/** @license Material-UI v3.9.3
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react-dom'), require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react-dom', 'react'], factory) :
  (factory((global['material-ui'] = {}),global.ReactDOM,global.React));
}(this, (function (exports,ReactDOM,React) { 'use strict';

  ReactDOM = ReactDOM && ReactDOM.hasOwnProperty('default') ? ReactDOM['default'] : ReactDOM;
  React = React && React.hasOwnProperty('default') ? React['default'] : React;

  var common = {
    black: '#000',
    white: '#fff'
  };

  var red = {
    50: '#ffebee',
    100: '#ffcdd2',
    200: '#ef9a9a',
    300: '#e57373',
    400: '#ef5350',
    500: '#f44336',
    600: '#e53935',
    700: '#d32f2f',
    800: '#c62828',
    900: '#b71c1c',
    A100: '#ff8a80',
    A200: '#ff5252',
    A400: '#ff1744',
    A700: '#d50000'
  };

  var pink = {
    50: '#fce4ec',
    100: '#f8bbd0',
    200: '#f48fb1',
    300: '#f06292',
    400: '#ec407a',
    500: '#e91e63',
    600: '#d81b60',
    700: '#c2185b',
    800: '#ad1457',
    900: '#880e4f',
    A100: '#ff80ab',
    A200: '#ff4081',
    A400: '#f50057',
    A700: '#c51162'
  };

  var purple = {
    50: '#f3e5f5',
    100: '#e1bee7',
    200: '#ce93d8',
    300: '#ba68c8',
    400: '#ab47bc',
    500: '#9c27b0',
    600: '#8e24aa',
    700: '#7b1fa2',
    800: '#6a1b9a',
    900: '#4a148c',
    A100: '#ea80fc',
    A200: '#e040fb',
    A400: '#d500f9',
    A700: '#aa00ff'
  };

  var deepPurple = {
    50: '#ede7f6',
    100: '#d1c4e9',
    200: '#b39ddb',
    300: '#9575cd',
    400: '#7e57c2',
    500: '#673ab7',
    600: '#5e35b1',
    700: '#512da8',
    800: '#4527a0',
    900: '#311b92',
    A100: '#b388ff',
    A200: '#7c4dff',
    A400: '#651fff',
    A700: '#6200ea'
  };

  var indigo = {
    50: '#e8eaf6',
    100: '#c5cae9',
    200: '#9fa8da',
    300: '#7986cb',
    400: '#5c6bc0',
    500: '#3f51b5',
    600: '#3949ab',
    700: '#303f9f',
    800: '#283593',
    900: '#1a237e',
    A100: '#8c9eff',
    A200: '#536dfe',
    A400: '#3d5afe',
    A700: '#304ffe'
  };

  var blue = {
    50: '#e3f2fd',
    100: '#bbdefb',
    200: '#90caf9',
    300: '#64b5f6',
    400: '#42a5f5',
    500: '#2196f3',
    600: '#1e88e5',
    700: '#1976d2',
    800: '#1565c0',
    900: '#0d47a1',
    A100: '#82b1ff',
    A200: '#448aff',
    A400: '#2979ff',
    A700: '#2962ff'
  };

  var lightBlue = {
    50: '#e1f5fe',
    100: '#b3e5fc',
    200: '#81d4fa',
    300: '#4fc3f7',
    400: '#29b6f6',
    500: '#03a9f4',
    600: '#039be5',
    700: '#0288d1',
    800: '#0277bd',
    900: '#01579b',
    A100: '#80d8ff',
    A200: '#40c4ff',
    A400: '#00b0ff',
    A700: '#0091ea'
  };

  var cyan = {
    50: '#e0f7fa',
    100: '#b2ebf2',
    200: '#80deea',
    300: '#4dd0e1',
    400: '#26c6da',
    500: '#00bcd4',
    600: '#00acc1',
    700: '#0097a7',
    800: '#00838f',
    900: '#006064',
    A100: '#84ffff',
    A200: '#18ffff',
    A400: '#00e5ff',
    A700: '#00b8d4'
  };

  var teal = {
    50: '#e0f2f1',
    100: '#b2dfdb',
    200: '#80cbc4',
    300: '#4db6ac',
    400: '#26a69a',
    500: '#009688',
    600: '#00897b',
    700: '#00796b',
    800: '#00695c',
    900: '#004d40',
    A100: '#a7ffeb',
    A200: '#64ffda',
    A400: '#1de9b6',
    A700: '#00bfa5'
  };

  var green = {
    50: '#e8f5e9',
    100: '#c8e6c9',
    200: '#a5d6a7',
    300: '#81c784',
    400: '#66bb6a',
    500: '#4caf50',
    600: '#43a047',
    700: '#388e3c',
    800: '#2e7d32',
    900: '#1b5e20',
    A100: '#b9f6ca',
    A200: '#69f0ae',
    A400: '#00e676',
    A700: '#00c853'
  };

  var lightGreen = {
    50: '#f1f8e9',
    100: '#dcedc8',
    200: '#c5e1a5',
    300: '#aed581',
    400: '#9ccc65',
    500: '#8bc34a',
    600: '#7cb342',
    700: '#689f38',
    800: '#558b2f',
    900: '#33691e',
    A100: '#ccff90',
    A200: '#b2ff59',
    A400: '#76ff03',
    A700: '#64dd17'
  };

  var lime = {
    50: '#f9fbe7',
    100: '#f0f4c3',
    200: '#e6ee9c',
    300: '#dce775',
    400: '#d4e157',
    500: '#cddc39',
    600: '#c0ca33',
    700: '#afb42b',
    800: '#9e9d24',
    900: '#827717',
    A100: '#f4ff81',
    A200: '#eeff41',
    A400: '#c6ff00',
    A700: '#aeea00'
  };

  var yellow = {
    50: '#fffde7',
    100: '#fff9c4',
    200: '#fff59d',
    300: '#fff176',
    400: '#ffee58',
    500: '#ffeb3b',
    600: '#fdd835',
    700: '#fbc02d',
    800: '#f9a825',
    900: '#f57f17',
    A100: '#ffff8d',
    A200: '#ffff00',
    A400: '#ffea00',
    A700: '#ffd600'
  };

  var amber = {
    50: '#fff8e1',
    100: '#ffecb3',
    200: '#ffe082',
    300: '#ffd54f',
    400: '#ffca28',
    500: '#ffc107',
    600: '#ffb300',
    700: '#ffa000',
    800: '#ff8f00',
    900: '#ff6f00',
    A100: '#ffe57f',
    A200: '#ffd740',
    A400: '#ffc400',
    A700: '#ffab00'
  };

  var orange = {
    50: '#fff3e0',
    100: '#ffe0b2',
    200: '#ffcc80',
    300: '#ffb74d',
    400: '#ffa726',
    500: '#ff9800',
    600: '#fb8c00',
    700: '#f57c00',
    800: '#ef6c00',
    900: '#e65100',
    A100: '#ffd180',
    A200: '#ffab40',
    A400: '#ff9100',
    A700: '#ff6d00'
  };

  var deepOrange = {
    50: '#fbe9e7',
    100: '#ffccbc',
    200: '#ffab91',
    300: '#ff8a65',
    400: '#ff7043',
    500: '#ff5722',
    600: '#f4511e',
    700: '#e64a19',
    800: '#d84315',
    900: '#bf360c',
    A100: '#ff9e80',
    A200: '#ff6e40',
    A400: '#ff3d00',
    A700: '#dd2c00'
  };

  var brown = {
    50: '#efebe9',
    100: '#d7ccc8',
    200: '#bcaaa4',
    300: '#a1887f',
    400: '#8d6e63',
    500: '#795548',
    600: '#6d4c41',
    700: '#5d4037',
    800: '#4e342e',
    900: '#3e2723',
    A100: '#d7ccc8',
    A200: '#bcaaa4',
    A400: '#8d6e63',
    A700: '#5d4037'
  };

  var grey = {
    50: '#fafafa',
    100: '#f5f5f5',
    200: '#eeeeee',
    300: '#e0e0e0',
    400: '#bdbdbd',
    500: '#9e9e9e',
    600: '#757575',
    700: '#616161',
    800: '#424242',
    900: '#212121',
    A100: '#d5d5d5',
    A200: '#aaaaaa',
    A400: '#303030',
    A700: '#616161'
  };

  var blueGrey = {
    50: '#eceff1',
    100: '#cfd8dc',
    200: '#b0bec5',
    300: '#90a4ae',
    400: '#78909c',
    500: '#607d8b',
    600: '#546e7a',
    700: '#455a64',
    800: '#37474f',
    900: '#263238',
    A100: '#cfd8dc',
    A200: '#b0bec5',
    A400: '#78909c',
    A700: '#455a64'
  };



  var index = /*#__PURE__*/Object.freeze({
    common: common,
    red: red,
    pink: pink,
    purple: purple,
    deepPurple: deepPurple,
    indigo: indigo,
    blue: blue,
    lightBlue: lightBlue,
    cyan: cyan,
    teal: teal,
    green: green,
    lightGreen: lightGreen,
    lime: lime,
    yellow: yellow,
    amber: amber,
    orange: orange,
    deepOrange: deepOrange,
    brown: brown,
    grey: grey,
    blueGrey: blueGrey
  });

  var global$1 = (typeof global !== "undefined" ? global :
              typeof self !== "undefined" ? self :
              typeof window !== "undefined" ? window : {});

  if (typeof global$1.setTimeout === 'function') ;
  if (typeof global$1.clearTimeout === 'function') ;

  // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
  var performance$1 = global$1.performance || {};
  var performanceNow =
    performance$1.now        ||
    performance$1.mozNow     ||
    performance$1.msNow      ||
    performance$1.oNow       ||
    performance$1.webkitNow  ||
    function(){ return (new Date()).getTime() };

  var warning = function() {};

  {
    var printWarning = function printWarning(format, args) {
      var len = arguments.length;
      args = new Array(len > 2 ? len - 2 : 0);
      for (var key = 2; key < len; key++) {
        args[key - 2] = arguments[key];
      }
      var argIndex = 0;
      var message = 'Warning: ' +
        format.replace(/%s/g, function() {
          return args[argIndex++];
        });
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };

    warning = function(condition, format, args) {
      var len = arguments.length;
      args = new Array(len > 2 ? len - 2 : 0);
      for (var key = 2; key < len; key++) {
        args[key - 2] = arguments[key];
      }
      if (format === undefined) {
        throw new Error(
            '`warning(condition, format, ...args)` requires a warning ' +
            'message argument'
        );
      }
      if (!condition) {
        printWarning.apply(null, [format].concat(args));
      }
    };
  }

  var warning_1 = warning;

  var escapeRegex = /([[\].#*$><+~=|^:(),"'`\s])/g;

  function safePrefix(classNamePrefix) {
    var prefix = String(classNamePrefix);
    warning_1(prefix.length < 256, "Material-UI: the class name prefix is too long: ".concat(prefix, ".")); // Sanitize the string as will be used to prefix the generated class name.

    return prefix.replace(escapeRegex, '-');
  } // Returns a function which generates unique class names based on counters.
  // When new generator function is created, rule counter is reset.
  // We need to reset the rule counter for SSR for each request.
  //
  // It's inspired by
  // https://github.com/cssinjs/jss/blob/4e6a05dd3f7b6572fdd3ab216861d9e446c20331/src/utils/createGenerateClassName.js


  function createGenerateClassName() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _options$dangerouslyU = options.dangerouslyUseGlobalCSS,
        dangerouslyUseGlobalCSS = _options$dangerouslyU === void 0 ? false : _options$dangerouslyU,
        _options$productionPr = options.productionPrefix,
        _options$seed = options.seed,
        seed = _options$seed === void 0 ? '' : _options$seed;
    var ruleCounter = 0;
    return function (rule, styleSheet) {
      ruleCounter += 1;
      warning_1(ruleCounter < 1e10, ['Material-UI: you might have a memory leak.', 'The ruleCounter is not supposed to grow that much.'].join(''));

      if (dangerouslyUseGlobalCSS && styleSheet && styleSheet.options.name) {
        return "".concat(safePrefix(styleSheet.options.name), "-").concat(rule.key);
      }


      if (styleSheet && styleSheet.options.classNamePrefix) {
        return "".concat(safePrefix(styleSheet.options.classNamePrefix), "-").concat(rule.key, "-").concat(seed).concat(ruleCounter);
      }

      return "".concat(rule.key, "-").concat(seed).concat(ruleCounter);
    };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var defineProperty = _defineProperty;

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x.default : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var _extends_1 = createCommonjsModule(function (module) {
  function _extends() {
    module.exports = _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  module.exports = _extends;
  });

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var objectWithoutPropertiesLoose = _objectWithoutPropertiesLoose;

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};
    var target = objectWithoutPropertiesLoose(source, excluded);
    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  var objectWithoutProperties = _objectWithoutProperties;

  var umd = createCommonjsModule(function (module, exports) {
  (function (global, factory) {
  	module.exports = factory();
  }(this, (function () {
  var isMergeableObject = function isMergeableObject(value) {
  	return isNonNullObject(value)
  		&& !isSpecial(value)
  };

  function isNonNullObject(value) {
  	return !!value && typeof value === 'object'
  }

  function isSpecial(value) {
  	var stringValue = Object.prototype.toString.call(value);

  	return stringValue === '[object RegExp]'
  		|| stringValue === '[object Date]'
  		|| isReactElement(value)
  }

  // see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
  var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
  var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

  function isReactElement(value) {
  	return value.$$typeof === REACT_ELEMENT_TYPE
  }

  function emptyTarget(val) {
  	return Array.isArray(val) ? [] : {}
  }

  function cloneUnlessOtherwiseSpecified(value, options) {
  	return (options.clone !== false && options.isMergeableObject(value))
  		? deepmerge(emptyTarget(value), value, options)
  		: value
  }

  function defaultArrayMerge(target, source, options) {
  	return target.concat(source).map(function(element) {
  		return cloneUnlessOtherwiseSpecified(element, options)
  	})
  }

  function mergeObject(target, source, options) {
  	var destination = {};
  	if (options.isMergeableObject(target)) {
  		Object.keys(target).forEach(function(key) {
  			destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
  		});
  	}
  	Object.keys(source).forEach(function(key) {
  		if (!options.isMergeableObject(source[key]) || !target[key]) {
  			destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
  		} else {
  			destination[key] = deepmerge(target[key], source[key], options);
  		}
  	});
  	return destination
  }

  function deepmerge(target, source, options) {
  	options = options || {};
  	options.arrayMerge = options.arrayMerge || defaultArrayMerge;
  	options.isMergeableObject = options.isMergeableObject || isMergeableObject;

  	var sourceIsArray = Array.isArray(source);
  	var targetIsArray = Array.isArray(target);
  	var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;

  	if (!sourceAndTargetTypesMatch) {
  		return cloneUnlessOtherwiseSpecified(source, options)
  	} else if (sourceIsArray) {
  		return options.arrayMerge(target, source, options)
  	} else {
  		return mergeObject(target, source, options)
  	}
  }

  deepmerge.all = function deepmergeAll(array, options) {
  	if (!Array.isArray(array)) {
  		throw new Error('first argument should be an array')
  	}

  	return array.reduce(function(prev, next) {
  		return deepmerge(prev, next, options)
  	}, {})
  };

  var deepmerge_1 = deepmerge;

  return deepmerge_1;

  })));
  });

  /*!
   * isobject <https://github.com/jonschlinkert/isobject>
   *
   * Copyright (c) 2014-2017, Jon Schlinkert.
   * Released under the MIT License.
   */

  var isobject = function isObject(val) {
    return val != null && typeof val === 'object' && Array.isArray(val) === false;
  };

  function isObjectObject(o) {
    return isobject(o) === true
      && Object.prototype.toString.call(o) === '[object Object]';
  }

  var isPlainObject = function isPlainObject(o) {
    var ctor,prot;

    if (isObjectObject(o) === false) return false;

    // If has modified constructor
    ctor = o.constructor;
    if (typeof ctor !== 'function') return false;

    // If has modified prototype
    prot = ctor.prototype;
    if (isObjectObject(prot) === false) return false;

    // If constructor does not have an Object-specific method
    if (prot.hasOwnProperty('isPrototypeOf') === false) {
      return false;
    }

    // Most likely a plain Object
    return true;
  };

  // Sorted ASC by size. That's important.
  // It can't be configured as it's used statically for propTypes.
  var keys = ['xs', 'sm', 'md', 'lg', 'xl']; // Keep in mind that @media is inclusive by the CSS specification.

  function createBreakpoints(breakpoints) {
    var _breakpoints$values = breakpoints.values,
        values = _breakpoints$values === void 0 ? {
      xs: 0,
      sm: 600,
      md: 960,
      lg: 1280,
      xl: 1920
    } : _breakpoints$values,
        _breakpoints$unit = breakpoints.unit,
        unit = _breakpoints$unit === void 0 ? 'px' : _breakpoints$unit,
        _breakpoints$step = breakpoints.step,
        step = _breakpoints$step === void 0 ? 5 : _breakpoints$step,
        other = objectWithoutProperties(breakpoints, ["values", "unit", "step"]);

    function up(key) {
      var value = typeof values[key] === 'number' ? values[key] : key;
      return "@media (min-width:".concat(value).concat(unit, ")");
    }

    function down(key) {
      var endIndex = keys.indexOf(key) + 1;
      var upperbound = values[keys[endIndex]];

      if (endIndex === keys.length) {
        // xl down applies to all sizes
        return up('xs');
      }

      var value = typeof upperbound === 'number' && endIndex > 0 ? upperbound : key;
      return "@media (max-width:".concat(value - step / 100).concat(unit, ")");
    }

    function between(start, end) {
      var endIndex = keys.indexOf(end) + 1;

      if (endIndex === keys.length) {
        return up(start);
      }

      return "@media (min-width:".concat(values[start]).concat(unit, ") and ") + "(max-width:".concat(values[keys[endIndex]] - step / 100).concat(unit, ")");
    }

    function only(key) {
      return between(key, key);
    }

    function width(key) {
      return values[key];
    }

    return _extends_1({
      keys: keys,
      values: values,
      up: up,
      down: down,
      between: between,
      only: only,
      width: width
    }, other);
  }

  function createMixins(breakpoints, spacing, mixins) {
    var _toolbar;

    return _extends_1({
      gutters: function gutters() {
        var styles = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return _extends_1({
          paddingLeft: spacing.unit * 2,
          paddingRight: spacing.unit * 2
        }, styles, defineProperty({}, breakpoints.up('sm'), _extends_1({
          paddingLeft: spacing.unit * 3,
          paddingRight: spacing.unit * 3
        }, styles[breakpoints.up('sm')])));
      },
      toolbar: (_toolbar = {
        minHeight: 56
      }, defineProperty(_toolbar, "".concat(breakpoints.up('xs'), " and (orientation: landscape)"), {
        minHeight: 48
      }), defineProperty(_toolbar, breakpoints.up('sm'), {
        minHeight: 64
      }), _toolbar)
    }, mixins);
  }

  /**
   * Returns a number whose value is limited to the given range.
   *
   * @param {number} value The value to be clamped
   * @param {number} min The lower boundary of the output range
   * @param {number} max The upper boundary of the output range
   * @returns {number} A number in the range [min, max]
   */

  function clamp(value) {
    var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
    warning_1(value >= min && value <= max, "Material-UI: the value provided ".concat(value, " is out of range [").concat(min, ", ").concat(max, "]."));

    if (value < min) {
      return min;
    }

    if (value > max) {
      return max;
    }

    return value;
  }
  /**
   * Converts a color from CSS hex format to CSS rgb format.
   *
   * @param {string} color - Hex color, i.e. #nnn or #nnnnnn
   * @returns {string} A CSS rgb color string
   */


  function convertHexToRGB(color) {
    color = color.substr(1);
    var re = new RegExp(".{1,".concat(color.length / 3, "}"), 'g');
    var colors = color.match(re);

    if (colors && colors[0].length === 1) {
      colors = colors.map(function (n) {
        return n + n;
      });
    }

    return colors ? "rgb(".concat(colors.map(function (n) {
      return parseInt(n, 16);
    }).join(', '), ")") : '';
  }
  /**
   * Returns an object with the type and values of a color.
   *
   * Note: Does not support rgb % values.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {object} - A MUI color object: {type: string, values: number[]}
   */

  function decomposeColor(color) {
    if (color.charAt(0) === '#') {
      return decomposeColor(convertHexToRGB(color));
    }

    var marker = color.indexOf('(');
    var type = color.substring(0, marker);
    var values = color.substring(marker + 1, color.length - 1).split(',');
    values = values.map(function (value) {
      return parseFloat(value);
    });

    {
      if (['rgb', 'rgba', 'hsl', 'hsla'].indexOf(type) === -1) {
        throw new Error(["Material-UI: unsupported `".concat(color, "` color."), 'We support the following formats: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla().'].join('\n'));
      }
    }

    return {
      type: type,
      values: values
    };
  }
  /**
   * Converts a color object with type and values to a string.
   *
   * @param {object} color - Decomposed color
   * @param {string} color.type - One of: 'rgb', 'rgba', 'hsl', 'hsla'
   * @param {array} color.values - [n,n,n] or [n,n,n,n]
   * @returns {string} A CSS color string
   */

  function recomposeColor(color) {
    var type = color.type;
    var values = color.values;

    if (type.indexOf('rgb') !== -1) {
      // Only convert the first 3 values to int (i.e. not alpha)
      values = values.map(function (n, i) {
        return i < 3 ? parseInt(n, 10) : n;
      });
    }

    if (type.indexOf('hsl') !== -1) {
      values[1] = "".concat(values[1], "%");
      values[2] = "".concat(values[2], "%");
    }

    return "".concat(color.type, "(").concat(values.join(', '), ")");
  }
  /**
   * Calculates the contrast ratio between two colors.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   *
   * @param {string} foreground - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {string} background - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {number} A contrast ratio value in the range 0 - 21.
   */

  function getContrastRatio(foreground, background) {
    var lumA = getLuminance(foreground);
    var lumB = getLuminance(background);
    return (Math.max(lumA, lumB) + 0.05) / (Math.min(lumA, lumB) + 0.05);
  }
  /**
   * The relative brightness of any point in a color space,
   * normalized to 0 for darkest black and 1 for lightest white.
   *
   * Formula: https://www.w3.org/TR/WCAG20-TECHS/G17.html#G17-tests
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @returns {number} The relative brightness of the color in the range 0 - 1
   */

  function getLuminance(color) {
    var decomposedColor = decomposeColor(color);

    if (decomposedColor.type.indexOf('rgb') !== -1) {
      var rgb = decomposedColor.values.map(function (val) {
        val /= 255; // normalized

        return val <= 0.03928 ? val / 12.92 : Math.pow((val + 0.055) / 1.055, 2.4);
      }); // Truncate at 3 digits

      return Number((0.2126 * rgb[0] + 0.7152 * rgb[1] + 0.0722 * rgb[2]).toFixed(3));
    } // else if (decomposedColor.type.indexOf('hsl') !== -1)


    return decomposedColor.values[2] / 100;
  }
  /**
   * Darken or lighten a colour, depending on its luminance.
   * Light colors are darkened, dark colors are lightened.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} coefficient=0.15 - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function emphasize(color) {
    var coefficient = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.15;
    return getLuminance(color) > 0.5 ? darken(color, coefficient) : lighten(color, coefficient);
  }
  /**
   * Set the absolute transparency of a color.
   * Any existing alpha values are overwritten.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} value - value to set the alpha channel to in the range 0 -1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function fade(color, value) {
    warning_1(color, "Material-UI: missing color argument in fade(".concat(color, ", ").concat(value, ")."));
    if (!color) return color;
    color = decomposeColor(color);
    value = clamp(value);

    if (color.type === 'rgb' || color.type === 'hsl') {
      color.type += 'a';
    }

    color.values[3] = value;
    return recomposeColor(color);
  }
  /**
   * Darkens a color.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function darken(color, coefficient) {
    warning_1(color, "Material-UI: missing color argument in darken(".concat(color, ", ").concat(coefficient, ")."));
    if (!color) return color;
    color = decomposeColor(color);
    coefficient = clamp(coefficient);

    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] *= 1 - coefficient;
    } else if (color.type.indexOf('rgb') !== -1) {
      for (var i = 0; i < 3; i += 1) {
        color.values[i] *= 1 - coefficient;
      }
    }

    return recomposeColor(color);
  }
  /**
   * Lightens a color.
   *
   * @param {string} color - CSS color, i.e. one of: #nnn, #nnnnnn, rgb(), rgba(), hsl(), hsla()
   * @param {number} coefficient - multiplier in the range 0 - 1
   * @returns {string} A CSS color string. Hex input values are returned as rgb
   */

  function lighten(color, coefficient) {
    warning_1(color, "Material-UI: missing color argument in lighten(".concat(color, ", ").concat(coefficient, ")."));
    if (!color) return color;
    color = decomposeColor(color);
    coefficient = clamp(coefficient);

    if (color.type.indexOf('hsl') !== -1) {
      color.values[2] += (100 - color.values[2]) * coefficient;
    } else if (color.type.indexOf('rgb') !== -1) {
      for (var i = 0; i < 3; i += 1) {
        color.values[i] += (255 - color.values[i]) * coefficient;
      }
    }

    return recomposeColor(color);
  }

  var light = {
    // The colors used to style the text.
    text: {
      // The most important text.
      primary: 'rgba(0, 0, 0, 0.87)',
      // Secondary text.
      secondary: 'rgba(0, 0, 0, 0.54)',
      // Disabled text have even lower visual prominence.
      disabled: 'rgba(0, 0, 0, 0.38)',
      // Text hints.
      hint: 'rgba(0, 0, 0, 0.38)'
    },
    // The color used to divide different elements.
    divider: 'rgba(0, 0, 0, 0.12)',
    // The background colors used to style the surfaces.
    // Consistency between these values is important.
    background: {
      paper: common.white,
      default: grey[50]
    },
    // The colors used to style the action elements.
    action: {
      // The color of an active action like an icon button.
      active: 'rgba(0, 0, 0, 0.54)',
      // The color of an hovered action.
      hover: 'rgba(0, 0, 0, 0.08)',
      hoverOpacity: 0.08,
      // The color of a selected action.
      selected: 'rgba(0, 0, 0, 0.14)',
      // The color of a disabled action.
      disabled: 'rgba(0, 0, 0, 0.26)',
      // The background color of a disabled action.
      disabledBackground: 'rgba(0, 0, 0, 0.12)'
    }
  };
  var dark = {
    text: {
      primary: common.white,
      secondary: 'rgba(255, 255, 255, 0.7)',
      disabled: 'rgba(255, 255, 255, 0.5)',
      hint: 'rgba(255, 255, 255, 0.5)',
      icon: 'rgba(255, 255, 255, 0.5)'
    },
    divider: 'rgba(255, 255, 255, 0.12)',
    background: {
      paper: grey[800],
      default: '#303030'
    },
    action: {
      active: common.white,
      hover: 'rgba(255, 255, 255, 0.1)',
      hoverOpacity: 0.1,
      selected: 'rgba(255, 255, 255, 0.2)',
      disabled: 'rgba(255, 255, 255, 0.3)',
      disabledBackground: 'rgba(255, 255, 255, 0.12)'
    }
  };

  function addLightOrDark(intent, direction, shade, tonalOffset) {
    if (!intent[direction]) {
      if (intent.hasOwnProperty(shade)) {
        intent[direction] = intent[shade];
      } else if (direction === 'light') {
        intent.light = lighten(intent.main, tonalOffset);
      } else if (direction === 'dark') {
        intent.dark = darken(intent.main, tonalOffset * 1.5);
      }
    }
  }

  function createPalette(palette) {
    var _palette$primary = palette.primary,
        primary = _palette$primary === void 0 ? {
      light: indigo[300],
      main: indigo[500],
      dark: indigo[700]
    } : _palette$primary,
        _palette$secondary = palette.secondary,
        secondary = _palette$secondary === void 0 ? {
      light: pink.A200,
      main: pink.A400,
      dark: pink.A700
    } : _palette$secondary,
        _palette$error = palette.error,
        error = _palette$error === void 0 ? {
      light: red[300],
      main: red[500],
      dark: red[700]
    } : _palette$error,
        _palette$type = palette.type,
        type = _palette$type === void 0 ? 'light' : _palette$type,
        _palette$contrastThre = palette.contrastThreshold,
        contrastThreshold = _palette$contrastThre === void 0 ? 3 : _palette$contrastThre,
        _palette$tonalOffset = palette.tonalOffset,
        tonalOffset = _palette$tonalOffset === void 0 ? 0.2 : _palette$tonalOffset,
        other = objectWithoutProperties(palette, ["primary", "secondary", "error", "type", "contrastThreshold", "tonalOffset"]);

    function getContrastText(background) {
      // Use the same logic as
      // Bootstrap: https://github.com/twbs/bootstrap/blob/1d6e3710dd447de1a200f29e8fa521f8a0908f70/scss/_functions.scss#L59
      // and material-components-web https://github.com/material-components/material-components-web/blob/ac46b8863c4dab9fc22c4c662dc6bd1b65dd652f/packages/mdc-theme/_functions.scss#L54
      var contrastText = getContrastRatio(background, dark.text.primary) >= contrastThreshold ? dark.text.primary : light.text.primary;

      {
        var contrast = getContrastRatio(background, contrastText);
        warning_1(contrast >= 3, ["Material-UI: the contrast ratio of ".concat(contrast, ":1 for ").concat(contrastText, " on ").concat(background), 'falls below the WACG recommended absolute minimum contrast ratio of 3:1.', 'https://www.w3.org/TR/2008/REC-WCAG20-20081211/#visual-audio-contrast-contrast'].join('\n'));
      }

      return contrastText;
    }

    function augmentColor(color) {
      var mainShade = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 500;
      var lightShade = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 300;
      var darkShade = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 700;

      if (!color.main && color[mainShade]) {
        color.main = color[mainShade];
      }

      if (!color.main) {
        throw new Error(['Material-UI: the color provided to augmentColor(color) is invalid.', "The color object needs to have a `main` property or a `".concat(mainShade, "` property.")].join('\n'));
      }

      addLightOrDark(color, 'light', lightShade, tonalOffset);
      addLightOrDark(color, 'dark', darkShade, tonalOffset);

      if (!color.contrastText) {
        color.contrastText = getContrastText(color.main);
      }

      return color;
    }

    augmentColor(primary);
    augmentColor(secondary, 'A400', 'A200', 'A700');
    augmentColor(error);
    var types = {
      dark: dark,
      light: light
    };
    warning_1(types[type], "Material-UI: the palette type `".concat(type, "` is not supported."));
    var paletteOutput = umd(_extends_1({
      // A collection of common colors.
      common: common,
      // The palette type, can be light or dark.
      type: type,
      // The colors used to represent primary interface elements for a user.
      primary: primary,
      // The colors used to represent secondary interface elements for a user.
      secondary: secondary,
      // The colors used to represent interface elements that the user should be made aware of.
      error: error,
      // The grey colors.
      grey: grey,
      // Used by `getContrastText()` to maximize the contrast between the background and
      // the text.
      contrastThreshold: contrastThreshold,
      // Take a background color and return the color of the text to maximize the contrast.
      getContrastText: getContrastText,
      // Generate a rich color object.
      augmentColor: augmentColor,
      // Used by the functions below to shift a color's luminance by approximately
      // two indexes within its tonal palette.
      // E.g., shift from Red 500 to Red 300 or Red 700.
      tonalOffset: tonalOffset
    }, types[type]), other, {
      clone: false // No need to clone deep

    });
    return paletteOutput;
  }

  var _typeof_1 = createCommonjsModule(function (module) {
  function _typeof2(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof2 = function _typeof2(obj) { return typeof obj; }; } else { _typeof2 = function _typeof2(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof2(obj); }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      module.exports = _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      module.exports = _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  module.exports = _typeof;
  });

  var reactIs_production_min = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports,"__esModule",{value:!0});
  var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?Symbol.for("react.memo"):
  60115,r=b?Symbol.for("react.lazy"):60116;function t(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case h:return a;default:return u}}case r:case q:case d:return u}}}function v(a){return t(a)===m}exports.typeOf=t;exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;
  exports.Fragment=e;exports.Lazy=r;exports.Memo=q;exports.Portal=d;exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;exports.isValidElementType=function(a){return "string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||"object"===typeof a&&null!==a&&(a.$$typeof===r||a.$$typeof===q||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n)};exports.isAsyncMode=function(a){return v(a)||t(a)===l};exports.isConcurrentMode=v;exports.isContextConsumer=function(a){return t(a)===k};
  exports.isContextProvider=function(a){return t(a)===h};exports.isElement=function(a){return "object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return t(a)===n};exports.isFragment=function(a){return t(a)===e};exports.isLazy=function(a){return t(a)===r};exports.isMemo=function(a){return t(a)===q};exports.isPortal=function(a){return t(a)===d};exports.isProfiler=function(a){return t(a)===g};exports.isStrictMode=function(a){return t(a)===f};
  exports.isSuspense=function(a){return t(a)===p};
  });

  unwrapExports(reactIs_production_min);
  var reactIs_production_min_1 = reactIs_production_min.typeOf;
  var reactIs_production_min_2 = reactIs_production_min.AsyncMode;
  var reactIs_production_min_3 = reactIs_production_min.ConcurrentMode;
  var reactIs_production_min_4 = reactIs_production_min.ContextConsumer;
  var reactIs_production_min_5 = reactIs_production_min.ContextProvider;
  var reactIs_production_min_6 = reactIs_production_min.Element;
  var reactIs_production_min_7 = reactIs_production_min.ForwardRef;
  var reactIs_production_min_8 = reactIs_production_min.Fragment;
  var reactIs_production_min_9 = reactIs_production_min.Lazy;
  var reactIs_production_min_10 = reactIs_production_min.Memo;
  var reactIs_production_min_11 = reactIs_production_min.Portal;
  var reactIs_production_min_12 = reactIs_production_min.Profiler;
  var reactIs_production_min_13 = reactIs_production_min.StrictMode;
  var reactIs_production_min_14 = reactIs_production_min.Suspense;
  var reactIs_production_min_15 = reactIs_production_min.isValidElementType;
  var reactIs_production_min_16 = reactIs_production_min.isAsyncMode;
  var reactIs_production_min_17 = reactIs_production_min.isConcurrentMode;
  var reactIs_production_min_18 = reactIs_production_min.isContextConsumer;
  var reactIs_production_min_19 = reactIs_production_min.isContextProvider;
  var reactIs_production_min_20 = reactIs_production_min.isElement;
  var reactIs_production_min_21 = reactIs_production_min.isForwardRef;
  var reactIs_production_min_22 = reactIs_production_min.isFragment;
  var reactIs_production_min_23 = reactIs_production_min.isLazy;
  var reactIs_production_min_24 = reactIs_production_min.isMemo;
  var reactIs_production_min_25 = reactIs_production_min.isPortal;
  var reactIs_production_min_26 = reactIs_production_min.isProfiler;
  var reactIs_production_min_27 = reactIs_production_min.isStrictMode;
  var reactIs_production_min_28 = reactIs_production_min.isSuspense;

  var reactIs_development = createCommonjsModule(function (module, exports) {



  {
    (function() {

  Object.defineProperty(exports, '__esModule', { value: true });

  // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
  // nor polyfill, then a plain number is used for performance.
  var hasSymbol = typeof Symbol === 'function' && Symbol.for;

  var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
  var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
  var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
  var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
  var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
  var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
  var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace;
  var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
  var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
  var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
  var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
  var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
  var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;

  function isValidElementType(type) {
    return typeof type === 'string' || typeof type === 'function' ||
    // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
    type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE);
  }

  /**
   * Forked from fbjs/warning:
   * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
   *
   * Only change is we use console.warn instead of console.error,
   * and do nothing when 'console' is not supported.
   * This really simplifies the code.
   * ---
   * Similar to invariant but only logs a warning if the condition is not met.
   * This can be used to log issues in development environments in critical
   * paths. Removing the logging code for production environments will keep the
   * same logic and follow the same code paths.
   */

  var lowPriorityWarning = function () {};

  {
    var printWarning = function (format) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var argIndex = 0;
      var message = 'Warning: ' + format.replace(/%s/g, function () {
        return args[argIndex++];
      });
      if (typeof console !== 'undefined') {
        console.warn(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };

    lowPriorityWarning = function (condition, format) {
      if (format === undefined) {
        throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');
      }
      if (!condition) {
        for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
          args[_key2 - 2] = arguments[_key2];
        }

        printWarning.apply(undefined, [format].concat(args));
      }
    };
  }

  var lowPriorityWarning$1 = lowPriorityWarning;

  function typeOf(object) {
    if (typeof object === 'object' && object !== null) {
      var $$typeof = object.$$typeof;
      switch ($$typeof) {
        case REACT_ELEMENT_TYPE:
          var type = object.type;

          switch (type) {
            case REACT_ASYNC_MODE_TYPE:
            case REACT_CONCURRENT_MODE_TYPE:
            case REACT_FRAGMENT_TYPE:
            case REACT_PROFILER_TYPE:
            case REACT_STRICT_MODE_TYPE:
            case REACT_SUSPENSE_TYPE:
              return type;
            default:
              var $$typeofType = type && type.$$typeof;

              switch ($$typeofType) {
                case REACT_CONTEXT_TYPE:
                case REACT_FORWARD_REF_TYPE:
                case REACT_PROVIDER_TYPE:
                  return $$typeofType;
                default:
                  return $$typeof;
              }
          }
        case REACT_LAZY_TYPE:
        case REACT_MEMO_TYPE:
        case REACT_PORTAL_TYPE:
          return $$typeof;
      }
    }

    return undefined;
  }

  // AsyncMode is deprecated along with isAsyncMode
  var AsyncMode = REACT_ASYNC_MODE_TYPE;
  var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
  var ContextConsumer = REACT_CONTEXT_TYPE;
  var ContextProvider = REACT_PROVIDER_TYPE;
  var Element = REACT_ELEMENT_TYPE;
  var ForwardRef = REACT_FORWARD_REF_TYPE;
  var Fragment = REACT_FRAGMENT_TYPE;
  var Lazy = REACT_LAZY_TYPE;
  var Memo = REACT_MEMO_TYPE;
  var Portal = REACT_PORTAL_TYPE;
  var Profiler = REACT_PROFILER_TYPE;
  var StrictMode = REACT_STRICT_MODE_TYPE;
  var Suspense = REACT_SUSPENSE_TYPE;

  var hasWarnedAboutDeprecatedIsAsyncMode = false;

  // AsyncMode should be deprecated
  function isAsyncMode(object) {
    {
      if (!hasWarnedAboutDeprecatedIsAsyncMode) {
        hasWarnedAboutDeprecatedIsAsyncMode = true;
        lowPriorityWarning$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
      }
    }
    return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
  }
  function isConcurrentMode(object) {
    return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
  }
  function isContextConsumer(object) {
    return typeOf(object) === REACT_CONTEXT_TYPE;
  }
  function isContextProvider(object) {
    return typeOf(object) === REACT_PROVIDER_TYPE;
  }
  function isElement(object) {
    return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
  }
  function isForwardRef(object) {
    return typeOf(object) === REACT_FORWARD_REF_TYPE;
  }
  function isFragment(object) {
    return typeOf(object) === REACT_FRAGMENT_TYPE;
  }
  function isLazy(object) {
    return typeOf(object) === REACT_LAZY_TYPE;
  }
  function isMemo(object) {
    return typeOf(object) === REACT_MEMO_TYPE;
  }
  function isPortal(object) {
    return typeOf(object) === REACT_PORTAL_TYPE;
  }
  function isProfiler(object) {
    return typeOf(object) === REACT_PROFILER_TYPE;
  }
  function isStrictMode(object) {
    return typeOf(object) === REACT_STRICT_MODE_TYPE;
  }
  function isSuspense(object) {
    return typeOf(object) === REACT_SUSPENSE_TYPE;
  }

  exports.typeOf = typeOf;
  exports.AsyncMode = AsyncMode;
  exports.ConcurrentMode = ConcurrentMode;
  exports.ContextConsumer = ContextConsumer;
  exports.ContextProvider = ContextProvider;
  exports.Element = Element;
  exports.ForwardRef = ForwardRef;
  exports.Fragment = Fragment;
  exports.Lazy = Lazy;
  exports.Memo = Memo;
  exports.Portal = Portal;
  exports.Profiler = Profiler;
  exports.StrictMode = StrictMode;
  exports.Suspense = Suspense;
  exports.isValidElementType = isValidElementType;
  exports.isAsyncMode = isAsyncMode;
  exports.isConcurrentMode = isConcurrentMode;
  exports.isContextConsumer = isContextConsumer;
  exports.isContextProvider = isContextProvider;
  exports.isElement = isElement;
  exports.isForwardRef = isForwardRef;
  exports.isFragment = isFragment;
  exports.isLazy = isLazy;
  exports.isMemo = isMemo;
  exports.isPortal = isPortal;
  exports.isProfiler = isProfiler;
  exports.isStrictMode = isStrictMode;
  exports.isSuspense = isSuspense;
    })();
  }
  });

  unwrapExports(reactIs_development);
  var reactIs_development_1 = reactIs_development.typeOf;
  var reactIs_development_2 = reactIs_development.AsyncMode;
  var reactIs_development_3 = reactIs_development.ConcurrentMode;
  var reactIs_development_4 = reactIs_development.ContextConsumer;
  var reactIs_development_5 = reactIs_development.ContextProvider;
  var reactIs_development_6 = reactIs_development.Element;
  var reactIs_development_7 = reactIs_development.ForwardRef;
  var reactIs_development_8 = reactIs_development.Fragment;
  var reactIs_development_9 = reactIs_development.Lazy;
  var reactIs_development_10 = reactIs_development.Memo;
  var reactIs_development_11 = reactIs_development.Portal;
  var reactIs_development_12 = reactIs_development.Profiler;
  var reactIs_development_13 = reactIs_development.StrictMode;
  var reactIs_development_14 = reactIs_development.Suspense;
  var reactIs_development_15 = reactIs_development.isValidElementType;
  var reactIs_development_16 = reactIs_development.isAsyncMode;
  var reactIs_development_17 = reactIs_development.isConcurrentMode;
  var reactIs_development_18 = reactIs_development.isContextConsumer;
  var reactIs_development_19 = reactIs_development.isContextProvider;
  var reactIs_development_20 = reactIs_development.isElement;
  var reactIs_development_21 = reactIs_development.isForwardRef;
  var reactIs_development_22 = reactIs_development.isFragment;
  var reactIs_development_23 = reactIs_development.isLazy;
  var reactIs_development_24 = reactIs_development.isMemo;
  var reactIs_development_25 = reactIs_development.isPortal;
  var reactIs_development_26 = reactIs_development.isProfiler;
  var reactIs_development_27 = reactIs_development.isStrictMode;
  var reactIs_development_28 = reactIs_development.isSuspense;

  var reactIs = createCommonjsModule(function (module) {

  {
    module.exports = reactIs_development;
  }
  });
  var reactIs_1 = reactIs.isValidElementType;

  /**
   * A factory that returns a propTypes validator that only accepts values that
   * are also accepted by React.createElement
   * e.g. "div", functional, class components, forwardRef etc.
   *
   * @param {boolean} isRequired If `true` returns a validator
   *                             that will throw if nullish values are passed
   */

  function createComponentProp(isRequired) {

    return function componentPropType(props, key, componentName, location, propFullName) {
      var prop = props[key];
      var propName = propFullName || key;
      var message;

      if (prop == null) {
        if (isRequired) {
          message = "The ".concat(location, " `").concat(propName, "` is marked as required in `").concat(componentName, "`, ") + "but its value is `".concat(_typeof_1(prop), "`.");
        }
      } else if (!reactIs_1(prop)) {
        var preciseType = _typeof_1(prop);

        message = "Invalid ".concat(location, " `").concat(propName, "` of type `").concat(preciseType, "` ") + "supplied to `".concat(componentName, "`, expected a component.");
      }

      if (message != null) {
        // change error message slightly on every check to prevent caching when testing
        // which would not trigger console errors on subsequent fails
        return new Error("".concat(message).concat(''));
      }

      return null;
    };
  }

  var componentPropType = createComponentProp(false);
  componentPropType.isRequired = createComponentProp(true);

  function chainPropTypes(propType1, propType2) {

    return function validate() {
      return propType1.apply(void 0, arguments) || propType2.apply(void 0, arguments);
    };
  }

  // This module is based on https://github.com/airbnb/prop-types-exact repository.
  // However, in order to reduce the number of dependencies and to remove some extra safe checks
  // the module was forked.
  // Only exported for test purposes.
  var specialProperty = "exact-prop: \u200B";

  function exactProp(propTypes) {

    return _extends_1({}, propTypes, defineProperty({}, specialProperty, function (props) {
      var unsupportedProps = Object.keys(props).filter(function (prop) {
        return !propTypes.hasOwnProperty(prop);
      });

      if (unsupportedProps.length > 0) {
        return new Error("The following properties are not supported: ".concat(unsupportedProps.map(function (prop) {
          return "`".concat(prop, "`");
        }).join(', '), ". Please remove them."));
      }

      return null;
    }));
  }

  // Fork of recompose/getDisplayName with added IE 11 support
  // Simplified polyfill for IE 11 support
  // https://github.com/JamesMGreene/Function.name/blob/58b314d4a983110c3682f1228f845d39ccca1817/Function.name.js#L3
  var fnNameMatchRegex = /^\s*function(?:\s|\s*\/\*.*\*\/\s*)+([^(\s/]*)\s*/;
  function getFunctionName(fn) {
    var match = "".concat(fn).match(fnNameMatchRegex);
    var name = match && match[1];
    return name || '';
  }

  function getDisplayName(Component) {
    if (typeof Component === 'string') {
      return Component;
    }

    if (!Component) {
      return undefined;
    }

    return Component.displayName || Component.name || getFunctionName(Component) || 'Component';
  }

  /* eslint-disable */
  // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
  var ponyfillGlobal = typeof window != 'undefined' && window.Math == Math ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();

  function round(value) {
    return Math.round(value * 1e5) / 1e5;
  }

  var caseAllCaps = {
    textTransform: 'uppercase'
  };
  var defaultFontFamily = '"Roboto", "Helvetica", "Arial", sans-serif';
  /**
   * @see @link{https://material.io/design/typography/the-type-system.html}
   * @see @link{https://material.io/design/typography/understanding-typography.html}
   */

  function createTypography(palette, typography) {
    var _ref = typeof typography === 'function' ? typography(palette) : typography,
        _ref$fontFamily = _ref.fontFamily,
        fontFamily = _ref$fontFamily === void 0 ? defaultFontFamily : _ref$fontFamily,
        _ref$fontSize = _ref.fontSize,
        fontSize = _ref$fontSize === void 0 ? 14 : _ref$fontSize,
        _ref$fontWeightLight = _ref.fontWeightLight,
        fontWeightLight = _ref$fontWeightLight === void 0 ? 300 : _ref$fontWeightLight,
        _ref$fontWeightRegula = _ref.fontWeightRegular,
        fontWeightRegular = _ref$fontWeightRegula === void 0 ? 400 : _ref$fontWeightRegula,
        _ref$fontWeightMedium = _ref.fontWeightMedium,
        fontWeightMedium = _ref$fontWeightMedium === void 0 ? 500 : _ref$fontWeightMedium,
        _ref$htmlFontSize = _ref.htmlFontSize,
        htmlFontSize = _ref$htmlFontSize === void 0 ? 16 : _ref$htmlFontSize,
        _ref$useNextVariants = _ref.useNextVariants,
        useNextVariants = _ref$useNextVariants === void 0 ? Boolean(ponyfillGlobal.__MUI_USE_NEXT_TYPOGRAPHY_VARIANTS__) : _ref$useNextVariants,
        _ref$suppressWarning = _ref.suppressWarning,
        suppressWarning = _ref$suppressWarning === void 0 ? false : _ref$suppressWarning,
        allVariants = _ref.allVariants,
        other = objectWithoutProperties(_ref, ["fontFamily", "fontSize", "fontWeightLight", "fontWeightRegular", "fontWeightMedium", "htmlFontSize", "useNextVariants", "suppressWarning", "allVariants"]);

    warning_1(useNextVariants || suppressWarning, 'Material-UI: you are using the deprecated typography variants ' + 'that will be removed in the next major release.' + '\nPlease read the migration guide under https://material-ui.com/style/typography#migration-to-typography-v2');
    var coef = fontSize / 14;

    var pxToRem = function pxToRem(size) {
      return "".concat(size / htmlFontSize * coef, "rem");
    };

    var buildVariant = function buildVariant(fontWeight, size, lineHeight, letterSpacing, casing) {
      return _extends_1({
        color: palette.text.primary,
        fontFamily: fontFamily,
        fontWeight: fontWeight,
        fontSize: pxToRem(size),
        // Unitless following http://meyerweb.com/eric/thoughts/2006/02/08/unitless-line-heights/
        lineHeight: lineHeight
      }, fontFamily === defaultFontFamily ? {
        letterSpacing: "".concat(round(letterSpacing / size), "em")
      } : {}, casing, allVariants);
    };

    var nextVariants = {
      h1: buildVariant(fontWeightLight, 96, 1, -1.5),
      h2: buildVariant(fontWeightLight, 60, 1, -0.5),
      h3: buildVariant(fontWeightRegular, 48, 1.04, 0),
      h4: buildVariant(fontWeightRegular, 34, 1.17, 0.25),
      h5: buildVariant(fontWeightRegular, 24, 1.33, 0),
      h6: buildVariant(fontWeightMedium, 20, 1.6, 0.15),
      subtitle1: buildVariant(fontWeightRegular, 16, 1.75, 0.15),
      subtitle2: buildVariant(fontWeightMedium, 14, 1.57, 0.1),
      body1Next: buildVariant(fontWeightRegular, 16, 1.5, 0.15),
      body2Next: buildVariant(fontWeightRegular, 14, 1.5, 0.15),
      buttonNext: buildVariant(fontWeightMedium, 14, 1.75, 0.4, caseAllCaps),
      captionNext: buildVariant(fontWeightRegular, 12, 1.66, 0.4),
      overline: buildVariant(fontWeightRegular, 12, 2.66, 1, caseAllCaps)
    }; // To remove in v4

    var oldVariants = {
      display4: _extends_1({
        fontSize: pxToRem(112),
        fontWeight: fontWeightLight,
        fontFamily: fontFamily,
        letterSpacing: '-.04em',
        lineHeight: "".concat(round(128 / 112), "em"),
        marginLeft: '-.04em',
        color: palette.text.secondary
      }, allVariants),
      display3: _extends_1({
        fontSize: pxToRem(56),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        letterSpacing: '-.02em',
        lineHeight: "".concat(round(73 / 56), "em"),
        marginLeft: '-.02em',
        color: palette.text.secondary
      }, allVariants),
      display2: _extends_1({
        fontSize: pxToRem(45),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(51 / 45), "em"),
        marginLeft: '-.02em',
        color: palette.text.secondary
      }, allVariants),
      display1: _extends_1({
        fontSize: pxToRem(34),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(41 / 34), "em"),
        color: palette.text.secondary
      }, allVariants),
      headline: _extends_1({
        fontSize: pxToRem(24),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(32.5 / 24), "em"),
        color: palette.text.primary
      }, allVariants),
      title: _extends_1({
        fontSize: pxToRem(21),
        fontWeight: fontWeightMedium,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(24.5 / 21), "em"),
        color: palette.text.primary
      }, allVariants),
      subheading: _extends_1({
        fontSize: pxToRem(16),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(24 / 16), "em"),
        color: palette.text.primary
      }, allVariants),
      body2: _extends_1({
        fontSize: pxToRem(14),
        fontWeight: fontWeightMedium,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(24 / 14), "em"),
        color: palette.text.primary
      }, allVariants),
      body1: _extends_1({
        fontSize: pxToRem(14),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(20.5 / 14), "em"),
        color: palette.text.primary
      }, allVariants),
      caption: _extends_1({
        fontSize: pxToRem(12),
        fontWeight: fontWeightRegular,
        fontFamily: fontFamily,
        lineHeight: "".concat(round(16.5 / 12), "em"),
        color: palette.text.secondary
      }, allVariants),
      button: _extends_1({
        fontSize: pxToRem(14),
        textTransform: 'uppercase',
        fontWeight: fontWeightMedium,
        fontFamily: fontFamily,
        color: palette.text.primary
      }, allVariants)
    };
    return umd(_extends_1({
      pxToRem: pxToRem,
      round: round,
      fontFamily: fontFamily,
      fontSize: fontSize,
      fontWeightLight: fontWeightLight,
      fontWeightRegular: fontWeightRegular,
      fontWeightMedium: fontWeightMedium
    }, oldVariants, nextVariants, useNextVariants ? {
      body1: nextVariants.body1Next,
      body2: nextVariants.body2Next,
      button: nextVariants.buttonNext,
      caption: nextVariants.captionNext
    } : {}, {
      useNextVariants: useNextVariants
    }), other, {
      clone: false // No need to clone deep

    });
  }

  var shadowKeyUmbraOpacity = 0.2;
  var shadowKeyPenumbraOpacity = 0.14;
  var shadowAmbientShadowOpacity = 0.12;

  function createShadow() {
    return ["".concat(arguments.length <= 0 ? undefined : arguments[0], "px ").concat(arguments.length <= 1 ? undefined : arguments[1], "px ").concat(arguments.length <= 2 ? undefined : arguments[2], "px ").concat(arguments.length <= 3 ? undefined : arguments[3], "px rgba(0,0,0,").concat(shadowKeyUmbraOpacity, ")"), "".concat(arguments.length <= 4 ? undefined : arguments[4], "px ").concat(arguments.length <= 5 ? undefined : arguments[5], "px ").concat(arguments.length <= 6 ? undefined : arguments[6], "px ").concat(arguments.length <= 7 ? undefined : arguments[7], "px rgba(0,0,0,").concat(shadowKeyPenumbraOpacity, ")"), "".concat(arguments.length <= 8 ? undefined : arguments[8], "px ").concat(arguments.length <= 9 ? undefined : arguments[9], "px ").concat(arguments.length <= 10 ? undefined : arguments[10], "px ").concat(arguments.length <= 11 ? undefined : arguments[11], "px rgba(0,0,0,").concat(shadowAmbientShadowOpacity, ")")].join(',');
  }

  var shadows = ['none', createShadow(0, 1, 3, 0, 0, 1, 1, 0, 0, 2, 1, -1), createShadow(0, 1, 5, 0, 0, 2, 2, 0, 0, 3, 1, -2), createShadow(0, 1, 8, 0, 0, 3, 4, 0, 0, 3, 3, -2), createShadow(0, 2, 4, -1, 0, 4, 5, 0, 0, 1, 10, 0), createShadow(0, 3, 5, -1, 0, 5, 8, 0, 0, 1, 14, 0), createShadow(0, 3, 5, -1, 0, 6, 10, 0, 0, 1, 18, 0), createShadow(0, 4, 5, -2, 0, 7, 10, 1, 0, 2, 16, 1), createShadow(0, 5, 5, -3, 0, 8, 10, 1, 0, 3, 14, 2), createShadow(0, 5, 6, -3, 0, 9, 12, 1, 0, 3, 16, 2), createShadow(0, 6, 6, -3, 0, 10, 14, 1, 0, 4, 18, 3), createShadow(0, 6, 7, -4, 0, 11, 15, 1, 0, 4, 20, 3), createShadow(0, 7, 8, -4, 0, 12, 17, 2, 0, 5, 22, 4), createShadow(0, 7, 8, -4, 0, 13, 19, 2, 0, 5, 24, 4), createShadow(0, 7, 9, -4, 0, 14, 21, 2, 0, 5, 26, 4), createShadow(0, 8, 9, -5, 0, 15, 22, 2, 0, 6, 28, 5), createShadow(0, 8, 10, -5, 0, 16, 24, 2, 0, 6, 30, 5), createShadow(0, 8, 11, -5, 0, 17, 26, 2, 0, 6, 32, 5), createShadow(0, 9, 11, -5, 0, 18, 28, 2, 0, 7, 34, 6), createShadow(0, 9, 12, -6, 0, 19, 29, 2, 0, 7, 36, 6), createShadow(0, 10, 13, -6, 0, 20, 31, 3, 0, 8, 38, 7), createShadow(0, 10, 13, -6, 0, 21, 33, 3, 0, 8, 40, 7), createShadow(0, 10, 14, -6, 0, 22, 35, 3, 0, 8, 42, 7), createShadow(0, 11, 14, -7, 0, 23, 36, 3, 0, 9, 44, 8), createShadow(0, 11, 15, -7, 0, 24, 38, 3, 0, 9, 46, 8)];

  var shape = {
    borderRadius: 4
  };

  var spacing = {
    // All components align to an 8dp square baseline grid for mobile, tablet, and desktop.
    // https://material.io/design/layout/understanding-layout.html#pixel-density
    unit: 8
  };

  // to learn the context in which each easing should be used.

  var easing = {
    // This is the most common easing curve.
    easeInOut: 'cubic-bezier(0.4, 0, 0.2, 1)',
    // Objects enter the screen at full velocity from off-screen and
    // slowly decelerate to a resting point.
    easeOut: 'cubic-bezier(0.0, 0, 0.2, 1)',
    // Objects leave the screen at full velocity. They do not decelerate when off-screen.
    easeIn: 'cubic-bezier(0.4, 0, 1, 1)',
    // The sharp curve is used by objects that may return to the screen at any time.
    sharp: 'cubic-bezier(0.4, 0, 0.6, 1)'
  }; // Follow https://material.io/guidelines/motion/duration-easing.html#duration-easing-common-durations
  // to learn when use what timing

  var duration = {
    shortest: 150,
    shorter: 200,
    short: 250,
    // most basic recommended timing
    standard: 300,
    // this is to be used in complex animations
    complex: 375,
    // recommended when something is entering screen
    enteringScreen: 225,
    // recommended when something is leaving screen
    leavingScreen: 195
  };
  var formatMs = function formatMs(milliseconds) {
    return "".concat(Math.round(milliseconds), "ms");
  };
  var isString = function isString(value) {
    return typeof value === 'string';
  };
  var isNumber = function isNumber(value) {
    return !isNaN(parseFloat(value));
  };
  /**
   * @param {string|Array} props
   * @param {object} param
   * @param {string} param.prop
   * @param {number} param.duration
   * @param {string} param.easing
   * @param {number} param.delay
   */

  var transitions = {
    easing: easing,
    duration: duration,
    create: function create() {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : ['all'];
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var _options$duration = options.duration,
          durationOption = _options$duration === void 0 ? duration.standard : _options$duration,
          _options$easing = options.easing,
          easingOption = _options$easing === void 0 ? easing.easeInOut : _options$easing,
          _options$delay = options.delay,
          delay = _options$delay === void 0 ? 0 : _options$delay,
          other = objectWithoutProperties(options, ["duration", "easing", "delay"]);

      warning_1(isString(props) || Array.isArray(props), 'Material-UI: argument "props" must be a string or Array.');
      warning_1(isNumber(durationOption) || isString(durationOption), "Material-UI: argument \"duration\" must be a number or a string but found ".concat(durationOption, "."));
      warning_1(isString(easingOption), 'Material-UI: argument "easing" must be a string.');
      warning_1(isNumber(delay) || isString(delay), 'Material-UI: argument "delay" must be a number or a string.');
      warning_1(Object.keys(other).length === 0, "Material-UI: unrecognized argument(s) [".concat(Object.keys(other).join(','), "]"));
      return (Array.isArray(props) ? props : [props]).map(function (animatedProp) {
        return "".concat(animatedProp, " ").concat(typeof durationOption === 'string' ? durationOption : formatMs(durationOption), " ").concat(easingOption, " ").concat(typeof delay === 'string' ? delay : formatMs(delay));
      }).join(',');
    },
    getAutoHeightDuration: function getAutoHeightDuration(height) {
      if (!height) {
        return 0;
      }

      var constant = height / 36; // https://www.wolframalpha.com/input/?i=(4+%2B+15+*+(x+%2F+36+)+**+0.25+%2B+(x+%2F+36)+%2F+5)+*+10

      return Math.round((4 + 15 * Math.pow(constant, 0.25) + constant / 5) * 10);
    }
  };

  // We need to centralize the zIndex definitions as they work
  // like global values in the browser.
  var zIndex = {
    mobileStepper: 1000,
    appBar: 1100,
    drawer: 1200,
    modal: 1300,
    snackbar: 1400,
    tooltip: 1500
  };

  function createMuiTheme() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var _options$breakpoints = options.breakpoints,
        breakpointsInput = _options$breakpoints === void 0 ? {} : _options$breakpoints,
        _options$mixins = options.mixins,
        mixinsInput = _options$mixins === void 0 ? {} : _options$mixins,
        _options$palette = options.palette,
        paletteInput = _options$palette === void 0 ? {} : _options$palette,
        shadowsInput = options.shadows,
        _options$spacing = options.spacing,
        spacingInput = _options$spacing === void 0 ? {} : _options$spacing,
        _options$typography = options.typography,
        typographyInput = _options$typography === void 0 ? {} : _options$typography,
        other = objectWithoutProperties(options, ["breakpoints", "mixins", "palette", "shadows", "spacing", "typography"]);

    var palette = createPalette(paletteInput);
    var breakpoints = createBreakpoints(breakpointsInput);

    var spacing$$1 = _extends_1({}, spacing, spacingInput);

    var muiTheme = _extends_1({
      breakpoints: breakpoints,
      direction: 'ltr',
      mixins: createMixins(breakpoints, spacing$$1, mixinsInput),
      overrides: {},
      // Inject custom styles
      palette: palette,
      props: {},
      // Inject custom properties
      shadows: shadowsInput || shadows,
      typography: createTypography(palette, typographyInput)
    }, umd({
      shape: shape,
      spacing: spacing$$1,
      transitions: transitions,
      zIndex: zIndex
    }, other, {
      isMergeableObject: isPlainObject
    }));

    {
      var statesWarning = ['disabled', 'focused', 'selected', 'checked'];

      var traverse = function traverse(node, parentKey) {
        var depth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
        var key; // eslint-disable-next-line guard-for-in, no-restricted-syntax

        for (key in node) {
          var child = node[key];

          if (depth === 1) {
            if (key.indexOf('Mui') === 0 && child) {
              traverse(child, key, depth + 1);
            }
          } else if (statesWarning.indexOf(key) !== -1 && Object.keys(child).length > 0) {
            warning_1(false, ["Material-UI: the `".concat(parentKey, "` component increases ") + "the CSS specificity of the `".concat(key, "` internal state."), 'You can not override it like this: ', JSON.stringify(node, null, 2), '', 'Instead, you need to use the $ruleName syntax:', JSON.stringify(defineProperty({}, "&$".concat(key), child), null, 2), '', 'https://material-ui.com/customization/overrides#internal-states'].join('\n'));
          }
        }
      };

      traverse(other.overrides);
    }

    warning_1(muiTheme.shadows.length === 25, 'Material-UI: the shadows array provided to createMuiTheme should support 25 elevations.');
    return muiTheme;
  }

  var getDynamicStyles_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  exports['default'] = getDynamicStyles;
  /**
   * Extracts a styles object with only props that contain function values.
   */
  function getDynamicStyles(styles) {
    var to = null;

    for (var key in styles) {
      var value = styles[key];
      var type = typeof value === 'undefined' ? 'undefined' : _typeof(value);

      if (type === 'function') {
        if (!to) to = {};
        to[key] = value;
      } else if (type === 'object' && value !== null && !Array.isArray(value)) {
        var extracted = getDynamicStyles(value);
        if (extracted) {
          if (!to) to = {};
          to[key] = extracted;
        }
      }
    }

    return to;
  }
  });

  unwrapExports(getDynamicStyles_1);

  var toCssValue_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = toCssValue;
  var join = function join(value, by) {
    var result = '';
    for (var i = 0; i < value.length; i++) {
      // Remove !important from the value, it will be readded later.
      if (value[i] === '!important') break;
      if (result) result += by;
      result += value[i];
    }
    return result;
  };

  /**
   * Converts array values to string.
   *
   * `margin: [['5px', '10px']]` > `margin: 5px 10px;`
   * `border: ['1px', '2px']` > `border: 1px, 2px;`
   * `margin: [['5px', '10px'], '!important']` > `margin: 5px 10px !important;`
   * `color: ['red', !important]` > `color: red !important;`
   */
  function toCssValue(value) {
    var ignoreImportant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    if (!Array.isArray(value)) return value;

    var cssValue = '';

    // Support space separated values via `[['5px', '10px']]`.
    if (Array.isArray(value[0])) {
      for (var i = 0; i < value.length; i++) {
        if (value[i] === '!important') break;
        if (cssValue) cssValue += ', ';
        cssValue += join(value[i], ' ');
      }
    } else cssValue = join(value, ', ');

    // Add !important, because it was ignored.
    if (!ignoreImportant && value[value.length - 1] === '!important') {
      cssValue += ' !important';
    }

    return cssValue;
  }
  });

  unwrapExports(toCssValue_1);

  var SheetsRegistry_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /**
   * Sheets registry to access them all at one place.
   */
  var SheetsRegistry = function () {
    function SheetsRegistry() {
      _classCallCheck(this, SheetsRegistry);

      this.registry = [];
    }

    _createClass(SheetsRegistry, [{
      key: 'add',


      /**
       * Register a Style Sheet.
       */
      value: function add(sheet) {
        var registry = this.registry;
        var index = sheet.options.index;


        if (registry.indexOf(sheet) !== -1) return;

        if (registry.length === 0 || index >= this.index) {
          registry.push(sheet);
          return;
        }

        // Find a position.
        for (var i = 0; i < registry.length; i++) {
          if (registry[i].options.index > index) {
            registry.splice(i, 0, sheet);
            return;
          }
        }
      }

      /**
       * Reset the registry.
       */

    }, {
      key: 'reset',
      value: function reset() {
        this.registry = [];
      }

      /**
       * Remove a Style Sheet.
       */

    }, {
      key: 'remove',
      value: function remove(sheet) {
        var index = this.registry.indexOf(sheet);
        this.registry.splice(index, 1);
      }

      /**
       * Convert all attached sheets to a CSS string.
       */

    }, {
      key: 'toString',
      value: function toString(options) {
        return this.registry.filter(function (sheet) {
          return sheet.attached;
        }).map(function (sheet) {
          return sheet.toString(options);
        }).join('\n');
      }
    }, {
      key: 'index',


      /**
       * Current highest index number.
       */
      get: function get() {
        return this.registry.length === 0 ? 0 : this.registry[this.registry.length - 1].options.index;
      }
    }]);

    return SheetsRegistry;
  }();

  exports['default'] = SheetsRegistry;
  });

  unwrapExports(SheetsRegistry_1);

  var warning$1 = function() {};

  {
    warning$1 = function(condition, format, args) {
      var len = arguments.length;
      args = new Array(len > 2 ? len - 2 : 0);
      for (var key = 2; key < len; key++) {
        args[key - 2] = arguments[key];
      }
      if (format === undefined) {
        throw new Error(
          '`warning(condition, format, ...args)` requires a warning ' +
          'message argument'
        );
      }

      if (format.length < 10 || (/^[s\W]*$/).test(format)) {
        throw new Error(
          'The warning format should be able to uniquely identify this ' +
          'warning. Please, use a more descriptive format than: ' + format
        );
      }

      if (!condition) {
        var argIndex = 0;
        var message = 'Warning: ' +
          format.replace(/%s/g, function() {
            return args[argIndex++];
          });
        if (typeof console !== 'undefined') {
          console.error(message);
        }
        try {
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch(x) {}
      }
    };
  }

  var warning_1$1 = warning$1;

  var SheetsManager_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _warning2 = _interopRequireDefault(warning_1$1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /**
   * SheetsManager is like a WeakMap which is designed to count StyleSheet
   * instances and attach/detach automatically.
   */
  var SheetsManager = function () {
    function SheetsManager() {
      _classCallCheck(this, SheetsManager);

      this.sheets = [];
      this.refs = [];
      this.keys = [];
    }

    _createClass(SheetsManager, [{
      key: 'get',
      value: function get(key) {
        var index = this.keys.indexOf(key);
        return this.sheets[index];
      }
    }, {
      key: 'add',
      value: function add(key, sheet) {
        var sheets = this.sheets,
            refs = this.refs,
            keys = this.keys;

        var index = sheets.indexOf(sheet);

        if (index !== -1) return index;

        sheets.push(sheet);
        refs.push(0);
        keys.push(key);

        return sheets.length - 1;
      }
    }, {
      key: 'manage',
      value: function manage(key) {
        var index = this.keys.indexOf(key);
        var sheet = this.sheets[index];
        if (this.refs[index] === 0) sheet.attach();
        this.refs[index]++;
        if (!this.keys[index]) this.keys.splice(index, 0, key);
        return sheet;
      }
    }, {
      key: 'unmanage',
      value: function unmanage(key) {
        var index = this.keys.indexOf(key);
        if (index === -1) {
          // eslint-ignore-next-line no-console
          (0, _warning2['default'])(false, "SheetsManager: can't find sheet to unmanage");
          return;
        }
        if (this.refs[index] > 0) {
          this.refs[index]--;
          if (this.refs[index] === 0) this.sheets[index].detach();
        }
      }
    }, {
      key: 'size',
      get: function get() {
        return this.keys.length;
      }
    }]);

    return SheetsManager;
  }();

  exports['default'] = SheetsManager;
  });

  unwrapExports(SheetsManager_1);

  var toCss_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = toCss;



  var _toCssValue2 = _interopRequireDefault(toCssValue_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * Indent a string.
   * http://jsperf.com/array-join-vs-for
   */
  function indentStr(str, indent) {
    var result = '';
    for (var index = 0; index < indent; index++) {
      result += '  ';
    }return result + str;
  }

  /**
   * Converts a Rule to CSS string.
   */

  function toCss(selector, style) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    var result = '';

    if (!style) return result;

    var _options$indent = options.indent,
        indent = _options$indent === undefined ? 0 : _options$indent;
    var fallbacks = style.fallbacks;


    indent++;

    // Apply fallbacks first.
    if (fallbacks) {
      // Array syntax {fallbacks: [{prop: value}]}
      if (Array.isArray(fallbacks)) {
        for (var index = 0; index < fallbacks.length; index++) {
          var fallback = fallbacks[index];
          for (var prop in fallback) {
            var value = fallback[prop];
            if (value != null) {
              result += '\n' + indentStr(prop + ': ' + (0, _toCssValue2['default'])(value) + ';', indent);
            }
          }
        }
      } else {
        // Object syntax {fallbacks: {prop: value}}
        for (var _prop in fallbacks) {
          var _value = fallbacks[_prop];
          if (_value != null) {
            result += '\n' + indentStr(_prop + ': ' + (0, _toCssValue2['default'])(_value) + ';', indent);
          }
        }
      }
    }

    for (var _prop2 in style) {
      var _value2 = style[_prop2];
      if (_value2 != null && _prop2 !== 'fallbacks') {
        result += '\n' + indentStr(_prop2 + ': ' + (0, _toCssValue2['default'])(_value2) + ';', indent);
      }
    }

    // Allow empty style in this case, because properties will be added dynamically.
    if (!result && !options.allowEmpty) return result;

    indent--;
    result = indentStr(selector + ' {' + result + '\n', indent) + indentStr('}', indent);

    return result;
  }
  });

  unwrapExports(toCss_1);

  var StyleRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _warning2 = _interopRequireDefault(warning_1$1);



  var _toCss2 = _interopRequireDefault(toCss_1);



  var _toCssValue2 = _interopRequireDefault(toCssValue_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var StyleRule = function () {
    function StyleRule(key, style, options) {
      _classCallCheck(this, StyleRule);

      this.type = 'style';
      this.isProcessed = false;
      var sheet = options.sheet,
          Renderer = options.Renderer,
          selector = options.selector;

      this.key = key;
      this.options = options;
      this.style = style;
      if (selector) this.selectorText = selector;
      this.renderer = sheet ? sheet.renderer : new Renderer();
    }

    /**
     * Set selector string.
     * Attention: use this with caution. Most browsers didn't implement
     * selectorText setter, so this may result in rerendering of entire Style Sheet.
     */


    _createClass(StyleRule, [{
      key: 'prop',


      /**
       * Get or set a style property.
       */
      value: function prop(name, value) {
        // It's a getter.
        if (value === undefined) return this.style[name];

        // Don't do anything if the value has not changed.
        if (this.style[name] === value) return this;

        value = this.options.jss.plugins.onChangeValue(value, name, this);

        var isEmpty = value == null || value === false;
        var isDefined = name in this.style;

        // Value is empty and wasn't defined before.
        if (isEmpty && !isDefined) return this;

        // We are going to remove this value.
        var remove = isEmpty && isDefined;

        if (remove) delete this.style[name];else this.style[name] = value;

        // Renderable is defined if StyleSheet option `link` is true.
        if (this.renderable) {
          if (remove) this.renderer.removeProperty(this.renderable, name);else this.renderer.setProperty(this.renderable, name, value);
          return this;
        }

        var sheet = this.options.sheet;

        if (sheet && sheet.attached) {
          (0, _warning2['default'])(false, 'Rule is not linked. Missing sheet option "link: true".');
        }
        return this;
      }

      /**
       * Apply rule to an element inline.
       */

    }, {
      key: 'applyTo',
      value: function applyTo(renderable) {
        var json = this.toJSON();
        for (var prop in json) {
          this.renderer.setProperty(renderable, prop, json[prop]);
        }return this;
      }

      /**
       * Returns JSON representation of the rule.
       * Fallbacks are not supported.
       * Useful for inline styles.
       */

    }, {
      key: 'toJSON',
      value: function toJSON() {
        var json = {};
        for (var prop in this.style) {
          var value = this.style[prop];
          if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) !== 'object') json[prop] = value;else if (Array.isArray(value)) json[prop] = (0, _toCssValue2['default'])(value);
        }
        return json;
      }

      /**
       * Generates a CSS string.
       */

    }, {
      key: 'toString',
      value: function toString(options) {
        var sheet = this.options.sheet;

        var link = sheet ? sheet.options.link : false;
        var opts = link ? _extends({}, options, { allowEmpty: true }) : options;
        return (0, _toCss2['default'])(this.selector, this.style, opts);
      }
    }, {
      key: 'selector',
      set: function set(selector) {
        if (selector === this.selectorText) return;

        this.selectorText = selector;

        if (!this.renderable) return;

        var hasChanged = this.renderer.setSelector(this.renderable, selector);

        // If selector setter is not implemented, rerender the rule.
        if (!hasChanged && this.renderable) {
          var renderable = this.renderer.replaceRule(this.renderable, this);
          if (renderable) this.renderable = renderable;
        }
      }

      /**
       * Get selector string.
       */
      ,
      get: function get() {
        return this.selectorText;
      }
    }]);

    return StyleRule;
  }();

  exports['default'] = StyleRule;
  });

  unwrapExports(StyleRule_1);

  function symbolObservablePonyfill(root) {
  	var result;
  	var Symbol = root.Symbol;

  	if (typeof Symbol === 'function') {
  		if (Symbol.observable) {
  			result = Symbol.observable;
  		} else {
  			result = Symbol('observable');
  			Symbol.observable = result;
  		}
  	} else {
  		result = '@@observable';
  	}

  	return result;
  }

  var root;

  if (typeof self !== 'undefined') {
    root = self;
  } else if (typeof window !== 'undefined') {
    root = window;
  } else if (typeof global$1 !== 'undefined') {
    root = global$1;
  } else if (typeof module !== 'undefined') {
    root = module;
  } else {
    root = Function('return this')();
  }

  var result = symbolObservablePonyfill(root);

  var isObservable = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _symbolObservable2 = _interopRequireDefault(result);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  exports['default'] = function (value) {
    return value && value[_symbolObservable2['default']] && value === value[_symbolObservable2['default']]();
  };
  });

  unwrapExports(isObservable);

  var cloneStyle_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  exports['default'] = cloneStyle;



  var _isObservable2 = _interopRequireDefault(isObservable);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var isArray = Array.isArray;
  function cloneStyle(style) {
    // Support empty values in case user ends up with them by accident.
    if (style == null) return style;

    // Support string value for SimpleRule.
    var typeOfStyle = typeof style === 'undefined' ? 'undefined' : _typeof(style);

    if (typeOfStyle === 'string' || typeOfStyle === 'number' || typeOfStyle === 'function') {
      return style;
    }

    // Support array for FontFaceRule.
    if (isArray(style)) return style.map(cloneStyle);

    // Support Observable styles.  Observables are immutable, so we don't need to
    // copy them.
    if ((0, _isObservable2['default'])(style)) return style;

    var newStyle = {};
    for (var name in style) {
      var value = style[name];
      if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
        newStyle[name] = cloneStyle(value);
        continue;
      }
      newStyle[name] = value;
    }

    return newStyle;
  }
  });

  unwrapExports(cloneStyle_1);

  var createRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = createRule;



  var _warning2 = _interopRequireDefault(warning_1$1);



  var _StyleRule2 = _interopRequireDefault(StyleRule_1);



  var _cloneStyle2 = _interopRequireDefault(cloneStyle_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * Create a rule instance.
   */
  function createRule() {
    var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'unnamed';
    var decl = arguments[1];
    var options = arguments[2];
    var jss = options.jss;

    var declCopy = (0, _cloneStyle2['default'])(decl);

    var rule = jss.plugins.onCreateRule(name, declCopy, options);
    if (rule) return rule;

    // It is an at-rule and it has no instance.
    if (name[0] === '@') {
      (0, _warning2['default'])(false, '[JSS] Unknown at-rule %s', name);
    }

    return new _StyleRule2['default'](name, declCopy, options);
  }
  });

  unwrapExports(createRule_1);

  var linkRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = linkRule;
  /**
   * Link rule with CSSStyleRule and nested rules with corresponding nested cssRules if both exists.
   */
  function linkRule(rule, cssRule) {
    rule.renderable = cssRule;
    if (rule.rules && cssRule.cssRules) rule.rules.link(cssRule.cssRules);
  }
  });

  unwrapExports(linkRule_1);

  var _escape = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  var CSS = global$1.CSS;

  var escapeRegex = /([[\].#*$><+~=|^:(),"'`])/g;

  exports['default'] = function (str) {

    if (!CSS || !CSS.escape) {
      return str.replace(escapeRegex, '\\$1');
    }

    return CSS.escape(str);
  };
  });

  unwrapExports(_escape);

  var RuleList_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _createRule2 = _interopRequireDefault(createRule_1);



  var _linkRule2 = _interopRequireDefault(linkRule_1);



  var _StyleRule2 = _interopRequireDefault(StyleRule_1);



  var _escape2 = _interopRequireDefault(_escape);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /**
   * Contains rules objects and allows adding/removing etc.
   * Is used for e.g. by `StyleSheet` or `ConditionalRule`.
   */
  var RuleList = function () {

    // Original styles object.
    function RuleList(options) {
      var _this = this;

      _classCallCheck(this, RuleList);

      this.map = {};
      this.raw = {};
      this.index = [];

      this.update = function (name, data) {
        var _options = _this.options,
            plugins = _options.jss.plugins,
            sheet = _options.sheet;

        if (typeof name === 'string') {
          plugins.onUpdate(data, _this.get(name), sheet);
        } else {
          for (var index = 0; index < _this.index.length; index++) {
            plugins.onUpdate(name, _this.index[index], sheet);
          }
        }
      };

      this.options = options;
      this.classes = options.classes;
    }

    /**
     * Create and register rule.
     *
     * Will not render after Style Sheet was rendered the first time.
     */


    // Used to ensure correct rules order.

    // Rules registry for access by .get() method.
    // It contains the same rule registered by name and by selector.


    _createClass(RuleList, [{
      key: 'add',
      value: function add(name, decl, options) {
        var _options2 = this.options,
            parent = _options2.parent,
            sheet = _options2.sheet,
            jss = _options2.jss,
            Renderer = _options2.Renderer,
            generateClassName = _options2.generateClassName;


        options = _extends({
          classes: this.classes,
          parent: parent,
          sheet: sheet,
          jss: jss,
          Renderer: Renderer,
          generateClassName: generateClassName
        }, options);

        if (!options.selector && this.classes[name]) {
          options.selector = '.' + (0, _escape2['default'])(this.classes[name]);
        }

        this.raw[name] = decl;

        var rule = (0, _createRule2['default'])(name, decl, options);

        var className = void 0;

        if (!options.selector && rule instanceof _StyleRule2['default']) {
          className = generateClassName(rule, sheet);
          rule.selector = '.' + (0, _escape2['default'])(className);
        }

        this.register(rule, className);

        var index = options.index === undefined ? this.index.length : options.index;
        this.index.splice(index, 0, rule);

        return rule;
      }

      /**
       * Get a rule.
       */

    }, {
      key: 'get',
      value: function get(name) {
        return this.map[name];
      }

      /**
       * Delete a rule.
       */

    }, {
      key: 'remove',
      value: function remove(rule) {
        this.unregister(rule);
        this.index.splice(this.indexOf(rule), 1);
      }

      /**
       * Get index of a rule.
       */

    }, {
      key: 'indexOf',
      value: function indexOf(rule) {
        return this.index.indexOf(rule);
      }

      /**
       * Run `onProcessRule()` plugins on every rule.
       */

    }, {
      key: 'process',
      value: function process() {
        var plugins = this.options.jss.plugins;
        // We need to clone array because if we modify the index somewhere else during a loop
        // we end up with very hard-to-track-down side effects.

        this.index.slice(0).forEach(plugins.onProcessRule, plugins);
      }

      /**
       * Register a rule in `.map` and `.classes` maps.
       */

    }, {
      key: 'register',
      value: function register(rule, className) {
        this.map[rule.key] = rule;
        if (rule instanceof _StyleRule2['default']) {
          this.map[rule.selector] = rule;
          if (className) this.classes[rule.key] = className;
        }
      }

      /**
       * Unregister a rule.
       */

    }, {
      key: 'unregister',
      value: function unregister(rule) {
        delete this.map[rule.key];
        if (rule instanceof _StyleRule2['default']) {
          delete this.map[rule.selector];
          delete this.classes[rule.key];
        }
      }

      /**
       * Update the function values with a new data.
       */

    }, {
      key: 'link',


      /**
       * Link renderable rules with CSSRuleList.
       */
      value: function link(cssRules) {
        var map = this.options.sheet.renderer.getUnescapedKeysMap(this.index);

        for (var i = 0; i < cssRules.length; i++) {
          var cssRule = cssRules[i];
          var _key = this.options.sheet.renderer.getKey(cssRule);
          if (map[_key]) _key = map[_key];
          var rule = this.map[_key];
          if (rule) (0, _linkRule2['default'])(rule, cssRule);
        }
      }

      /**
       * Convert rules to a CSS string.
       */

    }, {
      key: 'toString',
      value: function toString(options) {
        var str = '';
        var sheet = this.options.sheet;

        var link = sheet ? sheet.options.link : false;

        for (var index = 0; index < this.index.length; index++) {
          var rule = this.index[index];
          var css = rule.toString(options);

          // No need to render an empty rule.
          if (!css && !link) continue;

          if (str) str += '\n';
          str += css;
        }

        return str;
      }
    }]);

    return RuleList;
  }();

  exports['default'] = RuleList;
  });

  unwrapExports(RuleList_1);

  var sheets = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _SheetsRegistry2 = _interopRequireDefault(SheetsRegistry_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * This is a global sheets registry. Only DomRenderer will add sheets to it.
   * On the server one should use an own SheetsRegistry instance and add the
   * sheets to it, because you need to make sure to create a new registry for
   * each request in order to not leak sheets across requests.
   */
  exports['default'] = new _SheetsRegistry2['default']();
  });

  unwrapExports(sheets);

  var StyleSheet_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _linkRule2 = _interopRequireDefault(linkRule_1);



  var _RuleList2 = _interopRequireDefault(RuleList_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /* eslint-disable-next-line no-use-before-define */
  var StyleSheet = function () {
    function StyleSheet(styles, options) {
      var _this = this;

      _classCallCheck(this, StyleSheet);

      this.update = function (name, data) {
        if (typeof name === 'string') {
          _this.rules.update(name, data);
        } else {
          _this.rules.update(name);
        }
        return _this;
      };

      this.attached = false;
      this.deployed = false;
      this.linked = false;
      this.classes = {};
      this.options = _extends({}, options, {
        sheet: this,
        parent: this,
        classes: this.classes
      });
      this.renderer = new options.Renderer(this);
      this.rules = new _RuleList2['default'](this.options);

      for (var _name in styles) {
        this.rules.add(_name, styles[_name]);
      }

      this.rules.process();
    }

    /**
     * Attach renderable to the render tree.
     */


    _createClass(StyleSheet, [{
      key: 'attach',
      value: function attach() {
        if (this.attached) return this;
        if (!this.deployed) this.deploy();
        this.renderer.attach();
        if (!this.linked && this.options.link) this.link();
        this.attached = true;
        return this;
      }

      /**
       * Remove renderable from render tree.
       */

    }, {
      key: 'detach',
      value: function detach() {
        if (!this.attached) return this;
        this.renderer.detach();
        this.attached = false;
        return this;
      }

      /**
       * Add a rule to the current stylesheet.
       * Will insert a rule also after the stylesheet has been rendered first time.
       */

    }, {
      key: 'addRule',
      value: function addRule(name, decl, options) {
        var queue = this.queue;

        // Plugins can create rules.
        // In order to preserve the right order, we need to queue all `.addRule` calls,
        // which happen after the first `rules.add()` call.

        if (this.attached && !queue) this.queue = [];

        var rule = this.rules.add(name, decl, options);
        this.options.jss.plugins.onProcessRule(rule);

        if (this.attached) {
          if (!this.deployed) return rule;
          // Don't insert rule directly if there is no stringified version yet.
          // It will be inserted all together when .attach is called.
          if (queue) queue.push(rule);else {
            this.insertRule(rule);
            if (this.queue) {
              this.queue.forEach(this.insertRule, this);
              this.queue = undefined;
            }
          }
          return rule;
        }

        // We can't add rules to a detached style node.
        // We will redeploy the sheet once user will attach it.
        this.deployed = false;

        return rule;
      }

      /**
       * Insert rule into the StyleSheet
       */

    }, {
      key: 'insertRule',
      value: function insertRule(rule) {
        var renderable = this.renderer.insertRule(rule);
        if (renderable && this.options.link) (0, _linkRule2['default'])(rule, renderable);
      }

      /**
       * Create and add rules.
       * Will render also after Style Sheet was rendered the first time.
       */

    }, {
      key: 'addRules',
      value: function addRules(styles, options) {
        var added = [];
        for (var _name2 in styles) {
          added.push(this.addRule(_name2, styles[_name2], options));
        }
        return added;
      }

      /**
       * Get a rule by name.
       */

    }, {
      key: 'getRule',
      value: function getRule(name) {
        return this.rules.get(name);
      }

      /**
       * Delete a rule by name.
       * Returns `true`: if rule has been deleted from the DOM.
       */

    }, {
      key: 'deleteRule',
      value: function deleteRule(name) {
        var rule = this.rules.get(name);

        if (!rule) return false;

        this.rules.remove(rule);

        if (this.attached && rule.renderable) {
          return this.renderer.deleteRule(rule.renderable);
        }

        return true;
      }

      /**
       * Get index of a rule.
       */

    }, {
      key: 'indexOf',
      value: function indexOf(rule) {
        return this.rules.indexOf(rule);
      }

      /**
       * Deploy pure CSS string to a renderable.
       */

    }, {
      key: 'deploy',
      value: function deploy() {
        this.renderer.deploy();
        this.deployed = true;
        return this;
      }

      /**
       * Link renderable CSS rules from sheet with their corresponding models.
       */

    }, {
      key: 'link',
      value: function link() {
        var cssRules = this.renderer.getRules();

        // Is undefined when VirtualRenderer is used.
        if (cssRules) this.rules.link(cssRules);
        this.linked = true;
        return this;
      }

      /**
       * Update the function values with a new data.
       */

    }, {
      key: 'toString',


      /**
       * Convert rules to a CSS string.
       */
      value: function toString(options) {
        return this.rules.toString(options);
      }
    }]);

    return StyleSheet;
  }();

  exports['default'] = StyleSheet;
  });

  unwrapExports(StyleSheet_1);

  var moduleId = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  var ns = '2f1acc6c3a606b082e5eef5e54414ffb';
  if (global$1[ns] == null) global$1[ns] = 0;

  // Bundle may contain multiple JSS versions at the same time. In order to identify
  // the current version with just one short number and use it for classes generation
  // we use a counter. Also it is more accurate, because user can manually reevaluate
  // the module.
  exports['default'] = global$1[ns]++;
  });

  unwrapExports(moduleId);

  var createGenerateClassName$1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _warning2 = _interopRequireDefault(warning_1$1);



  var _StyleSheet2 = _interopRequireDefault(StyleSheet_1);



  var _moduleId2 = _interopRequireDefault(moduleId);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var maxRules = 1e10;

  /**
   * Returns a function which generates unique class names based on counters.
   * When new generator function is created, rule counter is reseted.
   * We need to reset the rule counter for SSR for each request.
   */

  exports['default'] = function () {
    var ruleCounter = 0;
    var defaultPrefix = '';

    return function (rule, sheet) {
      ruleCounter += 1;

      if (ruleCounter > maxRules) {
        (0, _warning2['default'])(false, '[JSS] You might have a memory leak. Rule counter is at %s.', ruleCounter);
      }

      var prefix = defaultPrefix;
      var jssId = '';

      if (sheet) {
        prefix = sheet.options.classNamePrefix || defaultPrefix;
        if (sheet.options.jss.id != null) jssId += sheet.options.jss.id;
      }

      return prefix + rule.key + '-' + _moduleId2['default'] + (jssId && '-' + jssId) + '-' + ruleCounter;
    };
  };
  });

  unwrapExports(createGenerateClassName$1);

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  var isBrowser = (typeof window === "undefined" ? "undefined" : _typeof(window)) === "object" && (typeof document === "undefined" ? "undefined" : _typeof(document)) === 'object' && document.nodeType === 9;

  var PluginsRegistry_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _warning2 = _interopRequireDefault(warning_1$1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var PluginsRegistry = function () {
    function PluginsRegistry() {
      _classCallCheck(this, PluginsRegistry);

      this.hooks = {
        onCreateRule: [],
        onProcessRule: [],
        onProcessStyle: [],
        onProcessSheet: [],
        onChangeValue: [],
        onUpdate: []

        /**
         * Call `onCreateRule` hooks and return an object if returned by a hook.
         */
      };
    }

    _createClass(PluginsRegistry, [{
      key: 'onCreateRule',
      value: function onCreateRule(name, decl, options) {
        for (var i = 0; i < this.hooks.onCreateRule.length; i++) {
          var rule = this.hooks.onCreateRule[i](name, decl, options);
          if (rule) return rule;
        }
        return null;
      }

      /**
       * Call `onProcessRule` hooks.
       */

    }, {
      key: 'onProcessRule',
      value: function onProcessRule(rule) {
        if (rule.isProcessed) return;
        var sheet = rule.options.sheet;

        for (var i = 0; i < this.hooks.onProcessRule.length; i++) {
          this.hooks.onProcessRule[i](rule, sheet);
        }

        // $FlowFixMe
        if (rule.style) this.onProcessStyle(rule.style, rule, sheet);

        rule.isProcessed = true;
      }

      /**
       * Call `onProcessStyle` hooks.
       */

    }, {
      key: 'onProcessStyle',
      value: function onProcessStyle(style, rule, sheet) {
        var nextStyle = style;

        for (var i = 0; i < this.hooks.onProcessStyle.length; i++) {
          nextStyle = this.hooks.onProcessStyle[i](nextStyle, rule, sheet);
          // $FlowFixMe
          rule.style = nextStyle;
        }
      }

      /**
       * Call `onProcessSheet` hooks.
       */

    }, {
      key: 'onProcessSheet',
      value: function onProcessSheet(sheet) {
        for (var i = 0; i < this.hooks.onProcessSheet.length; i++) {
          this.hooks.onProcessSheet[i](sheet);
        }
      }

      /**
       * Call `onUpdate` hooks.
       */

    }, {
      key: 'onUpdate',
      value: function onUpdate(data, rule, sheet) {
        for (var i = 0; i < this.hooks.onUpdate.length; i++) {
          this.hooks.onUpdate[i](data, rule, sheet);
        }
      }

      /**
       * Call `onChangeValue` hooks.
       */

    }, {
      key: 'onChangeValue',
      value: function onChangeValue(value, prop, rule) {
        var processedValue = value;
        for (var i = 0; i < this.hooks.onChangeValue.length; i++) {
          processedValue = this.hooks.onChangeValue[i](processedValue, prop, rule);
        }
        return processedValue;
      }

      /**
       * Register a plugin.
       * If function is passed, it is a shortcut for `{onProcessRule}`.
       */

    }, {
      key: 'use',
      value: function use(plugin) {
        for (var name in plugin) {
          if (this.hooks[name]) this.hooks[name].push(plugin[name]);else (0, _warning2['default'])(false, '[JSS] Unknown hook "%s".', name);
        }
      }
    }]);

    return PluginsRegistry;
  }();

  exports['default'] = PluginsRegistry;
  });

  unwrapExports(PluginsRegistry_1);

  var SimpleRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var SimpleRule = function () {
    function SimpleRule(key, value, options) {
      _classCallCheck(this, SimpleRule);

      this.type = 'simple';
      this.isProcessed = false;

      this.key = key;
      this.value = value;
      this.options = options;
    }

    /**
     * Generates a CSS string.
     */
    // eslint-disable-next-line no-unused-vars


    _createClass(SimpleRule, [{
      key: 'toString',
      value: function toString(options) {
        if (Array.isArray(this.value)) {
          var str = '';
          for (var index = 0; index < this.value.length; index++) {
            str += this.key + ' ' + this.value[index] + ';';
            if (this.value[index + 1]) str += '\n';
          }
          return str;
        }

        return this.key + ' ' + this.value + ';';
      }
    }]);

    return SimpleRule;
  }();

  exports['default'] = SimpleRule;
  });

  unwrapExports(SimpleRule_1);

  var KeyframesRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _RuleList2 = _interopRequireDefault(RuleList_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /**
   * Rule for @keyframes
   */
  var KeyframesRule = function () {
    function KeyframesRule(key, frames, options) {
      _classCallCheck(this, KeyframesRule);

      this.type = 'keyframes';
      this.isProcessed = false;

      this.key = key;
      this.options = options;
      this.rules = new _RuleList2['default'](_extends({}, options, { parent: this }));

      for (var name in frames) {
        this.rules.add(name, frames[name], _extends({}, this.options, {
          parent: this,
          selector: name
        }));
      }

      this.rules.process();
    }

    /**
     * Generates a CSS string.
     */


    _createClass(KeyframesRule, [{
      key: 'toString',
      value: function toString() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { indent: 1 };

        var inner = this.rules.toString(options);
        if (inner) inner += '\n';
        return this.key + ' {\n' + inner + '}';
      }
    }]);

    return KeyframesRule;
  }();

  exports['default'] = KeyframesRule;
  });

  unwrapExports(KeyframesRule_1);

  var ConditionalRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _RuleList2 = _interopRequireDefault(RuleList_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /**
   * Conditional rule for @media, @supports
   */
  var ConditionalRule = function () {
    function ConditionalRule(key, styles, options) {
      _classCallCheck(this, ConditionalRule);

      this.type = 'conditional';
      this.isProcessed = false;

      this.key = key;
      this.options = options;
      this.rules = new _RuleList2['default'](_extends({}, options, { parent: this }));

      for (var name in styles) {
        this.rules.add(name, styles[name]);
      }

      this.rules.process();
    }

    /**
     * Get a rule.
     */


    _createClass(ConditionalRule, [{
      key: 'getRule',
      value: function getRule(name) {
        return this.rules.get(name);
      }

      /**
       * Get index of a rule.
       */

    }, {
      key: 'indexOf',
      value: function indexOf(rule) {
        return this.rules.indexOf(rule);
      }

      /**
       * Create and register rule, run plugins.
       */

    }, {
      key: 'addRule',
      value: function addRule(name, style, options) {
        var rule = this.rules.add(name, style, options);
        this.options.jss.plugins.onProcessRule(rule);
        return rule;
      }

      /**
       * Generates a CSS string.
       */

    }, {
      key: 'toString',
      value: function toString() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { indent: 1 };

        var inner = this.rules.toString(options);
        return inner ? this.key + ' {\n' + inner + '\n}' : '';
      }
    }]);

    return ConditionalRule;
  }();

  exports['default'] = ConditionalRule;
  });

  unwrapExports(ConditionalRule_1);

  var FontFaceRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _toCss2 = _interopRequireDefault(toCss_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var FontFaceRule = function () {
    function FontFaceRule(key, style, options) {
      _classCallCheck(this, FontFaceRule);

      this.type = 'font-face';
      this.isProcessed = false;

      this.key = key;
      this.style = style;
      this.options = options;
    }

    /**
     * Generates a CSS string.
     */


    _createClass(FontFaceRule, [{
      key: 'toString',
      value: function toString(options) {
        if (Array.isArray(this.style)) {
          var str = '';
          for (var index = 0; index < this.style.length; index++) {
            str += (0, _toCss2['default'])(this.key, this.style[index]);
            if (this.style[index + 1]) str += '\n';
          }
          return str;
        }

        return (0, _toCss2['default'])(this.key, this.style, options);
      }
    }]);

    return FontFaceRule;
  }();

  exports['default'] = FontFaceRule;
  });

  unwrapExports(FontFaceRule_1);

  var ViewportRule_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _toCss2 = _interopRequireDefault(toCss_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var ViewportRule = function () {
    function ViewportRule(key, style, options) {
      _classCallCheck(this, ViewportRule);

      this.type = 'viewport';
      this.isProcessed = false;

      this.key = key;
      this.style = style;
      this.options = options;
    }

    /**
     * Generates a CSS string.
     */


    _createClass(ViewportRule, [{
      key: 'toString',
      value: function toString(options) {
        return (0, _toCss2['default'])(this.key, this.style, options);
      }
    }]);

    return ViewportRule;
  }();

  exports['default'] = ViewportRule;
  });

  unwrapExports(ViewportRule_1);

  var rules = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _SimpleRule2 = _interopRequireDefault(SimpleRule_1);



  var _KeyframesRule2 = _interopRequireDefault(KeyframesRule_1);



  var _ConditionalRule2 = _interopRequireDefault(ConditionalRule_1);



  var _FontFaceRule2 = _interopRequireDefault(FontFaceRule_1);



  var _ViewportRule2 = _interopRequireDefault(ViewportRule_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var classes = {
    '@charset': _SimpleRule2['default'],
    '@import': _SimpleRule2['default'],
    '@namespace': _SimpleRule2['default'],
    '@keyframes': _KeyframesRule2['default'],
    '@media': _ConditionalRule2['default'],
    '@supports': _ConditionalRule2['default'],
    '@font-face': _FontFaceRule2['default'],
    '@viewport': _ViewportRule2['default'],
    '@-ms-viewport': _ViewportRule2['default']

    /**
     * Generate plugins which will register all rules.
     */
  };
  var plugins = Object.keys(classes).map(function (key) {
    // https://jsperf.com/indexof-vs-substr-vs-regex-at-the-beginning-3
    var re = new RegExp('^' + key);
    var RuleClass = classes[key];
    var onCreateRule = function onCreateRule(name, decl, options) {
      return re.test(name) ? new RuleClass(name, decl, options) : null;
    };
    return { onCreateRule: onCreateRule };
  });

  exports['default'] = plugins;
  });

  unwrapExports(rules);

  var observables = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _StyleRule2 = _interopRequireDefault(StyleRule_1);



  var _createRule2 = _interopRequireDefault(createRule_1);



  var _isObservable2 = _interopRequireDefault(isObservable);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  exports['default'] = {
    onCreateRule: function onCreateRule(name, decl, options) {
      if (!(0, _isObservable2['default'])(decl)) return null;

      // Cast `decl` to `Observable`, since it passed the type guard.
      var style$ = decl;

      var rule = (0, _createRule2['default'])(name, {}, options);

      // TODO
      // Call `stream.subscribe()` returns a subscription, which should be explicitly
      // unsubscribed from when we know this sheet is no longer needed.
      style$.subscribe(function (style) {
        for (var prop in style) {
          rule.prop(prop, style[prop]);
        }
      });

      return rule;
    },
    onProcessRule: function onProcessRule(rule) {
      if (!(rule instanceof _StyleRule2['default'])) return;
      var styleRule = rule;
      var style = styleRule.style;

      var _loop = function _loop(prop) {
        var value = style[prop];
        if (!(0, _isObservable2['default'])(value)) return 'continue';
        delete style[prop];
        value.subscribe({
          next: function next(nextValue) {
            styleRule.prop(prop, nextValue);
          }
        });
      };

      for (var prop in style) {
        var _ret = _loop(prop);

        if (_ret === 'continue') continue;
      }
    }
  };
  });

  unwrapExports(observables);

  var functions = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _RuleList2 = _interopRequireDefault(RuleList_1);



  var _StyleRule2 = _interopRequireDefault(StyleRule_1);



  var _createRule2 = _interopRequireDefault(createRule_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  // A symbol replacement.
  var now = Date.now();

  var fnValuesNs = 'fnValues' + now;
  var fnStyleNs = 'fnStyle' + ++now;

  exports['default'] = {
    onCreateRule: function onCreateRule(name, decl, options) {
      if (typeof decl !== 'function') return null;
      var rule = (0, _createRule2['default'])(name, {}, options);
      rule[fnStyleNs] = decl;
      return rule;
    },
    onProcessStyle: function onProcessStyle(style, rule) {
      var fn = {};
      for (var prop in style) {
        var value = style[prop];
        if (typeof value !== 'function') continue;
        delete style[prop];
        fn[prop] = value;
      }
      rule = rule;
      rule[fnValuesNs] = fn;
      return style;
    },
    onUpdate: function onUpdate(data, rule) {
      // It is a rules container like for e.g. ConditionalRule.
      if (rule.rules instanceof _RuleList2['default']) {
        rule.rules.update(data);
        return;
      }
      if (!(rule instanceof _StyleRule2['default'])) return;

      rule = rule;

      // If we have a fn values map, it is a rule with function values.
      if (rule[fnValuesNs]) {
        for (var prop in rule[fnValuesNs]) {
          rule.prop(prop, rule[fnValuesNs][prop](data));
        }
      }

      rule = rule;

      var fnStyle = rule[fnStyleNs];

      // If we have a style function, the entire rule is dynamic and style object
      // will be returned from that function.
      if (fnStyle) {
        var style = fnStyle(data);
        for (var _prop in style) {
          rule.prop(_prop, style[_prop]);
        }
      }
    }
  };
  });

  unwrapExports(functions);

  var DomRenderer_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _warning2 = _interopRequireDefault(warning_1$1);



  var _sheets2 = _interopRequireDefault(sheets);



  var _StyleRule2 = _interopRequireDefault(StyleRule_1);



  var _toCssValue2 = _interopRequireDefault(toCssValue_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /**
   * Cache the value from the first time a function is called.
   */
  var memoize = function memoize(fn) {
    var value = void 0;
    return function () {
      if (!value) value = fn();
      return value;
    };
  };

  /**
   * Get a style property value.
   */
  function getPropertyValue(cssRule, prop) {
    try {
      return cssRule.style.getPropertyValue(prop);
    } catch (err) {
      // IE may throw if property is unknown.
      return '';
    }
  }

  /**
   * Set a style property.
   */
  function setProperty(cssRule, prop, value) {
    try {
      var cssValue = value;

      if (Array.isArray(value)) {
        cssValue = (0, _toCssValue2['default'])(value, true);

        if (value[value.length - 1] === '!important') {
          cssRule.style.setProperty(prop, cssValue, 'important');
          return true;
        }
      }

      cssRule.style.setProperty(prop, cssValue);
    } catch (err) {
      // IE may throw if property is unknown.
      return false;
    }
    return true;
  }

  /**
   * Remove a style property.
   */
  function removeProperty(cssRule, prop) {
    try {
      cssRule.style.removeProperty(prop);
    } catch (err) {
      (0, _warning2['default'])(false, '[JSS] DOMException "%s" was thrown. Tried to remove property "%s".', err.message, prop);
    }
  }

  var CSSRuleTypes = {
    STYLE_RULE: 1,
    KEYFRAMES_RULE: 7

    /**
     * Get the CSS Rule key.
     */

  };var getKey = function () {
    var extractKey = function extractKey(cssText) {
      var from = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      return cssText.substr(from, cssText.indexOf('{') - 1);
    };

    return function (cssRule) {
      if (cssRule.type === CSSRuleTypes.STYLE_RULE) return cssRule.selectorText;
      if (cssRule.type === CSSRuleTypes.KEYFRAMES_RULE) {
        var name = cssRule.name;

        if (name) return '@keyframes ' + name;

        // There is no rule.name in the following browsers:
        // - IE 9
        // - Safari 7.1.8
        // - Mobile Safari 9.0.0
        var cssText = cssRule.cssText;

        return '@' + extractKey(cssText, cssText.indexOf('keyframes'));
      }

      // Conditionals.
      return extractKey(cssRule.cssText);
    };
  }();

  /**
   * Set the selector.
   */
  function setSelector(cssRule, selectorText) {
    cssRule.selectorText = selectorText;

    // Return false if setter was not successful.
    // Currently works in chrome only.
    return cssRule.selectorText === selectorText;
  }

  /**
   * Gets the `head` element upon the first call and caches it.
   */
  var getHead = memoize(function () {
    return document.head || document.getElementsByTagName('head')[0];
  });

  /**
   * Gets a map of rule keys, where the property is an unescaped key and value
   * is a potentially escaped one.
   * It is used to identify CSS rules and the corresponding JSS rules. As an identifier
   * for CSSStyleRule we normally use `selectorText`. Though if original selector text
   * contains escaped code points e.g. `:not(#\\20)`, CSSOM will compile it to `:not(# )`
   * and so CSS rule's `selectorText` won't match JSS rule selector.
   *
   * https://www.w3.org/International/questions/qa-escapes#cssescapes
   */
  var getUnescapedKeysMap = function () {
    var style = void 0;
    var isAttached = false;

    return function (rules) {
      var map = {};
      // https://github.com/facebook/flow/issues/2696
      if (!style) style = document.createElement('style');
      for (var i = 0; i < rules.length; i++) {
        var rule = rules[i];
        if (!(rule instanceof _StyleRule2['default'])) continue;
        var selector = rule.selector;
        // Only unescape selector over CSSOM if it contains a back slash.

        if (selector && selector.indexOf('\\') !== -1) {
          // Lazilly attach when needed.
          if (!isAttached) {
            getHead().appendChild(style);
            isAttached = true;
          }
          style.textContent = selector + ' {}';
          var _style = style,
              sheet = _style.sheet;

          if (sheet) {
            var cssRules = sheet.cssRules;

            if (cssRules) map[cssRules[0].selectorText] = rule.key;
          }
        }
      }
      if (isAttached) {
        getHead().removeChild(style);
        isAttached = false;
      }
      return map;
    };
  }();

  /**
   * Find attached sheet with an index higher than the passed one.
   */
  function findHigherSheet(registry, options) {
    for (var i = 0; i < registry.length; i++) {
      var sheet = registry[i];
      if (sheet.attached && sheet.options.index > options.index && sheet.options.insertionPoint === options.insertionPoint) {
        return sheet;
      }
    }
    return null;
  }

  /**
   * Find attached sheet with the highest index.
   */
  function findHighestSheet(registry, options) {
    for (var i = registry.length - 1; i >= 0; i--) {
      var sheet = registry[i];
      if (sheet.attached && sheet.options.insertionPoint === options.insertionPoint) {
        return sheet;
      }
    }
    return null;
  }

  /**
   * Find a comment with "jss" inside.
   */
  function findCommentNode(text) {
    var head = getHead();
    for (var i = 0; i < head.childNodes.length; i++) {
      var node = head.childNodes[i];
      if (node.nodeType === 8 && node.nodeValue.trim() === text) {
        return node;
      }
    }
    return null;
  }

  /**
   * Find a node before which we can insert the sheet.
   */
  function findPrevNode(options) {
    var registry = _sheets2['default'].registry;


    if (registry.length > 0) {
      // Try to insert before the next higher sheet.
      var sheet = findHigherSheet(registry, options);
      if (sheet) return sheet.renderer.element;

      // Otherwise insert after the last attached.
      sheet = findHighestSheet(registry, options);
      if (sheet) return sheet.renderer.element.nextElementSibling;
    }

    // Try to find a comment placeholder if registry is empty.
    var insertionPoint = options.insertionPoint;

    if (insertionPoint && typeof insertionPoint === 'string') {
      var comment = findCommentNode(insertionPoint);
      if (comment) return comment.nextSibling;
      // If user specifies an insertion point and it can't be found in the document -
      // bad specificity issues may appear.
      (0, _warning2['default'])(insertionPoint === 'jss', '[JSS] Insertion point "%s" not found.', insertionPoint);
    }

    return null;
  }

  /**
   * Insert style element into the DOM.
   */
  function insertStyle(style, options) {
    var insertionPoint = options.insertionPoint;

    var prevNode = findPrevNode(options);

    if (prevNode) {
      var parentNode = prevNode.parentNode;

      if (parentNode) parentNode.insertBefore(style, prevNode);
      return;
    }

    // Works with iframes and any node types.
    if (insertionPoint && typeof insertionPoint.nodeType === 'number') {
      // https://stackoverflow.com/questions/41328728/force-casting-in-flow
      var insertionPointElement = insertionPoint;
      var _parentNode = insertionPointElement.parentNode;

      if (_parentNode) _parentNode.insertBefore(style, insertionPointElement.nextSibling);else (0, _warning2['default'])(false, '[JSS] Insertion point is not in the DOM.');
      return;
    }

    getHead().insertBefore(style, prevNode);
  }

  /**
   * Read jss nonce setting from the page if the user has set it.
   */
  var getNonce = memoize(function () {
    var node = document.querySelector('meta[property="csp-nonce"]');
    return node ? node.getAttribute('content') : null;
  });

  var DomRenderer = function () {
    function DomRenderer(sheet) {
      _classCallCheck(this, DomRenderer);

      this.getPropertyValue = getPropertyValue;
      this.setProperty = setProperty;
      this.removeProperty = removeProperty;
      this.setSelector = setSelector;
      this.getKey = getKey;
      this.getUnescapedKeysMap = getUnescapedKeysMap;
      this.hasInsertedRules = false;

      // There is no sheet when the renderer is used from a standalone StyleRule.
      if (sheet) _sheets2['default'].add(sheet);

      this.sheet = sheet;

      var _ref = this.sheet ? this.sheet.options : {},
          media = _ref.media,
          meta = _ref.meta,
          element = _ref.element;

      this.element = element || document.createElement('style');
      this.element.setAttribute('data-jss', '');
      if (media) this.element.setAttribute('media', media);
      if (meta) this.element.setAttribute('data-meta', meta);
      var nonce = getNonce();
      if (nonce) this.element.setAttribute('nonce', nonce);
    }

    /**
     * Insert style element into render tree.
     */


    // HTMLStyleElement needs fixing https://github.com/facebook/flow/issues/2696


    _createClass(DomRenderer, [{
      key: 'attach',
      value: function attach() {
        // In the case the element node is external and it is already in the DOM.
        if (this.element.parentNode || !this.sheet) return;

        // When rules are inserted using `insertRule` API, after `sheet.detach().attach()`
        // browsers remove those rules.
        // TODO figure out if its a bug and if it is known.
        // Workaround is to redeploy the sheet before attaching as a string.
        if (this.hasInsertedRules) {
          this.deploy();
          this.hasInsertedRules = false;
        }

        insertStyle(this.element, this.sheet.options);
      }

      /**
       * Remove style element from render tree.
       */

    }, {
      key: 'detach',
      value: function detach() {
        this.element.parentNode.removeChild(this.element);
      }

      /**
       * Inject CSS string into element.
       */

    }, {
      key: 'deploy',
      value: function deploy() {
        if (!this.sheet) return;
        this.element.textContent = '\n' + this.sheet.toString() + '\n';
      }

      /**
       * Insert a rule into element.
       */

    }, {
      key: 'insertRule',
      value: function insertRule(rule, index) {
        var sheet = this.element.sheet;
        var cssRules = sheet.cssRules;

        var str = rule.toString();
        if (!index) index = cssRules.length;

        if (!str) return false;

        try {
          sheet.insertRule(str, index);
        } catch (err) {
          (0, _warning2['default'])(false, '[JSS] Can not insert an unsupported rule \n\r%s', rule);
          return false;
        }
        this.hasInsertedRules = true;

        return cssRules[index];
      }

      /**
       * Delete a rule.
       */

    }, {
      key: 'deleteRule',
      value: function deleteRule(cssRule) {
        var sheet = this.element.sheet;

        var index = this.indexOf(cssRule);
        if (index === -1) return false;
        sheet.deleteRule(index);
        return true;
      }

      /**
       * Get index of a CSS Rule.
       */

    }, {
      key: 'indexOf',
      value: function indexOf(cssRule) {
        var cssRules = this.element.sheet.cssRules;

        for (var _index = 0; _index < cssRules.length; _index++) {
          if (cssRule === cssRules[_index]) return _index;
        }
        return -1;
      }

      /**
       * Generate a new CSS rule and replace the existing one.
       */

    }, {
      key: 'replaceRule',
      value: function replaceRule(cssRule, rule) {
        var index = this.indexOf(cssRule);
        var newCssRule = this.insertRule(rule, index);
        this.element.sheet.deleteRule(index);
        return newCssRule;
      }

      /**
       * Get all rules elements.
       */

    }, {
      key: 'getRules',
      value: function getRules() {
        return this.element.sheet.cssRules;
      }
    }]);

    return DomRenderer;
  }();

  exports['default'] = DomRenderer;
  });

  unwrapExports(DomRenderer_1);

  var VirtualRenderer_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  /* eslint-disable class-methods-use-this */

  /**
   * Rendering backend to do nothing in nodejs.
   */
  var VirtualRenderer = function () {
    function VirtualRenderer() {
      _classCallCheck(this, VirtualRenderer);
    }

    _createClass(VirtualRenderer, [{
      key: 'setProperty',
      value: function setProperty() {
        return true;
      }
    }, {
      key: 'getPropertyValue',
      value: function getPropertyValue() {
        return '';
      }
    }, {
      key: 'removeProperty',
      value: function removeProperty() {}
    }, {
      key: 'setSelector',
      value: function setSelector() {
        return true;
      }
    }, {
      key: 'getKey',
      value: function getKey() {
        return '';
      }
    }, {
      key: 'attach',
      value: function attach() {}
    }, {
      key: 'detach',
      value: function detach() {}
    }, {
      key: 'deploy',
      value: function deploy() {}
    }, {
      key: 'insertRule',
      value: function insertRule() {
        return false;
      }
    }, {
      key: 'deleteRule',
      value: function deleteRule() {
        return true;
      }
    }, {
      key: 'replaceRule',
      value: function replaceRule() {
        return false;
      }
    }, {
      key: 'getRules',
      value: function getRules() {}
    }, {
      key: 'indexOf',
      value: function indexOf() {
        return -1;
      }
    }]);

    return VirtualRenderer;
  }();

  exports['default'] = VirtualRenderer;
  });

  unwrapExports(VirtualRenderer_1);

  var Jss_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();



  var _isInBrowser2 = _interopRequireDefault(isBrowser);



  var _StyleSheet2 = _interopRequireDefault(StyleSheet_1);



  var _PluginsRegistry2 = _interopRequireDefault(PluginsRegistry_1);



  var _rules2 = _interopRequireDefault(rules);



  var _observables2 = _interopRequireDefault(observables);



  var _functions2 = _interopRequireDefault(functions);



  var _sheets2 = _interopRequireDefault(sheets);



  var _StyleRule2 = _interopRequireDefault(StyleRule_1);



  var _createGenerateClassName2 = _interopRequireDefault(createGenerateClassName$1);



  var _createRule3 = _interopRequireDefault(createRule_1);



  var _DomRenderer2 = _interopRequireDefault(DomRenderer_1);



  var _VirtualRenderer2 = _interopRequireDefault(VirtualRenderer_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var defaultPlugins = _rules2['default'].concat([_observables2['default'], _functions2['default']]);

  var instanceCounter = 0;

  var Jss = function () {
    function Jss(options) {
      _classCallCheck(this, Jss);

      this.id = instanceCounter++;
      this.version = "9.8.7";
      this.plugins = new _PluginsRegistry2['default']();
      this.options = {
        createGenerateClassName: _createGenerateClassName2['default'],
        Renderer: _isInBrowser2['default'] ? _DomRenderer2['default'] : _VirtualRenderer2['default'],
        plugins: []
      };
      this.generateClassName = (0, _createGenerateClassName2['default'])();

      // eslint-disable-next-line prefer-spread
      this.use.apply(this, defaultPlugins);
      this.setup(options);
    }

    _createClass(Jss, [{
      key: 'setup',
      value: function setup() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        if (options.createGenerateClassName) {
          this.options.createGenerateClassName = options.createGenerateClassName;
          // $FlowFixMe
          this.generateClassName = options.createGenerateClassName();
        }

        if (options.insertionPoint != null) this.options.insertionPoint = options.insertionPoint;
        if (options.virtual || options.Renderer) {
          this.options.Renderer = options.Renderer || (options.virtual ? _VirtualRenderer2['default'] : _DomRenderer2['default']);
        }

        // eslint-disable-next-line prefer-spread
        if (options.plugins) this.use.apply(this, options.plugins);

        return this;
      }

      /**
       * Create a Style Sheet.
       */

    }, {
      key: 'createStyleSheet',
      value: function createStyleSheet(styles) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        var index = options.index;
        if (typeof index !== 'number') {
          index = _sheets2['default'].index === 0 ? 0 : _sheets2['default'].index + 1;
        }
        var sheet = new _StyleSheet2['default'](styles, _extends({}, options, {
          jss: this,
          generateClassName: options.generateClassName || this.generateClassName,
          insertionPoint: this.options.insertionPoint,
          Renderer: this.options.Renderer,
          index: index
        }));
        this.plugins.onProcessSheet(sheet);

        return sheet;
      }

      /**
       * Detach the Style Sheet and remove it from the registry.
       */

    }, {
      key: 'removeStyleSheet',
      value: function removeStyleSheet(sheet) {
        sheet.detach();
        _sheets2['default'].remove(sheet);
        return this;
      }

      /**
       * Create a rule without a Style Sheet.
       */

    }, {
      key: 'createRule',
      value: function createRule(name) {
        var style = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        // Enable rule without name for inline styles.
        if ((typeof name === 'undefined' ? 'undefined' : _typeof(name)) === 'object') {
          options = style;
          style = name;
          name = undefined;
        }

        // Cast from RuleFactoryOptions to RuleOptions
        // https://stackoverflow.com/questions/41328728/force-casting-in-flow
        var ruleOptions = options;

        ruleOptions.jss = this;
        ruleOptions.Renderer = this.options.Renderer;
        if (!ruleOptions.generateClassName) ruleOptions.generateClassName = this.generateClassName;
        if (!ruleOptions.classes) ruleOptions.classes = {};
        var rule = (0, _createRule3['default'])(name, style, ruleOptions);

        if (!ruleOptions.selector && rule instanceof _StyleRule2['default']) {
          rule.selector = '.' + ruleOptions.generateClassName(rule);
        }

        this.plugins.onProcessRule(rule);

        return rule;
      }

      /**
       * Register plugin. Passed function will be invoked with a rule instance.
       */

    }, {
      key: 'use',
      value: function use() {
        var _this = this;

        for (var _len = arguments.length, plugins = Array(_len), _key = 0; _key < _len; _key++) {
          plugins[_key] = arguments[_key];
        }

        plugins.forEach(function (plugin) {
          // Avoids applying same plugin twice, at least based on ref.
          if (_this.options.plugins.indexOf(plugin) === -1) {
            _this.options.plugins.push(plugin);
            _this.plugins.use(plugin);
          }
        });

        return this;
      }
    }]);

    return Jss;
  }();

  exports['default'] = Jss;
  });

  unwrapExports(Jss_1);

  var lib = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.create = exports.createGenerateClassName = exports.sheets = exports.RuleList = exports.SheetsManager = exports.SheetsRegistry = exports.toCssValue = exports.getDynamicStyles = undefined;



  Object.defineProperty(exports, 'getDynamicStyles', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(getDynamicStyles_1)['default'];
    }
  });



  Object.defineProperty(exports, 'toCssValue', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(toCssValue_1)['default'];
    }
  });



  Object.defineProperty(exports, 'SheetsRegistry', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(SheetsRegistry_1)['default'];
    }
  });



  Object.defineProperty(exports, 'SheetsManager', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(SheetsManager_1)['default'];
    }
  });



  Object.defineProperty(exports, 'RuleList', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(RuleList_1)['default'];
    }
  });



  Object.defineProperty(exports, 'sheets', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(sheets)['default'];
    }
  });



  Object.defineProperty(exports, 'createGenerateClassName', {
    enumerable: true,
    get: function get() {
      return _interopRequireDefault(createGenerateClassName$1)['default'];
    }
  });



  var _Jss2 = _interopRequireDefault(Jss_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * Creates a new instance of Jss.
   */
  var create = exports.create = function create(options) {
    return new _Jss2['default'](options);
  };

  /**
   * A global Jss instance.
   */
  exports['default'] = create();
  });

  unwrapExports(lib);
  var lib_1 = lib.create;
  var lib_2 = lib.createGenerateClassName;
  var lib_3 = lib.sheets;
  var lib_4 = lib.RuleList;
  var lib_5 = lib.SheetsManager;
  var lib_6 = lib.SheetsRegistry;
  var lib_7 = lib.toCssValue;
  var lib_8 = lib.getDynamicStyles;

  var lib$1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

  exports['default'] = jssGlobal;



  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  var propKey = '@global';
  var prefixKey = '@global ';

  var GlobalContainerRule = function () {
    function GlobalContainerRule(key, styles, options) {
      _classCallCheck(this, GlobalContainerRule);

      this.type = 'global';

      this.key = key;
      this.options = options;
      this.rules = new lib.RuleList(_extends({}, options, {
        parent: this
      }));

      for (var selector in styles) {
        this.rules.add(selector, styles[selector], { selector: selector });
      }

      this.rules.process();
    }

    /**
     * Get a rule.
     */


    _createClass(GlobalContainerRule, [{
      key: 'getRule',
      value: function getRule(name) {
        return this.rules.get(name);
      }

      /**
       * Create and register rule, run plugins.
       */

    }, {
      key: 'addRule',
      value: function addRule(name, style, options) {
        var rule = this.rules.add(name, style, options);
        this.options.jss.plugins.onProcessRule(rule);
        return rule;
      }

      /**
       * Get index of a rule.
       */

    }, {
      key: 'indexOf',
      value: function indexOf(rule) {
        return this.rules.indexOf(rule);
      }

      /**
       * Generates a CSS string.
       */

    }, {
      key: 'toString',
      value: function toString() {
        return this.rules.toString();
      }
    }]);

    return GlobalContainerRule;
  }();

  var GlobalPrefixedRule = function () {
    function GlobalPrefixedRule(name, style, options) {
      _classCallCheck(this, GlobalPrefixedRule);

      this.name = name;
      this.options = options;
      var selector = name.substr(prefixKey.length);
      this.rule = options.jss.createRule(selector, style, _extends({}, options, {
        parent: this,
        selector: selector
      }));
    }

    _createClass(GlobalPrefixedRule, [{
      key: 'toString',
      value: function toString(options) {
        return this.rule.toString(options);
      }
    }]);

    return GlobalPrefixedRule;
  }();

  var separatorRegExp = /\s*,\s*/g;

  function addScope(selector, scope) {
    var parts = selector.split(separatorRegExp);
    var scoped = '';
    for (var i = 0; i < parts.length; i++) {
      scoped += scope + ' ' + parts[i].trim();
      if (parts[i + 1]) scoped += ', ';
    }
    return scoped;
  }

  function handleNestedGlobalContainerRule(rule) {
    var options = rule.options,
        style = rule.style;

    var rules = style[propKey];

    if (!rules) return;

    for (var name in rules) {
      options.sheet.addRule(name, rules[name], _extends({}, options, {
        selector: addScope(name, rule.selector)
      }));
    }

    delete style[propKey];
  }

  function handlePrefixedGlobalRule(rule) {
    var options = rule.options,
        style = rule.style;

    for (var prop in style) {
      if (prop.substr(0, propKey.length) !== propKey) continue;

      var selector = addScope(prop.substr(propKey.length), rule.selector);
      options.sheet.addRule(selector, style[prop], _extends({}, options, {
        selector: selector
      }));
      delete style[prop];
    }
  }

  /**
   * Convert nested rules to separate, remove them from original styles.
   *
   * @param {Rule} rule
   * @api public
   */
  function jssGlobal() {
    function onCreateRule(name, styles, options) {
      if (name === propKey) {
        return new GlobalContainerRule(name, styles, options);
      }

      if (name[0] === '@' && name.substr(0, prefixKey.length) === prefixKey) {
        return new GlobalPrefixedRule(name, styles, options);
      }

      var parent = options.parent;


      if (parent) {
        if (parent.type === 'global' || parent.options.parent.type === 'global') {
          options.global = true;
        }
      }

      if (options.global) options.selector = name;

      return null;
    }

    function onProcessRule(rule) {
      if (rule.type !== 'style') return;

      handleNestedGlobalContainerRule(rule);
      handlePrefixedGlobalRule(rule);
    }

    return { onCreateRule: onCreateRule, onProcessRule: onProcessRule };
  }
  });

  var jssGlobal = unwrapExports(lib$1);

  var warning$2 = function() {};

  {
    warning$2 = function(condition, format, args) {
      var len = arguments.length;
      args = new Array(len > 2 ? len - 2 : 0);
      for (var key = 2; key < len; key++) {
        args[key - 2] = arguments[key];
      }
      if (format === undefined) {
        throw new Error(
          '`warning(condition, format, ...args)` requires a warning ' +
          'message argument'
        );
      }

      if (format.length < 10 || (/^[s\W]*$/).test(format)) {
        throw new Error(
          'The warning format should be able to uniquely identify this ' +
          'warning. Please, use a more descriptive format than: ' + format
        );
      }

      if (!condition) {
        var argIndex = 0;
        var message = 'Warning: ' +
          format.replace(/%s/g, function() {
            return args[argIndex++];
          });
        if (typeof console !== 'undefined') {
          console.error(message);
        }
        try {
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch(x) {}
      }
    };
  }

  var warning_1$2 = warning$2;

  var lib$2 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  exports.default = jssNested;



  var _warning2 = _interopRequireDefault(warning_1$2);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  var separatorRegExp = /\s*,\s*/g;
  var parentRegExp = /&/g;
  var refRegExp = /\$([\w-]+)/g;

  /**
   * Convert nested rules to separate, remove them from original styles.
   *
   * @param {Rule} rule
   * @api public
   */
  function jssNested() {
    // Get a function to be used for $ref replacement.
    function getReplaceRef(container) {
      return function (match, key) {
        var rule = container.getRule(key);
        if (rule) return rule.selector;
        (0, _warning2.default)(false, '[JSS] Could not find the referenced rule %s in %s.', key, container.options.meta || container);
        return key;
      };
    }

    var hasAnd = function hasAnd(str) {
      return str.indexOf('&') !== -1;
    };

    function replaceParentRefs(nestedProp, parentProp) {
      var parentSelectors = parentProp.split(separatorRegExp);
      var nestedSelectors = nestedProp.split(separatorRegExp);

      var result = '';

      for (var i = 0; i < parentSelectors.length; i++) {
        var parent = parentSelectors[i];

        for (var j = 0; j < nestedSelectors.length; j++) {
          var nested = nestedSelectors[j];
          if (result) result += ', ';
          // Replace all & by the parent or prefix & with the parent.
          result += hasAnd(nested) ? nested.replace(parentRegExp, parent) : parent + ' ' + nested;
        }
      }

      return result;
    }

    function getOptions(rule, container, options) {
      // Options has been already created, now we only increase index.
      if (options) return _extends({}, options, { index: options.index + 1 });

      var nestingLevel = rule.options.nestingLevel;

      nestingLevel = nestingLevel === undefined ? 1 : nestingLevel + 1;

      return _extends({}, rule.options, {
        nestingLevel: nestingLevel,
        index: container.indexOf(rule) + 1
      });
    }

    function onProcessStyle(style, rule) {
      if (rule.type !== 'style') return style;
      var container = rule.options.parent;
      var options = void 0;
      var replaceRef = void 0;
      for (var prop in style) {
        var isNested = hasAnd(prop);
        var isNestedConditional = prop[0] === '@';

        if (!isNested && !isNestedConditional) continue;

        options = getOptions(rule, container, options);

        if (isNested) {
          var selector = replaceParentRefs(prop, rule.selector
          // Lazily create the ref replacer function just once for
          // all nested rules within the sheet.
          );if (!replaceRef) replaceRef = getReplaceRef(container
          // Replace all $refs.
          );selector = selector.replace(refRegExp, replaceRef);

          container.addRule(selector, style[prop], _extends({}, options, { selector: selector }));
        } else if (isNestedConditional) {
          container
          // Place conditional right after the parent rule to ensure right ordering.
          .addRule(prop, null, options).addRule(rule.key, style[prop], { selector: rule.selector });
        }

        delete style[prop];
      }

      return style;
    }

    return { onProcessStyle: onProcessStyle };
  }
  });

  var jssNested = unwrapExports(lib$2);

  var uppercasePattern = /[A-Z]/g;
  var msPattern = /^ms-/;
  var cache = {};

  function hyphenateStyleName(string) {
      return string in cache
      ? cache[string]
      : cache[string] = string
        .replace(uppercasePattern, '-$&')
        .toLowerCase()
        .replace(msPattern, '-ms-');
  }

  var hyphenateStyleName_1 = hyphenateStyleName;

  var lib$3 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = camelCase;



  var _hyphenateStyleName2 = _interopRequireDefault(hyphenateStyleName_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * Convert camel cased property names to dash separated.
   *
   * @param {Object} style
   * @return {Object}
   */
  function convertCase(style) {
    var converted = {};

    for (var prop in style) {
      converted[(0, _hyphenateStyleName2['default'])(prop)] = style[prop];
    }

    if (style.fallbacks) {
      if (Array.isArray(style.fallbacks)) converted.fallbacks = style.fallbacks.map(convertCase);else converted.fallbacks = convertCase(style.fallbacks);
    }

    return converted;
  }

  /**
   * Allow camel cased property names by converting them back to dasherized.
   *
   * @param {Rule} rule
   */
  function camelCase() {
    function onProcessStyle(style) {
      if (Array.isArray(style)) {
        // Handle rules like @font-face, which can have multiple styles in an array
        for (var index = 0; index < style.length; index++) {
          style[index] = convertCase(style[index]);
        }
        return style;
      }

      return convertCase(style);
    }

    function onChangeValue(value, prop, rule) {
      var hyphenatedProp = (0, _hyphenateStyleName2['default'])(prop);

      // There was no camel case in place
      if (prop === hyphenatedProp) return value;

      rule.prop(hyphenatedProp, value);

      // Core will ignore that property value we set the proper one above.
      return null;
    }

    return { onProcessStyle: onProcessStyle, onChangeValue: onChangeValue };
  }
  });

  var jssCamelCase = unwrapExports(lib$3);

  var defaultUnits = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  /**
   * Generated jss-default-unit CSS property units
   *
   * @type object
   */
  exports['default'] = {
    'animation-delay': 'ms',
    'animation-duration': 'ms',
    'background-position': 'px',
    'background-position-x': 'px',
    'background-position-y': 'px',
    'background-size': 'px',
    border: 'px',
    'border-bottom': 'px',
    'border-bottom-left-radius': 'px',
    'border-bottom-right-radius': 'px',
    'border-bottom-width': 'px',
    'border-left': 'px',
    'border-left-width': 'px',
    'border-radius': 'px',
    'border-right': 'px',
    'border-right-width': 'px',
    'border-spacing': 'px',
    'border-top': 'px',
    'border-top-left-radius': 'px',
    'border-top-right-radius': 'px',
    'border-top-width': 'px',
    'border-width': 'px',
    'border-after-width': 'px',
    'border-before-width': 'px',
    'border-end-width': 'px',
    'border-horizontal-spacing': 'px',
    'border-start-width': 'px',
    'border-vertical-spacing': 'px',
    bottom: 'px',
    'box-shadow': 'px',
    'column-gap': 'px',
    'column-rule': 'px',
    'column-rule-width': 'px',
    'column-width': 'px',
    'flex-basis': 'px',
    'font-size': 'px',
    'font-size-delta': 'px',
    height: 'px',
    left: 'px',
    'letter-spacing': 'px',
    'logical-height': 'px',
    'logical-width': 'px',
    margin: 'px',
    'margin-after': 'px',
    'margin-before': 'px',
    'margin-bottom': 'px',
    'margin-left': 'px',
    'margin-right': 'px',
    'margin-top': 'px',
    'max-height': 'px',
    'max-width': 'px',
    'margin-end': 'px',
    'margin-start': 'px',
    'mask-position-x': 'px',
    'mask-position-y': 'px',
    'mask-size': 'px',
    'max-logical-height': 'px',
    'max-logical-width': 'px',
    'min-height': 'px',
    'min-width': 'px',
    'min-logical-height': 'px',
    'min-logical-width': 'px',
    motion: 'px',
    'motion-offset': 'px',
    outline: 'px',
    'outline-offset': 'px',
    'outline-width': 'px',
    padding: 'px',
    'padding-bottom': 'px',
    'padding-left': 'px',
    'padding-right': 'px',
    'padding-top': 'px',
    'padding-after': 'px',
    'padding-before': 'px',
    'padding-end': 'px',
    'padding-start': 'px',
    'perspective-origin-x': '%',
    'perspective-origin-y': '%',
    perspective: 'px',
    right: 'px',
    'shape-margin': 'px',
    size: 'px',
    'text-indent': 'px',
    'text-stroke': 'px',
    'text-stroke-width': 'px',
    top: 'px',
    'transform-origin': '%',
    'transform-origin-x': '%',
    'transform-origin-y': '%',
    'transform-origin-z': '%',
    'transition-delay': 'ms',
    'transition-duration': 'ms',
    'vertical-align': 'px',
    width: 'px',
    'word-spacing': 'px',
    // Not existing properties.
    // Used to avoid issues with jss-expand intergration.
    'box-shadow-x': 'px',
    'box-shadow-y': 'px',
    'box-shadow-blur': 'px',
    'box-shadow-spread': 'px',
    'font-line-height': 'px',
    'text-shadow-x': 'px',
    'text-shadow-y': 'px',
    'text-shadow-blur': 'px'
  };
  });

  unwrapExports(defaultUnits);

  var lib$4 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

  exports['default'] = defaultUnit;



  var _defaultUnits2 = _interopRequireDefault(defaultUnits);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  /**
   * Clones the object and adds a camel cased property version.
   */
  function addCamelCasedVersion(obj) {
    var regExp = /(-[a-z])/g;
    var replace = function replace(str) {
      return str[1].toUpperCase();
    };
    var newObj = {};
    for (var key in obj) {
      newObj[key] = obj[key];
      newObj[key.replace(regExp, replace)] = obj[key];
    }
    return newObj;
  }

  var units = addCamelCasedVersion(_defaultUnits2['default']);

  /**
   * Recursive deep style passing function
   *
   * @param {String} current property
   * @param {(Object|Array|Number|String)} property value
   * @param {Object} options
   * @return {(Object|Array|Number|String)} resulting value
   */
  function iterate(prop, value, options) {
    if (!value) return value;

    var convertedValue = value;

    var type = typeof value === 'undefined' ? 'undefined' : _typeof(value);
    if (type === 'object' && Array.isArray(value)) type = 'array';

    switch (type) {
      case 'object':
        if (prop === 'fallbacks') {
          for (var innerProp in value) {
            value[innerProp] = iterate(innerProp, value[innerProp], options);
          }
          break;
        }
        for (var _innerProp in value) {
          value[_innerProp] = iterate(prop + '-' + _innerProp, value[_innerProp], options);
        }
        break;
      case 'array':
        for (var i = 0; i < value.length; i++) {
          value[i] = iterate(prop, value[i], options);
        }
        break;
      case 'number':
        if (value !== 0) {
          convertedValue = value + (options[prop] || units[prop] || '');
        }
        break;
      default:
        break;
    }

    return convertedValue;
  }

  /**
   * Add unit to numeric values.
   */
  function defaultUnit() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var camelCasedOptions = addCamelCasedVersion(options);

    function onProcessStyle(style, rule) {
      if (rule.type !== 'style') return style;

      for (var prop in style) {
        style[prop] = iterate(prop, style[prop], camelCasedOptions);
      }

      return style;
    }

    function onChangeValue(value, prop) {
      return iterate(prop, value, camelCasedOptions);
    }

    return { onProcessStyle: onProcessStyle, onChangeValue: onChangeValue };
  }
  });

  var jssDefaultUnit = unwrapExports(lib$4);

  var prefix = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });



  var _isInBrowser2 = _interopRequireDefault(isBrowser);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var js = ''; /**
                * Export javascript style and css style vendor prefixes.
                * Based on "transform" support test.
                */

  var css = '';

  // We should not do anything if required serverside.
  if (_isInBrowser2['default']) {
    // Order matters. We need to check Webkit the last one because
    // other vendors use to add Webkit prefixes to some properties
    var jsCssMap = {
      Moz: '-moz-',
      // IE did it wrong again ...
      ms: '-ms-',
      O: '-o-',
      Webkit: '-webkit-'
    };
    var style = document.createElement('p').style;
    var testProp = 'Transform';

    for (var key in jsCssMap) {
      if (key + testProp in style) {
        js = key;
        css = jsCssMap[key];
        break;
      }
    }
  }

  /**
   * Vendor prefix string for the current browser.
   *
   * @type {{js: String, css: String}}
   * @api public
   */
  exports['default'] = { js: js, css: css };
  });

  unwrapExports(prefix);

  var camelize_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = camelize;
  var regExp = /[-\s]+(.)?/g;

  /**
   * Convert dash separated strings to camel cased.
   *
   * @param {String} str
   * @return {String}
   */
  function camelize(str) {
    return str.replace(regExp, toUpper);
  }

  function toUpper(match, c) {
    return c ? c.toUpperCase() : '';
  }
  });

  unwrapExports(camelize_1);

  var supportedProperty_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = supportedProperty;



  var _isInBrowser2 = _interopRequireDefault(isBrowser);



  var _prefix2 = _interopRequireDefault(prefix);



  var _camelize2 = _interopRequireDefault(camelize_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var el = void 0;
  var cache = {};

  if (_isInBrowser2['default']) {
    el = document.createElement('p');

    /**
     * We test every property on vendor prefix requirement.
     * Once tested, result is cached. It gives us up to 70% perf boost.
     * http://jsperf.com/element-style-object-access-vs-plain-object
     *
     * Prefill cache with known css properties to reduce amount of
     * properties we need to feature test at runtime.
     * http://davidwalsh.name/vendor-prefix
     */
    var computed = window.getComputedStyle(document.documentElement, '');
    for (var key in computed) {
      if (!isNaN(key)) cache[computed[key]] = computed[key];
    }
  }

  /**
   * Test if a property is supported, returns supported property with vendor
   * prefix if required. Returns `false` if not supported.
   *
   * @param {String} prop dash separated
   * @return {String|Boolean}
   * @api public
   */
  function supportedProperty(prop) {
    // For server-side rendering.
    if (!el) return prop;

    // We have not tested this prop yet, lets do the test.
    if (cache[prop] != null) return cache[prop];

    // Camelization is required because we can't test using
    // css syntax for e.g. in FF.
    // Test if property is supported as it is.
    if ((0, _camelize2['default'])(prop) in el.style) {
      cache[prop] = prop;
    }
    // Test if property is supported with vendor prefix.
    else if (_prefix2['default'].js + (0, _camelize2['default'])('-' + prop) in el.style) {
        cache[prop] = _prefix2['default'].css + prop;
      } else {
        cache[prop] = false;
      }

    return cache[prop];
  }
  });

  unwrapExports(supportedProperty_1);

  var supportedValue_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = supportedValue;



  var _isInBrowser2 = _interopRequireDefault(isBrowser);



  var _prefix2 = _interopRequireDefault(prefix);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  var cache = {};
  var el = void 0;

  if (_isInBrowser2['default']) el = document.createElement('p');

  /**
   * Returns prefixed value if needed. Returns `false` if value is not supported.
   *
   * @param {String} property
   * @param {String} value
   * @return {String|Boolean}
   * @api public
   */
  function supportedValue(property, value) {
    // For server-side rendering.
    if (!el) return value;

    // It is a string or a number as a string like '1'.
    // We want only prefixable values here.
    if (typeof value !== 'string' || !isNaN(parseInt(value, 10))) return value;

    var cacheKey = property + value;

    if (cache[cacheKey] != null) return cache[cacheKey];

    // IE can even throw an error in some cases, for e.g. style.content = 'bar'
    try {
      // Test value as it is.
      el.style[property] = value;
    } catch (err) {
      cache[cacheKey] = false;
      return false;
    }

    // Value is supported as it is.
    if (el.style[property] !== '') {
      cache[cacheKey] = value;
    } else {
      // Test value with vendor prefix.
      value = _prefix2['default'].css + value;

      // Hardcode test to convert "flex" to "-ms-flexbox" for IE10.
      if (value === '-ms-flex') value = '-ms-flexbox';

      el.style[property] = value;

      // Value is supported with vendor prefix.
      if (el.style[property] !== '') cache[cacheKey] = value;
    }

    if (!cache[cacheKey]) cache[cacheKey] = false;

    // Reset style value.
    el.style[property] = '';

    return cache[cacheKey];
  }
  });

  unwrapExports(supportedValue_1);

  var lib$5 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.supportedValue = exports.supportedProperty = exports.prefix = undefined;



  var _prefix2 = _interopRequireDefault(prefix);



  var _supportedProperty2 = _interopRequireDefault(supportedProperty_1);



  var _supportedValue2 = _interopRequireDefault(supportedValue_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

  exports['default'] = {
    prefix: _prefix2['default'],
    supportedProperty: _supportedProperty2['default'],
    supportedValue: _supportedValue2['default']
  }; /**
      * CSS Vendor prefix detection and property feature testing.
      *
      * @copyright Oleg Slobodskoi 2015
      * @website https://github.com/jsstyles/css-vendor
      * @license MIT
      */

  exports.prefix = _prefix2['default'];
  exports.supportedProperty = _supportedProperty2['default'];
  exports.supportedValue = _supportedValue2['default'];
  });

  unwrapExports(lib$5);
  var lib_1$1 = lib$5.supportedValue;
  var lib_2$1 = lib$5.supportedProperty;
  var lib_3$1 = lib$5.prefix;

  var lib$6 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = jssVendorPrefixer;



  var vendor = _interopRequireWildcard(lib$5);

  function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

  /**
   * Add vendor prefix to a property name when needed.
   *
   * @param {Rule} rule
   * @api public
   */
  function jssVendorPrefixer() {
    function onProcessRule(rule) {
      if (rule.type === 'keyframes') {
        rule.key = '@' + vendor.prefix.css + rule.key.substr(1);
      }
    }

    function onProcessStyle(style, rule) {
      if (rule.type !== 'style') return style;

      for (var prop in style) {
        var value = style[prop];

        var changeProp = false;
        var supportedProp = vendor.supportedProperty(prop);
        if (supportedProp && supportedProp !== prop) changeProp = true;

        var changeValue = false;
        var supportedValue = vendor.supportedValue(supportedProp, value);
        if (supportedValue && supportedValue !== value) changeValue = true;

        if (changeProp || changeValue) {
          if (changeProp) delete style[prop];
          style[supportedProp || prop] = supportedValue || value;
        }
      }

      return style;
    }

    function onChangeValue(value, prop) {
      return vendor.supportedValue(prop, value);
    }

    return { onProcessRule: onProcessRule, onProcessStyle: onProcessStyle, onChangeValue: onChangeValue };
  }
  });

  var jssVendorPrefixer = unwrapExports(lib$6);

  var lib$7 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports['default'] = jssPropsSort;
  /**
   * Sort props by length.
   */
  function jssPropsSort() {
    function sort(prop0, prop1) {
      return prop0.length - prop1.length;
    }

    function onProcessStyle(style, rule) {
      if (rule.type !== 'style') return style;

      var newStyle = {};
      var props = Object.keys(style).sort(sort);
      for (var prop in props) {
        newStyle[props[prop]] = style[props[prop]];
      }
      return newStyle;
    }

    return { onProcessStyle: onProcessStyle };
  }
  });

  var jssPropsSort = unwrapExports(lib$7);

  function jssPreset() {
    return {
      plugins: [jssGlobal(), jssNested(), jssCamelCase(), jssDefaultUnit(), // Disable the vendor prefixer server-side, it does nothing.
      // This way, we can get a performance boost.
      // In the documentation, we are using `autoprefixer` to solve this problem.
      typeof window === 'undefined' ? null : jssVendorPrefixer(), jssPropsSort()]
    };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  var classCallCheck = _classCallCheck;

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  var createClass = _createClass;

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  var assertThisInitialized = _assertThisInitialized;

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof_1(call) === "object" || typeof call === "function")) {
      return call;
    }

    return assertThisInitialized(self);
  }

  var possibleConstructorReturn = _possibleConstructorReturn;

  var getPrototypeOf = createCommonjsModule(function (module) {
  function _getPrototypeOf(o) {
    module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  module.exports = _getPrototypeOf;
  });

  var setPrototypeOf = createCommonjsModule(function (module) {
  function _setPrototypeOf(o, p) {
    module.exports = _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  module.exports = _setPrototypeOf;
  });

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) setPrototypeOf(subClass, superClass);
  }

  var inherits = _inherits;

  /*
  object-assign
  (c) Sindre Sorhus
  @license MIT
  */
  /* eslint-disable no-unused-vars */
  var getOwnPropertySymbols = Object.getOwnPropertySymbols;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var propIsEnumerable = Object.prototype.propertyIsEnumerable;

  function toObject(val) {
  	if (val === null || val === undefined) {
  		throw new TypeError('Object.assign cannot be called with null or undefined');
  	}

  	return Object(val);
  }

  function shouldUseNative() {
  	try {
  		if (!Object.assign) {
  			return false;
  		}

  		// Detect buggy property enumeration order in older V8 versions.

  		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
  		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
  		test1[5] = 'de';
  		if (Object.getOwnPropertyNames(test1)[0] === '5') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test2 = {};
  		for (var i = 0; i < 10; i++) {
  			test2['_' + String.fromCharCode(i)] = i;
  		}
  		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
  			return test2[n];
  		});
  		if (order2.join('') !== '0123456789') {
  			return false;
  		}

  		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
  		var test3 = {};
  		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
  			test3[letter] = letter;
  		});
  		if (Object.keys(Object.assign({}, test3)).join('') !==
  				'abcdefghijklmnopqrst') {
  			return false;
  		}

  		return true;
  	} catch (err) {
  		// We don't expect any of the above to throw, but better to be safe.
  		return false;
  	}
  }

  var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
  	var from;
  	var to = toObject(target);
  	var symbols;

  	for (var s = 1; s < arguments.length; s++) {
  		from = Object(arguments[s]);

  		for (var key in from) {
  			if (hasOwnProperty.call(from, key)) {
  				to[key] = from[key];
  			}
  		}

  		if (getOwnPropertySymbols) {
  			symbols = getOwnPropertySymbols(from);
  			for (var i = 0; i < symbols.length; i++) {
  				if (propIsEnumerable.call(from, symbols[i])) {
  					to[symbols[i]] = from[symbols[i]];
  				}
  			}
  		}
  	}

  	return to;
  };

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

  var ReactPropTypesSecret_1 = ReactPropTypesSecret;

  var printWarning$1 = function() {};

  {
    var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;
    var loggedTypeFailures = {};

    printWarning$1 = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };
  }

  /**
   * Assert that the values match with the type specs.
   * Error messages are memorized and will only be shown once.
   *
   * @param {object} typeSpecs Map of name to a ReactPropType
   * @param {object} values Runtime values that need to be type-checked
   * @param {string} location e.g. "prop", "context", "child context"
   * @param {string} componentName Name of the component for error messages.
   * @param {?Function} getStack Returns the component stack.
   * @private
   */
  function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
    {
      for (var typeSpecName in typeSpecs) {
        if (typeSpecs.hasOwnProperty(typeSpecName)) {
          var error;
          // Prop type validation may throw. In case they do, we don't want to
          // fail the render phase where it didn't fail before. So we log it.
          // After these have been cleaned up, we'll let them throw.
          try {
            // This is intentionally an invariant that gets caught. It's the same
            // behavior as without this statement except with a better message.
            if (typeof typeSpecs[typeSpecName] !== 'function') {
              var err = Error(
                (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
                'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
              );
              err.name = 'Invariant Violation';
              throw err;
            }
            error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$1);
          } catch (ex) {
            error = ex;
          }
          if (error && !(error instanceof Error)) {
            printWarning$1(
              (componentName || 'React class') + ': type specification of ' +
              location + ' `' + typeSpecName + '` is invalid; the type checker ' +
              'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
              'You may have forgotten to pass an argument to the type checker ' +
              'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
              'shape all require an argument).'
            );

          }
          if (error instanceof Error && !(error.message in loggedTypeFailures)) {
            // Only monitor this failure once because there tends to be a lot of the
            // same error.
            loggedTypeFailures[error.message] = true;

            var stack = getStack ? getStack() : '';

            printWarning$1(
              'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
            );
          }
        }
      }
    }
  }

  var checkPropTypes_1 = checkPropTypes;

  var printWarning$2 = function() {};

  {
    printWarning$2 = function(text) {
      var message = 'Warning: ' + text;
      if (typeof console !== 'undefined') {
        console.error(message);
      }
      try {
        // --- Welcome to debugging React ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
      } catch (x) {}
    };
  }

  function emptyFunctionThatReturnsNull() {
    return null;
  }

  var factoryWithTypeCheckers = function(isValidElement, throwOnDirectAccess) {
    /* global Symbol */
    var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
    var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

    /**
     * Returns the iterator method function contained on the iterable object.
     *
     * Be sure to invoke the function with the iterable as context:
     *
     *     var iteratorFn = getIteratorFn(myIterable);
     *     if (iteratorFn) {
     *       var iterator = iteratorFn.call(myIterable);
     *       ...
     *     }
     *
     * @param {?object} maybeIterable
     * @return {?function}
     */
    function getIteratorFn(maybeIterable) {
      var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
      if (typeof iteratorFn === 'function') {
        return iteratorFn;
      }
    }

    /**
     * Collection of methods that allow declaration and validation of props that are
     * supplied to React components. Example usage:
     *
     *   var Props = require('ReactPropTypes');
     *   var MyArticle = React.createClass({
     *     propTypes: {
     *       // An optional string prop named "description".
     *       description: Props.string,
     *
     *       // A required enum prop named "category".
     *       category: Props.oneOf(['News','Photos']).isRequired,
     *
     *       // A prop named "dialog" that requires an instance of Dialog.
     *       dialog: Props.instanceOf(Dialog).isRequired
     *     },
     *     render: function() { ... }
     *   });
     *
     * A more formal specification of how these methods are used:
     *
     *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
     *   decl := ReactPropTypes.{type}(.isRequired)?
     *
     * Each and every declaration produces a function with the same signature. This
     * allows the creation of custom validation functions. For example:
     *
     *  var MyLink = React.createClass({
     *    propTypes: {
     *      // An optional string or URI prop named "href".
     *      href: function(props, propName, componentName) {
     *        var propValue = props[propName];
     *        if (propValue != null && typeof propValue !== 'string' &&
     *            !(propValue instanceof URI)) {
     *          return new Error(
     *            'Expected a string or an URI for ' + propName + ' in ' +
     *            componentName
     *          );
     *        }
     *      }
     *    },
     *    render: function() {...}
     *  });
     *
     * @internal
     */

    var ANONYMOUS = '<<anonymous>>';

    // Important!
    // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
    var ReactPropTypes = {
      array: createPrimitiveTypeChecker('array'),
      bool: createPrimitiveTypeChecker('boolean'),
      func: createPrimitiveTypeChecker('function'),
      number: createPrimitiveTypeChecker('number'),
      object: createPrimitiveTypeChecker('object'),
      string: createPrimitiveTypeChecker('string'),
      symbol: createPrimitiveTypeChecker('symbol'),

      any: createAnyTypeChecker(),
      arrayOf: createArrayOfTypeChecker,
      element: createElementTypeChecker(),
      instanceOf: createInstanceTypeChecker,
      node: createNodeChecker(),
      objectOf: createObjectOfTypeChecker,
      oneOf: createEnumTypeChecker,
      oneOfType: createUnionTypeChecker,
      shape: createShapeTypeChecker,
      exact: createStrictShapeTypeChecker,
    };

    /**
     * inlined Object.is polyfill to avoid requiring consumers ship their own
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
     */
    /*eslint-disable no-self-compare*/
    function is(x, y) {
      // SameValue algorithm
      if (x === y) {
        // Steps 1-5, 7-10
        // Steps 6.b-6.e: +0 != -0
        return x !== 0 || 1 / x === 1 / y;
      } else {
        // Step 6.a: NaN == NaN
        return x !== x && y !== y;
      }
    }
    /*eslint-enable no-self-compare*/

    /**
     * We use an Error-like object for backward compatibility as people may call
     * PropTypes directly and inspect their output. However, we don't use real
     * Errors anymore. We don't inspect their stack anyway, and creating them
     * is prohibitively expensive if they are created too often, such as what
     * happens in oneOfType() for any type before the one that matched.
     */
    function PropTypeError(message) {
      this.message = message;
      this.stack = '';
    }
    // Make `instanceof Error` still work for returned errors.
    PropTypeError.prototype = Error.prototype;

    function createChainableTypeChecker(validate) {
      {
        var manualPropTypeCallCache = {};
        var manualPropTypeWarningCount = 0;
      }
      function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
        componentName = componentName || ANONYMOUS;
        propFullName = propFullName || propName;

        if (secret !== ReactPropTypesSecret_1) {
          if (throwOnDirectAccess) {
            // New behavior only for users of `prop-types` package
            var err = new Error(
              'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
              'Use `PropTypes.checkPropTypes()` to call them. ' +
              'Read more at http://fb.me/use-check-prop-types'
            );
            err.name = 'Invariant Violation';
            throw err;
          } else if (typeof console !== 'undefined') {
            // Old behavior for people using React.PropTypes
            var cacheKey = componentName + ':' + propName;
            if (
              !manualPropTypeCallCache[cacheKey] &&
              // Avoid spamming the console because they are often not actionable except for lib authors
              manualPropTypeWarningCount < 3
            ) {
              printWarning$2(
                'You are manually calling a React.PropTypes validation ' +
                'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
                'and will throw in the standalone `prop-types` package. ' +
                'You may be seeing this warning due to a third-party PropTypes ' +
                'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
              );
              manualPropTypeCallCache[cacheKey] = true;
              manualPropTypeWarningCount++;
            }
          }
        }
        if (props[propName] == null) {
          if (isRequired) {
            if (props[propName] === null) {
              return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
            }
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
          }
          return null;
        } else {
          return validate(props, propName, componentName, location, propFullName);
        }
      }

      var chainedCheckType = checkType.bind(null, false);
      chainedCheckType.isRequired = checkType.bind(null, true);

      return chainedCheckType;
    }

    function createPrimitiveTypeChecker(expectedType) {
      function validate(props, propName, componentName, location, propFullName, secret) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== expectedType) {
          // `propValue` being instance of, say, date/regexp, pass the 'object'
          // check, but we can offer a more precise error message here rather than
          // 'of type `object`'.
          var preciseType = getPreciseType(propValue);

          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createAnyTypeChecker() {
      return createChainableTypeChecker(emptyFunctionThatReturnsNull);
    }

    function createArrayOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
        }
        var propValue = props[propName];
        if (!Array.isArray(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
        }
        for (var i = 0; i < propValue.length; i++) {
          var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
          if (error instanceof Error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createElementTypeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        if (!isValidElement(propValue)) {
          var propType = getPropType(propValue);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createInstanceTypeChecker(expectedClass) {
      function validate(props, propName, componentName, location, propFullName) {
        if (!(props[propName] instanceof expectedClass)) {
          var expectedClassName = expectedClass.name || ANONYMOUS;
          var actualClassName = getClassName(props[propName]);
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createEnumTypeChecker(expectedValues) {
      if (!Array.isArray(expectedValues)) {
        printWarning$2('Invalid argument supplied to oneOf, expected an instance of array.');
        return emptyFunctionThatReturnsNull;
      }

      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        for (var i = 0; i < expectedValues.length; i++) {
          if (is(propValue, expectedValues[i])) {
            return null;
          }
        }

        var valuesString = JSON.stringify(expectedValues);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + propValue + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createObjectOfTypeChecker(typeChecker) {
      function validate(props, propName, componentName, location, propFullName) {
        if (typeof typeChecker !== 'function') {
          return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
        }
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
        }
        for (var key in propValue) {
          if (propValue.hasOwnProperty(key)) {
            var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
            if (error instanceof Error) {
              return error;
            }
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createUnionTypeChecker(arrayOfTypeCheckers) {
      if (!Array.isArray(arrayOfTypeCheckers)) {
        printWarning$2('Invalid argument supplied to oneOfType, expected an instance of array.');
        return emptyFunctionThatReturnsNull;
      }

      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (typeof checker !== 'function') {
          printWarning$2(
            'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
            'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
          );
          return emptyFunctionThatReturnsNull;
        }
      }

      function validate(props, propName, componentName, location, propFullName) {
        for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
          var checker = arrayOfTypeCheckers[i];
          if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1) == null) {
            return null;
          }
        }

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
      }
      return createChainableTypeChecker(validate);
    }

    function createNodeChecker() {
      function validate(props, propName, componentName, location, propFullName) {
        if (!isNode(props[propName])) {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        for (var key in shapeTypes) {
          var checker = shapeTypes[key];
          if (!checker) {
            continue;
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error) {
            return error;
          }
        }
        return null;
      }
      return createChainableTypeChecker(validate);
    }

    function createStrictShapeTypeChecker(shapeTypes) {
      function validate(props, propName, componentName, location, propFullName) {
        var propValue = props[propName];
        var propType = getPropType(propValue);
        if (propType !== 'object') {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
        }
        // We need to check all keys in case some are required but missing from
        // props.
        var allKeys = objectAssign({}, props[propName], shapeTypes);
        for (var key in allKeys) {
          var checker = shapeTypes[key];
          if (!checker) {
            return new PropTypeError(
              'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
              '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
              '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
            );
          }
          var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error) {
            return error;
          }
        }
        return null;
      }

      return createChainableTypeChecker(validate);
    }

    function isNode(propValue) {
      switch (typeof propValue) {
        case 'number':
        case 'string':
        case 'undefined':
          return true;
        case 'boolean':
          return !propValue;
        case 'object':
          if (Array.isArray(propValue)) {
            return propValue.every(isNode);
          }
          if (propValue === null || isValidElement(propValue)) {
            return true;
          }

          var iteratorFn = getIteratorFn(propValue);
          if (iteratorFn) {
            var iterator = iteratorFn.call(propValue);
            var step;
            if (iteratorFn !== propValue.entries) {
              while (!(step = iterator.next()).done) {
                if (!isNode(step.value)) {
                  return false;
                }
              }
            } else {
              // Iterator will provide entry [k,v] tuples rather than values.
              while (!(step = iterator.next()).done) {
                var entry = step.value;
                if (entry) {
                  if (!isNode(entry[1])) {
                    return false;
                  }
                }
              }
            }
          } else {
            return false;
          }

          return true;
        default:
          return false;
      }
    }

    function isSymbol(propType, propValue) {
      // Native Symbol.
      if (propType === 'symbol') {
        return true;
      }

      // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
      if (propValue['@@toStringTag'] === 'Symbol') {
        return true;
      }

      // Fallback for non-spec compliant Symbols which are polyfilled.
      if (typeof Symbol === 'function' && propValue instanceof Symbol) {
        return true;
      }

      return false;
    }

    // Equivalent of `typeof` but with special handling for array and regexp.
    function getPropType(propValue) {
      var propType = typeof propValue;
      if (Array.isArray(propValue)) {
        return 'array';
      }
      if (propValue instanceof RegExp) {
        // Old webkits (at least until Android 4.0) return 'function' rather than
        // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
        // passes PropTypes.object.
        return 'object';
      }
      if (isSymbol(propType, propValue)) {
        return 'symbol';
      }
      return propType;
    }

    // This handles more types than `getPropType`. Only used for error messages.
    // See `createPrimitiveTypeChecker`.
    function getPreciseType(propValue) {
      if (typeof propValue === 'undefined' || propValue === null) {
        return '' + propValue;
      }
      var propType = getPropType(propValue);
      if (propType === 'object') {
        if (propValue instanceof Date) {
          return 'date';
        } else if (propValue instanceof RegExp) {
          return 'regexp';
        }
      }
      return propType;
    }

    // Returns a string that is postfixed to a warning about an invalid type.
    // For example, "undefined" or "of type array"
    function getPostfixForTypeWarning(value) {
      var type = getPreciseType(value);
      switch (type) {
        case 'array':
        case 'object':
          return 'an ' + type;
        case 'boolean':
        case 'date':
        case 'regexp':
          return 'a ' + type;
        default:
          return type;
      }
    }

    // Returns class name of the object, if any.
    function getClassName(propValue) {
      if (!propValue.constructor || !propValue.constructor.name) {
        return ANONYMOUS;
      }
      return propValue.constructor.name;
    }

    ReactPropTypes.checkPropTypes = checkPropTypes_1;
    ReactPropTypes.PropTypes = ReactPropTypes;

    return ReactPropTypes;
  };

  var propTypes = createCommonjsModule(function (module) {
  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  {
    var REACT_ELEMENT_TYPE = (typeof Symbol === 'function' &&
      Symbol.for &&
      Symbol.for('react.element')) ||
      0xeac7;

    var isValidElement = function(object) {
      return typeof object === 'object' &&
        object !== null &&
        object.$$typeof === REACT_ELEMENT_TYPE;
    };

    // By explicitly using `prop-types` you are opting into new development behavior.
    // http://fb.me/prop-types-in-prod
    var throwOnDirectAccess = true;
    module.exports = factoryWithTypeCheckers(isValidElement, throwOnDirectAccess);
  }
  });

  function createBroadcast (initialState) {
    var listeners = {};
    var id = 1;
    var _state = initialState;

    function getState () {
      return _state
    }

    function setState (state) {
      _state = state;
      var keys = Object.keys(listeners);
      var i = 0;
      var len = keys.length;
      for (; i < len; i++) {
        // if a listener gets unsubscribed during setState we just skip it
        if (listeners[keys[i]]) { listeners[keys[i]](state); }
      }
    }

    // subscribe to changes and return the subscriptionId
    function subscribe (listener) {
      if (typeof listener !== 'function') {
        throw new Error('listener must be a function.')
      }
      var currentId = id;
      listeners[currentId] = listener;
      id += 1;
      return currentId
    }

    // remove subscription by removing the listener function
    function unsubscribe (id) {
      listeners[id] = undefined;
    }

    return { getState: getState, setState: setState, subscribe: subscribe, unsubscribe: unsubscribe }
  }

  // Same value used by react-jss
  var CHANNEL = '__THEMING__';
  var themeListener = {
    contextTypes: defineProperty({}, CHANNEL, function () {}),
    initial: function initial(context) {
      if (!context[CHANNEL]) {
        return null;
      }

      return context[CHANNEL].getState();
    },
    subscribe: function subscribe(context, cb) {
      if (!context[CHANNEL]) {
        return null;
      }

      return context[CHANNEL].subscribe(cb);
    },
    unsubscribe: function unsubscribe(context, subscriptionId) {
      if (context[CHANNEL]) {
        context[CHANNEL].unsubscribe(subscriptionId);
      }
    }
  };

  /**
   * This component takes a `theme` property.
   * It makes the `theme` available down the React tree thanks to React context.
   * This component should preferably be used at **the root of your component tree**.
   */

  var MuiThemeProviderOld =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(MuiThemeProviderOld, _React$Component);

    // We are not using the React state in order to avoid unnecessary rerender.
    function MuiThemeProviderOld(props, context) {
      var _this;

      classCallCheck(this, MuiThemeProviderOld);

      _this = possibleConstructorReturn(this, getPrototypeOf(MuiThemeProviderOld).call(this)); // Get the outer theme from the context, can be null

      _this.broadcast = createBroadcast();
      _this.outerTheme = themeListener.initial(context); // Propagate the theme so it can be accessed by the children

      _this.broadcast.setState(_this.mergeOuterLocalTheme(props.theme));

      return _this;
    }

    createClass(MuiThemeProviderOld, [{
      key: "getChildContext",
      value: function getChildContext() {
        var _ref;

        var _this$props = this.props,
            disableStylesGeneration = _this$props.disableStylesGeneration,
            sheetsCache = _this$props.sheetsCache,
            sheetsManager = _this$props.sheetsManager;
        var muiThemeProviderOptions = this.context.muiThemeProviderOptions || {};

        if (disableStylesGeneration !== undefined) {
          muiThemeProviderOptions.disableStylesGeneration = disableStylesGeneration;
        }

        if (sheetsCache !== undefined) {
          muiThemeProviderOptions.sheetsCache = sheetsCache;
        }

        if (sheetsManager !== undefined) {
          muiThemeProviderOptions.sheetsManager = sheetsManager;
        }

        return _ref = {}, defineProperty(_ref, CHANNEL, this.broadcast), defineProperty(_ref, "muiThemeProviderOptions", muiThemeProviderOptions), _ref;
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        // Subscribe on the outer theme, if present
        this.unsubscribeId = themeListener.subscribe(this.context, function (outerTheme) {
          _this2.outerTheme = outerTheme; // Forward the parent theme update to the children

          _this2.broadcast.setState(_this2.mergeOuterLocalTheme(_this2.props.theme));
        });
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        // Propagate a local theme update
        if (this.props.theme !== prevProps.theme) {
          this.broadcast.setState(this.mergeOuterLocalTheme(this.props.theme));
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        if (this.unsubscribeId !== null) {
          themeListener.unsubscribe(this.context, this.unsubscribeId);
        }
      } // Simple merge between the outer theme and the local theme

    }, {
      key: "mergeOuterLocalTheme",
      value: function mergeOuterLocalTheme(localTheme) {
        // To support composition of theme.
        if (typeof localTheme === 'function') {
          warning_1(this.outerTheme, ['Material-UI: you are providing a theme function property ' + 'to the MuiThemeProvider component:', '<MuiThemeProvider theme={outerTheme => outerTheme} />', 'However, no outer theme is present.', 'Make sure a theme is already injected higher in the React tree ' + 'or provide a theme object.'].join('\n'));
          return localTheme(this.outerTheme);
        }

        if (!this.outerTheme) {
          return localTheme;
        }

        return _extends_1({}, this.outerTheme, localTheme);
      }
    }, {
      key: "render",
      value: function render() {
        // TODO move the sheetsManager property to a different component.
        // warning(
        //   typeof window !== 'undefined' || this.props.sheetsManager,
        //   [
        //     'Material-UI: you need to provide a sheetsManager to the MuiThemeProvider ' +
        //       'when rendering on the server.',
        //     'If you do not, you might experience a memory leak',
        //   ].join('\n'),
        // );
        return this.props.children;
      }
    }]);

    return MuiThemeProviderOld;
  }(React.Component);
  MuiThemeProviderOld.propTypes = {
    /**
     * You can wrap a node.
     */
    children: propTypes.node.isRequired,

    /**
     * You can disable the generation of the styles with this option.
     * It can be useful when traversing the React tree outside of the HTML
     * rendering step on the server.
     * Let's say you are using react-apollo to extract all
     * the queries made by the interface server-side.
     * You can significantly speed up the traversal with this property.
     */
    disableStylesGeneration: propTypes.bool,

    /**
     * @ignore
     *
     * In beta.
     */
    sheetsCache: propTypes.object,

    /**
     * The sheetsManager is used to deduplicate style sheet injection in the page.
     * It's deduplicating using the (theme, styles) couple.
     * On the server, you should provide a new instance for each request.
     */
    sheetsManager: propTypes.object,

    /**
     * A theme object.
     */
    theme: propTypes.oneOfType([propTypes.object, propTypes.func]).isRequired
  };

  {
    MuiThemeProviderOld.propTypes = exactProp(MuiThemeProviderOld.propTypes);
  }

  MuiThemeProviderOld.childContextTypes = _extends_1({}, themeListener.contextTypes, {
    muiThemeProviderOptions: propTypes.object
  });
  MuiThemeProviderOld.contextTypes = _extends_1({}, themeListener.contextTypes, {
    muiThemeProviderOptions: propTypes.object
  });
  /* istanbul ignore if */

  if (!ponyfillGlobal.__MUI_STYLES__) {
    ponyfillGlobal.__MUI_STYLES__ = {};
  }

  if (!ponyfillGlobal.__MUI_STYLES__.MuiThemeProvider) {
    ponyfillGlobal.__MUI_STYLES__.MuiThemeProvider = MuiThemeProviderOld;
  }

  var MuiThemeProvider = ponyfillGlobal.__MUI_STYLES__.MuiThemeProvider;

  function createStyles(styles) {
    return styles;
  }

  /**
   * Copyright 2015, Yahoo! Inc.
   * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
   */

  var REACT_STATICS = {
      childContextTypes: true,
      contextType: true,
      contextTypes: true,
      defaultProps: true,
      displayName: true,
      getDefaultProps: true,
      getDerivedStateFromError: true,
      getDerivedStateFromProps: true,
      mixins: true,
      propTypes: true,
      type: true
  };

  var KNOWN_STATICS = {
      name: true,
      length: true,
      prototype: true,
      caller: true,
      callee: true,
      arguments: true,
      arity: true
  };

  var FORWARD_REF_STATICS = {
      '$$typeof': true,
      render: true,
      defaultProps: true,
      displayName: true,
      propTypes: true
  };

  var TYPE_STATICS = {};
  TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;

  var defineProperty$1 = Object.defineProperty;
  var getOwnPropertyNames = Object.getOwnPropertyNames;
  var getOwnPropertySymbols$1 = Object.getOwnPropertySymbols;
  var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
  var getPrototypeOf$1 = Object.getPrototypeOf;
  var objectPrototype = Object.prototype;

  function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
      if (typeof sourceComponent !== 'string') {
          // don't hoist over string (html) components

          if (objectPrototype) {
              var inheritedComponent = getPrototypeOf$1(sourceComponent);
              if (inheritedComponent && inheritedComponent !== objectPrototype) {
                  hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
              }
          }

          var keys = getOwnPropertyNames(sourceComponent);

          if (getOwnPropertySymbols$1) {
              keys = keys.concat(getOwnPropertySymbols$1(sourceComponent));
          }

          var targetStatics = TYPE_STATICS[targetComponent['$$typeof']] || REACT_STATICS;
          var sourceStatics = TYPE_STATICS[sourceComponent['$$typeof']] || REACT_STATICS;

          for (var i = 0; i < keys.length; ++i) {
              var key = keys[i];
              if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
                  var descriptor = getOwnPropertyDescriptor(sourceComponent, key);
                  try {
                      // Avoid failures from read-only properties
                      defineProperty$1(targetComponent, key, descriptor);
                  } catch (e) {}
              }
          }

          return targetComponent;
      }

      return targetComponent;
  }

  var hoistNonReactStatics_cjs = hoistNonReactStatics;

  // Share the same values than in
  // https://github.com/cssinjs/jss/blob/master/packages/react-jss/src/ns.js
  var ns = {
    jss: '64a55d578f856d258dc345b094a2a2b3',
    sheetsRegistry: 'd4bd0baacbc52bbd48bbb9eb24344ecd',
    sheetOptions: '6fc570d6bd61383819d0f9e7407c452d'
  };

  function mergeClasses() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var baseClasses = options.baseClasses,
        newClasses = options.newClasses,
        Component = options.Component;

    if (!newClasses) {
      return baseClasses;
    }

    var nextClasses = _extends_1({}, baseClasses);

    if (typeof newClasses === 'string') {
      warning_1(false, ["Material-UI: the value `".concat(newClasses, "` ") + "provided to the classes property of ".concat(getDisplayName(Component), " is incorrect."), 'You might want to use the className property instead.'].join('\n'));
      return baseClasses;
    }

    Object.keys(newClasses).forEach(function (key) {
      warning_1(baseClasses[key] || !newClasses[key], ["Material-UI: the key `".concat(key, "` ") + "provided to the classes property is not implemented in ".concat(getDisplayName(Component), "."), "You can only override one of the following: ".concat(Object.keys(baseClasses).join(','), ".")].join('\n'));
      warning_1(!newClasses[key] || typeof newClasses[key] === 'string', ["Material-UI: the key `".concat(key, "` ") + "provided to the classes property is not valid for ".concat(getDisplayName(Component), "."), "You need to provide a non empty string instead of: ".concat(newClasses[key], ".")].join('\n'));

      if (newClasses[key]) {
        nextClasses[key] = "".concat(baseClasses[key], " ").concat(newClasses[key]);
      }
    });
    return nextClasses;
  }

  // Used https://github.com/thinkloop/multi-key-cache as inspiration
  var multiKeyStore = {
    set: function set(cache, key1, key2, value) {
      var subCache = cache.get(key1);

      if (!subCache) {
        subCache = new Map();
        cache.set(key1, subCache);
      }

      subCache.set(key2, value);
    },
    get: function get(cache, key1, key2) {
      var subCache = cache.get(key1);
      return subCache ? subCache.get(key2) : undefined;
    },
    delete: function _delete(cache, key1, key2) {
      var subCache = cache.get(key1);
      subCache.delete(key2);
    }
  };

  // Support for the jss-expand plugin.

  function arrayMerge(destination, source) {
    return source;
  }

  function getStylesCreator(stylesOrCreator) {
    var themingEnabled = typeof stylesOrCreator === 'function';
    warning_1(_typeof_1(stylesOrCreator) === 'object' || themingEnabled, ['Material-UI: the first argument provided to withStyles() is invalid.', 'You need to provide a function generating the styles or a styles object.'].join('\n'));

    function create(theme, name) {
      var styles = themingEnabled ? stylesOrCreator(theme) : stylesOrCreator;

      if (!name || !theme.overrides || !theme.overrides[name]) {
        return styles;
      }

      var overrides = theme.overrides[name];

      var stylesWithOverrides = _extends_1({}, styles);

      Object.keys(overrides).forEach(function (key) {
        warning_1(stylesWithOverrides[key], ['Material-UI: you are trying to override a style that does not exist.', "Fix the `".concat(key, "` key of `theme.overrides.").concat(name, "`.")].join('\n'));
        stylesWithOverrides[key] = umd(stylesWithOverrides[key], overrides[key], {
          arrayMerge: arrayMerge
        });
      });
      return stylesWithOverrides;
    }

    return {
      create: create,
      options: {},
      themingEnabled: themingEnabled
    };
  }

  /* eslint-disable no-restricted-syntax */
  function getThemeProps(params) {
    var theme = params.theme,
        name = params.name,
        props = params.props;

    if (!theme.props || !name || !theme.props[name]) {
      return props;
    } // Resolve default props, code borrow from React source.
    // https://github.com/facebook/react/blob/15a8f031838a553e41c0b66eb1bcf1da8448104d/packages/react/src/ReactElement.js#L221


    var defaultProps = theme.props[name];
    var propName;

    for (propName in defaultProps) {
      if (props[propName] === undefined) {
        props[propName] = defaultProps[propName];
      }
    }

    return props;
  }

  var jss = lib_1(jssPreset()); // Use a singleton or the provided one by the context.
  //
  // The counter-based approach doesn't tolerate any mistake.
  // It's much safer to use the same counter everywhere.

  var generateClassName = createGenerateClassName(); // Global index counter to preserve source order.
  // We create the style sheet during at the creation of the component,
  // children are handled after the parents, so the order of style elements would be parent->child.
  // It is a problem though when a parent passes a className
  // which needs to override any child's styles.
  // StyleSheet of the child has a higher specificity, because of the source order.
  // So our solution is to render sheets them in the reverse order child->sheet, so
  // that parent has a higher specificity.

  var indexCounter = -10e10; // Exported for test purposes

  var sheetsManager = new Map(); // We use the same empty object to ref count the styles that don't need a theme object.

  var noopTheme = {}; // In order to have self-supporting components, we rely on default theme when not provided.

  var defaultTheme = createMuiTheme({
    typography: {
      suppressWarning: true
    }
  }); // Link a style sheet with a component.
  // It does not modify the component passed to it;
  // instead, it returns a new component, with a `classes` property.

  var withStylesOld = function withStylesOld(stylesOrCreator) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return function (Component) {
      var _extends2;

      var _options$withTheme = options.withTheme,
          withTheme = _options$withTheme === void 0 ? false : _options$withTheme,
          _options$flip = options.flip,
          flip = _options$flip === void 0 ? null : _options$flip,
          name = options.name,
          styleSheetOptions = objectWithoutProperties(options, ["withTheme", "flip", "name"]);

      var stylesCreator = getStylesCreator(stylesOrCreator);
      var listenToTheme = stylesCreator.themingEnabled || typeof name === 'string' || withTheme;
      indexCounter += 1;
      stylesCreator.options.index = indexCounter;
      warning_1(indexCounter < 0, ['Material-UI: you might have a memory leak.', 'The indexCounter is not supposed to grow that much.'].join('\n'));

      var WithStyles =
      /*#__PURE__*/
      function (_React$Component) {
        inherits(WithStyles, _React$Component);

        function WithStyles(props, context) {
          var _this;

          classCallCheck(this, WithStyles);

          _this = possibleConstructorReturn(this, getPrototypeOf(WithStyles).call(this, props, context));
          _this.jss = context[ns.jss] || jss;
          _this.sheetsManager = sheetsManager;
          _this.unsubscribeId = null;
          var muiThemeProviderOptions = context.muiThemeProviderOptions;

          if (muiThemeProviderOptions) {
            if (muiThemeProviderOptions.sheetsManager) {
              _this.sheetsManager = muiThemeProviderOptions.sheetsManager;
            }

            _this.sheetsCache = muiThemeProviderOptions.sheetsCache;
            _this.disableStylesGeneration = muiThemeProviderOptions.disableStylesGeneration;
          } // Attach the stylesCreator to the instance of the component as in the context
          // of react-hot-loader the hooks can be executed in a different closure context:
          // https://github.com/gaearon/react-hot-loader/blob/master/src/patch.dev.js#L107


          _this.stylesCreatorSaved = stylesCreator;
          _this.sheetOptions = _extends_1({
            generateClassName: generateClassName
          }, context[ns.sheetOptions]); // We use || as the function call is lazy evaluated.

          _this.theme = listenToTheme ? themeListener.initial(context) || defaultTheme : noopTheme;

          _this.attach(_this.theme);

          _this.cacheClasses = {
            // Cache for the finalized classes value.
            value: null,
            // Cache for the last used classes prop pointer.
            lastProp: null,
            // Cache for the last used rendered classes pointer.
            lastJSS: {}
          };
          return _this;
        }

        createClass(WithStyles, [{
          key: "componentDidMount",
          value: function componentDidMount() {
            var _this2 = this;

            if (!listenToTheme) {
              return;
            }

            this.unsubscribeId = themeListener.subscribe(this.context, function (theme) {
              var oldTheme = _this2.theme;
              _this2.theme = theme;

              _this2.attach(_this2.theme); // Rerender the component so the underlying component gets the theme update.
              // By theme update we mean receiving and applying the new class names.


              _this2.setState({}, function () {
                _this2.detach(oldTheme);
              });
            });
          }
        }, {
          key: "componentDidUpdate",
          value: function componentDidUpdate() {
            // react-hot-loader specific logic
            if (this.stylesCreatorSaved === stylesCreator || "development" === 'production') {
              return;
            }

            this.detach(this.theme);
            this.stylesCreatorSaved = stylesCreator;
            this.attach(this.theme);
            this.forceUpdate();
          }
        }, {
          key: "componentWillUnmount",
          value: function componentWillUnmount() {
            this.detach(this.theme);

            if (this.unsubscribeId !== null) {
              themeListener.unsubscribe(this.context, this.unsubscribeId);
            }
          }
        }, {
          key: "getClasses",
          value: function getClasses() {
            if (this.disableStylesGeneration) {
              return this.props.classes || {};
            } // Tracks if either the rendered classes or classes prop has changed,
            // requiring the generation of a new finalized classes object.


            var generate = false;
            var sheetManager = multiKeyStore.get(this.sheetsManager, this.stylesCreatorSaved, this.theme);

            if (sheetManager.sheet.classes !== this.cacheClasses.lastJSS) {
              this.cacheClasses.lastJSS = sheetManager.sheet.classes;
              generate = true;
            }

            if (this.props.classes !== this.cacheClasses.lastProp) {
              this.cacheClasses.lastProp = this.props.classes;
              generate = true;
            }

            if (generate) {
              this.cacheClasses.value = mergeClasses({
                baseClasses: this.cacheClasses.lastJSS,
                newClasses: this.props.classes,
                Component: Component
              });
            }

            return this.cacheClasses.value;
          }
        }, {
          key: "attach",
          value: function attach(theme) {
            if (this.disableStylesGeneration) {
              return;
            }

            var stylesCreatorSaved = this.stylesCreatorSaved;
            var sheetManager = multiKeyStore.get(this.sheetsManager, stylesCreatorSaved, theme);

            if (!sheetManager) {
              sheetManager = {
                refs: 0,
                sheet: null
              };
              multiKeyStore.set(this.sheetsManager, stylesCreatorSaved, theme, sheetManager);
            }

            if (sheetManager.refs === 0) {
              var sheet;

              if (this.sheetsCache) {
                sheet = multiKeyStore.get(this.sheetsCache, stylesCreatorSaved, theme);
              }

              if (!sheet) {
                sheet = this.createSheet(theme);
                sheet.attach();

                if (this.sheetsCache) {
                  multiKeyStore.set(this.sheetsCache, stylesCreatorSaved, theme, sheet);
                }
              }

              sheetManager.sheet = sheet;
              var sheetsRegistry = this.context[ns.sheetsRegistry];

              if (sheetsRegistry) {
                sheetsRegistry.add(sheet);
              }
            }

            sheetManager.refs += 1;
          }
        }, {
          key: "createSheet",
          value: function createSheet(theme) {
            var styles = this.stylesCreatorSaved.create(theme, name);
            var meta = name;

            if (!meta) {
              // Provide a better DX outside production.
              meta = getDisplayName(Component);
              warning_1(typeof meta === 'string', ['Material-UI: the component displayName is invalid. It needs to be a string.', "Please fix the following component: ".concat(Component, ".")].join('\n'));
            }

            var sheet = this.jss.createStyleSheet(styles, _extends_1({
              meta: meta,
              classNamePrefix: meta,
              flip: typeof flip === 'boolean' ? flip : theme.direction === 'rtl',
              link: false
            }, this.sheetOptions, this.stylesCreatorSaved.options, {
              name: name || Component.displayName
            }, styleSheetOptions));
            return sheet;
          }
        }, {
          key: "detach",
          value: function detach(theme) {
            if (this.disableStylesGeneration) {
              return;
            }

            var sheetManager = multiKeyStore.get(this.sheetsManager, this.stylesCreatorSaved, theme);
            sheetManager.refs -= 1;

            if (sheetManager.refs === 0) {
              multiKeyStore.delete(this.sheetsManager, this.stylesCreatorSaved, theme);
              this.jss.removeStyleSheet(sheetManager.sheet);
              var sheetsRegistry = this.context[ns.sheetsRegistry];

              if (sheetsRegistry) {
                sheetsRegistry.remove(sheetManager.sheet);
              }
            }
          }
        }, {
          key: "render",
          value: function render() {
            var _this$props = this.props,
                classes = _this$props.classes,
                innerRef = _this$props.innerRef,
                other = objectWithoutProperties(_this$props, ["classes", "innerRef"]);

            var more = getThemeProps({
              theme: this.theme,
              name: name,
              props: other
            }); // Provide the theme to the wrapped component.
            // So we don't have to use the `withTheme()` Higher-order Component.

            if (withTheme && !more.theme) {
              more.theme = this.theme;
            }

            return React.createElement(Component, _extends_1({}, more, {
              classes: this.getClasses(),
              ref: innerRef
            }));
          }
        }]);

        return WithStyles;
      }(React.Component);

      WithStyles.propTypes = {
        /**
         * Override or extend the styles applied to the component.
         */
        classes: propTypes.object,

        /**
         * Use that property to pass a ref callback to the decorated component.
         */
        innerRef: propTypes.oneOfType([propTypes.func, propTypes.object])
      };
      WithStyles.contextTypes = _extends_1((_extends2 = {
        muiThemeProviderOptions: propTypes.object
      }, defineProperty(_extends2, ns.jss, propTypes.object), defineProperty(_extends2, ns.sheetOptions, propTypes.object), defineProperty(_extends2, ns.sheetsRegistry, propTypes.object), _extends2), listenToTheme ? themeListener.contextTypes : {});

      {
        WithStyles.displayName = "WithStyles(".concat(getDisplayName(Component), ")");
      }

      hoistNonReactStatics_cjs(WithStyles, Component);

      {
        // Exposed for test purposes.
        WithStyles.Naked = Component;
        WithStyles.options = options;
      }

      return WithStyles;
    };
  };
  /* istanbul ignore if */


  if (!ponyfillGlobal.__MUI_STYLES__) {
    ponyfillGlobal.__MUI_STYLES__ = {};
  }

  if (!ponyfillGlobal.__MUI_STYLES__.withStyles) {
    ponyfillGlobal.__MUI_STYLES__.withStyles = withStylesOld;
  }

  var withStyles = (function (styles, options) {
    return ponyfillGlobal.__MUI_STYLES__.withStyles(styles, _extends_1({
      defaultTheme: defaultTheme
    }, options));
  });

  var defaultTheme$1;

  function getDefaultTheme() {
    if (defaultTheme$1) {
      return defaultTheme$1;
    }

    defaultTheme$1 = createMuiTheme({
      typography: {
        suppressWarning: true
      }
    });
    return defaultTheme$1;
  } // Provide the theme object as a property to the input component.


  var withThemeOld = function withThemeOld() {
    return function (Component) {
      var WithTheme =
      /*#__PURE__*/
      function (_React$Component) {
        inherits(WithTheme, _React$Component);

        function WithTheme(props, context) {
          var _this;

          classCallCheck(this, WithTheme);

          _this = possibleConstructorReturn(this, getPrototypeOf(WithTheme).call(this));
          _this.state = {
            // We use || as the function call is lazy evaluated.
            theme: themeListener.initial(context) || getDefaultTheme()
          };
          return _this;
        }

        createClass(WithTheme, [{
          key: "componentDidMount",
          value: function componentDidMount() {
            var _this2 = this;

            this.unsubscribeId = themeListener.subscribe(this.context, function (theme) {
              _this2.setState({
                theme: theme
              });
            });
          }
        }, {
          key: "componentWillUnmount",
          value: function componentWillUnmount() {
            if (this.unsubscribeId !== null) {
              themeListener.unsubscribe(this.context, this.unsubscribeId);
            }
          }
        }, {
          key: "render",
          value: function render() {
            var _this$props = this.props,
                innerRef = _this$props.innerRef,
                other = objectWithoutProperties(_this$props, ["innerRef"]);

            return React.createElement(Component, _extends_1({
              theme: this.state.theme,
              ref: innerRef
            }, other));
          }
        }]);

        return WithTheme;
      }(React.Component);

      WithTheme.propTypes = {
        /**
         * Use that property to pass a ref callback to the decorated component.
         */
        innerRef: propTypes.oneOfType([propTypes.func, propTypes.object])
      };
      WithTheme.contextTypes = themeListener.contextTypes;

      {
        WithTheme.displayName = "WithTheme(".concat(getDisplayName(Component), ")");
      }

      hoistNonReactStatics_cjs(WithTheme, Component);

      {
        // Exposed for test purposes.
        WithTheme.Naked = Component;
      }

      return WithTheme;
    };
  };
  /* istanbul ignore if */


  if (!ponyfillGlobal.__MUI_STYLES__) {
    ponyfillGlobal.__MUI_STYLES__ = {};
  }

  if (!ponyfillGlobal.__MUI_STYLES__.withTheme) {
    ponyfillGlobal.__MUI_STYLES__.withTheme = withThemeOld;
  }

  var withTheme = ponyfillGlobal.__MUI_STYLES__.withTheme;

  var classnames = createCommonjsModule(function (module) {
  /*!
    Copyright (c) 2017 Jed Watson.
    Licensed under the MIT License (MIT), see
    http://jedwatson.github.io/classnames
  */
  /* global define */

  (function () {

  	var hasOwn = {}.hasOwnProperty;

  	function classNames () {
  		var classes = [];

  		for (var i = 0; i < arguments.length; i++) {
  			var arg = arguments[i];
  			if (!arg) continue;

  			var argType = typeof arg;

  			if (argType === 'string' || argType === 'number') {
  				classes.push(arg);
  			} else if (Array.isArray(arg) && arg.length) {
  				var inner = classNames.apply(null, arg);
  				if (inner) {
  					classes.push(inner);
  				}
  			} else if (argType === 'object') {
  				for (var key in arg) {
  					if (hasOwn.call(arg, key) && arg[key]) {
  						classes.push(key);
  					}
  				}
  			}
  		}

  		return classes.join(' ');
  	}

  	if (module.exports) {
  		classNames.default = classNames;
  		module.exports = classNames;
  	} else {
  		window.classNames = classNames;
  	}
  }());
  });

  //
  // A strict capitalization should uppercase the first letter of each word a the sentence.
  // We only handle the first word.

  function capitalize(string) {
    if (typeof string !== 'string') {
      throw new Error('Material-UI: capitalize(string) expects a string argument.');
    }

    return string.charAt(0).toUpperCase() + string.slice(1);
  }
  function contains(obj, pred) {
    return Object.keys(pred).every(function (key) {
      return obj.hasOwnProperty(key) && obj[key] === pred[key];
    });
  }
  function findIndex(arr, pred) {
    var predType = _typeof_1(pred);

    for (var i = 0; i < arr.length; i += 1) {
      if (predType === 'function' && !!pred(arr[i], i, arr) === true) {
        return i;
      }

      if (predType === 'object' && contains(arr[i], pred)) {
        return i;
      }

      if (['string', 'number', 'boolean'].indexOf(predType) !== -1) {
        return arr.indexOf(pred);
      }
    }

    return -1;
  }
  function find(arr, pred) {
    var index = findIndex(arr, pred);
    return index > -1 ? arr[index] : undefined;
  }
  /**
   * Safe chained function
   *
   * Will only create a new function if needed,
   * otherwise will pass back existing functions or null.
   *
   * @param {function} functions to chain
   * @returns {function|null}
   */

  function createChainedFunction() {
    for (var _len = arguments.length, funcs = new Array(_len), _key = 0; _key < _len; _key++) {
      funcs[_key] = arguments[_key];
    }

    return funcs.reduce(function (acc, func) {
      if (func == null) {
        return acc;
      }

      warning_1(typeof func === 'function', 'Material-UI: invalid Argument Type, must only provide functions, undefined, or null.');
      return function chainedFunction() {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        acc.apply(this, args);
        func.apply(this, args);
      };
    }, function () {});
  }

  var styles = function styles(theme) {
    var elevations = {};
    theme.shadows.forEach(function (shadow, index) {
      elevations["elevation".concat(index)] = {
        boxShadow: shadow
      };
    });
    return _extends_1({
      /* Styles applied to the root element. */
      root: {
        backgroundColor: theme.palette.background.paper
      },

      /* Styles applied to the root element if `square={false}`. */
      rounded: {
        borderRadius: theme.shape.borderRadius
      }
    }, elevations);
  };

  function Paper(props) {
    var classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        square = props.square,
        elevation = props.elevation,
        other = objectWithoutProperties(props, ["classes", "className", "component", "square", "elevation"]);

    warning_1(elevation >= 0 && elevation < 25, "Material-UI: this elevation `".concat(elevation, "` is not implemented."));
    var className = classnames(classes.root, classes["elevation".concat(elevation)], defineProperty({}, classes.rounded, !square), classNameProp);
    return React.createElement(Component, _extends_1({
      className: className
    }, other));
  }

  Paper.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Shadow depth, corresponds to `dp` in the spec.
     * It's accepting values between 0 and 24 inclusive.
     */
    elevation: propTypes.number,

    /**
     * If `true`, rounded corners are disabled.
     */
    square: propTypes.bool
  };
  Paper.defaultProps = {
    component: 'div',
    elevation: 2,
    square: false
  };
  var Paper$1 = withStyles(styles, {
    name: 'MuiPaper'
  })(Paper);

  var styles$1 = function styles(theme) {
    var backgroundColorDefault = theme.palette.type === 'light' ? theme.palette.grey[100] : theme.palette.grey[900];
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        flexDirection: 'column',
        width: '100%',
        boxSizing: 'border-box',
        // Prevent padding issue with the Modal and fixed positioned AppBar.
        zIndex: theme.zIndex.appBar,
        flexShrink: 0
      },

      /* Styles applied to the root element if `position="fixed"`. */
      positionFixed: {
        position: 'fixed',
        top: 0,
        left: 'auto',
        right: 0
      },

      /* Styles applied to the root element if `position="absolute"`. */
      positionAbsolute: {
        position: 'absolute',
        top: 0,
        left: 'auto',
        right: 0
      },

      /* Styles applied to the root element if `position="sticky"`. */
      positionSticky: {
        position: 'sticky',
        top: 0,
        left: 'auto',
        right: 0
      },

      /* Styles applied to the root element if `position="static"`. */
      positionStatic: {
        position: 'static'
      },

      /* Styles applied to the root element if `position="relative"`. */
      positionRelative: {
        position: 'relative'
      },

      /* Styles applied to the root element if `color="default"`. */
      colorDefault: {
        backgroundColor: backgroundColorDefault,
        color: theme.palette.getContrastText(backgroundColorDefault)
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        backgroundColor: theme.palette.primary.main,
        color: theme.palette.primary.contrastText
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        backgroundColor: theme.palette.secondary.main,
        color: theme.palette.secondary.contrastText
      }
    };
  };

  function AppBar(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        color = props.color,
        position = props.position,
        other = objectWithoutProperties(props, ["children", "classes", "className", "color", "position"]);

    var className = classnames(classes.root, classes["position".concat(capitalize(position))], (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'inherit'), defineProperty(_classNames, 'mui-fixed', position === 'fixed'), _classNames), classNameProp);
    return React.createElement(Paper$1, _extends_1({
      square: true,
      component: "header",
      elevation: 4,
      className: className
    }, other), children);
  }

  AppBar.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['inherit', 'primary', 'secondary', 'default']),

    /**
     * The positioning type. The behavior of the different options is described
     * [in the MDN web docs](https://developer.mozilla.org/en-US/docs/Learn/CSS/CSS_layout/Positioning).
     * Note: `sticky` is not universally supported and will fall back to `static` when unavailable.
     */
    position: propTypes.oneOf(['fixed', 'absolute', 'sticky', 'static', 'relative'])
  };
  AppBar.defaultProps = {
    color: 'primary',
    position: 'fixed'
  };
  var AppBar$1 = withStyles(styles$1, {
    name: 'MuiAppBar'
  })(AppBar);

  var styles$2 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        flexShrink: 0,
        width: 40,
        height: 40,
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(20),
        borderRadius: '50%',
        overflow: 'hidden',
        userSelect: 'none'
      },

      /* Styles applied to the root element if there are children and not `src` or `srcSet`. */
      colorDefault: {
        color: theme.palette.background.default,
        backgroundColor: theme.palette.type === 'light' ? theme.palette.grey[400] : theme.palette.grey[600]
      },

      /* Styles applied to the img element if either `src` or `srcSet` is defined. */
      img: {
        width: '100%',
        height: '100%',
        textAlign: 'center',
        // Handle non-square image. The property isn't supported by IE 11.
        objectFit: 'cover'
      }
    };
  };

  function Avatar(props) {
    var alt = props.alt,
        childrenProp = props.children,
        childrenClassNameProp = props.childrenClassName,
        classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        imgProps = props.imgProps,
        sizes = props.sizes,
        src = props.src,
        srcSet = props.srcSet,
        other = objectWithoutProperties(props, ["alt", "children", "childrenClassName", "classes", "className", "component", "imgProps", "sizes", "src", "srcSet"]);

    var children = null;
    var img = src || srcSet;

    if (img) {
      children = React.createElement("img", _extends_1({
        alt: alt,
        src: src,
        srcSet: srcSet,
        sizes: sizes,
        className: classes.img
      }, imgProps));
    } else if (childrenClassNameProp && React.isValidElement(childrenProp)) {
      children = React.cloneElement(childrenProp, {
        className: classnames(childrenClassNameProp, childrenProp.props.className)
      });
    } else {
      children = childrenProp;
    }

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, classes.system, defineProperty({}, classes.colorDefault, !img), classNameProp)
    }, other), children);
  }

  Avatar.propTypes = {
    /**
     * Used in combination with `src` or `srcSet` to
     * provide an alt attribute for the rendered `img` element.
     */
    alt: propTypes.string,

    /**
     * Used to render icon or text elements inside the Avatar.
     * `src` and `alt` props will not be used and no `img` will
     * be rendered by default.
     *
     * This can be an element, or just a string.
     */
    children: propTypes.node,

    /**
     * @ignore
     * The className of the child element.
     * Used by Chip and ListItemIcon to style the Avatar icon.
     */
    childrenClassName: propTypes.string,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Attributes applied to the `img` element if the component
     * is used to display an image.
     */
    imgProps: propTypes.object,

    /**
     * The `sizes` attribute for the `img` element.
     */
    sizes: propTypes.string,

    /**
     * The `src` attribute for the `img` element.
     */
    src: propTypes.string,

    /**
     * The `srcSet` attribute for the `img` element.
     */
    srcSet: propTypes.string
  };
  Avatar.defaultProps = {
    component: 'div'
  };
  var Avatar$1 = withStyles(styles$2, {
    name: 'MuiAvatar'
  })(Avatar);

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  function componentWillMount() {
    // Call this.constructor.gDSFP to support sub-classes.
    var state = this.constructor.getDerivedStateFromProps(this.props, this.state);
    if (state !== null && state !== undefined) {
      this.setState(state);
    }
  }

  function componentWillReceiveProps(nextProps) {
    // Call this.constructor.gDSFP to support sub-classes.
    // Use the setState() updater to ensure state isn't stale in certain edge cases.
    function updater(prevState) {
      var state = this.constructor.getDerivedStateFromProps(nextProps, prevState);
      return state !== null && state !== undefined ? state : null;
    }
    // Binding "this" is important for shallow renderer support.
    this.setState(updater.bind(this));
  }

  function componentWillUpdate(nextProps, nextState) {
    try {
      var prevProps = this.props;
      var prevState = this.state;
      this.props = nextProps;
      this.state = nextState;
      this.__reactInternalSnapshotFlag = true;
      this.__reactInternalSnapshot = this.getSnapshotBeforeUpdate(
        prevProps,
        prevState
      );
    } finally {
      this.props = prevProps;
      this.state = prevState;
    }
  }

  // React may warn about cWM/cWRP/cWU methods being deprecated.
  // Add a flag to suppress these warnings for this special case.
  componentWillMount.__suppressDeprecationWarning = true;
  componentWillReceiveProps.__suppressDeprecationWarning = true;
  componentWillUpdate.__suppressDeprecationWarning = true;

  function polyfill(Component) {
    var prototype = Component.prototype;

    if (!prototype || !prototype.isReactComponent) {
      throw new Error('Can only polyfill class components');
    }

    if (
      typeof Component.getDerivedStateFromProps !== 'function' &&
      typeof prototype.getSnapshotBeforeUpdate !== 'function'
    ) {
      return Component;
    }

    // If new component APIs are defined, "unsafe" lifecycles won't be called.
    // Error if any of these lifecycles are present,
    // Because they would work differently between older and newer (16.3+) versions of React.
    var foundWillMountName = null;
    var foundWillReceivePropsName = null;
    var foundWillUpdateName = null;
    if (typeof prototype.componentWillMount === 'function') {
      foundWillMountName = 'componentWillMount';
    } else if (typeof prototype.UNSAFE_componentWillMount === 'function') {
      foundWillMountName = 'UNSAFE_componentWillMount';
    }
    if (typeof prototype.componentWillReceiveProps === 'function') {
      foundWillReceivePropsName = 'componentWillReceiveProps';
    } else if (typeof prototype.UNSAFE_componentWillReceiveProps === 'function') {
      foundWillReceivePropsName = 'UNSAFE_componentWillReceiveProps';
    }
    if (typeof prototype.componentWillUpdate === 'function') {
      foundWillUpdateName = 'componentWillUpdate';
    } else if (typeof prototype.UNSAFE_componentWillUpdate === 'function') {
      foundWillUpdateName = 'UNSAFE_componentWillUpdate';
    }
    if (
      foundWillMountName !== null ||
      foundWillReceivePropsName !== null ||
      foundWillUpdateName !== null
    ) {
      var componentName = Component.displayName || Component.name;
      var newApiName =
        typeof Component.getDerivedStateFromProps === 'function'
          ? 'getDerivedStateFromProps()'
          : 'getSnapshotBeforeUpdate()';

      throw Error(
        'Unsafe legacy lifecycles will not be called for components using new component APIs.\n\n' +
          componentName +
          ' uses ' +
          newApiName +
          ' but also contains the following legacy lifecycles:' +
          (foundWillMountName !== null ? '\n  ' + foundWillMountName : '') +
          (foundWillReceivePropsName !== null
            ? '\n  ' + foundWillReceivePropsName
            : '') +
          (foundWillUpdateName !== null ? '\n  ' + foundWillUpdateName : '') +
          '\n\nThe above lifecycles should be removed. Learn more about this warning here:\n' +
          'https://fb.me/react-async-component-lifecycle-hooks'
      );
    }

    // React <= 16.2 does not support static getDerivedStateFromProps.
    // As a workaround, use cWM and cWRP to invoke the new static lifecycle.
    // Newer versions of React will ignore these lifecycles if gDSFP exists.
    if (typeof Component.getDerivedStateFromProps === 'function') {
      prototype.componentWillMount = componentWillMount;
      prototype.componentWillReceiveProps = componentWillReceiveProps;
    }

    // React <= 16.2 does not support getSnapshotBeforeUpdate.
    // As a workaround, use cWU to invoke the new lifecycle.
    // Newer versions of React will ignore that lifecycle if gSBU exists.
    if (typeof prototype.getSnapshotBeforeUpdate === 'function') {
      if (typeof prototype.componentDidUpdate !== 'function') {
        throw new Error(
          'Cannot polyfill getSnapshotBeforeUpdate() for components that do not define componentDidUpdate() on the prototype'
        );
      }

      prototype.componentWillUpdate = componentWillUpdate;

      var componentDidUpdate = prototype.componentDidUpdate;

      prototype.componentDidUpdate = function componentDidUpdatePolyfill(
        prevProps,
        prevState,
        maybeSnapshot
      ) {
        // 16.3+ will not execute our will-update method;
        // It will pass a snapshot value to did-update though.
        // Older versions will require our polyfilled will-update value.
        // We need to handle both cases, but can't just check for the presence of "maybeSnapshot",
        // Because for <= 15.x versions this might be a "prevContext" object.
        // We also can't just check "__reactInternalSnapshot",
        // Because get-snapshot might return a falsy value.
        // So check for the explicit __reactInternalSnapshotFlag flag to determine behavior.
        var snapshot = this.__reactInternalSnapshotFlag
          ? this.__reactInternalSnapshot
          : maybeSnapshot;

        componentDidUpdate.call(this, prevProps, prevState, snapshot);
      };
    }

    return Component;
  }

  var reactLifecyclesCompat_es = /*#__PURE__*/Object.freeze({
    polyfill: polyfill
  });

  var PropTypes = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.classNamesShape = exports.timeoutsShape = void 0;

  var _propTypes = _interopRequireDefault(propTypes);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  var timeoutsShape = _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.shape({
    enter: _propTypes.default.number,
    exit: _propTypes.default.number
  }).isRequired]);
  exports.timeoutsShape = timeoutsShape;
  var classNamesShape = _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.shape({
    enter: _propTypes.default.string,
    exit: _propTypes.default.string,
    active: _propTypes.default.string
  }), _propTypes.default.shape({
    enter: _propTypes.default.string,
    enterDone: _propTypes.default.string,
    enterActive: _propTypes.default.string,
    exit: _propTypes.default.string,
    exitDone: _propTypes.default.string,
    exitActive: _propTypes.default.string
  })]);
  exports.classNamesShape = classNamesShape;
  });

  unwrapExports(PropTypes);
  var PropTypes_1 = PropTypes.classNamesShape;
  var PropTypes_2 = PropTypes.timeoutsShape;

  var Transition_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = exports.EXITING = exports.ENTERED = exports.ENTERING = exports.EXITED = exports.UNMOUNTED = void 0;

  var PropTypes$$1 = _interopRequireWildcard(propTypes);

  var _react = _interopRequireDefault(React);

  var _reactDom = _interopRequireDefault(ReactDOM);





  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

  function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

  var UNMOUNTED = 'unmounted';
  exports.UNMOUNTED = UNMOUNTED;
  var EXITED = 'exited';
  exports.EXITED = EXITED;
  var ENTERING = 'entering';
  exports.ENTERING = ENTERING;
  var ENTERED = 'entered';
  exports.ENTERED = ENTERED;
  var EXITING = 'exiting';
  /**
   * The Transition component lets you describe a transition from one component
   * state to another _over time_ with a simple declarative API. Most commonly
   * it's used to animate the mounting and unmounting of a component, but can also
   * be used to describe in-place transition states as well.
   *
   * By default the `Transition` component does not alter the behavior of the
   * component it renders, it only tracks "enter" and "exit" states for the components.
   * It's up to you to give meaning and effect to those states. For example we can
   * add styles to a component when it enters or exits:
   *
   * ```jsx
   * import Transition from 'react-transition-group/Transition';
   *
   * const duration = 300;
   *
   * const defaultStyle = {
   *   transition: `opacity ${duration}ms ease-in-out`,
   *   opacity: 0,
   * }
   *
   * const transitionStyles = {
   *   entering: { opacity: 0 },
   *   entered:  { opacity: 1 },
   * };
   *
   * const Fade = ({ in: inProp }) => (
   *   <Transition in={inProp} timeout={duration}>
   *     {(state) => (
   *       <div style={{
   *         ...defaultStyle,
   *         ...transitionStyles[state]
   *       }}>
   *         I'm a fade Transition!
   *       </div>
   *     )}
   *   </Transition>
   * );
   * ```
   *
   * As noted the `Transition` component doesn't _do_ anything by itself to its child component.
   * What it does do is track transition states over time so you can update the
   * component (such as by adding styles or classes) when it changes states.
   *
   * There are 4 main states a Transition can be in:
   *  - `'entering'`
   *  - `'entered'`
   *  - `'exiting'`
   *  - `'exited'`
   *
   * Transition state is toggled via the `in` prop. When `true` the component begins the
   * "Enter" stage. During this stage, the component will shift from its current transition state,
   * to `'entering'` for the duration of the transition and then to the `'entered'` stage once
   * it's complete. Let's take the following example:
   *
   * ```jsx
   * state = { in: false };
   *
   * toggleEnterState = () => {
   *   this.setState({ in: true });
   * }
   *
   * render() {
   *   return (
   *     <div>
   *       <Transition in={this.state.in} timeout={500} />
   *       <button onClick={this.toggleEnterState}>Click to Enter</button>
   *     </div>
   *   );
   * }
   * ```
   *
   * When the button is clicked the component will shift to the `'entering'` state and
   * stay there for 500ms (the value of `timeout`) before it finally switches to `'entered'`.
   *
   * When `in` is `false` the same thing happens except the state moves from `'exiting'` to `'exited'`.
   *
   * ## Timing
   *
   * Timing is often the trickiest part of animation, mistakes can result in slight delays
   * that are hard to pin down. A common example is when you want to add an exit transition,
   * you should set the desired final styles when the state is `'exiting'`. That's when the
   * transition to those styles will start and, if you matched the `timeout` prop with the
   * CSS Transition duration, it will end exactly when the state changes to `'exited'`.
   *
   * > **Note**: For simpler transitions the `Transition` component might be enough, but
   * > take into account that it's platform-agnostic, while the `CSSTransition` component
   * > [forces reflows](https://github.com/reactjs/react-transition-group/blob/5007303e729a74be66a21c3e2205e4916821524b/src/CSSTransition.js#L208-L215)
   * > in order to make more complex transitions more predictable. For example, even though
   * > classes `example-enter` and `example-enter-active` are applied immediately one after
   * > another, you can still transition from one to the other because of the forced reflow
   * > (read [this issue](https://github.com/reactjs/react-transition-group/issues/159#issuecomment-322761171)
   * > for more info). Take this into account when choosing between `Transition` and
   * > `CSSTransition`.
   */

  exports.EXITING = EXITING;

  var Transition =
  /*#__PURE__*/
  function (_React$Component) {
    _inheritsLoose(Transition, _React$Component);

    function Transition(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;
      var parentGroup = context.transitionGroup; // In the context of a TransitionGroup all enters are really appears

      var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;
      var initialStatus;
      _this.appearStatus = null;

      if (props.in) {
        if (appear) {
          initialStatus = EXITED;
          _this.appearStatus = ENTERING;
        } else {
          initialStatus = ENTERED;
        }
      } else {
        if (props.unmountOnExit || props.mountOnEnter) {
          initialStatus = UNMOUNTED;
        } else {
          initialStatus = EXITED;
        }
      }

      _this.state = {
        status: initialStatus
      };
      _this.nextCallback = null;
      return _this;
    }

    var _proto = Transition.prototype;

    _proto.getChildContext = function getChildContext() {
      return {
        transitionGroup: null // allows for nested Transitions

      };
    };

    Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {
      var nextIn = _ref.in;

      if (nextIn && prevState.status === UNMOUNTED) {
        return {
          status: EXITED
        };
      }

      return null;
    }; // getSnapshotBeforeUpdate(prevProps) {
    //   let nextStatus = null
    //   if (prevProps !== this.props) {
    //     const { status } = this.state
    //     if (this.props.in) {
    //       if (status !== ENTERING && status !== ENTERED) {
    //         nextStatus = ENTERING
    //       }
    //     } else {
    //       if (status === ENTERING || status === ENTERED) {
    //         nextStatus = EXITING
    //       }
    //     }
    //   }
    //   return { nextStatus }
    // }


    _proto.componentDidMount = function componentDidMount() {
      this.updateStatus(true, this.appearStatus);
    };

    _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
      var nextStatus = null;

      if (prevProps !== this.props) {
        var status = this.state.status;

        if (this.props.in) {
          if (status !== ENTERING && status !== ENTERED) {
            nextStatus = ENTERING;
          }
        } else {
          if (status === ENTERING || status === ENTERED) {
            nextStatus = EXITING;
          }
        }
      }

      this.updateStatus(false, nextStatus);
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.cancelNextCallback();
    };

    _proto.getTimeouts = function getTimeouts() {
      var timeout = this.props.timeout;
      var exit, enter, appear;
      exit = enter = appear = timeout;

      if (timeout != null && typeof timeout !== 'number') {
        exit = timeout.exit;
        enter = timeout.enter;
        appear = timeout.appear;
      }

      return {
        exit: exit,
        enter: enter,
        appear: appear
      };
    };

    _proto.updateStatus = function updateStatus(mounting, nextStatus) {
      if (mounting === void 0) {
        mounting = false;
      }

      if (nextStatus !== null) {
        // nextStatus will always be ENTERING or EXITING.
        this.cancelNextCallback();

        var node = _reactDom.default.findDOMNode(this);

        if (nextStatus === ENTERING) {
          this.performEnter(node, mounting);
        } else {
          this.performExit(node);
        }
      } else if (this.props.unmountOnExit && this.state.status === EXITED) {
        this.setState({
          status: UNMOUNTED
        });
      }
    };

    _proto.performEnter = function performEnter(node, mounting) {
      var _this2 = this;

      var enter = this.props.enter;
      var appearing = this.context.transitionGroup ? this.context.transitionGroup.isMounting : mounting;
      var timeouts = this.getTimeouts(); // no enter animation skip right to ENTERED
      // if we are mounting and running this it means appear _must_ be set

      if (!mounting && !enter) {
        this.safeSetState({
          status: ENTERED
        }, function () {
          _this2.props.onEntered(node);
        });
        return;
      }

      this.props.onEnter(node, appearing);
      this.safeSetState({
        status: ENTERING
      }, function () {
        _this2.props.onEntering(node, appearing); // FIXME: appear timeout?


        _this2.onTransitionEnd(node, timeouts.enter, function () {
          _this2.safeSetState({
            status: ENTERED
          }, function () {
            _this2.props.onEntered(node, appearing);
          });
        });
      });
    };

    _proto.performExit = function performExit(node) {
      var _this3 = this;

      var exit = this.props.exit;
      var timeouts = this.getTimeouts(); // no exit animation skip right to EXITED

      if (!exit) {
        this.safeSetState({
          status: EXITED
        }, function () {
          _this3.props.onExited(node);
        });
        return;
      }

      this.props.onExit(node);
      this.safeSetState({
        status: EXITING
      }, function () {
        _this3.props.onExiting(node);

        _this3.onTransitionEnd(node, timeouts.exit, function () {
          _this3.safeSetState({
            status: EXITED
          }, function () {
            _this3.props.onExited(node);
          });
        });
      });
    };

    _proto.cancelNextCallback = function cancelNextCallback() {
      if (this.nextCallback !== null) {
        this.nextCallback.cancel();
        this.nextCallback = null;
      }
    };

    _proto.safeSetState = function safeSetState(nextState, callback) {
      // This shouldn't be necessary, but there are weird race conditions with
      // setState callbacks and unmounting in testing, so always make sure that
      // we can cancel any pending setState callbacks after we unmount.
      callback = this.setNextCallback(callback);
      this.setState(nextState, callback);
    };

    _proto.setNextCallback = function setNextCallback(callback) {
      var _this4 = this;

      var active = true;

      this.nextCallback = function (event) {
        if (active) {
          active = false;
          _this4.nextCallback = null;
          callback(event);
        }
      };

      this.nextCallback.cancel = function () {
        active = false;
      };

      return this.nextCallback;
    };

    _proto.onTransitionEnd = function onTransitionEnd(node, timeout, handler) {
      this.setNextCallback(handler);

      if (node) {
        if (this.props.addEndListener) {
          this.props.addEndListener(node, this.nextCallback);
        }

        if (timeout != null) {
          setTimeout(this.nextCallback, timeout);
        }
      } else {
        setTimeout(this.nextCallback, 0);
      }
    };

    _proto.render = function render() {
      var status = this.state.status;

      if (status === UNMOUNTED) {
        return null;
      }

      var _this$props = this.props,
          children = _this$props.children,
          childProps = _objectWithoutPropertiesLoose(_this$props, ["children"]); // filter props for Transtition


      delete childProps.in;
      delete childProps.mountOnEnter;
      delete childProps.unmountOnExit;
      delete childProps.appear;
      delete childProps.enter;
      delete childProps.exit;
      delete childProps.timeout;
      delete childProps.addEndListener;
      delete childProps.onEnter;
      delete childProps.onEntering;
      delete childProps.onEntered;
      delete childProps.onExit;
      delete childProps.onExiting;
      delete childProps.onExited;

      if (typeof children === 'function') {
        return children(status, childProps);
      }

      var child = _react.default.Children.only(children);

      return _react.default.cloneElement(child, childProps);
    };

    return Transition;
  }(_react.default.Component);

  Transition.contextTypes = {
    transitionGroup: PropTypes$$1.object
  };
  Transition.childContextTypes = {
    transitionGroup: function transitionGroup() {}
  };
  Transition.propTypes = {
    /**
     * A `function` child can be used instead of a React element.
     * This function is called with the current transition status
     * ('entering', 'entered', 'exiting', 'exited', 'unmounted'), which can be used
     * to apply context specific props to a component.
     *
     * ```jsx
     * <Transition timeout={150}>
     *   {(status) => (
     *     <MyComponent className={`fade fade-${status}`} />
     *   )}
     * </Transition>
     * ```
     */
    children: PropTypes$$1.oneOfType([PropTypes$$1.func.isRequired, PropTypes$$1.element.isRequired]).isRequired,

    /**
     * Show the component; triggers the enter or exit states
     */
    in: PropTypes$$1.bool,

    /**
     * By default the child component is mounted immediately along with
     * the parent `Transition` component. If you want to "lazy mount" the component on the
     * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay
     * mounted, even on "exited", unless you also specify `unmountOnExit`.
     */
    mountOnEnter: PropTypes$$1.bool,

    /**
     * By default the child component stays mounted after it reaches the `'exited'` state.
     * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.
     */
    unmountOnExit: PropTypes$$1.bool,

    /**
     * Normally a component is not transitioned if it is shown when the `<Transition>` component mounts.
     * If you want to transition on the first mount set `appear` to `true`, and the
     * component will transition in as soon as the `<Transition>` mounts.
     *
     * > Note: there are no specific "appear" states. `appear` only adds an additional `enter` transition.
     */
    appear: PropTypes$$1.bool,

    /**
     * Enable or disable enter transitions.
     */
    enter: PropTypes$$1.bool,

    /**
     * Enable or disable exit transitions.
     */
    exit: PropTypes$$1.bool,

    /**
     * The duration of the transition, in milliseconds.
     * Required unless `addEndListener` is provided
     *
     * You may specify a single timeout for all transitions like: `timeout={500}`,
     * or individually like:
     *
     * ```jsx
     * timeout={{
     *  enter: 300,
     *  exit: 500,
     * }}
     * ```
     *
     * @type {number | { enter?: number, exit?: number }}
     */
    timeout: function timeout(props) {
      var pt = PropTypes.timeoutsShape;    if (!props.addEndListener) pt = pt.isRequired;

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return pt.apply(void 0, [props].concat(args));
    },

    /**
     * Add a custom transition end trigger. Called with the transitioning
     * DOM node and a `done` callback. Allows for more fine grained transition end
     * logic. **Note:** Timeouts are still used as a fallback if provided.
     *
     * ```jsx
     * addEndListener={(node, done) => {
     *   // use the css transitionend event to mark the finish of a transition
     *   node.addEventListener('transitionend', done, false);
     * }}
     * ```
     */
    addEndListener: PropTypes$$1.func,

    /**
     * Callback fired before the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEnter: PropTypes$$1.func,

    /**
     * Callback fired after the "entering" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * @type Function(node: HtmlElement, isAppearing: bool)
     */
    onEntering: PropTypes$$1.func,

    /**
     * Callback fired after the "entered" status is applied. An extra parameter
     * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount
     *
     * @type Function(node: HtmlElement, isAppearing: bool) -> void
     */
    onEntered: PropTypes$$1.func,

    /**
     * Callback fired before the "exiting" status is applied.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExit: PropTypes$$1.func,

    /**
     * Callback fired after the "exiting" status is applied.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExiting: PropTypes$$1.func,

    /**
     * Callback fired after the "exited" status is applied.
     *
     * @type Function(node: HtmlElement) -> void
     */
    onExited: PropTypes$$1.func // Name the function so it is clearer in the documentation

  };

  function noop() {}

  Transition.defaultProps = {
    in: false,
    mountOnEnter: false,
    unmountOnExit: false,
    appear: false,
    enter: true,
    exit: true,
    onEnter: noop,
    onEntering: noop,
    onEntered: noop,
    onExit: noop,
    onExiting: noop,
    onExited: noop
  };
  Transition.UNMOUNTED = 0;
  Transition.EXITED = 1;
  Transition.ENTERING = 2;
  Transition.ENTERED = 3;
  Transition.EXITING = 4;

  var _default = (0, reactLifecyclesCompat_es.polyfill)(Transition);

  exports.default = _default;
  });

  var Transition = unwrapExports(Transition_1);
  var Transition_2 = Transition_1.EXITING;
  var Transition_3 = Transition_1.ENTERED;
  var Transition_4 = Transition_1.ENTERING;
  var Transition_5 = Transition_1.EXITED;
  var Transition_6 = Transition_1.UNMOUNTED;

  var reflow = function reflow(node) {
    return node.scrollTop;
  };
  function getTransitionProps(props, options) {
    var timeout = props.timeout,
        _props$style = props.style,
        style = _props$style === void 0 ? {} : _props$style;
    return {
      duration: style.transitionDuration || typeof timeout === 'number' ? timeout : timeout[options.mode],
      delay: style.transitionDelay
    };
  }

  var styles$3 = {
    entering: {
      opacity: 1
    },
    entered: {
      opacity: 1
    }
  };
  /**
   * The Fade transition is used by the [Modal](/utils/modal/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Fade =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Fade, _React$Component);

    function Fade() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Fade);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Fade)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.handleEnter = function (node) {
        var theme = _this.props.theme;
        reflow(node); // So the animation always start from the start.

        var transitionProps = getTransitionProps(_this.props, {
          mode: 'enter'
        });
        node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
        node.style.transition = theme.transitions.create('opacity', transitionProps);

        if (_this.props.onEnter) {
          _this.props.onEnter(node);
        }
      };

      _this.handleExit = function (node) {
        var theme = _this.props.theme;
        var transitionProps = getTransitionProps(_this.props, {
          mode: 'exit'
        });
        node.style.webkitTransition = theme.transitions.create('opacity', transitionProps);
        node.style.transition = theme.transitions.create('opacity', transitionProps);

        if (_this.props.onExit) {
          _this.props.onExit(node);
        }
      };

      return _this;
    }

    createClass(Fade, [{
      key: "render",
      value: function render() {
        var _this$props = this.props,
            children = _this$props.children,
            onEnter = _this$props.onEnter,
            onExit = _this$props.onExit,
            styleProp = _this$props.style,
            theme = _this$props.theme,
            other = objectWithoutProperties(_this$props, ["children", "onEnter", "onExit", "style", "theme"]);

        var style = _extends_1({}, styleProp, React.isValidElement(children) ? children.props.style : {});

        return React.createElement(Transition, _extends_1({
          appear: true,
          onEnter: this.handleEnter,
          onExit: this.handleExit
        }, other), function (state, childProps) {
          return React.cloneElement(children, _extends_1({
            style: _extends_1({
              opacity: 0
            }, styles$3[state], style)
          }, childProps));
        });
      }
    }]);

    return Fade;
  }(React.Component);

  Fade.propTypes = {
    /**
     * A single child content element.
     */
    children: propTypes.oneOfType([propTypes.element, propTypes.func]),

    /**
     * If `true`, the component will transition in.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })])
  };
  Fade.defaultProps = {
    timeout: {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    }
  };
  var Fade$1 = withTheme()(Fade);

  var styles$4 = {
    /* Styles applied to the root element. */
    root: {
      zIndex: -1,
      position: 'fixed',
      right: 0,
      bottom: 0,
      top: 0,
      left: 0,
      backgroundColor: 'rgba(0, 0, 0, 0.5)',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      // Disable scroll capabilities.
      touchAction: 'none'
    },

    /* Styles applied to the root element if `invisible={true}`. */
    invisible: {
      backgroundColor: 'transparent'
    }
  };

  function Backdrop(props) {
    var classes = props.classes,
        className = props.className,
        invisible = props.invisible,
        open = props.open,
        transitionDuration = props.transitionDuration,
        other = objectWithoutProperties(props, ["classes", "className", "invisible", "open", "transitionDuration"]);

    return React.createElement(Fade$1, _extends_1({
      in: open,
      timeout: transitionDuration
    }, other), React.createElement("div", {
      className: classnames(classes.root, defineProperty({}, classes.invisible, invisible), className),
      "aria-hidden": "true"
    }));
  }

  Backdrop.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the backdrop is invisible.
     * It can be used when rendering a popover or a custom select component.
     */
    invisible: propTypes.bool,

    /**
     * If `true`, the backdrop is open.
     */
    open: propTypes.bool.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })])
  };
  Backdrop.defaultProps = {
    invisible: false
  };
  var Backdrop$1 = withStyles(styles$4, {
    name: 'MuiBackdrop'
  })(Backdrop);

  var RADIUS = 10;
  var styles$5 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        display: 'inline-flex',
        // For correct alignment with the text.
        verticalAlign: 'middle'
      },

      /* Styles applied to the badge `span` element. */
      badge: {
        display: 'flex',
        flexDirection: 'row',
        flexWrap: 'wrap',
        justifyContent: 'center',
        alignContent: 'center',
        alignItems: 'center',
        position: 'absolute',
        top: 0,
        right: 0,
        boxSizing: 'border-box',
        fontFamily: theme.typography.fontFamily,
        fontWeight: theme.typography.fontWeightMedium,
        fontSize: theme.typography.pxToRem(12),
        minWidth: RADIUS * 2,
        padding: '0 4px',
        height: RADIUS * 2,
        borderRadius: RADIUS,
        backgroundColor: theme.palette.color,
        color: theme.palette.textColor,
        zIndex: 1,
        // Render the badge on top of potential ripples.
        transform: 'scale(1) translate(50%, -50%)',
        transformOrigin: '100% 0%',
        transition: theme.transitions.create('transform', {
          easing: theme.transitions.easing.easeInOut,
          duration: theme.transitions.duration.enteringScreen
        })
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        backgroundColor: theme.palette.primary.main,
        color: theme.palette.primary.contrastText
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        backgroundColor: theme.palette.secondary.main,
        color: theme.palette.secondary.contrastText
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        backgroundColor: theme.palette.error.main,
        color: theme.palette.error.contrastText
      },

      /* Styles applied to the badge `span` element if `invisible={true}`. */
      invisible: {
        transition: theme.transitions.create('transform', {
          easing: theme.transitions.easing.easeInOut,
          duration: theme.transitions.duration.leavingScreen
        }),
        transform: 'scale(0) translate(50%, -50%)',
        transformOrigin: '100% 0%'
      },

      /* Styles applied to the root element if `variant="dot"`. */
      dot: {
        height: 6,
        minWidth: 6,
        padding: 0
      }
    };
  };

  function Badge(props) {
    var _classNames;

    var badgeContent = props.badgeContent,
        children = props.children,
        classes = props.classes,
        className = props.className,
        color = props.color,
        ComponentProp = props.component,
        invisibleProp = props.invisible,
        showZero = props.showZero,
        max = props.max,
        variant = props.variant,
        other = objectWithoutProperties(props, ["badgeContent", "children", "classes", "className", "color", "component", "invisible", "showZero", "max", "variant"]);

    var invisible = invisibleProp;

    if (invisibleProp == null && Number(badgeContent) === 0 && !showZero) {
      invisible = true;
    }

    var badgeClassName = classnames(classes.badge, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'default'), defineProperty(_classNames, classes.invisible, invisible), defineProperty(_classNames, classes.dot, variant === 'dot'), _classNames));
    var displayValue = '';

    if (variant !== 'dot') {
      displayValue = badgeContent > max ? "".concat(max, "+") : badgeContent;
    }

    return React.createElement(ComponentProp, _extends_1({
      className: classnames(classes.root, className)
    }, other), children, React.createElement("span", {
      className: badgeClassName
    }, displayValue));
  }

  Badge.propTypes = {
    /**
     * The content rendered within the badge.
     */
    badgeContent: propTypes.node,

    /**
     * The badge will be added relative to this node.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'primary', 'secondary', 'error']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the badge will be invisible.
     */
    invisible: propTypes.bool,

    /**
     * Max count to show.
     */
    max: propTypes.number,

    /**
     * Controls whether the badge is hidden when `badgeContent` is zero.
     */
    showZero: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'dot'])
  };
  Badge.defaultProps = {
    color: 'default',
    component: 'span',
    max: 99,
    showZero: false,
    variant: 'standard'
  };
  var Badge$1 = withStyles(styles$5, {
    name: 'MuiBadge'
  })(Badge);

  var styles$6 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        justifyContent: 'center',
        height: 56,
        backgroundColor: theme.palette.background.paper
      }
    };
  };

  function BottomNavigation(props) {
    var childrenProp = props.children,
        classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        onChange = props.onChange,
        showLabels = props.showLabels,
        value = props.value,
        other = objectWithoutProperties(props, ["children", "classes", "className", "component", "onChange", "showLabels", "value"]);

    var className = classnames(classes.root, classNameProp);
    var children = React.Children.map(childrenProp, function (child, childIndex) {
      if (!React.isValidElement(child)) {
        return null;
      }

      warning_1(child.type !== React.Fragment, ["Material-UI: the BottomNavigation component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      var childValue = child.props.value === undefined ? childIndex : child.props.value;
      return React.cloneElement(child, {
        selected: childValue === value,
        showLabel: child.props.showLabel !== undefined ? child.props.showLabel : showLabels,
        value: childValue,
        onChange: onChange
      });
    });
    return React.createElement(Component, _extends_1({
      className: className
    }, other), children);
  }

  BottomNavigation.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Callback fired when the value changes.
     *
     * @param {object} event The event source of the callback
     * @param {any} value We default to the index of the child
     */
    onChange: propTypes.func,

    /**
     * If `true`, all `BottomNavigationAction`s will show their labels.
     * By default, only the selected `BottomNavigationAction` will show its label.
     */
    showLabels: propTypes.bool,

    /**
     * The value of the currently selected `BottomNavigationAction`.
     */
    value: propTypes.any
  };
  BottomNavigation.defaultProps = {
    component: 'div',
    showLabels: false
  };
  var BottomNavigation$1 = withStyles(styles$6, {
    name: 'MuiBottomNavigation'
  })(BottomNavigation);

  function ownerDocument(node) {
    return node && node.ownerDocument || document;
  }

  function ownerWindow(node) {
    var fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : window;
    var doc = ownerDocument(node);
    return doc.defaultView || doc.parentView || fallback;
  }

  /**
   * NoSsr purposely removes components from the subject of Server Side Rendering (SSR).
   *
   * This component can be useful in a variety of situations:
   * - Escape hatch for broken dependencies not supporting SSR.
   * - Improve the time-to-first paint on the client by only rendering above the fold.
   * - Reduce the rendering time on the server.
   * - Under too heavy server load, you can turn on service degradation.
   */

  var NoSsr =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(NoSsr, _React$Component);

    function NoSsr() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, NoSsr);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(NoSsr)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.mounted = false;
      _this.state = {
        mounted: false
      };
      return _this;
    }

    createClass(NoSsr, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        this.mounted = true;

        if (this.props.defer) {
          // Wondering why we use two RAFs? Check this video out:
          // https://www.youtube.com/watch?v=cCOL7MC4Pl0
          //
          // The componentDidMount() method is called after the DOM nodes are inserted.
          // The UI might not have rendering the changes. We request a frame.
          requestAnimationFrame(function () {
            // The browser should be about to render the DOM nodes
            // that React committed at this point.
            // We don't want to interrupt. Let's wait the next frame.
            requestAnimationFrame(function () {
              // The UI is up-to-date at this point.
              // We can continue rendering the children.
              if (_this2.mounted) {
                _this2.setState({
                  mounted: true
                });
              }
            });
          });
        } else {
          this.setState({
            mounted: true
          });
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.mounted = false;
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            children = _this$props.children,
            fallback = _this$props.fallback;
        return this.state.mounted ? children : fallback;
      }
    }]);

    return NoSsr;
  }(React.Component);

  NoSsr.propTypes = {
    children: propTypes.node.isRequired,

    /**
     * If `true`, the component will not only prevent server-side rendering.
     * It will also defer the rendering of the children into a different screen frame.
     */
    defer: propTypes.bool,

    /**
     * The fallback content to display.
     */
    fallback: propTypes.node
  };

  {
    NoSsr.propTypes = exactProp(NoSsr.propTypes);
  }

  NoSsr.defaultProps = {
    defer: false,
    fallback: null
  };

  var internal = {
    focusKeyPressed: false,
    keyUpEventTimeout: -1
  };

  function findActiveElement(doc) {
    var activeElement = doc.activeElement;

    while (activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement) {
      activeElement = activeElement.shadowRoot.activeElement;
    }

    return activeElement;
  }

  function detectFocusVisible(instance, element, callback) {
    var attempt = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    warning_1(instance.focusVisibleCheckTime, 'Material-UI: missing instance.focusVisibleCheckTime.');
    warning_1(instance.focusVisibleMaxCheckTimes, 'Material-UI: missing instance.focusVisibleMaxCheckTimes.');
    instance.focusVisibleTimeout = setTimeout(function () {
      var doc = ownerDocument(element);
      var activeElement = findActiveElement(doc);

      if (internal.focusKeyPressed && (activeElement === element || element.contains(activeElement))) {
        callback();
      } else if (attempt < instance.focusVisibleMaxCheckTimes) {
        detectFocusVisible(instance, element, callback, attempt + 1);
      }
    }, instance.focusVisibleCheckTime);
  }
  var FOCUS_KEYS = [9, // 'Tab',
  13, // 'Enter',
  27, // 'Escape',
  32, // ' ',
  37, // 'ArrowLeft',
  38, // 'ArrowUp',
  39, // 'ArrowRight',
  40];

  function isFocusKey(event) {
    // Use event.keyCode to support IE 11
    return FOCUS_KEYS.indexOf(event.keyCode) > -1;
  }

  var handleKeyUpEvent = function handleKeyUpEvent(event) {
    if (isFocusKey(event)) {
      internal.focusKeyPressed = true; // Let's consider that the user is using a keyboard during a window frame of 500ms.

      clearTimeout(internal.keyUpEventTimeout);
      internal.keyUpEventTimeout = setTimeout(function () {
        internal.focusKeyPressed = false;
      }, 500);
    }
  };

  function listenForFocusKeys(win) {
    // The event listener will only be added once per window.
    // Duplicate event listeners will be ignored by addEventListener.
    // Also, this logic is client side only, we don't need a teardown.
    win.addEventListener('keyup', handleKeyUpEvent);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  var arrayWithoutHoles = _arrayWithoutHoles;

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  var iterableToArray = _iterableToArray;

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  var nonIterableSpread = _nonIterableSpread;

  function _toConsumableArray(arr) {
    return arrayWithoutHoles(arr) || iterableToArray(arr) || nonIterableSpread();
  }

  var toConsumableArray = _toConsumableArray;

  var ChildMapping = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.getChildMapping = getChildMapping;
  exports.mergeChildMappings = mergeChildMappings;
  exports.getInitialChildMapping = getInitialChildMapping;
  exports.getNextChildMapping = getNextChildMapping;



  /**
   * Given `this.props.children`, return an object mapping key to child.
   *
   * @param {*} children `this.props.children`
   * @return {object} Mapping of key to child
   */
  function getChildMapping(children, mapFn) {
    var mapper = function mapper(child) {
      return mapFn && (0, React.isValidElement)(child) ? mapFn(child) : child;
    };

    var result = Object.create(null);
    if (children) React.Children.map(children, function (c) {
      return c;
    }).forEach(function (child) {
      // run the map function here instead so that the key is the computed one
      result[child.key] = mapper(child);
    });
    return result;
  }
  /**
   * When you're adding or removing children some may be added or removed in the
   * same render pass. We want to show *both* since we want to simultaneously
   * animate elements in and out. This function takes a previous set of keys
   * and a new set of keys and merges them with its best guess of the correct
   * ordering. In the future we may expose some of the utilities in
   * ReactMultiChild to make this easy, but for now React itself does not
   * directly have this concept of the union of prevChildren and nextChildren
   * so we implement it here.
   *
   * @param {object} prev prev children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @param {object} next next children as returned from
   * `ReactTransitionChildMapping.getChildMapping()`.
   * @return {object} a key set that contains all keys in `prev` and all keys
   * in `next` in a reasonable order.
   */


  function mergeChildMappings(prev, next) {
    prev = prev || {};
    next = next || {};

    function getValueForKey(key) {
      return key in next ? next[key] : prev[key];
    } // For each key of `next`, the list of keys to insert before that key in
    // the combined list


    var nextKeysPending = Object.create(null);
    var pendingKeys = [];

    for (var prevKey in prev) {
      if (prevKey in next) {
        if (pendingKeys.length) {
          nextKeysPending[prevKey] = pendingKeys;
          pendingKeys = [];
        }
      } else {
        pendingKeys.push(prevKey);
      }
    }

    var i;
    var childMapping = {};

    for (var nextKey in next) {
      if (nextKeysPending[nextKey]) {
        for (i = 0; i < nextKeysPending[nextKey].length; i++) {
          var pendingNextKey = nextKeysPending[nextKey][i];
          childMapping[nextKeysPending[nextKey][i]] = getValueForKey(pendingNextKey);
        }
      }

      childMapping[nextKey] = getValueForKey(nextKey);
    } // Finally, add the keys which didn't appear before any key in `next`


    for (i = 0; i < pendingKeys.length; i++) {
      childMapping[pendingKeys[i]] = getValueForKey(pendingKeys[i]);
    }

    return childMapping;
  }

  function getProp(child, prop, props) {
    return props[prop] != null ? props[prop] : child.props[prop];
  }

  function getInitialChildMapping(props, onExited) {
    return getChildMapping(props.children, function (child) {
      return (0, React.cloneElement)(child, {
        onExited: onExited.bind(null, child),
        in: true,
        appear: getProp(child, 'appear', props),
        enter: getProp(child, 'enter', props),
        exit: getProp(child, 'exit', props)
      });
    });
  }

  function getNextChildMapping(nextProps, prevChildMapping, onExited) {
    var nextChildMapping = getChildMapping(nextProps.children);
    var children = mergeChildMappings(prevChildMapping, nextChildMapping);
    Object.keys(children).forEach(function (key) {
      var child = children[key];
      if (!(0, React.isValidElement)(child)) return;
      var hasPrev = key in prevChildMapping;
      var hasNext = key in nextChildMapping;
      var prevChild = prevChildMapping[key];
      var isLeaving = (0, React.isValidElement)(prevChild) && !prevChild.props.in; // item is new (entering)

      if (hasNext && (!hasPrev || isLeaving)) {
        // console.log('entering', key)
        children[key] = (0, React.cloneElement)(child, {
          onExited: onExited.bind(null, child),
          in: true,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      } else if (!hasNext && hasPrev && !isLeaving) {
        // item is old (exiting)
        // console.log('leaving', key)
        children[key] = (0, React.cloneElement)(child, {
          in: false
        });
      } else if (hasNext && hasPrev && (0, React.isValidElement)(prevChild)) {
        // item hasn't changed transition states
        // copy over the last transition props;
        // console.log('unchanged', key)
        children[key] = (0, React.cloneElement)(child, {
          onExited: onExited.bind(null, child),
          in: prevChild.props.in,
          exit: getProp(child, 'exit', nextProps),
          enter: getProp(child, 'enter', nextProps)
        });
      }
    });
    return children;
  }
  });

  unwrapExports(ChildMapping);
  var ChildMapping_1 = ChildMapping.getChildMapping;
  var ChildMapping_2 = ChildMapping.mergeChildMappings;
  var ChildMapping_3 = ChildMapping.getInitialChildMapping;
  var ChildMapping_4 = ChildMapping.getNextChildMapping;

  var TransitionGroup_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = void 0;

  var _propTypes = _interopRequireDefault(propTypes);

  var _react = _interopRequireDefault(React);





  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

  function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

  function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

  var values = Object.values || function (obj) {
    return Object.keys(obj).map(function (k) {
      return obj[k];
    });
  };

  var defaultProps = {
    component: 'div',
    childFactory: function childFactory(child) {
      return child;
    }
    /**
     * The `<TransitionGroup>` component manages a set of transition components
     * (`<Transition>` and `<CSSTransition>`) in a list. Like with the transition
     * components, `<TransitionGroup>` is a state machine for managing the mounting
     * and unmounting of components over time.
     *
     * Consider the example below. As items are removed or added to the TodoList the
     * `in` prop is toggled automatically by the `<TransitionGroup>`.
     *
     * Note that `<TransitionGroup>`  does not define any animation behavior!
     * Exactly _how_ a list item animates is up to the individual transition
     * component. This means you can mix and match animations across different list
     * items.
     */

  };

  var TransitionGroup =
  /*#__PURE__*/
  function (_React$Component) {
    _inheritsLoose(TransitionGroup, _React$Component);

    function TransitionGroup(props, context) {
      var _this;

      _this = _React$Component.call(this, props, context) || this;

      var handleExited = _this.handleExited.bind(_assertThisInitialized(_assertThisInitialized(_this))); // Initial children should all be entering, dependent on appear


      _this.state = {
        handleExited: handleExited,
        firstRender: true
      };
      return _this;
    }

    var _proto = TransitionGroup.prototype;

    _proto.getChildContext = function getChildContext() {
      return {
        transitionGroup: {
          isMounting: !this.appeared
        }
      };
    };

    _proto.componentDidMount = function componentDidMount() {
      this.appeared = true;
      this.mounted = true;
    };

    _proto.componentWillUnmount = function componentWillUnmount() {
      this.mounted = false;
    };

    TransitionGroup.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, _ref) {
      var prevChildMapping = _ref.children,
          handleExited = _ref.handleExited,
          firstRender = _ref.firstRender;
      return {
        children: firstRender ? (0, ChildMapping.getInitialChildMapping)(nextProps, handleExited) : (0, ChildMapping.getNextChildMapping)(nextProps, prevChildMapping, handleExited),
        firstRender: false
      };
    };

    _proto.handleExited = function handleExited(child, node) {
      var currentChildMapping = (0, ChildMapping.getChildMapping)(this.props.children);
      if (child.key in currentChildMapping) return;

      if (child.props.onExited) {
        child.props.onExited(node);
      }

      if (this.mounted) {
        this.setState(function (state) {
          var children = _extends({}, state.children);

          delete children[child.key];
          return {
            children: children
          };
        });
      }
    };

    _proto.render = function render() {
      var _this$props = this.props,
          Component = _this$props.component,
          childFactory = _this$props.childFactory,
          props = _objectWithoutPropertiesLoose(_this$props, ["component", "childFactory"]);

      var children = values(this.state.children).map(childFactory);
      delete props.appear;
      delete props.enter;
      delete props.exit;

      if (Component === null) {
        return children;
      }

      return _react.default.createElement(Component, props, children);
    };

    return TransitionGroup;
  }(_react.default.Component);

  TransitionGroup.childContextTypes = {
    transitionGroup: _propTypes.default.object.isRequired
  };
  TransitionGroup.propTypes = {
    /**
     * `<TransitionGroup>` renders a `<div>` by default. You can change this
     * behavior by providing a `component` prop.
     * If you use React v16+ and would like to avoid a wrapping `<div>` element
     * you can pass in `component={null}`. This is useful if the wrapping div
     * borks your css styles.
     */
    component: _propTypes.default.any,

    /**
     * A set of `<Transition>` components, that are toggled `in` and out as they
     * leave. the `<TransitionGroup>` will inject specific transition props, so
     * remember to spread them through if you are wrapping the `<Transition>` as
     * with our `<Fade>` example.
     */
    children: _propTypes.default.node,

    /**
     * A convenience prop that enables or disables appear animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    appear: _propTypes.default.bool,

    /**
     * A convenience prop that enables or disables enter animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    enter: _propTypes.default.bool,

    /**
     * A convenience prop that enables or disables exit animations
     * for all children. Note that specifying this will override any defaults set
     * on individual children Transitions.
     */
    exit: _propTypes.default.bool,

    /**
     * You may need to apply reactive updates to a child as it is exiting.
     * This is generally done by using `cloneElement` however in the case of an exiting
     * child the element has already been removed and not accessible to the consumer.
     *
     * If you do need to update a child as it leaves you can provide a `childFactory`
     * to wrap every child, even the ones that are leaving.
     *
     * @type Function(child: ReactElement) -> ReactElement
     */
    childFactory: _propTypes.default.func
  };
  TransitionGroup.defaultProps = defaultProps;

  var _default = (0, reactLifecyclesCompat_es.polyfill)(TransitionGroup);

  exports.default = _default;
  module.exports = exports["default"];
  });

  var TransitionGroup = unwrapExports(TransitionGroup_1);

  /**
   * @ignore - internal component.
   */

  var Ripple =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Ripple, _React$Component);

    function Ripple() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Ripple);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Ripple)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {
        visible: false,
        leaving: false
      };

      _this.handleEnter = function () {
        _this.setState({
          visible: true
        });
      };

      _this.handleExit = function () {
        _this.setState({
          leaving: true
        });
      };

      return _this;
    }

    createClass(Ripple, [{
      key: "render",
      value: function render() {
        var _classNames, _classNames2;

        var _this$props = this.props,
            classes = _this$props.classes,
            classNameProp = _this$props.className,
            pulsate = _this$props.pulsate,
            rippleX = _this$props.rippleX,
            rippleY = _this$props.rippleY,
            rippleSize = _this$props.rippleSize,
            other = objectWithoutProperties(_this$props, ["classes", "className", "pulsate", "rippleX", "rippleY", "rippleSize"]);

        var _this$state = this.state,
            visible = _this$state.visible,
            leaving = _this$state.leaving;
        var rippleClassName = classnames(classes.ripple, (_classNames = {}, defineProperty(_classNames, classes.rippleVisible, visible), defineProperty(_classNames, classes.ripplePulsate, pulsate), _classNames), classNameProp);
        var rippleStyles = {
          width: rippleSize,
          height: rippleSize,
          top: -(rippleSize / 2) + rippleY,
          left: -(rippleSize / 2) + rippleX
        };
        var childClassName = classnames(classes.child, (_classNames2 = {}, defineProperty(_classNames2, classes.childLeaving, leaving), defineProperty(_classNames2, classes.childPulsate, pulsate), _classNames2));
        return React.createElement(Transition, _extends_1({
          onEnter: this.handleEnter,
          onExit: this.handleExit
        }, other), React.createElement("span", {
          className: rippleClassName,
          style: rippleStyles
        }, React.createElement("span", {
          className: childClassName
        })));
      }
    }]);

    return Ripple;
  }(React.Component);

  Ripple.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the ripple pulsates, typically indicating the keyboard focus state of an element.
     */
    pulsate: propTypes.bool,

    /**
     * Diameter of the ripple.
     */
    rippleSize: propTypes.number,

    /**
     * Horizontal position of the ripple center.
     */
    rippleX: propTypes.number,

    /**
     * Vertical position of the ripple center.
     */
    rippleY: propTypes.number
  };
  Ripple.defaultProps = {
    pulsate: false
  };

  var DURATION = 550;
  var DELAY_RIPPLE = 80;
  var styles$7 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        position: 'absolute',
        overflow: 'hidden',
        borderRadius: 'inherit',
        width: '100%',
        height: '100%',
        left: 0,
        top: 0,
        pointerEvents: 'none',
        zIndex: 0
      },

      /* Styles applied to the internal `Ripple` components `ripple` class. */
      ripple: {
        width: 50,
        height: 50,
        left: 0,
        top: 0,
        opacity: 0,
        position: 'absolute'
      },

      /* Styles applied to the internal `Ripple` components `rippleVisible` class. */
      rippleVisible: {
        opacity: 0.3,
        transform: 'scale(1)',
        animation: "mui-ripple-enter ".concat(DURATION, "ms ").concat(theme.transitions.easing.easeInOut),
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-ripple-enter'
      },

      /* Styles applied to the internal `Ripple` components `ripplePulsate` class. */
      ripplePulsate: {
        animationDuration: "".concat(theme.transitions.duration.shorter, "ms")
      },

      /* Styles applied to the internal `Ripple` components `child` class. */
      child: {
        opacity: 1,
        display: 'block',
        width: '100%',
        height: '100%',
        borderRadius: '50%',
        backgroundColor: 'currentColor'
      },

      /* Styles applied to the internal `Ripple` components `childLeaving` class. */
      childLeaving: {
        opacity: 0,
        animation: "mui-ripple-exit ".concat(DURATION, "ms ").concat(theme.transitions.easing.easeInOut),
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-ripple-exit'
      },

      /* Styles applied to the internal `Ripple` components `childPulsate` class. */
      childPulsate: {
        position: 'absolute',
        left: 0,
        top: 0,
        animation: "mui-ripple-pulsate 2500ms ".concat(theme.transitions.easing.easeInOut, " 200ms infinite"),
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-ripple-pulsate'
      },
      '@keyframes mui-ripple-enter': {
        '0%': {
          transform: 'scale(0)',
          opacity: 0.1
        },
        '100%': {
          transform: 'scale(1)',
          opacity: 0.3
        }
      },
      '@keyframes mui-ripple-exit': {
        '0%': {
          opacity: 1
        },
        '100%': {
          opacity: 0
        }
      },
      '@keyframes mui-ripple-pulsate': {
        '0%': {
          transform: 'scale(1)'
        },
        '50%': {
          transform: 'scale(0.92)'
        },
        '100%': {
          transform: 'scale(1)'
        }
      }
    };
  };

  var TouchRipple =
  /*#__PURE__*/
  function (_React$PureComponent) {
    inherits(TouchRipple, _React$PureComponent);

    function TouchRipple() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, TouchRipple);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(TouchRipple)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {
        nextKey: 0,
        ripples: []
      };

      _this.pulsate = function () {
        _this.start({}, {
          pulsate: true
        });
      };

      _this.start = function () {
        var event = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var cb = arguments.length > 2 ? arguments[2] : undefined;
        var _options$pulsate = options.pulsate,
            pulsate = _options$pulsate === void 0 ? false : _options$pulsate,
            _options$center = options.center,
            center = _options$center === void 0 ? _this.props.center || options.pulsate : _options$center,
            _options$fakeElement = options.fakeElement,
            fakeElement = _options$fakeElement === void 0 ? false : _options$fakeElement;

        if (event.type === 'mousedown' && _this.ignoringMouseDown) {
          _this.ignoringMouseDown = false;
          return;
        }

        if (event.type === 'touchstart') {
          _this.ignoringMouseDown = true;
        }

        var element = fakeElement ? null : ReactDOM.findDOMNode(assertThisInitialized(assertThisInitialized(_this)));
        var rect = element ? element.getBoundingClientRect() : {
          width: 0,
          height: 0,
          left: 0,
          top: 0
        }; // Get the size of the ripple

        var rippleX;
        var rippleY;
        var rippleSize;

        if (center || event.clientX === 0 && event.clientY === 0 || !event.clientX && !event.touches) {
          rippleX = Math.round(rect.width / 2);
          rippleY = Math.round(rect.height / 2);
        } else {
          var clientX = event.clientX ? event.clientX : event.touches[0].clientX;
          var clientY = event.clientY ? event.clientY : event.touches[0].clientY;
          rippleX = Math.round(clientX - rect.left);
          rippleY = Math.round(clientY - rect.top);
        }

        if (center) {
          rippleSize = Math.sqrt((2 * Math.pow(rect.width, 2) + Math.pow(rect.height, 2)) / 3); // For some reason the animation is broken on Mobile Chrome if the size if even.

          if (rippleSize % 2 === 0) {
            rippleSize += 1;
          }
        } else {
          var sizeX = Math.max(Math.abs((element ? element.clientWidth : 0) - rippleX), rippleX) * 2 + 2;
          var sizeY = Math.max(Math.abs((element ? element.clientHeight : 0) - rippleY), rippleY) * 2 + 2;
          rippleSize = Math.sqrt(Math.pow(sizeX, 2) + Math.pow(sizeY, 2));
        } // Touche devices


        if (event.touches) {
          // Prepare the ripple effect.
          _this.startTimerCommit = function () {
            _this.startCommit({
              pulsate: pulsate,
              rippleX: rippleX,
              rippleY: rippleY,
              rippleSize: rippleSize,
              cb: cb
            });
          }; // Delay the execution of the ripple effect.


          _this.startTimer = setTimeout(function () {
            if (_this.startTimerCommit) {
              _this.startTimerCommit();

              _this.startTimerCommit = null;
            }
          }, DELAY_RIPPLE); // We have to make a tradeoff with this value.
        } else {
          _this.startCommit({
            pulsate: pulsate,
            rippleX: rippleX,
            rippleY: rippleY,
            rippleSize: rippleSize,
            cb: cb
          });
        }
      };

      _this.startCommit = function (params) {
        var pulsate = params.pulsate,
            rippleX = params.rippleX,
            rippleY = params.rippleY,
            rippleSize = params.rippleSize,
            cb = params.cb;

        _this.setState(function (state) {
          return {
            nextKey: state.nextKey + 1,
            ripples: [].concat(toConsumableArray(state.ripples), [React.createElement(Ripple, {
              key: state.nextKey,
              classes: _this.props.classes,
              timeout: {
                exit: DURATION,
                enter: DURATION
              },
              pulsate: pulsate,
              rippleX: rippleX,
              rippleY: rippleY,
              rippleSize: rippleSize
            })])
          };
        }, cb);
      };

      _this.stop = function (event, cb) {
        clearTimeout(_this.startTimer);
        var ripples = _this.state.ripples; // The touch interaction occurs too quickly.
        // We still want to show ripple effect.

        if (event.type === 'touchend' && _this.startTimerCommit) {
          event.persist();

          _this.startTimerCommit();

          _this.startTimerCommit = null;
          _this.startTimer = setTimeout(function () {
            _this.stop(event, cb);
          });
          return;
        }

        _this.startTimerCommit = null;

        if (ripples && ripples.length) {
          _this.setState({
            ripples: ripples.slice(1)
          }, cb);
        }
      };

      return _this;
    }

    createClass(TouchRipple, [{
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.startTimer);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            center = _this$props.center,
            classes = _this$props.classes,
            className = _this$props.className,
            other = objectWithoutProperties(_this$props, ["center", "classes", "className"]);

        return React.createElement(TransitionGroup, _extends_1({
          component: "span",
          enter: true,
          exit: true,
          className: classnames(classes.root, className)
        }, other), this.state.ripples);
      }
    }]);

    return TouchRipple;
  }(React.PureComponent);

  TouchRipple.propTypes = {
    /**
     * If `true`, the ripple starts at the center of the component
     * rather than at the point of interaction.
     */
    center: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  TouchRipple.defaultProps = {
    center: false
  };
  var TouchRipple$1 = withStyles(styles$7, {
    flip: false,
    name: 'MuiTouchRipple'
  })(TouchRipple);

  /* eslint-disable import/no-mutable-exports */
  var createRippleHandler = function createRippleHandler(instance, eventName, action, cb) {
    return function (event) {
      if (cb) {
        cb.call(instance, event);
      }

      var ignore = false; // Ignore events that have been `event.preventDefault()` marked.

      if (event.defaultPrevented) {
        ignore = true;
      }

      if (instance.props.disableTouchRipple && eventName !== 'Blur') {
        ignore = true;
      }

      if (!ignore && instance.ripple) {
        instance.ripple[action](event);
      }

      if (typeof instance.props["on".concat(eventName)] === 'function') {
        instance.props["on".concat(eventName)](event);
      }

      return true;
    };
  };
  /* istanbul ignore if */


  if (typeof window === 'undefined') {
    createRippleHandler = function createRippleHandler() {
      return function () {};
    };
  }

  var createRippleHandler$1 = createRippleHandler;

  var styles$8 = {
    /* Styles applied to the root element. */
    root: {
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      position: 'relative',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      backgroundColor: 'transparent',
      // Reset default value
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 'none',
      border: 0,
      margin: 0,
      // Remove the margin in Safari
      borderRadius: 0,
      padding: 0,
      // Remove the padding in Firefox
      cursor: 'pointer',
      userSelect: 'none',
      verticalAlign: 'middle',
      '-moz-appearance': 'none',
      // Reset
      '-webkit-appearance': 'none',
      // Reset
      textDecoration: 'none',
      // So we take precedent over the style of a native <a /> element.
      color: 'inherit',
      '&::-moz-focus-inner': {
        borderStyle: 'none' // Remove Firefox dotted outline.

      },
      '&$disabled': {
        pointerEvents: 'none',
        // Disable link interactions
        cursor: 'default'
      }
    },

    /* Styles applied to the root element if `disabled={true}`. */
    disabled: {},

    /* Styles applied to the root element if keyboard focused. */
    focusVisible: {}
  };
  /* istanbul ignore if */

  if (!React.createContext) {
    throw new Error('Material-UI: react@16.3.0 or greater is required.');
  }
  /**
   * `ButtonBase` contains as few styles as possible.
   * It aims to be a simple building block for creating a button.
   * It contains a load of style reset and some focus/ripple logic.
   */


  var ButtonBase =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(ButtonBase, _React$Component);

    function ButtonBase() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, ButtonBase);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(ButtonBase)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {};
      _this.keyDown = false;
      _this.focusVisibleCheckTime = 50;
      _this.focusVisibleMaxCheckTimes = 5;
      _this.handleMouseDown = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'MouseDown', 'start', function () {
        clearTimeout(_this.focusVisibleTimeout);

        if (_this.state.focusVisible) {
          _this.setState({
            focusVisible: false
          });
        }
      });
      _this.handleMouseUp = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'MouseUp', 'stop');
      _this.handleMouseLeave = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'MouseLeave', 'stop', function (event) {
        if (_this.state.focusVisible) {
          event.preventDefault();
        }
      });
      _this.handleTouchStart = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'TouchStart', 'start');
      _this.handleTouchEnd = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'TouchEnd', 'stop');
      _this.handleTouchMove = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'TouchMove', 'stop');
      _this.handleContextMenu = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'ContextMenu', 'stop');
      _this.handleBlur = createRippleHandler$1(assertThisInitialized(assertThisInitialized(_this)), 'Blur', 'stop', function () {
        clearTimeout(_this.focusVisibleTimeout);

        if (_this.state.focusVisible) {
          _this.setState({
            focusVisible: false
          });
        }
      });

      _this.onRippleRef = function (node) {
        _this.ripple = node;
      };

      _this.onFocusVisibleHandler = function (event) {
        _this.keyDown = false;

        _this.setState({
          focusVisible: true
        });

        if (_this.props.onFocusVisible) {
          _this.props.onFocusVisible(event);
        }
      };

      _this.handleKeyDown = function (event) {
        var _this$props = _this.props,
            component = _this$props.component,
            focusRipple = _this$props.focusRipple,
            onKeyDown = _this$props.onKeyDown,
            onClick = _this$props.onClick; // Check if key is already down to avoid repeats being counted as multiple activations

        if (focusRipple && !_this.keyDown && _this.state.focusVisible && _this.ripple && event.key === ' ') {
          _this.keyDown = true;
          event.persist();

          _this.ripple.stop(event, function () {
            _this.ripple.start(event);
          });
        }

        if (onKeyDown) {
          onKeyDown(event);
        } // Keyboard accessibility for non interactive elements


        if (event.target === event.currentTarget && component && component !== 'button' && (event.key === ' ' || event.key === 'Enter') && !(_this.button.tagName === 'A' && _this.button.href)) {
          event.preventDefault();

          if (onClick) {
            onClick(event);
          }
        }
      };

      _this.handleKeyUp = function (event) {
        if (_this.props.focusRipple && event.key === ' ' && _this.ripple && _this.state.focusVisible) {
          _this.keyDown = false;
          event.persist();

          _this.ripple.stop(event, function () {
            _this.ripple.pulsate(event);
          });
        }

        if (_this.props.onKeyUp) {
          _this.props.onKeyUp(event);
        }
      };

      _this.handleFocus = function (event) {
        if (_this.props.disabled) {
          return;
        } // Fix for https://github.com/facebook/react/issues/7769


        if (!_this.button) {
          _this.button = event.currentTarget;
        }

        event.persist();
        detectFocusVisible(assertThisInitialized(assertThisInitialized(_this)), _this.button, function () {
          _this.onFocusVisibleHandler(event);
        });

        if (_this.props.onFocus) {
          _this.props.onFocus(event);
        }
      };

      return _this;
    }

    createClass(ButtonBase, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        this.button = ReactDOM.findDOMNode(this);
        listenForFocusKeys(ownerWindow(this.button));

        if (this.props.action) {
          this.props.action({
            focusVisible: function focusVisible() {
              _this2.setState({
                focusVisible: true
              });

              _this2.button.focus();
            }
          });
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps, prevState) {
        if (this.props.focusRipple && !this.props.disableRipple && !prevState.focusVisible && this.state.focusVisible) {
          this.ripple.pulsate();
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.focusVisibleTimeout);
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props2 = this.props,
            action = _this$props2.action,
            buttonRef = _this$props2.buttonRef,
            centerRipple = _this$props2.centerRipple,
            children = _this$props2.children,
            classes = _this$props2.classes,
            classNameProp = _this$props2.className,
            component = _this$props2.component,
            disabled = _this$props2.disabled,
            disableRipple = _this$props2.disableRipple,
            disableTouchRipple = _this$props2.disableTouchRipple,
            focusRipple = _this$props2.focusRipple,
            focusVisibleClassName = _this$props2.focusVisibleClassName,
            onBlur = _this$props2.onBlur,
            onFocus = _this$props2.onFocus,
            onFocusVisible = _this$props2.onFocusVisible,
            onKeyDown = _this$props2.onKeyDown,
            onKeyUp = _this$props2.onKeyUp,
            onMouseDown = _this$props2.onMouseDown,
            onMouseLeave = _this$props2.onMouseLeave,
            onMouseUp = _this$props2.onMouseUp,
            onTouchEnd = _this$props2.onTouchEnd,
            onTouchMove = _this$props2.onTouchMove,
            onTouchStart = _this$props2.onTouchStart,
            tabIndex = _this$props2.tabIndex,
            TouchRippleProps = _this$props2.TouchRippleProps,
            type = _this$props2.type,
            other = objectWithoutProperties(_this$props2, ["action", "buttonRef", "centerRipple", "children", "classes", "className", "component", "disabled", "disableRipple", "disableTouchRipple", "focusRipple", "focusVisibleClassName", "onBlur", "onFocus", "onFocusVisible", "onKeyDown", "onKeyUp", "onMouseDown", "onMouseLeave", "onMouseUp", "onTouchEnd", "onTouchMove", "onTouchStart", "tabIndex", "TouchRippleProps", "type"]);

        var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.focusVisible, this.state.focusVisible), defineProperty(_classNames, focusVisibleClassName, this.state.focusVisible), _classNames), classNameProp);
        var ComponentProp = component;

        if (ComponentProp === 'button' && other.href) {
          ComponentProp = 'a';
        }

        var buttonProps = {};

        if (ComponentProp === 'button') {
          buttonProps.type = type || 'button';
          buttonProps.disabled = disabled;
        } else {
          buttonProps.role = 'button';
        }

        return React.createElement(ComponentProp, _extends_1({
          className: className,
          onBlur: this.handleBlur,
          onFocus: this.handleFocus,
          onKeyDown: this.handleKeyDown,
          onKeyUp: this.handleKeyUp,
          onMouseDown: this.handleMouseDown,
          onMouseLeave: this.handleMouseLeave,
          onMouseUp: this.handleMouseUp,
          onTouchEnd: this.handleTouchEnd,
          onTouchMove: this.handleTouchMove,
          onTouchStart: this.handleTouchStart,
          onContextMenu: this.handleContextMenu,
          ref: buttonRef,
          tabIndex: disabled ? '-1' : tabIndex
        }, buttonProps, other), children, !disableRipple && !disabled ? React.createElement(NoSsr, null, React.createElement(TouchRipple$1, _extends_1({
          innerRef: this.onRippleRef,
          center: centerRipple
        }, TouchRippleProps))) : null);
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(nextProps, prevState) {
        if (typeof prevState.focusVisible === 'undefined') {
          return {
            focusVisible: false,
            lastDisabled: nextProps.disabled
          };
        } // The blur won't fire when the disabled state is set on a focused input.
        // We need to book keep the focused state manually.


        if (!prevState.prevState && nextProps.disabled && prevState.focusVisible) {
          return {
            focusVisible: false,
            lastDisabled: nextProps.disabled
          };
        }

        return {
          lastDisabled: nextProps.disabled
        };
      }
    }]);

    return ButtonBase;
  }(React.Component);

  ButtonBase.propTypes = {
    /**
     * Callback fired when the component mounts.
     * This is useful when you want to trigger an action programmatically.
     * It currently only supports `focusVisible()` action.
     *
     * @param {object} actions This object contains all possible actions
     * that can be triggered programmatically.
     */
    action: propTypes.func,

    /**
     * Use that property to pass a ref callback to the native button component.
     */
    buttonRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * If `true`, the ripples will be centered.
     * They won't start at the cursor interaction position.
     */
    centerRipple: propTypes.bool,

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the base button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * If `true`, the touch ripple effect will be disabled.
     */
    disableTouchRipple: propTypes.bool,

    /**
     * If `true`, the base button will have a keyboard focus ripple.
     * `disableRipple` must also be `false`.
     */
    focusRipple: propTypes.bool,

    /**
     * This property can help a person know which element has the keyboard focus.
     * The class name will be applied when the element gain the focus through a keyboard interaction.
     * It's a polyfill for the [CSS :focus-visible selector](https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo).
     * The rationale for using this feature [is explained here](https://github.com/WICG/focus-visible/blob/master/explainer.md).
     * A [polyfill can be used](https://github.com/WICG/focus-visible) to apply a `focus-visible` class to other components
     * if needed.
     */
    focusVisibleClassName: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * Callback fired when the component is focused with a keyboard.
     * We trigger a `onFocus` callback too.
     */
    onFocusVisible: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * @ignore
     */
    onKeyUp: propTypes.func,

    /**
     * @ignore
     */
    onMouseDown: propTypes.func,

    /**
     * @ignore
     */
    onMouseLeave: propTypes.func,

    /**
     * @ignore
     */
    onMouseUp: propTypes.func,

    /**
     * @ignore
     */
    onTouchEnd: propTypes.func,

    /**
     * @ignore
     */
    onTouchMove: propTypes.func,

    /**
     * @ignore
     */
    onTouchStart: propTypes.func,

    /**
     * @ignore
     */
    role: propTypes.string,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * Properties applied to the `TouchRipple` element.
     */
    TouchRippleProps: propTypes.object,

    /**
     * Used to control the button's purpose.
     * This property passes the value to the `type` attribute of the native button component.
     * Valid property values include `button`, `submit`, and `reset`.
     */
    type: propTypes.string
  };
  ButtonBase.defaultProps = {
    centerRipple: false,
    component: 'button',
    disableRipple: false,
    disableTouchRipple: false,
    focusRipple: false,
    tabIndex: '0',
    type: 'button'
  };
  var ButtonBase$1 = withStyles(styles$8, {
    name: 'MuiButtonBase'
  })(ButtonBase);

  function unsupportedProp(props, propName, componentName, location, propFullName) {

    var propFullNameSafe = propFullName || propName;

    if (typeof props[propName] !== 'undefined') {
      return new Error("The property `".concat(propFullNameSafe, "` is not supported. Please remove it."));
    }

    return null;
  }

  var styles$9 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        transition: theme.transitions.create(['color', 'padding-top'], {
          duration: theme.transitions.duration.short
        }),
        padding: '6px 12px 8px',
        minWidth: 80,
        maxWidth: 168,
        color: theme.palette.text.secondary,
        flex: '1',
        '&$iconOnly': {
          paddingTop: 16
        },
        '&$selected': {
          paddingTop: 6,
          color: theme.palette.primary.main
        }
      },

      /* Styles applied to the root element if selected. */
      selected: {},

      /* Styles applied to the root element if `showLabel={false}` and not selected. */
      iconOnly: {},

      /* Styles applied to the span element that wraps the icon and label. */
      wrapper: {
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        width: '100%',
        flexDirection: 'column'
      },

      /* Styles applied to the label's span element. */
      label: {
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(12),
        opacity: 1,
        transition: 'font-size 0.2s, opacity 0.2s',
        transitionDelay: '0.1s',
        '&$iconOnly': {
          opacity: 0,
          transitionDelay: '0s'
        },
        '&$selected': {
          fontSize: theme.typography.pxToRem(14)
        }
      }
    };
  };

  var BottomNavigationAction =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(BottomNavigationAction, _React$Component);

    function BottomNavigationAction() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, BottomNavigationAction);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(BottomNavigationAction)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.handleChange = function (event) {
        var _this$props = _this.props,
            onChange = _this$props.onChange,
            value = _this$props.value,
            onClick = _this$props.onClick;

        if (onChange) {
          onChange(event, value);
        }

        if (onClick) {
          onClick(event);
        }
      };

      return _this;
    }

    createClass(BottomNavigationAction, [{
      key: "render",
      value: function render() {
        var _classNames, _classNames2;

        var _this$props2 = this.props,
            classes = _this$props2.classes,
            classNameProp = _this$props2.className,
            icon = _this$props2.icon,
            label = _this$props2.label,
            onChange = _this$props2.onChange,
            onClick = _this$props2.onClick,
            selected = _this$props2.selected,
            showLabelProp = _this$props2.showLabel,
            value = _this$props2.value,
            other = objectWithoutProperties(_this$props2, ["classes", "className", "icon", "label", "onChange", "onClick", "selected", "showLabel", "value"]);

        var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.selected, selected), defineProperty(_classNames, classes.iconOnly, !showLabelProp && !selected), _classNames), classNameProp);
        var labelClassName = classnames(classes.label, (_classNames2 = {}, defineProperty(_classNames2, classes.selected, selected), defineProperty(_classNames2, classes.iconOnly, !showLabelProp && !selected), _classNames2));
        return React.createElement(ButtonBase$1, _extends_1({
          className: className,
          focusRipple: true,
          onClick: this.handleChange
        }, other), React.createElement("span", {
          className: classes.wrapper
        }, icon, React.createElement("span", {
          className: labelClassName
        }, label)));
      }
    }]);

    return BottomNavigationAction;
  }(React.Component);

  BottomNavigationAction.propTypes = {
    /**
     * This property isn't supported.
     * Use the `component` property if you need to change the children structure.
     */
    children: unsupportedProp,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The icon element.
     */
    icon: propTypes.node,

    /**
     * The label element.
     */
    label: propTypes.node,

    /**
     * @ignore
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    selected: propTypes.bool,

    /**
     * If `true`, the `BottomNavigationAction` will show its label.
     * By default, only the selected `BottomNavigationAction`
     * inside `BottomNavigation` will show its label.
     */
    showLabel: propTypes.bool,

    /**
     * You can provide your own value. Otherwise, we fallback to the child position index.
     */
    value: propTypes.any
  };
  var BottomNavigationAction$1 = withStyles(styles$9, {
    name: 'MuiBottomNavigationAction'
  })(BottomNavigationAction);

  var styles$a = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends_1({
        lineHeight: 1.75
      }, theme.typography.button, {
        boxSizing: 'border-box',
        minWidth: 64,
        padding: '6px 16px',
        borderRadius: theme.shape.borderRadius,
        color: theme.palette.text.primary,
        transition: theme.transitions.create(['background-color', 'box-shadow', 'border'], {
          duration: theme.transitions.duration.short
        }),
        '&:hover': {
          textDecoration: 'none',
          backgroundColor: fade(theme.palette.text.primary, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          },
          '&$disabled': {
            backgroundColor: 'transparent'
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      }),

      /* Styles applied to the span element that wraps the children. */
      label: {
        width: '100%',
        // assure the correct width for iOS Safari
        display: 'inherit',
        alignItems: 'inherit',
        justifyContent: 'inherit'
      },

      /* Styles applied to the root element if `variant="text"`. */
      text: {
        padding: '6px 8px'
      },

      /* Styles applied to the root element if `variant="text"` and `color="primary"`. */
      textPrimary: {
        color: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `variant="text"` and `color="secondary"`. */
      textSecondary: {
        color: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element for backwards compatibility with legacy variant naming. */
      flat: {},

      /* Styles applied to the root element for backwards compatibility with legacy variant naming. */
      flatPrimary: {},

      /* Styles applied to the root element for backwards compatibility with legacy variant naming. */
      flatSecondary: {},

      /* Styles applied to the root element if `variant="outlined"`. */
      outlined: {
        padding: '5px 16px',
        border: "1px solid ".concat(theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'),
        '&$disabled': {
          border: "1px solid ".concat(theme.palette.action.disabled)
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="primary"`. */
      outlinedPrimary: {
        color: theme.palette.primary.main,
        border: "1px solid ".concat(fade(theme.palette.primary.main, 0.5)),
        '&:hover': {
          border: "1px solid ".concat(theme.palette.primary.main),
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="secondary"`. */
      outlinedSecondary: {
        color: theme.palette.secondary.main,
        border: "1px solid ".concat(fade(theme.palette.secondary.main, 0.5)),
        '&:hover': {
          border: "1px solid ".concat(theme.palette.secondary.main),
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        },
        '&$disabled': {
          border: "1px solid ".concat(theme.palette.action.disabled)
        }
      },

      /* Styles applied to the root element if `variant="[contained | fab]"`. */
      contained: {
        color: theme.palette.getContrastText(theme.palette.grey[300]),
        backgroundColor: theme.palette.grey[300],
        boxShadow: theme.shadows[2],
        '&$focusVisible': {
          boxShadow: theme.shadows[6]
        },
        '&:active': {
          boxShadow: theme.shadows[8]
        },
        '&$disabled': {
          color: theme.palette.action.disabled,
          boxShadow: theme.shadows[0],
          backgroundColor: theme.palette.action.disabledBackground
        },
        '&:hover': {
          backgroundColor: theme.palette.grey.A100,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.grey[300]
          },
          '&$disabled': {
            backgroundColor: theme.palette.action.disabledBackground
          }
        }
      },

      /* Styles applied to the root element if `variant="[contained | fab]"` and `color="primary"`. */
      containedPrimary: {
        color: theme.palette.primary.contrastText,
        backgroundColor: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: theme.palette.primary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.primary.main
          }
        }
      },

      /* Styles applied to the root element if `variant="[contained | fab]"` and `color="secondary"`. */
      containedSecondary: {
        color: theme.palette.secondary.contrastText,
        backgroundColor: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: theme.palette.secondary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.secondary.main
          }
        }
      },

      /* Styles applied to the root element for backwards compatibility with legacy variant naming. */
      raised: {},
      // legacy

      /* Styles applied to the root element for backwards compatibility with legacy variant naming. */
      raisedPrimary: {},
      // legacy

      /* Styles applied to the root element for backwards compatibility with legacy variant naming. */
      raisedSecondary: {},
      // legacy

      /* Styles applied to the root element if `variant="[fab | extendedFab]"`. */
      fab: {
        borderRadius: '50%',
        padding: 0,
        minWidth: 0,
        width: 56,
        height: 56,
        boxShadow: theme.shadows[6],
        '&:active': {
          boxShadow: theme.shadows[12]
        }
      },

      /* Styles applied to the root element if `variant="extendedFab"`. */
      extendedFab: {
        borderRadius: 48 / 2,
        padding: '0 16px',
        width: 'auto',
        minWidth: 48,
        height: 48
      },

      /* Styles applied to the ButtonBase root element if the button is keyboard focused. */
      focusVisible: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit',
        borderColor: 'currentColor'
      },

      /* Styles applied to the root element if `mini={true}` & `variant="[fab | extendedFab]"`. */
      mini: {
        width: 40,
        height: 40
      },

      /* Styles applied to the root element if `size="small"`. */
      sizeSmall: {
        padding: '4px 8px',
        minWidth: 64,
        fontSize: theme.typography.pxToRem(13)
      },

      /* Styles applied to the root element if `size="large"`. */
      sizeLarge: {
        padding: '8px 24px',
        fontSize: theme.typography.pxToRem(15)
      },

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {
        width: '100%'
      }
    };
  };

  function Button(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        color = props.color,
        disabled = props.disabled,
        disableFocusRipple = props.disableFocusRipple,
        focusVisibleClassName = props.focusVisibleClassName,
        fullWidth = props.fullWidth,
        mini = props.mini,
        size = props.size,
        variant = props.variant,
        other = objectWithoutProperties(props, ["children", "classes", "className", "color", "disabled", "disableFocusRipple", "focusVisibleClassName", "fullWidth", "mini", "size", "variant"]);

    var fab = variant === 'fab' || variant === 'extendedFab';
    var contained = variant === 'contained' || variant === 'raised';
    var text = variant === 'text' || variant === 'flat';
    var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.fab, fab), defineProperty(_classNames, classes.mini, fab && mini), defineProperty(_classNames, classes.extendedFab, variant === 'extendedFab'), defineProperty(_classNames, classes.text, text), defineProperty(_classNames, classes.textPrimary, text && color === 'primary'), defineProperty(_classNames, classes.textSecondary, text && color === 'secondary'), defineProperty(_classNames, classes.flat, text), defineProperty(_classNames, classes.flatPrimary, text && color === 'primary'), defineProperty(_classNames, classes.flatSecondary, text && color === 'secondary'), defineProperty(_classNames, classes.contained, contained || fab), defineProperty(_classNames, classes.containedPrimary, (contained || fab) && color === 'primary'), defineProperty(_classNames, classes.containedSecondary, (contained || fab) && color === 'secondary'), defineProperty(_classNames, classes.raised, contained || fab), defineProperty(_classNames, classes.raisedPrimary, (contained || fab) && color === 'primary'), defineProperty(_classNames, classes.raisedSecondary, (contained || fab) && color === 'secondary'), defineProperty(_classNames, classes.outlined, variant === 'outlined'), defineProperty(_classNames, classes.outlinedPrimary, variant === 'outlined' && color === 'primary'), defineProperty(_classNames, classes.outlinedSecondary, variant === 'outlined' && color === 'secondary'), defineProperty(_classNames, classes["size".concat(capitalize(size))], size !== 'medium'), defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.fullWidth, fullWidth), defineProperty(_classNames, classes.colorInherit, color === 'inherit'), _classNames), classNameProp);
    return React.createElement(ButtonBase$1, _extends_1({
      className: className,
      disabled: disabled,
      focusRipple: !disableFocusRipple,
      focusVisibleClassName: classnames(classes.focusVisible, focusVisibleClassName)
    }, other), React.createElement("span", {
      className: classes.label
    }, children));
  }

  Button.propTypes = {
    /**
     * The content of the button.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple will be disabled.
     * `disableRipple` must also be true.
     */
    disableFocusRipple: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string,

    /**
     * If `true`, the button will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The URL to link to when the button is clicked.
     * If defined, an `a` element will be used as the root node.
     */
    href: propTypes.string,

    /**
     * If `true`, and `variant` is `'fab'`, will use mini floating action button styling.
     */
    mini: propTypes.bool,

    /**
     * The size of the button.
     * `small` is equivalent to the dense button styling.
     */
    size: propTypes.oneOf(['small', 'medium', 'large']),

    /**
     * @ignore
     */
    type: propTypes.string,

    /**
     * The variant to use.
     * __WARNING__: `flat` and `raised` are deprecated.
     * Instead use `text` and `contained` respectively.
     * `fab` and `extendedFab` are deprecated.
     * Instead use `<Fab>` and `<Fab variant="extended">`
     */
    variant: chainPropTypes(propTypes.oneOf(['text', 'outlined', 'contained', 'fab', 'extendedFab', 'flat', 'raised']), function (props) {
      if (props.variant === 'flat') {
        return new Error('Material-UI: the `flat` variant will be removed in the next major release. ' + '`text` is equivalent and should be used instead.');
      }

      if (props.variant === 'raised') {
        return new Error('Material-UI: the `raised` variant will be removed in the next major release. ' + '`contained` is equivalent and should be used instead.');
      }

      if (props.variant === 'fab') {
        return new Error('Material-UI: the `fab` variant will be removed in the next major release. ' + 'The `<Fab>` component is equivalent and should be used instead.');
      }

      if (props.variant === 'extendedFab') {
        return new Error('Material-UI: the `fab` variant will be removed in the next major release. ' + 'The `<Fab>` component with `variant="extended"` is equivalent ' + 'and should be used instead.');
      }

      return null;
    })
  };
  Button.defaultProps = {
    color: 'default',
    component: 'button',
    disabled: false,
    disableFocusRipple: false,
    fullWidth: false,
    mini: false,
    size: 'medium',
    type: 'button',
    variant: 'text'
  };
  var Button$1 = withStyles(styles$a, {
    name: 'MuiButton'
  })(Button);

  var styles$b = {
    /* Styles applied to the root element. */
    root: {
      overflow: 'hidden'
    }
  };

  function Card(props) {
    var classes = props.classes,
        className = props.className,
        raised = props.raised,
        other = objectWithoutProperties(props, ["classes", "className", "raised"]);

    return React.createElement(Paper$1, _extends_1({
      className: classnames(classes.root, className),
      elevation: raised ? 8 : 1
    }, other));
  }

  Card.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the card will use raised styling.
     */
    raised: propTypes.bool
  };
  Card.defaultProps = {
    raised: false
  };
  var Card$1 = withStyles(styles$b, {
    name: 'MuiCard'
  })(Card);

  var styles$c = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        textAlign: 'inherit',
        width: '100%',
        '&:hover $focusHighlight': {
          opacity: theme.palette.action.hoverOpacity
        },
        '&$focusVisible $focusHighlight': {
          opacity: 0.12
        }
      },

      /* Styles applied to the ButtonBase root element if the action area is keyboard focused. */
      focusVisible: {},

      /* Styles applied to the overlay that covers the action area when it is keyboard focused. */
      focusHighlight: {
        pointerEvents: 'none',
        position: 'absolute',
        backgroundColor: 'currentcolor',
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        opacity: 0,
        transition: theme.transitions.create('opacity', {
          duration: theme.transitions.duration.short
        })
      }
    };
  };

  function CardActionArea(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        focusVisibleClassName = props.focusVisibleClassName,
        other = objectWithoutProperties(props, ["children", "classes", "className", "focusVisibleClassName"]);

    return React.createElement(ButtonBase$1, _extends_1({
      className: classnames(classes.root, className),
      focusVisibleClassName: classnames(focusVisibleClassName, classes.focusVisible)
    }, other), children, React.createElement("span", {
      className: classes.focusHighlight
    }));
  }

  CardActionArea.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string
  };
  var CardActionArea$1 = withStyles(styles$c, {
    name: 'MuiCardActionArea'
  })(CardActionArea);

  function cloneElementWithClassName(child, className) {
    return React.cloneElement(child, {
      className: classnames(child.props.className, className)
    });
  }
  function cloneChildrenWithClassName(children, className) {
    return React.Children.map(children, function (child) {
      return React.isValidElement(child) && cloneElementWithClassName(child, className);
    });
  }
  function isMuiElement(element, muiNames) {
    return React.isValidElement(element) && muiNames.indexOf(element.type.muiName) !== -1;
  }
  function setRef(ref, value) {
    if (typeof ref === 'function') {
      ref(value);
    } else if (ref) {
      ref.current = value;
    }
  }

  var styles$d = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      boxSizing: 'border-box',
      padding: '8px 4px'
    },

    /* Styles applied to the root element if `disableActionSpacing={true}`. */
    disableActionSpacing: {
      padding: 8
    },

    /* Styles applied to the children. */
    action: {
      margin: '0 4px'
    }
  };

  function CardActions(props) {
    var disableActionSpacing = props.disableActionSpacing,
        children = props.children,
        classes = props.classes,
        className = props.className,
        other = objectWithoutProperties(props, ["disableActionSpacing", "children", "classes", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, defineProperty({}, classes.disableActionSpacing, disableActionSpacing), className)
    }, other), disableActionSpacing ? children : cloneChildrenWithClassName(children, classes.action));
  }

  CardActions.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the card actions do not have additional margin.
     */
    disableActionSpacing: propTypes.bool
  };
  CardActions.defaultProps = {
    disableActionSpacing: false
  };
  var CardActions$1 = withStyles(styles$d, {
    name: 'MuiCardActions'
  })(CardActions);

  var styles$e = {
    /* Styles applied to the root element. */
    root: {
      padding: 16,
      '&:last-child': {
        paddingBottom: 24
      }
    }
  };

  function CardContent(props) {
    var classes = props.classes,
        className = props.className,
        Component = props.component,
        other = objectWithoutProperties(props, ["classes", "className", "component"]);

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, className)
    }, other));
  }

  CardContent.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType
  };
  CardContent.defaultProps = {
    component: 'div'
  };
  var CardContent$1 = withStyles(styles$e, {
    name: 'MuiCardContent'
  })(CardContent);

  var styles$f = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        margin: 0
      },

      /* Styles applied to the root element if `variant="display4"`. */
      display4: theme.typography.display4,

      /* Styles applied to the root element if `variant="display3"`. */
      display3: theme.typography.display3,

      /* Styles applied to the root element if `variant="display2"`. */
      display2: theme.typography.display2,

      /* Styles applied to the root element if `variant="display1"`. */
      display1: theme.typography.display1,

      /* Styles applied to the root element if `variant="headline"`. */
      headline: theme.typography.headline,

      /* Styles applied to the root element if `variant="title"`. */
      title: theme.typography.title,

      /* Styles applied to the root element if `variant="subheading"`. */
      subheading: theme.typography.subheading,

      /* Styles applied to the root element if `variant="body2"`. */
      body2: theme.typography.body2,

      /* Styles applied to the root element if `variant="body1"`. */
      body1: theme.typography.body1,

      /* Styles applied to the root element if `variant="caption"`. */
      caption: theme.typography.caption,

      /* Styles applied to the root element if `variant="button"`. */
      button: theme.typography.button,

      /* Styles applied to the root element if `variant="h1"`. */
      h1: theme.typography.h1,

      /* Styles applied to the root element if `variant="h2"`. */
      h2: theme.typography.h2,

      /* Styles applied to the root element if `variant="h3"`. */
      h3: theme.typography.h3,

      /* Styles applied to the root element if `variant="h4"`. */
      h4: theme.typography.h4,

      /* Styles applied to the root element if `variant="h5"`. */
      h5: theme.typography.h5,

      /* Styles applied to the root element if `variant="h6"`. */
      h6: theme.typography.h6,

      /* Styles applied to the root element if `variant="subtitle1"`. */
      subtitle1: theme.typography.subtitle1,

      /* Styles applied to the root element if `variant="subtitle2"`. */
      subtitle2: theme.typography.subtitle2,

      /* Styles applied to the root element if `variant="overline"`. */
      overline: theme.typography.overline,

      /* Styles applied to the root element if `variant="srOnly"`. Only accessible to screen readers. */
      srOnly: {
        position: 'absolute',
        height: 1,
        width: 1,
        overflow: 'hidden'
      },

      /* Styles applied to the root element if `align="left"`. */
      alignLeft: {
        textAlign: 'left'
      },

      /* Styles applied to the root element if `align="center"`. */
      alignCenter: {
        textAlign: 'center'
      },

      /* Styles applied to the root element if `align="right"`. */
      alignRight: {
        textAlign: 'right'
      },

      /* Styles applied to the root element if `align="justify"`. */
      alignJustify: {
        textAlign: 'justify'
      },

      /* Styles applied to the root element if `align="nowrap"`. */
      noWrap: {
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap'
      },

      /* Styles applied to the root element if `gutterBottom={true}`. */
      gutterBottom: {
        marginBottom: '0.35em'
      },

      /* Styles applied to the root element if `paragraph={true}`. */
      paragraph: {
        marginBottom: 16
      },

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `color="textPrimary"`. */
      colorTextPrimary: {
        color: theme.palette.text.primary
      },

      /* Styles applied to the root element if `color="textSecondary"`. */
      colorTextSecondary: {
        color: theme.palette.text.secondary
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        color: theme.palette.error.main
      },

      /* Styles applied to the root element if `inline={true}`. */
      inline: {
        display: 'inline'
      }
    };
  };
  var nextVariants = {
    display4: 'h1',
    display3: 'h2',
    display2: 'h3',
    display1: 'h4',
    headline: 'h5',
    title: 'h6',
    subheading: 'subtitle1'
  };

  function getVariant(theme, variantProp) {
    var typography = theme.typography;
    var variant = variantProp;

    if (!variant) {
      variant = typography.useNextVariants ? 'body2' : 'body1';
    } // complete v2 switch


    if (typography.useNextVariants) {
      variant = nextVariants[variant] || variant;
    }

    return variant;
  }

  var defaultHeadlineMapping = {
    h1: 'h1',
    h2: 'h2',
    h3: 'h3',
    h4: 'h4',
    h5: 'h5',
    h6: 'h6',
    subtitle1: 'h6',
    subtitle2: 'h6',
    body1: 'p',
    body2: 'p',
    // deprecated
    display4: 'h1',
    display3: 'h1',
    display2: 'h1',
    display1: 'h1',
    headline: 'h1',
    title: 'h2',
    subheading: 'h3'
  };

  function Typography(props) {
    var _classNames;

    var align = props.align,
        classes = props.classes,
        classNameProp = props.className,
        color = props.color,
        componentProp = props.component,
        gutterBottom = props.gutterBottom,
        headlineMapping = props.headlineMapping,
        inline = props.inline,
        internalDeprecatedVariant = props.internalDeprecatedVariant,
        noWrap = props.noWrap,
        paragraph = props.paragraph,
        theme = props.theme,
        variantProp = props.variant,
        other = objectWithoutProperties(props, ["align", "classes", "className", "color", "component", "gutterBottom", "headlineMapping", "inline", "internalDeprecatedVariant", "noWrap", "paragraph", "theme", "variant"]);

    var variant = getVariant(theme, variantProp);
    var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes[variant], variant !== 'inherit'), defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'default'), defineProperty(_classNames, classes.noWrap, noWrap), defineProperty(_classNames, classes.gutterBottom, gutterBottom), defineProperty(_classNames, classes.paragraph, paragraph), defineProperty(_classNames, classes["align".concat(capitalize(align))], align !== 'inherit'), defineProperty(_classNames, classes.inline, inline), _classNames), classNameProp);
    var Component = componentProp || (paragraph ? 'p' : headlineMapping[variant] || defaultHeadlineMapping[variant]) || 'span';
    return React.createElement(Component, _extends_1({
      className: className
    }, other));
  }

  Typography.propTypes = {
    /**
     * Set the text-align on the component.
     */
    align: propTypes.oneOf(['inherit', 'left', 'center', 'right', 'justify']),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'error', 'inherit', 'primary', 'secondary', 'textPrimary', 'textSecondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     * By default, it maps the variant to a good default headline component.
     */
    component: componentPropType,

    /**
     * If `true`, the text will have a bottom margin.
     */
    gutterBottom: propTypes.bool,

    /**
     * We are empirically mapping the variant property to a range of different DOM element types.
     * For instance, subtitle1 to `<h6>`.
     * If you wish to change that mapping, you can provide your own.
     * Alternatively, you can use the `component` property.
     * The default mapping is the following:
     */
    headlineMapping: propTypes.object,

    /**
     *  Controls whether the Typography is inline or not.
     */
    inline: propTypes.bool,

    /**
     * A deprecated variant is used from an internal component. Users don't need
     * a deprecation warning here if they switched to the v2 theme. They already
     * get the mapping that will be applied in the next major release.
     *
     * @internal
     */
    internalDeprecatedVariant: propTypes.bool,

    /**
     * If `true`, the text will not wrap, but instead will truncate with an ellipsis.
     */
    noWrap: propTypes.bool,

    /**
     * If `true`, the text will have a bottom margin.
     */
    paragraph: propTypes.bool,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * Applies the theme typography styles.
     * Use `body1` as the default value with the legacy implementation and `body2` with the new one.
     */
    variant: chainPropTypes(propTypes.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'subtitle1', 'subtitle2', 'body1', 'body2', 'caption', 'button', 'overline', 'srOnly', 'inherit', // deprecated
    'display4', 'display3', 'display2', 'display1', 'headline', 'title', 'subheading']), function (props) {
      var deprecatedVariants = ['display4', 'display3', 'display2', 'display1', 'headline', 'title', 'subheading'];

      if (props.theme.typography.useNextVariants && !props.internalDeprecatedVariant && deprecatedVariants.indexOf(props.variant) !== -1) {
        return new Error('Material-UI: you are using a deprecated typography variant: ' + "`".concat(props.variant, "` that will be removed in the next major release.\n") + 'Please read the migration guide under https://material-ui.com/style/typography#migration-to-typography-v2.');
      }

      return null;
    })
  };
  Typography.defaultProps = {
    align: 'inherit',
    color: 'default',
    gutterBottom: false,
    headlineMapping: defaultHeadlineMapping,
    inline: false,
    noWrap: false,
    paragraph: false
  };
  var Typography$1 = withStyles(styles$f, {
    name: 'MuiTypography',
    withTheme: true
  })(Typography);

  var styles$g = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      padding: 16
    },

    /* Styles applied to the avatar element. */
    avatar: {
      flex: '0 0 auto',
      marginRight: 16
    },

    /* Styles applied to the action element. */
    action: {
      flex: '0 0 auto',
      alignSelf: 'flex-start',
      marginTop: -8,
      marginRight: -8
    },

    /* Styles applied to the content wrapper element. */
    content: {
      flex: '1 1 auto'
    },

    /* Styles applied to the title Typography element. */
    title: {},

    /* Styles applied to the subheader Typography element. */
    subheader: {}
  };

  function CardHeader(props) {
    var action = props.action,
        avatar = props.avatar,
        classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        disableTypography = props.disableTypography,
        subheaderProp = props.subheader,
        subheaderTypographyProps = props.subheaderTypographyProps,
        titleProp = props.title,
        titleTypographyProps = props.titleTypographyProps,
        other = objectWithoutProperties(props, ["action", "avatar", "classes", "className", "component", "disableTypography", "subheader", "subheaderTypographyProps", "title", "titleTypographyProps"]);

    var title$$1 = titleProp;

    if (title$$1 != null && title$$1.type !== Typography$1 && !disableTypography) {
      title$$1 = React.createElement(Typography$1, _extends_1({
        variant: avatar ? 'body2' : 'headline',
        internalDeprecatedVariant: true,
        className: classes.title,
        component: "span"
      }, titleTypographyProps), title$$1);
    }

    var subheader = subheaderProp;

    if (subheader != null && subheader.type !== Typography$1 && !disableTypography) {
      subheader = React.createElement(Typography$1, _extends_1({
        variant: avatar ? 'body2' : 'body1',
        className: classes.subheader,
        color: "textSecondary",
        component: "span"
      }, subheaderTypographyProps), subheader);
    }

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, classNameProp)
    }, other), avatar && React.createElement("div", {
      className: classes.avatar
    }, avatar), React.createElement("div", {
      className: classes.content
    }, title$$1, subheader), action && React.createElement("div", {
      className: classes.action
    }, action));
  }

  CardHeader.propTypes = {
    /**
     * The action to display in the card header.
     */
    action: propTypes.node,

    /**
     * The Avatar for the Card Header.
     */
    avatar: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the children won't be wrapped by a Typography component.
     * This can be useful to render an alternative Typography variant by wrapping
     * the `title` text, and optional `subheader` text
     * with the Typography component.
     */
    disableTypography: propTypes.bool,

    /**
     * The content of the component.
     */
    subheader: propTypes.node,

    /**
     * These props will be forwarded to the subheader
     * (as long as disableTypography is not `true`).
     */
    subheaderTypographyProps: propTypes.object,

    /**
     * The content of the Card Title.
     */
    title: propTypes.node,

    /**
     * These props will be forwarded to the title
     * (as long as disableTypography is not `true`).
     */
    titleTypographyProps: propTypes.object
  };
  CardHeader.defaultProps = {
    component: 'div',
    disableTypography: false
  };
  var CardHeader$1 = withStyles(styles$g, {
    name: 'MuiCardHeader'
  })(CardHeader);

  var styles$h = {
    /* Styles applied to the root element. */
    root: {
      display: 'block',
      backgroundSize: 'cover',
      backgroundRepeat: 'no-repeat',
      backgroundPosition: 'center'
    },

    /* Styles applied to the root element if `component="video, audio, picture, iframe, or img"`. */
    media: {
      width: '100%'
    }
  };
  var MEDIA_COMPONENTS = ['video', 'audio', 'picture', 'iframe', 'img'];

  function CardMedia(props) {
    var classes = props.classes,
        className = props.className,
        Component = props.component,
        image = props.image,
        src = props.src,
        style = props.style,
        other = objectWithoutProperties(props, ["classes", "className", "component", "image", "src", "style"]);

    warning_1(Boolean(image || src), 'Material-UI: either `image` or `src` property must be specified.');
    var isMediaComponent = MEDIA_COMPONENTS.indexOf(Component) !== -1;
    var composedStyle = !isMediaComponent && image ? _extends_1({
      backgroundImage: "url(\"".concat(image, "\")")
    }, style) : style;
    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, defineProperty({}, classes.media, isMediaComponent), className),
      style: composedStyle,
      src: isMediaComponent ? image || src : undefined
    }, other));
  }

  CardMedia.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Component for rendering image.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Image to be displayed as a background image.
     * Either `image` or `src` prop must be specified.
     * Note that caller must specify height otherwise the image will not be visible.
     */
    image: propTypes.string,

    /**
     * An alias for `image` property.
     * Available only with media components.
     * Media components: `video`, `audio`, `picture`, `iframe`, `img`.
     */
    src: propTypes.string,

    /**
     * @ignore
     */
    style: propTypes.object
  };
  CardMedia.defaultProps = {
    component: 'div'
  };
  var CardMedia$1 = withStyles(styles$h, {
    name: 'MuiCardMedia'
  })(CardMedia);

  /**
   * @ignore - internal component.
   */

  var FormControlContext = React.createContext();

  function withFormControlContext(Component) {
    var EnhancedComponent = function EnhancedComponent(props) {
      return React.createElement(FormControlContext.Consumer, null, function (context) {
        return React.createElement(Component, _extends_1({
          muiFormControl: context
        }, props));
      });
    };

    {
      EnhancedComponent.displayName = "WithFormControlContext(".concat(getDisplayName(Component), ")");
    }

    hoistNonReactStatics_cjs(EnhancedComponent, Component);
    return EnhancedComponent;
  }

  var styles$i = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        textAlign: 'center',
        flex: '0 0 auto',
        fontSize: theme.typography.pxToRem(24),
        padding: 12,
        borderRadius: '50%',
        overflow: 'visible',
        // Explicitly set the default value to solve a bug on IE 11.
        color: theme.palette.action.active,
        transition: theme.transitions.create('background-color', {
          duration: theme.transitions.duration.shortest
        }),
        '&:hover': {
          backgroundColor: fade(theme.palette.action.active, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          },
          '&$disabled': {
            backgroundColor: 'transparent'
          }
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        }
      },

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the children container element. */
      label: {
        width: '100%',
        display: 'flex',
        alignItems: 'inherit',
        justifyContent: 'inherit'
      }
    };
  };
  /**
   * Refer to the [Icons](/style/icons/) section of the documentation
   * regarding the available icon options.
   */

  function IconButton(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        className = props.className,
        color = props.color,
        disabled = props.disabled,
        other = objectWithoutProperties(props, ["children", "classes", "className", "color", "disabled"]);

    return React.createElement(ButtonBase$1, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'default'), defineProperty(_classNames, classes.disabled, disabled), _classNames), className),
      centerRipple: true,
      focusRipple: true,
      disabled: disabled
    }, other), React.createElement("span", {
      className: classes.label
    }, children));
  }

  IconButton.propTypes = {
    /**
     * The icon element.
     */
    children: chainPropTypes(propTypes.node, function (props) {
      var found = React.Children.toArray(props.children).some(function (child) {
        return React.isValidElement(child) && child.props.onClick;
      });

      if (found) {
        return new Error(['Material-UI: you are providing an onClick event listener ' + 'to a child of a button element.', 'Firefox will never trigger the event.', 'You should move the onClick listener to the parent button element.', 'https://github.com/mui-org/material-ui/issues/13957', // Change error message slightly on every check to prevent caching when testing
        // which would not trigger console errors on subsequent fails
        ''].join('\n'));
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * If `true`, the button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple will be disabled.
     */
    disableRipple: propTypes.bool
  };
  IconButton.defaultProps = {
    color: 'default',
    disabled: false
  };
  var IconButton$1 = withStyles(styles$i, {
    name: 'MuiIconButton'
  })(IconButton);

  var styles$j = {
    root: {
      display: 'inline-flex',
      alignItems: 'center',
      transition: 'none',
      '&:hover': {
        // Disable the hover effect for the IconButton.
        backgroundColor: 'transparent'
      }
    },
    checked: {},
    disabled: {},
    input: {
      cursor: 'inherit',
      position: 'absolute',
      opacity: 0,
      width: '100%',
      height: '100%',
      top: 0,
      left: 0,
      margin: 0,
      padding: 0
    }
  };
  /**
   * @ignore - internal component.
   */

  var SwitchBase =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(SwitchBase, _React$Component);

    function SwitchBase(props) {
      var _this;

      classCallCheck(this, SwitchBase);

      _this = possibleConstructorReturn(this, getPrototypeOf(SwitchBase).call(this));

      _this.handleFocus = function (event) {
        if (_this.props.onFocus) {
          _this.props.onFocus(event);
        }

        var muiFormControl = _this.props.muiFormControl;

        if (muiFormControl && muiFormControl.onFocus) {
          muiFormControl.onFocus(event);
        }
      };

      _this.handleBlur = function (event) {
        if (_this.props.onBlur) {
          _this.props.onBlur(event);
        }

        var muiFormControl = _this.props.muiFormControl;

        if (muiFormControl && muiFormControl.onBlur) {
          muiFormControl.onBlur(event);
        }
      };

      _this.handleInputChange = function (event) {
        var checked = event.target.checked;

        if (!_this.isControlled) {
          _this.setState({
            checked: checked
          });
        }

        if (_this.props.onChange) {
          _this.props.onChange(event, checked);
        }
      };

      _this.isControlled = props.checked != null;
      _this.state = {};

      if (!_this.isControlled) {
        // not controlled, use internal state
        _this.state.checked = props.defaultChecked !== undefined ? props.defaultChecked : false;
      }

      return _this;
    }

    createClass(SwitchBase, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props = this.props,
            autoFocus = _this$props.autoFocus,
            checkedProp = _this$props.checked,
            checkedIcon = _this$props.checkedIcon,
            classes = _this$props.classes,
            classNameProp = _this$props.className,
            defaultChecked = _this$props.defaultChecked,
            disabledProp = _this$props.disabled,
            icon = _this$props.icon,
            id = _this$props.id,
            inputProps = _this$props.inputProps,
            inputRef = _this$props.inputRef,
            muiFormControl = _this$props.muiFormControl,
            name = _this$props.name,
            onBlur = _this$props.onBlur,
            onChange = _this$props.onChange,
            onFocus = _this$props.onFocus,
            readOnly = _this$props.readOnly,
            required = _this$props.required,
            tabIndex = _this$props.tabIndex,
            type = _this$props.type,
            value = _this$props.value,
            other = objectWithoutProperties(_this$props, ["autoFocus", "checked", "checkedIcon", "classes", "className", "defaultChecked", "disabled", "icon", "id", "inputProps", "inputRef", "muiFormControl", "name", "onBlur", "onChange", "onFocus", "readOnly", "required", "tabIndex", "type", "value"]);

        var disabled = disabledProp;

        if (muiFormControl) {
          if (typeof disabled === 'undefined') {
            disabled = muiFormControl.disabled;
          }
        }

        var checked = this.isControlled ? checkedProp : this.state.checked;
        var hasLabelFor = type === 'checkbox' || type === 'radio';
        return React.createElement(IconButton$1, _extends_1({
          component: "span",
          className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.checked, checked), defineProperty(_classNames, classes.disabled, disabled), _classNames), classNameProp),
          disabled: disabled,
          tabIndex: null,
          role: undefined,
          onFocus: this.handleFocus,
          onBlur: this.handleBlur
        }, other), checked ? checkedIcon : icon, React.createElement("input", _extends_1({
          autoFocus: autoFocus,
          checked: checkedProp,
          defaultChecked: defaultChecked,
          className: classes.input,
          disabled: disabled,
          id: hasLabelFor && id,
          name: name,
          onChange: this.handleInputChange,
          readOnly: readOnly,
          ref: inputRef,
          required: required,
          tabIndex: tabIndex,
          type: type,
          value: value
        }, inputProps)));
      }
    }]);

    return SwitchBase;
  }(React.Component); // NB: If changed, please update Checkbox, Switch and Radio
  // so that the API documentation is updated.


  SwitchBase.propTypes = {
    /**
     * If `true`, the input will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.oneOfType([propTypes.bool, propTypes.string]),

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    defaultChecked: propTypes.bool,

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node.isRequired,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /*
     * @ignore
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.checked`.
     * @param {boolean} checked The `checked` value of the switch
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the input will be required.
     */
    required: propTypes.bool,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * The input component property `type`.
     */
    type: propTypes.string.isRequired,

    /**
     * The value of the component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool])
  };
  var SwitchBase$1 = withStyles(styles$j, {
    name: 'MuiPrivateSwitchBase'
  })(withFormControlContext(SwitchBase));

  var interopRequireDefault = createCommonjsModule(function (module) {
  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  module.exports = _interopRequireDefault;
  });

  unwrapExports(interopRequireDefault);

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    subClass.__proto__ = superClass;
  }

  var inheritsLoose = _inheritsLoose;

  var setStatic_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = void 0;

  var setStatic = function setStatic(key, value) {
    return function (BaseComponent) {
      /* eslint-disable no-param-reassign */
      BaseComponent[key] = value;
      /* eslint-enable no-param-reassign */

      return BaseComponent;
    };
  };

  var _default = setStatic;
  exports.default = _default;
  });

  unwrapExports(setStatic_1);

  var setDisplayName_1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = void 0;

  var _setStatic = interopRequireDefault(setStatic_1);

  var setDisplayName = function setDisplayName(displayName) {
    return (0, _setStatic.default)('displayName', displayName);
  };

  var _default = setDisplayName;
  exports.default = _default;
  });

  unwrapExports(setDisplayName_1);

  var getDisplayName_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = void 0;

  var getDisplayName = function getDisplayName(Component) {
    if (typeof Component === 'string') {
      return Component;
    }

    if (!Component) {
      return undefined;
    }

    return Component.displayName || Component.name || 'Component';
  };

  var _default = getDisplayName;
  exports.default = _default;
  });

  unwrapExports(getDisplayName_1);

  var wrapDisplayName_1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = void 0;

  var _getDisplayName = interopRequireDefault(getDisplayName_1);

  var wrapDisplayName = function wrapDisplayName(BaseComponent, hocName) {
    return hocName + "(" + (0, _getDisplayName.default)(BaseComponent) + ")";
  };

  var _default = wrapDisplayName;
  exports.default = _default;
  });

  unwrapExports(wrapDisplayName_1);

  var shouldUpdate_1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = void 0;

  var _inheritsLoose2 = interopRequireDefault(inheritsLoose);



  var _setDisplayName = interopRequireDefault(setDisplayName_1);

  var _wrapDisplayName = interopRequireDefault(wrapDisplayName_1);

  var shouldUpdate = function shouldUpdate(test) {
    return function (BaseComponent) {
      var factory = (0, React.createFactory)(BaseComponent);

      var ShouldUpdate =
      /*#__PURE__*/
      function (_Component) {
        (0, _inheritsLoose2.default)(ShouldUpdate, _Component);

        function ShouldUpdate() {
          return _Component.apply(this, arguments) || this;
        }

        var _proto = ShouldUpdate.prototype;

        _proto.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
          return test(this.props, nextProps);
        };

        _proto.render = function render() {
          return factory(this.props);
        };

        return ShouldUpdate;
      }(React.Component);

      {
        return (0, _setDisplayName.default)((0, _wrapDisplayName.default)(BaseComponent, 'shouldUpdate'))(ShouldUpdate);
      }

      return ShouldUpdate;
    };
  };

  var _default = shouldUpdate;
  exports.default = _default;
  });

  unwrapExports(shouldUpdate_1);

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   *
   * @typechecks
   * 
   */

  var hasOwnProperty$1 = Object.prototype.hasOwnProperty;

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      // Added the nonzero y check to make Flow happy, but it is redundant
      return x !== 0 || y !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }

  /**
   * Performs equality by iterating through keys on an object and returning false
   * when any key has values which are not strictly equal between the arguments.
   * Returns true when the values of all keys are strictly equal.
   */
  function shallowEqual(objA, objB) {
    if (is(objA, objB)) {
      return true;
    }

    if (typeof objA !== 'object' || objA === null || typeof objB !== 'object' || objB === null) {
      return false;
    }

    var keysA = Object.keys(objA);
    var keysB = Object.keys(objB);

    if (keysA.length !== keysB.length) {
      return false;
    }

    // Test for A's keys different from B.
    for (var i = 0; i < keysA.length; i++) {
      if (!hasOwnProperty$1.call(objB, keysA[i]) || !is(objA[keysA[i]], objB[keysA[i]])) {
        return false;
      }
    }

    return true;
  }

  var shallowEqual_1 = shallowEqual;

  var shallowEqual$1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = void 0;

  var _shallowEqual = interopRequireDefault(shallowEqual_1);

  var _default = _shallowEqual.default;
  exports.default = _default;
  });

  unwrapExports(shallowEqual$1);

  var pure_1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = void 0;

  var _shouldUpdate = interopRequireDefault(shouldUpdate_1);

  var _shallowEqual = interopRequireDefault(shallowEqual$1);

  var _setDisplayName = interopRequireDefault(setDisplayName_1);

  var _wrapDisplayName = interopRequireDefault(wrapDisplayName_1);

  var pure = function pure(BaseComponent) {
    var hoc = (0, _shouldUpdate.default)(function (props, nextProps) {
      return !(0, _shallowEqual.default)(props, nextProps);
    });

    {
      return (0, _setDisplayName.default)((0, _wrapDisplayName.default)(BaseComponent, 'pure'))(hoc(BaseComponent));
    }

    return hoc(BaseComponent);
  };

  var _default = pure;
  exports.default = _default;
  });

  var pure = unwrapExports(pure_1);

  var styles$k = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        userSelect: 'none',
        width: '1em',
        height: '1em',
        display: 'inline-block',
        fill: 'currentColor',
        flexShrink: 0,
        fontSize: 24,
        transition: theme.transitions.create('fill', {
          duration: theme.transitions.duration.shorter
        })
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `color="action"`. */
      colorAction: {
        color: theme.palette.action.active
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        color: theme.palette.error.main
      },

      /* Styles applied to the root element if `color="disabled"`. */
      colorDisabled: {
        color: theme.palette.action.disabled
      },

      /* Styles applied to the root element if `fontSize="inherit"`. */
      fontSizeInherit: {
        fontSize: 'inherit'
      },

      /* Styles applied to the root element if `fontSize="small"`. */
      fontSizeSmall: {
        fontSize: 20
      },

      /* Styles applied to the root element if `fontSize="large"`. */
      fontSizeLarge: {
        fontSize: 35
      }
    };
  };

  function SvgIcon(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        className = props.className,
        color = props.color,
        Component = props.component,
        fontSize = props.fontSize,
        nativeColor = props.nativeColor,
        titleAccess = props.titleAccess,
        viewBox = props.viewBox,
        other = objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "fontSize", "nativeColor", "titleAccess", "viewBox"]);

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'inherit'), defineProperty(_classNames, classes["fontSize".concat(capitalize(fontSize))], fontSize !== 'default'), _classNames), className),
      focusable: "false",
      viewBox: viewBox,
      color: nativeColor,
      "aria-hidden": titleAccess ? 'false' : 'true',
      role: titleAccess ? 'img' : 'presentation'
    }, other), children, titleAccess ? React.createElement("title", null, titleAccess) : null);
  }

  SvgIcon.propTypes = {
    /**
     * Node passed into the SVG element.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     * You can use the `nativeColor` property to apply a color attribute to the SVG element.
     */
    color: propTypes.oneOf(['inherit', 'primary', 'secondary', 'action', 'error', 'disabled']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
     */
    fontSize: propTypes.oneOf(['inherit', 'default', 'small', 'large']),

    /**
     * Applies a color attribute to the SVG element.
     */
    nativeColor: propTypes.string,

    /**
     * The shape-rendering attribute. The behavior of the different options is described on the
     * [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/shape-rendering).
     * If you are having issues with blurry icons you should investigate this property.
     */
    shapeRendering: propTypes.string,

    /**
     * Provides a human-readable title for the element that contains it.
     * https://www.w3.org/TR/SVG-access/#Equivalent
     */
    titleAccess: propTypes.string,

    /**
     * Allows you to redefine what the coordinates without units mean inside an SVG element.
     * For example, if the SVG element is 500 (width) by 200 (height),
     * and you pass viewBox="0 0 50 20",
     * this means that the coordinates inside the SVG will go from the top left corner (0,0)
     * to bottom right (50,20) and each unit will be worth 10px.
     */
    viewBox: propTypes.string
  };
  SvgIcon.defaultProps = {
    color: 'inherit',
    component: 'svg',
    fontSize: 'default',
    viewBox: '0 0 24 24'
  };
  SvgIcon.muiName = 'SvgIcon';
  var SvgIcon$1 = withStyles(styles$k, {
    name: 'MuiSvgIcon'
  })(SvgIcon);

  /**
   * @ignore - internal component.
   */

  var _ref = React.createElement("path", {
    d: "M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"
  });

  var CheckBoxOutlineBlank = function CheckBoxOutlineBlank(props) {
    return React.createElement(SvgIcon$1, props, _ref);
  };

  CheckBoxOutlineBlank = pure(CheckBoxOutlineBlank);
  CheckBoxOutlineBlank.muiName = 'SvgIcon';
  var CheckBoxOutlineBlankIcon = CheckBoxOutlineBlank;

  /**
   * @ignore - internal component.
   */

  var _ref$1 = React.createElement("path", {
    d: "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"
  });

  var CheckBox = function CheckBox(props) {
    return React.createElement(SvgIcon$1, props, _ref$1);
  };

  CheckBox = pure(CheckBox);
  CheckBox.muiName = 'SvgIcon';
  var CheckBoxIcon = CheckBox;

  /**
   * @ignore - internal component.
   */

  var _ref$2 = React.createElement("path", {
    d: "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10H7v-2h10v2z"
  });

  var IndeterminateCheckBox = function IndeterminateCheckBox(props) {
    return React.createElement(SvgIcon$1, props, _ref$2);
  };

  IndeterminateCheckBox = pure(IndeterminateCheckBox);
  IndeterminateCheckBox.muiName = 'SvgIcon';
  var IndeterminateCheckBoxIcon = IndeterminateCheckBox;

  var styles$l = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        color: theme.palette.text.secondary
      },

      /* Styles applied to the root element if `checked={true}`. */
      checked: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `indeterminate={true}`. */
      indeterminate: {},

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        '&$checked': {
          color: theme.palette.primary.main
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        '&$checked': {
          color: theme.palette.secondary.main
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      }
    };
  };

  function Checkbox(props) {
    var checkedIcon = props.checkedIcon,
        classes = props.classes,
        className = props.className,
        color = props.color,
        icon = props.icon,
        indeterminate = props.indeterminate,
        indeterminateIcon = props.indeterminateIcon,
        inputProps = props.inputProps,
        other = objectWithoutProperties(props, ["checkedIcon", "classes", "className", "color", "icon", "indeterminate", "indeterminateIcon", "inputProps"]);

    return React.createElement(SwitchBase$1, _extends_1({
      type: "checkbox",
      checkedIcon: indeterminate ? indeterminateIcon : checkedIcon,
      className: classnames(defineProperty({}, classes.indeterminate, indeterminate), className),
      classes: {
        root: classnames(classes.root, classes["color".concat(capitalize(color))]),
        checked: classes.checked,
        disabled: classes.disabled
      },
      inputProps: _extends_1({
        'data-indeterminate': indeterminate
      }, inputProps),
      icon: indeterminate ? indeterminateIcon : icon
    }, other));
  }

  Checkbox.propTypes = {
    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.oneOfType([propTypes.bool, propTypes.string]),

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'default']),

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * If `true`, the component appears indeterminate.
     * This does not set the native input element to indeterminate due
     * to inconsistent behavior across browsers.
     * However, we set a `data-indeterminate` attribute on the input.
     */
    indeterminate: propTypes.bool,

    /**
     * The icon to display when the component is indeterminate.
     */
    indeterminateIcon: propTypes.node,

    /**
     * Properties applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.checked`.
     * @param {boolean} checked The `checked` value of the switch
     */
    onChange: propTypes.func,

    /**
     * The input component property `type`.
     */
    type: propTypes.string,

    /**
     * The value of the component.
     */
    value: propTypes.string
  };
  Checkbox.defaultProps = {
    checkedIcon: React.createElement(CheckBoxIcon, null),
    color: 'secondary',
    icon: React.createElement(CheckBoxOutlineBlankIcon, null),
    indeterminate: false,
    indeterminateIcon: React.createElement(IndeterminateCheckBoxIcon, null)
  };
  var Checkbox$1 = withStyles(styles$l, {
    name: 'MuiCheckbox'
  })(Checkbox);

  /**
   * @ignore - internal component.
   */

  var _ref$3 = React.createElement("path", {
    d: "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"
  });

  var Cancel = function Cancel(props) {
    return React.createElement(SvgIcon$1, props, _ref$3);
  };

  Cancel = pure(Cancel);
  Cancel.muiName = 'SvgIcon';
  var CancelIcon = Cancel;

  var styles$m = function styles(theme) {
    var height = 32;
    var backgroundColor = theme.palette.type === 'light' ? theme.palette.grey[300] : theme.palette.grey[700];
    var deleteIconColor = fade(theme.palette.text.primary, 0.26);
    return {
      /* Styles applied to the root element. */
      root: {
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(13),
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        height: height,
        color: theme.palette.getContrastText(backgroundColor),
        backgroundColor: backgroundColor,
        borderRadius: height / 2,
        whiteSpace: 'nowrap',
        transition: theme.transitions.create(['background-color', 'box-shadow']),
        // label will inherit this from root, then `clickable` class overrides this for both
        cursor: 'default',
        // We disable the focus ring for mouse, touch and keyboard users.
        outline: 'none',
        textDecoration: 'none',
        border: 'none',
        // Remove `button` border
        padding: 0,
        // Remove `button` padding
        verticalAlign: 'middle',
        boxSizing: 'border-box'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        backgroundColor: theme.palette.primary.main,
        color: theme.palette.primary.contrastText
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        backgroundColor: theme.palette.secondary.main,
        color: theme.palette.secondary.contrastText
      },

      /* Styles applied to the root element if `onClick` is defined or `clickable={true}`. */
      clickable: {
        WebkitTapHighlightColor: 'transparent',
        // Remove grey highlight
        cursor: 'pointer',
        '&:hover, &:focus': {
          backgroundColor: emphasize(backgroundColor, 0.08)
        },
        '&:active': {
          boxShadow: theme.shadows[1],
          backgroundColor: emphasize(backgroundColor, 0.12)
        }
      },

      /**
       * Styles applied to the root element if
       * `onClick` and `color="primary"` is defined or `clickable={true}`.
       */
      clickableColorPrimary: {
        '&:hover, &:focus': {
          backgroundColor: emphasize(theme.palette.primary.main, 0.08)
        },
        '&:active': {
          backgroundColor: emphasize(theme.palette.primary.main, 0.12)
        }
      },

      /**
       * Styles applied to the root element if
       * `onClick` and `color="secondary"` is defined or `clickable={true}`.
       */
      clickableColorSecondary: {
        '&:hover, &:focus': {
          backgroundColor: emphasize(theme.palette.secondary.main, 0.08)
        },
        '&:active': {
          backgroundColor: emphasize(theme.palette.secondary.main, 0.12)
        }
      },

      /* Styles applied to the root element if `onDelete` is defined. */
      deletable: {
        '&:focus': {
          backgroundColor: emphasize(backgroundColor, 0.08)
        }
      },

      /* Styles applied to the root element if `onDelete` and `color="primary"` is defined. */
      deletableColorPrimary: {
        '&:focus': {
          backgroundColor: emphasize(theme.palette.primary.main, 0.2)
        }
      },

      /* Styles applied to the root element if `onDelete` and `color="secondary"` is defined. */
      deletableColorSecondary: {
        '&:focus': {
          backgroundColor: emphasize(theme.palette.secondary.main, 0.2)
        }
      },

      /* Styles applied to the root element if `variant="outlined"`. */
      outlined: {
        backgroundColor: 'transparent',
        border: "1px solid ".concat(theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)'),
        '$clickable&:hover, $clickable&:focus, $deletable&:focus': {
          backgroundColor: fade(theme.palette.text.primary, theme.palette.action.hoverOpacity)
        },
        '& $avatar': {
          marginLeft: -1
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="primary"`. */
      outlinedPrimary: {
        color: theme.palette.primary.main,
        border: "1px solid ".concat(theme.palette.primary.main),
        '$clickable&:hover, $clickable&:focus, $deletable&:focus': {
          backgroundColor: fade(theme.palette.primary.main, theme.palette.action.hoverOpacity)
        }
      },

      /* Styles applied to the root element if `variant="outlined"` and `color="secondary"`. */
      outlinedSecondary: {
        color: theme.palette.secondary.main,
        border: "1px solid ".concat(theme.palette.secondary.main),
        '$clickable&:hover, $clickable&:focus, $deletable&:focus': {
          backgroundColor: fade(theme.palette.secondary.main, theme.palette.action.hoverOpacity)
        }
      },

      /* Styles applied to the `avatar` element. */
      avatar: {
        marginRight: -4,
        width: height,
        height: height,
        color: theme.palette.type === 'light' ? theme.palette.grey[700] : theme.palette.grey[300],
        fontSize: theme.typography.pxToRem(16)
      },

      /* Styles applied to the `avatar` element if `color="primary"`. */
      avatarColorPrimary: {
        color: theme.palette.primary.contrastText,
        backgroundColor: theme.palette.primary.dark
      },

      /* Styles applied to the `avatar` element if `color="secondary"`. */
      avatarColorSecondary: {
        color: theme.palette.secondary.contrastText,
        backgroundColor: theme.palette.secondary.dark
      },

      /* Styles applied to the `avatar` elements children. */
      avatarChildren: {
        width: 19,
        height: 19
      },

      /* Styles applied to the `icon` element. */
      icon: {
        color: theme.palette.type === 'light' ? theme.palette.grey[700] : theme.palette.grey[300],
        marginLeft: 4,
        marginRight: -8
      },

      /* Styles applied to the `icon` element if `color="primary"`. */
      iconColorPrimary: {
        color: 'inherit'
      },

      /* Styles applied to the `icon` element if `color="secondary"`. */
      iconColorSecondary: {
        color: 'inherit'
      },

      /* Styles applied to the label `span` element`. */
      label: {
        display: 'flex',
        alignItems: 'center',
        paddingLeft: 12,
        paddingRight: 12,
        userSelect: 'none',
        whiteSpace: 'nowrap',
        cursor: 'inherit'
      },

      /* Styles applied to the `deleteIcon` element. */
      deleteIcon: {
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        color: deleteIconColor,
        cursor: 'pointer',
        height: 'auto',
        margin: '0 4px 0 -8px',
        '&:hover': {
          color: fade(deleteIconColor, 0.4)
        }
      },

      /* Styles applied to the deleteIcon element if `color="primary"` and `variant="default"`. */
      deleteIconColorPrimary: {
        color: fade(theme.palette.primary.contrastText, 0.7),
        '&:hover, &:active': {
          color: theme.palette.primary.contrastText
        }
      },

      /* Styles applied to the deleteIcon element if `color="secondary"` and `variant="default"`. */
      deleteIconColorSecondary: {
        color: fade(theme.palette.secondary.contrastText, 0.7),
        '&:hover, &:active': {
          color: theme.palette.secondary.contrastText
        }
      },

      /* Styles applied to the deleteIcon element if `color="primary"` and `variant="outlined"`. */
      deleteIconOutlinedColorPrimary: {
        color: fade(theme.palette.primary.main, 0.7),
        '&:hover, &:active': {
          color: theme.palette.primary.main
        }
      },

      /* Styles applied to the deleteIcon element if `color="secondary"` and `variant="outlined"`. */
      deleteIconOutlinedColorSecondary: {
        color: fade(theme.palette.secondary.main, 0.7),
        '&:hover, &:active': {
          color: theme.palette.secondary.main
        }
      }
    };
  };
  /**
   * Chips represent complex entities in small blocks, such as a contact.
   */

  var Chip =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Chip, _React$Component);

    function Chip() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Chip);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Chip)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.handleDeleteIconClick = function (event) {
        // Stop the event from bubbling up to the `Chip`
        event.stopPropagation();
        var onDelete = _this.props.onDelete;

        if (onDelete) {
          onDelete(event);
        }
      };

      _this.handleKeyDown = function (event) {
        var onKeyDown = _this.props.onKeyDown;

        if (onKeyDown) {
          onKeyDown(event);
        } // Ignore events from children of `Chip`.


        if (event.currentTarget !== event.target) {
          return;
        }

        var key = event.key;

        if (key === ' ' || key === 'Enter' || key === 'Backspace' || key === 'Escape') {
          event.preventDefault();
        }
      };

      _this.handleKeyUp = function (event) {
        var _this$props = _this.props,
            onClick = _this$props.onClick,
            onDelete = _this$props.onDelete,
            onKeyUp = _this$props.onKeyUp;

        if (onKeyUp) {
          onKeyUp(event);
        } // Ignore events from children of `Chip`.


        if (event.currentTarget !== event.target) {
          return;
        }

        var key = event.key;

        if (onClick && (key === ' ' || key === 'Enter')) {
          onClick(event);
        } else if (onDelete && key === 'Backspace') {
          onDelete(event);
        } else if (key === 'Escape' && _this.chipRef) {
          _this.chipRef.blur();
        }
      };

      return _this;
    }

    createClass(Chip, [{
      key: "render",
      value: function render() {
        var _classNames,
            _this2 = this;

        var _this$props2 = this.props,
            avatarProp = _this$props2.avatar,
            classes = _this$props2.classes,
            classNameProp = _this$props2.className,
            clickableProp = _this$props2.clickable,
            color = _this$props2.color,
            Component = _this$props2.component,
            deleteIconProp = _this$props2.deleteIcon,
            iconProp = _this$props2.icon,
            label = _this$props2.label,
            onClick = _this$props2.onClick,
            onDelete = _this$props2.onDelete,
            onKeyDown = _this$props2.onKeyDown,
            onKeyUp = _this$props2.onKeyUp,
            tabIndexProp = _this$props2.tabIndex,
            variant = _this$props2.variant,
            other = objectWithoutProperties(_this$props2, ["avatar", "classes", "className", "clickable", "color", "component", "deleteIcon", "icon", "label", "onClick", "onDelete", "onKeyDown", "onKeyUp", "tabIndex", "variant"]);

        var clickable = clickableProp !== false && onClick ? true : clickableProp;
        var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'default'), defineProperty(_classNames, classes.clickable, clickable), defineProperty(_classNames, classes["clickableColor".concat(capitalize(color))], clickable && color !== 'default'), defineProperty(_classNames, classes.deletable, onDelete), defineProperty(_classNames, classes["deletableColor".concat(capitalize(color))], onDelete && color !== 'default'), defineProperty(_classNames, classes.outlined, variant === 'outlined'), defineProperty(_classNames, classes.outlinedPrimary, variant === 'outlined' && color === 'primary'), defineProperty(_classNames, classes.outlinedSecondary, variant === 'outlined' && color === 'secondary'), _classNames), classNameProp);
        var deleteIcon = null;

        if (onDelete) {
          var _customClasses;

          var customClasses = (_customClasses = {}, defineProperty(_customClasses, classes["deleteIconColor".concat(capitalize(color))], color !== 'default' && variant !== 'outlined'), defineProperty(_customClasses, classes["deleteIconOutlinedColor".concat(capitalize(color))], color !== 'default' && variant === 'outlined'), _customClasses);
          deleteIcon = deleteIconProp && React.isValidElement(deleteIconProp) ? React.cloneElement(deleteIconProp, {
            className: classnames(deleteIconProp.props.className, classes.deleteIcon, customClasses),
            onClick: this.handleDeleteIconClick
          }) : React.createElement(CancelIcon, {
            className: classnames(classes.deleteIcon, customClasses),
            onClick: this.handleDeleteIconClick
          });
        }

        var avatar = null;

        if (avatarProp && React.isValidElement(avatarProp)) {
          avatar = React.cloneElement(avatarProp, {
            className: classnames(classes.avatar, avatarProp.props.className, defineProperty({}, classes["avatarColor".concat(capitalize(color))], color !== 'default')),
            childrenClassName: classnames(classes.avatarChildren, avatarProp.props.childrenClassName)
          });
        }

        var icon = null;

        if (iconProp && React.isValidElement(iconProp)) {
          icon = React.cloneElement(iconProp, {
            className: classnames(classes.icon, iconProp.props.className, defineProperty({}, classes["iconColor".concat(capitalize(color))], color !== 'default'))
          });
        }

        var tabIndex = tabIndexProp;

        if (!tabIndex) {
          tabIndex = onClick || onDelete || clickable ? 0 : -1;
        }

        warning_1(!avatar || !icon, 'Material-UI: the Chip component can not handle the avatar ' + 'and the icon property at the same time. Pick one.');
        return React.createElement(Component, _extends_1({
          role: "button",
          className: className,
          tabIndex: tabIndex,
          onClick: onClick,
          onKeyDown: this.handleKeyDown,
          onKeyUp: this.handleKeyUp,
          ref: function ref(_ref) {
            _this2.chipRef = _ref;
          }
        }, other), avatar || icon, React.createElement("span", {
          className: classes.label
        }, label), deleteIcon);
      }
    }]);

    return Chip;
  }(React.Component);

  Chip.propTypes = {
    /**
     * Avatar element.
     */
    avatar: propTypes.element,

    /**
     * This property isn't supported.
     * Use the `component` property if you need to change the children structure.
     */
    children: unsupportedProp,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If true, the chip will appear clickable, and will raise when pressed,
     * even if the onClick property is not defined.
     * If false, the chip will not be clickable, even if onClick property is defined.
     * This can be used, for example,
     * along with the component property to indicate an anchor Chip is clickable.
     */
    clickable: propTypes.bool,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Override the default delete icon element. Shown only if `onDelete` is set.
     */
    deleteIcon: propTypes.element,

    /**
     * Icon element.
     */
    icon: propTypes.element,

    /**
     * The content of the label.
     */
    label: propTypes.node,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * Callback function fired when the delete icon is clicked.
     * If set, the delete icon will be shown.
     */
    onDelete: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * @ignore
     */
    onKeyUp: propTypes.func,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['default', 'outlined'])
  };
  Chip.defaultProps = {
    component: 'div',
    color: 'default',
    variant: 'default'
  };
  var Chip$1 = withStyles(styles$m, {
    name: 'MuiChip'
  })(Chip);

  var SIZE = 44;

  function getRelativeValue(value, min, max) {
    var clampedValue = Math.min(Math.max(min, value), max);
    return (clampedValue - min) / (max - min);
  }

  function easeOut(t) {
    t = getRelativeValue(t, 0, 1); // https://gist.github.com/gre/1650294

    t = (t -= 1) * t * t + 1;
    return t;
  }

  function easeIn(t) {
    return t * t;
  }

  var styles$n = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'inline-block',
        lineHeight: 1 // Keep the progress centered

      },

      /* Styles applied to the root element if `variant="static"`. */
      static: {
        transition: theme.transitions.create('transform')
      },

      /* Styles applied to the root element if `variant="indeterminate"`. */
      indeterminate: {
        animation: 'mui-progress-circular-rotate 1.4s linear infinite',
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-progress-circular-rotate'
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the `svg` element. */
      svg: {},

      /* Styles applied to the `circle` svg path. */
      circle: {
        stroke: 'currentColor' // Use butt to follow the specification, by chance, it's already the default CSS value.
        // strokeLinecap: 'butt',

      },

      /* Styles applied to the `circle` svg path if `variant="static"`. */
      circleStatic: {
        transition: theme.transitions.create('stroke-dashoffset')
      },

      /* Styles applied to the `circle` svg path if `variant="indeterminate"`. */
      circleIndeterminate: {
        animation: 'mui-progress-circular-dash 1.4s ease-in-out infinite',
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-progress-circular-dash',
        // Some default value that looks fine waiting for the animation to kicks in.
        strokeDasharray: '80px, 200px',
        strokeDashoffset: '0px' // Add the unit to fix a Edge 16 and below bug.

      },
      '@keyframes mui-progress-circular-rotate': {
        '100%': {
          transform: 'rotate(360deg)'
        }
      },
      '@keyframes mui-progress-circular-dash': {
        '0%': {
          strokeDasharray: '1px, 200px',
          strokeDashoffset: '0px'
        },
        '50%': {
          strokeDasharray: '100px, 200px',
          strokeDashoffset: '-15px'
        },
        '100%': {
          strokeDasharray: '100px, 200px',
          strokeDashoffset: '-125px'
        }
      },

      /* Styles applied to the `circle` svg path if `disableShrink={true}`. */
      circleDisableShrink: {
        animation: 'none'
      }
    };
  };
  /**
   * ## ARIA
   *
   * If the progress bar is describing the loading progress of a particular region of a page,
   * you should use `aria-describedby` to point to the progress bar, and set the `aria-busy`
   * attribute to `true` on that region until it has finished loading.
   */

  function CircularProgress(props) {
    var _classNames, _classNames2;

    var classes = props.classes,
        className = props.className,
        color = props.color,
        disableShrink = props.disableShrink,
        size = props.size,
        style = props.style,
        thickness = props.thickness,
        value = props.value,
        variant = props.variant,
        other = objectWithoutProperties(props, ["classes", "className", "color", "disableShrink", "size", "style", "thickness", "value", "variant"]);

    var circleStyle = {};
    var rootStyle = {};
    var rootProps = {};

    if (variant === 'determinate' || variant === 'static') {
      var circumference = 2 * Math.PI * ((SIZE - thickness) / 2);
      circleStyle.strokeDasharray = circumference.toFixed(3);
      rootProps['aria-valuenow'] = Math.round(value);

      if (variant === 'static') {
        circleStyle.strokeDashoffset = "".concat(((100 - value) / 100 * circumference).toFixed(3), "px");
        rootStyle.transform = 'rotate(-90deg)';
      } else {
        circleStyle.strokeDashoffset = "".concat((easeIn((100 - value) / 100) * circumference).toFixed(3), "px");
        rootStyle.transform = "rotate(".concat((easeOut(value / 70) * 270).toFixed(3), "deg)");
      }
    }

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'inherit'), defineProperty(_classNames, classes.indeterminate, variant === 'indeterminate'), defineProperty(_classNames, classes.static, variant === 'static'), _classNames), className),
      style: _extends_1({
        width: size,
        height: size
      }, rootStyle, style),
      role: "progressbar"
    }, rootProps, other), React.createElement("svg", {
      className: classes.svg,
      viewBox: "".concat(SIZE / 2, " ").concat(SIZE / 2, " ").concat(SIZE, " ").concat(SIZE)
    }, React.createElement("circle", {
      className: classnames(classes.circle, (_classNames2 = {}, defineProperty(_classNames2, classes.circleIndeterminate, variant === 'indeterminate'), defineProperty(_classNames2, classes.circleStatic, variant === 'static'), defineProperty(_classNames2, classes.circleDisableShrink, disableShrink), _classNames2)),
      style: circleStyle,
      cx: SIZE,
      cy: SIZE,
      r: (SIZE - thickness) / 2,
      fill: "none",
      strokeWidth: thickness
    })));
  }

  CircularProgress.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'inherit']),

    /**
     * If `true`, the shrink animation is disabled.
     * This only works if variant is `indeterminate`.
     */
    disableShrink: chainPropTypes(propTypes.bool, function (props) {
      /* istanbul ignore if */
      if (props.disableShrink && props.variant !== 'indeterminate') {
        return new Error('Material-UI: you have provided the `disableShrink` property ' + 'with a variant other than `indeterminate`. This will have no effect.');
      }

      return null;
    }),

    /**
     * The size of the circle.
     */
    size: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * The thickness of the circle.
     */
    thickness: propTypes.number,

    /**
     * The value of the progress indicator for the determinate and static variants.
     * Value between 0 and 100.
     */
    value: propTypes.number,

    /**
     * The variant to use.
     * Use indeterminate when there is no progress value.
     */
    variant: propTypes.oneOf(['determinate', 'indeterminate', 'static'])
  };
  CircularProgress.defaultProps = {
    color: 'primary',
    disableShrink: false,
    size: 40,
    thickness: 3.6,
    value: 0,
    variant: 'indeterminate'
  };
  var CircularProgress$1 = withStyles(styles$n, {
    name: 'MuiCircularProgress',
    flip: false
  })(CircularProgress);

  var reactEventListener_cjs = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, '__esModule', { value: true });

  function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

  var _classCallCheck = _interopDefault(classCallCheck);
  var _createClass = _interopDefault(createClass);
  var _possibleConstructorReturn = _interopDefault(possibleConstructorReturn);
  var _getPrototypeOf = _interopDefault(getPrototypeOf);
  var _inherits = _interopDefault(inherits);
  var _typeof = _interopDefault(_typeof_1);
  var _objectWithoutProperties = _interopDefault(objectWithoutProperties);
  var _extends = _interopDefault(_extends_1);
  var React$$1 = _interopDefault(React);
  var PropTypes = _interopDefault(propTypes);
  var warning = _interopDefault(warning_1);

  function defineProperty(object, property, attr) {
    return Object.defineProperty(object, property, attr);
  } // Passive options
  // Inspired by https://github.com/Modernizr/Modernizr/blob/master/feature-detects/dom/passiveeventlisteners.js


  var passiveOption = function () {
    var cache = null;
    return function () {
      if (cache !== null) {
        return cache;
      }

      var supportsPassiveOption = false;

      try {
        window.addEventListener('test', null, defineProperty({}, 'passive', {
          get: function get() {
            supportsPassiveOption = true;
          }
        }));
      } catch (err) {//
      }

      cache = supportsPassiveOption;
      return supportsPassiveOption;
    }();
  }();

  var defaultEventOptions = {
    capture: false,
    passive: false
  };

  function mergeDefaultEventOptions(options) {
    return _extends({}, defaultEventOptions, options);
  }

  function getEventListenerArgs(eventName, callback, options) {
    var args = [eventName, callback];
    args.push(passiveOption ? options : options.capture);
    return args;
  }

  function on$$1(target, eventName, callback, options) {
    // eslint-disable-next-line prefer-spread
    target.addEventListener.apply(target, getEventListenerArgs(eventName, callback, options));
  }

  function off$$1(target, eventName, callback, options) {
    // eslint-disable-next-line prefer-spread
    target.removeEventListener.apply(target, getEventListenerArgs(eventName, callback, options));
  }

  function forEachListener(props, iteratee) {
    var children = props.children,
        target = props.target,
        eventProps = _objectWithoutProperties(props, ["children", "target"]);

    Object.keys(eventProps).forEach(function (name) {
      if (name.substring(0, 2) !== 'on') {
        return;
      }

      var prop = eventProps[name];

      var type = _typeof(prop);

      var isObject = type === 'object';
      var isFunction = type === 'function';

      if (!isObject && !isFunction) {
        return;
      }

      var capture = name.substr(-7).toLowerCase() === 'capture';
      var eventName = name.substring(2).toLowerCase();
      eventName = capture ? eventName.substring(0, eventName.length - 7) : eventName;

      if (isObject) {
        iteratee(eventName, prop.handler, prop.options);
      } else {
        iteratee(eventName, prop, mergeDefaultEventOptions({
          capture: capture
        }));
      }
    });
  }

  function withOptions(handler, options) {
    warning(options, 'react-event-listener: should be specified options in withOptions.');
    return {
      handler: handler,
      options: mergeDefaultEventOptions(options)
    };
  }

  var EventListener =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inherits(EventListener, _React$PureComponent);

    function EventListener() {
      _classCallCheck(this, EventListener);

      return _possibleConstructorReturn(this, _getPrototypeOf(EventListener).apply(this, arguments));
    }

    _createClass(EventListener, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.applyListeners(on$$1);
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        this.applyListeners(off$$1, prevProps);
        this.applyListeners(on$$1);
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.applyListeners(off$$1);
      }
    }, {
      key: "applyListeners",
      value: function applyListeners(onOrOff) {
        var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.props;
        var target = props.target;

        if (target) {
          var element = target;

          if (typeof target === 'string') {
            element = window[target];
          }

          forEachListener(props, onOrOff.bind(null, element));
        }
      }
    }, {
      key: "render",
      value: function render() {
        return this.props.children || null;
      }
    }]);

    return EventListener;
  }(React$$1.PureComponent);

  EventListener.propTypes = {
    /**
     * You can provide a single child too.
     */
    children: PropTypes.node,

    /**
     * The DOM target to listen to.
     */
    target: PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
  };

  exports.withOptions = withOptions;
  exports.default = EventListener;
  });

  var EventListener = unwrapExports(reactEventListener_cjs);
  var reactEventListener_cjs_1 = reactEventListener_cjs.withOptions;

  /**
   * Listen for click events that occur somewhere in the document, outside of the element itself.
   * For instance, if you need to hide a menu when people click anywhere else on your page.
   */

  var ClickAwayListener =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(ClickAwayListener, _React$Component);

    function ClickAwayListener() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, ClickAwayListener);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(ClickAwayListener)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.mounted = false;
      _this.moved = false;

      _this.handleClickAway = function (event) {
        // Ignore events that have been `event.preventDefault()` marked.
        if (event.defaultPrevented) {
          return;
        } // IE 11 support, which trigger the handleClickAway even after the unbind


        if (!_this.mounted) {
          return;
        } // Do not act if user performed touchmove


        if (_this.moved) {
          _this.moved = false;
          return;
        } // The child might render null.


        if (!_this.node) {
          return;
        }

        var doc = ownerDocument(_this.node);

        if (doc.documentElement && doc.documentElement.contains(event.target) && !_this.node.contains(event.target)) {
          _this.props.onClickAway(event);
        }
      };

      _this.handleTouchMove = function () {
        _this.moved = true;
      };

      return _this;
    }

    createClass(ClickAwayListener, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        // Finds the first child when a component returns a fragment.
        // https://github.com/facebook/react/blob/036ae3c6e2f056adffc31dfb78d1b6f0c63272f0/packages/react-dom/src/__tests__/ReactDOMFiber-test.js#L105
        this.node = ReactDOM.findDOMNode(this);
        this.mounted = true;
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.mounted = false;
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            children = _this$props.children,
            mouseEvent = _this$props.mouseEvent,
            touchEvent = _this$props.touchEvent,
            onClickAway = _this$props.onClickAway,
            other = objectWithoutProperties(_this$props, ["children", "mouseEvent", "touchEvent", "onClickAway"]);

        var listenerProps = {};

        if (mouseEvent !== false) {
          listenerProps[mouseEvent] = this.handleClickAway;
        }

        if (touchEvent !== false) {
          listenerProps[touchEvent] = this.handleClickAway;
          listenerProps.onTouchMove = this.handleTouchMove;
        }

        return React.createElement(React.Fragment, null, children, React.createElement(EventListener, _extends_1({
          target: "document"
        }, listenerProps, other)));
      }
    }]);

    return ClickAwayListener;
  }(React.Component);

  ClickAwayListener.propTypes = {
    /**
     * The wrapped element.
     */
    children: propTypes.element.isRequired,

    /**
     * The mouse event to listen to. You can disable the listener by providing `false`.
     */
    mouseEvent: propTypes.oneOf(['onClick', 'onMouseDown', 'onMouseUp', false]),

    /**
     * Callback fired when a "click away" event is detected.
     */
    onClickAway: propTypes.func.isRequired,

    /**
     * The touch event to listen to. You can disable the listener by providing `false`.
     */
    touchEvent: propTypes.oneOf(['onTouchStart', 'onTouchEnd', false])
  };
  ClickAwayListener.defaultProps = {
    mouseEvent: 'onMouseUp',
    touchEvent: 'onTouchEnd'
  };

  var styles$o = function styles(theme) {
    return {
      /* Styles applied to the container element. */
      container: {
        height: 0,
        overflow: 'hidden',
        transition: theme.transitions.create('height')
      },

      /* Styles applied to the container element when the transition has entered. */
      entered: {
        height: 'auto',
        overflow: 'visible'
      },

      /* Styles applied to the outer wrapper element. */
      wrapper: {
        // Hack to get children with a negative margin to not falsify the height computation.
        display: 'flex'
      },

      /* Styles applied to the inner wrapper element. */
      wrapperInner: {
        width: '100%'
      }
    };
  };
  /**
   * The Collapse transition is used by the
   * [Vertical Stepper](/demos/steppers/#vertical-stepper) StepContent component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Collapse =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Collapse, _React$Component);

    function Collapse() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Collapse);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Collapse)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.handleEnter = function (node) {
        node.style.height = _this.props.collapsedHeight;

        if (_this.props.onEnter) {
          _this.props.onEnter(node);
        }
      };

      _this.handleEntering = function (node) {
        var _this$props = _this.props,
            timeout = _this$props.timeout,
            theme = _this$props.theme;
        var wrapperHeight = _this.wrapperRef ? _this.wrapperRef.clientHeight : 0;

        var _getTransitionProps = getTransitionProps(_this.props, {
          mode: 'enter'
        }),
            transitionDuration = _getTransitionProps.duration;

        if (timeout === 'auto') {
          var duration2 = theme.transitions.getAutoHeightDuration(wrapperHeight);
          node.style.transitionDuration = "".concat(duration2, "ms");
          _this.autoTransitionDuration = duration2;
        } else {
          node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : "".concat(transitionDuration, "ms");
        }

        node.style.height = "".concat(wrapperHeight, "px");

        if (_this.props.onEntering) {
          _this.props.onEntering(node);
        }
      };

      _this.handleEntered = function (node) {
        node.style.height = 'auto';

        if (_this.props.onEntered) {
          _this.props.onEntered(node);
        }
      };

      _this.handleExit = function (node) {
        var wrapperHeight = _this.wrapperRef ? _this.wrapperRef.clientHeight : 0;
        node.style.height = "".concat(wrapperHeight, "px");

        if (_this.props.onExit) {
          _this.props.onExit(node);
        }
      };

      _this.handleExiting = function (node) {
        var _this$props2 = _this.props,
            timeout = _this$props2.timeout,
            theme = _this$props2.theme;
        var wrapperHeight = _this.wrapperRef ? _this.wrapperRef.clientHeight : 0;

        var _getTransitionProps2 = getTransitionProps(_this.props, {
          mode: 'exit'
        }),
            transitionDuration = _getTransitionProps2.duration;

        if (timeout === 'auto') {
          var duration2 = theme.transitions.getAutoHeightDuration(wrapperHeight);
          node.style.transitionDuration = "".concat(duration2, "ms");
          _this.autoTransitionDuration = duration2;
        } else {
          node.style.transitionDuration = typeof transitionDuration === 'string' ? transitionDuration : "".concat(transitionDuration, "ms");
        }

        node.style.height = _this.props.collapsedHeight;

        if (_this.props.onExiting) {
          _this.props.onExiting(node);
        }
      };

      _this.addEndListener = function (_, next) {
        if (_this.props.timeout === 'auto') {
          _this.timer = setTimeout(next, _this.autoTransitionDuration || 0);
        }
      };

      return _this;
    }

    createClass(Collapse, [{
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.timer);
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props3 = this.props,
            children = _this$props3.children,
            classes = _this$props3.classes,
            className = _this$props3.className,
            collapsedHeight = _this$props3.collapsedHeight,
            Component = _this$props3.component,
            onEnter = _this$props3.onEnter,
            onEntered = _this$props3.onEntered,
            onEntering = _this$props3.onEntering,
            onExit = _this$props3.onExit,
            onExiting = _this$props3.onExiting,
            style = _this$props3.style,
            theme = _this$props3.theme,
            timeout = _this$props3.timeout,
            other = objectWithoutProperties(_this$props3, ["children", "classes", "className", "collapsedHeight", "component", "onEnter", "onEntered", "onEntering", "onExit", "onExiting", "style", "theme", "timeout"]);

        return React.createElement(Transition, _extends_1({
          onEnter: this.handleEnter,
          onEntered: this.handleEntered,
          onEntering: this.handleEntering,
          onExit: this.handleExit,
          onExiting: this.handleExiting,
          addEndListener: this.addEndListener,
          timeout: timeout === 'auto' ? null : timeout
        }, other), function (state, childProps) {
          return React.createElement(Component, _extends_1({
            className: classnames(classes.container, defineProperty({}, classes.entered, state === 'entered'), className),
            style: _extends_1({}, style, {
              minHeight: collapsedHeight
            })
          }, childProps), React.createElement("div", {
            className: classes.wrapper,
            ref: function ref(_ref) {
              _this2.wrapperRef = _ref;
            }
          }, React.createElement("div", {
            className: classes.wrapperInner
          }, children)));
        });
      }
    }]);

    return Collapse;
  }(React.Component);

  Collapse.propTypes = {
    /**
     * The content node to be collapsed.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The height of the container when collapsed.
     */
    collapsedHeight: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the component will transition in.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onEntered: propTypes.func,

    /**
     * @ignore
     */
    onEntering: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    onExiting: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])])
  };
  Collapse.defaultProps = {
    collapsedHeight: '0px',
    component: 'div',
    timeout: duration.standard
  };
  Collapse.muiSupportAuto = true;
  var Collapse$1 = withStyles(styles$o, {
    withTheme: true,
    name: 'MuiCollapse'
  })(Collapse);

  var styles$p = function styles(theme) {
    return {
      '@global': {
        html: {
          WebkitFontSmoothing: 'antialiased',
          // Antialiasing.
          MozOsxFontSmoothing: 'grayscale',
          // Antialiasing.
          // Change from `box-sizing: content-box` so that `width`
          // is not affected by `padding` or `border`.
          boxSizing: 'border-box'
        },
        '*, *::before, *::after': {
          boxSizing: 'inherit'
        },
        body: {
          margin: 0,
          // Remove the margin in all browsers.
          backgroundColor: theme.palette.background.default,
          '@media print': {
            // Save printer ink.
            backgroundColor: theme.palette.common.white
          }
        }
      }
    };
  };
  /**
   * Kickstart an elegant, consistent, and simple baseline to build upon.
   */


  var CssBaseline =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(CssBaseline, _React$Component);

    function CssBaseline() {
      classCallCheck(this, CssBaseline);

      return possibleConstructorReturn(this, getPrototypeOf(CssBaseline).apply(this, arguments));
    }

    createClass(CssBaseline, [{
      key: "render",
      value: function render() {
        return this.props.children;
      }
    }]);

    return CssBaseline;
  }(React.Component);

  CssBaseline.propTypes = {
    /**
     * You can wrap a node.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    classes: propTypes.object.isRequired
  };

  {
    CssBaseline.propTypes = exactProp(CssBaseline.propTypes);
  }

  CssBaseline.defaultProps = {
    children: null
  };
  var CssBaseline$1 = withStyles(styles$p, {
    name: 'MuiCssBaseline'
  })(CssBaseline);

  /**
   * Helper component to allow attaching a ref to a
   * wrapped element to access the underlying DOM element.
   *
   * It's highly inspired by https://github.com/facebook/react/issues/11401#issuecomment-340543801.
   * For example:
   * ```jsx
   * import React from 'react';
   * import RootRef from '@material-ui/core/RootRef';
   *
   * class MyComponent extends React.Component {
   *   constructor() {
   *     super();
   *     this.domRef = React.createRef();
   *   }
   *
   *   componentDidMount() {
   *     console.log(this.domRef.current); // DOM node
   *   }
   *
   *   render() {
   *     return (
   *       <RootRef rootRef={this.domRef}>
   *         <SomeChildComponent />
   *       </RootRef>
   *     );
   *   }
   * }
   * ```
   */

  var RootRef =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(RootRef, _React$Component);

    function RootRef() {
      classCallCheck(this, RootRef);

      return possibleConstructorReturn(this, getPrototypeOf(RootRef).apply(this, arguments));
    }

    createClass(RootRef, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.ref = ReactDOM.findDOMNode(this);
        setRef(this.props.rootRef, this.ref);
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var ref = ReactDOM.findDOMNode(this);

        if (prevProps.rootRef !== this.props.rootRef || this.ref !== ref) {
          if (prevProps.rootRef !== this.props.rootRef) {
            setRef(prevProps.rootRef, null);
          }

          this.ref = ref;
          setRef(this.props.rootRef, this.ref);
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.ref = null;
        setRef(this.props.rootRef, null);
      }
    }, {
      key: "render",
      value: function render() {
        return this.props.children;
      }
    }]);

    return RootRef;
  }(React.Component);

  RootRef.propTypes = {
    /**
     * The wrapped element.
     */
    children: propTypes.element.isRequired,

    /**
     * Provide a way to access the DOM node of the wrapped element.
     * You can provide a callback ref or a `React.createRef()` ref.
     */
    rootRef: propTypes.oneOfType([propTypes.func, propTypes.object]).isRequired
  };

  {
    RootRef.propTypes = exactProp(RootRef.propTypes);
  }

  function getContainer(container, defaultContainer) {
    container = typeof container === 'function' ? container() : container;
    return ReactDOM.findDOMNode(container) || defaultContainer;
  }

  function getOwnerDocument(element) {
    return ownerDocument(ReactDOM.findDOMNode(element));
  }
  /**
   * Portals provide a first-class way to render children into a DOM node
   * that exists outside the DOM hierarchy of the parent component.
   */


  var Portal =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Portal, _React$Component);

    function Portal() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Portal);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Portal)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.getMountNode = function () {
        return _this.mountNode;
      };

      return _this;
    }

    createClass(Portal, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.setMountNode(this.props.container); // Only rerender if needed

        if (!this.props.disablePortal) {
          this.forceUpdate(this.props.onRendered);
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var _this2 = this;

        if (prevProps.container !== this.props.container || prevProps.disablePortal !== this.props.disablePortal) {
          this.setMountNode(this.props.container); // Only rerender if needed

          if (!this.props.disablePortal) {
            this.forceUpdate(function () {
              if (_this2.props.onRendered) {
                // This might be triggered earlier than the componentDidUpdate of a parent element.
                // We need to account for it.
                clearTimeout(_this2.renderedTimer);
                _this2.renderedTimer = setTimeout(_this2.props.onRendered);
              }
            });
          }
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.mountNode = null;
        clearTimeout(this.renderedTimer);
      }
    }, {
      key: "setMountNode",
      value: function setMountNode(container) {
        if (this.props.disablePortal) {
          this.mountNode = ReactDOM.findDOMNode(this).parentElement;
          return;
        }

        this.mountNode = getContainer(container, getOwnerDocument(this).body);
      }
      /**
       * @public
       */

    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            children = _this$props.children,
            disablePortal = _this$props.disablePortal;

        if (disablePortal) {
          return children;
        }

        return this.mountNode ? ReactDOM.createPortal(children, this.mountNode) : null;
      }
    }]);

    return Portal;
  }(React.Component);

  Portal.propTypes = {
    /**
     * The children to render into the `container`.
     */
    children: propTypes.node.isRequired,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will have the portal children appended to it.
     * By default, it uses the body of the top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * Disable the portal behavior.
     * The children stay within it's parent DOM hierarchy.
     */
    disablePortal: propTypes.bool,

    /**
     * Callback fired once the children has been mounted into the `container`.
     */
    onRendered: propTypes.func
  };
  Portal.defaultProps = {
    disablePortal: false
  };

  {
    Portal.propTypes = exactProp(Portal.propTypes);
  }

  var camelize_1$1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = camelize;
  var rHyphen = /-(.)/g;

  function camelize(string) {
    return string.replace(rHyphen, function (_, chr) {
      return chr.toUpperCase();
    });
  }

  module.exports = exports["default"];
  });

  unwrapExports(camelize_1$1);

  var camelizeStyle = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = camelizeStyleName;

  var _camelize = interopRequireDefault(camelize_1$1);

  /**
   * Copyright 2014-2015, Facebook, Inc.
   * All rights reserved.
   * https://github.com/facebook/react/blob/2aeb8a2a6beb00617a4217f7f8284924fa2ad819/src/vendor/core/camelizeStyleName.js
   */
  var msPattern = /^-ms-/;

  function camelizeStyleName(string) {
    return (0, _camelize.default)(string.replace(msPattern, 'ms-'));
  }

  module.exports = exports["default"];
  });

  unwrapExports(camelizeStyle);

  var hyphenate_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = hyphenate;
  var rUpper = /([A-Z])/g;

  function hyphenate(string) {
    return string.replace(rUpper, '-$1').toLowerCase();
  }

  module.exports = exports["default"];
  });

  unwrapExports(hyphenate_1);

  var hyphenateStyle = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = hyphenateStyleName;

  var _hyphenate = interopRequireDefault(hyphenate_1);

  /**
   * Copyright 2013-2014, Facebook, Inc.
   * All rights reserved.
   * https://github.com/facebook/react/blob/2aeb8a2a6beb00617a4217f7f8284924fa2ad819/src/vendor/core/hyphenateStyleName.js
   */
  var msPattern = /^ms-/;

  function hyphenateStyleName(string) {
    return (0, _hyphenate.default)(string).replace(msPattern, '-ms-');
  }

  module.exports = exports["default"];
  });

  unwrapExports(hyphenateStyle);

  var getComputedStyle$1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = _getComputedStyle;

  var _camelizeStyle = interopRequireDefault(camelizeStyle);

  var rposition = /^(top|right|bottom|left)$/;
  var rnumnonpx = /^([+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|))(?!px)[a-z%]+$/i;

  function _getComputedStyle(node) {
    if (!node) throw new TypeError('No Element passed to `getComputedStyle()`');
    var doc = node.ownerDocument;
    return 'defaultView' in doc ? doc.defaultView.opener ? node.ownerDocument.defaultView.getComputedStyle(node, null) : window.getComputedStyle(node, null) : {
      //ie 8 "magic" from: https://github.com/jquery/jquery/blob/1.11-stable/src/css/curCSS.js#L72
      getPropertyValue: function getPropertyValue(prop) {
        var style = node.style;
        prop = (0, _camelizeStyle.default)(prop);
        if (prop == 'float') prop = 'styleFloat';
        var current = node.currentStyle[prop] || null;
        if (current == null && style && style[prop]) current = style[prop];

        if (rnumnonpx.test(current) && !rposition.test(prop)) {
          // Remember the original values
          var left = style.left;
          var runStyle = node.runtimeStyle;
          var rsLeft = runStyle && runStyle.left; // Put in the new values to get a computed value out

          if (rsLeft) runStyle.left = node.currentStyle.left;
          style.left = prop === 'fontSize' ? '1em' : current;
          current = style.pixelLeft + 'px'; // Revert the changed values

          style.left = left;
          if (rsLeft) runStyle.left = rsLeft;
        }

        return current;
      }
    };
  }

  module.exports = exports["default"];
  });

  unwrapExports(getComputedStyle$1);

  var removeStyle_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = removeStyle;

  function removeStyle(node, key) {
    return 'removeProperty' in node.style ? node.style.removeProperty(key) : node.style.removeAttribute(key);
  }

  module.exports = exports["default"];
  });

  unwrapExports(removeStyle_1);

  var inDOM = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = void 0;

  var _default = !!(typeof window !== 'undefined' && window.document && window.document.createElement);

  exports.default = _default;
  module.exports = exports["default"];
  });

  unwrapExports(inDOM);

  var properties = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = exports.animationEnd = exports.animationDelay = exports.animationTiming = exports.animationDuration = exports.animationName = exports.transitionEnd = exports.transitionDuration = exports.transitionDelay = exports.transitionTiming = exports.transitionProperty = exports.transform = void 0;

  var _inDOM = interopRequireDefault(inDOM);

  var transform = 'transform';
  exports.transform = transform;
  var prefix, transitionEnd, animationEnd;
  exports.animationEnd = animationEnd;
  exports.transitionEnd = transitionEnd;
  var transitionProperty, transitionDuration, transitionTiming, transitionDelay;
  exports.transitionDelay = transitionDelay;
  exports.transitionTiming = transitionTiming;
  exports.transitionDuration = transitionDuration;
  exports.transitionProperty = transitionProperty;
  var animationName, animationDuration, animationTiming, animationDelay;
  exports.animationDelay = animationDelay;
  exports.animationTiming = animationTiming;
  exports.animationDuration = animationDuration;
  exports.animationName = animationName;

  if (_inDOM.default) {
    var _getTransitionPropert = getTransitionProperties();

    prefix = _getTransitionPropert.prefix;
    exports.transitionEnd = transitionEnd = _getTransitionPropert.transitionEnd;
    exports.animationEnd = animationEnd = _getTransitionPropert.animationEnd;
    exports.transform = transform = prefix + "-" + transform;
    exports.transitionProperty = transitionProperty = prefix + "-transition-property";
    exports.transitionDuration = transitionDuration = prefix + "-transition-duration";
    exports.transitionDelay = transitionDelay = prefix + "-transition-delay";
    exports.transitionTiming = transitionTiming = prefix + "-transition-timing-function";
    exports.animationName = animationName = prefix + "-animation-name";
    exports.animationDuration = animationDuration = prefix + "-animation-duration";
    exports.animationTiming = animationTiming = prefix + "-animation-delay";
    exports.animationDelay = animationDelay = prefix + "-animation-timing-function";
  }

  var _default = {
    transform: transform,
    end: transitionEnd,
    property: transitionProperty,
    timing: transitionTiming,
    delay: transitionDelay,
    duration: transitionDuration
  };
  exports.default = _default;

  function getTransitionProperties() {
    var style = document.createElement('div').style;
    var vendorMap = {
      O: function O(e) {
        return "o" + e.toLowerCase();
      },
      Moz: function Moz(e) {
        return e.toLowerCase();
      },
      Webkit: function Webkit(e) {
        return "webkit" + e;
      },
      ms: function ms(e) {
        return "MS" + e;
      }
    };
    var vendors = Object.keys(vendorMap);
    var transitionEnd, animationEnd;
    var prefix = '';

    for (var i = 0; i < vendors.length; i++) {
      var vendor = vendors[i];

      if (vendor + "TransitionProperty" in style) {
        prefix = "-" + vendor.toLowerCase();
        transitionEnd = vendorMap[vendor]('TransitionEnd');
        animationEnd = vendorMap[vendor]('AnimationEnd');
        break;
      }
    }

    if (!transitionEnd && 'transitionProperty' in style) transitionEnd = 'transitionend';
    if (!animationEnd && 'animationName' in style) animationEnd = 'animationend';
    style = null;
    return {
      animationEnd: animationEnd,
      transitionEnd: transitionEnd,
      prefix: prefix
    };
  }
  });

  unwrapExports(properties);
  var properties_1 = properties.animationEnd;
  var properties_2 = properties.animationDelay;
  var properties_3 = properties.animationTiming;
  var properties_4 = properties.animationDuration;
  var properties_5 = properties.animationName;
  var properties_6 = properties.transitionEnd;
  var properties_7 = properties.transitionDuration;
  var properties_8 = properties.transitionDelay;
  var properties_9 = properties.transitionTiming;
  var properties_10 = properties.transitionProperty;
  var properties_11 = properties.transform;

  var isTransform_1 = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = isTransform;
  var supportedTransforms = /^((translate|rotate|scale)(X|Y|Z|3d)?|matrix(3d)?|perspective|skew(X|Y)?)$/i;

  function isTransform(property) {
    return !!(property && supportedTransforms.test(property));
  }

  module.exports = exports["default"];
  });

  unwrapExports(isTransform_1);

  var style_1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = style;

  var _camelizeStyle = interopRequireDefault(camelizeStyle);

  var _hyphenateStyle = interopRequireDefault(hyphenateStyle);

  var _getComputedStyle2 = interopRequireDefault(getComputedStyle$1);

  var _removeStyle = interopRequireDefault(removeStyle_1);



  var _isTransform = interopRequireDefault(isTransform_1);

  function style(node, property, value) {
    var css = '';
    var transforms = '';
    var props = property;

    if (typeof property === 'string') {
      if (value === undefined) {
        return node.style[(0, _camelizeStyle.default)(property)] || (0, _getComputedStyle2.default)(node).getPropertyValue((0, _hyphenateStyle.default)(property));
      } else {
        (props = {})[property] = value;
      }
    }

    Object.keys(props).forEach(function (key) {
      var value = props[key];

      if (!value && value !== 0) {
        (0, _removeStyle.default)(node, (0, _hyphenateStyle.default)(key));
      } else if ((0, _isTransform.default)(key)) {
        transforms += key + "(" + value + ") ";
      } else {
        css += (0, _hyphenateStyle.default)(key) + ": " + value + ";";
      }
    });

    if (transforms) {
      css += properties.transform + ": " + transforms + ";";
    }

    node.style.cssText += ';' + css;
  }

  module.exports = exports["default"];
  });

  var css = unwrapExports(style_1);

  var scrollbarSize_1 = createCommonjsModule(function (module, exports) {



  exports.__esModule = true;
  exports.default = scrollbarSize;

  var _inDOM = interopRequireDefault(inDOM);

  var size;

  function scrollbarSize(recalc) {
    if (!size && size !== 0 || recalc) {
      if (_inDOM.default) {
        var scrollDiv = document.createElement('div');
        scrollDiv.style.position = 'absolute';
        scrollDiv.style.top = '-9999px';
        scrollDiv.style.width = '50px';
        scrollDiv.style.height = '50px';
        scrollDiv.style.overflow = 'scroll';
        document.body.appendChild(scrollDiv);
        size = scrollDiv.offsetWidth - scrollDiv.clientWidth;
        document.body.removeChild(scrollDiv);
      }
    }

    return size;
  }

  module.exports = exports["default"];
  });

  var getScrollbarSize = unwrapExports(scrollbarSize_1);

  var isWindow = createCommonjsModule(function (module, exports) {

  exports.__esModule = true;
  exports.default = getWindow;

  function getWindow(node) {
    return node === node.window ? node : node.nodeType === 9 ? node.defaultView || node.parentWindow : false;
  }

  module.exports = exports["default"];
  });

  var isWindow$1 = unwrapExports(isWindow);

  function isBody(node) {
    return node && node.tagName.toLowerCase() === 'body';
  } // Do we have a vertical scroll bar?

  function isOverflowing(container) {
    var doc = ownerDocument(container);
    var win = ownerWindow(doc);
    /* istanbul ignore next */

    if (!isWindow$1(doc) && !isBody(container)) {
      return container.scrollHeight > container.clientHeight;
    } // Takes in account potential non zero margin on the body.


    var style = win.getComputedStyle(doc.body);
    var marginLeft = parseInt(style.getPropertyValue('margin-left'), 10);
    var marginRight = parseInt(style.getPropertyValue('margin-right'), 10);
    return marginLeft + doc.body.clientWidth + marginRight < win.innerWidth;
  }

  var BLACKLIST = ['template', 'script', 'style'];

  function isHideable(node) {
    return node.nodeType === 1 && BLACKLIST.indexOf(node.tagName.toLowerCase()) === -1;
  }

  function siblings(container, mount, currentNode, callback) {
    var blacklist = [mount, currentNode];
    [].forEach.call(container.children, function (node) {
      if (blacklist.indexOf(node) === -1 && isHideable(node)) {
        callback(node);
      }
    });
  }

  function ariaHidden(node, show) {
    if (show) {
      node.setAttribute('aria-hidden', 'true');
    } else {
      node.removeAttribute('aria-hidden');
    }
  }
  function ariaHiddenSiblings(container, mountNode, currentNode, show) {
    siblings(container, mountNode, currentNode, function (node) {
      return ariaHidden(node, show);
    });
  }

  function findIndexOf(data, callback) {
    var idx = -1;
    data.some(function (item, index) {
      if (callback(item)) {
        idx = index;
        return true;
      }

      return false;
    });
    return idx;
  }

  function getPaddingRight(node) {
    return parseInt(css(node, 'paddingRight') || 0, 10);
  }

  function setContainerStyle(data) {
    // We are only interested in the actual `style` here because we will override it.
    data.style = {
      overflow: data.container.style.overflow,
      paddingRight: data.container.style.paddingRight
    };
    var style = {
      overflow: 'hidden'
    };

    if (data.overflowing) {
      var scrollbarSize = getScrollbarSize(); // Use computed style, here to get the real padding to add our scrollbar width.

      style.paddingRight = "".concat(getPaddingRight(data.container) + scrollbarSize, "px"); // .mui-fixed is a global helper.

      var fixedNodes = ownerDocument(data.container).querySelectorAll('.mui-fixed');

      for (var i = 0; i < fixedNodes.length; i += 1) {
        var paddingRight = getPaddingRight(fixedNodes[i]);
        data.prevPaddings.push(paddingRight);
        fixedNodes[i].style.paddingRight = "".concat(paddingRight + scrollbarSize, "px");
      }
    }

    Object.keys(style).forEach(function (key) {
      data.container.style[key] = style[key];
    });
  }

  function removeContainerStyle(data) {
    // The modal might be closed before it had the chance to be mounted in the DOM.
    if (data.style) {
      Object.keys(data.style).forEach(function (key) {
        data.container.style[key] = data.style[key];
      });
    }

    var fixedNodes = ownerDocument(data.container).querySelectorAll('.mui-fixed');

    for (var i = 0; i < fixedNodes.length; i += 1) {
      fixedNodes[i].style.paddingRight = "".concat(data.prevPaddings[i], "px");
    }
  }
  /**
   * @ignore - do not document.
   *
   * Proper state management for containers and the modals in those containers.
   * Simplified, but inspired by react-overlay's ModalManager class.
   * Used by the Modal to ensure proper styling of containers.
   */


  var ModalManager =
  /*#__PURE__*/
  function () {
    function ModalManager() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      classCallCheck(this, ModalManager);

      var _options$hideSiblingN = options.hideSiblingNodes,
          hideSiblingNodes = _options$hideSiblingN === void 0 ? true : _options$hideSiblingN,
          _options$handleContai = options.handleContainerOverflow,
          handleContainerOverflow = _options$handleContai === void 0 ? true : _options$handleContai;
      this.hideSiblingNodes = hideSiblingNodes;
      this.handleContainerOverflow = handleContainerOverflow; // this.modals[modalIdx] = modal

      this.modals = []; // this.data[containerIdx] = {
      //   modals: [],
      //   container,
      //   overflowing,
      //   prevPaddings,
      // }

      this.data = [];
    }

    createClass(ModalManager, [{
      key: "add",
      value: function add(modal, container) {
        var modalIdx = this.modals.indexOf(modal);

        if (modalIdx !== -1) {
          return modalIdx;
        }

        modalIdx = this.modals.length;
        this.modals.push(modal); // If the modal we are adding is already in the DOM.

        if (modal.modalRef) {
          ariaHidden(modal.modalRef, false);
        }

        if (this.hideSiblingNodes) {
          ariaHiddenSiblings(container, modal.mountNode, modal.modalRef, true);
        }

        var containerIdx = findIndexOf(this.data, function (item) {
          return item.container === container;
        });

        if (containerIdx !== -1) {
          this.data[containerIdx].modals.push(modal);
          return modalIdx;
        }

        var data = {
          modals: [modal],
          container: container,
          overflowing: isOverflowing(container),
          prevPaddings: []
        };
        this.data.push(data);
        return modalIdx;
      }
    }, {
      key: "mount",
      value: function mount(modal) {
        var containerIdx = findIndexOf(this.data, function (item) {
          return item.modals.indexOf(modal) !== -1;
        });
        var data = this.data[containerIdx];

        if (!data.style && this.handleContainerOverflow) {
          setContainerStyle(data);
        }
      }
    }, {
      key: "remove",
      value: function remove(modal) {
        var modalIdx = this.modals.indexOf(modal);

        if (modalIdx === -1) {
          return modalIdx;
        }

        var containerIdx = findIndexOf(this.data, function (item) {
          return item.modals.indexOf(modal) !== -1;
        });
        var data = this.data[containerIdx];
        data.modals.splice(data.modals.indexOf(modal), 1);
        this.modals.splice(modalIdx, 1); // If that was the last modal in a container, clean up the container.

        if (data.modals.length === 0) {
          if (this.handleContainerOverflow) {
            removeContainerStyle(data);
          } // In case the modal wasn't in the DOM yet.


          if (modal.modalRef) {
            ariaHidden(modal.modalRef, true);
          }

          if (this.hideSiblingNodes) {
            ariaHiddenSiblings(data.container, modal.mountNode, modal.modalRef, false);
          }

          this.data.splice(containerIdx, 1);
        } else if (this.hideSiblingNodes) {
          // Otherwise make sure the next top modal is visible to a screen reader.
          var nextTop = data.modals[data.modals.length - 1]; // as soon as a modal is adding its modalRef is undefined. it can't set
          // aria-hidden because the dom element doesn't exist either
          // when modal was unmounted before modalRef gets null

          if (nextTop.modalRef) {
            ariaHidden(nextTop.modalRef, false);
          }
        }

        return modalIdx;
      }
    }, {
      key: "isTopModal",
      value: function isTopModal(modal) {
        return !!this.modals.length && this.modals[this.modals.length - 1] === modal;
      }
    }]);

    return ModalManager;
  }();

  function getContainer$1(container, defaultContainer) {
    container = typeof container === 'function' ? container() : container;
    return ReactDOM.findDOMNode(container) || defaultContainer;
  }

  function getHasTransition(props) {
    return props.children ? props.children.props.hasOwnProperty('in') : false;
  }

  var styles$q = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'fixed',
        zIndex: theme.zIndex.modal,
        right: 0,
        bottom: 0,
        top: 0,
        left: 0
      },

      /* Styles applied to the root element if the `Modal` has exited. */
      hidden: {
        visibility: 'hidden'
      }
    };
  };
  /* istanbul ignore if */

  if (!React.createContext) {
    throw new Error('Material-UI: react@16.3.0 or greater is required.');
  }
  /**
   * Modal is a lower-level construct that is leveraged by the following components:
   *
   * - [Dialog](/api/dialog/)
   * - [Drawer](/api/drawer/)
   * - [Menu](/api/menu/)
   * - [Popover](/api/popover/)
   *
   * If you are creating a modal dialog, you probably want to use the [Dialog](/api/dialog/) component
   * rather than directly using Modal.
   *
   * This component shares many concepts with [react-overlays](https://react-bootstrap.github.io/react-overlays/#modals).
   */


  var Modal =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Modal, _React$Component);

    function Modal(props) {
      var _this;

      classCallCheck(this, Modal);

      _this = possibleConstructorReturn(this, getPrototypeOf(Modal).call(this));
      _this.mounted = false;

      _this.handleOpen = function () {
        var doc = ownerDocument(_this.mountNode);
        var container = getContainer$1(_this.props.container, doc.body);

        _this.props.manager.add(assertThisInitialized(assertThisInitialized(_this)), container);

        doc.addEventListener('focus', _this.enforceFocus, true);

        if (_this.dialogRef) {
          _this.handleOpened();
        }
      };

      _this.handleRendered = function () {
        if (_this.props.onRendered) {
          _this.props.onRendered();
        }

        if (_this.props.open) {
          _this.handleOpened();
        } else {
          ariaHidden(_this.modalRef, true);
        }
      };

      _this.handleOpened = function () {
        _this.autoFocus();

        _this.props.manager.mount(assertThisInitialized(assertThisInitialized(_this))); // Fix a bug on Chrome where the scroll isn't initially 0.


        _this.modalRef.scrollTop = 0;
      };

      _this.handleClose = function (reason) {
        var hasTransition = getHasTransition(_this.props);
        /* If the component does not have a transition or is unmounting remove the Modal
        otherwise let the transition handle removing the style, this prevents elements
        moving around when the Modal is closed. */

        if (!(hasTransition && _this.props.closeAfterTransition) || reason === 'unmount') {
          _this.props.manager.remove(assertThisInitialized(assertThisInitialized(_this)));
        }

        var doc = ownerDocument(_this.mountNode);
        doc.removeEventListener('focus', _this.enforceFocus, true);

        _this.restoreLastFocus();
      };

      _this.handleExited = function () {
        if (_this.props.closeAfterTransition) {
          _this.props.manager.remove(assertThisInitialized(assertThisInitialized(_this)));
        }

        _this.setState({
          exited: true
        });
      };

      _this.handleBackdropClick = function (event) {
        if (event.target !== event.currentTarget) {
          return;
        }

        if (_this.props.onBackdropClick) {
          _this.props.onBackdropClick(event);
        }

        if (!_this.props.disableBackdropClick && _this.props.onClose) {
          _this.props.onClose(event, 'backdropClick');
        }
      };

      _this.handleKeyDown = function (event) {
        // event.defaultPrevented:
        //
        // Ignore events that have been `event.preventDefault()` marked.
        // preventDefault() is meant to stop default behaviours like
        // clicking a checkbox to check it, hitting a button to submit a form,
        // and hitting left arrow to move the cursor in a text input etc.
        // Only special HTML elements have these default bahaviours.
        //
        // To remove in v4.
        if (event.key !== 'Escape' || !_this.isTopModal() || event.defaultPrevented) {
          return;
        } // Swallow the event, in case someone is listening for the escape key on the body.


        event.stopPropagation();

        if (_this.props.onEscapeKeyDown) {
          _this.props.onEscapeKeyDown(event);
        }

        if (!_this.props.disableEscapeKeyDown && _this.props.onClose) {
          _this.props.onClose(event, 'escapeKeyDown');
        }
      };

      _this.enforceFocus = function () {
        // The Modal might not already be mounted.
        if (!_this.isTopModal() || _this.props.disableEnforceFocus || !_this.mounted || !_this.dialogRef) {
          return;
        }

        var currentActiveElement = ownerDocument(_this.mountNode).activeElement;

        if (!_this.dialogRef.contains(currentActiveElement)) {
          _this.dialogRef.focus();
        }
      };

      _this.handlePortalRef = function (ref) {
        _this.mountNode = ref ? ref.getMountNode() : ref;
      };

      _this.handleModalRef = function (ref) {
        _this.modalRef = ref;
      };

      _this.onRootRef = function (ref) {
        _this.dialogRef = ref;
      };

      _this.state = {
        exited: !props.open
      };
      return _this;
    }

    createClass(Modal, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.mounted = true;

        if (this.props.open) {
          this.handleOpen();
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (prevProps.open && !this.props.open) {
          this.handleClose();
        } else if (!prevProps.open && this.props.open) {
          this.lastFocus = ownerDocument(this.mountNode).activeElement;
          this.handleOpen();
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.mounted = false;

        if (this.props.open || getHasTransition(this.props) && !this.state.exited) {
          this.handleClose('unmount');
        }
      }
    }, {
      key: "autoFocus",
      value: function autoFocus() {
        // We might render an empty child.
        if (this.props.disableAutoFocus || !this.dialogRef) {
          return;
        }

        var currentActiveElement = ownerDocument(this.mountNode).activeElement;

        if (!this.dialogRef.contains(currentActiveElement)) {
          if (!this.dialogRef.hasAttribute('tabIndex')) {
            warning_1(false, ['Material-UI: the modal content node does not accept focus.', 'For the benefit of assistive technologies, ' + 'the tabIndex of the node is being set to "-1".'].join('\n'));
            this.dialogRef.setAttribute('tabIndex', -1);
          }

          this.lastFocus = currentActiveElement;
          this.dialogRef.focus();
        }
      }
    }, {
      key: "restoreLastFocus",
      value: function restoreLastFocus() {
        if (this.props.disableRestoreFocus || !this.lastFocus) {
          return;
        } // Not all elements in IE 11 have a focus method.
        // Because IE 11 market share is low, we accept the restore focus being broken
        // and we silent the issue.


        if (this.lastFocus.focus) {
          this.lastFocus.focus();
        }

        this.lastFocus = null;
      }
    }, {
      key: "isTopModal",
      value: function isTopModal() {
        return this.props.manager.isTopModal(this);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            BackdropComponent = _this$props.BackdropComponent,
            BackdropProps = _this$props.BackdropProps,
            children = _this$props.children,
            classes = _this$props.classes,
            className = _this$props.className,
            closeAfterTransition = _this$props.closeAfterTransition,
            container = _this$props.container,
            disableAutoFocus = _this$props.disableAutoFocus,
            disableBackdropClick = _this$props.disableBackdropClick,
            disableEnforceFocus = _this$props.disableEnforceFocus,
            disableEscapeKeyDown = _this$props.disableEscapeKeyDown,
            disablePortal = _this$props.disablePortal,
            disableRestoreFocus = _this$props.disableRestoreFocus,
            hideBackdrop = _this$props.hideBackdrop,
            keepMounted = _this$props.keepMounted,
            manager = _this$props.manager,
            onBackdropClick = _this$props.onBackdropClick,
            onClose = _this$props.onClose,
            onEscapeKeyDown = _this$props.onEscapeKeyDown,
            onRendered = _this$props.onRendered,
            open = _this$props.open,
            other = objectWithoutProperties(_this$props, ["BackdropComponent", "BackdropProps", "children", "classes", "className", "closeAfterTransition", "container", "disableAutoFocus", "disableBackdropClick", "disableEnforceFocus", "disableEscapeKeyDown", "disablePortal", "disableRestoreFocus", "hideBackdrop", "keepMounted", "manager", "onBackdropClick", "onClose", "onEscapeKeyDown", "onRendered", "open"]);

        var exited = this.state.exited;
        var hasTransition = getHasTransition(this.props);

        if (!keepMounted && !open && (!hasTransition || exited)) {
          return null;
        }

        var childProps = {}; // It's a Transition like component

        if (hasTransition) {
          childProps.onExited = createChainedFunction(this.handleExited, children.props.onExited);
        }

        if (children.props.role === undefined) {
          childProps.role = children.props.role || 'document';
        }

        if (children.props.tabIndex === undefined) {
          childProps.tabIndex = children.props.tabIndex || '-1';
        }

        return React.createElement(Portal, {
          ref: this.handlePortalRef,
          container: container,
          disablePortal: disablePortal,
          onRendered: this.handleRendered
        }, React.createElement("div", _extends_1({
          ref: this.handleModalRef,
          onKeyDown: this.handleKeyDown,
          role: "presentation",
          className: classnames(classes.root, className, defineProperty({}, classes.hidden, exited))
        }, other), hideBackdrop ? null : React.createElement(BackdropComponent, _extends_1({
          open: open,
          onClick: this.handleBackdropClick
        }, BackdropProps)), React.createElement(RootRef, {
          rootRef: this.onRootRef
        }, React.cloneElement(children, childProps))));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(nextProps) {
        if (nextProps.open) {
          return {
            exited: false
          };
        }

        if (!getHasTransition(nextProps)) {
          // Otherwise let handleExited take care of marking exited.
          return {
            exited: true
          };
        }

        return null;
      }
    }]);

    return Modal;
  }(React.Component);

  Modal.propTypes = {
    /**
     * A backdrop component. This property enables custom backdrop rendering.
     */
    BackdropComponent: componentPropType,

    /**
     * Properties applied to the [`Backdrop`](/api/backdrop/) element.
     */
    BackdropProps: propTypes.object,

    /**
     * A single child content element.
     */
    children: propTypes.element,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * When set to true the Modal waits until a nested Transition is completed before closing.
     */
    closeAfterTransition: propTypes.bool,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will have the portal children appended to it.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * If `true`, the modal will not automatically shift focus to itself when it opens, and
     * replace it to the last focused element when it closes.
     * This also works correctly with any modal children that have the `disableAutoFocus` prop.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     */
    disableAutoFocus: propTypes.bool,

    /**
     * If `true`, clicking the backdrop will not fire any callback.
     */
    disableBackdropClick: propTypes.bool,

    /**
     * If `true`, the modal will not prevent focus from leaving the modal while open.
     *
     * Generally this should never be set to `true` as it makes the modal less
     * accessible to assistive technologies, like screen readers.
     */
    disableEnforceFocus: propTypes.bool,

    /**
     * If `true`, hitting escape will not fire any callback.
     */
    disableEscapeKeyDown: propTypes.bool,

    /**
     * Disable the portal behavior.
     * The children stay within it's parent DOM hierarchy.
     */
    disablePortal: propTypes.bool,

    /**
     * If `true`, the modal will not restore focus to previously focused element once
     * modal is hidden.
     */
    disableRestoreFocus: propTypes.bool,

    /**
     * If `true`, the backdrop is not rendered.
     */
    hideBackdrop: propTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This property can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Modal.
     */
    keepMounted: propTypes.bool,

    /**
     * @ignore
     *
     * A modal manager used to track and manage the state of open
     * Modals. This enables customizing how modals interact within a container.
     */
    manager: propTypes.object,

    /**
     * Callback fired when the backdrop is clicked.
     */
    onBackdropClick: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * The `reason` parameter can optionally be used to control the response to `onClose`.
     *
     * @param {object} event The event source of the callback
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`
     */
    onClose: propTypes.func,

    /**
     * Callback fired when the escape key is pressed,
     * `disableEscapeKeyDown` is false and the modal is in focus.
     */
    onEscapeKeyDown: propTypes.func,

    /**
     * Callback fired once the children has been mounted into the `container`.
     * It signals that the `open={true}` property took effect.
     */
    onRendered: propTypes.func,

    /**
     * If `true`, the modal is open.
     */
    open: propTypes.bool.isRequired
  };
  Modal.defaultProps = {
    BackdropComponent: Backdrop$1,
    closeAfterTransition: false,
    disableAutoFocus: false,
    disableBackdropClick: false,
    disableEnforceFocus: false,
    disableEscapeKeyDown: false,
    disablePortal: false,
    disableRestoreFocus: false,
    hideBackdrop: false,
    keepMounted: false,
    // Modals don't open on the server so this won't conflict with concurrent requests.
    manager: new ModalManager()
  };
  var Modal$1 = withStyles(styles$q, {
    flip: false,
    name: 'MuiModal'
  })(Modal);

  var styles$r = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {},

      /* Styles applied to the root element if `scroll="paper"`. */
      scrollPaper: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center'
      },

      /* Styles applied to the root element if `scroll="body"`. */
      scrollBody: {
        overflowY: 'auto',
        overflowX: 'hidden'
      },

      /* Styles applied to the container element. */
      container: {
        height: '100%',
        // We disable the focus ring for mouse, touch and keyboard users.
        outline: 'none'
      },

      /* Styles applied to the `Paper` component. */
      paper: {
        display: 'flex',
        flexDirection: 'column',
        margin: 48,
        position: 'relative',
        overflowY: 'auto' // Fix IE 11 issue, to remove at some point.

      },

      /* Styles applied to the `Paper` component if `scroll="paper"`. */
      paperScrollPaper: {
        flex: '0 1 auto',
        maxHeight: 'calc(100% - 96px)'
      },

      /* Styles applied to the `Paper` component if `scroll="body"`. */
      paperScrollBody: {
        margin: '48px auto'
      },

      /* Styles applied to the `Paper` component if `maxWidth="xs"`. */
      paperWidthXs: {
        maxWidth: Math.max(theme.breakpoints.values.xs, 360),
        '&$paperScrollBody': defineProperty({}, theme.breakpoints.down(Math.max(theme.breakpoints.values.xs, 360) + 48 * 2), {
          margin: 48
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="sm"`. */
      paperWidthSm: {
        maxWidth: theme.breakpoints.values.sm,
        '&$paperScrollBody': defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.sm + 48 * 2), {
          margin: 48
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="md"`. */
      paperWidthMd: {
        maxWidth: theme.breakpoints.values.md,
        '&$paperScrollBody': defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.md + 48 * 2), {
          margin: 48
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="lg"`. */
      paperWidthLg: {
        maxWidth: theme.breakpoints.values.lg,
        '&$paperScrollBody': defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.lg + 48 * 2), {
          margin: 48
        })
      },

      /* Styles applied to the `Paper` component if `maxWidth="xl"`. */
      paperWidthXl: {
        maxWidth: theme.breakpoints.values.xl,
        '&$paperScrollBody': defineProperty({}, theme.breakpoints.down(theme.breakpoints.values.xl + 48 * 2), {
          margin: 48
        })
      },

      /* Styles applied to the `Paper` component if `fullWidth={true}`. */
      paperFullWidth: {
        width: '100%'
      },

      /* Styles applied to the `Paper` component if `fullScreen={true}`. */
      paperFullScreen: {
        margin: 0,
        width: '100%',
        maxWidth: '100%',
        height: '100%',
        maxHeight: 'none',
        borderRadius: 0,
        '&$paperScrollBody': {
          margin: 0
        }
      }
    };
  };
  /**
   * Dialogs are overlaid modal paper based components with a backdrop.
   */

  var Dialog =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Dialog, _React$Component);

    function Dialog() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Dialog);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Dialog)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.handleMouseDown = function (event) {
        _this.mouseDownTarget = event.target;
      };

      _this.handleBackdropClick = function (event) {
        // Ignore the events not coming from the "backdrop"
        // We don't want to close the dialog when clicking the dialog content.
        if (event.target !== event.currentTarget) {
          return;
        } // Make sure the event starts and ends on the same DOM element.


        if (event.target !== _this.mouseDownTarget) {
          return;
        }

        _this.mouseDownTarget = null;

        if (_this.props.onBackdropClick) {
          _this.props.onBackdropClick(event);
        }

        if (!_this.props.disableBackdropClick && _this.props.onClose) {
          _this.props.onClose(event, 'backdropClick');
        }
      };

      return _this;
    }

    createClass(Dialog, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props = this.props,
            BackdropProps = _this$props.BackdropProps,
            children = _this$props.children,
            classes = _this$props.classes,
            className = _this$props.className,
            disableBackdropClick = _this$props.disableBackdropClick,
            disableEscapeKeyDown = _this$props.disableEscapeKeyDown,
            fullScreen = _this$props.fullScreen,
            fullWidth = _this$props.fullWidth,
            maxWidth = _this$props.maxWidth,
            onBackdropClick = _this$props.onBackdropClick,
            onClose = _this$props.onClose,
            onEnter = _this$props.onEnter,
            onEntered = _this$props.onEntered,
            onEntering = _this$props.onEntering,
            onEscapeKeyDown = _this$props.onEscapeKeyDown,
            onExit = _this$props.onExit,
            onExited = _this$props.onExited,
            onExiting = _this$props.onExiting,
            open = _this$props.open,
            PaperComponent = _this$props.PaperComponent,
            _this$props$PaperProp = _this$props.PaperProps,
            PaperProps = _this$props$PaperProp === void 0 ? {} : _this$props$PaperProp,
            scroll = _this$props.scroll,
            TransitionComponent = _this$props.TransitionComponent,
            transitionDuration = _this$props.transitionDuration,
            TransitionProps = _this$props.TransitionProps,
            other = objectWithoutProperties(_this$props, ["BackdropProps", "children", "classes", "className", "disableBackdropClick", "disableEscapeKeyDown", "fullScreen", "fullWidth", "maxWidth", "onBackdropClick", "onClose", "onEnter", "onEntered", "onEntering", "onEscapeKeyDown", "onExit", "onExited", "onExiting", "open", "PaperComponent", "PaperProps", "scroll", "TransitionComponent", "transitionDuration", "TransitionProps"]);

        return React.createElement(Modal$1, _extends_1({
          className: classnames(classes.root, className),
          BackdropProps: _extends_1({
            transitionDuration: transitionDuration
          }, BackdropProps),
          closeAfterTransition: true,
          disableBackdropClick: disableBackdropClick,
          disableEscapeKeyDown: disableEscapeKeyDown,
          onBackdropClick: onBackdropClick,
          onEscapeKeyDown: onEscapeKeyDown,
          onClose: onClose,
          open: open,
          role: "dialog"
        }, other), React.createElement(TransitionComponent, _extends_1({
          appear: true,
          in: open,
          timeout: transitionDuration,
          onEnter: onEnter,
          onEntering: onEntering,
          onEntered: onEntered,
          onExit: onExit,
          onExiting: onExiting,
          onExited: onExited
        }, TransitionProps), React.createElement("div", {
          className: classnames(classes.container, classes["scroll".concat(capitalize(scroll))]),
          onClick: this.handleBackdropClick,
          onMouseDown: this.handleMouseDown,
          role: "document"
        }, React.createElement(PaperComponent, _extends_1({
          elevation: 24
        }, PaperProps, {
          className: classnames(classes.paper, classes["paperScroll".concat(capitalize(scroll))], (_classNames = {}, defineProperty(_classNames, classes["paperWidth".concat(maxWidth ? capitalize(maxWidth) : '')], maxWidth), defineProperty(_classNames, classes.paperFullScreen, fullScreen), defineProperty(_classNames, classes.paperFullWidth, fullWidth), _classNames), PaperProps.className)
        }), children))));
      }
    }]);

    return Dialog;
  }(React.Component);

  Dialog.propTypes = {
    /**
     * @ignore
     */
    BackdropProps: propTypes.object,

    /**
     * Dialog children, usually the included sub-components.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, clicking the backdrop will not fire the `onClose` callback.
     */
    disableBackdropClick: propTypes.bool,

    /**
     * If `true`, hitting escape will not fire the `onClose` callback.
     */
    disableEscapeKeyDown: propTypes.bool,

    /**
     * If `true`, the dialog will be full-screen
     */
    fullScreen: propTypes.bool,

    /**
     * If `true`, the dialog stretches to `maxWidth`.
     */
    fullWidth: propTypes.bool,

    /**
     * Determine the max width of the dialog.
     * The dialog width grows with the size of the screen, this property is useful
     * on the desktop where you might need some coherent different width size across your
     * application. Set to `false` to disable `maxWidth`.
     */
    maxWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false]),

    /**
     * Callback fired when the backdrop is clicked.
     */
    onBackdropClick: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the dialog enters.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the dialog has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the dialog is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired when the escape key is pressed,
     * `disableKeyboard` is false and the modal is in focus.
     */
    onEscapeKeyDown: propTypes.func,

    /**
     * Callback fired before the dialog exits.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the dialog has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the dialog is exiting.
     */
    onExiting: propTypes.func,

    /**
     * If `true`, the Dialog is open.
     */
    open: propTypes.bool.isRequired,

    /**
     * The component used to render the body of the dialog.
     */
    PaperComponent: componentPropType,

    /**
     * Properties applied to the [`Paper`](/api/paper/) element.
     */
    PaperProps: propTypes.object,

    /**
     * Determine the container for scrolling the dialog.
     */
    scroll: propTypes.oneOf(['body', 'paper']),

    /**
     * The component used for the transition.
     */
    TransitionComponent: componentPropType,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * Properties applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  };
  Dialog.defaultProps = {
    disableBackdropClick: false,
    disableEscapeKeyDown: false,
    fullScreen: false,
    fullWidth: false,
    maxWidth: 'sm',
    PaperComponent: Paper$1,
    scroll: 'paper',
    TransitionComponent: Fade$1,
    transitionDuration: {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    }
  };
  var Dialog$1 = withStyles(styles$r, {
    name: 'MuiDialog'
  })(Dialog);

  var styles$s = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'flex-end',
      flex: '0 0 auto',
      margin: '8px 4px'
    },

    /* Styles applied to the children. */
    action: {
      margin: '0 4px'
    }
  };

  function DialogActions(props) {
    var disableActionSpacing = props.disableActionSpacing,
        children = props.children,
        classes = props.classes,
        className = props.className,
        other = objectWithoutProperties(props, ["disableActionSpacing", "children", "classes", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, className)
    }, other), disableActionSpacing ? children : cloneChildrenWithClassName(children, classes.action));
  }

  DialogActions.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the dialog actions do not have additional margin.
     */
    disableActionSpacing: propTypes.bool
  };
  DialogActions.defaultProps = {
    disableActionSpacing: false
  };
  var DialogActions$1 = withStyles(styles$s, {
    name: 'MuiDialogActions'
  })(DialogActions);

  var styles$t = {
    /* Styles applied to the root element. */
    root: {
      flex: '1 1 auto',
      overflowY: 'auto',
      WebkitOverflowScrolling: 'touch',
      // Add iOS momentum scrolling.
      padding: '0 24px 24px',
      '&:first-child': {
        paddingTop: 24
      }
    }
  };

  function DialogContent(props) {
    var classes = props.classes,
        children = props.children,
        className = props.className,
        other = objectWithoutProperties(props, ["classes", "children", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, className)
    }, other), children);
  }

  DialogContent.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  var DialogContent$1 = withStyles(styles$t, {
    name: 'MuiDialogContent'
  })(DialogContent);

  var styles$u = {
    /* Styles applied to the root element. */
    root: {
      // Should use variant="body1" in v4
      lineHeight: 1.5
    }
  };

  function DialogContentText(props) {
    return React.createElement(Typography$1, _extends_1({
      component: "p",
      internalDeprecatedVariant: true,
      variant: "subheading",
      color: "textSecondary"
    }, props));
  }

  DialogContentText.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired
  };
  var DialogContentText$1 = withStyles(styles$u, {
    name: 'MuiDialogContentText'
  })(DialogContentText);

  var styles$v = {
    /* Styles applied to the root element. */
    root: {
      margin: 0,
      padding: '24px 24px 20px',
      flex: '0 0 auto'
    }
  };

  function DialogTitle(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        disableTypography = props.disableTypography,
        other = objectWithoutProperties(props, ["children", "classes", "className", "disableTypography"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, className)
    }, other), disableTypography ? children : React.createElement(Typography$1, {
      variant: "title",
      internalDeprecatedVariant: true
    }, children));
  }

  DialogTitle.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the children won't be wrapped by a typography component.
     * For instance, this can be useful to render an h4 instead of the default h2.
     */
    disableTypography: propTypes.bool
  };
  DialogTitle.defaultProps = {
    disableTypography: false
  };
  var DialogTitle$1 = withStyles(styles$v, {
    name: 'MuiDialogTitle'
  })(DialogTitle);

  var styles$w = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        height: 1,
        margin: 0,
        // Reset browser default style.
        border: 'none',
        flexShrink: 0,
        backgroundColor: theme.palette.divider
      },

      /* Styles applied to the root element if `absolute={true}`. */
      absolute: {
        position: 'absolute',
        bottom: 0,
        left: 0,
        width: '100%'
      },

      /* Styles applied to the root element if `variant="inset"`. */
      inset: {
        marginLeft: 72
      },

      /* Styles applied to the root element if `light={true}`. */
      light: {
        backgroundColor: fade(theme.palette.divider, 0.08)
      },

      /* Styles applied to the root element if `variant="middle"`. */
      middle: {
        marginLeft: theme.spacing.unit * 2,
        marginRight: theme.spacing.unit * 2
      }
    };
  };

  function Divider(props) {
    var _classNames;

    var absolute = props.absolute,
        classes = props.classes,
        className = props.className,
        Component = props.component,
        inset = props.inset,
        light = props.light,
        variant = props.variant,
        other = objectWithoutProperties(props, ["absolute", "classes", "className", "component", "inset", "light", "variant"]);

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.inset, inset || variant === 'inset'), defineProperty(_classNames, classes.middle, variant === 'middle'), defineProperty(_classNames, classes.absolute, absolute), defineProperty(_classNames, classes.light, light), _classNames), className)
    }, other));
  }

  Divider.propTypes = {
    /**
     * Absolutely position the element.
     */
    absolute: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the divider will be indented.
     * __WARNING__: `inset` is deprecated.
     * Instead use `variant="inset"`.
     */
    inset: chainPropTypes(propTypes.bool, function (props) {
      /* istanbul ignore if */
      if (props.inset) {
        return new Error('Material-UI: you are using the deprecated `inset` property ' + 'that will be removed in the next major release. The property `variant="inset"` ' + 'is equivalent and should be used instead.');
      }

      return null;
    }),

    /**
     * If `true`, the divider will have a lighter color.
     */
    light: propTypes.bool,

    /**
     *  The variant to use.
     */
    variant: propTypes.oneOf(['fullWidth', 'inset', 'middle'])
  };
  Divider.defaultProps = {
    absolute: false,
    component: 'hr',
    light: false,
    variant: 'fullWidth'
  };
  var Divider$1 = withStyles(styles$w, {
    name: 'MuiDivider'
  })(Divider);

  /**
   * Returns a function, that, as long as it continues to be invoked, will not
   * be triggered. The function will be called after it stops being called for
   * N milliseconds. If `immediate` is passed, trigger the function on the
   * leading edge, instead of the trailing. The function also has a property 'clear' 
   * that is a function which will clear the timer to prevent previously scheduled executions. 
   *
   * @source underscore.js
   * @see http://unscriptable.com/2009/03/20/debouncing-javascript-methods/
   * @param {Function} function to wrap
   * @param {Number} timeout in ms (`100`)
   * @param {Boolean} whether to execute at the beginning (`false`)
   * @api public
   */
  function debounce(func, wait, immediate){
    var timeout, args, context, timestamp, result;
    if (null == wait) wait = 100;

    function later() {
      var last = Date.now() - timestamp;

      if (last < wait && last >= 0) {
        timeout = setTimeout(later, wait - last);
      } else {
        timeout = null;
        if (!immediate) {
          result = func.apply(context, args);
          context = args = null;
        }
      }
    }
    var debounced = function(){
      context = this;
      args = arguments;
      timestamp = Date.now();
      var callNow = immediate && !timeout;
      if (!timeout) timeout = setTimeout(later, wait);
      if (callNow) {
        result = func.apply(context, args);
        context = args = null;
      }

      return result;
    };

    debounced.clear = function() {
      if (timeout) {
        clearTimeout(timeout);
        timeout = null;
      }
    };
    
    debounced.flush = function() {
      if (timeout) {
        result = func.apply(context, args);
        context = args = null;
        
        clearTimeout(timeout);
        timeout = null;
      }
    };

    return debounced;
  }
  // Adds compatibility for ES modules
  debounce.debounce = debounce;

  var debounce_1 = debounce;

  var GUTTER = 24; // Translate the node so he can't be seen on the screen.
  // Later, we gonna translate back the node to his original location
  // with `translate3d(0, 0, 0)`.`

  function getTranslateValue(props, node) {
    var direction = props.direction;
    var rect = node.getBoundingClientRect();
    var transform;

    if (node.fakeTransform) {
      transform = node.fakeTransform;
    } else {
      var computedStyle = ownerWindow(node).getComputedStyle(node);
      transform = computedStyle.getPropertyValue('-webkit-transform') || computedStyle.getPropertyValue('transform');
    }

    var offsetX = 0;
    var offsetY = 0;

    if (transform && transform !== 'none' && typeof transform === 'string') {
      var transformValues = transform.split('(')[1].split(')')[0].split(',');
      offsetX = parseInt(transformValues[4], 10);
      offsetY = parseInt(transformValues[5], 10);
    }

    if (direction === 'left') {
      return "translateX(100vw) translateX(-".concat(rect.left - offsetX, "px)");
    }

    if (direction === 'right') {
      return "translateX(-".concat(rect.left + rect.width + GUTTER - offsetX, "px)");
    }

    if (direction === 'up') {
      return "translateY(100vh) translateY(-".concat(rect.top - offsetY, "px)");
    } // direction === 'down'


    return "translateY(-".concat(rect.top + rect.height + GUTTER - offsetY, "px)");
  }

  function setTranslateValue(props, node) {
    var transform = getTranslateValue(props, node);

    if (transform) {
      node.style.webkitTransform = transform;
      node.style.transform = transform;
    }
  }
  /**
   * The Slide transition is used by the [Snackbar](/demos/snackbars/) component.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Slide =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Slide, _React$Component);

    function Slide() {
      var _this;

      classCallCheck(this, Slide);

      _this = possibleConstructorReturn(this, getPrototypeOf(Slide).call(this));
      _this.mounted = false;

      _this.handleEnter = function (node) {
        setTranslateValue(_this.props, node);
        reflow(node);

        if (_this.props.onEnter) {
          _this.props.onEnter(node);
        }
      };

      _this.handleEntering = function (node) {
        var theme = _this.props.theme;
        var transitionProps = getTransitionProps(_this.props, {
          mode: 'enter'
        });
        node.style.webkitTransition = theme.transitions.create('-webkit-transform', _extends_1({}, transitionProps, {
          easing: theme.transitions.easing.easeOut
        }));
        node.style.transition = theme.transitions.create('transform', _extends_1({}, transitionProps, {
          easing: theme.transitions.easing.easeOut
        }));
        node.style.webkitTransform = 'translate(0, 0)';
        node.style.transform = 'translate(0, 0)';

        if (_this.props.onEntering) {
          _this.props.onEntering(node);
        }
      };

      _this.handleExit = function (node) {
        var theme = _this.props.theme;
        var transitionProps = getTransitionProps(_this.props, {
          mode: 'exit'
        });
        node.style.webkitTransition = theme.transitions.create('-webkit-transform', _extends_1({}, transitionProps, {
          easing: theme.transitions.easing.sharp
        }));
        node.style.transition = theme.transitions.create('transform', _extends_1({}, transitionProps, {
          easing: theme.transitions.easing.sharp
        }));
        setTranslateValue(_this.props, node);

        if (_this.props.onExit) {
          _this.props.onExit(node);
        }
      };

      _this.handleExited = function (node) {
        // No need for transitions when the component is hidden
        node.style.webkitTransition = '';
        node.style.transition = '';

        if (_this.props.onExited) {
          _this.props.onExited(node);
        }
      };

      if (typeof window !== 'undefined') {
        _this.handleResize = debounce_1(function () {
          // Skip configuration where the position is screen size invariant.
          if (_this.props.in || _this.props.direction === 'down' || _this.props.direction === 'right') {
            return;
          }

          if (_this.transitionRef) {
            setTranslateValue(_this.props, _this.transitionRef);
          }
        }, 166); // Corresponds to 10 frames at 60 Hz.
      }

      return _this;
    }

    createClass(Slide, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.mounted = true; // state.mounted handle SSR, once the component is mounted, we need
        // to properly hide it.

        if (!this.props.in) {
          // We need to set initial translate values of transition element
          // otherwise component will be shown when in=false.
          this.updatePosition();
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (prevProps.direction !== this.props.direction && !this.props.in) {
          // We need to update the position of the drawer when the direction change and
          // when it's hidden.
          this.updatePosition();
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.handleResize.clear();
      }
    }, {
      key: "updatePosition",
      value: function updatePosition() {
        if (this.transitionRef) {
          this.transitionRef.style.visibility = 'inherit';
          setTranslateValue(this.props, this.transitionRef);
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            children = _this$props.children,
            direction = _this$props.direction,
            onEnter = _this$props.onEnter,
            onEntering = _this$props.onEntering,
            onExit = _this$props.onExit,
            onExited = _this$props.onExited,
            styleProp = _this$props.style,
            theme = _this$props.theme,
            other = objectWithoutProperties(_this$props, ["children", "direction", "onEnter", "onEntering", "onExit", "onExited", "style", "theme"]);

        var style = {}; // We use this state to handle the server-side rendering.
        // We don't know the width of the children ahead of time.
        // We need to render it.

        if (!this.props.in && !this.mounted) {
          style.visibility = 'hidden';
        }

        style = _extends_1({}, style, styleProp, React.isValidElement(children) ? children.props.style : {});
        return React.createElement(EventListener, {
          target: "window",
          onResize: this.handleResize
        }, React.createElement(Transition, _extends_1({
          onEnter: this.handleEnter,
          onEntering: this.handleEntering,
          onExit: this.handleExit,
          onExited: this.handleExited,
          appear: true,
          style: style,
          ref: function ref(_ref) {
            _this2.transitionRef = ReactDOM.findDOMNode(_ref);
          }
        }, other), children));
      }
    }]);

    return Slide;
  }(React.Component);

  Slide.propTypes = {
    /**
     * A single child content element.
     */
    children: propTypes.oneOfType([propTypes.element, propTypes.func]),

    /**
     * Direction the child node will enter from.
     */
    direction: propTypes.oneOf(['left', 'right', 'up', 'down']),

    /**
     * If `true`, show the component; triggers the enter or exit animation.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onEntering: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    onExited: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })])
  };
  Slide.defaultProps = {
    direction: 'down',
    timeout: {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    }
  };
  var Slide$1 = withTheme()(Slide);

  var oppositeDirection = {
    left: 'right',
    right: 'left',
    top: 'down',
    bottom: 'up'
  };
  function isHorizontal(props) {
    return ['left', 'right'].indexOf(props.anchor) !== -1;
  }
  function getAnchor(props) {
    return props.theme.direction === 'rtl' && isHorizontal(props) ? oppositeDirection[props.anchor] : props.anchor;
  }
  var styles$x = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {},

      /* Styles applied to the root element if `variant="permanent or persistent"`. */
      docked: {
        flex: '0 0 auto'
      },

      /* Styles applied to the `Paper` component. */
      paper: {
        overflowY: 'auto',
        display: 'flex',
        flexDirection: 'column',
        height: '100%',
        flex: '1 0 auto',
        zIndex: theme.zIndex.drawer,
        WebkitOverflowScrolling: 'touch',
        // Add iOS momentum scrolling.
        // temporary style
        position: 'fixed',
        top: 0,
        // We disable the focus ring for mouse, touch and keyboard users.
        // At some point, it would be better to keep it for keyboard users.
        // :focus-ring CSS pseudo-class will help.
        outline: 'none'
      },

      /* Styles applied to the `Paper` component if `anchor="left"`. */
      paperAnchorLeft: {
        left: 0,
        right: 'auto'
      },

      /* Styles applied to the `Paper` component if `anchor="right"`. */
      paperAnchorRight: {
        left: 'auto',
        right: 0
      },

      /* Styles applied to the `Paper` component if `anchor="top"`. */
      paperAnchorTop: {
        top: 0,
        left: 0,
        bottom: 'auto',
        right: 0,
        height: 'auto',
        maxHeight: '100%'
      },

      /* Styles applied to the `Paper` component if `anchor="bottom"`. */
      paperAnchorBottom: {
        top: 'auto',
        left: 0,
        bottom: 0,
        right: 0,
        height: 'auto',
        maxHeight: '100%'
      },

      /* Styles applied to the `Paper` component if `anchor="left"` & `variant` is not "temporary". */
      paperAnchorDockedLeft: {
        borderRight: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Paper` component if `anchor="top"` & `variant` is not "temporary". */
      paperAnchorDockedTop: {
        borderBottom: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Paper` component if `anchor="right"` & `variant` is not "temporary". */
      paperAnchorDockedRight: {
        borderLeft: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Paper` component if `anchor="bottom"` & `variant` is not "temporary". */
      paperAnchorDockedBottom: {
        borderTop: "1px solid ".concat(theme.palette.divider)
      },

      /* Styles applied to the `Modal` component. */
      modal: {}
    };
  };
  /**
   * The properties of the [Modal](/api/modal/) component are available
   * when `variant="temporary"` is set.
   */

  var Drawer =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Drawer, _React$Component);

    function Drawer() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Drawer);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Drawer)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.mounted = false;
      return _this;
    }

    createClass(Drawer, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.mounted = true;
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            anchorProp = _this$props.anchor,
            BackdropProps = _this$props.BackdropProps,
            children = _this$props.children,
            classes = _this$props.classes,
            className = _this$props.className,
            elevation = _this$props.elevation,
            _this$props$ModalProp = _this$props.ModalProps;
        _this$props$ModalProp = _this$props$ModalProp === void 0 ? {} : _this$props$ModalProp;

        var BackdropPropsProp = _this$props$ModalProp.BackdropProps,
            ModalProps = objectWithoutProperties(_this$props$ModalProp, ["BackdropProps"]),
            onClose = _this$props.onClose,
            open = _this$props.open,
            PaperProps = _this$props.PaperProps,
            SlideProps = _this$props.SlideProps,
            theme = _this$props.theme,
            transitionDuration = _this$props.transitionDuration,
            variant = _this$props.variant,
            other = objectWithoutProperties(_this$props, ["anchor", "BackdropProps", "children", "classes", "className", "elevation", "ModalProps", "onClose", "open", "PaperProps", "SlideProps", "theme", "transitionDuration", "variant"]);

        var anchor = getAnchor(this.props);
        var drawer = React.createElement(Paper$1, _extends_1({
          elevation: variant === 'temporary' ? elevation : 0,
          square: true,
          className: classnames(classes.paper, classes["paperAnchor".concat(capitalize(anchor))], defineProperty({}, classes["paperAnchorDocked".concat(capitalize(anchor))], variant !== 'temporary'))
        }, PaperProps), children);

        if (variant === 'permanent') {
          return React.createElement("div", _extends_1({
            className: classnames(classes.root, classes.docked, className)
          }, other), drawer);
        }

        var slidingDrawer = React.createElement(Slide$1, _extends_1({
          in: open,
          direction: oppositeDirection[anchor],
          timeout: transitionDuration,
          appear: this.mounted
        }, SlideProps), drawer);

        if (variant === 'persistent') {
          return React.createElement("div", _extends_1({
            className: classnames(classes.root, classes.docked, className)
          }, other), slidingDrawer);
        } // variant === temporary


        return React.createElement(Modal$1, _extends_1({
          BackdropProps: _extends_1({}, BackdropProps, BackdropPropsProp, {
            transitionDuration: transitionDuration
          }),
          className: classnames(classes.root, classes.modal, className),
          open: open,
          onClose: onClose
        }, other, ModalProps), slidingDrawer);
      }
    }]);

    return Drawer;
  }(React.Component);

  Drawer.propTypes = {
    /**
     * Side from which the drawer will appear.
     */
    anchor: propTypes.oneOf(['left', 'top', 'right', 'bottom']),

    /**
     * @ignore
     */
    BackdropProps: propTypes.object,

    /**
     * The contents of the drawer.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The elevation of the drawer.
     */
    elevation: propTypes.number,

    /**
     * Properties applied to the [`Modal`](/api/modal/) element.
     */
    ModalProps: propTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback
     */
    onClose: propTypes.func,

    /**
     * If `true`, the drawer is open.
     */
    open: propTypes.bool,

    /**
     * Properties applied to the [`Paper`](/api/paper/) element.
     */
    PaperProps: propTypes.object,

    /**
     * Properties applied to the [`Slide`](/api/slide/) element.
     */
    SlideProps: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['permanent', 'persistent', 'temporary'])
  };
  Drawer.defaultProps = {
    anchor: 'left',
    elevation: 16,
    open: false,
    transitionDuration: {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    },
    variant: 'temporary' // Mobile first.

  };
  var Drawer$1 = withStyles(styles$x, {
    name: 'MuiDrawer',
    flip: false,
    withTheme: true
  })(Drawer);

  var styles$y = function styles(theme) {
    var transition = {
      duration: theme.transitions.duration.shortest
    };
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        transition: theme.transitions.create(['margin'], transition),
        '&:before': {
          position: 'absolute',
          left: 0,
          top: -1,
          right: 0,
          height: 1,
          content: '""',
          opacity: 1,
          backgroundColor: theme.palette.divider,
          transition: theme.transitions.create(['opacity', 'background-color'], transition)
        },
        '&:first-child': {
          '&:before': {
            display: 'none'
          }
        },
        '&$expanded + &': {
          '&:before': {
            display: 'none'
          }
        }
      },

      /* Styles applied to the root element if `square={false}`. */
      rounded: {
        borderRadius: 0,
        '&:first-child': {
          borderTopLeftRadius: theme.shape.borderRadius,
          borderTopRightRadius: theme.shape.borderRadius
        },
        '&:last-child': {
          borderBottomLeftRadius: theme.shape.borderRadius,
          borderBottomRightRadius: theme.shape.borderRadius,
          // Fix a rendering issue on Edge
          '@supports (-ms-ime-align: auto)': {
            borderBottomLeftRadius: 0,
            borderBottomRightRadius: 0
          }
        }
      },

      /* Styles applied to the root element if `expanded={true}`. */
      expanded: {
        margin: '16px 0',
        '&:first-child': {
          marginTop: 0
        },
        '&:last-child': {
          marginBottom: 0
        },
        '&:before': {
          opacity: 0
        }
      },

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {
        backgroundColor: theme.palette.action.disabledBackground
      }
    };
  };

  var ExpansionPanel =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(ExpansionPanel, _React$Component);

    function ExpansionPanel(props) {
      var _this;

      classCallCheck(this, ExpansionPanel);

      _this = possibleConstructorReturn(this, getPrototypeOf(ExpansionPanel).call(this));

      _this.handleChange = function (event) {
        var expanded = _this.isControlled ? _this.props.expanded : _this.state.expanded;

        if (!_this.isControlled) {
          _this.setState({
            expanded: !expanded
          });
        }

        if (_this.props.onChange) {
          _this.props.onChange(event, !expanded);
        }
      };

      _this.isControlled = props.expanded != null;
      _this.state = {};

      if (!_this.isControlled) {
        // not controlled, use internal state
        _this.state.expanded = props.defaultExpanded !== undefined ? props.defaultExpanded : false;
      }

      return _this;
    }

    createClass(ExpansionPanel, [{
      key: "render",
      value: function render() {
        var _this2 = this,
            _classNames;

        var _this$props = this.props,
            childrenProp = _this$props.children,
            classes = _this$props.classes,
            classNameProp = _this$props.className,
            CollapsePropsProp = _this$props.CollapseProps,
            defaultExpanded = _this$props.defaultExpanded,
            disabled = _this$props.disabled,
            expandedProp = _this$props.expanded,
            onChange = _this$props.onChange,
            square = _this$props.square,
            other = objectWithoutProperties(_this$props, ["children", "classes", "className", "CollapseProps", "defaultExpanded", "disabled", "expanded", "onChange", "square"]);

        var expanded = this.isControlled ? expandedProp : this.state.expanded;
        var summary = null;
        var children = React.Children.map(childrenProp, function (child) {
          if (!React.isValidElement(child)) {
            return null;
          }

          warning_1(child.type !== React.Fragment, ["Material-UI: the ExpansionPanel component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));

          if (isMuiElement(child, ['ExpansionPanelSummary'])) {
            summary = React.cloneElement(child, {
              disabled: disabled,
              expanded: expanded,
              onChange: _this2.handleChange
            });
            return null;
          }

          return child;
        });
        var CollapseProps = !expanded ? {
          'aria-hidden': 'true'
        } : null;
        return React.createElement(Paper$1, _extends_1({
          className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.expanded, expanded), defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.rounded, !square), _classNames), classNameProp),
          elevation: 1,
          square: square
        }, other), summary, React.createElement(Collapse$1, _extends_1({
          in: expanded,
          timeout: "auto"
        }, CollapseProps, CollapsePropsProp), children));
      }
    }]);

    return ExpansionPanel;
  }(React.Component);

  ExpansionPanel.propTypes = {
    /**
     * The content of the expansion panel.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Properties applied to the [`Collapse`](/api/collapse/) element.
     */
    CollapseProps: propTypes.object,

    /**
     * If `true`, expands the panel by default.
     */
    defaultExpanded: propTypes.bool,

    /**
     * If `true`, the panel will be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, expands the panel, otherwise collapse it.
     * Setting this prop enables control over the panel.
     */
    expanded: propTypes.bool,

    /**
     * Callback fired when the expand/collapse state is changed.
     *
     * @param {object} event The event source of the callback
     * @param {boolean} expanded The `expanded` state of the panel
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    square: propTypes.bool
  };
  ExpansionPanel.defaultProps = {
    defaultExpanded: false,
    disabled: false,
    square: false
  };
  var ExpansionPanel$1 = withStyles(styles$y, {
    name: 'MuiExpansionPanel'
  })(ExpansionPanel);

  var styles$z = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'flex-end',
      padding: '16px 8px'
    },

    /* Styles applied to the children. */
    action: {
      marginLeft: 8
    }
  };

  function ExpansionPanelActions(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        other = objectWithoutProperties(props, ["children", "classes", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, className)
    }, other), cloneChildrenWithClassName(children, classes.action));
  }

  ExpansionPanelActions.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  var ExpansionPanelActions$1 = withStyles(styles$z, {
    name: 'MuiExpansionPanelActions'
  })(ExpansionPanelActions);

  var styles$A = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      padding: '8px 24px 24px'
    }
  };

  function ExpansionPanelDetails(props) {
    var classes = props.classes,
        children = props.children,
        className = props.className,
        other = objectWithoutProperties(props, ["classes", "children", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, className)
    }, other), children);
  }

  ExpansionPanelDetails.propTypes = {
    /**
     * The content of the expansion panel details.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  var ExpansionPanelDetails$1 = withStyles(styles$A, {
    name: 'MuiExpansionPanelDetails'
  })(ExpansionPanelDetails);

  var styles$B = function styles(theme) {
    var transition = {
      duration: theme.transitions.duration.shortest
    };
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        minHeight: 8 * 6,
        transition: theme.transitions.create(['min-height', 'background-color'], transition),
        padding: '0 24px 0 24px',
        '&:hover:not($disabled)': {
          cursor: 'pointer'
        },
        '&$expanded': {
          minHeight: 64
        },
        '&$focused': {
          backgroundColor: theme.palette.grey[300]
        },
        '&$disabled': {
          opacity: 0.38
        }
      },

      /* Styles applied to the root element if `expanded={true}`. */
      expanded: {},

      /* Styles applied to the root and children wrapper elements when focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the children wrapper element. */
      content: {
        display: 'flex',
        flexGrow: 1,
        transition: theme.transitions.create(['margin'], transition),
        margin: '12px 0',
        '& > :last-child': {
          paddingRight: 32
        },
        '&$expanded': {
          margin: '20px 0'
        }
      },

      /* Styles applied to the `IconButton` component when `expandIcon` is supplied. */
      expandIcon: {
        position: 'absolute',
        top: '50%',
        right: 8,
        transform: 'translateY(-50%) rotate(0deg)',
        transition: theme.transitions.create('transform', transition),
        '&:hover': {
          // Disable the hover effect for the IconButton,
          // because a hover effect should apply to the entire Expand button and
          // not only to the IconButton.
          backgroundColor: 'transparent'
        },
        '&$expanded': {
          transform: 'translateY(-50%) rotate(180deg)'
        }
      }
    };
  };

  var ExpansionPanelSummary =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(ExpansionPanelSummary, _React$Component);

    function ExpansionPanelSummary() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, ExpansionPanelSummary);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(ExpansionPanelSummary)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {
        focused: false
      };

      _this.handleFocusVisible = function (event) {
        _this.setState({
          focused: true
        });

        if (_this.props.onFocusVisible) {
          _this.props.onFocusVisible(event);
        }
      };

      _this.handleBlur = function (event) {
        _this.setState({
          focused: false
        });

        if (_this.props.onBlur) {
          _this.props.onBlur(event);
        }
      };

      _this.handleChange = function (event) {
        var _this$props = _this.props,
            onChange = _this$props.onChange,
            onClick = _this$props.onClick;

        if (onChange) {
          onChange(event);
        }

        if (onClick) {
          onClick(event);
        }
      };

      return _this;
    }

    createClass(ExpansionPanelSummary, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props2 = this.props,
            children = _this$props2.children,
            classes = _this$props2.classes,
            className = _this$props2.className,
            disabled = _this$props2.disabled,
            expanded = _this$props2.expanded,
            expandIcon = _this$props2.expandIcon,
            IconButtonProps = _this$props2.IconButtonProps,
            onBlur = _this$props2.onBlur,
            onChange = _this$props2.onChange,
            onClick = _this$props2.onClick,
            onFocusVisible = _this$props2.onFocusVisible,
            other = objectWithoutProperties(_this$props2, ["children", "classes", "className", "disabled", "expanded", "expandIcon", "IconButtonProps", "onBlur", "onChange", "onClick", "onFocusVisible"]);

        var focused = this.state.focused;
        return React.createElement(ButtonBase$1, _extends_1({
          focusRipple: false,
          disableRipple: true,
          disabled: disabled,
          component: "div",
          "aria-expanded": expanded,
          className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.expanded, expanded), defineProperty(_classNames, classes.focused, focused), _classNames), className),
          onFocusVisible: this.handleFocusVisible,
          onBlur: this.handleBlur,
          onClick: this.handleChange
        }, other), React.createElement("div", {
          className: classnames(classes.content, defineProperty({}, classes.expanded, expanded))
        }, children), expandIcon && React.createElement(IconButton$1, _extends_1({
          disabled: disabled,
          className: classnames(classes.expandIcon, defineProperty({}, classes.expanded, expanded)),
          component: "div",
          tabIndex: -1,
          "aria-hidden": "true"
        }, IconButtonProps), expandIcon));
      }
    }]);

    return ExpansionPanelSummary;
  }(React.Component);

  ExpansionPanelSummary.propTypes = {
    /**
     * The content of the expansion panel summary.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     * If `true`, the summary will be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * @ignore
     * If `true`, expands the summary, otherwise collapse it.
     */
    expanded: propTypes.bool,

    /**
     * The icon to display as the expand indicator.
     */
    expandIcon: propTypes.node,

    /**
     * Properties applied to the `TouchRipple` element wrapping the expand icon.
     */
    IconButtonProps: propTypes.object,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * @ignore
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    onFocusVisible: propTypes.func
  };
  ExpansionPanelSummary.defaultProps = {
    disabled: false
  };
  ExpansionPanelSummary.muiName = 'ExpansionPanelSummary';
  var ExpansionPanelSummary$1 = withStyles(styles$B, {
    name: 'MuiExpansionPanelSummary'
  })(ExpansionPanelSummary);

  var styles$C = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends_1({}, theme.typography.button, {
        boxSizing: 'border-box',
        minHeight: 36,
        transition: theme.transitions.create(['background-color', 'box-shadow', 'border'], {
          duration: theme.transitions.duration.short
        }),
        borderRadius: '50%',
        padding: 0,
        minWidth: 0,
        width: 56,
        height: 56,
        boxShadow: theme.shadows[6],
        '&:active': {
          boxShadow: theme.shadows[12]
        },
        color: theme.palette.getContrastText(theme.palette.grey[300]),
        backgroundColor: theme.palette.grey[300],
        '&$focusVisible': {
          boxShadow: theme.shadows[6]
        },
        '&:hover': {
          backgroundColor: theme.palette.grey.A100,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.grey[300]
          },
          '&$disabled': {
            backgroundColor: theme.palette.action.disabledBackground
          },
          textDecoration: 'none'
        },
        '&$disabled': {
          color: theme.palette.action.disabled,
          boxShadow: theme.shadows[0],
          backgroundColor: theme.palette.action.disabledBackground
        }
      }),

      /* Styles applied to the span element that wraps the children. */
      label: {
        width: '100%',
        // assure the correct width for iOS Safari
        display: 'inherit',
        alignItems: 'inherit',
        justifyContent: 'inherit'
      },

      /* Styles applied to the root element if `color="primary"`. */
      primary: {
        color: theme.palette.primary.contrastText,
        backgroundColor: theme.palette.primary.main,
        '&:hover': {
          backgroundColor: theme.palette.primary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.primary.main
          }
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      secondary: {
        color: theme.palette.secondary.contrastText,
        backgroundColor: theme.palette.secondary.main,
        '&:hover': {
          backgroundColor: theme.palette.secondary.dark,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: theme.palette.secondary.main
          }
        }
      },

      /* Styles applied to the root element if `variant="extended"`. */
      extended: {
        borderRadius: 48 / 2,
        padding: '0 16px',
        width: 'auto',
        minHeight: 'auto',
        minWidth: 48,
        height: 48,
        '&$sizeSmall': {
          width: 'auto',
          padding: '0 8px',
          borderRadius: 34 / 2,
          minWidth: 34,
          height: 34
        },
        '&$sizeMedium': {
          width: 'auto',
          padding: '0 16px',
          borderRadius: 40 / 2,
          minWidth: 40,
          height: 40
        }
      },

      /* Styles applied to the ButtonBase root element if the button is keyboard focused. */
      focusVisible: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the root element if `size="small"``. */
      sizeSmall: {
        width: 40,
        height: 40
      },

      /* Styles applied to the root element if `size="medium"``. */
      sizeMedium: {
        width: 48,
        height: 48
      }
    };
  };

  function Fab(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        className = props.className,
        color = props.color,
        disabled = props.disabled,
        disableFocusRipple = props.disableFocusRipple,
        focusVisibleClassName = props.focusVisibleClassName,
        size = props.size,
        variant = props.variant,
        other = objectWithoutProperties(props, ["children", "classes", "className", "color", "disabled", "disableFocusRipple", "focusVisibleClassName", "size", "variant"]);

    return React.createElement(ButtonBase$1, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.extended, variant === 'extended'), defineProperty(_classNames, classes.primary, color === 'primary'), defineProperty(_classNames, classes.secondary, color === 'secondary'), defineProperty(_classNames, classes["size".concat(capitalize(size))], size !== 'large'), defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.colorInherit, color === 'inherit'), _classNames), className),
      disabled: disabled,
      focusRipple: !disableFocusRipple,
      focusVisibleClassName: classnames(classes.focusVisible, focusVisibleClassName)
    }, other), React.createElement("span", {
      className: classes.label
    }, children));
  }

  Fab.propTypes = {
    /**
     * The content of the button.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'inherit', 'primary', 'secondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the button will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the  keyboard focus ripple will be disabled.
     * `disableRipple` must also be true.
     */
    disableFocusRipple: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string,

    /**
     * The URL to link to when the button is clicked.
     * If defined, an `a` element will be used as the root node.
     */
    href: propTypes.string,

    /**
     * The size of the button.
     * `small` is equivalent to the dense button styling.
     */
    size: propTypes.oneOf(['small', 'medium', 'large']),

    /**
     * @ignore
     */
    type: propTypes.string,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['round', 'extended'])
  };
  Fab.defaultProps = {
    color: 'default',
    component: 'button',
    disabled: false,
    disableFocusRipple: false,
    size: 'large',
    type: 'button',
    variant: 'round'
  };
  var Fab$1 = withStyles(styles$C, {
    name: 'MuiFab'
  })(Fab);

  function formControlState(_ref) {
    var props = _ref.props,
        states = _ref.states,
        muiFormControl = _ref.muiFormControl;
    return states.reduce(function (acc, state) {
      acc[state] = props[state];

      if (muiFormControl) {
        if (typeof props[state] === 'undefined') {
          acc[state] = muiFormControl[state];
        }
      }

      return acc;
    }, {});
  }

  var ROWS_HEIGHT = 19;
  var styles$D = {
    /* Styles applied to the root element. */
    root: {
      position: 'relative',
      // because the shadow has position: 'absolute',
      width: '100%'
    },
    textarea: {
      width: '100%',
      height: '100%',
      resize: 'none',
      font: 'inherit',
      padding: 0,
      cursor: 'inherit',
      boxSizing: 'border-box',
      lineHeight: 'inherit',
      border: 'none',
      outline: 'none',
      background: 'transparent'
    },
    shadow: {
      // Overflow also needed to here to remove the extra row
      // added to textareas in Firefox.
      overflow: 'hidden',
      // Visibility needed to hide the extra text area on iPads
      visibility: 'hidden',
      position: 'absolute',
      height: 'auto',
      whiteSpace: 'pre-wrap'
    }
  };
  /**
   * @ignore - internal component.
   */

  var Textarea =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Textarea, _React$Component);

    function Textarea(props) {
      var _this;

      classCallCheck(this, Textarea);

      _this = possibleConstructorReturn(this, getPrototypeOf(Textarea).call(this));

      _this.handleRefInput = function (ref) {
        _this.inputRef = ref;
        setRef(_this.props.textareaRef, ref);
      };

      _this.handleRefSinglelineShadow = function (ref) {
        _this.singlelineShadowRef = ref;
      };

      _this.handleRefShadow = function (ref) {
        _this.shadowRef = ref;
      };

      _this.handleChange = function (event) {
        _this.value = event.target.value;

        if (!_this.isControlled) {
          // The component is not controlled, we need to update the shallow value.
          _this.shadowRef.value = _this.value;

          _this.syncHeightWithShadow();
        }

        if (_this.props.onChange) {
          _this.props.onChange(event);
        }
      };

      _this.isControlled = props.value != null; // <Input> expects the components it renders to respond to 'value'
      // so that it can check whether they are filled.

      _this.value = props.value || props.defaultValue || '';
      _this.state = {
        height: Number(props.rows) * ROWS_HEIGHT
      };

      if (typeof window !== 'undefined') {
        _this.handleResize = debounce_1(function () {
          _this.syncHeightWithShadow();
        }, 166); // Corresponds to 10 frames at 60 Hz.
      }

      return _this;
    }

    createClass(Textarea, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.syncHeightWithShadow();
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        this.syncHeightWithShadow();
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.handleResize.clear();
      }
    }, {
      key: "syncHeightWithShadow",
      value: function syncHeightWithShadow() {
        var props = this.props; // Guarding for **broken** shallow rendering method that call componentDidMount
        // but doesn't handle refs correctly.
        // To remove once the shallow rendering has been fixed.

        if (!this.shadowRef) {
          return;
        }

        if (this.isControlled) {
          // The component is controlled, we need to update the shallow value.
          this.shadowRef.value = props.value == null ? '' : String(props.value);
        }

        var lineHeight = this.singlelineShadowRef.scrollHeight; // The Textarea might not be visible (p.ex: display: none).
        // In this case, the layout values read from the DOM will be 0.

        lineHeight = lineHeight === 0 ? ROWS_HEIGHT : lineHeight;
        var newHeight = this.shadowRef.scrollHeight; // Guarding for jsdom, where scrollHeight isn't present.
        // See https://github.com/tmpvar/jsdom/issues/1013

        if (newHeight === undefined) {
          return;
        }

        if (Number(props.rowsMax) >= Number(props.rows)) {
          newHeight = Math.min(Number(props.rowsMax) * lineHeight, newHeight);
        }

        newHeight = Math.max(newHeight, lineHeight); // Need a large enough different to update the height.
        // This prevents infinite rendering loop.

        if (Math.abs(this.state.height - newHeight) > 1) {
          this.setState({
            height: newHeight
          });
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            classes = _this$props.classes,
            className = _this$props.className,
            defaultValue = _this$props.defaultValue,
            onChange = _this$props.onChange,
            rows = _this$props.rows,
            rowsMax = _this$props.rowsMax,
            style = _this$props.style,
            textareaRef = _this$props.textareaRef,
            value = _this$props.value,
            other = objectWithoutProperties(_this$props, ["classes", "className", "defaultValue", "onChange", "rows", "rowsMax", "style", "textareaRef", "value"]);

        return React.createElement("div", {
          className: classes.root
        }, React.createElement(EventListener, {
          target: "window",
          onResize: this.handleResize
        }), React.createElement("textarea", {
          "aria-hidden": "true",
          className: classnames(classes.textarea, classes.shadow),
          readOnly: true,
          ref: this.handleRefSinglelineShadow,
          rows: "1",
          tabIndex: -1,
          value: ""
        }), React.createElement("textarea", {
          "aria-hidden": "true",
          className: classnames(classes.textarea, classes.shadow),
          defaultValue: defaultValue,
          readOnly: true,
          ref: this.handleRefShadow,
          rows: rows,
          tabIndex: -1,
          value: value
        }), React.createElement("textarea", _extends_1({
          rows: rows,
          className: classnames(classes.textarea, className),
          defaultValue: defaultValue,
          value: value,
          onChange: this.handleChange,
          ref: this.handleRefInput,
          style: _extends_1({
            height: this.state.height
          }, style)
        }, other)));
      }
    }]);

    return Textarea;
  }(React.Component);

  Textarea.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * @ignore
     */
    disabled: propTypes.bool,

    /**
     * @ignore
     */
    onChange: propTypes.func,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native textarea element.
     */
    textareaRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * @ignore
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number])
  };
  Textarea.defaultProps = {
    rows: 1
  };
  var Textarea$1 = withStyles(styles$D, {
    name: 'MuiPrivateTextarea'
  })(Textarea);

  // Supports determination of isControlled().
  // Controlled input accepts its current value as a prop.
  //
  // @see https://facebook.github.io/react/docs/forms.html#controlled-components
  // @param value
  // @returns {boolean} true if string (including '') or number (including zero)
  function hasValue(value) {
    return value != null && !(Array.isArray(value) && value.length === 0);
  } // Determine if field is empty or filled.
  // Response determines if label is presented above field or as placeholder.
  //
  // @param obj
  // @param SSR
  // @returns {boolean} False when not present or empty string.
  //                    True when any number or string with length.

  function isFilled(obj) {
    var SSR = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return obj && (hasValue(obj.value) && obj.value !== '' || SSR && hasValue(obj.defaultValue) && obj.defaultValue !== '');
  } // Determine if an Input is adorned on start.
  // It's corresponding to the left with LTR.
  //
  // @param obj
  // @returns {boolean} False when no adornments.
  //                    True when adorned at the start.

  function isAdornedStart(obj) {
    return obj.startAdornment;
  }

  var styles$E = function styles(theme) {
    var light = theme.palette.type === 'light';
    var placeholder = {
      color: 'currentColor',
      opacity: light ? 0.42 : 0.5,
      transition: theme.transitions.create('opacity', {
        duration: theme.transitions.duration.shorter
      })
    };
    var placeholderHidden = {
      opacity: 0
    };
    var placeholderVisible = {
      opacity: light ? 0.42 : 0.5
    };
    return {
      /* Styles applied to the root element. */
      root: {
        // Mimics the default input display property used by browsers for an input.
        fontFamily: theme.typography.fontFamily,
        color: theme.palette.text.primary,
        fontSize: theme.typography.pxToRem(16),
        lineHeight: '1.1875em',
        // Reset (19px), match the native input line-height
        cursor: 'text',
        display: 'inline-flex',
        alignItems: 'center',
        '&$disabled': {
          color: theme.palette.text.disabled,
          cursor: 'default'
        }
      },

      /* Styles applied to the root element if the component is a descendant of `FormControl`. */
      formControl: {},

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `startAdornment` is provided. */
      adornedStart: {},

      /* Styles applied to the root element if `endAdornment` is provided. */
      adornedEnd: {},

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the `input` element if `margin="dense"`. */
      marginDense: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {
        padding: "".concat(8 - 2, "px 0 ").concat(8 - 1, "px")
      },

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {
        width: '100%'
      },

      /* Styles applied to the `input` element. */
      input: {
        font: 'inherit',
        color: 'currentColor',
        padding: "".concat(8 - 2, "px 0 ").concat(8 - 1, "px"),
        border: 0,
        boxSizing: 'content-box',
        background: 'none',
        margin: 0,
        // Reset for Safari
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        display: 'block',
        // Make the flex item shrink with Firefox
        minWidth: 0,
        width: '100%',
        // Fix IE 11 width issue
        '&::-webkit-input-placeholder': placeholder,
        '&::-moz-placeholder': placeholder,
        // Firefox 19+
        '&:-ms-input-placeholder': placeholder,
        // IE 11
        '&::-ms-input-placeholder': placeholder,
        // Edge
        '&:focus': {
          outline: 0
        },
        // Reset Firefox invalid required input style
        '&:invalid': {
          boxShadow: 'none'
        },
        '&::-webkit-search-decoration': {
          // Remove the padding when type=search.
          '-webkit-appearance': 'none'
        },
        // Show and hide the placeholder logic
        'label[data-shrink=false] + $formControl &': {
          '&::-webkit-input-placeholder': placeholderHidden,
          '&::-moz-placeholder': placeholderHidden,
          // Firefox 19+
          '&:-ms-input-placeholder': placeholderHidden,
          // IE 11
          '&::-ms-input-placeholder': placeholderHidden,
          // Edge
          '&:focus::-webkit-input-placeholder': placeholderVisible,
          '&:focus::-moz-placeholder': placeholderVisible,
          // Firefox 19+
          '&:focus:-ms-input-placeholder': placeholderVisible,
          // IE 11
          '&:focus::-ms-input-placeholder': placeholderVisible // Edge

        },
        '&$disabled': {
          opacity: 1 // Reset iOS opacity

        }
      },

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {
        paddingTop: 4 - 1
      },

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {
        resize: 'none',
        padding: 0
      },

      /* Styles applied to the `input` element if `type` is not "text"`. */
      inputType: {
        // type="date" or type="time", etc. have specific styles we need to reset.
        height: '1.1875em' // Reset (19px), match the native input line-height

      },

      /* Styles applied to the `input` element if `type="search"`. */
      inputTypeSearch: {
        // Improve type search style.
        '-moz-appearance': 'textfield',
        '-webkit-appearance': 'textfield'
      },

      /* Styles applied to the `input` element if `startAdornment` is provided. */
      inputAdornedStart: {},

      /* Styles applied to the `input` element if `endAdornment` is provided. */
      inputAdornedEnd: {}
    };
  };
  /**
   * `InputBase` contains as few styles as possible.
   * It aims to be a simple building block for creating an input.
   * It contains a load of style reset and some state logic.
   */

  var InputBase =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(InputBase, _React$Component);

    createClass(InputBase, null, [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(props, state) {
        // The blur won't fire when the disabled state is set on a focused input.
        // We need to book keep the focused state manually.
        if (props.disabled && state.focused) {
          return {
            focused: false
          };
        }

        return null;
      }
    }]);

    function InputBase(props) {
      var _this;

      classCallCheck(this, InputBase);

      _this = possibleConstructorReturn(this, getPrototypeOf(InputBase).call(this, props));
      _this.state = {
        focused: false
      };

      _this.handleFocus = function (event) {
        var muiFormControl = _this.props.muiFormControl; // Fix a bug with IE 11 where the focus/blur events are triggered
        // while the input is disabled.

        if (formControlState({
          props: _this.props,
          muiFormControl: muiFormControl,
          states: ['disabled']
        }).disabled) {
          event.stopPropagation();
          return;
        }

        _this.setState({
          focused: true
        });

        if (_this.props.onFocus) {
          _this.props.onFocus(event);
        }

        if (muiFormControl && muiFormControl.onFocus) {
          muiFormControl.onFocus(event);
        }
      };

      _this.handleBlur = function (event) {
        _this.setState({
          focused: false
        });

        if (_this.props.onBlur) {
          _this.props.onBlur(event);
        }

        var muiFormControl = _this.props.muiFormControl;

        if (muiFormControl && muiFormControl.onBlur) {
          muiFormControl.onBlur(event);
        }
      };

      _this.handleChange = function () {
        if (!_this.isControlled) {
          _this.checkDirty(_this.inputRef);
        } // Perform in the willUpdate


        if (_this.props.onChange) {
          var _this$props;

          (_this$props = _this.props).onChange.apply(_this$props, arguments);
        }
      };

      _this.handleRefInput = function (ref) {
        _this.inputRef = ref;
        warning_1(!ref || ref instanceof HTMLInputElement || ref.focus, ['Material-UI: you have provided a `inputComponent` to the input component', 'that does not correctly handle the `inputRef` property.', 'Make sure the `inputRef` property is called with a HTMLInputElement.'].join('\n'));
        var refProp;

        if (_this.props.inputRef) {
          refProp = _this.props.inputRef;
        } else if (_this.props.inputProps && _this.props.inputProps.ref) {
          refProp = _this.props.inputProps.ref;
        }

        setRef(refProp, ref);
      };

      _this.handleClick = function (event) {
        if (_this.inputRef && event.currentTarget === event.target) {
          _this.inputRef.focus();
        }

        if (_this.props.onClick) {
          _this.props.onClick(event);
        }
      };

      _this.isControlled = props.value != null;

      if (_this.isControlled) {
        _this.checkDirty(props);
      }

      return _this;
    }

    createClass(InputBase, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (!this.isControlled) {
          this.checkDirty(this.inputRef);
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        // Book keep the focused state.
        if (!prevProps.disabled && this.props.disabled) {
          var muiFormControl = this.props.muiFormControl;

          if (muiFormControl && muiFormControl.onBlur) {
            muiFormControl.onBlur();
          }
        }

        if (this.isControlled) {
          this.checkDirty(this.props);
        } // else performed in the onChange

      }
    }, {
      key: "checkDirty",
      value: function checkDirty(obj) {
        var muiFormControl = this.props.muiFormControl;

        if (isFilled(obj)) {
          if (muiFormControl && muiFormControl.onFilled) {
            muiFormControl.onFilled();
          }

          if (this.props.onFilled) {
            this.props.onFilled();
          }

          return;
        }

        if (muiFormControl && muiFormControl.onEmpty) {
          muiFormControl.onEmpty();
        }

        if (this.props.onEmpty) {
          this.props.onEmpty();
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames, _classNames2;

        var _this$props2 = this.props,
            autoComplete = _this$props2.autoComplete,
            autoFocus = _this$props2.autoFocus,
            classes = _this$props2.classes,
            classNameProp = _this$props2.className,
            defaultValue = _this$props2.defaultValue,
            disabled = _this$props2.disabled,
            endAdornment = _this$props2.endAdornment,
            error = _this$props2.error,
            fullWidth = _this$props2.fullWidth,
            id = _this$props2.id,
            inputComponent = _this$props2.inputComponent,
            _this$props2$inputPro = _this$props2.inputProps;
        _this$props2$inputPro = _this$props2$inputPro === void 0 ? {} : _this$props2$inputPro;

        var inputPropsClassName = _this$props2$inputPro.className,
            inputPropsProp = objectWithoutProperties(_this$props2$inputPro, ["className"]),
            inputRef = _this$props2.inputRef,
            margin = _this$props2.margin,
            muiFormControl = _this$props2.muiFormControl,
            multiline = _this$props2.multiline,
            name = _this$props2.name,
            onBlur = _this$props2.onBlur,
            onChange = _this$props2.onChange,
            onClick = _this$props2.onClick,
            onEmpty = _this$props2.onEmpty,
            onFilled = _this$props2.onFilled,
            onFocus = _this$props2.onFocus,
            onKeyDown = _this$props2.onKeyDown,
            onKeyUp = _this$props2.onKeyUp,
            placeholder = _this$props2.placeholder,
            readOnly = _this$props2.readOnly,
            renderPrefix = _this$props2.renderPrefix,
            rows = _this$props2.rows,
            rowsMax = _this$props2.rowsMax,
            startAdornment = _this$props2.startAdornment,
            type = _this$props2.type,
            value = _this$props2.value,
            other = objectWithoutProperties(_this$props2, ["autoComplete", "autoFocus", "classes", "className", "defaultValue", "disabled", "endAdornment", "error", "fullWidth", "id", "inputComponent", "inputProps", "inputRef", "margin", "muiFormControl", "multiline", "name", "onBlur", "onChange", "onClick", "onEmpty", "onFilled", "onFocus", "onKeyDown", "onKeyUp", "placeholder", "readOnly", "renderPrefix", "rows", "rowsMax", "startAdornment", "type", "value"]);

        var ariaDescribedby = other['aria-describedby'];
        delete other['aria-describedby'];
        var fcs = formControlState({
          props: this.props,
          muiFormControl: muiFormControl,
          states: ['disabled', 'error', 'margin', 'required', 'filled']
        });
        var focused = muiFormControl ? muiFormControl.focused : this.state.focused;
        var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.disabled, fcs.disabled), defineProperty(_classNames, classes.error, fcs.error), defineProperty(_classNames, classes.fullWidth, fullWidth), defineProperty(_classNames, classes.focused, focused), defineProperty(_classNames, classes.formControl, muiFormControl), defineProperty(_classNames, classes.marginDense, fcs.margin === 'dense'), defineProperty(_classNames, classes.multiline, multiline), defineProperty(_classNames, classes.adornedStart, startAdornment), defineProperty(_classNames, classes.adornedEnd, endAdornment), _classNames), classNameProp);
        var inputClassName = classnames(classes.input, (_classNames2 = {}, defineProperty(_classNames2, classes.disabled, fcs.disabled), defineProperty(_classNames2, classes.inputType, type !== 'text'), defineProperty(_classNames2, classes.inputTypeSearch, type === 'search'), defineProperty(_classNames2, classes.inputMultiline, multiline), defineProperty(_classNames2, classes.inputMarginDense, fcs.margin === 'dense'), defineProperty(_classNames2, classes.inputAdornedStart, startAdornment), defineProperty(_classNames2, classes.inputAdornedEnd, endAdornment), _classNames2), inputPropsClassName);
        var InputComponent = inputComponent;

        var inputProps = _extends_1({}, inputPropsProp, {
          ref: this.handleRefInput
        });

        if (typeof InputComponent !== 'string') {
          inputProps = _extends_1({
            // Rename ref to inputRef as we don't know the
            // provided `inputComponent` structure.
            inputRef: this.handleRefInput,
            type: type
          }, inputProps, {
            ref: null
          });
        } else if (multiline) {
          if (rows && !rowsMax) {
            InputComponent = 'textarea';
          } else {
            inputProps = _extends_1({
              rowsMax: rowsMax,
              textareaRef: this.handleRefInput
            }, inputProps, {
              ref: null
            });
            InputComponent = Textarea$1;
          }
        } else {
          inputProps = _extends_1({
            type: type
          }, inputProps);
        }

        return React.createElement("div", _extends_1({
          className: className,
          onClick: this.handleClick
        }, other), renderPrefix ? renderPrefix(_extends_1({}, fcs, {
          startAdornment: startAdornment,
          focused: focused
        })) : null, startAdornment, React.createElement(FormControlContext.Provider, {
          value: null
        }, React.createElement(InputComponent, _extends_1({
          "aria-invalid": fcs.error,
          "aria-describedby": ariaDescribedby,
          autoComplete: autoComplete,
          autoFocus: autoFocus,
          className: inputClassName,
          defaultValue: defaultValue,
          disabled: fcs.disabled,
          id: id,
          name: name,
          onBlur: this.handleBlur,
          onChange: this.handleChange,
          onFocus: this.handleFocus,
          onKeyDown: onKeyDown,
          onKeyUp: onKeyUp,
          placeholder: placeholder,
          readOnly: readOnly,
          required: fcs.required,
          rows: rows,
          value: value
        }, inputProps))), endAdornment);
      }
    }]);

    return InputBase;
  }(React.Component);

  InputBase.propTypes = {
    /**
     * This property helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it here:
     * https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the input will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The default input value, useful when not controlling the component.
     */
    defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))]),

    /**
     * If `true`, the input will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: componentPropType,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onClick: propTypes.func,

    /**
     * @ignore
     */
    onEmpty: propTypes.func,

    /**
     * @ignore
     */
    onFilled: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * @ignore
     */
    onKeyUp: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * @ignore
     */
    renderPrefix: propTypes.func,

    /**
     * If `true`, the input will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the input element. It should be a valid HTML5 input type.
     */
    type: propTypes.string,

    /**
     * The input value, required for a controlled component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))])
  };
  InputBase.defaultProps = {
    fullWidth: false,
    inputComponent: 'input',
    multiline: false,
    type: 'text'
  };
  var InputBase$1 = withStyles(styles$E, {
    name: 'MuiInputBase'
  })(withFormControlContext(InputBase));

  var styles$F = function styles(theme) {
    var light = theme.palette.type === 'light';
    var bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
    var backgroundColor = light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.09)';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        backgroundColor: backgroundColor,
        borderTopLeftRadius: theme.shape.borderRadius,
        borderTopRightRadius: theme.shape.borderRadius,
        transition: theme.transitions.create('background-color', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        }),
        '&:hover': {
          backgroundColor: light ? 'rgba(0, 0, 0, 0.13)' : 'rgba(255, 255, 255, 0.13)',
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: backgroundColor
          }
        },
        '&$focused': {
          backgroundColor: light ? 'rgba(0, 0, 0, 0.09)' : 'rgba(255, 255, 255, 0.09)'
        },
        '&$disabled': {
          backgroundColor: light ? 'rgba(0, 0, 0, 0.12)' : 'rgba(255, 255, 255, 0.12)'
        }
      },

      /* Styles applied to the root element if `disableUnderline={false}`. */
      underline: {
        '&:after': {
          borderBottom: "2px solid ".concat(theme.palette.primary[light ? 'dark' : 'light']),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '""',
          position: 'absolute',
          right: 0,
          transform: 'scaleX(0)',
          transition: theme.transitions.create('transform', {
            duration: theme.transitions.duration.shorter,
            easing: theme.transitions.easing.easeOut
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&$focused:after': {
          transform: 'scaleX(1)'
        },
        '&$error:after': {
          borderBottomColor: theme.palette.error.main,
          transform: 'scaleX(1)' // error is always underlined in red

        },
        '&:before': {
          borderBottom: "1px solid ".concat(bottomLineColor),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '"\\00a0"',
          position: 'absolute',
          right: 0,
          transition: theme.transitions.create('border-bottom-color', {
            duration: theme.transitions.duration.shorter
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&:hover:not($disabled):not($focused):not($error):before': {
          borderBottom: "1px solid ".concat(theme.palette.text.primary)
        },
        '&$disabled:before': {
          borderBottom: "1px dotted ".concat(bottomLineColor)
        }
      },

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `startAdornment` is provided. */
      adornedStart: {
        paddingLeft: 12
      },

      /* Styles applied to the root element if `endAdornment` is provided. */
      adornedEnd: {
        paddingRight: 12
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {
        padding: '27px 12px 10px',
        boxSizing: 'border-box' // Prevent padding issue with fullWidth.

      },

      /* Styles applied to the `input` element. */
      input: {
        padding: '27px 12px 10px'
      },

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {
        paddingTop: 24,
        paddingBottom: 6
      },

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {
        padding: 0
      },

      /* Styles applied to the `input` element if `startAdornment` is provided. */
      inputAdornedStart: {
        paddingLeft: 0
      },

      /* Styles applied to the `input` element if `endAdornment` is provided. */
      inputAdornedEnd: {
        paddingRight: 0
      }
    };
  };

  function FilledInput(props) {
    var disableUnderline = props.disableUnderline,
        classes = props.classes,
        other = objectWithoutProperties(props, ["disableUnderline", "classes"]);

    return React.createElement(InputBase$1, _extends_1({
      classes: _extends_1({}, classes, {
        root: classnames(classes.root, defineProperty({}, classes.underline, !disableUnderline)),
        underline: null
      })
    }, other));
  }

  FilledInput.propTypes = {
    /**
     * This property helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it here:
     * https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the input will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The default input value, useful when not controlling the component.
     */
    defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))]),

    /**
     * If `true`, the input will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the input will not have an underline.
     */
    disableUnderline: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: componentPropType,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     */
    onChange: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the input will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the input element. It should be a valid HTML5 input type.
     */
    type: propTypes.string,

    /**
     * The input value, required for a controlled component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))])
  };
  InputBase$1.defaultProps = {
    fullWidth: false,
    inputComponent: 'input',
    multiline: false,
    type: 'text'
  };
  FilledInput.muiName = 'Input';
  var FilledInput$1 = withStyles(styles$F, {
    name: 'MuiFilledInput'
  })(FilledInput);

  var styles$G = {
    /* Styles applied to the root element. */
    root: {
      display: 'inline-flex',
      flexDirection: 'column',
      position: 'relative',
      // Reset fieldset default style.
      minWidth: 0,
      padding: 0,
      margin: 0,
      border: 0,
      verticalAlign: 'top' // Fix alignment issue on Safari.

    },

    /* Styles applied to the root element if `margin="normal"`. */
    marginNormal: {
      marginTop: 16,
      marginBottom: 8
    },

    /* Styles applied to the root element if `margin="dense"`. */
    marginDense: {
      marginTop: 8,
      marginBottom: 4
    },

    /* Styles applied to the root element if `fullWidth={true}`. */
    fullWidth: {
      width: '100%'
    }
  };
  /**
   * Provides context such as filled/focused/error/required for form inputs.
   * Relying on the context provides high flexibility and ensures that the state always stays
   * consistent across the children of the `FormControl`.
   * This context is used by the following components:
   *  - FormLabel
   *  - FormHelperText
   *  - Input
   *  - InputLabel
   *
   * ⚠️ Only one input can be used within a FormControl.
   */

  var FormControl =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(FormControl, _React$Component);

    createClass(FormControl, null, [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(props, state) {
        if (props.disabled && state.focused) {
          return {
            focused: false
          };
        }

        return null;
      }
    }]);

    function FormControl(props) {
      var _this;

      classCallCheck(this, FormControl);

      _this = possibleConstructorReturn(this, getPrototypeOf(FormControl).call(this));

      _this.handleFocus = function () {
        _this.setState(function (state) {
          return !state.focused ? {
            focused: true
          } : null;
        });
      };

      _this.handleBlur = function () {
        _this.setState(function (state) {
          return state.focused ? {
            focused: false
          } : null;
        });
      };

      _this.handleDirty = function () {
        if (!_this.state.filled) {
          _this.setState({
            filled: true
          });
        }
      };

      _this.handleClean = function () {
        if (_this.state.filled) {
          _this.setState({
            filled: false
          });
        }
      };

      _this.state = {
        adornedStart: false,
        filled: false,
        focused: false
      }; // We need to iterate through the children and find the Input in order
      // to fully support server-side rendering.

      var children = props.children;

      if (children) {
        React.Children.forEach(children, function (child) {
          if (!isMuiElement(child, ['Input', 'Select'])) {
            return;
          }

          if (isFilled(child.props, true)) {
            _this.state.filled = true;
          }

          var input = isMuiElement(child, ['Select']) ? child.props.input : child;

          if (input && isAdornedStart(input.props)) {
            _this.state.adornedStart = true;
          }
        });
      }

      return _this;
    }

    createClass(FormControl, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props = this.props,
            classes = _this$props.classes,
            className = _this$props.className,
            Component = _this$props.component,
            disabled = _this$props.disabled,
            error = _this$props.error,
            fullWidth = _this$props.fullWidth,
            margin = _this$props.margin,
            required = _this$props.required,
            variant = _this$props.variant,
            other = objectWithoutProperties(_this$props, ["classes", "className", "component", "disabled", "error", "fullWidth", "margin", "required", "variant"]);

        var _this$state = this.state,
            adornedStart = _this$state.adornedStart,
            filled = _this$state.filled,
            focused = _this$state.focused;
        var childContext = {
          adornedStart: adornedStart,
          disabled: disabled,
          error: error,
          filled: filled,
          focused: focused,
          margin: margin,
          onBlur: this.handleBlur,
          onEmpty: this.handleClean,
          onFilled: this.handleDirty,
          onFocus: this.handleFocus,
          required: required,
          variant: variant
        };
        return React.createElement(FormControlContext.Provider, {
          value: childContext
        }, React.createElement(Component, _extends_1({
          className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["margin".concat(capitalize(margin))], margin !== 'none'), defineProperty(_classNames, classes.fullWidth, fullWidth), _classNames), className)
        }, other)));
      }
    }]);

    return FormControl;
  }(React.Component);

  FormControl.propTypes = {
    /**
     * The contents of the form control.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the label, input and helper text should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the label should be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the component will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * If `dense` or `normal`, will adjust vertical spacing of this and contained components.
     */
    margin: propTypes.oneOf(['none', 'dense', 'normal']),

    /**
     * If `true`, the label will indicate that the input is required.
     */
    required: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };
  FormControl.defaultProps = {
    component: 'div',
    disabled: false,
    error: false,
    fullWidth: false,
    margin: 'none',
    required: false,
    variant: 'standard'
  };
  var FormControl$1 = withStyles(styles$G, {
    name: 'MuiFormControl'
  })(FormControl);

  var styles$H = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'inline-flex',
        alignItems: 'center',
        cursor: 'pointer',
        // For correct alignment with the text.
        verticalAlign: 'middle',
        // Remove grey highlight
        WebkitTapHighlightColor: 'transparent',
        marginLeft: -14,
        marginRight: 16,
        // used for row presentation of radio/checkbox
        '&$disabled': {
          cursor: 'default'
        }
      },

      /* Styles applied to the root element if `labelPlacement="start"`. */
      labelPlacementStart: {
        flexDirection: 'row-reverse',
        marginLeft: 16,
        // used for row presentation of radio/checkbox
        marginRight: -14
      },

      /* Styles applied to the root element if `labelPlacement="top"`. */
      labelPlacementTop: {
        flexDirection: 'column-reverse',
        marginLeft: 16
      },

      /* Styles applied to the root element if `labelPlacement="bottom"`. */
      labelPlacementBottom: {
        flexDirection: 'column',
        marginLeft: 16
      },

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the label's Typography component. */
      label: {
        '&$disabled': {
          color: theme.palette.text.disabled
        }
      }
    };
  };
  /**
   * Drop in replacement of the `Radio`, `Switch` and `Checkbox` component.
   * Use this component if you want to display an extra label.
   */

  function FormControlLabel(props) {
    var _classNames;

    var checked = props.checked,
        classes = props.classes,
        classNameProp = props.className,
        control = props.control,
        disabledProp = props.disabled,
        inputRef = props.inputRef,
        label = props.label,
        labelPlacement = props.labelPlacement,
        muiFormControl = props.muiFormControl,
        name = props.name,
        onChange = props.onChange,
        value = props.value,
        other = objectWithoutProperties(props, ["checked", "classes", "className", "control", "disabled", "inputRef", "label", "labelPlacement", "muiFormControl", "name", "onChange", "value"]);

    var disabled = disabledProp;

    if (typeof disabled === 'undefined' && typeof control.props.disabled !== 'undefined') {
      disabled = control.props.disabled;
    }

    if (typeof disabled === 'undefined' && muiFormControl) {
      disabled = muiFormControl.disabled;
    }

    var controlProps = {
      disabled: disabled
    };
    ['checked', 'name', 'onChange', 'value', 'inputRef'].forEach(function (key) {
      if (typeof control.props[key] === 'undefined' && typeof props[key] !== 'undefined') {
        controlProps[key] = props[key];
      }
    });
    return React.createElement("label", _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["labelPlacement".concat(capitalize(labelPlacement))], labelPlacement !== 'end'), defineProperty(_classNames, classes.disabled, disabled), _classNames), classNameProp)
    }, other), React.cloneElement(control, controlProps), React.createElement(Typography$1, {
      component: "span",
      className: classnames(classes.label, defineProperty({}, classes.disabled, disabled))
    }, label));
  }

  FormControlLabel.propTypes = {
    /**
     * If `true`, the component appears selected.
     */
    checked: propTypes.oneOfType([propTypes.bool, propTypes.string]),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * A control element. For instance, it can be be a `Radio`, a `Switch` or a `Checkbox`.
     */
    control: propTypes.element,

    /**
     * If `true`, the control will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * The text to be used in an enclosing label element.
     */
    label: propTypes.node,

    /**
     * The position of the label.
     */
    labelPlacement: propTypes.oneOf(['end', 'start', 'top', 'bottom']),

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /*
     * @ignore
     */
    name: propTypes.string,

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.checked`.
     * @param {boolean} checked The `checked` value of the switch
     */
    onChange: propTypes.func,

    /**
     * The value of the component.
     */
    value: propTypes.string
  };
  FormControlLabel.defaultProps = {
    labelPlacement: 'end'
  };
  var FormControlLabel$1 = withStyles(styles$H, {
    name: 'MuiFormControlLabel'
  })(withFormControlContext(FormControlLabel));

  var styles$I = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      flexDirection: 'column',
      flexWrap: 'wrap'
    },

    /* Styles applied to the root element if `row={true}`. */
    row: {
      flexDirection: 'row'
    }
  };
  /**
   * `FormGroup` wraps controls such as `Checkbox` and `Switch`.
   * It provides compact row layout.
   * For the `Radio`, you should be using the `RadioGroup` component instead of this one.
   */

  function FormGroup(props) {
    var classes = props.classes,
        className = props.className,
        children = props.children,
        row = props.row,
        other = objectWithoutProperties(props, ["classes", "className", "children", "row"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, defineProperty({}, classes.row, row), className)
    }, other), children);
  }

  FormGroup.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Display group of elements in a compact row.
     */
    row: propTypes.bool
  };
  FormGroup.defaultProps = {
    row: false
  };
  var FormGroup$1 = withStyles(styles$I, {
    name: 'MuiFormGroup'
  })(FormGroup);

  var styles$J = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        color: theme.palette.text.secondary,
        fontFamily: theme.typography.fontFamily,
        fontSize: theme.typography.pxToRem(12),
        textAlign: 'left',
        marginTop: 8,
        lineHeight: '1em',
        minHeight: '1em',
        margin: 0,
        '&$disabled': {
          color: theme.palette.text.disabled
        },
        '&$error': {
          color: theme.palette.error.main
        }
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `margin="dense"`. */
      marginDense: {
        marginTop: 4
      },

      /* Styles applied to the root element if `variant="filled"` or `variant="outlined"`. */
      contained: {
        margin: '8px 12px 0'
      },

      /* Styles applied to the root element if `focused={true}`. */
      focused: {},

      /* Styles applied to the root element if `filled={true}`. */
      filled: {},

      /* Styles applied to the root element if `required={true}`. */
      required: {}
    };
  };

  function FormHelperText(props) {
    var _classNames;

    var classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        disabled = props.disabled,
        error = props.error,
        filled = props.filled,
        focused = props.focused,
        margin = props.margin,
        muiFormControl = props.muiFormControl,
        required = props.required,
        variant = props.variant,
        other = objectWithoutProperties(props, ["classes", "className", "component", "disabled", "error", "filled", "focused", "margin", "muiFormControl", "required", "variant"]);

    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['variant', 'margin', 'disabled', 'error', 'filled', 'focused', 'required']
    });
    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.contained, fcs.variant === 'filled' || fcs.variant === 'outlined'), defineProperty(_classNames, classes.marginDense, fcs.margin === 'dense'), defineProperty(_classNames, classes.disabled, fcs.disabled), defineProperty(_classNames, classes.error, fcs.error), defineProperty(_classNames, classes.filled, fcs.filled), defineProperty(_classNames, classes.focused, fcs.focused), defineProperty(_classNames, classes.required, fcs.required), _classNames), classNameProp)
    }, other));
  }

  FormHelperText.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the helper text should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, helper text should be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the helper text should use filled classes key.
     */
    filled: propTypes.bool,

    /**
     * If `true`, the helper text should use focused classes key.
     */
    focused: propTypes.bool,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense']),

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * If `true`, the helper text should use required classes key.
     */
    required: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };
  FormHelperText.defaultProps = {
    component: 'p'
  };
  var FormHelperText$1 = withStyles(styles$J, {
    name: 'MuiFormHelperText'
  })(withFormControlContext(FormHelperText));

  var styles$K = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        fontFamily: theme.typography.fontFamily,
        color: theme.palette.text.secondary,
        fontSize: theme.typography.pxToRem(16),
        lineHeight: 1,
        padding: 0,
        '&$focused': {
          color: theme.palette.primary[theme.palette.type === 'light' ? 'dark' : 'light']
        },
        '&$disabled': {
          color: theme.palette.text.disabled
        },
        '&$error': {
          color: theme.palette.error.main
        }
      },

      /* Styles applied to the root element if `focused={true}`. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `filled={true}`. */
      filled: {},

      /* Styles applied to the root element if `required={true}`. */
      required: {},
      asterisk: {
        '&$error': {
          color: theme.palette.error.main
        }
      }
    };
  };

  function FormLabel(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        disabled = props.disabled,
        error = props.error,
        filled = props.filled,
        focused = props.focused,
        muiFormControl = props.muiFormControl,
        required = props.required,
        other = objectWithoutProperties(props, ["children", "classes", "className", "component", "disabled", "error", "filled", "focused", "muiFormControl", "required"]);

    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['required', 'focused', 'disabled', 'error', 'filled']
    });
    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.disabled, fcs.disabled), defineProperty(_classNames, classes.error, fcs.error), defineProperty(_classNames, classes.filled, fcs.filled), defineProperty(_classNames, classes.focused, fcs.focused), defineProperty(_classNames, classes.required, fcs.required), _classNames), classNameProp)
    }, other), children, fcs.required && React.createElement("span", {
      className: classnames(classes.asterisk, defineProperty({}, classes.error, fcs.error))
    }, "\u2009*"));
  }

  FormLabel.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the label should be displayed in a disabled state.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the label should be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the label should use filled classes key.
     */
    filled: propTypes.bool,

    /**
     * If `true`, the input of this label is focused (used by `FormGroup` components).
     */
    focused: propTypes.bool,

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * If `true`, the label will indicate that the input is required.
     */
    required: propTypes.bool
  };
  FormLabel.defaultProps = {
    component: 'label'
  };
  var FormLabel$1 = withStyles(styles$K, {
    name: 'MuiFormLabel'
  })(withFormControlContext(FormLabel));

  function requirePropFactory(componentNameInError) {

    var requireProp = function requireProp(requiredProp) {
      return function (props, propName, componentName, location, propFullName) {
        var propFullNameSafe = propFullName || propName;

        if (typeof props[propName] !== 'undefined' && !props[requiredProp]) {
          return new Error("The property `".concat(propFullNameSafe, "` of ") + "`".concat(componentNameInError, "` must be used on `").concat(requiredProp, "`."));
        }

        return null;
      };
    };

    return requireProp;
  }

  var GUTTERS = [0, 8, 16, 24, 32, 40];
  var GRID_SIZES = ['auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];

  function generateGrid(globalStyles, theme, breakpoint) {
    var styles = {};
    GRID_SIZES.forEach(function (size) {
      var key = "grid-".concat(breakpoint, "-").concat(size);

      if (size === true) {
        // For the auto layouting
        styles[key] = {
          flexBasis: 0,
          flexGrow: 1,
          maxWidth: '100%'
        };
        return;
      }

      if (size === 'auto') {
        styles[key] = {
          flexBasis: 'auto',
          flexGrow: 0,
          maxWidth: 'none'
        };
        return;
      } // Keep 7 significant numbers.


      var width = "".concat(Math.round(size / 12 * 10e7) / 10e5, "%"); // Close to the bootstrap implementation:
      // https://github.com/twbs/bootstrap/blob/8fccaa2439e97ec72a4b7dc42ccc1f649790adb0/scss/mixins/_grid.scss#L41

      styles[key] = {
        flexBasis: width,
        flexGrow: 0,
        maxWidth: width
      };
    }); // No need for a media query for the first size.

    if (breakpoint === 'xs') {
      _extends_1(globalStyles, styles);
    } else {
      globalStyles[theme.breakpoints.up(breakpoint)] = styles;
    }
  }

  function generateGutter(theme, breakpoint) {
    var styles = {};
    GUTTERS.forEach(function (spacing, index) {
      if (index === 0) {
        // Skip the default style.
        return;
      }

      styles["spacing-".concat(breakpoint, "-").concat(spacing)] = {
        margin: -spacing / 2,
        width: "calc(100% + ".concat(spacing, "px)"),
        '& > $item': {
          padding: spacing / 2
        }
      };
    });
    return styles;
  } // Default CSS values
  // flex: '0 1 auto',
  // flexDirection: 'row',
  // alignItems: 'flex-start',
  // flexWrap: 'nowrap',
  // justifyContent: 'flex-start',


  var styles$L = function styles(theme) {
    return _extends_1({
      /* Styles applied to the root element if `container={true}`. */
      container: {
        boxSizing: 'border-box',
        display: 'flex',
        flexWrap: 'wrap',
        width: '100%'
      },

      /* Styles applied to the root element if `item={true}`. */
      item: {
        boxSizing: 'border-box',
        margin: '0' // For instance, it's useful when used with a `figure` element.

      },

      /* Styles applied to the root element if `zeroMinWidth={true}`. */
      zeroMinWidth: {
        minWidth: 0
      },

      /* Styles applied to the root element if `direction="column"`. */
      'direction-xs-column': {
        flexDirection: 'column'
      },

      /* Styles applied to the root element if `direction="column-reverse"`. */
      'direction-xs-column-reverse': {
        flexDirection: 'column-reverse'
      },

      /* Styles applied to the root element if `direction="rwo-reverse"`. */
      'direction-xs-row-reverse': {
        flexDirection: 'row-reverse'
      },

      /* Styles applied to the root element if `wrap="nowrap"`. */
      'wrap-xs-nowrap': {
        flexWrap: 'nowrap'
      },

      /* Styles applied to the root element if `wrap="reverse"`. */
      'wrap-xs-wrap-reverse': {
        flexWrap: 'wrap-reverse'
      },

      /* Styles applied to the root element if `alignItems="center"`. */
      'align-items-xs-center': {
        alignItems: 'center'
      },

      /* Styles applied to the root element if `alignItems="flex-start"`. */
      'align-items-xs-flex-start': {
        alignItems: 'flex-start'
      },

      /* Styles applied to the root element if `alignItems="flex-end"`. */
      'align-items-xs-flex-end': {
        alignItems: 'flex-end'
      },

      /* Styles applied to the root element if `alignItems="baseline"`. */
      'align-items-xs-baseline': {
        alignItems: 'baseline'
      },

      /* Styles applied to the root element if `alignContent="center"`. */
      'align-content-xs-center': {
        alignContent: 'center'
      },

      /* Styles applied to the root element if `alignContent="flex-start"`. */
      'align-content-xs-flex-start': {
        alignContent: 'flex-start'
      },

      /* Styles applied to the root element if `alignContent="flex-end"`. */
      'align-content-xs-flex-end': {
        alignContent: 'flex-end'
      },

      /* Styles applied to the root element if `alignContent="space-between"`. */
      'align-content-xs-space-between': {
        alignContent: 'space-between'
      },

      /* Styles applied to the root element if `alignContent="space-around"`. */
      'align-content-xs-space-around': {
        alignContent: 'space-around'
      },

      /* Styles applied to the root element if `justify="center"`. */
      'justify-xs-center': {
        justifyContent: 'center'
      },

      /* Styles applied to the root element if `justify="flex-end"`. */
      'justify-xs-flex-end': {
        justifyContent: 'flex-end'
      },

      /* Styles applied to the root element if `justify="space-between"`. */
      'justify-xs-space-between': {
        justifyContent: 'space-between'
      },

      /* Styles applied to the root element if `justify="space-around"`. */
      'justify-xs-space-around': {
        justifyContent: 'space-around'
      },

      /* Styles applied to the root element if `justify="space-evenly"`. */
      'justify-xs-space-evenly': {
        justifyContent: 'space-evenly'
      }
    }, generateGutter(theme, 'xs'), keys.reduce(function (accumulator, key) {
      // Use side effect over immutability for better performance.
      generateGrid(accumulator, theme, key);
      return accumulator;
    }, {}));
  };

  function Grid(props) {
    var _classNames;

    var alignContent = props.alignContent,
        alignItems = props.alignItems,
        classes = props.classes,
        classNameProp = props.className,
        Component = props.component,
        container = props.container,
        direction = props.direction,
        item = props.item,
        justify = props.justify,
        lg = props.lg,
        md = props.md,
        sm = props.sm,
        spacing = props.spacing,
        wrap = props.wrap,
        xl = props.xl,
        xs = props.xs,
        zeroMinWidth = props.zeroMinWidth,
        other = objectWithoutProperties(props, ["alignContent", "alignItems", "classes", "className", "component", "container", "direction", "item", "justify", "lg", "md", "sm", "spacing", "wrap", "xl", "xs", "zeroMinWidth"]);

    var className = classnames((_classNames = {}, defineProperty(_classNames, classes.container, container), defineProperty(_classNames, classes.item, item), defineProperty(_classNames, classes.zeroMinWidth, zeroMinWidth), defineProperty(_classNames, classes["spacing-xs-".concat(String(spacing))], container && spacing !== 0), defineProperty(_classNames, classes["direction-xs-".concat(String(direction))], direction !== Grid.defaultProps.direction), defineProperty(_classNames, classes["wrap-xs-".concat(String(wrap))], wrap !== Grid.defaultProps.wrap), defineProperty(_classNames, classes["align-items-xs-".concat(String(alignItems))], alignItems !== Grid.defaultProps.alignItems), defineProperty(_classNames, classes["align-content-xs-".concat(String(alignContent))], alignContent !== Grid.defaultProps.alignContent), defineProperty(_classNames, classes["justify-xs-".concat(String(justify))], justify !== Grid.defaultProps.justify), defineProperty(_classNames, classes["grid-xs-".concat(String(xs))], xs !== false), defineProperty(_classNames, classes["grid-sm-".concat(String(sm))], sm !== false), defineProperty(_classNames, classes["grid-md-".concat(String(md))], md !== false), defineProperty(_classNames, classes["grid-lg-".concat(String(lg))], lg !== false), defineProperty(_classNames, classes["grid-xl-".concat(String(xl))], xl !== false), _classNames), classNameProp);
    return React.createElement(Component, _extends_1({
      className: className
    }, other));
  }

  Grid.propTypes = {
    /**
     * Defines the `align-content` style property.
     * It's applied for all screen sizes.
     */
    alignContent: propTypes.oneOf(['stretch', 'center', 'flex-start', 'flex-end', 'space-between', 'space-around']),

    /**
     * Defines the `align-items` style property.
     * It's applied for all screen sizes.
     */
    alignItems: propTypes.oneOf(['flex-start', 'center', 'flex-end', 'stretch', 'baseline']),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the component will have the flex *container* behavior.
     * You should be wrapping *items* with a *container*.
     */
    container: propTypes.bool,

    /**
     * Defines the `flex-direction` style property.
     * It is applied for all screen sizes.
     */
    direction: propTypes.oneOf(['row', 'row-reverse', 'column', 'column-reverse']),

    /**
     * If `true`, the component will have the flex *item* behavior.
     * You should be wrapping *items* with a *container*.
     */
    item: propTypes.bool,

    /**
     * Defines the `justify-content` style property.
     * It is applied for all screen sizes.
     */
    justify: propTypes.oneOf(['flex-start', 'center', 'flex-end', 'space-between', 'space-around', 'space-evenly']),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `lg` breakpoint and wider screens if not overridden.
     */
    lg: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `md` breakpoint and wider screens if not overridden.
     */
    md: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `sm` breakpoint and wider screens if not overridden.
     */
    sm: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the space between the type `item` component.
     * It can only be used on a type `container` component.
     */
    spacing: propTypes.oneOf(GUTTERS),

    /**
     * Defines the `flex-wrap` style property.
     * It's applied for all screen sizes.
     */
    wrap: propTypes.oneOf(['nowrap', 'wrap', 'wrap-reverse']),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for the `xl` breakpoint and wider screens.
     */
    xl: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * Defines the number of grids the component is going to use.
     * It's applied for all the screen sizes with the lowest priority.
     */
    xs: propTypes.oneOf([false, 'auto', true, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]),

    /**
     * If `true`, it sets `min-width: 0` on the item.
     * Refer to the limitations section of the documentation to better understand the use case.
     */
    zeroMinWidth: propTypes.bool
  };
  Grid.defaultProps = {
    alignContent: 'stretch',
    alignItems: 'stretch',
    component: 'div',
    container: false,
    direction: 'row',
    item: false,
    justify: 'flex-start',
    lg: false,
    md: false,
    sm: false,
    spacing: 0,
    wrap: 'wrap',
    xl: false,
    xs: false,
    zeroMinWidth: false
  };
  var StyledGrid = withStyles(styles$L, {
    name: 'MuiGrid'
  })(Grid);

  {
    var requireProp = requirePropFactory('Grid');
    StyledGrid.propTypes = _extends_1({}, StyledGrid.propTypes, {
      alignContent: requireProp('container'),
      alignItems: requireProp('container'),
      direction: requireProp('container'),
      justify: requireProp('container'),
      lg: requireProp('item'),
      md: requireProp('item'),
      sm: requireProp('item'),
      spacing: requireProp('container'),
      wrap: requireProp('container'),
      xs: requireProp('item'),
      zeroMinWidth: requireProp('zeroMinWidth')
    });
  }

  var styles$M = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      flexWrap: 'wrap',
      overflowY: 'auto',
      listStyle: 'none',
      padding: 0,
      WebkitOverflowScrolling: 'touch' // Add iOS momentum scrolling.

    }
  };

  function GridList(props) {
    var cellHeight = props.cellHeight,
        children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        cols = props.cols,
        Component = props.component,
        spacing = props.spacing,
        style = props.style,
        other = objectWithoutProperties(props, ["cellHeight", "children", "classes", "className", "cols", "component", "spacing", "style"]);

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, classNameProp),
      style: _extends_1({
        margin: -spacing / 2
      }, style)
    }, other), React.Children.map(children, function (child) {
      if (!React.isValidElement(child)) {
        return null;
      }

      warning_1(child.type !== React.Fragment, ["Material-UI: the GridList component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      var childCols = child.props.cols || 1;
      var childRows = child.props.rows || 1;
      return React.cloneElement(child, {
        style: _extends_1({
          width: "".concat(100 / cols * childCols, "%"),
          height: cellHeight === 'auto' ? 'auto' : cellHeight * childRows + spacing,
          padding: spacing / 2
        }, child.props.style)
      });
    }));
  }

  GridList.propTypes = {
    /**
     * Number of px for one cell height.
     * You can set `'auto'` if you want to let the children determine the height.
     */
    cellHeight: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['auto'])]),

    /**
     * Grid Tiles that will be in Grid List.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Number of columns.
     */
    cols: propTypes.number,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Number of px for the spacing between tiles.
     */
    spacing: propTypes.number,

    /**
     * @ignore
     */
    style: propTypes.object
  };
  GridList.defaultProps = {
    cellHeight: 180,
    cols: 2,
    component: 'ul',
    spacing: 4
  };
  var GridList$1 = withStyles(styles$M, {
    name: 'MuiGridList'
  })(GridList);

  var styles$N = {
    /* Styles applied to the root element. */
    root: {
      boxSizing: 'border-box',
      flexShrink: 0
    },

    /* Styles applied to the `div` element that wraps the children. */
    tile: {
      position: 'relative',
      display: 'block',
      // In case it's not rendered with a div.
      height: '100%',
      overflow: 'hidden'
    },

    /* Styles applied to an `img` element child, if needed to ensure it covers the tile. */
    imgFullHeight: {
      height: '100%',
      transform: 'translateX(-50%)',
      position: 'relative',
      left: '50%'
    },

    /* Styles applied to an `img` element child, if needed to ensure it covers the tile. */
    imgFullWidth: {
      width: '100%',
      position: 'relative',
      transform: 'translateY(-50%)',
      top: '50%'
    }
  };

  var GridListTile =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(GridListTile, _React$Component);

    function GridListTile() {
      var _this;

      classCallCheck(this, GridListTile);

      _this = possibleConstructorReturn(this, getPrototypeOf(GridListTile).call(this));

      _this.fit = function () {
        var imgElement = _this.imgElement;

        if (!imgElement || !imgElement.complete) {
          return;
        }

        if (imgElement.width / imgElement.height > imgElement.parentNode.offsetWidth / imgElement.parentNode.offsetHeight) {
          var _imgElement$classList, _imgElement$classList2;

          (_imgElement$classList = imgElement.classList).remove.apply(_imgElement$classList, toConsumableArray(_this.props.classes.imgFullWidth.split(' ')));

          (_imgElement$classList2 = imgElement.classList).add.apply(_imgElement$classList2, toConsumableArray(_this.props.classes.imgFullHeight.split(' ')));
        } else {
          var _imgElement$classList3, _imgElement$classList4;

          (_imgElement$classList3 = imgElement.classList).remove.apply(_imgElement$classList3, toConsumableArray(_this.props.classes.imgFullHeight.split(' ')));

          (_imgElement$classList4 = imgElement.classList).add.apply(_imgElement$classList4, toConsumableArray(_this.props.classes.imgFullWidth.split(' ')));
        }

        imgElement.removeEventListener('load', _this.fit);
      };

      if (typeof window !== 'undefined') {
        _this.handleResize = debounce_1(function () {
          _this.fit();
        }, 166); // Corresponds to 10 frames at 60 Hz.
      }

      return _this;
    }

    createClass(GridListTile, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.ensureImageCover();
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        this.ensureImageCover();
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.handleResize.clear();
      }
    }, {
      key: "ensureImageCover",
      value: function ensureImageCover() {
        if (!this.imgElement) {
          return;
        }

        if (this.imgElement.complete) {
          this.fit();
        } else {
          this.imgElement.addEventListener('load', this.fit);
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            children = _this$props.children,
            classes = _this$props.classes,
            className = _this$props.className,
            cols = _this$props.cols,
            Component = _this$props.component,
            rows = _this$props.rows,
            other = objectWithoutProperties(_this$props, ["children", "classes", "className", "cols", "component", "rows"]);

        return React.createElement(Component, _extends_1({
          className: classnames(classes.root, className)
        }, other), React.createElement(EventListener, {
          target: "window",
          onResize: this.handleResize
        }), React.createElement("div", {
          className: classes.tile
        }, React.Children.map(children, function (child) {
          if (!React.isValidElement(child)) {
            return null;
          }

          if (child.type === 'img') {
            return React.cloneElement(child, {
              ref: function ref(node) {
                _this2.imgElement = node;
              }
            });
          }

          return child;
        })));
      }
    }]);

    return GridListTile;
  }(React.Component);

  GridListTile.propTypes = {
    /**
     * Theoretically you can pass any node as children, but the main use case is to pass an img,
     * in which case GridListTile takes care of making the image "cover" available space
     * (similar to `background-size: cover` or to `object-fit: cover`).
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Width of the tile in number of grid cells.
     */
    cols: propTypes.number,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Height of the tile in number of grid cells.
     */
    rows: propTypes.number
  };
  GridListTile.defaultProps = {
    cols: 1,
    component: 'li',
    rows: 1
  };
  var GridListTile$1 = withStyles(styles$N, {
    name: 'MuiGridListTile'
  })(GridListTile);

  var styles$O = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'absolute',
        left: 0,
        right: 0,
        height: 48,
        background: 'rgba(0, 0, 0, 0.5)',
        display: 'flex',
        alignItems: 'center',
        fontFamily: theme.typography.fontFamily
      },

      /* Styles applied to the root element if `titlePosition="bottom"`. */
      titlePositionBottom: {
        bottom: 0
      },

      /* Styles applied to the root element if `titlePosition="top"`. */
      titlePositionTop: {
        top: 0
      },

      /* Styles applied to the root element if a `subtitle` is provided. */
      rootSubtitle: {
        height: 68
      },

      /* Styles applied to the title and subtitle container element. */
      titleWrap: {
        flexGrow: 1,
        marginLeft: theme.mixins.gutters().paddingLeft,
        marginRight: theme.mixins.gutters().paddingRight,
        color: theme.palette.common.white,
        overflow: 'hidden'
      },

      /* Styles applied to the container element if `actionPosition="left"`. */
      titleWrapActionPosLeft: {
        marginLeft: 0
      },

      /* Styles applied to the container element if `actionPosition="right"`. */
      titleWrapActionPosRight: {
        marginRight: 0
      },

      /* Styles applied to the title container element. */
      title: {
        fontSize: theme.typography.pxToRem(16),
        lineHeight: '24px',
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
      },

      /* Styles applied to the subtitle container element. */
      subtitle: {
        fontSize: theme.typography.pxToRem(12),
        lineHeight: 1,
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
      },

      /* Styles applied to the actionIcon if supplied. */
      actionIcon: {},

      /* Styles applied to the actionIcon if `actionPosition="left"`. */
      actionIconActionPosLeft: {
        order: -1
      }
    };
  };

  function GridListTileBar(props) {
    var _classNames, _classNames2;

    var actionIcon = props.actionIcon,
        actionPosition = props.actionPosition,
        classes = props.classes,
        classNameProp = props.className,
        subtitle = props.subtitle,
        title$$1 = props.title,
        titlePosition = props.titlePosition,
        other = objectWithoutProperties(props, ["actionIcon", "actionPosition", "classes", "className", "subtitle", "title", "titlePosition"]);

    var actionPos = actionIcon && actionPosition;
    var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.titlePositionBottom, titlePosition === 'bottom'), defineProperty(_classNames, classes.titlePositionTop, titlePosition === 'top'), defineProperty(_classNames, classes.rootSubtitle, subtitle), _classNames), classNameProp); // Remove the margin between the title / subtitle wrapper, and the Action Icon

    var titleWrapClassName = classnames(classes.titleWrap, (_classNames2 = {}, defineProperty(_classNames2, classes.titleWrapActionPosLeft, actionPos === 'left'), defineProperty(_classNames2, classes.titleWrapActionPosRight, actionPos === 'right'), _classNames2));
    return React.createElement("div", _extends_1({
      className: className
    }, other), React.createElement("div", {
      className: titleWrapClassName
    }, React.createElement("div", {
      className: classes.title
    }, title$$1), subtitle ? React.createElement("div", {
      className: classes.subtitle
    }, subtitle) : null), actionIcon ? React.createElement("div", {
      className: classnames(classes.actionIcon, defineProperty({}, classes.actionIconActionPosLeft, actionPos === 'left'))
    }, actionIcon) : null);
  }

  GridListTileBar.propTypes = {
    /**
     * An IconButton element to be used as secondary action target
     * (primary action target is the tile itself).
     */
    actionIcon: propTypes.node,

    /**
     * Position of secondary action IconButton.
     */
    actionPosition: propTypes.oneOf(['left', 'right']),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * String or element serving as subtitle (support text).
     */
    subtitle: propTypes.node,

    /**
     * Title to be displayed on tile.
     */
    title: propTypes.node,

    /**
     * Position of the title bar.
     */
    titlePosition: propTypes.oneOf(['top', 'bottom'])
  };
  GridListTileBar.defaultProps = {
    actionPosition: 'right',
    titlePosition: 'bottom'
  };
  var GridListTileBar$1 = withStyles(styles$O, {
    name: 'MuiGridListTileBar'
  })(GridListTileBar);

  function getScale(value) {
    return "scale(".concat(value, ", ").concat(Math.pow(value, 2), ")");
  }

  var styles$P = {
    entering: {
      opacity: 1,
      transform: getScale(1)
    },
    entered: {
      opacity: 1,
      // Use translateZ to scrolling issue on Chrome.
      transform: "".concat(getScale(1), " translateZ(0)")
    }
  };
  /**
   * The Grow transition is used by the [Tooltip](/demos/tooltips/) and
   * [Popover](/utils/popover/) components.
   * It uses [react-transition-group](https://github.com/reactjs/react-transition-group) internally.
   */

  var Grow =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Grow, _React$Component);

    function Grow() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Grow);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Grow)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.handleEnter = function (node) {
        var _this$props = _this.props,
            theme = _this$props.theme,
            timeout = _this$props.timeout;
        reflow(node); // So the animation always start from the start.

        var _getTransitionProps = getTransitionProps(_this.props, {
          mode: 'enter'
        }),
            transitionDuration = _getTransitionProps.duration,
            delay = _getTransitionProps.delay;

        var duration = 0;

        if (timeout === 'auto') {
          duration = theme.transitions.getAutoHeightDuration(node.clientHeight);
          _this.autoTimeout = duration;
        } else {
          duration = transitionDuration;
        }

        node.style.transition = [theme.transitions.create('opacity', {
          duration: duration,
          delay: delay
        }), theme.transitions.create('transform', {
          duration: duration * 0.666,
          delay: delay
        })].join(',');

        if (_this.props.onEnter) {
          _this.props.onEnter(node);
        }
      };

      _this.handleExit = function (node) {
        var _this$props2 = _this.props,
            theme = _this$props2.theme,
            timeout = _this$props2.timeout;
        var duration = 0;

        var _getTransitionProps2 = getTransitionProps(_this.props, {
          mode: 'exit'
        }),
            transitionDuration = _getTransitionProps2.duration,
            delay = _getTransitionProps2.delay;

        if (timeout === 'auto') {
          duration = theme.transitions.getAutoHeightDuration(node.clientHeight);
          _this.autoTimeout = duration;
        } else {
          duration = transitionDuration;
        }

        node.style.transition = [theme.transitions.create('opacity', {
          duration: duration,
          delay: delay
        }), theme.transitions.create('transform', {
          duration: duration * 0.666,
          delay: delay || duration * 0.333
        })].join(',');
        node.style.opacity = '0';
        node.style.transform = getScale(0.75);

        if (_this.props.onExit) {
          _this.props.onExit(node);
        }
      };

      _this.addEndListener = function (_, next) {
        if (_this.props.timeout === 'auto') {
          _this.timer = setTimeout(next, _this.autoTimeout || 0);
        }
      };

      return _this;
    }

    createClass(Grow, [{
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.timer);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props3 = this.props,
            children = _this$props3.children,
            onEnter = _this$props3.onEnter,
            onExit = _this$props3.onExit,
            styleProp = _this$props3.style,
            theme = _this$props3.theme,
            timeout = _this$props3.timeout,
            other = objectWithoutProperties(_this$props3, ["children", "onEnter", "onExit", "style", "theme", "timeout"]);

        var style = _extends_1({}, styleProp, React.isValidElement(children) ? children.props.style : {});

        return React.createElement(Transition, _extends_1({
          appear: true,
          onEnter: this.handleEnter,
          onExit: this.handleExit,
          addEndListener: this.addEndListener,
          timeout: timeout === 'auto' ? null : timeout
        }, other), function (state, childProps) {
          return React.cloneElement(children, _extends_1({
            style: _extends_1({
              opacity: 0,
              transform: getScale(0.75)
            }, styles$P[state], style)
          }, childProps));
        });
      }
    }]);

    return Grow;
  }(React.Component);

  Grow.propTypes = {
    /**
     * A single child content element.
     */
    children: propTypes.oneOfType([propTypes.element, propTypes.func]),

    /**
     * If `true`, show the component; triggers the enter or exit animation.
     */
    in: propTypes.bool,

    /**
     * @ignore
     */
    onEnter: propTypes.func,

    /**
     * @ignore
     */
    onExit: propTypes.func,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    timeout: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])])
  };
  Grow.defaultProps = {
    timeout: 'auto'
  };
  Grow.muiSupportAuto = true;
  var Grow$1 = withTheme()(Grow);

  var isWidthUp = function isWidthUp(breakpoint, width) {
    var inclusive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    if (inclusive) {
      return keys.indexOf(breakpoint) <= keys.indexOf(width);
    }

    return keys.indexOf(breakpoint) < keys.indexOf(width);
  }; // By default, returns true if screen width is the same or less than the given breakpoint.

  var isWidthDown = function isWidthDown(breakpoint, width) {
    var inclusive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    if (inclusive) {
      return keys.indexOf(width) <= keys.indexOf(breakpoint);
    }

    return keys.indexOf(width) < keys.indexOf(breakpoint);
  };

  var withWidth = function withWidth() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return function (Component) {
      var _options$withTheme = options.withTheme,
          withThemeOption = _options$withTheme === void 0 ? false : _options$withTheme,
          _options$noSSR = options.noSSR,
          noSSR = _options$noSSR === void 0 ? false : _options$noSSR,
          initialWidthOption = options.initialWidth,
          _options$resizeInterv = options.resizeInterval,
          resizeInterval = _options$resizeInterv === void 0 ? 166 : _options$resizeInterv;

      var WithWidth =
      /*#__PURE__*/
      function (_React$Component) {
        inherits(WithWidth, _React$Component);

        function WithWidth(props) {
          var _this;

          classCallCheck(this, WithWidth);

          _this = possibleConstructorReturn(this, getPrototypeOf(WithWidth).call(this, props));
          _this.state = {
            width: noSSR ? _this.getWidth() : undefined
          };

          if (typeof window !== 'undefined') {
            _this.handleResize = debounce_1(function () {
              var width2 = _this.getWidth();

              if (width2 !== _this.state.width) {
                _this.setState({
                  width: width2
                });
              }
            }, resizeInterval);
          }

          return _this;
        }

        createClass(WithWidth, [{
          key: "componentDidMount",
          value: function componentDidMount() {
            var width = this.getWidth();

            if (width !== this.state.width) {
              this.setState({
                width: width
              });
            }
          }
        }, {
          key: "componentWillUnmount",
          value: function componentWillUnmount() {
            this.handleResize.clear();
          }
        }, {
          key: "getWidth",
          value: function getWidth() {
            var innerWidth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.innerWidth;
            var breakpoints = this.props.theme.breakpoints;
            var width = null;
            /**
             * Start with the slowest value as low end devices often have a small screen.
             *
             * innerWidth |xs      sm      md      lg      xl
             *            |-------|-------|-------|-------|------>
             * width      |  xs   |  sm   |  md   |  lg   |  xl
             */

            var index = 1;

            while (width === null && index < keys.length) {
              var currentWidth = keys[index]; // @media are inclusive, so reproduce the behavior here.

              if (innerWidth < breakpoints.values[currentWidth]) {
                width = keys[index - 1];
                break;
              }

              index += 1;
            }

            width = width || 'xl';
            return width;
          }
        }, {
          key: "render",
          value: function render() {
            var _getThemeProps = getThemeProps({
              theme: this.props.theme,
              name: 'MuiWithWidth',
              props: _extends_1({}, this.props)
            }),
                initialWidth = _getThemeProps.initialWidth,
                theme = _getThemeProps.theme,
                width = _getThemeProps.width,
                other = objectWithoutProperties(_getThemeProps, ["initialWidth", "theme", "width"]);

            var more = _extends_1({
              width: width || this.state.width || initialWidth || initialWidthOption
            }, other); // When rendering the component on the server,
            // we have no idea about the client browser screen width.
            // In order to prevent blinks and help the reconciliation of the React tree
            // we are not rendering the child component.
            //
            // An alternative is to use the `initialWidth` property.


            if (more.width === undefined) {
              return null;
            }

            if (withThemeOption) {
              more.theme = theme;
            }

            return React.createElement(React.Fragment, null, React.createElement(Component, more), React.createElement(EventListener, {
              target: "window",
              onResize: this.handleResize
            }));
          }
        }]);

        return WithWidth;
      }(React.Component);

      WithWidth.propTypes = {
        /**
         * As `window.innerWidth` is unavailable on the server,
         * we default to rendering an empty component during the first mount.
         * You might want to use an heuristic to approximate
         * the screen width of the client browser screen width.
         *
         * For instance, you could be using the user-agent or the client-hints.
         * https://caniuse.com/#search=client%20hint
         */
        initialWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']),

        /**
         * @ignore
         */
        theme: propTypes.object.isRequired,

        /**
         * Bypass the width calculation logic.
         */
        width: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl'])
      };

      {
        WithWidth.displayName = "WithWidth(".concat(getDisplayName(Component), ")");
      }

      hoistNonReactStatics_cjs(WithWidth, Component);
      return withTheme()(WithWidth);
    };
  };

  /**
   * @ignore - internal component.
   */

  function HiddenJs(props) {
    var children = props.children,
        only = props.only,
        width = props.width;
    var visible = true; // `only` check is faster to get out sooner if used.

    if (only) {
      if (Array.isArray(only)) {
        for (var i = 0; i < only.length; i += 1) {
          var breakpoint = only[i];

          if (width === breakpoint) {
            visible = false;
            break;
          }
        }
      } else if (only && width === only) {
        visible = false;
      }
    } // Allow `only` to be combined with other props. If already hidden, no need to check others.


    if (visible) {
      // determine visibility based on the smallest size up
      for (var _i = 0; _i < keys.length; _i += 1) {
        var _breakpoint = keys[_i];
        var breakpointUp = props["".concat(_breakpoint, "Up")];
        var breakpointDown = props["".concat(_breakpoint, "Down")];

        if (breakpointUp && isWidthUp(_breakpoint, width) || breakpointDown && isWidthDown(_breakpoint, width)) {
          visible = false;
          break;
        }
      }
    }

    if (!visible) {
      return null;
    }

    return children;
  }

  HiddenJs.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Specify which implementation to use.  'js' is the default, 'css' works better for
     * server-side rendering.
     */
    implementation: propTypes.oneOf(['js', 'css']),

    /**
     * You can use this property when choosing the `js` implementation with server-side rendering.
     *
     * As `window.innerWidth` is unavailable on the server,
     * we default to rendering an empty component during the first mount.
     * You might want to use an heuristic to approximate
     * the screen width of the client browser screen width.
     *
     * For instance, you could be using the user-agent or the client-hints.
     * https://caniuse.com/#search=client%20hint
     */
    initialWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']),

    /**
     * If true, screens this size and down will be hidden.
     */
    lgDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    lgUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    mdDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    mdUp: propTypes.bool,

    /**
     * Hide the given breakpoint(s).
     */
    only: propTypes.oneOfType([propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']), propTypes.arrayOf(propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']))]),

    /**
     * If true, screens this size and down will be hidden.
     */
    smDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    smUp: propTypes.bool,

    /**
     * @ignore
     * width prop provided by withWidth decorator.
     */
    width: propTypes.string.isRequired,

    /**
     * If true, screens this size and down will be hidden.
     */
    xlDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xlUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xsDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xsUp: propTypes.bool
  };

  {
    HiddenJs.propTypes = exactProp(HiddenJs.propTypes);
  }

  var HiddenJs$1 = withWidth()(HiddenJs);

  var styles$Q = function styles(theme) {
    var hidden = {
      display: 'none'
    };
    return keys.reduce(function (acc, key) {
      acc["only".concat(capitalize(key))] = defineProperty({}, theme.breakpoints.only(key), hidden);
      acc["".concat(key, "Up")] = defineProperty({}, theme.breakpoints.up(key), hidden);
      acc["".concat(key, "Down")] = defineProperty({}, theme.breakpoints.down(key), hidden);
      return acc;
    }, {});
  };
  /**
   * @ignore - internal component.
   */


  function HiddenCss(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        lgDown = props.lgDown,
        lgUp = props.lgUp,
        mdDown = props.mdDown,
        mdUp = props.mdUp,
        only = props.only,
        smDown = props.smDown,
        smUp = props.smUp,
        xlDown = props.xlDown,
        xlUp = props.xlUp,
        xsDown = props.xsDown,
        xsUp = props.xsUp,
        other = objectWithoutProperties(props, ["children", "classes", "className", "lgDown", "lgUp", "mdDown", "mdUp", "only", "smDown", "smUp", "xlDown", "xlUp", "xsDown", "xsUp"]);

    warning_1(Object.keys(other).length === 0 || Object.keys(other).length === 1 && other.hasOwnProperty('ref'), "Material-UI: unsupported properties received ".concat(Object.keys(other).join(', '), " by `<Hidden />`."));
    var classNames = [];

    if (className) {
      classNames.push(className);
    }

    for (var i = 0; i < keys.length; i += 1) {
      var breakpoint = keys[i];
      var breakpointUp = props["".concat(breakpoint, "Up")];
      var breakpointDown = props["".concat(breakpoint, "Down")];

      if (breakpointUp) {
        classNames.push(classes["".concat(breakpoint, "Up")]);
      }

      if (breakpointDown) {
        classNames.push(classes["".concat(breakpoint, "Down")]);
      }
    }

    if (only) {
      var onlyBreakpoints = Array.isArray(only) ? only : [only];
      onlyBreakpoints.forEach(function (breakpoint) {
        classNames.push(classes["only".concat(capitalize(breakpoint))]);
      });
    }

    return React.createElement("div", {
      className: classNames.join(' ')
    }, children);
  }

  HiddenCss.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Specify which implementation to use.  'js' is the default, 'css' works better for
     * server-side rendering.
     */
    implementation: propTypes.oneOf(['js', 'css']),

    /**
     * If true, screens this size and down will be hidden.
     */
    lgDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    lgUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    mdDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    mdUp: propTypes.bool,

    /**
     * Hide the given breakpoint(s).
     */
    only: propTypes.oneOfType([propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']), propTypes.arrayOf(propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']))]),

    /**
     * If true, screens this size and down will be hidden.
     */
    smDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    smUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xlDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xlUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xsDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xsUp: propTypes.bool
  };
  var HiddenCss$1 = withStyles(styles$Q, {
    name: 'MuiPrivateHiddenCss'
  })(HiddenCss);

  /**
   * Responsively hides children based on the selected implementation.
   */

  function Hidden(props) {
    var implementation = props.implementation,
        other = objectWithoutProperties(props, ["implementation"]);

    if (implementation === 'js') {
      return React.createElement(HiddenJs$1, other);
    }

    return React.createElement(HiddenCss$1, other);
  }

  Hidden.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Specify which implementation to use.  'js' is the default, 'css' works better for
     * server-side rendering.
     */
    implementation: propTypes.oneOf(['js', 'css']),

    /**
     * You can use this property when choosing the `js` implementation with server-side rendering.
     *
     * As `window.innerWidth` is unavailable on the server,
     * we default to rendering an empty component during the first mount.
     * You might want to use an heuristic to approximate
     * the screen width of the client browser screen width.
     *
     * For instance, you could be using the user-agent or the client-hints.
     * https://caniuse.com/#search=client%20hint
     */
    initialWidth: propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']),

    /**
     * If true, screens this size and down will be hidden.
     */
    lgDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    lgUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    mdDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    mdUp: propTypes.bool,

    /**
     * Hide the given breakpoint(s).
     */
    only: propTypes.oneOfType([propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']), propTypes.arrayOf(propTypes.oneOf(['xs', 'sm', 'md', 'lg', 'xl']))]),

    /**
     * If true, screens this size and down will be hidden.
     */
    smDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    smUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xlDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xlUp: propTypes.bool,

    /**
     * If true, screens this size and down will be hidden.
     */
    xsDown: propTypes.bool,

    /**
     * If true, screens this size and up will be hidden.
     */
    xsUp: propTypes.bool
  };
  Hidden.defaultProps = {
    implementation: 'js',
    lgDown: false,
    lgUp: false,
    mdDown: false,
    mdUp: false,
    smDown: false,
    smUp: false,
    xlDown: false,
    xlUp: false,
    xsDown: false,
    xsUp: false
  };

  var styles$R = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        userSelect: 'none',
        fontSize: 24,
        width: '1em',
        height: '1em',
        // Chrome fix for https://bugs.chromium.org/p/chromium/issues/detail?id=820541
        // To remove at some point.
        overflow: 'hidden',
        flexShrink: 0
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        color: theme.palette.secondary.main
      },

      /* Styles applied to the root element if `color="action"`. */
      colorAction: {
        color: theme.palette.action.active
      },

      /* Styles applied to the root element if `color="error"`. */
      colorError: {
        color: theme.palette.error.main
      },

      /* Styles applied to the root element if `color="disabled"`. */
      colorDisabled: {
        color: theme.palette.action.disabled
      },
      fontSizeInherit: {
        fontSize: 'inherit'
      },

      /* Styles applied to the root element if `fontSize="small"`. */
      fontSizeSmall: {
        fontSize: 20
      },

      /* Styles applied to the root element if `fontSize="large"`. */
      fontSizeLarge: {
        fontSize: 36
      }
    };
  };

  function Icon(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        className = props.className,
        color = props.color,
        Component = props.component,
        fontSize = props.fontSize,
        other = objectWithoutProperties(props, ["children", "classes", "className", "color", "component", "fontSize"]);

    return React.createElement(Component, _extends_1({
      className: classnames('material-icons', classes.root, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'inherit'), defineProperty(_classNames, classes["fontSize".concat(capitalize(fontSize))], fontSize !== 'default'), _classNames), className),
      "aria-hidden": "true"
    }, other), children);
  }

  Icon.propTypes = {
    /**
     * The name of the icon font ligature.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['inherit', 'primary', 'secondary', 'action', 'error', 'disabled']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * The fontSize applied to the icon. Defaults to 24px, but can be configure to inherit font size.
     */
    fontSize: propTypes.oneOf(['inherit', 'default', 'small', 'large'])
  };
  Icon.defaultProps = {
    color: 'inherit',
    component: 'span',
    fontSize: 'default'
  };
  Icon.muiName = 'Icon';
  var Icon$1 = withStyles(styles$R, {
    name: 'MuiIcon'
  })(Icon);

  var styles$S = function styles(theme) {
    var light = theme.palette.type === 'light';
    var bottomLineColor = light ? 'rgba(0, 0, 0, 0.42)' : 'rgba(255, 255, 255, 0.7)';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative'
      },

      /* Styles applied to the root element if the component is a descendant of `FormControl`. */
      formControl: {
        'label + &': {
          marginTop: 16
        }
      },

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `disableUnderline={false}`. */
      underline: {
        '&:after': {
          borderBottom: "2px solid ".concat(theme.palette.primary[light ? 'dark' : 'light']),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '""',
          position: 'absolute',
          right: 0,
          transform: 'scaleX(0)',
          transition: theme.transitions.create('transform', {
            duration: theme.transitions.duration.shorter,
            easing: theme.transitions.easing.easeOut
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&$focused:after': {
          transform: 'scaleX(1)'
        },
        '&$error:after': {
          borderBottomColor: theme.palette.error.main,
          transform: 'scaleX(1)' // error is always underlined in red

        },
        '&:before': {
          borderBottom: "1px solid ".concat(bottomLineColor),
          left: 0,
          bottom: 0,
          // Doing the other way around crash on IE 11 "''" https://github.com/cssinjs/jss/issues/242
          content: '"\\00a0"',
          position: 'absolute',
          right: 0,
          transition: theme.transitions.create('border-bottom-color', {
            duration: theme.transitions.duration.shorter
          }),
          pointerEvents: 'none' // Transparent to the hover style.

        },
        '&:hover:not($disabled):not($focused):not($error):before': {
          borderBottom: "2px solid ".concat(theme.palette.text.primary),
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            borderBottom: "1px solid ".concat(bottomLineColor)
          }
        },
        '&$disabled:before': {
          borderBottomStyle: 'dotted'
        }
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {},

      /* Styles applied to the root element if `fullWidth={true}`. */
      fullWidth: {},

      /* Styles applied to the `input` element. */
      input: {},

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {},

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {},

      /* Styles applied to the `input` element if `type` is not "text"`. */
      inputType: {},

      /* Styles applied to the `input` element if `type="search"`. */
      inputTypeSearch: {}
    };
  };

  function Input(props) {
    var disableUnderline = props.disableUnderline,
        classes = props.classes,
        other = objectWithoutProperties(props, ["disableUnderline", "classes"]);

    return React.createElement(InputBase$1, _extends_1({
      classes: _extends_1({}, classes, {
        root: classnames(classes.root, defineProperty({}, classes.underline, !disableUnderline)),
        underline: null
      })
    }, other));
  }

  Input.propTypes = {
    /**
     * This property helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it here:
     * https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the input will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The default input value, useful when not controlling the component.
     */
    defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))]),

    /**
     * If `true`, the input will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the input will not have an underline.
     */
    disableUnderline: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: componentPropType,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     */
    onChange: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the input will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the input element. It should be a valid HTML5 input type.
     */
    type: propTypes.string,

    /**
     * The input value, required for a controlled component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))])
  };
  InputBase$1.defaultProps = {
    fullWidth: false,
    inputComponent: 'input',
    multiline: false,
    type: 'text'
  };
  Input.muiName = 'Input';
  var Input$1 = withStyles(styles$S, {
    name: 'MuiInput'
  })(Input);

  var styles$T = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      height: '0.01em',
      // Fix IE 11 flexbox alignment. To remove at some point.
      maxHeight: '2em',
      alignItems: 'center'
    },

    /* Styles applied to the root element if `variant="filled"`. */
    filled: {
      '&$positionStart': {
        marginTop: 16
      }
    },

    /* Styles applied to the root element if `position="start"`. */
    positionStart: {
      marginRight: 8
    },

    /* Styles applied to the root element if `position="end"`. */
    positionEnd: {
      marginLeft: 8
    },

    /* Styles applied to the root element if `disablePointerEvents=true`. */
    disablePointerEvents: {
      pointerEvents: 'none'
    }
  };

  function InputAdornment(props) {
    var _classNames;

    var children = props.children,
        Component = props.component,
        classes = props.classes,
        className = props.className,
        disablePointerEvents = props.disablePointerEvents,
        disableTypography = props.disableTypography,
        muiFormControl = props.muiFormControl,
        position = props.position,
        variantProp = props.variant,
        other = objectWithoutProperties(props, ["children", "component", "classes", "className", "disablePointerEvents", "disableTypography", "muiFormControl", "position", "variant"]);

    var variant = variantProp;

    if (variantProp && muiFormControl) {
      warning_1(variantProp !== muiFormControl.variant, 'Material-UI: The `InputAdornment` variant infers the variant property ' + 'you do not have to provide one.');
    }

    if (muiFormControl && !variant) {
      variant = muiFormControl.variant;
    }

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.filled, variant === 'filled'), defineProperty(_classNames, classes.positionStart, position === 'start'), defineProperty(_classNames, classes.positionEnd, position === 'end'), defineProperty(_classNames, classes.disablePointerEvents, disablePointerEvents), _classNames), className)
    }, other), typeof children === 'string' && !disableTypography ? React.createElement(Typography$1, {
      color: "textSecondary"
    }, children) : children);
  }

  InputAdornment.propTypes = {
    /**
     * The content of the component, normally an `IconButton` or string.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * Disable pointer events on the root.
     * This allows for the content of the adornment to focus the input on click.
     */
    disablePointerEvents: propTypes.bool,

    /**
     * If children is a string then disable wrapping in a Typography component.
     */
    disableTypography: propTypes.bool,

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * The position this adornment should appear relative to the `Input`.
     */
    position: propTypes.oneOf(['start', 'end']),

    /**
     * The variant to use.
     * Note: If you are using the `TextField` component or the `FormControl` component
     * you do not have to set this manually.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };
  InputAdornment.defaultProps = {
    component: 'div',
    disablePointerEvents: false,
    disableTypography: false
  };
  var InputAdornment$1 = withStyles(styles$T, {
    name: 'MuiInputAdornment'
  })(withFormControlContext(InputAdornment));

  var styles$U = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        transformOrigin: 'top left'
      },

      /* Styles applied to the root element if `focused={true}`. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `required={true}`. */
      required: {},

      /* Styles applied to the root element if the component is a descendant of `FormControl`. */
      formControl: {
        position: 'absolute',
        left: 0,
        top: 0,
        // slight alteration to spec spacing to match visual spec result
        transform: 'translate(0, 24px) scale(1)'
      },

      /* Styles applied to the root element if `margin="dense"`. */
      marginDense: {
        // Compensation for the `Input.inputDense` style.
        transform: 'translate(0, 21px) scale(1)'
      },

      /* Styles applied to the `input` element if `shrink={true}`. */
      shrink: {
        transform: 'translate(0, 1.5px) scale(0.75)',
        transformOrigin: 'top left'
      },

      /* Styles applied to the `input` element if `disableAnimation={false}`. */
      animated: {
        transition: theme.transitions.create(['color', 'transform'], {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        })
      },

      /* Styles applied to the root element if `variant="filled"`. */
      filled: {
        // Chrome's autofill feature gives the input field a yellow background.
        // Since the input field is behind the label in the HTML tree,
        // the input field is drawn last and hides the label with an opaque background color.
        // zIndex: 1 will raise the label above opaque background-colors of input.
        zIndex: 1,
        pointerEvents: 'none',
        transform: 'translate(12px, 20px) scale(1)',
        '&$marginDense': {
          transform: 'translate(12px, 17px) scale(1)'
        },
        '&$shrink': {
          transform: 'translate(12px, 10px) scale(0.75)',
          '&$marginDense': {
            transform: 'translate(12px, 7px) scale(0.75)'
          }
        }
      },

      /* Styles applied to the root element if `variant="outlined"`. */
      outlined: {
        // see comment above on filled.zIndex
        zIndex: 1,
        pointerEvents: 'none',
        transform: 'translate(14px, 20px) scale(1)',
        '&$marginDense': {
          transform: 'translate(14px, 17px) scale(1)'
        },
        '&$shrink': {
          transform: 'translate(14px, -6px) scale(0.75)'
        }
      }
    };
  };

  function InputLabel(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        disableAnimation = props.disableAnimation,
        FormLabelClasses = props.FormLabelClasses,
        margin = props.margin,
        muiFormControl = props.muiFormControl,
        shrinkProp = props.shrink,
        variant = props.variant,
        other = objectWithoutProperties(props, ["children", "classes", "className", "disableAnimation", "FormLabelClasses", "margin", "muiFormControl", "shrink", "variant"]);

    var shrink = shrinkProp;

    if (typeof shrink === 'undefined' && muiFormControl) {
      shrink = muiFormControl.filled || muiFormControl.focused || muiFormControl.adornedStart;
    }

    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['margin', 'variant']
    });
    var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.formControl, muiFormControl), defineProperty(_classNames, classes.animated, !disableAnimation), defineProperty(_classNames, classes.shrink, shrink), defineProperty(_classNames, classes.marginDense, fcs.margin === 'dense'), defineProperty(_classNames, classes.filled, fcs.variant === 'filled'), defineProperty(_classNames, classes.outlined, fcs.variant === 'outlined'), _classNames), classNameProp);
    return React.createElement(FormLabel$1, _extends_1({
      "data-shrink": shrink,
      className: className,
      classes: _extends_1({
        focused: classes.focused,
        disabled: classes.disabled,
        error: classes.error,
        required: classes.required
      }, FormLabelClasses)
    }, other), children);
  }

  InputLabel.propTypes = {
    /**
     * The contents of the `InputLabel`.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the transition animation is disabled.
     */
    disableAnimation: propTypes.bool,

    /**
     * If `true`, apply disabled class.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the label will be displayed in an error state.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input of this label is focused.
     */
    focused: propTypes.bool,

    /**
     * `classes` property applied to the [`FormLabel`](/api/form-label/) element.
     */
    FormLabelClasses: propTypes.object,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense']),

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * if `true`, the label will indicate that the input is required.
     */
    required: propTypes.bool,

    /**
     * If `true`, the label is shrunk.
     */
    shrink: propTypes.bool,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };
  InputLabel.defaultProps = {
    disableAnimation: false
  };
  var InputLabel$1 = withStyles(styles$U, {
    name: 'MuiInputLabel'
  })(withFormControlContext(InputLabel));

  var TRANSITION_DURATION = 4; // seconds

  var styles$V = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        overflow: 'hidden',
        height: 4
      },

      /* Styles applied to the root & bar2 element if `color="primary"`; bar2 if `variant-"buffer"`. */
      colorPrimary: {
        backgroundColor: lighten(theme.palette.primary.light, 0.6)
      },
      // eslint-disable-next-line max-len

      /* Styles applied to the root & bar2 elements if `color="secondary"`; bar2 if `variant="buffer"`. */
      colorSecondary: {
        backgroundColor: lighten(theme.palette.secondary.light, 0.4)
      },

      /* Styles applied to the root element if `variant="determinate"`. */
      determinate: {},

      /* Styles applied to the root element if `variant="indeterminate"`. */
      indeterminate: {},

      /* Styles applied to the root element if `variant="buffer"`. */
      buffer: {
        backgroundColor: 'transparent'
      },

      /* Styles applied to the root element if `variant="query"`. */
      query: {
        transform: 'rotate(180deg)'
      },

      /* Styles applied to the additional bar element if `variant="buffer"`. */
      dashed: {
        position: 'absolute',
        marginTop: 0,
        height: '100%',
        width: '100%',
        animation: 'buffer 3s infinite linear',
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$buffer'
      },

      /* Styles applied to the additional bar element if `variant="buffer"` & `color="primary"`. */
      dashedColorPrimary: {
        backgroundImage: "radial-gradient(".concat(lighten(theme.palette.primary.light, 0.6), " 0%, ").concat(lighten(theme.palette.primary.light, 0.6), " 16%, transparent 42%)"),
        backgroundSize: '10px 10px',
        backgroundPosition: '0px -23px'
      },

      /* Styles applied to the additional bar element if `variant="buffer"` & `color="secondary"`. */
      dashedColorSecondary: {
        backgroundImage: "radial-gradient(".concat(lighten(theme.palette.secondary.light, 0.4), " 0%, ").concat(lighten(theme.palette.secondary.light, 0.6), " 16%, transparent 42%)"),
        backgroundSize: '10px 10px',
        backgroundPosition: '0px -23px'
      },

      /* Styles applied to the layered bar1 & bar2 elements. */
      bar: {
        width: '100%',
        position: 'absolute',
        left: 0,
        bottom: 0,
        top: 0,
        transition: 'transform 0.2s linear',
        transformOrigin: 'left'
      },

      /* Styles applied to the bar elements if `color="primary"`; bar2 if `variant` not "buffer". */
      barColorPrimary: {
        backgroundColor: theme.palette.primary.main
      },

      /* Styles applied to the bar elements if `color="secondary"`; bar2 if `variant` not "buffer". */
      barColorSecondary: {
        backgroundColor: theme.palette.secondary.main
      },

      /* Styles applied to the bar1 element if `variant="indeterminate or query"`. */
      bar1Indeterminate: {
        width: 'auto',
        animation: 'mui-indeterminate1 2.1s cubic-bezier(0.65, 0.815, 0.735, 0.395) infinite',
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-indeterminate1'
      },

      /* Styles applied to the bar1 element if `variant="determinate"`. */
      bar1Determinate: {
        transition: "transform .".concat(TRANSITION_DURATION, "s linear")
      },

      /* Styles applied to the bar1 element if `variant="buffer"`. */
      bar1Buffer: {
        zIndex: 1,
        transition: "transform .".concat(TRANSITION_DURATION, "s linear")
      },

      /* Styles applied to the bar2 element if `variant="indeterminate or query"`. */
      bar2Indeterminate: {
        width: 'auto',
        animation: 'mui-indeterminate2 2.1s cubic-bezier(0.165, 0.84, 0.44, 1) infinite',
        // Backward compatible logic between JSS v9 and v10.
        // To remove with the release of Material-UI v4
        animationName: '$mui-indeterminate2',
        animationDelay: '1.15s'
      },

      /* Styles applied to the bar2 element if `variant="buffer"`. */
      bar2Buffer: {
        transition: "transform .".concat(TRANSITION_DURATION, "s linear")
      },
      // Legends:
      // || represents the viewport
      // -  represents a light background
      // x  represents a dark background
      '@keyframes mui-indeterminate1': {
        //  |-----|---x-||-----||-----|
        '0%': {
          left: '-35%',
          right: '100%'
        },
        //  |-----|-----||-----||xxxx-|
        '60%': {
          left: '100%',
          right: '-90%'
        },
        '100%': {
          left: '100%',
          right: '-90%'
        }
      },
      '@keyframes mui-indeterminate2': {
        //  |xxxxx|xxxxx||-----||-----|
        '0%': {
          left: '-200%',
          right: '100%'
        },
        //  |-----|-----||-----||-x----|
        '60%': {
          left: '107%',
          right: '-8%'
        },
        '100%': {
          left: '107%',
          right: '-8%'
        }
      },
      '@keyframes buffer': {
        '0%': {
          opacity: 1,
          backgroundPosition: '0px -23px'
        },
        '50%': {
          opacity: 0,
          backgroundPosition: '0px -23px'
        },
        '100%': {
          opacity: 1,
          backgroundPosition: '-200px -23px'
        }
      }
    };
  };
  /**
   * ## ARIA
   *
   * If the progress bar is describing the loading progress of a particular region of a page,
   * you should use `aria-describedby` to point to the progress bar, and set the `aria-busy`
   * attribute to `true` on that region until it has finished loading.
   */

  function LinearProgress(props) {
    var _classNames, _classNames2, _classNames3, _classNames4;

    var classes = props.classes,
        classNameProp = props.className,
        color = props.color,
        value = props.value,
        valueBuffer = props.valueBuffer,
        variant = props.variant,
        other = objectWithoutProperties(props, ["classes", "className", "color", "value", "valueBuffer", "variant"]);

    var className = classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.colorPrimary, color === 'primary'), defineProperty(_classNames, classes.colorSecondary, color === 'secondary'), defineProperty(_classNames, classes.determinate, variant === 'determinate'), defineProperty(_classNames, classes.indeterminate, variant === 'indeterminate'), defineProperty(_classNames, classes.buffer, variant === 'buffer'), defineProperty(_classNames, classes.query, variant === 'query'), _classNames), classNameProp);
    var dashedClass = classnames(classes.dashed, (_classNames2 = {}, defineProperty(_classNames2, classes.dashedColorPrimary, color === 'primary'), defineProperty(_classNames2, classes.dashedColorSecondary, color === 'secondary'), _classNames2));
    var bar1ClassName = classnames(classes.bar, (_classNames3 = {}, defineProperty(_classNames3, classes.barColorPrimary, color === 'primary'), defineProperty(_classNames3, classes.barColorSecondary, color === 'secondary'), defineProperty(_classNames3, classes.bar1Indeterminate, variant === 'indeterminate' || variant === 'query'), defineProperty(_classNames3, classes.bar1Determinate, variant === 'determinate'), defineProperty(_classNames3, classes.bar1Buffer, variant === 'buffer'), _classNames3));
    var bar2ClassName = classnames(classes.bar, (_classNames4 = {}, defineProperty(_classNames4, classes.barColorPrimary, color === 'primary' && variant !== 'buffer'), defineProperty(_classNames4, classes.colorPrimary, color === 'primary' && variant === 'buffer'), defineProperty(_classNames4, classes.barColorSecondary, color === 'secondary' && variant !== 'buffer'), defineProperty(_classNames4, classes.colorSecondary, color === 'secondary' && variant === 'buffer'), defineProperty(_classNames4, classes.bar2Indeterminate, variant === 'indeterminate' || variant === 'query'), defineProperty(_classNames4, classes.bar2Buffer, variant === 'buffer'), _classNames4));
    var rootProps = {};
    var inlineStyles = {
      bar1: {},
      bar2: {}
    };

    if (variant === 'determinate' || variant === 'buffer') {
      if (value !== undefined) {
        rootProps['aria-valuenow'] = Math.round(value);
        inlineStyles.bar1.transform = "scaleX(".concat(value / 100, ")");
      } else {
        warning_1(false, 'Material-UI: you need to provide a value property ' + 'when using the determinate or buffer variant of LinearProgress .');
      }
    }

    if (variant === 'buffer') {
      if (valueBuffer !== undefined) {
        inlineStyles.bar2.transform = "scaleX(".concat((valueBuffer || 0) / 100, ")");
      } else {
        warning_1(false, 'Material-UI: you need to provide a valueBuffer property ' + 'when using the buffer variant of LinearProgress.');
      }
    }

    return React.createElement("div", _extends_1({
      className: className,
      role: "progressbar"
    }, rootProps, other), variant === 'buffer' ? React.createElement("div", {
      className: dashedClass
    }) : null, React.createElement("div", {
      className: bar1ClassName,
      style: inlineStyles.bar1
    }), variant === 'determinate' ? null : React.createElement("div", {
      className: bar2ClassName,
      style: inlineStyles.bar2
    }));
  }

  LinearProgress.propTypes = {
    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary']),

    /**
     * The value of the progress indicator for the determinate and buffer variants.
     * Value between 0 and 100.
     */
    value: propTypes.number,

    /**
     * The value for the buffer variant.
     * Value between 0 and 100.
     */
    valueBuffer: propTypes.number,

    /**
     * The variant to use.
     * Use indeterminate or query when there is no progress value.
     */
    variant: propTypes.oneOf(['determinate', 'indeterminate', 'buffer', 'query'])
  };
  LinearProgress.defaultProps = {
    color: 'primary',
    variant: 'indeterminate'
  };
  var LinearProgress$1 = withStyles(styles$V, {
    name: 'MuiLinearProgress'
  })(LinearProgress);

  var styles$W = {
    /* Styles applied to the root element. */
    root: {},

    /* Styles applied to the root element if `underline="none"`. */
    underlineNone: {
      textDecoration: 'none'
    },

    /* Styles applied to the root element if `underline="hover"`. */
    underlineHover: {
      textDecoration: 'none',
      '&:hover': {
        textDecoration: 'underline'
      }
    },

    /* Styles applied to the root element if `underline="always"`. */
    underlineAlways: {
      textDecoration: 'underline'
    },
    // Same reset as ButtonBase.root

    /* Styles applied to the root element if `component="button"`. */
    button: {
      position: 'relative',
      // Remove grey highlight
      WebkitTapHighlightColor: 'transparent',
      backgroundColor: 'transparent',
      // Reset default value
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 'none',
      border: 0,
      margin: 0,
      // Remove the margin in Safari
      borderRadius: 0,
      padding: 0,
      // Remove the padding in Firefox
      cursor: 'pointer',
      userSelect: 'none',
      verticalAlign: 'middle',
      '-moz-appearance': 'none',
      // Reset
      '-webkit-appearance': 'none',
      // Reset
      '&::-moz-focus-inner': {
        borderStyle: 'none' // Remove Firefox dotted outline.

      }
    }
  };

  function Link(props) {
    var block = props.block,
        children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        component = props.component,
        TypographyClasses = props.TypographyClasses,
        underline = props.underline,
        other = objectWithoutProperties(props, ["block", "children", "classes", "className", "component", "TypographyClasses", "underline"]);

    return React.createElement(Typography$1, _extends_1({
      className: classnames(classes.root, defineProperty({}, classes.button, component === 'button'), classes["underline".concat(capitalize(underline))], classNameProp),
      classes: TypographyClasses,
      component: component,
      inline: !block
    }, other), children);
  }

  Link.propTypes = {
    /**
     *  Controls whether the link is inline or not. When `block` is true the link is not inline
     *  when `block` is false it is.
     */
    block: propTypes.bool,

    /**
     * The content of the link.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the link.
     */
    color: propTypes.oneOf(['error', 'inherit', 'primary', 'secondary', 'textPrimary', 'textSecondary']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * `classes` property applied to the [`Typography`](/api/typography/) element.
     */
    TypographyClasses: propTypes.object,

    /**
     *  Controls when the link should have an underline.
     */
    underline: propTypes.oneOf(['none', 'hover', 'always']),

    /**
     * Applies the theme typography styles.
     */
    variant: propTypes.string
  };
  Link.defaultProps = {
    block: false,
    color: 'primary',
    component: 'a',
    underline: 'hover',
    variant: 'inherit'
  };
  var Link$1 = withStyles(styles$W, {
    name: 'MuiLink'
  })(Link);

  /**
   * @ignore - internal component.
   */

  var ListContext = React.createContext({});

  var styles$X = {
    /* Styles applied to the root element. */
    root: {
      listStyle: 'none',
      margin: 0,
      padding: 0,
      position: 'relative'
    },

    /* Styles applied to the root element if `disablePadding={false}`. */
    padding: {
      paddingTop: 8,
      paddingBottom: 8
    },

    /* Styles applied to the root element if `dense={true}` & `disablePadding={false}`. */
    dense: {
      paddingTop: 4,
      paddingBottom: 4
    },

    /* Styles applied to the root element if a `subheader` is provided. */
    subheader: {
      paddingTop: 0
    }
  };

  function List(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        className = props.className,
        Component = props.component,
        dense = props.dense,
        disablePadding = props.disablePadding,
        subheader = props.subheader,
        other = objectWithoutProperties(props, ["children", "classes", "className", "component", "dense", "disablePadding", "subheader"]);

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.dense, dense && !disablePadding), defineProperty(_classNames, classes.padding, !disablePadding), defineProperty(_classNames, classes.subheader, subheader), _classNames), className)
    }, other), React.createElement(ListContext.Provider, {
      value: {
        dense: dense
      }
    }, subheader, children));
  }

  List.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, compact vertical padding designed for keyboard and mouse input will be used for
     * the list and list items. The property is available to descendant components as the
     * `dense` context.
     */
    dense: propTypes.bool,

    /**
     * If `true`, vertical padding will be removed from the list.
     */
    disablePadding: propTypes.bool,

    /**
     * The content of the subheader, normally `ListSubheader`.
     */
    subheader: propTypes.node
  };
  List.defaultProps = {
    component: 'ul',
    dense: false,
    disablePadding: false
  };
  var List$1 = withStyles(styles$X, {
    name: 'MuiList'
  })(List);

  /**
   * @ignore - internal component.
   *
   * Consumes a context and passes that context merged with its props.
   */

  function MergeListContext(props) {
    var alignItems = props.alignItems,
        children = props.children,
        dense = props.dense;
    return React.createElement(ListContext.Consumer, null, function (context) {
      var childContext = {
        dense: dense || context.dense || false,
        alignItems: alignItems
      };
      return React.createElement(ListContext.Provider, {
        value: childContext
      }, children(childContext));
    });
  }

  MergeListContext.propTypes = {
    alignItems: propTypes.oneOf(['flex-start', 'center']).isRequired,
    children: propTypes.func.isRequired,
    dense: propTypes.bool.isRequired
  };

  var styles$Y = function styles(theme) {
    return {
      /* Styles applied to the (normally root) `component` element. May be wrapped by a `container`. */
      root: {
        display: 'flex',
        justifyContent: 'flex-start',
        alignItems: 'center',
        position: 'relative',
        textDecoration: 'none',
        width: '100%',
        boxSizing: 'border-box',
        textAlign: 'left',
        paddingTop: 11,
        // To use 10px in v4
        paddingBottom: 11,
        // To use 10px in v4
        '&$selected, &$selected:hover, &$selected:focus': {
          backgroundColor: theme.palette.action.selected
        }
      },

      /* Styles applied to the `container` element if `children` includes `ListItemSecondaryAction`. */
      container: {
        position: 'relative'
      },
      // To remove in v4

      /* Styles applied to the `component`'s `focusVisibleClassName` property if `button={true}`. */
      focusVisible: {},

      /* Legacy styles applied to the root element. Use `root` instead. */
      default: {},

      /* Styles applied to the `component` element if `dense={true}` or `children` includes `Avatar`. */
      dense: {
        paddingTop: 8,
        paddingBottom: 8
      },

      /* Styles applied to the `component` element if `alignItems="flex-start"`. */
      alignItemsFlexStart: {
        alignItems: 'flex-start'
      },

      /* Styles applied to the inner `component` element if `disabled={true}`. */
      disabled: {
        opacity: 0.5
      },

      /* Styles applied to the inner `component` element if `divider={true}`. */
      divider: {
        borderBottom: "1px solid ".concat(theme.palette.divider),
        backgroundClip: 'padding-box'
      },

      /* Styles applied to the inner `component` element if `disableGutters={false}`. */
      gutters: {
        paddingLeft: 16,
        paddingRight: 16
      },

      /* Styles applied to the inner `component` element if `button={true}`. */
      button: {
        transition: theme.transitions.create('background-color', {
          duration: theme.transitions.duration.shortest
        }),
        '&:hover': {
          textDecoration: 'none',
          backgroundColor: theme.palette.action.hover,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            backgroundColor: 'transparent'
          }
        },
        '&:focus': {
          backgroundColor: theme.palette.action.hover
        }
      },

      /* Styles applied to the `component` element if `children` includes `ListItemSecondaryAction`. */
      secondaryAction: {
        // Add some space to avoid collision as `ListItemSecondaryAction`
        // is absolutely positioned.
        paddingRight: 32
      },

      /* Styles applied to the root element if `selected={true}`. */
      selected: {}
    };
  };
  /**
   * Uses an additional container component if `ListItemSecondaryAction` is the last child.
   */

  function ListItem(props) {
    var alignItems = props.alignItems,
        button = props.button,
        childrenProp = props.children,
        classes = props.classes,
        classNameProp = props.className,
        componentProp = props.component,
        ContainerComponent = props.ContainerComponent,
        _props$ContainerProps = props.ContainerProps;
    _props$ContainerProps = _props$ContainerProps === void 0 ? {} : _props$ContainerProps;

    var ContainerClassName = _props$ContainerProps.className,
        ContainerProps = objectWithoutProperties(_props$ContainerProps, ["className"]),
        denseProp = props.dense,
        disabled = props.disabled,
        disableGutters = props.disableGutters,
        divider = props.divider,
        focusVisibleClassName = props.focusVisibleClassName,
        selected = props.selected,
        other = objectWithoutProperties(props, ["alignItems", "button", "children", "classes", "className", "component", "ContainerComponent", "ContainerProps", "dense", "disabled", "disableGutters", "divider", "focusVisibleClassName", "selected"]);

    return React.createElement(MergeListContext, {
      dense: denseProp,
      alignItems: alignItems
    }, function (_ref) {
      var _classNames;

      var dense = _ref.dense;
      var children = React.Children.toArray(childrenProp);
      var hasAvatar = children.some(function (value) {
        return isMuiElement(value, ['ListItemAvatar']);
      });
      var hasSecondaryAction = children.length && isMuiElement(children[children.length - 1], ['ListItemSecondaryAction']);
      var className = classnames(classes.root, classes.default, (_classNames = {}, defineProperty(_classNames, classes.dense, dense || hasAvatar), defineProperty(_classNames, classes.gutters, !disableGutters), defineProperty(_classNames, classes.divider, divider), defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.button, button), defineProperty(_classNames, classes.alignItemsFlexStart, alignItems === 'flex-start'), defineProperty(_classNames, classes.secondaryAction, hasSecondaryAction), defineProperty(_classNames, classes.selected, selected), _classNames), classNameProp);

      var componentProps = _extends_1({
        className: className,
        disabled: disabled
      }, other);

      var Component = componentProp || 'li';

      if (button) {
        componentProps.component = componentProp || 'div';
        componentProps.focusVisibleClassName = classnames(classes.focusVisible, focusVisibleClassName);
        Component = ButtonBase$1;
      }

      if (hasSecondaryAction) {
        // Use div by default.
        Component = !componentProps.component && !componentProp ? 'div' : Component; // Avoid nesting of li > li.

        if (ContainerComponent === 'li') {
          if (Component === 'li') {
            Component = 'div';
          } else if (componentProps.component === 'li') {
            componentProps.component = 'div';
          }
        }

        return React.createElement(ContainerComponent, _extends_1({
          className: classnames(classes.container, ContainerClassName)
        }, ContainerProps), React.createElement(Component, componentProps, children), children.pop());
      }

      return React.createElement(Component, componentProps, children);
    });
  }

  ListItem.propTypes = {
    /**
     * Defines the `align-items` style property.
     */
    alignItems: propTypes.oneOf(['flex-start', 'center']),

    /**
     * If `true`, the list item will be a button (using `ButtonBase`).
     */
    button: propTypes.bool,

    /**
     * The content of the component. If a `ListItemSecondaryAction` is used it must
     * be the last child.
     */
    children: chainPropTypes(propTypes.node, function (props) {
      var children = React.Children.toArray(props.children); // React.Children.toArray(props.children).findLastIndex(isListItemSecondaryAction)

      var secondaryActionIndex = -1;

      for (var i = children.length - 1; i >= 0; i -= 1) {
        var child = children[i];

        if (isMuiElement(child, ['ListItemSecondaryAction'])) {
          secondaryActionIndex = i;
          break;
        }
      } //  is ListItemSecondaryAction the last child of ListItem


      if (secondaryActionIndex !== -1 && secondaryActionIndex !== children.length - 1) {
        return new Error('Material-UI: you used an element after ListItemSecondaryAction. ' + 'For ListItem to detect that it has a secondary action ' + "you must pass it has the last children to ListItem.".concat(''));
      }

      return null;
    }),

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     * By default, it's a `li` when `button` is `false` and a `div` when `button` is `true`.
     */
    component: componentPropType,

    /**
     * The container component used when a `ListItemSecondaryAction` is the last child.
     */
    ContainerComponent: componentPropType,

    /**
     * Properties applied to the container component if used.
     */
    ContainerProps: propTypes.object,

    /**
     * If `true`, compact vertical padding designed for keyboard and mouse input will be used.
     */
    dense: propTypes.bool,

    /**
     * If `true`, the list item will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the left and right padding is removed.
     */
    disableGutters: propTypes.bool,

    /**
     * If `true`, a 1px light border is added to the bottom of the list item.
     */
    divider: propTypes.bool,

    /**
     * @ignore
     */
    focusVisibleClassName: propTypes.string,

    /**
     * Use to apply selected styling.
     */
    selected: propTypes.bool
  };
  ListItem.defaultProps = {
    alignItems: 'center',
    button: false,
    ContainerComponent: 'li',
    dense: false,
    disabled: false,
    disableGutters: false,
    divider: false,
    selected: false
  };
  var ListItem$1 = withStyles(styles$Y, {
    name: 'MuiListItem'
  })(ListItem);

  var styles$Z = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        width: 36,
        height: 36,
        fontSize: theme.typography.pxToRem(18),
        marginRight: 4
      },

      /* Styles applied to the root element when. */
      alignItemsFlexStart: {
        marginTop: 4
      },

      /* Styles applied to the children – typically the `Avatar` component. */
      icon: {
        width: 20,
        height: 20,
        fontSize: theme.typography.pxToRem(20)
      }
    };
  };
  /**
   * This is a simple wrapper to apply the `dense`
   * and `align-items="flex-start"` mode styles to `Avatar`.
   */

  function ListItemAvatar(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        other = objectWithoutProperties(props, ["children", "classes", "className"]);

    return React.createElement(ListContext.Consumer, null, function (context) {
      var _classNames;

      return React.cloneElement(children, _extends_1({
        className: classnames((_classNames = {}, defineProperty(_classNames, classes.root, context.dense), defineProperty(_classNames, classes.alignItemsFlexStart, context.alignItems === 'flex-start'), _classNames), className, children.props.className),
        childrenClassName: classnames(defineProperty({}, classes.icon, context.dense), children.props.childrenClassName)
      }, other));
    });
  }

  ListItemAvatar.propTypes = {
    /**
     * The content of the component – normally `Avatar`.
     */
    children: propTypes.element.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  ListItemAvatar.muiName = 'ListItemAvatar';
  var ListItemAvatar$1 = withStyles(styles$Z, {
    name: 'MuiListItemAvatar'
  })(ListItemAvatar);

  var styles$_ = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        marginRight: 16,
        color: theme.palette.action.active,
        flexShrink: 0,
        display: 'inline-flex'
      }
    };
  };
  /**
   * A simple wrapper to apply `List` styles to an `Icon` or `SvgIcon`.
   */

  function ListItemIcon(props) {
    var children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        other = objectWithoutProperties(props, ["children", "classes", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, classNameProp)
    }, other), children);
  }

  ListItemIcon.propTypes = {
    /**
     * The content of the component, normally `Icon`, `SvgIcon`,
     * or a `@material-ui/icons` SVG icon element.
     */
    children: propTypes.element.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  var ListItemIcon$1 = withStyles(styles$_, {
    name: 'MuiListItemIcon'
  })(ListItemIcon);

  var styles$10 = {
    /* Styles applied to the root element. */
    root: {
      position: 'absolute',
      right: 4,
      top: '50%',
      transform: 'translateY(-50%)'
    }
  };
  /**
   * Must be used as the last child of ListItem to function properly.
   */

  function ListItemSecondaryAction(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        other = objectWithoutProperties(props, ["children", "classes", "className"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, className)
    }, other), children);
  }

  ListItemSecondaryAction.propTypes = {
    /**
     * The content of the component, normally an `IconButton` or selection control.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string
  };
  ListItemSecondaryAction.muiName = 'ListItemSecondaryAction';
  var ListItemSecondaryAction$1 = withStyles(styles$10, {
    name: 'MuiListItemSecondaryAction'
  })(ListItemSecondaryAction);

  var styles$11 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        flex: '1 1 auto',
        minWidth: 0,
        padding: '0 16px',
        '&:first-child': {
          paddingLeft: 0
        }
      },

      /* Styles applied to the root element if `inset={true}`. */
      inset: {
        '&:first-child': {
          paddingLeft: 56
        }
      },

      /* Styles applied to the root element if `context.dense` is `true`. */
      dense: {
        fontSize: theme.typography.pxToRem(13)
      },

      /* Styles applied to the primary `Typography` component. */
      primary: {
        '&$textDense': {
          fontSize: 'inherit'
        }
      },

      /* Styles applied to the secondary `Typography` component. */
      secondary: {
        '&$textDense': {
          fontSize: 'inherit'
        }
      },

      /* Styles applied to the `Typography` components if `context.dense` is `true`. */
      textDense: {}
    };
  };

  function ListItemText(props) {
    var children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        disableTypography = props.disableTypography,
        inset = props.inset,
        primaryProp = props.primary,
        primaryTypographyProps = props.primaryTypographyProps,
        secondaryProp = props.secondary,
        secondaryTypographyProps = props.secondaryTypographyProps,
        theme = props.theme,
        other = objectWithoutProperties(props, ["children", "classes", "className", "disableTypography", "inset", "primary", "primaryTypographyProps", "secondary", "secondaryTypographyProps", "theme"]);

    return React.createElement(ListContext.Consumer, null, function (_ref) {
      var _classNames3;

      var dense = _ref.dense;
      var primary = primaryProp != null ? primaryProp : children;

      if (primary != null && primary.type !== Typography$1 && !disableTypography) {
        primary = React.createElement(Typography$1, _extends_1({
          variant: theme.typography.useNextVariants ? 'body1' : 'subheading',
          className: classnames(classes.primary, defineProperty({}, classes.textDense, dense)),
          component: "span"
        }, primaryTypographyProps), primary);
      }

      var secondary = secondaryProp;

      if (secondary != null && secondary.type !== Typography$1 && !disableTypography) {
        secondary = React.createElement(Typography$1, _extends_1({
          className: classnames(classes.secondary, defineProperty({}, classes.textDense, dense)),
          color: "textSecondary"
        }, secondaryTypographyProps), secondary);
      }

      return React.createElement("div", _extends_1({
        className: classnames(classes.root, (_classNames3 = {}, defineProperty(_classNames3, classes.dense, dense), defineProperty(_classNames3, classes.inset, inset), _classNames3), classNameProp)
      }, other), primary, secondary);
    });
  }

  ListItemText.propTypes = {
    /**
     * Alias for the `primary` property.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the children won't be wrapped by a Typography component.
     * This can be useful to render an alternative Typography variant by wrapping
     * the `children` (or `primary`) text, and optional `secondary` text
     * with the Typography component.
     */
    disableTypography: propTypes.bool,

    /**
     * If `true`, the children will be indented.
     * This should be used if there is no left avatar or left icon.
     */
    inset: propTypes.bool,

    /**
     * The main content element.
     */
    primary: propTypes.node,

    /**
     * These props will be forwarded to the primary typography component
     * (as long as disableTypography is not `true`).
     */
    primaryTypographyProps: propTypes.object,

    /**
     * The secondary content element.
     */
    secondary: propTypes.node,

    /**
     * These props will be forwarded to the secondary typography component
     * (as long as disableTypography is not `true`).
     */
    secondaryTypographyProps: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired
  };
  ListItemText.defaultProps = {
    disableTypography: false,
    inset: false
  };
  var ListItemText$1 = withStyles(styles$11, {
    name: 'MuiListItemText',
    withTheme: true
  })(ListItemText);

  var styles$12 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        boxSizing: 'border-box',
        lineHeight: '48px',
        listStyle: 'none',
        color: theme.palette.text.secondary,
        fontFamily: theme.typography.fontFamily,
        fontWeight: theme.typography.fontWeightMedium,
        fontSize: theme.typography.pxToRem(14)
      },

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        color: theme.palette.primary.main
      },

      /* Styles applied to the root element if `color="inherit"`. */
      colorInherit: {
        color: 'inherit'
      },

      /* Styles applied to the inner `component` element if `disableGutters={false}`. */
      gutters: {
        paddingLeft: 16,
        paddingRight: 16
      },

      /* Styles applied to the root element if `inset={true}`. */
      inset: {
        paddingLeft: 72
      },

      /* Styles applied to the root element if `disableSticky={false}`. */
      sticky: {
        position: 'sticky',
        top: 0,
        zIndex: 1,
        backgroundColor: 'inherit'
      }
    };
  };

  function ListSubheader(props) {
    var _classNames;

    var classes = props.classes,
        className = props.className,
        color = props.color,
        Component = props.component,
        disableGutters = props.disableGutters,
        disableSticky = props.disableSticky,
        inset = props.inset,
        other = objectWithoutProperties(props, ["classes", "className", "color", "component", "disableGutters", "disableSticky", "inset"]);

    return React.createElement(Component, _extends_1({
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes["color".concat(capitalize(color))], color !== 'default'), defineProperty(_classNames, classes.inset, inset), defineProperty(_classNames, classes.sticky, !disableSticky), defineProperty(_classNames, classes.gutters, !disableGutters), _classNames), className)
    }, other));
  }

  ListSubheader.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['default', 'primary', 'inherit']),

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the List Subheader will not have gutters.
     */
    disableGutters: propTypes.bool,

    /**
     * If `true`, the List Subheader will not stick to the top during scroll.
     */
    disableSticky: propTypes.bool,

    /**
     * If `true`, the List Subheader will be indented.
     */
    inset: propTypes.bool
  };
  ListSubheader.defaultProps = {
    color: 'default',
    component: 'li',
    disableGutters: false,
    disableSticky: false,
    inset: false
  };
  ListSubheader.muiName = 'ListSubheader';
  var ListSubheader$1 = withStyles(styles$12, {
    name: 'MuiListSubheader'
  })(ListSubheader);

  function getOffsetTop(rect, vertical) {
    var offset = 0;

    if (typeof vertical === 'number') {
      offset = vertical;
    } else if (vertical === 'center') {
      offset = rect.height / 2;
    } else if (vertical === 'bottom') {
      offset = rect.height;
    }

    return offset;
  }

  function getOffsetLeft(rect, horizontal) {
    var offset = 0;

    if (typeof horizontal === 'number') {
      offset = horizontal;
    } else if (horizontal === 'center') {
      offset = rect.width / 2;
    } else if (horizontal === 'right') {
      offset = rect.width;
    }

    return offset;
  }

  function getTransformOriginValue(transformOrigin) {
    return [transformOrigin.horizontal, transformOrigin.vertical].map(function (n) {
      return typeof n === 'number' ? "".concat(n, "px") : n;
    }).join(' ');
  } // Sum the scrollTop between two elements.


  function getScrollParent(parent, child) {
    var element = child;
    var scrollTop = 0;

    while (element && element !== parent) {
      element = element.parentNode;
      scrollTop += element.scrollTop;
    }

    return scrollTop;
  }

  function getAnchorEl(anchorEl) {
    return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
  }

  var styles$13 = {
    /* Styles applied to the `Paper` component. */
    paper: {
      position: 'absolute',
      overflowY: 'auto',
      overflowX: 'hidden',
      // So we see the popover when it's empty.
      // It's most likely on issue on userland.
      minWidth: 16,
      minHeight: 16,
      maxWidth: 'calc(100% - 32px)',
      maxHeight: 'calc(100% - 32px)',
      // We disable the focus ring for mouse, touch and keyboard users.
      outline: 'none'
    }
  };

  var Popover =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Popover, _React$Component);

    function Popover() {
      var _this;

      classCallCheck(this, Popover);

      _this = possibleConstructorReturn(this, getPrototypeOf(Popover).call(this));
      _this.handleGetOffsetTop = getOffsetTop;
      _this.handleGetOffsetLeft = getOffsetLeft;

      _this.componentWillUnmount = function () {
        _this.handleResize.clear();
      };

      _this.setPositioningStyles = function (element) {
        var positioning = _this.getPositioningStyle(element);

        if (positioning.top !== null) {
          element.style.top = positioning.top;
        }

        if (positioning.left !== null) {
          element.style.left = positioning.left;
        }

        element.style.transformOrigin = positioning.transformOrigin;
      };

      _this.getPositioningStyle = function (element) {
        var _this$props = _this.props,
            anchorEl = _this$props.anchorEl,
            anchorReference = _this$props.anchorReference,
            marginThreshold = _this$props.marginThreshold; // Check if the parent has requested anchoring on an inner content node

        var contentAnchorOffset = _this.getContentAnchorOffset(element);

        var elemRect = {
          width: element.offsetWidth,
          height: element.offsetHeight
        }; // Get the transform origin point on the element itself

        var transformOrigin = _this.getTransformOrigin(elemRect, contentAnchorOffset);

        if (anchorReference === 'none') {
          return {
            top: null,
            left: null,
            transformOrigin: getTransformOriginValue(transformOrigin)
          };
        } // Get the offset of of the anchoring element


        var anchorOffset = _this.getAnchorOffset(contentAnchorOffset); // Calculate element positioning


        var top = anchorOffset.top - transformOrigin.vertical;
        var left = anchorOffset.left - transformOrigin.horizontal;
        var bottom = top + elemRect.height;
        var right = left + elemRect.width; // Use the parent window of the anchorEl if provided

        var containerWindow = ownerWindow(getAnchorEl(anchorEl)); // Window thresholds taking required margin into account

        var heightThreshold = containerWindow.innerHeight - marginThreshold;
        var widthThreshold = containerWindow.innerWidth - marginThreshold; // Check if the vertical axis needs shifting

        if (top < marginThreshold) {
          var diff = top - marginThreshold;
          top -= diff;
          transformOrigin.vertical += diff;
        } else if (bottom > heightThreshold) {
          var _diff = bottom - heightThreshold;

          top -= _diff;
          transformOrigin.vertical += _diff;
        }

        warning_1(elemRect.height < heightThreshold || !elemRect.height || !heightThreshold, ['Material-UI: the popover component is too tall.', "Some part of it can not be seen on the screen (".concat(elemRect.height - heightThreshold, "px)."), 'Please consider adding a `max-height` to improve the user-experience.'].join('\n')); // Check if the horizontal axis needs shifting

        if (left < marginThreshold) {
          var _diff2 = left - marginThreshold;

          left -= _diff2;
          transformOrigin.horizontal += _diff2;
        } else if (right > widthThreshold) {
          var _diff3 = right - widthThreshold;

          left -= _diff3;
          transformOrigin.horizontal += _diff3;
        }

        return {
          top: "".concat(top, "px"),
          left: "".concat(left, "px"),
          transformOrigin: getTransformOriginValue(transformOrigin)
        };
      };

      _this.handleEntering = function (element) {
        if (_this.props.onEntering) {
          _this.props.onEntering(element);
        }

        _this.setPositioningStyles(element);
      };

      if (typeof window !== 'undefined') {
        _this.handleResize = debounce_1(function () {
          // Because we debounce the event, the open property might no longer be true
          // when the callback resolves.
          if (!_this.props.open) {
            return;
          }

          _this.setPositioningStyles(_this.paperRef);
        }, 166); // Corresponds to 10 frames at 60 Hz.
      }

      return _this;
    }

    createClass(Popover, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.props.action) {
          this.props.action({
            updatePosition: this.handleResize
          });
        }
      }
    }, {
      key: "getAnchorOffset",
      // Returns the top/left offset of the position
      // to attach to on the anchor element (or body if none is provided)
      value: function getAnchorOffset(contentAnchorOffset) {
        var _this$props2 = this.props,
            anchorEl = _this$props2.anchorEl,
            anchorOrigin = _this$props2.anchorOrigin,
            anchorReference = _this$props2.anchorReference,
            anchorPosition = _this$props2.anchorPosition;

        if (anchorReference === 'anchorPosition') {
          warning_1(anchorPosition, 'Material-UI: you need to provide a `anchorPosition` property when using ' + '<Popover anchorReference="anchorPosition" />.');
          return anchorPosition;
        } // If an anchor element wasn't provided, just use the parent body element of this Popover


        var anchorElement = getAnchorEl(anchorEl) || ownerDocument(this.paperRef).body;
        var anchorRect = anchorElement.getBoundingClientRect();
        var anchorVertical = contentAnchorOffset === 0 ? anchorOrigin.vertical : 'center';
        return {
          top: anchorRect.top + this.handleGetOffsetTop(anchorRect, anchorVertical),
          left: anchorRect.left + this.handleGetOffsetLeft(anchorRect, anchorOrigin.horizontal)
        };
      } // Returns the vertical offset of inner content to anchor the transform on if provided

    }, {
      key: "getContentAnchorOffset",
      value: function getContentAnchorOffset(element) {
        var _this$props3 = this.props,
            getContentAnchorEl = _this$props3.getContentAnchorEl,
            anchorReference = _this$props3.anchorReference;
        var contentAnchorOffset = 0;

        if (getContentAnchorEl && anchorReference === 'anchorEl') {
          var contentAnchorEl = getContentAnchorEl(element);

          if (contentAnchorEl && element.contains(contentAnchorEl)) {
            var scrollTop = getScrollParent(element, contentAnchorEl);
            contentAnchorOffset = contentAnchorEl.offsetTop + contentAnchorEl.clientHeight / 2 - scrollTop || 0;
          } // != the default value


          warning_1(this.props.anchorOrigin.vertical === 'top', ['Material-UI: you can not change the default `anchorOrigin.vertical` value ', 'when also providing the `getContentAnchorEl` property to the popover component.', 'Only use one of the two properties.', 'Set `getContentAnchorEl` to `null | undefined`' + ' or leave `anchorOrigin.vertical` unchanged.'].join('\n'));
        }

        return contentAnchorOffset;
      } // Return the base transform origin using the element
      // and taking the content anchor offset into account if in use

    }, {
      key: "getTransformOrigin",
      value: function getTransformOrigin(elemRect) {
        var contentAnchorOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        var transformOrigin = this.props.transformOrigin;
        return {
          vertical: this.handleGetOffsetTop(elemRect, transformOrigin.vertical) + contentAnchorOffset,
          horizontal: this.handleGetOffsetLeft(elemRect, transformOrigin.horizontal)
        };
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props4 = this.props,
            action = _this$props4.action,
            anchorEl = _this$props4.anchorEl,
            anchorOrigin = _this$props4.anchorOrigin,
            anchorPosition = _this$props4.anchorPosition,
            anchorReference = _this$props4.anchorReference,
            children = _this$props4.children,
            classes = _this$props4.classes,
            containerProp = _this$props4.container,
            elevation = _this$props4.elevation,
            getContentAnchorEl = _this$props4.getContentAnchorEl,
            marginThreshold = _this$props4.marginThreshold,
            ModalClasses = _this$props4.ModalClasses,
            onEnter = _this$props4.onEnter,
            onEntered = _this$props4.onEntered,
            onEntering = _this$props4.onEntering,
            onExit = _this$props4.onExit,
            onExited = _this$props4.onExited,
            onExiting = _this$props4.onExiting,
            open = _this$props4.open,
            PaperProps = _this$props4.PaperProps,
            role = _this$props4.role,
            transformOrigin = _this$props4.transformOrigin,
            TransitionComponent = _this$props4.TransitionComponent,
            transitionDurationProp = _this$props4.transitionDuration,
            _this$props4$Transiti = _this$props4.TransitionProps,
            TransitionProps = _this$props4$Transiti === void 0 ? {} : _this$props4$Transiti,
            other = objectWithoutProperties(_this$props4, ["action", "anchorEl", "anchorOrigin", "anchorPosition", "anchorReference", "children", "classes", "container", "elevation", "getContentAnchorEl", "marginThreshold", "ModalClasses", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "open", "PaperProps", "role", "transformOrigin", "TransitionComponent", "transitionDuration", "TransitionProps"]);

        var transitionDuration = transitionDurationProp;

        if (transitionDurationProp === 'auto' && !TransitionComponent.muiSupportAuto) {
          transitionDuration = undefined;
        } // If the container prop is provided, use that
        // If the anchorEl prop is provided, use its parent body element as the container
        // If neither are provided let the Modal take care of choosing the container


        var container = containerProp || (anchorEl ? ownerDocument(getAnchorEl(anchorEl)).body : undefined);
        return React.createElement(Modal$1, _extends_1({
          classes: ModalClasses,
          container: container,
          open: open,
          BackdropProps: {
            invisible: true
          }
        }, other), React.createElement(TransitionComponent, _extends_1({
          appear: true,
          in: open,
          onEnter: onEnter,
          onEntered: onEntered,
          onExit: onExit,
          onExited: onExited,
          onExiting: onExiting,
          role: role,
          timeout: transitionDuration
        }, TransitionProps, {
          onEntering: createChainedFunction(this.handleEntering, TransitionProps.onEntering)
        }), React.createElement(Paper$1, _extends_1({
          className: classes.paper,
          elevation: elevation,
          ref: function ref(_ref) {
            _this2.paperRef = ReactDOM.findDOMNode(_ref);
          }
        }, PaperProps), React.createElement(EventListener, {
          target: "window",
          onResize: this.handleResize
        }), children)));
      }
    }]);

    return Popover;
  }(React.Component);

  Popover.propTypes = {
    /**
     * This is callback property. It's called by the component on mount.
     * This is useful when you want to trigger an action programmatically.
     * It currently only supports updatePosition() action.
     *
     * @param {object} actions This object contains all possible actions
     * that can be triggered programmatically.
     */
    action: propTypes.func,

    /**
     * This is the DOM element, or a function that returns the DOM element,
     * that may be used to set the position of the popover.
     */
    anchorEl: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * This is the point on the anchor where the popover's
     * `anchorEl` will attach to. This is not used when the
     * anchorReference is 'anchorPosition'.
     *
     * Options:
     * vertical: [top, center, bottom];
     * horizontal: [left, center, right].
     */
    anchorOrigin: propTypes.shape({
      horizontal: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['left', 'center', 'right'])]).isRequired,
      vertical: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['top', 'center', 'bottom'])]).isRequired
    }),

    /**
     * This is the position that may be used
     * to set the position of the popover.
     * The coordinates are relative to
     * the application's client area.
     */
    anchorPosition: propTypes.shape({
      left: propTypes.number.isRequired,
      top: propTypes.number.isRequired
    }),

    /*
     * This determines which anchor prop to refer to to set
     * the position of the popover.
     */
    anchorReference: propTypes.oneOf(['anchorEl', 'anchorPosition', 'none']),

    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will passed to the Modal component.
     * By default, it uses the body of the anchorEl's top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * The elevation of the popover.
     */
    elevation: propTypes.number,

    /**
     * This function is called in order to retrieve the content anchor element.
     * It's the opposite of the `anchorEl` property.
     * The content anchor element should be an element inside the popover.
     * It's used to correctly scroll and set the position of the popover.
     * The positioning strategy tries to make the content anchor element just above the
     * anchor element.
     */
    getContentAnchorEl: propTypes.func,

    /**
     * Specifies how close to the edge of the window the popover can appear.
     */
    marginThreshold: propTypes.number,

    /**
     * `classes` property applied to the [`Modal`](/api/modal/) element.
     */
    ModalClasses: propTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback.
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the component is entering.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the component has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the component is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired before the component is exiting.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the component has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the component is exiting.
     */
    onExiting: propTypes.func,

    /**
     * If `true`, the popover is visible.
     */
    open: propTypes.bool.isRequired,

    /**
     * Properties applied to the [`Paper`](/api/paper/) element.
     */
    PaperProps: propTypes.object,

    /**
     * @ignore
     */
    role: propTypes.string,

    /**
     * This is the point on the popover which
     * will attach to the anchor's origin.
     *
     * Options:
     * vertical: [top, center, bottom, x(px)];
     * horizontal: [left, center, right, x(px)].
     */
    transformOrigin: propTypes.shape({
      horizontal: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['left', 'center', 'right'])]).isRequired,
      vertical: propTypes.oneOfType([propTypes.number, propTypes.oneOf(['top', 'center', 'bottom'])]).isRequired
    }),

    /**
     * The component used for the transition.
     */
    TransitionComponent: componentPropType,

    /**
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])]),

    /**
     * Properties applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  };
  Popover.defaultProps = {
    anchorReference: 'anchorEl',
    anchorOrigin: {
      vertical: 'top',
      horizontal: 'left'
    },
    elevation: 8,
    marginThreshold: 16,
    transformOrigin: {
      vertical: 'top',
      horizontal: 'left'
    },
    TransitionComponent: Grow$1,
    transitionDuration: 'auto'
  };
  var Popover$1 = withStyles(styles$13, {
    name: 'MuiPopover'
  })(Popover);

  var MenuList =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(MenuList, _React$Component);

    function MenuList() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, MenuList);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(MenuList)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {
        currentTabIndex: null
      };

      _this.handleBlur = function (event) {
        _this.blurTimer = setTimeout(function () {
          if (_this.listRef) {
            var list = _this.listRef;
            var currentFocus = ownerDocument(list).activeElement;

            if (!list.contains(currentFocus)) {
              _this.resetTabIndex();
            }
          }
        }, 30);

        if (_this.props.onBlur) {
          _this.props.onBlur(event);
        }
      };

      _this.handleKeyDown = function (event) {
        var list = _this.listRef;
        var key = event.key;
        var currentFocus = ownerDocument(list).activeElement;

        if ((key === 'ArrowUp' || key === 'ArrowDown') && (!currentFocus || currentFocus && !list.contains(currentFocus))) {
          if (_this.selectedItemRef) {
            _this.selectedItemRef.focus();
          } else {
            list.firstChild.focus();
          }
        } else if (key === 'ArrowDown') {
          event.preventDefault();

          if (currentFocus.nextElementSibling) {
            currentFocus.nextElementSibling.focus();
          } else if (!_this.props.disableListWrap) {
            list.firstChild.focus();
          }
        } else if (key === 'ArrowUp') {
          event.preventDefault();

          if (currentFocus.previousElementSibling) {
            currentFocus.previousElementSibling.focus();
          } else if (!_this.props.disableListWrap) {
            list.lastChild.focus();
          }
        } else if (key === 'Home') {
          event.preventDefault();
          list.firstChild.focus();
        } else if (key === 'End') {
          event.preventDefault();
          list.lastChild.focus();
        }

        if (_this.props.onKeyDown) {
          _this.props.onKeyDown(event);
        }
      };

      _this.handleItemFocus = function (event) {
        var list = _this.listRef;

        if (list) {
          for (var i = 0; i < list.children.length; i += 1) {
            if (list.children[i] === event.currentTarget) {
              _this.setTabIndex(i);

              break;
            }
          }
        }
      };

      return _this;
    }

    createClass(MenuList, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.resetTabIndex();
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.blurTimer);
      }
    }, {
      key: "setTabIndex",
      value: function setTabIndex(index) {
        this.setState({
          currentTabIndex: index
        });
      }
    }, {
      key: "focus",
      value: function focus() {
        var currentTabIndex = this.state.currentTabIndex;
        var list = this.listRef;

        if (!list || !list.children || !list.firstChild) {
          return;
        }

        if (currentTabIndex && currentTabIndex >= 0) {
          list.children[currentTabIndex].focus();
        } else {
          list.firstChild.focus();
        }
      }
    }, {
      key: "resetTabIndex",
      value: function resetTabIndex() {
        var list = this.listRef;
        var currentFocus = ownerDocument(list).activeElement;
        var items = [];

        for (var i = 0; i < list.children.length; i += 1) {
          items.push(list.children[i]);
        }

        var currentFocusIndex = items.indexOf(currentFocus);

        if (currentFocusIndex !== -1) {
          return this.setTabIndex(currentFocusIndex);
        }

        if (this.selectedItemRef) {
          return this.setTabIndex(items.indexOf(this.selectedItemRef));
        }

        return this.setTabIndex(0);
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            children = _this$props.children,
            className = _this$props.className,
            onBlur = _this$props.onBlur,
            onKeyDown = _this$props.onKeyDown,
            disableListWrap = _this$props.disableListWrap,
            other = objectWithoutProperties(_this$props, ["children", "className", "onBlur", "onKeyDown", "disableListWrap"]);

        return React.createElement(List$1, _extends_1({
          role: "menu",
          ref: function ref(_ref) {
            _this2.listRef = ReactDOM.findDOMNode(_ref);
          },
          className: className,
          onKeyDown: this.handleKeyDown,
          onBlur: this.handleBlur
        }, other), React.Children.map(children, function (child, index) {
          if (!React.isValidElement(child)) {
            return null;
          }

          warning_1(child.type !== React.Fragment, ["Material-UI: the MenuList component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
          return React.cloneElement(child, {
            tabIndex: index === _this2.state.currentTabIndex ? 0 : -1,
            ref: child.props.selected ? function (ref) {
              _this2.selectedItemRef = ReactDOM.findDOMNode(ref);
            } : undefined,
            onFocus: _this2.handleItemFocus
          });
        }));
      }
    }]);

    return MenuList;
  }(React.Component);

  MenuList.propTypes = {
    /**
     * MenuList contents, normally `MenuItem`s.
     */
    children: propTypes.node,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * If `true`, the menu items will not wrap focus.
     */
    disableListWrap: propTypes.bool,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func
  };
  MenuList.defaultProps = {
    disableListWrap: false
  };

  var RTL_ORIGIN = {
    vertical: 'top',
    horizontal: 'right'
  };
  var LTR_ORIGIN = {
    vertical: 'top',
    horizontal: 'left'
  };
  var styles$14 = {
    /* Styles applied to the `Paper` component. */
    paper: {
      // specZ: The maximum height of a simple menu should be one or more rows less than the view
      // height. This ensures a tapable area outside of the simple menu with which to dismiss
      // the menu.
      maxHeight: 'calc(100% - 96px)',
      // Add iOS momentum scrolling.
      WebkitOverflowScrolling: 'touch'
    }
  };

  var Menu =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Menu, _React$Component);

    function Menu() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Menu);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Menu)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.getContentAnchorEl = function () {
        if (_this.menuListRef.selectedItemRef) {
          return ReactDOM.findDOMNode(_this.menuListRef.selectedItemRef);
        }

        return ReactDOM.findDOMNode(_this.menuListRef).firstChild;
      };

      _this.focus = function () {
        if (_this.menuListRef && _this.menuListRef.selectedItemRef) {
          ReactDOM.findDOMNode(_this.menuListRef.selectedItemRef).focus();
          return;
        }

        var menuList = ReactDOM.findDOMNode(_this.menuListRef);

        if (menuList && menuList.firstChild) {
          menuList.firstChild.focus();
        }
      };

      _this.handleMenuListRef = function (ref) {
        _this.menuListRef = ref;
      };

      _this.handleEntering = function (element) {
        var _this$props = _this.props,
            disableAutoFocusItem = _this$props.disableAutoFocusItem,
            theme = _this$props.theme;
        var menuList = ReactDOM.findDOMNode(_this.menuListRef); // Focus so the scroll computation of the Popover works as expected.

        if (disableAutoFocusItem !== true) {
          _this.focus();
        } // Let's ignore that piece of logic if users are already overriding the width
        // of the menu.


        if (menuList && element.clientHeight < menuList.clientHeight && !menuList.style.width) {
          var size = "".concat(getScrollbarSize(), "px");
          menuList.style[theme.direction === 'rtl' ? 'paddingLeft' : 'paddingRight'] = size;
          menuList.style.width = "calc(100% + ".concat(size, ")");
        }

        if (_this.props.onEntering) {
          _this.props.onEntering(element);
        }
      };

      _this.handleListKeyDown = function (event) {
        if (event.key === 'Tab') {
          event.preventDefault();

          if (_this.props.onClose) {
            _this.props.onClose(event, 'tabKeyDown');
          }
        }
      };

      return _this;
    }

    createClass(Menu, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.props.open && this.props.disableAutoFocusItem !== true) {
          this.focus();
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props2 = this.props,
            children = _this$props2.children,
            classes = _this$props2.classes,
            disableAutoFocusItem = _this$props2.disableAutoFocusItem,
            MenuListProps = _this$props2.MenuListProps,
            onEntering = _this$props2.onEntering,
            _this$props2$PaperPro = _this$props2.PaperProps,
            PaperProps = _this$props2$PaperPro === void 0 ? {} : _this$props2$PaperPro,
            PopoverClasses = _this$props2.PopoverClasses,
            theme = _this$props2.theme,
            other = objectWithoutProperties(_this$props2, ["children", "classes", "disableAutoFocusItem", "MenuListProps", "onEntering", "PaperProps", "PopoverClasses", "theme"]);

        return React.createElement(Popover$1, _extends_1({
          getContentAnchorEl: this.getContentAnchorEl,
          classes: PopoverClasses,
          onEntering: this.handleEntering,
          anchorOrigin: theme.direction === 'rtl' ? RTL_ORIGIN : LTR_ORIGIN,
          transformOrigin: theme.direction === 'rtl' ? RTL_ORIGIN : LTR_ORIGIN,
          PaperProps: _extends_1({}, PaperProps, {
            classes: _extends_1({}, PaperProps.classes, {
              root: classes.paper
            })
          })
        }, other), React.createElement(MenuList, _extends_1({
          onKeyDown: this.handleListKeyDown
        }, MenuListProps, {
          ref: this.handleMenuListRef
        }), children));
      }
    }]);

    return Menu;
  }(React.Component);

  Menu.propTypes = {
    /**
     * The DOM element used to set the position of the menu.
     */
    anchorEl: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * Menu contents, normally `MenuItem`s.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * If `true`, the selected / first menu item will not be auto focused.
     */
    disableAutoFocusItem: propTypes.bool,

    /**
     * Properties applied to the [`MenuList`](/api/menu-list/) element.
     */
    MenuListProps: propTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback
     * @param {string} reason Can be:`"escapeKeyDown"`, `"backdropClick"`, `"tabKeyDown"`
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the Menu enters.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the Menu has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the Menu is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired before the Menu exits.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the Menu has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the Menu is exiting.
     */
    onExiting: propTypes.func,

    /**
     * If `true`, the menu is visible.
     */
    open: propTypes.bool.isRequired,

    /**
     * @ignore
     */
    PaperProps: propTypes.object,

    /**
     * `classes` property applied to the [`Popover`](/api/popover/) element.
     */
    PopoverClasses: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The length of the transition in `ms`, or 'auto'
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])])
  };
  Menu.defaultProps = {
    disableAutoFocusItem: false,
    transitionDuration: 'auto'
  };
  var Menu$1 = withStyles(styles$14, {
    name: 'MuiMenu',
    withTheme: true
  })(Menu);

  var styles$15 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends_1({}, theme.typography.subheading, {
        height: 24,
        boxSizing: 'content-box',
        width: 'auto',
        overflow: 'hidden',
        whiteSpace: 'nowrap',
        '&$selected': {}
      }),

      /* Styles applied to the root element if `disableGutters={false}`. */
      gutters: {
        paddingLeft: 16,
        paddingRight: 16
      },

      /* Styles applied to the root element if `selected={true}`. */
      selected: {}
    };
  };

  function MenuItem(props) {
    var _classNames;

    var classes = props.classes,
        className = props.className,
        component = props.component,
        disableGutters = props.disableGutters,
        role = props.role,
        selected = props.selected,
        other = objectWithoutProperties(props, ["classes", "className", "component", "disableGutters", "role", "selected"]);

    return React.createElement(ListItem$1, _extends_1({
      button: true,
      role: role,
      tabIndex: -1,
      component: component,
      selected: selected,
      disableGutters: disableGutters,
      className: classnames(classes.root, (_classNames = {}, defineProperty(_classNames, classes.selected, selected), defineProperty(_classNames, classes.gutters, !disableGutters), _classNames), className)
    }, other));
  }

  MenuItem.propTypes = {
    /**
     * Menu item contents.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The component used for the root node.
     * Either a string to use a DOM element or a component.
     */
    component: componentPropType,

    /**
     * If `true`, the left and right padding is removed.
     */
    disableGutters: propTypes.bool,

    /**
     * @ignore
     */
    role: propTypes.string,

    /**
     * @ignore
     */
    selected: propTypes.bool
  };
  MenuItem.defaultProps = {
    component: 'li',
    disableGutters: false,
    role: 'menuitem'
  };
  var MenuItem$1 = withStyles(styles$15, {
    name: 'MuiMenuItem'
  })(MenuItem);

  var styles$16 = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
        background: theme.palette.background.default,
        padding: 8
      },

      /* Styles applied to the root element if `position="bottom"`. */
      positionBottom: {
        position: 'fixed',
        bottom: 0,
        left: 0,
        right: 0,
        zIndex: theme.zIndex.mobileStepper
      },

      /* Styles applied to the root element if `position="top"`. */
      positionTop: {
        position: 'fixed',
        top: 0,
        left: 0,
        right: 0,
        zIndex: theme.zIndex.mobileStepper
      },

      /* Styles applied to the root element if `position="static"`. */
      positionStatic: {},

      /* Styles applied to the dots container if `variant="dots"`. */
      dots: {
        display: 'flex',
        flexDirection: 'row'
      },

      /* Styles applied to each dot if `variant="dots"`. */
      dot: {
        backgroundColor: theme.palette.action.disabled,
        borderRadius: '50%',
        width: 8,
        height: 8,
        margin: '0 2px'
      },

      /* Styles applied to a dot if `variant="dots"` and this is the active step. */
      dotActive: {
        backgroundColor: theme.palette.primary.main
      },

      /* Styles applied to the Linear Progress component if `variant="progress"`. */
      progress: {
        width: '50%'
      }
    };
  };

  function MobileStepper(props) {
    var activeStep = props.activeStep,
        backButton = props.backButton,
        classes = props.classes,
        classNameProp = props.className,
        LinearProgressProps = props.LinearProgressProps,
        nextButton = props.nextButton,
        position = props.position,
        steps = props.steps,
        variant = props.variant,
        other = objectWithoutProperties(props, ["activeStep", "backButton", "classes", "className", "LinearProgressProps", "nextButton", "position", "steps", "variant"]);

    var className = classnames(classes.root, classes["position".concat(capitalize(position))], classNameProp);
    return React.createElement(Paper$1, _extends_1({
      square: true,
      elevation: 0,
      className: className
    }, other), backButton, variant === 'dots' && React.createElement("div", {
      className: classes.dots
    }, toConsumableArray(new Array(steps)).map(function (_, step) {
      var dotClassName = classnames(classes.dot, defineProperty({}, classes.dotActive, step === activeStep)); // eslint-disable-next-line react/no-array-index-key

      return React.createElement("div", {
        key: step,
        className: dotClassName
      });
    })), variant === 'progress' && React.createElement(LinearProgress$1, _extends_1({
      className: classes.progress,
      variant: "determinate",
      value: Math.ceil(activeStep / (steps - 1) * 100)
    }, LinearProgressProps)), nextButton);
  }

  MobileStepper.propTypes = {
    /**
     * Set the active step (zero based index).
     * Defines which dot is highlighted when the variant is 'dots'.
     */
    activeStep: propTypes.number,

    /**
     * A back button element. For instance, it can be a `Button` or an `IconButton`.
     */
    backButton: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Properties applied to the `LinearProgress` element.
     */
    LinearProgressProps: propTypes.object,

    /**
     * A next button element. For instance, it can be a `Button` or an `IconButton`.
     */
    nextButton: propTypes.node,

    /**
     * Set the positioning type.
     */
    position: propTypes.oneOf(['bottom', 'top', 'static']),

    /**
     * The total steps.
     */
    steps: propTypes.number.isRequired,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['text', 'dots', 'progress'])
  };
  MobileStepper.defaultProps = {
    activeStep: 0,
    position: 'bottom',
    variant: 'dots'
  };
  var MobileStepper$1 = withStyles(styles$16, {
    name: 'MuiMobileStepper'
  })(MobileStepper);

  /**
   * @ignore - internal component.
   */

  function NativeSelectInput(props) {
    var _classNames;

    var children = props.children,
        classes = props.classes,
        className = props.className,
        disabled = props.disabled,
        IconComponent = props.IconComponent,
        inputRef = props.inputRef,
        name = props.name,
        onChange = props.onChange,
        value = props.value,
        variant = props.variant,
        other = objectWithoutProperties(props, ["children", "classes", "className", "disabled", "IconComponent", "inputRef", "name", "onChange", "value", "variant"]);

    return React.createElement("div", {
      className: classes.root
    }, React.createElement("select", _extends_1({
      className: classnames(classes.select, (_classNames = {}, defineProperty(_classNames, classes.filled, variant === 'filled'), defineProperty(_classNames, classes.outlined, variant === 'outlined'), defineProperty(_classNames, classes.disabled, disabled), _classNames), className),
      name: name,
      disabled: disabled,
      onChange: onChange,
      value: value,
      ref: inputRef
    }, other), children), React.createElement(IconComponent, {
      className: classes.icon
    }));
  }

  NativeSelectInput.propTypes = {
    /**
     * The option elements to populate the select with.
     * Can be some `<option>` elements.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the select element.
     */
    className: propTypes.string,

    /**
     * If `true`, the select will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: componentPropType,

    /**
     * Use that property to pass a ref callback to the native select element.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * Name attribute of the `select` or hidden `input` element.
     */
    name: propTypes.string,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     */
    onChange: propTypes.func,

    /**
     * The input value.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool]))]),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };

  /**
   * @ignore - internal component.
   */

  var _ref$4 = React.createElement("path", {
    d: "M7 10l5 5 5-5z"
  });

  var ArrowDropDown = function ArrowDropDown(props) {
    return React.createElement(SvgIcon$1, props, _ref$4);
  };

  ArrowDropDown = pure(ArrowDropDown);
  ArrowDropDown.muiName = 'SvgIcon';
  var ArrowDropDownIcon = ArrowDropDown;

  var styles$17 = function styles(theme) {
    return {
      /* Styles applied to the `Input` component `root` class. */
      root: {
        position: 'relative',
        width: '100%'
      },

      /* Styles applied to the `Input` component `select` class. */
      select: {
        '-moz-appearance': 'none',
        // Reset
        '-webkit-appearance': 'none',
        // Reset
        // When interacting quickly, the text can end up selected.
        // Native select can't be selected either.
        userSelect: 'none',
        paddingRight: 32,
        borderRadius: 0,
        // Reset
        height: '1.1875em',
        // Reset (19px), match the native input line-height
        width: 'calc(100% - 32px)',
        minWidth: 16,
        // So it doesn't collapse.
        cursor: 'pointer',
        '&:focus': {
          // Show that it's not an text input
          backgroundColor: theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.05)' : 'rgba(255, 255, 255, 0.05)',
          borderRadius: 0 // Reset Chrome style

        },
        // Remove IE 11 arrow
        '&::-ms-expand': {
          display: 'none'
        },
        '&$disabled': {
          cursor: 'default'
        },
        '&[multiple]': {
          height: 'auto'
        },
        '&:not([multiple]) option, &:not([multiple]) optgroup': {
          backgroundColor: theme.palette.background.paper
        }
      },

      /* Styles applied to the `Input` component if `variant="filled"`. */
      filled: {
        width: 'calc(100% - 44px)'
      },

      /* Styles applied to the `Input` component if `variant="outlined"`. */
      outlined: {
        width: 'calc(100% - 46px)',
        borderRadius: theme.shape.borderRadius
      },

      /* Styles applied to the `Input` component `selectMenu` class. */
      selectMenu: {
        width: 'auto',
        // Fix Safari textOverflow
        height: 'auto',
        // Reset
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        overflow: 'hidden',
        minHeight: '1.1875em' // Reset (19px), match the native input line-height

      },

      /* Styles applied to the `Input` component `disabled` class. */
      disabled: {},

      /* Styles applied to the `Input` component `icon` class. */
      icon: {
        // We use a position absolute over a flexbox in order to forward the pointer events
        // to the input.
        position: 'absolute',
        right: 0,
        top: 'calc(50% - 12px)',
        // Center vertically
        color: theme.palette.action.active,
        'pointer-events': 'none' // Don't block pointer events on the select under the icon.

      }
    };
  };
  /**
   * An alternative to `<Select native />` with a much smaller bundle size footprint.
   */

  function NativeSelect(props) {
    var children = props.children,
        classes = props.classes,
        IconComponent = props.IconComponent,
        input = props.input,
        inputProps = props.inputProps,
        muiFormControl = props.muiFormControl,
        variant = props.variant,
        other = objectWithoutProperties(props, ["children", "classes", "IconComponent", "input", "inputProps", "muiFormControl", "variant"]);

    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['variant']
    });
    return React.cloneElement(input, _extends_1({
      // Most of the logic is implemented in `NativeSelectInput`.
      // The `Select` component is a simple API wrapper to expose something better to play with.
      inputComponent: NativeSelectInput,
      inputProps: _extends_1({
        children: children,
        classes: classes,
        IconComponent: IconComponent,
        variant: fcs.variant,
        type: undefined
      }, inputProps, input ? input.props.inputProps : {})
    }, other));
  }

  NativeSelect.propTypes = {
    /**
     * The option elements to populate the select with.
     * Can be some `<option>` elements.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: componentPropType,

    /**
     * An `Input` element; does not have to be a material-ui specific `Input`.
     */
    input: propTypes.element,

    /**
     * Attributes applied to the `select` element.
     */
    inputProps: propTypes.object,

    /**
     * @ignore
     */
    muiFormControl: propTypes.object,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     */
    onChange: propTypes.func,

    /**
     * The input value.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool]))]),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };
  NativeSelect.defaultProps = {
    IconComponent: ArrowDropDownIcon,
    input: React.createElement(Input$1, null)
  };
  NativeSelect.muiName = 'Select';
  var NativeSelect$1 = withStyles(styles$17, {
    name: 'MuiNativeSelect'
  })(withFormControlContext(NativeSelect));

  var styles$18 = function styles(theme) {
    var align = theme.direction === 'rtl' ? 'right' : 'left';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'absolute',
        bottom: 0,
        right: 0,
        top: -5,
        left: 0,
        margin: 0,
        padding: 0,
        pointerEvents: 'none',
        borderRadius: theme.shape.borderRadius,
        borderStyle: 'solid',
        borderWidth: 1,
        // Match the Input Label
        transition: theme.transitions.create(["padding-".concat(align), 'border-color', 'border-width'], {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        })
      },

      /* Styles applied to the legend element. */
      legend: {
        textAlign: 'left',
        padding: 0,
        lineHeight: '11px',
        transition: theme.transitions.create('width', {
          duration: theme.transitions.duration.shorter,
          easing: theme.transitions.easing.easeOut
        })
      }
    };
  };
  /**
   * @ignore - internal component.
   */

  function NotchedOutline(props) {
    var children = props.children,
        classes = props.classes,
        className = props.className,
        labelWidthProp = props.labelWidth,
        notched = props.notched,
        style = props.style,
        theme = props.theme,
        other = objectWithoutProperties(props, ["children", "classes", "className", "labelWidth", "notched", "style", "theme"]);

    var align = theme.direction === 'rtl' ? 'right' : 'left';
    var labelWidth = labelWidthProp > 0 ? labelWidthProp * 0.75 + 8 : 0;
    return React.createElement("fieldset", _extends_1({
      "aria-hidden": true,
      style: _extends_1(defineProperty({}, "padding".concat(capitalize(align)), 8 + (notched ? 0 : labelWidth / 2)), style),
      className: classnames(classes.root, className)
    }, other), React.createElement("legend", {
      className: classes.legend,
      style: {
        // IE 11: fieldset with legend does not render
        // a border radius. This maintains consistency
        // by always having a legend rendered
        width: notched ? labelWidth : 0.01
      }
    }, React.createElement("span", {
      dangerouslySetInnerHTML: {
        __html: '&#8203;'
      }
    })));
  }

  NotchedOutline.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The width of the legend.
     */
    labelWidth: propTypes.number.isRequired,

    /**
     * If `true`, the outline is notched to accommodate the label.
     */
    notched: propTypes.bool.isRequired,

    /**
     * @ignore
     */
    style: propTypes.object,

    /**
     * @ignore
     */
    theme: propTypes.object
  };
  var NotchedOutline$1 = withStyles(styles$18, {
    name: 'MuiPrivateNotchedOutline',
    withTheme: true
  })(NotchedOutline);

  var styles$19 = function styles(theme) {
    var borderColor = theme.palette.type === 'light' ? 'rgba(0, 0, 0, 0.23)' : 'rgba(255, 255, 255, 0.23)';
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'relative',
        '& $notchedOutline': {
          borderColor: borderColor
        },
        '&:hover:not($disabled):not($focused):not($error) $notchedOutline': {
          borderColor: theme.palette.text.primary,
          // Reset on touch devices, it doesn't add specificity
          '@media (hover: none)': {
            borderColor: borderColor
          }
        },
        '&$focused $notchedOutline': {
          borderColor: theme.palette.primary.main,
          borderWidth: 2
        },
        '&$error $notchedOutline': {
          borderColor: theme.palette.error.main
        },
        '&$disabled $notchedOutline': {
          borderColor: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if the component is focused. */
      focused: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `startAdornment` is provided. */
      adornedStart: {
        paddingLeft: 14
      },

      /* Styles applied to the root element if `endAdornment` is provided. */
      adornedEnd: {
        paddingRight: 14
      },

      /* Styles applied to the root element if `error={true}`. */
      error: {},

      /* Styles applied to the root element if `multiline={true}`. */
      multiline: {
        padding: '18.5px 14px',
        boxSizing: 'border-box' // Prevent padding issue with fullWidth.

      },

      /* Styles applied to the `NotchedOutline` element. */
      notchedOutline: {},

      /* Styles applied to the `input` element. */
      input: {
        padding: '18.5px 14px'
      },

      /* Styles applied to the `input` element if `margin="dense"`. */
      inputMarginDense: {
        paddingTop: 15,
        paddingBottom: 15
      },

      /* Styles applied to the `input` element if `multiline={true}`. */
      inputMultiline: {
        padding: 0
      },

      /* Styles applied to the `input` element if `startAdornment` is provided. */
      inputAdornedStart: {
        paddingLeft: 0
      },

      /* Styles applied to the `input` element if `endAdornment` is provided. */
      inputAdornedEnd: {
        paddingRight: 0
      }
    };
  };

  function OutlinedInput(props) {
    var classes = props.classes,
        labelWidth = props.labelWidth,
        notched = props.notched,
        other = objectWithoutProperties(props, ["classes", "labelWidth", "notched"]);

    return React.createElement(InputBase$1, _extends_1({
      renderPrefix: function renderPrefix(state) {
        return React.createElement(NotchedOutline$1, {
          className: classes.notchedOutline,
          labelWidth: labelWidth,
          notched: typeof notched !== 'undefined' ? notched : Boolean(state.startAdornment || state.filled || state.focused)
        });
      },
      classes: _extends_1({}, classes, {
        root: classnames(classes.root, classes.underline),
        notchedOutline: null
      })
    }, other));
  }

  OutlinedInput.propTypes = {
    /**
     * This property helps users to fill forms faster, especially on mobile devices.
     * The name can be confusing, as it's more like an autofill.
     * You can learn more about it here:
     * https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill
     */
    autoComplete: propTypes.string,

    /**
     * If `true`, the input will be focused during the first mount.
     */
    autoFocus: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the wrapper element.
     */
    className: propTypes.string,

    /**
     * The default input value, useful when not controlling the component.
     */
    defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))]),

    /**
     * If `true`, the input will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * End `InputAdornment` for this component.
     */
    endAdornment: propTypes.node,

    /**
     * If `true`, the input will indicate an error. This is normally obtained via context from
     * FormControl.
     */
    error: propTypes.bool,

    /**
     * If `true`, the input will take up the full width of its container.
     */
    fullWidth: propTypes.bool,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * The component used for the native input.
     * Either a string to use a DOM element or a component.
     */
    inputComponent: componentPropType,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * The width of the legend.
     */
    labelWidth: propTypes.number.isRequired,

    /**
     * If `dense`, will adjust vertical spacing. This is normally obtained via context from
     * FormControl.
     */
    margin: propTypes.oneOf(['dense', 'none']),

    /**
     * If `true`, a textarea element will be rendered.
     */
    multiline: propTypes.bool,

    /**
     * Name attribute of the `input` element.
     */
    name: propTypes.string,

    /**
     * If `true`, the outline is notched to accommodate the label.
     */
    notched: propTypes.bool,

    /**
     * Callback fired when the value is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     */
    onChange: propTypes.func,

    /**
     * The short hint displayed in the input before the user enters a value.
     */
    placeholder: propTypes.string,

    /**
     * It prevents the user from changing the value of the field
     * (not from interacting with the field).
     */
    readOnly: propTypes.bool,

    /**
     * If `true`, the input will be required.
     */
    required: propTypes.bool,

    /**
     * Number of rows to display when multiline option is set to true.
     */
    rows: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Maximum number of rows to display when multiline option is set to true.
     */
    rowsMax: propTypes.oneOfType([propTypes.string, propTypes.number]),

    /**
     * Start `InputAdornment` for this component.
     */
    startAdornment: propTypes.node,

    /**
     * Type of the input element. It should be a valid HTML5 input type.
     */
    type: propTypes.string,

    /**
     * The input value, required for a controlled component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))])
  };
  InputBase$1.defaultProps = {
    fullWidth: false,
    inputComponent: 'input',
    multiline: false,
    type: 'text'
  };
  OutlinedInput.muiName = 'Input';
  var OutlinedInput$1 = withStyles(styles$19, {
    name: 'MuiOutlinedInput'
  })(OutlinedInput);

  /**!
   * @fileOverview Kickass library to create and place poppers near their reference elements.
   * @version 1.14.6
   * @license
   * Copyright (c) 2016 Federico Zivolo and contributors
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all
   * copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   * SOFTWARE.
   */
  var isBrowser$1 = typeof window !== 'undefined' && typeof document !== 'undefined';

  var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
  var timeoutDuration = 0;
  for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
    if (isBrowser$1 && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
      timeoutDuration = 1;
      break;
    }
  }

  function microtaskDebounce(fn) {
    var called = false;
    return function () {
      if (called) {
        return;
      }
      called = true;
      window.Promise.resolve().then(function () {
        called = false;
        fn();
      });
    };
  }

  function taskDebounce(fn) {
    var scheduled = false;
    return function () {
      if (!scheduled) {
        scheduled = true;
        setTimeout(function () {
          scheduled = false;
          fn();
        }, timeoutDuration);
      }
    };
  }

  var supportsMicroTasks = isBrowser$1 && window.Promise;

  /**
  * Create a debounced version of a method, that's asynchronously deferred
  * but called in the minimum time possible.
  *
  * @method
  * @memberof Popper.Utils
  * @argument {Function} fn
  * @returns {Function}
  */
  var debounce$1 = supportsMicroTasks ? microtaskDebounce : taskDebounce;

  /**
   * Check if the given variable is a function
   * @method
   * @memberof Popper.Utils
   * @argument {Any} functionToCheck - variable to check
   * @returns {Boolean} answer to: is a function?
   */
  function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
  }

  /**
   * Get CSS computed property of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Eement} element
   * @argument {String} property
   */
  function getStyleComputedProperty(element, property) {
    if (element.nodeType !== 1) {
      return [];
    }
    // NOTE: 1 DOM access here
    var window = element.ownerDocument.defaultView;
    var css = window.getComputedStyle(element, null);
    return property ? css[property] : css;
  }

  /**
   * Returns the parentNode or the host of the element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} parent
   */
  function getParentNode(element) {
    if (element.nodeName === 'HTML') {
      return element;
    }
    return element.parentNode || element.host;
  }

  /**
   * Returns the scrolling parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} scroll parent
   */
  function getScrollParent$1(element) {
    // Return body, `getScroll` will take care to get the correct `scrollTop` from it
    if (!element) {
      return document.body;
    }

    switch (element.nodeName) {
      case 'HTML':
      case 'BODY':
        return element.ownerDocument.body;
      case '#document':
        return element.body;
    }

    // Firefox want us to check `-x` and `-y` variations as well

    var _getStyleComputedProp = getStyleComputedProperty(element),
        overflow = _getStyleComputedProp.overflow,
        overflowX = _getStyleComputedProp.overflowX,
        overflowY = _getStyleComputedProp.overflowY;

    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
      return element;
    }

    return getScrollParent$1(getParentNode(element));
  }

  var isIE11 = isBrowser$1 && !!(window.MSInputMethodContext && document.documentMode);
  var isIE10 = isBrowser$1 && /MSIE 10/.test(navigator.userAgent);

  /**
   * Determines if the browser is Internet Explorer
   * @method
   * @memberof Popper.Utils
   * @param {Number} version to check
   * @returns {Boolean} isIE
   */
  function isIE(version) {
    if (version === 11) {
      return isIE11;
    }
    if (version === 10) {
      return isIE10;
    }
    return isIE11 || isIE10;
  }

  /**
   * Returns the offset parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} offset parent
   */
  function getOffsetParent(element) {
    if (!element) {
      return document.documentElement;
    }

    var noOffsetParent = isIE(10) ? document.body : null;

    // NOTE: 1 DOM access here
    var offsetParent = element.offsetParent || null;
    // Skip hidden elements which don't have an offsetParent
    while (offsetParent === noOffsetParent && element.nextElementSibling) {
      offsetParent = (element = element.nextElementSibling).offsetParent;
    }

    var nodeName = offsetParent && offsetParent.nodeName;

    if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
      return element ? element.ownerDocument.documentElement : document.documentElement;
    }

    // .offsetParent will return the closest TH, TD or TABLE in case
    // no offsetParent is present, I hate this job...
    if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
      return getOffsetParent(offsetParent);
    }

    return offsetParent;
  }

  function isOffsetContainer(element) {
    var nodeName = element.nodeName;

    if (nodeName === 'BODY') {
      return false;
    }
    return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
  }

  /**
   * Finds the root node (document, shadowDOM root) of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} node
   * @returns {Element} root node
   */
  function getRoot(node) {
    if (node.parentNode !== null) {
      return getRoot(node.parentNode);
    }

    return node;
  }

  /**
   * Finds the offset parent common to the two provided nodes
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element1
   * @argument {Element} element2
   * @returns {Element} common offset parent
   */
  function findCommonOffsetParent(element1, element2) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
      return document.documentElement;
    }

    // Here we make sure to give as "start" the element that comes first in the DOM
    var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
    var start = order ? element1 : element2;
    var end = order ? element2 : element1;

    // Get common ancestor container
    var range = document.createRange();
    range.setStart(start, 0);
    range.setEnd(end, 0);
    var commonAncestorContainer = range.commonAncestorContainer;

    // Both nodes are inside #document

    if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
      if (isOffsetContainer(commonAncestorContainer)) {
        return commonAncestorContainer;
      }

      return getOffsetParent(commonAncestorContainer);
    }

    // one of the nodes is inside shadowDOM, find which one
    var element1root = getRoot(element1);
    if (element1root.host) {
      return findCommonOffsetParent(element1root.host, element2);
    } else {
      return findCommonOffsetParent(element1, getRoot(element2).host);
    }
  }

  /**
   * Gets the scroll value of the given element in the given side (top and left)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {String} side `top` or `left`
   * @returns {number} amount of scrolled pixels
   */
  function getScroll(element) {
    var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';

    var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
    var nodeName = element.nodeName;

    if (nodeName === 'BODY' || nodeName === 'HTML') {
      var html = element.ownerDocument.documentElement;
      var scrollingElement = element.ownerDocument.scrollingElement || html;
      return scrollingElement[upperSide];
    }

    return element[upperSide];
  }

  /*
   * Sum or subtract the element scroll values (left and top) from a given rect object
   * @method
   * @memberof Popper.Utils
   * @param {Object} rect - Rect object you want to change
   * @param {HTMLElement} element - The element from the function reads the scroll values
   * @param {Boolean} subtract - set to true if you want to subtract the scroll values
   * @return {Object} rect - The modifier rect object
   */
  function includeScroll(rect, element) {
    var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var scrollTop = getScroll(element, 'top');
    var scrollLeft = getScroll(element, 'left');
    var modifier = subtract ? -1 : 1;
    rect.top += scrollTop * modifier;
    rect.bottom += scrollTop * modifier;
    rect.left += scrollLeft * modifier;
    rect.right += scrollLeft * modifier;
    return rect;
  }

  /*
   * Helper to detect borders of a given element
   * @method
   * @memberof Popper.Utils
   * @param {CSSStyleDeclaration} styles
   * Result of `getStyleComputedProperty` on the given element
   * @param {String} axis - `x` or `y`
   * @return {number} borders - The borders size of the given axis
   */

  function getBordersSize(styles, axis) {
    var sideA = axis === 'x' ? 'Left' : 'Top';
    var sideB = sideA === 'Left' ? 'Right' : 'Bottom';

    return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
  }

  function getSize(axis, body, html, computedStyle) {
    return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
  }

  function getWindowSizes(document) {
    var body = document.body;
    var html = document.documentElement;
    var computedStyle = isIE(10) && getComputedStyle(html);

    return {
      height: getSize('Height', body, html, computedStyle),
      width: getSize('Width', body, html, computedStyle)
    };
  }

  var classCallCheck$1 = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var createClass$1 = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();





  var defineProperty$2 = function (obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  };

  var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  /**
   * Given element offsets, generate an output similar to getBoundingClientRect
   * @method
   * @memberof Popper.Utils
   * @argument {Object} offsets
   * @returns {Object} ClientRect like output
   */
  function getClientRect(offsets) {
    return _extends({}, offsets, {
      right: offsets.left + offsets.width,
      bottom: offsets.top + offsets.height
    });
  }

  /**
   * Get bounding client rect of given element
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} element
   * @return {Object} client rect
   */
  function getBoundingClientRect(element) {
    var rect = {};

    // IE10 10 FIX: Please, don't ask, the element isn't
    // considered in DOM in some circumstances...
    // This isn't reproducible in IE10 compatibility mode of IE11
    try {
      if (isIE(10)) {
        rect = element.getBoundingClientRect();
        var scrollTop = getScroll(element, 'top');
        var scrollLeft = getScroll(element, 'left');
        rect.top += scrollTop;
        rect.left += scrollLeft;
        rect.bottom += scrollTop;
        rect.right += scrollLeft;
      } else {
        rect = element.getBoundingClientRect();
      }
    } catch (e) {}

    var result = {
      left: rect.left,
      top: rect.top,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    };

    // subtract scrollbar size from sizes
    var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
    var width = sizes.width || element.clientWidth || result.right - result.left;
    var height = sizes.height || element.clientHeight || result.bottom - result.top;

    var horizScrollbar = element.offsetWidth - width;
    var vertScrollbar = element.offsetHeight - height;

    // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
    // we make this check conditional for performance reasons
    if (horizScrollbar || vertScrollbar) {
      var styles = getStyleComputedProperty(element);
      horizScrollbar -= getBordersSize(styles, 'x');
      vertScrollbar -= getBordersSize(styles, 'y');

      result.width -= horizScrollbar;
      result.height -= vertScrollbar;
    }

    return getClientRect(result);
  }

  function getOffsetRectRelativeToArbitraryNode(children, parent) {
    var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var isIE10 = isIE(10);
    var isHTML = parent.nodeName === 'HTML';
    var childrenRect = getBoundingClientRect(children);
    var parentRect = getBoundingClientRect(parent);
    var scrollParent = getScrollParent$1(children);

    var styles = getStyleComputedProperty(parent);
    var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
    var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10);

    // In cases where the parent is fixed, we must ignore negative scroll in offset calc
    if (fixedPosition && isHTML) {
      parentRect.top = Math.max(parentRect.top, 0);
      parentRect.left = Math.max(parentRect.left, 0);
    }
    var offsets = getClientRect({
      top: childrenRect.top - parentRect.top - borderTopWidth,
      left: childrenRect.left - parentRect.left - borderLeftWidth,
      width: childrenRect.width,
      height: childrenRect.height
    });
    offsets.marginTop = 0;
    offsets.marginLeft = 0;

    // Subtract margins of documentElement in case it's being used as parent
    // we do this only on HTML because it's the only element that behaves
    // differently when margins are applied to it. The margins are included in
    // the box of the documentElement, in the other cases not.
    if (!isIE10 && isHTML) {
      var marginTop = parseFloat(styles.marginTop, 10);
      var marginLeft = parseFloat(styles.marginLeft, 10);

      offsets.top -= borderTopWidth - marginTop;
      offsets.bottom -= borderTopWidth - marginTop;
      offsets.left -= borderLeftWidth - marginLeft;
      offsets.right -= borderLeftWidth - marginLeft;

      // Attach marginTop and marginLeft because in some circumstances we may need them
      offsets.marginTop = marginTop;
      offsets.marginLeft = marginLeft;
    }

    if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
      offsets = includeScroll(offsets, parent);
    }

    return offsets;
  }

  function getViewportOffsetRectRelativeToArtbitraryNode(element) {
    var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var html = element.ownerDocument.documentElement;
    var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
    var width = Math.max(html.clientWidth, window.innerWidth || 0);
    var height = Math.max(html.clientHeight, window.innerHeight || 0);

    var scrollTop = !excludeScroll ? getScroll(html) : 0;
    var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;

    var offset = {
      top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
      left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
      width: width,
      height: height
    };

    return getClientRect(offset);
  }

  /**
   * Check if the given element is fixed or is inside a fixed parent
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {Element} customContainer
   * @returns {Boolean} answer to "isFixed?"
   */
  function isFixed(element) {
    var nodeName = element.nodeName;
    if (nodeName === 'BODY' || nodeName === 'HTML') {
      return false;
    }
    if (getStyleComputedProperty(element, 'position') === 'fixed') {
      return true;
    }
    return isFixed(getParentNode(element));
  }

  /**
   * Finds the first parent of an element that has a transformed property defined
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} first transformed parent or documentElement
   */

  function getFixedPositionOffsetParent(element) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element || !element.parentElement || isIE()) {
      return document.documentElement;
    }
    var el = element.parentElement;
    while (el && getStyleComputedProperty(el, 'transform') === 'none') {
      el = el.parentElement;
    }
    return el || document.documentElement;
  }

  /**
   * Computed the boundaries limits and return them
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} popper
   * @param {HTMLElement} reference
   * @param {number} padding
   * @param {HTMLElement} boundariesElement - Element used to define the boundaries
   * @param {Boolean} fixedPosition - Is in fixed position mode
   * @returns {Object} Coordinates of the boundaries
   */
  function getBoundaries(popper, reference, padding, boundariesElement) {
    var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

    // NOTE: 1 DOM access here

    var boundaries = { top: 0, left: 0 };
    var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);

    // Handle viewport case
    if (boundariesElement === 'viewport') {
      boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
    } else {
      // Handle other cases based on DOM element used as boundaries
      var boundariesNode = void 0;
      if (boundariesElement === 'scrollParent') {
        boundariesNode = getScrollParent$1(getParentNode(reference));
        if (boundariesNode.nodeName === 'BODY') {
          boundariesNode = popper.ownerDocument.documentElement;
        }
      } else if (boundariesElement === 'window') {
        boundariesNode = popper.ownerDocument.documentElement;
      } else {
        boundariesNode = boundariesElement;
      }

      var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);

      // In case of HTML, we need a different computation
      if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
        var _getWindowSizes = getWindowSizes(popper.ownerDocument),
            height = _getWindowSizes.height,
            width = _getWindowSizes.width;

        boundaries.top += offsets.top - offsets.marginTop;
        boundaries.bottom = height + offsets.top;
        boundaries.left += offsets.left - offsets.marginLeft;
        boundaries.right = width + offsets.left;
      } else {
        // for all the other DOM elements, this one is good
        boundaries = offsets;
      }
    }

    // Add paddings
    padding = padding || 0;
    var isPaddingNumber = typeof padding === 'number';
    boundaries.left += isPaddingNumber ? padding : padding.left || 0;
    boundaries.top += isPaddingNumber ? padding : padding.top || 0;
    boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
    boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;

    return boundaries;
  }

  function getArea(_ref) {
    var width = _ref.width,
        height = _ref.height;

    return width * height;
  }

  /**
   * Utility used to transform the `auto` placement to the placement with more
   * available space.
   * @method
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
    var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

    if (placement.indexOf('auto') === -1) {
      return placement;
    }

    var boundaries = getBoundaries(popper, reference, padding, boundariesElement);

    var rects = {
      top: {
        width: boundaries.width,
        height: refRect.top - boundaries.top
      },
      right: {
        width: boundaries.right - refRect.right,
        height: boundaries.height
      },
      bottom: {
        width: boundaries.width,
        height: boundaries.bottom - refRect.bottom
      },
      left: {
        width: refRect.left - boundaries.left,
        height: boundaries.height
      }
    };

    var sortedAreas = Object.keys(rects).map(function (key) {
      return _extends({
        key: key
      }, rects[key], {
        area: getArea(rects[key])
      });
    }).sort(function (a, b) {
      return b.area - a.area;
    });

    var filteredAreas = sortedAreas.filter(function (_ref2) {
      var width = _ref2.width,
          height = _ref2.height;
      return width >= popper.clientWidth && height >= popper.clientHeight;
    });

    var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;

    var variation = placement.split('-')[1];

    return computedPlacement + (variation ? '-' + variation : '');
  }

  /**
   * Get offsets to the reference element
   * @method
   * @memberof Popper.Utils
   * @param {Object} state
   * @param {Element} popper - the popper element
   * @param {Element} reference - the reference element (the popper will be relative to this)
   * @param {Element} fixedPosition - is in fixed position mode
   * @returns {Object} An object containing the offsets which will be applied to the popper
   */
  function getReferenceOffsets(state, popper, reference) {
    var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);
    return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
  }

  /**
   * Get the outer sizes of the given element (offset size + margins)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Object} object containing width and height properties
   */
  function getOuterSizes(element) {
    var window = element.ownerDocument.defaultView;
    var styles = window.getComputedStyle(element);
    var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
    var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
    var result = {
      width: element.offsetWidth + y,
      height: element.offsetHeight + x
    };
    return result;
  }

  /**
   * Get the opposite placement of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement
   * @returns {String} flipped placement
   */
  function getOppositePlacement(placement) {
    var hash = { left: 'right', right: 'left', bottom: 'top', top: 'bottom' };
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash[matched];
    });
  }

  /**
   * Get offsets to the popper
   * @method
   * @memberof Popper.Utils
   * @param {Object} position - CSS position the Popper will get applied
   * @param {HTMLElement} popper - the popper element
   * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
   * @param {String} placement - one of the valid placement options
   * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
   */
  function getPopperOffsets(popper, referenceOffsets, placement) {
    placement = placement.split('-')[0];

    // Get popper node sizes
    var popperRect = getOuterSizes(popper);

    // Add position, width and height to our offsets object
    var popperOffsets = {
      width: popperRect.width,
      height: popperRect.height
    };

    // depending by the popper placement we have to compute its offsets slightly differently
    var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    var mainSide = isHoriz ? 'top' : 'left';
    var secondarySide = isHoriz ? 'left' : 'top';
    var measurement = isHoriz ? 'height' : 'width';
    var secondaryMeasurement = !isHoriz ? 'height' : 'width';

    popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
    if (placement === secondarySide) {
      popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
    } else {
      popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
    }

    return popperOffsets;
  }

  /**
   * Mimics the `find` method of Array
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function find$1(arr, check) {
    // use native find if supported
    if (Array.prototype.find) {
      return arr.find(check);
    }

    // use `filter` to obtain the same behavior of `find`
    return arr.filter(check)[0];
  }

  /**
   * Return the index of the matching object
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function findIndex$1(arr, prop, value) {
    // use native findIndex if supported
    if (Array.prototype.findIndex) {
      return arr.findIndex(function (cur) {
        return cur[prop] === value;
      });
    }

    // use `find` + `indexOf` if `findIndex` isn't supported
    var match = find$1(arr, function (obj) {
      return obj[prop] === value;
    });
    return arr.indexOf(match);
  }

  /**
   * Loop trough the list of modifiers and run them in order,
   * each of them will then edit the data object.
   * @method
   * @memberof Popper.Utils
   * @param {dataObject} data
   * @param {Array} modifiers
   * @param {String} ends - Optional modifier name used as stopper
   * @returns {dataObject}
   */
  function runModifiers(modifiers, data, ends) {
    var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex$1(modifiers, 'name', ends));

    modifiersToRun.forEach(function (modifier) {
      if (modifier['function']) {
        // eslint-disable-line dot-notation
        console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
      }
      var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation
      if (modifier.enabled && isFunction(fn)) {
        // Add properties to offsets to make them a complete clientRect object
        // we do this before each modifier to make sure the previous one doesn't
        // mess with these values
        data.offsets.popper = getClientRect(data.offsets.popper);
        data.offsets.reference = getClientRect(data.offsets.reference);

        data = fn(data, modifier);
      }
    });

    return data;
  }

  /**
   * Updates the position of the popper, computing the new offsets and applying
   * the new style.<br />
   * Prefer `scheduleUpdate` over `update` because of performance reasons.
   * @method
   * @memberof Popper
   */
  function update() {
    // if popper is destroyed, don't perform any further update
    if (this.state.isDestroyed) {
      return;
    }

    var data = {
      instance: this,
      styles: {},
      arrowStyles: {},
      attributes: {},
      flipped: false,
      offsets: {}
    };

    // compute reference element offsets
    data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);

    // store the computed placement inside `originalPlacement`
    data.originalPlacement = data.placement;

    data.positionFixed = this.options.positionFixed;

    // compute the popper offsets
    data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);

    data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute';

    // run the modifiers
    data = runModifiers(this.modifiers, data);

    // the first `update` will call `onCreate` callback
    // the other ones will call `onUpdate` callback
    if (!this.state.isCreated) {
      this.state.isCreated = true;
      this.options.onCreate(data);
    } else {
      this.options.onUpdate(data);
    }
  }

  /**
   * Helper used to know if the given modifier is enabled.
   * @method
   * @memberof Popper.Utils
   * @returns {Boolean}
   */
  function isModifierEnabled(modifiers, modifierName) {
    return modifiers.some(function (_ref) {
      var name = _ref.name,
          enabled = _ref.enabled;
      return enabled && name === modifierName;
    });
  }

  /**
   * Get the prefixed supported property name
   * @method
   * @memberof Popper.Utils
   * @argument {String} property (camelCase)
   * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
   */
  function getSupportedPropertyName(property) {
    var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
    var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

    for (var i = 0; i < prefixes.length; i++) {
      var prefix = prefixes[i];
      var toCheck = prefix ? '' + prefix + upperProp : property;
      if (typeof document.body.style[toCheck] !== 'undefined') {
        return toCheck;
      }
    }
    return null;
  }

  /**
   * Destroys the popper.
   * @method
   * @memberof Popper
   */
  function destroy() {
    this.state.isDestroyed = true;

    // touch DOM only if `applyStyle` modifier is enabled
    if (isModifierEnabled(this.modifiers, 'applyStyle')) {
      this.popper.removeAttribute('x-placement');
      this.popper.style.position = '';
      this.popper.style.top = '';
      this.popper.style.left = '';
      this.popper.style.right = '';
      this.popper.style.bottom = '';
      this.popper.style.willChange = '';
      this.popper.style[getSupportedPropertyName('transform')] = '';
    }

    this.disableEventListeners();

    // remove the popper if user explicity asked for the deletion on destroy
    // do not use `remove` because IE11 doesn't support it
    if (this.options.removeOnDestroy) {
      this.popper.parentNode.removeChild(this.popper);
    }
    return this;
  }

  /**
   * Get the window associated with the element
   * @argument {Element} element
   * @returns {Window}
   */
  function getWindow(element) {
    var ownerDocument = element.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
  }

  function attachToScrollParents(scrollParent, event, callback, scrollParents) {
    var isBody = scrollParent.nodeName === 'BODY';
    var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
    target.addEventListener(event, callback, { passive: true });

    if (!isBody) {
      attachToScrollParents(getScrollParent$1(target.parentNode), event, callback, scrollParents);
    }
    scrollParents.push(target);
  }

  /**
   * Setup needed event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function setupEventListeners(reference, options, state, updateBound) {
    // Resize event listener on window
    state.updateBound = updateBound;
    getWindow(reference).addEventListener('resize', state.updateBound, { passive: true });

    // Scroll event listener on scroll parents
    var scrollElement = getScrollParent$1(reference);
    attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
    state.scrollElement = scrollElement;
    state.eventsEnabled = true;

    return state;
  }

  /**
   * It will add resize/scroll events and start recalculating
   * position of the popper element when they are triggered.
   * @method
   * @memberof Popper
   */
  function enableEventListeners() {
    if (!this.state.eventsEnabled) {
      this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
    }
  }

  /**
   * Remove event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function removeEventListeners(reference, state) {
    // Remove resize event listener on window
    getWindow(reference).removeEventListener('resize', state.updateBound);

    // Remove scroll event listener on scroll parents
    state.scrollParents.forEach(function (target) {
      target.removeEventListener('scroll', state.updateBound);
    });

    // Reset state
    state.updateBound = null;
    state.scrollParents = [];
    state.scrollElement = null;
    state.eventsEnabled = false;
    return state;
  }

  /**
   * It will remove resize/scroll events and won't recalculate popper position
   * when they are triggered. It also won't trigger `onUpdate` callback anymore,
   * unless you call `update` method manually.
   * @method
   * @memberof Popper
   */
  function disableEventListeners() {
    if (this.state.eventsEnabled) {
      cancelAnimationFrame(this.scheduleUpdate);
      this.state = removeEventListeners(this.reference, this.state);
    }
  }

  /**
   * Tells if a given input is a number
   * @method
   * @memberof Popper.Utils
   * @param {*} input to check
   * @return {Boolean}
   */
  function isNumeric(n) {
    return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
  }

  /**
   * Set the style to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the style to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setStyles(element, styles) {
    Object.keys(styles).forEach(function (prop) {
      var unit = '';
      // add unit if the value is numeric and is one of the following
      if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
        unit = 'px';
      }
      element.style[prop] = styles[prop] + unit;
    });
  }

  /**
   * Set the attributes to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the attributes to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setAttributes(element, attributes) {
    Object.keys(attributes).forEach(function (prop) {
      var value = attributes[prop];
      if (value !== false) {
        element.setAttribute(prop, attributes[prop]);
      } else {
        element.removeAttribute(prop);
      }
    });
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} data.styles - List of style properties - values to apply to popper element
   * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The same data object
   */
  function applyStyle(data) {
    // any property present in `data.styles` will be applied to the popper,
    // in this way we can make the 3rd party modifiers add custom styles to it
    // Be aware, modifiers could override the properties defined in the previous
    // lines of this modifier!
    setStyles(data.instance.popper, data.styles);

    // any property present in `data.attributes` will be applied to the popper,
    // they will be set as HTML attributes of the element
    setAttributes(data.instance.popper, data.attributes);

    // if arrowElement is defined and arrowStyles has some properties
    if (data.arrowElement && Object.keys(data.arrowStyles).length) {
      setStyles(data.arrowElement, data.arrowStyles);
    }

    return data;
  }

  /**
   * Set the x-placement attribute before everything else because it could be used
   * to add margins to the popper margins needs to be calculated to get the
   * correct popper offsets.
   * @method
   * @memberof Popper.modifiers
   * @param {HTMLElement} reference - The reference element used to position the popper
   * @param {HTMLElement} popper - The HTML element used as popper
   * @param {Object} options - Popper.js options
   */
  function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
    // compute reference element offsets
    var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);

    popper.setAttribute('x-placement', placement);

    // Apply `position` to popper before anything else because
    // without the position applied we can't guarantee correct computations
    setStyles(popper, { position: options.positionFixed ? 'fixed' : 'absolute' });

    return options;
  }

  /**
   * @function
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Boolean} shouldRound - If the offsets should be rounded at all
   * @returns {Object} The popper's position offsets rounded
   *
   * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
   * good as it can be within reason.
   * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
   *
   * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
   * as well on High DPI screens).
   *
   * Firefox prefers no rounding for positioning and does not have blurriness on
   * high DPI screens.
   *
   * Only horizontal placement and left/right values need to be considered.
   */
  function getRoundedOffsets(data, shouldRound) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;


    var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
    var isVariation = data.placement.indexOf('-') !== -1;
    var sameWidthOddness = reference.width % 2 === popper.width % 2;
    var bothOddWidth = reference.width % 2 === 1 && popper.width % 2 === 1;
    var noRound = function noRound(v) {
      return v;
    };

    var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthOddness ? Math.round : Math.floor;
    var verticalToInteger = !shouldRound ? noRound : Math.round;

    return {
      left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
      top: verticalToInteger(popper.top),
      bottom: verticalToInteger(popper.bottom),
      right: horizontalToInteger(popper.right)
    };
  }

  var isFirefox = isBrowser$1 && /Firefox/i.test(navigator.userAgent);

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeStyle(data, options) {
    var x = options.x,
        y = options.y;
    var popper = data.offsets.popper;

    // Remove this legacy support in Popper.js v2

    var legacyGpuAccelerationOption = find$1(data.instance.modifiers, function (modifier) {
      return modifier.name === 'applyStyle';
    }).gpuAcceleration;
    if (legacyGpuAccelerationOption !== undefined) {
      console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
    }
    var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;

    var offsetParent = getOffsetParent(data.instance.popper);
    var offsetParentRect = getBoundingClientRect(offsetParent);

    // Styles
    var styles = {
      position: popper.position
    };

    var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);

    var sideA = x === 'bottom' ? 'top' : 'bottom';
    var sideB = y === 'right' ? 'left' : 'right';

    // if gpuAcceleration is set to `true` and transform is supported,
    //  we use `translate3d` to apply the position to the popper we
    // automatically use the supported prefixed version if needed
    var prefixedProperty = getSupportedPropertyName('transform');

    // now, let's make a step back and look at this code closely (wtf?)
    // If the content of the popper grows once it's been positioned, it
    // may happen that the popper gets misplaced because of the new content
    // overflowing its reference element
    // To avoid this problem, we provide two options (x and y), which allow
    // the consumer to define the offset origin.
    // If we position a popper on top of a reference element, we can set
    // `x` to `top` to make the popper grow towards its top instead of
    // its bottom.
    var left = void 0,
        top = void 0;
    if (sideA === 'bottom') {
      // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
      // and not the bottom of the html element
      if (offsetParent.nodeName === 'HTML') {
        top = -offsetParent.clientHeight + offsets.bottom;
      } else {
        top = -offsetParentRect.height + offsets.bottom;
      }
    } else {
      top = offsets.top;
    }
    if (sideB === 'right') {
      if (offsetParent.nodeName === 'HTML') {
        left = -offsetParent.clientWidth + offsets.right;
      } else {
        left = -offsetParentRect.width + offsets.right;
      }
    } else {
      left = offsets.left;
    }
    if (gpuAcceleration && prefixedProperty) {
      styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
      styles[sideA] = 0;
      styles[sideB] = 0;
      styles.willChange = 'transform';
    } else {
      // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
      var invertTop = sideA === 'bottom' ? -1 : 1;
      var invertLeft = sideB === 'right' ? -1 : 1;
      styles[sideA] = top * invertTop;
      styles[sideB] = left * invertLeft;
      styles.willChange = sideA + ', ' + sideB;
    }

    // Attributes
    var attributes = {
      'x-placement': data.placement
    };

    // Update `data` attributes, styles and arrowStyles
    data.attributes = _extends({}, attributes, data.attributes);
    data.styles = _extends({}, styles, data.styles);
    data.arrowStyles = _extends({}, data.offsets.arrow, data.arrowStyles);

    return data;
  }

  /**
   * Helper used to know if the given modifier depends from another one.<br />
   * It checks if the needed modifier is listed and enabled.
   * @method
   * @memberof Popper.Utils
   * @param {Array} modifiers - list of modifiers
   * @param {String} requestingName - name of requesting modifier
   * @param {String} requestedName - name of requested modifier
   * @returns {Boolean}
   */
  function isModifierRequired(modifiers, requestingName, requestedName) {
    var requesting = find$1(modifiers, function (_ref) {
      var name = _ref.name;
      return name === requestingName;
    });

    var isRequired = !!requesting && modifiers.some(function (modifier) {
      return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
    });

    if (!isRequired) {
      var _requesting = '`' + requestingName + '`';
      var requested = '`' + requestedName + '`';
      console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
    }
    return isRequired;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function arrow(data, options) {
    var _data$offsets$arrow;

    // arrow depends on keepTogether in order to work
    if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
      return data;
    }

    var arrowElement = options.element;

    // if arrowElement is a string, suppose it's a CSS selector
    if (typeof arrowElement === 'string') {
      arrowElement = data.instance.popper.querySelector(arrowElement);

      // if arrowElement is not found, don't run the modifier
      if (!arrowElement) {
        return data;
      }
    } else {
      // if the arrowElement isn't a query selector we must check that the
      // provided DOM node is child of its popper node
      if (!data.instance.popper.contains(arrowElement)) {
        console.warn('WARNING: `arrow.element` must be child of its popper element!');
        return data;
      }
    }

    var placement = data.placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var isVertical = ['left', 'right'].indexOf(placement) !== -1;

    var len = isVertical ? 'height' : 'width';
    var sideCapitalized = isVertical ? 'Top' : 'Left';
    var side = sideCapitalized.toLowerCase();
    var altSide = isVertical ? 'left' : 'top';
    var opSide = isVertical ? 'bottom' : 'right';
    var arrowElementSize = getOuterSizes(arrowElement)[len];

    //
    // extends keepTogether behavior making sure the popper and its
    // reference have enough pixels in conjunction
    //

    // top/left side
    if (reference[opSide] - arrowElementSize < popper[side]) {
      data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
    }
    // bottom/right side
    if (reference[side] + arrowElementSize > popper[opSide]) {
      data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
    }
    data.offsets.popper = getClientRect(data.offsets.popper);

    // compute center of the popper
    var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;

    // Compute the sideValue using the updated popper offsets
    // take popper margin in account because we don't have this info available
    var css = getStyleComputedProperty(data.instance.popper);
    var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
    var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
    var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;

    // prevent arrowElement from being placed not contiguously to its popper
    sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);

    data.arrowElement = arrowElement;
    data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty$2(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty$2(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);

    return data;
  }

  /**
   * Get the opposite placement variation of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement variation
   * @returns {String} flipped placement variation
   */
  function getOppositeVariation(variation) {
    if (variation === 'end') {
      return 'start';
    } else if (variation === 'start') {
      return 'end';
    }
    return variation;
  }

  /**
   * List of accepted placements to use as values of the `placement` option.<br />
   * Valid placements are:
   * - `auto`
   * - `top`
   * - `right`
   * - `bottom`
   * - `left`
   *
   * Each placement can have a variation from this list:
   * - `-start`
   * - `-end`
   *
   * Variations are interpreted easily if you think of them as the left to right
   * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
   * is right.<br />
   * Vertically (`left` and `right`), `start` is top and `end` is bottom.
   *
   * Some valid examples are:
   * - `top-end` (on top of reference, right aligned)
   * - `right-start` (on right of reference, top aligned)
   * - `bottom` (on bottom, centered)
   * - `auto-end` (on the side with more space available, alignment depends by placement)
   *
   * @static
   * @type {Array}
   * @enum {String}
   * @readonly
   * @method placements
   * @memberof Popper
   */
  var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start'];

  // Get rid of `auto` `auto-start` and `auto-end`
  var validPlacements = placements.slice(3);

  /**
   * Given an initial placement, returns all the subsequent placements
   * clockwise (or counter-clockwise).
   *
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement - A valid placement (it accepts variations)
   * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
   * @returns {Array} placements including their variations
   */
  function clockwise(placement) {
    var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var index = validPlacements.indexOf(placement);
    var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
    return counter ? arr.reverse() : arr;
  }

  var BEHAVIORS = {
    FLIP: 'flip',
    CLOCKWISE: 'clockwise',
    COUNTERCLOCKWISE: 'counterclockwise'
  };

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function flip(data, options) {
    // if `inner` modifier is enabled, we can't use the `flip` modifier
    if (isModifierEnabled(data.instance.modifiers, 'inner')) {
      return data;
    }

    if (data.flipped && data.placement === data.originalPlacement) {
      // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
      return data;
    }

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);

    var placement = data.placement.split('-')[0];
    var placementOpposite = getOppositePlacement(placement);
    var variation = data.placement.split('-')[1] || '';

    var flipOrder = [];

    switch (options.behavior) {
      case BEHAVIORS.FLIP:
        flipOrder = [placement, placementOpposite];
        break;
      case BEHAVIORS.CLOCKWISE:
        flipOrder = clockwise(placement);
        break;
      case BEHAVIORS.COUNTERCLOCKWISE:
        flipOrder = clockwise(placement, true);
        break;
      default:
        flipOrder = options.behavior;
    }

    flipOrder.forEach(function (step, index) {
      if (placement !== step || flipOrder.length === index + 1) {
        return data;
      }

      placement = data.placement.split('-')[0];
      placementOpposite = getOppositePlacement(placement);

      var popperOffsets = data.offsets.popper;
      var refOffsets = data.offsets.reference;

      // using floor because the reference offsets may contain decimals we are not going to consider here
      var floor = Math.floor;
      var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);

      var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
      var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
      var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
      var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);

      var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom;

      // flip the variation if required
      var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
      var flippedVariation = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom);

      if (overlapsRef || overflowsBoundaries || flippedVariation) {
        // this boolean to detect any flip loop
        data.flipped = true;

        if (overlapsRef || overflowsBoundaries) {
          placement = flipOrder[index + 1];
        }

        if (flippedVariation) {
          variation = getOppositeVariation(variation);
        }

        data.placement = placement + (variation ? '-' + variation : '');

        // this object contains `position`, we want to preserve it along with
        // any additional property we may add in the future
        data.offsets.popper = _extends({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));

        data = runModifiers(data.instance.modifiers, data, 'flip');
      }
    });
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function keepTogether(data) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var placement = data.placement.split('-')[0];
    var floor = Math.floor;
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
    var side = isVertical ? 'right' : 'bottom';
    var opSide = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';

    if (popper[side] < floor(reference[opSide])) {
      data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
    }
    if (popper[opSide] > floor(reference[side])) {
      data.offsets.popper[opSide] = floor(reference[side]);
    }

    return data;
  }

  /**
   * Converts a string containing value + unit into a px value number
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} str - Value + unit string
   * @argument {String} measurement - `height` or `width`
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @returns {Number|String}
   * Value in pixels, or original string if no values were extracted
   */
  function toValue(str, measurement, popperOffsets, referenceOffsets) {
    // separate value from unit
    var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
    var value = +split[1];
    var unit = split[2];

    // If it's not a number it's an operator, I guess
    if (!value) {
      return str;
    }

    if (unit.indexOf('%') === 0) {
      var element = void 0;
      switch (unit) {
        case '%p':
          element = popperOffsets;
          break;
        case '%':
        case '%r':
        default:
          element = referenceOffsets;
      }

      var rect = getClientRect(element);
      return rect[measurement] / 100 * value;
    } else if (unit === 'vh' || unit === 'vw') {
      // if is a vh or vw, we calculate the size based on the viewport
      var size = void 0;
      if (unit === 'vh') {
        size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
      } else {
        size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
      }
      return size / 100 * value;
    } else {
      // if is an explicit pixel unit, we get rid of the unit and keep the value
      // if is an implicit unit, it's px, and we return just the value
      return value;
    }
  }

  /**
   * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} offset
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @argument {String} basePlacement
   * @returns {Array} a two cells array with x and y offsets in numbers
   */
  function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
    var offsets = [0, 0];

    // Use height if placement is left or right and index is 0 otherwise use width
    // in this way the first offset will use an axis and the second one
    // will use the other one
    var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1;

    // Split the offset string to obtain a list of values and operands
    // The regex addresses values with the plus or minus sign in front (+10, -20, etc)
    var fragments = offset.split(/(\+|\-)/).map(function (frag) {
      return frag.trim();
    });

    // Detect if the offset string contains a pair of values or a single one
    // they could be separated by comma or space
    var divider = fragments.indexOf(find$1(fragments, function (frag) {
      return frag.search(/,|\s/) !== -1;
    }));

    if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
      console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
    }

    // If divider is found, we divide the list of values and operands to divide
    // them by ofset X and Y.
    var splitRegex = /\s*,\s*|\s+/;
    var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];

    // Convert the values with units to absolute pixels to allow our computations
    ops = ops.map(function (op, index) {
      // Most of the units rely on the orientation of the popper
      var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
      var mergeWithPrevious = false;
      return op
      // This aggregates any `+` or `-` sign that aren't considered operators
      // e.g.: 10 + +5 => [10, +, +5]
      .reduce(function (a, b) {
        if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
          a[a.length - 1] = b;
          mergeWithPrevious = true;
          return a;
        } else if (mergeWithPrevious) {
          a[a.length - 1] += b;
          mergeWithPrevious = false;
          return a;
        } else {
          return a.concat(b);
        }
      }, [])
      // Here we convert the string values into number values (in px)
      .map(function (str) {
        return toValue(str, measurement, popperOffsets, referenceOffsets);
      });
    });

    // Loop trough the offsets arrays and execute the operations
    ops.forEach(function (op, index) {
      op.forEach(function (frag, index2) {
        if (isNumeric(frag)) {
          offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
        }
      });
    });
    return offsets;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @argument {Number|String} options.offset=0
   * The offset value as described in the modifier description
   * @returns {Object} The data object, properly modified
   */
  function offset(data, _ref) {
    var offset = _ref.offset;
    var placement = data.placement,
        _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var basePlacement = placement.split('-')[0];

    var offsets = void 0;
    if (isNumeric(+offset)) {
      offsets = [+offset, 0];
    } else {
      offsets = parseOffset(offset, popper, reference, basePlacement);
    }

    if (basePlacement === 'left') {
      popper.top += offsets[0];
      popper.left -= offsets[1];
    } else if (basePlacement === 'right') {
      popper.top += offsets[0];
      popper.left += offsets[1];
    } else if (basePlacement === 'top') {
      popper.left += offsets[0];
      popper.top -= offsets[1];
    } else if (basePlacement === 'bottom') {
      popper.left += offsets[0];
      popper.top += offsets[1];
    }

    data.popper = popper;
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function preventOverflow(data, options) {
    var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);

    // If offsetParent is the reference element, we really want to
    // go one step up and use the next offsetParent as reference to
    // avoid to make this modifier completely useless and look like broken
    if (data.instance.reference === boundariesElement) {
      boundariesElement = getOffsetParent(boundariesElement);
    }

    // NOTE: DOM access here
    // resets the popper's position so that the document size can be calculated excluding
    // the size of the popper element itself
    var transformProp = getSupportedPropertyName('transform');
    var popperStyles = data.instance.popper.style; // assignment to help minification
    var top = popperStyles.top,
        left = popperStyles.left,
        transform = popperStyles[transformProp];

    popperStyles.top = '';
    popperStyles.left = '';
    popperStyles[transformProp] = '';

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);

    // NOTE: DOM access here
    // restores the original style properties after the offsets have been computed
    popperStyles.top = top;
    popperStyles.left = left;
    popperStyles[transformProp] = transform;

    options.boundaries = boundaries;

    var order = options.priority;
    var popper = data.offsets.popper;

    var check = {
      primary: function primary(placement) {
        var value = popper[placement];
        if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
          value = Math.max(popper[placement], boundaries[placement]);
        }
        return defineProperty$2({}, placement, value);
      },
      secondary: function secondary(placement) {
        var mainSide = placement === 'right' ? 'left' : 'top';
        var value = popper[mainSide];
        if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
          value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
        }
        return defineProperty$2({}, mainSide, value);
      }
    };

    order.forEach(function (placement) {
      var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
      popper = _extends({}, popper, check[side](placement));
    });

    data.offsets.popper = popper;

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function shift(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var shiftvariation = placement.split('-')[1];

    // if shift shiftvariation is specified, run the modifier
    if (shiftvariation) {
      var _data$offsets = data.offsets,
          reference = _data$offsets.reference,
          popper = _data$offsets.popper;

      var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
      var side = isVertical ? 'left' : 'top';
      var measurement = isVertical ? 'width' : 'height';

      var shiftOffsets = {
        start: defineProperty$2({}, side, reference[side]),
        end: defineProperty$2({}, side, reference[side] + reference[measurement] - popper[measurement])
      };

      data.offsets.popper = _extends({}, popper, shiftOffsets[shiftvariation]);
    }

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function hide(data) {
    if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
      return data;
    }

    var refRect = data.offsets.reference;
    var bound = find$1(data.instance.modifiers, function (modifier) {
      return modifier.name === 'preventOverflow';
    }).boundaries;

    if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === true) {
        return data;
      }

      data.hide = true;
      data.attributes['x-out-of-boundaries'] = '';
    } else {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === false) {
        return data;
      }

      data.hide = false;
      data.attributes['x-out-of-boundaries'] = false;
    }

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function inner(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;

    var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;

    popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);

    data.placement = getOppositePlacement(placement);
    data.offsets.popper = getClientRect(popper);

    return data;
  }

  /**
   * Modifier function, each modifier can have a function of this type assigned
   * to its `fn` property.<br />
   * These functions will be called on each update, this means that you must
   * make sure they are performant enough to avoid performance bottlenecks.
   *
   * @function ModifierFn
   * @argument {dataObject} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {dataObject} The data object, properly modified
   */

  /**
   * Modifiers are plugins used to alter the behavior of your poppers.<br />
   * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
   * needed by the library.
   *
   * Usually you don't want to override the `order`, `fn` and `onLoad` props.
   * All the other properties are configurations that could be tweaked.
   * @namespace modifiers
   */
  var modifiers = {
    /**
     * Modifier used to shift the popper on the start or end of its reference
     * element.<br />
     * It will read the variation of the `placement` property.<br />
     * It can be one either `-end` or `-start`.
     * @memberof modifiers
     * @inner
     */
    shift: {
      /** @prop {number} order=100 - Index used to define the order of execution */
      order: 100,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: shift
    },

    /**
     * The `offset` modifier can shift your popper on both its axis.
     *
     * It accepts the following units:
     * - `px` or unit-less, interpreted as pixels
     * - `%` or `%r`, percentage relative to the length of the reference element
     * - `%p`, percentage relative to the length of the popper element
     * - `vw`, CSS viewport width unit
     * - `vh`, CSS viewport height unit
     *
     * For length is intended the main axis relative to the placement of the popper.<br />
     * This means that if the placement is `top` or `bottom`, the length will be the
     * `width`. In case of `left` or `right`, it will be the `height`.
     *
     * You can provide a single value (as `Number` or `String`), or a pair of values
     * as `String` divided by a comma or one (or more) white spaces.<br />
     * The latter is a deprecated method because it leads to confusion and will be
     * removed in v2.<br />
     * Additionally, it accepts additions and subtractions between different units.
     * Note that multiplications and divisions aren't supported.
     *
     * Valid examples are:
     * ```
     * 10
     * '10%'
     * '10, 10'
     * '10%, 10'
     * '10 + 10%'
     * '10 - 5vh + 3%'
     * '-10px + 5vh, 5px - 6%'
     * ```
     * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
     * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
     * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
     *
     * @memberof modifiers
     * @inner
     */
    offset: {
      /** @prop {number} order=200 - Index used to define the order of execution */
      order: 200,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: offset,
      /** @prop {Number|String} offset=0
       * The offset value as described in the modifier description
       */
      offset: 0
    },

    /**
     * Modifier used to prevent the popper from being positioned outside the boundary.
     *
     * A scenario exists where the reference itself is not within the boundaries.<br />
     * We can say it has "escaped the boundaries" — or just "escaped".<br />
     * In this case we need to decide whether the popper should either:
     *
     * - detach from the reference and remain "trapped" in the boundaries, or
     * - if it should ignore the boundary and "escape with its reference"
     *
     * When `escapeWithReference` is set to`true` and reference is completely
     * outside its boundaries, the popper will overflow (or completely leave)
     * the boundaries in order to remain attached to the edge of the reference.
     *
     * @memberof modifiers
     * @inner
     */
    preventOverflow: {
      /** @prop {number} order=300 - Index used to define the order of execution */
      order: 300,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: preventOverflow,
      /**
       * @prop {Array} [priority=['left','right','top','bottom']]
       * Popper will try to prevent overflow following these priorities by default,
       * then, it could overflow on the left and on top of the `boundariesElement`
       */
      priority: ['left', 'right', 'top', 'bottom'],
      /**
       * @prop {number} padding=5
       * Amount of pixel used to define a minimum distance between the boundaries
       * and the popper. This makes sure the popper always has a little padding
       * between the edges of its container
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='scrollParent'
       * Boundaries used by the modifier. Can be `scrollParent`, `window`,
       * `viewport` or any DOM element.
       */
      boundariesElement: 'scrollParent'
    },

    /**
     * Modifier used to make sure the reference and its popper stay near each other
     * without leaving any gap between the two. Especially useful when the arrow is
     * enabled and you want to ensure that it points to its reference element.
     * It cares only about the first axis. You can still have poppers with margin
     * between the popper and its reference element.
     * @memberof modifiers
     * @inner
     */
    keepTogether: {
      /** @prop {number} order=400 - Index used to define the order of execution */
      order: 400,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: keepTogether
    },

    /**
     * This modifier is used to move the `arrowElement` of the popper to make
     * sure it is positioned between the reference element and its popper element.
     * It will read the outer size of the `arrowElement` node to detect how many
     * pixels of conjunction are needed.
     *
     * It has no effect if no `arrowElement` is provided.
     * @memberof modifiers
     * @inner
     */
    arrow: {
      /** @prop {number} order=500 - Index used to define the order of execution */
      order: 500,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: arrow,
      /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
      element: '[x-arrow]'
    },

    /**
     * Modifier used to flip the popper's placement when it starts to overlap its
     * reference element.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     *
     * **NOTE:** this modifier will interrupt the current update cycle and will
     * restart it if it detects the need to flip the placement.
     * @memberof modifiers
     * @inner
     */
    flip: {
      /** @prop {number} order=600 - Index used to define the order of execution */
      order: 600,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: flip,
      /**
       * @prop {String|Array} behavior='flip'
       * The behavior used to change the popper's placement. It can be one of
       * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
       * placements (with optional variations)
       */
      behavior: 'flip',
      /**
       * @prop {number} padding=5
       * The popper will flip if it hits the edges of the `boundariesElement`
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='viewport'
       * The element which will define the boundaries of the popper position.
       * The popper will never be placed outside of the defined boundaries
       * (except if `keepTogether` is enabled)
       */
      boundariesElement: 'viewport'
    },

    /**
     * Modifier used to make the popper flow toward the inner of the reference element.
     * By default, when this modifier is disabled, the popper will be placed outside
     * the reference element.
     * @memberof modifiers
     * @inner
     */
    inner: {
      /** @prop {number} order=700 - Index used to define the order of execution */
      order: 700,
      /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
      enabled: false,
      /** @prop {ModifierFn} */
      fn: inner
    },

    /**
     * Modifier used to hide the popper when its reference element is outside of the
     * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
     * be used to hide with a CSS selector the popper when its reference is
     * out of boundaries.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     * @memberof modifiers
     * @inner
     */
    hide: {
      /** @prop {number} order=800 - Index used to define the order of execution */
      order: 800,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: hide
    },

    /**
     * Computes the style that will be applied to the popper element to gets
     * properly positioned.
     *
     * Note that this modifier will not touch the DOM, it just prepares the styles
     * so that `applyStyle` modifier can apply it. This separation is useful
     * in case you need to replace `applyStyle` with a custom implementation.
     *
     * This modifier has `850` as `order` value to maintain backward compatibility
     * with previous versions of Popper.js. Expect the modifiers ordering method
     * to change in future major versions of the library.
     *
     * @memberof modifiers
     * @inner
     */
    computeStyle: {
      /** @prop {number} order=850 - Index used to define the order of execution */
      order: 850,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: computeStyle,
      /**
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: true,
      /**
       * @prop {string} [x='bottom']
       * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
       * Change this if your popper should grow in a direction different from `bottom`
       */
      x: 'bottom',
      /**
       * @prop {string} [x='left']
       * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
       * Change this if your popper should grow in a direction different from `right`
       */
      y: 'right'
    },

    /**
     * Applies the computed styles to the popper element.
     *
     * All the DOM manipulations are limited to this modifier. This is useful in case
     * you want to integrate Popper.js inside a framework or view library and you
     * want to delegate all the DOM manipulations to it.
     *
     * Note that if you disable this modifier, you must make sure the popper element
     * has its position set to `absolute` before Popper.js can do its work!
     *
     * Just disable this modifier and define your own to achieve the desired effect.
     *
     * @memberof modifiers
     * @inner
     */
    applyStyle: {
      /** @prop {number} order=900 - Index used to define the order of execution */
      order: 900,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: applyStyle,
      /** @prop {Function} */
      onLoad: applyStyleOnLoad,
      /**
       * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: undefined
    }
  };

  /**
   * The `dataObject` is an object containing all the information used by Popper.js.
   * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
   * @name dataObject
   * @property {Object} data.instance The Popper.js instance
   * @property {String} data.placement Placement applied to popper
   * @property {String} data.originalPlacement Placement originally defined on init
   * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
   * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
   * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
   * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.boundaries Offsets of the popper boundaries
   * @property {Object} data.offsets The measurements of popper, reference and arrow elements
   * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
   */

  /**
   * Default options provided to Popper.js constructor.<br />
   * These can be overridden using the `options` argument of Popper.js.<br />
   * To override an option, simply pass an object with the same
   * structure of the `options` object, as the 3rd argument. For example:
   * ```
   * new Popper(ref, pop, {
   *   modifiers: {
   *     preventOverflow: { enabled: false }
   *   }
   * })
   * ```
   * @type {Object}
   * @static
   * @memberof Popper
   */
  var Defaults = {
    /**
     * Popper's placement.
     * @prop {Popper.placements} placement='bottom'
     */
    placement: 'bottom',

    /**
     * Set this to true if you want popper to position it self in 'fixed' mode
     * @prop {Boolean} positionFixed=false
     */
    positionFixed: false,

    /**
     * Whether events (resize, scroll) are initially enabled.
     * @prop {Boolean} eventsEnabled=true
     */
    eventsEnabled: true,

    /**
     * Set to true if you want to automatically remove the popper when
     * you call the `destroy` method.
     * @prop {Boolean} removeOnDestroy=false
     */
    removeOnDestroy: false,

    /**
     * Callback called when the popper is created.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onCreate}
     */
    onCreate: function onCreate() {},

    /**
     * Callback called when the popper is updated. This callback is not called
     * on the initialization/creation of the popper, but only on subsequent
     * updates.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onUpdate}
     */
    onUpdate: function onUpdate() {},

    /**
     * List of modifiers used to modify the offsets before they are applied to the popper.
     * They provide most of the functionalities of Popper.js.
     * @prop {modifiers}
     */
    modifiers: modifiers
  };

  /**
   * @callback onCreate
   * @param {dataObject} data
   */

  /**
   * @callback onUpdate
   * @param {dataObject} data
   */

  // Utils
  // Methods
  var Popper = function () {
    /**
     * Creates a new Popper.js instance.
     * @class Popper
     * @param {HTMLElement|referenceObject} reference - The reference element used to position the popper
     * @param {HTMLElement} popper - The HTML element used as the popper
     * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
     * @return {Object} instance - The generated Popper.js instance
     */
    function Popper(reference, popper) {
      var _this = this;

      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      classCallCheck$1(this, Popper);

      this.scheduleUpdate = function () {
        return requestAnimationFrame(_this.update);
      };

      // make update() debounced, so that it only runs at most once-per-tick
      this.update = debounce$1(this.update.bind(this));

      // with {} we create a new object with the options inside it
      this.options = _extends({}, Popper.Defaults, options);

      // init state
      this.state = {
        isDestroyed: false,
        isCreated: false,
        scrollParents: []
      };

      // get reference and popper elements (allow jQuery wrappers)
      this.reference = reference && reference.jquery ? reference[0] : reference;
      this.popper = popper && popper.jquery ? popper[0] : popper;

      // Deep merge modifiers options
      this.options.modifiers = {};
      Object.keys(_extends({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
        _this.options.modifiers[name] = _extends({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
      });

      // Refactoring modifiers' list (Object => Array)
      this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
        return _extends({
          name: name
        }, _this.options.modifiers[name]);
      })
      // sort the modifiers by order
      .sort(function (a, b) {
        return a.order - b.order;
      });

      // modifiers have the ability to execute arbitrary code when Popper.js get inited
      // such code is executed in the same order of its modifier
      // they could add new properties to their options configuration
      // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
      this.modifiers.forEach(function (modifierOptions) {
        if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
          modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
        }
      });

      // fire the first update to position the popper in the right place
      this.update();

      var eventsEnabled = this.options.eventsEnabled;
      if (eventsEnabled) {
        // setup event listeners, they will take care of update the position in specific situations
        this.enableEventListeners();
      }

      this.state.eventsEnabled = eventsEnabled;
    }

    // We can't use class properties because they don't get listed in the
    // class prototype and break stuff like Sinon stubs


    createClass$1(Popper, [{
      key: 'update',
      value: function update$$1() {
        return update.call(this);
      }
    }, {
      key: 'destroy',
      value: function destroy$$1() {
        return destroy.call(this);
      }
    }, {
      key: 'enableEventListeners',
      value: function enableEventListeners$$1() {
        return enableEventListeners.call(this);
      }
    }, {
      key: 'disableEventListeners',
      value: function disableEventListeners$$1() {
        return disableEventListeners.call(this);
      }

      /**
       * Schedules an update. It will run on the next UI update available.
       * @method scheduleUpdate
       * @memberof Popper
       */


      /**
       * Collection of utilities useful when writing custom modifiers.
       * Starting from version 1.7, this method is available only if you
       * include `popper-utils.js` before `popper.js`.
       *
       * **DEPRECATION**: This way to access PopperUtils is deprecated
       * and will be removed in v2! Use the PopperUtils module directly instead.
       * Due to the high instability of the methods contained in Utils, we can't
       * guarantee them to follow semver. Use them at your own risk!
       * @static
       * @private
       * @type {Object}
       * @deprecated since version 1.8
       * @member Utils
       * @memberof Popper
       */

    }]);
    return Popper;
  }();

  /**
   * The `referenceObject` is an object that provides an interface compatible with Popper.js
   * and lets you use it as replacement of a real DOM node.<br />
   * You can use this method to position a popper relatively to a set of coordinates
   * in case you don't have a DOM node to use as reference.
   *
   * ```
   * new Popper(referenceObject, popperNode);
   * ```
   *
   * NB: This feature isn't supported in Internet Explorer 10.
   * @name referenceObject
   * @property {Function} data.getBoundingClientRect
   * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
   * @property {number} data.clientWidth
   * An ES6 getter that will return the width of the virtual reference element.
   * @property {number} data.clientHeight
   * An ES6 getter that will return the height of the virtual reference element.
   */


  Popper.Utils = (typeof window !== 'undefined' ? window : global$1).PopperUtils;
  Popper.placements = placements;
  Popper.Defaults = Defaults;

  function flipPlacement(placement) {
    var direction = typeof window !== 'undefined' && document.body.getAttribute('dir') || 'ltr';

    if (direction !== 'rtl') {
      return placement;
    }

    switch (placement) {
      case 'bottom-end':
        return 'bottom-start';

      case 'bottom-start':
        return 'bottom-end';

      case 'top-end':
        return 'top-start';

      case 'top-start':
        return 'top-end';

      default:
        return placement;
    }
  }

  function getAnchorEl$1(anchorEl) {
    return typeof anchorEl === 'function' ? anchorEl() : anchorEl;
  }
  /**
   * Poppers rely on the 3rd party library [Popper.js](https://github.com/FezVrasta/popper.js) for positioning.
   */


  var Popper$1 =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Popper$$1, _React$Component);

    function Popper$$1(props) {
      var _this;

      classCallCheck(this, Popper$$1);

      _this = possibleConstructorReturn(this, getPrototypeOf(Popper$$1).call(this));

      _this.handleOpen = function () {
        var _this$props = _this.props,
            anchorEl = _this$props.anchorEl,
            modifiers = _this$props.modifiers,
            open = _this$props.open,
            placement = _this$props.placement,
            _this$props$popperOpt = _this$props.popperOptions,
            popperOptions = _this$props$popperOpt === void 0 ? {} : _this$props$popperOpt,
            disablePortal = _this$props.disablePortal;
        var popperNode = ReactDOM.findDOMNode(assertThisInitialized(assertThisInitialized(_this)));

        if (!popperNode || !anchorEl || !open) {
          return;
        }

        if (_this.popper) {
          _this.popper.destroy();

          _this.popper = null;
        }

        _this.popper = new Popper(getAnchorEl$1(anchorEl), popperNode, _extends_1({
          placement: flipPlacement(placement)
        }, popperOptions, {
          modifiers: _extends_1({}, disablePortal ? {} : {
            // It's using scrollParent by default, we can use the viewport when using a portal.
            preventOverflow: {
              boundariesElement: 'window'
            }
          }, modifiers, popperOptions.modifiers),
          // We could have been using a custom modifier like react-popper is doing.
          // But it seems this is the best public API for this use case.
          onCreate: _this.handlePopperUpdate,
          onUpdate: _this.handlePopperUpdate
        }));
      };

      _this.handlePopperUpdate = function (data) {
        if (data.placement !== _this.state.placement) {
          _this.setState({
            placement: data.placement
          });
        }
      };

      _this.handleExited = function () {
        _this.setState({
          exited: true
        });

        _this.handleClose();
      };

      _this.handleClose = function () {
        if (!_this.popper) {
          return;
        }

        _this.popper.destroy();

        _this.popper = null;
      };

      _this.state = {
        exited: !props.open
      };
      return _this;
    }

    createClass(Popper$$1, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (prevProps.open !== this.props.open && !this.props.open && !this.props.transition) {
          // Otherwise handleExited will call this.
          this.handleClose();
        } // Let's update the popper position.


        if (prevProps.open !== this.props.open || prevProps.anchorEl !== this.props.anchorEl || prevProps.popperOptions !== this.props.popperOptions || prevProps.modifiers !== this.props.modifiers || prevProps.disablePortal !== this.props.disablePortal || prevProps.placement !== this.props.placement) {
          this.handleOpen();
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.handleClose();
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props2 = this.props,
            anchorEl = _this$props2.anchorEl,
            children = _this$props2.children,
            container = _this$props2.container,
            disablePortal = _this$props2.disablePortal,
            keepMounted = _this$props2.keepMounted,
            modifiers = _this$props2.modifiers,
            open = _this$props2.open,
            placementProps = _this$props2.placement,
            popperOptions = _this$props2.popperOptions,
            transition = _this$props2.transition,
            other = objectWithoutProperties(_this$props2, ["anchorEl", "children", "container", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "transition"]);

        var _this$state = this.state,
            exited = _this$state.exited,
            placement = _this$state.placement;

        if (!keepMounted && !open && (!transition || exited)) {
          return null;
        }

        var childProps = {
          placement: placement || flipPlacement(placementProps)
        };

        if (transition) {
          childProps.TransitionProps = {
            in: open,
            onExited: this.handleExited
          };
        }

        return React.createElement(Portal, {
          onRendered: this.handleOpen,
          disablePortal: disablePortal,
          container: container
        }, React.createElement("div", _extends_1({
          role: "tooltip",
          style: {
            // Prevents scroll issue, waiting for Popper.js to add this style once initiated.
            position: 'absolute'
          }
        }, other), typeof children === 'function' ? children(childProps) : children));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(nextProps) {
        if (nextProps.open) {
          return {
            exited: false
          };
        }

        if (!nextProps.transition) {
          // Otherwise let handleExited take care of marking exited.
          return {
            exited: true
          };
        }

        return null;
      }
    }]);

    return Popper$$1;
  }(React.Component);

  Popper$1.propTypes = {
    /**
     * This is the DOM element, or a function that returns the DOM element,
     * that may be used to set the position of the popover.
     * The return value will passed as the reference object of the Popper
     * instance.
     */
    anchorEl: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * Popper render function or node.
     */
    children: propTypes.oneOfType([propTypes.node, propTypes.func]).isRequired,

    /**
     * A node, component instance, or function that returns either.
     * The `container` will passed to the Modal component.
     * By default, it uses the body of the anchorEl's top-level document object,
     * so it's simply `document.body` most of the time.
     */
    container: propTypes.oneOfType([propTypes.object, propTypes.func]),

    /**
     * Disable the portal behavior.
     * The children stay within it's parent DOM hierarchy.
     */
    disablePortal: propTypes.bool,

    /**
     * Always keep the children in the DOM.
     * This property can be useful in SEO situation or
     * when you want to maximize the responsiveness of the Popper.
     */
    keepMounted: propTypes.bool,

    /**
     * Popper.js is based on a "plugin-like" architecture,
     * most of its features are fully encapsulated "modifiers".
     *
     * A modifier is a function that is called each time Popper.js needs to
     * compute the position of the popper.
     * For this reason, modifiers should be very performant to avoid bottlenecks.
     * To learn how to create a modifier, [read the modifiers documentation](https://github.com/FezVrasta/popper.js/blob/master/docs/_includes/popper-documentation.md#modifiers--object).
     */
    modifiers: propTypes.object,

    /**
     * If `true`, the popper is visible.
     */
    open: propTypes.bool.isRequired,

    /**
     * Popper placement.
     */
    placement: propTypes.oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

    /**
     * Options provided to the [`popper.js`](https://github.com/FezVrasta/popper.js) instance.
     */
    popperOptions: propTypes.object,

    /**
     * Help supporting a react-transition-group/Transition component.
     */
    transition: propTypes.bool
  };
  Popper$1.defaultProps = {
    disablePortal: false,
    placement: 'bottom',
    transition: false
  };

  /**
   * @ignore - internal component.
   */

  var _ref$5 = React.createElement("path", {
    d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"
  });

  var RadioButtonUnchecked = function RadioButtonUnchecked(props) {
    return React.createElement(SvgIcon$1, props, _ref$5);
  };

  RadioButtonUnchecked = pure(RadioButtonUnchecked);
  RadioButtonUnchecked.muiName = 'SvgIcon';
  var RadioButtonUncheckedIcon = RadioButtonUnchecked;

  /**
   * @ignore - internal component.
   */

  var _ref$6 = React.createElement("path", {
    d: "M12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zm0-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z"
  });

  var RadioButtonChecked = function RadioButtonChecked(props) {
    return React.createElement(SvgIcon$1, props, _ref$6);
  };

  RadioButtonChecked = pure(RadioButtonChecked);
  RadioButtonChecked.muiName = 'SvgIcon';
  var RadioButtonCheckedIcon = RadioButtonChecked;

  var styles$1a = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        color: theme.palette.text.secondary
      },

      /* Styles applied to the root element if `checked={true}`. */
      checked: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the root element if `color="primary"`. */
      colorPrimary: {
        '&$checked': {
          color: theme.palette.primary.main
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      },

      /* Styles applied to the root element if `color="secondary"`. */
      colorSecondary: {
        '&$checked': {
          color: theme.palette.secondary.main
        },
        '&$disabled': {
          color: theme.palette.action.disabled
        }
      }
    };
  };

  var _ref$7 = React.createElement(RadioButtonUncheckedIcon, null);

  var _ref2 = React.createElement(RadioButtonCheckedIcon, null);

  function Radio(props) {
    var classes = props.classes,
        color = props.color,
        other = objectWithoutProperties(props, ["classes", "color"]);

    return React.createElement(SwitchBase$1, _extends_1({
      type: "radio",
      icon: _ref$7,
      checkedIcon: _ref2,
      classes: {
        root: classnames(classes.root, classes["color".concat(capitalize(color))]),
        checked: classes.checked,
        disabled: classes.disabled
      }
    }, other));
  }

  Radio.propTypes = {
    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.oneOfType([propTypes.bool, propTypes.string]),

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'default']),

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     * @param {boolean} checked The `checked` value of the switch
     */
    onChange: propTypes.func,

    /**
     * The input component property `type`.
     */
    type: propTypes.string,

    /**
     * The value of the component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool])
  };
  Radio.defaultProps = {
    color: 'secondary'
  };
  var Radio$1 = withStyles(styles$1a, {
    name: 'MuiRadio'
  })(Radio);

  var RadioGroup =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(RadioGroup, _React$Component);

    function RadioGroup(props) {
      var _this;

      classCallCheck(this, RadioGroup);

      _this = possibleConstructorReturn(this, getPrototypeOf(RadioGroup).call(this));
      _this.radios = [];

      _this.focus = function () {
        if (!_this.radios || !_this.radios.length) {
          return;
        }

        var focusRadios = _this.radios.filter(function (n) {
          return !n.disabled;
        });

        if (!focusRadios.length) {
          return;
        }

        var selectedRadio = find(focusRadios, function (n) {
          return n.checked;
        });

        if (selectedRadio) {
          selectedRadio.focus();
          return;
        }

        focusRadios[0].focus();
      };

      _this.handleChange = function (event) {
        if (!_this.isControlled) {
          _this.setState({
            value: event.target.value
          });
        }

        if (_this.props.onChange) {
          _this.props.onChange(event, event.target.value);
        }
      };

      _this.isControlled = props.value != null;

      if (!_this.isControlled) {
        _this.state = {
          value: props.defaultValue
        };
      }

      return _this;
    }

    createClass(RadioGroup, [{
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            children = _this$props.children,
            name = _this$props.name,
            valueProp = _this$props.value,
            onChange = _this$props.onChange,
            other = objectWithoutProperties(_this$props, ["children", "name", "value", "onChange"]);

        var value = this.isControlled ? valueProp : this.state.value;
        this.radios = [];
        return React.createElement(FormGroup$1, _extends_1({
          role: "radiogroup"
        }, other), React.Children.map(children, function (child) {
          if (!React.isValidElement(child)) {
            return null;
          }

          warning_1(child.type !== React.Fragment, ["Material-UI: the RadioGroup component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
          return React.cloneElement(child, {
            name: name,
            inputRef: function inputRef(node) {
              if (node) {
                _this2.radios.push(node);
              }
            },
            checked: value === child.props.value,
            onChange: createChainedFunction(child.props.onChange, _this2.handleChange)
          });
        }));
      }
    }]);

    return RadioGroup;
  }(React.Component);

  RadioGroup.propTypes = {
    /**
     * The content of the component.
     */
    children: propTypes.node,

    /**
     * The default input value, useful when not controlling the component.
     */
    defaultValue: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool]),

    /**
     * The name used to reference the value of the control.
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback fired when a radio button is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     * @param {string} value The `value` of the selected radio button
     */
    onChange: propTypes.func,

    /**
     * @ignore
     */
    onKeyDown: propTypes.func,

    /**
     * Value of the selected radio button.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool])
  };

  function areEqualValues(a, b) {
    if (_typeof_1(b) === 'object' && b !== null) {
      return a === b;
    }

    return String(a) === String(b);
  }
  /**
   * @ignore - internal component.
   */


  var SelectInput =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(SelectInput, _React$Component);

    function SelectInput(props) {
      var _this;

      classCallCheck(this, SelectInput);

      _this = possibleConstructorReturn(this, getPrototypeOf(SelectInput).call(this));
      _this.ignoreNextBlur = false;

      _this.update = function (_ref) {
        var event = _ref.event,
            open = _ref.open;

        if (_this.isOpenControlled) {
          if (open) {
            _this.props.onOpen(event);
          } else {
            _this.props.onClose(event);
          }

          return;
        }

        _this.setState({
          // Perform the layout computation outside of the render method.
          menuMinWidth: _this.props.autoWidth ? null : _this.displayRef.clientWidth,
          open: open
        });
      };

      _this.handleClick = function (event) {
        // Opening the menu is going to blur the. It will be focused back when closed.
        _this.ignoreNextBlur = true;

        _this.update({
          open: true,
          event: event
        });
      };

      _this.handleClose = function (event) {
        _this.update({
          open: false,
          event: event
        });
      };

      _this.handleItemClick = function (child) {
        return function (event) {
          if (!_this.props.multiple) {
            _this.update({
              open: false,
              event: event
            });
          }

          var _this$props = _this.props,
              onChange = _this$props.onChange,
              name = _this$props.name;

          if (onChange) {
            var value;

            if (_this.props.multiple) {
              value = Array.isArray(_this.props.value) ? toConsumableArray(_this.props.value) : [];
              var itemIndex = value.indexOf(child.props.value);

              if (itemIndex === -1) {
                value.push(child.props.value);
              } else {
                value.splice(itemIndex, 1);
              }
            } else {
              value = child.props.value;
            }

            event.persist();
            event.target = {
              value: value,
              name: name
            };
            onChange(event, child);
          }
        };
      };

      _this.handleBlur = function (event) {
        if (_this.ignoreNextBlur === true) {
          // The parent components are relying on the bubbling of the event.
          event.stopPropagation();
          _this.ignoreNextBlur = false;
          return;
        }

        if (_this.props.onBlur) {
          var _this$props2 = _this.props,
              value = _this$props2.value,
              name = _this$props2.name;
          event.persist();
          event.target = {
            value: value,
            name: name
          };

          _this.props.onBlur(event);
        }
      };

      _this.handleKeyDown = function (event) {
        if (_this.props.readOnly) {
          return;
        }

        if ([' ', 'ArrowUp', 'ArrowDown', // The native select doesn't respond to enter on MacOS, but it's recommended by
        // https://www.w3.org/TR/wai-aria-practices/examples/listbox/listbox-collapsible.html
        'Enter'].indexOf(event.key) !== -1) {
          event.preventDefault(); // Opening the menu is going to blur the. It will be focused back when closed.

          _this.ignoreNextBlur = true;

          _this.update({
            open: true,
            event: event
          });
        }
      };

      _this.handleDisplayRef = function (ref) {
        _this.displayRef = ref;
      };

      _this.handleInputRef = function (ref) {
        var inputRef = _this.props.inputRef;

        if (!inputRef) {
          return;
        }

        var nodeProxy = {
          node: ref,
          // By pass the native input as we expose a rich object (array).
          value: _this.props.value,
          focus: function focus() {
            _this.displayRef.focus();
          }
        };
        setRef(inputRef, nodeProxy);
      };

      _this.isOpenControlled = props.open !== undefined;
      _this.state = {
        menuMinWidth: null,
        open: false
      };
      return _this;
    }

    createClass(SelectInput, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.isOpenControlled && this.props.open) {
          // Focus the display node so the focus is restored on this element once
          // the menu is closed.
          this.displayRef.focus(); // Rerender with the resolve `displayRef` reference.

          this.forceUpdate();
        }

        if (this.props.autoFocus) {
          this.displayRef.focus();
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this,
            _classNames;

        var _this$props3 = this.props,
            autoWidth = _this$props3.autoWidth,
            children = _this$props3.children,
            classes = _this$props3.classes,
            className = _this$props3.className,
            disabled = _this$props3.disabled,
            displayEmpty = _this$props3.displayEmpty,
            IconComponent = _this$props3.IconComponent,
            inputRef = _this$props3.inputRef,
            _this$props3$MenuProp = _this$props3.MenuProps,
            MenuProps = _this$props3$MenuProp === void 0 ? {} : _this$props3$MenuProp,
            multiple = _this$props3.multiple,
            name = _this$props3.name,
            onBlur = _this$props3.onBlur,
            onChange = _this$props3.onChange,
            onClose = _this$props3.onClose,
            onFocus = _this$props3.onFocus,
            onOpen = _this$props3.onOpen,
            openProp = _this$props3.open,
            readOnly = _this$props3.readOnly,
            renderValue = _this$props3.renderValue,
            required = _this$props3.required,
            SelectDisplayProps = _this$props3.SelectDisplayProps,
            tabIndexProp = _this$props3.tabIndex,
            _this$props3$type = _this$props3.type,
            type = _this$props3$type === void 0 ? 'hidden' : _this$props3$type,
            value = _this$props3.value,
            variant = _this$props3.variant,
            other = objectWithoutProperties(_this$props3, ["autoWidth", "children", "classes", "className", "disabled", "displayEmpty", "IconComponent", "inputRef", "MenuProps", "multiple", "name", "onBlur", "onChange", "onClose", "onFocus", "onOpen", "open", "readOnly", "renderValue", "required", "SelectDisplayProps", "tabIndex", "type", "value", "variant"]);

        var open = this.isOpenControlled && this.displayRef ? openProp : this.state.open;
        delete other['aria-invalid'];
        var display;
        var displaySingle = '';
        var displayMultiple = [];
        var computeDisplay = false; // No need to display any value if the field is empty.

        if (isFilled(this.props) || displayEmpty) {
          if (renderValue) {
            display = renderValue(value);
          } else {
            computeDisplay = true;
          }
        }

        var items = React.Children.map(children, function (child) {
          if (!React.isValidElement(child)) {
            return null;
          }

          warning_1(child.type !== React.Fragment, ["Material-UI: the Select component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
          var selected;

          if (multiple) {
            if (!Array.isArray(value)) {
              throw new Error('Material-UI: the `value` property must be an array ' + 'when using the `Select` component with `multiple`.');
            }

            selected = value.some(function (v) {
              return areEqualValues(v, child.props.value);
            });

            if (selected && computeDisplay) {
              displayMultiple.push(child.props.children);
            }
          } else {
            selected = areEqualValues(value, child.props.value);

            if (selected && computeDisplay) {
              displaySingle = child.props.children;
            }
          }

          return React.cloneElement(child, {
            onClick: _this2.handleItemClick(child),
            role: 'option',
            selected: selected,
            value: undefined,
            // The value is most likely not a valid HTML attribute.
            'data-value': child.props.value // Instead, we provide it as a data attribute.

          });
        });

        if (computeDisplay) {
          display = multiple ? displayMultiple.join(', ') : displaySingle;
        } // Avoid performing a layout computation in the render method.


        var menuMinWidth = this.state.menuMinWidth;

        if (!autoWidth && this.isOpenControlled && this.displayRef) {
          menuMinWidth = this.displayRef.clientWidth;
        }

        var tabIndex;

        if (typeof tabIndexProp !== 'undefined') {
          tabIndex = tabIndexProp;
        } else {
          tabIndex = disabled ? null : 0;
        }

        return React.createElement("div", {
          className: classes.root
        }, React.createElement("div", _extends_1({
          className: classnames(classes.select, classes.selectMenu, (_classNames = {}, defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.filled, variant === 'filled'), defineProperty(_classNames, classes.outlined, variant === 'outlined'), _classNames), className),
          ref: this.handleDisplayRef,
          "aria-pressed": open ? 'true' : 'false',
          tabIndex: tabIndex,
          role: "button",
          "aria-owns": open ? "menu-".concat(name || '') : undefined,
          "aria-haspopup": "true",
          onKeyDown: this.handleKeyDown,
          onBlur: this.handleBlur,
          onClick: disabled || readOnly ? null : this.handleClick,
          onFocus: onFocus // The id can help with end-to-end testing automation.
          ,
          id: name ? "select-".concat(name) : undefined
        }, SelectDisplayProps), display || React.createElement("span", {
          dangerouslySetInnerHTML: {
            __html: '&#8203;'
          }
        })), React.createElement("input", _extends_1({
          value: Array.isArray(value) ? value.join(',') : value,
          name: name,
          ref: this.handleInputRef,
          type: type
        }, other)), React.createElement(IconComponent, {
          className: classes.icon
        }), React.createElement(Menu$1, _extends_1({
          id: "menu-".concat(name || ''),
          anchorEl: this.displayRef,
          open: open,
          onClose: this.handleClose
        }, MenuProps, {
          MenuListProps: _extends_1({
            role: 'listbox',
            disableListWrap: true
          }, MenuProps.MenuListProps),
          PaperProps: _extends_1({}, MenuProps.PaperProps, {
            style: _extends_1({
              minWidth: menuMinWidth
            }, MenuProps.PaperProps != null ? MenuProps.PaperProps.style : null)
          })
        }), items));
      }
    }]);

    return SelectInput;
  }(React.Component);

  SelectInput.propTypes = {
    /**
     * @ignore
     */
    autoFocus: propTypes.bool,

    /**
     * If true, the width of the popover will automatically be set according to the items inside the
     * menu, otherwise it will be at least the width of the select input.
     */
    autoWidth: propTypes.bool,

    /**
     * The option elements to populate the select with.
     * Can be some `<MenuItem>` elements.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * The CSS class name of the select element.
     */
    className: propTypes.string,

    /**
     * If `true`, the select will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the selected item is displayed even if its value is empty.
     */
    displayEmpty: propTypes.bool,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: componentPropType,

    /**
     * Use that property to pass a ref callback to the native select element.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * Properties applied to the [`Menu`](/api/menu/) element.
     */
    MenuProps: propTypes.object,

    /**
     * If true, `value` must be an array and the menu will support multiple selections.
     */
    multiple: propTypes.bool,

    /**
     * Name attribute of the `select` or hidden `input` element.
     */
    name: propTypes.string,

    /**
     * @ignore
     */
    onBlur: propTypes.func,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     * @param {object} [child] The react element that was selected.
     */
    onChange: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback
     */
    onClose: propTypes.func,

    /**
     * @ignore
     */
    onFocus: propTypes.func,

    /**
     * Callback fired when the component requests to be opened.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback
     */
    onOpen: propTypes.func,

    /**
     * Control `select` open state.
     */
    open: propTypes.bool,

    /**
     * @ignore
     */
    readOnly: propTypes.bool,

    /**
     * Render the selected value.
     *
     * @param {*} value The `value` provided to the component.
     * @returns {ReactElement}
     */
    renderValue: propTypes.func,

    /**
     * @ignore
     */
    required: propTypes.bool,

    /**
     * Properties applied to the clickable div element.
     */
    SelectDisplayProps: propTypes.object,

    /**
     * @ignore
     */
    tabIndex: propTypes.oneOfType([propTypes.number, propTypes.string]),

    /**
     * @ignore
     */
    type: propTypes.string,

    /**
     * The input value.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))]).isRequired,

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };

  var styles$1b = styles$17;

  function Select(props) {
    var autoWidth = props.autoWidth,
        children = props.children,
        classes = props.classes,
        displayEmpty = props.displayEmpty,
        IconComponent = props.IconComponent,
        input = props.input,
        inputProps = props.inputProps,
        MenuProps = props.MenuProps,
        muiFormControl = props.muiFormControl,
        multiple = props.multiple,
        native = props.native,
        onClose = props.onClose,
        onOpen = props.onOpen,
        open = props.open,
        renderValue = props.renderValue,
        SelectDisplayProps = props.SelectDisplayProps,
        variant = props.variant,
        other = objectWithoutProperties(props, ["autoWidth", "children", "classes", "displayEmpty", "IconComponent", "input", "inputProps", "MenuProps", "muiFormControl", "multiple", "native", "onClose", "onOpen", "open", "renderValue", "SelectDisplayProps", "variant"]);

    var inputComponent = native ? NativeSelectInput : SelectInput;
    var fcs = formControlState({
      props: props,
      muiFormControl: muiFormControl,
      states: ['variant']
    });
    return React.cloneElement(input, _extends_1({
      // Most of the logic is implemented in `SelectInput`.
      // The `Select` component is a simple API wrapper to expose something better to play with.
      inputComponent: inputComponent,
      inputProps: _extends_1({
        children: children,
        IconComponent: IconComponent,
        variant: fcs.variant,
        type: undefined,
        // We render a select. We can ignore the type provided by the `Input`.
        multiple: multiple
      }, native ? {} : {
        autoWidth: autoWidth,
        displayEmpty: displayEmpty,
        MenuProps: MenuProps,
        onClose: onClose,
        onOpen: onOpen,
        open: open,
        renderValue: renderValue,
        SelectDisplayProps: SelectDisplayProps
      }, inputProps, {
        classes: inputProps ? mergeClasses({
          baseClasses: classes,
          newClasses: inputProps.classes,
          Component: Select
        }) : classes
      }, input ? input.props.inputProps : {})
    }, other));
  }

  Select.propTypes = {
    /**
     * If true, the width of the popover will automatically be set according to the items inside the
     * menu, otherwise it will be at least the width of the select input.
     */
    autoWidth: propTypes.bool,

    /**
     * The option elements to populate the select with.
     * Can be some `MenuItem` when `native` is false and `option` when `native` is true.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * If `true`, the selected item is displayed even if its value is empty.
     * You can only use it when the `native` property is `false` (default).
     */
    displayEmpty: propTypes.bool,

    /**
     * The icon that displays the arrow.
     */
    IconComponent: componentPropType,

    /**
     * An `Input` element; does not have to be a material-ui specific `Input`.
     */
    input: propTypes.element,

    /**
     * Attributes applied to the `input` element.
     * When `native` is `true`, the attributes are applied on the `select` element.
     */
    inputProps: propTypes.object,

    /**
     * Properties applied to the [`Menu`](/api/menu/) element.
     */
    MenuProps: propTypes.object,

    /**
     * If true, `value` must be an array and the menu will support multiple selections.
     */
    multiple: propTypes.bool,

    /**
     * If `true`, the component will be using a native `select` element.
     */
    native: propTypes.bool,

    /**
     * Callback function fired when a menu item is selected.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.value`.
     * @param {object} [child] The react element that was selected when `native` is `false` (default).
     */
    onChange: propTypes.func,

    /**
     * Callback fired when the component requests to be closed.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback
     */
    onClose: propTypes.func,

    /**
     * Callback fired when the component requests to be opened.
     * Use in controlled mode (see open).
     *
     * @param {object} event The event source of the callback
     */
    onOpen: propTypes.func,

    /**
     * Control `select` open state.
     * You can only use it when the `native` property is `false` (default).
     */
    open: propTypes.bool,

    /**
     * Render the selected value.
     * You can only use it when the `native` property is `false` (default).
     *
     * @param {*} value The `value` provided to the component.
     * @returns {ReactElement}
     */
    renderValue: propTypes.func,

    /**
     * Properties applied to the clickable div element.
     */
    SelectDisplayProps: propTypes.object,

    /**
     * The input value.
     * This property is required when the `native` property is `false` (default).
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object, propTypes.arrayOf(propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool, propTypes.object]))]),

    /**
     * The variant to use.
     */
    variant: propTypes.oneOf(['standard', 'outlined', 'filled'])
  };
  Select.defaultProps = {
    autoWidth: false,
    displayEmpty: false,
    IconComponent: ArrowDropDownIcon,
    input: React.createElement(Input$1, null),
    multiple: false,
    native: false
  };
  Select.muiName = 'Select';
  var Select$1 = withStyles(styles$1b, {
    name: 'MuiSelect'
  })(withFormControlContext(Select));

  var styles$1c = function styles(theme) {
    var _root;

    var emphasis = theme.palette.type === 'light' ? 0.8 : 0.98;
    var backgroundColor = emphasize(theme.palette.background.default, emphasis);
    return {
      /* Styles applied to the root element. */
      root: (_root = {
        color: theme.palette.getContrastText(backgroundColor),
        backgroundColor: backgroundColor,
        display: 'flex',
        alignItems: 'center',
        flexWrap: 'wrap',
        padding: '6px 24px'
      }, defineProperty(_root, theme.breakpoints.up('md'), {
        minWidth: 288,
        maxWidth: 568,
        borderRadius: theme.shape.borderRadius
      }), defineProperty(_root, theme.breakpoints.down('sm'), {
        flexGrow: 1
      }), _root),

      /* Styles applied to the message wrapper element. */
      message: {
        padding: '8px 0'
      },

      /* Styles applied to the action wrapper element if `action` is provided. */
      action: {
        display: 'flex',
        alignItems: 'center',
        marginLeft: 'auto',
        paddingLeft: 24,
        marginRight: -8
      }
    };
  };

  function SnackbarContent(props) {
    var action = props.action,
        classes = props.classes,
        className = props.className,
        message = props.message,
        other = objectWithoutProperties(props, ["action", "classes", "className", "message"]);

    return React.createElement(Paper$1, _extends_1({
      component: Typography$1,
      headlineMapping: {
        body1: 'div',
        body2: 'div'
      },
      role: "alertdialog",
      square: true,
      elevation: 6,
      className: classnames(classes.root, className)
    }, other), React.createElement("div", {
      className: classes.message
    }, message), action ? React.createElement("div", {
      className: classes.action
    }, action) : null);
  }

  SnackbarContent.propTypes = {
    /**
     * The action to display.
     */
    action: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The message to display.
     */
    message: propTypes.node
  };
  var SnackbarContent$1 = withStyles(styles$1c, {
    name: 'MuiSnackbarContent'
  })(SnackbarContent);

  var styles$1d = function styles(theme) {
    var gutter = 24;
    var top = {
      top: 0
    };
    var bottom = {
      bottom: 0
    };
    var right = {
      justifyContent: 'flex-end'
    };
    var left = {
      justifyContent: 'flex-start'
    };
    var topSpace = {
      top: gutter
    };
    var bottomSpace = {
      bottom: gutter
    };
    var rightSpace = {
      right: gutter
    };
    var leftSpace = {
      left: gutter
    };
    var center = {
      left: '50%',
      right: 'auto',
      transform: 'translateX(-50%)'
    };
    return {
      /* Styles applied to the root element. */
      root: {
        zIndex: theme.zIndex.snackbar,
        position: 'fixed',
        display: 'flex',
        left: 0,
        right: 0,
        justifyContent: 'center',
        alignItems: 'center'
      },

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'center' }}`. */
      anchorOriginTopCenter: _extends_1({}, top, defineProperty({}, theme.breakpoints.up('md'), _extends_1({}, center))),

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'center' }}`. */
      anchorOriginBottomCenter: _extends_1({}, bottom, defineProperty({}, theme.breakpoints.up('md'), _extends_1({}, center))),

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'right' }}`. */
      anchorOriginTopRight: _extends_1({}, top, right, defineProperty({}, theme.breakpoints.up('md'), _extends_1({
        left: 'auto'
      }, topSpace, rightSpace))),

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'right' }}`. */
      anchorOriginBottomRight: _extends_1({}, bottom, right, defineProperty({}, theme.breakpoints.up('md'), _extends_1({
        left: 'auto'
      }, bottomSpace, rightSpace))),

      /* Styles applied to the root element if `anchorOrigin={{ 'top', 'left' }}`. */
      anchorOriginTopLeft: _extends_1({}, top, left, defineProperty({}, theme.breakpoints.up('md'), _extends_1({
        right: 'auto'
      }, topSpace, leftSpace))),

      /* Styles applied to the root element if `anchorOrigin={{ 'bottom', 'left' }}`. */
      anchorOriginBottomLeft: _extends_1({}, bottom, left, defineProperty({}, theme.breakpoints.up('md'), _extends_1({
        right: 'auto'
      }, bottomSpace, leftSpace)))
    };
  };
  /* istanbul ignore if */

  if (!React.createContext) {
    throw new Error('Material-UI: react@16.3.0 or greater is required.');
  }

  var Snackbar =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Snackbar, _React$Component);

    function Snackbar() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Snackbar);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Snackbar)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {};

      _this.handleMouseEnter = function (event) {
        if (_this.props.onMouseEnter) {
          _this.props.onMouseEnter(event);
        }

        _this.handlePause();
      };

      _this.handleMouseLeave = function (event) {
        if (_this.props.onMouseLeave) {
          _this.props.onMouseLeave(event);
        }

        _this.handleResume();
      };

      _this.handleClickAway = function (event) {
        if (_this.props.onClose) {
          _this.props.onClose(event, 'clickaway');
        }
      };

      _this.handlePause = function () {
        clearTimeout(_this.timerAutoHide);
      };

      _this.handleResume = function () {
        if (_this.props.autoHideDuration != null) {
          if (_this.props.resumeHideDuration != null) {
            _this.setAutoHideTimer(_this.props.resumeHideDuration);

            return;
          }

          _this.setAutoHideTimer(_this.props.autoHideDuration * 0.5);
        }
      };

      _this.handleExited = function () {
        _this.setState({
          exited: true
        });
      };

      return _this;
    }

    createClass(Snackbar, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.props.open) {
          this.setAutoHideTimer();
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (prevProps.open !== this.props.open) {
          if (this.props.open) {
            this.setAutoHideTimer();
          } else {
            clearTimeout(this.timerAutoHide);
          }
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.timerAutoHide);
      }
    }, {
      key: "setAutoHideTimer",
      // Timer that controls delay before snackbar auto hides
      value: function setAutoHideTimer(autoHideDuration) {
        var _this2 = this;

        var autoHideDurationBefore = autoHideDuration != null ? autoHideDuration : this.props.autoHideDuration;

        if (!this.props.onClose || autoHideDurationBefore == null) {
          return;
        }

        clearTimeout(this.timerAutoHide);
        this.timerAutoHide = setTimeout(function () {
          var autoHideDurationAfter = autoHideDuration != null ? autoHideDuration : _this2.props.autoHideDuration;

          if (!_this2.props.onClose || autoHideDurationAfter == null) {
            return;
          }

          _this2.props.onClose(null, 'timeout');
        }, autoHideDurationBefore);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            action = _this$props.action,
            _this$props$anchorOri = _this$props.anchorOrigin,
            vertical = _this$props$anchorOri.vertical,
            horizontal = _this$props$anchorOri.horizontal,
            autoHideDuration = _this$props.autoHideDuration,
            children = _this$props.children,
            classes = _this$props.classes,
            className = _this$props.className,
            ClickAwayListenerProps = _this$props.ClickAwayListenerProps,
            ContentProps = _this$props.ContentProps,
            disableWindowBlurListener = _this$props.disableWindowBlurListener,
            message = _this$props.message,
            onClose = _this$props.onClose,
            onEnter = _this$props.onEnter,
            onEntered = _this$props.onEntered,
            onEntering = _this$props.onEntering,
            onExit = _this$props.onExit,
            onExited = _this$props.onExited,
            onExiting = _this$props.onExiting,
            onMouseEnter = _this$props.onMouseEnter,
            onMouseLeave = _this$props.onMouseLeave,
            open = _this$props.open,
            resumeHideDuration = _this$props.resumeHideDuration,
            TransitionComponent = _this$props.TransitionComponent,
            transitionDuration = _this$props.transitionDuration,
            TransitionProps = _this$props.TransitionProps,
            other = objectWithoutProperties(_this$props, ["action", "anchorOrigin", "autoHideDuration", "children", "classes", "className", "ClickAwayListenerProps", "ContentProps", "disableWindowBlurListener", "message", "onClose", "onEnter", "onEntered", "onEntering", "onExit", "onExited", "onExiting", "onMouseEnter", "onMouseLeave", "open", "resumeHideDuration", "TransitionComponent", "transitionDuration", "TransitionProps"]); // So we only render active snackbars.


        if (!open && this.state.exited) {
          return null;
        }

        return React.createElement(ClickAwayListener, _extends_1({
          onClickAway: this.handleClickAway
        }, ClickAwayListenerProps), React.createElement("div", _extends_1({
          className: classnames(classes.root, classes["anchorOrigin".concat(capitalize(vertical)).concat(capitalize(horizontal))], className),
          onMouseEnter: this.handleMouseEnter,
          onMouseLeave: this.handleMouseLeave
        }, other), React.createElement(EventListener, {
          target: "window",
          onFocus: disableWindowBlurListener ? undefined : this.handleResume,
          onBlur: disableWindowBlurListener ? undefined : this.handlePause
        }), React.createElement(TransitionComponent, _extends_1({
          appear: true,
          in: open,
          onEnter: onEnter,
          onEntered: onEntered,
          onEntering: onEntering,
          onExit: onExit,
          onExited: createChainedFunction(this.handleExited, onExited),
          onExiting: onExiting,
          timeout: transitionDuration,
          direction: vertical === 'top' ? 'down' : 'up'
        }, TransitionProps), children || React.createElement(SnackbarContent$1, _extends_1({
          message: message,
          action: action
        }, ContentProps)))));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(nextProps, prevState) {
        if (typeof prevState.exited === 'undefined') {
          return {
            exited: !nextProps.open
          };
        }

        if (nextProps.open) {
          return {
            exited: false
          };
        }

        return null;
      }
    }]);

    return Snackbar;
  }(React.Component);

  Snackbar.propTypes = {
    /**
     * The action to display.
     */
    action: propTypes.node,

    /**
     * The anchor of the `Snackbar`.
     */
    anchorOrigin: propTypes.shape({
      horizontal: propTypes.oneOf(['left', 'center', 'right']).isRequired,
      vertical: propTypes.oneOf(['top', 'bottom']).isRequired
    }),

    /**
     * The number of milliseconds to wait before automatically calling the
     * `onClose` function. `onClose` should then set the state of the `open`
     * prop to hide the Snackbar. This behavior is disabled by default with
     * the `null` value.
     */
    autoHideDuration: propTypes.number,

    /**
     * Replace the `SnackbarContent` component.
     */
    children: propTypes.element,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Properties applied to the `ClickAwayListener` element.
     */
    ClickAwayListenerProps: propTypes.object,

    /**
     * Properties applied to the [`SnackbarContent`](/api/snackbar-content/) element.
     */
    ContentProps: propTypes.object,

    /**
     * If `true`, the `autoHideDuration` timer will expire even if the window is not focused.
     */
    disableWindowBlurListener: propTypes.bool,

    /**
     * When displaying multiple consecutive Snackbars from a parent rendering a single
     * <Snackbar/>, add the key property to ensure independent treatment of each message.
     * e.g. <Snackbar key={message} />, otherwise, the message may update-in-place and
     * features such as autoHideDuration may be canceled.
     */
    key: propTypes.any,

    /**
     * The message to display.
     */
    message: propTypes.node,

    /**
     * Callback fired when the component requests to be closed.
     * Typically `onClose` is used to set state in the parent component,
     * which is used to control the `Snackbar` `open` prop.
     * The `reason` parameter can optionally be used to control the response to `onClose`,
     * for example ignoring `clickaway`.
     *
     * @param {object} event The event source of the callback
     * @param {string} reason Can be:`"timeout"` (`autoHideDuration` expired) or: `"clickaway"`
     */
    onClose: propTypes.func,

    /**
     * Callback fired before the transition is entering.
     */
    onEnter: propTypes.func,

    /**
     * Callback fired when the transition has entered.
     */
    onEntered: propTypes.func,

    /**
     * Callback fired when the transition is entering.
     */
    onEntering: propTypes.func,

    /**
     * Callback fired before the transition is exiting.
     */
    onExit: propTypes.func,

    /**
     * Callback fired when the transition has exited.
     */
    onExited: propTypes.func,

    /**
     * Callback fired when the transition is exiting.
     */
    onExiting: propTypes.func,

    /**
     * @ignore
     */
    onMouseEnter: propTypes.func,

    /**
     * @ignore
     */
    onMouseLeave: propTypes.func,

    /**
     * If true, `Snackbar` is open.
     */
    open: propTypes.bool,

    /**
     * The number of milliseconds to wait before dismissing after user interaction.
     * If `autoHideDuration` property isn't specified, it does nothing.
     * If `autoHideDuration` property is specified but `resumeHideDuration` isn't,
     * we default to `autoHideDuration / 2` ms.
     */
    resumeHideDuration: propTypes.number,

    /**
     * The component used for the transition.
     */
    TransitionComponent: componentPropType,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * Properties applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  };
  Snackbar.defaultProps = {
    anchorOrigin: {
      vertical: 'bottom',
      horizontal: 'center'
    },
    disableWindowBlurListener: false,
    TransitionComponent: Slide$1,
    transitionDuration: {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    }
  };
  var Snackbar$1 = withStyles(styles$1d, {
    flip: false,
    name: 'MuiSnackbar'
  })(Snackbar);

  var styles$1e = {
    /* Styles applied to the root element. */
    root: {},

    /* Styles applied to the root element if `orientation="horizontal"`. */
    horizontal: {
      paddingLeft: 8,
      paddingRight: 8,
      '&:first-child': {
        paddingLeft: 0
      },
      '&:last-child': {
        paddingRight: 0
      }
    },

    /* Styles applied to the root element if `orientation="vertical"`. */
    vertical: {},

    /* Styles applied to the root element if `alternativeLabel={true}`. */
    alternativeLabel: {
      flex: 1,
      position: 'relative'
    },

    /* Styles applied to the root element if `completed={true}`. */
    completed: {}
  };

  function Step(props) {
    var _classNames;

    var active = props.active,
        alternativeLabel = props.alternativeLabel,
        children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        completed = props.completed,
        connector = props.connector,
        disabled = props.disabled,
        index = props.index,
        last = props.last,
        orientation = props.orientation,
        other = objectWithoutProperties(props, ["active", "alternativeLabel", "children", "classes", "className", "completed", "connector", "disabled", "index", "last", "orientation"]);

    var className = classnames(classes.root, classes[orientation], (_classNames = {}, defineProperty(_classNames, classes.alternativeLabel, alternativeLabel), defineProperty(_classNames, classes.completed, completed), _classNames), classNameProp);
    return React.createElement("div", _extends_1({
      className: className
    }, other), connector && alternativeLabel && index !== 0 && React.cloneElement(connector, {
      orientation: orientation,
      alternativeLabel: alternativeLabel,
      index: index,
      active: active,
      completed: completed,
      disabled: disabled
    }), React.Children.map(children, function (child) {
      if (!React.isValidElement(child)) {
        return null;
      }

      warning_1(child.type !== React.Fragment, ["Material-UI: the Step component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n'));
      return React.cloneElement(child, _extends_1({
        active: active,
        alternativeLabel: alternativeLabel,
        completed: completed,
        disabled: disabled,
        last: last,
        icon: index + 1,
        orientation: orientation
      }, child.props));
    }));
  }

  Step.propTypes = {
    /**
     * Sets the step as active. Is passed to child components.
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Stepper when it's supplied with the alternativeLabel property.
     */
    alternativeLabel: propTypes.bool,

    /**
     * Should be `Step` sub-components such as `StepLabel`, `StepContent`.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * Mark the step as completed. Is passed to child components.
     */
    completed: propTypes.bool,

    /**
     * @ignore
     * Passed down from Stepper if alternativeLabel is also set.
     */
    connector: propTypes.element,

    /**
     * Mark the step as disabled, will also disable the button if
     * `StepButton` is a child of `Step`. Is passed to child components.
     */
    disabled: propTypes.bool,

    /**
     * @ignore
     * Used internally for numbering.
     */
    index: propTypes.number,

    /**
     * @ignore
     */
    last: propTypes.bool,

    /**
     * @ignore
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical'])
  };
  Step.defaultProps = {
    active: false,
    completed: false,
    disabled: false
  };
  var Step$1 = withStyles(styles$1e, {
    name: 'MuiStep'
  })(Step);

  /**
   * @ignore - internal component.
   */

  var _ref$8 = React.createElement("path", {
    d: "M12 0a12 12 0 1 0 0 24 12 12 0 0 0 0-24zm-2 17l-5-5 1.4-1.4 3.6 3.6 7.6-7.6L19 8l-9 9z"
  });

  var CheckCircle = function CheckCircle(props) {
    return React.createElement(SvgIcon$1, props, _ref$8);
  };

  CheckCircle = pure(CheckCircle);
  CheckCircle.muiName = 'SvgIcon';
  var CheckCircle$1 = CheckCircle;

  /**
   * @ignore - internal component.
   */

  var _ref$9 = React.createElement("path", {
    d: "M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"
  });

  var Warning = function Warning(props) {
    return React.createElement(SvgIcon$1, props, _ref$9);
  };

  Warning = pure(Warning);
  Warning.muiName = 'SvgIcon';
  var Warning$1 = Warning;

  var styles$1f = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'block',
        color: theme.palette.text.disabled,
        '&$active': {
          color: theme.palette.primary.main
        },
        '&$completed': {
          color: theme.palette.primary.main
        },
        '&$error': {
          color: theme.palette.error.main
        }
      },

      /* Styles applied to the SVG text element. */
      text: {
        fill: theme.palette.primary.contrastText,
        fontSize: theme.typography.caption.fontSize,
        fontFamily: theme.typography.fontFamily
      },

      /* Styles applied to the root element if `active={true}`. */
      active: {},

      /* Styles applied to the root element if `completed={true}`. */
      completed: {},

      /* Styles applied to the root element if `error={true}`. */
      error: {}
    };
  };

  var _ref$a = React.createElement("circle", {
    cx: "12",
    cy: "12",
    r: "12"
  });

  function StepIcon(props) {
    var completed = props.completed,
        icon = props.icon,
        active = props.active,
        error = props.error,
        classes = props.classes;

    if (typeof icon === 'number' || typeof icon === 'string') {
      if (error) {
        return React.createElement(Warning$1, {
          className: classnames(classes.root, classes.error)
        });
      }

      if (completed) {
        return React.createElement(CheckCircle$1, {
          className: classnames(classes.root, classes.completed)
        });
      }

      return React.createElement(SvgIcon$1, {
        className: classnames(classes.root, defineProperty({}, classes.active, active))
      }, _ref$a, React.createElement("text", {
        className: classes.text,
        x: "12",
        y: "16",
        textAnchor: "middle"
      }, icon));
    }

    return icon;
  }

  StepIcon.propTypes = {
    /**
     * Whether this step is active.
     */
    active: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * Mark the step as completed. Is passed to child components.
     */
    completed: propTypes.bool,

    /**
     * Mark the step as failed.
     */
    error: propTypes.bool,

    /**
     * The icon displayed by the step label.
     */
    icon: propTypes.node.isRequired
  };
  StepIcon.defaultProps = {
    active: false,
    completed: false,
    error: false
  };
  var StepIcon$1 = withStyles(styles$1f, {
    name: 'MuiStepIcon'
  })(StepIcon);

  var styles$1g = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'flex',
        alignItems: 'center',
        '&$alternativeLabel': {
          flexDirection: 'column'
        },
        '&$disabled': {
          cursor: 'default'
        }
      },

      /* Styles applied to the root element if `orientation="horizontal". */
      horizontal: {},

      /* Styles applied to the root element if `orientation="vertical". */
      vertical: {},

      /* Styles applied to the `Typography` component which wraps `children`. */
      label: {
        color: theme.palette.text.secondary,
        '&$active': {
          color: theme.palette.text.primary,
          fontWeight: 500
        },
        '&$completed': {
          color: theme.palette.text.primary,
          fontWeight: 500
        },
        '&$alternativeLabel': {
          textAlign: 'center',
          marginTop: 16
        },
        '&$error': {
          color: theme.palette.error.main
        }
      },

      /* Styles applied to the `Typography` component if `active={true}`. */
      active: {},

      /* Styles applied to the `Typography` component if `completed={true}`. */
      completed: {},

      /* Styles applied to the root element and `Typography` component if `error={true}`. */
      error: {},

      /* Styles applied to the root element and `Typography` component if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the `icon` container element. */
      iconContainer: {
        flexShrink: 0,
        // Fix IE 11 issue
        display: 'flex',
        paddingRight: 8,
        '&$alternativeLabel': {
          paddingRight: 0
        }
      },

      /* Styles applied to the root & icon container and `Typography` if `alternativeLabel={true}`. */
      alternativeLabel: {},

      /* Styles applied to the container element which wraps `Typography` and `optional`. */
      labelContainer: {
        width: '100%'
      }
    };
  };

  function StepLabel(props) {
    var _classNames, _classNames3;

    var active = props.active,
        alternativeLabel = props.alternativeLabel,
        children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        completed = props.completed,
        disabled = props.disabled,
        error = props.error,
        icon = props.icon,
        last = props.last,
        optional = props.optional,
        orientation = props.orientation,
        StepIconComponentProp = props.StepIconComponent,
        StepIconProps = props.StepIconProps,
        other = objectWithoutProperties(props, ["active", "alternativeLabel", "children", "classes", "className", "completed", "disabled", "error", "icon", "last", "optional", "orientation", "StepIconComponent", "StepIconProps"]);

    var StepIconComponent = StepIconComponentProp;

    if (icon && !StepIconComponent) {
      StepIconComponent = StepIcon$1;
    }

    return React.createElement("span", _extends_1({
      className: classnames(classes.root, classes[orientation], (_classNames = {}, defineProperty(_classNames, classes.disabled, disabled), defineProperty(_classNames, classes.alternativeLabel, alternativeLabel), defineProperty(_classNames, classes.error, error), _classNames), classNameProp)
    }, other), icon || StepIconComponent ? React.createElement("span", {
      className: classnames(classes.iconContainer, defineProperty({}, classes.alternativeLabel, alternativeLabel))
    }, React.createElement(StepIconComponent, _extends_1({
      completed: completed,
      active: active,
      error: error,
      icon: icon
    }, StepIconProps))) : null, React.createElement("span", {
      className: classes.labelContainer
    }, React.createElement(Typography$1, {
      component: "span",
      className: classnames(classes.label, (_classNames3 = {}, defineProperty(_classNames3, classes.alternativeLabel, alternativeLabel), defineProperty(_classNames3, classes.completed, completed), defineProperty(_classNames3, classes.active, active), defineProperty(_classNames3, classes.error, error), _classNames3))
    }, children), optional));
  }

  StepLabel.propTypes = {
    /**
     * @ignore
     * Sets the step as active. Is passed to child components.
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Stepper when it's supplied with the alternativeLabel property.
     */
    alternativeLabel: propTypes.bool,

    /**
     * In most cases will simply be a string containing a title for the label.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     * Mark the step as completed. Is passed to child components.
     */
    completed: propTypes.bool,

    /**
     * Mark the step as disabled, will also disable the button if
     * `StepLabelButton` is a child of `StepLabel`. Is passed to child components.
     */
    disabled: propTypes.bool,

    /**
     * Mark the step as failed.
     */
    error: propTypes.bool,

    /**
     * Override the default icon.
     */
    icon: propTypes.node,

    /**
     * @ignore
     */
    last: propTypes.bool,

    /**
     * The optional node to display.
     */
    optional: propTypes.node,

    /**
     * @ignore
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical']),

    /**
     * The component to render in place of the [`StepIcon`](/api/step-icon/).
     */
    StepIconComponent: componentPropType,

    /**
     * Properties applied to the [`StepIcon`](/api/step-icon/) element.
     */
    StepIconProps: propTypes.object
  };
  StepLabel.defaultProps = {
    active: false,
    alternativeLabel: false,
    completed: false,
    disabled: false,
    error: false,
    last: false,
    orientation: 'horizontal'
  };
  StepLabel.muiName = 'StepLabel';
  var StepLabel$1 = withStyles(styles$1g, {
    name: 'MuiStepLabel'
  })(StepLabel);

  var styles$1h = {
    /* Styles applied to the root element. */
    root: {
      width: '100%',
      padding: '24px 16px',
      margin: '-24px -16px',
      boxSizing: 'content-box'
    },

    /* Styles applied to the root element if `orientation="horizontal"`. */
    horizontal: {},

    /* Styles applied to the root element if `orientation="vertical"`. */
    vertical: {
      justifyContent: 'flex-start'
    },

    /* Styles applied to the `ButtonBase` touch-ripple. */
    touchRipple: {
      color: 'rgba(0, 0, 0, 0.3)'
    }
  };

  function StepButton(props) {
    var active = props.active,
        alternativeLabel = props.alternativeLabel,
        children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        completed = props.completed,
        disabled = props.disabled,
        icon = props.icon,
        last = props.last,
        optional = props.optional,
        orientation = props.orientation,
        other = objectWithoutProperties(props, ["active", "alternativeLabel", "children", "classes", "className", "completed", "disabled", "icon", "last", "optional", "orientation"]);

    var childProps = {
      active: active,
      alternativeLabel: alternativeLabel,
      completed: completed,
      disabled: disabled,
      icon: icon,
      optional: optional,
      orientation: orientation
    };
    var child = isMuiElement(children, ['StepLabel']) ? React.cloneElement(children, childProps) : React.createElement(StepLabel$1, childProps, children);
    return React.createElement(ButtonBase$1, _extends_1({
      disabled: disabled,
      TouchRippleProps: {
        className: classes.touchRipple
      },
      className: classnames(classes.root, classes[orientation], classNameProp)
    }, other), child);
  }

  StepButton.propTypes = {
    /**
     * @ignore
     * Passed in via `Step` - passed through to `StepLabel`.
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Stepper when it's supplied with the alternativeLabel property.
     */
    alternativeLabel: propTypes.bool,

    /**
     * Can be a `StepLabel` or a node to place inside `StepLabel` as children.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     * Sets completed styling. Is passed to StepLabel.
     */
    completed: propTypes.bool,

    /**
     * @ignore
     * Disables the button and sets disabled styling. Is passed to StepLabel.
     */
    disabled: propTypes.bool,

    /**
     * The icon displayed by the step label.
     */
    icon: propTypes.node,

    /**
     * @ignore
     */
    last: propTypes.bool,

    /**
     * The optional node to display.
     */
    optional: propTypes.node,

    /**
     * @ignore
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical'])
  };
  var StepButton$1 = withStyles(styles$1h, {
    name: 'MuiStepButton'
  })(StepButton);

  var styles$1i = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        flex: '1 1 auto'
      },

      /* Styles applied to the root element if `orientation="horizontal"`. */
      horizontal: {},

      /* Styles applied to the root element if `orientation="vertical"`. */
      vertical: {
        marginLeft: 12,
        // half icon
        padding: '0 0 8px'
      },

      /* Styles applied to the root element if `alternativeLabel={true}`. */
      alternativeLabel: {
        position: 'absolute',
        top: 8 + 4,
        left: 'calc(-50% + 20px)',
        right: 'calc(50% + 20px)'
      },

      /* Styles applied to the root element if `active={true}`. */
      active: {},

      /* Styles applied to the root element if `completed={true}`. */
      completed: {},

      /* Styles applied to the root element if `disabled={true}`. */
      disabled: {},

      /* Styles applied to the line element. */
      line: {
        display: 'block',
        borderColor: theme.palette.type === 'light' ? theme.palette.grey[400] : theme.palette.grey[600]
      },

      /* Styles applied to the root element if `orientation="horizontal"`. */
      lineHorizontal: {
        borderTopStyle: 'solid',
        borderTopWidth: 1
      },

      /* Styles applied to the root element if `orientation="vertical"`. */
      lineVertical: {
        borderLeftStyle: 'solid',
        borderLeftWidth: 1,
        minHeight: 24
      }
    };
  };

  function StepConnector(props) {
    var _classNames, _classNames2;

    var active = props.active,
        alternativeLabel = props.alternativeLabel,
        classes = props.classes,
        classNameProp = props.className,
        completed = props.completed,
        disabled = props.disabled,
        index = props.index,
        orientation = props.orientation,
        other = objectWithoutProperties(props, ["active", "alternativeLabel", "classes", "className", "completed", "disabled", "index", "orientation"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, classes[orientation], (_classNames = {}, defineProperty(_classNames, classes.alternativeLabel, alternativeLabel), defineProperty(_classNames, classes.active, active), defineProperty(_classNames, classes.completed, completed), defineProperty(_classNames, classes.disabled, disabled), _classNames), classNameProp)
    }, other), React.createElement("span", {
      className: classnames(classes.line, (_classNames2 = {}, defineProperty(_classNames2, classes.lineHorizontal, orientation === 'horizontal'), defineProperty(_classNames2, classes.lineVertical, orientation === 'vertical'), _classNames2))
    }));
  }

  StepConnector.propTypes = {
    /**
     * @ignore
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Step when it's supplied with the alternativeLabel property.
     */
    alternativeLabel: propTypes.bool,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    completed: propTypes.bool,

    /**
     * @ignore
     */
    disabled: propTypes.bool,

    /**
     * @ignore
     */
    index: propTypes.number,

    /**
     * @ignore
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical'])
  };
  StepConnector.defaultProps = {
    alternativeLabel: false,
    orientation: 'horizontal'
  };
  var StepConnector$1 = withStyles(styles$1i, {
    name: 'MuiStepConnector'
  })(StepConnector);

  var styles$1j = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        marginTop: 8,
        marginLeft: 12,
        // half icon
        paddingLeft: 8 + 12,
        // margin + half icon
        paddingRight: 8,
        borderLeft: "1px solid ".concat(theme.palette.type === 'light' ? theme.palette.grey[400] : theme.palette.grey[600])
      },

      /* Styles applied to the root element if `last={true}` (controlled by `Step`). */
      last: {
        borderLeft: 'none'
      },

      /* Styles applied to the Transition component. */
      transition: {}
    };
  };

  function StepContent(props) {
    var active = props.active,
        alternativeLabel = props.alternativeLabel,
        children = props.children,
        classes = props.classes,
        className = props.className,
        completed = props.completed,
        last = props.last,
        optional = props.optional,
        orientation = props.orientation,
        TransitionComponent = props.TransitionComponent,
        transitionDurationProp = props.transitionDuration,
        TransitionProps = props.TransitionProps,
        other = objectWithoutProperties(props, ["active", "alternativeLabel", "children", "classes", "className", "completed", "last", "optional", "orientation", "TransitionComponent", "transitionDuration", "TransitionProps"]);

    warning_1(orientation === 'vertical', 'Material-UI: <StepContent /> is only designed for use with the vertical stepper.');
    var transitionDuration = transitionDurationProp;

    if (transitionDurationProp === 'auto' && !TransitionComponent.muiSupportAuto) {
      transitionDuration = undefined;
    }

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, defineProperty({}, classes.last, last), className)
    }, other), React.createElement(TransitionComponent, _extends_1({
      in: active,
      className: classes.transition,
      timeout: transitionDuration,
      unmountOnExit: true
    }, TransitionProps), children));
  }

  StepContent.propTypes = {
    /**
     * @ignore
     * Expands the content.
     */
    active: propTypes.bool,

    /**
     * @ignore
     * Set internally by Step when it's supplied with the alternativeLabel property.
     */
    alternativeLabel: propTypes.bool,

    /**
     * Step content.
     */
    children: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * @ignore
     */
    completed: propTypes.bool,

    /**
     * @ignore
     */
    last: propTypes.bool,

    /**
     * @ignore
     * Set internally by Step when it's supplied with the optional property.
     */
    optional: propTypes.bool,

    /**
     * @ignore
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical']),

    /**
     * The component used for the transition.
     */
    TransitionComponent: componentPropType,

    /**
     * Adjust the duration of the content expand transition.
     * Passed as a property to the transition component.
     *
     * Set to 'auto' to automatically calculate transition time based on height.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    }), propTypes.oneOf(['auto'])]),

    /**
     * Properties applied to the `Transition` element.
     */
    TransitionProps: propTypes.object
  };
  StepContent.defaultProps = {
    TransitionComponent: Collapse$1,
    transitionDuration: 'auto'
  };
  var StepContent$1 = withStyles(styles$1j, {
    name: 'MuiStepContent'
  })(StepContent);

  var styles$1k = {
    /* Styles applied to the root element. */
    root: {
      display: 'flex',
      padding: 24
    },

    /* Styles applied to the root element if `orientation="horizontal"`. */
    horizontal: {
      flexDirection: 'row',
      alignItems: 'center'
    },

    /* Styles applied to the root element if `orientation="vertical"`. */
    vertical: {
      flexDirection: 'column'
    },

    /* Styles applied to the root element if `alternativeLabel={true}`. */
    alternativeLabel: {
      alignItems: 'flex-start'
    }
  };

  function Stepper(props) {
    var activeStep = props.activeStep,
        alternativeLabel = props.alternativeLabel,
        children = props.children,
        classes = props.classes,
        classNameProp = props.className,
        connectorProp = props.connector,
        nonLinear = props.nonLinear,
        orientation = props.orientation,
        other = objectWithoutProperties(props, ["activeStep", "alternativeLabel", "children", "classes", "className", "connector", "nonLinear", "orientation"]);

    var className = classnames(classes.root, classes[orientation], defineProperty({}, classes.alternativeLabel, alternativeLabel), classNameProp);
    var connector = React.isValidElement(connectorProp) ? React.cloneElement(connectorProp, {
      orientation: orientation
    }) : null;
    var childrenArray = React.Children.toArray(children);
    var steps = childrenArray.map(function (step, index) {
      var controlProps = {
        alternativeLabel: alternativeLabel,
        connector: connectorProp,
        last: index + 1 === childrenArray.length,
        orientation: orientation
      };
      var state = {
        index: index,
        active: false,
        completed: false,
        disabled: false
      };

      if (activeStep === index) {
        state.active = true;
      } else if (!nonLinear && activeStep > index) {
        state.completed = true;
      } else if (!nonLinear && activeStep < index) {
        state.disabled = true;
      }

      return [!alternativeLabel && connector && index !== 0 && React.cloneElement(connector, _extends_1({
        key: index
      }, state)), React.cloneElement(step, _extends_1({}, controlProps, state, step.props))];
    });
    return React.createElement(Paper$1, _extends_1({
      square: true,
      elevation: 0,
      className: className
    }, other), steps);
  }

  Stepper.propTypes = {
    /**
     * Set the active step (zero based index).
     */
    activeStep: propTypes.number,

    /**
     * If set to 'true' and orientation is horizontal,
     * then the step label will be positioned under the icon.
     */
    alternativeLabel: propTypes.bool,

    /**
     * Two or more `<Step />` components.
     */
    children: propTypes.node.isRequired,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * A component to be placed between each step.
     */
    connector: propTypes.element,

    /**
     * If set the `Stepper` will not assist in controlling steps for linear flow.
     */
    nonLinear: propTypes.bool,

    /**
     * The stepper orientation (layout flow direction).
     */
    orientation: propTypes.oneOf(['horizontal', 'vertical'])
  };
  Stepper.defaultProps = {
    activeStep: 0,
    alternativeLabel: false,
    connector: React.createElement(StepConnector$1, null),
    nonLinear: false,
    orientation: 'horizontal'
  };
  var Stepper$1 = withStyles(styles$1k, {
    name: 'MuiStepper'
  })(Stepper);

  var styles$1l = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        position: 'fixed',
        top: 0,
        left: 0,
        bottom: 0,
        zIndex: theme.zIndex.drawer - 1
      },
      anchorLeft: {
        right: 'auto'
      },
      anchorRight: {
        left: 'auto',
        right: 0
      },
      anchorTop: {
        bottom: 'auto',
        right: 0
      },
      anchorBottom: {
        top: 'auto',
        bottom: 0,
        right: 0
      }
    };
  };
  /**
   * @ignore - internal component.
   */

  var SwipeArea = React.forwardRef(function (props, ref) {
    var anchor = props.anchor,
        classes = props.classes,
        className = props.className,
        width = props.width,
        other = objectWithoutProperties(props, ["anchor", "classes", "className", "width"]);

    return React.createElement("div", _extends_1({
      className: classnames(classes.root, classes["anchor".concat(capitalize(anchor))], className),
      style: defineProperty({}, isHorizontal(props) ? 'width' : 'height', width),
      ref: ref
    }, other));
  });
  SwipeArea.propTypes = {
    /**
     * Side on which to attach the discovery area.
     */
    anchor: propTypes.oneOf(['left', 'top', 'right', 'bottom']).isRequired,

    /**
     * @ignore
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The width of the left most (or right most) area in pixels where the
     * drawer can be swiped open from.
     */
    width: propTypes.number.isRequired
  };
  var SwipeArea$1 = withStyles(styles$1l, {
    name: 'MuiPrivateSwipeArea'
  })(SwipeArea);

  // trigger a native scroll.

  var UNCERTAINTY_THRESHOLD = 3; // px
  // We can only have one node at the time claiming ownership for handling the swipe.
  // Otherwise, the UX would be confusing.
  // That's why we use a singleton here.

  var nodeThatClaimedTheSwipe = null; // Exported for test purposes.
  /* istanbul ignore if */

  if (!React.createContext) {
    throw new Error('Material-UI: react@16.3.0 or greater is required.');
  }

  var SwipeableDrawer =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(SwipeableDrawer, _React$Component);

    function SwipeableDrawer() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, SwipeableDrawer);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(SwipeableDrawer)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {};
      _this.isSwiping = null;
      _this.swipeAreaRef = React.createRef();

      _this.handleBodyTouchStart = function (event) {
        // We are not supposed to handle this touch move.
        if (nodeThatClaimedTheSwipe !== null && nodeThatClaimedTheSwipe !== assertThisInitialized(assertThisInitialized(_this))) {
          return;
        }

        var _this$props = _this.props,
            disableDiscovery = _this$props.disableDiscovery,
            disableSwipeToOpen = _this$props.disableSwipeToOpen,
            open = _this$props.open,
            swipeAreaWidth = _this$props.swipeAreaWidth;
        var anchor = getAnchor(_this.props);
        var currentX = anchor === 'right' ? document.body.offsetWidth - event.touches[0].pageX : event.touches[0].pageX;
        var currentY = anchor === 'bottom' ? window.innerHeight - event.touches[0].clientY : event.touches[0].clientY;

        if (!open) {
          if (disableSwipeToOpen || event.target !== _this.swipeAreaRef.current) {
            return;
          }

          if (isHorizontal(_this.props)) {
            if (currentX > swipeAreaWidth) {
              return;
            }
          } else if (currentY > swipeAreaWidth) {
            return;
          }
        }

        nodeThatClaimedTheSwipe = assertThisInitialized(assertThisInitialized(_this));
        _this.startX = currentX;
        _this.startY = currentY;

        _this.setState({
          maybeSwiping: true
        });

        if (!open && _this.paperRef) {
          // The ref may be null when a parent component updates while swiping.
          _this.setPosition(_this.getMaxTranslate() + (disableDiscovery ? 20 : -swipeAreaWidth), {
            changeTransition: false
          });
        }

        _this.velocity = 0;
        _this.lastTime = null;
        _this.lastTranslate = null;
        document.body.addEventListener('touchmove', _this.handleBodyTouchMove, {
          passive: false
        });
        document.body.addEventListener('touchend', _this.handleBodyTouchEnd); // https://plus.google.com/+PaulIrish/posts/KTwfn1Y2238

        document.body.addEventListener('touchcancel', _this.handleBodyTouchEnd);
      };

      _this.handleBodyTouchMove = function (event) {
        // The ref may be null when a parent component updates while swiping.
        if (!_this.paperRef) return;
        var anchor = getAnchor(_this.props);
        var horizontalSwipe = isHorizontal(_this.props);
        var currentX = anchor === 'right' ? document.body.offsetWidth - event.touches[0].pageX : event.touches[0].pageX;
        var currentY = anchor === 'bottom' ? window.innerHeight - event.touches[0].clientY : event.touches[0].clientY; // We don't know yet.

        if (_this.isSwiping == null) {
          var dx = Math.abs(currentX - _this.startX);
          var dy = Math.abs(currentY - _this.startY); // We are likely to be swiping, let's prevent the scroll event on iOS.

          if (dx > dy) {
            event.preventDefault();
          }

          var isSwiping = horizontalSwipe ? dx > dy && dx > UNCERTAINTY_THRESHOLD : dy > dx && dy > UNCERTAINTY_THRESHOLD;

          if (isSwiping === true || (horizontalSwipe ? dy > UNCERTAINTY_THRESHOLD : dx > UNCERTAINTY_THRESHOLD)) {
            _this.isSwiping = isSwiping;

            if (!isSwiping) {
              _this.handleBodyTouchEnd(event);

              return;
            } // Shift the starting point.


            _this.startX = currentX;
            _this.startY = currentY; // Compensate for the part of the drawer displayed on touch start.

            if (!_this.props.disableDiscovery && !_this.props.open) {
              if (horizontalSwipe) {
                _this.startX -= _this.props.swipeAreaWidth;
              } else {
                _this.startY -= _this.props.swipeAreaWidth;
              }
            }
          }
        }

        if (!_this.isSwiping) {
          return;
        }

        var translate = _this.getTranslate(horizontalSwipe ? currentX : currentY);

        if (_this.lastTranslate === null) {
          _this.lastTranslate = translate;
          _this.lastTime = performance.now() + 1;
        }

        var velocity = (translate - _this.lastTranslate) / (performance.now() - _this.lastTime) * 1e3; // Low Pass filter.

        _this.velocity = _this.velocity * 0.4 + velocity * 0.6;
        _this.lastTranslate = translate;
        _this.lastTime = performance.now(); // We are swiping, let's prevent the scroll event on iOS.

        event.preventDefault();

        _this.setPosition(translate);
      };

      _this.handleBodyTouchEnd = function (event) {
        nodeThatClaimedTheSwipe = null;

        _this.removeBodyTouchListeners();

        _this.setState({
          maybeSwiping: false
        }); // The swipe wasn't started.


        if (!_this.isSwiping) {
          _this.isSwiping = null;
          return;
        }

        _this.isSwiping = null;
        var anchor = getAnchor(_this.props);
        var current;

        if (isHorizontal(_this.props)) {
          current = anchor === 'right' ? document.body.offsetWidth - event.changedTouches[0].pageX : event.changedTouches[0].pageX;
        } else {
          current = anchor === 'bottom' ? window.innerHeight - event.changedTouches[0].clientY : event.changedTouches[0].clientY;
        }

        var translateRatio = _this.getTranslate(current) / _this.getMaxTranslate();

        if (_this.props.open) {
          if (_this.velocity > _this.props.minFlingVelocity || translateRatio > _this.props.hysteresis) {
            _this.props.onClose();
          } else {
            // Reset the position, the swipe was aborted.
            _this.setPosition(0, {
              mode: 'exit'
            });
          }

          return;
        }

        if (_this.velocity < -_this.props.minFlingVelocity || 1 - translateRatio > _this.props.hysteresis) {
          _this.props.onOpen();
        } else {
          // Reset the position, the swipe was aborted.
          _this.setPosition(_this.getMaxTranslate(), {
            mode: 'enter'
          });
        }
      };

      _this.handleBackdropRef = function (ref) {
        _this.backdropRef = ref ? ReactDOM.findDOMNode(ref) : null;
      };

      _this.handlePaperRef = function (ref) {
        _this.paperRef = ref ? ReactDOM.findDOMNode(ref) : null;
      };

      return _this;
    }

    createClass(SwipeableDrawer, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.props.variant === 'temporary') {
          this.listenTouchStart();
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var variant = this.props.variant;
        var prevVariant = prevProps.variant;

        if (variant !== prevVariant) {
          if (variant === 'temporary') {
            this.listenTouchStart();
          } else if (prevVariant === 'temporary') {
            this.removeTouchStart();
          }
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.removeTouchStart();
        this.removeBodyTouchListeners(); // We need to release the lock.

        if (nodeThatClaimedTheSwipe === this) {
          nodeThatClaimedTheSwipe = null;
        }
      }
    }, {
      key: "getMaxTranslate",
      value: function getMaxTranslate() {
        return isHorizontal(this.props) ? this.paperRef.clientWidth : this.paperRef.clientHeight;
      }
    }, {
      key: "getTranslate",
      value: function getTranslate(current) {
        var start = isHorizontal(this.props) ? this.startX : this.startY;
        return Math.min(Math.max(this.props.open ? start - current : this.getMaxTranslate() + start - current, 0), this.getMaxTranslate());
      }
    }, {
      key: "setPosition",
      value: function setPosition(translate) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var _options$mode = options.mode,
            mode = _options$mode === void 0 ? null : _options$mode,
            _options$changeTransi = options.changeTransition,
            changeTransition = _options$changeTransi === void 0 ? true : _options$changeTransi;
        var anchor = getAnchor(this.props);
        var rtlTranslateMultiplier = ['right', 'bottom'].indexOf(anchor) !== -1 ? 1 : -1;
        var transform = isHorizontal(this.props) ? "translate(".concat(rtlTranslateMultiplier * translate, "px, 0)") : "translate(0, ".concat(rtlTranslateMultiplier * translate, "px)");
        var drawerStyle = this.paperRef.style;
        drawerStyle.webkitTransform = transform;
        drawerStyle.transform = transform;
        var transition = '';

        if (mode) {
          transition = this.props.theme.transitions.create('all', getTransitionProps({
            timeout: this.props.transitionDuration
          }, {
            mode: mode
          }));
        }

        if (changeTransition) {
          drawerStyle.webkitTransition = transition;
          drawerStyle.transition = transition;
        }

        if (!this.props.disableBackdropTransition && !this.props.hideBackdrop) {
          var backdropStyle = this.backdropRef.style;
          backdropStyle.opacity = 1 - translate / this.getMaxTranslate();

          if (changeTransition) {
            backdropStyle.webkitTransition = transition;
            backdropStyle.transition = transition;
          }
        }
      }
    }, {
      key: "listenTouchStart",
      value: function listenTouchStart() {
        document.body.addEventListener('touchstart', this.handleBodyTouchStart);
      }
    }, {
      key: "removeTouchStart",
      value: function removeTouchStart() {
        document.body.removeEventListener('touchstart', this.handleBodyTouchStart);
      }
    }, {
      key: "removeBodyTouchListeners",
      value: function removeBodyTouchListeners() {
        document.body.removeEventListener('touchmove', this.handleBodyTouchMove, {
          passive: false
        });
        document.body.removeEventListener('touchend', this.handleBodyTouchEnd);
        document.body.removeEventListener('touchcancel', this.handleBodyTouchEnd);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props2 = this.props,
            anchor = _this$props2.anchor,
            disableBackdropTransition = _this$props2.disableBackdropTransition,
            disableDiscovery = _this$props2.disableDiscovery,
            disableSwipeToOpen = _this$props2.disableSwipeToOpen,
            hysteresis = _this$props2.hysteresis,
            minFlingVelocity = _this$props2.minFlingVelocity,
            _this$props2$ModalPro = _this$props2.ModalProps;
        _this$props2$ModalPro = _this$props2$ModalPro === void 0 ? {} : _this$props2$ModalPro;

        var BackdropProps = _this$props2$ModalPro.BackdropProps,
            ModalPropsProp = objectWithoutProperties(_this$props2$ModalPro, ["BackdropProps"]),
            onOpen = _this$props2.onOpen,
            open = _this$props2.open,
            _this$props2$PaperPro = _this$props2.PaperProps,
            PaperProps = _this$props2$PaperPro === void 0 ? {} : _this$props2$PaperPro,
            SwipeAreaProps = _this$props2.SwipeAreaProps,
            swipeAreaWidth = _this$props2.swipeAreaWidth,
            variant = _this$props2.variant,
            other = objectWithoutProperties(_this$props2, ["anchor", "disableBackdropTransition", "disableDiscovery", "disableSwipeToOpen", "hysteresis", "minFlingVelocity", "ModalProps", "onOpen", "open", "PaperProps", "SwipeAreaProps", "swipeAreaWidth", "variant"]);

        var maybeSwiping = this.state.maybeSwiping;
        return React.createElement(React.Fragment, null, React.createElement(Drawer$1, _extends_1({
          open: variant === 'temporary' && maybeSwiping ? true : open,
          variant: variant,
          ModalProps: _extends_1({
            BackdropProps: _extends_1({}, BackdropProps, {
              ref: this.handleBackdropRef
            })
          }, ModalPropsProp),
          PaperProps: _extends_1({}, PaperProps, {
            style: _extends_1({
              pointerEvents: variant === 'temporary' && !open ? 'none' : ''
            }, PaperProps.style),
            ref: this.handlePaperRef
          }),
          anchor: anchor
        }, other)), !disableSwipeToOpen && variant === 'temporary' && React.createElement(NoSsr, null, React.createElement(SwipeArea$1, _extends_1({
          anchor: anchor,
          innerRef: this.swipeAreaRef,
          width: swipeAreaWidth
        }, SwipeAreaProps))));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(nextProps, prevState) {
        if (typeof prevState.maybeSwiping === 'undefined') {
          return {
            maybeSwiping: false,
            open: nextProps.open
          };
        }

        if (!nextProps.open && prevState.open) {
          return {
            maybeSwiping: false,
            open: nextProps.open
          };
        }

        return {
          open: nextProps.open
        };
      }
    }]);

    return SwipeableDrawer;
  }(React.Component);

  SwipeableDrawer.propTypes = {
    /**
     * @ignore
     */
    anchor: propTypes.oneOf(['left', 'top', 'right', 'bottom']),

    /**
     * Disable the backdrop transition.
     * This can improve the FPS on low-end devices.
     */
    disableBackdropTransition: propTypes.bool,

    /**
     * If `true`, touching the screen near the edge of the drawer will not slide in the drawer a bit
     * to promote accidental discovery of the swipe gesture.
     */
    disableDiscovery: propTypes.bool,

    /**
     * If `true`, swipe to open is disabled. This is useful in browsers where swiping triggers
     * navigation actions. Swipe to open is disabled on iOS browsers by default.
     */
    disableSwipeToOpen: propTypes.bool,

    /**
     * @ignore
     */
    hideBackdrop: propTypes.bool,

    /**
     * Affects how far the drawer must be opened/closed to change his state.
     * Specified as percent (0-1) of the width of the drawer
     */
    hysteresis: propTypes.number,

    /**
     * Defines, from which (average) velocity on, the swipe is
     * defined as complete although hysteresis isn't reached.
     * Good threshold is between 250 - 1000 px/s
     */
    minFlingVelocity: propTypes.number,

    /**
     * @ignore
     */
    ModalProps: propTypes.object,

    /**
     * Callback fired when the component requests to be closed.
     *
     * @param {object} event The event source of the callback
     */
    onClose: propTypes.func.isRequired,

    /**
     * Callback fired when the component requests to be opened.
     *
     * @param {object} event The event source of the callback
     */
    onOpen: propTypes.func.isRequired,

    /**
     * If `true`, the drawer is open.
     */
    open: propTypes.bool.isRequired,

    /**
     * @ignore
     */
    PaperProps: propTypes.object,

    /**
     * Properties applied to the swipe area element.
     */
    SwipeAreaProps: propTypes.object,

    /**
     * The width of the left most (or right most) area in pixels where the
     * drawer can be swiped open from.
     */
    swipeAreaWidth: propTypes.number,

    /**
     * @ignore
     */
    theme: propTypes.object.isRequired,

    /**
     * The duration for the transition, in milliseconds.
     * You may specify a single timeout for all transitions, or individually with an object.
     */
    transitionDuration: propTypes.oneOfType([propTypes.number, propTypes.shape({
      enter: propTypes.number,
      exit: propTypes.number
    })]),

    /**
     * @ignore
     */
    variant: propTypes.oneOf(['permanent', 'persistent', 'temporary'])
  };
  SwipeableDrawer.defaultProps = {
    anchor: 'left',
    disableBackdropTransition: false,
    disableDiscovery: false,
    disableSwipeToOpen: typeof navigator !== 'undefined' && /iPad|iPhone|iPod/.test(navigator.userAgent),
    hysteresis: 0.55,
    minFlingVelocity: 400,
    swipeAreaWidth: 20,
    transitionDuration: {
      enter: duration.enteringScreen,
      exit: duration.leavingScreen
    },
    variant: 'temporary' // Mobile first.

  };
  var SwipeableDrawer$1 = withTheme()(SwipeableDrawer);

  var styles$1m = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: {
        display: 'inline-flex',
        width: 62,
        position: 'relative',
        flexShrink: 0,
        zIndex: 0,
        // Reset the stacking context.
        // For correct alignment with the text.
        verticalAlign: 'middle'
      },

      /* Styles used to create the `icon` passed to the internal `SwitchBase` component `icon` prop. */
      icon: {
        boxShadow: theme.shadows[1],
        backgroundColor: 'currentColor',
        width: 20,
        height: 20,
        borderRadius: '50%'
      },

      /* Styles applied the icon element component if `checked={true}`. */
      iconChecked: {
        boxShadow: theme.shadows[2]
      },

      /* Styles applied to the internal `SwitchBase` component's `root` class. */
      switchBase: {
        padding: 0,
        height: 48,
        width: 48,
        color: theme.palette.type === 'light' ? theme.palette.grey[50] : theme.palette.grey[400],
        transition: theme.transitions.create('transform', {
          duration: theme.transitions.duration.shortest
        })
      },

      /* Styles applied to the internal `SwitchBase` component's `checked` class. */
      checked: {
        transform: 'translateX(14px)',
        '& + $bar': {
          opacity: 0.5
        }
      },

      /* Styles applied to the internal SwitchBase component's root element if `color="primary"`. */
      colorPrimary: {
        '&$checked': {
          color: theme.palette.primary.main,
          '& + $bar': {
            backgroundColor: theme.palette.primary.main
          }
        }
      },

      /* Styles applied to the internal SwitchBase component's root element if `color="secondary"`. */
      colorSecondary: {
        '&$checked': {
          color: theme.palette.secondary.main,
          '& + $bar': {
            backgroundColor: theme.palette.secondary.main
          }
        }
      },

      /* Styles applied to the internal SwitchBase component's disabled class. */
      disabled: {
        '& + $bar': {
          opacity: theme.palette.type === 'light' ? 0.12 : 0.1
        },
        '& $icon': {
          boxShadow: theme.shadows[1]
        },
        '&$switchBase': {
          color: theme.palette.type === 'light' ? theme.palette.grey[400] : theme.palette.grey[800],
          '& + $bar': {
            backgroundColor: theme.palette.type === 'light' ? theme.palette.common.black : theme.palette.common.white
          }
        }
      },

      /* Styles applied to the bar element. */
      bar: {
        borderRadius: 14 / 2,
        display: 'block',
        position: 'absolute',
        zIndex: -1,
        width: 34,
        height: 14,
        top: '50%',
        left: '50%',
        marginTop: -7,
        marginLeft: -17,
        transition: theme.transitions.create(['opacity', 'background-color'], {
          duration: theme.transitions.duration.shortest
        }),
        backgroundColor: theme.palette.type === 'light' ? theme.palette.common.black : theme.palette.common.white,
        opacity: theme.palette.type === 'light' ? 0.38 : 0.3
      }
    };
  };

  function Switch(props) {
    var classes = props.classes,
        className = props.className,
        color = props.color,
        other = objectWithoutProperties(props, ["classes", "className", "color"]);

    return React.createElement("span", {
      className: classnames(classes.root, className)
    }, React.createElement(SwitchBase$1, _extends_1({
      type: "checkbox",
      icon: React.createElement("span", {
        className: classes.icon
      }),
      classes: {
        root: classnames(classes.switchBase, classes["color".concat(capitalize(color))]),
        checked: classes.checked,
        disabled: classes.disabled
      },
      checkedIcon: React.createElement("span", {
        className: classnames(classes.icon, classes.iconChecked)
      })
    }, other)), React.createElement("span", {
      className: classes.bar
    }));
  }

  Switch.propTypes = {
    /**
     * If `true`, the component is checked.
     */
    checked: propTypes.oneOfType([propTypes.bool, propTypes.string]),

    /**
     * The icon to display when the component is checked.
     */
    checkedIcon: propTypes.node,

    /**
     * Override or extend the styles applied to the component.
     * See [CSS API](#css-api) below for more details.
     */
    classes: propTypes.object.isRequired,

    /**
     * @ignore
     */
    className: propTypes.string,

    /**
     * The color of the component. It supports those theme colors that make sense for this component.
     */
    color: propTypes.oneOf(['primary', 'secondary', 'default']),

    /**
     * @ignore
     */
    defaultChecked: propTypes.bool,

    /**
     * If `true`, the switch will be disabled.
     */
    disabled: propTypes.bool,

    /**
     * If `true`, the ripple effect will be disabled.
     */
    disableRipple: propTypes.bool,

    /**
     * The icon to display when the component is unchecked.
     */
    icon: propTypes.node,

    /**
     * The id of the `input` element.
     */
    id: propTypes.string,

    /**
     * Attributes applied to the `input` element.
     */
    inputProps: propTypes.object,

    /**
     * Use that property to pass a ref callback to the native input component.
     */
    inputRef: propTypes.oneOfType([propTypes.func, propTypes.object]),

    /**
     * Callback fired when the state is changed.
     *
     * @param {object} event The event source of the callback.
     * You can pull out the new value by accessing `event.target.checked`.
     * @param {boolean} checked The `checked` value of the switch
     */
    onChange: propTypes.func,

    /**
     * The input component property `type`.
     */
    type: propTypes.string,

    /**
     * The value of the component.
     */
    value: propTypes.oneOfType([propTypes.string, propTypes.number, propTypes.bool])
  };
  Switch.defaultProps = {
    color: 'secondary'
  };
  var Switch$1 = withStyles(styles$1m, {
    name: 'MuiSwitch'
  })(Switch);

  var styles$1n = function styles(theme) {
    return {
      /* Styles applied to the root element. */
      root: _extends_1({}, theme.typography.button, defineProperty({
        maxWidth: 264,
        minWidth: 72,
        position: 'relative',
        boxSizing: 'border-box',
        padding: 0,
        minHeight: 48,
        flexShrink: 0,
        overflow: 'hidden',
        whiteSpace: 'normal',
        textAlign: 'center'
      }, theme.breakpoints.up('md'), {
        fontSize: theme.typography.pxToRem(13),
        minWidth: 160
      })),

      /* Styles applied to the root element if both `icon` and `label` are provided. */
      labelIcon: {
        minHeight: 72,
        // paddingTop supposed to be 12px
        // - 3px from the paddingBottom
        paddingTop: 9 // paddingBottom supposed to be 12px
        // -3px for line-height of the label
        // -6px for label padding
        // = 3px

      },

      /* Styles applied to the root element if `textColor="inherit"`. */
      textColorInherit: {
        color: 'inherit',
        opacity: 0.7,
        '&$selected': {
          opacity: 1
        },
        '&$disabled': {
          opacity: 0.4
        }
      },

      /* Styles applied to the root element if `textColor="primary"`. */
      textColorPrimary: {
        color: theme.palette.text.secondary,
        '&$selected': {
          color: theme.palette.primary.main
        },
        '&$disabled': {
          color: theme.palette.text.disabled
        }
      },

      /* Styles applied to the root element if `textColor="secondary"`. */
      textColorSecondary: {
        color: theme.palette.text.secondary,
        '&$selected': {
          color: theme.palette.secondary.main
        },
        '&$disabled': {
          color: theme.palette.text.disabled
        }
      },

      /* Styles applied to the root element if `selected={true}` (controlled by the Tabs component). */
      selected: {},

      /* Styles applied to the root element if `disabled={true}` (controlled by the Tabs component). */
      disabled: {},

      /* Styles applied to the root element if `fullWidth={true}` (controlled by the Tabs component). */
      fullWidth: {
        flexShrink: 1,
        flexGrow: 1,
        maxWidth: 'none'
      },

      /* Styles applied to the `icon` and `label`'s wrapper element. */
      wrapper: {
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        width: '100%',
        flexDirection: 'column'
      },

      /* Styles applied to the label container element if `label` is provided. */
      labelContainer: defineProperty({
        width: '100%',
        // Fix an IE 11 issue
        boxSizing: 'border-box',
        padding: '6px 12px'
      }, theme.breakpoints.up('md'), {
        padding: '6px 24px'
      }),

      /* Styles applied to the label wrapper element if `label` is provided. */
      label: {},

      /* Deprecated, the styles will be removed in v4. */
      labelWrapped: {}
    };
  };

  var Tab =
  /*#__PURE__*/
  function (_React$Component) {
    inherits(Tab, _React$Component);

    function Tab() {
      var _getPrototypeOf2;

      var _this;

      classCallCheck(this, Tab);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = possibleConstructorReturn(this, (_getPrototypeOf2 = getPrototypeOf(Tab)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {
        labelWrapped: false
      };

      _this.handleChange = function (event) {
        var _this$props = _this.props,
            onChange = _this$props.onChange,
            value = _this$props.value,
            onClick = _this$props.onClick;

        if (onChange) {
          onChange(event, value);
        }

        if (onClick) {
          onClick(event);
        }
      };

      _this.checkTextWrap = function () {
        if (_this.labelRef) {
          var labelWrapped = _this.labelRef.getClientRects().length > 1;

          if (_this.state.labelWrapped !== labelWrapped) {
            _this.setState({
              labelWrapped: labelWrapped
            });
          }
        }
      };

      return _this;
    }

    createClass(Tab, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.checkTextWrap();
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps, prevState) {
        if (this.state.labelWrapped === prevState.labelWrapped) {
          /**
           * At certain text and tab lengths, a larger font size may wrap to two lines while the smaller
           * font size still only requires one line.  This check will prevent an infinite render loop
           * from occurring in that scenario.
           */
          this.checkTextWrap();
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this,
            _classNames2;

        var _this$props2 = this.props,
            classes = _this$props2.classes,
            className = _this$props2.className,
            disabled = _this$props2.disabled,
            fullWidth = _this$props2.fullWidth,
            icon = _this$props2.icon,
            indicator = _this$props2.indicator,
            labelProp = _this$props2.label,
            onChange = _this$props2.onChange,
            selected = _this$props2.selected,
            textColor = _this$props2.textColor,
            value = _this$props2.value,
            other = objectWithoutProperties(_this$props2, ["classes", "className", "disabled", "fullWidth", "icon", "indicator", "label", "onChange", "selected", "textColor", "value"]);

        var label;

        if (labelProp !== undefined) {
          label = React.createElement("span", {
            className: classes.labelContainer
          }, React.createElement("span", {
            className: classnames(classes.label, defineProperty({}, classes.labelWrapped, this.state.labelWrapped)),
            ref: function ref(_ref) {
              _this2.labelRef = _ref;
           