"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cnb = void 0;
var isArray = Array.isArray;
var toClassName = function (val) {
    var str = '';
    if (typeof val === 'string')
        str += val;
    else if (typeof val === 'object') {
        var tmp = void 0;
        if (isArray(val)) {
            var i = 0;
            var l = val.length;
            while (i < l) {
                tmp = toClassName(val[i++]);
                if (tmp) {
                    if (str) {
                        str += ' ';
                    }
                    str += tmp;
                }
            }
        }
        else {
            // eslint-disable-next-line guard-for-in
            for (tmp in val) {
                if (tmp && val[tmp]) {
                    if (str) {
                        str += ' ';
                    }
                    str += tmp;
                }
            }
        }
    }
    return str;
};
function cnb() {
    var l = arguments.length;
    var i = 0;
    var n;
    var tmp;
    var str = '';
    while (i < l) {
        n = arguments[i++];
        if (n) {
            tmp = toClassName(n);
            if (tmp) {
                if (str) {
                    str += ' ';
                }
                str += tmp;
            }
        }
    }
    return str;
}
exports.cnb = cnb;
