"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dcnb = void 0;
var SPACE_REGEX = /\s+/;
var create = Object.create;
var isArray = Array.isArray;
/* istanbul ignore next */
// eslint-disable-next-line @typescript-eslint/no-empty-function
function Storage() { }
/* istanbul ignore next */
Storage.prototype = create(null);
function addVal(val, storage) {
    if (!val)
        return;
    var l;
    if (typeof val === 'string') {
        val = val.split(SPACE_REGEX);
        l = val.length;
        for (var i_1 = 0; i_1 < l; i_1++)
            storage[val[i_1]] = true;
        return;
    }
    if (typeof val !== 'object')
        return;
    if (isArray(val)) {
        l = val.length;
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        for (var i_2 = 0; i_2 < l; i_2++)
            addVal(val[i_2], storage);
        return;
    }
    var i;
    // eslint-disable-next-line guard-for-in
    for (i in val)
        storage[i] = !!val[i];
}
function dcnb() {
    var storage = new Storage();
    var i = 0;
    var l = arguments.length;
    while (i < l) {
        addVal(arguments[i++], storage);
    }
    var str = '';
    for (i in storage) {
        if (storage[i] && i) {
            if (str) {
                str += ' ';
            }
            str += i;
        }
    }
    return str;
}
exports.dcnb = dcnb;
