this.primereact = this.primereact || {};
this.primereact.keyfilter = (function (exports, core) {
  'use strict';

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var KeyFilter = /*#__PURE__*/function () {
    function KeyFilter() {
      _classCallCheck(this, KeyFilter);
    }

    _createClass(KeyFilter, null, [{
      key: "isNavKeyPress",
      value:
      /* eslint-disable */

      /* eslint-enable */
      function isNavKeyPress(e) {
        var k = e.keyCode;
        k = core.DomHandler.getBrowser().safari ? KeyFilter.SAFARI_KEYS[k] || k : k;
        return k >= 33 && k <= 40 || k === KeyFilter.KEYS.RETURN || k === KeyFilter.KEYS.TAB || k === KeyFilter.KEYS.ESC;
      }
    }, {
      key: "isSpecialKey",
      value: function isSpecialKey(e) {
        var k = e.keyCode;
        return k === 9 || k === 13 || k === 27 || k === 16 || k === 17 || k >= 18 && k <= 20 || core.DomHandler.getBrowser().opera && !e.shiftKey && (k === 8 || k >= 33 && k <= 35 || k >= 36 && k <= 39 || k >= 44 && k <= 45);
      }
    }, {
      key: "getKey",
      value: function getKey(e) {
        var k = e.keyCode || e.charCode;
        return core.DomHandler.getBrowser().safari ? KeyFilter.SAFARI_KEYS[k] || k : k;
      }
    }, {
      key: "getCharCode",
      value: function getCharCode(e) {
        return e.charCode || e.keyCode || e.which;
      }
    }, {
      key: "onKeyPress",
      value: function onKeyPress(e, keyfilter, validateOnly) {
        if (validateOnly) {
          return;
        }

        var regex = KeyFilter.DEFAULT_MASKS[keyfilter] ? KeyFilter.DEFAULT_MASKS[keyfilter] : keyfilter;
        var browser = core.DomHandler.getBrowser();

        if (e.ctrlKey || e.altKey) {
          return;
        }

        var k = this.getKey(e);

        if (browser.mozilla && (this.isNavKeyPress(e) || k === KeyFilter.KEYS.BACKSPACE || k === KeyFilter.KEYS.DELETE && e.charCode === 0)) {
          return;
        }

        var c = this.getCharCode(e);
        var cc = String.fromCharCode(c);

        if (browser.mozilla && (this.isSpecialKey(e) || !cc)) {
          return;
        }

        if (!regex.test(cc)) {
          e.preventDefault();
        }
      }
    }, {
      key: "validate",
      value: function validate(e, keyfilter) {
        var value = e.target.value,
            validatePattern = true;

        if (value && !keyfilter.test(value)) {
          validatePattern = false;
        }

        return validatePattern;
      }
    }]);

    return KeyFilter;
  }();

  _defineProperty(KeyFilter, "DEFAULT_MASKS", {
    pint: /[\d]/,
    int: /[\d\-]/,
    pnum: /[\d\.]/,
    money: /[\d\.\s,]/,
    num: /[\d\-\.]/,
    hex: /[0-9a-f]/i,
    email: /[a-z0-9_\.\-@]/i,
    alpha: /[a-z_]/i,
    alphanum: /[a-z0-9_]/i
  });

  _defineProperty(KeyFilter, "KEYS", {
    TAB: 9,
    RETURN: 13,
    ESC: 27,
    BACKSPACE: 8,
    DELETE: 46
  });

  _defineProperty(KeyFilter, "SAFARI_KEYS", {
    63234: 37,
    // left
    63235: 39,
    // right
    63232: 38,
    // up
    63233: 40,
    // down
    63276: 33,
    // page up
    63277: 34,
    // page down
    63272: 46,
    // delete
    63273: 36,
    // home
    63275: 35 // end

  });

  exports.KeyFilter = KeyFilter;

  Object.defineProperty(exports, '__esModule', { value: true });

  return exports;

}({}, primereact.core));
