'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactTransitionGroup = require('react-transition-group');
var ReactDOM = require('react-dom');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () {
            return e[k];
          }
        });
      }
    });
  }
  n['default'] = e;
  return Object.freeze(n);
}

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);

function _arrayLikeToArray$k(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }

  return arr2;
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray$k(arr);
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

function _unsupportedIterableToArray$k(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray$k(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$k(o, minLen);
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray$k(arr) || _nonIterableSpread();
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof(obj) {
      return typeof obj;
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArrayLimit(arr, i) {
  var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]);

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray$k(arr, i) || _nonIterableRest();
}

function classNames() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args) {
    var classes = [];

    for (var i = 0; i < args.length; i++) {
      var className = args[i];
      if (!className) continue;

      var type = _typeof(className);

      if (type === 'string' || type === 'number') {
        classes.push(className);
      } else if (type === 'object') {
        var _classes = Array.isArray(className) ? className : Object.entries(className).map(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];

          return !!value ? key : null;
        });

        classes = _classes.length ? classes.concat(_classes.filter(function (c) {
          return !!c;
        })) : classes;
      }
    }

    return classes.join(' ');
  }

  return undefined;
}

function _createForOfIteratorHelper$j(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$j(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$j(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$j(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$j(o, minLen); }

function _arrayLikeToArray$j(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var DomHandler = /*#__PURE__*/function () {
  function DomHandler() {
    _classCallCheck(this, DomHandler);
  }

  _createClass(DomHandler, null, [{
    key: "innerWidth",
    value: function innerWidth(el) {
      if (el) {
        var width = el.offsetWidth;
        var style = getComputedStyle(el);
        width += parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
        return width;
      }

      return 0;
    }
  }, {
    key: "width",
    value: function width(el) {
      if (el) {
        var width = el.offsetWidth;
        var style = getComputedStyle(el);
        width -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight);
        return width;
      }

      return 0;
    }
  }, {
    key: "getWindowScrollTop",
    value: function getWindowScrollTop() {
      var doc = document.documentElement;
      return (window.pageYOffset || doc.scrollTop) - (doc.clientTop || 0);
    }
  }, {
    key: "getWindowScrollLeft",
    value: function getWindowScrollLeft() {
      var doc = document.documentElement;
      return (window.pageXOffset || doc.scrollLeft) - (doc.clientLeft || 0);
    }
  }, {
    key: "getOuterWidth",
    value: function getOuterWidth(el, margin) {
      if (el) {
        var width = el.offsetWidth;

        if (margin) {
          var style = getComputedStyle(el);
          width += parseFloat(style.marginLeft) + parseFloat(style.marginRight);
        }

        return width;
      }

      return 0;
    }
  }, {
    key: "getOuterHeight",
    value: function getOuterHeight(el, margin) {
      if (el) {
        var height = el.offsetHeight;

        if (margin) {
          var style = getComputedStyle(el);
          height += parseFloat(style.marginTop) + parseFloat(style.marginBottom);
        }

        return height;
      }

      return 0;
    }
  }, {
    key: "getClientHeight",
    value: function getClientHeight(el, margin) {
      if (el) {
        var height = el.clientHeight;

        if (margin) {
          var style = getComputedStyle(el);
          height += parseFloat(style.marginTop) + parseFloat(style.marginBottom);
        }

        return height;
      }

      return 0;
    }
  }, {
    key: "getViewport",
    value: function getViewport() {
      var win = window,
          d = document,
          e = d.documentElement,
          g = d.getElementsByTagName('body')[0],
          w = win.innerWidth || e.clientWidth || g.clientWidth,
          h = win.innerHeight || e.clientHeight || g.clientHeight;
      return {
        width: w,
        height: h
      };
    }
  }, {
    key: "getOffset",
    value: function getOffset(el) {
      if (el) {
        var rect = el.getBoundingClientRect();
        return {
          top: rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0),
          left: rect.left + (window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0)
        };
      }

      return {
        top: 'auto',
        left: 'auto'
      };
    }
  }, {
    key: "index",
    value: function index(element) {
      if (element) {
        var children = element.parentNode.childNodes;
        var num = 0;

        for (var i = 0; i < children.length; i++) {
          if (children[i] === element) return num;
          if (children[i].nodeType === 1) num++;
        }
      }

      return -1;
    }
  }, {
    key: "addMultipleClasses",
    value: function addMultipleClasses(element, className) {
      if (element && className) {
        if (element.classList) {
          var styles = className.split(' ');

          for (var i = 0; i < styles.length; i++) {
            element.classList.add(styles[i]);
          }
        } else {
          var _styles = className.split(' ');

          for (var _i = 0; _i < _styles.length; _i++) {
            element.className += ' ' + _styles[_i];
          }
        }
      }
    }
  }, {
    key: "addClass",
    value: function addClass(element, className) {
      if (element && className) {
        if (element.classList) element.classList.add(className);else element.className += ' ' + className;
      }
    }
  }, {
    key: "removeClass",
    value: function removeClass(element, className) {
      if (element && className) {
        if (element.classList) element.classList.remove(className);else element.className = element.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
      }
    }
  }, {
    key: "hasClass",
    value: function hasClass(element, className) {
      if (element) {
        if (element.classList) return element.classList.contains(className);else return new RegExp('(^| )' + className + '( |$)', 'gi').test(element.className);
      }
    }
  }, {
    key: "find",
    value: function find(element, selector) {
      return element ? Array.from(element.querySelectorAll(selector)) : [];
    }
  }, {
    key: "findSingle",
    value: function findSingle(element, selector) {
      if (element) {
        return element.querySelector(selector);
      }

      return null;
    }
  }, {
    key: "getHeight",
    value: function getHeight(el) {
      if (el) {
        var height = el.offsetHeight;
        var style = getComputedStyle(el);
        height -= parseFloat(style.paddingTop) + parseFloat(style.paddingBottom) + parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
        return height;
      }

      return 0;
    }
  }, {
    key: "getWidth",
    value: function getWidth(el) {
      if (el) {
        var width = el.offsetWidth;
        var style = getComputedStyle(el);
        width -= parseFloat(style.paddingLeft) + parseFloat(style.paddingRight) + parseFloat(style.borderLeftWidth) + parseFloat(style.borderRightWidth);
        return width;
      }

      return 0;
    }
  }, {
    key: "alignOverlay",
    value: function alignOverlay(overlay, target, appendTo) {
      if (overlay && target) {
        if (appendTo === 'self') {
          this.relativePosition(overlay, target);
        } else {
          overlay.style.minWidth = DomHandler.getOuterWidth(target) + 'px';
          this.absolutePosition(overlay, target);
        }
      }
    }
  }, {
    key: "absolutePosition",
    value: function absolutePosition(element, target) {
      if (element) {
        var elementDimensions = element.offsetParent ? {
          width: element.offsetWidth,
          height: element.offsetHeight
        } : this.getHiddenElementDimensions(element);
        var elementOuterHeight = elementDimensions.height;
        var elementOuterWidth = elementDimensions.width;
        var targetOuterHeight = target.offsetHeight;
        var targetOuterWidth = target.offsetWidth;
        var targetOffset = target.getBoundingClientRect();
        var windowScrollTop = this.getWindowScrollTop();
        var windowScrollLeft = this.getWindowScrollLeft();
        var viewport = this.getViewport();
        var top, left;

        if (targetOffset.top + targetOuterHeight + elementOuterHeight > viewport.height) {
          top = targetOffset.top + windowScrollTop - elementOuterHeight;

          if (top < 0) {
            top = windowScrollTop;
          }

          element.style.transformOrigin = 'bottom';
        } else {
          top = targetOuterHeight + targetOffset.top + windowScrollTop;
          element.style.transformOrigin = 'top';
        }

        if (targetOffset.left + targetOuterWidth + elementOuterWidth > viewport.width) left = Math.max(0, targetOffset.left + windowScrollLeft + targetOuterWidth - elementOuterWidth);else left = targetOffset.left + windowScrollLeft;
        element.style.top = top + 'px';
        element.style.left = left + 'px';
      }
    }
  }, {
    key: "relativePosition",
    value: function relativePosition(element, target) {
      if (element) {
        var elementDimensions = element.offsetParent ? {
          width: element.offsetWidth,
          height: element.offsetHeight
        } : this.getHiddenElementDimensions(element);
        var targetHeight = target.offsetHeight;
        var targetOffset = target.getBoundingClientRect();
        var viewport = this.getViewport();
        var top, left;

        if (targetOffset.top + targetHeight + elementDimensions.height > viewport.height) {
          top = -1 * elementDimensions.height;

          if (targetOffset.top + top < 0) {
            top = -1 * targetOffset.top;
          }

          element.style.transformOrigin = 'bottom';
        } else {
          top = targetHeight;
          element.style.transformOrigin = 'top';
        }

        if (elementDimensions.width > viewport.width) {
          // element wider then viewport and cannot fit on screen (align at left side of viewport)
          left = targetOffset.left * -1;
        } else if (targetOffset.left + elementDimensions.width > viewport.width) {
          // element wider then viewport but can be fit on screen (align at right side of viewport)
          left = (targetOffset.left + elementDimensions.width - viewport.width) * -1;
        } else {
          // element fits on screen (align with target)
          left = 0;
        }

        element.style.top = top + 'px';
        element.style.left = left + 'px';
      }
    }
  }, {
    key: "flipfitCollision",
    value: function flipfitCollision(element, target) {
      var _this = this;

      var my = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'left top';
      var at = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'left bottom';
      var callback = arguments.length > 4 ? arguments[4] : undefined;
      var targetOffset = target.getBoundingClientRect();
      var viewport = this.getViewport();
      var myArr = my.split(' ');
      var atArr = at.split(' ');

      var getPositionValue = function getPositionValue(arr, isOffset) {
        return isOffset ? +arr.substring(arr.search(/(\+|-)/g)) || 0 : arr.substring(0, arr.search(/(\+|-)/g)) || arr;
      };

      var position = {
        my: {
          x: getPositionValue(myArr[0]),
          y: getPositionValue(myArr[1] || myArr[0]),
          offsetX: getPositionValue(myArr[0], true),
          offsetY: getPositionValue(myArr[1] || myArr[0], true)
        },
        at: {
          x: getPositionValue(atArr[0]),
          y: getPositionValue(atArr[1] || atArr[0]),
          offsetX: getPositionValue(atArr[0], true),
          offsetY: getPositionValue(atArr[1] || atArr[0], true)
        }
      };
      var myOffset = {
        left: function left() {
          var totalOffset = position.my.offsetX + position.at.offsetX;
          return totalOffset + targetOffset.left + (position.my.x === 'left' ? 0 : -1 * (position.my.x === 'center' ? _this.getOuterWidth(element) / 2 : _this.getOuterWidth(element)));
        },
        top: function top() {
          var totalOffset = position.my.offsetY + position.at.offsetY;
          return totalOffset + targetOffset.top + (position.my.y === 'top' ? 0 : -1 * (position.my.y === 'center' ? _this.getOuterHeight(element) / 2 : _this.getOuterHeight(element)));
        }
      };
      var alignWithAt = {
        count: {
          x: 0,
          y: 0
        },
        left: function left() {
          var left = myOffset.left();
          var scrollLeft = DomHandler.getWindowScrollLeft();
          element.style.left = left + scrollLeft + 'px';

          if (this.count.x === 2) {
            element.style.left = scrollLeft + 'px';
            this.count.x = 0;
          } else if (left < 0) {
            this.count.x++;
            position.my.x = 'left';
            position.at.x = 'right';
            position.my.offsetX *= -1;
            position.at.offsetX *= -1;
            this.right();
          }
        },
        right: function right() {
          var left = myOffset.left() + DomHandler.getOuterWidth(target);
          var scrollLeft = DomHandler.getWindowScrollLeft();
          element.style.left = left + scrollLeft + 'px';

          if (this.count.x === 2) {
            element.style.left = viewport.width - DomHandler.getOuterWidth(element) + scrollLeft + 'px';
            this.count.x = 0;
          } else if (left + DomHandler.getOuterWidth(element) > viewport.width) {
            this.count.x++;
            position.my.x = 'right';
            position.at.x = 'left';
            position.my.offsetX *= -1;
            position.at.offsetX *= -1;
            this.left();
          }
        },
        top: function top() {
          var top = myOffset.top();
          var scrollTop = DomHandler.getWindowScrollTop();
          element.style.top = top + scrollTop + 'px';

          if (this.count.y === 2) {
            element.style.left = scrollTop + 'px';
            this.count.y = 0;
          } else if (top < 0) {
            this.count.y++;
            position.my.y = 'top';
            position.at.y = 'bottom';
            position.my.offsetY *= -1;
            position.at.offsetY *= -1;
            this.bottom();
          }
        },
        bottom: function bottom() {
          var top = myOffset.top() + DomHandler.getOuterHeight(target);
          var scrollTop = DomHandler.getWindowScrollTop();
          element.style.top = top + scrollTop + 'px';

          if (this.count.y === 2) {
            element.style.left = viewport.height - DomHandler.getOuterHeight(element) + scrollTop + 'px';
            this.count.y = 0;
          } else if (top + DomHandler.getOuterHeight(target) > viewport.height) {
            this.count.y++;
            position.my.y = 'bottom';
            position.at.y = 'top';
            position.my.offsetY *= -1;
            position.at.offsetY *= -1;
            this.top();
          }
        },
        center: function center(axis) {
          if (axis === 'y') {
            var top = myOffset.top() + DomHandler.getOuterHeight(target) / 2;
            element.style.top = top + DomHandler.getWindowScrollTop() + 'px';

            if (top < 0) {
              this.bottom();
            } else if (top + DomHandler.getOuterHeight(target) > viewport.height) {
              this.top();
            }
          } else {
            var left = myOffset.left() + DomHandler.getOuterWidth(target) / 2;
            element.style.left = left + DomHandler.getWindowScrollLeft() + 'px';

            if (left < 0) {
              this.left();
            } else if (left + DomHandler.getOuterWidth(element) > viewport.width) {
              this.right();
            }
          }
        }
      };
      alignWithAt[position.at.x]('x');
      alignWithAt[position.at.y]('y');

      if (this.isFunction(callback)) {
        callback(position);
      }
    }
  }, {
    key: "findCollisionPosition",
    value: function findCollisionPosition(position) {
      if (position) {
        var isAxisY = position === 'top' || position === 'bottom';
        var myXPosition = position === 'left' ? 'right' : 'left';
        var myYPosition = position === 'top' ? 'bottom' : 'top';

        if (isAxisY) {
          return {
            axis: 'y',
            my: "center ".concat(myYPosition),
            at: "center ".concat(position)
          };
        }

        return {
          axis: 'x',
          my: "".concat(myXPosition, " center"),
          at: "".concat(position, " center")
        };
      }
    }
  }, {
    key: "getParents",
    value: function getParents(element) {
      var parents = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      return element['parentNode'] === null ? parents : this.getParents(element.parentNode, parents.concat([element.parentNode]));
    }
  }, {
    key: "getScrollableParents",
    value: function getScrollableParents(element) {
      var scrollableParents = [];

      if (element) {
        var parents = this.getParents(element);
        var overflowRegex = /(auto|scroll)/;

        var overflowCheck = function overflowCheck(node) {
          var styleDeclaration = window['getComputedStyle'](node, null);
          return overflowRegex.test(styleDeclaration.getPropertyValue('overflow')) || overflowRegex.test(styleDeclaration.getPropertyValue('overflowX')) || overflowRegex.test(styleDeclaration.getPropertyValue('overflowY'));
        };

        var _iterator = _createForOfIteratorHelper$j(parents),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var parent = _step.value;
            var scrollSelectors = parent.nodeType === 1 && parent.dataset['scrollselectors'];

            if (scrollSelectors) {
              var selectors = scrollSelectors.split(',');

              var _iterator2 = _createForOfIteratorHelper$j(selectors),
                  _step2;

              try {
                for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                  var selector = _step2.value;
                  var el = this.findSingle(parent, selector);

                  if (el && overflowCheck(el)) {
                    scrollableParents.push(el);
                  }
                }
              } catch (err) {
                _iterator2.e(err);
              } finally {
                _iterator2.f();
              }
            }

            if (parent.nodeType !== 9 && overflowCheck(parent)) {
              scrollableParents.push(parent);
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      return scrollableParents;
    }
  }, {
    key: "getHiddenElementOuterHeight",
    value: function getHiddenElementOuterHeight(element) {
      if (element) {
        element.style.visibility = 'hidden';
        element.style.display = 'block';
        var elementHeight = element.offsetHeight;
        element.style.display = '';
        element.style.visibility = '';
        return elementHeight;
      }

      return 0;
    }
  }, {
    key: "getHiddenElementOuterWidth",
    value: function getHiddenElementOuterWidth(element) {
      if (element) {
        element.style.visibility = 'hidden';
        element.style.display = 'block';
        var elementWidth = element.offsetWidth;
        element.style.display = '';
        element.style.visibility = '';
        return elementWidth;
      }

      return 0;
    }
  }, {
    key: "getHiddenElementDimensions",
    value: function getHiddenElementDimensions(element) {
      var dimensions = {};

      if (element) {
        element.style.visibility = 'hidden';
        element.style.display = 'block';
        dimensions.width = element.offsetWidth;
        dimensions.height = element.offsetHeight;
        element.style.display = '';
        element.style.visibility = '';
      }

      return dimensions;
    }
  }, {
    key: "fadeIn",
    value: function fadeIn(element, duration) {
      if (element) {
        element.style.opacity = 0;
        var last = +new Date();
        var opacity = 0;

        var tick = function tick() {
          opacity = +element.style.opacity + (new Date().getTime() - last) / duration;
          element.style.opacity = opacity;
          last = +new Date();

          if (+opacity < 1) {
            window.requestAnimationFrame && requestAnimationFrame(tick) || setTimeout(tick, 16);
          }
        };

        tick();
      }
    }
  }, {
    key: "fadeOut",
    value: function fadeOut(element, duration) {
      if (element) {
        var opacity = 1,
            interval = 50,
            gap = interval / duration;
        var fading = setInterval(function () {
          opacity -= gap;

          if (opacity <= 0) {
            opacity = 0;
            clearInterval(fading);
          }

          element.style.opacity = opacity;
        }, interval);
      }
    }
  }, {
    key: "getUserAgent",
    value: function getUserAgent() {
      return navigator.userAgent;
    }
  }, {
    key: "isIOS",
    value: function isIOS() {
      return /iPad|iPhone|iPod/.test(navigator.userAgent) && !window['MSStream'];
    }
  }, {
    key: "isAndroid",
    value: function isAndroid() {
      return /(android)/i.test(navigator.userAgent);
    }
  }, {
    key: "isTouchDevice",
    value: function isTouchDevice() {
      return 'ontouchstart' in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;
    }
  }, {
    key: "isFunction",
    value: function isFunction(obj) {
      return !!(obj && obj.constructor && obj.call && obj.apply);
    }
  }, {
    key: "appendChild",
    value: function appendChild(element, target) {
      if (this.isElement(target)) target.appendChild(element);else if (target.el && target.el.nativeElement) target.el.nativeElement.appendChild(element);else throw new Error('Cannot append ' + target + ' to ' + element);
    }
  }, {
    key: "removeChild",
    value: function removeChild(element, target) {
      if (this.isElement(target)) target.removeChild(element);else if (target.el && target.el.nativeElement) target.el.nativeElement.removeChild(element);else throw new Error('Cannot remove ' + element + ' from ' + target);
    }
  }, {
    key: "isElement",
    value: function isElement(obj) {
      return (typeof HTMLElement === "undefined" ? "undefined" : _typeof(HTMLElement)) === "object" ? obj instanceof HTMLElement : obj && _typeof(obj) === "object" && obj !== null && obj.nodeType === 1 && typeof obj.nodeName === "string";
    }
  }, {
    key: "scrollInView",
    value: function scrollInView(container, item) {
      var borderTopValue = getComputedStyle(container).getPropertyValue('borderTopWidth');
      var borderTop = borderTopValue ? parseFloat(borderTopValue) : 0;
      var paddingTopValue = getComputedStyle(container).getPropertyValue('paddingTop');
      var paddingTop = paddingTopValue ? parseFloat(paddingTopValue) : 0;
      var containerRect = container.getBoundingClientRect();
      var itemRect = item.getBoundingClientRect();
      var offset = itemRect.top + document.body.scrollTop - (containerRect.top + document.body.scrollTop) - borderTop - paddingTop;
      var scroll = container.scrollTop;
      var elementHeight = container.clientHeight;
      var itemHeight = this.getOuterHeight(item);

      if (offset < 0) {
        container.scrollTop = scroll + offset;
      } else if (offset + itemHeight > elementHeight) {
        container.scrollTop = scroll + offset - elementHeight + itemHeight;
      }
    }
  }, {
    key: "clearSelection",
    value: function clearSelection() {
      if (window.getSelection) {
        if (window.getSelection().empty) {
          window.getSelection().empty();
        } else if (window.getSelection().removeAllRanges && window.getSelection().rangeCount > 0 && window.getSelection().getRangeAt(0).getClientRects().length > 0) {
          window.getSelection().removeAllRanges();
        }
      } else if (document['selection'] && document['selection'].empty) {
        try {
          document['selection'].empty();
        } catch (error) {//ignore IE bug
        }
      }
    }
  }, {
    key: "calculateScrollbarWidth",
    value: function calculateScrollbarWidth(el) {
      if (el) {
        var style = getComputedStyle(el);
        return el.offsetWidth - el.clientWidth - parseFloat(style.borderLeftWidth) - parseFloat(style.borderRightWidth);
      } else {
        if (this.calculatedScrollbarWidth != null) return this.calculatedScrollbarWidth;
        var scrollDiv = document.createElement("div");
        scrollDiv.className = "p-scrollbar-measure";
        document.body.appendChild(scrollDiv);
        var scrollbarWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
        document.body.removeChild(scrollDiv);
        this.calculatedScrollbarWidth = scrollbarWidth;
        return scrollbarWidth;
      }
    }
  }, {
    key: "getBrowser",
    value: function getBrowser() {
      if (!this.browser) {
        var matched = this.resolveUserAgent();
        this.browser = {};

        if (matched.browser) {
          this.browser[matched.browser] = true;
          this.browser['version'] = matched.version;
        }

        if (this.browser['chrome']) {
          this.browser['webkit'] = true;
        } else if (this.browser['webkit']) {
          this.browser['safari'] = true;
        }
      }

      return this.browser;
    }
  }, {
    key: "resolveUserAgent",
    value: function resolveUserAgent() {
      var ua = navigator.userAgent.toLowerCase();
      var match = /(chrome)[ ]([\w.]+)/.exec(ua) || /(webkit)[ ]([\w.]+)/.exec(ua) || /(opera)(?:.*version|)[ ]([\w.]+)/.exec(ua) || /(msie) ([\w.]+)/.exec(ua) || ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) || [];
      return {
        browser: match[1] || "",
        version: match[2] || "0"
      };
    }
  }, {
    key: "isVisible",
    value: function isVisible(element) {
      return element && element.offsetParent != null;
    }
  }, {
    key: "getFocusableElements",
    value: function getFocusableElements(element) {
      var focusableElements = DomHandler.find(element, "button:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden]),\n                [href][clientHeight][clientWidth]:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden]),\n                input:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden]), select:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden]),\n                textarea:not([tabindex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden]), [tabIndex]:not([tabIndex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden]),\n                [contenteditable]:not([tabIndex = \"-1\"]):not([disabled]):not([style*=\"display:none\"]):not([hidden])");
      var visibleFocusableElements = [];

      var _iterator3 = _createForOfIteratorHelper$j(focusableElements),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var focusableElement = _step3.value;
          if (getComputedStyle(focusableElement).display !== "none" && getComputedStyle(focusableElement).visibility !== "hidden") visibleFocusableElements.push(focusableElement);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return visibleFocusableElements;
    }
  }, {
    key: "getFirstFocusableElement",
    value: function getFirstFocusableElement(element) {
      var focusableElements = DomHandler.getFocusableElements(element);
      return focusableElements.length > 0 ? focusableElements[0] : null;
    }
  }, {
    key: "getLastFocusableElement",
    value: function getLastFocusableElement(element) {
      var focusableElements = DomHandler.getFocusableElements(element);
      return focusableElements.length > 0 ? focusableElements[focusableElements.length - 1] : null;
    }
  }, {
    key: "getCursorOffset",
    value: function getCursorOffset(el, prevText, nextText, currentText) {
      if (el) {
        var style = getComputedStyle(el);
        var ghostDiv = document.createElement('div');
        ghostDiv.style.position = 'absolute';
        ghostDiv.style.top = '0px';
        ghostDiv.style.left = '0px';
        ghostDiv.style.visibility = 'hidden';
        ghostDiv.style.pointerEvents = 'none';
        ghostDiv.style.overflow = style.overflow;
        ghostDiv.style.width = style.width;
        ghostDiv.style.height = style.height;
        ghostDiv.style.padding = style.padding;
        ghostDiv.style.border = style.border;
        ghostDiv.style.overflowWrap = style.overflowWrap;
        ghostDiv.style.whiteSpace = style.whiteSpace;
        ghostDiv.style.lineHeight = style.lineHeight;
        ghostDiv.innerHTML = prevText.replace(/\r\n|\r|\n/g, '<br />');
        var ghostSpan = document.createElement('span');
        ghostSpan.textContent = currentText;
        ghostDiv.appendChild(ghostSpan);
        var text = document.createTextNode(nextText);
        ghostDiv.appendChild(text);
        document.body.appendChild(ghostDiv);
        var offsetLeft = ghostSpan.offsetLeft,
            offsetTop = ghostSpan.offsetTop,
            clientHeight = ghostSpan.clientHeight;
        document.body.removeChild(ghostDiv);
        return {
          left: Math.abs(offsetLeft - el.scrollLeft),
          top: Math.abs(offsetTop - el.scrollTop) + clientHeight
        };
      }

      return {
        top: 'auto',
        left: 'auto'
      };
    }
  }]);

  return DomHandler;
}();

var ConnectedOverlayScrollHandler = /*#__PURE__*/function () {
  function ConnectedOverlayScrollHandler(element) {
    var listener = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};

    _classCallCheck(this, ConnectedOverlayScrollHandler);

    this.element = element;
    this.listener = listener;
  }

  _createClass(ConnectedOverlayScrollHandler, [{
    key: "bindScrollListener",
    value: function bindScrollListener() {
      this.scrollableParents = DomHandler.getScrollableParents(this.element);

      for (var i = 0; i < this.scrollableParents.length; i++) {
        this.scrollableParents[i].addEventListener('scroll', this.listener);
      }
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollableParents) {
        for (var i = 0; i < this.scrollableParents.length; i++) {
          this.scrollableParents[i].removeEventListener('scroll', this.listener);
        }
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.unbindScrollListener();
      this.element = null;
      this.listener = null;
      this.scrollableParents = null;
    }
  }]);

  return ConnectedOverlayScrollHandler;
}();

function EventBus () {
  var allHandlers = new Map();
  return {
    on: function on(type, handler) {
      var handlers = allHandlers.get(type);
      if (!handlers) handlers = [handler];else handlers.push(handler);
      allHandlers.set(type, handlers);
    },
    off: function off(type, handler) {
      var handlers = allHandlers.get(type);
      handlers && handlers.splice(handlers.indexOf(handler) >>> 0, 1);
    },
    emit: function emit(type, evt) {
      var handlers = allHandlers.get(type);
      handlers && handlers.slice().forEach(function (handler) {
        return handler(evt);
      });
    }
  };
}

var ObjectUtils = /*#__PURE__*/function () {
  function ObjectUtils() {
    _classCallCheck(this, ObjectUtils);
  }

  _createClass(ObjectUtils, null, [{
    key: "equals",
    value: function equals(obj1, obj2, field) {
      if (field && obj1 && _typeof(obj1) === 'object' && obj2 && _typeof(obj2) === 'object') return this.resolveFieldData(obj1, field) === this.resolveFieldData(obj2, field);else return this.deepEquals(obj1, obj2);
    }
  }, {
    key: "deepEquals",
    value: function deepEquals(a, b) {
      if (a === b) return true;

      if (a && b && _typeof(a) == 'object' && _typeof(b) == 'object') {
        var arrA = Array.isArray(a),
            arrB = Array.isArray(b),
            i,
            length,
            key;

        if (arrA && arrB) {
          length = a.length;
          if (length !== b.length) return false;

          for (i = length; i-- !== 0;) {
            if (!this.deepEquals(a[i], b[i])) return false;
          }

          return true;
        }

        if (arrA !== arrB) return false;
        var dateA = a instanceof Date,
            dateB = b instanceof Date;
        if (dateA !== dateB) return false;
        if (dateA && dateB) return a.getTime() === b.getTime();
        var regexpA = a instanceof RegExp,
            regexpB = b instanceof RegExp;
        if (regexpA !== regexpB) return false;
        if (regexpA && regexpB) return a.toString() === b.toString();
        var keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length) return false;

        for (i = length; i-- !== 0;) {
          if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
        }

        for (i = length; i-- !== 0;) {
          key = keys[i];
          if (!this.deepEquals(a[key], b[key])) return false;
        }

        return true;
      }
      /*eslint no-self-compare: "off"*/


      return a !== a && b !== b;
    }
  }, {
    key: "resolveFieldData",
    value: function resolveFieldData(data, field) {
      if (data && Object.keys(data).length && field) {
        if (this.isFunction(field)) {
          return field(data);
        } else if (field.indexOf('.') === -1) {
          return data[field];
        } else {
          var fields = field.split('.');
          var value = data;

          for (var i = 0, len = fields.length; i < len; ++i) {
            if (value == null) {
              return null;
            }

            value = value[fields[i]];
          }

          return value;
        }
      } else {
        return null;
      }
    }
  }, {
    key: "isFunction",
    value: function isFunction(obj) {
      return !!(obj && obj.constructor && obj.call && obj.apply);
    }
  }, {
    key: "findDiffKeys",
    value: function findDiffKeys(obj1, obj2) {
      if (!obj1 || !obj2) {
        return {};
      }

      return Object.keys(obj1).filter(function (key) {
        return !obj2.hasOwnProperty(key);
      }).reduce(function (result, current) {
        result[current] = obj1[current];
        return result;
      }, {});
    }
  }, {
    key: "reorderArray",
    value: function reorderArray(value, from, to) {
      var target;

      if (value && from !== to) {
        if (to >= value.length) {
          target = to - value.length;

          while (target-- + 1) {
            value.push(undefined);
          }
        }

        value.splice(to, 0, value.splice(from, 1)[0]);
      }
    }
  }, {
    key: "findIndexInList",
    value: function findIndexInList(value, list, dataKey) {
      var _this = this;

      if (list) {
        return dataKey ? list.findIndex(function (item) {
          return _this.equals(item, value, dataKey);
        }) : list.findIndex(function (item) {
          return item === value;
        });
      }

      return -1;
    }
  }, {
    key: "getJSXElement",
    value: function getJSXElement(obj) {
      for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        params[_key - 1] = arguments[_key];
      }

      return this.isFunction(obj) ? obj.apply(void 0, params) : obj;
    }
  }, {
    key: "removeAccents",
    value: function removeAccents(str) {
      if (str && str.search(/[\xC0-\xFF]/g) > -1) {
        str = str.replace(/[\xC0-\xC5]/g, "A").replace(/[\xC6]/g, "AE").replace(/[\xC7]/g, "C").replace(/[\xC8-\xCB]/g, "E").replace(/[\xCC-\xCF]/g, "I").replace(/[\xD0]/g, "D").replace(/[\xD1]/g, "N").replace(/[\xD2-\xD6\xD8]/g, "O").replace(/[\xD9-\xDC]/g, "U").replace(/[\xDD]/g, "Y").replace(/[\xDE]/g, "P").replace(/[\xE0-\xE5]/g, "a").replace(/[\xE6]/g, "ae").replace(/[\xE7]/g, "c").replace(/[\xE8-\xEB]/g, "e").replace(/[\xEC-\xEF]/g, "i").replace(/[\xF1]/g, "n").replace(/[\xF2-\xF6\xF8]/g, "o").replace(/[\xF9-\xFC]/g, "u").replace(/[\xFE]/g, "p").replace(/[\xFD\xFF]/g, "y");
      }

      return str;
    }
  }, {
    key: "isEmpty",
    value: function isEmpty(value) {
      return value === null || value === undefined || value === '' || Array.isArray(value) && value.length === 0 || _typeof(value) === 'object' && Object.keys(value).length === 0;
    }
  }, {
    key: "isNotEmpty",
    value: function isNotEmpty(value) {
      return !this.isEmpty(value);
    }
  }]);

  return ObjectUtils;
}();

function _createForOfIteratorHelper$i(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$i(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$i(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$i(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$i(o, minLen); }

function _arrayLikeToArray$i(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var FilterUtils = /*#__PURE__*/function () {
  function FilterUtils() {
    _classCallCheck(this, FilterUtils);
  }

  _createClass(FilterUtils, null, [{
    key: "filter",
    value: function filter(value, fields, filterValue, filterMatchMode, filterLocale) {
      var filteredItems = [];
      var filterText = ObjectUtils.removeAccents(filterValue).toLocaleLowerCase(filterLocale);

      if (value) {
        var _iterator = _createForOfIteratorHelper$i(value),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var item = _step.value;

            var _iterator2 = _createForOfIteratorHelper$i(fields),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var field = _step2.value;
                var fieldValue = ObjectUtils.removeAccents(String(ObjectUtils.resolveFieldData(item, field))).toLocaleLowerCase(filterLocale);

                if (FilterUtils[filterMatchMode](fieldValue, filterText, filterLocale)) {
                  filteredItems.push(item);
                  break;
                }
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      return filteredItems;
    }
  }, {
    key: "startsWith",
    value: function startsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.slice(0, filterValue.length) === filterValue;
    }
  }, {
    key: "contains",
    value: function contains(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue) !== -1;
    }
  }, {
    key: "endsWith",
    value: function endsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
      var stringValue = ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);
      return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
    }
  }, {
    key: "equals",
    value: function equals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() === filter.getTime();else return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) === ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    }
  }, {
    key: "notEquals",
    value: function notEquals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return false;
      }

      if (value === undefined || value === null) {
        return true;
      }

      if (value.getTime && filter.getTime) return value.getTime() !== filter.getTime();else return ObjectUtils.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) !== ObjectUtils.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    }
  }, {
    key: "in",
    value: function _in(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      for (var i = 0; i < filter.length; i++) {
        if (ObjectUtils.equals(value, filter[i])) {
          return true;
        }
      }

      return false;
    }
  }, {
    key: "lt",
    value: function lt(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() < filter.getTime();else return value < parseFloat(filter);
    }
  }, {
    key: "lte",
    value: function lte(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() <= filter.getTime();else return value <= parseFloat(filter);
    }
  }, {
    key: "gt",
    value: function gt(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() > filter.getTime();else return value > parseFloat(filter);
    }
  }, {
    key: "gte",
    value: function gte(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() >= filter.getTime();else return value >= parseFloat(filter);
    }
  }]);

  return FilterUtils;
}();

function ownKeys$P(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$P(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$P(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$P(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
function mask(el, options) {
  var defaultOptions = {
    mask: null,
    slotChar: '_',
    autoClear: true,
    unmask: false,
    readOnly: false,
    onComplete: null,
    onChange: null,
    onFocus: null,
    onBlur: null
  };
  options = _objectSpread$P(_objectSpread$P({}, defaultOptions), options);
  var tests, partialPosition, len, firstNonMaskPos, defs, androidChrome, lastRequiredNonMaskPos, oldVal, focusText, caretTimeoutId, buffer, defaultBuffer;

  var caret = function caret(first, last) {
    var range, begin, end;

    if (!el.offsetParent || el !== document.activeElement) {
      return;
    }

    if (typeof first === 'number') {
      begin = first;
      end = typeof last === 'number' ? last : begin;

      if (el.setSelectionRange) {
        el.setSelectionRange(begin, end);
      } else if (el['createTextRange']) {
        range = el['createTextRange']();
        range.collapse(true);
        range.moveEnd('character', end);
        range.moveStart('character', begin);
        range.select();
      }
    } else {
      if (el.setSelectionRange) {
        begin = el.selectionStart;
        end = el.selectionEnd;
      } else if (document['selection'] && document['selection'].createRange) {
        range = document['selection'].createRange();
        begin = 0 - range.duplicate().moveStart('character', -100000);
        end = begin + range.text.length;
      }

      return {
        begin: begin,
        end: end
      };
    }
  };

  var isCompleted = function isCompleted() {
    for (var i = firstNonMaskPos; i <= lastRequiredNonMaskPos; i++) {
      if (tests[i] && buffer[i] === getPlaceholder(i)) {
        return false;
      }
    }

    return true;
  };

  var getPlaceholder = function getPlaceholder(i) {
    if (i < options.slotChar.length) {
      return options.slotChar.charAt(i);
    }

    return options.slotChar.charAt(0);
  };

  var getValue = function getValue() {
    return options.unmask ? getUnmaskedValue() : el && el.value;
  };

  var seekNext = function seekNext(pos) {
    while (++pos < len && !tests[pos]) {
    }

    return pos;
  };

  var seekPrev = function seekPrev(pos) {
    while (--pos >= 0 && !tests[pos]) {
    }

    return pos;
  };

  var shiftL = function shiftL(begin, end) {
    var i, j;

    if (begin < 0) {
      return;
    }

    for (i = begin, j = seekNext(end); i < len; i++) {
      if (tests[i]) {
        if (j < len && tests[i].test(buffer[j])) {
          buffer[i] = buffer[j];
          buffer[j] = getPlaceholder(j);
        } else {
          break;
        }

        j = seekNext(j);
      }
    }

    writeBuffer();
    caret(Math.max(firstNonMaskPos, begin));
  };

  var shiftR = function shiftR(pos) {
    var i, c, j, t;

    for (i = pos, c = getPlaceholder(pos); i < len; i++) {
      if (tests[i]) {
        j = seekNext(i);
        t = buffer[i];
        buffer[i] = c;

        if (j < len && tests[j].test(t)) {
          c = t;
        } else {
          break;
        }
      }
    }
  };

  var handleAndroidInput = function handleAndroidInput(e) {
    var curVal = el.value;
    var pos = caret();

    if (oldVal && oldVal.length && oldVal.length > curVal.length) {
      // a deletion or backspace happened
      checkVal(true);

      while (pos.begin > 0 && !tests[pos.begin - 1]) {
        pos.begin--;
      }

      if (pos.begin === 0) {
        while (pos.begin < firstNonMaskPos && !tests[pos.begin]) {
          pos.begin++;
        }
      }

      caret(pos.begin, pos.begin);
    } else {
      checkVal(true);

      while (pos.begin < len && !tests[pos.begin]) {
        pos.begin++;
      }

      caret(pos.begin, pos.begin);
    }

    if (options.onComplete && isCompleted()) {
      options.onComplete({
        originalEvent: e,
        value: getValue()
      });
    }
  };

  var onBlur = function onBlur(e) {
    checkVal();
    updateModel(e);

    if (options.onBlur) {
      options.onBlur(e);
    }

    if (el.value !== focusText) {
      var event = document.createEvent('HTMLEvents');
      event.initEvent('change', true, false);
      el.dispatchEvent(event);
    }
  };

  var onKeyDown = function onKeyDown(e) {
    if (options.readOnly) {
      return;
    }

    var k = e.which || e.keyCode,
        pos,
        begin,
        end;
    var iPhone = /iphone/i.test(DomHandler.getUserAgent());
    oldVal = el.value; //backspace, delete, and escape get special treatment

    if (k === 8 || k === 46 || iPhone && k === 127) {
      pos = caret();
      begin = pos.begin;
      end = pos.end;

      if (end - begin === 0) {
        begin = k !== 46 ? seekPrev(begin) : end = seekNext(begin - 1);
        end = k === 46 ? seekNext(end) : end;
      }

      clearBuffer(begin, end);
      shiftL(begin, end - 1);
      updateModel(e);
      e.preventDefault();
    } else if (k === 13) {
      // enter
      onBlur(e);
      updateModel(e);
    } else if (k === 27) {
      // escape
      el.value = focusText;
      caret(0, checkVal());
      updateModel(e);
      e.preventDefault();
    }
  };

  var onKeyPress = function onKeyPress(e) {
    if (options.readOnly) {
      return;
    }

    var k = e.which || e.keyCode,
        pos = caret(),
        p,
        c,
        next,
        completed;

    if (e.ctrlKey || e.altKey || e.metaKey || k < 32) {
      //Ignore
      return;
    } else if (k && k !== 13) {
      if (pos.end - pos.begin !== 0) {
        clearBuffer(pos.begin, pos.end);
        shiftL(pos.begin, pos.end - 1);
      }

      p = seekNext(pos.begin - 1);

      if (p < len) {
        c = String.fromCharCode(k);

        if (tests[p].test(c)) {
          shiftR(p);
          buffer[p] = c;
          writeBuffer();
          next = seekNext(p);

          if (/android/i.test(DomHandler.getUserAgent())) {
            //Path for CSP Violation on FireFox OS 1.1
            var proxy = function proxy() {
              caret(next);
            };

            setTimeout(proxy, 0);
          } else {
            caret(next);
          }

          if (pos.begin <= lastRequiredNonMaskPos) {
            completed = isCompleted();
          }
        }
      }

      e.preventDefault();
    }

    updateModel(e);

    if (options.onComplete && completed) {
      options.onComplete({
        originalEvent: e,
        value: getValue()
      });
    }
  };

  var clearBuffer = function clearBuffer(start, end) {
    var i;

    for (i = start; i < end && i < len; i++) {
      if (tests[i]) {
        buffer[i] = getPlaceholder(i);
      }
    }
  };

  var writeBuffer = function writeBuffer() {
    el.value = buffer.join('');
  };

  var checkVal = function checkVal(allow) {
    //try to place characters where they belong
    var test = el.value,
        lastMatch = -1,
        i,
        c,
        pos;

    for (i = 0, pos = 0; i < len; i++) {
      if (tests[i]) {
        buffer[i] = getPlaceholder(i);

        while (pos++ < test.length) {
          c = test.charAt(pos - 1);

          if (tests[i].test(c)) {
            buffer[i] = c;
            lastMatch = i;
            break;
          }
        }

        if (pos > test.length) {
          clearBuffer(i + 1, len);
          break;
        }
      } else {
        if (buffer[i] === test.charAt(pos)) {
          pos++;
        }

        if (i < partialPosition) {
          lastMatch = i;
        }
      }
    }

    if (allow) {
      writeBuffer();
    } else if (lastMatch + 1 < partialPosition) {
      if (options.autoClear || buffer.join('') === defaultBuffer) {
        // Invalid value. Remove it and replace it with the
        // mask, which is the default behavior.
        if (el.value) el.value = '';
        clearBuffer(0, len);
      } else {
        // Invalid value, but we opt to show the value to the
        // user and allow them to correct their mistake.
        writeBuffer();
      }
    } else {
      writeBuffer();
      el.value = el.value.substring(0, lastMatch + 1);
    }

    return partialPosition ? i : firstNonMaskPos;
  };

  var onFocus = function onFocus(e) {
    if (options.readOnly) {
      return;
    }

    clearTimeout(caretTimeoutId);
    var pos;
    focusText = el.value;
    pos = checkVal();
    caretTimeoutId = setTimeout(function () {
      if (el !== document.activeElement) {
        return;
      }

      writeBuffer();

      if (pos === options.mask.replace("?", "").length) {
        caret(0, pos);
      } else {
        caret(pos);
      }
    }, 10);

    if (options.onFocus) {
      options.onFocus(e);
    }
  };

  var onInput = function onInput(event) {
    if (androidChrome) handleAndroidInput(event);else handleInputChange(event);
  };

  var handleInputChange = function handleInputChange(e) {
    if (options.readOnly) {
      return;
    }

    var pos = checkVal(true);
    caret(pos);
    updateModel(e);

    if (options.onComplete && isCompleted()) {
      options.onComplete({
        originalEvent: e,
        value: getValue()
      });
    }
  };

  var getUnmaskedValue = function getUnmaskedValue() {
    var unmaskedBuffer = [];

    for (var i = 0; i < buffer.length; i++) {
      var c = buffer[i];

      if (tests[i] && c !== getPlaceholder(i)) {
        unmaskedBuffer.push(c);
      }
    }

    return unmaskedBuffer.join('');
  };

  var updateModel = function updateModel(e) {
    if (options.onChange) {
      var val = getValue().replace(options.slotChar, '');
      options.onChange({
        originalEvent: e,
        value: defaultBuffer !== val ? val : ''
      });
    }
  };

  var bindEvents = function bindEvents() {
    el.addEventListener('focus', onFocus);
    el.addEventListener('blur', onBlur);
    el.addEventListener('keydown', onKeyDown);
    el.addEventListener('keypress', onKeyPress);
    el.addEventListener('input', onInput);
    el.addEventListener('paste', handleInputChange);
  };

  var unbindEvents = function unbindEvents() {
    el.removeEventListener('focus', onFocus);
    el.removeEventListener('blur', onBlur);
    el.removeEventListener('keydown', onKeyDown);
    el.removeEventListener('keypress', onKeyPress);
    el.removeEventListener('input', onInput);
    el.removeEventListener('paste', handleInputChange);
  };

  var init = function init() {
    tests = [];
    partialPosition = options.mask.length;
    len = options.mask.length;
    firstNonMaskPos = null;
    defs = {
      '9': '[0-9]',
      'a': '[A-Za-z]',
      '*': '[A-Za-z0-9]'
    };
    var ua = DomHandler.getUserAgent();
    androidChrome = /chrome/i.test(ua) && /android/i.test(ua);
    var maskTokens = options.mask.split('');

    for (var i = 0; i < maskTokens.length; i++) {
      var c = maskTokens[i];

      if (c === '?') {
        len--;
        partialPosition = i;
      } else if (defs[c]) {
        tests.push(new RegExp(defs[c]));

        if (firstNonMaskPos === null) {
          firstNonMaskPos = tests.length - 1;
        }

        if (i < partialPosition) {
          lastRequiredNonMaskPos = tests.length - 1;
        }
      } else {
        tests.push(null);
      }
    }

    buffer = [];

    for (var _i = 0; _i < maskTokens.length; _i++) {
      var _c = maskTokens[_i];

      if (_c !== '?') {
        if (defs[_c]) buffer.push(getPlaceholder(_i));else buffer.push(_c);
      }
    }

    defaultBuffer = buffer.join('');
  };

  if (el && options.mask) {
    init();
    bindEvents();
  }

  return {
    init: init,
    bindEvents: bindEvents,
    unbindEvents: unbindEvents,
    updateModel: updateModel,
    getValue: getValue
  };
}

var lastId = 0;
function UniqueComponentId () {
  var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'pr_id_';
  lastId++;
  return "".concat(prefix).concat(lastId);
}

var PrimeReact = function PrimeReact() {
  _classCallCheck(this, PrimeReact);
};

_defineProperty(PrimeReact, "ripple", false);

_defineProperty(PrimeReact, "locale", 'en');

_defineProperty(PrimeReact, "autoZIndex", true);

_defineProperty(PrimeReact, "zIndex", {
  modal: 1100,
  overlay: 1000,
  menu: 1000,
  tooltip: 1100,
  toast: 1200
});

_defineProperty(PrimeReact, "appendTo", null);

function ownKeys$O(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$O(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$O(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$O(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
var locales = {
  'en': {
    accept: 'Yes',
    reject: 'No',
    choose: 'Choose',
    upload: 'Upload',
    cancel: 'Cancel',
    dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    dayNamesMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
    monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    today: 'Today',
    clear: 'Clear',
    weekHeader: 'Wk',
    firstDayOfWeek: 0,
    dateFormat: 'mm/dd/yy',
    weak: 'Weak',
    medium: 'Medium',
    strong: 'Strong',
    passwordPrompt: 'Enter a password'
  }
};

function locale(locale) {
  if (locale) {
    PrimeReact.locale = locale;
  }

  return {
    locale: PrimeReact.locale,
    options: locales[PrimeReact.locale]
  };
}

function addLocale(locale, options) {
  locales[locale] = _objectSpread$O(_objectSpread$O({}, locales['en']), options);
}

function updateLocaleOption(key, value, locale) {
  localeOptions(locale)[key] = value;
}

function updateLocaleOptions(options, locale) {
  var _locale = locale || PrimeReact.locale;

  locales[_locale] = _objectSpread$O(_objectSpread$O({}, locales[_locale]), options);
}

function localeOption(key, locale) {
  try {
    return localeOptions(locale)[key];
  } catch (error) {
    throw new Error("The ".concat(key, " option is not found in the current locale('").concat(locale || PrimeReact.locale, "')."));
  }
}

function localeOptions(locale) {
  var _locale = locale || PrimeReact.locale;

  return locales[_locale];
}

var PrimeIcons = Object.freeze({
  ALIGN_CENTER: 'pi pi-align-center',
  ALIGN_JUSTIFY: 'pi pi-align-justify',
  ALIGN_LEFT: 'pi pi-align-left',
  ALIGN_RIGHT: 'pi pi-align-right',
  AMAZON: 'pi pi-amazon',
  ANDROID: 'pi pi-android',
  ANGLE_DOUBLE_DOWN: 'pi pi-angle-double-down',
  ANGLE_DOUBLE_LEFT: 'pi pi-angle-double-left',
  ANGLE_DOUBLE_RIGHT: 'pi pi-angle-double-right',
  ANGLE_DOUBLE_UP: 'pi pi-angle-double-up',
  ANGLE_DOWN: 'pi pi-angle-down',
  ANGLE_LEFT: 'pi pi-angle-left',
  ANGLE_RIGHT: 'pi pi-angle-right',
  ANGLE_UP: 'pi pi-angle-up',
  APPLE: 'pi pi-apple',
  ARROW_CIRCLE_DOWN: 'pi pi-arrow-circle-down',
  ARROW_CIRCLE_LEFT: 'pi pi-arrow-circle-left',
  ARROW_CIRCLE_RIGHT: 'pi pi-arrow-circle-right',
  ARROW_CIRCLE_UP: 'pi pi-arrow-circle-up',
  ARROW_DOWN: 'pi pi-arrow-down',
  ARROW_LEFT: 'pi pi-arrow-left',
  ARROW_RIGHT: 'pi pi-arrow-right',
  ARROW_UP: 'pi pi-arrow-up',
  BACKWARD: 'pi pi-backward',
  BAN: 'pi pi-ban',
  BARS: 'pi pi-bars',
  BELL: 'pi pi-bell',
  BOOK: 'pi pi-book',
  BOOKMARK: 'pi pi-bookmark',
  BRIEFCASE: 'pi pi-briefcase',
  CALENDAR_MINUS: 'pi pi-calendar-minus',
  CALENDAR_PLUS: 'pi pi-calendar-plus',
  CALENDAR_TIMES: 'pi pi-calendar-times',
  CALENDAR: 'pi pi-calendar',
  CAMERA: 'pi pi-camera',
  CARET_DOWN: 'pi pi-caret-down',
  CARET_LEFT: 'pi pi-caret-left',
  CARET_RIGHT: 'pi pi-caret-right',
  CARET_UP: 'pi pi-caret-up',
  CHART_BAR: 'pi pi-chart-bar',
  CHART_LINE: 'pi pi-chart-line',
  CHECK_CIRCLE: 'pi pi-check-circle',
  CHECK_SQUARE: 'pi pi-check-square',
  CHECK: 'pi pi-check',
  CHEVRON_CIRCLE_DOWN: 'pi pi-chevron-circle-down',
  CHEVRON_CIRCLE_LEFT: 'pi pi-chevron-circle-left',
  CHEVRON_CIRCLE_RIGHT: 'pi pi-chevron-circle-right',
  CHEVRON_CIRCLE_UP: 'pi pi-chevron-circle-up',
  CHEVRON_DOWN: 'pi pi-chevron-down',
  CHEVRON_LEFT: 'pi pi-chevron-left',
  CHEVRON_RIGHT: 'pi pi-chevron-right',
  CHEVRON_UP: 'pi pi-chevron-up',
  CLOCK: 'pi pi-clock',
  CLONE: 'pi pi-clone',
  CLOUD_DOWNLOAD: 'pi pi-cloud-download',
  CLOUD_UPLOAD: 'pi pi-cloud-upload',
  CLOUD: 'pi pi-cloud',
  COG: 'pi pi-cog',
  COMMENT: 'pi pi-comment',
  COMMENTS: 'pi pi-comments',
  COMPASS: 'pi pi-compass',
  COPY: 'pi pi-copy',
  CREDIT_CARD: 'pi pi-credit-card',
  DESKTOP: 'pi pi-desktop',
  DISCORD: 'pi pi-discord',
  DIRECTIONS_ALT: 'pi pi-directions-alt',
  DIRECTIONS: 'pi pi-directions',
  DOLLAR: 'pi pi-dollar',
  DOWNLOAD: 'pi pi-download',
  EJECT: 'pi pi-eject',
  ELLIPSIS_H: 'pi pi-ellipsis-h',
  ELLIPSIS_V: 'pi pi-ellipsis-v',
  ENVELOPE: 'pi pi-envelope',
  EXCLAMATION_CIRCLE: 'pi pi-exclamation-circle',
  EXCLAMATION_TRIANGLE: 'pi pi-exclamation-triangle ',
  EXTERNAL_LINK: 'pi pi-external-link',
  EYE_SLASH: 'pi pi-eye-slash',
  EYE: 'pi pi-eye',
  FACEBOOK: 'pi pi-facebook',
  FAST_BACKWARD: 'pi pi-fast-backward',
  FAST_FORWARD: 'pi pi-fast-forward',
  FILE_EXCEL: 'pi pi-file-excel',
  FILE_O: 'pi pi-file-o',
  FILE_PDF: 'pi pi-file-pdf',
  FILE: 'pi pi-file',
  FILTER: 'pi pi-filter',
  FILTER_SLASH: 'pi pi-filter-slash',
  FLAG: 'pi pi-flag',
  FOLDER_OPEN: 'pi pi-folder-open',
  FOLDER: 'pi pi-folder',
  FORWARD: 'pi pi-forward',
  GITHUB: 'pi pi-github',
  GLOBE: 'pi pi-globe',
  GOOGLE: 'pi pi-google',
  HEART: 'pi pi-heart',
  HOME: 'pi pi-home',
  ID_CARD: 'pi pi-id-card',
  IMAGE: 'pi pi-image',
  IMAGES: 'pi pi-images',
  INBOX: 'pi pi-inbox',
  INFO_CIRCLE: 'pi pi-info-circle',
  INFO: 'pi pi-info',
  KEY: 'pi pi-key',
  LINK: 'pi pi-link',
  LIST: 'pi pi-list',
  LOCK_OPEN: 'pi pi-lock-open',
  LOCK: 'pi pi-lock',
  MAP: 'pi pi-map',
  MAP_MARKER: 'pi pi-map-marker',
  MICROSOFT: 'pi pi-microsoft',
  MINUS_CIRCLE: 'pi pi-minus-circle',
  MINUS: 'pi pi-minus',
  MOBILE: 'pi pi-mobile',
  MONEY_BILL: 'pi pi-money-bill',
  MOON: 'pi pi-moon',
  PALETTE: 'pi pi-palette',
  PAPERCLIP: 'pi pi-paperclip',
  PAUSE: 'pi pi-pause',
  PAYPAL: 'pi pi-paypal',
  PENCIL: 'pi pi-pencil',
  PERCENTAGE: 'pi pi-percentage',
  PHONE: 'pi pi-phone',
  PLAY: 'pi pi-play',
  PLUS_CIRCLE: 'pi pi-plus-circle',
  PLUS: 'pi pi-plus',
  POWER_OFF: 'pi pi-power-off',
  PRINT: 'pi pi-print',
  QUESTION_CIRCLE: 'pi pi-question-circle',
  QUESTION: 'pi pi-question',
  RADIO_OFF: 'pi pi-radio-off',
  RADIO_ON: 'pi pi-radio-on',
  REFRESH: 'pi pi-refresh',
  REPLAY: 'pi pi-replay',
  REPLY: 'pi pi-reply',
  SAVE: 'pi pi-save',
  SEARCH_MINUS: 'pi pi-search-minus',
  SEARCH_PLUS: 'pi pi-search-plus',
  SEARCH: 'pi pi-search',
  SEND: 'pi pi-send',
  SHARE_ALT: 'pi pi-share-alt',
  SHIELD: 'pi pi-shield',
  SHOPPING_CART: 'pi pi-shopping-cart',
  SIGN_IN: 'pi pi-sign-in',
  SIGN_OUT: 'pi pi-sign-out',
  SITEMAP: 'pi pi-sitemap',
  SLACK: 'pi pi-slack',
  SLIDERS_H: 'pi pi-sliders-h',
  SLIDERS_V: 'pi pi-sliders-v',
  SORT_ALPHA_ALT_DOWN: 'pi pi-sort-alpha-alt-down',
  SORT_ALPHA_ALT_UP: 'pi pi-sort-alpha-alt-up',
  SORT_ALPHA_DOWN: 'pi pi-sort-alpha-down',
  SORT_ALPHA_UP: 'pi pi-sort-alpha-up',
  SORT_ALT: 'pi pi-sort-alt',
  SORT_AMOUNT_DOWN_ALT: 'pi pi-sort-amount-down-alt',
  SORT_AMOUNT_DOWN: 'pi pi-sort-amount-down',
  SORT_AMOUNT_UP_ALT: 'pi pi-sort-amount-up-alt',
  SORT_AMOUNT_UP: 'pi pi-sort-amount-up',
  SORT_DOWN: 'pi pi-sort-down',
  SORT_NUMERIC_ALT_DOWN: 'pi pi-sort-numeric-alt-down',
  SORT_NUMERIC_ALT_UP: 'pi pi-sort-numeric-alt-up',
  SORT_NUMERIC_DOWN: 'pi pi-sort-numeric-down',
  SORT_NUMERIC_UP: 'pi pi-sort-numeric-up',
  SORT_UP: 'pi pi-sort-up',
  SORT: 'pi pi-sort',
  SPINNER: 'pi pi-spinner',
  STAR_O: 'pi pi-star-o',
  STAR: 'pi pi-star',
  STEP_BACKWARD_ALT: 'pi pi-step-backward-alt',
  STEP_BACKWARD: 'pi pi-step-backward',
  STEP_FORWARD_ALT: 'pi pi-step-forward-alt',
  STEP_FORWARD: 'pi pi-step-forward',
  SUN: 'pi pi-sun',
  TABLE: 'pi pi-table',
  TABLET: 'pi pi-tablet',
  TAG: 'pi pi-tag',
  TAGS: 'pi pi-tags',
  TH_LARGE: 'pi pi-th-large',
  THUMBS_DOWN: 'pi pi-thumbs-down',
  THUMBS_UP: 'pi pi-thumbs-up',
  TICKET: 'pi pi-ticket',
  TIMES_CIRCLE: 'pi pi-times-circle',
  TIMES: 'pi pi-times',
  TRASH: 'pi pi-trash',
  TWITTER: 'pi pi-twitter',
  UNDO: 'pi pi-undo',
  UNLOCK: 'pi pi-unlock',
  UPLOAD: 'pi pi-upload',
  USER_EDIT: 'pi pi-user-edit',
  USER_MINUS: 'pi pi-user-minus',
  USER_PLUS: 'pi pi-user-plus',
  USER: 'pi pi-user',
  USERS: 'pi pi-users',
  VIDEO: 'pi pi-video',
  VIMEO: 'pi pi-vimeo',
  VOLUME_DOWN: 'pi pi-volume-down',
  VOLUME_OFF: 'pi pi-volume-off',
  VOLUME_UP: 'pi pi-volume-up',
  YOUTUBE: 'pi pi-youtube',
  WALLET: 'pi pi-wallet',
  WIFI: 'pi pi-wifi',
  WINDOW_MAXIMIZE: 'pi pi-window-maximize',
  WINDOW_MINIMIZE: 'pi pi-window-minimize'
});

var MessageSeverity = Object.freeze({
  SUCCESS: 'success',
  INFO: 'info',
  WARN: 'warn',
  ERROR: 'error'
});

function handler() {
  var zIndexes = [];

  var generateZIndex = function generateZIndex(key, baseZIndex) {
    baseZIndex = baseZIndex || getBaseZIndex(key);
    var lastZIndex = getLastZIndex(key, baseZIndex);
    var newZIndex = lastZIndex.value + (lastZIndex.key === key ? 0 : baseZIndex) + 1;
    zIndexes.push({
      key: key,
      value: newZIndex
    });
    return newZIndex;
  };

  var revertZIndex = function revertZIndex(zIndex) {
    zIndexes = zIndexes.filter(function (obj) {
      return obj.value !== zIndex;
    });
  };

  var getBaseZIndex = function getBaseZIndex(key) {
    return PrimeReact.zIndex[key] || 999;
  };

  var getCurrentZIndex = function getCurrentZIndex(key) {
    return getLastZIndex(key).value;
  };

  var getLastZIndex = function getLastZIndex(key) {
    var baseZIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    return (zIndexes || []).reverse().find(function (obj) {
      return PrimeReact.autoZIndex ? true : obj.key === key;
    }) || {
      key: key,
      value: baseZIndex
    };
  };

  return {
    get: function get(el) {
      return el ? parseInt(el.style.zIndex, 10) || 0 : 0;
    },
    set: function set(key, el, baseZIndex) {
      if (el) {
        el.style.zIndex = String(generateZIndex(key, baseZIndex));
      }
    },
    clear: function clear(el) {
      if (el) {
        revertZIndex(ZIndexUtils.get(el));
        el.style.zIndex = '';
      }
    },
    getBase: function getBase(key) {
      return getBaseZIndex(key);
    },
    getCurrent: function getCurrent(key) {
      return getCurrentZIndex(key);
    }
  };
}

var ZIndexUtils = handler();

function ownKeys$N(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$N(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$N(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$N(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$2l(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2l(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2l() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var CSSTransition = /*#__PURE__*/function (_Component) {
  _inherits(CSSTransition, _Component);

  var _super = _createSuper$2l(CSSTransition);

  function CSSTransition(props) {
    var _this;

    _classCallCheck(this, CSSTransition);

    _this = _super.call(this, props);
    _this.onEnter = _this.onEnter.bind(_assertThisInitialized(_this));
    _this.onEntering = _this.onEntering.bind(_assertThisInitialized(_this));
    _this.onEntered = _this.onEntered.bind(_assertThisInitialized(_this));
    _this.onExit = _this.onExit.bind(_assertThisInitialized(_this));
    _this.onExiting = _this.onExiting.bind(_assertThisInitialized(_this));
    _this.onExited = _this.onExited.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(CSSTransition, [{
    key: "onEnter",
    value: function onEnter(node, isAppearing) {
      this.props.onEnter && this.props.onEnter(node, isAppearing); // component

      this.props.options && this.props.options.onEnter && this.props.options.onEnter(node, isAppearing); // user option
    }
  }, {
    key: "onEntering",
    value: function onEntering(node, isAppearing) {
      this.props.onEntering && this.props.onEntering(node, isAppearing); // component

      this.props.options && this.props.options.onEntering && this.props.options.onEntering(node, isAppearing); // user option
    }
  }, {
    key: "onEntered",
    value: function onEntered(node, isAppearing) {
      this.props.onEntered && this.props.onEntered(node, isAppearing); // component

      this.props.options && this.props.options.onEntered && this.props.options.onEntered(node, isAppearing); // user option
    }
  }, {
    key: "onExit",
    value: function onExit(node) {
      this.props.onExit && this.props.onExit(node); // component

      this.props.options && this.props.options.onExit && this.props.options.onExit(node); // user option
    }
  }, {
    key: "onExiting",
    value: function onExiting(node) {
      this.props.onExiting && this.props.onExiting(node); // component

      this.props.options && this.props.options.onExiting && this.props.options.onExiting(node); // user option
    }
  }, {
    key: "onExited",
    value: function onExited(node) {
      this.props.onExited && this.props.onExited(node); // component

      this.props.options && this.props.options.onExited && this.props.options.onExited(node); // user option
    }
  }, {
    key: "render",
    value: function render() {
      var immutableProps = {
        nodeRef: this.props.nodeRef,
        in: this.props.in,
        onEnter: this.onEnter,
        onEntering: this.onEntering,
        onEntered: this.onEntered,
        onExit: this.onExit,
        onExiting: this.onExiting,
        onExited: this.onExited
      };
      var mutableProps = {
        classNames: this.props.classNames,
        timeout: this.props.timeout,
        unmountOnExit: this.props.unmountOnExit
      };

      var props = _objectSpread$N(_objectSpread$N(_objectSpread$N({}, mutableProps), this.props.options || {}), immutableProps);

      return /*#__PURE__*/React__default['default'].createElement(reactTransitionGroup.CSSTransition, props, this.props.children);
    }
  }]);

  return CSSTransition;
}(React.Component);

function ownKeys$M(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$M(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$M(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$M(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$2k(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2k(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2k() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var AccordionTab = /*#__PURE__*/function (_Component) {
  _inherits(AccordionTab, _Component);

  var _super = _createSuper$2k(AccordionTab);

  function AccordionTab() {
    _classCallCheck(this, AccordionTab);

    return _super.apply(this, arguments);
  }

  return AccordionTab;
}(React.Component);

_defineProperty(AccordionTab, "defaultProps", {
  header: null,
  disabled: false,
  headerStyle: null,
  headerClassName: null,
  headerTemplate: null,
  contentStyle: null,
  contentClassName: null
});

var Accordion = /*#__PURE__*/function (_Component2) {
  _inherits(Accordion, _Component2);

  var _super2 = _createSuper$2k(Accordion);

  function Accordion(props) {
    var _this;

    _classCallCheck(this, Accordion);

    _this = _super2.call(this, props);
    var state = {
      id: _this.props.id
    };

    if (!_this.props.onTabChange) {
      state = _objectSpread$M(_objectSpread$M({}, state), {}, {
        activeIndex: props.activeIndex
      });
    }

    _this.state = state;
    _this.contentWrappers = [];
    return _this;
  }

  _createClass(Accordion, [{
    key: "onTabHeaderClick",
    value: function onTabHeaderClick(event, tab, index) {
      if (!tab.props.disabled) {
        var selected = this.isSelected(index);
        var newActiveIndex = null;

        if (this.props.multiple) {
          var indexes = (this.props.onTabChange ? this.props.activeIndex : this.state.activeIndex) || [];
          if (selected) indexes = indexes.filter(function (i) {
            return i !== index;
          });else indexes = [].concat(_toConsumableArray(indexes), [index]);
          newActiveIndex = indexes;
        } else {
          newActiveIndex = selected ? null : index;
        }

        var callback = selected ? this.props.onTabClose : this.props.onTabOpen;

        if (callback) {
          callback({
            originalEvent: event,
            index: index
          });
        }

        if (this.props.onTabChange) {
          this.props.onTabChange({
            originalEvent: event,
            index: newActiveIndex
          });
        } else {
          this.setState({
            activeIndex: newActiveIndex
          });
        }
      }

      event.preventDefault();
    }
  }, {
    key: "isSelected",
    value: function isSelected(index) {
      var activeIndex = this.props.onTabChange ? this.props.activeIndex : this.state.activeIndex;
      return this.props.multiple ? activeIndex && activeIndex.indexOf(index) >= 0 : activeIndex === index;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this.state.id) {
        this.setState({
          id: UniqueComponentId()
        });
      }
    }
  }, {
    key: "renderTabHeader",
    value: function renderTabHeader(tab, selected, index) {
      var _classNames,
          _this2 = this;

      var tabHeaderClass = classNames('p-accordion-header', {
        'p-highlight': selected,
        'p-disabled': tab.props.disabled
      }, tab.props.headerClassName);
      var iconClassName = classNames('p-accordion-toggle-icon', (_classNames = {}, _defineProperty(_classNames, "".concat(this.props.expandIcon), !selected), _defineProperty(_classNames, "".concat(this.props.collapseIcon), selected), _classNames));
      var id = this.state.id + '_header_' + index;
      var ariaControls = this.state.id + '_content_' + index;
      var tabIndex = tab.props.disabled ? -1 : null;
      var header = tab.props.headerTemplate ? ObjectUtils.getJSXElement(tab.props.headerTemplate, tab.props) : /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-accordion-header-text"
      }, tab.props.header);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: tabHeaderClass,
        style: tab.props.headerStyle
      }, /*#__PURE__*/React__default['default'].createElement("a", {
        href: '#' + ariaControls,
        id: id,
        className: "p-accordion-header-link",
        "aria-controls": ariaControls,
        role: "tab",
        "aria-expanded": selected,
        onClick: function onClick(event) {
          return _this2.onTabHeaderClick(event, tab, index);
        },
        tabIndex: tabIndex
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), header));
    }
  }, {
    key: "renderTabContent",
    value: function renderTabContent(tab, selected, index) {
      var className = classNames('p-toggleable-content', tab.props.contentClassName);
      var id = this.state.id + '_content_' + index;
      var toggleableContentRef = /*#__PURE__*/React__default['default'].createRef();
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: toggleableContentRef,
        classNames: "p-toggleable-content",
        timeout: {
          enter: 1000,
          exit: 450
        },
        in: selected,
        unmountOnExit: true,
        options: this.props.transitionOptions
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: toggleableContentRef,
        id: id,
        className: className,
        style: tab.props.contentStyle,
        role: "region",
        "aria-labelledby": this.state.id + '_header_' + index
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-accordion-content"
      }, tab.props.children)));
    }
  }, {
    key: "renderTab",
    value: function renderTab(tab, index) {
      var selected = this.isSelected(index);
      var tabHeader = this.renderTabHeader(tab, selected, index);
      var tabContent = this.renderTabContent(tab, selected, index);
      var tabClassName = classNames('p-accordion-tab', {
        'p-accordion-tab-active': selected
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        key: tab.props.header,
        className: tabClassName
      }, tabHeader, tabContent);
    }
  }, {
    key: "renderTabs",
    value: function renderTabs() {
      var _this3 = this;

      return React__default['default'].Children.map(this.props.children, function (tab, index) {
        if (tab && tab.type === AccordionTab) {
          return _this3.renderTab(tab, index);
        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var className = classNames('p-accordion p-component', this.props.className);
      var tabs = this.renderTabs();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this4.container = el;
        },
        id: this.state.id,
        className: className,
        style: this.props.style
      }, tabs);
    }
  }]);

  return Accordion;
}(React.Component);

_defineProperty(Accordion, "defaultProps", {
  id: null,
  activeIndex: null,
  className: null,
  style: null,
  multiple: false,
  expandIcon: 'pi pi-chevron-right',
  collapseIcon: 'pi pi-chevron-down',
  transitionOptions: null,
  onTabOpen: null,
  onTabClose: null,
  onTabChange: null
});

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

var KeyFilter = /*#__PURE__*/function () {
  function KeyFilter() {
    _classCallCheck(this, KeyFilter);
  }

  _createClass(KeyFilter, null, [{
    key: "isNavKeyPress",
    value:
    /* eslint-disable */

    /* eslint-enable */
    function isNavKeyPress(e) {
      var k = e.keyCode;
      k = DomHandler.getBrowser().safari ? KeyFilter.SAFARI_KEYS[k] || k : k;
      return k >= 33 && k <= 40 || k === KeyFilter.KEYS.RETURN || k === KeyFilter.KEYS.TAB || k === KeyFilter.KEYS.ESC;
    }
  }, {
    key: "isSpecialKey",
    value: function isSpecialKey(e) {
      var k = e.keyCode;
      return k === 9 || k === 13 || k === 27 || k === 16 || k === 17 || k >= 18 && k <= 20 || DomHandler.getBrowser().opera && !e.shiftKey && (k === 8 || k >= 33 && k <= 35 || k >= 36 && k <= 39 || k >= 44 && k <= 45);
    }
  }, {
    key: "getKey",
    value: function getKey(e) {
      var k = e.keyCode || e.charCode;
      return DomHandler.getBrowser().safari ? KeyFilter.SAFARI_KEYS[k] || k : k;
    }
  }, {
    key: "getCharCode",
    value: function getCharCode(e) {
      return e.charCode || e.keyCode || e.which;
    }
  }, {
    key: "onKeyPress",
    value: function onKeyPress(e, keyfilter, validateOnly) {
      if (validateOnly) {
        return;
      }

      var regex = KeyFilter.DEFAULT_MASKS[keyfilter] ? KeyFilter.DEFAULT_MASKS[keyfilter] : keyfilter;
      var browser = DomHandler.getBrowser();

      if (e.ctrlKey || e.altKey) {
        return;
      }

      var k = this.getKey(e);

      if (browser.mozilla && (this.isNavKeyPress(e) || k === KeyFilter.KEYS.BACKSPACE || k === KeyFilter.KEYS.DELETE && e.charCode === 0)) {
        return;
      }

      var c = this.getCharCode(e);
      var cc = String.fromCharCode(c);

      if (browser.mozilla && (this.isSpecialKey(e) || !cc)) {
        return;
      }

      if (!regex.test(cc)) {
        e.preventDefault();
      }
    }
  }, {
    key: "validate",
    value: function validate(e, keyfilter) {
      var value = e.target.value,
          validatePattern = true;

      if (value && !keyfilter.test(value)) {
        validatePattern = false;
      }

      return validatePattern;
    }
  }]);

  return KeyFilter;
}();

_defineProperty(KeyFilter, "DEFAULT_MASKS", {
  pint: /[\d]/,
  int: /[\d\-]/,
  pnum: /[\d\.]/,
  money: /[\d\.\s,]/,
  num: /[\d\-\.]/,
  hex: /[0-9a-f]/i,
  email: /[a-z0-9_\.\-@]/i,
  alpha: /[a-z_]/i,
  alphanum: /[a-z0-9_]/i
});

_defineProperty(KeyFilter, "KEYS", {
  TAB: 9,
  RETURN: 13,
  ESC: 27,
  BACKSPACE: 8,
  DELETE: 46
});

_defineProperty(KeyFilter, "SAFARI_KEYS", {
  63234: 37,
  // left
  63235: 39,
  // right
  63232: 38,
  // up
  63233: 40,
  // down
  63276: 33,
  // page up
  63277: 34,
  // page down
  63272: 46,
  // delete
  63273: 36,
  // home
  63275: 35 // end

});

function _createSuper$2j(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2j(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2j() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Portal = /*#__PURE__*/function (_Component) {
  _inherits(Portal, _Component);

  var _super = _createSuper$2j(Portal);

  function Portal(props) {
    var _this;

    _classCallCheck(this, Portal);

    _this = _super.call(this, props);
    _this.state = {
      mounted: props.visible
    };
    return _this;
  }

  _createClass(Portal, [{
    key: "hasDOM",
    value: function hasDOM() {
      return !!(typeof window !== 'undefined' && window.document && window.document.createElement);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.hasDOM() && !this.state.mounted) {
        this.setState({
          mounted: true
        }, this.props.onMounted);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.props.onUnmounted && this.props.onUnmounted();
    }
  }, {
    key: "render",
    value: function render() {
      if (this.props.element && this.state.mounted) {
        var appendTo = this.props.appendTo || PrimeReact.appendTo || document.body;
        return appendTo === 'self' ? this.props.element : /*#__PURE__*/ReactDOM__default['default'].createPortal(this.props.element, appendTo);
      }

      return null;
    }
  }]);

  return Portal;
}(React.Component);

_defineProperty(Portal, "defaultProps", {
  element: null,
  appendTo: null,
  visible: false,
  onMounted: null,
  onUnmounted: null
});

function _createSuper$2i(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2i(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2i() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys$L(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$L(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$L(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$L(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
function tip(props) {
  var appendTo = props.appendTo || document.body;
  var tooltipWrapper = document.createDocumentFragment();
  DomHandler.appendChild(tooltipWrapper, appendTo);
  props = _objectSpread$L(_objectSpread$L({}, props), props.options);
  var tooltipEl = /*#__PURE__*/React__default['default'].createElement(Tooltip, props);
  ReactDOM__default['default'].render(tooltipEl, tooltipWrapper);

  var updateTooltip = function updateTooltip(newProps) {
    props = _objectSpread$L(_objectSpread$L({}, props), newProps);
    ReactDOM__default['default'].render( /*#__PURE__*/React__default['default'].cloneElement(tooltipEl, props), tooltipWrapper);
  };

  return {
    destroy: function destroy() {
      ReactDOM__default['default'].unmountComponentAtNode(tooltipWrapper);
    },
    updateContent: function updateContent(newContent) {
      console.warn("The 'updateContent' method has been deprecated on Tooltip. Use update(newProps) method.");
      updateTooltip({
        content: newContent
      });
    },
    update: function update(newProps) {
      updateTooltip(newProps);
    }
  };
}
var Tooltip = /*#__PURE__*/function (_Component) {
  _inherits(Tooltip, _Component);

  var _super = _createSuper$2i(Tooltip);

  function Tooltip(props) {
    var _this;

    _classCallCheck(this, Tooltip);

    _this = _super.call(this, props);
    _this.state = {
      visible: false,
      position: _this.props.position
    };
    _this.show = _this.show.bind(_assertThisInitialized(_this));
    _this.hide = _this.hide.bind(_assertThisInitialized(_this));
    _this.onMouseEnter = _this.onMouseEnter.bind(_assertThisInitialized(_this));
    _this.onMouseLeave = _this.onMouseLeave.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Tooltip, [{
    key: "isTargetContentEmpty",
    value: function isTargetContentEmpty(target) {
      return !(this.props.content || this.getTargetOption(target, 'tooltip'));
    }
  }, {
    key: "isContentEmpty",
    value: function isContentEmpty(target) {
      return !(this.props.content || this.getTargetOption(target, 'tooltip') || this.props.children);
    }
  }, {
    key: "isMouseTrack",
    value: function isMouseTrack(target) {
      return this.getTargetOption(target, 'mousetrack') || this.props.mouseTrack;
    }
  }, {
    key: "isDisabled",
    value: function isDisabled(target) {
      return this.getTargetOption(target, 'disabled') === 'true' || this.hasTargetOption(target, 'disabled') || this.props.disabled;
    }
  }, {
    key: "isAutoHide",
    value: function isAutoHide() {
      return this.getTargetOption(this.currentTarget, 'autohide') || this.props.autoHide;
    }
  }, {
    key: "getTargetOption",
    value: function getTargetOption(target, option) {
      if (this.hasTargetOption(target, "data-pr-".concat(option))) {
        return target.getAttribute("data-pr-".concat(option));
      }

      return null;
    }
  }, {
    key: "hasTargetOption",
    value: function hasTargetOption(target, option) {
      return target && target.hasAttribute(option);
    }
  }, {
    key: "getEvents",
    value: function getEvents(target) {
      var showEvent = this.getTargetOption(target, 'showevent') || this.props.showEvent;
      var hideEvent = this.getTargetOption(target, 'hideevent') || this.props.hideEvent;

      if (this.isMouseTrack(target)) {
        showEvent = 'mousemove';
        hideEvent = 'mouseleave';
      } else {
        var event = this.getTargetOption(target, 'event') || this.props.event;

        if (event === 'focus') {
          showEvent = 'focus';
          hideEvent = 'blur';
        }
      }

      return {
        showEvent: showEvent,
        hideEvent: hideEvent
      };
    }
  }, {
    key: "getPosition",
    value: function getPosition(target) {
      return this.getTargetOption(target, 'position') || this.state.position;
    }
  }, {
    key: "getMouseTrackPosition",
    value: function getMouseTrackPosition(target) {
      var top = this.getTargetOption(target, 'mousetracktop') || this.props.mouseTrackTop;
      var left = this.getTargetOption(target, 'mousetrackleft') || this.props.mouseTrackLeft;
      return {
        top: top,
        left: left
      };
    }
  }, {
    key: "updateText",
    value: function updateText(target, callback) {
      if (this.tooltipTextEl) {
        var content = this.getTargetOption(target, 'tooltip') || this.props.content;

        if (content) {
          this.tooltipTextEl.innerHTML = ''; // remove children

          this.tooltipTextEl.appendChild(document.createTextNode(content));
          callback();
        } else if (this.props.children) {
          callback();
        }
      }
    }
  }, {
    key: "show",
    value: function show(e) {
      var _this2 = this;

      this.currentTarget = e.currentTarget;

      if (this.isContentEmpty(this.currentTarget) || this.isDisabled(this.currentTarget)) {
        return;
      }

      var updateTooltipState = function updateTooltipState() {
        _this2.updateText(_this2.currentTarget, function () {
          if (_this2.props.autoZIndex && !ZIndexUtils.get(_this2.containerEl)) {
            ZIndexUtils.set('tooltip', _this2.containerEl, _this2.props.baseZIndex);
          }

          _this2.containerEl.style.left = '';
          _this2.containerEl.style.top = '';

          if (_this2.isMouseTrack(_this2.currentTarget) && !_this2.containerSize) {
            _this2.containerSize = {
              width: DomHandler.getOuterWidth(_this2.containerEl),
              height: DomHandler.getOuterHeight(_this2.containerEl)
            };
          }

          _this2.align(_this2.currentTarget, {
            x: e.pageX,
            y: e.pageY
          });
        });
      };

      if (this.state.visible) {
        this.applyDelay('updateDelay', updateTooltipState);
      } else {
        this.sendCallback(this.props.onBeforeShow, {
          originalEvent: e,
          target: this.currentTarget
        });
        this.applyDelay('showDelay', function () {
          _this2.setState({
            visible: true,
            position: _this2.getPosition(_this2.currentTarget)
          }, function () {
            updateTooltipState();

            _this2.sendCallback(_this2.props.onShow, {
              originalEvent: e,
              target: _this2.currentTarget
            });
          });

          _this2.bindDocumentResizeListener();

          _this2.bindScrollListener();

          DomHandler.addClass(_this2.currentTarget, _this2.getTargetOption(_this2.currentTarget, 'classname'));
        });
      }
    }
  }, {
    key: "hide",
    value: function hide(e) {
      var _this3 = this;

      this.clearTimeouts();

      if (this.state.visible) {
        DomHandler.removeClass(this.currentTarget, this.getTargetOption(this.currentTarget, 'classname'));
        this.sendCallback(this.props.onBeforeHide, {
          originalEvent: e,
          target: this.currentTarget
        });
        this.applyDelay('hideDelay', function () {
          ZIndexUtils.clear(_this3.containerEl);
          DomHandler.removeClass(_this3.containerEl, 'p-tooltip-active');

          if (!_this3.isAutoHide() && _this3.allowHide === false) {
            return;
          }

          _this3.setState({
            visible: false,
            position: _this3.props.position
          }, function () {
            if (_this3.tooltipTextEl) {
              ReactDOM__default['default'].unmountComponentAtNode(_this3.tooltipTextEl);
            }

            _this3.unbindDocumentResizeListener();

            _this3.unbindScrollListener();

            _this3.currentTarget = null;
            _this3.scrollHandler = null;
            _this3.containerSize = null;
            _this3.allowHide = true;

            _this3.sendCallback(_this3.props.onHide, {
              originalEvent: e,
              target: _this3.currentTarget
            });
          });
        });
      }
    }
  }, {
    key: "align",
    value: function align(target, coordinate) {
      var _this4 = this;

      var left = 0,
          top = 0;

      if (this.isMouseTrack(target) && coordinate) {
        var containerSize = {
          width: DomHandler.getOuterWidth(this.containerEl),
          height: DomHandler.getOuterHeight(this.containerEl)
        };
        left = coordinate.x;
        top = coordinate.y;

        var _this$getMouseTrackPo = this.getMouseTrackPosition(target),
            mouseTrackTop = _this$getMouseTrackPo.top,
            mouseTrackLeft = _this$getMouseTrackPo.left;

        switch (this.state.position) {
          case 'left':
            left -= containerSize.width + mouseTrackLeft;
            top -= containerSize.height / 2 - mouseTrackTop;
            break;

          case 'right':
            left += mouseTrackLeft;
            top -= containerSize.height / 2 - mouseTrackTop;
            break;

          case 'top':
            left -= containerSize.width / 2 - mouseTrackLeft;
            top -= containerSize.height + mouseTrackTop;
            break;

          case 'bottom':
            left -= containerSize.width / 2 - mouseTrackLeft;
            top += mouseTrackTop;
            break;
        }

        if (left <= 0 || this.containerSize.width > containerSize.width) {
          this.containerEl.style.left = '0px';
          this.containerEl.style.right = window.innerWidth - containerSize.width - left + 'px';
        } else {
          this.containerEl.style.right = '';
          this.containerEl.style.left = left + 'px';
        }

        this.containerEl.style.top = top + 'px';
        DomHandler.addClass(this.containerEl, 'p-tooltip-active');
      } else {
        var pos = DomHandler.findCollisionPosition(this.state.position);
        var my = this.getTargetOption(target, 'my') || this.props.my || pos.my;
        var at = this.getTargetOption(target, 'at') || this.props.at || pos.at;
        this.containerEl.style.padding = '0px';
        DomHandler.flipfitCollision(this.containerEl, target, my, at, function (currentPosition) {
          var _currentPosition$at = currentPosition.at,
              atX = _currentPosition$at.x,
              atY = _currentPosition$at.y;
          var myX = currentPosition.my.x;
          var position = _this4.props.at ? atX !== 'center' && atX !== myX ? atX : atY : currentPosition.at["".concat(pos.axis)];
          _this4.containerEl.style.padding = '';

          _this4.setState({
            position: position
          }, function () {
            _this4.updateContainerPosition();

            DomHandler.addClass(_this4.containerEl, 'p-tooltip-active');
          });
        });
      }
    }
  }, {
    key: "updateContainerPosition",
    value: function updateContainerPosition() {
      if (this.containerEl) {
        var style = getComputedStyle(this.containerEl);
        if (this.state.position === 'left') this.containerEl.style.left = parseFloat(style.left) - parseFloat(style.paddingLeft) * 2 + 'px';else if (this.state.position === 'top') this.containerEl.style.top = parseFloat(style.top) - parseFloat(style.paddingTop) * 2 + 'px';
      }
    }
  }, {
    key: "onMouseEnter",
    value: function onMouseEnter() {
      if (!this.isAutoHide()) {
        this.allowHide = false;
      }
    }
  }, {
    key: "onMouseLeave",
    value: function onMouseLeave(e) {
      if (!this.isAutoHide()) {
        this.allowHide = true;
        this.hide(e);
      }
    }
  }, {
    key: "bindDocumentResizeListener",
    value: function bindDocumentResizeListener() {
      var _this5 = this;

      this.documentResizeListener = function (e) {
        if (!DomHandler.isAndroid()) {
          _this5.hide(e);
        }
      };

      window.addEventListener('resize', this.documentResizeListener);
    }
  }, {
    key: "unbindDocumentResizeListener",
    value: function unbindDocumentResizeListener() {
      if (this.documentResizeListener) {
        window.removeEventListener('resize', this.documentResizeListener);
        this.documentResizeListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this6 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.currentTarget, function (e) {
          if (_this6.state.visible) {
            _this6.hide(e);
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "bindTargetEvent",
    value: function bindTargetEvent(target) {
      if (target) {
        var _this$getEvents = this.getEvents(target),
            showEvent = _this$getEvents.showEvent,
            hideEvent = _this$getEvents.hideEvent;

        target.addEventListener(showEvent, this.show);
        target.addEventListener(hideEvent, this.hide);
      }
    }
  }, {
    key: "unbindTargetEvent",
    value: function unbindTargetEvent(target) {
      if (target) {
        var _this$getEvents2 = this.getEvents(target),
            showEvent = _this$getEvents2.showEvent,
            hideEvent = _this$getEvents2.hideEvent;

        target.removeEventListener(showEvent, this.show);
        target.removeEventListener(hideEvent, this.hide);
      }
    }
  }, {
    key: "applyDelay",
    value: function applyDelay(delayProp, callback) {
      this.clearTimeouts();
      var delay = this.getTargetOption(this.currentTarget, delayProp.toLowerCase()) || this.props[delayProp];

      if (!!delay) {
        this["".concat(delayProp, "Timeout")] = setTimeout(function () {
          return callback();
        }, delay);
      } else {
        callback();
      }
    }
  }, {
    key: "sendCallback",
    value: function sendCallback(callback) {
      if (callback) {
        for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          params[_key - 1] = arguments[_key];
        }

        callback.apply(void 0, params);
      }
    }
  }, {
    key: "clearTimeouts",
    value: function clearTimeouts() {
      clearTimeout(this.showDelayTimeout);
      clearTimeout(this.updateDelayTimeout);
      clearTimeout(this.hideDelayTimeout);
    }
  }, {
    key: "updateTargetEvents",
    value: function updateTargetEvents(target) {
      this.unloadTargetEvents(target);
      this.loadTargetEvents(target);
    }
  }, {
    key: "loadTargetEvents",
    value: function loadTargetEvents(target) {
      this.setTargetEventOperations(target || this.props.target, 'bindTargetEvent');
    }
  }, {
    key: "unloadTargetEvents",
    value: function unloadTargetEvents(target) {
      this.setTargetEventOperations(target || this.props.target, 'unbindTargetEvent');
    }
  }, {
    key: "setTargetEventOperations",
    value: function setTargetEventOperations(target, operation) {
      var _this7 = this;

      if (target) {
        if (DomHandler.isElement(target)) {
          this[operation](target);
        } else {
          var setEvent = function setEvent(target) {
            var element = DomHandler.find(document, target);
            element.forEach(function (el) {
              _this7[operation](el);
            });
          };

          if (target instanceof Array) {
            target.forEach(function (t) {
              setEvent(t);
            });
          } else {
            setEvent(target);
          }
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.target) {
        this.loadTargetEvents();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var _this8 = this;

      if (prevProps.target !== this.props.target) {
        this.unloadTargetEvents(prevProps.target);
        this.loadTargetEvents();
      }

      if (this.state.visible) {
        if (prevProps.content !== this.props.content) {
          this.applyDelay('updateDelay', function () {
            _this8.updateText(_this8.currentTarget, function () {
              _this8.align(_this8.currentTarget);
            });
          });
        }

        if (this.currentTarget && this.isDisabled(this.currentTarget)) {
          this.hide();
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.clearTimeouts();
      this.unbindDocumentResizeListener();
      this.unloadTargetEvents();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      ZIndexUtils.clear(this.containerEl);
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var _this9 = this;

      var tooltipClassName = classNames('p-tooltip p-component', _defineProperty({}, "p-tooltip-".concat(this.state.position), true), this.props.className);
      var isTargetContentEmpty = this.isTargetContentEmpty(this.currentTarget);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        ref: function ref(el) {
          return _this9.containerEl = el;
        },
        className: tooltipClassName,
        style: this.props.style,
        role: "tooltip",
        "aria-hidden": this.state.visible,
        onMouseEnter: this.onMouseEnter,
        onMouseLeave: this.onMouseLeave
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-tooltip-arrow"
      }), /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this9.tooltipTextEl = el;
        },
        className: "p-tooltip-text"
      }, isTargetContentEmpty && this.props.children));
    }
  }, {
    key: "render",
    value: function render() {
      if (this.state.visible) {
        var element = this.renderElement();
        return /*#__PURE__*/React__default['default'].createElement(Portal, {
          element: element,
          appendTo: this.props.appendTo,
          visible: true
        });
      }

      return null;
    }
  }]);

  return Tooltip;
}(React.Component);

_defineProperty(Tooltip, "defaultProps", {
  id: null,
  target: null,
  content: null,
  disabled: false,
  className: null,
  style: null,
  appendTo: null,
  position: 'right',
  my: null,
  at: null,
  event: null,
  showEvent: 'mouseenter',
  hideEvent: 'mouseleave',
  autoZIndex: true,
  baseZIndex: 0,
  mouseTrack: false,
  mouseTrackTop: 5,
  mouseTrackLeft: 5,
  showDelay: 0,
  updateDelay: 0,
  hideDelay: 0,
  autoHide: true,
  onBeforeShow: null,
  onBeforeHide: null,
  onShow: null,
  onHide: null
});

function ownKeys$K(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$K(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$K(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$K(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$2h(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2h(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2h() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var InputTextComponent = /*#__PURE__*/function (_Component) {
  _inherits(InputTextComponent, _Component);

  var _super = _createSuper$2h(InputTextComponent);

  function InputTextComponent(props) {
    var _this;

    _classCallCheck(this, InputTextComponent);

    _this = _super.call(this, props);
    _this.onInput = _this.onInput.bind(_assertThisInitialized(_this));
    _this.onKeyPress = _this.onKeyPress.bind(_assertThisInitialized(_this));
    _this.elementRef = /*#__PURE__*/React.createRef(_this.props.forwardRef);
    return _this;
  }

  _createClass(InputTextComponent, [{
    key: "isFilled",
    value: function isFilled() {
      return this.props.value != null && this.props.value.toString().length > 0 || this.props.defaultValue != null && this.props.defaultValue.toString().length > 0 || this.elementRef && this.elementRef.current && this.elementRef.current.value != null && this.elementRef.current.value.toString().length > 0;
    }
  }, {
    key: "onKeyPress",
    value: function onKeyPress(event) {
      if (this.props.onKeyPress) {
        this.props.onKeyPress(event);
      }

      if (this.props.keyfilter) {
        KeyFilter.onKeyPress(event, this.props.keyfilter, this.props.validateOnly);
      }
    }
  }, {
    key: "onInput",
    value: function onInput(event) {
      var validatePattern = true;

      if (this.props.keyfilter && this.props.validateOnly) {
        validatePattern = KeyFilter.validate(event, this.props.keyfilter);
      }

      if (this.props.onInput) {
        this.props.onInput(event, validatePattern);
      }

      if (!this.props.onChange) {
        if (event.target.value.length > 0) DomHandler.addClass(event.target, 'p-filled');else DomHandler.removeClass(event.target, 'p-filled');
      }
    }
  }, {
    key: "updateForwardRef",
    value: function updateForwardRef() {
      var ref = this.props.forwardRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.elementRef.current);
        } else {
          ref.current = this.elementRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateForwardRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$K({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.elementRef.current,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-inputtext p-component', {
        'p-disabled': this.props.disabled,
        'p-filled': this.isFilled()
      }, this.props.className);
      var inputProps = ObjectUtils.findDiffKeys(this.props, InputTextComponent.defaultProps);
      return /*#__PURE__*/React__default['default'].createElement("input", _extends({
        ref: this.elementRef
      }, inputProps, {
        className: className,
        onInput: this.onInput,
        onKeyPress: this.onKeyPress
      }));
    }
  }]);

  return InputTextComponent;
}(React.Component);

_defineProperty(InputTextComponent, "defaultProps", {
  keyfilter: null,
  validateOnly: false,
  tooltip: null,
  tooltipOptions: null,
  onInput: null,
  onKeyPress: null,
  forwardRef: null
});

var InputText = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(InputTextComponent, _extends({
    forwardRef: ref
  }, props));
});

function _createSuper$2g(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2g(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2g() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Ripple = /*#__PURE__*/function (_Component) {
  _inherits(Ripple, _Component);

  var _super = _createSuper$2g(Ripple);

  function Ripple(props) {
    var _this;

    _classCallCheck(this, Ripple);

    _this = _super.call(this, props);
    _this.onMouseDown = _this.onMouseDown.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Ripple, [{
    key: "getTarget",
    value: function getTarget() {
      return this.ink && this.ink.parentElement;
    }
  }, {
    key: "bindEvents",
    value: function bindEvents() {
      if (this.target) {
        this.target.addEventListener('mousedown', this.onMouseDown);
      }
    }
  }, {
    key: "unbindEvents",
    value: function unbindEvents() {
      if (this.target) {
        this.target.removeEventListener('mousedown', this.onMouseDown);
      }
    }
  }, {
    key: "onMouseDown",
    value: function onMouseDown(event) {
      if (!this.ink || getComputedStyle(this.ink, null).display === 'none') {
        return;
      }

      DomHandler.removeClass(this.ink, 'p-ink-active');

      if (!DomHandler.getHeight(this.ink) && !DomHandler.getWidth(this.ink)) {
        var d = Math.max(DomHandler.getOuterWidth(this.target), DomHandler.getOuterHeight(this.target));
        this.ink.style.height = d + 'px';
        this.ink.style.width = d + 'px';
      }

      var offset = DomHandler.getOffset(this.target);
      var x = event.pageX - offset.left + document.body.scrollTop - DomHandler.getWidth(this.ink) / 2;
      var y = event.pageY - offset.top + document.body.scrollLeft - DomHandler.getHeight(this.ink) / 2;
      this.ink.style.top = y + 'px';
      this.ink.style.left = x + 'px';
      DomHandler.addClass(this.ink, 'p-ink-active');
    }
  }, {
    key: "onAnimationEnd",
    value: function onAnimationEnd(event) {
      DomHandler.removeClass(event.currentTarget, 'p-ink-active');
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.ink) {
        this.target = this.getTarget();
        this.bindEvents();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.ink && !this.target) {
        this.target = this.getTarget();
        this.bindEvents();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.ink) {
        this.target = null;
        this.unbindEvents();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      return PrimeReact.ripple && /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          return _this2.ink = el;
        },
        className: "p-ink",
        onAnimationEnd: this.onAnimationEnd
      });
    }
  }]);

  return Ripple;
}(React.Component);

function ownKeys$J(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$J(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$J(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$J(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$2f(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2f(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2f() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ButtonComponent = /*#__PURE__*/function (_Component) {
  _inherits(ButtonComponent, _Component);

  var _super = _createSuper$2f(ButtonComponent);

  function ButtonComponent(props) {
    var _this;

    _classCallCheck(this, ButtonComponent);

    _this = _super.call(this, props);
    _this.elementRef = /*#__PURE__*/React.createRef(_this.props.forwardRef);
    return _this;
  }

  _createClass(ButtonComponent, [{
    key: "updateForwardRef",
    value: function updateForwardRef() {
      var ref = this.props.forwardRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.elementRef.current);
        } else {
          ref.current = this.elementRef.current;
        }
      }
    }
  }, {
    key: "isDisabled",
    value: function isDisabled() {
      return this.props.disabled || this.props.loading;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateForwardRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$J({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.elementRef.current,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "renderIcon",
    value: function renderIcon() {
      var icon = this.props.loading ? this.props.loadingIcon : this.props.icon;
      var content = null;

      if (icon) {
        var _classNames;

        var iconType = _typeof(icon);

        var className = classNames('p-button-icon p-c', (_classNames = {
          'p-button-loading-icon': this.props.loading
        }, _defineProperty(_classNames, "".concat(icon), iconType === 'string'), _defineProperty(_classNames, 'p-button-icon-left', this.props.iconPos === 'left' && this.props.label), _defineProperty(_classNames, 'p-button-icon-right', this.props.iconPos === 'right' && this.props.label), _defineProperty(_classNames, 'p-button-icon-top', this.props.iconPos === 'top' && this.props.label), _defineProperty(_classNames, 'p-button-icon-bottom', this.props.iconPos === 'bottom' && this.props.label), _classNames));
        content = /*#__PURE__*/React__default['default'].createElement("span", {
          className: className
        });

        if (iconType !== 'string') {
          var defaultContentOptions = {
            className: className,
            element: content,
            props: this.props
          };
          content = ObjectUtils.getJSXElement(icon, defaultContentOptions);
        }
      }

      return content;
    }
  }, {
    key: "renderLabel",
    value: function renderLabel() {
      if (this.props.label) {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-button-label p-c"
        }, this.props.label);
      }

      return !this.props.children && !this.props.label && /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-button-label p-c",
        dangerouslySetInnerHTML: {
          __html: "&nbsp;"
        }
      });
    }
  }, {
    key: "renderBadge",
    value: function renderBadge() {
      if (this.props.badge) {
        var badgeClassName = classNames('p-badge', this.props.badgeClassName);
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: badgeClassName
        }, this.props.badge);
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var disabled = this.isDisabled();
      var className = classNames('p-button p-component', this.props.className, _defineProperty({
        'p-button-icon-only': (this.props.icon || this.props.loading && this.props.loadingIcon) && !this.props.label,
        'p-button-vertical': (this.props.iconPos === 'top' || this.props.iconPos === 'bottom') && this.props.label,
        'p-disabled': disabled,
        'p-button-loading': this.props.loading,
        'p-button-loading-label-only': this.props.loading && !this.props.icon && this.props.label
      }, "p-button-loading-".concat(this.props.iconPos), this.props.loading && this.props.loadingIcon && this.props.label));
      var icon = this.renderIcon();
      var label = this.renderLabel();
      var badge = this.renderBadge();
      var buttonProps = ObjectUtils.findDiffKeys(this.props, ButtonComponent.defaultProps);
      return /*#__PURE__*/React__default['default'].createElement("button", _extends({
        ref: this.elementRef
      }, buttonProps, {
        className: className,
        disabled: disabled
      }), icon, label, this.props.children, badge, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }]);

  return ButtonComponent;
}(React.Component);

_defineProperty(ButtonComponent, "defaultProps", {
  label: null,
  icon: null,
  iconPos: 'left',
  badge: null,
  badgeClassName: null,
  tooltip: null,
  tooltipOptions: null,
  forwardRef: null,
  disabled: false,
  loading: false,
  loadingIcon: 'pi pi-spinner pi-spin'
});

var Button = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(ButtonComponent, _extends({
    forwardRef: ref
  }, props));
});

function ownKeys$I(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$I(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$I(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$I(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$2e(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2e(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2e() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var VirtualScroller = /*#__PURE__*/function (_Component) {
  _inherits(VirtualScroller, _Component);

  var _super = _createSuper$2e(VirtualScroller);

  function VirtualScroller(props) {
    var _this;

    _classCallCheck(this, VirtualScroller);

    _this = _super.call(this, props);

    var isBoth = _this.isBoth();

    _this.state = {
      first: isBoth ? {
        rows: 0,
        cols: 0
      } : 0,
      last: isBoth ? {
        rows: 0,
        cols: 0
      } : 0,
      numItemsInViewport: isBoth ? {
        rows: 0,
        cols: 0
      } : 0,
      numToleratedItems: props.numToleratedItems,
      loading: false
    };
    _this.onScroll = _this.onScroll.bind(_assertThisInitialized(_this));
    _this.lastScrollPos = isBoth ? {
      top: 0,
      left: 0
    } : 0;
    return _this;
  }

  _createClass(VirtualScroller, [{
    key: "scrollTo",
    value: function scrollTo(options) {
      this.element && this.element.scrollTo(options);
    }
  }, {
    key: "scrollToIndex",
    value: function scrollToIndex(index) {
      var _this2 = this;

      var behavior = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'auto';
      var isBoth = this.isBoth();
      var isHorizontal = this.isHorizontal();
      var first = this.state.first;
      var itemSize = this.props.itemSize;
      var contentPadding = this.getContentPadding();

      var calculateFirst = function calculateFirst() {
        var _index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

        return _index <= _this2.state.numToleratedItems ? 0 : _index;
      };

      var calculateCoord = function calculateCoord(_first, _size, _padding) {
        return _first * _size + _padding;
      };

      var scrollTo = function scrollTo() {
        var left = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        return _this2.scrollTo({
          left: left,
          top: top,
          behavior: behavior
        });
      };

      if (isBoth) {
        var newFirst = {
          rows: calculateFirst(index[0]),
          cols: calculateFirst(index[1])
        };
        (newFirst.rows !== first.rows || newFirst.cols !== first.cols) && scrollTo(calculateCoord(newFirst.cols, itemSize[1], contentPadding.left), calculateCoord(newFirst.rows, itemSize[0], contentPadding.top));
      } else {
        var _newFirst = calculateFirst(index);

        if (_newFirst !== first) {
          isHorizontal ? scrollTo(calculateCoord(_newFirst, itemSize, contentPadding.left), 0) : scrollTo(0, calculateCoord(_newFirst, itemSize, contentPadding.top));
        }
      }
    }
  }, {
    key: "scrollInView",
    value: function scrollInView(index, to) {
      var _this3 = this;

      var behavior = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'auto';

      if (to) {
        var isBoth = this.isBoth();
        var isHorizontal = this.isHorizontal();

        var _this$getRenderedRang = this.getRenderedRange(),
            first = _this$getRenderedRang.first,
            viewport = _this$getRenderedRang.viewport;

        var itemSize = this.props.itemSize;

        var scrollTo = function scrollTo() {
          var left = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
          var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          return _this3.scrollTo({
            left: left,
            top: top,
            behavior: behavior
          });
        };

        var isToStart = to === 'to-start';
        var isToEnd = to === 'to-end';

        if (isToStart) {
          if (isBoth) {
            if (viewport.first.rows - first.rows > index[0]) {
              scrollTo(viewport.first.cols * itemSize, (viewport.first.rows - 1) * itemSize);
            } else if (viewport.first.cols - first.cols > index[1]) {
              scrollTo((viewport.first.cols - 1) * itemSize, viewport.first.rows * itemSize);
            }
          } else {
            if (viewport.first - first > index) {
              var pos = (viewport.first - 1) * itemSize;
              isHorizontal ? scrollTo(pos, 0) : scrollTo(0, pos);
            }
          }
        } else if (isToEnd) {
          if (isBoth) {
            if (viewport.last.rows - first.rows <= index[0] + 1) {
              scrollTo(viewport.first.cols * itemSize, (viewport.first.rows + 1) * itemSize);
            } else if (viewport.last.cols - first.cols <= index[1] + 1) {
              scrollTo((viewport.first.cols + 1) * itemSize, viewport.first.rows * itemSize);
            }
          } else {
            if (viewport.last - first <= index + 1) {
              var _pos2 = (viewport.first + 1) * itemSize;

              isHorizontal ? scrollTo(_pos2, 0) : scrollTo(0, _pos2);
            }
          }
        }
      } else {
        this.scrollToIndex(index, behavior);
      }
    }
  }, {
    key: "getRenderedRange",
    value: function getRenderedRange() {
      var isBoth = this.isBoth();
      var isHorizontal = this.isHorizontal();
      var _this$state = this.state,
          first = _this$state.first,
          last = _this$state.last,
          numItemsInViewport = _this$state.numItemsInViewport;
      var itemSize = this.props.itemSize;

      var calculateFirstInViewport = function calculateFirstInViewport(_pos, _size) {
        return Math.floor(_pos / (_size || _pos));
      };

      var firstInViewport = first;
      var lastInViewport = 0;

      if (this.element) {
        var scrollTop = this.element.scrollTop;
        var scrollLeft = this.element.scrollLeft;

        if (isBoth) {
          firstInViewport = {
            rows: calculateFirstInViewport(scrollTop, itemSize[0]),
            cols: calculateFirstInViewport(scrollLeft, itemSize[1])
          };
          lastInViewport = {
            rows: firstInViewport.rows + numItemsInViewport.rows,
            cols: firstInViewport.cols + numItemsInViewport.cols
          };
        } else {
          var scrollPos = isHorizontal ? scrollLeft : scrollTop;
          firstInViewport = calculateFirstInViewport(scrollPos, itemSize);
          lastInViewport = firstInViewport + numItemsInViewport;
        }
      }

      return {
        first: first,
        last: last,
        viewport: {
          first: firstInViewport,
          last: lastInViewport
        }
      };
    }
  }, {
    key: "isHorizontal",
    value: function isHorizontal() {
      return this.props.orientation === 'horizontal';
    }
  }, {
    key: "isBoth",
    value: function isBoth() {
      return this.props.orientation === 'both';
    }
  }, {
    key: "calculateOptions",
    value: function calculateOptions() {
      var _this4 = this;

      var isBoth = this.isBoth();
      var isHorizontal = this.isHorizontal();
      var first = this.state.first;
      var itemSize = this.props.itemSize;
      var contentPadding = this.getContentPadding();
      var contentWidth = this.element ? this.element.offsetWidth - contentPadding.left : 0;
      var contentHeight = this.element ? this.element.offsetHeight - contentPadding.top : 0;

      var calculateNumItemsInViewport = function calculateNumItemsInViewport(_contentSize, _itemSize) {
        return Math.ceil(_contentSize / (_itemSize || _contentSize));
      };

      var numItemsInViewport = isBoth ? {
        rows: calculateNumItemsInViewport(contentHeight, itemSize[0]),
        cols: calculateNumItemsInViewport(contentWidth, itemSize[1])
      } : calculateNumItemsInViewport(isHorizontal ? contentWidth : contentHeight, itemSize);
      var numToleratedItems = this.state.numToleratedItems || Math.ceil((isBoth ? numItemsInViewport.rows : numItemsInViewport) / 2);

      var calculateLast = function calculateLast(_first, _num, _isCols) {
        return _this4.getLast(_first + _num + (_first < numToleratedItems ? 2 : 3) * numToleratedItems, _isCols);
      };

      var last = isBoth ? {
        rows: calculateLast(first.rows, numItemsInViewport.rows),
        cols: calculateLast(first.cols, numItemsInViewport.cols, true)
      } : calculateLast(first, numItemsInViewport);
      var state = {
        numItemsInViewport: numItemsInViewport,
        last: last,
        numToleratedItems: numToleratedItems
      };

      if (this.props.showLoader) {
        state['loaderArr'] = Array.from({
          length: isBoth ? numItemsInViewport.rows : numItemsInViewport
        });
      }

      this.setState(state, function () {
        if (_this4.props.lazy) {
          _this4.props.onLazyLoad && _this4.props.onLazyLoad({
            first: _this4.state.first,
            last: _this4.state.last
          });
        }
      });
    }
  }, {
    key: "getLast",
    value: function getLast(last, isCols) {
      return this.props.items ? Math.min(isCols ? this.props.items[0].length : this.props.items.length, last) : 0;
    }
  }, {
    key: "getContentPadding",
    value: function getContentPadding() {
      if (this.content) {
        var style = getComputedStyle(this.content);
        var left = parseInt(style.paddingLeft, 10);
        var right = parseInt(style.paddingRight, 10);
        var top = parseInt(style.paddingTop, 10);
        var bottom = parseInt(style.paddingBottom, 10);
        return {
          left: left,
          right: right,
          top: top,
          bottom: bottom,
          x: left + right,
          y: top + bottom
        };
      }

      return {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0,
        x: 0,
        y: 0
      };
    }
  }, {
    key: "setSize",
    value: function setSize() {
      var _this5 = this;

      if (this.element) {
        var isBoth = this.isBoth();
        var isHorizontal = this.isHorizontal();
        var parentElement = this.element.parentElement;
        var width = this.props.scrollWidth || "".concat(this.element.offsetWidth || parentElement.offsetWidth, "px");
        var height = this.props.scrollHeight || "".concat(this.element.offsetHeight || parentElement.offsetHeight, "px");

        var setProp = function setProp(_name, _value) {
          return _this5.element.style[_name] = _value;
        };

        if (isBoth) {
          setProp('height', height);
          setProp('width', width);
        } else {
          isHorizontal ? setProp('width', width) : setProp('height', height);
        }
      }
    }
  }, {
    key: "setSpacerSize",
    value: function setSpacerSize() {
      var _this6 = this;

      var items = this.props.items;

      if (this.spacer && items) {
        var isBoth = this.isBoth();
        var isHorizontal = this.isHorizontal();
        var itemSize = this.props.itemSize;
        var contentPadding = this.getContentPadding();

        var setProp = function setProp(_name, _value, _size) {
          var _padding = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

          return _this6.spacer.style[_name] = (_value || []).length * _size + _padding + 'px';
        };

        if (isBoth) {
          setProp('height', items[0], itemSize[0], contentPadding.y);
          setProp('width', items[1], itemSize[1], contentPadding.x);
        } else {
          isHorizontal ? setProp('width', items, itemSize, contentPadding.x) : setProp('height', items, itemSize, contentPadding.y);
        }
      }
    }
  }, {
    key: "setContentPosition",
    value: function setContentPosition(pos) {
      var _this7 = this;

      if (this.content) {
        var isBoth = this.isBoth();
        var isHorizontal = this.isHorizontal();
        var first = pos ? pos.first : this.state.first;
        var itemSize = this.props.itemSize;

        var calculateTranslateVal = function calculateTranslateVal(_first, _size) {
          return _first * _size;
        };

        var setTransform = function setTransform() {
          var _x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

          var _y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

          return _this7.content.style.transform = "translate3d(".concat(_x, "px, ").concat(_y, "px, 0)");
        };

        if (isBoth) {
          setTransform(calculateTranslateVal(first.cols, itemSize[1]), calculateTranslateVal(first.rows, itemSize[0]));
        } else {
          var translateVal = calculateTranslateVal(first, itemSize);
          isHorizontal ? setTransform(translateVal, 0) : setTransform(0, translateVal);
        }
      }
    }
  }, {
    key: "onScrollPositionChange",
    value: function onScrollPositionChange(event) {
      var _this8 = this;

      var target = event.target;
      var isBoth = this.isBoth();
      var isHorizontal = this.isHorizontal();
      var _this$state2 = this.state,
          first = _this$state2.first,
          last = _this$state2.last,
          numItemsInViewport = _this$state2.numItemsInViewport,
          numToleratedItems = _this$state2.numToleratedItems;
      var itemSize = this.props.itemSize;
      var contentPadding = this.getContentPadding();

      var calculateScrollPos = function calculateScrollPos(_pos, _padding) {
        return _pos ? _pos > _padding ? _pos - _padding : _pos : 0;
      };

      var calculateCurrentIndex = function calculateCurrentIndex(_pos, _size) {
        return Math.floor(_pos / (_size || _pos));
      };

      var calculateTriggerIndex = function calculateTriggerIndex(_currentIndex, _first, _last, _num, _isScrollDownOrRight) {
        return _currentIndex <= numToleratedItems ? numToleratedItems : _isScrollDownOrRight ? _last - _num - numToleratedItems : _first + numToleratedItems - 1;
      };

      var calculateFirst = function calculateFirst(_currentIndex, _triggerIndex, _first, _last, _num, _isScrollDownOrRight) {
        if (_currentIndex <= numToleratedItems) return 0;else return _isScrollDownOrRight ? _currentIndex < _triggerIndex ? _first : _currentIndex - numToleratedItems : _currentIndex > _triggerIndex ? _first : _currentIndex - 2 * numToleratedItems;
      };

      var calculateLast = function calculateLast(_currentIndex, _first, _last, _num, _isCols) {
        var lastValue = _first + _num + 2 * numToleratedItems;

        if (_currentIndex >= numToleratedItems) {
          lastValue += numToleratedItems + 1;
        }

        return _this8.getLast(lastValue, _isCols);
      };

      var scrollTop = calculateScrollPos(target.scrollTop, contentPadding.top);
      var scrollLeft = calculateScrollPos(target.scrollLeft, contentPadding.left);
      var newFirst = 0;
      var newLast = last;
      var isRangeChanged = false;

      if (isBoth) {
        var isScrollDown = this.lastScrollPos.top <= scrollTop;
        var isScrollRight = this.lastScrollPos.left <= scrollLeft;
        var currentIndex = {
          rows: calculateCurrentIndex(scrollTop, itemSize[0]),
          cols: calculateCurrentIndex(scrollLeft, itemSize[1])
        };
        var triggerIndex = {
          rows: calculateTriggerIndex(currentIndex.rows, first.rows, last.rows, numItemsInViewport.rows, isScrollDown),
          cols: calculateTriggerIndex(currentIndex.cols, first.cols, last.cols, numItemsInViewport.cols, isScrollRight)
        };
        newFirst = {
          rows: calculateFirst(currentIndex.rows, triggerIndex.rows, first.rows, last.rows, numItemsInViewport.rows, isScrollDown),
          cols: calculateFirst(currentIndex.cols, triggerIndex.cols, first.cols, last.cols, numItemsInViewport.cols, isScrollRight)
        };
        newLast = {
          rows: calculateLast(currentIndex.rows, newFirst.rows, last.rows, numItemsInViewport.rows),
          cols: calculateLast(currentIndex.cols, newFirst.cols, last.cols, numItemsInViewport.cols, true)
        };
        isRangeChanged = newFirst.rows !== first.rows || newFirst.cols !== first.cols || newLast.rows !== last.rows || newLast.cols !== last.cols;
        this.lastScrollPos = {
          top: scrollTop,
          left: scrollLeft
        };
      } else {
        var scrollPos = isHorizontal ? scrollLeft : scrollTop;
        var isScrollDownOrRight = this.lastScrollPos <= scrollPos;

        var _currentIndex2 = calculateCurrentIndex(scrollPos, itemSize);

        var _triggerIndex2 = calculateTriggerIndex(_currentIndex2, first, last, numItemsInViewport, isScrollDownOrRight);

        newFirst = calculateFirst(_currentIndex2, _triggerIndex2, first, last, numItemsInViewport, isScrollDownOrRight);
        newLast = calculateLast(_currentIndex2, newFirst, last, numItemsInViewport);
        isRangeChanged = newFirst !== first || newLast !== last;
        this.lastScrollPos = scrollPos;
      }

      return {
        first: newFirst,
        last: newLast,
        isRangeChanged: isRangeChanged
      };
    }
  }, {
    key: "onScrollChange",
    value: function onScrollChange(event) {
      var _this9 = this;

      var _this$onScrollPositio = this.onScrollPositionChange(event),
          first = _this$onScrollPositio.first,
          last = _this$onScrollPositio.last,
          isRangeChanged = _this$onScrollPositio.isRangeChanged;

      if (isRangeChanged) {
        var newState = {
          first: first,
          last: last
        };
        this.setContentPosition(newState);

        if (this.props.lazy) {
          this.props.onLazyLoad && this.props.onLazyLoad(newState);
        }

        this.setState(newState, function () {
          _this9.props.onScrollIndexChange && _this9.props.onScrollIndexChange(newState);
        });
      }
    }
  }, {
    key: "onScroll",
    value: function onScroll(event) {
      var _this10 = this;

      this.props.onScroll && this.props.onScroll(event);

      if (this.props.delay) {
        if (this.scrollTimeout) {
          clearTimeout(this.scrollTimeout);
        }

        if (!this.state.loading && this.props.showLoader) {
          var _this$onScrollPositio2 = this.onScrollPositionChange(event),
              changed = _this$onScrollPositio2.isRangeChanged;

          changed && this.setState({
            loading: true
          });
        }

        this.scrollTimeout = setTimeout(function () {
          _this10.onScrollChange(event);

          if (_this10.state.loading && _this10.props.showLoader && !_this10.props.lazy) {
            _this10.setState({
              loading: false
            });
          }
        }, this.props.delay);
      } else {
        this.onScrollChange(event);
      }
    }
  }, {
    key: "getOptions",
    value: function getOptions(index, count) {
      return {
        index: index,
        count: count,
        first: index === 0,
        last: index === count - 1,
        even: index % 2 === 0,
        odd: index % 2 !== 0,
        props: this.props
      };
    }
  }, {
    key: "init",
    value: function init() {
      this.setSize();
      this.calculateOptions();
      this.setSpacerSize();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.init();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevProps.itemSize !== this.props.itemSize || !prevProps.items || prevProps.items.length !== (this.props.items || []).length) {
        this.init();
      }

      if (this.props.lazy && prevProps.loading !== this.props.loading && this.state.loading !== this.props.loading) {
        this.setState({
          loading: this.props.loading
        });
      }

      if (prevProps.orientation !== this.props.orientation) {
        this.lastScrollPos = this.isBoth() ? {
          top: 0,
          left: 0
        } : 0;
      }
    }
  }, {
    key: "renderItem",
    value: function renderItem(item, index, count, passedItem) {
      var options = this.getOptions(index, count);
      var content = ObjectUtils.getJSXElement(this.props.itemTemplate, passedItem || item, options);
      return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, {
        key: index
      }, content);
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this11 = this;

      var items = this.props.items;

      if (items && !this.state.loading) {
        var isBoth = this.isBoth();
        var _this$state3 = this.state,
            first = _this$state3.first,
            last = _this$state3.last;
        var count = items.length;

        if (isBoth) {
          return items.slice(first.rows, last.rows).map(function (item, i) {
            var items = item.slice(first.cols, last.cols);
            var index = first.rows + i;
            return _this11.renderItem(item, index, count, items);
          });
        } else {
          return items.slice(first, last).map(function (item, i) {
            var index = first + i;
            return _this11.renderItem(item, index, count);
          });
        }
      }

      return null;
    }
  }, {
    key: "renderLoaderItem",
    value: function renderLoaderItem(index, count, extOptions) {
      var options = _objectSpread$I(_objectSpread$I({}, this.getOptions(index, count)), extOptions || {});

      var content = ObjectUtils.getJSXElement(this.props.loadingTemplate, options);
      return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, {
        key: index
      }, content);
    }
  }, {
    key: "renderLoader",
    value: function renderLoader() {
      var _this12 = this;

      if (this.state.loading) {
        var className = classNames('p-virtualscroller-loader', {
          'p-component-overlay': !this.props.loadingTemplate
        });
        var content = /*#__PURE__*/React__default['default'].createElement("i", {
          className: "p-virtualscroller-loading-icon pi pi-spinner pi-spin"
        });

        if (this.props.loadingTemplate) {
          var isBoth = this.isBoth();
          var numItemsInViewport = this.state.numItemsInViewport;
          var length = isBoth ? numItemsInViewport.rows : numItemsInViewport;
          content = this.state.loaderArr.map(function (_, index) {
            return _this12.renderLoaderItem(index, length, isBoth && {
              numCols: numItemsInViewport.cols
            });
          });
        }

        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: className
        }, content);
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this13 = this;

      var items = this.renderItems();
      var content = /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-virtualscroller-content",
        ref: function ref(el) {
          return _this13.content = el;
        }
      }, items);

      if (this.props.contentTemplate) {
        var _this$state4 = this.state,
            loading = _this$state4.loading,
            first = _this$state4.first,
            last = _this$state4.last;
        var defaultOptions = {
          className: 'p-virtualscroller-content',
          ref: function ref(el) {
            return _this13.content = el;
          },
          children: items,
          element: content,
          props: this.props,
          loading: loading,
          first: first,
          last: last
        };
        return ObjectUtils.getJSXElement(this.props.contentTemplate, defaultOptions);
      }

      return content;
    }
  }, {
    key: "render",
    value: function render() {
      var _this14 = this;

      var isBoth = this.isBoth();
      var isHorizontal = this.isHorizontal();
      var className = classNames('p-virtualscroller', {
        'p-both-scroll': isBoth,
        'p-horizontal-scroll': isHorizontal
      }, this.props.className);
      var loader = this.renderLoader();
      var content = this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this14.element = el;
        },
        className: className,
        tabIndex: 0,
        style: this.props.style,
        onScroll: this.onScroll
      }, content, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this14.spacer = el;
        },
        className: "p-virtualscroller-spacer"
      }), loader);
    }
  }]);

  return VirtualScroller;
}(React.Component);

_defineProperty(VirtualScroller, "defaultProps", {
  id: null,
  style: null,
  className: null,
  items: null,
  itemSize: 0,
  scrollHeight: null,
  scrollWidth: null,
  orientation: 'vertical',
  numToleratedItems: null,
  delay: 0,
  lazy: false,
  showLoader: false,
  loadingTemplate: null,
  itemTemplate: null,
  contentTemplate: null,
  onScroll: null,
  onScrollIndexChange: null,
  onLazyLoad: null
});

function ownKeys$H(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$H(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$H(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$H(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$2d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2d(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2d() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var AutoCompletePanelComponent = /*#__PURE__*/function (_Component) {
  _inherits(AutoCompletePanelComponent, _Component);

  var _super = _createSuper$2d(AutoCompletePanelComponent);

  function AutoCompletePanelComponent() {
    _classCallCheck(this, AutoCompletePanelComponent);

    return _super.apply(this, arguments);
  }

  _createClass(AutoCompletePanelComponent, [{
    key: "getOptionGroupRenderKey",
    value: function getOptionGroupRenderKey(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupLabel);
    }
  }, {
    key: "renderGroupChildren",
    value: function renderGroupChildren(optionGroup, i) {
      var _this = this;

      var groupChildren = this.props.getOptionGroupChildren(optionGroup);
      return groupChildren.map(function (item, j) {
        var itemContent = _this.props.itemTemplate ? ObjectUtils.getJSXElement(_this.props.itemTemplate, item, j) : _this.props.field ? ObjectUtils.resolveFieldData(item, _this.props.field) : item;
        return /*#__PURE__*/React__default['default'].createElement("li", {
          key: j + '_item',
          role: "option",
          "aria-selected": _this.props.ariaSelected === item,
          className: "p-autocomplete-item",
          onClick: function onClick(e) {
            return _this.props.onItemClick(e, item);
          },
          "data-group": i,
          "data-index": j
        }, itemContent, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      });
    }
  }, {
    key: "renderItem",
    value: function renderItem(suggestion, index) {
      var _this2 = this;

      if (this.props.optionGroupLabel) {
        var groupContent = this.props.optionGroupTemplate ? ObjectUtils.getJSXElement(this.props.optionGroupTemplate, suggestion, index) : this.props.getOptionGroupLabel(suggestion);
        var groupChildrenContent = this.renderGroupChildren(suggestion, index);
        var key = index + '_' + this.getOptionGroupRenderKey(suggestion);
        return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, {
          key: key
        }, /*#__PURE__*/React__default['default'].createElement("li", {
          className: "p-autocomplete-item-group"
        }, groupContent), groupChildrenContent);
      } else {
        var itemContent = this.props.itemTemplate ? ObjectUtils.getJSXElement(this.props.itemTemplate, suggestion, index) : this.props.field ? ObjectUtils.resolveFieldData(suggestion, this.props.field) : suggestion;
        return /*#__PURE__*/React__default['default'].createElement("li", {
          key: index + '_item',
          role: "option",
          "aria-selected": this.props.ariaSelected === suggestion,
          className: "p-autocomplete-item",
          onClick: function onClick(e) {
            return _this2.props.onItemClick(e, suggestion);
          }
        }, itemContent, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this3 = this;

      if (this.props.suggestions) {
        return this.props.suggestions.map(function (suggestion, index) {
          return _this3.renderItem(suggestion, index);
        });
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this4 = this;

      if (this.props.virtualScrollerOptions) {
        var virtualScrollerProps = _objectSpread$H(_objectSpread$H({}, this.props.virtualScrollerOptions), {
          style: _objectSpread$H(_objectSpread$H({}, this.props.virtualScrollerOptions.style), {
            height: this.props.scrollHeight
          }),
          items: this.props.suggestions,
          itemTemplate: function itemTemplate(item, options) {
            return item && _this4.renderItem(item, options.index);
          },
          contentTemplate: function contentTemplate(options) {
            var className = classNames('p-autocomplete-items', options.className);
            return /*#__PURE__*/React__default['default'].createElement("ul", {
              ref: options.ref,
              className: className,
              role: "listbox",
              id: _this4.props.listId
            }, options.children);
          }
        });

        return /*#__PURE__*/React__default['default'].createElement(VirtualScroller, _extends({
          ref: this.props.virtualScrollerRef
        }, virtualScrollerProps));
      } else {
        var items = this.renderItems();
        return /*#__PURE__*/React__default['default'].createElement("ul", {
          className: "p-autocomplete-items",
          role: "listbox",
          id: this.props.listId
        }, items);
      }
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var panelClassName = classNames('p-autocomplete-panel p-component', this.props.panelClassName);

      var panelStyle = _objectSpread$H({
        maxHeight: this.props.scrollHeight
      }, this.props.panelStyle);

      var content = this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.props.forwardRef,
        classNames: "p-connected-overlay",
        in: this.props.in,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.props.onEnter,
        onEntering: this.props.onEntering,
        onEntered: this.props.onEntered,
        onExit: this.props.onExit,
        onExited: this.props.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.props.forwardRef,
        className: panelClassName,
        style: panelStyle,
        onClick: this.props.onClick
      }, content));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo
      });
    }
  }]);

  return AutoCompletePanelComponent;
}(React.Component);

var AutoCompletePanel = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(AutoCompletePanelComponent, _extends({
    forwardRef: ref
  }, props));
});

var OverlayService = EventBus();

function ownKeys$G(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$G(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$G(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$G(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper$h(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$h(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$h(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$h(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$h(o, minLen); }

function _arrayLikeToArray$h(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$2c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2c() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var AutoComplete = /*#__PURE__*/function (_Component) {
  _inherits(AutoComplete, _Component);

  var _super = _createSuper$2c(AutoComplete);

  function AutoComplete(props) {
    var _this;

    _classCallCheck(this, AutoComplete);

    _this = _super.call(this, props);
    _this.state = {
      id: _this.props.id,
      searching: false,
      focused: false,
      overlayVisible: false
    };
    _this.onInputChange = _this.onInputChange.bind(_assertThisInitialized(_this));
    _this.onInputFocus = _this.onInputFocus.bind(_assertThisInitialized(_this));
    _this.onInputBlur = _this.onInputBlur.bind(_assertThisInitialized(_this));
    _this.onInputKeyDown = _this.onInputKeyDown.bind(_assertThisInitialized(_this));
    _this.onDropdownClick = _this.onDropdownClick.bind(_assertThisInitialized(_this));
    _this.onMultiContainerClick = _this.onMultiContainerClick.bind(_assertThisInitialized(_this));
    _this.onMultiInputFocus = _this.onMultiInputFocus.bind(_assertThisInitialized(_this));
    _this.onMultiInputBlur = _this.onMultiInputBlur.bind(_assertThisInitialized(_this));
    _this.selectItem = _this.selectItem.bind(_assertThisInitialized(_this));
    _this.getOptionGroupLabel = _this.getOptionGroupLabel.bind(_assertThisInitialized(_this));
    _this.getOptionGroupChildren = _this.getOptionGroupChildren.bind(_assertThisInitialized(_this));
    _this.onOverlayEnter = _this.onOverlayEnter.bind(_assertThisInitialized(_this));
    _this.onOverlayEntering = _this.onOverlayEntering.bind(_assertThisInitialized(_this));
    _this.onOverlayEntered = _this.onOverlayEntered.bind(_assertThisInitialized(_this));
    _this.onOverlayExit = _this.onOverlayExit.bind(_assertThisInitialized(_this));
    _this.onOverlayExited = _this.onOverlayExited.bind(_assertThisInitialized(_this));
    _this.onPanelClick = _this.onPanelClick.bind(_assertThisInitialized(_this));
    _this.overlayRef = /*#__PURE__*/React.createRef();
    _this.virtualScrollerRef = /*#__PURE__*/React.createRef();
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(AutoComplete, [{
    key: "onInputChange",
    value: function onInputChange(event) {
      var _this2 = this;

      //Cancel the search request if user types within the timeout
      if (this.timeout) {
        clearTimeout(this.timeout);
      }

      var query = event.target.value;

      if (!this.props.multiple) {
        this.updateModel(event, query);
      }

      if (query.length === 0) {
        this.hideOverlay();

        if (this.props.onClear) {
          this.props.onClear(event);
        }
      } else {
        if (query.length >= this.props.minLength) {
          this.timeout = setTimeout(function () {
            _this2.search(event, query, 'input');
          }, this.props.delay);
        } else {
          this.hideOverlay();
        }
      }
    }
  }, {
    key: "search",
    value: function search(event, query, source) {
      //allow empty string but not undefined or null
      if (query === undefined || query === null) {
        return;
      } //do not search blank values on input change


      if (source === 'input' && query.trim().length === 0) {
        return;
      }

      if (this.props.completeMethod) {
        this.setState({
          searching: true
        });
        this.props.completeMethod({
          originalEvent: event,
          query: query
        });
      }
    }
  }, {
    key: "selectItem",
    value: function selectItem(event, option, preventInputFocus) {
      if (this.props.multiple) {
        this.inputRef.current.value = '';

        if (!this.isSelected(option)) {
          var newValue = this.props.value ? [].concat(_toConsumableArray(this.props.value), [option]) : [option];
          this.updateModel(event, newValue);
        }
      } else {
        this.updateInputField(option);
        this.updateModel(event, option);
      }

      if (this.props.onSelect) {
        this.props.onSelect({
          originalEvent: event,
          value: option
        });
      }

      if (!preventInputFocus) {
        this.inputRef.current.focus();
        this.hideOverlay();
      }
    }
  }, {
    key: "updateModel",
    value: function updateModel(event, value) {
      if (this.props.onChange) {
        this.props.onChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.state.id,
            value: value
          }
        });
      }

      this.ariaSelected = value;
    }
  }, {
    key: "formatValue",
    value: function formatValue(value) {
      if (value) {
        if (this.props.selectedItemTemplate && (this.props.multiple ? this.isSelected(value) : this.findOptionIndex(value) > -1)) {
          var resolvedFieldData = ObjectUtils.getJSXElement(this.props.selectedItemTemplate, value);
          return resolvedFieldData ? resolvedFieldData : value;
        } else if (this.props.field) {
          var _resolvedFieldData = ObjectUtils.resolveFieldData(value, this.props.field);

          return _resolvedFieldData !== null && _resolvedFieldData !== undefined ? _resolvedFieldData : value;
        } else return value;
      } else return '';
    }
  }, {
    key: "updateInputField",
    value: function updateInputField(value) {
      var formattedValue = this.formatValue(value);
      this.inputRef.current.value = formattedValue;
    }
  }, {
    key: "showOverlay",
    value: function showOverlay() {
      this.setState({
        overlayVisible: true
      });
    }
  }, {
    key: "hideOverlay",
    value: function hideOverlay() {
      this.setState({
        overlayVisible: false,
        searching: false
      });
    }
  }, {
    key: "onOverlayEnter",
    value: function onOverlayEnter() {
      ZIndexUtils.set('overlay', this.overlayRef.current);
      this.alignOverlay();
    }
  }, {
    key: "onOverlayEntering",
    value: function onOverlayEntering() {
      if (this.props.autoHighlight && this.props.suggestions && this.props.suggestions.length) {
        DomHandler.addClass(this.overlayRef.current.firstChild.firstChild, 'p-highlight');
      }
    }
  }, {
    key: "onOverlayEntered",
    value: function onOverlayEntered() {
      this.bindDocumentClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onOverlayExit",
    value: function onOverlayExit() {
      this.unbindDocumentClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
    }
  }, {
    key: "onOverlayExited",
    value: function onOverlayExited() {
      ZIndexUtils.clear(this.overlayRef.current);
      this.props.onHide && this.props.onHide();
    }
  }, {
    key: "alignOverlay",
    value: function alignOverlay() {
      var target = this.props.multiple ? this.multiContainer : this.inputRef.current;
      DomHandler.alignOverlay(this.overlayRef.current, target, this.props.appendTo || PrimeReact.appendTo);
    }
  }, {
    key: "onPanelClick",
    value: function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: this.container
      });
    }
  }, {
    key: "onDropdownClick",
    value: function onDropdownClick(event) {
      this.inputRef.current.focus();
      if (this.props.dropdownMode === 'blank') this.search(event, '', 'dropdown');else if (this.props.dropdownMode === 'current') this.search(event, this.inputRef.current.value, 'dropdown');

      if (this.props.onDropdownClick) {
        this.props.onDropdownClick({
          originalEvent: event,
          query: this.inputRef.current.value
        });
      }
    }
  }, {
    key: "removeItem",
    value: function removeItem(event, index) {
      var removedValue = this.props.value[index];
      var newValue = this.props.value.filter(function (val, i) {
        return index !== i;
      });
      this.updateModel(event, newValue);

      if (this.props.onUnselect) {
        this.props.onUnselect({
          originalEvent: event,
          value: removedValue
        });
      }
    }
  }, {
    key: "onInputKeyDown",
    value: function onInputKeyDown(event) {
      if (this.state.overlayVisible) {
        var highlightItem = DomHandler.findSingle(this.overlayRef.current, 'li.p-highlight');

        switch (event.which) {
          //down
          case 40:
            if (highlightItem) {
              var nextElement = this.findNextItem(highlightItem);

              if (nextElement) {
                DomHandler.addClass(nextElement, 'p-highlight');
                DomHandler.removeClass(highlightItem, 'p-highlight');
                DomHandler.scrollInView(this.overlayRef.current, nextElement);
              }
            } else {
              highlightItem = DomHandler.findSingle(this.overlayRef.current, 'li');

              if (DomHandler.hasClass(highlightItem, 'p-autocomplete-item-group')) {
                highlightItem = this.findNextItem(highlightItem);
              }

              if (highlightItem) {
                DomHandler.addClass(highlightItem, 'p-highlight');
              }
            }

            event.preventDefault();
            break;
          //up

          case 38:
            if (highlightItem) {
              var previousElement = this.findPrevItem(highlightItem);

              if (previousElement) {
                DomHandler.addClass(previousElement, 'p-highlight');
                DomHandler.removeClass(highlightItem, 'p-highlight');
                DomHandler.scrollInView(this.overlayRef.current, previousElement);
              }
            }

            event.preventDefault();
            break;
          //enter

          case 13:
            if (highlightItem) {
              this.selectHighlightItem(event, highlightItem);
              this.hideOverlay();
            }

            event.preventDefault();
            break;
          //escape

          case 27:
            this.hideOverlay();
            event.preventDefault();
            break;
          //tab

          case 9:
            if (highlightItem) {
              this.selectHighlightItem(event, highlightItem);
            }

            this.hideOverlay();
            break;
        }
      }

      if (this.props.multiple) {
        switch (event.which) {
          //backspace
          case 8:
            if (this.props.value && this.props.value.length && !this.inputRef.current.value) {
              var removedValue = this.props.value[this.props.value.length - 1];
              var newValue = this.props.value.slice(0, -1);
              this.updateModel(event, newValue);

              if (this.props.onUnselect) {
                this.props.onUnselect({
                  originalEvent: event,
                  value: removedValue
                });
              }
            }

            break;
        }
      }
    }
  }, {
    key: "selectHighlightItem",
    value: function selectHighlightItem(event, item) {
      if (this.props.optionGroupLabel) {
        var optionGroup = this.props.suggestions[item.dataset.group];
        this.selectItem(event, this.getOptionGroupChildren(optionGroup)[item.dataset.index]);
      } else {
        this.selectItem(event, this.props.suggestions[DomHandler.index(item)]);
      }
    }
  }, {
    key: "findNextItem",
    value: function findNextItem(item) {
      var nextItem = item.nextElementSibling;
      return nextItem ? DomHandler.hasClass(nextItem, 'p-autocomplete-item-group') ? this.findNextItem(nextItem) : nextItem : null;
    }
  }, {
    key: "findPrevItem",
    value: function findPrevItem(item) {
      var prevItem = item.previousElementSibling;
      return prevItem ? DomHandler.hasClass(prevItem, 'p-autocomplete-item-group') ? this.findPrevItem(prevItem) : prevItem : null;
    }
  }, {
    key: "onInputFocus",
    value: function onInputFocus(event) {
      var _this3 = this;

      event.persist();
      this.setState({
        focused: true
      }, function () {
        if (_this3.props.onFocus) {
          _this3.props.onFocus(event);
        }
      });
    }
  }, {
    key: "forceItemSelection",
    value: function forceItemSelection(event) {
      var valid = false;
      var inputValue = event.target.value.trim();

      if (this.props.suggestions) {
        var _iterator = _createForOfIteratorHelper$h(this.props.suggestions),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var item = _step.value;
            var itemValue = this.props.field ? ObjectUtils.resolveFieldData(item, this.props.field) : item;

            if (itemValue && inputValue === itemValue.trim()) {
              valid = true;
              this.selectItem(event, item, true);
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      if (!valid) {
        this.inputRef.current.value = '';
        this.updateModel(event, null);

        if (this.props.onClear) {
          this.props.onClear(event);
        }
      }
    }
  }, {
    key: "onInputBlur",
    value: function onInputBlur(event) {
      var _this4 = this;

      event.persist();
      this.setState({
        focused: false
      }, function () {
        if (_this4.props.forceSelection) {
          _this4.forceItemSelection(event);
        }

        if (_this4.props.onBlur) {
          _this4.props.onBlur(event);
        }
      });
    }
  }, {
    key: "onMultiContainerClick",
    value: function onMultiContainerClick(event) {
      this.inputRef.current.focus();

      if (this.props.onClick) {
        this.props.onClick(event);
      }
    }
  }, {
    key: "onMultiInputFocus",
    value: function onMultiInputFocus(event) {
      this.onInputFocus(event);
      DomHandler.addClass(this.multiContainer, 'p-focus');
    }
  }, {
    key: "onMultiInputBlur",
    value: function onMultiInputBlur(event) {
      this.onInputBlur(event);
      DomHandler.removeClass(this.multiContainer, 'p-focus');
    }
  }, {
    key: "isSelected",
    value: function isSelected(val) {
      var selected = false;

      if (this.props.value && this.props.value.length) {
        for (var i = 0; i < this.props.value.length; i++) {
          if (ObjectUtils.equals(this.props.value[i], val)) {
            selected = true;
            break;
          }
        }
      }

      return selected;
    }
  }, {
    key: "findOptionIndex",
    value: function findOptionIndex(option) {
      var index = -1;

      if (this.props.suggestions) {
        for (var i = 0; i < this.props.suggestions.length; i++) {
          if (ObjectUtils.equals(option, this.props.suggestions[i])) {
            index = i;
            break;
          }
        }
      }

      return index;
    }
  }, {
    key: "getOptionGroupLabel",
    value: function getOptionGroupLabel(optionGroup) {
      return this.props.optionGroupLabel ? ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupLabel) : optionGroup;
    }
  }, {
    key: "getOptionGroupChildren",
    value: function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupChildren);
    }
  }, {
    key: "bindDocumentClickListener",
    value: function bindDocumentClickListener() {
      var _this5 = this;

      if (!this.documentClickListener) {
        this.documentClickListener = function (event) {
          if (event.which === 3) {
            // right click
            return;
          }

          if (_this5.state.overlayVisible && _this5.isOutsideClicked(event)) {
            _this5.hideOverlay();
          }
        };

        document.addEventListener('click', this.documentClickListener);
      }
    }
  }, {
    key: "unbindDocumentClickListener",
    value: function unbindDocumentClickListener() {
      if (this.documentClickListener) {
        document.removeEventListener('click', this.documentClickListener);
        this.documentClickListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this6 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.container, function () {
          if (_this6.state.overlayVisible) {
            _this6.hideOverlay();
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "bindResizeListener",
    value: function bindResizeListener() {
      var _this7 = this;

      if (!this.resizeListener) {
        this.resizeListener = function () {
          if (_this7.state.overlayVisible && !DomHandler.isAndroid()) {
            _this7.hideOverlay();
          }
        };

        window.addEventListener('resize', this.resizeListener);
      }
    }
  }, {
    key: "unbindResizeListener",
    value: function unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener('resize', this.resizeListener);
        this.resizeListener = null;
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(event) {
      return this.container && this.overlayRef && this.overlayRef.current && !this.overlayRef.current.contains(event.target) && !this.isInputClicked(event);
    }
  }, {
    key: "isInputClicked",
    value: function isInputClicked(event) {
      if (this.props.multiple) return event.target === this.multiContainer || this.multiContainer.contains(event.target);else return event.target === this.inputRef.current;
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();

      if (!this.state.id) {
        this.setState({
          id: UniqueComponentId()
        });
      }

      if (this.props.autoFocus && this.inputRef && this.inputRef.current) {
        this.inputRef.current.focus();
      }

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.suggestions !== this.props.suggestions && this.state.searching) {
        if (this.props.suggestions && this.props.suggestions.length) {
          this.showOverlay();
        } else {
          this.hideOverlay();
        }

        this.setState({
          searching: false
        });
      }

      if (this.inputRef && this.inputRef.current && !this.props.multiple) {
        this.updateInputField(this.props.value);
      }

      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$G({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentClickListener();
      this.unbindResizeListener();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }

      if (this.timeout) {
        clearTimeout(this.timeout);
      }

      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.container,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "renderSimpleAutoComplete",
    value: function renderSimpleAutoComplete() {
      var inputClassName = classNames('p-autocomplete-input', this.props.inputClassName, {
        'p-autocomplete-dd-input': this.props.dropdown
      });
      return /*#__PURE__*/React__default['default'].createElement(InputText, {
        ref: this.inputRef,
        id: this.props.inputId,
        type: this.props.type,
        name: this.props.name,
        defaultValue: this.formatValue(this.props.value),
        role: "searchbox",
        "aria-autocomplete": "list",
        "aria-controls": this.state.id + '_list',
        "aria-labelledby": this.props.ariaLabelledBy,
        className: inputClassName,
        style: this.props.inputStyle,
        autoComplete: "off",
        readOnly: this.props.readOnly,
        disabled: this.props.disabled,
        placeholder: this.props.placeholder,
        size: this.props.size,
        maxLength: this.props.maxlength,
        tabIndex: this.props.tabIndex,
        onBlur: this.onInputBlur,
        onFocus: this.onInputFocus,
        onChange: this.onInputChange,
        onMouseDown: this.props.onMouseDown,
        onKeyUp: this.props.onKeyUp,
        onKeyDown: this.onInputKeyDown,
        onKeyPress: this.props.onKeyPress,
        onContextMenu: this.props.onContextMenu,
        onClick: this.props.onClick,
        onDoubleClick: this.props.onDblClick
      });
    }
  }, {
    key: "renderChips",
    value: function renderChips() {
      var _this8 = this;

      if (this.props.value && this.props.value.length) {
        return this.props.value.map(function (val, index) {
          return /*#__PURE__*/React__default['default'].createElement("li", {
            key: index + 'multi-item',
            className: "p-autocomplete-token p-highlight"
          }, /*#__PURE__*/React__default['default'].createElement("span", {
            className: "p-autocomplete-token-label"
          }, _this8.formatValue(val)), !_this8.props.disabled && /*#__PURE__*/React__default['default'].createElement("span", {
            className: "p-autocomplete-token-icon pi pi-times-circle",
            onClick: function onClick(e) {
              return _this8.removeItem(e, index);
            }
          }));
        });
      }

      return null;
    }
  }, {
    key: "renderMultiInput",
    value: function renderMultiInput() {
      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: "p-autocomplete-input-token"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: this.inputRef,
        type: this.props.type,
        disabled: this.props.disabled,
        placeholder: this.props.placeholder,
        role: "searchbox",
        "aria-autocomplete": "list",
        "aria-controls": this.state.id + '_list',
        "aria-labelledby": this.props.ariaLabelledBy,
        autoComplete: "off",
        tabIndex: this.props.tabIndex,
        onChange: this.onInputChange,
        id: this.props.inputId,
        name: this.props.name,
        style: this.props.inputStyle,
        className: this.props.inputClassName,
        maxLength: this.props.maxlength,
        onKeyUp: this.props.onKeyUp,
        onKeyDown: this.onInputKeyDown,
        onKeyPress: this.props.onKeyPress,
        onFocus: this.onMultiInputFocus,
        onBlur: this.onMultiInputBlur
      }));
    }
  }, {
    key: "renderMultipleAutoComplete",
    value: function renderMultipleAutoComplete() {
      var _this9 = this;

      var multiContainerClass = classNames('p-autocomplete-multiple-container p-component p-inputtext', {
        'p-disabled': this.props.disabled
      });
      var tokens = this.renderChips();
      var input = this.renderMultiInput();
      return /*#__PURE__*/React__default['default'].createElement("ul", {
        ref: function ref(el) {
          _this9.multiContainer = el;
        },
        className: multiContainerClass,
        onContextMenu: this.props.onContextMenu,
        onMouseDown: this.props.onMouseDown,
        onClick: this.onMultiContainerClick,
        onDoubleClick: this.props.onDblClick
      }, tokens, input);
    }
  }, {
    key: "renderDropdown",
    value: function renderDropdown() {
      var _this10 = this;

      return /*#__PURE__*/React__default['default'].createElement(Button, {
        ref: function ref(el) {
          return _this10.dropdownButton = el;
        },
        type: "button",
        icon: this.props.dropdownIcon,
        className: "p-autocomplete-dropdown",
        disabled: this.props.disabled,
        onClick: this.onDropdownClick
      });
    }
  }, {
    key: "renderLoader",
    value: function renderLoader() {
      if (this.state.searching) {
        return /*#__PURE__*/React__default['default'].createElement("i", {
          className: "p-autocomplete-loader pi pi-spinner pi-spin"
        });
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this11 = this;

      var input, dropdown;
      var className = classNames('p-autocomplete p-component p-inputwrapper', this.props.className, {
        'p-autocomplete-dd': this.props.dropdown,
        'p-autocomplete-multiple': this.props.multiple,
        'p-inputwrapper-filled': this.props.value,
        'p-inputwrapper-focus': this.state.focused
      });
      var loader = this.renderLoader();
      if (this.props.multiple) input = this.renderMultipleAutoComplete();else input = this.renderSimpleAutoComplete();

      if (this.props.dropdown) {
        dropdown = this.renderDropdown();
      }

      return /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          return _this11.container = el;
        },
        id: this.state.id,
        style: this.props.style,
        className: className,
        "aria-haspopup": "listbox",
        "aria-expanded": this.state.overlayVisible,
        "aria-owns": this.state.id + '_list'
      }, input, loader, dropdown, /*#__PURE__*/React__default['default'].createElement(AutoCompletePanel, _extends({
        ref: this.overlayRef,
        virtualScrollerRef: this.virtualScrollerRef
      }, this.props, {
        listId: this.state.id + '_list',
        onItemClick: this.selectItem,
        ariaSelected: this.ariaSelected,
        onClick: this.onPanelClick,
        getOptionGroupLabel: this.getOptionGroupLabel,
        getOptionGroupChildren: this.getOptionGroupChildren,
        in: this.state.overlayVisible,
        onEnter: this.onOverlayEnter,
        onEntering: this.onOverlayEntering,
        onEntered: this.onOverlayEntered,
        onExit: this.onOverlayExit,
        onExited: this.onOverlayExited
      })));
    }
  }]);

  return AutoComplete;
}(React.Component);

_defineProperty(AutoComplete, "defaultProps", {
  id: null,
  inputRef: null,
  value: null,
  name: null,
  type: 'text',
  suggestions: null,
  field: null,
  optionGroupLabel: null,
  optionGroupChildren: null,
  optionGroupTemplate: null,
  forceSelection: false,
  autoHighlight: false,
  virtualScrollerOptions: null,
  scrollHeight: '200px',
  dropdown: false,
  dropdownMode: 'blank',
  multiple: false,
  minLength: 1,
  delay: 300,
  style: null,
  className: null,
  inputId: null,
  inputStyle: null,
  inputClassName: null,
  panelClassName: null,
  panelStyle: null,
  placeholder: null,
  readOnly: false,
  disabled: false,
  maxlength: null,
  size: null,
  appendTo: null,
  tabIndex: null,
  autoFocus: false,
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  completeMethod: null,
  itemTemplate: null,
  selectedItemTemplate: null,
  transitionOptions: null,
  dropdownIcon: 'pi pi-chevron-down',
  onChange: null,
  onFocus: null,
  onBlur: null,
  onSelect: null,
  onUnselect: null,
  onDropdownClick: null,
  onClick: null,
  onDblClick: null,
  onMouseDown: null,
  onKeyUp: null,
  onKeyPress: null,
  onContextMenu: null,
  onClear: null,
  onShow: null,
  onHide: null
});

function _createSuper$2b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2b() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Avatar = /*#__PURE__*/function (_Component) {
  _inherits(Avatar, _Component);

  var _super = _createSuper$2b(Avatar);

  function Avatar() {
    _classCallCheck(this, Avatar);

    return _super.apply(this, arguments);
  }

  _createClass(Avatar, [{
    key: "renderContent",
    value: function renderContent() {
      var _this = this;

      if (this.props.label) {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-avatar-text"
        }, this.props.label);
      } else if (this.props.icon) {
        var iconClassName = classNames('p-avatar-icon', this.props.icon);
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: iconClassName
        });
      } else if (this.props.image) {
        var onError = function onError(e) {
          if (_this.props.onImageError) {
            _this.props.onImageError(e);
          }
        };

        return /*#__PURE__*/React__default['default'].createElement("img", {
          src: this.props.image,
          alt: this.props.imageAlt,
          onError: onError
        });
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var containerClassName = classNames('p-avatar p-component', {
        'p-avatar-image': this.props.image != null,
        'p-avatar-circle': this.props.shape === 'circle',
        'p-avatar-lg': this.props.size === 'large',
        'p-avatar-xl': this.props.size === 'xlarge',
        'p-avatar-clickable': !!this.props.onClick
      }, this.props.className);
      var content = this.props.template ? ObjectUtils.getJSXElement(this.props.template, this.props) : this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: containerClassName,
        style: this.props.style,
        onClick: this.props.onClick
      }, content, this.props.children);
    }
  }]);

  return Avatar;
}(React.Component);

_defineProperty(Avatar, "defaultProps", {
  label: null,
  icon: null,
  image: null,
  size: 'normal',
  shape: 'square',
  style: null,
  className: null,
  template: null,
  imageAlt: 'avatar',
  onImageError: null,
  onClick: null
});

function _createSuper$2a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$2a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$2a() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var AvatarGroup = /*#__PURE__*/function (_Component) {
  _inherits(AvatarGroup, _Component);

  var _super = _createSuper$2a(AvatarGroup);

  function AvatarGroup() {
    _classCallCheck(this, AvatarGroup);

    return _super.apply(this, arguments);
  }

  _createClass(AvatarGroup, [{
    key: "render",
    value: function render() {
      var containerClassName = classNames('p-avatar-group p-component', this.props.className);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: containerClassName,
        style: this.props.style
      }, this.props.children);
    }
  }]);

  return AvatarGroup;
}(React.Component);

_defineProperty(AvatarGroup, "defaultProps", {
  style: null,
  className: null
});

function _createSuper$29(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$29(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$29() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Badge = /*#__PURE__*/function (_Component) {
  _inherits(Badge, _Component);

  var _super = _createSuper$29(Badge);

  function Badge() {
    _classCallCheck(this, Badge);

    return _super.apply(this, arguments);
  }

  _createClass(Badge, [{
    key: "render",
    value: function render() {
      var badgeClassName = classNames('p-badge p-component', {
        'p-badge-no-gutter': this.props.value && String(this.props.value).length === 1,
        'p-badge-dot': !this.props.value,
        'p-badge-lg': this.props.size === 'large',
        'p-badge-xl': this.props.size === 'xlarge',
        'p-badge-info': this.props.severity === 'info',
        'p-badge-success': this.props.severity === 'success',
        'p-badge-warning': this.props.severity === 'warning',
        'p-badge-danger': this.props.severity === 'danger'
      }, this.props.className);
      return /*#__PURE__*/React__default['default'].createElement("span", {
        className: badgeClassName,
        style: this.props.style
      }, this.props.value);
    }
  }]);

  return Badge;
}(React.Component);

_defineProperty(Badge, "defaultProps", {
  value: null,
  severity: null,
  size: null,
  style: null,
  className: null
});

function _createSuper$28(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$28(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$28() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var BreadCrumb = /*#__PURE__*/function (_Component) {
  _inherits(BreadCrumb, _Component);

  var _super = _createSuper$28(BreadCrumb);

  function BreadCrumb() {
    _classCallCheck(this, BreadCrumb);

    return _super.apply(this, arguments);
  }

  _createClass(BreadCrumb, [{
    key: "itemClick",
    value: function itemClick(event, item) {
      if (item.disabled) {
        event.preventDefault();
        return;
      }

      if (!item.url) {
        event.preventDefault();
      }

      if (item.command) {
        item.command({
          originalEvent: event,
          item: item
        });
      }
    }
  }, {
    key: "renderHome",
    value: function renderHome() {
      var _this = this;

      if (this.props.home) {
        var className = classNames('p-breadcrumb-home', {
          'p-disabled': this.props.home.disabled
        }, this.props.home.className);
        var iconClassName = classNames('p-menuitem-icon', this.props.home.icon);
        return /*#__PURE__*/React__default['default'].createElement("li", {
          className: className,
          style: this.props.home.style
        }, /*#__PURE__*/React__default['default'].createElement("a", {
          href: this.props.home.url || '#',
          className: "p-menuitem-link",
          "aria-disabled": this.props.home.disabled,
          target: this.props.home.target,
          onClick: function onClick(event) {
            return _this.itemClick(event, _this.props.home);
          }
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: iconClassName
        })));
      }

      return null;
    }
  }, {
    key: "renderSeparator",
    value: function renderSeparator() {
      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: "p-breadcrumb-chevron pi pi-chevron-right"
      });
    }
  }, {
    key: "renderMenuitem",
    value: function renderMenuitem(item) {
      var _this2 = this;

      var className = classNames(item.className, {
        'p-disabled': item.disabled
      });
      var label = item.label && /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-menuitem-text"
      }, item.label);
      var content = /*#__PURE__*/React__default['default'].createElement("a", {
        href: item.url || '#',
        className: "p-menuitem-link",
        target: item.target,
        onClick: function onClick(event) {
          return _this2.itemClick(event, item);
        },
        "aria-disabled": item.disabled
      }, label);

      if (item.template) {
        var defaultContentOptions = {
          onClick: function onClick(event) {
            return _this2.itemClick(event, item);
          },
          className: 'p-menuitem-link',
          labelClassName: 'p-menuitem-text',
          element: content,
          props: this.props
        };
        content = ObjectUtils.getJSXElement(item.template, item, defaultContentOptions);
      }

      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: className,
        style: item.style
      }, content);
    }
  }, {
    key: "renderMenuitems",
    value: function renderMenuitems() {
      var _this3 = this;

      if (this.props.model) {
        var items = this.props.model.map(function (item, index) {
          var menuitem = _this3.renderMenuitem(item);

          var separator = index === _this3.props.model.length - 1 ? null : _this3.renderSeparator();
          return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, {
            key: item.label + '_' + index
          }, menuitem, separator);
        });
        return items;
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-breadcrumb p-component', this.props.className);
      var home = this.renderHome();
      var items = this.renderMenuitems();
      var separator = this.renderSeparator();
      return /*#__PURE__*/React__default['default'].createElement("nav", {
        id: this.props.id,
        className: className,
        style: this.props.style,
        "aria-label": "Breadcrumb"
      }, /*#__PURE__*/React__default['default'].createElement("ul", null, home, separator, items));
    }
  }]);

  return BreadCrumb;
}(React.Component);

_defineProperty(BreadCrumb, "defaultProps", {
  id: null,
  model: null,
  home: null,
  style: null,
  className: null
});

function _createSuper$27(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$27(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$27() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var CalendarPanelComponent = /*#__PURE__*/function (_Component) {
  _inherits(CalendarPanelComponent, _Component);

  var _super = _createSuper$27(CalendarPanelComponent);

  function CalendarPanelComponent() {
    _classCallCheck(this, CalendarPanelComponent);

    return _super.apply(this, arguments);
  }

  _createClass(CalendarPanelComponent, [{
    key: "renderElement",
    value: function renderElement() {
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.props.forwardRef,
        classNames: "p-connected-overlay",
        in: this.props.in,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.props.onEnter,
        onEntered: this.props.onEntered,
        onExit: this.props.onExit,
        onExited: this.props.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.props.forwardRef,
        className: this.props.className,
        style: this.props.style,
        onClick: this.props.onClick
      }, this.props.children));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return this.props.inline ? element : /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo
      });
    }
  }]);

  return CalendarPanelComponent;
}(React.Component);

_defineProperty(CalendarPanelComponent, "defaultProps", {
  appendTo: null,
  style: null,
  className: null
});

var CalendarPanel = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(CalendarPanelComponent, _extends({
    forwardRef: ref
  }, props));
});

function _createForOfIteratorHelper$g(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$g(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$g(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$g(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$g(o, minLen); }

function _arrayLikeToArray$g(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys$F(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$F(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$F(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$F(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$26(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$26(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$26() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Calendar = /*#__PURE__*/function (_Component) {
  _inherits(Calendar, _Component);

  var _super = _createSuper$26(Calendar);

  function Calendar(props) {
    var _this;

    _classCallCheck(this, Calendar);

    _this = _super.call(this, props);
    _this.state = {
      focused: false,
      overlayVisible: false
    };

    if (!_this.props.onViewDateChange) {
      var propValue = _this.props.value;

      if (Array.isArray(propValue)) {
        propValue = propValue[0];
      }

      var viewDate = _this.props.viewDate && _this.isValidDate(_this.props.viewDate) ? _this.props.viewDate : propValue && _this.isValidDate(propValue) ? propValue : new Date();

      _this.validateDate(viewDate);

      _this.state = _objectSpread$F(_objectSpread$F({}, _this.state), {}, {
        viewDate: viewDate
      });
    }

    _this.navigation = null;
    _this.onUserInput = _this.onUserInput.bind(_assertThisInitialized(_this));
    _this.onInputFocus = _this.onInputFocus.bind(_assertThisInitialized(_this));
    _this.onInputBlur = _this.onInputBlur.bind(_assertThisInitialized(_this));
    _this.onInputKeyDown = _this.onInputKeyDown.bind(_assertThisInitialized(_this));
    _this.onButtonClick = _this.onButtonClick.bind(_assertThisInitialized(_this));
    _this.onPrevButtonClick = _this.onPrevButtonClick.bind(_assertThisInitialized(_this));
    _this.onNextButtonClick = _this.onNextButtonClick.bind(_assertThisInitialized(_this));
    _this.onMonthDropdownChange = _this.onMonthDropdownChange.bind(_assertThisInitialized(_this));
    _this.onYearDropdownChange = _this.onYearDropdownChange.bind(_assertThisInitialized(_this));
    _this.onTodayButtonClick = _this.onTodayButtonClick.bind(_assertThisInitialized(_this));
    _this.onClearButtonClick = _this.onClearButtonClick.bind(_assertThisInitialized(_this));
    _this.onPanelClick = _this.onPanelClick.bind(_assertThisInitialized(_this));
    _this.incrementHour = _this.incrementHour.bind(_assertThisInitialized(_this));
    _this.decrementHour = _this.decrementHour.bind(_assertThisInitialized(_this));
    _this.incrementMinute = _this.incrementMinute.bind(_assertThisInitialized(_this));
    _this.decrementMinute = _this.decrementMinute.bind(_assertThisInitialized(_this));
    _this.incrementSecond = _this.incrementSecond.bind(_assertThisInitialized(_this));
    _this.decrementSecond = _this.decrementSecond.bind(_assertThisInitialized(_this));
    _this.toggleAmPm = _this.toggleAmPm.bind(_assertThisInitialized(_this));
    _this.onTimePickerElementMouseDown = _this.onTimePickerElementMouseDown.bind(_assertThisInitialized(_this));
    _this.onTimePickerElementMouseUp = _this.onTimePickerElementMouseUp.bind(_assertThisInitialized(_this));
    _this.onTimePickerElementMouseLeave = _this.onTimePickerElementMouseLeave.bind(_assertThisInitialized(_this));
    _this.onOverlayEnter = _this.onOverlayEnter.bind(_assertThisInitialized(_this));
    _this.onOverlayEntered = _this.onOverlayEntered.bind(_assertThisInitialized(_this));
    _this.onOverlayExit = _this.onOverlayExit.bind(_assertThisInitialized(_this));
    _this.onOverlayExited = _this.onOverlayExited.bind(_assertThisInitialized(_this));
    _this.reFocusInputField = _this.reFocusInputField.bind(_assertThisInitialized(_this));
    _this.overlayRef = /*#__PURE__*/React.createRef();
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(Calendar, [{
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.updateInputRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }

      if (this.props.inline) {
        this.initFocusableCell();
      } else if (this.props.mask) {
        mask(this.inputRef.current, {
          mask: this.props.mask,
          readOnly: this.props.readOnlyInput || this.props.disabled,
          onChange: function onChange(e) {
            return _this2.updateValueOnInput(e.originalEvent, e.value);
          }
        });
      }

      if (this.props.value) {
        this.updateInputfield(this.props.value);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;

      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$F({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }

      if (!this.props.onViewDateChange && !this.viewStateChanged) {
        var propValue = this.props.value;

        if (Array.isArray(propValue)) {
          propValue = propValue[0];
        }

        var prevPropValue = prevProps.value;

        if (Array.isArray(prevPropValue)) {
          prevPropValue = prevPropValue[0];
        }

        if (!prevPropValue && propValue || propValue && propValue instanceof Date && propValue.getTime() !== prevPropValue.getTime()) {
          var viewDate = this.props.viewDate && this.isValidDate(this.props.viewDate) ? this.props.viewDate : propValue && this.isValidDate(propValue) ? propValue : new Date();
          this.validateDate(viewDate);
          this.setState({
            viewDate: viewDate
          }, function () {
            _this3.viewStateChanged = true;
          });
        }
      }

      if (this.overlayRef && this.overlayRef.current) {
        this.updateFocus();
      }

      if (prevProps.value !== this.props.value && (!this.viewStateChanged || !this.isVisible()) || this.isOptionChanged(prevProps)) {
        this.updateInputfield(this.props.value);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }

      if (this.touchUIMask) {
        this.disableModality();
        this.touchUIMask = null;
      }

      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }

      this.unbindDocumentClickListener();
      this.unbindDocumentResizeListener();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.inputRef.current,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "isVisible",
    value: function isVisible() {
      return this.props.onVisibleChange ? this.props.visible : this.state.overlayVisible;
    }
  }, {
    key: "isOptionChanged",
    value: function isOptionChanged(prevProps) {
      var _this4 = this;

      var optionProps = ['dateFormat', 'hourFormat', 'timeOnly', 'showSeconds', 'showMillisec'];
      return optionProps.some(function (option) {
        return prevProps[option] !== _this4.props[option];
      });
    }
  }, {
    key: "getDateFormat",
    value: function getDateFormat() {
      return this.props.dateFormat || localeOption('dateFormat', this.props.locale);
    }
  }, {
    key: "onInputFocus",
    value: function onInputFocus(event) {
      var _this5 = this;

      if (this.ignoreFocusFunctionality) {
        this.setState({
          focused: true
        }, function () {
          _this5.ignoreFocusFunctionality = false;
        });
      } else {
        event.persist();

        if (this.props.showOnFocus && !this.isVisible()) {
          this.showOverlay();
        }

        this.setState({
          focused: true
        }, function () {
          if (_this5.props.onFocus) {
            _this5.props.onFocus(event);
          }
        });
      }
    }
  }, {
    key: "onInputBlur",
    value: function onInputBlur(event) {
      var _this6 = this;

      event.persist();
      this.setState({
        focused: false
      }, function () {
        if (_this6.props.onBlur) {
          _this6.props.onBlur(event);
        }

        if (!_this6.props.keepInvalid) {
          _this6.updateInputfield(_this6.props.value);
        }
      });
    }
  }, {
    key: "onInputKeyDown",
    value: function onInputKeyDown(event) {
      this.isKeydown = true;

      switch (event.which) {
        //escape
        case 27:
          {
            this.hideOverlay();
            break;
          }
        //tab

        case 9:
          {
            if (this.isVisible()) {
              this.trapFocus(event);
            }

            if (this.props.touchUI) {
              this.disableModality();
            }

            break;
          }
      }
    }
  }, {
    key: "onUserInput",
    value: function onUserInput(event) {
      // IE 11 Workaround for input placeholder
      if (!this.isKeydown) {
        return;
      }

      this.isKeydown = false;
      this.updateValueOnInput(event, event.target.value);

      if (this.props.onInput) {
        this.props.onInput(event);
      }
    }
  }, {
    key: "updateValueOnInput",
    value: function updateValueOnInput(event, rawValue) {
      try {
        var value = this.parseValueFromString(rawValue);

        if (this.isValidSelection(value)) {
          this.updateModel(event, value);
          this.updateViewDate(event, value.length ? value[0] : value);
        }
      } catch (err) {
        //invalid date
        var _value = this.props.keepInvalid ? rawValue : null;

        this.updateModel(event, _value);
      }
    }
  }, {
    key: "reFocusInputField",
    value: function reFocusInputField() {
      if (!this.props.inline && this.inputRef.current) {
        this.ignoreFocusFunctionality = true;
        this.inputRef.current.focus();
      }
    }
  }, {
    key: "isValidSelection",
    value: function isValidSelection(value) {
      var _this7 = this;

      var isValid = true;

      if (this.isSingleSelection()) {
        if (!(this.isSelectable(value.getDate(), value.getMonth(), value.getFullYear(), false) && this.isSelectableTime(value))) {
          isValid = false;
        }
      } else if (value.every(function (v) {
        return _this7.isSelectable(v.getDate(), v.getMonth(), v.getFullYear(), false) && _this7.isSelectableTime(value);
      })) {
        if (this.isRangeSelection()) {
          isValid = value.length > 1 && value[1] > value[0] ? true : false;
        }
      }

      return isValid;
    }
  }, {
    key: "onButtonClick",
    value: function onButtonClick() {
      if (this.isVisible()) {
        this.hideOverlay();
      } else {
        this.showOverlay();
      }
    }
  }, {
    key: "onPrevButtonClick",
    value: function onPrevButtonClick(event) {
      this.navigation = {
        backward: true,
        button: true
      };
      this.navBackward(event);
    }
  }, {
    key: "onNextButtonClick",
    value: function onNextButtonClick(event) {
      this.navigation = {
        backward: false,
        button: true
      };
      this.navForward(event);
    }
  }, {
    key: "onContainerButtonKeydown",
    value: function onContainerButtonKeydown(event) {
      switch (event.which) {
        //tab
        case 9:
          this.trapFocus(event);
          break;
        //escape

        case 27:
          this.hideOverlay(null, this.reFocusInputField);
          event.preventDefault();
          break;
      }
    }
  }, {
    key: "trapFocus",
    value: function trapFocus(event) {
      event.preventDefault();
      var focusableElements = DomHandler.getFocusableElements(this.overlayRef.current);

      if (focusableElements && focusableElements.length > 0) {
        if (!document.activeElement) {
          focusableElements[0].focus();
        } else {
          var focusedIndex = focusableElements.indexOf(document.activeElement);

          if (event.shiftKey) {
            if (focusedIndex === -1 || focusedIndex === 0) focusableElements[focusableElements.length - 1].focus();else focusableElements[focusedIndex - 1].focus();
          } else {
            if (focusedIndex === -1 || focusedIndex === focusableElements.length - 1) focusableElements[0].focus();else focusableElements[focusedIndex + 1].focus();
          }
        }
      }
    }
  }, {
    key: "updateFocus",
    value: function updateFocus() {
      var cell;

      if (this.navigation) {
        if (this.navigation.button) {
          this.initFocusableCell();
          if (this.navigation.backward) DomHandler.findSingle(this.overlayRef.current, '.p-datepicker-prev').focus();else DomHandler.findSingle(this.overlayRef.current, '.p-datepicker-next').focus();
        } else {
          if (this.navigation.backward) {
            var cells = DomHandler.find(this.overlayRef.current, '.p-datepicker-calendar td span:not(.p-disabled)');
            cell = cells[cells.length - 1];
          } else {
            cell = DomHandler.findSingle(this.overlayRef.current, '.p-datepicker-calendar td span:not(.p-disabled)');
          }

          if (cell) {
            cell.tabIndex = '0';
            cell.focus();
          }
        }

        this.navigation = null;
      } else {
        this.initFocusableCell();
      }
    }
  }, {
    key: "initFocusableCell",
    value: function initFocusableCell() {
      var cell;

      if (this.view === 'month') {
        var cells = DomHandler.find(this.overlayRef.current, '.p-monthpicker .p-monthpicker-month');
        var selectedCell = DomHandler.findSingle(this.overlayRef.current, '.p-monthpicker .p-monthpicker-month.p-highlight');
        cells.forEach(function (cell) {
          return cell.tabIndex = -1;
        });
        cell = selectedCell || cells[0];
      } else {
        cell = DomHandler.findSingle(this.overlayRef.current, 'span.p-highlight');

        if (!cell) {
          var todayCell = DomHandler.findSingle(this.overlayRef.current, 'td.p-datepicker-today span:not(.p-disabled)');
          if (todayCell) cell = todayCell;else cell = DomHandler.findSingle(this.overlayRef.current, '.p-datepicker-calendar td span:not(.p-disabled)');
        }
      }

      if (cell) {
        cell.tabIndex = '0';
      }
    }
  }, {
    key: "navBackward",
    value: function navBackward(event) {
      if (this.props.disabled) {
        event.preventDefault();
        return;
      }

      var newViewDate = new Date(this.getViewDate().getTime());
      newViewDate.setDate(1);

      if (this.props.view === 'date') {
        if (newViewDate.getMonth() === 0) {
          newViewDate.setMonth(11);
          newViewDate.setFullYear(newViewDate.getFullYear() - 1);
        } else {
          newViewDate.setMonth(newViewDate.getMonth() - 1);
        }
      } else if (this.props.view === 'month') {
        var currentYear = newViewDate.getFullYear();
        var newYear = currentYear - 1;

        if (this.props.yearNavigator) {
          var minYear = parseInt(this.props.yearRange.split(':')[0], 10);

          if (newYear < minYear) {
            newYear = minYear;
          }
        }

        newViewDate.setFullYear(newYear);
      }

      this.updateViewDate(event, newViewDate);
      event.preventDefault();
    }
  }, {
    key: "navForward",
    value: function navForward(event) {
      if (this.props.disabled) {
        event.preventDefault();
        return;
      }

      var newViewDate = new Date(this.getViewDate().getTime());
      newViewDate.setDate(1);

      if (this.props.view === 'date') {
        if (newViewDate.getMonth() === 11) {
          newViewDate.setMonth(0);
          newViewDate.setFullYear(newViewDate.getFullYear() + 1);
        } else {
          newViewDate.setMonth(newViewDate.getMonth() + 1);
        }
      } else if (this.props.view === 'month') {
        var currentYear = newViewDate.getFullYear();
        var newYear = currentYear + 1;

        if (this.props.yearNavigator) {
          var maxYear = parseInt(this.props.yearRange.split(':')[1], 10);

          if (newYear > maxYear) {
            newYear = maxYear;
          }
        }

        newViewDate.setFullYear(newYear);
      }

      this.updateViewDate(event, newViewDate);
      event.preventDefault();
    }
  }, {
    key: "onMonthDropdownChange",
    value: function onMonthDropdownChange(event, value) {
      var currentViewDate = this.getViewDate();
      var newViewDate = new Date(currentViewDate.getTime());
      newViewDate.setMonth(parseInt(value, 10));
      this.updateViewDate(event, newViewDate);
    }
  }, {
    key: "onYearDropdownChange",
    value: function onYearDropdownChange(event, value) {
      var currentViewDate = this.getViewDate();
      var newViewDate = new Date(currentViewDate.getTime());
      newViewDate.setFullYear(parseInt(value, 10));
      this.updateViewDate(event, newViewDate);
    }
  }, {
    key: "onTodayButtonClick",
    value: function onTodayButtonClick(event) {
      var today = new Date();
      var dateMeta = {
        day: today.getDate(),
        month: today.getMonth(),
        year: today.getFullYear(),
        today: true,
        selectable: true
      };
      var timeMeta = {
        hours: today.getHours(),
        minutes: today.getMinutes(),
        seconds: today.getSeconds(),
        milliseconds: today.getMilliseconds()
      };
      this.updateViewDate(event, today);
      this.onDateSelect(event, dateMeta, timeMeta);

      if (this.props.onTodayButtonClick) {
        this.props.onTodayButtonClick(event);
      }
    }
  }, {
    key: "onClearButtonClick",
    value: function onClearButtonClick(event) {
      this.updateModel(event, null);
      this.updateInputfield(null);
      this.hideOverlay(null, this.reFocusInputField);

      if (this.props.onClearButtonClick) {
        this.props.onClearButtonClick(event);
      }
    }
  }, {
    key: "onPanelClick",
    value: function onPanelClick(event) {
      if (!this.props.inline) {
        OverlayService.emit('overlay-click', {
          originalEvent: event,
          target: this.container
        });
      }
    }
  }, {
    key: "onTimePickerElementMouseDown",
    value: function onTimePickerElementMouseDown(event, type, direction) {
      if (!this.props.disabled) {
        this.repeat(event, null, type, direction);
        event.preventDefault();
      }
    }
  }, {
    key: "onTimePickerElementMouseUp",
    value: function onTimePickerElementMouseUp() {
      if (!this.props.disabled) {
        this.clearTimePickerTimer();
      }
    }
  }, {
    key: "onTimePickerElementMouseLeave",
    value: function onTimePickerElementMouseLeave() {
      if (!this.props.disabled) {
        this.clearTimePickerTimer();
      }
    }
  }, {
    key: "repeat",
    value: function repeat(event, interval, type, direction) {
      var _this8 = this;

      event.persist();
      var i = interval || 500;
      this.clearTimePickerTimer();
      this.timePickerTimer = setTimeout(function () {
        _this8.repeat(event, 100, type, direction);
      }, i);

      switch (type) {
        case 0:
          if (direction === 1) this.incrementHour(event);else this.decrementHour(event);
          break;

        case 1:
          if (direction === 1) this.incrementMinute(event);else this.decrementMinute(event);
          break;

        case 2:
          if (direction === 1) this.incrementSecond(event);else this.decrementSecond(event);
          break;

        case 3:
          if (direction === 1) this.incrementMilliSecond(event);else this.decrementMilliSecond(event);
          break;
      }
    }
  }, {
    key: "clearTimePickerTimer",
    value: function clearTimePickerTimer() {
      if (this.timePickerTimer) {
        clearTimeout(this.timePickerTimer);
      }
    }
  }, {
    key: "incrementHour",
    value: function incrementHour(event) {
      var currentTime = this.getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour + this.props.stepHour;
      newHour = newHour >= 24 ? newHour - 24 : newHour;

      if (this.validateHour(newHour, currentTime)) {
        if (this.props.maxDate && this.props.maxDate.toDateString() === currentTime.toDateString() && this.props.maxDate.getHours() === newHour) {
          if (this.props.maxDate.getMinutes() < currentTime.getMinutes()) {
            if (this.props.maxDate.getSeconds() < currentTime.getSeconds()) {
              if (this.props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
                this.updateTime(event, newHour, this.props.maxDate.getMinutes(), this.props.maxDate.getSeconds(), this.props.maxDate.getMilliseconds());
              } else {
                this.updateTime(event, newHour, this.props.maxDate.getMinutes(), this.props.maxDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              this.updateTime(event, newHour, this.props.maxDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else if (this.props.maxDate.getMinutes() === currentTime.getMinutes()) {
            if (this.props.maxDate.getSeconds() < currentTime.getSeconds()) {
              if (this.props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
                this.updateTime(event, newHour, this.props.maxDate.getMinutes(), this.props.maxDate.getSeconds(), this.props.maxDate.getMilliseconds());
              } else {
                this.updateTime(event, newHour, this.props.maxDate.getMinutes(), this.props.maxDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              this.updateTime(event, newHour, this.props.maxDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            this.updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          this.updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }

      event.preventDefault();
    }
  }, {
    key: "decrementHour",
    value: function decrementHour(event) {
      var currentTime = this.getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour - this.props.stepHour;
      newHour = newHour < 0 ? newHour + 24 : newHour;

      if (this.validateHour(newHour, currentTime)) {
        if (this.props.minDate && this.props.minDate.toDateString() === currentTime.toDateString() && this.props.minDate.getHours() === newHour) {
          if (this.props.minDate.getMinutes() > currentTime.getMinutes()) {
            if (this.props.minDate.getSeconds() > currentTime.getSeconds()) {
              if (this.props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
                this.updateTime(event, newHour, this.props.minDate.getMinutes(), this.props.minDate.getSeconds(), this.props.minDate.getMilliseconds());
              } else {
                this.updateTime(event, newHour, this.props.minDate.getMinutes(), this.props.minDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              this.updateTime(event, newHour, this.props.minDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else if (this.props.minDate.getMinutes() === currentTime.getMinutes()) {
            if (this.props.minDate.getSeconds() > currentTime.getSeconds()) {
              if (this.props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
                this.updateTime(event, newHour, this.props.minDate.getMinutes(), this.props.minDate.getSeconds(), this.props.minDate.getMilliseconds());
              } else {
                this.updateTime(event, newHour, this.props.minDate.getMinutes(), this.props.minDate.getSeconds(), currentTime.getMilliseconds());
              }
            } else {
              this.updateTime(event, newHour, this.props.minDate.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            this.updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          this.updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }

      event.preventDefault();
    }
  }, {
    key: "incrementMinute",
    value: function incrementMinute(event) {
      var currentTime = this.getCurrentDateTime();
      var currentMinute = currentTime.getMinutes();
      var newMinute = currentMinute + this.props.stepMinute;
      newMinute = newMinute > 59 ? newMinute - 60 : newMinute;

      if (this.validateMinute(newMinute, currentTime)) {
        if (this.props.maxDate && this.props.maxDate.toDateString() === currentTime.toDateString() && this.props.maxDate.getMinutes() === newMinute) {
          if (this.props.maxDate.getSeconds() < currentTime.getSeconds()) {
            if (this.props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
              this.updateTime(event, currentTime.getHours(), newMinute, this.props.maxDate.getSeconds(), this.props.maxDate.getMilliseconds());
            } else {
              this.updateTime(event, currentTime.getHours(), newMinute, this.props.maxDate.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            this.updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          this.updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }

      event.preventDefault();
    }
  }, {
    key: "decrementMinute",
    value: function decrementMinute(event) {
      var currentTime = this.getCurrentDateTime();
      var currentMinute = currentTime.getMinutes();
      var newMinute = currentMinute - this.props.stepMinute;
      newMinute = newMinute < 0 ? newMinute + 60 : newMinute;

      if (this.validateMinute(newMinute, currentTime)) {
        if (this.props.minDate && this.props.minDate.toDateString() === currentTime.toDateString() && this.props.minDate.getMinutes() === newMinute) {
          if (this.props.minDate.getSeconds() > currentTime.getSeconds()) {
            if (this.props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
              this.updateTime(event, currentTime.getHours(), newMinute, this.props.minDate.getSeconds(), this.props.minDate.getMilliseconds());
            } else {
              this.updateTime(event, currentTime.getHours(), newMinute, this.props.minDate.getSeconds(), currentTime.getMilliseconds());
            }
          } else {
            this.updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
          }
        } else {
          this.updateTime(event, currentTime.getHours(), newMinute, currentTime.getSeconds(), currentTime.getMilliseconds());
        }
      }

      event.preventDefault();
    }
  }, {
    key: "incrementSecond",
    value: function incrementSecond(event) {
      var currentTime = this.getCurrentDateTime();
      var currentSecond = currentTime.getSeconds();
      var newSecond = currentSecond + this.props.stepSecond;
      newSecond = newSecond > 59 ? newSecond - 60 : newSecond;

      if (this.validateSecond(newSecond, currentTime)) {
        if (this.props.maxDate && this.props.maxDate.toDateString() === currentTime.toDateString() && this.props.maxDate.getSeconds() === newSecond) {
          if (this.props.maxDate.getMilliseconds() < currentTime.getMilliseconds()) {
            this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, this.props.maxDate.getMilliseconds());
          } else {
            this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
          }
        } else {
          this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
        }
      }

      event.preventDefault();
    }
  }, {
    key: "decrementSecond",
    value: function decrementSecond(event) {
      var currentTime = this.getCurrentDateTime();
      var currentSecond = currentTime.getSeconds();
      var newSecond = currentSecond - this.props.stepSecond;
      newSecond = newSecond < 0 ? newSecond + 60 : newSecond;

      if (this.validateSecond(newSecond, currentTime)) {
        if (this.props.minDate && this.props.minDate.toDateString() === currentTime.toDateString() && this.props.minDate.getSeconds() === newSecond) {
          if (this.props.minDate.getMilliseconds() > currentTime.getMilliseconds()) {
            this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, this.props.minDate.getMilliseconds());
          } else {
            this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
          }
        } else {
          this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), newSecond, currentTime.getMilliseconds());
        }
      }

      event.preventDefault();
    }
  }, {
    key: "incrementMilliSecond",
    value: function incrementMilliSecond(event) {
      var currentTime = this.getCurrentDateTime();
      var currentMillisecond = currentTime.getMilliseconds();
      var newMillisecond = currentMillisecond + this.props.stepMillisec;
      newMillisecond = newMillisecond > 999 ? newMillisecond - 1000 : newMillisecond;

      if (this.validateMillisecond(newMillisecond, currentTime)) {
        this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), currentTime.getSeconds(), newMillisecond);
      }

      event.preventDefault();
    }
  }, {
    key: "decrementMilliSecond",
    value: function decrementMilliSecond(event) {
      var currentTime = this.getCurrentDateTime();
      var currentMillisecond = currentTime.getMilliseconds();
      var newMillisecond = currentMillisecond - this.props.stepMillisec;
      newMillisecond = newMillisecond < 0 ? newMillisecond + 999 : newMillisecond;

      if (this.validateMillisecond(newMillisecond, currentTime)) {
        this.updateTime(event, currentTime.getHours(), currentTime.getMinutes(), currentTime.getSeconds(), newMillisecond);
      }

      event.preventDefault();
    }
  }, {
    key: "toggleAmPm",
    value: function toggleAmPm(event) {
      var currentTime = this.getCurrentDateTime();
      var currentHour = currentTime.getHours();
      var newHour = currentHour >= 12 ? currentHour - 12 : currentHour + 12;
      this.updateTime(event, newHour, currentTime.getMinutes(), currentTime.getSeconds(), currentTime.getMilliseconds());
      event.preventDefault();
    }
  }, {
    key: "getViewDate",
    value: function getViewDate() {
      return this.props.onViewDateChange ? this.props.viewDate : this.state.viewDate;
    }
  }, {
    key: "getCurrentDateTime",
    value: function getCurrentDateTime() {
      if (this.isSingleSelection()) {
        return this.props.value && this.props.value instanceof Date ? this.props.value : this.getViewDate();
      } else if (this.isMultipleSelection()) {
        if (this.props.value && this.props.value.length) {
          return this.props.value[this.props.value.length - 1];
        }
      } else if (this.isRangeSelection()) {
        if (this.props.value && this.props.value.length) {
          var startDate = this.props.value[0];
          var endDate = this.props.value[1];
          return endDate || startDate;
        }
      }

      return new Date();
    }
  }, {
    key: "isValidDate",
    value: function isValidDate(date) {
      return date instanceof Date && !isNaN(date);
    }
  }, {
    key: "validateHour",
    value: function validateHour(hour, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;

      if (this.props.minDate && valueDateString && this.props.minDate.toDateString() === valueDateString) {
        if (this.props.minDate.getHours() > hour) {
          valid = false;
        }
      }

      if (this.props.maxDate && valueDateString && this.props.maxDate.toDateString() === valueDateString) {
        if (this.props.maxDate.getHours() < hour) {
          valid = false;
        }
      }

      return valid;
    }
  }, {
    key: "validateMinute",
    value: function validateMinute(minute, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;

      if (this.props.minDate && valueDateString && this.props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === this.props.minDate.getHours()) {
          if (this.props.minDate.getMinutes() > minute) {
            valid = false;
          }
        }
      }

      if (this.props.maxDate && valueDateString && this.props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === this.props.maxDate.getHours()) {
          if (this.props.maxDate.getMinutes() < minute) {
            valid = false;
          }
        }
      }

      return valid;
    }
  }, {
    key: "validateSecond",
    value: function validateSecond(second, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;

      if (this.props.minDate && valueDateString && this.props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === this.props.minDate.getHours() && value.getMinutes() === this.props.minDate.getMinutes()) {
          if (this.props.minDate.getSeconds() > second) {
            valid = false;
          }
        }
      }

      if (this.props.maxDate && valueDateString && this.props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === this.props.maxDate.getHours() && value.getMinutes() === this.props.maxDate.getMinutes()) {
          if (this.props.maxDate.getSeconds() < second) {
            valid = false;
          }
        }
      }

      return valid;
    }
  }, {
    key: "validateMillisecond",
    value: function validateMillisecond(millisecond, value) {
      var valid = true;
      var valueDateString = value ? value.toDateString() : null;

      if (this.props.minDate && valueDateString && this.props.minDate.toDateString() === valueDateString) {
        if (value.getHours() === this.props.minDate.getHours() && value.getSeconds() === this.props.minDate.getSeconds() && value.getMinutes() === this.props.minDate.getMinutes()) {
          if (this.props.minDate.getMilliseconds() > millisecond) {
            valid = false;
          }
        }
      }

      if (this.props.maxDate && valueDateString && this.props.maxDate.toDateString() === valueDateString) {
        if (value.getHours() === this.props.maxDate.getHours() && value.getSeconds() === this.props.maxDate.getSeconds() && value.getMinutes() === this.props.maxDate.getMinutes()) {
          if (this.props.maxDate.getMilliseconds() < millisecond) {
            valid = false;
          }
        }
      }

      return valid;
    }
  }, {
    key: "validateDate",
    value: function validateDate(value) {
      if (this.props.yearNavigator) {
        var viewYear = value.getFullYear();
        var minRangeYear = this.props.yearRange ? parseInt(this.props.yearRange.split(':')[0], 10) : null;
        var maxRangeYear = this.props.yearRange ? parseInt(this.props.yearRange.split(':')[1], 10) : null;
        var minYear = this.props.minDate && minRangeYear != null ? Math.max(this.props.minDate.getFullYear(), minRangeYear) : this.props.minDate || minRangeYear;
        var maxYear = this.props.maxDate && maxRangeYear != null ? Math.min(this.props.maxDate.getFullYear(), maxRangeYear) : this.props.maxDate || maxRangeYear;

        if (minYear && minYear > viewYear) {
          viewYear = minYear;
        }

        if (maxYear && maxYear < viewYear) {
          viewYear = maxYear;
        }

        value.setFullYear(viewYear);
      }

      if (this.props.monthNavigator && this.props.view !== 'month') {
        var viewMonth = value.getMonth();
        var viewMonthWithMinMax = parseInt(this.isInMinYear(value) && Math.max(this.props.minDate.getMonth(), viewMonth).toString() || this.isInMaxYear(value) && Math.min(this.props.maxDate.getMonth(), viewMonth).toString() || viewMonth);
        value.setMonth(viewMonthWithMinMax);
      }
    }
  }, {
    key: "updateTime",
    value: function updateTime(event, hour, minute, second, millisecond) {
      var newDateTime = this.getCurrentDateTime();
      newDateTime.setHours(hour);
      newDateTime.setMinutes(minute);
      newDateTime.setSeconds(second);
      newDateTime.setMilliseconds(millisecond);

      if (this.isMultipleSelection()) {
        if (this.props.value && this.props.value.length) {
          var value = _toConsumableArray(this.props.value);

          value[value.length - 1] = newDateTime;
          newDateTime = value;
        } else {
          newDateTime = [newDateTime];
        }
      } else if (this.isRangeSelection()) {
        if (this.props.value && this.props.value.length) {
          var startDate = this.props.value[0];
          var endDate = this.props.value[1];
          newDateTime = endDate ? [startDate, newDateTime] : [newDateTime, null];
        } else {
          newDateTime = [newDateTime, null];
        }
      }

      this.updateModel(event, newDateTime);

      if (this.props.onSelect) {
        this.props.onSelect({
          originalEvent: event,
          value: newDateTime
        });
      }

      this.updateInputfield(newDateTime);
    }
  }, {
    key: "updateViewDate",
    value: function updateViewDate(event, value) {
      this.validateDate(value);

      if (this.props.onViewDateChange) {
        this.props.onViewDateChange({
          originalEvent: event,
          value: value
        });
      } else {
        this.viewStateChanged = true;
        this.setState({
          viewDate: value
        });
      }
    }
  }, {
    key: "onDateCellKeydown",
    value: function onDateCellKeydown(event, date, groupIndex) {
      var cellContent = event.currentTarget;
      var cell = cellContent.parentElement;

      switch (event.which) {
        //down arrow
        case 40:
          {
            cellContent.tabIndex = '-1';
            var cellIndex = DomHandler.index(cell);
            var nextRow = cell.parentElement.nextElementSibling;

            if (nextRow) {
              var focusCell = nextRow.children[cellIndex].children[0];

              if (DomHandler.hasClass(focusCell, 'p-disabled')) {
                this.navigation = {
                  backward: false
                };
                this.navForward(event);
              } else {
                nextRow.children[cellIndex].children[0].tabIndex = '0';
                nextRow.children[cellIndex].children[0].focus();
              }
            } else {
              this.navigation = {
                backward: false
              };
              this.navForward(event);
            }

            event.preventDefault();
            break;
          }
        //up arrow

        case 38:
          {
            cellContent.tabIndex = '-1';

            var _cellIndex = DomHandler.index(cell);

            var prevRow = cell.parentElement.previousElementSibling;

            if (prevRow) {
              var _focusCell = prevRow.children[_cellIndex].children[0];

              if (DomHandler.hasClass(_focusCell, 'p-disabled')) {
                this.navigation = {
                  backward: true
                };
                this.navBackward(event);
              } else {
                _focusCell.tabIndex = '0';

                _focusCell.focus();
              }
            } else {
              this.navigation = {
                backward: true
              };
              this.navBackward(event);
            }

            event.preventDefault();
            break;
          }
        //left arrow

        case 37:
          {
            cellContent.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;

            if (prevCell) {
              var _focusCell2 = prevCell.children[0];

              if (DomHandler.hasClass(_focusCell2, 'p-disabled')) {
                this.navigateToMonth(true, groupIndex, event);
              } else {
                _focusCell2.tabIndex = '0';

                _focusCell2.focus();
              }
            } else {
              this.navigateToMonth(true, groupIndex, event);
            }

            event.preventDefault();
            break;
          }
        //right arrow

        case 39:
          {
            cellContent.tabIndex = '-1';
            var nextCell = cell.nextElementSibling;

            if (nextCell) {
              var _focusCell3 = nextCell.children[0];

              if (DomHandler.hasClass(_focusCell3, 'p-disabled')) {
                this.navigateToMonth(false, groupIndex, event);
              } else {
                _focusCell3.tabIndex = '0';

                _focusCell3.focus();
              }
            } else {
              this.navigateToMonth(false, groupIndex, event);
            }

            event.preventDefault();
            break;
          }
        //enter

        case 13:
          {
            this.onDateSelect(event, date);
            event.preventDefault();
            break;
          }
        //escape

        case 27:
          {
            this.hideOverlay(null, this.reFocusInputField);
            event.preventDefault();
            break;
          }
        //tab

        case 9:
          {
            this.trapFocus(event);
            break;
          }
      }
    }
  }, {
    key: "navigateToMonth",
    value: function navigateToMonth(prev, groupIndex, event) {
      if (prev) {
        if (this.props.numberOfMonths === 1 || groupIndex === 0) {
          this.navigation = {
            backward: true
          };
          this.navBackward(event);
        } else {
          var prevMonthContainer = this.overlayRef.current.children[groupIndex - 1];
          var cells = DomHandler.find(prevMonthContainer, '.p-datepicker-calendar td span:not(.p-disabled)');
          var focusCell = cells[cells.length - 1];
          focusCell.tabIndex = '0';
          focusCell.focus();
        }
      } else {
        if (this.props.numberOfMonths === 1 || groupIndex === this.props.numberOfMonths - 1) {
          this.navigation = {
            backward: false
          };
          this.navForward(event);
        } else {
          var nextMonthContainer = this.overlayRef.current.children[groupIndex + 1];

          var _focusCell4 = DomHandler.findSingle(nextMonthContainer, '.p-datepicker-calendar td span:not(.p-disabled)');

          _focusCell4.tabIndex = '0';

          _focusCell4.focus();
        }
      }
    }
  }, {
    key: "onMonthCellKeydown",
    value: function onMonthCellKeydown(event, index) {
      var cell = event.currentTarget;

      switch (event.which) {
        //arrows
        case 38:
        case 40:
          {
            cell.tabIndex = '-1';
            var cells = cell.parentElement.children;
            var cellIndex = DomHandler.index(cell);
            var nextCell = cells[event.which === 40 ? cellIndex + 3 : cellIndex - 3];

            if (nextCell) {
              nextCell.tabIndex = '0';
              nextCell.focus();
            }

            event.preventDefault();
            break;
          }
        //left arrow

        case 37:
          {
            cell.tabIndex = '-1';
            var prevCell = cell.previousElementSibling;

            if (prevCell) {
              prevCell.tabIndex = '0';
              prevCell.focus();
            }

            event.preventDefault();
            break;
          }
        //right arrow

        case 39:
          {
            cell.tabIndex = '-1';
            var _nextCell = cell.nextElementSibling;

            if (_nextCell) {
              _nextCell.tabIndex = '0';

              _nextCell.focus();
            }

            event.preventDefault();
            break;
          }
        //enter

        case 13:
          {
            this.onMonthSelect(event, index);
            event.preventDefault();
            break;
          }
        //escape

        case 27:
          {
            this.hideOverlay(null, this.reFocusInputField);
            event.preventDefault();
            break;
          }
        //tab

        case 9:
          {
            this.trapFocus(event);
            break;
          }
      }
    }
  }, {
    key: "onDateSelect",
    value: function onDateSelect(event, dateMeta, timeMeta) {
      var _this9 = this;

      if (this.props.disabled || !dateMeta.selectable) {
        event.preventDefault();
        return;
      }

      DomHandler.find(this.overlayRef.current, '.p-datepicker-calendar td span:not(.p-disabled)').forEach(function (cell) {
        return cell.tabIndex = -1;
      });
      event.currentTarget.focus();

      if (this.isMultipleSelection()) {
        if (this.isSelected(dateMeta)) {
          var value = this.props.value.filter(function (date, i) {
            return !_this9.isDateEquals(date, dateMeta);
          });
          this.updateModel(event, value);
          this.updateInputfield(value);
        } else if (!this.props.maxDateCount || !this.props.value || this.props.maxDateCount > this.props.value.length) {
          this.selectDate(event, dateMeta, timeMeta);
        }
      } else {
        this.selectDate(event, dateMeta, timeMeta);
      }

      if (!this.props.inline && this.isSingleSelection() && (!this.props.showTime || this.props.hideOnDateTimeSelect)) {
        setTimeout(function () {
          _this9.hideOverlay('dateselect');
        }, 100);

        if (this.touchUIMask) {
          this.disableModality();
        }
      }

      event.preventDefault();
    }
  }, {
    key: "selectTime",
    value: function selectTime(date, timeMeta) {
      if (this.props.showTime) {
        var hours, minutes, seconds, milliseconds;

        if (timeMeta) {
          hours = timeMeta.hours;
          minutes = timeMeta.minutes;
          seconds = timeMeta.seconds;
          milliseconds = timeMeta.milliseconds;
        } else {
          var time = this.getCurrentDateTime();
          var _ref = [time.getHours(), time.getMinutes(), time.getSeconds(), time.getMilliseconds()];
          hours = _ref[0];
          minutes = _ref[1];
          seconds = _ref[2];
          milliseconds = _ref[3];
        }

        date.setHours(hours);
        date.setMinutes(minutes);
        date.setSeconds(seconds);
        date.setMilliseconds(milliseconds);
      }
    }
  }, {
    key: "selectDate",
    value: function selectDate(event, dateMeta, timeMeta) {
      var date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
      this.selectTime(date, timeMeta);

      if (this.props.minDate && this.props.minDate > date) {
        date = this.props.minDate;
      }

      if (this.props.maxDate && this.props.maxDate < date) {
        date = this.props.maxDate;
      }

      var selectedValues = date;

      if (this.isSingleSelection()) {
        this.updateModel(event, date);
      } else if (this.isMultipleSelection()) {
        selectedValues = this.props.value ? [].concat(_toConsumableArray(this.props.value), [date]) : [date];
        this.updateModel(event, selectedValues);
      } else if (this.isRangeSelection()) {
        if (this.props.value && this.props.value.length) {
          var startDate = this.props.value[0];
          var endDate = this.props.value[1];

          if (!endDate && date.getTime() >= startDate.getTime()) {
            endDate = date;
          } else {
            startDate = date;
            endDate = null;
          }

          selectedValues = [startDate, endDate];
          this.updateModel(event, selectedValues);
        } else {
          selectedValues = [date, null];
          this.updateModel(event, selectedValues);
        }
      }

      if (this.props.onSelect) {
        this.props.onSelect({
          originalEvent: event,
          value: date
        });
      }

      this.updateInputfield(selectedValues);
    }
  }, {
    key: "onMonthSelect",
    value: function onMonthSelect(event, month) {
      this.onDateSelect(event, {
        year: this.getViewDate().getFullYear(),
        month: month,
        day: 1,
        selectable: true
      });
      event.preventDefault();
    }
  }, {
    key: "updateModel",
    value: function updateModel(event, value) {
      if (this.props.onChange) {
        var newValue = value && value instanceof Date ? new Date(value.getTime()) : value;
        this.viewStateChanged = true;
        this.props.onChange({
          originalEvent: event,
          value: newValue,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: newValue
          }
        });
      }
    }
  }, {
    key: "showOverlay",
    value: function showOverlay(type) {
      var _this10 = this;

      if (this.props.onVisibleChange) {
        this.props.onVisibleChange({
          visible: true,
          type: type
        });
      } else {
        this.setState({
          overlayVisible: true
        }, function () {
          _this10.overlayEventListener = function (e) {
            if (!_this10.isOutsideClicked(e.target)) {
              _this10.isOverlayClicked = true;
            }
          };

          OverlayService.on('overlay-click', _this10.overlayEventListener);
        });
      }
    }
  }, {
    key: "hideOverlay",
    value: function hideOverlay(type, callback) {
      var _this11 = this;

      var _hideCallback = function _hideCallback() {
        _this11.viewStateChanged = false;
        _this11.ignoreFocusFunctionality = false;
        _this11.isOverlayClicked = false;

        if (callback) {
          callback();
        }

        OverlayService.off('overlay-click', _this11.overlayEventListener);
        _this11.overlayEventListener = null;
      };

      if (this.props.onVisibleChange) this.props.onVisibleChange({
        visible: false,
        type: type,
        callback: _hideCallback
      });else this.setState({
        overlayVisible: false
      }, _hideCallback);
    }
  }, {
    key: "onOverlayEnter",
    value: function onOverlayEnter() {
      if (this.props.autoZIndex) {
        ZIndexUtils.set(this.props.touchUI ? 'modal' : 'overlay', this.overlayRef.current, this.props.baseZIndex);
      }

      this.alignOverlay();
    }
  }, {
    key: "onOverlayEntered",
    value: function onOverlayEntered() {
      this.bindDocumentClickListener();
      this.bindDocumentResizeListener();
      this.bindScrollListener();
      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onOverlayExit",
    value: function onOverlayExit() {
      this.unbindDocumentClickListener();
      this.unbindDocumentResizeListener();
      this.unbindScrollListener();
    }
  }, {
    key: "onOverlayExited",
    value: function onOverlayExited() {
      ZIndexUtils.clear(this.overlayRef.current);
      this.props.onHide && this.props.onHide();
    }
  }, {
    key: "bindDocumentClickListener",
    value: function bindDocumentClickListener() {
      var _this12 = this;

      if (!this.documentClickListener) {
        this.documentClickListener = function (event) {
          if (!_this12.isOverlayClicked && _this12.isVisible() && _this12.isOutsideClicked(event.target)) {
            _this12.hideOverlay('outside');
          }

          _this12.isOverlayClicked = false;
        };

        document.addEventListener('click', this.documentClickListener);
      }
    }
  }, {
    key: "unbindDocumentClickListener",
    value: function unbindDocumentClickListener() {
      if (this.documentClickListener) {
        document.removeEventListener('click', this.documentClickListener);
        this.documentClickListener = null;
      }
    }
  }, {
    key: "bindDocumentResizeListener",
    value: function bindDocumentResizeListener() {
      if (!this.documentResizeListener && !this.props.touchUI) {
        this.documentResizeListener = this.onWindowResize.bind(this);
        window.addEventListener('resize', this.documentResizeListener);
      }
    }
  }, {
    key: "unbindDocumentResizeListener",
    value: function unbindDocumentResizeListener() {
      if (this.documentResizeListener) {
        window.removeEventListener('resize', this.documentResizeListener);
        this.documentResizeListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this13 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.container, function () {
          if (_this13.isVisible()) {
            _this13.hideOverlay();
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(target) {
      return this.container && !(this.container.isSameNode(target) || this.isNavIconClicked(target) || this.container.contains(target) || this.overlayRef && this.overlayRef.current.contains(target));
    }
  }, {
    key: "isNavIconClicked",
    value: function isNavIconClicked(target) {
      return DomHandler.hasClass(target, 'p-datepicker-prev') || DomHandler.hasClass(target, 'p-datepicker-prev-icon') || DomHandler.hasClass(target, 'p-datepicker-next') || DomHandler.hasClass(target, 'p-datepicker-next-icon');
    }
  }, {
    key: "onWindowResize",
    value: function onWindowResize() {
      if (this.isVisible() && !DomHandler.isAndroid()) {
        this.hideOverlay();
      }
    }
  }, {
    key: "alignOverlay",
    value: function alignOverlay() {
      if (this.props.touchUI) {
        this.enableModality();
      } else {
        DomHandler.alignOverlay(this.overlayRef.current, this.inputRef.current.parentElement, this.props.appendTo || PrimeReact.appendTo);
      }
    }
  }, {
    key: "enableModality",
    value: function enableModality() {
      var _this14 = this;

      if (!this.touchUIMask) {
        this.touchUIMask = document.createElement('div');
        this.touchUIMask.style.zIndex = String(ZIndexUtils.get(this.overlayRef.current) - 1);
        DomHandler.addMultipleClasses(this.touchUIMask, 'p-component-overlay p-datepicker-mask p-datepicker-mask-scrollblocker p-component-overlay-enter');

        this.touchUIMaskClickListener = function () {
          _this14.disableModality();
        };

        this.touchUIMask.addEventListener('click', this.touchUIMaskClickListener);
        document.body.appendChild(this.touchUIMask);
        DomHandler.addClass(document.body, 'p-overflow-hidden');
      }
    }
  }, {
    key: "disableModality",
    value: function disableModality() {
      var _this15 = this;

      if (this.touchUIMask) {
        DomHandler.addClass(this.touchUIMask, 'p-component-overlay-leave');
        this.touchUIMask.addEventListener('animationend', function () {
          _this15.destroyMask();
        });
      }
    }
  }, {
    key: "destroyMask",
    value: function destroyMask() {
      this.touchUIMask.removeEventListener('click', this.touchUIMaskClickListener);
      this.touchUIMaskClickListener = null;
      document.body.removeChild(this.touchUIMask);
      this.touchUIMask = null;
      var bodyChildren = document.body.children;
      var hasBlockerMasks;

      for (var i = 0; i < bodyChildren.length; i++) {
        var bodyChild = bodyChildren[i];

        if (DomHandler.hasClass(bodyChild, 'p-datepicker-mask-scrollblocker')) {
          hasBlockerMasks = true;
          break;
        }
      }

      if (!hasBlockerMasks) {
        DomHandler.removeClass(document.body, 'p-overflow-hidden');
      }
    }
  }, {
    key: "getFirstDayOfMonthIndex",
    value: function getFirstDayOfMonthIndex(month, year) {
      var day = new Date();
      day.setDate(1);
      day.setMonth(month);
      day.setFullYear(year);
      var dayIndex = day.getDay() + this.getSundayIndex();
      return dayIndex >= 7 ? dayIndex - 7 : dayIndex;
    }
  }, {
    key: "getDaysCountInMonth",
    value: function getDaysCountInMonth(month, year) {
      return 32 - this.daylightSavingAdjust(new Date(year, month, 32)).getDate();
    }
  }, {
    key: "getDaysCountInPrevMonth",
    value: function getDaysCountInPrevMonth(month, year) {
      var prev = this.getPreviousMonthAndYear(month, year);
      return this.getDaysCountInMonth(prev.month, prev.year);
    }
  }, {
    key: "daylightSavingAdjust",
    value: function daylightSavingAdjust(date) {
      if (!date) {
        return null;
      }

      date.setHours(date.getHours() > 12 ? date.getHours() + 2 : 0);
      return date;
    }
  }, {
    key: "getPreviousMonthAndYear",
    value: function getPreviousMonthAndYear(month, year) {
      var m, y;

      if (month === 0) {
        m = 11;
        y = year - 1;
      } else {
        m = month - 1;
        y = year;
      }

      return {
        'month': m,
        'year': y
      };
    }
  }, {
    key: "getNextMonthAndYear",
    value: function getNextMonthAndYear(month, year) {
      var m, y;

      if (month === 11) {
        m = 0;
        y = year + 1;
      } else {
        m = month + 1;
        y = year;
      }

      return {
        'month': m,
        'year': y
      };
    }
  }, {
    key: "getSundayIndex",
    value: function getSundayIndex() {
      var firstDayOfWeek = localeOption('firstDayOfWeek', this.props.locale);
      return firstDayOfWeek > 0 ? 7 - firstDayOfWeek : 0;
    }
  }, {
    key: "createWeekDays",
    value: function createWeekDays() {
      var weekDays = [];

      var _localeOptions = localeOptions(this.props.locale),
          dayIndex = _localeOptions.firstDayOfWeek,
          dayNamesMin = _localeOptions.dayNamesMin;

      for (var i = 0; i < 7; i++) {
        weekDays.push(dayNamesMin[dayIndex]);
        dayIndex = dayIndex === 6 ? 0 : ++dayIndex;
      }

      return weekDays;
    }
  }, {
    key: "createMonths",
    value: function createMonths(month, year) {
      var months = [];

      for (var i = 0; i < this.props.numberOfMonths; i++) {
        var m = month + i;
        var y = year;

        if (m > 11) {
          m = m % 11 - 1;
          y = year + 1;
        }

        months.push(this.createMonth(m, y));
      }

      return months;
    }
  }, {
    key: "createMonth",
    value: function createMonth(month, year) {
      var dates = [];
      var firstDay = this.getFirstDayOfMonthIndex(month, year);
      var daysLength = this.getDaysCountInMonth(month, year);
      var prevMonthDaysLength = this.getDaysCountInPrevMonth(month, year);
      var dayNo = 1;
      var today = new Date();
      var weekNumbers = [];
      var monthRows = Math.ceil((daysLength + firstDay) / 7);

      for (var i = 0; i < monthRows; i++) {
        var week = [];

        if (i === 0) {
          for (var j = prevMonthDaysLength - firstDay + 1; j <= prevMonthDaysLength; j++) {
            var prev = this.getPreviousMonthAndYear(month, year);
            week.push({
              day: j,
              month: prev.month,
              year: prev.year,
              otherMonth: true,
              today: this.isToday(today, j, prev.month, prev.year),
              selectable: this.isSelectable(j, prev.month, prev.year, true)
            });
          }

          var remainingDaysLength = 7 - week.length;

          for (var _j = 0; _j < remainingDaysLength; _j++) {
            week.push({
              day: dayNo,
              month: month,
              year: year,
              today: this.isToday(today, dayNo, month, year),
              selectable: this.isSelectable(dayNo, month, year, false)
            });
            dayNo++;
          }
        } else {
          for (var _j2 = 0; _j2 < 7; _j2++) {
            if (dayNo > daysLength) {
              var next = this.getNextMonthAndYear(month, year);
              week.push({
                day: dayNo - daysLength,
                month: next.month,
                year: next.year,
                otherMonth: true,
                today: this.isToday(today, dayNo - daysLength, next.month, next.year),
                selectable: this.isSelectable(dayNo - daysLength, next.month, next.year, true)
              });
            } else {
              week.push({
                day: dayNo,
                month: month,
                year: year,
                today: this.isToday(today, dayNo, month, year),
                selectable: this.isSelectable(dayNo, month, year, false)
              });
            }

            dayNo++;
          }
        }

        if (this.props.showWeek) {
          weekNumbers.push(this.getWeekNumber(new Date(week[0].year, week[0].month, week[0].day)));
        }

        dates.push(week);
      }

      return {
        month: month,
        year: year,
        dates: dates,
        weekNumbers: weekNumbers
      };
    }
  }, {
    key: "getWeekNumber",
    value: function getWeekNumber(date) {
      var checkDate = new Date(date.getTime());
      checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7));
      var time = checkDate.getTime();
      checkDate.setMonth(0);
      checkDate.setDate(1);
      return Math.floor(Math.round((time - checkDate.getTime()) / 86400000) / 7) + 1;
    }
  }, {
    key: "isSelectable",
    value: function isSelectable(day, month, year, otherMonth) {
      var validMin = true;
      var validMax = true;
      var validDate = true;
      var validDay = true;
      var validMonth = true;

      if (this.props.minDate) {
        if (this.props.minDate.getFullYear() > year) {
          validMin = false;
        } else if (this.props.minDate.getFullYear() === year) {
          if (this.props.minDate.getMonth() > month) {
            validMin = false;
          } else if (this.props.minDate.getMonth() === month) {
            if (this.props.minDate.getDate() > day) {
              validMin = false;
            }
          }
        }
      }

      if (this.props.maxDate) {
        if (this.props.maxDate.getFullYear() < year) {
          validMax = false;
        } else if (this.props.maxDate.getFullYear() === year) {
          if (this.props.maxDate.getMonth() < month) {
            validMax = false;
          } else if (this.props.maxDate.getMonth() === month) {
            if (this.props.maxDate.getDate() < day) {
              validMax = false;
            }
          }
        }
      }

      if (this.props.disabledDates) {
        validDate = !this.isDateDisabled(day, month, year);
      }

      if (this.props.disabledDays) {
        validDay = !this.isDayDisabled(day, month, year);
      }

      if (this.props.selectOtherMonths === false && otherMonth) {
        validMonth = false;
      }

      return validMin && validMax && validDate && validDay && validMonth;
    }
  }, {
    key: "isSelectableTime",
    value: function isSelectableTime(value) {
      var validMin = true;
      var validMax = true;

      if (this.props.minDate && this.props.minDate.toDateString() === value.toDateString()) {
        if (this.props.minDate.getHours() > value.getHours()) {
          validMin = false;
        } else if (this.props.minDate.getHours() === value.getHours()) {
          if (this.props.minDate.getMinutes() > value.getMinutes()) {
            validMin = false;
          } else if (this.props.minDate.getMinutes() === value.getMinutes()) {
            if (this.props.minDate.getSeconds() > value.getSeconds()) {
              validMin = false;
            } else if (this.props.minDate.getSeconds() === value.getSeconds()) {
              if (this.props.minDate.getMilliseconds() > value.getMilliseconds()) {
                validMin = false;
              }
            }
          }
        }
      }

      if (this.props.maxDate && this.props.maxDate.toDateString() === value.toDateString()) {
        if (this.props.maxDate.getHours() < value.getHours()) {
          validMax = false;
        } else if (this.props.maxDate.getHours() === value.getHours()) {
          if (this.props.maxDate.getMinutes() < value.getMinutes()) {
            validMax = false;
          } else if (this.props.maxDate.getMinutes() === value.getMinutes()) {
            if (this.props.maxDate.getSeconds() < value.getSeconds()) {
              validMax = false;
            } else if (this.props.maxDate.getSeconds() === value.getSeconds()) {
              if (this.props.maxDate.getMilliseconds() < value.getMilliseconds()) {
                validMax = false;
              }
            }
          }
        }
      }

      return validMin && validMax;
    }
  }, {
    key: "isSelected",
    value: function isSelected(dateMeta) {
      if (this.props.value) {
        if (this.isSingleSelection()) {
          return this.isDateEquals(this.props.value, dateMeta);
        } else if (this.isMultipleSelection()) {
          var selected = false;

          var _iterator = _createForOfIteratorHelper$g(this.props.value),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var date = _step.value;
              selected = this.isDateEquals(date, dateMeta);

              if (selected) {
                break;
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          return selected;
        } else if (this.isRangeSelection()) {
          if (this.props.value[1]) return this.isDateEquals(this.props.value[0], dateMeta) || this.isDateEquals(this.props.value[1], dateMeta) || this.isDateBetween(this.props.value[0], this.props.value[1], dateMeta);else {
            return this.isDateEquals(this.props.value[0], dateMeta);
          }
        }
      } else {
        return false;
      }
    }
  }, {
    key: "isMonthSelected",
    value: function isMonthSelected(month) {
      var viewDate = this.getViewDate();
      if (this.props.value && this.props.value instanceof Date) return this.props.value.getDate() === 1 && this.props.value.getMonth() === month && this.props.value.getFullYear() === viewDate.getFullYear();else return false;
    }
  }, {
    key: "isDateEquals",
    value: function isDateEquals(value, dateMeta) {
      if (value && value instanceof Date) return value.getDate() === dateMeta.day && value.getMonth() === dateMeta.month && value.getFullYear() === dateMeta.year;else return false;
    }
  }, {
    key: "isDateBetween",
    value: function isDateBetween(start, end, dateMeta) {
      var between = false;

      if (start && end) {
        var date = new Date(dateMeta.year, dateMeta.month, dateMeta.day);
        return start.getTime() <= date.getTime() && end.getTime() >= date.getTime();
      }

      return between;
    }
  }, {
    key: "isSingleSelection",
    value: function isSingleSelection() {
      return this.props.selectionMode === 'single';
    }
  }, {
    key: "isRangeSelection",
    value: function isRangeSelection() {
      return this.props.selectionMode === 'range';
    }
  }, {
    key: "isMultipleSelection",
    value: function isMultipleSelection() {
      return this.props.selectionMode === 'multiple';
    }
  }, {
    key: "isToday",
    value: function isToday(today, day, month, year) {
      return today.getDate() === day && today.getMonth() === month && today.getFullYear() === year;
    }
  }, {
    key: "isDateDisabled",
    value: function isDateDisabled(day, month, year) {
      if (this.props.disabledDates) {
        for (var i = 0; i < this.props.disabledDates.length; i++) {
          var disabledDate = this.props.disabledDates[i];

          if (disabledDate.getFullYear() === year && disabledDate.getMonth() === month && disabledDate.getDate() === day) {
            return true;
          }
        }
      }

      return false;
    }
  }, {
    key: "isDayDisabled",
    value: function isDayDisabled(day, month, year) {
      if (this.props.disabledDays) {
        var weekday = new Date(year, month, day);
        var weekdayNumber = weekday.getDay();
        return this.props.disabledDays.indexOf(weekdayNumber) !== -1;
      }

      return false;
    }
  }, {
    key: "updateInputfield",
    value: function updateInputfield(value) {
      if (!(this.inputRef && this.inputRef.current)) {
        return;
      }

      var formattedValue = '';

      if (value) {
        try {
          if (this.isSingleSelection()) {
            formattedValue = this.isValidDate(value) ? this.formatDateTime(value) : '';
          } else if (this.isMultipleSelection()) {
            for (var i = 0; i < value.length; i++) {
              var selectedValue = value[i];
              var dateAsString = this.isValidDate(selectedValue) ? this.formatDateTime(selectedValue) : '';
              formattedValue += dateAsString;

              if (i !== value.length - 1) {
                formattedValue += ', ';
              }
            }
          } else if (this.isRangeSelection()) {
            if (value && value.length) {
              var startDate = value[0];
              var endDate = value[1];
              formattedValue = this.isValidDate(startDate) ? this.formatDateTime(startDate) : '';

              if (endDate) {
                formattedValue += this.isValidDate(endDate) ? ' - ' + this.formatDateTime(endDate) : '';
              }
            }
          }
        } catch (err) {
          formattedValue = value;
        }
      }

      this.inputRef.current.value = formattedValue;
    }
  }, {
    key: "formatDateTime",
    value: function formatDateTime(date) {
      var formattedValue = null;

      if (date) {
        if (this.props.timeOnly) {
          formattedValue = this.formatTime(date);
        } else {
          formattedValue = this.formatDate(date, this.getDateFormat());

          if (this.props.showTime) {
            formattedValue += ' ' + this.formatTime(date);
          }
        }
      }

      return formattedValue;
    }
  }, {
    key: "formatDate",
    value: function formatDate(date, format) {
      if (!date) {
        return '';
      }

      var iFormat;

      var lookAhead = function lookAhead(match) {
        var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;

        if (matches) {
          iFormat++;
        }

        return matches;
      },
          formatNumber = function formatNumber(match, value, len) {
        var num = '' + value;

        if (lookAhead(match)) {
          while (num.length < len) {
            num = '0' + num;
          }
        }

        return num;
      },
          formatName = function formatName(match, value, shortNames, longNames) {
        return lookAhead(match) ? longNames[value] : shortNames[value];
      };

      var output = '';
      var literal = false;

      var _localeOptions2 = localeOptions(this.props.locale),
          dayNamesShort = _localeOptions2.dayNamesShort,
          dayNames = _localeOptions2.dayNames,
          monthNamesShort = _localeOptions2.monthNamesShort,
          monthNames = _localeOptions2.monthNames;

      if (date) {
        for (iFormat = 0; iFormat < format.length; iFormat++) {
          if (literal) {
            if (format.charAt(iFormat) === '\'' && !lookAhead('\'')) {
              literal = false;
            } else {
              output += format.charAt(iFormat);
            }
          } else {
            switch (format.charAt(iFormat)) {
              case 'd':
                output += formatNumber('d', date.getDate(), 2);
                break;

              case 'D':
                output += formatName('D', date.getDay(), dayNamesShort, dayNames);
                break;

              case 'o':
                output += formatNumber('o', Math.round((new Date(date.getFullYear(), date.getMonth(), date.getDate()).getTime() - new Date(date.getFullYear(), 0, 0).getTime()) / 86400000), 3);
                break;

              case 'm':
                output += formatNumber('m', date.getMonth() + 1, 2);
                break;

              case 'M':
                output += formatName('M', date.getMonth(), monthNamesShort, monthNames);
                break;

              case 'y':
                output += lookAhead('y') ? date.getFullYear() : (date.getFullYear() % 100 < 10 ? '0' : '') + date.getFullYear() % 100;
                break;

              case '@':
                output += date.getTime();
                break;

              case '!':
                output += date.getTime() * 10000 + this.ticksTo1970;
                break;

              case '\'':
                if (lookAhead('\'')) {
                  output += '\'';
                } else {
                  literal = true;
                }

                break;

              default:
                output += format.charAt(iFormat);
            }
          }
        }
      }

      return output;
    }
  }, {
    key: "formatTime",
    value: function formatTime(date) {
      if (!date) {
        return '';
      }

      var output = '';
      var hours = date.getHours();
      var minutes = date.getMinutes();
      var seconds = date.getSeconds();
      var milliseconds = date.getMilliseconds();

      if (this.props.hourFormat === '12' && hours > 11 && hours !== 12) {
        hours -= 12;
      }

      if (this.props.hourFormat === '12') {
        output += hours === 0 ? 12 : hours < 10 ? '0' + hours : hours;
      } else {
        output += hours < 10 ? '0' + hours : hours;
      }

      output += ':';
      output += minutes < 10 ? '0' + minutes : minutes;

      if (this.props.showSeconds) {
        output += ':';
        output += seconds < 10 ? '0' + seconds : seconds;
      }

      if (this.props.showMillisec) {
        output += '.';
        output += milliseconds < 100 ? (milliseconds < 10 ? '00' : '0') + milliseconds : milliseconds;
      }

      if (this.props.hourFormat === '12') {
        output += date.getHours() > 11 ? ' PM' : ' AM';
      }

      return output;
    }
  }, {
    key: "parseValueFromString",
    value: function parseValueFromString(text) {
      if (!text || text.trim().length === 0) {
        return null;
      }

      var value;

      if (this.isSingleSelection()) {
        value = this.parseDateTime(text);
      } else if (this.isMultipleSelection()) {
        var tokens = text.split(',');
        value = [];

        var _iterator2 = _createForOfIteratorHelper$g(tokens),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var token = _step2.value;
            value.push(this.parseDateTime(token.trim()));
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } else if (this.isRangeSelection()) {
        var _tokens = text.split(' - ');

        value = [];

        for (var i = 0; i < _tokens.length; i++) {
          value[i] = this.parseDateTime(_tokens[i].trim());
        }
      }

      return value;
    }
  }, {
    key: "parseDateTime",
    value: function parseDateTime(text) {
      var date;
      var parts = text.split(' ');

      if (this.props.timeOnly) {
        date = new Date();
        this.populateTime(date, parts[0], parts[1]);
      } else {
        if (this.props.showTime) {
          date = this.parseDate(parts[0], this.getDateFormat());
          this.populateTime(date, parts[1], parts[2]);
        } else {
          date = this.parseDate(text, this.getDateFormat());
        }
      }

      return date;
    }
  }, {
    key: "populateTime",
    value: function populateTime(value, timeString, ampm) {
      if (this.props.hourFormat === '12' && ampm !== 'PM' && ampm !== 'AM') {
        throw new Error('Invalid Time');
      }

      var time = this.parseTime(timeString, ampm);
      value.setHours(time.hour);
      value.setMinutes(time.minute);
      value.setSeconds(time.second);
      value.setMilliseconds(time.millisecond);
    }
  }, {
    key: "parseTime",
    value: function parseTime(value, ampm) {
      value = this.props.showMillisec ? value.replace('.', ':') : value;
      var tokens = value.split(':');
      var validTokenLength = this.props.showSeconds ? 3 : 2;
      validTokenLength = this.props.showMillisec ? validTokenLength + 1 : validTokenLength;

      if (tokens.length !== validTokenLength || tokens[0].length !== 2 || tokens[1].length !== 2 || this.props.showSeconds && tokens[2].length !== 2 || this.props.showMillisec && tokens[3].length !== 3) {
        throw new Error('Invalid time');
      }

      var h = parseInt(tokens[0], 10);
      var m = parseInt(tokens[1], 10);
      var s = this.props.showSeconds ? parseInt(tokens[2], 10) : null;
      var ms = this.props.showMillisec ? parseInt(tokens[3], 10) : null;

      if (isNaN(h) || isNaN(m) || h > 23 || m > 59 || this.props.hourFormat === '12' && h > 12 || this.props.showSeconds && (isNaN(s) || s > 59) || this.props.showMillisec && (isNaN(s) || s > 1000)) {
        throw new Error('Invalid time');
      } else {
        if (this.props.hourFormat === '12' && h !== 12 && ampm === 'PM') {
          h += 12;
        }

        return {
          hour: h,
          minute: m,
          second: s,
          millisecond: ms
        };
      }
    } // Ported from jquery-ui datepicker parseDate

  }, {
    key: "parseDate",
    value: function parseDate(value, format) {
      if (format == null || value == null) {
        throw new Error('Invalid arguments');
      }

      value = _typeof(value) === "object" ? value.toString() : value + "";

      if (value === "") {
        return null;
      }

      var iFormat,
          dim,
          extra,
          iValue = 0,
          shortYearCutoff = typeof this.props.shortYearCutoff !== "string" ? this.props.shortYearCutoff : new Date().getFullYear() % 100 + parseInt(this.props.shortYearCutoff, 10),
          year = -1,
          month = -1,
          day = -1,
          doy = -1,
          literal = false,
          date,
          lookAhead = function lookAhead(match) {
        var matches = iFormat + 1 < format.length && format.charAt(iFormat + 1) === match;

        if (matches) {
          iFormat++;
        }

        return matches;
      },
          getNumber = function getNumber(match) {
        var isDoubled = lookAhead(match),
            size = match === "@" ? 14 : match === "!" ? 20 : match === "y" && isDoubled ? 4 : match === "o" ? 3 : 2,
            minSize = match === "y" ? size : 1,
            digits = new RegExp("^\\d{" + minSize + "," + size + "}"),
            num = value.substring(iValue).match(digits);

        if (!num) {
          throw new Error('Missing number at position ' + iValue);
        }

        iValue += num[0].length;
        return parseInt(num[0], 10);
      },
          getName = function getName(match, shortNames, longNames) {
        var index = -1;
        var arr = lookAhead(match) ? longNames : shortNames;
        var names = [];

        for (var i = 0; i < arr.length; i++) {
          names.push([i, arr[i]]);
        }

        names.sort(function (a, b) {
          return -(a[1].length - b[1].length);
        });

        for (var _i = 0; _i < names.length; _i++) {
          var name = names[_i][1];

          if (value.substr(iValue, name.length).toLowerCase() === name.toLowerCase()) {
            index = names[_i][0];
            iValue += name.length;
            break;
          }
        }

        if (index !== -1) {
          return index + 1;
        } else {
          throw new Error('Unknown name at position ' + iValue);
        }
      },
          checkLiteral = function checkLiteral() {
        if (value.charAt(iValue) !== format.charAt(iFormat)) {
          throw new Error('Unexpected literal at position ' + iValue);
        }

        iValue++;
      };

      if (this.props.view === 'month') {
        day = 1;
      }

      var _localeOptions3 = localeOptions(this.props.locale),
          dayNamesShort = _localeOptions3.dayNamesShort,
          dayNames = _localeOptions3.dayNames,
          monthNamesShort = _localeOptions3.monthNamesShort,
          monthNames = _localeOptions3.monthNames;

      for (iFormat = 0; iFormat < format.length; iFormat++) {
        if (literal) {
          if (format.charAt(iFormat) === "'" && !lookAhead("'")) {
            literal = false;
          } else {
            checkLiteral();
          }
        } else {
          switch (format.charAt(iFormat)) {
            case "d":
              day = getNumber("d");
              break;

            case "D":
              getName("D", dayNamesShort, dayNames);
              break;

            case "o":
              doy = getNumber("o");
              break;

            case "m":
              month = getNumber("m");
              break;

            case "M":
              month = getName("M", monthNamesShort, monthNames);
              break;

            case "y":
              year = getNumber("y");
              break;

            case "@":
              date = new Date(getNumber("@"));
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;

            case "!":
              date = new Date((getNumber("!") - this.ticksTo1970) / 10000);
              year = date.getFullYear();
              month = date.getMonth() + 1;
              day = date.getDate();
              break;

            case "'":
              if (lookAhead("'")) {
                checkLiteral();
              } else {
                literal = true;
              }

              break;

            default:
              checkLiteral();
          }
        }
      }

      if (iValue < value.length) {
        extra = value.substr(iValue);

        if (!/^\s+/.test(extra)) {
          throw new Error('Extra/unparsed characters found in date: ' + extra);
        }
      }

      if (year === -1) {
        year = new Date().getFullYear();
      } else if (year < 100) {
        year += new Date().getFullYear() - new Date().getFullYear() % 100 + (year <= shortYearCutoff ? 0 : -100);
      }

      if (doy > -1) {
        month = 1;
        day = doy;

        do {
          dim = this.getDaysCountInMonth(year, month - 1);

          if (day <= dim) {
            break;
          }

          month++;
          day -= dim;
        } while (true);
      }

      date = this.daylightSavingAdjust(new Date(year, month - 1, day));

      if (date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day) {
        throw new Error('Invalid date'); // E.g. 31/02/00
      }

      return date;
    }
  }, {
    key: "renderBackwardNavigator",
    value: function renderBackwardNavigator(isVisible) {
      var _this16 = this;

      var navigatorProps = isVisible ? {
        'onClick': this.onPrevButtonClick,
        'onKeyDown': function onKeyDown(e) {
          return _this16.onContainerButtonKeydown(e);
        }
      } : {
        'style': {
          visibility: 'hidden'
        }
      };
      return /*#__PURE__*/React__default['default'].createElement("button", _extends({
        type: "button",
        className: "p-datepicker-prev p-link"
      }, navigatorProps), /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-datepicker-prev-icon pi pi-chevron-left"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderForwardNavigator",
    value: function renderForwardNavigator(isVisible) {
      var _this17 = this;

      var navigatorProps = isVisible ? {
        'onClick': this.onNextButtonClick,
        'onKeyDown': function onKeyDown(e) {
          return _this17.onContainerButtonKeydown(e);
        }
      } : {
        'style': {
          visibility: 'hidden'
        }
      };
      return /*#__PURE__*/React__default['default'].createElement("button", _extends({
        type: "button",
        className: "p-datepicker-next p-link"
      }, navigatorProps), /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-datepicker-next-icon pi pi-chevron-right"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "isInMinYear",
    value: function isInMinYear(viewDate) {
      return this.props.minDate && this.props.minDate.getFullYear() === viewDate.getFullYear();
    }
  }, {
    key: "isInMaxYear",
    value: function isInMaxYear(viewDate) {
      return this.props.maxDate && this.props.maxDate.getFullYear() === viewDate.getFullYear();
    }
  }, {
    key: "renderTitleMonthElement",
    value: function renderTitleMonthElement(month) {
      var _this18 = this;

      var monthNames = localeOption('monthNames', this.props.locale);

      if (this.props.monthNavigator && this.props.view !== 'month') {
        var viewDate = this.getViewDate();
        var viewMonth = viewDate.getMonth();
        var displayedMonthOptions = monthNames.map(function (month, index) {
          return (!_this18.isInMinYear(viewDate) || index >= _this18.props.minDate.getMonth()) && (!_this18.isInMaxYear(viewDate) || index <= _this18.props.maxDate.getMonth()) ? {
            label: month,
            value: index,
            index: index
          } : null;
        }).filter(function (option) {
          return !!option;
        });
        var displayedMonthNames = displayedMonthOptions.map(function (option) {
          return option.label;
        });
        var content = /*#__PURE__*/React__default['default'].createElement("select", {
          className: "p-datepicker-month",
          onChange: function onChange(e) {
            return _this18.onMonthDropdownChange(e, e.target.value);
          },
          value: viewMonth
        }, displayedMonthOptions.map(function (option) {
          return /*#__PURE__*/React__default['default'].createElement("option", {
            key: option.label,
            value: option.value
          }, option.label);
        }));

        if (this.props.monthNavigatorTemplate) {
          var defaultContentOptions = {
            onChange: this.onMonthDropdownChange,
            className: 'p-datepicker-month',
            value: viewMonth,
            names: displayedMonthNames,
            options: displayedMonthOptions,
            element: content,
            props: this.props
          };
          return ObjectUtils.getJSXElement(this.props.monthNavigatorTemplate, defaultContentOptions);
        }

        return content;
      } else {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-datepicker-month"
        }, monthNames[month]);
      }
    }
  }, {
    key: "renderTitleYearElement",
    value: function renderTitleYearElement(year) {
      var _this19 = this;

      if (this.props.yearNavigator) {
        var yearOptions = [];
        var years = this.props.yearRange.split(':');
        var yearStart = parseInt(years[0], 10);
        var yearEnd = parseInt(years[1], 10);

        for (var i = yearStart; i <= yearEnd; i++) {
          yearOptions.push(i);
        }

        var viewDate = this.getViewDate();
        var viewYear = viewDate.getFullYear();
        var displayedYearNames = yearOptions.filter(function (year) {
          return !(_this19.props.minDate && _this19.props.minDate.getFullYear() > year) && !(_this19.props.maxDate && _this19.props.maxDate.getFullYear() < year);
        });
        var content = /*#__PURE__*/React__default['default'].createElement("select", {
          className: "p-datepicker-year",
          onChange: function onChange(e) {
            return _this19.onYearDropdownChange(e, e.target.value);
          },
          value: viewYear
        }, displayedYearNames.map(function (year) {
          return /*#__PURE__*/React__default['default'].createElement("option", {
            key: year,
            value: year
          }, year);
        }));

        if (this.props.yearNavigatorTemplate) {
          var options = displayedYearNames.map(function (name, i) {
            return {
              label: name,
              value: name,
              index: i
            };
          });
          var defaultContentOptions = {
            onChange: this.onYearDropdownChange,
            className: 'p-datepicker-year',
            value: viewYear,
            names: displayedYearNames,
            options: options,
            element: content,
            props: this.props
          };
          return ObjectUtils.getJSXElement(this.props.yearNavigatorTemplate, defaultContentOptions);
        }

        return content;
      } else {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-datepicker-year"
        }, year);
      }
    }
  }, {
    key: "renderTitle",
    value: function renderTitle(monthMetaData) {
      var month = this.renderTitleMonthElement(monthMetaData.month);
      var year = this.renderTitleYearElement(monthMetaData.year);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-title"
      }, month, year);
    }
  }, {
    key: "renderDayNames",
    value: function renderDayNames(weekDays) {
      var dayNames = weekDays.map(function (weekDay, index) {
        return /*#__PURE__*/React__default['default'].createElement("th", {
          key: "".concat(weekDay, "-").concat(index),
          scope: "col"
        }, /*#__PURE__*/React__default['default'].createElement("span", null, weekDay));
      });

      if (this.props.showWeek) {
        var weekHeader = /*#__PURE__*/React__default['default'].createElement("th", {
          scope: "col",
          key: 'wn',
          className: "p-datepicker-weekheader p-disabled"
        }, /*#__PURE__*/React__default['default'].createElement("span", null, localeOption('weekHeader', this.props.locale)));
        return [weekHeader].concat(_toConsumableArray(dayNames));
      } else {
        return dayNames;
      }
    }
  }, {
    key: "renderDateCellContent",
    value: function renderDateCellContent(date, className, groupIndex) {
      var _this20 = this;

      var content = this.props.dateTemplate ? this.props.dateTemplate(date) : date.day;
      return /*#__PURE__*/React__default['default'].createElement("span", {
        className: className,
        onClick: function onClick(e) {
          return _this20.onDateSelect(e, date);
        },
        onKeyDown: function onKeyDown(e) {
          return _this20.onDateCellKeydown(e, date, groupIndex);
        }
      }, content, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderWeek",
    value: function renderWeek(weekDates, weekNumber, groupIndex) {
      var _this21 = this;

      var week = weekDates.map(function (date) {
        var selected = _this21.isSelected(date);

        var cellClassName = classNames({
          'p-datepicker-other-month': date.otherMonth,
          'p-datepicker-today': date.today
        });
        var dateClassName = classNames({
          'p-highlight': selected,
          'p-disabled': !date.selectable
        });
        var content = date.otherMonth && !_this21.props.showOtherMonths ? null : _this21.renderDateCellContent(date, dateClassName, groupIndex);
        return /*#__PURE__*/React__default['default'].createElement("td", {
          key: date.day,
          className: cellClassName
        }, content);
      });

      if (this.props.showWeek) {
        var weekNumberCell = /*#__PURE__*/React__default['default'].createElement("td", {
          key: 'wn' + weekNumber,
          className: "p-datepicker-weeknumber"
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-disabled"
        }, weekNumber));
        return [weekNumberCell].concat(_toConsumableArray(week));
      } else {
        return week;
      }
    }
  }, {
    key: "renderDates",
    value: function renderDates(monthMetaData, groupIndex) {
      var _this22 = this;

      return monthMetaData.dates.map(function (weekDates, index) {
        return /*#__PURE__*/React__default['default'].createElement("tr", {
          key: index
        }, _this22.renderWeek(weekDates, monthMetaData.weekNumbers[index], groupIndex));
      });
    }
  }, {
    key: "renderDateViewGrid",
    value: function renderDateViewGrid(monthMetaData, weekDays, groupIndex) {
      var dayNames = this.renderDayNames(weekDays);
      var dates = this.renderDates(monthMetaData, groupIndex);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-calendar-container"
      }, /*#__PURE__*/React__default['default'].createElement("table", {
        className: "p-datepicker-calendar"
      }, /*#__PURE__*/React__default['default'].createElement("thead", null, /*#__PURE__*/React__default['default'].createElement("tr", null, dayNames)), /*#__PURE__*/React__default['default'].createElement("tbody", null, dates)));
    }
  }, {
    key: "renderMonth",
    value: function renderMonth(monthMetaData, index) {
      var weekDays = this.createWeekDays();
      var backwardNavigator = this.renderBackwardNavigator(index === 0);
      var forwardNavigator = this.renderForwardNavigator(this.props.numberOfMonths === 1 || index === this.props.numberOfMonths - 1);
      var title = this.renderTitle(monthMetaData);
      var dateViewGrid = this.renderDateViewGrid(monthMetaData, weekDays, index);
      var header = this.props.headerTemplate ? this.props.headerTemplate() : null;
      return /*#__PURE__*/React__default['default'].createElement("div", {
        key: monthMetaData.month,
        className: "p-datepicker-group"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-header"
      }, header, backwardNavigator, title, forwardNavigator), dateViewGrid);
    }
  }, {
    key: "renderMonths",
    value: function renderMonths(monthsMetaData) {
      var _this23 = this;

      var groups = monthsMetaData.map(function (monthMetaData, index) {
        return _this23.renderMonth(monthMetaData, index);
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-group-container"
      }, groups);
    }
  }, {
    key: "renderDateView",
    value: function renderDateView() {
      var viewDate = this.getViewDate();
      var monthsMetaData = this.createMonths(viewDate.getMonth(), viewDate.getFullYear());
      var months = this.renderMonths(monthsMetaData);
      return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, months);
    }
  }, {
    key: "renderMonthViewMonth",
    value: function renderMonthViewMonth(index) {
      var _this24 = this;

      var className = classNames('p-monthpicker-month', {
        'p-highlight': this.isMonthSelected(index)
      });
      var monthNamesShort = localeOption('monthNamesShort', this.props.locale);
      var monthName = monthNamesShort[index];
      return /*#__PURE__*/React__default['default'].createElement("span", {
        key: monthName,
        className: className,
        onClick: function onClick(event) {
          return _this24.onMonthSelect(event, index);
        },
        onKeyDown: function onKeyDown(event) {
          return _this24.onMonthCellKeydown(event, index);
        }
      }, monthName, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderMonthViewMonths",
    value: function renderMonthViewMonths() {
      var months = [];

      for (var i = 0; i <= 11; i++) {
        months.push(this.renderMonthViewMonth(i));
      }

      return months;
    }
  }, {
    key: "renderMonthView",
    value: function renderMonthView() {
      var backwardNavigator = this.renderBackwardNavigator(true);
      var forwardNavigator = this.renderForwardNavigator(true);
      var yearElement = this.renderTitleYearElement(this.getViewDate().getFullYear());
      var months = this.renderMonthViewMonths();
      return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-group-container"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-group"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-header"
      }, backwardNavigator, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datepicker-title"
      }, yearElement), forwardNavigator))), /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-monthpicker"
      }, months));
    }
  }, {
    key: "renderDatePicker",
    value: function renderDatePicker() {
      if (!this.props.timeOnly) {
        if (this.props.view === 'date') {
          return this.renderDateView();
        } else if (this.props.view === 'month') {
          return this.renderMonthView();
        } else {
          return null;
        }
      }
    }
  }, {
    key: "renderHourPicker",
    value: function renderHourPicker() {
      var _this25 = this;

      var currentTime = this.getCurrentDateTime();
      var hour = currentTime.getHours();

      if (this.props.hourFormat === '12') {
        if (hour === 0) hour = 12;else if (hour > 11 && hour !== 12) hour = hour - 12;
      }

      var hourDisplay = hour < 10 ? '0' + hour : hour;
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hour-picker"
      }, /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: "p-link",
        onMouseDown: function onMouseDown(e) {
          return _this25.onTimePickerElementMouseDown(e, 0, 1);
        },
        onMouseUp: this.onTimePickerElementMouseUp,
        onMouseLeave: this.onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return _this25.onContainerButtonKeydown(e);
        }
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "pi pi-chevron-up"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("span", null, hourDisplay), /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: "p-link",
        onMouseDown: function onMouseDown(e) {
          return _this25.onTimePickerElementMouseDown(e, 0, -1);
        },
        onMouseUp: this.onTimePickerElementMouseUp,
        onMouseLeave: this.onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return _this25.onContainerButtonKeydown(e);
        }
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "pi pi-chevron-down"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
    }
  }, {
    key: "renderMinutePicker",
    value: function renderMinutePicker() {
      var _this26 = this;

      var currentTime = this.getCurrentDateTime();
      var minute = currentTime.getMinutes();
      var minuteDisplay = minute < 10 ? '0' + minute : minute;
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-minute-picker"
      }, /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: "p-link",
        onMouseDown: function onMouseDown(e) {
          return _this26.onTimePickerElementMouseDown(e, 1, 1);
        },
        onMouseUp: this.onTimePickerElementMouseUp,
        onMouseLeave: this.onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return _this26.onContainerButtonKeydown(e);
        }
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "pi pi-chevron-up"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("span", null, minuteDisplay), /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: "p-link",
        onMouseDown: function onMouseDown(e) {
          return _this26.onTimePickerElementMouseDown(e, 1, -1);
        },
        onMouseUp: this.onTimePickerElementMouseUp,
        onMouseLeave: this.onTimePickerElementMouseLeave,
        onKeyDown: function onKeyDown(e) {
          return _this26.onContainerButtonKeydown(e);
        }
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "pi pi-chevron-down"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
    }
  }, {
    key: "renderSecondPicker",
    value: function renderSecondPicker() {
      var _this27 = this;

      if (this.props.showSeconds) {
        var currentTime = this.getCurrentDateTime();
        var second = currentTime.getSeconds();
        var secondDisplay = second < 10 ? '0' + second : second;
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-second-picker"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-link",
          onMouseDown: function onMouseDown(e) {
            return _this27.onTimePickerElementMouseDown(e, 2, 1);
          },
          onMouseUp: this.onTimePickerElementMouseUp,
          onMouseLeave: this.onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return _this27.onContainerButtonKeydown(e);
          }
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "pi pi-chevron-up"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("span", null, secondDisplay), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-link",
          onMouseDown: function onMouseDown(e) {
            return _this27.onTimePickerElementMouseDown(e, 2, -1);
          },
          onMouseUp: this.onTimePickerElementMouseUp,
          onMouseLeave: this.onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return _this27.onContainerButtonKeydown(e);
          }
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "pi pi-chevron-down"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
      }

      return null;
    }
  }, {
    key: "renderMiliSecondPicker",
    value: function renderMiliSecondPicker() {
      var _this28 = this;

      if (this.props.showMillisec) {
        var currentTime = this.getCurrentDateTime();
        var millisecond = currentTime.getMilliseconds();
        var millisecondDisplay = millisecond < 100 ? (millisecond < 10 ? '00' : '0') + millisecond : millisecond;
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-millisecond-picker"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-link",
          onMouseDown: function onMouseDown(e) {
            return _this28.onTimePickerElementMouseDown(e, 3, 1);
          },
          onMouseUp: this.onTimePickerElementMouseUp,
          onMouseLeave: this.onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return _this28.onContainerButtonKeydown(e);
          }
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "pi pi-chevron-up"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("span", null, millisecondDisplay), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-link",
          onMouseDown: function onMouseDown(e) {
            return _this28.onTimePickerElementMouseDown(e, 3, -1);
          },
          onMouseUp: this.onTimePickerElementMouseUp,
          onMouseLeave: this.onTimePickerElementMouseLeave,
          onKeyDown: function onKeyDown(e) {
            return _this28.onContainerButtonKeydown(e);
          }
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "pi pi-chevron-down"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
      }

      return null;
    }
  }, {
    key: "renderAmPmPicker",
    value: function renderAmPmPicker() {
      if (this.props.hourFormat === '12') {
        var currentTime = this.getCurrentDateTime();
        var hour = currentTime.getHours();
        var display = hour > 11 ? 'PM' : 'AM';
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-ampm-picker"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-link",
          onClick: this.toggleAmPm
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "pi pi-chevron-up"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("span", null, display), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-link",
          onClick: this.toggleAmPm
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "pi pi-chevron-down"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
      }

      return null;
    }
  }, {
    key: "renderSeparator",
    value: function renderSeparator(separator) {
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-separator"
      }, /*#__PURE__*/React__default['default'].createElement("span", null, separator));
    }
  }, {
    key: "renderTimePicker",
    value: function renderTimePicker() {
      if (this.props.showTime || this.props.timeOnly) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-timepicker"
        }, this.renderHourPicker(), this.renderSeparator(':'), this.renderMinutePicker(), this.props.showSeconds && this.renderSeparator(':'), this.renderSecondPicker(), this.props.showMillisec && this.renderSeparator('.'), this.renderMiliSecondPicker(), this.props.hourFormat === '12' && this.renderSeparator(':'), this.renderAmPmPicker());
      }

      return null;
    }
  }, {
    key: "renderInputElement",
    value: function renderInputElement() {
      if (!this.props.inline) {
        return /*#__PURE__*/React__default['default'].createElement(InputText, {
          ref: this.inputRef,
          id: this.props.inputId,
          name: this.props.name,
          type: "text",
          className: this.props.inputClassName,
          style: this.props.inputStyle,
          readOnly: this.props.readOnlyInput,
          disabled: this.props.disabled,
          required: this.props.required,
          autoComplete: "off",
          placeholder: this.props.placeholder,
          onInput: this.onUserInput,
          onFocus: this.onInputFocus,
          onBlur: this.onInputBlur,
          onKeyDown: this.onInputKeyDown,
          "aria-labelledby": this.props.ariaLabelledBy,
          inputMode: this.props.inputMode
        });
      }

      return null;
    }
  }, {
    key: "renderButton",
    value: function renderButton() {
      if (this.props.showIcon) {
        return /*#__PURE__*/React__default['default'].createElement(Button, {
          type: "button",
          icon: this.props.icon,
          onClick: this.onButtonClick,
          tabIndex: "-1",
          disabled: this.props.disabled,
          className: "p-datepicker-trigger"
        });
      }

      return null;
    }
  }, {
    key: "renderButtonBar",
    value: function renderButtonBar() {
      var _this29 = this;

      if (this.props.showButtonBar) {
        var todayClassName = classNames('p-button-text', this.props.todayButtonClassName);
        var clearClassName = classNames('p-button-text', this.props.clearButtonClassName);

        var _localeOptions4 = localeOptions(this.props.locale),
            today = _localeOptions4.today,
            clear = _localeOptions4.clear;

        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-datepicker-buttonbar"
        }, /*#__PURE__*/React__default['default'].createElement(Button, {
          type: "button",
          label: today,
          onClick: this.onTodayButtonClick,
          onKeyDown: function onKeyDown(e) {
            return _this29.onContainerButtonKeydown(e);
          },
          className: todayClassName
        }), /*#__PURE__*/React__default['default'].createElement(Button, {
          type: "button",
          label: clear,
          onClick: this.onClearButtonClick,
          onKeyDown: function onKeyDown(e) {
            return _this29.onContainerButtonKeydown(e);
          },
          className: clearClassName
        }));
      }

      return null;
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      if (this.props.footerTemplate) {
        var content = this.props.footerTemplate();
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-datepicker-footer"
        }, content);
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this30 = this;

      var className = classNames('p-calendar p-component p-inputwrapper', this.props.className, {
        'p-calendar-w-btn': this.props.showIcon,
        'p-calendar-disabled': this.props.disabled,
        'p-calendar-timeonly': this.props.timeOnly,
        'p-inputwrapper-filled': this.props.value || DomHandler.hasClass(this.inputRef.current, 'p-filled') && this.inputRef.current.value !== '',
        'p-inputwrapper-focus': this.state.focused
      });
      var panelClassName = classNames('p-datepicker p-component', this.props.panelClassName, {
        'p-datepicker-inline': this.props.inline,
        'p-disabled': this.props.disabled,
        'p-datepicker-timeonly': this.props.timeOnly,
        'p-datepicker-multiple-month': this.props.numberOfMonths > 1,
        'p-datepicker-monthpicker': this.props.view === 'month',
        'p-datepicker-touch-ui': this.props.touchUI
      });
      var input = this.renderInputElement();
      var button = this.renderButton();
      var datePicker = this.renderDatePicker();
      var timePicker = this.renderTimePicker();
      var buttonBar = this.renderButtonBar();
      var footer = this.renderFooter();
      var isVisible = this.props.inline || this.isVisible();
      return /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          return _this30.container = el;
        },
        id: this.props.id,
        className: className,
        style: this.props.style
      }, input, button, /*#__PURE__*/React__default['default'].createElement(CalendarPanel, {
        ref: this.overlayRef,
        className: panelClassName,
        style: this.props.panelStyle,
        appendTo: this.props.appendTo,
        inline: this.props.inline,
        onClick: this.onPanelClick,
        in: isVisible,
        onEnter: this.onOverlayEnter,
        onEntered: this.onOverlayEntered,
        onExit: this.onOverlayExit,
        onExited: this.onOverlayExited,
        transitionOptions: this.props.transitionOptions
      }, datePicker, timePicker, buttonBar, footer));
    }
  }]);

  return Calendar;
}(React.Component);

_defineProperty(Calendar, "defaultProps", {
  id: null,
  inputRef: null,
  name: null,
  value: null,
  visible: false,
  viewDate: null,
  style: null,
  className: null,
  inline: false,
  selectionMode: 'single',
  inputId: null,
  inputStyle: null,
  inputClassName: null,
  inputMode: 'none',
  required: false,
  readOnlyInput: false,
  keepInvalid: false,
  mask: null,
  disabled: false,
  tabIndex: null,
  placeholder: null,
  showIcon: false,
  icon: 'pi pi-calendar',
  showOnFocus: true,
  numberOfMonths: 1,
  view: 'date',
  touchUI: false,
  showTime: false,
  timeOnly: false,
  showSeconds: false,
  showMillisec: false,
  hourFormat: '24',
  stepHour: 1,
  stepMinute: 1,
  stepSecond: 1,
  stepMillisec: 1,
  shortYearCutoff: '+10',
  hideOnDateTimeSelect: false,
  showWeek: false,
  locale: null,
  dateFormat: null,
  panelStyle: null,
  panelClassName: null,
  monthNavigator: false,
  yearNavigator: false,
  yearRange: null,
  disabledDates: null,
  disabledDays: null,
  minDate: null,
  maxDate: null,
  maxDateCount: null,
  showOtherMonths: true,
  selectOtherMonths: false,
  showButtonBar: false,
  todayButtonClassName: 'p-button-secondary',
  clearButtonClassName: 'p-button-secondary',
  autoZIndex: true,
  baseZIndex: 0,
  appendTo: null,
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  dateTemplate: null,
  headerTemplate: null,
  footerTemplate: null,
  monthNavigatorTemplate: null,
  yearNavigatorTemplate: null,
  transitionOptions: null,
  onVisibleChange: null,
  onFocus: null,
  onBlur: null,
  onInput: null,
  onSelect: null,
  onChange: null,
  onViewDateChange: null,
  onTodayButtonClick: null,
  onClearButtonClick: null,
  onShow: null,
  onHide: null
});

function _createSuper$25(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$25(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$25() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Captcha = /*#__PURE__*/function (_Component) {
  _inherits(Captcha, _Component);

  var _super = _createSuper$25(Captcha);

  function Captcha() {
    _classCallCheck(this, Captcha);

    return _super.apply(this, arguments);
  }

  _createClass(Captcha, [{
    key: "init",
    value: function init() {
      var _this = this;

      this._instance = window.grecaptcha.render(this.targetEL, {
        'sitekey': this.props.siteKey,
        'theme': this.props.theme,
        'type': this.props.type,
        'size': this.props.size,
        'tabindex': this.props.tabIndex,
        'hl': this.props.language,
        'callback': function callback(response) {
          _this.recaptchaCallback(response);
        },
        'expired-callback': function expiredCallback() {
          _this.recaptchaExpiredCallback();
        }
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      if (this._instance === null) return;
      window.grecaptcha.reset(this._instance);
    }
  }, {
    key: "getResponse",
    value: function getResponse() {
      if (this._instance === null) return null;
      return window.grecaptcha.getResponse(this._instance);
    }
  }, {
    key: "recaptchaCallback",
    value: function recaptchaCallback(response) {
      if (this.props.onResponse) {
        this.props.onResponse({
          response: response
        });
      }
    }
  }, {
    key: "recaptchaExpiredCallback",
    value: function recaptchaExpiredCallback() {
      if (this.props.onExpire) {
        this.props.onExpire();
      }
    }
  }, {
    key: "addRecaptchaScript",
    value: function addRecaptchaScript() {
      var _this2 = this;

      this.recaptchaScript = null;

      if (!window.grecaptcha) {
        var head = document.head || document.getElementsByTagName('head')[0];
        this.recaptchaScript = document.createElement('script');
        this.recaptchaScript.src = "https://www.google.com/recaptcha/api.js?render=explicit";
        this.recaptchaScript.async = true;
        this.recaptchaScript.defer = true;

        this.recaptchaScript.onload = function () {
          if (!window.grecaptcha) {
            console.warn("Recaptcha is not loaded");
            return;
          }

          window.grecaptcha.ready(function () {
            _this2.init();
          });
        };

        head.appendChild(this.recaptchaScript);
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.addRecaptchaScript();

      if (window.grecaptcha) {
        this.init();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.recaptchaScript) {
        this.recaptchaScript.parentNode.removeChild(this.recaptchaScript);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        ref: function ref(el) {
          return _this3.targetEL = el;
        }
      });
    }
  }]);

  return Captcha;
}(React.Component);

_defineProperty(Captcha, "defaultProps", {
  id: null,
  siteKey: null,
  theme: "light",
  type: "image",
  size: "normal",
  tabIndex: 0,
  language: "en",
  onResponse: null,
  onExpire: null
});

function _createSuper$24(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$24(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$24() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Card = /*#__PURE__*/function (_Component) {
  _inherits(Card, _Component);

  var _super = _createSuper$24(Card);

  function Card() {
    _classCallCheck(this, Card);

    return _super.apply(this, arguments);
  }

  _createClass(Card, [{
    key: "renderHeader",
    value: function renderHeader() {
      if (this.props.header) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-card-header"
        }, ObjectUtils.getJSXElement(this.props.header, this.props));
      }

      return null;
    }
  }, {
    key: "renderBody",
    value: function renderBody() {
      var title = this.props.title && /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-card-title"
      }, ObjectUtils.getJSXElement(this.props.title, this.props));
      var subTitle = this.props.subTitle && /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-card-subtitle"
      }, ObjectUtils.getJSXElement(this.props.subTitle, this.props));
      var children = this.props.children && /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-card-content"
      }, this.props.children);
      var footer = this.props.footer && /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-card-footer"
      }, ObjectUtils.getJSXElement(this.props.footer, this.props));
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-card-body"
      }, title, subTitle, children, footer);
    }
  }, {
    key: "render",
    value: function render() {
      var header = this.renderHeader();
      var body = this.renderBody();
      var className = classNames('p-card p-component', this.props.className);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: className,
        style: this.props.style,
        id: this.props.id
      }, header, body);
    }
  }]);

  return Card;
}(React.Component);

_defineProperty(Card, "defaultProps", {
  id: null,
  header: null,
  footer: null,
  title: null,
  subTitle: null,
  style: null,
  className: null
});

function ownKeys$E(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$E(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$E(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$E(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$23(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$23(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$23() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var CarouselItem = /*#__PURE__*/function (_Component) {
  _inherits(CarouselItem, _Component);

  var _super = _createSuper$23(CarouselItem);

  function CarouselItem() {
    _classCallCheck(this, CarouselItem);

    return _super.apply(this, arguments);
  }

  _createClass(CarouselItem, [{
    key: "render",
    value: function render() {
      var content = this.props.template(this.props.item);
      var itemClassName = classNames(this.props.className, 'p-carousel-item', {
        'p-carousel-item-active': this.props.active,
        'p-carousel-item-start': this.props.start,
        'p-carousel-item-end': this.props.end
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: itemClassName
      }, content);
    }
  }]);

  return CarouselItem;
}(React.Component);

_defineProperty(CarouselItem, "defaultProps", {
  template: null,
  item: null,
  active: false,
  start: false,
  end: false,
  className: null
});

var Carousel = /*#__PURE__*/function (_Component2) {
  _inherits(Carousel, _Component2);

  var _super2 = _createSuper$23(Carousel);

  function Carousel(props) {
    var _this;

    _classCallCheck(this, Carousel);

    _this = _super2.call(this, props);
    _this.state = {
      numVisible: props.numVisible,
      numScroll: props.numScroll,
      totalShiftedItems: props.page * props.numScroll * -1
    };

    if (!_this.props.onPageChange) {
      _this.state = _objectSpread$E(_objectSpread$E({}, _this.state), {}, {
        page: props.page
      });
    }

    _this.navBackward = _this.navBackward.bind(_assertThisInitialized(_this));
    _this.navForward = _this.navForward.bind(_assertThisInitialized(_this));
    _this.onTransitionEnd = _this.onTransitionEnd.bind(_assertThisInitialized(_this));
    _this.onTouchStart = _this.onTouchStart.bind(_assertThisInitialized(_this));
    _this.onTouchMove = _this.onTouchMove.bind(_assertThisInitialized(_this));
    _this.onTouchEnd = _this.onTouchEnd.bind(_assertThisInitialized(_this));
    _this.totalIndicators = 0;
    _this.remainingItems = 0;
    _this.allowAutoplay = !!_this.props.autoplayInterval;
    _this.circular = _this.props.circular || _this.allowAutoplay;
    _this.attributeSelector = UniqueComponentId();
    _this.swipeThreshold = 20;
    return _this;
  }

  _createClass(Carousel, [{
    key: "step",
    value: function step(dir, page) {
      var totalShiftedItems = this.state.totalShiftedItems;
      var isCircular = this.isCircular();

      if (page != null) {
        totalShiftedItems = this.state.numScroll * page * -1;

        if (isCircular) {
          totalShiftedItems -= this.state.numVisible;
        }

        this.isRemainingItemsAdded = false;
      } else {
        totalShiftedItems += this.state.numScroll * dir;

        if (this.isRemainingItemsAdded) {
          totalShiftedItems += this.remainingItems - this.state.numScroll * dir;
          this.isRemainingItemsAdded = false;
        }

        var originalShiftedItems = isCircular ? totalShiftedItems + this.state.numVisible : totalShiftedItems;
        page = Math.abs(Math.floor(originalShiftedItems / this.state.numScroll));
      }

      if (isCircular && this.state.page === this.totalIndicators - 1 && dir === -1) {
        totalShiftedItems = -1 * (this.props.value.length + this.state.numVisible);
        page = 0;
      } else if (isCircular && this.state.page === 0 && dir === 1) {
        totalShiftedItems = 0;
        page = this.totalIndicators - 1;
      } else if (page === this.totalIndicators - 1 && this.remainingItems > 0) {
        totalShiftedItems += this.remainingItems * -1 - this.state.numScroll * dir;
        this.isRemainingItemsAdded = true;
      }

      if (this.itemsContainer) {
        DomHandler.removeClass(this.itemsContainer, 'p-items-hidden');
        this.changePosition(totalShiftedItems);
        this.itemsContainer.style.transition = 'transform 500ms ease 0s';
      }

      if (this.props.onPageChange) {
        this.setState({
          totalShiftedItems: totalShiftedItems
        });
        this.props.onPageChange({
          page: page
        });
      } else {
        this.setState({
          page: page,
          totalShiftedItems: totalShiftedItems
        });
      }
    }
  }, {
    key: "calculatePosition",
    value: function calculatePosition() {
      if (this.itemsContainer && this.responsiveOptions) {
        var windowWidth = window.innerWidth;
        var matchedResponsiveData = {
          numVisible: this.props.numVisible,
          numScroll: this.props.numScroll
        };

        for (var i = 0; i < this.responsiveOptions.length; i++) {
          var res = this.responsiveOptions[i];

          if (parseInt(res.breakpoint, 10) >= windowWidth) {
            matchedResponsiveData = res;
          }
        }

        var state = {};

        if (this.state.numScroll !== matchedResponsiveData.numScroll) {
          var page = this.getPage();
          page = Math.floor(page * this.state.numScroll / matchedResponsiveData.numScroll);
          var totalShiftedItems = matchedResponsiveData.numScroll * page * -1;

          if (this.isCircular()) {
            totalShiftedItems -= matchedResponsiveData.numVisible;
          }

          state = {
            totalShiftedItems: totalShiftedItems,
            numScroll: matchedResponsiveData.numScroll
          };

          if (this.props.onPageChange) {
            this.props.onPageChange({
              page: page
            });
          } else {
            state = _objectSpread$E(_objectSpread$E({}, state), {}, {
              page: page
            });
          }
        }

        if (this.state.numVisible !== matchedResponsiveData.numVisible) {
          state = _objectSpread$E(_objectSpread$E({}, state), {}, {
            numVisible: matchedResponsiveData.numVisible
          });
        }

        if (Object.keys(state).length) {
          this.setState(state);
        }
      }
    }
  }, {
    key: "navBackward",
    value: function navBackward(e, page) {
      if (this.circular || this.getPage() !== 0) {
        this.step(1, page);
      }

      this.allowAutoplay = false;

      if (e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "navForward",
    value: function navForward(e, page) {
      if (this.circular || this.getPage() < this.totalIndicators - 1) {
        this.step(-1, page);
      }

      this.allowAutoplay = false;

      if (e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "onDotClick",
    value: function onDotClick(e, page) {
      var currentPage = this.getPage();

      if (page > currentPage) {
        this.navForward(e, page);
      } else if (page < currentPage) {
        this.navBackward(e, page);
      }
    }
  }, {
    key: "onTransitionEnd",
    value: function onTransitionEnd() {
      if (this.itemsContainer) {
        DomHandler.addClass(this.itemsContainer, 'p-items-hidden');
        this.itemsContainer.style.transition = '';

        if ((this.state.page === 0 || this.state.page === this.totalIndicators - 1) && this.isCircular()) {
          this.changePosition(this.state.totalShiftedItems);
        }
      }
    }
  }, {
    key: "onTouchStart",
    value: function onTouchStart(e) {
      var touchobj = e.changedTouches[0];
      this.startPos = {
        x: touchobj.pageX,
        y: touchobj.pageY
      };
    }
  }, {
    key: "onTouchMove",
    value: function onTouchMove(e) {
      if (e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "onTouchEnd",
    value: function onTouchEnd(e) {
      var touchobj = e.changedTouches[0];

      if (this.isVertical()) {
        this.changePageOnTouch(e, touchobj.pageY - this.startPos.y);
      } else {
        this.changePageOnTouch(e, touchobj.pageX - this.startPos.x);
      }
    }
  }, {
    key: "changePageOnTouch",
    value: function changePageOnTouch(e, diff) {
      if (Math.abs(diff) > this.swipeThreshold) {
        if (diff < 0) {
          // left
          this.navForward(e);
        } else {
          // right
          this.navBackward(e);
        }
      }
    }
  }, {
    key: "bindDocumentListeners",
    value: function bindDocumentListeners() {
      var _this2 = this;

      if (!this.documentResizeListener) {
        this.documentResizeListener = function () {
          _this2.calculatePosition();
        };

        window.addEventListener('resize', this.documentResizeListener);
      }
    }
  }, {
    key: "unbindDocumentListeners",
    value: function unbindDocumentListeners() {
      if (this.documentResizeListener) {
        window.removeEventListener('resize', this.documentResizeListener);
        this.documentResizeListener = null;
      }
    }
  }, {
    key: "isVertical",
    value: function isVertical() {
      return this.props.orientation === 'vertical';
    }
  }, {
    key: "isCircular",
    value: function isCircular() {
      return this.circular && this.props.value.length >= this.state.numVisible;
    }
  }, {
    key: "getPage",
    value: function getPage() {
      return this.props.onPageChange ? this.props.page : this.state.page;
    }
  }, {
    key: "getTotalIndicators",
    value: function getTotalIndicators() {
      return this.props.value ? Math.ceil((this.props.value.length - this.state.numVisible) / this.state.numScroll) + 1 : 0;
    }
  }, {
    key: "isAutoplay",
    value: function isAutoplay() {
      return this.props.autoplayInterval && this.allowAutoplay;
    }
  }, {
    key: "startAutoplay",
    value: function startAutoplay() {
      var _this3 = this;

      this.interval = setInterval(function () {
        if (_this3.state.page === _this3.totalIndicators - 1) {
          _this3.step(-1, 0);
        } else {
          _this3.step(-1, _this3.state.page + 1);
        }
      }, this.props.autoplayInterval);
    }
  }, {
    key: "stopAutoplay",
    value: function stopAutoplay() {
      if (this.interval) {
        clearInterval(this.interval);
      }
    }
  }, {
    key: "createStyle",
    value: function createStyle() {
      if (!this.carouselStyle) {
        this.carouselStyle = document.createElement('style');
        document.body.appendChild(this.carouselStyle);
      }

      var innerHTML = "\n            .p-carousel[".concat(this.attributeSelector, "] .p-carousel-item {\n                flex: 1 0 ").concat(100 / this.state.numVisible, "%\n            }\n        ");

      if (this.props.responsiveOptions) {
        this.responsiveOptions = _toConsumableArray(this.props.responsiveOptions);
        this.responsiveOptions.sort(function (data1, data2) {
          var value1 = data1.breakpoint;
          var value2 = data2.breakpoint;
          var result = null;
          if (value1 == null && value2 != null) result = -1;else if (value1 != null && value2 == null) result = 1;else if (value1 == null && value2 == null) result = 0;else if (typeof value1 === 'string' && typeof value2 === 'string') result = value1.localeCompare(value2, undefined, {
            numeric: true
          });else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
          return -1 * result;
        });

        for (var i = 0; i < this.responsiveOptions.length; i++) {
          var res = this.responsiveOptions[i];
          innerHTML += "\n                    @media screen and (max-width: ".concat(res.breakpoint, ") {\n                        .p-carousel[").concat(this.attributeSelector, "] .p-carousel-item {\n                            flex: 1 0 ").concat(100 / res.numVisible, "%\n                        }\n                    }\n                ");
        }
      }

      this.carouselStyle.innerHTML = innerHTML;
    }
  }, {
    key: "changePosition",
    value: function changePosition(totalShiftedItems) {
      if (this.itemsContainer) {
        this.itemsContainer.style.transform = this.isVertical() ? "translate3d(0, ".concat(totalShiftedItems * (100 / this.state.numVisible), "%, 0)") : "translate3d(".concat(totalShiftedItems * (100 / this.state.numVisible), "%, 0, 0)");
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.container) {
        this.container.setAttribute(this.attributeSelector, '');
      }

      this.createStyle();
      this.calculatePosition();
      this.changePosition(this.state.totalShiftedItems);

      if (this.props.responsiveOptions) {
        this.bindDocumentListeners();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var isCircular = this.isCircular();
      var stateChanged = false;
      var totalShiftedItems = this.state.totalShiftedItems;

      if (this.props.autoplayInterval) {
        this.stopAutoplay();
      }

      if (prevState.numScroll !== this.state.numScroll || prevState.numVisible !== this.state.numVisible || this.props.value && prevProps.value && prevProps.value.length !== this.props.value.length) {
        this.remainingItems = (this.props.value.length - this.state.numVisible) % this.state.numScroll;
        var page = this.getPage();

        if (this.totalIndicators !== 0 && page >= this.totalIndicators) {
          page = this.totalIndicators - 1;

          if (this.props.onPageChange) {
            this.props.onPageChange({
              page: page
            });
          } else {
            this.setState({
              page: page
            });
          }

          stateChanged = true;
        }

        totalShiftedItems = page * this.state.numScroll * -1;

        if (isCircular) {
          totalShiftedItems -= this.state.numVisible;
        }

        if (page === this.totalIndicators - 1 && this.remainingItems > 0) {
          totalShiftedItems += -1 * this.remainingItems + this.state.numScroll;
          this.isRemainingItemsAdded = true;
        } else {
          this.isRemainingItemsAdded = false;
        }

        if (totalShiftedItems !== this.state.totalShiftedItems) {
          this.setState({
            totalShiftedItems: totalShiftedItems
          });
          stateChanged = true;
        }

        this.changePosition(totalShiftedItems);
      }

      if (isCircular) {
        if (this.state.page === 0) {
          totalShiftedItems = -1 * this.state.numVisible;
        } else if (totalShiftedItems === 0) {
          totalShiftedItems = -1 * this.props.value.length;

          if (this.remainingItems > 0) {
            this.isRemainingItemsAdded = true;
          }
        }

        if (totalShiftedItems !== this.state.totalShiftedItems) {
          this.setState({
            totalShiftedItems: totalShiftedItems
          });
          stateChanged = true;
        }
      }

      if (prevProps.page !== this.props.page) {
        if (this.props.page > prevProps.page && this.props.page <= this.totalIndicators - 1) {
          this.step(-1, this.props.page);
        } else if (this.props.page < prevProps.page) {
          this.step(1, this.props.page);
        }
      }

      if (!stateChanged && this.isAutoplay()) {
        this.startAutoplay();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.props.responsiveOptions) {
        this.unbindDocumentListeners();
      }

      if (this.props.autoplayInterval) {
        this.stopAutoplay();
      }
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this4 = this;

      if (this.props.value && this.props.value.length) {
        var isCircular = this.isCircular();
        var clonedItemsForStarting = null;
        var clonedItemsForFinishing = null;

        if (isCircular) {
          var clonedElements = null;
          clonedElements = this.props.value.slice(-1 * this.state.numVisible);
          clonedItemsForStarting = clonedElements.map(function (item, index) {
            var isActive = _this4.state.totalShiftedItems * -1 === _this4.props.value.length + _this4.state.numVisible,
                start = index === 0,
                end = index === clonedElements.length - 1;
            return /*#__PURE__*/React__default['default'].createElement(CarouselItem, {
              key: index + '_scloned',
              className: "p-carousel-item-cloned",
              template: _this4.props.itemTemplate,
              item: item,
              active: isActive,
              start: start,
              end: end
            });
          });
          clonedElements = this.props.value.slice(0, this.state.numVisible);
          clonedItemsForFinishing = clonedElements.map(function (item, index) {
            var isActive = _this4.state.totalShiftedItems === 0,
                start = index === 0,
                end = index === clonedElements.length - 1;
            return /*#__PURE__*/React__default['default'].createElement(CarouselItem, {
              key: index + '_fcloned',
              className: "p-carousel-item-cloned",
              template: _this4.props.itemTemplate,
              item: item,
              active: isActive,
              start: start,
              end: end
            });
          });
        }

        var items = this.props.value.map(function (item, index) {
          var firstIndex = isCircular ? -1 * (_this4.state.totalShiftedItems + _this4.state.numVisible) : _this4.state.totalShiftedItems * -1,
              lastIndex = firstIndex + _this4.state.numVisible - 1,
              isActive = firstIndex <= index && lastIndex >= index,
              start = firstIndex === index,
              end = lastIndex === index;
          return /*#__PURE__*/React__default['default'].createElement(CarouselItem, {
            key: index,
            template: _this4.props.itemTemplate,
            item: item,
            active: isActive,
            start: start,
            end: end
          });
        });
        return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, clonedItemsForStarting, items, clonedItemsForFinishing);
      }
    }
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      if (this.props.header) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-carousel-header"
        }, this.props.header);
      }

      return null;
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      if (this.props.footer) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-carousel-footer"
        }, this.props.footer);
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this5 = this;

      var items = this.renderItems();
      var height = this.isVertical() ? this.props.verticalViewPortHeight : 'auto';
      var backwardNavigator = this.renderBackwardNavigator();
      var forwardNavigator = this.renderForwardNavigator();
      var containerClassName = classNames('p-carousel-container', this.props.containerClassName);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: containerClassName
      }, backwardNavigator, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-carousel-items-content",
        style: {
          'height': height
        }
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this5.itemsContainer = el;
        },
        className: "p-carousel-items-container",
        onTransitionEnd: this.onTransitionEnd,
        onTouchStart: this.onTouchStart,
        onTouchMove: this.onTouchMove,
        onTouchEnd: this.onTouchEnd
      }, items)), forwardNavigator);
    }
  }, {
    key: "renderBackwardNavigator",
    value: function renderBackwardNavigator() {
      var isDisabled = (!this.circular || this.props.value && this.props.value.length < this.state.numVisible) && this.getPage() === 0;
      var buttonClassName = classNames('p-carousel-prev p-link', {
        'p-disabled': isDisabled
      }),
          iconClassName = classNames('p-carousel-prev-icon pi', {
        'pi-chevron-left': !this.isVertical(),
        'pi-chevron-up': this.isVertical()
      });
      return /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: buttonClassName,
        onClick: this.navBackward,
        disabled: isDisabled
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderForwardNavigator",
    value: function renderForwardNavigator() {
      var isDisabled = (!this.circular || this.props.value && this.props.value.length < this.state.numVisible) && (this.getPage() === this.totalIndicators - 1 || this.totalIndicators === 0);
      var buttonClassName = classNames('p-carousel-next p-link', {
        'p-disabled': isDisabled
      }),
          iconClassName = classNames('p-carousel-next-icon pi', {
        'pi-chevron-right': !this.isVertical(),
        'pi-chevron-down': this.isVertical()
      });
      return /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: buttonClassName,
        onClick: this.navForward,
        disabled: isDisabled
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderIndicator",
    value: function renderIndicator(index) {
      var _this6 = this;

      var isActive = this.getPage() === index,
          indicatorItemClassName = classNames('p-carousel-indicator', {
        'p-highlight': isActive
      });
      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: indicatorItemClassName,
        key: 'p-carousel-indicator-' + index
      }, /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: "p-link",
        onClick: function onClick(e) {
          return _this6.onDotClick(e, index);
        }
      }, /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
    }
  }, {
    key: "renderIndicators",
    value: function renderIndicators() {
      var indicatorsContentClassName = classNames('p-carousel-indicators p-reset', this.props.indicatorsContentClassName);
      var indicators = [];

      for (var i = 0; i < this.totalIndicators; i++) {
        indicators.push(this.renderIndicator(i));
      }

      return /*#__PURE__*/React__default['default'].createElement("ul", {
        className: indicatorsContentClassName
      }, indicators);
    }
  }, {
    key: "render",
    value: function render() {
      var _this7 = this;

      var className = classNames('p-carousel p-component', {
        'p-carousel-vertical': this.isVertical(),
        'p-carousel-horizontal': !this.isVertical()
      }, this.props.className);
      var contentClassName = classNames('p-carousel-content', this.props.contentClassName);
      this.totalIndicators = this.getTotalIndicators();
      var content = this.renderContent();
      var indicators = this.renderIndicators();
      var header = this.renderHeader();
      var footer = this.renderFooter();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this7.container = el;
        },
        id: this.props.id,
        className: className,
        style: this.props.style
      }, header, /*#__PURE__*/React__default['default'].createElement("div", {
        className: contentClassName
      }, content, indicators), footer);
    }
  }]);

  return Carousel;
}(React.Component);

_defineProperty(Carousel, "defaultProps", {
  id: null,
  value: null,
  page: 0,
  header: null,
  footer: null,
  style: null,
  className: null,
  itemTemplate: null,
  circular: false,
  autoplayInterval: 0,
  numVisible: 1,
  numScroll: 1,
  responsiveOptions: null,
  orientation: "horizontal",
  verticalViewPortHeight: "300px",
  contentClassName: null,
  containerClassName: null,
  indicatorsContentClassName: null,
  onPageChange: null
});

function _createForOfIteratorHelper$f(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$f(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$f(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$f(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$f(o, minLen); }

function _arrayLikeToArray$f(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$22(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$22(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$22() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var CascadeSelectSub = /*#__PURE__*/function (_Component) {
  _inherits(CascadeSelectSub, _Component);

  var _super = _createSuper$22(CascadeSelectSub);

  function CascadeSelectSub(props) {
    var _this;

    _classCallCheck(this, CascadeSelectSub);

    _this = _super.call(this, props);
    _this.state = {
      activeOption: null
    };
    _this.onOptionSelect = _this.onOptionSelect.bind(_assertThisInitialized(_this));
    _this.onOptionGroupSelect = _this.onOptionGroupSelect.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(CascadeSelectSub, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.selectionPath && this.props.options && !this.props.dirty) {
        var _iterator = _createForOfIteratorHelper$f(this.props.options),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var option = _step.value;

            if (this.props.selectionPath.includes(option)) {
              this.setState({
                activeOption: option
              });
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      if (!this.props.root) {
        this.position();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.parentActive !== this.props.parentActive) {
        this.setState({
          activeOption: null
        });
      }
    }
  }, {
    key: "position",
    value: function position() {
      var parentItem = this.element.parentElement;
      var containerOffset = DomHandler.getOffset(parentItem);
      var viewport = DomHandler.getViewport();
      var sublistWidth = this.element.offsetParent ? this.element.offsetWidth : DomHandler.getHiddenElementOuterWidth(this.element);
      var itemOuterWidth = DomHandler.getOuterWidth(parentItem.children[0]);

      if (parseInt(containerOffset.left, 10) + itemOuterWidth + sublistWidth > viewport.width - DomHandler.calculateScrollbarWidth()) {
        this.element.style.left = '-100%';
      }
    }
  }, {
    key: "onOptionSelect",
    value: function onOptionSelect(event) {
      if (this.props.onOptionSelect) {
        this.props.onOptionSelect(event);
      }
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event, option) {
      var listItem = event.currentTarget.parentElement;

      switch (event.key) {
        case 'Down':
        case 'ArrowDown':
          var nextItem = this.findNextItem(listItem);

          if (nextItem) {
            nextItem.children[0].focus();
          }

          break;

        case 'Up':
        case 'ArrowUp':
          var prevItem = this.findPrevItem(listItem);

          if (prevItem) {
            prevItem.children[0].focus();
          }

          break;

        case 'Right':
        case 'ArrowRight':
          if (this.isOptionGroup(option)) {
            if (this.state.activeOption === option) {
              listItem.children[1].children[0].children[0].focus();
            } else {
              this.setState({
                activeOption: option
              });
            }
          }

          break;

        case 'Left':
        case 'ArrowLeft':
          this.setState({
            activeOption: null
          });
          var parentList = event.currentTarget.parentElement.parentElement.previousElementSibling;

          if (parentList) {
            parentList.focus();
          }

          break;

        case 'Enter':
          this.onOptionClick(event, option);
          break;

        case 'Tab':
        case 'Escape':
          if (this.props.onPanelHide) {
            this.props.onPanelHide();
            event.preventDefault();
          }

          break;
      }

      event.preventDefault();
    }
  }, {
    key: "findNextItem",
    value: function findNextItem(item) {
      var nextItem = item.nextElementSibling;
      if (nextItem) return DomHandler.hasClass(nextItem, 'p-disabled') || !DomHandler.hasClass(nextItem, 'p-cascadeselect-item') ? this.findNextItem(nextItem) : nextItem;else return null;
    }
  }, {
    key: "findPrevItem",
    value: function findPrevItem(item) {
      var prevItem = item.previousElementSibling;
      if (prevItem) return DomHandler.hasClass(prevItem, 'p-disabled') || !DomHandler.hasClass(prevItem, 'p-cascadeselect-item') ? this.findPrevItem(prevItem) : prevItem;else return null;
    }
  }, {
    key: "onOptionClick",
    value: function onOptionClick(event, option) {
      if (this.isOptionGroup(option)) {
        this.setState({
          activeOption: this.state.activeOption === option ? null : option
        });

        if (this.props.onOptionGroupSelect) {
          this.props.onOptionGroupSelect({
            originalEvent: event,
            value: option
          });
        }
      } else {
        if (this.props.onOptionSelect) {
          this.props.onOptionSelect({
            originalEvent: event,
            value: this.getOptionValue(option)
          });
        }
      }
    }
  }, {
    key: "onOptionGroupSelect",
    value: function onOptionGroupSelect(event) {
      if (this.props.onOptionGroupSelect) {
        this.props.onOptionGroupSelect(event);
      }
    }
  }, {
    key: "getOptionLabel",
    value: function getOptionLabel(option) {
      return this.props.optionLabel ? ObjectUtils.resolveFieldData(option, this.props.optionLabel) : option;
    }
  }, {
    key: "getOptionValue",
    value: function getOptionValue(option) {
      return this.props.optionValue ? ObjectUtils.resolveFieldData(option, this.props.optionValue) : option;
    }
  }, {
    key: "getOptionGroupLabel",
    value: function getOptionGroupLabel(optionGroup) {
      return this.props.optionGroupLabel ? ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupLabel) : null;
    }
  }, {
    key: "getOptionGroupChildren",
    value: function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupChildren[this.props.level]);
    }
  }, {
    key: "isOptionGroup",
    value: function isOptionGroup(option) {
      return Object.prototype.hasOwnProperty.call(option, this.props.optionGroupChildren[this.props.level]);
    }
  }, {
    key: "getOptionLabelToRender",
    value: function getOptionLabelToRender(option) {
      return this.isOptionGroup(option) ? this.getOptionGroupLabel(option) : this.getOptionLabel(option);
    }
  }, {
    key: "renderSubmenu",
    value: function renderSubmenu(option) {
      if (this.isOptionGroup(option) && this.state.activeOption === option) {
        return /*#__PURE__*/React__default['default'].createElement(CascadeSelectSub, {
          options: this.getOptionGroupChildren(option),
          className: "p-cascadeselect-sublist",
          selectionPath: this.props.selectionPath,
          optionLabel: this.props.optionLabel,
          optionValue: this.props.optionValue,
          level: this.props.level + 1,
          onOptionSelect: this.onOptionSelect,
          onOptionGroupSelect: this.onOptionGroupSelect,
          parentActive: this.state.activeOption === option,
          optionGroupLabel: this.props.optionGroupLabel,
          optionGroupChildren: this.props.optionGroupChildren,
          dirty: this.props.dirty,
          template: this.props.template,
          onPanelHide: this.props.onPanelHide
        });
      }

      return null;
    }
  }, {
    key: "renderOption",
    value: function renderOption(option, index) {
      var _this2 = this;

      var className = classNames('p-cascadeselect-item', {
        'p-cascadeselect-item-group': this.isOptionGroup(option),
        'p-cascadeselect-item-active p-highlight': this.state.activeOption === option
      }, option.className);
      var submenu = this.renderSubmenu(option);
      var content = this.props.template ? ObjectUtils.getJSXElement(this.props.template, this.getOptionValue(option)) : /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-cascadeselect-item-text"
      }, this.getOptionLabelToRender(option));
      var optionGroup = this.isOptionGroup(option) && /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-cascadeselect-group-icon pi pi-angle-right"
      });
      return /*#__PURE__*/React__default['default'].createElement("li", {
        key: this.getOptionLabelToRender(option) + '_' + index,
        className: className,
        style: option.style,
        role: "none"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-cascadeselect-item-content",
        onClick: function onClick(event) {
          return _this2.onOptionClick(event, option);
        },
        tabIndex: 0,
        onKeyDown: function onKeyDown(event) {
          return _this2.onKeyDown(event, option);
        }
      }, content, optionGroup, /*#__PURE__*/React__default['default'].createElement(Ripple, null)), submenu);
    }
  }, {
    key: "renderMenu",
    value: function renderMenu() {
      var _this3 = this;

      if (this.props.options) {
        return this.props.options.map(function (option, index) {
          return _this3.renderOption(option, index);
        });
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var className = classNames('p-cascadeselect-panel p-cascadeselect-items', this.props.className);
      var submenu = this.renderMenu();
      return /*#__PURE__*/React__default['default'].createElement("ul", {
        ref: function ref(el) {
          return _this4.element = el;
        },
        className: className,
        role: "listbox",
        "aria-orientation": "horizontal"
      }, submenu);
    }
  }]);

  return CascadeSelectSub;
}(React.Component);

_defineProperty(CascadeSelectSub, "defaultProps", {
  options: null,
  selectionPath: false,
  className: null,
  optionLabel: null,
  optionValue: null,
  level: null,
  optionGroupLabel: null,
  optionGroupChildren: null,
  parentActive: null,
  dirty: null,
  root: null,
  template: null,
  onOptionSelect: null,
  onOptionGroupSelect: null
});

function _createForOfIteratorHelper$e(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$e(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$e(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$e(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$e(o, minLen); }

function _arrayLikeToArray$e(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$21(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$21(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$21() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var CascadeSelect = /*#__PURE__*/function (_Component) {
  _inherits(CascadeSelect, _Component);

  var _super = _createSuper$21(CascadeSelect);

  function CascadeSelect(props) {
    var _this;

    _classCallCheck(this, CascadeSelect);

    _this = _super.call(this, props);
    _this.state = {
      focused: false,
      overlayVisible: false
    };
    _this.dirty = false;
    _this.selectionPath = null;
    _this.overlayRef = /*#__PURE__*/React.createRef();
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    _this.hide = _this.hide.bind(_assertThisInitialized(_this));
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onInputFocus = _this.onInputFocus.bind(_assertThisInitialized(_this));
    _this.onInputBlur = _this.onInputBlur.bind(_assertThisInitialized(_this));
    _this.onInputKeyDown = _this.onInputKeyDown.bind(_assertThisInitialized(_this));
    _this.onOverlayEnter = _this.onOverlayEnter.bind(_assertThisInitialized(_this));
    _this.onOverlayEntered = _this.onOverlayEntered.bind(_assertThisInitialized(_this));
    _this.onOverlayExit = _this.onOverlayExit.bind(_assertThisInitialized(_this));
    _this.onOverlayExited = _this.onOverlayExited.bind(_assertThisInitialized(_this));
    _this.onOptionSelect = _this.onOptionSelect.bind(_assertThisInitialized(_this));
    _this.onOptionGroupSelect = _this.onOptionGroupSelect.bind(_assertThisInitialized(_this));
    _this.onPanelClick = _this.onPanelClick.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(CascadeSelect, [{
    key: "onOptionSelect",
    value: function onOptionSelect(event) {
      if (this.props.onChange) {
        this.props.onChange({
          originalEvent: event,
          value: event.value
        });
      }

      this.updateSelectionPath();
      this.hide();
      this.inputRef.current.focus();
    }
  }, {
    key: "onOptionGroupSelect",
    value: function onOptionGroupSelect(event) {
      this.dirty = true;

      if (this.props.onGroupChange) {
        this.props.onGroupChange(event);
      }
    }
  }, {
    key: "getOptionLabel",
    value: function getOptionLabel(option) {
      return this.props.optionLabel ? ObjectUtils.resolveFieldData(option, this.props.optionLabel) : option;
    }
  }, {
    key: "getOptionValue",
    value: function getOptionValue(option) {
      return this.props.optionValue ? ObjectUtils.resolveFieldData(option, this.props.optionValue) : option;
    }
  }, {
    key: "getOptionGroupChildren",
    value: function getOptionGroupChildren(optionGroup, level) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupChildren[level]);
    }
  }, {
    key: "isOptionGroup",
    value: function isOptionGroup(option, level) {
      return Object.prototype.hasOwnProperty.call(option, this.props.optionGroupChildren[level]);
    }
  }, {
    key: "updateSelectionPath",
    value: function updateSelectionPath() {
      var path;

      if (this.props.value != null && this.props.options) {
        var _iterator = _createForOfIteratorHelper$e(this.props.options),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var option = _step.value;
            path = this.findModelOptionInGroup(option, 0);

            if (path) {
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      this.selectionPath = path;
    }
  }, {
    key: "findModelOptionInGroup",
    value: function findModelOptionInGroup(option, level) {
      if (this.isOptionGroup(option, level)) {
        var selectedOption;

        var _iterator2 = _createForOfIteratorHelper$e(this.getOptionGroupChildren(option, level)),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var childOption = _step2.value;
            selectedOption = this.findModelOptionInGroup(childOption, level + 1);

            if (selectedOption) {
              selectedOption.unshift(option);
              return selectedOption;
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } else if (ObjectUtils.equals(this.props.value, this.getOptionValue(option), this.props.dataKey)) {
        return [option];
      }

      return null;
    }
  }, {
    key: "onClick",
    value: function onClick(event) {
      if (this.props.disabled) {
        return;
      }

      var overlay = this.overlayRef ? this.overlayRef.current : null;

      if (!overlay || !overlay.contains(event.target)) {
        this.inputRef.current.focus();

        if (this.state.overlayVisible) {
          this.hide();
        } else {
          this.show();
        }
      }
    }
  }, {
    key: "onInputFocus",
    value: function onInputFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "onInputBlur",
    value: function onInputBlur() {
      this.setState({
        focused: false
      });
    }
  }, {
    key: "onInputKeyDown",
    value: function onInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          if (this.state.overlayVisible) {
            DomHandler.findSingle(this.overlayRef.current, '.p-cascadeselect-item').children[0].focus();
          } else if (event.altKey && this.props.options && this.props.options.length) {
            this.show();
          }

          event.preventDefault();
          break;
        //space

        case 32:
          if (this.state.overlayVisible) this.hide();else this.show();
          event.preventDefault();
          break;
        //tab

        case 9:
          this.hide();
          break;
      }
    }
  }, {
    key: "onPanelClick",
    value: function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: this.container
      });
    }
  }, {
    key: "show",
    value: function show() {
      if (this.props.onBeforeShow) {
        this.props.onBeforeShow();
      }

      this.setState({
        overlayVisible: true
      });
    }
  }, {
    key: "hide",
    value: function hide() {
      var _this2 = this;

      if (this.props.onBeforeHide) {
        this.props.onBeforeHide();
      }

      this.setState({
        overlayVisible: false
      }, function () {
        _this2.inputRef.current.focus();
      });
    }
  }, {
    key: "onOverlayEnter",
    value: function onOverlayEnter() {
      ZIndexUtils.set('overlay', this.overlayRef.current);
      this.alignOverlay();
    }
  }, {
    key: "onOverlayEntered",
    value: function onOverlayEntered() {
      this.bindOutsideClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onOverlayExit",
    value: function onOverlayExit() {
      this.unbindOutsideClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
      this.dirty = false;
    }
  }, {
    key: "onOverlayExited",
    value: function onOverlayExited() {
      ZIndexUtils.clear(this.overlayRef.current);
      this.props.onHide && this.props.onHide();
    }
  }, {
    key: "alignOverlay",
    value: function alignOverlay() {
      DomHandler.alignOverlay(this.overlayRef.current, this.label.parentElement, this.props.appendTo || PrimeReact.appendTo);
    }
  }, {
    key: "bindOutsideClickListener",
    value: function bindOutsideClickListener() {
      var _this3 = this;

      if (!this.outsideClickListener) {
        this.outsideClickListener = function (event) {
          if (_this3.state.overlayVisible && _this3.isOutsideClicked(event)) {
            _this3.hide();
          }
        };

        document.addEventListener('click', this.outsideClickListener);
      }
    }
  }, {
    key: "unbindOutsideClickListener",
    value: function unbindOutsideClickListener() {
      if (this.outsideClickListener) {
        document.removeEventListener('click', this.outsideClickListener);
        this.outsideClickListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this4 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.container, function () {
          if (_this4.state.overlayVisible) {
            _this4.hide();
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "bindResizeListener",
    value: function bindResizeListener() {
      var _this5 = this;

      if (!this.resizeListener) {
        this.resizeListener = function () {
          if (_this5.state.overlayVisible && !DomHandler.isAndroid()) {
            _this5.hide();
          }
        };

        window.addEventListener('resize', this.resizeListener);
      }
    }
  }, {
    key: "unbindResizeListener",
    value: function unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener('resize', this.resizeListener);
        this.resizeListener = null;
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(event) {
      return this.container && !(this.container.isSameNode(event.target) || this.container.contains(event.target) || this.overlayRef && this.overlayRef.current.contains(event.target));
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();
      this.updateSelectionPath();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindOutsideClickListener();
      this.unbindResizeListener();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.value !== this.props.value) {
        this.updateSelectionPath();
      }
    }
  }, {
    key: "renderKeyboardHelper",
    value: function renderKeyboardHelper() {
      var value = this.props.value ? this.getOptionLabel(this.props.value) : null;
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hidden-accessible"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: this.inputRef,
        type: "text",
        id: this.props.inputId,
        name: this.props.name,
        defaultValue: value,
        readOnly: true,
        disabled: this.props.disabled,
        onFocus: this.onInputFocus,
        onBlur: this.onInputBlur,
        onKeyDown: this.onInputKeyDown,
        tabIndex: this.props.tabIndex,
        "aria-haspopup": "listbox",
        "aria-labelledby": this.props.ariaLabelledBy
      }));
    }
  }, {
    key: "renderLabel",
    value: function renderLabel() {
      var _this6 = this;

      var label = this.props.value ? this.getOptionLabel(this.props.value) : this.props.placeholder || 'p-emptylabel';
      var labelClassName = classNames('p-cascadeselect-label ', {
        'p-placeholder': label === this.props.placeholder,
        'p-cascadeselect-label-empty': !this.props.value && label === 'p-emptylabel'
      });
      return /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          return _this6.label = el;
        },
        className: labelClassName
      }, label);
    }
  }, {
    key: "renderDropdownIcon",
    value: function renderDropdownIcon() {
      var iconClassName = classNames('p-cascadeselect-trigger-icon', this.props.dropdownIcon);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-cascadeselect-trigger",
        role: "button",
        "aria-haspopup": "listbox",
        "aria-expanded": this.state.overlayVisible
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }));
    }
  }, {
    key: "renderOverlay",
    value: function renderOverlay() {
      var overlay = /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.overlayRef,
        classNames: "p-connected-overlay",
        in: this.state.overlayVisible,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.onOverlayEnter,
        onEntered: this.onOverlayEntered,
        onExit: this.onOverlayExit,
        onExited: this.onOverlayExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.overlayRef,
        className: "p-cascadeselect-panel p-component",
        onClick: this.onPanelClick
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-cascadeselect-items-wrapper"
      }, /*#__PURE__*/React__default['default'].createElement(CascadeSelectSub, {
        options: this.props.options,
        selectionPath: this.selectionPath,
        className: "p-cascadeselect-items",
        optionLabel: this.props.optionLabel,
        optionValue: this.props.optionValue,
        level: 0,
        optionGroupLabel: this.props.optionGroupLabel,
        optionGroupChildren: this.props.optionGroupChildren,
        onOptionSelect: this.onOptionSelect,
        onOptionGroupSelect: this.onOptionGroupSelect,
        root: true,
        template: this.props.itemTemplate,
        onPanelHide: this.hide
      }))));
      return /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: overlay,
        appendTo: this.props.appendTo
      });
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var _this7 = this;

      var className = classNames('p-cascadeselect p-component p-inputwrapper', this.props.className, {
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused,
        'p-inputwrapper-filled': this.props.value,
        'p-inputwrapper-focus': this.state.focused || this.state.overlayVisible
      });
      var keyboardHelper = this.renderKeyboardHelper();
      var labelElement = this.renderLabel();
      var dropdownIcon = this.renderDropdownIcon();
      var overlay = this.renderOverlay();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        ref: function ref(el) {
          return _this7.container = el;
        },
        className: className,
        style: this.props.style,
        onClick: this.onClick
      }, keyboardHelper, labelElement, dropdownIcon, overlay);
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return element;
    }
  }]);

  return CascadeSelect;
}(React.Component);

_defineProperty(CascadeSelect, "defaultProps", {
  id: null,
  inputRef: null,
  style: null,
  className: null,
  value: null,
  name: null,
  options: null,
  optionLabel: null,
  optionValue: null,
  optionGroupLabel: null,
  optionGroupChildren: null,
  placeholder: null,
  itemTemplate: null,
  disabled: false,
  dataKey: null,
  inputId: null,
  tabIndex: null,
  ariaLabelledBy: null,
  appendTo: null,
  transitionOptions: null,
  dropdownIcon: 'pi pi-chevron-down',
  onChange: null,
  onGroupChange: null,
  onBeforeShow: null,
  onBeforeHide: null,
  onShow: null,
  onHide: null
});

function _createSuper$20(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$20(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$20() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Chart = /*#__PURE__*/function (_Component) {
  _inherits(Chart, _Component);

  var _super = _createSuper$20(Chart);

  function Chart() {
    _classCallCheck(this, Chart);

    return _super.apply(this, arguments);
  }

  _createClass(Chart, [{
    key: "initChart",
    value: function initChart() {
      var _this = this;

      Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require('chart.js/auto')); }).then(function (module) {
        if (_this.chart) {
          _this.chart.destroy();

          _this.chart = null;
        }

        if (module && module.default) {
          _this.chart = new module.default(_this.canvas, {
            type: _this.props.type,
            data: _this.props.data,
            options: _this.props.options,
            plugins: _this.props.plugins
          });
        }
      });
    }
  }, {
    key: "getCanvas",
    value: function getCanvas() {
      return this.canvas;
    }
  }, {
    key: "getChart",
    value: function getChart() {
      return this.chart;
    }
  }, {
    key: "getBase64Image",
    value: function getBase64Image() {
      return this.chart.toBase64Image();
    }
  }, {
    key: "generateLegend",
    value: function generateLegend() {
      if (this.chart) {
        this.chart.generateLegend();
      }
    }
  }, {
    key: "refresh",
    value: function refresh() {
      if (this.chart) {
        this.chart.update();
      }
    }
  }, {
    key: "reinit",
    value: function reinit() {
      this.initChart();
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      if (nextProps.data === this.props.data && nextProps.options === this.props.options && nextProps.type === this.props.type) {
        return false;
      }

      return true;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.initChart();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.reinit();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.chart) {
        this.chart.destroy();
        this.chart = null;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var className = classNames('p-chart', this.props.className),
          style = Object.assign({
        width: this.props.width,
        height: this.props.height
      }, this.props.style);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        style: style,
        className: className
      }, /*#__PURE__*/React__default['default'].createElement("canvas", {
        ref: function ref(el) {
          _this2.canvas = el;
        },
        width: this.props.width,
        height: this.props.height
      }));
    }
  }]);

  return Chart;
}(React.Component);

_defineProperty(Chart, "defaultProps", {
  id: null,
  type: null,
  data: null,
  options: null,
  plugins: null,
  width: null,
  height: null,
  style: null,
  className: null
});

function ownKeys$D(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$D(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$D(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$D(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1$(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1$(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1$() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Checkbox = /*#__PURE__*/function (_Component) {
  _inherits(Checkbox, _Component);

  var _super = _createSuper$1$(Checkbox);

  function Checkbox(props) {
    var _this;

    _classCallCheck(this, Checkbox);

    _this = _super.call(this, props);
    _this.state = {
      focused: false
    };
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(Checkbox, [{
    key: "onClick",
    value: function onClick(e) {
      if (!this.props.disabled && !this.props.readOnly && this.props.onChange) {
        var value = this.isChecked() ? this.props.falseValue : this.props.trueValue;
        this.props.onChange({
          originalEvent: e,
          value: this.props.value,
          checked: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            type: 'checkbox',
            name: this.props.name,
            id: this.props.id,
            value: this.props.value,
            checked: value
          }
        });
        this.inputRef.current.checked = !this.isChecked();
        this.inputRef.current.focus();
        e.preventDefault();
      }
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      this.inputRef.current.checked = this.isChecked();

      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$D({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }
    }
  }, {
    key: "onFocus",
    value: function onFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      this.setState({
        focused: false
      });
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.key === 'Enter') {
        this.onClick(event);
        event.preventDefault();
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.element,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "isChecked",
    value: function isChecked() {
      return this.props.checked === this.props.trueValue;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var containerClass = classNames('p-checkbox p-component', {
        'p-checkbox-checked': this.isChecked(),
        'p-checkbox-disabled': this.props.disabled,
        'p-checkbox-focused': this.state.focused
      }, this.props.className);
      var boxClass = classNames('p-checkbox-box', {
        'p-highlight': this.isChecked(),
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused
      });
      var iconClass = classNames('p-checkbox-icon p-c', _defineProperty({}, this.props.icon, this.isChecked()));
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this2.element = el;
        },
        id: this.props.id,
        className: containerClass,
        style: this.props.style,
        onClick: this.onClick,
        onContextMenu: this.props.onContextMenu,
        onMouseDown: this.props.onMouseDown
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hidden-accessible"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: this.inputRef,
        type: "checkbox",
        "aria-labelledby": this.props.ariaLabelledBy,
        id: this.props.inputId,
        name: this.props.name,
        tabIndex: this.props.tabIndex,
        defaultChecked: this.isChecked(),
        onKeyDown: this.onKeyDown,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        disabled: this.props.disabled,
        readOnly: this.props.readOnly,
        required: this.props.required
      })), /*#__PURE__*/React__default['default'].createElement("div", {
        className: boxClass,
        ref: function ref(el) {
          return _this2.box = el;
        },
        role: "checkbox",
        "aria-checked": this.isChecked()
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClass
      })));
    }
  }]);

  return Checkbox;
}(React.Component);

_defineProperty(Checkbox, "defaultProps", {
  id: null,
  inputRef: null,
  inputId: null,
  value: null,
  name: null,
  checked: false,
  trueValue: true,
  falseValue: false,
  style: null,
  className: null,
  disabled: false,
  required: false,
  readOnly: false,
  tabIndex: null,
  icon: 'pi pi-check',
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  onChange: null,
  onMouseDown: null,
  onContextMenu: null
});

function _createSuper$1_(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1_(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1_() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Chip = /*#__PURE__*/function (_Component) {
  _inherits(Chip, _Component);

  var _super = _createSuper$1_(Chip);

  function Chip(props) {
    var _this;

    _classCallCheck(this, Chip);

    _this = _super.call(this, props);
    _this.state = {
      visible: true
    };
    _this.close = _this.close.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Chip, [{
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.keyCode === 13) {
        // enter
        this.close(event);
      }
    }
  }, {
    key: "close",
    value: function close(event) {
      var _this2 = this;

      event.persist();
      this.setState({
        visible: false
      }, function () {
        if (_this2.props.onRemove) {
          _this2.props.onRemove(event);
        }
      });
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this3 = this;

      var content = [];

      if (this.props.image) {
        var onError = function onError(e) {
          if (_this3.props.onImageError) {
            _this3.props.onImageError(e);
          }
        };

        content.push( /*#__PURE__*/React__default['default'].createElement("img", {
          key: "image",
          src: this.props.image,
          alt: this.props.imageAlt,
          onError: onError
        }));
      } else if (this.props.icon) {
        var iconClassName = classNames('p-chip-icon', this.props.icon);
        content.push( /*#__PURE__*/React__default['default'].createElement("span", {
          key: "icon",
          className: iconClassName
        }));
      }

      if (this.props.label) {
        content.push( /*#__PURE__*/React__default['default'].createElement("span", {
          key: "label",
          className: "p-chip-text"
        }, this.props.label));
      }

      if (this.props.removable) {
        var removableIconClassName = classNames('p-chip-remove-icon', this.props.removeIcon);
        content.push( /*#__PURE__*/React__default['default'].createElement("span", {
          key: "removeIcon",
          tabIndex: 0,
          className: removableIconClassName,
          onClick: this.close,
          onKeyDown: this.onKeyDown
        }));
      }

      return content;
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var containerClassName = classNames('p-chip p-component', {
        'p-chip-image': this.props.image != null
      }, this.props.className);
      var content = this.props.template ? ObjectUtils.getJSXElement(this.props.template, this.props) : this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: containerClassName,
        style: this.props.style
      }, content);
    }
  }, {
    key: "render",
    value: function render() {
      return this.state.visible && this.renderElement();
    }
  }]);

  return Chip;
}(React.Component);

_defineProperty(Chip, "defaultProps", {
  label: null,
  icon: null,
  image: null,
  removable: false,
  removeIcon: 'pi pi-times-circle',
  className: null,
  style: null,
  template: null,
  imageAlt: 'chip',
  onImageError: null,
  onRemove: null
});

function ownKeys$C(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$C(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$C(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$C(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1Z(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1Z(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1Z() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Chips = /*#__PURE__*/function (_Component) {
  _inherits(Chips, _Component);

  var _super = _createSuper$1Z(Chips);

  function Chips(props) {
    var _this;

    _classCallCheck(this, Chips);

    _this = _super.call(this, props);
    _this.state = {
      focused: false
    };
    _this.onWrapperClick = _this.onWrapperClick.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onPaste = _this.onPaste.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(Chips, [{
    key: "removeItem",
    value: function removeItem(event, index) {
      if (this.props.disabled) {
        return;
      }

      var values = _toConsumableArray(this.props.value);

      var removedItem = values.splice(index, 1);

      if (this.props.onRemove) {
        this.props.onRemove({
          originalEvent: event,
          value: removedItem
        });
      }

      if (this.props.onChange) {
        this.props.onChange({
          originalEvent: event,
          value: values,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: values
          }
        });
      }
    }
  }, {
    key: "addItem",
    value: function addItem(event, item, preventDefault) {
      if (item && item.trim().length) {
        var values = this.props.value ? _toConsumableArray(this.props.value) : [];

        if (this.props.allowDuplicate || values.indexOf(item) === -1) {
          values.push(item);

          if (this.props.onAdd) {
            this.props.onAdd({
              originalEvent: event,
              value: item
            });
          }
        }

        this.updateInput(event, values, preventDefault);
      }
    }
  }, {
    key: "onWrapperClick",
    value: function onWrapperClick() {
      this.inputRef.current.focus();
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      var inputValue = event.target.value;
      var values = this.props.value || [];

      switch (event.which) {
        //backspace
        case 8:
          if (this.inputRef.current.value.length === 0 && values.length > 0) {
            this.removeItem(event, values.length - 1);
          }

          break;
        //enter

        case 13:
          if (inputValue && inputValue.trim().length && (!this.props.max || this.props.max > values.length)) {
            this.addItem(event, inputValue, true);
          }

          break;

        default:
          if (this.isMaxedOut()) {
            event.preventDefault();
          } else if (this.props.separator) {
            if (this.props.separator === ',' && event.which === 188) {
              this.addItem(event, inputValue, true);
            }
          }

          break;
      }
    }
  }, {
    key: "updateInput",
    value: function updateInput(event, items, preventDefault) {
      if (this.props.onChange) {
        this.props.onChange({
          originalEvent: event,
          value: items,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: items
          }
        });
      }

      this.inputRef.current.value = '';

      if (preventDefault) {
        event.preventDefault();
      }
    }
  }, {
    key: "onPaste",
    value: function onPaste(event) {
      var _this2 = this;

      if (this.props.separator) {
        var pastedData = (event.clipboardData || window['clipboardData']).getData('Text');

        if (pastedData) {
          var values = this.props.value || [];
          var pastedValues = pastedData.split(this.props.separator);
          pastedValues = pastedValues.filter(function (val) {
            return (_this2.props.allowDuplicate || values.indexOf(val) === -1) && val.trim().length;
          });
          values = [].concat(_toConsumableArray(values), _toConsumableArray(pastedValues));
          this.updateInput(event, values, true);
        }
      }
    }
  }, {
    key: "onFocus",
    value: function onFocus(event) {
      var _this3 = this;

      event.persist();
      this.setState({
        focused: true
      }, function () {
        if (_this3.props.onFocus) {
          _this3.props.onFocus(event);
        }
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur(event) {
      var _this4 = this;

      event.persist();
      this.setState({
        focused: false
      }, function () {
        if (_this4.props.onBlur) {
          _this4.props.onBlur(event);
        }
      });
    }
  }, {
    key: "isMaxedOut",
    value: function isMaxedOut() {
      return this.props.max && this.props.value && this.props.max === this.props.value.length;
    }
  }, {
    key: "isFilled",
    value: function isFilled() {
      return this.props.value && this.props.value.length || this.inputRef && this.inputRef.current && this.inputRef.current.value && this.inputRef.current.value.length;
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var isValueSame = this.props.value && prevProps.value && prevProps.value.length === this.props.value.length;

      if (this.props.tooltip) {
        if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
          if (this.tooltip) this.tooltip.update(_objectSpread$C({
            content: this.props.tooltip
          }, this.props.tooltipOptions || {}));else this.renderTooltip();
        } else if (!isValueSame && this.tooltip) {
          this.tooltip.deactivate();
          this.tooltip.activate();
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.inputRef.current,
        targetContainer: this.listElement,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "renderItem",
    value: function renderItem(value, index) {
      var _this5 = this;

      var content = this.props.itemTemplate ? this.props.itemTemplate(value) : value;
      var icon = this.props.disabled ? null : /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-chips-token-icon pi pi-times-circle",
        onClick: function onClick(event) {
          return _this5.removeItem(event, index);
        }
      });
      return /*#__PURE__*/React__default['default'].createElement("li", {
        key: index,
        className: "p-chips-token p-highlight"
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-chips-token-label"
      }, content), icon);
    }
  }, {
    key: "renderInputElement",
    value: function renderInputElement() {
      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: "p-chips-input-token"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: this.inputRef,
        placeholder: this.props.placeholder,
        type: "text",
        name: this.props.name,
        disabled: this.props.disabled || this.isMaxedOut(),
        onKeyDown: this.onKeyDown,
        onPaste: this.onPaste,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        "aria-labelledby": this.props.ariaLabelledBy
      }));
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this6 = this;

      if (this.props.value) {
        return this.props.value.map(function (value, index) {
          return _this6.renderItem(value, index);
        });
      }

      return null;
    }
  }, {
    key: "renderList",
    value: function renderList() {
      var _this7 = this;

      var className = classNames('p-inputtext p-chips-multiple-container', {
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused
      });
      var items = this.renderItems();
      var inputElement = this.renderInputElement();
      return /*#__PURE__*/React__default['default'].createElement("ul", {
        ref: function ref(el) {
          return _this7.listElement = el;
        },
        className: className,
        onClick: this.onWrapperClick
      }, items, inputElement);
    }
  }, {
    key: "render",
    value: function render() {
      var _this8 = this;

      var className = classNames('p-chips p-component p-inputwrapper', this.props.className, {
        'p-inputwrapper-filled': this.isFilled(),
        'p-inputwrapper-focus': this.state.focused
      });
      var list = this.renderList();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this8.element = el;
        },
        id: this.props.id,
        className: className,
        style: this.props.style
      }, list);
    }
  }]);

  return Chips;
}(React.Component);

_defineProperty(Chips, "defaultProps", {
  id: null,
  inputRef: null,
  name: null,
  placeholder: null,
  value: null,
  max: null,
  disabled: null,
  style: null,
  className: null,
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  separator: null,
  allowDuplicate: true,
  itemTemplate: null,
  onAdd: null,
  onRemove: null,
  onChange: null,
  onFocus: null,
  onBlur: null
});

function _createSuper$1Y(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1Y(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1Y() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ColorPickerPanelComponent = /*#__PURE__*/function (_Component) {
  _inherits(ColorPickerPanelComponent, _Component);

  var _super = _createSuper$1Y(ColorPickerPanelComponent);

  function ColorPickerPanelComponent() {
    _classCallCheck(this, ColorPickerPanelComponent);

    return _super.apply(this, arguments);
  }

  _createClass(ColorPickerPanelComponent, [{
    key: "renderElement",
    value: function renderElement() {
      var className = classNames('p-colorpicker-panel', {
        'p-colorpicker-overlay-panel': !this.props.inline,
        'p-disabled': this.props.disabled
      });
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.props.forwardRef,
        classNames: "p-connected-overlay",
        in: this.props.in,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.props.onEnter,
        onEntered: this.props.onEntered,
        onExit: this.props.onExit,
        onExited: this.props.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.props.forwardRef,
        className: className,
        onClick: this.props.onClick
      }, this.props.children));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return this.props.inline ? element : /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo
      });
    }
  }]);

  return ColorPickerPanelComponent;
}(React.Component);

_defineProperty(ColorPickerPanelComponent, "defaultProps", {
  appendTo: null,
  inline: false,
  disabled: false,
  onClick: null
});

var ColorPickerPanel = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(ColorPickerPanelComponent, _extends({
    forwardRef: ref
  }, props));
});

function ownKeys$B(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$B(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$B(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$B(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1X(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1X(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1X() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ColorPicker = /*#__PURE__*/function (_Component) {
  _inherits(ColorPicker, _Component);

  var _super = _createSuper$1X(ColorPicker);

  function ColorPicker(props) {
    var _this;

    _classCallCheck(this, ColorPicker);

    _this = _super.call(this, props);
    _this.state = {
      overlayVisible: false
    };
    _this.onInputClick = _this.onInputClick.bind(_assertThisInitialized(_this));
    _this.onInputKeydown = _this.onInputKeydown.bind(_assertThisInitialized(_this));
    _this.onOverlayEnter = _this.onOverlayEnter.bind(_assertThisInitialized(_this));
    _this.onOverlayEntered = _this.onOverlayEntered.bind(_assertThisInitialized(_this));
    _this.onOverlayExit = _this.onOverlayExit.bind(_assertThisInitialized(_this));
    _this.onOverlayExited = _this.onOverlayExited.bind(_assertThisInitialized(_this));
    _this.onPanelClick = _this.onPanelClick.bind(_assertThisInitialized(_this));
    _this.onColorMousedown = _this.onColorMousedown.bind(_assertThisInitialized(_this));
    _this.onHueMousedown = _this.onHueMousedown.bind(_assertThisInitialized(_this));
    _this.onColorDragStart = _this.onColorDragStart.bind(_assertThisInitialized(_this));
    _this.onHueDragStart = _this.onHueDragStart.bind(_assertThisInitialized(_this));
    _this.onDrag = _this.onDrag.bind(_assertThisInitialized(_this));
    _this.onDragEnd = _this.onDragEnd.bind(_assertThisInitialized(_this));
    _this.overlayRef = /*#__PURE__*/React.createRef();
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(ColorPicker, [{
    key: "onPanelClick",
    value: function onPanelClick(event) {
      if (!this.props.inline) {
        OverlayService.emit('overlay-click', {
          originalEvent: event,
          target: this.container
        });
      }
    }
  }, {
    key: "onHueMousedown",
    value: function onHueMousedown(event) {
      if (this.props.disabled) {
        return;
      }

      this.bindDragListeners();
      this.onHueDragStart(event);
    }
  }, {
    key: "onHueDragStart",
    value: function onHueDragStart(event) {
      if (this.props.disabled) {
        return;
      }

      this.hueDragging = true;
      this.pickHue(event);
      DomHandler.addClass(this.container, 'p-colorpicker-dragging');
    }
  }, {
    key: "pickHue",
    value: function pickHue(event) {
      var top = this.hueView.getBoundingClientRect().top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
      this.hsbValue = this.validateHSB({
        h: Math.floor(360 * (150 - Math.max(0, Math.min(150, (event.pageY || event.changedTouches[0].pageY) - top))) / 150),
        s: 100,
        b: 100
      });
      this.updateColorSelector();
      this.updateHue();
      this.updateModel();
    }
  }, {
    key: "onColorMousedown",
    value: function onColorMousedown(event) {
      if (this.props.disabled) {
        return;
      }

      this.bindDragListeners();
      this.onColorDragStart(event);
    }
  }, {
    key: "onColorDragStart",
    value: function onColorDragStart(event) {
      if (this.props.disabled) {
        return;
      }

      this.colorDragging = true;
      this.pickColor(event);
      DomHandler.addClass(this.container, 'p-colorpicker-dragging');
      event.preventDefault();
    }
  }, {
    key: "onDrag",
    value: function onDrag(event) {
      if (this.colorDragging) {
        this.pickColor(event);
        event.preventDefault();
      }

      if (this.hueDragging) {
        this.pickHue(event);
        event.preventDefault();
      }
    }
  }, {
    key: "onDragEnd",
    value: function onDragEnd() {
      this.colorDragging = false;
      this.hueDragging = false;
      DomHandler.removeClass(this.container, 'p-colorpicker-dragging');
      this.unbindDragListeners();
    }
  }, {
    key: "bindDragListeners",
    value: function bindDragListeners() {
      this.bindDocumentMouseMoveListener();
      this.bindDocumentMouseUpListener();
    }
  }, {
    key: "unbindDragListeners",
    value: function unbindDragListeners() {
      this.unbindDocumentMouseMoveListener();
      this.unbindDocumentMouseUpListener();
    }
  }, {
    key: "pickColor",
    value: function pickColor(event) {
      var rect = this.colorSelector.getBoundingClientRect();
      var top = rect.top + (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
      var left = rect.left + document.body.scrollLeft;
      var saturation = Math.floor(100 * Math.max(0, Math.min(150, (event.pageX || event.changedTouches[0].pageX) - left)) / 150);
      var brightness = Math.floor(100 * (150 - Math.max(0, Math.min(150, (event.pageY || event.changedTouches[0].pageY) - top))) / 150);
      this.hsbValue = this.validateHSB({
        h: this.hsbValue.h,
        s: saturation,
        b: brightness
      });
      this.updateColorHandle();
      this.updateInput();
      this.updateModel();
    }
  }, {
    key: "updateModel",
    value: function updateModel() {
      switch (this.props.format) {
        case 'hex':
          this.onChange(this.HSBtoHEX(this.hsbValue));
          break;

        case 'rgb':
          this.onChange(this.HSBtoRGB(this.hsbValue));
          break;

        case 'hsb':
          this.onChange(this.hsbValue);
          break;
      }
    }
  }, {
    key: "toHSB",
    value: function toHSB(value) {
      var hsb;

      if (value) {
        switch (this.props.format) {
          case 'hex':
            hsb = this.HEXtoHSB(value);
            break;

          case 'rgb':
            hsb = this.RGBtoHSB(value);
            break;

          case 'hsb':
            hsb = value;
            break;
        }
      } else {
        hsb = this.HEXtoHSB(this.props.defaultColor);
      }

      return hsb;
    }
  }, {
    key: "updateHSBValue",
    value: function updateHSBValue(value) {
      this.hsbValue = this.toHSB(value);
    }
  }, {
    key: "areHSBEqual",
    value: function areHSBEqual(val1, val2) {
      return val1.h === val2.h && val1.s === val2.s && val1.b === val2.b;
    }
  }, {
    key: "onChange",
    value: function onChange(value) {
      if (this.props.onChange) {
        this.props.onChange({
          value: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: value
          }
        });
      }
    }
  }, {
    key: "updateColorSelector",
    value: function updateColorSelector() {
      if (this.colorSelector) {
        var hsbValue = this.validateHSB({
          h: this.hsbValue.h,
          s: 100,
          b: 100
        });
        this.colorSelector.style.backgroundColor = '#' + this.HSBtoHEX(hsbValue);
      }
    }
  }, {
    key: "updateColorHandle",
    value: function updateColorHandle() {
      if (this.colorHandle) {
        this.colorHandle.style.left = Math.floor(150 * this.hsbValue.s / 100) + 'px';
        this.colorHandle.style.top = Math.floor(150 * (100 - this.hsbValue.b) / 100) + 'px';
      }
    }
  }, {
    key: "updateHue",
    value: function updateHue() {
      if (this.hueHandle) {
        this.hueHandle.style.top = Math.floor(150 - 150 * this.hsbValue.h / 360) + 'px';
      }
    }
  }, {
    key: "updateInput",
    value: function updateInput() {
      if (this.inputRef && this.inputRef.current) {
        this.inputRef.current.style.backgroundColor = '#' + this.HSBtoHEX(this.hsbValue);
      }
    }
  }, {
    key: "show",
    value: function show() {
      this.setState({
        overlayVisible: true
      });
    }
  }, {
    key: "hide",
    value: function hide() {
      this.setState({
        overlayVisible: false
      });
    }
  }, {
    key: "onOverlayEnter",
    value: function onOverlayEnter() {
      ZIndexUtils.set('overlay', this.overlayRef.current);
      this.alignOverlay();
    }
  }, {
    key: "onOverlayEntered",
    value: function onOverlayEntered() {
      this.bindDocumentClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onOverlayExit",
    value: function onOverlayExit() {
      this.unbindDocumentClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
    }
  }, {
    key: "onOverlayExited",
    value: function onOverlayExited() {
      ZIndexUtils.clear(this.overlayRef.current);
      this.props.onHide && this.props.onHide();
    }
  }, {
    key: "onInputClick",
    value: function onInputClick() {
      this.togglePanel();
    }
  }, {
    key: "togglePanel",
    value: function togglePanel() {
      if (this.state.overlayVisible) this.hide();else this.show();
    }
  }, {
    key: "onInputKeydown",
    value: function onInputKeydown(event) {
      switch (event.which) {
        //space
        case 32:
          this.togglePanel();
          event.preventDefault();
          break;
        //escape and tab

        case 27:
        case 9:
          this.hide();
          break;
      }
    }
  }, {
    key: "bindDocumentClickListener",
    value: function bindDocumentClickListener() {
      var _this2 = this;

      if (!this.documentClickListener) {
        this.documentClickListener = function (event) {
          if (_this2.state.overlayVisible && _this2.isOutsideClicked(event)) {
            _this2.hide();
          }
        };

        document.addEventListener('click', this.documentClickListener);
      }
    }
  }, {
    key: "unbindDocumentClickListener",
    value: function unbindDocumentClickListener() {
      if (this.documentClickListener) {
        document.removeEventListener('click', this.documentClickListener);
        this.documentClickListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this3 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.container, function () {
          if (_this3.state.overlayVisible) {
            _this3.hide();
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "bindResizeListener",
    value: function bindResizeListener() {
      var _this4 = this;

      if (!this.resizeListener) {
        this.resizeListener = function () {
          if (_this4.state.overlayVisible && !DomHandler.isAndroid()) {
            _this4.hide();
          }
        };

        window.addEventListener('resize', this.resizeListener);
      }
    }
  }, {
    key: "unbindResizeListener",
    value: function unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener('resize', this.resizeListener);
        this.resizeListener = null;
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(event) {
      return this.container && !(this.container.isSameNode(event.target) || this.container.contains(event.target) || this.overlayRef && this.overlayRef.current.contains(event.target));
    }
  }, {
    key: "bindDocumentMouseMoveListener",
    value: function bindDocumentMouseMoveListener() {
      if (!this.documentMouseMoveListener) {
        this.documentMouseMoveListener = this.onDocumentMouseMove.bind(this);
        document.addEventListener('mousemove', this.documentMouseMoveListener);
      }
    }
  }, {
    key: "onDocumentMouseMove",
    value: function onDocumentMouseMove(event) {
      if (this.colorDragging) {
        this.pickColor(event);
      }

      if (this.hueDragging) {
        this.pickHue(event);
      }
    }
  }, {
    key: "unbindDocumentMouseMoveListener",
    value: function unbindDocumentMouseMoveListener() {
      if (this.documentMouseMoveListener) {
        document.removeEventListener('mousemove', this.documentMouseMoveListener);
        this.documentMouseMoveListener = null;
      }
    }
  }, {
    key: "bindDocumentMouseUpListener",
    value: function bindDocumentMouseUpListener() {
      if (!this.documentMouseUpListener) {
        this.documentMouseUpListener = this.onDocumentMouseUp.bind(this);
        document.addEventListener('mouseup', this.documentMouseUpListener);
      }
    }
  }, {
    key: "onDocumentMouseUp",
    value: function onDocumentMouseUp() {
      this.colorDragging = false;
      this.hueDragging = false;
      DomHandler.removeClass(this.container, 'p-colorpicker-dragging');
      this.unbindDocumentMouseMoveListener();
      this.unbindDocumentMouseUpListener();
    }
  }, {
    key: "unbindDocumentMouseUpListener",
    value: function unbindDocumentMouseUpListener() {
      if (this.documentMouseUpListener) {
        document.removeEventListener('mouseup', this.documentMouseUpListener);
        this.documentMouseUpListener = null;
      }
    }
  }, {
    key: "validateHSB",
    value: function validateHSB(hsb) {
      return {
        h: Math.min(360, Math.max(0, hsb.h)),
        s: Math.min(100, Math.max(0, hsb.s)),
        b: Math.min(100, Math.max(0, hsb.b))
      };
    }
  }, {
    key: "validateRGB",
    value: function validateRGB(rgb) {
      return {
        r: Math.min(255, Math.max(0, rgb.r)),
        g: Math.min(255, Math.max(0, rgb.g)),
        b: Math.min(255, Math.max(0, rgb.b))
      };
    }
  }, {
    key: "validateHEX",
    value: function validateHEX(hex) {
      var len = 6 - hex.length;

      if (len > 0) {
        var o = [];

        for (var i = 0; i < len; i++) {
          o.push('0');
        }

        o.push(hex);
        hex = o.join('');
      }

      return hex;
    }
  }, {
    key: "HEXtoRGB",
    value: function HEXtoRGB(hex) {
      var hexValue = parseInt(hex.indexOf('#') > -1 ? hex.substring(1) : hex, 16);
      return {
        r: hexValue >> 16,
        g: (hexValue & 0x00FF00) >> 8,
        b: hexValue & 0x0000FF
      };
    }
  }, {
    key: "HEXtoHSB",
    value: function HEXtoHSB(hex) {
      return this.RGBtoHSB(this.HEXtoRGB(hex));
    }
  }, {
    key: "RGBtoHSB",
    value: function RGBtoHSB(rgb) {
      var hsb = {
        h: 0,
        s: 0,
        b: 0
      };
      var min = Math.min(rgb.r, rgb.g, rgb.b);
      var max = Math.max(rgb.r, rgb.g, rgb.b);
      var delta = max - min;
      hsb.b = max;
      hsb.s = max !== 0 ? 255 * delta / max : 0;

      if (hsb.s !== 0) {
        if (rgb.r === max) {
          hsb.h = (rgb.g - rgb.b) / delta;
        } else if (rgb.g === max) {
          hsb.h = 2 + (rgb.b - rgb.r) / delta;
        } else {
          hsb.h = 4 + (rgb.r - rgb.g) / delta;
        }
      } else {
        hsb.h = -1;
      }

      hsb.h *= 60;

      if (hsb.h < 0) {
        hsb.h += 360;
      }

      hsb.s *= 100 / 255;
      hsb.b *= 100 / 255;
      return hsb;
    }
  }, {
    key: "HSBtoRGB",
    value: function HSBtoRGB(hsb) {
      var rgb = {
        r: null,
        g: null,
        b: null
      };
      var h = Math.round(hsb.h);
      var s = Math.round(hsb.s * 255 / 100);
      var v = Math.round(hsb.b * 255 / 100);

      if (s === 0) {
        rgb = {
          r: v,
          g: v,
          b: v
        };
      } else {
        var t1 = v;
        var t2 = (255 - s) * v / 255;
        var t3 = (t1 - t2) * (h % 60) / 60;
        if (h === 360) h = 0;

        if (h < 60) {
          rgb.r = t1;
          rgb.b = t2;
          rgb.g = t2 + t3;
        } else if (h < 120) {
          rgb.g = t1;
          rgb.b = t2;
          rgb.r = t1 - t3;
        } else if (h < 180) {
          rgb.g = t1;
          rgb.r = t2;
          rgb.b = t2 + t3;
        } else if (h < 240) {
          rgb.b = t1;
          rgb.r = t2;
          rgb.g = t1 - t3;
        } else if (h < 300) {
          rgb.b = t1;
          rgb.g = t2;
          rgb.r = t2 + t3;
        } else if (h < 360) {
          rgb.r = t1;
          rgb.g = t2;
          rgb.b = t1 - t3;
        } else {
          rgb.r = 0;
          rgb.g = 0;
          rgb.b = 0;
        }
      }

      return {
        r: Math.round(rgb.r),
        g: Math.round(rgb.g),
        b: Math.round(rgb.b)
      };
    }
  }, {
    key: "RGBtoHEX",
    value: function RGBtoHEX(rgb) {
      var hex = [rgb.r.toString(16), rgb.g.toString(16), rgb.b.toString(16)];

      for (var key in hex) {
        if (hex[key].length === 1) {
          hex[key] = '0' + hex[key];
        }
      }

      return hex.join('');
    }
  }, {
    key: "HSBtoHEX",
    value: function HSBtoHEX(hsb) {
      return this.RGBtoHEX(this.HSBtoRGB(hsb));
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();
      this.updateHSBValue(this.props.value);
      this.updateUI();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!this.colorDragging && !this.hueDragging && this.props.value !== prevProps.value) {
        this.updateHSBValue(this.props.value);
      }

      this.updateUI();

      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$B({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentClickListener();
      this.unbindDocumentMouseMoveListener();
      this.unbindDocumentMouseUpListener();
      this.unbindResizeListener();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }

      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "updateUI",
    value: function updateUI() {
      this.updateHue();
      this.updateColorHandle();
      this.updateInput();
      this.updateColorSelector();
    }
  }, {
    key: "alignOverlay",
    value: function alignOverlay() {
      if (this.inputRef && this.inputRef.current) {
        DomHandler.alignOverlay(this.overlayRef.current, this.inputRef.current.parentElement, this.props.appendTo || PrimeReact.appendTo);
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.container,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "renderColorSelector",
    value: function renderColorSelector() {
      var _this5 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this5.colorSelector = el;
        },
        className: "p-colorpicker-color-selector",
        onMouseDown: this.onColorMousedown,
        onTouchStart: this.onColorDragStart,
        onTouchMove: this.onDrag,
        onTouchEnd: this.onDragEnd
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-colorpicker-color"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this5.colorHandle = el;
        },
        className: "p-colorpicker-color-handle"
      })));
    }
  }, {
    key: "renderHue",
    value: function renderHue() {
      var _this6 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this6.hueView = el;
        },
        className: "p-colorpicker-hue",
        onMouseDown: this.onHueMousedown,
        onTouchStart: this.onHueDragStart,
        onTouchMove: this.onDrag,
        onTouchEnd: this.onDragEnd
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this6.hueHandle = el;
        },
        className: "p-colorpicker-hue-handle"
      }));
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var colorSelector = this.renderColorSelector();
      var hue = this.renderHue();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-colorpicker-content"
      }, colorSelector, hue);
    }
  }, {
    key: "renderInput",
    value: function renderInput() {
      if (!this.props.inline) {
        var inputClassName = classNames('p-colorpicker-preview p-inputtext', {
          'p-disabled': this.props.disabled
        });
        var inputProps = ObjectUtils.findDiffKeys(this.props, ColorPicker.defaultProps);
        return /*#__PURE__*/React__default['default'].createElement("input", _extends({
          ref: this.inputRef,
          type: "text",
          className: inputClassName,
          readOnly: true,
          id: this.props.inputId,
          tabIndex: this.props.tabIndex,
          disabled: this.props.disabled,
          onClick: this.onInputClick,
          onKeyDown: this.onInputKeydown
        }, inputProps));
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this7 = this;

      var containerClassName = classNames('p-colorpicker p-component', {
        'p-colorpicker-overlay': !this.props.inline
      }, this.props.className);
      var content = this.renderContent();
      var input = this.renderInput();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this7.container = el;
        },
        id: this.props.id,
        style: this.props.style,
        className: containerClassName
      }, input, /*#__PURE__*/React__default['default'].createElement(ColorPickerPanel, {
        ref: this.overlayRef,
        appendTo: this.props.appendTo,
        inline: this.props.inline,
        disabled: this.props.disabled,
        onClick: this.onPanelClick,
        in: this.props.inline || this.state.overlayVisible,
        onEnter: this.onOverlayEnter,
        onEntered: this.onOverlayEntered,
        onExit: this.onOverlayExit,
        onExited: this.onOverlayExited,
        transitionOptions: this.props.transitionOptions
      }, content));
    }
  }]);

  return ColorPicker;
}(React.Component);

_defineProperty(ColorPicker, "defaultProps", {
  id: null,
  inputRef: null,
  value: null,
  style: null,
  className: null,
  defaultColor: 'ff0000',
  inline: false,
  format: 'hex',
  appendTo: null,
  disabled: false,
  tabIndex: null,
  inputId: null,
  tooltip: null,
  tooltipOptions: null,
  transitionOptions: null,
  onChange: null,
  onShow: null,
  onHide: null
});

function _createSuper$1W(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1W(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1W() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Column = /*#__PURE__*/function (_Component) {
  _inherits(Column, _Component);

  var _super = _createSuper$1W(Column);

  function Column() {
    _classCallCheck(this, Column);

    return _super.apply(this, arguments);
  }

  return Column;
}(React.Component);

_defineProperty(Column, "defaultProps", {
  columnKey: null,
  field: null,
  sortField: null,
  filterField: null,
  header: null,
  body: null,
  loadingBody: null,
  footer: null,
  sortable: false,
  sortableDisabled: false,
  sortFunction: null,
  filter: false,
  filterMatchMode: 'startsWith',
  filterPlaceholder: null,
  filterType: 'text',
  filterMaxLength: null,
  filterElement: null,
  filterFunction: null,
  filterHeaderStyle: null,
  filterHeaderClassName: null,
  style: null,
  className: null,
  headerStyle: null,
  headerClassName: null,
  bodyStyle: null,
  bodyClassName: null,
  footerStyle: null,
  footerClassName: null,
  expander: false,
  frozen: false,
  selectionMode: null,
  colSpan: null,
  rowSpan: null,
  editor: null,
  editorValidator: null,
  editorValidatorEvent: 'click',
  onBeforeEditorHide: null,
  onBeforeEditorShow: null,
  onEditorInit: null,
  onEditorSubmit: null,
  onEditorCancel: null,
  excludeGlobalFilter: false,
  rowReorder: false,
  rowReorderIcon: 'pi pi-bars',
  rowEditor: false,
  exportable: true,
  reorderable: true
});

function _createSuper$1V(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1V(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1V() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ColumnGroup = /*#__PURE__*/function (_Component) {
  _inherits(ColumnGroup, _Component);

  var _super = _createSuper$1V(ColumnGroup);

  function ColumnGroup() {
    _classCallCheck(this, ColumnGroup);

    return _super.apply(this, arguments);
  }

  return ColumnGroup;
}(React.Component);

function _createSuper$1U(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1U(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1U() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Dialog = /*#__PURE__*/function (_Component) {
  _inherits(Dialog, _Component);

  var _super = _createSuper$1U(Dialog);

  function Dialog(props) {
    var _this;

    _classCallCheck(this, Dialog);

    _this = _super.call(this, props);
    _this.state = {
      id: props.id,
      maskVisible: props.visible,
      visible: false
    };

    if (!_this.props.onMaximize) {
      _this.state.maximized = props.maximized;
    }

    _this.onClose = _this.onClose.bind(_assertThisInitialized(_this));
    _this.toggleMaximize = _this.toggleMaximize.bind(_assertThisInitialized(_this));
    _this.onDragStart = _this.onDragStart.bind(_assertThisInitialized(_this));
    _this.onResizeStart = _this.onResizeStart.bind(_assertThisInitialized(_this));
    _this.onMaskClick = _this.onMaskClick.bind(_assertThisInitialized(_this));
    _this.onEnter = _this.onEnter.bind(_assertThisInitialized(_this));
    _this.onEntered = _this.onEntered.bind(_assertThisInitialized(_this));
    _this.onExited = _this.onExited.bind(_assertThisInitialized(_this));
    _this.attributeSelector = UniqueComponentId();
    _this.dialogRef = /*#__PURE__*/React__default['default'].createRef();
    return _this;
  }

  _createClass(Dialog, [{
    key: "onClose",
    value: function onClose(event) {
      this.props.onHide();
      event.preventDefault();
    }
  }, {
    key: "focus",
    value: function focus() {
      var activeElement = document.activeElement;
      var isActiveElementInDialog = activeElement && this.dialogRef && this.dialogRef.current.contains(activeElement);

      if (!isActiveElementInDialog && this.props.closable && this.props.showHeader) {
        this.closeElement.focus();
      }
    }
  }, {
    key: "onMaskClick",
    value: function onMaskClick(event) {
      if (this.props.dismissableMask && this.props.modal && this.mask === event.target) {
        this.onClose(event);
      }

      this.props.onMaskClick && this.props.onMaskClick(event);
    }
  }, {
    key: "toggleMaximize",
    value: function toggleMaximize(event) {
      var maximized = !this.maximized;

      if (this.props.onMaximize) {
        this.props.onMaximize({
          originalEvent: event,
          maximized: maximized
        });
      } else {
        this.setState({
          maximized: maximized
        }, this.changeScrollOnMaximizable);
      }

      event.preventDefault();
    }
  }, {
    key: "onDragStart",
    value: function onDragStart(event) {
      if (DomHandler.hasClass(event.target, 'p-dialog-header-icon') || DomHandler.hasClass(event.target.parentElement, 'p-dialog-header-icon')) {
        return;
      }

      if (this.props.draggable) {
        this.dragging = true;
        this.lastPageX = event.pageX;
        this.lastPageY = event.pageY;
        this.dialogEl.style.margin = '0';
        DomHandler.addClass(document.body, 'p-unselectable-text');

        if (this.props.onDragStart) {
          this.props.onDragStart(event);
        }
      }
    }
  }, {
    key: "onDrag",
    value: function onDrag(event) {
      if (this.dragging) {
        var width = DomHandler.getOuterWidth(this.dialogEl);
        var height = DomHandler.getOuterHeight(this.dialogEl);
        var deltaX = event.pageX - this.lastPageX;
        var deltaY = event.pageY - this.lastPageY;
        var offset = this.dialogEl.getBoundingClientRect();
        var leftPos = offset.left + deltaX;
        var topPos = offset.top + deltaY;
        var viewport = DomHandler.getViewport();
        this.dialogEl.style.position = 'fixed';

        if (this.props.keepInViewport) {
          if (leftPos >= this.props.minX && leftPos + width < viewport.width) {
            this.lastPageX = event.pageX;
            this.dialogEl.style.left = leftPos + 'px';
          }

          if (topPos >= this.props.minY && topPos + height < viewport.height) {
            this.lastPageY = event.pageY;
            this.dialogEl.style.top = topPos + 'px';
          }
        } else {
          this.lastPageX = event.pageX;
          this.dialogEl.style.left = leftPos + 'px';
          this.lastPageY = event.pageY;
          this.dialogEl.style.top = topPos + 'px';
        }

        if (this.props.onDrag) {
          this.props.onDrag(event);
        }
      }
    }
  }, {
    key: "onDragEnd",
    value: function onDragEnd(event) {
      if (this.dragging) {
        this.dragging = false;
        DomHandler.removeClass(document.body, 'p-unselectable-text');

        if (this.props.onDragEnd) {
          this.props.onDragEnd(event);
        }
      }
    }
  }, {
    key: "onResizeStart",
    value: function onResizeStart(event) {
      if (this.props.resizable) {
        this.resizing = true;
        this.lastPageX = event.pageX;
        this.lastPageY = event.pageY;
        DomHandler.addClass(document.body, 'p-unselectable-text');

        if (this.props.onResizeStart) {
          this.props.onResizeStart(event);
        }
      }
    }
  }, {
    key: "convertToPx",
    value: function convertToPx(value, property, viewport) {
      !viewport && (viewport = DomHandler.getViewport());
      var val = parseInt(value);

      if (/^(\d+|(\.\d+))(\.\d+)?%$/.test(value)) {
        return val * (viewport[property] / 100);
      }

      return val;
    }
  }, {
    key: "onResize",
    value: function onResize(event) {
      if (this.resizing) {
        var deltaX = event.pageX - this.lastPageX;
        var deltaY = event.pageY - this.lastPageY;
        var width = DomHandler.getOuterWidth(this.dialogEl);
        var height = DomHandler.getOuterHeight(this.dialogEl);
        var offset = this.dialogEl.getBoundingClientRect();
        var viewport = DomHandler.getViewport();
        var newWidth = width + deltaX;
        var newHeight = height + deltaY;
        var minWidth = this.convertToPx(this.dialogEl.style.minWidth, 'width', viewport);
        var minHeight = this.convertToPx(this.dialogEl.style.minHeight, 'height', viewport);
        var hasBeenDragged = !parseInt(this.dialogEl.style.top) || !parseInt(this.dialogEl.style.left);

        if (hasBeenDragged) {
          newWidth += deltaX;
          newHeight += deltaY;
        }

        if ((!minWidth || newWidth > minWidth) && offset.left + newWidth < viewport.width) {
          this.dialogEl.style.width = newWidth + 'px';
        }

        if ((!minHeight || newHeight > minHeight) && offset.top + newHeight < viewport.height) {
          this.dialogEl.style.height = newHeight + 'px';
        }

        this.lastPageX = event.pageX;
        this.lastPageY = event.pageY;

        if (this.props.onResize) {
          this.props.onResize(event);
        }
      }
    }
  }, {
    key: "onResizeEnd",
    value: function onResizeEnd(event) {
      if (this.resizing) {
        this.resizing = false;
        DomHandler.removeClass(document.body, 'p-unselectable-text');

        if (this.props.onResizeEnd) {
          this.props.onResizeEnd(event);
        }
      }
    }
  }, {
    key: "resetPosition",
    value: function resetPosition() {
      this.dialogEl.style.position = '';
      this.dialogEl.style.left = '';
      this.dialogEl.style.top = '';
      this.dialogEl.style.margin = '';
    }
  }, {
    key: "getPositionClass",
    value: function getPositionClass() {
      var _this2 = this;

      var positions = ['center', 'left', 'right', 'top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right'];
      var pos = positions.find(function (item) {
        return item === _this2.props.position || item.replace('-', '') === _this2.props.position;
      });
      return pos ? "p-dialog-".concat(pos) : '';
    }
  }, {
    key: "maximized",
    get: function get() {
      return this.props.onMaximize ? this.props.maximized : this.state.maximized;
    }
  }, {
    key: "dialogEl",
    get: function get() {
      return this.dialogRef.current;
    }
  }, {
    key: "onEnter",
    value: function onEnter() {
      this.dialogEl.setAttribute(this.attributeSelector, '');
    }
  }, {
    key: "onEntered",
    value: function onEntered() {
      if (this.props.onShow) {
        this.props.onShow();
      }

      if (this.props.focusOnShow) {
        this.focus();
      }

      this.enableDocumentSettings();
    }
  }, {
    key: "onExited",
    value: function onExited() {
      this.dragging = false;
      ZIndexUtils.clear(this.mask);
      this.setState({
        maskVisible: false
      });
      DomHandler.addClass(this.mask, 'p-component-overlay-leave');
      this.disableDocumentSettings();
    }
  }, {
    key: "enableDocumentSettings",
    value: function enableDocumentSettings() {
      this.bindGlobalListeners();

      if (this.props.blockScroll || this.props.maximizable && this.maximized) {
        DomHandler.addClass(document.body, 'p-overflow-hidden');
      }
    }
  }, {
    key: "disableDocumentSettings",
    value: function disableDocumentSettings() {
      this.unbindGlobalListeners();

      if (this.props.modal) {
        var hasBlockScroll = document.primeDialogParams && document.primeDialogParams.some(function (param) {
          return param.hasBlockScroll;
        });

        if (!hasBlockScroll) {
          DomHandler.removeClass(document.body, 'p-overflow-hidden');
        }
      } else if (this.props.blockScroll || this.props.maximizable && this.maximized) {
        DomHandler.removeClass(document.body, 'p-overflow-hidden');
      }
    }
  }, {
    key: "bindGlobalListeners",
    value: function bindGlobalListeners() {
      if (this.props.draggable) {
        this.bindDocumentDragListener();
      }

      if (this.props.resizable) {
        this.bindDocumentResizeListeners();
      }

      if (this.props.closeOnEscape && this.props.closable) {
        this.bindDocumentKeyDownListener();
      }
    }
  }, {
    key: "unbindGlobalListeners",
    value: function unbindGlobalListeners() {
      this.unbindDocumentDragListener();
      this.unbindDocumentResizeListeners();
      this.unbindDocumentKeyDownListener();
    }
  }, {
    key: "bindDocumentDragListener",
    value: function bindDocumentDragListener() {
      this.documentDragListener = this.onDrag.bind(this);
      this.documentDragEndListener = this.onDragEnd.bind(this);
      window.document.addEventListener('mousemove', this.documentDragListener);
      window.document.addEventListener('mouseup', this.documentDragEndListener);
    }
  }, {
    key: "unbindDocumentDragListener",
    value: function unbindDocumentDragListener() {
      if (this.documentDragListener && this.documentDragEndListener) {
        window.document.removeEventListener('mousemove', this.documentDragListener);
        window.document.removeEventListener('mouseup', this.documentDragEndListener);
        this.documentDragListener = null;
        this.documentDragEndListener = null;
      }
    }
  }, {
    key: "bindDocumentResizeListeners",
    value: function bindDocumentResizeListeners() {
      this.documentResizeListener = this.onResize.bind(this);
      this.documentResizeEndListener = this.onResizeEnd.bind(this);
      window.document.addEventListener('mousemove', this.documentResizeListener);
      window.document.addEventListener('mouseup', this.documentResizeEndListener);
    }
  }, {
    key: "unbindDocumentResizeListeners",
    value: function unbindDocumentResizeListeners() {
      if (this.documentResizeListener && this.documentResizeEndListener) {
        window.document.removeEventListener('mousemove', this.documentResizeListener);
        window.document.removeEventListener('mouseup', this.documentResizeEndListener);
        this.documentResizeListener = null;
        this.documentResizeEndListener = null;
      }
    }
  }, {
    key: "bindDocumentKeyDownListener",
    value: function bindDocumentKeyDownListener() {
      var _this3 = this;

      this.documentKeyDownListener = function (event) {
        var currentTarget = event.currentTarget;

        if (currentTarget && currentTarget.primeDialogParams) {
          var params = currentTarget.primeDialogParams;
          var paramLength = params.length;
          var dialogId = params[paramLength - 1] ? params[paramLength - 1].id : undefined;

          if (dialogId === _this3.state.id) {
            var dialog = document.getElementById(dialogId);

            if (event.which === 27) {
              _this3.onClose(event);

              event.stopImmediatePropagation();
              params.splice(paramLength - 1, 1);
            } else if (event.which === 9) {
              event.preventDefault();
              var focusableElements = DomHandler.getFocusableElements(dialog);

              if (focusableElements && focusableElements.length > 0) {
                if (!document.activeElement) {
                  focusableElements[0].focus();
                } else {
                  var focusedIndex = focusableElements.indexOf(document.activeElement);

                  if (event.shiftKey) {
                    if (focusedIndex === -1 || focusedIndex === 0) focusableElements[focusableElements.length - 1].focus();else focusableElements[focusedIndex - 1].focus();
                  } else {
                    if (focusedIndex === -1 || focusedIndex === focusableElements.length - 1) focusableElements[0].focus();else focusableElements[focusedIndex + 1].focus();
                  }
                }
              }
            }
          }
        }
      };

      var newParam = {
        id: this.state.id,
        hasBlockScroll: this.props.blockScroll
      };
      document.primeDialogParams = document.primeDialogParams ? [].concat(_toConsumableArray(document.primeDialogParams), [newParam]) : [newParam];
      document.addEventListener('keydown', this.documentKeyDownListener);
    }
  }, {
    key: "unbindDocumentKeyDownListener",
    value: function unbindDocumentKeyDownListener() {
      var _this4 = this;

      if (this.documentKeyDownListener) {
        document.removeEventListener('keydown', this.documentKeyDownListener);
        document.primeDialogParams = document.primeDialogParams && document.primeDialogParams.filter(function (param) {
          return param.id !== _this4.state.id;
        });
        this.documentKeyDownListener = null;
      }
    }
  }, {
    key: "createStyle",
    value: function createStyle() {
      if (!this.styleElement) {
        this.styleElement = document.createElement('style');
        document.head.appendChild(this.styleElement);
        var innerHTML = '';

        for (var breakpoint in this.props.breakpoints) {
          innerHTML += "\n                    @media screen and (max-width: ".concat(breakpoint, ") {\n                        .p-dialog[").concat(this.attributeSelector, "] {\n                            width: ").concat(this.props.breakpoints[breakpoint], " !important;\n                        }\n                    }\n                ");
        }

        this.styleElement.innerHTML = innerHTML;
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this5 = this;

      if (!this.state.id) {
        this.setState({
          id: UniqueComponentId()
        });
      }

      if (this.props.visible) {
        this.setState({
          visible: true
        }, function () {
          ZIndexUtils.set('modal', _this5.mask, _this5.props.baseZIndex);
        });
      }

      if (this.props.breakpoints) {
        this.createStyle();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this6 = this;

      if (this.props.visible && !this.state.maskVisible) {
        this.setState({
          maskVisible: true
        }, function () {
          ZIndexUtils.set('modal', _this6.mask, _this6.props.baseZIndex);
        });
      }

      if (this.props.visible !== this.state.visible && this.state.maskVisible) {
        this.setState({
          visible: this.props.visible
        });
      }

      if (prevProps.maximized !== this.props.maximized && this.props.onMaximize) {
        this.changeScrollOnMaximizable();
      }
    }
  }, {
    key: "changeScrollOnMaximizable",
    value: function changeScrollOnMaximizable() {
      if (!this.props.blockScroll) {
        var funcName = this.maximized ? 'addClass' : 'removeClass';
        DomHandler[funcName](document.body, 'p-overflow-hidden');
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.disableDocumentSettings();

      if (this.styleElement) {
        document.head.removeChild(this.styleElement);
        this.styleElement = null;
      }

      ZIndexUtils.clear(this.mask);
    }
  }, {
    key: "renderCloseIcon",
    value: function renderCloseIcon() {
      var _this7 = this;

      if (this.props.closable) {
        return /*#__PURE__*/React__default['default'].createElement("button", {
          ref: function ref(el) {
            return _this7.closeElement = el;
          },
          type: "button",
          className: "p-dialog-header-icon p-dialog-header-close p-link",
          "aria-label": this.props.ariaCloseIconLabel,
          onClick: this.onClose
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-dialog-header-close-icon pi pi-times"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderMaximizeIcon",
    value: function renderMaximizeIcon() {
      var iconClassName = classNames('p-dialog-header-maximize-icon pi', {
        'pi-window-maximize': !this.maximized,
        'pi-window-minimize': this.maximized
      });

      if (this.props.maximizable) {
        return /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-dialog-header-icon p-dialog-header-maximize p-link",
          onClick: this.toggleMaximize
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: iconClassName
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      var _this8 = this;

      if (this.props.showHeader) {
        var closeIcon = this.renderCloseIcon();
        var maximizeIcon = this.renderMaximizeIcon();
        var icons = ObjectUtils.getJSXElement(this.props.icons, this.props);
        var header = ObjectUtils.getJSXElement(this.props.header, this.props);
        return /*#__PURE__*/React__default['default'].createElement("div", {
          ref: function ref(el) {
            return _this8.headerEl = el;
          },
          className: "p-dialog-header",
          onMouseDown: this.onDragStart
        }, /*#__PURE__*/React__default['default'].createElement("div", {
          id: this.state.id + '_header',
          className: "p-dialog-title"
        }, header), /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-dialog-header-icons"
        }, icons, maximizeIcon, closeIcon));
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this9 = this;

      var contentClassName = classNames('p-dialog-content', this.props.contentClassName);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.state.id + '_content',
        ref: function ref(el) {
          return _this9.contentEl = el;
        },
        className: contentClassName,
        style: this.props.contentStyle
      }, this.props.children);
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      var _this10 = this;

      var footer = ObjectUtils.getJSXElement(this.props.footer, this.props);
      return footer && /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this10.footerElement = el;
        },
        className: "p-dialog-footer"
      }, footer);
    }
  }, {
    key: "renderResizer",
    value: function renderResizer() {
      if (this.props.resizable) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-resizable-handle",
          style: {
            zIndex: 90
          },
          onMouseDown: this.onResizeStart
        });
      }

      return null;
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var _this11 = this;

      var className = classNames('p-dialog p-component', this.props.className, {
        'p-dialog-rtl': this.props.rtl,
        'p-dialog-maximized': this.maximized
      });
      var maskClassName = classNames('p-dialog-mask', {
        'p-component-overlay p-component-overlay-enter': this.props.modal,
        'p-dialog-visible': this.state.maskVisible,
        'p-dialog-draggable': this.props.draggable,
        'p-dialog-resizable': this.props.resizable
      }, this.props.maskClassName, this.getPositionClass());
      var header = this.renderHeader();
      var content = this.renderContent();
      var footer = this.renderFooter();
      var resizer = this.renderResizer();
      var transitionTimeout = {
        enter: this.props.position === 'center' ? 150 : 300,
        exit: this.props.position === 'center' ? 150 : 300
      };
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this11.mask = el;
        },
        className: maskClassName,
        onClick: this.onMaskClick
      }, /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.dialogRef,
        classNames: "p-dialog",
        timeout: transitionTimeout,
        in: this.state.visible,
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.onEnter,
        onEntered: this.onEntered,
        onExited: this.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.dialogRef,
        id: this.state.id,
        className: className,
        style: this.props.style,
        onClick: this.props.onClick,
        role: "dialog",
        "aria-labelledby": this.state.id + '_header',
        "aria-describedby": this.state.id + '_content',
        "aria-modal": this.props.modal
      }, header, content, footer, resizer)));
    }
  }, {
    key: "render",
    value: function render() {
      if (this.state.maskVisible) {
        var element = this.renderElement();
        return /*#__PURE__*/React__default['default'].createElement(Portal, {
          element: element,
          appendTo: this.props.appendTo,
          visible: true
        });
      }

      return null;
    }
  }]);

  return Dialog;
}(React.Component);

_defineProperty(Dialog, "defaultProps", {
  id: null,
  header: null,
  footer: null,
  visible: false,
  position: 'center',
  draggable: true,
  resizable: true,
  modal: true,
  onHide: null,
  onShow: null,
  contentStyle: null,
  contentClassName: null,
  closeOnEscape: true,
  dismissableMask: false,
  rtl: false,
  closable: true,
  style: null,
  className: null,
  maskClassName: null,
  showHeader: true,
  appendTo: null,
  baseZIndex: 0,
  maximizable: false,
  blockScroll: false,
  icons: null,
  ariaCloseIconLabel: 'Close',
  focusOnShow: true,
  minX: 0,
  minY: 0,
  keepInViewport: true,
  maximized: false,
  breakpoints: null,
  transitionOptions: null,
  onMaximize: null,
  onDragStart: null,
  onDrag: null,
  onDragEnd: null,
  onResizeStart: null,
  onResize: null,
  onResizeEnd: null,
  onClick: null,
  onMaskClick: null
});

function _createSuper$1T(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1T(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1T() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys$A(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$A(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$A(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$A(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
function confirmDialog(props) {
  var appendTo = props.appendTo || document.body;
  var confirmDialogWrapper = document.createDocumentFragment();
  DomHandler.appendChild(confirmDialogWrapper, appendTo);
  props = _objectSpread$A(_objectSpread$A({}, props), {
    visible: props.visible === undefined ? true : props.visible
  });
  var confirmDialogEl = /*#__PURE__*/React__default['default'].createElement(ConfirmDialog, props);
  ReactDOM__default['default'].render(confirmDialogEl, confirmDialogWrapper);

  var updateConfirmDialog = function updateConfirmDialog(newProps) {
    props = _objectSpread$A(_objectSpread$A({}, props), newProps);
    ReactDOM__default['default'].render( /*#__PURE__*/React__default['default'].cloneElement(confirmDialogEl, props), confirmDialogWrapper);
  };

  return {
    _destroy: function _destroy() {
      ReactDOM__default['default'].unmountComponentAtNode(confirmDialogWrapper);
    },
    show: function show() {
      updateConfirmDialog({
        visible: true,
        onHide: function onHide() {
          updateConfirmDialog({
            visible: false
          }); // reset
        }
      });
    },
    hide: function hide() {
      updateConfirmDialog({
        visible: false
      });
    },
    update: function update(newProps) {
      updateConfirmDialog(newProps);
    }
  };
}
var ConfirmDialog = /*#__PURE__*/function (_Component) {
  _inherits(ConfirmDialog, _Component);

  var _super = _createSuper$1T(ConfirmDialog);

  function ConfirmDialog(props) {
    var _this;

    _classCallCheck(this, ConfirmDialog);

    _this = _super.call(this, props);
    _this.state = {
      visible: props.visible
    };
    _this.reject = _this.reject.bind(_assertThisInitialized(_this));
    _this.accept = _this.accept.bind(_assertThisInitialized(_this));
    _this.hide = _this.hide.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(ConfirmDialog, [{
    key: "acceptLabel",
    value: function acceptLabel() {
      return this.props.acceptLabel || localeOption('accept');
    }
  }, {
    key: "rejectLabel",
    value: function rejectLabel() {
      return this.props.rejectLabel || localeOption('reject');
    }
  }, {
    key: "accept",
    value: function accept() {
      if (this.props.accept) {
        this.props.accept();
      }

      this.hide('accept');
    }
  }, {
    key: "reject",
    value: function reject() {
      if (this.props.reject) {
        this.props.reject();
      }

      this.hide('reject');
    }
  }, {
    key: "show",
    value: function show() {
      this.setState({
        visible: true
      });
    }
  }, {
    key: "hide",
    value: function hide(result) {
      var _this2 = this;

      this.setState({
        visible: false
      }, function () {
        if (_this2.props.onHide) {
          _this2.props.onHide(result);
        }
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.visible !== this.props.visible) {
        this.setState({
          visible: this.props.visible
        });
      }
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      var acceptClassName = classNames('p-confirm-dialog-accept', this.props.acceptClassName);
      var rejectClassName = classNames('p-confirm-dialog-reject', {
        'p-button-text': !this.props.rejectClassName
      }, this.props.rejectClassName);
      var content = /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement(Button, {
        label: this.rejectLabel(),
        icon: this.props.rejectIcon,
        className: rejectClassName,
        onClick: this.reject
      }), /*#__PURE__*/React__default['default'].createElement(Button, {
        label: this.acceptLabel(),
        icon: this.props.acceptIcon,
        className: acceptClassName,
        onClick: this.accept,
        autoFocus: true
      }));

      if (this.props.footer) {
        var defaultContentOptions = {
          accept: this.accept,
          reject: this.reject,
          acceptClassName: acceptClassName,
          rejectClassName: rejectClassName,
          acceptLabel: this.acceptLabel(),
          rejectLabel: this.rejectLabel(),
          element: content,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.footer, defaultContentOptions);
      }

      return content;
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var className = classNames('p-confirm-dialog', this.props.className);
      var iconClassName = classNames('p-confirm-dialog-icon', this.props.icon);
      var dialogProps = ObjectUtils.findDiffKeys(this.props, ConfirmDialog.defaultProps);
      var message = ObjectUtils.getJSXElement(this.props.message, this.props);
      var footer = this.renderFooter();
      return /*#__PURE__*/React__default['default'].createElement(Dialog, _extends({
        visible: this.state.visible
      }, dialogProps, {
        className: className,
        footer: footer,
        onHide: this.hide,
        breakpoints: this.props.breakpoints
      }), /*#__PURE__*/React__default['default'].createElement("i", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-confirm-dialog-message"
      }, message));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo
      });
    }
  }]);

  return ConfirmDialog;
}(React.Component);

_defineProperty(ConfirmDialog, "defaultProps", {
  visible: false,
  message: null,
  rejectLabel: null,
  acceptLabel: null,
  icon: null,
  rejectIcon: null,
  acceptIcon: null,
  rejectClassName: null,
  acceptClassName: null,
  className: null,
  appendTo: null,
  footer: null,
  breakpoints: null,
  onHide: null,
  accept: null,
  reject: null
});

function _createSuper$1S(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1S(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1S() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys$z(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$z(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$z(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$z(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }
function confirmPopup(props) {
  var appendTo = props.appendTo || document.body;
  var confirmPopupWrapper = document.createDocumentFragment();
  DomHandler.appendChild(confirmPopupWrapper, appendTo);
  props = _objectSpread$z(_objectSpread$z({}, props), {
    visible: props.visible === undefined ? true : props.visible
  });
  var confirmPopupEl = /*#__PURE__*/React__default['default'].createElement(ConfirmPopup, props);
  ReactDOM__default['default'].render(confirmPopupEl, confirmPopupWrapper);

  var updateConfirmPopup = function updateConfirmPopup(newProps) {
    props = _objectSpread$z(_objectSpread$z({}, props), newProps);
    ReactDOM__default['default'].render( /*#__PURE__*/React__default['default'].cloneElement(confirmPopupEl, props), confirmPopupWrapper);
  };

  return {
    _destroy: function _destroy() {
      ReactDOM__default['default'].unmountComponentAtNode(confirmPopupWrapper);
    },
    show: function show() {
      updateConfirmPopup({
        visible: true,
        onHide: function onHide() {
          updateConfirmPopup({
            visible: false
          }); // reset
        }
      });
    },
    hide: function hide() {
      updateConfirmPopup({
        visible: false
      });
    },
    update: function update(newProps) {
      updateConfirmPopup(newProps);
    }
  };
}
var ConfirmPopup = /*#__PURE__*/function (_Component) {
  _inherits(ConfirmPopup, _Component);

  var _super = _createSuper$1S(ConfirmPopup);

  function ConfirmPopup(props) {
    var _this;

    _classCallCheck(this, ConfirmPopup);

    _this = _super.call(this, props);
    _this.state = {
      visible: false
    };
    _this.reject = _this.reject.bind(_assertThisInitialized(_this));
    _this.accept = _this.accept.bind(_assertThisInitialized(_this));
    _this.hide = _this.hide.bind(_assertThisInitialized(_this));
    _this.onCloseClick = _this.onCloseClick.bind(_assertThisInitialized(_this));
    _this.onPanelClick = _this.onPanelClick.bind(_assertThisInitialized(_this));
    _this.onEnter = _this.onEnter.bind(_assertThisInitialized(_this));
    _this.onEntered = _this.onEntered.bind(_assertThisInitialized(_this));
    _this.onExit = _this.onExit.bind(_assertThisInitialized(_this));
    _this.onExited = _this.onExited.bind(_assertThisInitialized(_this));
    _this.overlayRef = /*#__PURE__*/React__default['default'].createRef();
    _this.acceptBtnRef = /*#__PURE__*/React__default['default'].createRef();
    return _this;
  }

  _createClass(ConfirmPopup, [{
    key: "acceptLabel",
    value: function acceptLabel() {
      return this.props.acceptLabel || localeOption('accept');
    }
  }, {
    key: "rejectLabel",
    value: function rejectLabel() {
      return this.props.rejectLabel || localeOption('reject');
    }
  }, {
    key: "bindDocumentClickListener",
    value: function bindDocumentClickListener() {
      var _this2 = this;

      if (!this.documentClickListener && this.props.dismissable) {
        this.documentClickListener = function (event) {
          if (!_this2.isPanelClicked && _this2.isOutsideClicked(event.target)) {
            _this2.hide();
          }

          _this2.isPanelClicked = false;
        };

        document.addEventListener('click', this.documentClickListener);
      }
    }
  }, {
    key: "unbindDocumentClickListener",
    value: function unbindDocumentClickListener() {
      if (this.documentClickListener) {
        document.removeEventListener('click', this.documentClickListener);
        this.documentClickListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this3 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.props.target, function () {
          if (_this3.state.visible) {
            _this3.hide();
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "bindResizeListener",
    value: function bindResizeListener() {
      var _this4 = this;

      if (!this.resizeListener) {
        this.resizeListener = function () {
          if (_this4.state.visible && !DomHandler.isAndroid()) {
            _this4.hide();
          }
        };

        window.addEventListener('resize', this.resizeListener);
      }
    }
  }, {
    key: "unbindResizeListener",
    value: function unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener('resize', this.resizeListener);
        this.resizeListener = null;
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(target) {
      return this.overlayRef && this.overlayRef.current && !(this.overlayRef.current.isSameNode(target) || this.overlayRef.current.contains(target));
    }
  }, {
    key: "onCloseClick",
    value: function onCloseClick(event) {
      this.hide();
      event.preventDefault();
    }
  }, {
    key: "onPanelClick",
    value: function onPanelClick(event) {
      this.isPanelClicked = true;
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: this.props.target
      });
    }
  }, {
    key: "accept",
    value: function accept() {
      if (this.props.accept) {
        this.props.accept();
      }

      this.hide('accept');
    }
  }, {
    key: "reject",
    value: function reject() {
      if (this.props.reject) {
        this.props.reject();
      }

      this.hide('reject');
    }
  }, {
    key: "show",
    value: function show() {
      var _this5 = this;

      this.setState({
        visible: true
      }, function () {
        _this5.overlayEventListener = function (e) {
          if (!_this5.isOutsideClicked(e.target)) {
            _this5.isPanelClicked = true;
          }
        };

        OverlayService.on('overlay-click', _this5.overlayEventListener);
      });
    }
  }, {
    key: "hide",
    value: function hide(result) {
      var _this6 = this;

      this.setState({
        visible: false
      }, function () {
        OverlayService.off('overlay-click', _this6.overlayEventListener);
        _this6.overlayEventListener = null;

        if (_this6.props.onHide) {
          _this6.props.onHide(result);
        }
      });
    }
  }, {
    key: "onEnter",
    value: function onEnter() {
      ZIndexUtils.set('overlay', this.overlayRef.current);
      this.align();
    }
  }, {
    key: "onEntered",
    value: function onEntered() {
      this.bindDocumentClickListener();
      this.bindScrollListener();
      this.bindResizeListener();

      if (this.acceptBtnRef && this.acceptBtnRef.current) {
        this.acceptBtnRef.current.focus();
      }

      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onExit",
    value: function onExit() {
      this.unbindDocumentClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
    }
  }, {
    key: "onExited",
    value: function onExited() {
      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "align",
    value: function align() {
      if (this.props.target) {
        DomHandler.absolutePosition(this.overlayRef.current, this.props.target);
        var containerOffset = DomHandler.getOffset(this.overlayRef.current);
        var targetOffset = DomHandler.getOffset(this.props.target);
        var arrowLeft = 0;

        if (containerOffset.left < targetOffset.left) {
          arrowLeft = targetOffset.left - containerOffset.left;
        }

        this.overlayRef.current.style.setProperty('--overlayArrowLeft', "".concat(arrowLeft, "px"));

        if (containerOffset.top < targetOffset.top) {
          DomHandler.addClass(this.overlayRef.current, 'p-confirm-popup-flipped');
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.visible) {
        this.setState({
          visible: true
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.visible !== this.props.visible) {
        this.setState({
          visible: this.props.visible
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentClickListener();
      this.unbindResizeListener();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      if (this.overlayEventListener) {
        OverlayService.off('overlay-click', this.overlayEventListener);
        this.overlayEventListener = null;
      }

      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var iconClassName = classNames('p-confirm-popup-icon', this.props.icon);
      var message = ObjectUtils.getJSXElement(this.props.message, this.props);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-confirm-popup-content"
      }, /*#__PURE__*/React__default['default'].createElement("i", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-confirm-popup-message"
      }, message));
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      var acceptClassName = classNames('p-confirm-popup-accept p-button-sm', this.props.acceptClassName);
      var rejectClassName = classNames('p-confirm-popup-reject p-button-sm', {
        'p-button-text': !this.props.rejectClassName
      }, this.props.rejectClassName);
      var content = /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-confirm-popup-footer"
      }, /*#__PURE__*/React__default['default'].createElement(Button, {
        label: this.rejectLabel(),
        icon: this.props.rejectIcon,
        className: rejectClassName,
        onClick: this.reject
      }), /*#__PURE__*/React__default['default'].createElement(Button, {
        ref: this.acceptBtnRef,
        label: this.acceptLabel(),
        icon: this.props.acceptIcon,
        className: acceptClassName,
        onClick: this.accept
      }));

      if (this.props.footer) {
        var defaultContentOptions = {
          accept: this.accept,
          reject: this.reject,
          className: 'p-confirm-popup-footer',
          acceptClassName: acceptClassName,
          rejectClassName: rejectClassName,
          acceptLabel: this.acceptLabel(),
          rejectLabel: this.rejectLabel(),
          element: content,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.footer, defaultContentOptions);
      }

      return content;
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var className = classNames('p-confirm-popup p-component', this.props.className);
      var content = this.renderContent();
      var footer = this.renderFooter();
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.overlayRef,
        classNames: "p-connected-overlay",
        in: this.state.visible,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.onEnter,
        onEntered: this.onEntered,
        onExit: this.onExit,
        onExited: this.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.overlayRef,
        id: this.props.id,
        className: className,
        style: this.props.style,
        onClick: this.onPanelClick
      }, content, footer));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo,
        visible: true
      });
    }
  }]);

  return ConfirmPopup;
}(React.Component);

_defineProperty(ConfirmPopup, "defaultProps", {
  target: null,
  visible: false,
  message: null,
  rejectLabel: null,
  acceptLabel: null,
  icon: null,
  rejectIcon: null,
  acceptIcon: null,
  rejectClassName: null,
  acceptClassName: null,
  className: null,
  style: null,
  appendTo: null,
  dismissable: true,
  footer: null,
  onShow: null,
  onHide: null,
  accept: null,
  reject: null,
  transitionOptions: null
});

function _createSuper$1R(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1R(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1R() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var ContextMenuSub = /*#__PURE__*/function (_Component) {
  _inherits(ContextMenuSub, _Component);

  var _super = _createSuper$1R(ContextMenuSub);

  function ContextMenuSub(props) {
    var _this;

    _classCallCheck(this, ContextMenuSub);

    _this = _super.call(this, props);
    _this.state = {
      activeItem: null
    };
    _this.onEnter = _this.onEnter.bind(_assertThisInitialized(_this));
    _this.submenuRef = /*#__PURE__*/React__default['default'].createRef();
    return _this;
  }

  _createClass(ContextMenuSub, [{
    key: "onItemMouseEnter",
    value: function onItemMouseEnter(event, item) {
      if (item.disabled) {
        event.preventDefault();
        return;
      }

      this.setState({
        activeItem: item
      });
    }
  }, {
    key: "onItemClick",
    value: function onItemClick(event, item) {
      if (item.disabled) {
        event.preventDefault();
        return;
      }

      if (!item.url) {
        event.preventDefault();
      }

      if (item.command) {
        item.command({
          originalEvent: event,
          item: item
        });
      }

      if (!item.items) {
        this.props.onLeafClick(event);
      }
    }
  }, {
    key: "position",
    value: function position() {
      var parentItem = this.submenuRef.current.parentElement;
      var containerOffset = DomHandler.getOffset(this.submenuRef.current.parentElement);
      var viewport = DomHandler.getViewport();
      var sublistWidth = this.submenuRef.current.offsetParent ? this.submenuRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(this.submenuRef.current);
      var itemOuterWidth = DomHandler.getOuterWidth(parentItem.children[0]);
      this.submenuRef.current.style.top = '0px';

      if (parseInt(containerOffset.left, 10) + itemOuterWidth + sublistWidth > viewport.width - DomHandler.calculateScrollbarWidth()) {
        this.submenuRef.current.style.left = -1 * sublistWidth + 'px';
      } else {
        this.submenuRef.current.style.left = itemOuterWidth + 'px';
      }
    }
  }, {
    key: "onEnter",
    value: function onEnter() {
      this.position();
    }
  }, {
    key: "isActive",
    value: function isActive() {
      return this.props.root || !this.props.resetMenu;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.isActive()) {
        this.position();
      }
    }
  }, {
    key: "renderSeparator",
    value: function renderSeparator(index) {
      return /*#__PURE__*/React__default['default'].createElement("li", {
        key: 'separator_' + index,
        className: "p-menu-separator",
        role: "separator"
      });
    }
  }, {
    key: "renderSubmenu",
    value: function renderSubmenu(item) {
      if (item.items) {
        return /*#__PURE__*/React__default['default'].createElement(ContextMenuSub, {
          model: item.items,
          resetMenu: item !== this.state.activeItem,
          onLeafClick: this.props.onLeafClick
        });
      }

      return null;
    }
  }, {
    key: "renderMenuitem",
    value: function renderMenuitem(item, index) {
      var _this2 = this;

      var active = this.state.activeItem === item;
      var className = classNames('p-menuitem', {
        'p-menuitem-active': active
      }, item.className);
      var linkClassName = classNames('p-menuitem-link', {
        'p-disabled': item.disabled
      });
      var iconClassName = classNames('p-menuitem-icon', item.icon);
      var submenuIconClassName = 'p-submenu-icon pi pi-angle-right';
      var icon = item.icon && /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      });
      var label = item.label && /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-menuitem-text"
      }, item.label);
      var submenuIcon = item.items && /*#__PURE__*/React__default['default'].createElement("span", {
        className: submenuIconClassName
      });
      var submenu = this.renderSubmenu(item);
      var content = /*#__PURE__*/React__default['default'].createElement("a", {
        href: item.url || '#',
        className: linkClassName,
        target: item.target,
        onClick: function onClick(event) {
          return _this2.onItemClick(event, item, index);
        },
        role: "menuitem",
        "aria-haspopup": item.items != null,
        "aria-disabled": item.disabled
      }, icon, label, submenuIcon, /*#__PURE__*/React__default['default'].createElement(Ripple, null));

      if (item.template) {
        var defaultContentOptions = {
          onClick: function onClick(event) {
            return _this2.onItemClick(event, item, index);
          },
          className: linkClassName,
          labelClassName: 'p-menuitem-text',
          iconClassName: iconClassName,
          submenuIconClassName: submenuIconClassName,
          element: content,
          props: this.props,
          active: active
        };
        content = ObjectUtils.getJSXElement(item.template, item, defaultContentOptions);
      }

      return /*#__PURE__*/React__default['default'].createElement("li", {
        key: item.label + '_' + index,
        role: "none",
        className: className,
        style: item.style,
        onMouseEnter: function onMouseEnter(event) {
          return _this2.onItemMouseEnter(event, item);
        }
      }, content, submenu);
    }
  }, {
    key: "renderItem",
    value: function renderItem(item, index) {
      if (item.separator) return this.renderSeparator(index);else return this.renderMenuitem(item, index);
    }
  }, {
    key: "renderMenu",
    value: function renderMenu() {
      var _this3 = this;

      if (this.props.model) {
        return this.props.model.map(function (item, index) {
          return _this3.renderItem(item, index);
        });
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames({
        'p-submenu-list': !this.props.root
      });
      var submenu = this.renderMenu();
      var isActive = this.isActive();
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.submenuRef,
        classNames: "p-contextmenusub",
        in: isActive,
        timeout: {
          enter: 0,
          exit: 0
        },
        unmountOnExit: true,
        onEnter: this.onEnter
      }, /*#__PURE__*/React__default['default'].createElement("ul", {
        ref: this.submenuRef,
        className: className
      }, submenu));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.resetMenu === true) {
        return {
          activeItem: null
        };
      }

      return null;
    }
  }]);

  return ContextMenuSub;
}(React.Component);

_defineProperty(ContextMenuSub, "defaultProps", {
  model: null,
  root: false,
  className: null,
  resetMenu: false,
  onLeafClick: null
});

var ContextMenu = /*#__PURE__*/function (_Component2) {
  _inherits(ContextMenu, _Component2);

  var _super2 = _createSuper$1R(ContextMenu);

  function ContextMenu(props) {
    var _this4;

    _classCallCheck(this, ContextMenu);

    _this4 = _super2.call(this, props);
    _this4.state = {
      visible: false,
      reshow: false,
      resetMenu: false
    };
    _this4.onMenuClick = _this4.onMenuClick.bind(_assertThisInitialized(_this4));
    _this4.onLeafClick = _this4.onLeafClick.bind(_assertThisInitialized(_this4));
    _this4.onMenuMouseEnter = _this4.onMenuMouseEnter.bind(_assertThisInitialized(_this4));
    _this4.onEnter = _this4.onEnter.bind(_assertThisInitialized(_this4));
    _this4.onEntered = _this4.onEntered.bind(_assertThisInitialized(_this4));
    _this4.onExit = _this4.onExit.bind(_assertThisInitialized(_this4));
    _this4.onExited = _this4.onExited.bind(_assertThisInitialized(_this4));
    _this4.menuRef = /*#__PURE__*/React__default['default'].createRef();
    return _this4;
  }

  _createClass(ContextMenu, [{
    key: "onMenuClick",
    value: function onMenuClick() {
      this.setState({
        resetMenu: false
      });
    }
  }, {
    key: "onMenuMouseEnter",
    value: function onMenuMouseEnter() {
      this.setState({
        resetMenu: false
      });
    }
  }, {
    key: "show",
    value: function show(event) {
      var _this5 = this;

      if (!(event instanceof Event)) {
        event.persist();
      }

      event.stopPropagation();
      event.preventDefault();
      this.currentEvent = event;

      if (this.state.visible) {
        this.setState({
          reshow: true
        });
      } else {
        this.setState({
          visible: true
        }, function () {
          if (_this5.props.onShow) {
            _this5.props.onShow(_this5.currentEvent);
          }
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var _this6 = this;

      if (this.state.visible && prevState.reshow !== this.state.reshow) {
        var event = this.currentEvent;
        this.setState({
          visible: false,
          reshow: false,
          rePosition: false,
          resetMenu: true
        }, function () {
          return _this6.show(event);
        });
      }
    }
  }, {
    key: "hide",
    value: function hide(event) {
      var _this7 = this;

      if (!(event instanceof Event)) {
        event.persist();
      }

      this.currentEvent = event;
      this.setState({
        visible: false,
        reshow: false
      }, function () {
        if (_this7.props.onHide) {
          _this7.props.onHide(_this7.currentEvent);
        }
      });
    }
  }, {
    key: "onEnter",
    value: function onEnter() {
      if (this.props.autoZIndex) {
        ZIndexUtils.set('menu', this.menuRef.current, this.props.baseZIndex);
      }

      this.position(this.currentEvent);
    }
  }, {
    key: "onEntered",
    value: function onEntered() {
      this.bindDocumentListeners();
    }
  }, {
    key: "onExit",
    value: function onExit() {
      this.currentEvent = null;
      this.unbindDocumentListeners();
    }
  }, {
    key: "onExited",
    value: function onExited() {
      ZIndexUtils.clear(this.menuRef.current);
    }
  }, {
    key: "position",
    value: function position(event) {
      if (event) {
        var left = event.pageX + 1;
        var top = event.pageY + 1;
        var width = this.menuRef.current.offsetParent ? this.menuRef.current.offsetWidth : DomHandler.getHiddenElementOuterWidth(this.menuRef.current);
        var height = this.menuRef.current.offsetParent ? this.menuRef.current.offsetHeight : DomHandler.getHiddenElementOuterHeight(this.menuRef.current);
        var viewport = DomHandler.getViewport(); //flip

        if (left + width - document.body.scrollLeft > viewport.width) {
          left -= width;
        } //flip


        if (top + height - document.body.scrollTop > viewport.height) {
          top -= height;
        } //fit


        if (left < document.body.scrollLeft) {
          left = document.body.scrollLeft;
        } //fit


        if (top < document.body.scrollTop) {
          top = document.body.scrollTop;
        }

        this.menuRef.current.style.left = left + 'px';
        this.menuRef.current.style.top = top + 'px';
      }
    }
  }, {
    key: "onLeafClick",
    value: function onLeafClick(event) {
      this.setState({
        resetMenu: true
      });
      this.hide(event);
      event.stopPropagation();
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(event) {
      return this.menuRef && this.menuRef.current && !(this.menuRef.current.isSameNode(event.target) || this.menuRef.current.contains(event.target));
    }
  }, {
    key: "bindDocumentListeners",
    value: function bindDocumentListeners() {
      this.bindDocumentResizeListener();
      this.bindDocumentClickListener();
    }
  }, {
    key: "unbindDocumentListeners",
    value: function unbindDocumentListeners() {
      this.unbindDocumentResizeListener();
      this.unbindDocumentClickListener();
    }
  }, {
    key: "bindDocumentClickListener",
    value: function bindDocumentClickListener() {
      var _this8 = this;

      if (!this.documentClickListener) {
        this.documentClickListener = function (event) {
          if (_this8.isOutsideClicked(event) && event.button !== 2) {
            _this8.hide(event);

            _this8.setState({
              resetMenu: true
            });
          }
        };

        document.addEventListener('click', this.documentClickListener);
      }
    }
  }, {
    key: "bindDocumentContextMenuListener",
    value: function bindDocumentContextMenuListener() {
      var _this9 = this;

      if (!this.documentContextMenuListener) {
        this.documentContextMenuListener = function (event) {
          _this9.show(event);
        };

        document.addEventListener('contextmenu', this.documentContextMenuListener);
      }
    }
  }, {
    key: "bindDocumentResizeListener",
    value: function bindDocumentResizeListener() {
      var _this10 = this;

      if (!this.documentResizeListener) {
        this.documentResizeListener = function (event) {
          if (_this10.state.visible && !DomHandler.isAndroid()) {
            _this10.hide(event);
          }
        };

        window.addEventListener('resize', this.documentResizeListener);
      }
    }
  }, {
    key: "unbindDocumentClickListener",
    value: function unbindDocumentClickListener() {
      if (this.documentClickListener) {
        document.removeEventListener('click', this.documentClickListener);
        this.documentClickListener = null;
      }
    }
  }, {
    key: "unbindDocumentContextMenuListener",
    value: function unbindDocumentContextMenuListener() {
      if (this.documentContextMenuListener) {
        document.removeEventListener('contextmenu', this.documentContextMenuListener);
        this.documentContextMenuListener = null;
      }
    }
  }, {
    key: "unbindDocumentResizeListener",
    value: function unbindDocumentResizeListener() {
      if (this.documentResizeListener) {
        window.removeEventListener('resize', this.documentResizeListener);
        this.documentResizeListener = null;
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.global) {
        this.bindDocumentContextMenuListener();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentListeners();
      this.unbindDocumentContextMenuListener();
      ZIndexUtils.clear(this.menuRef.current);
    }
  }, {
    key: "renderContextMenu",
    value: function renderContextMenu() {
      var className = classNames('p-contextmenu p-component', this.props.className);
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.menuRef,
        classNames: "p-contextmenu",
        in: this.state.visible,
        timeout: {
          enter: 250,
          exit: 0
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.onEnter,
        onEntered: this.onEntered,
        onExit: this.onExit,
        onExited: this.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.menuRef,
        id: this.props.id,
        className: className,
        style: this.props.style,
        onClick: this.onMenuClick,
        onMouseEnter: this.onMenuMouseEnter
      }, /*#__PURE__*/React__default['default'].createElement(ContextMenuSub, {
        model: this.props.model,
        root: true,
        resetMenu: this.state.resetMenu,
        onLeafClick: this.onLeafClick
      })));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderContextMenu();
      return /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo
      });
    }
  }]);

  return ContextMenu;
}(React.Component);

_defineProperty(ContextMenu, "defaultProps", {
  id: null,
  model: null,
  style: null,
  className: null,
  global: false,
  autoZIndex: true,
  baseZIndex: 0,
  appendTo: null,
  transitionOptions: null,
  onShow: null,
  onHide: null
});

function _createSuper$1Q(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1Q(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1Q() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DataScroller = /*#__PURE__*/function (_Component) {
  _inherits(DataScroller, _Component);

  var _super = _createSuper$1Q(DataScroller);

  function DataScroller(props) {
    var _this;

    _classCallCheck(this, DataScroller);

    _this = _super.call(this, props);
    _this.state = {};
    _this.dataToRender = [];
    _this.value = _this.props.value;
    _this.first = 0;
    return _this;
  }

  _createClass(DataScroller, [{
    key: "handleDataChange",
    value: function handleDataChange() {
      if (this.props.lazy) {
        this.dataToRender = this.value;
        this.setState({
          dataToRender: this.dataToRender
        });
      } else {
        this.load();
      }
    }
  }, {
    key: "load",
    value: function load() {
      if (this.props.lazy) {
        if (this.props.onLazyLoad) {
          this.props.onLazyLoad(this.createLazyLoadMetadata());
        }

        this.first = this.first + this.props.rows;
      } else {
        if (this.value) {
          for (var i = this.first; i < this.first + this.props.rows; i++) {
            if (i >= this.value.length) {
              break;
            }

            this.dataToRender.push(this.value[i]);
          }

          if (this.value.length !== 0) {
            this.first = this.first + this.props.rows;
          }

          this.setState({
            dataToRender: this.dataToRender
          });
        }
      }
    }
  }, {
    key: "reset",
    value: function reset() {
      this.first = 0;
      this.dataToRender = [];
      this.setState({
        dataToRender: this.dataToRender
      });
      this.load();
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return !this.dataToRender || this.dataToRender.length === 0;
    }
  }, {
    key: "createLazyLoadMetadata",
    value: function createLazyLoadMetadata() {
      return {
        first: this.first,
        rows: this.props.rows
      };
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this2 = this;

      if (this.props.inline) {
        this.scrollFunction = function () {
          var scrollTop = _this2.contentElement.scrollTop,
              scrollHeight = _this2.contentElement.scrollHeight,
              viewportHeight = _this2.contentElement.clientHeight;

          if (scrollTop >= scrollHeight * _this2.props.buffer - viewportHeight) {
            _this2.load();
          }
        };

        this.contentElement.addEventListener('scroll', this.scrollFunction);
      } else {
        this.scrollFunction = function () {
          var docBody = document.body,
              docElement = document.documentElement,
              scrollTop = window.pageYOffset || document.documentElement.scrollTop,
              winHeight = docElement.clientHeight,
              docHeight = Math.max(docBody.scrollHeight, docBody.offsetHeight, winHeight, docElement.scrollHeight, docElement.offsetHeight);

          if (scrollTop >= docHeight * _this2.props.buffer - winHeight) {
            _this2.load();
          }
        };

        window.addEventListener('scroll', this.scrollFunction);
      }
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollFunction) {
        if (this.props.inline) {
          this.contentElement.removeEventListener('scroll', this.scrollFunction);
          this.contentElement = null;
        } else if (!this.props.loader) {
          window.removeEventListener('scroll', this.scrollFunction);
        }
      }

      this.scrollFunction = null;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.load();

      if (!this.props.loader) {
        this.bindScrollListener();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var newValue = this.props.value;

      if (newValue && this.value !== newValue) {
        this.value = newValue;
        this.first = 0;
        this.dataToRender = [];
        this.handleDataChange();
      }

      if (prevProps.loader !== this.props.loader && this.props.loader) {
        this.unbindScrollListener();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.scrollFunction) {
        this.unbindScrollListener();
      }
    }
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      if (this.props.header) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-datascroller-header"
        }, this.props.header);
      }

      return null;
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      if (this.props.footer) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-datascroller-footer"
        }, this.props.footer);
      }

      return null;
    }
  }, {
    key: "renderItem",
    value: function renderItem(value, index) {
      var content = this.props.itemTemplate ? this.props.itemTemplate(value) : value;
      return /*#__PURE__*/React__default['default'].createElement("li", {
        key: index + '_datascrollitem'
      }, content);
    }
  }, {
    key: "renderEmptyMessage",
    value: function renderEmptyMessage() {
      var content = ObjectUtils.getJSXElement(this.props.emptyMessage, this.props);
      return /*#__PURE__*/React__default['default'].createElement("li", null, content);
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this3 = this;

      var content = this.state.dataToRender && this.state.dataToRender.length ? this.state.dataToRender.map(function (val, i) {
        return _this3.renderItem(val, i);
      }) : this.renderEmptyMessage();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this3.contentElement = el;
        },
        className: "p-datascroller-content",
        style: {
          'maxHeight': this.props.scrollHeight
        }
      }, /*#__PURE__*/React__default['default'].createElement("ul", {
        className: "p-datascroller-list"
      }, content));
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-datascroller p-component', this.props.className, {
        'p-datascroller-inline': this.props.inline
      });
      var header = this.renderHeader();
      var footer = this.renderFooter();
      var content = this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        className: className
      }, header, content, footer);
    }
  }]);

  return DataScroller;
}(React.Component);

_defineProperty(DataScroller, "defaultProps", {
  id: null,
  value: null,
  rows: 0,
  inline: false,
  scrollHeight: null,
  loader: false,
  buffer: 0.9,
  style: null,
  className: null,
  onLazyLoad: null,
  emptyMessage: 'No records found',
  itemTemplate: null,
  header: null,
  footer: null,
  lazy: false
});

function _createSuper$1P(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1P(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1P() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var FirstPageLink = /*#__PURE__*/function (_Component) {
  _inherits(FirstPageLink, _Component);

  var _super = _createSuper$1P(FirstPageLink);

  function FirstPageLink() {
    _classCallCheck(this, FirstPageLink);

    return _super.apply(this, arguments);
  }

  _createClass(FirstPageLink, [{
    key: "render",
    value: function render() {
      var className = classNames('p-paginator-first p-paginator-element p-link', {
        'p-disabled': this.props.disabled
      });
      var iconClassName = 'p-paginator-icon pi pi-angle-double-left';
      var element = /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: className,
        onClick: this.props.onClick,
        disabled: this.props.disabled
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));

      if (this.props.template) {
        var defaultOptions = {
          onClick: this.props.onClick,
          className: className,
          iconClassName: iconClassName,
          disabled: this.props.disabled,
          element: element,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return FirstPageLink;
}(React.Component);

_defineProperty(FirstPageLink, "defaultProps", {
  disabled: false,
  onClick: null,
  template: null
});

function _createSuper$1O(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1O(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1O() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var NextPageLink = /*#__PURE__*/function (_Component) {
  _inherits(NextPageLink, _Component);

  var _super = _createSuper$1O(NextPageLink);

  function NextPageLink() {
    _classCallCheck(this, NextPageLink);

    return _super.apply(this, arguments);
  }

  _createClass(NextPageLink, [{
    key: "render",
    value: function render() {
      var className = classNames('p-paginator-next p-paginator-element p-link', {
        'p-disabled': this.props.disabled
      });
      var iconClassName = 'p-paginator-icon pi pi-angle-right';
      var element = /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: className,
        onClick: this.props.onClick,
        disabled: this.props.disabled
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));

      if (this.props.template) {
        var defaultOptions = {
          onClick: this.props.onClick,
          className: className,
          iconClassName: iconClassName,
          disabled: this.props.disabled,
          element: element,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return NextPageLink;
}(React.Component);

_defineProperty(NextPageLink, "defaultProps", {
  disabled: false,
  onClick: null,
  template: null
});

function _createSuper$1N(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1N(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1N() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var PrevPageLink = /*#__PURE__*/function (_Component) {
  _inherits(PrevPageLink, _Component);

  var _super = _createSuper$1N(PrevPageLink);

  function PrevPageLink() {
    _classCallCheck(this, PrevPageLink);

    return _super.apply(this, arguments);
  }

  _createClass(PrevPageLink, [{
    key: "render",
    value: function render() {
      var className = classNames('p-paginator-prev p-paginator-element p-link', {
        'p-disabled': this.props.disabled
      });
      var iconClassName = 'p-paginator-icon pi pi-angle-left';
      var element = /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: className,
        onClick: this.props.onClick,
        disabled: this.props.disabled
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));

      if (this.props.template) {
        var defaultOptions = {
          onClick: this.props.onClick,
          className: className,
          iconClassName: iconClassName,
          disabled: this.props.disabled,
          element: element,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return PrevPageLink;
}(React.Component);

_defineProperty(PrevPageLink, "defaultProps", {
  disabled: false,
  onClick: null,
  template: null
});

function _createSuper$1M(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1M(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1M() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var LastPageLink = /*#__PURE__*/function (_Component) {
  _inherits(LastPageLink, _Component);

  var _super = _createSuper$1M(LastPageLink);

  function LastPageLink() {
    _classCallCheck(this, LastPageLink);

    return _super.apply(this, arguments);
  }

  _createClass(LastPageLink, [{
    key: "render",
    value: function render() {
      var className = classNames('p-paginator-last p-paginator-element p-link', {
        'p-disabled': this.props.disabled
      });
      var iconClassName = 'p-paginator-icon pi pi-angle-double-right';
      var element = /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: className,
        onClick: this.props.onClick,
        disabled: this.props.disabled
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));

      if (this.props.template) {
        var defaultOptions = {
          onClick: this.props.onClick,
          className: className,
          iconClassName: iconClassName,
          disabled: this.props.disabled,
          element: element,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return LastPageLink;
}(React.Component);

_defineProperty(LastPageLink, "defaultProps", {
  disabled: false,
  onClick: null,
  template: null
});

function _createSuper$1L(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1L(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1L() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var PageLinks = /*#__PURE__*/function (_Component) {
  _inherits(PageLinks, _Component);

  var _super = _createSuper$1L(PageLinks);

  function PageLinks() {
    _classCallCheck(this, PageLinks);

    return _super.apply(this, arguments);
  }

  _createClass(PageLinks, [{
    key: "onPageLinkClick",
    value: function onPageLinkClick(event, pageLink) {
      if (this.props.onClick) {
        this.props.onClick({
          originalEvent: event,
          value: pageLink
        });
      }

      event.preventDefault();
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var elements;

      if (this.props.value) {
        var startPageInView = this.props.value[0];
        var endPageInView = this.props.value[this.props.value.length - 1];
        elements = this.props.value.map(function (pageLink, i) {
          var className = classNames('p-paginator-page p-paginator-element p-link', {
            'p-paginator-page-start': pageLink === startPageInView,
            'p-paginator-page-end': pageLink === endPageInView,
            'p-highlight': pageLink - 1 === _this.props.page
          });
          var element = /*#__PURE__*/React__default['default'].createElement("button", {
            type: "button",
            className: className,
            onClick: function onClick(e) {
              return _this.onPageLinkClick(e, pageLink);
            }
          }, pageLink, /*#__PURE__*/React__default['default'].createElement(Ripple, null));

          if (_this.props.template) {
            var defaultOptions = {
              onClick: function onClick(e) {
                return _this.onPageLinkClick(e, pageLink);
              },
              className: className,
              view: {
                startPage: startPageInView - 1,
                endPage: endPageInView - 1
              },
              page: pageLink - 1,
              currentPage: _this.props.page,
              totalPages: _this.props.pageCount,
              element: element,
              props: _this.props
            };
            element = ObjectUtils.getJSXElement(_this.props.template, defaultOptions);
          }

          return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, {
            key: pageLink
          }, element);
        });
      }

      return /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-paginator-pages"
      }, elements);
    }
  }]);

  return PageLinks;
}(React.Component);

_defineProperty(PageLinks, "defaultProps", {
  value: null,
  page: null,
  rows: null,
  pageCount: null,
  links: null,
  template: null
});

function _createSuper$1K(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1K(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1K() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DropdownItem = /*#__PURE__*/function (_Component) {
  _inherits(DropdownItem, _Component);

  var _super = _createSuper$1K(DropdownItem);

  function DropdownItem(props) {
    var _this;

    _classCallCheck(this, DropdownItem);

    _this = _super.call(this, props);
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(DropdownItem, [{
    key: "onClick",
    value: function onClick(event) {
      if (this.props.onClick) {
        this.props.onClick({
          originalEvent: event,
          option: this.props.option
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-dropdown-item', {
        'p-highlight': this.props.selected,
        'p-disabled': this.props.disabled,
        'p-dropdown-item-empty': !this.props.label || this.props.label.length === 0
      }, this.props.option.className);
      var content = this.props.template ? ObjectUtils.getJSXElement(this.props.template, this.props.option) : this.props.label;
      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: className,
        onClick: this.onClick,
        "aria-label": this.props.label,
        key: this.props.label,
        role: "option",
        "aria-selected": this.props.selected
      }, content, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }]);

  return DropdownItem;
}(React.Component);

_defineProperty(DropdownItem, "defaultProps", {
  option: null,
  label: null,
  template: null,
  selected: false,
  disabled: false,
  onClick: null
});

function ownKeys$y(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$y(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$y(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$y(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1J(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1J(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1J() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var DropdownPanelComponent = /*#__PURE__*/function (_Component) {
  _inherits(DropdownPanelComponent, _Component);

  var _super = _createSuper$1J(DropdownPanelComponent);

  function DropdownPanelComponent(props) {
    var _this;

    _classCallCheck(this, DropdownPanelComponent);

    _this = _super.call(this, props);
    _this.onEnter = _this.onEnter.bind(_assertThisInitialized(_this));
    _this.onEntered = _this.onEntered.bind(_assertThisInitialized(_this));
    _this.onFilterInputChange = _this.onFilterInputChange.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(DropdownPanelComponent, [{
    key: "onEnter",
    value: function onEnter() {
      var _this2 = this;

      this.props.onEnter(function () {
        if (_this2.virtualScrollerRef) {
          var selectedIndex = _this2.props.getSelectedOptionIndex();

          if (selectedIndex !== -1) {
            _this2.virtualScrollerRef.scrollToIndex(selectedIndex);
          }
        }
      });
    }
  }, {
    key: "onEntered",
    value: function onEntered() {
      var _this3 = this;

      this.props.onEntered(function () {
        if (_this3.props.filter && _this3.props.filterInputAutoFocus) {
          _this3.filterInput.focus();
        }
      });
    }
  }, {
    key: "onFilterInputChange",
    value: function onFilterInputChange(event) {
      if (this.virtualScrollerRef) {
        this.virtualScrollerRef.scrollToIndex(0);
      }

      this.props.onFilterInputChange && this.props.onFilterInputChange(event);
    }
  }, {
    key: "isEmptyFilter",
    value: function isEmptyFilter() {
      return !(this.props.visibleOptions && this.props.visibleOptions.length) && this.props.hasFilter();
    }
  }, {
    key: "renderGroupChildren",
    value: function renderGroupChildren(optionGroup) {
      var _this4 = this;

      var groupChildren = this.props.getOptionGroupChildren(optionGroup);
      return groupChildren.map(function (option, j) {
        var optionLabel = _this4.props.getOptionLabel(option);

        var optionKey = j + '_' + _this4.props.getOptionRenderKey(option);

        var disabled = _this4.props.isOptionDisabled(option);

        return /*#__PURE__*/React__default['default'].createElement(DropdownItem, {
          key: optionKey,
          label: optionLabel,
          option: option,
          template: _this4.props.itemTemplate,
          selected: _this4.props.isSelected(option),
          disabled: disabled,
          onClick: _this4.props.onOptionClick
        });
      });
    }
  }, {
    key: "renderEmptyMessage",
    value: function renderEmptyMessage(emptyMessage) {
      var message = ObjectUtils.getJSXElement(emptyMessage, this.props);
      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: "p-dropdown-empty-message"
      }, message);
    }
  }, {
    key: "renderItem",
    value: function renderItem(option, index) {
      if (this.props.optionGroupLabel) {
        var groupContent = this.props.optionGroupTemplate ? ObjectUtils.getJSXElement(this.props.optionGroupTemplate, option, index) : this.props.getOptionGroupLabel(option);
        var groupChildrenContent = this.renderGroupChildren(option);
        var key = index + '_' + this.props.getOptionGroupRenderKey(option);
        return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, {
          key: key
        }, /*#__PURE__*/React__default['default'].createElement("li", {
          className: "p-dropdown-item-group"
        }, groupContent), groupChildrenContent);
      } else {
        var optionLabel = this.props.getOptionLabel(option);
        var optionKey = index + '_' + this.props.getOptionRenderKey(option);
        var disabled = this.props.isOptionDisabled(option);
        return /*#__PURE__*/React__default['default'].createElement(DropdownItem, {
          key: optionKey,
          label: optionLabel,
          option: option,
          template: this.props.itemTemplate,
          selected: this.props.isSelected(option),
          disabled: disabled,
          onClick: this.props.onOptionClick
        });
      }
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this5 = this;

      if (this.props.visibleOptions && this.props.visibleOptions.length) {
        return this.props.visibleOptions.map(function (option, index) {
          return _this5.renderItem(option, index);
        });
      } else if (this.props.hasFilter()) {
        return this.renderEmptyMessage(this.props.emptyFilterMessage);
      }

      return this.renderEmptyMessage(this.props.emptyMessage);
    }
  }, {
    key: "renderFilterClearIcon",
    value: function renderFilterClearIcon() {
      var _this6 = this;

      if (this.props.showFilterClear && this.props.filterValue) {
        return /*#__PURE__*/React__default['default'].createElement("i", {
          className: "p-dropdown-filter-clear-icon pi pi-times",
          onClick: function onClick() {
            return _this6.props.onFilterClearIconClick(function () {
              return _this6.filterInput.focus();
            });
          }
        });
      }

      return null;
    }
  }, {
    key: "renderFilter",
    value: function renderFilter() {
      var _this7 = this;

      if (this.props.filter) {
        var clearIcon = this.renderFilterClearIcon();
        var containerClassName = classNames('p-dropdown-filter-container', {
          'p-dropdown-clearable-filter': !!clearIcon
        });
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-dropdown-header"
        }, /*#__PURE__*/React__default['default'].createElement("div", {
          className: containerClassName
        }, /*#__PURE__*/React__default['default'].createElement("input", {
          ref: function ref(el) {
            return _this7.filterInput = el;
          },
          type: "text",
          autoComplete: "off",
          className: "p-dropdown-filter p-inputtext p-component",
          placeholder: this.props.filterPlaceholder,
          onKeyDown: this.props.onFilterInputKeyDown,
          onChange: this.onFilterInputChange,
          value: this.props.filterValue
        }), clearIcon, /*#__PURE__*/React__default['default'].createElement("i", {
          className: "p-dropdown-filter-icon pi pi-search"
        })));
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this8 = this;

      if (this.props.virtualScrollerOptions) {
        var virtualScrollerProps = _objectSpread$y(_objectSpread$y({}, this.props.virtualScrollerOptions), {
          style: _objectSpread$y(_objectSpread$y({}, this.props.virtualScrollerOptions.style), {
            height: this.props.scrollHeight
          }),
          className: classNames('p-dropdown-items-wrapper', this.props.virtualScrollerOptions.className),
          items: this.props.visibleOptions,
          onLazyLoad: function onLazyLoad(event) {
            return _this8.props.virtualScrollerOptions.onLazyLoad(_objectSpread$y(_objectSpread$y({}, event), {
              filter: _this8.props.filterValue
            }));
          },
          itemTemplate: function itemTemplate(item, options) {
            return item && _this8.renderItem(item, options.index);
          },
          contentTemplate: function contentTemplate(options) {
            var className = classNames('p-dropdown-items', options.className);
            var content = _this8.isEmptyFilter() ? _this8.renderEmptyMessage() : options.children;
            return /*#__PURE__*/React__default['default'].createElement("ul", {
              ref: options.ref,
              className: className,
              role: "listbox"
            }, content);
          }
        });

        return /*#__PURE__*/React__default['default'].createElement(VirtualScroller, _extends({
          ref: function ref(el) {
            return _this8.virtualScrollerRef = el;
          }
        }, virtualScrollerProps));
      } else {
        var items = this.renderItems();
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-dropdown-items-wrapper",
          style: {
            maxHeight: this.props.scrollHeight || 'auto'
          }
        }, /*#__PURE__*/React__default['default'].createElement("ul", {
          className: "p-dropdown-items",
          role: "listbox"
        }, items));
      }
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var className = classNames('p-dropdown-panel p-component', this.props.panelClassName);
      var filter = this.renderFilter();
      var content = this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.props.forwardRef,
        classNames: "p-connected-overlay",
        in: this.props.in,
        timeout: {
          enter: 120,
          exit: 100
        },
        options: this.props.transitionOptions,
        unmountOnExit: true,
        onEnter: this.onEnter,
        onEntering: this.props.onEntering,
        onEntered: this.onEntered,
        onExit: this.props.onExit,
        onExited: this.props.onExited
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.props.forwardRef,
        className: className,
        style: this.props.panelStyle,
        onClick: this.props.onClick
      }, filter, content));
    }
  }, {
    key: "render",
    value: function render() {
      var element = this.renderElement();
      return /*#__PURE__*/React__default['default'].createElement(Portal, {
        element: element,
        appendTo: this.props.appendTo
      });
    }
  }]);

  return DropdownPanelComponent;
}(React.Component);

var DropdownPanel = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(DropdownPanelComponent, _extends({
    forwardRef: ref
  }, props));
});

function ownKeys$x(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$x(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$x(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$x(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper$d(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$d(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$d(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$d(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$d(o, minLen); }

function _arrayLikeToArray$d(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$1I(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1I(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1I() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Dropdown = /*#__PURE__*/function (_Component) {
  _inherits(Dropdown, _Component);

  var _super = _createSuper$1I(Dropdown);

  function Dropdown(props) {
    var _this;

    _classCallCheck(this, Dropdown);

    _this = _super.call(this, props);
    _this.state = {
      filter: '',
      focused: false,
      overlayVisible: false
    };
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onInputFocus = _this.onInputFocus.bind(_assertThisInitialized(_this));
    _this.onInputBlur = _this.onInputBlur.bind(_assertThisInitialized(_this));
    _this.onInputKeyDown = _this.onInputKeyDown.bind(_assertThisInitialized(_this));
    _this.onEditableInputChange = _this.onEditableInputChange.bind(_assertThisInitialized(_this));
    _this.onEditableInputFocus = _this.onEditableInputFocus.bind(_assertThisInitialized(_this));
    _this.onOptionClick = _this.onOptionClick.bind(_assertThisInitialized(_this));
    _this.onFilterInputChange = _this.onFilterInputChange.bind(_assertThisInitialized(_this));
    _this.onFilterInputKeyDown = _this.onFilterInputKeyDown.bind(_assertThisInitialized(_this));
    _this.onFilterClearIconClick = _this.onFilterClearIconClick.bind(_assertThisInitialized(_this));
    _this.onPanelClick = _this.onPanelClick.bind(_assertThisInitialized(_this));
    _this.onOverlayEnter = _this.onOverlayEnter.bind(_assertThisInitialized(_this));
    _this.onOverlayEntered = _this.onOverlayEntered.bind(_assertThisInitialized(_this));
    _this.onOverlayExit = _this.onOverlayExit.bind(_assertThisInitialized(_this));
    _this.onOverlayExited = _this.onOverlayExited.bind(_assertThisInitialized(_this));
    _this.resetFilter = _this.resetFilter.bind(_assertThisInitialized(_this));
    _this.clear = _this.clear.bind(_assertThisInitialized(_this));
    _this.hasFilter = _this.hasFilter.bind(_assertThisInitialized(_this));
    _this.getOptionLabel = _this.getOptionLabel.bind(_assertThisInitialized(_this));
    _this.getOptionRenderKey = _this.getOptionRenderKey.bind(_assertThisInitialized(_this));
    _this.isOptionDisabled = _this.isOptionDisabled.bind(_assertThisInitialized(_this));
    _this.getOptionGroupChildren = _this.getOptionGroupChildren.bind(_assertThisInitialized(_this));
    _this.getOptionGroupLabel = _this.getOptionGroupLabel.bind(_assertThisInitialized(_this));
    _this.getOptionGroupRenderKey = _this.getOptionGroupRenderKey.bind(_assertThisInitialized(_this));
    _this.getSelectedOptionIndex = _this.getSelectedOptionIndex.bind(_assertThisInitialized(_this));
    _this.isSelected = _this.isSelected.bind(_assertThisInitialized(_this));
    _this.overlayRef = /*#__PURE__*/React.createRef();
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(Dropdown, [{
    key: "onClick",
    value: function onClick(event) {
      if (this.props.disabled) {
        return;
      }

      if (DomHandler.hasClass(event.target, 'p-dropdown-clear-icon') || event.target.tagName === 'INPUT') {
        return;
      } else if (!this.overlayRef.current || !(this.overlayRef.current && this.overlayRef.current.contains(event.target))) {
        this.focusInput.focus();

        if (this.state.overlayVisible) {
          this.hideOverlay();
        } else {
          this.showOverlay();
        }
      }
    }
  }, {
    key: "onInputFocus",
    value: function onInputFocus(event) {
      var _this2 = this;

      event.persist();

      if (this.props.showOnFocus && !this.state.overlayVisible) {
        this.showOverlay();
      }

      this.setState({
        focused: true
      }, function () {
        if (_this2.props.onFocus) {
          _this2.props.onFocus(event);
        }
      });
    }
  }, {
    key: "onInputBlur",
    value: function onInputBlur(event) {
      var _this3 = this;

      event.persist();
      this.setState({
        focused: false
      }, function () {
        if (_this3.props.onBlur) {
          _this3.props.onBlur(event);
        }
      });
    }
  }, {
    key: "onPanelClick",
    value: function onPanelClick(event) {
      OverlayService.emit('overlay-click', {
        originalEvent: event,
        target: this.container
      });
    }
  }, {
    key: "onInputKeyDown",
    value: function onInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          this.onDownKey(event);
          break;
        //up

        case 38:
          this.onUpKey(event);
          break;
        //space

        case 32:
          if (this.state.overlayVisible) this.hideOverlay();else this.showOverlay();
          event.preventDefault();
          break;
        //enter

        case 13:
          this.hideOverlay();
          event.preventDefault();
          break;
        //escape and tab

        case 27:
        case 9:
          this.hideOverlay();
          break;

        default:
          this.search(event);
          break;
      }
    }
  }, {
    key: "onFilterInputKeyDown",
    value: function onFilterInputKeyDown(event) {
      switch (event.which) {
        //down
        case 40:
          this.onDownKey(event);
          break;
        //up

        case 38:
          this.onUpKey(event);
          break;
        //enter and escape

        case 13:
        case 27:
          this.hideOverlay();
          event.preventDefault();
          break;
      }
    }
  }, {
    key: "onUpKey",
    value: function onUpKey(event) {
      var visibleOptions = this.getVisibleOptions();

      if (visibleOptions) {
        var prevOption = this.findPrevOption(this.getSelectedOptionIndex());

        if (prevOption) {
          this.selectItem({
            originalEvent: event,
            option: prevOption
          });
        }
      }

      event.preventDefault();
    }
  }, {
    key: "onDownKey",
    value: function onDownKey(event) {
      var visibleOptions = this.getVisibleOptions();

      if (visibleOptions) {
        if (!this.state.overlayVisible && event.altKey) {
          this.showOverlay();
        } else {
          var nextOption = this.findNextOption(this.getSelectedOptionIndex());

          if (nextOption) {
            this.selectItem({
              originalEvent: event,
              option: nextOption
            });
          }
        }
      }

      event.preventDefault();
    }
  }, {
    key: "findNextOption",
    value: function findNextOption(index) {
      var visibleOptions = this.getVisibleOptions();

      if (this.props.optionGroupLabel) {
        var groupIndex = index === -1 ? 0 : index.group;
        var optionIndex = index === -1 ? -1 : index.option;
        var option = this.findNextOptionInList(this.getOptionGroupChildren(visibleOptions[groupIndex]), optionIndex);
        if (option) return option;else if (groupIndex + 1 !== visibleOptions.length) return this.findNextOption({
          group: groupIndex + 1,
          option: -1
        });else return null;
      } else {
        return this.findNextOptionInList(visibleOptions, index);
      }
    }
  }, {
    key: "findNextOptionInList",
    value: function findNextOptionInList(list, index) {
      var i = index + 1;

      if (i === list.length) {
        return null;
      }

      var option = list[i];
      if (this.isOptionDisabled(option)) return this.findNextOptionInList(i);else return option;
    }
  }, {
    key: "findPrevOption",
    value: function findPrevOption(index) {
      if (index === -1) {
        return null;
      }

      var visibleOptions = this.getVisibleOptions();

      if (this.props.optionGroupLabel) {
        var groupIndex = index.group;
        var optionIndex = index.option;
        var option = this.findPrevOptionInList(this.getOptionGroupChildren(visibleOptions[groupIndex]), optionIndex);
        if (option) return option;else if (groupIndex > 0) return this.findPrevOption({
          group: groupIndex - 1,
          option: this.getOptionGroupChildren(visibleOptions[groupIndex - 1]).length
        });else return null;
      } else {
        return this.findPrevOptionInList(visibleOptions, index);
      }
    }
  }, {
    key: "findPrevOptionInList",
    value: function findPrevOptionInList(list, index) {
      var i = index - 1;

      if (i < 0) {
        return null;
      }

      var option = list[i];
      if (this.isOptionDisabled(option)) return this.findPrevOption(i);else return option;
    }
  }, {
    key: "search",
    value: function search(event) {
      var _this4 = this;

      if (this.searchTimeout) {
        clearTimeout(this.searchTimeout);
      }

      var char = event.key;
      this.previousSearchChar = this.currentSearchChar;
      this.currentSearchChar = char;
      if (this.previousSearchChar === this.currentSearchChar) this.searchValue = this.currentSearchChar;else this.searchValue = this.searchValue ? this.searchValue + char : char;

      if (this.searchValue) {
        var searchIndex = this.getSelectedOptionIndex();
        var newOption = this.props.optionGroupLabel ? this.searchOptionInGroup(searchIndex) : this.searchOption(++searchIndex);

        if (newOption) {
          this.selectItem({
            originalEvent: event,
            option: newOption
          });
          this.selectedOptionUpdated = true;
        }
      }

      this.searchTimeout = setTimeout(function () {
        _this4.searchValue = null;
      }, 250);
    }
  }, {
    key: "searchOption",
    value: function searchOption(index) {
      var option;

      if (this.searchValue) {
        var visibleOptions = this.getVisibleOptions();
        option = this.searchOptionInRange(index, visibleOptions.length);

        if (!option) {
          option = this.searchOptionInRange(0, index);
        }
      }

      return option;
    }
  }, {
    key: "searchOptionInRange",
    value: function searchOptionInRange(start, end) {
      var visibleOptions = this.getVisibleOptions();

      for (var i = start; i < end; i++) {
        var opt = visibleOptions[i];

        if (this.matchesSearchValue(opt)) {
          return opt;
        }
      }

      return null;
    }
  }, {
    key: "searchOptionInGroup",
    value: function searchOptionInGroup(index) {
      var searchIndex = index === -1 ? {
        group: 0,
        option: -1
      } : index;
      var visibleOptions = this.getVisibleOptions();

      for (var i = searchIndex.group; i < visibleOptions.length; i++) {
        var groupOptions = this.getOptionGroupChildren(visibleOptions[i]);

        for (var j = searchIndex.group === i ? searchIndex.option + 1 : 0; j < groupOptions.length; j++) {
          if (this.matchesSearchValue(groupOptions[j])) {
            return groupOptions[j];
          }
        }
      }

      for (var _i = 0; _i <= searchIndex.group; _i++) {
        var _groupOptions = this.getOptionGroupChildren(visibleOptions[_i]);

        for (var _j = 0; _j < (searchIndex.group === _i ? searchIndex.option : _groupOptions.length); _j++) {
          if (this.matchesSearchValue(_groupOptions[_j])) {
            return _groupOptions[_j];
          }
        }
      }

      return null;
    }
  }, {
    key: "matchesSearchValue",
    value: function matchesSearchValue(option) {
      var label = this.getOptionLabel(option).toLocaleLowerCase(this.props.filterLocale);
      return label.startsWith(this.searchValue.toLocaleLowerCase(this.props.filterLocale));
    }
  }, {
    key: "onEditableInputChange",
    value: function onEditableInputChange(event) {
      if (this.props.onChange) {
        this.props.onChange({
          originalEvent: event.originalEvent,
          value: event.target.value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: event.target.value
          }
        });
      }
    }
  }, {
    key: "onEditableInputFocus",
    value: function onEditableInputFocus(event) {
      var _this5 = this;

      event.persist();
      this.setState({
        focused: true
      }, function () {
        _this5.hideOverlay();

        if (_this5.props.onFocus) {
          _this5.props.onFocus(event);
        }
      });
    }
  }, {
    key: "onOptionClick",
    value: function onOptionClick(event) {
      var option = event.option;

      if (!option.disabled) {
        this.selectItem(event);
        this.focusInput.focus();
      }

      this.hideOverlay();
    }
  }, {
    key: "onFilterInputChange",
    value: function onFilterInputChange(event) {
      var _this6 = this;

      var filter = event.target.value;
      this.setState({
        filter: filter
      }, function () {
        if (_this6.props.onFilter) {
          _this6.props.onFilter({
            originalEvent: event,
            filter: filter
          });
        }
      });
    }
  }, {
    key: "onFilterClearIconClick",
    value: function onFilterClearIconClick(callback) {
      this.resetFilter(callback);
    }
  }, {
    key: "resetFilter",
    value: function resetFilter(callback) {
      var _this7 = this;

      var filter = '';
      this.setState({
        filter: filter
      }, function () {
        _this7.props.onFilter && _this7.props.onFilter({
          filter: filter
        });
        callback && callback();
      });
    }
  }, {
    key: "clear",
    value: function clear(event) {
      if (this.props.onChange) {
        this.props.onChange({
          originalEvent: event,
          value: undefined,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: undefined
          }
        });
      }

      this.updateEditableLabel();
    }
  }, {
    key: "selectItem",
    value: function selectItem(event) {
      var currentSelectedOption = this.getSelectedOption();

      if (currentSelectedOption !== event.option) {
        this.updateEditableLabel(event.option);
        var optionValue = this.getOptionValue(event.option);

        if (this.props.onChange) {
          this.props.onChange({
            originalEvent: event.originalEvent,
            value: optionValue,
            stopPropagation: function stopPropagation() {},
            preventDefault: function preventDefault() {},
            target: {
              name: this.props.name,
              id: this.props.id,
              value: optionValue
            }
          });
        }
      }
    }
  }, {
    key: "getSelectedOption",
    value: function getSelectedOption() {
      var index = this.getSelectedOptionIndex();
      var visibleOptions = this.getVisibleOptions();
      return index !== -1 ? this.props.optionGroupLabel ? this.getOptionGroupChildren(visibleOptions[index.group])[index.option] : visibleOptions[index] : null;
    }
  }, {
    key: "getSelectedOptionIndex",
    value: function getSelectedOptionIndex() {
      var visibleOptions = this.getVisibleOptions();

      if (this.props.value != null && visibleOptions) {
        if (this.props.optionGroupLabel) {
          for (var i = 0; i < visibleOptions.length; i++) {
            var selectedOptionIndex = this.findOptionIndexInList(this.props.value, this.getOptionGroupChildren(visibleOptions[i]));

            if (selectedOptionIndex !== -1) {
              return {
                group: i,
                option: selectedOptionIndex
              };
            }
          }
        } else {
          return this.findOptionIndexInList(this.props.value, visibleOptions);
        }
      }

      return -1;
    }
  }, {
    key: "findOptionIndexInList",
    value: function findOptionIndexInList(value, list) {
      var key = this.equalityKey();

      for (var i = 0; i < list.length; i++) {
        if (ObjectUtils.equals(value, this.getOptionValue(list[i]), key)) {
          return i;
        }
      }

      return -1;
    }
  }, {
    key: "isSelected",
    value: function isSelected(option) {
      return ObjectUtils.equals(this.props.value, this.getOptionValue(option), this.equalityKey());
    }
  }, {
    key: "equalityKey",
    value: function equalityKey() {
      return this.props.optionValue ? null : this.props.dataKey;
    }
  }, {
    key: "showOverlay",
    value: function showOverlay() {
      this.setState({
        overlayVisible: true
      });
    }
  }, {
    key: "hideOverlay",
    value: function hideOverlay() {
      this.setState({
        overlayVisible: false
      });
    }
  }, {
    key: "onOverlayEnter",
    value: function onOverlayEnter(callback) {
      ZIndexUtils.set('overlay', this.overlayRef.current);
      this.alignOverlay();
      callback && callback();
    }
  }, {
    key: "onOverlayEntered",
    value: function onOverlayEntered(callback) {
      this.bindDocumentClickListener();
      this.bindScrollListener();
      this.bindResizeListener();
      callback && callback();
      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onOverlayExit",
    value: function onOverlayExit() {
      this.unbindDocumentClickListener();
      this.unbindScrollListener();
      this.unbindResizeListener();
    }
  }, {
    key: "onOverlayExited",
    value: function onOverlayExited() {
      if (this.props.filter && this.props.resetFilterOnHide) {
        this.resetFilter();
      }

      ZIndexUtils.clear(this.overlayRef.current);
      this.props.onHide && this.props.onHide();
    }
  }, {
    key: "alignOverlay",
    value: function alignOverlay() {
      DomHandler.alignOverlay(this.overlayRef.current, this.input.parentElement, this.props.appendTo || PrimeReact.appendTo);
    }
  }, {
    key: "scrollInView",
    value: function scrollInView() {
      var highlightItem = DomHandler.findSingle(this.overlayRef.current, 'li.p-highlight');

      if (highlightItem) {
        highlightItem.scrollIntoView({
          block: 'nearest',
          inline: 'start'
        });
      }
    }
  }, {
    key: "bindDocumentClickListener",
    value: function bindDocumentClickListener() {
      var _this8 = this;

      if (!this.documentClickListener) {
        this.documentClickListener = function (event) {
          if (_this8.state.overlayVisible && _this8.isOutsideClicked(event)) {
            _this8.hideOverlay();
          }
        };

        document.addEventListener('click', this.documentClickListener);
      }
    }
  }, {
    key: "unbindDocumentClickListener",
    value: function unbindDocumentClickListener() {
      if (this.documentClickListener) {
        document.removeEventListener('click', this.documentClickListener);
        this.documentClickListener = null;
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this9 = this;

      if (!this.scrollHandler) {
        this.scrollHandler = new ConnectedOverlayScrollHandler(this.container, function () {
          if (_this9.state.overlayVisible) {
            _this9.hideOverlay();
          }
        });
      }

      this.scrollHandler.bindScrollListener();
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.scrollHandler) {
        this.scrollHandler.unbindScrollListener();
      }
    }
  }, {
    key: "bindResizeListener",
    value: function bindResizeListener() {
      var _this10 = this;

      if (!this.resizeListener) {
        this.resizeListener = function () {
          if (_this10.state.overlayVisible && !DomHandler.isTouchDevice()) {
            _this10.hideOverlay();
          }
        };

        window.addEventListener('resize', this.resizeListener);
      }
    }
  }, {
    key: "unbindResizeListener",
    value: function unbindResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener('resize', this.resizeListener);
        this.resizeListener = null;
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(event) {
      return this.container && !(this.container.isSameNode(event.target) || this.isClearClicked(event) || this.container.contains(event.target) || this.overlayRef && this.overlayRef.current.contains(event.target));
    }
  }, {
    key: "isClearClicked",
    value: function isClearClicked(event) {
      return DomHandler.hasClass(event.target, 'p-dropdown-clear-icon');
    }
  }, {
    key: "updateEditableLabel",
    value: function updateEditableLabel(option) {
      if (this.input) {
        this.input.value = option ? this.getOptionLabel(option) : this.props.value || '';
      }
    }
  }, {
    key: "hasFilter",
    value: function hasFilter() {
      return this.state.filter && this.state.filter.trim().length > 0;
    }
  }, {
    key: "getOptionLabel",
    value: function getOptionLabel(option) {
      return this.props.optionLabel ? ObjectUtils.resolveFieldData(option, this.props.optionLabel) : option && option['label'] !== undefined ? option['label'] : option;
    }
  }, {
    key: "getOptionValue",
    value: function getOptionValue(option) {
      return this.props.optionValue ? ObjectUtils.resolveFieldData(option, this.props.optionValue) : option && option['value'] !== undefined ? option['value'] : option;
    }
  }, {
    key: "getOptionRenderKey",
    value: function getOptionRenderKey(option) {
      return this.props.dataKey ? ObjectUtils.resolveFieldData(option, this.props.dataKey) : this.getOptionLabel(option);
    }
  }, {
    key: "isOptionDisabled",
    value: function isOptionDisabled(option) {
      if (this.props.optionDisabled) {
        return ObjectUtils.isFunction(this.props.optionDisabled) ? this.props.optionDisabled(option) : ObjectUtils.resolveFieldData(option, this.props.optionDisabled);
      }

      return option && option['disabled'] !== undefined ? option['disabled'] : false;
    }
  }, {
    key: "getOptionGroupRenderKey",
    value: function getOptionGroupRenderKey(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupLabel);
    }
  }, {
    key: "getOptionGroupLabel",
    value: function getOptionGroupLabel(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupLabel);
    }
  }, {
    key: "getOptionGroupChildren",
    value: function getOptionGroupChildren(optionGroup) {
      return ObjectUtils.resolveFieldData(optionGroup, this.props.optionGroupChildren);
    }
  }, {
    key: "checkValidity",
    value: function checkValidity() {
      return this.inputRef.current.checkValidity();
    }
  }, {
    key: "getVisibleOptions",
    value: function getVisibleOptions() {
      if (this.hasFilter()) {
        var filterValue = this.state.filter.trim().toLocaleLowerCase(this.props.filterLocale);
        var searchFields = this.props.filterBy ? this.props.filterBy.split(',') : [this.props.optionLabel || 'label'];

        if (this.props.optionGroupLabel) {
          var filteredGroups = [];

          var _iterator = _createForOfIteratorHelper$d(this.props.options),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var optgroup = _step.value;
              var filteredSubOptions = FilterUtils.filter(this.getOptionGroupChildren(optgroup), searchFields, filterValue, this.props.filterMatchMode, this.props.filterLocale);

              if (filteredSubOptions && filteredSubOptions.length) {
                filteredGroups.push(_objectSpread$x(_objectSpread$x({}, optgroup), {
                  items: filteredSubOptions
                }));
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          return filteredGroups;
        } else {
          return FilterUtils.filter(this.props.options, searchFields, filterValue, this.props.filterMatchMode, this.props.filterLocale);
        }
      } else {
        return this.props.options;
      }
    }
  }, {
    key: "updateInputField",
    value: function updateInputField() {
      if (this.props.editable && this.input) {
        var selectedOption = this.getSelectedOption();
        var label = selectedOption ? this.getOptionLabel(selectedOption) : null;
        var value = label || this.props.value || '';
        this.input.value = value;
      }
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();

      if (this.props.autoFocus && this.focusInput) {
        this.focusInput.focus();
      }

      if (this.props.tooltip) {
        this.renderTooltip();
      }

      this.updateInputField();
      this.inputRef.current.selectedIndex = 1;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentClickListener();
      this.unbindResizeListener();

      if (this.scrollHandler) {
        this.scrollHandler.destroy();
        this.scrollHandler = null;
      }

      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }

      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
        this.hideTimeout = null;
      }

      ZIndexUtils.clear(this.overlayRef.current);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.state.overlayVisible) {
        if (this.props.filter) {
          this.alignOverlay();
        }

        if (prevProps.value !== this.props.value) {
          this.scrollInView();
        }
      }

      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$x({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }

      if (this.state.filter && (!this.props.options || this.props.options.length === 0)) {
        this.setState({
          filter: ''
        });
      }

      this.updateInputField();
      this.inputRef.current.selectedIndex = 1;
    }
  }, {
    key: "renderHiddenSelect",
    value: function renderHiddenSelect(selectedOption) {
      var placeHolderOption = /*#__PURE__*/React__default['default'].createElement("option", {
        value: ""
      }, this.props.placeholder);
      var option = selectedOption ? /*#__PURE__*/React__default['default'].createElement("option", {
        value: selectedOption.value
      }, this.getOptionLabel(selectedOption)) : null;
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hidden-accessible p-dropdown-hidden-select"
      }, /*#__PURE__*/React__default['default'].createElement("select", {
        ref: this.inputRef,
        required: this.props.required,
        name: this.props.name,
        tabIndex: -1,
        "aria-hidden": "true"
      }, placeHolderOption, option));
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.container,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "renderKeyboardHelper",
    value: function renderKeyboardHelper() {
      var _this11 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hidden-accessible"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: function ref(el) {
          return _this11.focusInput = el;
        },
        id: this.props.inputId,
        type: "text",
        readOnly: true,
        "aria-haspopup": "listbox",
        onFocus: this.onInputFocus,
        onBlur: this.onInputBlur,
        onKeyDown: this.onInputKeyDown,
        disabled: this.props.disabled,
        tabIndex: this.props.tabIndex,
        "aria-label": this.props.ariaLabel,
        "aria-labelledby": this.props.ariaLabelledBy
      }));
    }
  }, {
    key: "renderLabel",
    value: function renderLabel(selectedOption) {
      var _this12 = this;

      var label = selectedOption ? this.getOptionLabel(selectedOption) : null;

      if (this.props.editable) {
        var value = label || this.props.value || '';
        return /*#__PURE__*/React__default['default'].createElement("input", {
          ref: function ref(el) {
            return _this12.input = el;
          },
          type: "text",
          defaultValue: value,
          className: "p-dropdown-label p-inputtext",
          disabled: this.props.disabled,
          placeholder: this.props.placeholder,
          maxLength: this.props.maxLength,
          onInput: this.onEditableInputChange,
          onFocus: this.onEditableInputFocus,
          onBlur: this.onInputBlur,
          "aria-label": this.props.ariaLabel,
          "aria-labelledby": this.props.ariaLabelledBy,
          "aria-haspopup": "listbox"
        });
      } else {
        var className = classNames('p-dropdown-label p-inputtext', {
          'p-placeholder': label === null && this.props.placeholder,
          'p-dropdown-label-empty': label === null && !this.props.placeholder
        });
        var content = this.props.valueTemplate ? ObjectUtils.getJSXElement(this.props.valueTemplate, selectedOption, this.props) : label || this.props.placeholder || 'empty';
        return /*#__PURE__*/React__default['default'].createElement("span", {
          ref: function ref(el) {
            return _this12.input = el;
          },
          className: className
        }, content);
      }
    }
  }, {
    key: "renderClearIcon",
    value: function renderClearIcon() {
      if (this.props.value != null && this.props.showClear && !this.props.disabled) {
        return /*#__PURE__*/React__default['default'].createElement("i", {
          className: "p-dropdown-clear-icon pi pi-times",
          onClick: this.clear
        });
      }

      return null;
    }
  }, {
    key: "renderDropdownIcon",
    value: function renderDropdownIcon() {
      var _this13 = this;

      var iconClassName = classNames('p-dropdown-trigger-icon p-clickable', this.props.dropdownIcon);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this13.trigger = el;
        },
        className: "p-dropdown-trigger",
        role: "button",
        "aria-haspopup": "listbox",
        "aria-expanded": this.state.overlayVisible
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this14 = this;

      var className = classNames('p-dropdown p-component p-inputwrapper', this.props.className, {
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused,
        'p-dropdown-clearable': this.props.showClear && !this.props.disabled,
        'p-inputwrapper-filled': this.props.value,
        'p-inputwrapper-focus': this.state.focused || this.state.overlayVisible
      });
      var visibleOptions = this.getVisibleOptions();
      var selectedOption = this.getSelectedOption();
      var hiddenSelect = this.renderHiddenSelect(selectedOption);
      var keyboardHelper = this.renderKeyboardHelper();
      var labelElement = this.renderLabel(selectedOption);
      var dropdownIcon = this.renderDropdownIcon();
      var clearIcon = this.renderClearIcon();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        ref: function ref(el) {
          return _this14.container = el;
        },
        className: className,
        style: this.props.style,
        onClick: this.onClick,
        onMouseDown: this.props.onMouseDown,
        onContextMenu: this.props.onContextMenu
      }, keyboardHelper, hiddenSelect, labelElement, clearIcon, dropdownIcon, /*#__PURE__*/React__default['default'].createElement(DropdownPanel, _extends({
        ref: this.overlayRef,
        visibleOptions: visibleOptions
      }, this.props, {
        onClick: this.onPanelClick,
        onOptionClick: this.onOptionClick,
        filterValue: this.state.filter,
        hasFilter: this.hasFilter,
        onFilterClearIconClick: this.onFilterClearIconClick,
        onFilterInputKeyDown: this.onFilterInputKeyDown,
        onFilterInputChange: this.onFilterInputChange,
        getOptionLabel: this.getOptionLabel,
        getOptionRenderKey: this.getOptionRenderKey,
        isOptionDisabled: this.isOptionDisabled,
        getOptionGroupChildren: this.getOptionGroupChildren,
        getOptionGroupLabel: this.getOptionGroupLabel,
        getOptionGroupRenderKey: this.getOptionGroupRenderKey,
        isSelected: this.isSelected,
        getSelectedOptionIndex: this.getSelectedOptionIndex,
        in: this.state.overlayVisible,
        onEnter: this.onOverlayEnter,
        onEntered: this.onOverlayEntered,
        onExit: this.onOverlayExit,
        onExited: this.onOverlayExited
      })));
    }
  }]);

  return Dropdown;
}(React.Component);

_defineProperty(Dropdown, "defaultProps", {
  id: null,
  inputRef: null,
  name: null,
  value: null,
  options: null,
  optionLabel: null,
  optionValue: null,
  optionDisabled: null,
  optionGroupLabel: null,
  optionGroupChildren: null,
  optionGroupTemplate: null,
  valueTemplate: null,
  itemTemplate: null,
  style: null,
  className: null,
  virtualScrollerOptions: null,
  scrollHeight: '200px',
  filter: false,
  filterBy: null,
  filterMatchMode: 'contains',
  filterPlaceholder: null,
  filterLocale: undefined,
  emptyMessage: 'No records found',
  emptyFilterMessage: 'No results found',
  editable: false,
  placeholder: null,
  required: false,
  disabled: false,
  appendTo: null,
  tabIndex: null,
  autoFocus: false,
  filterInputAutoFocus: true,
  resetFilterOnHide: false,
  showFilterClear: false,
  panelClassName: null,
  panelStyle: null,
  dataKey: null,
  inputId: null,
  showClear: false,
  maxLength: null,
  tooltip: null,
  tooltipOptions: null,
  ariaLabel: null,
  ariaLabelledBy: null,
  transitionOptions: null,
  dropdownIcon: 'pi pi-chevron-down',
  showOnFocus: false,
  onChange: null,
  onFocus: null,
  onBlur: null,
  onMouseDown: null,
  onContextMenu: null,
  onShow: null,
  onHide: null,
  onFilter: null
});

function _createSuper$1H(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1H(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1H() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var RowsPerPageDropdown = /*#__PURE__*/function (_Component) {
  _inherits(RowsPerPageDropdown, _Component);

  var _super = _createSuper$1H(RowsPerPageDropdown);

  function RowsPerPageDropdown() {
    _classCallCheck(this, RowsPerPageDropdown);

    return _super.apply(this, arguments);
  }

  _createClass(RowsPerPageDropdown, [{
    key: "hasOptions",
    value: function hasOptions() {
      return this.props.options && this.props.options.length > 0;
    }
  }, {
    key: "render",
    value: function render() {
      var hasOptions = this.hasOptions();
      var options = hasOptions ? this.props.options.map(function (opt) {
        return {
          label: String(opt),
          value: opt
        };
      }) : [];
      var element = hasOptions ? /*#__PURE__*/React__default['default'].createElement(Dropdown, {
        value: this.props.value,
        options: options,
        onChange: this.props.onChange,
        appendTo: this.props.appendTo,
        disabled: this.props.disabled
      }) : null;

      if (this.props.template) {
        var defaultOptions = {
          value: this.props.value,
          options: options,
          onChange: this.props.onChange,
          appendTo: this.props.appendTo,
          currentPage: this.props.page,
          totalPages: this.props.pageCount,
          totalRecords: this.props.totalRecords,
          disabled: this.props.disabled,
          element: element,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return RowsPerPageDropdown;
}(React.Component);

_defineProperty(RowsPerPageDropdown, "defaultProps", {
  options: null,
  value: null,
  page: null,
  pageCount: null,
  totalRecords: 0,
  appendTo: null,
  onChange: null,
  template: null,
  disabled: false
});

function ownKeys$w(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$w(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$w(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$w(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1G(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1G(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1G() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var CurrentPageReport = /*#__PURE__*/function (_Component) {
  _inherits(CurrentPageReport, _Component);

  var _super = _createSuper$1G(CurrentPageReport);

  function CurrentPageReport() {
    _classCallCheck(this, CurrentPageReport);

    return _super.apply(this, arguments);
  }

  _createClass(CurrentPageReport, [{
    key: "render",
    value: function render() {
      var report = {
        currentPage: this.props.page + 1,
        totalPages: this.props.pageCount,
        first: Math.min(this.props.first + 1, this.props.totalRecords),
        last: Math.min(this.props.first + this.props.rows, this.props.totalRecords),
        rows: this.props.rows,
        totalRecords: this.props.totalRecords
      };
      var text = this.props.reportTemplate.replace("{currentPage}", report.currentPage).replace("{totalPages}", report.totalPages).replace("{first}", report.first).replace("{last}", report.last).replace("{rows}", report.rows).replace("{totalRecords}", report.totalRecords);
      var element = /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-paginator-current"
      }, text);

      if (this.props.template) {
        var defaultOptions = _objectSpread$w(_objectSpread$w({}, report), {
          className: 'p-paginator-current',
          element: element,
          props: this.props
        });

        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return CurrentPageReport;
}(React.Component);

_defineProperty(CurrentPageReport, "defaultProps", {
  pageCount: null,
  page: null,
  first: null,
  rows: null,
  totalRecords: null,
  reportTemplate: '({currentPage} of {totalPages})',
  template: null
});

function ownKeys$v(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$v(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$v(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$v(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1F(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1F(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1F() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var InputNumber = /*#__PURE__*/function (_Component) {
  _inherits(InputNumber, _Component);

  var _super = _createSuper$1F(InputNumber);

  function InputNumber(props) {
    var _this;

    _classCallCheck(this, InputNumber);

    _this = _super.call(this, props);
    _this.state = {
      focused: false
    };

    _this.constructParser();

    _this.onInput = _this.onInput.bind(_assertThisInitialized(_this));
    _this.onInputKeyDown = _this.onInputKeyDown.bind(_assertThisInitialized(_this));
    _this.onInputKeyPress = _this.onInputKeyPress.bind(_assertThisInitialized(_this));
    _this.onInputClick = _this.onInputClick.bind(_assertThisInitialized(_this));
    _this.onInputBlur = _this.onInputBlur.bind(_assertThisInitialized(_this));
    _this.onInputFocus = _this.onInputFocus.bind(_assertThisInitialized(_this));
    _this.onPaste = _this.onPaste.bind(_assertThisInitialized(_this));
    _this.onUpButtonMouseLeave = _this.onUpButtonMouseLeave.bind(_assertThisInitialized(_this));
    _this.onUpButtonMouseDown = _this.onUpButtonMouseDown.bind(_assertThisInitialized(_this));
    _this.onUpButtonMouseUp = _this.onUpButtonMouseUp.bind(_assertThisInitialized(_this));
    _this.onUpButtonKeyDown = _this.onUpButtonKeyDown.bind(_assertThisInitialized(_this));
    _this.onUpButtonKeyUp = _this.onUpButtonKeyUp.bind(_assertThisInitialized(_this));
    _this.onDownButtonMouseLeave = _this.onDownButtonMouseLeave.bind(_assertThisInitialized(_this));
    _this.onDownButtonMouseDown = _this.onDownButtonMouseDown.bind(_assertThisInitialized(_this));
    _this.onDownButtonMouseUp = _this.onDownButtonMouseUp.bind(_assertThisInitialized(_this));
    _this.onDownButtonKeyDown = _this.onDownButtonKeyDown.bind(_assertThisInitialized(_this));
    _this.onDownButtonKeyUp = _this.onDownButtonKeyUp.bind(_assertThisInitialized(_this));
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(InputNumber, [{
    key: "getOptions",
    value: function getOptions() {
      return {
        localeMatcher: this.props.localeMatcher,
        style: this.props.mode,
        currency: this.props.currency,
        currencyDisplay: this.props.currencyDisplay,
        useGrouping: this.props.useGrouping,
        minimumFractionDigits: this.props.minFractionDigits,
        maximumFractionDigits: this.props.maxFractionDigits
      };
    }
  }, {
    key: "constructParser",
    value: function constructParser() {
      this.numberFormat = new Intl.NumberFormat(this.props.locale, this.getOptions());

      var numerals = _toConsumableArray(new Intl.NumberFormat(this.props.locale, {
        useGrouping: false
      }).format(9876543210)).reverse();

      var index = new Map(numerals.map(function (d, i) {
        return [d, i];
      }));
      this._numeral = new RegExp("[".concat(numerals.join(''), "]"), 'g');
      this._group = this.getGroupingExpression();
      this._minusSign = this.getMinusSignExpression();
      this._currency = this.getCurrencyExpression();
      this._decimal = this.getDecimalExpression();
      this._suffix = this.getSuffixExpression();
      this._prefix = this.getPrefixExpression();

      this._index = function (d) {
        return index.get(d);
      };
    }
  }, {
    key: "escapeRegExp",
    value: function escapeRegExp(text) {
      return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    }
  }, {
    key: "getDecimalExpression",
    value: function getDecimalExpression() {
      var formatter = new Intl.NumberFormat(this.props.locale, _objectSpread$v(_objectSpread$v({}, this.getOptions()), {}, {
        useGrouping: false
      }));
      return new RegExp("[".concat(formatter.format(1.1).replace(this._currency, '').trim().replace(this._numeral, ''), "]"), 'g');
    }
  }, {
    key: "getGroupingExpression",
    value: function getGroupingExpression() {
      var formatter = new Intl.NumberFormat(this.props.locale, {
        useGrouping: true
      });
      this.groupChar = formatter.format(1000000).trim().replace(this._numeral, '').charAt(0);
      return new RegExp("[".concat(this.groupChar, "]"), 'g');
    }
  }, {
    key: "getMinusSignExpression",
    value: function getMinusSignExpression() {
      var formatter = new Intl.NumberFormat(this.props.locale, {
        useGrouping: false
      });
      return new RegExp("[".concat(formatter.format(-1).trim().replace(this._numeral, ''), "]"), 'g');
    }
  }, {
    key: "getCurrencyExpression",
    value: function getCurrencyExpression() {
      if (this.props.currency) {
        var formatter = new Intl.NumberFormat(this.props.locale, {
          style: 'currency',
          currency: this.props.currency,
          currencyDisplay: this.props.currencyDisplay,
          minimumFractionDigits: 0,
          maximumFractionDigits: 0
        });
        return new RegExp("[".concat(formatter.format(1).replace(/\s/g, '').replace(this._numeral, '').replace(this._group, ''), "]"), 'g');
      }

      return new RegExp("[]", 'g');
    }
  }, {
    key: "getPrefixExpression",
    value: function getPrefixExpression() {
      if (this.props.prefix) {
        this.prefixChar = this.props.prefix;
      } else {
        var formatter = new Intl.NumberFormat(this.props.locale, {
          style: this.props.mode,
          currency: this.props.currency,
          currencyDisplay: this.props.currencyDisplay
        });
        this.prefixChar = formatter.format(1).split('1')[0];
      }

      return new RegExp("".concat(this.escapeRegExp(this.prefixChar || '')), 'g');
    }
  }, {
    key: "getSuffixExpression",
    value: function getSuffixExpression() {
      if (this.props.suffix) {
        this.suffixChar = this.props.suffix;
      } else {
        var formatter = new Intl.NumberFormat(this.props.locale, {
          style: this.props.mode,
          currency: this.props.currency,
          currencyDisplay: this.props.currencyDisplay,
          minimumFractionDigits: 0,
          maximumFractionDigits: 0
        });
        this.suffixChar = formatter.format(1).split('1')[1];
      }

      return new RegExp("".concat(this.escapeRegExp(this.suffixChar || '')), 'g');
    }
  }, {
    key: "formatValue",
    value: function formatValue(value) {
      if (value != null) {
        if (value === '-') {
          // Minus sign
          return value;
        }

        if (this.props.format) {
          var formatter = new Intl.NumberFormat(this.props.locale, this.getOptions());
          var formattedValue = formatter.format(value);

          if (this.props.prefix) {
            formattedValue = this.props.prefix + formattedValue;
          }

          if (this.props.suffix) {
            formattedValue = formattedValue + this.props.suffix;
          }

          return formattedValue;
        }

        return value.toString();
      }

      return '';
    }
  }, {
    key: "parseValue",
    value: function parseValue(text) {
      var filteredText = text.replace(this._suffix, '').replace(this._prefix, '').trim().replace(/\s/g, '').replace(this._currency, '').replace(this._group, '').replace(this._minusSign, '-').replace(this._decimal, '.').replace(this._numeral, this._index);

      if (filteredText) {
        if (filteredText === '-') // Minus sign
          return filteredText;
        var parsedValue = +filteredText;
        return isNaN(parsedValue) ? null : parsedValue;
      }

      return null;
    }
  }, {
    key: "repeat",
    value: function repeat(event, interval, dir) {
      var _this2 = this;

      var i = interval || 500;
      this.clearTimer();
      this.timer = setTimeout(function () {
        _this2.repeat(event, 40, dir);
      }, i);
      this.spin(event, dir);
    }
  }, {
    key: "spin",
    value: function spin(event, dir) {
      if (this.inputRef && this.inputRef.current) {
        var step = this.props.step * dir;
        var currentValue = this.parseValue(this.inputRef.current.value) || 0;
        var newValue = this.validateValue(currentValue + step);
        this.updateInput(newValue, null, 'spin');
        this.updateModel(event, newValue);
        this.handleOnChange(event, currentValue, newValue);
      }
    }
  }, {
    key: "onUpButtonMouseDown",
    value: function onUpButtonMouseDown(event) {
      if (!this.props.disabled) {
        this.inputRef.current.focus();
        this.repeat(event, null, 1);
        event.preventDefault();
      }
    }
  }, {
    key: "onUpButtonMouseUp",
    value: function onUpButtonMouseUp() {
      if (!this.props.disabled) {
        this.clearTimer();
      }
    }
  }, {
    key: "onUpButtonMouseLeave",
    value: function onUpButtonMouseLeave() {
      if (!this.props.disabled) {
        this.clearTimer();
      }
    }
  }, {
    key: "onUpButtonKeyUp",
    value: function onUpButtonKeyUp() {
      if (!this.props.disabled) {
        this.clearTimer();
      }
    }
  }, {
    key: "onUpButtonKeyDown",
    value: function onUpButtonKeyDown(event) {
      if (event.keyCode === 32 || event.keyCode === 13) {
        this.repeat(event, null, 1);
      }
    }
  }, {
    key: "onDownButtonMouseDown",
    value: function onDownButtonMouseDown(event) {
      if (!this.props.disabled) {
        this.inputRef.current.focus();
        this.repeat(event, null, -1);
        event.preventDefault();
      }
    }
  }, {
    key: "onDownButtonMouseUp",
    value: function onDownButtonMouseUp() {
      if (!this.props.disabled) {
        this.clearTimer();
      }
    }
  }, {
    key: "onDownButtonMouseLeave",
    value: function onDownButtonMouseLeave() {
      if (!this.props.disabled) {
        this.clearTimer();
      }
    }
  }, {
    key: "onDownButtonKeyUp",
    value: function onDownButtonKeyUp() {
      if (!this.props.disabled) {
        this.clearTimer();
      }
    }
  }, {
    key: "onDownButtonKeyDown",
    value: function onDownButtonKeyDown(event) {
      if (event.keyCode === 32 || event.keyCode === 13) {
        this.repeat(event, null, -1);
      }
    }
  }, {
    key: "onInput",
    value: function onInput(event) {
      if (this.isSpecialChar) {
        event.target.value = this.lastValue;
      }

      this.isSpecialChar = false;
    }
  }, {
    key: "onInputKeyDown",
    value: function onInputKeyDown(event) {
      this.lastValue = event.target.value;

      if (event.shiftKey || event.altKey) {
        this.isSpecialChar = true;
        return;
      }

      var selectionStart = event.target.selectionStart;
      var selectionEnd = event.target.selectionEnd;
      var inputValue = event.target.value;
      var newValueStr = null;

      if (event.altKey) {
        event.preventDefault();
      }

      switch (event.which) {
        //up
        case 38:
          this.spin(event, 1);
          event.preventDefault();
          break;
        //down

        case 40:
          this.spin(event, -1);
          event.preventDefault();
          break;
        //left

        case 37:
          if (!this.isNumeralChar(inputValue.charAt(selectionStart - 1))) {
            event.preventDefault();
          }

          break;
        //right

        case 39:
          if (!this.isNumeralChar(inputValue.charAt(selectionStart))) {
            event.preventDefault();
          }

          break;
        //enter

        case 13:
          newValueStr = this.validateValue(this.parseValue(inputValue));
          this.inputRef.current.value = this.formatValue(newValueStr);
          this.inputRef.current.setAttribute('aria-valuenow', newValueStr);
          this.updateModel(event, newValueStr);
          break;
        //backspace

        case 8:
          event.preventDefault();

          if (selectionStart === selectionEnd) {
            var deleteChar = inputValue.charAt(selectionStart - 1);

            var _this$getDecimalCharI = this.getDecimalCharIndexes(inputValue),
                decimalCharIndex = _this$getDecimalCharI.decimalCharIndex,
                decimalCharIndexWithoutPrefix = _this$getDecimalCharI.decimalCharIndexWithoutPrefix;

            if (this.isNumeralChar(deleteChar)) {
              var decimalLength = this.getDecimalLength(inputValue);

              if (this._group.test(deleteChar)) {
                this._group.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart - 2) + inputValue.slice(selectionStart - 1);
              } else if (this._decimal.test(deleteChar)) {
                this._decimal.lastIndex = 0;

                if (decimalLength) {
                  this.inputRef.current.setSelectionRange(selectionStart - 1, selectionStart - 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
                }
              } else if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
                var insertedText = this.isDecimalMode() && (this.props.minFractionDigits || 0) < decimalLength ? '' : '0';
                newValueStr = inputValue.slice(0, selectionStart - 1) + insertedText + inputValue.slice(selectionStart);
              } else if (decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart - 1) + '0' + inputValue.slice(selectionStart);
                newValueStr = this.parseValue(newValueStr) > 0 ? newValueStr : '';
              } else {
                newValueStr = inputValue.slice(0, selectionStart - 1) + inputValue.slice(selectionStart);
              }
            }

            this.updateValue(event, newValueStr, null, 'delete-single');
          } else {
            newValueStr = this.deleteRange(inputValue, selectionStart, selectionEnd);
            this.updateValue(event, newValueStr, null, 'delete-range');
          }

          break;
        // del

        case 46:
          event.preventDefault();

          if (selectionStart === selectionEnd) {
            var _deleteChar = inputValue.charAt(selectionStart);

            var _this$getDecimalCharI2 = this.getDecimalCharIndexes(inputValue),
                _decimalCharIndex = _this$getDecimalCharI2.decimalCharIndex,
                _decimalCharIndexWithoutPrefix = _this$getDecimalCharI2.decimalCharIndexWithoutPrefix;

            if (this.isNumeralChar(_deleteChar)) {
              var _decimalLength = this.getDecimalLength(inputValue);

              if (this._group.test(_deleteChar)) {
                this._group.lastIndex = 0;
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 2);
              } else if (this._decimal.test(_deleteChar)) {
                this._decimal.lastIndex = 0;

                if (_decimalLength) {
                  this.$refs.input.$el.setSelectionRange(selectionStart + 1, selectionStart + 1);
                } else {
                  newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
                }
              } else if (_decimalCharIndex > 0 && selectionStart > _decimalCharIndex) {
                var _insertedText = this.isDecimalMode() && (this.props.minFractionDigits || 0) < _decimalLength ? '' : '0';

                newValueStr = inputValue.slice(0, selectionStart) + _insertedText + inputValue.slice(selectionStart + 1);
              } else if (_decimalCharIndexWithoutPrefix === 1) {
                newValueStr = inputValue.slice(0, selectionStart) + '0' + inputValue.slice(selectionStart + 1);
                newValueStr = this.parseValue(newValueStr) > 0 ? newValueStr : '';
              } else {
                newValueStr = inputValue.slice(0, selectionStart) + inputValue.slice(selectionStart + 1);
              }
            }

            this.updateValue(event, newValueStr, null, 'delete-back-single');
          } else {
            newValueStr = this.deleteRange(inputValue, selectionStart, selectionEnd);
            this.updateValue(event, newValueStr, null, 'delete-range');
          }

          break;
      }

      if (this.props.onKeyDown) {
        this.props.onKeyDown(event);
      }
    }
  }, {
    key: "onInputKeyPress",
    value: function onInputKeyPress(event) {
      event.preventDefault();
      var code = event.which || event.keyCode;
      var char = String.fromCharCode(code);
      var isDecimalSign = this.isDecimalSign(char);
      var isMinusSign = this.isMinusSign(char);

      if (48 <= code && code <= 57 || isMinusSign || isDecimalSign) {
        this.insert(event, char, {
          isDecimalSign: isDecimalSign,
          isMinusSign: isMinusSign
        });
      }
    }
  }, {
    key: "onPaste",
    value: function onPaste(event) {
      event.preventDefault();
      var data = (event.clipboardData || window['clipboardData']).getData('Text');

      if (data) {
        var filteredData = this.parseValue(data);

        if (filteredData != null) {
          this.insert(event, filteredData.toString());
        }
      }
    }
  }, {
    key: "allowMinusSign",
    value: function allowMinusSign() {
      return this.props.min === null || this.props.min < 0;
    }
  }, {
    key: "isMinusSign",
    value: function isMinusSign(char) {
      if (this._minusSign.test(char) || char === '-') {
        this._minusSign.lastIndex = 0;
        return true;
      }

      return false;
    }
  }, {
    key: "isDecimalSign",
    value: function isDecimalSign(char) {
      if (this._decimal.test(char)) {
        this._decimal.lastIndex = 0;
        return true;
      }

      return false;
    }
  }, {
    key: "isDecimalMode",
    value: function isDecimalMode() {
      return this.props.mode === 'decimal';
    }
  }, {
    key: "getDecimalCharIndexes",
    value: function getDecimalCharIndexes(val) {
      var decimalCharIndex = val.search(this._decimal);
      this._decimal.lastIndex = 0;
      var filteredVal = val.replace(this._prefix, '').trim().replace(/\s/g, '').replace(this._currency, '');
      var decimalCharIndexWithoutPrefix = filteredVal.search(this._decimal);
      this._decimal.lastIndex = 0;
      return {
        decimalCharIndex: decimalCharIndex,
        decimalCharIndexWithoutPrefix: decimalCharIndexWithoutPrefix
      };
    }
  }, {
    key: "getCharIndexes",
    value: function getCharIndexes(val) {
      var decimalCharIndex = val.search(this._decimal);
      this._decimal.lastIndex = 0;
      var minusCharIndex = val.search(this._minusSign);
      this._minusSign.lastIndex = 0;
      var suffixCharIndex = val.search(this._suffix);
      this._suffix.lastIndex = 0;
      var currencyCharIndex = val.search(this._currency);
      this._currency.lastIndex = 0;
      return {
        decimalCharIndex: decimalCharIndex,
        minusCharIndex: minusCharIndex,
        suffixCharIndex: suffixCharIndex,
        currencyCharIndex: currencyCharIndex
      };
    }
  }, {
    key: "insert",
    value: function insert(event, text) {
      var sign = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
        isDecimalSign: false,
        isMinusSign: false
      };
      var minusCharIndexOnText = text.search(this._minusSign);
      this._minusSign.lastIndex = 0;

      if (!this.allowMinusSign() && minusCharIndexOnText !== -1) {
        return;
      }

      var selectionStart = this.inputRef.current.selectionStart;
      var selectionEnd = this.inputRef.current.selectionEnd;
      var inputValue = this.inputRef.current.value.trim();

      var _this$getCharIndexes = this.getCharIndexes(inputValue),
          decimalCharIndex = _this$getCharIndexes.decimalCharIndex,
          minusCharIndex = _this$getCharIndexes.minusCharIndex,
          suffixCharIndex = _this$getCharIndexes.suffixCharIndex,
          currencyCharIndex = _this$getCharIndexes.currencyCharIndex;

      var newValueStr;

      if (sign.isMinusSign) {
        if (selectionStart === 0) {
          newValueStr = inputValue;

          if (minusCharIndex === -1 || selectionEnd !== 0) {
            newValueStr = this.insertText(inputValue, text, 0, selectionEnd);
          }

          this.updateValue(event, newValueStr, text, 'insert');
        }
      } else if (sign.isDecimalSign) {
        if (decimalCharIndex > 0 && selectionStart === decimalCharIndex) {
          this.updateValue(event, inputValue, text, 'insert');
        } else if (decimalCharIndex > selectionStart && decimalCharIndex < selectionEnd) {
          newValueStr = this.insertText(inputValue, text, selectionStart, selectionEnd);
          this.updateValue(event, newValueStr, text, 'insert');
        } else if (decimalCharIndex === -1 && this.props.maxFractionDigits) {
          newValueStr = this.insertText(inputValue, text, selectionStart, selectionEnd);
          this.updateValue(event, newValueStr, text, 'insert');
        }
      } else {
        var maxFractionDigits = this.numberFormat.resolvedOptions().maximumFractionDigits;
        var operation = selectionStart !== selectionEnd ? 'range-insert' : 'insert';

        if (decimalCharIndex > 0 && selectionStart > decimalCharIndex) {
          if (selectionStart + text.length - (decimalCharIndex + 1) <= maxFractionDigits) {
            var charIndex = currencyCharIndex >= selectionStart ? currencyCharIndex - 1 : suffixCharIndex >= selectionStart ? suffixCharIndex : inputValue.length;
            newValueStr = inputValue.slice(0, selectionStart) + text + inputValue.slice(selectionStart + text.length, charIndex) + inputValue.slice(charIndex);
            this.updateValue(event, newValueStr, text, operation);
          }
        } else {
          newValueStr = this.insertText(inputValue, text, selectionStart, selectionEnd);
          this.updateValue(event, newValueStr, text, operation);
        }
      }
    }
  }, {
    key: "insertText",
    value: function insertText(value, text, start, end) {
      var textSplit = text === '.' ? text : text.split('.');

      if (textSplit.length === 2) {
        var decimalCharIndex = value.slice(start, end).search(this._decimal);
        this._decimal.lastIndex = 0;
        return decimalCharIndex > 0 ? value.slice(0, start) + this.formatValue(text) + value.slice(end) : value || this.formatValue(text);
      } else if (end - start === value.length) {
        return this.formatValue(text);
      } else if (start === 0) {
        return text + value.slice(end);
      } else if (end === value.length) {
        return value.slice(0, start) + text;
      } else {
        return value.slice(0, start) + text + value.slice(end);
      }
    }
  }, {
    key: "deleteRange",
    value: function deleteRange(value, start, end) {
      var newValueStr;
      if (end - start === value.length) newValueStr = '';else if (start === 0) newValueStr = value.slice(end);else if (end === value.length) newValueStr = value.slice(0, start);else newValueStr = value.slice(0, start) + value.slice(end);
      return newValueStr;
    }
  }, {
    key: "initCursor",
    value: function initCursor() {
      var selectionStart = this.inputRef.current.selectionStart;
      var inputValue = this.inputRef.current.value;
      var valueLength = inputValue.length;
      var index = null; // remove prefix

      var prefixLength = (this.prefixChar || '').length;
      inputValue = inputValue.replace(this._prefix, '');
      selectionStart = selectionStart - prefixLength;
      var char = inputValue.charAt(selectionStart);

      if (this.isNumeralChar(char)) {
        return selectionStart + prefixLength;
      } //left


      var i = selectionStart - 1;

      while (i >= 0) {
        char = inputValue.charAt(i);

        if (this.isNumeralChar(char)) {
          index = i + prefixLength;
          break;
        } else {
          i--;
        }
      }

      if (index !== null) {
        this.inputRef.current.setSelectionRange(index + 1, index + 1);
      } else {
        i = selectionStart;

        while (i < valueLength) {
          char = inputValue.charAt(i);

          if (this.isNumeralChar(char)) {
            index = i + prefixLength;
            break;
          } else {
            i++;
          }
        }

        if (index !== null) {
          this.inputRef.current.setSelectionRange(index, index);
        }
      }

      return index || 0;
    }
  }, {
    key: "onInputClick",
    value: function onInputClick() {
      this.initCursor();
    }
  }, {
    key: "isNumeralChar",
    value: function isNumeralChar(char) {
      if (char.length === 1 && (this._numeral.test(char) || this._decimal.test(char) || this._group.test(char) || this._minusSign.test(char))) {
        this.resetRegex();
        return true;
      } else {
        return false;
      }
    }
  }, {
    key: "resetRegex",
    value: function resetRegex() {
      this._numeral.lastIndex = 0;
      this._decimal.lastIndex = 0;
      this._group.lastIndex = 0;
      this._minusSign.lastIndex = 0;
    }
  }, {
    key: "updateValue",
    value: function updateValue(event, valueStr, insertedValueStr, operation) {
      var currentValue = this.inputRef.current.value;
      var newValue = null;

      if (valueStr != null) {
        newValue = this.parseValue(valueStr);
        newValue = !newValue && !this.props.allowEmpty ? 0 : newValue;
        this.updateInput(newValue, insertedValueStr, operation, valueStr);
        this.handleOnChange(event, currentValue, newValue);
      }
    }
  }, {
    key: "handleOnChange",
    value: function handleOnChange(event, currentValue, newValue) {
      if (this.props.onChange && this.isValueChanged(currentValue, newValue)) {
        this.props.onChange({
          originalEvent: event,
          value: newValue
        });
      }
    }
  }, {
    key: "isValueChanged",
    value: function isValueChanged(currentValue, newValue) {
      if (newValue === null && currentValue !== null) {
        return true;
      }

      if (newValue != null) {
        var parsedCurrentValue = typeof currentValue === 'string' ? this.parseValue(currentValue) : currentValue;
        return newValue !== parsedCurrentValue;
      }

      return false;
    }
  }, {
    key: "validateValue",
    value: function validateValue(value) {
      if (value === '-' || value == null) {
        return null;
      }

      if (this.props.min !== null && value < this.props.min) {
        return this.props.min;
      }

      if (this.props.max !== null && value > this.props.max) {
        return this.props.max;
      }

      return value;
    }
  }, {
    key: "updateInput",
    value: function updateInput(value, insertedValueStr, operation, valueStr) {
      insertedValueStr = insertedValueStr || '';
      var inputEl = this.inputRef.current;
      var inputValue = inputEl.value;
      var newValue = this.formatValue(value);
      var currentLength = inputValue.length;

      if (newValue !== valueStr) {
        newValue = this.concatValues(newValue, valueStr);
      }

      if (currentLength === 0) {
        inputEl.value = newValue;
        inputEl.setSelectionRange(0, 0);
        var index = this.initCursor();
        var selectionEnd = index + insertedValueStr.length;
        inputEl.setSelectionRange(selectionEnd, selectionEnd);
      } else {
        var selectionStart = inputEl.selectionStart;
        var _selectionEnd = inputEl.selectionEnd;
        inputEl.value = newValue;
        var newLength = newValue.length;

        if (operation === 'range-insert') {
          var startValue = this.parseValue((inputValue || '').slice(0, selectionStart));
          var startValueStr = startValue !== null ? startValue.toString() : '';
          var startExpr = startValueStr.split('').join("(".concat(this.groupChar, ")?"));
          var sRegex = new RegExp(startExpr, 'g');
          sRegex.test(newValue);
          var tExpr = insertedValueStr.split('').join("(".concat(this.groupChar, ")?"));
          var tRegex = new RegExp(tExpr, 'g');
          tRegex.test(newValue.slice(sRegex.lastIndex));
          _selectionEnd = sRegex.lastIndex + tRegex.lastIndex;
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (newLength === currentLength) {
          if (operation === 'insert' || operation === 'delete-back-single') inputEl.setSelectionRange(_selectionEnd + 1, _selectionEnd + 1);else if (operation === 'delete-single') inputEl.setSelectionRange(_selectionEnd - 1, _selectionEnd - 1);else if (operation === 'delete-range' || operation === 'spin') inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (operation === 'delete-back-single') {
          var prevChar = inputValue.charAt(_selectionEnd - 1);
          var nextChar = inputValue.charAt(_selectionEnd);
          var diff = currentLength - newLength;

          var isGroupChar = this._group.test(nextChar);

          if (isGroupChar && diff === 1) {
            _selectionEnd += 1;
          } else if (!isGroupChar && this.isNumeralChar(prevChar)) {
            _selectionEnd += -1 * diff + 1;
          }

          this._group.lastIndex = 0;
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        } else if (inputValue === '-' && operation === 'insert') {
          inputEl.setSelectionRange(0, 0);

          var _index = this.initCursor();

          var _selectionEnd2 = _index + insertedValueStr.length + 1;

          inputEl.setSelectionRange(_selectionEnd2, _selectionEnd2);
        } else {
          _selectionEnd = _selectionEnd + (newLength - currentLength);
          inputEl.setSelectionRange(_selectionEnd, _selectionEnd);
        }
      }

      inputEl.setAttribute('aria-valuenow', value);
    }
  }, {
    key: "updateInputValue",
    value: function updateInputValue(newValue) {
      newValue = !newValue && !this.props.allowEmpty ? 0 : newValue;
      var inputEl = this.inputRef.current;
      var value = inputEl.value;
      var formattedValue = this.formattedValue(newValue);

      if (value !== formattedValue) {
        inputEl.value = formattedValue;
        inputEl.setAttribute('aria-valuenow', newValue);
      }
    }
  }, {
    key: "formattedValue",
    value: function formattedValue(val) {
      var newVal = !val && !this.props.allowEmpty ? 0 : val;
      return this.formatValue(newVal);
    }
  }, {
    key: "concatValues",
    value: function concatValues(val1, val2) {
      if (val1 && val2) {
        var decimalCharIndex = val2.search(this._decimal);
        this._decimal.lastIndex = 0;
        return decimalCharIndex !== -1 ? val1.split(this._decimal)[0] + val2.slice(decimalCharIndex) : val1;
      }

      return val1;
    }
  }, {
    key: "getDecimalLength",
    value: function getDecimalLength(value) {
      if (value) {
        var valueSplit = value.split(this._decimal);

        if (valueSplit.length === 2) {
          return valueSplit[1].replace(this._suffix, '').trim().replace(/\s/g, '').replace(this._currency, '').length;
        }
      }

      return 0;
    }
  }, {
    key: "updateModel",
    value: function updateModel(event, value) {
      if (this.props.onValueChange) {
        this.props.onValueChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: value
          }
        });
      }
    }
  }, {
    key: "onInputFocus",
    value: function onInputFocus(event) {
      var _this3 = this;

      event.persist();
      this.setState({
        focused: true
      }, function () {
        if (_this3.props.onFocus) {
          _this3.props.onFocus(event);
        }
      });
    }
  }, {
    key: "onInputBlur",
    value: function onInputBlur(event) {
      var _this4 = this;

      event.persist();
      this.setState({
        focused: false
      }, function () {
        var currentValue = _this4.inputRef.current.value;

        if (_this4.isValueChanged(currentValue, _this4.props.value)) {
          var newValue = _this4.validateValue(_this4.parseValue(currentValue));

          _this4.updateInputValue(newValue);

          _this4.updateModel(event, newValue);
        }

        if (_this4.props.onBlur) {
          _this4.props.onBlur(event);
        }
      });
    }
  }, {
    key: "clearTimer",
    value: function clearTimer() {
      if (this.timer) {
        clearInterval(this.timer);
      }
    }
  }, {
    key: "isStacked",
    value: function isStacked() {
      return this.props.showButtons && this.props.buttonLayout === 'stacked';
    }
  }, {
    key: "isHorizontal",
    value: function isHorizontal() {
      return this.props.showButtons && this.props.buttonLayout === 'horizontal';
    }
  }, {
    key: "isVertical",
    value: function isVertical() {
      return this.props.showButtons && this.props.buttonLayout === 'vertical';
    }
  }, {
    key: "getInputMode",
    value: function getInputMode() {
      return this.props.inputMode || (this.props.mode === 'decimal' && !this.props.minFractionDigits ? 'numeric' : 'decimal');
    }
  }, {
    key: "getFormatter",
    value: function getFormatter() {
      return this.numberFormat;
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }

      var newValue = this.validateValue(this.props.value);

      if (this.props.value !== null && this.props.value !== newValue) {
        this.updateModel(null, newValue);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$v({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }

      var isOptionChanged = this.isOptionChanged(prevProps);

      if (isOptionChanged) {
        this.constructParser();
      }

      if (prevProps.value !== this.props.value || isOptionChanged) {
        var newValue = this.validateValue(this.props.value);
        this.updateInputValue(newValue);

        if (this.props.value !== null && this.props.value !== newValue) {
          this.updateModel(null, newValue);
        }
      }
    }
  }, {
    key: "isOptionChanged",
    value: function isOptionChanged(prevProps) {
      var _this5 = this;

      var optionProps = ['locale', 'localeMatcher', 'mode', 'currency', 'currencyDisplay', 'useGrouping', 'minFractionDigits', 'maxFractionDigits', 'suffix', 'prefix'];
      return optionProps.some(function (option) {
        return prevProps[option] !== _this5.props[option];
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.element,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "renderInputElement",
    value: function renderInputElement() {
      var className = classNames('p-inputnumber-input', this.props.inputClassName);
      var valueToRender = this.formattedValue(this.props.value);
      return /*#__PURE__*/React__default['default'].createElement(InputText, {
        ref: this.inputRef,
        id: this.props.inputId,
        style: this.props.inputStyle,
        role: "spinbutton",
        className: className,
        defaultValue: valueToRender,
        type: this.props.type,
        size: this.props.size,
        tabIndex: this.props.tabIndex,
        inputMode: this.getInputMode(),
        maxLength: this.props.maxlength,
        disabled: this.props.disabled,
        required: this.props.required,
        pattern: this.props.pattern,
        placeholder: this.props.placeholder,
        readOnly: this.props.readOnly,
        name: this.props.name,
        autoFocus: this.props.autoFocus,
        onKeyDown: this.onInputKeyDown,
        onKeyPress: this.onInputKeyPress,
        onInput: this.onInput,
        onClick: this.onInputClick,
        onBlur: this.onInputBlur,
        onFocus: this.onInputFocus,
        onPaste: this.onPaste,
        min: this.props.min,
        max: this.props.max,
        "aria-valuemin": this.props.min,
        "aria-valuemax": this.props.max,
        "aria-valuenow": this.props.value,
        "aria-labelledby": this.props.ariaLabelledBy
      });
    }
  }, {
    key: "renderUpButton",
    value: function renderUpButton() {
      var className = classNames('p-inputnumber-button p-inputnumber-button-up p-button p-button-icon-only p-component', {
        'p-disabled': this.props.disabled
      }, this.props.incrementButtonClassName);
      var icon = classNames('p-button-icon', this.props.incrementButtonIcon);
      return /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: className,
        onMouseLeave: this.onUpButtonMouseLeave,
        onMouseDown: this.onUpButtonMouseDown,
        onMouseUp: this.onUpButtonMouseUp,
        onKeyDown: this.onUpButtonKeyDown,
        onKeyUp: this.onUpButtonKeyUp,
        disabled: this.props.disabled,
        tabIndex: -1
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: icon
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderDownButton",
    value: function renderDownButton() {
      var className = classNames('p-inputnumber-button p-inputnumber-button-down p-button p-button-icon-only p-component', {
        'p-disabled': this.props.disabled
      }, this.props.decrementButtonClassName);
      var icon = classNames('p-button-icon', this.props.decrementButtonIcon);
      return /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: className,
        onMouseLeave: this.onDownButtonMouseLeave,
        onMouseDown: this.onDownButtonMouseDown,
        onMouseUp: this.onDownButtonMouseUp,
        onKeyDown: this.onDownButtonKeyDown,
        onKeyUp: this.onDownButtonKeyUp,
        disabled: this.props.disabled,
        tabIndex: -1
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: icon
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderButtonGroup",
    value: function renderButtonGroup() {
      var upButton = this.props.showButtons && this.renderUpButton();
      var downButton = this.props.showButtons && this.renderDownButton();

      if (this.isStacked()) {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-inputnumber-button-group"
        }, upButton, downButton);
      }

      return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, upButton, downButton);
    }
  }, {
    key: "render",
    value: function render() {
      var _this6 = this;

      var className = classNames('p-inputnumber p-component p-inputwrapper', this.props.className, {
        'p-inputwrapper-filled': this.props.value != null && this.props.value.toString().length > 0,
        'p-inputwrapper-focus': this.state.focused,
        'p-inputnumber-buttons-stacked': this.isStacked(),
        'p-inputnumber-buttons-horizontal': this.isHorizontal(),
        'p-inputnumber-buttons-vertical': this.isVertical()
      });
      var inputElement = this.renderInputElement();
      var buttonGroup = this.renderButtonGroup();
      return /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          return _this6.element = el;
        },
        id: this.props.id,
        className: className,
        style: this.props.style
      }, inputElement, buttonGroup);
    }
  }]);

  return InputNumber;
}(React.Component);

_defineProperty(InputNumber, "defaultProps", {
  value: null,
  inputRef: null,
  format: true,
  showButtons: false,
  buttonLayout: 'stacked',
  incrementButtonClassName: null,
  decrementButtonClassName: null,
  incrementButtonIcon: 'pi pi-angle-up',
  decrementButtonIcon: 'pi pi-angle-down',
  locale: undefined,
  localeMatcher: undefined,
  mode: 'decimal',
  suffix: null,
  prefix: null,
  currency: undefined,
  currencyDisplay: undefined,
  useGrouping: true,
  minFractionDigits: undefined,
  maxFractionDigits: undefined,
  id: null,
  name: null,
  type: 'text',
  allowEmpty: true,
  step: 1,
  min: null,
  max: null,
  disabled: false,
  required: false,
  tabIndex: null,
  pattern: null,
  inputMode: null,
  placeholder: null,
  readOnly: false,
  size: null,
  style: null,
  className: null,
  inputId: null,
  autoFocus: false,
  inputStyle: null,
  inputClassName: null,
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  onValueChange: null,
  onChange: null,
  onBlur: null,
  onFocus: null,
  onKeyDown: null
});

function _createSuper$1E(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1E(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1E() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var JumpToPageInput = /*#__PURE__*/function (_Component) {
  _inherits(JumpToPageInput, _Component);

  var _super = _createSuper$1E(JumpToPageInput);

  function JumpToPageInput(props) {
    var _this;

    _classCallCheck(this, JumpToPageInput);

    _this = _super.call(this, props);
    _this.onChange = _this.onChange.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(JumpToPageInput, [{
    key: "onChange",
    value: function onChange(event) {
      if (this.props.onChange) {
        this.props.onChange(this.props.rows * (event.value - 1), this.props.rows);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var value = this.props.pageCount > 0 ? this.props.page + 1 : 0;
      var element = /*#__PURE__*/React__default['default'].createElement(InputNumber, {
        value: value,
        onChange: this.onChange,
        className: "p-paginator-page-input",
        disabled: this.props.disabled
      });

      if (this.props.template) {
        var defaultOptions = {
          value: value,
          onChange: this.onChange,
          disabled: this.props.disabled,
          className: 'p-paginator-page-input',
          element: element,
          props: this.props
        };
        return ObjectUtils.getJSXElement(this.props.template, defaultOptions);
      }

      return element;
    }
  }]);

  return JumpToPageInput;
}(React.Component);

_defineProperty(JumpToPageInput, "defaultProps", {
  page: null,
  rows: null,
  pageCount: null,
  disabled: false,
  template: null,
  onChange: null
});

function _createSuper$1D(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1D(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1D() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Paginator = /*#__PURE__*/function (_Component) {
  _inherits(Paginator, _Component);

  var _super = _createSuper$1D(Paginator);

  function Paginator(props) {
    var _this;

    _classCallCheck(this, Paginator);

    _this = _super.call(this, props);
    _this.changePageToFirst = _this.changePageToFirst.bind(_assertThisInitialized(_this));
    _this.changePageToPrev = _this.changePageToPrev.bind(_assertThisInitialized(_this));
    _this.changePageToNext = _this.changePageToNext.bind(_assertThisInitialized(_this));
    _this.changePageToLast = _this.changePageToLast.bind(_assertThisInitialized(_this));
    _this.onRowsChange = _this.onRowsChange.bind(_assertThisInitialized(_this));
    _this.changePage = _this.changePage.bind(_assertThisInitialized(_this));
    _this.onPageLinkClick = _this.onPageLinkClick.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Paginator, [{
    key: "isFirstPage",
    value: function isFirstPage() {
      return this.getPage() === 0;
    }
  }, {
    key: "isLastPage",
    value: function isLastPage() {
      return this.getPage() === this.getPageCount() - 1;
    }
  }, {
    key: "getPageCount",
    value: function getPageCount() {
      return Math.ceil(this.props.totalRecords / this.props.rows);
    }
  }, {
    key: "calculatePageLinkBoundaries",
    value: function calculatePageLinkBoundaries() {
      var numberOfPages = this.getPageCount();
      var visiblePages = Math.min(this.props.pageLinkSize, numberOfPages); //calculate range, keep current in middle if necessary

      var start = Math.max(0, Math.ceil(this.getPage() - visiblePages / 2));
      var end = Math.min(numberOfPages - 1, start + visiblePages - 1); //check when approaching to last page

      var delta = this.props.pageLinkSize - (end - start + 1);
      start = Math.max(0, start - delta);
      return [start, end];
    }
  }, {
    key: "updatePageLinks",
    value: function updatePageLinks() {
      var pageLinks = [];
      var boundaries = this.calculatePageLinkBoundaries();
      var start = boundaries[0];
      var end = boundaries[1];

      for (var i = start; i <= end; i++) {
        pageLinks.push(i + 1);
      }

      return pageLinks;
    }
  }, {
    key: "changePage",
    value: function changePage(first, rows) {
      var pc = this.getPageCount();
      var p = Math.floor(first / rows);

      if (p >= 0 && p < pc) {
        var newPageState = {
          first: first,
          rows: rows,
          page: p,
          pageCount: pc
        };

        if (this.props.onPageChange) {
          this.props.onPageChange(newPageState);
        }
      }
    }
  }, {
    key: "getPage",
    value: function getPage() {
      return Math.floor(this.props.first / this.props.rows);
    }
  }, {
    key: "empty",
    value: function empty() {
      var pageCount = this.getPageCount();
      return pageCount === 0;
    }
  }, {
    key: "changePageToFirst",
    value: function changePageToFirst(event) {
      this.changePage(0, this.props.rows);
      event.preventDefault();
    }
  }, {
    key: "changePageToPrev",
    value: function changePageToPrev(event) {
      this.changePage(this.props.first - this.props.rows, this.props.rows);
      event.preventDefault();
    }
  }, {
    key: "onPageLinkClick",
    value: function onPageLinkClick(event) {
      this.changePage((event.value - 1) * this.props.rows, this.props.rows);
    }
  }, {
    key: "changePageToNext",
    value: function changePageToNext(event) {
      this.changePage(this.props.first + this.props.rows, this.props.rows);
      event.preventDefault();
    }
  }, {
    key: "changePageToLast",
    value: function changePageToLast(event) {
      this.changePage((this.getPageCount() - 1) * this.props.rows, this.props.rows);
      event.preventDefault();
    }
  }, {
    key: "onRowsChange",
    value: function onRowsChange(event) {
      var rows = event.value;
      this.isRowChanged = rows !== this.props.rows;
      this.changePage(0, rows);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (this.props.rows !== prevProps.rows && !this.isRowChanged) {
        this.changePage(0, this.props.rows);
      } else if (this.getPage() > 0 && prevProps.totalRecords !== this.props.totalRecords && this.props.first >= this.props.totalRecords) {
        this.changePage((this.getPageCount() - 1) * this.props.rows, this.props.rows);
      }

      this.isRowChanged = false;
    }
  }, {
    key: "renderElement",
    value: function renderElement(key, template) {
      var element;

      switch (key) {
        case 'FirstPageLink':
          element = /*#__PURE__*/React__default['default'].createElement(FirstPageLink, {
            key: key,
            onClick: this.changePageToFirst,
            disabled: this.isFirstPage() || this.empty(),
            template: template
          });
          break;

        case 'PrevPageLink':
          element = /*#__PURE__*/React__default['default'].createElement(PrevPageLink, {
            key: key,
            onClick: this.changePageToPrev,
            disabled: this.isFirstPage() || this.empty(),
            template: template
          });
          break;

        case 'NextPageLink':
          element = /*#__PURE__*/React__default['default'].createElement(NextPageLink, {
            key: key,
            onClick: this.changePageToNext,
            disabled: this.isLastPage() || this.empty(),
            template: template
          });
          break;

        case 'LastPageLink':
          element = /*#__PURE__*/React__default['default'].createElement(LastPageLink, {
            key: key,
            onClick: this.changePageToLast,
            disabled: this.isLastPage() || this.empty(),
            template: template
          });
          break;

        case 'PageLinks':
          element = /*#__PURE__*/React__default['default'].createElement(PageLinks, {
            key: key,
            value: this.updatePageLinks(),
            page: this.getPage(),
            rows: this.props.rows,
            pageCount: this.getPageCount(),
            onClick: this.onPageLinkClick,
            template: template
          });
          break;

        case 'RowsPerPageDropdown':
          element = /*#__PURE__*/React__default['default'].createElement(RowsPerPageDropdown, {
            key: key,
            value: this.props.rows,
            page: this.getPage(),
            pageCount: this.getPageCount(),
            totalRecords: this.props.totalRecords,
            options: this.props.rowsPerPageOptions,
            onChange: this.onRowsChange,
            appendTo: this.props.dropdownAppendTo,
            template: template,
            disabled: this.empty()
          });
          break;

        case 'CurrentPageReport':
          element = /*#__PURE__*/React__default['default'].createElement(CurrentPageReport, {
            reportTemplate: this.props.currentPageReportTemplate,
            key: key,
            page: this.getPage(),
            pageCount: this.getPageCount(),
            first: this.props.first,
            rows: this.props.rows,
            totalRecords: this.props.totalRecords,
            template: template
          });
          break;

        case 'JumpToPageInput':
          element = /*#__PURE__*/React__default['default'].createElement(JumpToPageInput, {
            key: key,
            rows: this.props.rows,
            page: this.getPage(),
            pageCount: this.getPageCount(),
            onChange: this.changePage,
            disabled: this.empty(),
            template: template
          });
          break;

        default:
          element = null;
          break;
      }

      return element;
    }
  }, {
    key: "renderElements",
    value: function renderElements() {
      var _this2 = this;

      var template = this.props.template;

      if (template) {
        if (_typeof(template) === 'object') {
          return template.layout ? template.layout.split(' ').map(function (value) {
            var key = value.trim();
            return _this2.renderElement(key, template[key]);
          }) : Object.entries(template).map(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                key = _ref2[0],
                _template = _ref2[1];

            return _this2.renderElement(key, _template);
          });
        }

        return template.split(' ').map(function (value) {
          return _this2.renderElement(value.trim());
        });
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      if (!this.props.alwaysShow && this.getPageCount() === 1) {
        return null;
      } else {
        var className = classNames('p-paginator p-component', this.props.className);
        var leftContent = ObjectUtils.getJSXElement(this.props.leftContent, this.props);
        var rightContent = ObjectUtils.getJSXElement(this.props.rightContent, this.props);
        var elements = this.renderElements();
        var leftElement = leftContent && /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-paginator-left-content"
        }, leftContent);
        var rightElement = rightContent && /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-paginator-right-content"
        }, rightContent);
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: className,
          style: this.props.style
        }, leftElement, elements, rightElement);
      }
    }
  }]);

  return Paginator;
}(React.Component);

_defineProperty(Paginator, "defaultProps", {
  totalRecords: 0,
  rows: 0,
  first: 0,
  pageLinkSize: 5,
  rowsPerPageOptions: null,
  alwaysShow: true,
  style: null,
  className: null,
  template: 'FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown',
  onPageChange: null,
  leftContent: null,
  rightContent: null,
  dropdownAppendTo: null,
  currentPageReportTemplate: '({currentPage} of {totalPages})'
});

function _createSuper$1C(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1C(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1C() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ScrollableView = /*#__PURE__*/function (_Component) {
  _inherits(ScrollableView, _Component);

  var _super = _createSuper$1C(ScrollableView);

  function ScrollableView(props) {
    var _this;

    _classCallCheck(this, ScrollableView);

    _this = _super.call(this, props);
    _this.onHeaderScroll = _this.onHeaderScroll.bind(_assertThisInitialized(_this));
    _this.onBodyScroll = _this.onBodyScroll.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(ScrollableView, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setScrollHeight();

      if (!this.props.frozen) {
        var scrollBarWidth = DomHandler.calculateScrollbarWidth();
        this.scrollHeaderBox.style.marginRight = scrollBarWidth + 'px';

        if (this.scrollFooterBox) {
          this.scrollFooterBox.style.marginRight = scrollBarWidth + 'px';
        }
      } else {
        this.scrollBody.style.paddingBottom = DomHandler.calculateScrollbarWidth() + 'px';
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState, snapshot) {
      if (this.props.scrollHeight !== prevProps.scrollHeight) {
        this.setScrollHeight();
      }

      if (!this.props.frozen && this.props.virtualScroll) {
        this.virtualScroller.style.height = this.props.totalRecords * this.props.virtualRowHeight + 'px';
      }

      if (this.virtualScrollCallback && !this.props.loading) {
        this.virtualScrollCallback();
        this.virtualScrollCallback = null;
      }
    }
  }, {
    key: "setScrollHeight",
    value: function setScrollHeight() {
      if (this.props.scrollHeight) {
        var frozenView = this.container.previousElementSibling;

        if (frozenView) {
          var frozenScrollBody = DomHandler.findSingle(frozenView, '.p-datatable-scrollable-body');
          this.scrollBody.style.maxHeight = frozenScrollBody.style.maxHeight;
        } else {
          if (this.props.scrollHeight.indexOf('%') !== -1) {
            var datatableContainer = this.findDataTableContainer(this.container);
            this.scrollBody.style.visibility = 'hidden';
            this.scrollBody.style.height = '100px'; //temporary height to calculate static height

            var containerHeight = DomHandler.getOuterHeight(datatableContainer);
            var relativeHeight = DomHandler.getOuterHeight(datatableContainer.parentElement) * parseInt(this.props.scrollHeight, 10) / 100;
            var staticHeight = containerHeight - 100; //total height of headers, footers, paginators

            var scrollBodyHeight = relativeHeight - staticHeight;

            if (this.props.frozen) {
              scrollBodyHeight -= DomHandler.calculateScrollbarWidth();
            }

            this.scrollBody.style.height = 'auto';
            this.scrollBody.style.maxHeight = scrollBodyHeight + 'px';
            this.scrollBody.style.visibility = 'visible';
          } else {
            this.scrollBody.style.maxHeight = this.props.scrollHeight;
          }
        }
      }
    }
  }, {
    key: "findDataTableContainer",
    value: function findDataTableContainer(element) {
      if (element) {
        var el = element;

        while (el && !DomHandler.hasClass(el, 'p-datatable')) {
          el = el.parentElement;
        }

        return el;
      } else {
        return null;
      }
    }
  }, {
    key: "onHeaderScroll",
    value: function onHeaderScroll() {
      this.scrollHeader.scrollLeft = 0;
    }
  }, {
    key: "onBodyScroll",
    value: function onBodyScroll() {
      var _this2 = this;

      var frozenView = this.container.previousElementSibling;
      var frozenScrollBody;

      if (frozenView) {
        frozenScrollBody = DomHandler.findSingle(frozenView, '.p-datatable-scrollable-body');
      }

      this.scrollHeaderBox.style.marginLeft = -1 * this.scrollBody.scrollLeft + 'px';

      if (this.scrollFooterBox) {
        this.scrollFooterBox.style.marginLeft = -1 * this.scrollBody.scrollLeft + 'px';
      }

      if (frozenScrollBody) {
        frozenScrollBody.scrollTop = this.scrollBody.scrollTop;
      }

      if (this.props.virtualScroll) {
        var viewport = DomHandler.getClientHeight(this.scrollBody);
        var tableHeight = DomHandler.getOuterHeight(this.scrollTable);
        var pageHeight = this.props.virtualRowHeight * this.props.rows;
        var virtualTableHeight = DomHandler.getOuterHeight(this.virtualScroller);
        var pageCount = virtualTableHeight / pageHeight || 1;
        var scrollBodyTop = this.scrollTable.style.top || '0';

        if (this.scrollBody.scrollTop + viewport > parseFloat(scrollBodyTop) + tableHeight || this.scrollBody.scrollTop < parseFloat(scrollBodyTop)) {
          if (this.loadingTable) {
            this.loadingTable.style.display = 'table';
            this.loadingTable.style.top = this.scrollBody.scrollTop + 'px';
          }

          var page = Math.floor(this.scrollBody.scrollTop * pageCount / this.scrollBody.scrollHeight) + 1;

          if (this.props.onVirtualScroll) {
            this.props.onVirtualScroll({
              page: page
            });

            this.virtualScrollCallback = function () {
              if (_this2.loadingTable) {
                _this2.loadingTable.style.display = 'none';
              }

              _this2.scrollTable.style.top = (page - 1) * pageHeight + 'px';
            };
          }
        }
      }
    }
  }, {
    key: "renderColGroup",
    value: function renderColGroup() {
      if (this.props.columns && this.props.columns.length) {
        return /*#__PURE__*/React__default['default'].createElement("colgroup", {
          className: "p-datatable-scrollable-colgroup"
        }, this.props.columns.map(function (col, i) {
          return /*#__PURE__*/React__default['default'].createElement("col", {
            key: col.props.field + '_' + i,
            style: col.props.headerStyle || col.props.style,
            className: col.props.headerClassName || col.props.className
          });
        }));
      } else {
        return null;
      }
    }
  }, {
    key: "renderLoadingTable",
    value: function renderLoadingTable(colGroup) {
      var _this3 = this;

      if (this.props.virtualScroll) {
        return /*#__PURE__*/React__default['default'].createElement("table", {
          ref: function ref(el) {
            return _this3.loadingTable = el;
          },
          style: {
            top: '0',
            display: 'none'
          },
          className: "p-datatable-scrollable-body-table p-datatable-loading-virtual-table p-datatable-virtual-table"
        }, colGroup, this.props.loadingBody);
      } else {
        return null;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var className = classNames('p-datatable-scrollable-view', {
        'p-datatable-frozen-view': this.props.frozen,
        'p-datatable-unfrozen-view': !this.props.frozen && this.props.frozenWidth
      });
      var tableBodyClassName = classNames('p-datatable-scrollable-body-table', this.props.tableClassName, {
        'p-datatable-virtual-table': this.props.virtualScroll
      });
      var tableHeaderClassName = classNames('p-datatable-scrollable-header-table', this.props.tableClassName);
      var tableFooterClassName = classNames('p-datatable-scrollable-footer-table', this.props.tableClassName);
      var tableBodyStyle = Object.assign({
        top: '0'
      }, this.props.tableStyle);
      var width = this.props.columns ? this.props.frozen ? this.props.frozenWidth : 'calc(100% - ' + this.props.frozenWidth + ')' : 0;
      var left = this.props.frozen ? null : this.props.frozenWidth;
      var colGroup = this.renderColGroup();
      var loadingTable = this.renderLoadingTable(colGroup);
      var scrollableBodyStyle = !this.props.frozen && this.props.scrollHeight ? {
        overflowY: 'scroll'
      } : null;
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: className,
        style: {
          width: width,
          left: left
        },
        ref: function ref(el) {
          _this4.container = el;
        }
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-scrollable-header",
        ref: function ref(el) {
          _this4.scrollHeader = el;
        },
        onScroll: this.onHeaderScroll
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-scrollable-header-box",
        ref: function ref(el) {
          _this4.scrollHeaderBox = el;
        }
      }, /*#__PURE__*/React__default['default'].createElement("table", {
        className: tableHeaderClassName,
        style: this.props.tableStyle
      }, colGroup, this.props.header, this.props.frozenBody))), /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-scrollable-body",
        ref: function ref(el) {
          _this4.scrollBody = el;
        },
        style: scrollableBodyStyle,
        onScroll: this.onBodyScroll
      }, /*#__PURE__*/React__default['default'].createElement("table", {
        ref: function ref(el) {
          return _this4.scrollTable = el;
        },
        style: tableBodyStyle,
        className: tableBodyClassName
      }, colGroup, this.props.body), loadingTable, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-virtual-scroller",
        ref: function ref(el) {
          _this4.virtualScroller = el;
        }
      })), /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-scrollable-footer",
        ref: function ref(el) {
          _this4.scrollFooter = el;
        }
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-scrollable-footer-box",
        ref: function ref(el) {
          _this4.scrollFooterBox = el;
        }
      }, /*#__PURE__*/React__default['default'].createElement("table", {
        className: tableFooterClassName,
        style: this.props.tableStyle
      }, colGroup, this.props.footer))));
    }
  }]);

  return ScrollableView;
}(React.Component);

_defineProperty(ScrollableView, "defaultProps", {
  header: null,
  body: null,
  footer: null,
  columns: null,
  frozen: null,
  frozenWidth: null,
  frozenBody: null,
  virtualScroll: false,
  virtualRowHeight: null,
  rows: null,
  totalRecords: null,
  loading: false,
  tableStyle: null,
  tableClassName: null,
  onVirtualScroll: null
});

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose(source, excluded);
  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

function _createSuper$1B(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1B(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1B() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var RowRadioButton = /*#__PURE__*/function (_Component) {
  _inherits(RowRadioButton, _Component);

  var _super = _createSuper$1B(RowRadioButton);

  function RowRadioButton(props) {
    var _this;

    _classCallCheck(this, RowRadioButton);

    _this = _super.call(this, props);
    _this.state = {
      focused: false
    };
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onChange = _this.onChange.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(RowRadioButton, [{
    key: "onClick",
    value: function onClick(event) {
      if (this.props.onClick) {
        this.props.onClick({
          originalEvent: event,
          data: this.props.rowData
        });
      }

      this.input.focus();
    }
  }, {
    key: "onFocus",
    value: function onFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      this.setState({
        focused: false
      });
    }
  }, {
    key: "onChange",
    value: function onChange(event) {
      this.onClick(event);
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.code === 'Space') {
        this.onClick(event);
        event.preventDefault();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var className = classNames('p-radiobutton-box p-component p-clickable', {
        'p-highlight': this.props.selected,
        'p-focus': this.state.focused
      });
      var name = "".concat(this.props.tableId ? this.props.tableId + '_' : '', "dt_radio");
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-radiobutton p-component"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hidden-accessible"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        name: name,
        ref: function ref(el) {
          return _this2.input = el;
        },
        type: "radio",
        checked: this.props.selected,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        onChange: this.onChange,
        onKeyDown: this.onKeyDown
      })), /*#__PURE__*/React__default['default'].createElement("div", {
        className: className,
        onClick: this.onClick,
        role: "radio",
        "aria-checked": this.props.selected
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-radiobutton-icon p-clickable"
      })));
    }
  }]);

  return RowRadioButton;
}(React.Component);

_defineProperty(RowRadioButton, "defaultProps", {
  rowData: null,
  onClick: null,
  selected: false
});

function _createSuper$1A(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1A(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1A() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var RowCheckbox = /*#__PURE__*/function (_Component) {
  _inherits(RowCheckbox, _Component);

  var _super = _createSuper$1A(RowCheckbox);

  function RowCheckbox(props) {
    var _this;

    _classCallCheck(this, RowCheckbox);

    _this = _super.call(this, props);
    _this.state = {
      focused: false
    };
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(RowCheckbox, [{
    key: "onClick",
    value: function onClick(event) {
      if (!this.props.disabled) {
        this.setState({
          focused: true
        });

        if (this.props.onClick) {
          this.props.onClick({
            originalEvent: event,
            data: this.props.rowData,
            checked: this.props.selected
          });
        }
      }
    }
  }, {
    key: "onFocus",
    value: function onFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      this.setState({
        focused: false
      });
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.code === 'Space') {
        this.onClick(event);
        event.preventDefault();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-checkbox-box p-component p-clickable', {
        'p-highlight': this.props.selected,
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused
      });
      var iconClassName = classNames('p-checkbox-icon p-clickable', {
        'pi pi-check': this.props.selected
      });
      var tabIndex = this.props.disabled ? null : '0';
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-checkbox p-component",
        onClick: this.onClick
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: className,
        role: "checkbox",
        "aria-checked": this.props.selected,
        tabIndex: tabIndex,
        onKeyDown: this.onKeyDown,
        onFocus: this.onFocus,
        onBlur: this.onBlur
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      })));
    }
  }]);

  return RowCheckbox;
}(React.Component);

_defineProperty(RowCheckbox, "defaultProps", {
  rowData: null,
  onClick: null,
  disabled: false
});

function ownKeys$u(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$u(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$u(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$u(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1z(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1z(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1z() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var BodyCell = /*#__PURE__*/function (_Component) {
  _inherits(BodyCell, _Component);

  var _super = _createSuper$1z(BodyCell);

  function BodyCell(props) {
    var _this;

    _classCallCheck(this, BodyCell);

    _this = _super.call(this, props);
    _this.state = {
      editing: _this.props.editing
    };
    _this.onExpanderClick = _this.onExpanderClick.bind(_assertThisInitialized(_this));
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onMouseDown = _this.onMouseDown.bind(_assertThisInitialized(_this));
    _this.onMouseUp = _this.onMouseUp.bind(_assertThisInitialized(_this));
    _this.onEditorFocus = _this.onEditorFocus.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(BodyCell, [{
    key: "onExpanderClick",
    value: function onExpanderClick(event) {
      if (this.props.onRowToggle) {
        this.props.onRowToggle({
          originalEvent: event,
          data: this.props.rowData
        });
      }

      event.preventDefault();
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (this.props.editMode !== 'row') {
        if (event.which === 13 || event.which === 9) {
          // tab || enter
          this.switchCellToViewMode(event, true);
        }

        if (event.which === 27) {
          // escape
          this.switchCellToViewMode(event, false);
        }
      }

      if (this.props.allowCellSelection) {
        var cell = event.currentTarget;

        switch (event.which) {
          //left arrow
          case 37:
            var prevCell = this.findPrevSelectableCell(cell);

            if (prevCell) {
              this.changeTabIndex(cell, prevCell);
              prevCell.focus();
            }

            event.preventDefault();
            break;
          //right arrow

          case 39:
            var nextCell = this.findNextSelectableCell(cell);

            if (nextCell) {
              this.changeTabIndex(cell, nextCell);
              nextCell.focus();
            }

            event.preventDefault();
            break;
          //up arrow

          case 38:
            var prevRow = this.findPrevSelectableRow(cell.parentElement);

            if (prevRow) {
              var upCell = prevRow.children[this.props.index];
              this.changeTabIndex(cell, upCell);
              upCell.focus();
            }

            event.preventDefault();
            break;
          //down arrow

          case 40:
            var nextRow = this.findNextSelectableRow(cell.parentElement);

            if (nextRow) {
              var downCell = nextRow.children[this.props.index];
              this.changeTabIndex(cell, downCell);
              downCell.focus();
            }

            event.preventDefault();
            break;
          //enter or space

          case 13: // @deprecated

          case 32:
            this.onClick(event);
            event.preventDefault();
            break;
        }
      }
    }
  }, {
    key: "onClick",
    value: function onClick(event) {
      var _this2 = this;

      if (this.props.editMode !== 'row' && this.props.editor && !this.state.editing && (this.props.selectOnEdit || !this.props.selectOnEdit && this.props.selected)) {
        this.selfClick = true;

        if (this.props.onBeforeEditorShow) {
          this.props.onBeforeEditorShow({
            originalEvent: event,
            columnProps: this.props
          });
        }

        this.setState({
          editing: true
        }, function () {
          if (_this2.props.onEditorInit) {
            _this2.props.onEditorInit({
              originalEvent: event,
              columnProps: _this2.props
            });
          }

          if (_this2.props.editorValidatorEvent === 'click') {
            _this2.bindDocumentEditListener();

            _this2.overlayEventListener = function (e) {
              if (!_this2.isOutsideClicked(e.target)) {
                _this2.selfClick = true;
              }
            };

            OverlayService.on('overlay-click', _this2.overlayEventListener);
          }

          if (_this2.props.onEditingCellChange) {
            _this2.props.onEditingCellChange({
              rowIndex: _this2.props.rowIndex,
              cellIndex: _this2.props.index,
              editing: true
            });
          }
        });
      }

      if (this.props.allowCellSelection && this.props.onClick) {
        this.props.onClick({
          originalEvent: event,
          value: ObjectUtils.resolveFieldData(this.props.rowData, this.props.field),
          field: this.props.field,
          rowData: this.props.rowData,
          rowIndex: this.props.rowIndex,
          cellIndex: this.props.index,
          selected: this.isSelected()
        });
      }
    }
  }, {
    key: "onBlur",
    value: function onBlur(event) {
      this.selfClick = false;

      if (this.props.editMode !== 'row' && this.state.editing && this.props.editorValidatorEvent === 'blur') {
        this.switchCellToViewMode(event, true);
      }
    }
  }, {
    key: "onMouseDown",
    value: function onMouseDown(event) {
      if (this.props.onMouseDown) {
        this.props.onMouseDown({
          originalEvent: event,
          value: ObjectUtils.resolveFieldData(this.props.rowData, this.props.field),
          field: this.props.field,
          rowData: this.props.rowData,
          rowIndex: this.props.rowIndex,
          cellIndex: this.props.index,
          selected: this.isSelected()
        });
      }
    }
  }, {
    key: "onMouseUp",
    value: function onMouseUp(event) {
      if (this.props.onMouseUp) {
        this.props.onMouseUp({
          originalEvent: event,
          value: ObjectUtils.resolveFieldData(this.props.rowData, this.props.field),
          field: this.props.field,
          rowData: this.props.rowData,
          rowIndex: this.props.rowIndex,
          cellIndex: this.props.index,
          selected: this.isSelected()
        });
      }
    }
  }, {
    key: "onEditorFocus",
    value: function onEditorFocus(event) {
      this.onClick(event);
    }
  }, {
    key: "bindDocumentEditListener",
    value: function bindDocumentEditListener() {
      var _this3 = this;

      if (!this.documentEditListener) {
        this.documentEditListener = function (e) {
          if (!_this3.selfClick && _this3.isOutsideClicked(e.target)) {
            _this3.switchCellToViewMode(e, true);
          }

          _this3.selfClick = false;
        };

        document.addEventListener('click', this.documentEditListener);
      }
    }
  }, {
    key: "isOutsideClicked",
    value: function isOutsideClicked(target) {
      return this.container && !(this.container.isSameNode(target) || this.container.contains(target));
    }
  }, {
    key: "closeCell",
    value: function closeCell(event) {
      var _this4 = this;

      if (this.props.onBeforeEditorHide) {
        this.props.onBeforeEditorHide({
          originalEvent: event,
          columnProps: this.props
        });
      }
      /* When using the 'tab' key, the focus event of the next cell is not called in IE. */


      setTimeout(function () {
        _this4.setState({
          editing: false
        }, function () {
          _this4.unbindDocumentEditListener();

          OverlayService.off('overlay-click', _this4.overlayEventListener);
          _this4.overlayEventListener = null;

          if (_this4.props.onEditingCellChange) {
            _this4.props.onEditingCellChange({
              rowIndex: _this4.props.rowIndex,
              cellIndex: _this4.props.index,
              editing: false
            });
          }
        });
      }, 1);
    }
  }, {
    key: "switchCellToViewMode",
    value: function switchCellToViewMode(event, submit) {
      var params = {
        originalEvent: event,
        columnProps: this.props
      };

      if (!submit && this.props.onEditorCancel) {
        this.props.onEditorCancel(params);
      }

      var valid = true;

      if (this.props.editorValidator) {
        valid = this.props.editorValidator(params);
      }

      if (valid) {
        if (submit && this.props.onEditorSubmit) {
          this.props.onEditorSubmit(params);
        }

        this.closeCell(event);
      }
    }
  }, {
    key: "findNextSelectableCell",
    value: function findNextSelectableCell(cell) {
      var nextCell = cell.nextElementSibling;

      if (nextCell) {
        return DomHandler.hasClass(nextCell, 'p-selectable-cell') ? nextCell : this.findNextSelectableRow(nextCell);
      }

      return null;
    }
  }, {
    key: "findPrevSelectableCell",
    value: function findPrevSelectableCell(cell) {
      var prevCell = cell.previousElementSibling;

      if (prevCell) {
        return DomHandler.hasClass(prevCell, 'p-selectable-cell') ? prevCell : this.findPrevSelectableRow(prevCell);
      }

      return null;
    }
  }, {
    key: "findNextSelectableRow",
    value: function findNextSelectableRow(row) {
      var nextRow = row.nextElementSibling;

      if (nextRow) {
        return DomHandler.hasClass(nextRow, 'p-selectable-row') ? nextRow : this.findNextSelectableRow(nextRow);
      }

      return null;
    }
  }, {
    key: "findPrevSelectableRow",
    value: function findPrevSelectableRow(row) {
      var prevRow = row.previousElementSibling;

      if (prevRow) {
        return DomHandler.hasClass(prevRow, 'p-selectable-row') ? prevRow : this.findPrevSelectableRow(prevRow);
      }

      return null;
    }
  }, {
    key: "changeTabIndex",
    value: function changeTabIndex(currentCell, nextCell) {
      if (currentCell && nextCell) {
        currentCell.tabIndex = -1;
        nextCell.tabIndex = 0;
      }
    }
  }, {
    key: "getTabIndex",
    value: function getTabIndex(cellSelected) {
      return this.props.allowCellSelection ? cellSelected ? 0 : this.props.rowIndex === 0 && this.props.index === 0 ? 0 : -1 : null;
    }
  }, {
    key: "isSelected",
    value: function isSelected() {
      if (this.props.selection) {
        return this.props.selection instanceof Array ? this.findIndexInSelection() > -1 : this.equals(this.props.selection);
      }

      return false;
    }
  }, {
    key: "equals",
    value: function equals(selectedCell) {
      return (selectedCell.rowIndex === this.props.rowIndex || selectedCell.rowData === this.props.rowData) && (selectedCell.field === this.props.field || selectedCell.cellIndex === this.props.index);
    }
  }, {
    key: "findIndexInSelection",
    value: function findIndexInSelection() {
      var _this5 = this;

      return this.props.selection ? this.props.selection.findIndex(function (d) {
        return _this5.equals(d);
      }) : -1;
    }
  }, {
    key: "unbindDocumentEditListener",
    value: function unbindDocumentEditListener() {
      if (this.documentEditListener) {
        document.removeEventListener('click', this.documentEditListener);
        this.documentEditListener = null;
        this.selfClick = false;
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this6 = this;

      if (this.props.editMode !== 'row' && this.container && this.props.editor) {
        clearTimeout(this.tabindexTimeout);
        this.tabindexTimeout = setTimeout(function () {
          if (_this6.state.editing) {
            var focusable = DomHandler.findSingle(_this6.container, 'input');

            if (focusable && document.activeElement !== focusable && !focusable.hasAttribute('data-isCellEditing')) {
              focusable.setAttribute('data-isCellEditing', true);
              focusable.focus();
            }

            _this6.keyHelper.tabIndex = -1;
          } else if (_this6.keyHelper) {
            _this6.keyHelper.setAttribute('tabindex', 0);
          }
        }, 1);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindDocumentEditListener();

      if (this.overlayEventListener) {
        OverlayService.off('overlay-click', this.overlayEventListener);
        this.overlayEventListener = null;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this7 = this;

      var content, editorKeyHelper;
      var cellSelected = this.props.allowCellSelection && this.isSelected();
      var cellClassName = null;

      if (this.props.cellClassName) {
        var cellData = ObjectUtils.resolveFieldData(this.props.rowData, this.props.field);
        cellClassName = this.props.cellClassName(cellData, _objectSpread$u(_objectSpread$u({}, this.props), {
          rowData: this.props.rowData
        }));
      }

      var className = classNames(this.props.bodyClassName || this.props.className, cellClassName, {
        'p-selection-column': this.props.selectionMode,
        'p-selectable-cell': this.props.allowCellSelection,
        'p-highlight': cellSelected,
        'p-editable-column': this.props.editor,
        'p-cell-editing': this.state.editing && this.props.editor
      });
      var tabIndex = this.getTabIndex(cellSelected);

      if (this.props.expander) {
        var iconClassName = classNames('p-row-toggler-icon pi pi-fw p-clickable', {
          'pi-chevron-down': this.props.expanded,
          'pi-chevron-right': !this.props.expanded
        });
        var ariaControls = "".concat(this.props.tableId ? this.props.tableId + '_' : '', "content_").concat(this.props.rowIndex, "_expanded");
        var expanderProps = {
          onClick: this.onExpanderClick,
          className: 'p-row-toggler p-link',
          iconClassName: iconClassName
        };
        content = /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          onClick: expanderProps.onClick,
          className: expanderProps.className,
          "aria-expanded": this.props.expanded,
          "aria-controls": ariaControls
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: expanderProps.iconClassName
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));

        if (this.props.body) {
          expanderProps['element'] = content;
          content = this.props.body(this.props.rowData, _objectSpread$u(_objectSpread$u({}, this.props), {
            expander: expanderProps
          }));
        }
      } else if (this.props.selectionMode) {
        var showSelection = true;

        if (this.props.showSelectionElement) {
          showSelection = this.props.showSelectionElement(this.props.rowData);
        }

        if (showSelection) {
          if (this.props.selectionMode === 'single') content = /*#__PURE__*/React__default['default'].createElement(RowRadioButton, {
            onClick: this.props.onRadioClick,
            rowData: this.props.rowData,
            selected: this.props.selected,
            tableId: this.props.tableId
          });else content = /*#__PURE__*/React__default['default'].createElement(RowCheckbox, {
            onClick: this.props.onCheckboxClick,
            rowData: this.props.rowData,
            selected: this.props.selected
          });
        }
      } else if (this.props.rowReorder) {
        var showReorder = true;

        if (this.props.showRowReorderElement) {
          showReorder = this.props.showRowReorderElement(this.props.rowData);
        }

        if (showReorder) {
          var reorderIcon = classNames('p-datatable-reorderablerow-handle', this.props.rowReorderIcon);
          content = /*#__PURE__*/React__default['default'].createElement("i", {
            className: reorderIcon
          });
        }
      } else if (this.props.rowEditor) {
        var rowEditorProps = {};

        if (this.state.editing) {
          rowEditorProps = {
            editing: true,
            onSaveClick: this.props.onRowEditSave,
            saveClassName: 'p-row-editor-save p-link',
            saveIconClassName: 'p-row-editor-save-icon pi pi-fw pi-check p-clickable',
            onCancelClick: this.props.onRowEditCancel,
            cancelClassName: 'p-row-editor-cancel p-link',
            cancelIconClassName: 'p-row-editor-cancel-icon pi pi-fw pi-times p-clickable'
          };
          content = /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("button", {
            type: "button",
            onClick: rowEditorProps.onSaveClick,
            className: rowEditorProps.saveClassName
          }, /*#__PURE__*/React__default['default'].createElement("span", {
            className: rowEditorProps.saveIconClassName
          }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("button", {
            type: "button",
            onClick: rowEditorProps.onCancelClick,
            className: rowEditorProps.cancelClassName
          }, /*#__PURE__*/React__default['default'].createElement("span", {
            className: rowEditorProps.cancelIconClassName
          }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
        } else {
          rowEditorProps = {
            editing: false,
            onInitClick: this.props.onRowEditInit,
            initClassName: 'p-row-editor-init p-link',
            initIconClassName: 'p-row-editor-init-icon pi pi-fw pi-pencil p-clickable'
          };
          content = /*#__PURE__*/React__default['default'].createElement("button", {
            type: "button",
            onClick: rowEditorProps.onInitClick,
            className: rowEditorProps.initClassName
          }, /*#__PURE__*/React__default['default'].createElement("span", {
            className: rowEditorProps.initIconClassName
          }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
        }

        if (this.props.body) {
          rowEditorProps['element'] = content;
          content = this.props.body(this.props.rowData, _objectSpread$u(_objectSpread$u({}, this.props), {
            rowEditor: rowEditorProps
          }));
        }
      } else {
        if (this.state.editing && this.props.editor) {
          content = this.props.editor(this.props);
        } else {
          if (this.props.body) content = this.props.body(this.props.rowData, this.props);else content = ObjectUtils.resolveFieldData(this.props.rowData, this.props.field);
        }
      }

      if (this.props.editMode !== 'row') {
        /* eslint-disable */
        editorKeyHelper = this.props.editor && /*#__PURE__*/React__default['default'].createElement("a", {
          tabIndex: "0",
          ref: function ref(el) {
            _this7.keyHelper = el;
          },
          className: "p-cell-editor-key-helper p-hidden-accessible",
          onFocus: this.onEditorFocus
        }, /*#__PURE__*/React__default['default'].createElement("span", null));
        /* eslint-enable */
      }

      return /*#__PURE__*/React__default['default'].createElement("td", {
        ref: function ref(el) {
          _this7.container = el;
        },
        role: "cell",
        tabIndex: tabIndex,
        className: className,
        style: this.props.bodyStyle || this.props.style,
        onClick: this.onClick,
        onKeyDown: this.onKeyDown,
        rowSpan: this.props.rowSpan,
        onBlur: this.onBlur,
        onMouseDown: this.onMouseDown,
        onMouseUp: this.onMouseUp
      }, editorKeyHelper, content);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.editMode === 'row' && nextProps.editing !== prevState.editing) {
        return {
          editing: nextProps.editing
        };
      }

      return null;
    }
  }]);

  return BodyCell;
}(React.Component);

function ownKeys$t(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$t(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$t(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$t(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1y(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1y(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1y() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var BodyRow = /*#__PURE__*/function (_Component) {
  _inherits(BodyRow, _Component);

  var _super = _createSuper$1y(BodyRow);

  function BodyRow(props) {
    var _this;

    _classCallCheck(this, BodyRow);

    _this = _super.call(this, props);

    if (!_this.props.isRowEditingControlled) {
      _this.state = {
        editing: false
      };
    }

    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onDoubleClick = _this.onDoubleClick.bind(_assertThisInitialized(_this));
    _this.onTouchEnd = _this.onTouchEnd.bind(_assertThisInitialized(_this));
    _this.onRightClick = _this.onRightClick.bind(_assertThisInitialized(_this));
    _this.onMouseDown = _this.onMouseDown.bind(_assertThisInitialized(_this));
    _this.onMouseUp = _this.onMouseUp.bind(_assertThisInitialized(_this));
    _this.onDragEnd = _this.onDragEnd.bind(_assertThisInitialized(_this));
    _this.onDragOver = _this.onDragOver.bind(_assertThisInitialized(_this));
    _this.onDragLeave = _this.onDragLeave.bind(_assertThisInitialized(_this));
    _this.onDrop = _this.onDrop.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onRowEditInit = _this.onRowEditInit.bind(_assertThisInitialized(_this));
    _this.onRowEditSave = _this.onRowEditSave.bind(_assertThisInitialized(_this));
    _this.onRowEditCancel = _this.onRowEditCancel.bind(_assertThisInitialized(_this));
    _this.updateEditingState = _this.updateEditingState.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(BodyRow, [{
    key: "getEditing",
    value: function getEditing() {
      return this.props.isRowEditingControlled ? this.props.editing : this.state.editing;
    }
  }, {
    key: "onClick",
    value: function onClick(event) {
      if (this.props.onClick) {
        this.props.onClick({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }
    }
  }, {
    key: "onDoubleClick",
    value: function onDoubleClick(event) {
      if (this.props.onDoubleClick) {
        this.props.onDoubleClick({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }
    }
  }, {
    key: "onTouchEnd",
    value: function onTouchEnd(event) {
      if (this.props.onTouchEnd) {
        this.props.onTouchEnd(event);
      }
    }
  }, {
    key: "onRightClick",
    value: function onRightClick(event) {
      if (this.props.onRightClick) {
        this.props.onRightClick({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }
    }
  }, {
    key: "onMouseDown",
    value: function onMouseDown(event) {
      if (DomHandler.hasClass(event.target, 'p-datatable-reorderablerow-handle')) event.currentTarget.draggable = true;else event.currentTarget.draggable = false;

      if (this.props.onMouseDown) {
        this.props.onMouseDown({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }
    }
  }, {
    key: "onMouseUp",
    value: function onMouseUp(event) {
      if (this.props.onMouseUp) {
        this.props.onMouseUp({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }
    }
  }, {
    key: "onDragEnd",
    value: function onDragEnd(event) {
      if (this.props.onDragEnd) {
        this.props.onDragEnd(event);
      }

      event.currentTarget.draggable = false;
    }
  }, {
    key: "onDragOver",
    value: function onDragOver(event) {
      if (this.props.onDragOver) {
        this.props.onDragOver({
          originalEvent: event,
          rowElement: this.container
        });
      }

      event.preventDefault();
    }
  }, {
    key: "onDragLeave",
    value: function onDragLeave(event) {
      if (this.props.onDragLeave) {
        this.props.onDragLeave({
          originalEvent: event,
          rowElement: this.container
        });
      }
    }
  }, {
    key: "onDrop",
    value: function onDrop(event) {
      if (this.props.onDrop) {
        this.props.onDrop({
          originalEvent: event,
          rowElement: this.container
        });
      }

      event.preventDefault();
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (this.isFocusable() && !this.props.allowCellSelection) {
        var target = event.target,
            row = event.currentTarget;

        switch (event.which) {
          //down arrow
          case 40:
            var nextRow = this.findNextSelectableRow(row);

            if (nextRow) {
              this.changeTabIndex(row, nextRow);
              nextRow.focus();
            }

            event.preventDefault();
            break;
          //up arrow

          case 38:
            var prevRow = this.findPrevSelectableRow(row);

            if (prevRow) {
              this.changeTabIndex(row, prevRow);
              prevRow.focus();
            }

            event.preventDefault();
            break;
          //enter

          case 13:
            // @deprecated
            this.onClick(event);
            event.preventDefault();
            break;
          //space

          case 32:
            if (target.nodeName !== 'INPUT' && target.nodeName !== 'TEXTAREA' && !target.readOnly) {
              this.onClick(event);
              event.preventDefault();
            }

            break;
        }
      }
    }
  }, {
    key: "changeTabIndex",
    value: function changeTabIndex(currentRow, nextRow) {
      if (currentRow && nextRow) {
        currentRow.tabIndex = -1;
        nextRow.tabIndex = 0;
      }
    }
  }, {
    key: "findNextSelectableRow",
    value: function findNextSelectableRow(row) {
      var nextRow = row.nextElementSibling;

      if (nextRow) {
        if (DomHandler.hasClass(nextRow, 'p-selectable-row')) return nextRow;else return this.findNextSelectableRow(nextRow);
      } else {
        return null;
      }
    }
  }, {
    key: "findPrevSelectableRow",
    value: function findPrevSelectableRow(row) {
      var prevRow = row.previousElementSibling;

      if (prevRow) {
        if (DomHandler.hasClass(prevRow, 'p-selectable-row')) return prevRow;else return this.findPrevSelectableRow(prevRow);
      } else {
        return null;
      }
    }
  }, {
    key: "updateEditingState",
    value: function updateEditingState(event, editing) {
      if (this.props.isRowEditingControlled) {
        this.props.onRowEditingToggle({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      } else {
        this.setState({
          editing: editing
        });
      }
    }
  }, {
    key: "onRowEditInit",
    value: function onRowEditInit(event) {
      if (this.props.onRowEditInit) {
        this.props.onRowEditInit({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }

      this.updateEditingState(event, true);
      event.preventDefault();
    }
  }, {
    key: "onRowEditSave",
    value: function onRowEditSave(event) {
      var valid = true;

      if (this.props.rowEditorValidator) {
        valid = this.props.rowEditorValidator(this.props.rowData);
      }

      if (this.props.onRowEditSave) {
        this.props.onRowEditSave({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex,
          valid: valid
        });
      }

      if (valid) {
        this.updateEditingState(event, false);
      }

      event.preventDefault();
    }
  }, {
    key: "onRowEditCancel",
    value: function onRowEditCancel(event) {
      if (this.props.onRowEditCancel) {
        this.props.onRowEditCancel({
          originalEvent: event,
          data: this.props.rowData,
          index: this.props.rowIndex
        });
      }

      this.updateEditingState(event, false);
      event.preventDefault();
    }
  }, {
    key: "isFocusable",
    value: function isFocusable() {
      return this.props.selectionMode && this.props.selectionModeInColumn !== 'single' && this.props.selectionModeInColumn !== 'multiple';
    }
  }, {
    key: "getTabIndex",
    value: function getTabIndex() {
      return this.isFocusable() && !this.props.allowCellSelection ? this.props.rowIndex === 0 ? 0 : -1 : null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var columns = React__default['default'].Children.toArray(this.props.children);
      var conditionalClassNames = {
        'p-highlight': !this.props.allowCellSelection && this.props.selected,
        'p-highlight-contextmenu': this.props.contextMenuSelected,
        'p-selectable-row': this.props.allowRowSelection,
        'p-row-odd': this.props.rowIndex % 2 !== 0
      };

      if (this.props.rowClassName) {
        var rowClassNameCondition = this.props.rowClassName(this.props.rowData);
        conditionalClassNames = _objectSpread$t(_objectSpread$t({}, conditionalClassNames), rowClassNameCondition);
      }

      var className = classNames(conditionalClassNames);
      var style = this.props.virtualScroll ? {
        height: this.props.virtualRowHeight
      } : {};
      var hasRowSpanGrouping = this.props.rowGroupMode === 'rowspan';
      var tabIndex = this.getTabIndex();
      var cells = [];

      for (var i = 0; i < columns.length; i++) {
        var column = columns[i];
        var rowSpan = void 0;

        if (hasRowSpanGrouping) {
          if (this.props.sortField === column.props.field) {
            if (this.props.groupRowSpan) {
              rowSpan = this.props.groupRowSpan;
              className += ' p-datatable-rowspan-group';
            } else {
              continue;
            }
          }
        }

        var editing = this.getEditing();
        var cell = /*#__PURE__*/React__default['default'].createElement(BodyCell, _extends({
          tableId: this.props.tableId,
          key: i
        }, column.props, {
          value: this.props.value,
          rowSpan: rowSpan,
          rowData: this.props.rowData,
          index: i,
          rowIndex: this.props.rowIndex,
          onRowToggle: this.props.onRowToggle,
          expanded: this.props.expanded,
          onRadioClick: this.props.onRadioClick,
          onCheckboxClick: this.props.onCheckboxClick,
          selected: this.props.selected,
          selection: this.props.selection,
          selectOnEdit: this.props.selectOnEdit,
          editMode: this.props.editMode,
          editing: editing,
          onRowEditInit: this.onRowEditInit,
          onRowEditSave: this.onRowEditSave,
          onRowEditCancel: this.onRowEditCancel,
          onMouseDown: this.props.onCellMouseDown,
          onMouseUp: this.props.onCellMouseUp,
          showRowReorderElement: this.props.showRowReorderElement,
          showSelectionElement: this.props.showSelectionElement,
          allowCellSelection: this.props.allowCellSelection,
          onClick: this.props.onCellClick,
          onEditingCellChange: this.props.onEditingCellChange,
          cellClassName: this.props.cellClassName
        }));
        cells.push(cell);
      }

      return /*#__PURE__*/React__default['default'].createElement("tr", {
        role: "row",
        tabIndex: tabIndex,
        ref: function ref(el) {
          _this2.container = el;
        },
        className: className,
        onClick: this.onClick,
        onDoubleClick: this.onDoubleClick,
        onTouchEnd: this.onTouchEnd,
        onContextMenu: this.onRightClick,
        onMouseDown: this.onMouseDown,
        onMouseUp: this.onMouseUp,
        onDragStart: this.props.onDragStart,
        onDragEnd: this.onDragEnd,
        onDragOver: this.onDragOver,
        onDragLeave: this.onDragLeave,
        onDrop: this.onDrop,
        style: style,
        onKeyDown: this.onKeyDown
      }, cells);
    }
  }]);

  return BodyRow;
}(React.Component);

function _createSuper$1x(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1x(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1x() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var RowTogglerButton = /*#__PURE__*/function (_Component) {
  _inherits(RowTogglerButton, _Component);

  var _super = _createSuper$1x(RowTogglerButton);

  function RowTogglerButton(props) {
    var _this;

    _classCallCheck(this, RowTogglerButton);

    _this = _super.call(this, props);
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(RowTogglerButton, [{
    key: "onClick",
    value: function onClick(event) {
      if (this.props.onClick) {
        this.props.onClick({
          originalEvent: event,
          data: this.props.rowData
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var iconClassName = classNames('p-row-toggler-icon pi pi-fw p-clickable', {
        'pi-chevron-down': this.props.expanded,
        'pi-chevron-right': !this.props.expanded
      });
      return /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        onClick: this.onClick,
        className: "p-row-toggler p-link"
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }]);

  return RowTogglerButton;
}(React.Component);

_defineProperty(RowTogglerButton, "defaultProps", {
  rowData: null,
  onClick: null,
  expanded: false
});

var _excluded = ["originalEvent"];

function ownKeys$s(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$s(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$s(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$s(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1w(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1w(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1w() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var TableBody = /*#__PURE__*/function (_Component) {
  _inherits(TableBody, _Component);

  var _super = _createSuper$1w(TableBody);

  function TableBody(props) {
    var _this;

    _classCallCheck(this, TableBody);

    _this = _super.call(this, props);
    _this.onRowClick = _this.onRowClick.bind(_assertThisInitialized(_this));
    _this.onRowRightClick = _this.onRowRightClick.bind(_assertThisInitialized(_this));
    _this.onRowTouchEnd = _this.onRowTouchEnd.bind(_assertThisInitialized(_this));
    _this.onRowToggle = _this.onRowToggle.bind(_assertThisInitialized(_this));
    _this.onRowEditingToggle = _this.onRowEditingToggle.bind(_assertThisInitialized(_this));
    _this.onRadioClick = _this.onRadioClick.bind(_assertThisInitialized(_this));
    _this.onCheckboxClick = _this.onCheckboxClick.bind(_assertThisInitialized(_this));
    _this.onDragSelectionMouseMove = _this.onDragSelectionMouseMove.bind(_assertThisInitialized(_this));
    _this.onDragSelectionMouseUp = _this.onDragSelectionMouseUp.bind(_assertThisInitialized(_this));
    _this.onRowDragEnd = _this.onRowDragEnd.bind(_assertThisInitialized(_this));
    _this.onRowDragLeave = _this.onRowDragLeave.bind(_assertThisInitialized(_this));
    _this.onRowDrop = _this.onRowDrop.bind(_assertThisInitialized(_this));
    _this.onRowMouseDown = _this.onRowMouseDown.bind(_assertThisInitialized(_this));
    _this.onRowMouseUp = _this.onRowMouseUp.bind(_assertThisInitialized(_this));
    _this.onCellClick = _this.onCellClick.bind(_assertThisInitialized(_this));
    _this.onCellMouseDown = _this.onCellMouseDown.bind(_assertThisInitialized(_this));
    _this.onCellMouseUp = _this.onCellMouseUp.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(TableBody, [{
    key: "onRowClick",
    value: function onRowClick(event) {
      if (this.allowCellSelection() || !this.allowSelection(event)) {
        return;
      }

      this.props.onRowClick && this.props.onRowClick(event);

      if (this.allowRowSelection()) {
        if (this.allowRangeSelection(event)) {
          this.onRangeSelection(event);
        } else {
          var toggleable = this.isRadioSelectionModeInColumn() || this.isCheckboxSelectionModeInColumn() || this.allowMetaKeySelection(event);
          this.anchorRowIndex = event.index;
          this.rangeRowIndex = event.index;
          this.anchorRowFirst = this.props.first;

          if (this.isSingleSelection()) {
            this.onSingleSelection(_objectSpread$s(_objectSpread$s({}, event), {}, {
              toggleable: toggleable,
              type: 'row'
            }));
          } else {
            this.onMultipleSelection(_objectSpread$s(_objectSpread$s({}, event), {}, {
              toggleable: toggleable,
              type: 'row'
            }));
          }
        }
      } else {
        this.focusOnElement(event.originalEvent);
      }

      this.rowTouched = false;
    }
  }, {
    key: "onCellClick",
    value: function onCellClick(event) {
      if (!this.allowSelection(event)) {
        return;
      }

      this.props.onCellClick && this.props.onCellClick(event);

      if (this.allowCellSelection()) {
        if (this.allowRangeSelection(event)) {
          this.onRangeSelection(event);
        } else {
          var toggleable = this.allowMetaKeySelection(event);

          var originalEvent = event.originalEvent,
              data = _objectWithoutProperties(event, _excluded);

          this.anchorRowIndex = event.rowIndex;
          this.rangeRowIndex = event.rowIndex;
          this.anchorRowFirst = this.props.first;
          this.anchorCellIndex = event.cellIndex;

          if (this.isSingleSelection()) {
            this.onSingleSelection({
              originalEvent: originalEvent,
              data: data,
              toggleable: toggleable,
              type: 'cell'
            });
          } else {
            this.onMultipleSelection({
              originalEvent: originalEvent,
              data: data,
              toggleable: toggleable,
              type: 'cell'
            });
          }
        }
      }

      this.rowTouched = false;
    }
  }, {
    key: "onSingleSelection",
    value: function onSingleSelection(_ref) {
      var originalEvent = _ref.originalEvent,
          data = _ref.data,
          toggleable = _ref.toggleable,
          type = _ref.type;
      var selected = this.isSelected(data);
      var selection = this.props.selection;

      if (selected) {
        if (toggleable) {
          selection = null;
          this.onUnselect({
            originalEvent: originalEvent,
            data: data,
            type: type
          });
        }
      } else {
        selection = data;
        this.onSelect({
          originalEvent: originalEvent,
          data: data,
          type: type
        });
      }

      this.focusOnElement(originalEvent, true);

      if (this.props.onSelectionChange && selection !== this.props.selection) {
        this.props.onSelectionChange({
          originalEvent: originalEvent,
          value: selection
        });
      }
    }
  }, {
    key: "onMultipleSelection",
    value: function onMultipleSelection(_ref2) {
      var _this2 = this;

      var originalEvent = _ref2.originalEvent,
          data = _ref2.data,
          toggleable = _ref2.toggleable,
          type = _ref2.type;
      var selected = this.isSelected(data);
      var selection = this.props.selection || [];

      if (selected) {
        if (toggleable) {
          var selectionIndex = this.findIndexInSelection(data);
          selection = this.props.selection.filter(function (val, i) {
            return i !== selectionIndex;
          });
          this.onUnselect({
            originalEvent: originalEvent,
            data: data,
            type: type
          });
        } else if (selection.length) {
          this.props.selection.forEach(function (d) {
            return _this2.onUnselect({
              originalEvent: originalEvent,
              data: d,
              type: type
            });
          });
          selection = [data];
          this.onSelect({
            originalEvent: originalEvent,
            data: data,
            type: type
          });
        }
      } else {
        selection = toggleable && this.isMultipleSelection() ? [].concat(_toConsumableArray(selection), [data]) : [data];
        this.onSelect({
          originalEvent: originalEvent,
          data: data,
          type: type
        });
      }

      this.focusOnElement(originalEvent, true);

      if (this.props.onSelectionChange && selection !== this.props.selection) {
        this.props.onSelectionChange({
          originalEvent: originalEvent,
          value: selection
        });
      }
    }
  }, {
    key: "onRangeSelection",
    value: function onRangeSelection(event) {
      DomHandler.clearSelection();
      this.rangeRowIndex = this.allowCellSelection() ? event.rowIndex : event.index;
      var selectionInRange = this.selectRange(event);
      var selection = this.isMultipleSelection() ? _toConsumableArray(new Set([].concat(_toConsumableArray(this.props.selection || []), _toConsumableArray(selectionInRange)))) : selectionInRange;

      if (this.props.onSelectionChange && selection !== this.props.selection) {
        this.props.onSelectionChange({
          originalEvent: event.originalEvent,
          value: selection
        });
      }

      this.anchorRowIndex = this.rangeRowIndex;
      this.anchorCellIndex = event.cellIndex;
      this.focusOnElement(event.originalEvent, false);
    }
  }, {
    key: "selectRange",
    value: function selectRange(event) {
      var rangeStart, rangeEnd;
      var isLazyAndPaginator = this.props.lazy && this.props.paginator;

      if (isLazyAndPaginator) {
        this.anchorRowIndex += this.anchorRowFirst;
        this.rangeRowIndex += this.props.first;
      }

      if (this.rangeRowIndex > this.anchorRowIndex) {
        rangeStart = this.anchorRowIndex;
        rangeEnd = this.rangeRowIndex;
      } else if (this.rangeRowIndex < this.anchorRowIndex) {
        rangeStart = this.rangeRowIndex;
        rangeEnd = this.anchorRowIndex;
      } else {
        rangeStart = rangeEnd = this.rangeRowIndex;
      }

      if (isLazyAndPaginator) {
        rangeStart = Math.max(rangeStart - this.props.first, 0);
        rangeEnd -= this.props.first;
      }

      return this.allowCellSelection() ? this.selectRangeOnCell(event, rangeStart, rangeEnd) : this.selectRangeOnRow(event, rangeStart, rangeEnd);
    }
  }, {
    key: "selectRangeOnRow",
    value: function selectRangeOnRow(event, rowRangeStart, rowRangeEnd) {
      var value = this.props.value;
      var selection = [];

      for (var i = rowRangeStart; i <= rowRangeEnd; i++) {
        var rangeRowData = value[i];
        selection.push(rangeRowData);
        this.onSelect({
          originalEvent: event.originalEvent,
          data: rangeRowData,
          type: 'row'
        });
      }

      return selection;
    }
  }, {
    key: "selectRangeOnCell",
    value: function selectRangeOnCell(event, rowRangeStart, rowRangeEnd) {
      var cellRangeStart,
          cellRangeEnd,
          cellIndex = event.cellIndex;

      if (cellIndex > this.anchorCellIndex) {
        cellRangeStart = this.anchorCellIndex;
        cellRangeEnd = cellIndex;
      } else if (cellIndex < this.anchorCellIndex) {
        cellRangeStart = cellIndex;
        cellRangeEnd = this.anchorCellIndex;
      } else {
        cellRangeStart = cellRangeEnd = cellIndex;
      }

      var value = this.props.value;
      var selection = [];

      for (var i = rowRangeStart; i <= rowRangeEnd; i++) {
        var rowData = value[i];
        var columns = React__default['default'].Children.toArray(this.props.children);

        for (var j = cellRangeStart; j <= cellRangeEnd; j++) {
          var field = columns[j].props.field;
          var rangeRowData = {
            value: ObjectUtils.resolveFieldData(rowData, field),
            field: field,
            rowData: rowData,
            rowIndex: i,
            cellIndex: j,
            selected: true
          };
          selection.push(rangeRowData);
          this.onSelect({
            originalEvent: event.originalEvent,
            data: rangeRowData,
            type: 'cell'
          });
        }
      }

      return selection;
    }
  }, {
    key: "onSelect",
    value: function onSelect(event) {
      if (this.allowCellSelection()) this.props.onCellSelect && this.props.onCellSelect(_objectSpread$s(_objectSpread$s({
        originalEvent: event.originalEvent
      }, event.data), {}, {
        type: event.type
      }));else this.props.onRowSelect && this.props.onRowSelect(event);
    }
  }, {
    key: "onUnselect",
    value: function onUnselect(event) {
      if (this.allowCellSelection()) this.props.onCellUnselect && this.props.onCellUnselect(_objectSpread$s(_objectSpread$s({
        originalEvent: event.originalEvent
      }, event.data), {}, {
        type: event.type
      }));else this.props.onRowUnselect && this.props.onRowUnselect(event);
    }
  }, {
    key: "enableDragSelection",
    value: function enableDragSelection(event) {
      if (this.props.dragSelection && !this.dragSelectionHelper) {
        this.dragSelectionHelper = document.createElement('div');
        DomHandler.addClass(this.dragSelectionHelper, 'p-datatable-drag-selection-helper');
        this.initialDragPosition = {
          x: event.clientX,
          y: event.clientY
        };
        this.dragSelectionHelper.style.top = "".concat(event.pageY, "px");
        this.dragSelectionHelper.style.left = "".concat(event.pageX, "px");
        this.bindDragSelectionEvents();
      }
    }
  }, {
    key: "bindDragSelectionEvents",
    value: function bindDragSelectionEvents() {
      document.addEventListener('mousemove', this.onDragSelectionMouseMove);
      document.addEventListener('mouseup', this.onDragSelectionMouseUp);
      document.body.appendChild(this.dragSelectionHelper);
    }
  }, {
    key: "unbindDragSelectionEvents",
    value: function unbindDragSelectionEvents() {
      this.onDragSelectionMouseUp();
    }
  }, {
    key: "onDragSelectionMouseMove",
    value: function onDragSelectionMouseMove(event) {
      var _this$initialDragPosi = this.initialDragPosition,
          x = _this$initialDragPosi.x,
          y = _this$initialDragPosi.y;
      var dx = event.clientX - x;
      var dy = event.clientY - y;
      if (dy < 0) this.dragSelectionHelper.style.top = "".concat(event.pageY + 5, "px");
      if (dx < 0) this.dragSelectionHelper.style.left = "".concat(event.pageX + 5, "px");
      this.dragSelectionHelper.style.height = "".concat(Math.abs(dy), "px");
      this.dragSelectionHelper.style.width = "".concat(Math.abs(dx), "px");
      event.preventDefault();
    }
  }, {
    key: "onDragSelectionMouseUp",
    value: function onDragSelectionMouseUp() {
      if (this.dragSelectionHelper) {
        this.dragSelectionHelper.remove();
        this.dragSelectionHelper = null;
      }

      document.removeEventListener('mousemove', this.onDragSelectionMouseMove);
      document.removeEventListener('mouseup', this.onDragSelectionMouseUp);
    }
  }, {
    key: "onRowMouseDown",
    value: function onRowMouseDown(event) {
      DomHandler.clearSelection();

      if (this.allowRowDrag(event)) {
        this.enableDragSelection(event.originalEvent);
        this.anchorRowIndex = event.index;
        this.rangeRowIndex = event.index;
        this.anchorRowFirst = this.props.first;
      }
    }
  }, {
    key: "onRowMouseUp",
    value: function onRowMouseUp(event) {
      var isSameRow = event.index === this.anchorRowIndex;

      if (this.allowRowDrag(event) && !isSameRow) {
        this.onRangeSelection(event);
      }
    }
  }, {
    key: "onCellMouseDown",
    value: function onCellMouseDown(event) {
      if (this.allowCellDrag(event)) {
        this.enableDragSelection(event.originalEvent);
        this.anchorRowIndex = event.rowIndex;
        this.rangeRowIndex = event.rowIndex;
        this.anchorRowFirst = this.props.first;
        this.anchorCellIndex = event.cellIndex;
      }
    }
  }, {
    key: "onCellMouseUp",
    value: function onCellMouseUp(event) {
      var isSameCell = event.rowIndex === this.anchorRowIndex && event.cellIndex === this.anchorCellIndex;

      if (this.allowCellDrag(event) && !isSameCell) {
        this.onRangeSelection(event);
      }
    }
  }, {
    key: "onRowTouchEnd",
    value: function onRowTouchEnd(event) {
      this.rowTouched = true;
    }
  }, {
    key: "onRowRightClick",
    value: function onRowRightClick(event) {
      if (this.props.onContextMenu) {
        DomHandler.clearSelection();

        if (this.props.onContextMenuSelectionChange) {
          this.props.onContextMenuSelectionChange({
            originalEvent: event.originalEvent,
            value: event.data
          });
        }

        if (this.props.onContextMenu) {
          this.props.onContextMenu({
            originalEvent: event.originalEvent,
            data: event.data
          });
        }

        event.originalEvent.preventDefault();
      }
    }
  }, {
    key: "onRadioClick",
    value: function onRadioClick(event) {
      this.onSingleSelection(_objectSpread$s(_objectSpread$s({}, event), {}, {
        toggleable: true,
        type: 'radio'
      }));
    }
  }, {
    key: "onCheckboxClick",
    value: function onCheckboxClick(event) {
      this.onMultipleSelection(_objectSpread$s(_objectSpread$s({}, event), {}, {
        toggleable: true,
        type: 'checkbox'
      }));
    }
  }, {
    key: "allowDrag",
    value: function allowDrag(event) {
      return this.props.dragSelection && this.isMultipleSelection() && !event.originalEvent.shiftKey;
    }
  }, {
    key: "allowRowDrag",
    value: function allowRowDrag(event) {
      return !this.allowCellSelection() && this.allowDrag(event);
    }
  }, {
    key: "allowCellDrag",
    value: function allowCellDrag(event) {
      return this.allowCellSelection() && this.allowDrag(event);
    }
  }, {
    key: "allowSelection",
    value: function allowSelection(event) {
      var targetNode = event.originalEvent.target.nodeName;

      if (targetNode === 'INPUT' || targetNode === 'BUTTON' || targetNode === 'A' || DomHandler.hasClass(event.originalEvent.target, 'p-clickable')) {
        return false;
      }

      return true;
    }
  }, {
    key: "allowMetaKeySelection",
    value: function allowMetaKeySelection(event) {
      return !this.rowTouched && (!this.props.metaKeySelection || this.props.metaKeySelection && (event.originalEvent.metaKey || event.originalEvent.ctrlKey));
    }
  }, {
    key: "allowRangeSelection",
    value: function allowRangeSelection(event) {
      return this.isMultipleSelection() && event.originalEvent.shiftKey && this.anchorRowIndex !== null;
    }
  }, {
    key: "allowRowSelection",
    value: function allowRowSelection() {
      return (this.props.selectionMode || this.props.selectionModeInColumn) && !this.isRadioOnlySelection() && !this.isCheckboxOnlySelection();
    }
  }, {
    key: "allowCellSelection",
    value: function allowCellSelection() {
      return this.props.cellSelection && !this.isRadioSelectionModeInColumn() && !this.isCheckboxSelectionModeInColumn();
    }
  }, {
    key: "isRadioSelectionMode",
    value: function isRadioSelectionMode() {
      return this.props.selectionMode === 'radiobutton';
    }
  }, {
    key: "isCheckboxSelectionMode",
    value: function isCheckboxSelectionMode() {
      return this.props.selectionMode === 'checkbox';
    }
  }, {
    key: "isRadioSelectionModeInColumn",
    value: function isRadioSelectionModeInColumn() {
      return this.props.selectionModeInColumn === 'single';
    }
  }, {
    key: "isCheckboxSelectionModeInColumn",
    value: function isCheckboxSelectionModeInColumn() {
      return this.props.selectionModeInColumn === 'multiple';
    }
  }, {
    key: "isSingleSelection",
    value: function isSingleSelection() {
      return this.props.selectionMode === 'single' && !this.isCheckboxSelectionModeInColumn() || !this.isRadioSelectionMode() && this.isRadioSelectionModeInColumn();
    }
  }, {
    key: "isMultipleSelection",
    value: function isMultipleSelection() {
      return this.props.selectionMode === 'multiple' && !this.isRadioSelectionModeInColumn() || this.isCheckboxSelectionModeInColumn();
    }
  }, {
    key: "isRadioOnlySelection",
    value: function isRadioOnlySelection() {
      return this.isRadioSelectionMode() && this.isRadioSelectionModeInColumn();
    }
  }, {
    key: "isCheckboxOnlySelection",
    value: function isCheckboxOnlySelection() {
      return this.isCheckboxSelectionMode() && this.isCheckboxSelectionModeInColumn();
    }
  }, {
    key: "isSelected",
    value: function isSelected(rowData) {
      if (rowData && this.props.selection) {
        return this.props.selection instanceof Array ? this.findIndexInSelection(rowData) > -1 : this.equals(rowData, this.props.selection);
      }

      return false;
    }
  }, {
    key: "isContextMenuSelected",
    value: function isContextMenuSelected(rowData) {
      if (rowData && this.props.contextMenuSelection) {
        return this.equals(rowData, this.props.contextMenuSelection);
      }

      return false;
    }
  }, {
    key: "focusOnElement",
    value: function focusOnElement(event, isFocused) {
      var target = event.currentTarget;

      if (!this.allowCellSelection()) {
        if (this.isCheckboxSelectionModeInColumn()) {
          var checkbox = DomHandler.findSingle(target, 'td.p-selection-column .p-checkbox-box');
          checkbox && checkbox.focus();
        } else if (this.isRadioSelectionModeInColumn()) {
          var radio = DomHandler.findSingle(target, 'td.p-selection-column input[type="radio"]');
          radio && radio.focus();
        }
      }

      !isFocused && target && target.focus();
    }
  }, {
    key: "equals",
    value: function equals(data1, data2) {
      if (this.allowCellSelection()) return (data1.rowIndex === data2.rowIndex || data1.rowData === data2.rowData) && (data1.field === data2.field || data1.cellIndex === data2.cellIndex);else return this.compareSelectionBy === 'equals' ? data1 === data2 : ObjectUtils.equals(data1, data2, this.props.dataKey);
    }
  }, {
    key: "findIndexInSelection",
    value: function findIndexInSelection(data) {
      var _this3 = this;

      return this.props.selection ? this.props.selection.findIndex(function (d) {
        return _this3.equals(data, d);
      }) : -1;
    }
  }, {
    key: "onRowToggle",
    value: function onRowToggle(event) {
      var expandedRows;
      var dataKey = this.props.dataKey;

      if (dataKey) {
        var dataKeyValue = String(ObjectUtils.resolveFieldData(event.data, dataKey));
        expandedRows = this.props.expandedRows ? _objectSpread$s({}, this.props.expandedRows) : {};

        if (expandedRows[dataKeyValue] != null) {
          delete expandedRows[dataKeyValue];

          if (this.props.onRowCollapse) {
            this.props.onRowCollapse({
              originalEvent: event,
              data: event.data
            });
          }
        } else {
          expandedRows[dataKeyValue] = true;

          if (this.props.onRowExpand) {
            this.props.onRowExpand({
              originalEvent: event,
              data: event.data
            });
          }
        }
      } else {
        var expandedRowIndex = this.findRowIndex(this.props.expandedRows, event.data);
        expandedRows = this.props.expandedRows ? _toConsumableArray(this.props.expandedRows) : [];

        if (expandedRowIndex !== -1) {
          expandedRows = expandedRows.filter(function (val, i) {
            return i !== expandedRowIndex;
          });

          if (this.props.onRowCollapse) {
            this.props.onRowCollapse({
              originalEvent: event,
              data: event.data
            });
          }
        } else {
          expandedRows.push(event.data);

          if (this.props.onRowExpand) {
            this.props.onRowExpand({
              originalEvent: event,
              data: event.data
            });
          }
        }
      }

      if (this.props.onRowToggle) {
        this.props.onRowToggle({
          data: expandedRows
        });
      }
    }
  }, {
    key: "findRowIndex",
    value: function findRowIndex(rows, row) {
      return rows ? rows.findIndex(function (r) {
        return ObjectUtils.equals(row, r);
      }) : -1;
    }
  }, {
    key: "isRowExpanded",
    value: function isRowExpanded(row) {
      var dataKey = this.props.dataKey;

      if (dataKey) {
        var dataKeyValue = String(ObjectUtils.resolveFieldData(row, dataKey));
        return this.props.expandedRows && this.props.expandedRows[dataKeyValue] != null;
      } else {
        return this.findRowIndex(this.props.expandedRows, row) !== -1;
      }
    }
  }, {
    key: "onRowEditingToggle",
    value: function onRowEditingToggle(event) {
      var editingRows;
      var dataKey = this.props.dataKey;

      if (dataKey) {
        var dataKeyValue = String(ObjectUtils.resolveFieldData(event.data, dataKey));
        editingRows = this.props.editingRows ? _objectSpread$s({}, this.props.editingRows) : {};
        if (editingRows[dataKeyValue] != null) delete editingRows[dataKeyValue];else editingRows[dataKeyValue] = true;
      } else {
        var editingRowIndex = this.findRowIndex(this.props.editingRows, event.data);
        editingRows = this.props.editingRows ? _toConsumableArray(this.props.editingRows) : [];
        if (editingRowIndex !== -1) editingRows = editingRows.filter(function (val, i) {
          return i !== editingRowIndex;
        });else editingRows.push(event.data);
      }

      if (this.props.onRowEditChange) {
        this.props.onRowEditChange({
          originalEvent: event.originalEvent,
          data: editingRows,
          index: event.rowIndex
        });
      }
    }
  }, {
    key: "isRowEditing",
    value: function isRowEditing(row) {
      var dataKey = this.props.dataKey;

      if (dataKey) {
        var dataKeyValue = String(ObjectUtils.resolveFieldData(row, dataKey));
        return this.props.editingRows && this.props.editingRows[dataKeyValue] != null;
      } else {
        return this.findRowIndex(this.props.editingRows, row) !== -1;
      }
    }
  }, {
    key: "isSelectionEnabled",
    value: function isSelectionEnabled() {
      if (this.props.selectionMode || this.props.selectionModeInColumn != null) {
        return true;
      } else {
        if (Array.isArray(this.props.children)) {
          for (var i = 0; i < this.props.children.length; i++) {
            if (this.props.children[i].props.selectionMode) {
              return true;
            }
          }
        } else {
          return this.props.children && this.props.children.selectionMode != null;
        }
      }

      return false;
    }
  }, {
    key: "onRowDragStart",
    value: function onRowDragStart(event, index) {
      this.rowDragging = true;
      this.draggedRowIndex = index;
      event.dataTransfer.setData('text', 'b'); // For firefox
    }
  }, {
    key: "onRowDragEnd",
    value: function onRowDragEnd(event, index) {
      this.rowDragging = false;
      this.draggedRowIndex = null;
      this.droppedRowIndex = null;
    }
  }, {
    key: "onRowDragOver",
    value: function onRowDragOver(event, index) {
      if (this.rowDragging && this.draggedRowIndex !== index) {
        var rowElement = event.rowElement;
        var rowY = DomHandler.getOffset(rowElement).top + DomHandler.getWindowScrollTop();
        var pageY = event.originalEvent.pageY;
        var rowMidY = rowY + DomHandler.getOuterHeight(rowElement) / 2;
        var prevRowElement = rowElement.previousElementSibling;

        if (pageY < rowMidY) {
          DomHandler.removeClass(rowElement, 'p-datatable-dragpoint-bottom');
          this.droppedRowIndex = index;
          if (prevRowElement) DomHandler.addClass(prevRowElement, 'p-datatable-dragpoint-bottom');else DomHandler.addClass(rowElement, 'p-datatable-dragpoint-top');
        } else {
          if (prevRowElement) DomHandler.removeClass(prevRowElement, 'p-datatable-dragpoint-bottom');else DomHandler.addClass(rowElement, 'p-datatable-dragpoint-top');
          this.droppedRowIndex = index + 1;
          DomHandler.addClass(rowElement, 'p-datatable-dragpoint-bottom');
        }
      }
    }
  }, {
    key: "onRowDragLeave",
    value: function onRowDragLeave(event) {
      var rowElement = event.rowElement;
      var prevRowElement = rowElement.previousElementSibling;

      if (prevRowElement) {
        DomHandler.removeClass(prevRowElement, 'p-datatable-dragpoint-bottom');
      }

      DomHandler.removeClass(rowElement, 'p-datatable-dragpoint-bottom');
      DomHandler.removeClass(rowElement, 'p-datatable-dragpoint-top');
    }
  }, {
    key: "onRowDrop",
    value: function onRowDrop(event) {
      if (this.droppedRowIndex != null) {
        var dropIndex = this.draggedRowIndex > this.droppedRowIndex ? this.droppedRowIndex : this.droppedRowIndex === 0 ? 0 : this.droppedRowIndex - 1;

        var val = _toConsumableArray(this.props.value);

        ObjectUtils.reorderArray(val, this.draggedRowIndex, dropIndex);

        if (this.props.onRowReorder) {
          this.props.onRowReorder({
            originalEvent: event,
            value: val,
            dragIndex: this.draggedRowIndex,
            dropIndex: this.droppedRowIndex
          });
        }
      } //cleanup


      this.onRowDragLeave(event);
      this.onRowDragEnd(event);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.props.dragSelection) {
        this.unbindDragSelectionEvents();
      }
    }
  }, {
    key: "renderRowGroupHeader",
    value: function renderRowGroupHeader(rowData, index) {
      var content = null;

      if (this.props.rowGroupMode === 'subheader' && this.props.expandableRowGroups) {
        content = /*#__PURE__*/React__default['default'].createElement(RowTogglerButton, {
          onClick: this.onRowToggle,
          rowData: rowData,
          expanded: this.isRowExpanded(rowData)
        });
      }

      return /*#__PURE__*/React__default['default'].createElement("tr", {
        role: "row",
        key: index + '_rowgroupheader',
        className: "p-rowgroup-header"
      }, /*#__PURE__*/React__default['default'].createElement("td", {
        role: "cell",
        colSpan: React__default['default'].Children.count(this.props.children)
      }, content, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-rowgroup-header-name"
      }, this.props.rowGroupHeaderTemplate(rowData, index))));
    }
  }, {
    key: "renderRowGroupFooter",
    value: function renderRowGroupFooter(rowData, index) {
      return /*#__PURE__*/React__default['default'].createElement("tr", {
        role: "row",
        key: index + '_rowgroupfooter',
        className: "p-rowgroup-footer"
      }, this.props.rowGroupFooterTemplate(rowData, index));
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var rows;

      if (this.props.children) {
        var rpp = this.props.rows || 0;
        var first = this.props.first || 0;
        var selectionEnabled = this.isSelectionEnabled();
        var rowGroupMode = this.props.rowGroupMode;
        var hasSubheaderGrouping = rowGroupMode && rowGroupMode === 'subheader';
        var rowSpanGrouping = rowGroupMode && rowGroupMode === 'rowspan';
        var rowGroupHeaderExpanded = false;

        if (this.props.value && this.props.value.length) {
          rows = [];
          var startIndex = this.props.lazy ? 0 : this.props.value.length > first ? first : 0;
          var endIndex = this.props.virtualScroll ? startIndex + rpp * 2 : startIndex + rpp || this.props.value.length;

          var _loop = function _loop(i) {
            if (i >= _this4.props.value.length) {
              return "break";
            }

            var rowData = _this4.props.value[i];

            var expanded = _this4.isRowExpanded(rowData);

            var editing = _this4.isRowEditing(rowData);

            var selected = selectionEnabled ? _this4.isSelected(_this4.props.value[i]) : false;

            var contextMenuSelected = _this4.isContextMenuSelected(rowData);

            var groupRowSpan = void 0; //header row group

            if (hasSubheaderGrouping) {
              var currentRowFieldData = ObjectUtils.resolveFieldData(rowData, _this4.props.groupField);
              var previousRowFieldData = ObjectUtils.resolveFieldData(_this4.props.value[i - 1], _this4.props.groupField);

              if (i === 0 || currentRowFieldData !== previousRowFieldData) {
                rows.push(_this4.renderRowGroupHeader(rowData, i));
                rowGroupHeaderExpanded = expanded;
              }
            }

            if (rowSpanGrouping) {
              var rowSpanIndex = i;

              var _currentRowFieldData = ObjectUtils.resolveFieldData(rowData, _this4.props.sortField);

              var shouldCountRowSpan = i === startIndex || ObjectUtils.resolveFieldData(_this4.props.value[i - 1], _this4.props.sortField) !== _currentRowFieldData;

              if (shouldCountRowSpan) {
                var nextRowFieldData = _currentRowFieldData;
                groupRowSpan = 0;

                while (_currentRowFieldData === nextRowFieldData) {
                  groupRowSpan++;
                  var nextRowData = _this4.props.value[++rowSpanIndex];

                  if (nextRowData) {
                    nextRowFieldData = ObjectUtils.resolveFieldData(nextRowData, _this4.props.sortField);
                  } else {
                    break;
                  }
                }
              }
            }

            var isRowGroupExpanded = _this4.props.expandableRowGroups && hasSubheaderGrouping && rowGroupHeaderExpanded;

            if (!_this4.props.expandableRowGroups || isRowGroupExpanded) {
              //row content
              var bodyRow = /*#__PURE__*/React__default['default'].createElement(BodyRow, {
                tableId: _this4.props.tableId,
                key: i,
                value: _this4.props.value,
                rowData: rowData,
                rowIndex: i,
                onClick: _this4.onRowClick,
                onDoubleClick: _this4.props.onRowDoubleClick,
                onRightClick: _this4.onRowRightClick,
                onTouchEnd: _this4.onRowTouchEnd,
                onMouseDown: _this4.onRowMouseDown,
                onMouseUp: _this4.onRowMouseUp,
                onCellMouseDown: _this4.onCellMouseDown,
                onCellMouseUp: _this4.onCellMouseUp,
                onRowToggle: _this4.onRowToggle,
                expanded: expanded,
                selectionMode: _this4.props.selectionMode,
                selectOnEdit: _this4.props.selectOnEdit,
                onRadioClick: _this4.onRadioClick,
                onCheckboxClick: _this4.onCheckboxClick,
                selected: selected,
                contextMenuSelected: contextMenuSelected,
                rowClassName: _this4.props.rowClassName,
                cellClassName: _this4.props.cellClassName,
                sortField: _this4.props.sortField,
                rowGroupMode: _this4.props.rowGroupMode,
                groupRowSpan: groupRowSpan,
                onDragStart: function onDragStart(e) {
                  return _this4.onRowDragStart(e, i);
                },
                onDragEnd: _this4.onRowDragEnd,
                onDragOver: function onDragOver(e) {
                  return _this4.onRowDragOver(e, i);
                },
                onDragLeave: _this4.onRowDragLeave,
                onDrop: _this4.onRowDrop,
                virtualScroll: _this4.props.virtualScroll,
                virtualRowHeight: _this4.props.virtualRowHeight,
                editMode: _this4.props.editMode,
                editing: editing,
                isRowEditingControlled: !!_this4.props.onRowEditChange,
                rowEditorValidator: _this4.props.rowEditorValidator,
                onRowEditInit: _this4.props.onRowEditInit,
                onRowEditSave: _this4.props.onRowEditSave,
                onRowEditCancel: _this4.props.onRowEditCancel,
                onRowEditingToggle: _this4.onRowEditingToggle,
                showRowReorderElement: _this4.props.showRowReorderElement,
                showSelectionElement: _this4.props.showSelectionElement,
                onSelectionChange: _this4.props.onSelectionChange,
                selectionModeInColumn: _this4.props.selectionModeInColumn,
                dragSelection: _this4.props.dragSelection,
                selection: _this4.props.selection,
                allowRowSelection: _this4.allowRowSelection(),
                allowCellSelection: _this4.allowCellSelection(),
                onCellClick: _this4.onCellClick,
                onEditingCellChange: _this4.props.onEditingCellChange
              }, _this4.props.children);
              rows.push(bodyRow);
            } //row expansion


            if (expanded && !(hasSubheaderGrouping && _this4.props.expandableRowGroups)) {
              var expandedRowContent = _this4.props.rowExpansionTemplate(rowData);

              var id = "".concat(_this4.props.tableId ? _this4.props.tableId + '_' : '', "content_").concat(i, "_expanded");
              var expandedRow = /*#__PURE__*/React__default['default'].createElement("tr", {
                key: id,
                id: id,
                role: "row",
                className: "p-row-expanded"
              }, /*#__PURE__*/React__default['default'].createElement("td", {
                role: "cell",
                colSpan: _this4.props.children.length
              }, expandedRowContent));
              rows.push(expandedRow);
            } //footer row group


            if (hasSubheaderGrouping && (!_this4.props.expandableRowGroups || isRowGroupExpanded)) {
              var _currentRowFieldData2 = ObjectUtils.resolveFieldData(rowData, _this4.props.groupField);

              var _nextRowFieldData = ObjectUtils.resolveFieldData(_this4.props.value[i + 1], _this4.props.groupField);

              if (i === _this4.props.value.length - 1 || _currentRowFieldData2 !== _nextRowFieldData) {
                rows.push(_this4.renderRowGroupFooter(rowData, i));
              }
            }
          };

          for (var i = startIndex; i < endIndex; i++) {
            var _ret = _loop(i);

            if (_ret === "break") break;
          }
        } else {
          var emptyMessage = this.props.emptyMessage;
          rows = !this.props.loading && emptyMessage !== null ? /*#__PURE__*/React__default['default'].createElement("tr", {
            role: "row",
            className: "p-datatable-emptymessage"
          }, /*#__PURE__*/React__default['default'].createElement("td", {
            role: "cell",
            colSpan: this.props.children.length
          }, typeof emptyMessage === 'function' ? emptyMessage(this.props.frozen) : emptyMessage)) : null;
        }
      }

      return /*#__PURE__*/React__default['default'].createElement("tbody", {
        className: "p-datatable-tbody"
      }, rows);
    }
  }]);

  return TableBody;
}(React.Component);

function _createSuper$1v(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1v(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1v() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var FooterCell = /*#__PURE__*/function (_Component) {
  _inherits(FooterCell, _Component);

  var _super = _createSuper$1v(FooterCell);

  function FooterCell() {
    _classCallCheck(this, FooterCell);

    return _super.apply(this, arguments);
  }

  _createClass(FooterCell, [{
    key: "render",
    value: function render() {
      var className = this.props.footerClassName || this.props.className;
      var footer = ObjectUtils.getJSXElement(this.props.footer, this.props);
      return /*#__PURE__*/React__default['default'].createElement("td", {
        role: "cell",
        className: className,
        style: this.props.footerStyle || this.props.style,
        colSpan: this.props.colSpan,
        rowSpan: this.props.rowSpan
      }, footer);
    }
  }]);

  return FooterCell;
}(React.Component);

function _createSuper$1u(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1u(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1u() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var TableFooter = /*#__PURE__*/function (_Component) {
  _inherits(TableFooter, _Component);

  var _super = _createSuper$1u(TableFooter);

  function TableFooter() {
    _classCallCheck(this, TableFooter);

    return _super.apply(this, arguments);
  }

  _createClass(TableFooter, [{
    key: "createFooterCells",
    value: function createFooterCells(root, column, i) {
      var children = React__default['default'].Children.toArray(root.props.children);
      return React__default['default'].Children.map(children, function (column, i) {
        return /*#__PURE__*/React__default['default'].createElement(FooterCell, _extends({
          key: i
        }, column.props));
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var content;

      if (this.props.columnGroup) {
        var rows = React__default['default'].Children.toArray(this.props.columnGroup.props.children);
        content = rows.map(function (row, i) {
          return /*#__PURE__*/React__default['default'].createElement("tr", {
            key: i,
            role: "row"
          }, _this.createFooterCells(row));
        });
      } else {
        content = /*#__PURE__*/React__default['default'].createElement("tr", {
          role: "row"
        }, this.createFooterCells(this));
      }

      return /*#__PURE__*/React__default['default'].createElement("tfoot", {
        className: "p-datatable-tfoot"
      }, content);
    }
  }]);

  return TableFooter;
}(React.Component);

function _createSuper$1t(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1t(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1t() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var HeaderCell = /*#__PURE__*/function (_Component) {
  _inherits(HeaderCell, _Component);

  var _super = _createSuper$1t(HeaderCell);

  function HeaderCell(props) {
    var _this;

    _classCallCheck(this, HeaderCell);

    _this = _super.call(this, props);
    _this.state = {
      filterValue: '',
      badgeVisible: false
    };
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onFilterChange = _this.onFilterChange.bind(_assertThisInitialized(_this));
    _this.onMouseDown = _this.onMouseDown.bind(_assertThisInitialized(_this));
    _this.onResizerMouseDown = _this.onResizerMouseDown.bind(_assertThisInitialized(_this));
    _this.onResizerClick = _this.onResizerClick.bind(_assertThisInitialized(_this));
    _this.onResizerDoubleClick = _this.onResizerDoubleClick.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onDragStart = _this.onDragStart.bind(_assertThisInitialized(_this));
    _this.onDragOver = _this.onDragOver.bind(_assertThisInitialized(_this));
    _this.onDragLeave = _this.onDragLeave.bind(_assertThisInitialized(_this));
    _this.onDrop = _this.onDrop.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(HeaderCell, [{
    key: "onClick",
    value: function onClick(event) {
      var _this$props$columnPro = this.props.columnProps,
          field = _this$props$columnPro.field,
          sortField = _this$props$columnPro.sortField,
          sortable = _this$props$columnPro.sortable,
          sortFunction = _this$props$columnPro.sortFunction;

      if (!this.isSortableDisabled()) {
        var targetNode = event.target;

        if (DomHandler.hasClass(targetNode, 'p-sortable-column') || DomHandler.hasClass(targetNode, 'p-column-title') || DomHandler.hasClass(targetNode, 'p-sortable-column-icon') || DomHandler.hasClass(targetNode.parentElement, 'p-sortable-column-icon')) {
          this.props.onSort({
            originalEvent: event,
            sortField: sortField || field,
            sortFunction: sortFunction,
            sortable: sortable,
            sortableDisabledFields: this.props.sortableDisabledFields
          });
          DomHandler.clearSelection();
        }
      }
    }
  }, {
    key: "onFilterChange",
    value: function onFilterChange(e) {
      var _this2 = this;

      var filterValue = e.target.value;

      if (this.props.columnProps.filter && this.props.onFilter) {
        if (this.filterTimeout) {
          clearTimeout(this.filterTimeout);
        }

        this.filterTimeout = setTimeout(function () {
          _this2.props.onFilter({
            value: filterValue,
            field: _this2.props.columnProps.filterField || _this2.props.columnProps.field,
            matchMode: _this2.props.columnProps.filterMatchMode
          });

          _this2.filterTimeout = null;
        }, this.props.filterDelay);
      }

      this.setState({
        filterValue: filterValue
      });
    }
  }, {
    key: "onResizerMouseDown",
    value: function onResizerMouseDown(event) {
      if (this.props.resizableColumns && this.props.onColumnResizeStart) {
        this.props.onColumnResizeStart({
          originalEvent: event,
          columnEl: event.target.parentElement,
          columnProps: this.props.columnProps
        });
        event.preventDefault();
      }
    }
  }, {
    key: "onResizerClick",
    value: function onResizerClick(event) {
      if (this.props.resizableColumns && this.props.onColumnResizerClick) {
        this.props.onColumnResizerClick({
          originalEvent: event,
          element: event.currentTarget.parentElement,
          column: this.props.columnProps
        });
        event.preventDefault();
      }
    }
  }, {
    key: "onResizerDoubleClick",
    value: function onResizerDoubleClick(event) {
      if (this.props.resizableColumns && this.props.onColumnResizerDoubleClick) {
        this.props.onColumnResizerDoubleClick({
          originalEvent: event,
          element: event.currentTarget.parentElement,
          column: this.props.columnProps
        });
        event.preventDefault();
      }
    }
  }, {
    key: "onMouseDown",
    value: function onMouseDown(event) {
      if (this.props.reorderableColumns && this.props.columnProps.reorderable) {
        if (event.target.nodeName !== 'INPUT') this.el.draggable = true;else if (event.target.nodeName === 'INPUT') this.el.draggable = false;
      }
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.key === 'Enter' && event.currentTarget === this.el) {
        this.onClick(event);
        event.preventDefault();
      }
    }
  }, {
    key: "onDragStart",
    value: function onDragStart(event) {
      if (this.props.onDragStart) {
        this.props.onDragStart({
          originalEvent: event,
          column: this.props.columnProps
        });
      }
    }
  }, {
    key: "onDragOver",
    value: function onDragOver(event) {
      if (this.props.onDragOver) {
        this.props.onDragOver({
          originalEvent: event,
          column: this.props.columnProps
        });
      }
    }
  }, {
    key: "onDragLeave",
    value: function onDragLeave(event) {
      if (this.props.onDragLeave) {
        this.props.onDragLeave({
          originalEvent: event,
          column: this.props.columnProps
        });
      }
    }
  }, {
    key: "onDrop",
    value: function onDrop(event) {
      if (this.props.onDrop) {
        this.props.onDrop({
          originalEvent: event,
          column: this.props.columnProps
        });
      }
    }
  }, {
    key: "getMultiSortMetaDataIndex",
    value: function getMultiSortMetaDataIndex() {
      if (this.props.multiSortMeta) {
        var columnSortField = this.props.columnProps.sortField || this.props.columnProps.field;

        for (var i = 0; i < this.props.multiSortMeta.length; i++) {
          if (this.props.multiSortMeta[i].field === columnSortField) {
            return i;
          }
        }
      }

      return -1;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var prevColumnProps = prevProps.columnProps;
      var columnProps = this.props.columnProps;
      var filterField = columnProps.filterField || columnProps.field;

      if (prevColumnProps.sortableDisabled !== columnProps.sortableDisabled || prevColumnProps.sortable !== columnProps.sortable) {
        this.props.onSortableChange();
      }

      if (this.state.filterValue && prevProps.filters && prevProps.filters[filterField] && (!this.props.filters || !this.props.filters[filterField])) {
        this.setState({
          filterValue: ''
        });
      }
    }
  }, {
    key: "getAriaSort",
    value: function getAriaSort(sorted, sortOrder) {
      if (this.props.columnProps.sortable) {
        var sortIcon = sorted ? sortOrder < 0 ? 'pi-sort-amount-down' : 'pi-sort-amount-up-alt' : 'pi-sort-alt';
        if (sortIcon === 'pi-sort-amount-down') return 'descending';else if (sortIcon === 'pi-sort-amount-up-alt') return 'ascending';else return 'none';
      } else {
        return null;
      }
    }
  }, {
    key: "isSortableDisabled",
    value: function isSortableDisabled() {
      return !this.props.columnProps.sortable || this.props.columnProps.sortable && (this.props.allSortableDisabled || this.props.columnProps.sortableDisabled);
    }
  }, {
    key: "isSingleSorted",
    value: function isSingleSorted() {
      return this.props.sortField !== null ? this.props.columnProps.field === this.props.sortField || this.props.columnProps.sortField === this.props.sortField : false;
    }
  }, {
    key: "renderSortIcon",
    value: function renderSortIcon(sorted, sortOrder) {
      if (this.props.columnProps.sortable) {
        var sortIcon = sorted ? sortOrder < 0 ? 'pi-sort-amount-down' : 'pi-sort-amount-up-alt' : 'pi-sort-alt';
        var sortIconClassName = classNames('p-sortable-column-icon pi pi-fw', sortIcon);
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: sortIconClassName
        });
      } else {
        return null;
      }
    }
  }, {
    key: "renderSortBadge",
    value: function renderSortBadge(sortMetaDataIndex) {
      if (sortMetaDataIndex !== -1 && this.state.badgeVisible) {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-sortable-column-badge"
        }, sortMetaDataIndex + 1);
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var filterElement, headerCheckbox;

      if (this.props.columnProps.filter && this.props.renderOptions.renderFilter) {
        filterElement = this.props.columnProps.filterElement || /*#__PURE__*/React__default['default'].createElement(InputText, {
          onChange: this.onFilterChange,
          type: this.props.columnProps.filterType,
          value: this.state.filterValue,
          className: "p-column-filter",
          placeholder: this.props.columnProps.filterPlaceholder,
          maxLength: this.props.columnProps.filterMaxLength
        });
      }

      if (this.props.columnProps.selectionMode === 'multiple' && this.props.renderOptions.renderHeaderCheckbox) {
        headerCheckbox = /*#__PURE__*/React__default['default'].createElement(RowCheckbox, {
          onClick: this.props.onHeaderCheckboxClick,
          selected: this.props.headerCheckboxSelected,
          disabled: !this.props.value || this.props.value.length === 0
        });
      }

      if (this.props.renderOptions.filterOnly) {
        return /*#__PURE__*/React__default['default'].createElement("th", {
          ref: function ref(el) {
            return _this3.el = el;
          },
          role: "columnheader",
          className: classNames('p-filter-column', this.props.columnProps.filterHeaderClassName),
          style: this.props.columnProps.filterHeaderStyle || this.props.columnProps.style,
          colSpan: this.props.columnProps.colSpan,
          rowSpan: this.props.columnProps.rowSpan
        }, filterElement, headerCheckbox);
      } else {
        var sortMetaDataIndex = this.getMultiSortMetaDataIndex();
        var multiSortMetaData = sortMetaDataIndex !== -1 ? this.props.multiSortMeta[sortMetaDataIndex] : null;
        var singleSorted = this.isSingleSorted();
        var multipleSorted = multiSortMetaData !== null;
        var sortOrder = 0;
        var resizer = this.props.resizableColumns && /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-column-resizer p-clickable",
          onMouseDown: this.onResizerMouseDown,
          onClick: this.onResizerClick,
          onDoubleClick: this.onResizerDoubleClick
        });
        if (singleSorted) sortOrder = this.props.sortOrder;else if (multipleSorted) sortOrder = multiSortMetaData.order;
        var sorted = this.props.columnProps.sortable && (singleSorted || multipleSorted);
        var isSortableDisabled = this.isSortableDisabled();
        var className = classNames({
          'p-sortable-column': this.props.columnProps.sortable,
          'p-highlight': sorted,
          'p-sortable-disabled': isSortableDisabled,
          'p-resizable-column': this.props.resizableColumns,
          'p-selection-column': this.props.columnProps.selectionMode
        }, this.props.columnProps.headerClassName || this.props.columnProps.className);
        var sortIconElement = this.renderSortIcon(sorted, sortOrder);
        var ariaSortData = this.getAriaSort(sorted, sortOrder);
        var sortBadge = this.renderSortBadge(sortMetaDataIndex);
        var tabIndex = this.props.columnProps.sortable && !isSortableDisabled ? this.props.tabIndex : null;
        return /*#__PURE__*/React__default['default'].createElement("th", {
          ref: function ref(el) {
            return _this3.el = el;
          },
          role: "columnheader",
          tabIndex: tabIndex,
          className: className,
          style: this.props.columnProps.headerStyle || this.props.columnProps.style,
          onClick: this.onClick,
          onMouseDown: this.onMouseDown,
          onKeyDown: this.onKeyDown,
          colSpan: this.props.columnProps.colSpan,
          rowSpan: this.props.columnProps.rowSpan,
          "aria-sort": ariaSortData,
          onDragStart: this.onDragStart,
          onDragOver: this.onDragOver,
          onDragLeave: this.onDragLeave,
          onDrop: this.onDrop
        }, resizer, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-column-title"
        }, this.props.columnProps.header), sortIconElement, sortBadge, filterElement, headerCheckbox);
      }
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      return {
        badgeVisible: nextProps.multiSortMeta && nextProps.multiSortMeta.length > 1
      };
    }
  }]);

  return HeaderCell;
}(React.Component);

function _createForOfIteratorHelper$c(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$c(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$c(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$c(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$c(o, minLen); }

function _arrayLikeToArray$c(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$1s(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1s(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1s() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var TableHeader = /*#__PURE__*/function (_Component) {
  _inherits(TableHeader, _Component);

  var _super = _createSuper$1s(TableHeader);

  function TableHeader(props) {
    var _this;

    _classCallCheck(this, TableHeader);

    _this = _super.call(this, props);
    _this.state = {
      sortableDisabledFields: [],
      allSortableDisabled: false
    };
    _this.onSortableChange = _this.onSortableChange.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(TableHeader, [{
    key: "createHeaderCells",
    value: function createHeaderCells(columns, renderOptions) {
      var _this2 = this;

      return React__default['default'].Children.map(columns, function (column, i) {
        return /*#__PURE__*/React__default['default'].createElement(HeaderCell, {
          key: column.props.columnKey || column.props.field || i,
          allSortableDisabled: _this2.isAllSortableDisabled(),
          onSortableChange: _this2.onSortableChange,
          columnProps: column.props,
          value: _this2.props.value,
          onSort: _this2.props.onSort,
          sortableDisabledFields: _this2.state.sortableDisabledFields,
          sortMode: _this2.props.sortMode,
          sortField: _this2.props.sortField,
          sortOrder: _this2.props.sortOrder,
          multiSortMeta: _this2.props.multiSortMeta,
          resizableColumns: _this2.props.resizableColumns,
          onColumnResizeStart: _this2.props.onColumnResizeStart,
          onColumnResizerClick: _this2.props.onColumnResizerClick,
          onColumnResizerDoubleClick: _this2.props.onColumnResizerDoubleClick,
          filterDelay: _this2.props.filterDelay,
          onFilter: _this2.props.onFilter,
          renderOptions: renderOptions,
          onHeaderCheckboxClick: _this2.props.onHeaderCheckboxClick,
          headerCheckboxSelected: _this2.props.headerCheckboxSelected,
          reorderableColumns: _this2.props.reorderableColumns,
          onDragStart: _this2.props.onColumnDragStart,
          onDragOver: _this2.props.onColumnDragOver,
          onDragLeave: _this2.props.onColumnDragLeave,
          onDrop: _this2.props.onColumnDrop,
          filters: _this2.props.filters,
          tabIndex: _this2.props.tabIndex
        });
      });
    }
  }, {
    key: "hasColumnFilter",
    value: function hasColumnFilter(columns) {
      if (columns) {
        var _iterator = _createForOfIteratorHelper$c(columns),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var col = _step.value;

            if (col.props.filter) {
              return true;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      return false;
    }
  }, {
    key: "isSingleSort",
    value: function isSingleSort() {
      return this.props.sortMode === 'single';
    }
  }, {
    key: "isMultipleSort",
    value: function isMultipleSort() {
      return this.props.sortMode === 'multiple';
    }
  }, {
    key: "isAllSortableDisabled",
    value: function isAllSortableDisabled() {
      return this.isSingleSort() && this.state.allSortableDisabled;
    }
  }, {
    key: "isColumnSorted",
    value: function isColumnSorted(column) {
      return this.props.sortField !== null ? column.props.field === this.props.sortField || column.props.sortField === this.props.sortField : false;
    }
  }, {
    key: "updateSortableDisabled",
    value: function updateSortableDisabled() {
      var _this3 = this;

      if (this.isSingleSort() || this.isMultipleSort() && this.props.onSort) {
        var sortableDisabledFields = [];
        var allSortableDisabled = false;
        React__default['default'].Children.forEach(this.props.children, function (column) {
          if (column.props.sortableDisabled) {
            sortableDisabledFields.push(column.props.sortField || column.props.field);

            if (!allSortableDisabled && _this3.isColumnSorted(column)) {
              allSortableDisabled = true;
            }
          }
        });
        this.setState({
          sortableDisabledFields: sortableDisabledFields,
          allSortableDisabled: allSortableDisabled
        });
      }
    }
  }, {
    key: "onSortableChange",
    value: function onSortableChange() {
      this.updateSortableDisabled();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateSortableDisabled();
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var content;

      if (this.props.columnGroup) {
        var rows = React__default['default'].Children.toArray(this.props.columnGroup.props.children);
        content = rows.map(function (row, i) {
          return /*#__PURE__*/React__default['default'].createElement("tr", {
            key: i,
            role: "row"
          }, _this4.createHeaderCells(React__default['default'].Children.toArray(row.props.children), {
            filterOnly: false,
            renderFilter: true,
            renderHeaderCheckbox: true
          }));
        });
      } else {
        var columns = React__default['default'].Children.toArray(this.props.children);

        if (this.hasColumnFilter(columns)) {
          content = /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("tr", {
            role: "row"
          }, this.createHeaderCells(columns, {
            filterOnly: false,
            renderFilter: false,
            renderHeaderCheckbox: false
          })), /*#__PURE__*/React__default['default'].createElement("tr", {
            role: "row"
          }, this.createHeaderCells(columns, {
            filterOnly: true,
            renderFilter: true,
            renderHeaderCheckbox: true
          })));
        } else {
          content = /*#__PURE__*/React__default['default'].createElement("tr", {
            role: "row"
          }, this.createHeaderCells(columns, {
            filterOnly: false,
            renderFilter: false,
            renderHeaderCheckbox: true
          }));
        }
      }

      return /*#__PURE__*/React__default['default'].createElement("thead", {
        className: "p-datatable-thead"
      }, content);
    }
  }]);

  return TableHeader;
}(React.Component);

function _createSuper$1r(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1r(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1r() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var TableLoadingBody = /*#__PURE__*/function (_Component) {
  _inherits(TableLoadingBody, _Component);

  var _super = _createSuper$1r(TableLoadingBody);

  function TableLoadingBody() {
    _classCallCheck(this, TableLoadingBody);

    return _super.apply(this, arguments);
  }

  _createClass(TableLoadingBody, [{
    key: "renderRow",
    value: function renderRow(index) {
      var cells = [];

      for (var i = 0; i < this.props.columns.length; i++) {
        cells.push( /*#__PURE__*/React__default['default'].createElement("td", {
          key: i
        }, this.props.columns[i].props.loadingBody()));
      }

      return /*#__PURE__*/React__default['default'].createElement("tr", {
        key: index
      }, cells);
    }
  }, {
    key: "renderRows",
    value: function renderRows() {
      var rows = [];

      for (var i = 0; i < this.props.rows; i++) {
        rows.push(this.renderRow(i));
      }

      return rows;
    }
  }, {
    key: "render",
    value: function render() {
      var rows = this.renderRows();
      return /*#__PURE__*/React__default['default'].createElement("tbody", {
        className: "p-datatable-tbody"
      }, rows);
    }
  }]);

  return TableLoadingBody;
}(React.Component);

function _createForOfIteratorHelper$b(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$b(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$b(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$b(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$b(o, minLen); }

function _arrayLikeToArray$b(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys$r(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$r(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$r(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$r(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1q(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1q(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1q() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DataTable = /*#__PURE__*/function (_Component) {
  _inherits(DataTable, _Component);

  var _super = _createSuper$1q(DataTable);

  function DataTable(props) {
    var _this;

    _classCallCheck(this, DataTable);

    _this = _super.call(this, props);
    _this.state = {
      d_rows: props.rows,
      editingCells: []
    };

    if (!_this.props.onPage) {
      _this.state.first = props.first;
      _this.state.rows = props.rows;
    }

    if (!_this.props.onSort) {
      _this.state.sortField = props.sortField;
      _this.state.sortOrder = props.sortOrder;
      _this.state.multiSortMeta = props.multiSortMeta;
    }

    if (!_this.props.onFilter) {
      _this.state.filters = props.filters;
    }

    if (_this.isStateful()) {
      _this.restoreState(_this.state);
    }

    _this.onPageChange = _this.onPageChange.bind(_assertThisInitialized(_this));
    _this.onSort = _this.onSort.bind(_assertThisInitialized(_this));
    _this.onFilter = _this.onFilter.bind(_assertThisInitialized(_this));
    _this.onColumnResizeStart = _this.onColumnResizeStart.bind(_assertThisInitialized(_this));
    _this.onHeaderCheckboxClick = _this.onHeaderCheckboxClick.bind(_assertThisInitialized(_this));
    _this.onColumnDragStart = _this.onColumnDragStart.bind(_assertThisInitialized(_this));
    _this.onColumnDragOver = _this.onColumnDragOver.bind(_assertThisInitialized(_this));
    _this.onColumnDragLeave = _this.onColumnDragLeave.bind(_assertThisInitialized(_this));
    _this.onColumnDrop = _this.onColumnDrop.bind(_assertThisInitialized(_this));
    _this.onVirtualScroll = _this.onVirtualScroll.bind(_assertThisInitialized(_this));
    _this.onEditingCellChange = _this.onEditingCellChange.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(DataTable, [{
    key: "getFirst",
    value: function getFirst() {
      return this.props.onPage ? this.props.first : this.state.first;
    }
  }, {
    key: "getRows",
    value: function getRows() {
      return this.props.onPage ? this.props.rows : this.state.rows;
    }
  }, {
    key: "getSortField",
    value: function getSortField() {
      return this.props.onSort ? this.props.sortField : this.state.sortField;
    }
  }, {
    key: "getSortOrder",
    value: function getSortOrder() {
      return this.props.onSort ? this.props.sortOrder : this.state.sortOrder;
    }
  }, {
    key: "getMultiSortMeta",
    value: function getMultiSortMeta() {
      return this.props.onSort ? this.props.multiSortMeta : this.state.multiSortMeta;
    }
  }, {
    key: "getFilters",
    value: function getFilters() {
      return this.props.onFilter ? this.props.filters : this.state.filters;
    }
  }, {
    key: "getStorage",
    value: function getStorage() {
      switch (this.props.stateStorage) {
        case 'local':
          return window.localStorage;

        case 'session':
          return window.sessionStorage;

        case 'custom':
          return null;

        default:
          throw new Error(this.props.stateStorage + ' is not a valid value for the state storage, supported values are "local", "session" and "custom".');
      }
    }
  }, {
    key: "isCustomStateStorage",
    value: function isCustomStateStorage() {
      return this.props.stateStorage === 'custom';
    }
  }, {
    key: "isStateful",
    value: function isStateful() {
      return this.props.stateKey != null || this.isCustomStateStorage();
    }
  }, {
    key: "saveState",
    value: function saveState() {
      var state = {};

      if (this.props.paginator) {
        state.first = this.getFirst();
        state.rows = this.getRows();
      }

      var sortField = this.getSortField();

      if (sortField) {
        state.sortField = sortField;
        state.sortOrder = this.getSortOrder();
      }

      var multiSortMeta = this.getMultiSortMeta();

      if (multiSortMeta) {
        state.multiSortMeta = multiSortMeta;
      }

      if (this.hasFilter()) {
        state.filters = this.getFilters();
      }

      if (this.props.resizableColumns) {
        this.saveColumnWidths(state);
      }

      if (this.props.reorderableColumns) {
        state.columnOrder = this.state.columnOrder;
      }

      if (this.props.expandedRows) {
        state.expandedRows = this.props.expandedRows;
      }

      if (this.props.selection && this.props.onSelectionChange) {
        state.selection = this.props.selection;
      }

      if (this.isCustomStateStorage()) {
        if (this.props.customSaveState) {
          this.props.customSaveState(state);
        }
      } else {
        var storage = this.getStorage();

        if (Object.keys(state).length) {
          storage.setItem(this.props.stateKey, JSON.stringify(state));
        }
      }

      if (this.props.onStateSave) {
        this.props.onStateSave(state);
      }
    }
  }, {
    key: "clearState",
    value: function clearState() {
      var storage = this.getStorage();

      if (storage && this.props.stateKey) {
        storage.removeItem(this.props.stateKey);
      }
    }
  }, {
    key: "restoreState",
    value: function restoreState(state) {
      var restoredState = {};

      if (this.isCustomStateStorage()) {
        if (this.props.customRestoreState) {
          restoredState = this.props.customRestoreState();
        }
      } else {
        var storage = this.getStorage();
        var stateString = storage.getItem(this.props.stateKey);

        if (stateString) {
          restoredState = JSON.parse(stateString);
        }
      }

      this._restoreState(restoredState, state);
    }
  }, {
    key: "restoreTableState",
    value: function restoreTableState(restoredState) {
      var state = this._restoreState(restoredState);

      if (state && Object.keys(state).length) {
        this.setState(state);
      }
    }
  }, {
    key: "_restoreState",
    value: function _restoreState(restoredState) {
      var _this2 = this;

      var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (restoredState && Object.keys(restoredState).length) {
        if (this.props.paginator) {
          if (this.props.onPage) {
            var getOnPageParams = function getOnPageParams(first, rows) {
              var totalRecords = _this2.getTotalRecords(_this2.processData());

              var pageCount = Math.ceil(totalRecords / rows) || 1;
              var page = Math.floor(first / rows);
              return {
                first: first,
                rows: rows,
                page: page,
                pageCount: pageCount
              };
            };

            this.props.onPage(getOnPageParams(restoredState.first, restoredState.rows));
          } else {
            state.first = restoredState.first;
            state.rows = restoredState.rows;
          }
        }

        if (restoredState.sortField) {
          if (this.props.onSort) {
            this.props.onSort({
              sortField: restoredState.sortField,
              sortOrder: restoredState.sortOrder
            });
          } else {
            state.sortField = restoredState.sortField;
            state.sortOrder = restoredState.sortOrder;
          }
        }

        if (restoredState.multiSortMeta) {
          if (this.props.onSort) {
            this.props.onSort({
              multiSortMeta: restoredState.multiSortMeta
            });
          } else {
            state.multiSortMeta = restoredState.multiSortMeta;
          }
        }

        if (restoredState.filters) {
          if (this.props.onFilter) {
            this.props.onFilter({
              filters: restoredState.filters
            });
          } else {
            state.filters = restoredState.filters;
          }
        }

        if (this.props.resizableColumns) {
          this.columnWidthsState = restoredState.columnWidths;
          this.tableWidthState = restoredState.tableWidth;
        }

        if (this.props.reorderableColumns) {
          state.columnOrder = restoredState.columnOrder;
        }

        if (restoredState.expandedRows && this.props.onRowToggle) {
          this.props.onRowToggle({
            data: restoredState.expandedRows
          });
        }

        if (restoredState.selection && this.props.onSelectionChange) {
          this.props.onSelectionChange({
            value: restoredState.selection
          });
        }

        if (this.props.onStateRestore) {
          this.props.onStateRestore(restoredState);
        }
      }

      return state;
    }
  }, {
    key: "saveColumnWidths",
    value: function saveColumnWidths(state) {
      var widths = [];
      var headers = DomHandler.find(this.container, '.p-datatable-thead > tr > th.p-resizable-column');
      headers.map(function (header) {
        return widths.push(DomHandler.getOuterWidth(header));
      });
      state.columnWidths = widths.join(',');

      if (this.props.columnResizeMode === 'expand') {
        state.tableWidth = this.props.scrollable ? DomHandler.findSingle(this.container, '.p-datatable-scrollable-header-table').style.width : DomHandler.getOuterWidth(this.table) + 'px';
      }
    }
  }, {
    key: "restoreColumnWidths",
    value: function restoreColumnWidths() {
      if (this.columnWidthsState) {
        var widths = this.columnWidthsState.split(',');

        if (this.props.columnResizeMode === 'expand' && this.tableWidthState) {
          if (this.props.scrollable) {
            this.setScrollableItemsWidthOnExpandResize(null, this.tableWidthState, 0);
          } else {
            this.table.style.width = this.tableWidthState;
            this.container.style.width = this.tableWidthState;
          }
        }

        if (this.props.scrollable) {
          var headerCols = DomHandler.find(this.container, '.p-datatable-scrollable-header-table > colgroup > col');
          var bodyCols = DomHandler.find(this.container, '.p-datatable-scrollable-body-table > colgroup > col');
          headerCols.map(function (col, index) {
            return col.style.width = widths[index] + 'px';
          });
          bodyCols.map(function (col, index) {
            return col.style.width = widths[index] + 'px';
          });
        } else {
          var headers = DomHandler.find(this.table, '.p-datatable-thead > tr > th');
          headers.map(function (header, index) {
            return header.style.width = widths[index] + 'px';
          });
        }
      }
    }
  }, {
    key: "onPageChange",
    value: function onPageChange(event) {
      if (this.props.onPage) this.props.onPage(event);else this.setState({
        first: event.first,
        rows: event.rows
      });

      if (this.props.onValueChange) {
        this.props.onValueChange(this.processData());
      }
    }
  }, {
    key: "createPaginator",
    value: function createPaginator(position, totalRecords, data) {
      var className = classNames('p-paginator-' + position, this.props.paginatorClassName);
      return /*#__PURE__*/React__default['default'].createElement(Paginator, {
        first: this.getFirst(),
        rows: this.getRows(),
        pageLinkSize: this.props.pageLinkSize,
        className: className,
        onPageChange: this.onPageChange,
        template: this.props.paginatorTemplate,
        totalRecords: totalRecords,
        rowsPerPageOptions: this.props.rowsPerPageOptions,
        currentPageReportTemplate: this.props.currentPageReportTemplate,
        leftContent: this.props.paginatorLeft,
        rightContent: this.props.paginatorRight,
        alwaysShow: this.props.alwaysShowPaginator,
        dropdownAppendTo: this.props.paginatorDropdownAppendTo
      });
    }
  }, {
    key: "onSort",
    value: function onSort(event) {
      var sortField = event.sortField;
      var sortOrder = this.props.defaultSortOrder;
      var multiSortMeta;
      var eventMeta;
      this.columnSortable = event.sortable;
      this.columnSortFunction = event.sortFunction;
      this.columnField = event.sortField;

      if (this.props.sortMode === 'multiple') {
        var metaKey = event.originalEvent.metaKey || event.originalEvent.ctrlKey;
        var sortableDisabledFields = event.sortableDisabledFields;
        multiSortMeta = _toConsumableArray(this.getMultiSortMeta() || []);
        var sortMeta = multiSortMeta.find(function (sortMeta) {
          return sortMeta.field === sortField;
        });
        sortOrder = sortMeta ? this.getCalculatedSortOrder(sortMeta.order) : sortOrder;
        var newMetaData = {
          field: sortField,
          order: sortOrder
        };

        if (sortOrder) {
          multiSortMeta = metaKey ? multiSortMeta : multiSortMeta.filter(function (meta) {
            return sortableDisabledFields.some(function (field) {
              return field === meta.field;
            });
          });
          this.addSortMeta(newMetaData, multiSortMeta);
        } else if (this.props.removableSort) {
          this.removeSortMeta(newMetaData, multiSortMeta);
        }

        eventMeta = {
          multiSortMeta: multiSortMeta
        };
      } else {
        sortOrder = this.getSortField() === sortField ? this.getCalculatedSortOrder(this.getSortOrder()) : sortOrder;

        if (this.props.removableSort) {
          sortField = sortOrder ? sortField : null;
        }

        eventMeta = {
          sortField: sortField,
          sortOrder: sortOrder
        };
      }

      if (this.props.onSort) {
        this.props.onSort(eventMeta);
      } else {
        eventMeta.first = 0;
        this.setState(eventMeta);
      }

      if (this.props.onValueChange) {
        this.props.onValueChange(this.processData({
          sortField: sortField,
          sortOrder: sortOrder,
          multiSortMeta: multiSortMeta
        }));
      }
    }
  }, {
    key: "getCalculatedSortOrder",
    value: function getCalculatedSortOrder(currentOrder) {
      return this.props.removableSort ? this.props.defaultSortOrder === currentOrder ? currentOrder * -1 : 0 : currentOrder * -1;
    }
  }, {
    key: "addSortMeta",
    value: function addSortMeta(meta, multiSortMeta) {
      var index = -1;

      for (var i = 0; i < multiSortMeta.length; i++) {
        if (multiSortMeta[i].field === meta.field) {
          index = i;
          break;
        }
      }

      if (index >= 0) multiSortMeta[index] = meta;else multiSortMeta.push(meta);
    }
  }, {
    key: "removeSortMeta",
    value: function removeSortMeta(meta, multiSortMeta) {
      var index = -1;

      for (var i = 0; i < multiSortMeta.length; i++) {
        if (multiSortMeta[i].field === meta.field) {
          index = i;
          break;
        }
      }

      if (index >= 0) {
        multiSortMeta.splice(index, 1);
      }

      multiSortMeta = multiSortMeta.length > 0 ? multiSortMeta : null;
    }
  }, {
    key: "sortSingle",
    value: function sortSingle(data, sortField, sortOrder) {
      var value = _toConsumableArray(data);

      if (this.columnSortable && this.columnSortFunction) {
        value = this.columnSortFunction({
          field: this.getSortField(),
          order: this.getSortOrder()
        });
      } else {
        value.sort(function (data1, data2) {
          var value1 = ObjectUtils.resolveFieldData(data1, sortField);
          var value2 = ObjectUtils.resolveFieldData(data2, sortField);
          var result = null;
          if (value1 == null && value2 != null) result = -1;else if (value1 != null && value2 == null) result = 1;else if (value1 == null && value2 == null) result = 0;else if (typeof value1 === 'string' && typeof value2 === 'string') result = value1.localeCompare(value2, undefined, {
            numeric: true
          });else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
          return sortOrder * result;
        });
      }

      return value;
    }
  }, {
    key: "sortMultiple",
    value: function sortMultiple(data, multiSortMeta) {
      var _this3 = this;

      var value = _toConsumableArray(data);

      if (this.columnSortable && this.columnSortFunction) {
        var meta = multiSortMeta.find(function (meta) {
          return meta.field === _this3.columnField;
        });
        var field = this.columnField;
        var order = meta ? meta.order : this.defaultSortOrder;
        value = this.columnSortFunction({
          field: field,
          order: order
        });
      } else {
        value.sort(function (data1, data2) {
          return _this3.multisortField(data1, data2, multiSortMeta, 0);
        });
      }

      return value;
    }
  }, {
    key: "multisortField",
    value: function multisortField(data1, data2, multiSortMeta, index) {
      var value1 = ObjectUtils.resolveFieldData(data1, multiSortMeta[index].field);
      var value2 = ObjectUtils.resolveFieldData(data2, multiSortMeta[index].field);
      var result = null;

      if (typeof value1 === 'string' || value1 instanceof String) {
        if (value1.localeCompare && value1 !== value2) {
          return multiSortMeta[index].order * value1.localeCompare(value2, undefined, {
            numeric: true
          });
        }
      } else {
        result = value1 < value2 ? -1 : 1;
      }

      if (value1 === value2) {
        return multiSortMeta.length - 1 > index ? this.multisortField(data1, data2, multiSortMeta, index + 1) : 0;
      }

      return multiSortMeta[index].order * result;
    }
  }, {
    key: "filter",
    value: function filter(value, field, mode) {
      this.onFilter({
        value: value,
        field: field,
        matchMode: mode
      });
    }
  }, {
    key: "onFilter",
    value: function onFilter(event) {
      var currentFilters = this.getFilters();
      var newFilters = currentFilters ? _objectSpread$r({}, currentFilters) : {};
      if (!this.isFilterBlank(event.value)) newFilters[event.field] = {
        value: event.value,
        matchMode: event.matchMode
      };else if (newFilters[event.field]) delete newFilters[event.field];

      if (this.props.onFilter) {
        this.props.onFilter({
          filters: newFilters
        });
      } else {
        this.setState({
          first: 0,
          filters: newFilters
        });
      }

      if (this.props.onValueChange) {
        this.props.onValueChange(this.processData({
          filters: newFilters
        }));
      }
    }
  }, {
    key: "hasFilter",
    value: function hasFilter() {
      var filters = this.getFilters() || this.props.globalFilter;
      return filters && Object.keys(filters).length > 0;
    }
  }, {
    key: "isFilterBlank",
    value: function isFilterBlank(filter) {
      if (filter !== null && filter !== undefined) {
        if (typeof filter === 'string' && filter.trim().length === 0 || filter instanceof Array && filter.length === 0) return true;else return false;
      }

      return true;
    }
  }, {
    key: "hasFooter",
    value: function hasFooter() {
      if (this.props.children) {
        if (this.props.footerColumnGroup) {
          return true;
        } else {
          return this.hasChildrenFooter(this.props.children);
        }
      } else {
        return false;
      }
    }
  }, {
    key: "hasChildrenFooter",
    value: function hasChildrenFooter(children) {
      var hasFooter = false;

      if (children) {
        if (children instanceof Array) {
          for (var i = 0; i < children.length; i++) {
            hasFooter = hasFooter || this.hasChildrenFooter(children[i]);
          }
        } else {
          return children.props && children.props.footer !== null;
        }
      }

      return hasFooter;
    }
  }, {
    key: "onColumnResizeStart",
    value: function onColumnResizeStart(event) {
      var containerLeft = DomHandler.getOffset(this.container).left;
      this.resizeColumn = event.columnEl;
      this.resizeColumnProps = event.columnProps;
      this.columnResizing = true;
      this.lastResizerHelperX = event.originalEvent.pageX - containerLeft + this.container.scrollLeft;
      this.bindColumnResizeEvents();
    }
  }, {
    key: "onColumnResize",
    value: function onColumnResize(event) {
      var containerLeft = DomHandler.getOffset(this.container).left;
      DomHandler.addClass(this.container, 'p-unselectable-text');
      this.resizerHelper.style.height = this.container.offsetHeight + 'px';
      this.resizerHelper.style.top = 0 + 'px';
      this.resizerHelper.style.left = event.pageX - containerLeft + this.container.scrollLeft + 'px';
      this.resizerHelper.style.display = 'block';
    }
  }, {
    key: "onColumnResizeEnd",
    value: function onColumnResizeEnd(event) {
      var delta = this.resizerHelper.offsetLeft - this.lastResizerHelperX;
      var columnWidth = this.resizeColumn.offsetWidth;
      var newColumnWidth = columnWidth + delta;
      var minWidth = this.resizeColumn.style.minWidth || 15;

      if (columnWidth + delta > parseInt(minWidth, 10)) {
        if (this.props.columnResizeMode === 'fit') {
          var nextColumn = this.resizeColumn.nextElementSibling;
          var nextColumnWidth = nextColumn.offsetWidth - delta;

          if (newColumnWidth > 15 && nextColumnWidth > 15) {
            if (this.props.scrollable) {
              var scrollableView = this.findParentScrollableView(this.resizeColumn);
              var scrollableBodyTable = DomHandler.findSingle(scrollableView, 'table.p-datatable-scrollable-body-table');
              var scrollableHeaderTable = DomHandler.findSingle(scrollableView, 'table.p-datatable-scrollable-header-table');
              var scrollableFooterTable = DomHandler.findSingle(scrollableView, 'table.p-datatable-scrollable-footer-table');
              var resizeColumnIndex = DomHandler.index(this.resizeColumn);
              this.resizeColGroup(scrollableHeaderTable, resizeColumnIndex, newColumnWidth, nextColumnWidth);
              this.resizeColGroup(scrollableBodyTable, resizeColumnIndex, newColumnWidth, nextColumnWidth);
              this.resizeColGroup(scrollableFooterTable, resizeColumnIndex, newColumnWidth, nextColumnWidth);
            } else {
              this.resizeColumn.style.width = newColumnWidth + 'px';

              if (nextColumn) {
                nextColumn.style.width = nextColumnWidth + 'px';
              }
            }
          }
        } else if (this.props.columnResizeMode === 'expand') {
          if (this.props.scrollable) {
            this.setScrollableItemsWidthOnExpandResize(this.resizeColumn, newColumnWidth, delta);
          } else {
            this.table.style.width = this.table.offsetWidth + delta + 'px';
            this.resizeColumn.style.width = newColumnWidth + 'px';
          }
        }

        if (this.props.onColumnResizeEnd) {
          this.props.onColumnResizeEnd({
            element: this.resizeColumn,
            column: this.resizeColumnProps,
            delta: delta
          });
        }

        if (this.isStateful()) {
          this.saveState();
        }
      }

      this.resizerHelper.style.display = 'none';
      this.resizeColumn = null;
      this.resizeColumnProps = null;
      DomHandler.removeClass(this.container, 'p-unselectable-text');
      this.unbindColumnResizeEvents();
    }
  }, {
    key: "setScrollableItemsWidthOnExpandResize",
    value: function setScrollableItemsWidthOnExpandResize(column, newColumnWidth, delta) {
      var scrollableView = column ? this.findParentScrollableView(column) : this.container;
      var scrollableBody = DomHandler.findSingle(scrollableView, '.p-datatable-scrollable-body');
      var scrollableHeader = DomHandler.findSingle(scrollableView, '.p-datatable-scrollable-header');
      var scrollableFooter = DomHandler.findSingle(scrollableView, '.p-datatable-scrollable-footer');
      var scrollableBodyTable = DomHandler.findSingle(scrollableBody, 'table.p-datatable-scrollable-body-table');
      var scrollableHeaderTable = DomHandler.findSingle(scrollableHeader, 'table.p-datatable-scrollable-header-table');
      var scrollableFooterTable = DomHandler.findSingle(scrollableFooter, 'table.p-datatable-scrollable-footer-table');
      var scrollableBodyTableWidth = column ? scrollableBodyTable.offsetWidth + delta : newColumnWidth;
      var scrollableHeaderTableWidth = column ? scrollableHeaderTable.offsetWidth + delta : newColumnWidth;
      var isContainerInViewport = this.container.offsetWidth >= scrollableBodyTableWidth;

      var setWidth = function setWidth(container, table, width, isContainerInViewport) {
        if (container && table) {
          container.style.width = isContainerInViewport ? width + DomHandler.calculateScrollbarWidth(scrollableBody) + 'px' : 'auto';
          table.style.width = width + 'px';
        }
      };

      setWidth(scrollableBody, scrollableBodyTable, scrollableBodyTableWidth, isContainerInViewport);
      setWidth(scrollableHeader, scrollableHeaderTable, scrollableHeaderTableWidth, isContainerInViewport);
      setWidth(scrollableFooter, scrollableFooterTable, scrollableHeaderTableWidth, isContainerInViewport);

      if (column) {
        var resizeColumnIndex = DomHandler.index(column);
        this.resizeColGroup(scrollableHeaderTable, resizeColumnIndex, newColumnWidth, null);
        this.resizeColGroup(scrollableBodyTable, resizeColumnIndex, newColumnWidth, null);
        this.resizeColGroup(scrollableFooterTable, resizeColumnIndex, newColumnWidth, null);
      }
    }
  }, {
    key: "findParentScrollableView",
    value: function findParentScrollableView(column) {
      if (column) {
        var parent = column.parentElement;

        while (parent && !DomHandler.hasClass(parent, 'p-datatable-scrollable-view')) {
          parent = parent.parentElement;
        }

        return parent;
      } else {
        return null;
      }
    }
  }, {
    key: "resizeColGroup",
    value: function resizeColGroup(table, resizeColumnIndex, newColumnWidth, nextColumnWidth) {
      if (table) {
        var colGroup = table.children[0].nodeName === 'COLGROUP' ? table.children[0] : null;

        if (colGroup) {
          var col = colGroup.children[resizeColumnIndex];
          var nextCol = col.nextElementSibling;
          col.style.width = newColumnWidth + 'px';

          if (nextCol && nextColumnWidth) {
            nextCol.style.width = nextColumnWidth + 'px';
          }
        } else {
          throw new Error("Scrollable tables require a colgroup to support resizable columns");
        }
      }
    }
  }, {
    key: "bindColumnResizeEvents",
    value: function bindColumnResizeEvents() {
      var _this4 = this;

      this.documentColumnResizeListener = document.addEventListener('mousemove', function (event) {
        if (_this4.columnResizing) {
          _this4.onColumnResize(event);
        }
      });
      this.documentColumnResizeEndListener = document.addEventListener('mouseup', function (event) {
        if (_this4.columnResizing) {
          _this4.columnResizing = false;

          _this4.onColumnResizeEnd(event);
        }
      });
    }
  }, {
    key: "unbindColumnResizeEvents",
    value: function unbindColumnResizeEvents() {
      document.removeEventListener('document', this.documentColumnResizeListener);
      document.removeEventListener('document', this.documentColumnResizeEndListener);
    }
  }, {
    key: "findParentHeader",
    value: function findParentHeader(element) {
      if (element.nodeName === 'TH') {
        return element;
      } else {
        var parent = element.parentElement;

        while (parent.nodeName !== 'TH') {
          parent = parent.parentElement;
          if (!parent) break;
        }

        return parent;
      }
    }
  }, {
    key: "onColumnDragStart",
    value: function onColumnDragStart(e) {
      var event = e.originalEvent,
          column = e.column;

      if (this.columnResizing) {
        event.preventDefault();
        return;
      }

      this.iconWidth = DomHandler.getHiddenElementOuterWidth(this.reorderIndicatorUp);
      this.iconHeight = DomHandler.getHiddenElementOuterHeight(this.reorderIndicatorUp);
      this.draggedColumnEl = this.findParentHeader(event.currentTarget);
      this.draggedColumn = column;
      event.dataTransfer.setData('text', 'b'); // Firefox requires this to make dragging possible
    }
  }, {
    key: "onColumnDragOver",
    value: function onColumnDragOver(e) {
      var event = e.originalEvent;
      var dropHeader = this.findParentHeader(event.currentTarget);

      if (this.props.reorderableColumns && this.draggedColumnEl && dropHeader) {
        event.preventDefault();
        var containerOffset = DomHandler.getOffset(this.container);
        var dropHeaderOffset = DomHandler.getOffset(dropHeader);

        if (this.draggedColumnEl !== dropHeader) {
          var targetLeft = dropHeaderOffset.left - containerOffset.left; //let targetTop =  containerOffset.top - dropHeaderOffset.top;

          var columnCenter = dropHeaderOffset.left + dropHeader.offsetWidth / 2;
          this.reorderIndicatorUp.style.top = dropHeaderOffset.top - containerOffset.top - (this.iconHeight - 1) + 'px';
          this.reorderIndicatorDown.style.top = dropHeaderOffset.top - containerOffset.top + dropHeader.offsetHeight + 'px';

          if (event.pageX > columnCenter) {
            this.reorderIndicatorUp.style.left = targetLeft + dropHeader.offsetWidth - Math.ceil(this.iconWidth / 2) + 'px';
            this.reorderIndicatorDown.style.left = targetLeft + dropHeader.offsetWidth - Math.ceil(this.iconWidth / 2) + 'px';
            this.dropPosition = 1;
          } else {
            this.reorderIndicatorUp.style.left = targetLeft - Math.ceil(this.iconWidth / 2) + 'px';
            this.reorderIndicatorDown.style.left = targetLeft - Math.ceil(this.iconWidth / 2) + 'px';
            this.dropPosition = -1;
          }

          this.reorderIndicatorUp.style.display = 'block';
          this.reorderIndicatorDown.style.display = 'block';
        }
      }
    }
  }, {
    key: "onColumnDragLeave",
    value: function onColumnDragLeave(e) {
      var event = e.originalEvent;

      if (this.props.reorderableColumns && this.draggedColumnEl) {
        event.preventDefault();
        this.reorderIndicatorUp.style.display = 'none';
        this.reorderIndicatorDown.style.display = 'none';
      }
    }
  }, {
    key: "onColumnDrop",
    value: function onColumnDrop(e) {
      var _this5 = this;

      var event = e.originalEvent,
          column = e.column;
      event.preventDefault();

      if (this.draggedColumnEl) {
        var dragIndex = DomHandler.index(this.draggedColumnEl);
        var dropIndex = DomHandler.index(this.findParentHeader(event.currentTarget));
        var allowDrop = dragIndex !== dropIndex;

        if (allowDrop && (dropIndex - dragIndex === 1 && this.dropPosition === -1 || dragIndex - dropIndex === 1 && this.dropPosition === 1)) {
          allowDrop = false;
        }

        if (allowDrop) {
          var columns = this.state.columnOrder ? this.getColumns() : React__default['default'].Children.toArray(this.props.children);

          var isSameColumn = function isSameColumn(col1, col2) {
            return col1.columnKey || col2.columnKey ? ObjectUtils.equals(col1, col2, 'columnKey') : ObjectUtils.equals(col1, col2, 'field');
          };

          var dragColIndex = columns.findIndex(function (child) {
            return isSameColumn(child.props, _this5.draggedColumn);
          });
          var dropColIndex = columns.findIndex(function (child) {
            return isSameColumn(child.props, column);
          });

          if (dropColIndex < dragColIndex && this.dropPosition === 1) {
            dropColIndex++;
          }

          if (dropColIndex > dragColIndex && this.dropPosition === -1) {
            dropColIndex--;
          }

          ObjectUtils.reorderArray(columns, dragColIndex, dropColIndex);
          var columnOrder = [];

          var _iterator = _createForOfIteratorHelper$b(columns),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var _column = _step.value;
              columnOrder.push(_column.props.columnKey || _column.props.field);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          this.setState({
            columnOrder: columnOrder
          });

          if (this.props.onColReorder) {
            this.props.onColReorder({
              originalEvent: event,
              dragIndex: dragColIndex,
              dropIndex: dropColIndex,
              columns: columns
            });
          }
        }

        this.reorderIndicatorUp.style.display = 'none';
        this.reorderIndicatorDown.style.display = 'none';
        this.draggedColumnEl.draggable = false;
        this.draggedColumnEl = null;
        this.dropPosition = null;
      }
    }
  }, {
    key: "onVirtualScroll",
    value: function onVirtualScroll(event) {
      var _this6 = this;

      if (this.virtualScrollTimer) {
        clearTimeout(this.virtualScrollTimer);
      }

      this.virtualScrollTimer = setTimeout(function () {
        if (_this6.props.onVirtualScroll) {
          _this6.props.onVirtualScroll({
            first: (event.page - 1) * _this6.props.rows,
            rows: _this6.props.virtualScroll ? _this6.props.rows * 2 : _this6.props.rows
          });
        }
      }, this.props.virtualScrollDelay);
    }
  }, {
    key: "hasEditingCell",
    value: function hasEditingCell() {
      return this.state.editingCells && this.state.editingCells.length !== 0;
    }
  }, {
    key: "onEditingCellChange",
    value: function onEditingCellChange(event) {
      var _this7 = this;

      var rowIndex = event.rowIndex,
          cellIndex = event.cellIndex,
          editing = event.editing;

      var editingCells = _toConsumableArray(this.state.editingCells);

      if (editing) editingCells.push({
        rowIndex: rowIndex,
        cellIndex: cellIndex
      });else editingCells = editingCells.filter(function (cell) {
        return !(cell.rowIndex === rowIndex && cell.cellIndex === cellIndex);
      });
      this.setState({
        editingCells: editingCells
      }, function () {
        _this7.props.onValueChange && _this7.props.onValueChange(_this7.processData());
      });
    }
  }, {
    key: "exportCSV",
    value: function exportCSV(options) {
      var _this8 = this;

      var data;
      var csv = "\uFEFF";
      var columns = this.getColumns();

      if (options && options.selectionOnly) {
        data = this.props.selection || [];
      } else {
        data = [].concat(_toConsumableArray(this.props.frozenValue || []), _toConsumableArray(this.processData() || []));
      } //headers


      columns.forEach(function (column, i) {
        var _column$props = column.props,
            field = _column$props.field,
            header = _column$props.header,
            exportable = _column$props.exportable;

        if (exportable && field) {
          csv += '"' + (header || field) + '"';

          if (i < columns.length - 1) {
            csv += _this8.props.csvSeparator;
          }
        }
      }); //body

      data.forEach(function (record) {
        csv += '\n';
        columns.forEach(function (column, i) {
          var _column$props2 = column.props,
              field = _column$props2.field,
              exportable = _column$props2.exportable;

          if (exportable && field) {
            var cellData = ObjectUtils.resolveFieldData(record, field);
            if (cellData != null) cellData = _this8.props.exportFunction ? _this8.props.exportFunction({
              data: cellData,
              field: field
            }) : String(cellData).replace(/"/g, '""');else cellData = '';
            csv += '"' + cellData + '"';

            if (i < columns.length - 1) {
              csv += _this8.props.csvSeparator;
            }
          }
        });
      });
      var blob = new Blob([csv], {
        type: 'application/csv;charset=utf-8;'
      });

      if (window.navigator.msSaveOrOpenBlob) {
        navigator.msSaveOrOpenBlob(blob, this.props.exportFilename + '.csv');
      } else {
        var link = document.createElement("a");

        if (link.download !== undefined) {
          link.setAttribute('href', URL.createObjectURL(blob));
          link.setAttribute('download', this.props.exportFilename + '.csv');
          link.style.display = 'none';
          document.body.appendChild(link);
          link.click();
          document.body.removeChild(link);
        } else {
          csv = 'data:text/csv;charset=utf-8,' + csv;
          window.open(encodeURI(csv));
        }
      }
    }
  }, {
    key: "closeEditingCell",
    value: function closeEditingCell() {
      if (this.props.editMode !== "row") {
        document.body.click();
      }
    }
  }, {
    key: "onHeaderCheckboxClick",
    value: function onHeaderCheckboxClick(event) {
      var originalEvent = event.originalEvent;
      var selection;

      if (!event.checked) {
        var visibleData = this.hasFilter() ? this.processData() : this.props.value;
        selection = _toConsumableArray(visibleData);
        this.props.onAllRowsSelect && this.props.onAllRowsSelect({
          originalEvent: originalEvent,
          data: selection,
          type: 'all'
        });
      } else {
        selection = [];
        this.props.onAllRowsUnselect && this.props.onAllRowsUnselect({
          originalEvent: originalEvent,
          data: selection,
          type: 'all'
        });
      }

      if (this.props.onSelectionChange) {
        this.props.onSelectionChange({
          originalEvent: originalEvent,
          value: selection
        });
      }
    }
  }, {
    key: "filterLocal",
    value: function filterLocal(value, localFilters) {
      var filteredValue = [];
      var filters = localFilters || this.getFilters();
      var columns = React__default['default'].Children.toArray(this.props.children);

      for (var i = 0; i < value.length; i++) {
        var localMatch = true;
        var globalMatch = false;

        for (var j = 0; j < columns.length; j++) {
          var col = columns[j];
          var columnField = col.props.filterField || col.props.field;
          var filterMeta = filters ? filters[columnField] : null; //local

          if (filterMeta) {
            var filterValue = filterMeta.value;
            var dataFieldValue = ObjectUtils.resolveFieldData(value[i], columnField);
            var filterMatchMode = filterMeta.matchMode || col.props.filterMatchMode;
            var filterConstraint = filterMatchMode === 'custom' ? col.props.filterFunction : FilterUtils[filterMatchMode];
            var options = {
              rowData: value[i],
              filters: filters,
              props: this.props,
              column: {
                filterMeta: filterMeta,
                filterField: columnField,
                props: col.props
              }
            };

            if (filterConstraint !== null && !filterConstraint(dataFieldValue, filterValue, this.props.filterLocale, options)) {
              localMatch = false;
            }

            if (!localMatch) {
              break;
            }
          }

          if (!col.props.excludeGlobalFilter && this.props.globalFilter && !globalMatch) {
            globalMatch = FilterUtils['contains'](ObjectUtils.resolveFieldData(value[i], columnField), this.props.globalFilter, this.props.filterLocale);
          }
        }

        var matches = localMatch;

        if (this.props.globalFilter) {
          matches = localMatch && globalMatch;
        }

        if (matches) {
          filteredValue.push(value[i]);
        }
      }

      if (filteredValue.length === value.length) {
        filteredValue = value;
      }

      return filteredValue;
    }
  }, {
    key: "processData",
    value: function processData(localState) {
      var data = this.props.value;

      if (!this.props.lazy && !this.hasEditingCell()) {
        if (data && data.length) {
          var sortField = localState && localState.sortField || this.getSortField();
          var sortOrder = localState && localState.sortOrder || this.getSortOrder();
          var multiSortMeta = localState && localState.multiSortMeta || this.getMultiSortMeta();

          if (sortField || multiSortMeta && multiSortMeta.length) {
            if (this.props.sortMode === 'single') data = this.sortSingle(data, sortField, sortOrder);else if (this.props.sortMode === 'multiple') data = this.sortMultiple(data, multiSortMeta);
          }

          var localFilters = localState && localState.filters || this.getFilters();

          if (localFilters || this.props.globalFilter) {
            data = this.filterLocal(data, localFilters);
          }
        }
      }

      return data;
    }
  }, {
    key: "isAllSelected",
    value: function isAllSelected() {
      var visibleData = this.hasFilter() ? this.processData() : this.props.value;

      if (this.props.lazy) {
        return this.props.selection && this.props.totalRecords && this.props.selection.length === this.props.totalRecords;
      }

      return this.props.selection && visibleData && visibleData.length && this.props.selection.length === visibleData.length;
    }
  }, {
    key: "getFrozenColumns",
    value: function getFrozenColumns(columns) {
      var frozenColumns = null;

      var _iterator2 = _createForOfIteratorHelper$b(columns),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var col = _step2.value;

          if (col.props.frozen) {
            frozenColumns = frozenColumns || [];
            frozenColumns.push(col);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return frozenColumns;
    }
  }, {
    key: "getScrollableColumns",
    value: function getScrollableColumns(columns) {
      var scrollableColumns = null;

      var _iterator3 = _createForOfIteratorHelper$b(columns),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var col = _step3.value;

          if (!col.props.frozen) {
            scrollableColumns = scrollableColumns || [];
            scrollableColumns.push(col);
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return scrollableColumns;
    }
  }, {
    key: "getSelectionModeInColumn",
    value: function getSelectionModeInColumn(columns) {
      if (Array.isArray(columns)) {
        var _iterator4 = _createForOfIteratorHelper$b(columns),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var col = _step4.value;
            if (col.props.selectionMode) return col.props.selectionMode;
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }

      return null;
    }
  }, {
    key: "createTableHeader",
    value: function createTableHeader(value, columns, columnGroup) {
      return /*#__PURE__*/React__default['default'].createElement(TableHeader, {
        value: value,
        sortMode: this.props.sortMode,
        onSort: this.onSort,
        sortField: this.getSortField(),
        sortOrder: this.getSortOrder(),
        multiSortMeta: this.getMultiSortMeta(),
        columnGroup: columnGroup,
        resizableColumns: this.props.resizableColumns,
        onColumnResizeStart: this.onColumnResizeStart,
        onColumnResizerClick: this.props.onColumnResizerClick,
        onColumnResizerDoubleClick: this.props.onColumnResizerDoubleClick,
        onFilter: this.onFilter,
        filterDelay: this.props.filterDelay,
        onHeaderCheckboxClick: this.onHeaderCheckboxClick,
        headerCheckboxSelected: this.isAllSelected(),
        reorderableColumns: this.props.reorderableColumns,
        onColumnDragStart: this.onColumnDragStart,
        filters: this.getFilters(),
        onColumnDragOver: this.onColumnDragOver,
        onColumnDragLeave: this.onColumnDragLeave,
        onColumnDrop: this.onColumnDrop,
        tabIndex: this.props.tabIndex
      }, columns);
    }
  }, {
    key: "createTableBody",
    value: function createTableBody(value, columns, frozen, selectionModeInColumn) {
      return /*#__PURE__*/React__default['default'].createElement(TableBody, {
        tableId: this.props.id,
        value: value,
        first: this.getFirst(),
        rows: this.getRows(),
        lazy: this.props.lazy,
        paginator: this.props.paginator,
        dataKey: this.props.dataKey,
        compareSelectionBy: this.props.compareSelectionBy,
        selectionMode: this.props.selectionMode,
        selection: this.props.selection,
        metaKeySelection: this.props.metaKeySelection,
        frozen: frozen,
        selectionModeInColumn: selectionModeInColumn,
        onSelectionChange: this.props.onSelectionChange,
        onRowClick: this.props.onRowClick,
        onRowDoubleClick: this.props.onRowDoubleClick,
        onRowSelect: this.props.onRowSelect,
        onRowUnselect: this.props.onRowUnselect,
        contextMenuSelection: this.props.contextMenuSelection,
        onContextMenuSelectionChange: this.props.onContextMenuSelectionChange,
        onContextMenu: this.props.onContextMenu,
        expandedRows: this.props.expandedRows,
        onRowToggle: this.props.onRowToggle,
        rowExpansionTemplate: this.props.rowExpansionTemplate,
        selectOnEdit: this.props.selectOnEdit,
        onRowExpand: this.props.onRowExpand,
        onRowCollapse: this.props.onRowCollapse,
        emptyMessage: this.props.emptyMessage,
        virtualScroll: this.props.virtualScroll,
        virtualRowHeight: this.props.virtualRowHeight,
        loading: this.props.loading,
        groupField: this.props.groupField,
        rowGroupMode: this.props.rowGroupMode,
        rowGroupHeaderTemplate: this.props.rowGroupHeaderTemplate,
        rowGroupFooterTemplate: this.props.rowGroupFooterTemplate,
        sortField: this.getSortField(),
        rowClassName: this.props.rowClassName,
        cellClassName: this.props.cellClassName,
        onRowReorder: this.props.onRowReorder,
        editMode: this.props.editMode,
        editingRows: this.props.editingRows,
        rowEditorValidator: this.props.rowEditorValidator,
        onRowEditInit: this.props.onRowEditInit,
        onRowEditSave: this.props.onRowEditSave,
        onRowEditCancel: this.props.onRowEditCancel,
        onRowEditChange: this.props.onRowEditChange,
        expandableRowGroups: this.props.expandableRowGroups,
        showRowReorderElement: this.props.showRowReorderElement,
        showSelectionElement: this.props.showSelectionElement,
        dragSelection: this.props.dragSelection,
        cellSelection: this.props.cellSelection,
        onCellClick: this.props.onCellClick,
        onCellSelect: this.props.onCellSelect,
        onCellUnselect: this.props.onCellUnselect,
        onEditingCellChange: this.onEditingCellChange
      }, columns);
    }
  }, {
    key: "createTableLoadingBody",
    value: function createTableLoadingBody(columns) {
      if (this.props.virtualScroll) {
        return /*#__PURE__*/React__default['default'].createElement(TableLoadingBody, {
          columns: columns,
          rows: this.getRows()
        });
      } else {
        return null;
      }
    }
  }, {
    key: "createTableFooter",
    value: function createTableFooter(columns, columnGroup) {
      if (this.hasFooter()) return /*#__PURE__*/React__default['default'].createElement(TableFooter, {
        columnGroup: columnGroup
      }, columns);else return null;
    }
  }, {
    key: "createScrollableView",
    value: function createScrollableView(value, columns, frozen, headerColumnGroup, footerColumnGroup, totalRecords, selectionModeInColumn) {
      return /*#__PURE__*/React__default['default'].createElement(ScrollableView, {
        columns: columns,
        header: this.createTableHeader(value, columns, headerColumnGroup),
        body: this.createTableBody(value, columns, frozen, selectionModeInColumn),
        loadingBody: this.createTableLoadingBody(columns),
        frozenBody: this.props.frozenValue ? this.createTableBody(this.props.frozenValue, columns, true, selectionModeInColumn) : null,
        footer: this.createTableFooter(columns, footerColumnGroup),
        tableStyle: this.props.tableStyle,
        tableClassName: this.props.tableClassName,
        scrollHeight: this.props.scrollHeight,
        frozen: frozen,
        frozenWidth: this.props.frozenWidth,
        virtualScroll: this.props.virtualScroll,
        virtualRowHeight: this.props.virtualRowHeight,
        rows: this.props.rows,
        totalRecords: totalRecords,
        onVirtualScroll: this.onVirtualScroll,
        loading: this.props.loading
      });
    }
  }, {
    key: "getColumns",
    value: function getColumns() {
      var columns = React__default['default'].Children.toArray(this.props.children);

      if (columns && columns.length) {
        if (this.props.reorderableColumns && this.state.columnOrder) {
          var orderedColumns = [];

          var _iterator5 = _createForOfIteratorHelper$b(this.state.columnOrder),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var columnKey = _step5.value;
              var column = this.findColumnByKey(columns, columnKey);

              if (column) {
                orderedColumns.push(column);
              }
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }

          return [].concat(orderedColumns, _toConsumableArray(columns.filter(function (item) {
            return orderedColumns.indexOf(item) < 0;
          })));
        } else {
          return columns;
        }
      }

      return null;
    }
  }, {
    key: "findColumnByKey",
    value: function findColumnByKey(columns, key) {
      if (columns && columns.length) {
        for (var i = 0; i < columns.length; i++) {
          var child = columns[i];

          if (child.props.columnKey === key || child.props.field === key) {
            return child;
          }
        }
      }

      return null;
    }
  }, {
    key: "getTotalRecords",
    value: function getTotalRecords(data) {
      return this.props.lazy ? this.props.totalRecords : data ? data.length : 0;
    }
  }, {
    key: "reset",
    value: function reset() {
      var state = {};

      if (!this.props.onPage) {
        state.first = this.props.first;
        state.rows = this.props.rows;
      }

      if (!this.props.onSort) {
        state.sortField = this.props.sortField;
        state.sortOrder = this.props.sortOrder;
        state.multiSortMeta = this.props.multiSortMeta;
      }

      if (!this.props.onFilter) {
        state.filters = this.props.filters;
      }

      this.resetColumnOrder();

      if (Object.keys(state).length) {
        this.setState(state);
      }
    }
  }, {
    key: "resetColumnOrder",
    value: function resetColumnOrder() {
      var columns = React__default['default'].Children.toArray(this.props.children);
      var columnOrder = [];

      var _iterator6 = _createForOfIteratorHelper$b(columns),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var column = _step6.value;
          columnOrder.push(column.props.columnKey || column.props.field);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      this.setState({
        columnOrder: columnOrder
      });
    }
  }, {
    key: "renderLoader",
    value: function renderLoader() {
      var iconClassName = classNames('p-datatable-loading-icon pi-spin', this.props.loadingIcon);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-loading-overlay p-component-overlay"
      }, /*#__PURE__*/React__default['default'].createElement("i", {
        className: iconClassName
      }));
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.isStateful() && this.props.resizableColumns) {
        this.restoreColumnWidths();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (this.isStateful()) {
        this.saveState();
      }

      if (prevProps.globalFilter !== this.props.globalFilter) {
        this.filter(this.props.globalFilter, 'globalFilter', 'contains');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this9 = this;

      var value = this.processData();
      var columns = this.getColumns();
      var totalRecords = this.getTotalRecords(value);
      var selectionModeInColumn = this.getSelectionModeInColumn(columns);
      var className = classNames('p-datatable p-component', {
        'p-datatable-resizable': this.props.resizableColumns,
        'p-datatable-resizable-fit': this.props.resizableColumns && this.props.columnResizeMode === 'fit',
        'p-datatable-scrollable': this.props.scrollable,
        'p-datatable-virtual-scrollable': this.props.virtualScroll,
        'p-datatable-striped': this.props.stripedRows,
        'p-datatable-gridlines': this.props.showGridlines,
        'p-datatable-auto-layout': this.props.autoLayout,
        'p-datatable-hoverable-rows': this.props.rowHover || this.props.selectionMode || selectionModeInColumn
      }, this.props.className);
      var paginatorTop = this.props.paginator && this.props.paginatorPosition !== 'bottom' && this.createPaginator('top', totalRecords);
      var paginatorBottom = this.props.paginator && this.props.paginatorPosition !== 'top' && this.createPaginator('bottom', totalRecords);
      var headerFacet = this.props.header && /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-header"
      }, this.props.header);
      var footerFacet = this.props.footer && /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-datatable-footer"
      }, this.props.footer);
      var resizeHelper = this.props.resizableColumns && /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          _this9.resizerHelper = el;
        },
        className: "p-column-resizer-helper p-highlight",
        style: {
          display: 'none'
        }
      });
      var tableContent = null;
      var resizeIndicatorUp = this.props.reorderableColumns && /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          _this9.reorderIndicatorUp = el;
        },
        className: "pi pi-arrow-down p-datatable-reorder-indicator-up",
        style: {
          position: 'absolute',
          display: 'none'
        }
      });
      var resizeIndicatorDown = this.props.reorderableColumns && /*#__PURE__*/React__default['default'].createElement("span", {
        ref: function ref(el) {
          _this9.reorderIndicatorDown = el;
        },
        className: "pi pi-arrow-up p-datatable-reorder-indicator-down",
        style: {
          position: 'absolute',
          display: 'none'
        }
      });
      var loader;

      if (this.props.loading) {
        loader = this.renderLoader();
      }

      if (Array.isArray(columns)) {
        if (this.props.scrollable) {
          var frozenColumns = this.getFrozenColumns(columns);
          var scrollableColumns = frozenColumns ? this.getScrollableColumns(columns) : columns;
          var frozenView, scrollableView;

          if (frozenColumns) {
            frozenView = this.createScrollableView(value, frozenColumns, true, this.props.frozenHeaderColumnGroup, this.props.frozenFooterColumnGroup, totalRecords, selectionModeInColumn);
          }

          scrollableView = this.createScrollableView(value, scrollableColumns, false, this.props.headerColumnGroup, this.props.footerColumnGroup, totalRecords, selectionModeInColumn);
          tableContent = /*#__PURE__*/React__default['default'].createElement("div", {
            className: "p-datatable-scrollable-wrapper"
          }, frozenView, scrollableView);
        } else {
          var tableHeader = this.createTableHeader(value, columns, this.props.headerColumnGroup);
          var tableBody = this.createTableBody(value, columns, false, selectionModeInColumn);
          var tableFooter = this.createTableFooter(columns, this.props.footerColumnGroup);
          tableContent = /*#__PURE__*/React__default['default'].createElement("div", {
            className: "p-datatable-wrapper"
          }, /*#__PURE__*/React__default['default'].createElement("table", {
            style: this.props.tableStyle,
            role: "grid",
            className: this.props.tableClassName,
            ref: function ref(el) {
              _this9.table = el;
            }
          }, tableHeader, tableFooter, tableBody));
        }
      }

      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        className: className,
        style: this.props.style,
        ref: function ref(el) {
          _this9.container = el;
        },
        "data-scrollselectors": ".p-datatable-scrollable-body, .p-datatable-unfrozen-view .p-datatable-scrollable-body"
      }, loader, headerFacet, paginatorTop, tableContent, paginatorBottom, footerFacet, resizeHelper, resizeIndicatorUp, resizeIndicatorDown);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.rows !== prevState.d_rows && !nextProps.onPage) {
        return {
          rows: nextProps.rows,
          d_rows: nextProps.rows
        };
      }

      return null;
    }
  }]);

  return DataTable;
}(React.Component);

_defineProperty(DataTable, "defaultProps", {
  id: null,
  value: null,
  header: null,
  footer: null,
  style: null,
  className: null,
  tableStyle: null,
  tableClassName: null,
  paginator: false,
  paginatorPosition: 'bottom',
  alwaysShowPaginator: true,
  paginatorClassName: null,
  paginatorTemplate: 'FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown',
  paginatorLeft: null,
  paginatorRight: null,
  paginatorDropdownAppendTo: null,
  pageLinkSize: 5,
  rowsPerPageOptions: null,
  currentPageReportTemplate: '({currentPage} of {totalPages})',
  first: 0,
  rows: null,
  totalRecords: null,
  lazy: false,
  sortField: null,
  sortOrder: null,
  multiSortMeta: null,
  sortMode: 'single',
  defaultSortOrder: 1,
  removableSort: false,
  emptyMessage: 'No records found',
  selectionMode: null,
  dragSelection: false,
  cellSelection: false,
  selection: null,
  onSelectionChange: null,
  contextMenuSelection: null,
  onContextMenuSelectionChange: null,
  compareSelectionBy: 'deepEquals',
  dataKey: null,
  metaKeySelection: true,
  selectOnEdit: true,
  headerColumnGroup: null,
  footerColumnGroup: null,
  frozenHeaderColumnGroup: null,
  frozenFooterColumnGroup: null,
  rowExpansionTemplate: null,
  expandedRows: null,
  onRowToggle: null,
  resizableColumns: false,
  columnResizeMode: 'fit',
  reorderableColumns: false,
  filters: null,
  globalFilter: null,
  filterDelay: 300,
  filterLocale: undefined,
  scrollable: false,
  scrollHeight: null,
  virtualScroll: false,
  virtualScrollDelay: 150,
  virtualRowHeight: 28,
  frozenWidth: null,
  frozenValue: null,
  csvSeparator: ',',
  exportFilename: 'download',
  rowGroupMode: null,
  autoLayout: false,
  rowClassName: null,
  cellClassName: null,
  rowGroupHeaderTemplate: null,
  rowGroupFooterTemplate: null,
  loading: false,
  loadingIcon: 'pi pi-spinner',
  tabIndex: 0,
  stateKey: null,
  stateStorage: 'session',
  groupField: null,
  editMode: 'cell',
  editingRows: null,
  expandableRowGroups: false,
  rowHover: false,
  showGridlines: false,
  stripedRows: false,
  showSelectionElement: null,
  showRowReorderElement: null,
  onColumnResizeEnd: null,
  onColumnResizerClick: null,
  onColumnResizerDoubleClick: null,
  onSort: null,
  onPage: null,
  onFilter: null,
  onVirtualScroll: null,
  onAllRowsSelect: null,
  onAllRowsUnselect: null,
  onRowClick: null,
  onRowDoubleClick: null,
  onRowSelect: null,
  onRowUnselect: null,
  onRowExpand: null,
  onRowCollapse: null,
  onContextMenu: null,
  onColReorder: null,
  onCellClick: null,
  onCellSelect: null,
  onCellUnselect: null,
  onRowReorder: null,
  onValueChange: null,
  rowEditorValidator: null,
  onRowEditInit: null,
  onRowEditSave: null,
  onRowEditCancel: null,
  onRowEditChange: null,
  exportFunction: null,
  customSaveState: null,
  customRestoreState: null,
  onStateSave: null,
  onStateRestore: null
});

function _createSuper$1p(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1p(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1p() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DataViewLayoutOptions = /*#__PURE__*/function (_Component) {
  _inherits(DataViewLayoutOptions, _Component);

  var _super = _createSuper$1p(DataViewLayoutOptions);

  function DataViewLayoutOptions(props) {
    var _this;

    _classCallCheck(this, DataViewLayoutOptions);

    _this = _super.call(this, props);
    _this.changeLayout = _this.changeLayout.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(DataViewLayoutOptions, [{
    key: "changeLayout",
    value: function changeLayout(event, layoutMode) {
      this.props.onChange({
        originalEvent: event,
        value: layoutMode
      });
      event.preventDefault();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var className = classNames('p-dataview-layout-options p-selectbutton p-buttonset', this.props.className);
      var buttonListClass = classNames('p-button p-button-icon-only', {
        'p-highlight': this.props.layout === 'list'
      });
      var buttonGridClass = classNames('p-button p-button-icon-only', {
        'p-highlight': this.props.layout === 'grid'
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        style: this.props.style,
        className: className
      }, /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: buttonListClass,
        onClick: function onClick(event) {
          return _this2.changeLayout(event, 'list');
        }
      }, /*#__PURE__*/React__default['default'].createElement("i", {
        className: "pi pi-bars"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)), /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: buttonGridClass,
        onClick: function onClick(event) {
          return _this2.changeLayout(event, 'grid');
        }
      }, /*#__PURE__*/React__default['default'].createElement("i", {
        className: "pi pi-th-large"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
    }
  }]);

  return DataViewLayoutOptions;
}(React.Component);

_defineProperty(DataViewLayoutOptions, "defaultProps", {
  id: null,
  style: null,
  className: null,
  layout: null,
  onChange: null
});

var DataViewItem = /*#__PURE__*/function (_Component2) {
  _inherits(DataViewItem, _Component2);

  var _super2 = _createSuper$1p(DataViewItem);

  function DataViewItem() {
    _classCallCheck(this, DataViewItem);

    return _super2.apply(this, arguments);
  }

  _createClass(DataViewItem, [{
    key: "render",
    value: function render() {
      return this.props.template(this.props.item, this.props.layout);
    }
  }]);

  return DataViewItem;
}(React.Component);

_defineProperty(DataViewItem, "defaultProps", {
  template: null,
  item: null,
  layout: null
});

var DataView = /*#__PURE__*/function (_Component3) {
  _inherits(DataView, _Component3);

  var _super3 = _createSuper$1p(DataView);

  function DataView(props) {
    var _this3;

    _classCallCheck(this, DataView);

    _this3 = _super3.call(this, props);

    if (!_this3.props.onPage) {
      _this3.state = {
        first: _this3.props.first,
        rows: _this3.props.rows
      };
    }

    _this3.sortChange = false;
    _this3.onPageChange = _this3.onPageChange.bind(_assertThisInitialized(_this3));
    return _this3;
  }

  _createClass(DataView, [{
    key: "getItemRenderKey",
    value: function getItemRenderKey(value) {
      return this.props.dataKey ? ObjectUtils.resolveFieldData(value, this.props.dataKey) : null;
    }
  }, {
    key: "getTotalRecords",
    value: function getTotalRecords() {
      if (this.props.totalRecords) return this.props.totalRecords;else return this.props.value ? this.props.value.length : 0;
    }
  }, {
    key: "createPaginator",
    value: function createPaginator(position) {
      var className = classNames('p-paginator-' + position, this.props.paginatorClassName);
      var first = this.props.onPage ? this.props.first : this.state.first;
      var rows = this.props.onPage ? this.props.rows : this.state.rows;
      var totalRecords = this.getTotalRecords();
      return /*#__PURE__*/React__default['default'].createElement(Paginator, {
        first: first,
        rows: rows,
        pageLinkSize: this.props.pageLinkSize,
        className: className,
        onPageChange: this.onPageChange,
        template: this.props.paginatorTemplate,
        totalRecords: totalRecords,
        rowsPerPageOptions: this.props.rowsPerPageOptions,
        currentPageReportTemplate: this.props.currentPageReportTemplate,
        leftContent: this.props.paginatorLeft,
        rightContent: this.props.paginatorRight,
        alwaysShow: this.props.alwaysShowPaginator,
        dropdownAppendTo: this.props.paginatorDropdownAppendTo
      });
    }
  }, {
    key: "onPageChange",
    value: function onPageChange(event) {
      if (this.props.onPage) {
        this.props.onPage(event);
      } else {
        this.setState({
          first: event.first,
          rows: event.rows
        });
      }
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return !this.props.value || this.props.value.length === 0;
    }
  }, {
    key: "sort",
    value: function sort() {
      var _this4 = this;

      if (this.props.value) {
        var value = _toConsumableArray(this.props.value);

        value.sort(function (data1, data2) {
          var value1 = ObjectUtils.resolveFieldData(data1, _this4.props.sortField);
          var value2 = ObjectUtils.resolveFieldData(data2, _this4.props.sortField);
          var result = null;
          if (value1 == null && value2 != null) result = -1;else if (value1 != null && value2 == null) result = 1;else if (value1 == null && value2 == null) result = 0;else if (typeof value1 === 'string' && typeof value2 === 'string') result = value1.localeCompare(value2, undefined, {
            numeric: true
          });else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
          return _this4.props.sortOrder * result;
        });
        return value;
      } else {
        return null;
      }
    }
  }, {
    key: "renderLoader",
    value: function renderLoader() {
      if (this.props.loading) {
        var iconClassName = classNames('p-dataview-loading-icon pi-spin', this.props.loadingIcon);
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-dataview-loading-overlay p-component-overlay"
        }, /*#__PURE__*/React__default['default'].createElement("i", {
          className: iconClassName
        }));
      }

      return null;
    }
  }, {
    key: "renderTopPaginator",
    value: function renderTopPaginator() {
      if (this.props.paginator && (this.props.paginatorPosition !== 'bottom' || this.props.paginatorPosition === 'both')) {
        return this.createPaginator('top');
      }

      return null;
    }
  }, {
    key: "renderBottomPaginator",
    value: function renderBottomPaginator() {
      if (this.props.paginator && (this.props.paginatorPosition !== 'top' || this.props.paginatorPosition === 'both')) {
        return this.createPaginator('bottom');
      }

      return null;
    }
  }, {
    key: "renderEmptyMessage",
    value: function renderEmptyMessage() {
      if (!this.props.loading) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-col-12 col-12 p-dataview-emptymessage"
        }, this.props.emptyMessage);
      }

      return null;
    }
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      if (this.props.header) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-dataview-header"
        }, this.props.header);
      }

      return null;
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      if (this.props.footer) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-dataview-footer"
        }, " ", this.props.footer);
      }

      return null;
    }
  }, {
    key: "renderItems",
    value: function renderItems(value) {
      var _this5 = this;

      if (value && value.length) {
        if (this.props.paginator) {
          var rows = this.props.onPage ? this.props.rows : this.state.rows;
          var first = this.props.lazy ? 0 : this.props.onPage ? this.props.first : this.state.first;
          var totalRecords = this.getTotalRecords();
          var last = Math.min(rows + first, totalRecords);
          var items = [];

          for (var i = first; i < last; i++) {
            var val = value[i];
            val && items.push( /*#__PURE__*/React__default['default'].createElement(DataViewItem, {
              key: this.getItemRenderKey(value) || i,
              template: this.props.itemTemplate,
              layout: this.props.layout,
              item: val
            }));
          }

          return items;
        } else {
          return value.map(function (item, index) {
            return /*#__PURE__*/React__default['default'].createElement(DataViewItem, {
              key: _this5.getItemRenderKey(item) || index,
              template: _this5.props.itemTemplate,
              layout: _this5.props.layout,
              item: item
            });
          });
        }
      } else {
        return this.renderEmptyMessage();
      }
    }
  }, {
    key: "renderContent",
    value: function renderContent(value) {
      var items = this.renderItems(value);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-dataview-content"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-grid p-nogutter grid grid-nogutter"
      }, items));
    }
  }, {
    key: "processData",
    value: function processData() {
      var data = this.props.value;

      if (data && data.length) {
        if (this.props.sortField) {
          data = this.sort();
        }
      }

      return data;
    }
  }, {
    key: "render",
    value: function render() {
      var value = this.processData();
      var className = classNames('p-dataview p-component', {
        'p-dataview-list': this.props.layout === 'list',
        'p-dataview-grid': this.props.layout === 'grid',
        'p-dataview-loading': this.props.loading
      }, this.props.className);
      var loader = this.renderLoader();
      var topPaginator = this.renderTopPaginator();
      var bottomPaginator = this.renderBottomPaginator();
      var header = this.renderHeader();
      var footer = this.renderFooter();
      var content = this.renderContent(value);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        style: this.props.style,
        className: className
      }, loader, header, topPaginator, content, bottomPaginator, footer);
    }
  }]);

  return DataView;
}(React.Component);

_defineProperty(DataView, "defaultProps", {
  id: null,
  header: null,
  footer: null,
  value: null,
  layout: 'list',
  dataKey: null,
  rows: null,
  first: 0,
  totalRecords: null,
  paginator: false,
  paginatorPosition: 'bottom',
  alwaysShowPaginator: true,
  paginatorClassName: null,
  paginatorTemplate: 'FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown',
  paginatorLeft: null,
  paginatorRight: null,
  paginatorDropdownAppendTo: null,
  pageLinkSize: 5,
  rowsPerPageOptions: null,
  currentPageReportTemplate: '({currentPage} of {totalPages})',
  emptyMessage: 'No records found',
  sortField: null,
  sortOrder: null,
  style: null,
  className: null,
  lazy: false,
  loading: false,
  loadingIcon: 'pi pi-spinner',
  itemTemplate: null,
  onPage: null
});

function _createSuper$1o(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1o(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1o() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var DeferredContent = /*#__PURE__*/function (_Component) {
  _inherits(DeferredContent, _Component);

  var _super = _createSuper$1o(DeferredContent);

  function DeferredContent(props) {
    var _this;

    _classCallCheck(this, DeferredContent);

    _this = _super.call(this, props);
    _this.state = {
      loaded: false
    };
    return _this;
  }

  _createClass(DeferredContent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this.state.loaded) {
        if (this.shouldLoad()) this.load();else this.bindScrollListener();
      }
    }
  }, {
    key: "bindScrollListener",
    value: function bindScrollListener() {
      var _this2 = this;

      this.documentScrollListener = function () {
        if (_this2.shouldLoad()) {
          _this2.load();

          _this2.unbindScrollListener();
        }
      };

      window.addEventListener('scroll', this.documentScrollListener);
    }
  }, {
    key: "unbindScrollListener",
    value: function unbindScrollListener() {
      if (this.documentScrollListener) {
        window.removeEventListener('scroll', this.documentScrollListener);
        this.documentScrollListener = null;
      }
    }
  }, {
    key: "shouldLoad",
    value: function shouldLoad() {
      if (this.state.loaded) {
        return false;
      } else {
        var rect = this.container.getBoundingClientRect();
        var docElement = document.documentElement;
        var winHeight = docElement.clientHeight;
        return winHeight >= rect.top;
      }
    }
  }, {
    key: "load",
    value: function load(event) {
      this.setState({
        loaded: true
      });

      if (this.props.onLoad) {
        this.props.onLoad(event);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.unbindScrollListener();
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this3.container = el;
        }
      }, this.state.loaded ? this.props.children : null);
    }
  }]);

  return DeferredContent;
}(React.Component);

_defineProperty(DeferredContent, "defaultProps", {
  onload: null
});

function _createSuper$1n(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1n(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1n() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Divider = /*#__PURE__*/function (_Component) {
  _inherits(Divider, _Component);

  var _super = _createSuper$1n(Divider);

  function Divider() {
    _classCallCheck(this, Divider);

    return _super.apply(this, arguments);
  }

  _createClass(Divider, [{
    key: "isHorizontal",
    get: function get() {
      return this.props.layout === 'horizontal';
    }
  }, {
    key: "isVertical",
    get: function get() {
      return this.props.layout === 'vertical';
    }
  }, {
    key: "render",
    value: function render() {
      var dividerClassName = classNames("p-divider p-component p-divider-".concat(this.props.layout, " p-divider-").concat(this.props.type), {
        'p-divider-left': this.isHorizontal && (!this.props.align || this.props.align === 'left'),
        'p-divider-right': this.isHorizontal && this.props.align === 'right',
        'p-divider-center': this.isHorizontal && this.props.align === 'center' || this.isVertical && (!this.props.align || this.props.align === 'center'),
        'p-divider-top': this.isVertical && this.props.align === 'top',
        'p-divider-bottom': this.isVertical && this.props.align === 'bottom'
      }, this.props.className);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: dividerClassName,
        style: this.props.style,
        role: "separator"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-divider-content"
      }, this.props.children));
    }
  }]);

  return Divider;
}(React.Component);

_defineProperty(Divider, "defaultProps", {
  align: null,
  layout: 'horizontal',
  type: 'solid',
  style: null,
  className: null
});

function ownKeys$q(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$q(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$q(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$q(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1m(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1m(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1m() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Editor = /*#__PURE__*/function (_Component) {
  _inherits(Editor, _Component);

  var _super = _createSuper$1m(Editor);

  function Editor() {
    _classCallCheck(this, Editor);

    return _super.apply(this, arguments);
  }

  _createClass(Editor, [{
    key: "getQuill",
    value: function getQuill() {
      return this.quill;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this = this;

      Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require('quill')); }).then(function (module) {
        if (module && module.default) {
          _this.quill = new module.default(_this.editorElement, {
            modules: _objectSpread$q({
              toolbar: _this.toolbarElement
            }, _this.props.modules),
            placeholder: _this.props.placeholder,
            readOnly: _this.props.readOnly,
            theme: _this.props.theme,
            formats: _this.props.formats
          });

          if (_this.props.value) {
            _this.quill.setContents(_this.quill.clipboard.convert(_this.props.value));
          }

          _this.quill.on('text-change', function (delta, source) {
            var html = _this.editorElement.children[0].innerHTML;

            var text = _this.quill.getText();

            if (html === '<p><br></p>') {
              html = null;
            }

            if (_this.props.onTextChange) {
              _this.props.onTextChange({
                htmlValue: html,
                textValue: text,
                delta: delta,
                source: source
              });
            }
          });

          _this.quill.on('selection-change', function (range, oldRange, source) {
            if (_this.props.onSelectionChange) {
              _this.props.onSelectionChange({
                range: range,
                oldRange: oldRange,
                source: source
              });
            }
          });
        }
      }).then(function () {
        if (_this.quill && _this.quill.getModule('toolbar')) {
          _this.props.onLoad && _this.props.onLoad(_this.quill);
        }
      });
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.value !== prevProps.value && this.quill && !this.quill.hasFocus()) {
        if (this.props.value) this.quill.setContents(this.quill.clipboard.convert(this.props.value));else this.quill.setText('');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var containerClass = classNames('p-component p-editor-container', this.props.className);
      var toolbarHeader = null;

      if (this.props.headerTemplate) {
        toolbarHeader = /*#__PURE__*/React__default['default'].createElement("div", {
          ref: function ref(el) {
            return _this2.toolbarElement = el;
          },
          className: "p-editor-toolbar"
        }, this.props.headerTemplate);
      } else {
        toolbarHeader = /*#__PURE__*/React__default['default'].createElement("div", {
          ref: function ref(el) {
            return _this2.toolbarElement = el;
          },
          className: "p-editor-toolbar"
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "ql-formats"
        }, /*#__PURE__*/React__default['default'].createElement("select", {
          className: "ql-header",
          defaultValue: "0"
        }, /*#__PURE__*/React__default['default'].createElement("option", {
          value: "1"
        }, "Heading"), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "2"
        }, "Subheading"), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "0"
        }, "Normal")), /*#__PURE__*/React__default['default'].createElement("select", {
          className: "ql-font"
        }, /*#__PURE__*/React__default['default'].createElement("option", null), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "serif"
        }), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "monospace"
        }))), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "ql-formats"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-bold",
          "aria-label": "Bold"
        }), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-italic",
          "aria-label": "Italic"
        }), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-underline",
          "aria-label": "Underline"
        })), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "ql-formats"
        }, /*#__PURE__*/React__default['default'].createElement("select", {
          className: "ql-color"
        }), /*#__PURE__*/React__default['default'].createElement("select", {
          className: "ql-background"
        })), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "ql-formats"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-list",
          value: "ordered",
          "aria-label": "Ordered List"
        }), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-list",
          value: "bullet",
          "aria-label": "Unordered List"
        }), /*#__PURE__*/React__default['default'].createElement("select", {
          className: "ql-align"
        }, /*#__PURE__*/React__default['default'].createElement("option", {
          defaultValue: true
        }), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "center"
        }), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "right"
        }), /*#__PURE__*/React__default['default'].createElement("option", {
          value: "justify"
        }))), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "ql-formats"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-link",
          "aria-label": "Insert Link"
        }), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-image",
          "aria-label": "Insert Image"
        }), /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-code-block",
          "aria-label": "Insert Code Block"
        })), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "ql-formats"
        }, /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "ql-clean",
          "aria-label": "Remove Styles"
        })));
      }

      var content = /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this2.editorElement = el;
        },
        className: "p-editor-content",
        style: this.props.style
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        className: containerClass
      }, toolbarHeader, content);
    }
  }]);

  return Editor;
}(React.Component);

_defineProperty(Editor, "defaultProps", {
  id: null,
  value: null,
  style: null,
  className: null,
  placeholder: null,
  readOnly: false,
  modules: null,
  formats: null,
  theme: 'snow',
  headerTemplate: null,
  onTextChange: null,
  onSelectionChange: null,
  onLoad: null
});

function ownKeys$p(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$p(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$p(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$p(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1l(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1l(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1l() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Fieldset = /*#__PURE__*/function (_Component) {
  _inherits(Fieldset, _Component);

  var _super = _createSuper$1l(Fieldset);

  function Fieldset(props) {
    var _this;

    _classCallCheck(this, Fieldset);

    _this = _super.call(this, props);
    var state = {
      id: props.id
    };

    if (!_this.props.onToggle) {
      state = _objectSpread$p(_objectSpread$p({}, state), {}, {
        collapsed: props.collapsed
      });
    }

    _this.state = state;
    _this.toggle = _this.toggle.bind(_assertThisInitialized(_this));
    _this.contentRef = /*#__PURE__*/React__default['default'].createRef();
    return _this;
  }

  _createClass(Fieldset, [{
    key: "toggle",
    value: function toggle(event) {
      if (this.props.toggleable) {
        var collapsed = this.props.onToggle ? this.props.collapsed : this.state.collapsed;
        if (collapsed) this.expand(event);else this.collapse(event);

        if (this.props.onToggle) {
          this.props.onToggle({
            originalEvent: event,
            value: !collapsed
          });
        }
      }

      event.preventDefault();
    }
  }, {
    key: "expand",
    value: function expand(event) {
      if (!this.props.onToggle) {
        this.setState({
          collapsed: false
        });
      }

      if (this.props.onExpand) {
        this.props.onExpand(event);
      }
    }
  }, {
    key: "collapse",
    value: function collapse(event) {
      if (!this.props.onToggle) {
        this.setState({
          collapsed: true
        });
      }

      if (this.props.onCollapse) {
        this.props.onCollapse(event);
      }
    }
  }, {
    key: "isCollapsed",
    value: function isCollapsed() {
      return this.props.toggleable ? this.props.onToggle ? this.props.collapsed : this.state.collapsed : false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this.state.id) {
        this.setState({
          id: UniqueComponentId()
        });
      }
    }
  }, {
    key: "renderContent",
    value: function renderContent(collapsed) {
      var id = this.state.id + '_content';
      return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
        nodeRef: this.contentRef,
        classNames: "p-toggleable-content",
        timeout: {
          enter: 1000,
          exit: 450
        },
        in: !collapsed,
        unmountOnExit: true,
        options: this.props.transitionOptions
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.contentRef,
        id: id,
        className: "p-toggleable-content",
        "aria-hidden": collapsed,
        role: "region",
        "aria-labelledby": this.state.id + '_header'
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-fieldset-content"
      }, this.props.children)));
    }
  }, {
    key: "renderToggleIcon",
    value: function renderToggleIcon(collapsed) {
      if (this.props.toggleable) {
        var className = classNames('p-fieldset-toggler pi', {
          'pi-plus': collapsed,
          'pi-minus': !collapsed
        });
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: className
        });
      }

      return null;
    }
  }, {
    key: "renderLegendContent",
    value: function renderLegendContent(collapsed) {
      if (this.props.toggleable) {
        var toggleIcon = this.renderToggleIcon(collapsed);
        var ariaControls = this.state.id + '_content';
        return /*#__PURE__*/React__default['default'].createElement("a", {
          href: '#' + ariaControls,
          "aria-controls": ariaControls,
          id: this.state.id + '_header',
          "aria-expanded": !collapsed,
          tabIndex: this.props.toggleable ? null : -1
        }, toggleIcon, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-fieldset-legend-text"
        }, this.props.legend), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-fieldset-legend-text",
        id: this.state.id + '_header'
      }, this.props.legend);
    }
  }, {
    key: "renderLegend",
    value: function renderLegend(collapsed) {
      var legendContent = this.renderLegendContent(collapsed);

      if (this.props.legend != null || this.props.toggleable) {
        return /*#__PURE__*/React__default['default'].createElement("legend", {
          className: "p-fieldset-legend p-unselectable-text",
          onClick: this.toggle
        }, legendContent);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-fieldset p-component', this.props.className, {
        'p-fieldset-toggleable': this.props.toggleable
      });
      var collapsed = this.isCollapsed();
      var legend = this.renderLegend(collapsed);
      var content = this.renderContent(collapsed);
      return /*#__PURE__*/React__default['default'].createElement("fieldset", {
        id: this.props.id,
        className: className,
        style: this.props.style,
        onClick: this.props.onClick
      }, legend, content);
    }
  }]);

  return Fieldset;
}(React.Component);

_defineProperty(Fieldset, "defaultProps", {
  id: null,
  legend: null,
  className: null,
  style: null,
  toggleable: null,
  collapsed: null,
  transitionOptions: null,
  onExpand: null,
  onCollapse: null,
  onToggle: null,
  onClick: null
});

function _createSuper$1k(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1k(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1k() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var UIMessageComponent = /*#__PURE__*/function (_Component) {
  _inherits(UIMessageComponent, _Component);

  var _super = _createSuper$1k(UIMessageComponent);

  function UIMessageComponent(props) {
    var _this;

    _classCallCheck(this, UIMessageComponent);

    _this = _super.call(this, props);
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.onClose = _this.onClose.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(UIMessageComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      if (!this.props.message.sticky) {
        this.timeout = setTimeout(function () {
          _this2.onClose(null);
        }, this.props.message.life || 3000);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.timeout) {
        clearTimeout(this.timeout);
      }
    }
  }, {
    key: "onClose",
    value: function onClose(event) {
      if (this.timeout) {
        clearTimeout(this.timeout);
      }

      if (this.props.onClose) {
        this.props.onClose(this.props.message);
      }

      if (event) {
        event.preventDefault();
        event.stopPropagation();
      }
    }
  }, {
    key: "onClick",
    value: function onClick() {
      if (this.props.onClick) {
        this.props.onClick(this.props.message);
      }
    }
  }, {
    key: "renderCloseIcon",
    value: function renderCloseIcon() {
      if (this.props.message.closable !== false) {
        return /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: "p-message-close p-link",
          onClick: this.onClose
        }, /*#__PURE__*/React__default['default'].createElement("i", {
          className: "p-message-close-icon pi pi-times"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderMessage",
    value: function renderMessage() {
      if (this.props.message) {
        var _this$props$message = this.props.message,
            severity = _this$props$message.severity,
            content = _this$props$message.content,
            summary = _this$props$message.summary,
            detail = _this$props$message.detail;
        var icon = classNames('p-message-icon pi ', {
          'pi-info-circle': severity === 'info',
          'pi-check': severity === 'success',
          'pi-exclamation-triangle': severity === 'warn',
          'pi-times-circle': severity === 'error'
        });
        return content || /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("span", {
          className: icon
        }), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-message-summary"
        }, summary), /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-message-detail"
        }, detail));
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var severity = this.props.message.severity;
      var className = 'p-message p-component p-message-' + severity;
      var closeIcon = this.renderCloseIcon();
      var message = this.renderMessage();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.props.forwardRef,
        className: className,
        onClick: this.onClick
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-message-wrapper"
      }, message, closeIcon));
    }
  }]);

  return UIMessageComponent;
}(React.Component);

_defineProperty(UIMessageComponent, "defaultProps", {
  message: null,
  onClose: null,
  onClick: null
});

var UIMessage = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(UIMessageComponent, _extends({
    forwardRef: ref
  }, props));
});

function _createSuper$1j(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1j(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1j() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var messageIdx$1 = 0;
var Messages = /*#__PURE__*/function (_Component) {
  _inherits(Messages, _Component);

  var _super = _createSuper$1j(Messages);

  function Messages(props) {
    var _this;

    _classCallCheck(this, Messages);

    _this = _super.call(this, props);
    _this.state = {
      messages: []
    };
    _this.onClose = _this.onClose.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Messages, [{
    key: "show",
    value: function show(value) {
      if (value) {
        var newMessages = [];

        if (Array.isArray(value)) {
          for (var i = 0; i < value.length; i++) {
            value[i].id = messageIdx$1++;
            newMessages = [].concat(_toConsumableArray(this.state.messages), _toConsumableArray(value));
          }
        } else {
          value.id = messageIdx$1++;
          newMessages = this.state.messages ? [].concat(_toConsumableArray(this.state.messages), [value]) : [value];
        }

        this.setState({
          messages: newMessages
        });
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.setState({
        messages: []
      });
    }
  }, {
    key: "replace",
    value: function replace(value) {
      var _this2 = this;

      this.setState({
        messages: []
      }, function () {
        return _this2.show(value);
      });
    }
  }, {
    key: "onClose",
    value: function onClose(message) {
      var newMessages = this.state.messages.filter(function (msg) {
        return msg.id !== message.id;
      });
      this.setState({
        messages: newMessages
      });

      if (this.props.onRemove) {
        this.props.onRemove(message);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        className: this.props.className,
        style: this.props.style
      }, /*#__PURE__*/React__default['default'].createElement(reactTransitionGroup.TransitionGroup, null, this.state.messages.map(function (message) {
        var messageRef = /*#__PURE__*/React__default['default'].createRef();
        return /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
          nodeRef: messageRef,
          key: message.id,
          classNames: "p-message",
          unmountOnExit: true,
          timeout: {
            enter: 300,
            exit: 300
          },
          options: _this3.props.transitionOptions
        }, /*#__PURE__*/React__default['default'].createElement(UIMessage, {
          ref: messageRef,
          message: message,
          onClick: _this3.props.onClick,
          onClose: _this3.onClose
        }));
      })));
    }
  }]);

  return Messages;
}(React.Component);

_defineProperty(Messages, "defaultProps", {
  id: null,
  className: null,
  style: null,
  transitionOptions: null,
  onRemove: null,
  onClick: null
});

function _createSuper$1i(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1i(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1i() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var ProgressBar = /*#__PURE__*/function (_Component) {
  _inherits(ProgressBar, _Component);

  var _super = _createSuper$1i(ProgressBar);

  function ProgressBar() {
    _classCallCheck(this, ProgressBar);

    return _super.apply(this, arguments);
  }

  _createClass(ProgressBar, [{
    key: "renderLabel",
    value: function renderLabel() {
      if (this.props.showValue && this.props.value != null) {
        var label = this.props.displayValueTemplate ? this.props.displayValueTemplate(this.props.value) : this.props.value + this.props.unit;
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-progressbar-label"
        }, label);
      }

      return null;
    }
  }, {
    key: "renderDeterminate",
    value: function renderDeterminate() {
      var className = classNames('p-progressbar p-component p-progressbar-determinate', this.props.className);
      var label = this.renderLabel();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        role: "progressbar",
        id: this.props.id,
        className: className,
        style: this.props.style,
        "aria-valuemin": "0",
        "aria-valuenow": this.props.value,
        "aria-valuemax": "100",
        "aria-label": this.props.value
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-progressbar-value p-progressbar-value-animate",
        style: {
          width: this.props.value + '%',
          display: 'block',
          backgroundColor: this.props.color
        }
      }), label);
    }
  }, {
    key: "renderIndeterminate",
    value: function renderIndeterminate() {
      var className = classNames('p-progressbar p-component p-progressbar-indeterminate', this.props.className);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        role: "progressbar",
        id: this.props.id,
        className: className,
        style: this.props.style
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-progressbar-indeterminate-container"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-progressbar-value p-progressbar-value-animate",
        style: {
          backgroundColor: this.props.color
        }
      })));
    }
  }, {
    key: "render",
    value: function render() {
      if (this.props.mode === 'determinate') return this.renderDeterminate();else if (this.props.mode === 'indeterminate') return this.renderIndeterminate();else throw new Error(this.props.mode + " is not a valid mode for the ProgressBar. Valid values are 'determinate' and 'indeterminate'");
    }
  }]);

  return ProgressBar;
}(React.Component);

_defineProperty(ProgressBar, "defaultProps", {
  id: null,
  value: null,
  showValue: true,
  unit: '%',
  style: null,
  className: null,
  mode: 'determinate',
  displayValueTemplate: null,
  color: null
});

function _createForOfIteratorHelper$a(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$a(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$a(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$a(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$a(o, minLen); }

function _arrayLikeToArray$a(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$1h(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1h(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1h() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var FileUpload = /*#__PURE__*/function (_Component) {
  _inherits(FileUpload, _Component);

  var _super = _createSuper$1h(FileUpload);

  function FileUpload(props) {
    var _this;

    _classCallCheck(this, FileUpload);

    _this = _super.call(this, props);
    _this.state = {
      files: [],
      msgs: [],
      focused: false
    };
    _this.choose = _this.choose.bind(_assertThisInitialized(_this));
    _this.upload = _this.upload.bind(_assertThisInitialized(_this));
    _this.clear = _this.clear.bind(_assertThisInitialized(_this));
    _this.onFileSelect = _this.onFileSelect.bind(_assertThisInitialized(_this));
    _this.onDragEnter = _this.onDragEnter.bind(_assertThisInitialized(_this));
    _this.onDragOver = _this.onDragOver.bind(_assertThisInitialized(_this));
    _this.onDragLeave = _this.onDragLeave.bind(_assertThisInitialized(_this));
    _this.onDrop = _this.onDrop.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onSimpleUploaderClick = _this.onSimpleUploaderClick.bind(_assertThisInitialized(_this));
    _this.duplicateIEEvent = false;
    return _this;
  }

  _createClass(FileUpload, [{
    key: "hasFiles",
    value: function hasFiles() {
      return this.state.files && this.state.files.length > 0;
    }
  }, {
    key: "isImage",
    value: function isImage(file) {
      return /^image\//.test(file.type);
    }
  }, {
    key: "chooseDisabled",
    value: function chooseDisabled() {
      return this.props.disabled || this.props.fileLimit && this.props.fileLimit <= this.state.files.length + this.uploadedFileCount;
    }
  }, {
    key: "uploadDisabled",
    value: function uploadDisabled() {
      return this.props.disabled || !this.hasFiles();
    }
  }, {
    key: "cancelDisabled",
    value: function cancelDisabled() {
      return this.props.disabled || !this.hasFiles();
    }
  }, {
    key: "chooseButtonLabel",
    value: function chooseButtonLabel() {
      return this.props.chooseLabel || this.props.chooseOptions.label || localeOption('choose');
    }
  }, {
    key: "uploadButtonLabel",
    value: function uploadButtonLabel() {
      return this.props.uploadLabel || this.props.uploadOptions.label || localeOption('upload');
    }
  }, {
    key: "cancelButtonLabel",
    value: function cancelButtonLabel() {
      return this.props.cancelLabel || this.props.cancelOptions.label || localeOption('cancel');
    }
  }, {
    key: "remove",
    value: function remove(event, index) {
      this.clearInputElement();

      var currentFiles = _toConsumableArray(this.state.files);

      var removedFile = this.state.files[index];
      currentFiles.splice(index, 1);
      this.setState({
        files: currentFiles
      });

      if (this.props.onRemove) {
        this.props.onRemove({
          originalEvent: event,
          file: removedFile
        });
      }
    }
  }, {
    key: "clearInputElement",
    value: function clearInputElement() {
      if (this.fileInput) {
        this.fileInput.value = '';
      }
    }
  }, {
    key: "clearIEInput",
    value: function clearIEInput() {
      if (this.fileInput) {
        this.duplicateIEEvent = true; //IE11 fix to prevent onFileChange trigger again

        this.fileInput.value = '';
      }
    }
  }, {
    key: "formatSize",
    value: function formatSize(bytes) {
      if (bytes === 0) {
        return '0 B';
      }

      var k = 1000,
          dm = 3,
          sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
          i = Math.floor(Math.log(bytes) / Math.log(k));
      return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
    }
  }, {
    key: "onFileSelect",
    value: function onFileSelect(event) {
      var _this2 = this;

      if (event.type !== 'drop' && this.isIE11() && this.duplicateIEEvent) {
        this.duplicateIEEvent = false;
        return;
      }

      this.setState({
        msgs: []
      });
      this.files = this.state.files || [];
      var files = event.dataTransfer ? event.dataTransfer.files : event.target.files;

      for (var i = 0; i < files.length; i++) {
        var file = files[i];

        if (!this.isFileSelected(file)) {
          if (this.validate(file)) {
            if (this.isImage(file)) {
              file.objectURL = window.URL.createObjectURL(file);
            }

            this.files.push(file);
          }
        }
      }

      this.setState({
        files: this.files
      }, function () {
        if (_this2.hasFiles() && _this2.props.auto) {
          _this2.upload();
        }
      });

      if (this.props.onSelect) {
        this.props.onSelect({
          originalEvent: event,
          files: files
        });
      }

      if (event.type !== 'drop' && this.isIE11()) {
        this.clearIEInput();
      } else {
        this.clearInputElement();
      }

      if (this.props.mode === 'basic' && this.files.length > 0) {
        this.fileInput.style.display = 'none';
      }
    }
  }, {
    key: "isFileSelected",
    value: function isFileSelected(file) {
      var _iterator = _createForOfIteratorHelper$a(this.state.files),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var sFile = _step.value;
          if (sFile.name + sFile.type + sFile.size === file.name + file.type + file.size) return true;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return false;
    }
  }, {
    key: "isIE11",
    value: function isIE11() {
      return !!window['MSInputMethodContext'] && !!document['documentMode'];
    }
  }, {
    key: "validate",
    value: function validate(file) {
      if (this.props.maxFileSize && file.size > this.props.maxFileSize) {
        var message = {
          severity: 'error',
          summary: this.props.invalidFileSizeMessageSummary.replace('{0}', file.name),
          detail: this.props.invalidFileSizeMessageDetail.replace('{0}', this.formatSize(this.props.maxFileSize))
        };

        if (this.props.mode === 'advanced') {
          this.messagesUI.show(message);
        }

        if (this.props.onValidationFail) {
          this.props.onValidationFail(file);
        }

        return false;
      }

      return true;
    }
  }, {
    key: "upload",
    value: function upload() {
      var _this3 = this;

      if (this.props.customUpload) {
        if (this.props.fileLimit) {
          this.uploadedFileCount += this.state.files.length;
        }

        if (this.props.uploadHandler) {
          this.props.uploadHandler({
            files: this.state.files,
            options: {
              clear: this.clear,
              props: this.props
            }
          });
        }
      } else {
        this.setState({
          msgs: []
        });
        var xhr = new XMLHttpRequest();
        var formData = new FormData();

        if (this.props.onBeforeUpload) {
          this.props.onBeforeUpload({
            'xhr': xhr,
            'formData': formData
          });
        }

        var _iterator2 = _createForOfIteratorHelper$a(this.state.files),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var file = _step2.value;
            formData.append(this.props.name, file, file.name);
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        xhr.upload.addEventListener('progress', function (event) {
          if (event.lengthComputable) {
            _this3.setState({
              progress: Math.round(event.loaded * 100 / event.total)
            }, function () {
              if (_this3.props.onProgress) {
                _this3.props.onProgress({
                  originalEvent: event,
                  progress: _this3.state.progress
                });
              }
            });
          }
        });

        xhr.onreadystatechange = function () {
          if (xhr.readyState === 4) {
            _this3.setState({
              progress: 0
            });

            if (xhr.status >= 200 && xhr.status < 300) {
              if (_this3.props.fileLimit) {
                _this3.uploadedFileCount += _this3.state.files.length;
              }

              if (_this3.props.onUpload) {
                _this3.props.onUpload({
                  xhr: xhr,
                  files: _this3.state.files
                });
              }
            } else {
              if (_this3.props.onError) {
                _this3.props.onError({
                  xhr: xhr,
                  files: _this3.state.files
                });
              }
            }

            _this3.clear();
          }
        };

        xhr.open('POST', this.props.url, true);

        if (this.props.onBeforeSend) {
          this.props.onBeforeSend({
            'xhr': xhr,
            'formData': formData
          });
        }

        xhr.withCredentials = this.props.withCredentials;
        xhr.send(formData);
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.setState({
        files: []
      });

      if (this.props.onClear) {
        this.props.onClear();
      }

      this.clearInputElement();
    }
  }, {
    key: "choose",
    value: function choose() {
      this.fileInput.click();
    }
  }, {
    key: "onFocus",
    value: function onFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      this.setState({
        focused: false
      });
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.which === 13) {
        // enter
        this.choose();
      }
    }
  }, {
    key: "onDragEnter",
    value: function onDragEnter(event) {
      if (!this.props.disabled) {
        event.stopPropagation();
        event.preventDefault();
      }
    }
  }, {
    key: "onDragOver",
    value: function onDragOver(event) {
      if (!this.props.disabled) {
        DomHandler.addClass(this.content, 'p-fileupload-highlight');
        event.stopPropagation();
        event.preventDefault();
      }
    }
  }, {
    key: "onDragLeave",
    value: function onDragLeave(event) {
      if (!this.props.disabled) {
        DomHandler.removeClass(this.content, 'p-fileupload-highlight');
      }
    }
  }, {
    key: "onDrop",
    value: function onDrop(event) {
      if (!this.props.disabled) {
        DomHandler.removeClass(this.content, 'p-fileupload-highlight');
        event.stopPropagation();
        event.preventDefault();
        var files = event.dataTransfer ? event.dataTransfer.files : event.target.files;
        var allowDrop = this.props.multiple || files && files.length === 1;

        if (allowDrop) {
          this.onFileSelect(event);
        }
      }
    }
  }, {
    key: "onSimpleUploaderClick",
    value: function onSimpleUploaderClick() {
      if (this.hasFiles()) {
        this.upload();
      } else {
        this.fileInput.click();
      }
    }
  }, {
    key: "renderChooseButton",
    value: function renderChooseButton() {
      var _this4 = this;

      var _this$props$chooseOpt = this.props.chooseOptions,
          className = _this$props$chooseOpt.className,
          style = _this$props$chooseOpt.style,
          icon = _this$props$chooseOpt.icon,
          iconOnly = _this$props$chooseOpt.iconOnly;
      var chooseClassName = classNames('p-button p-fileupload-choose p-component', {
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused,
        'p-button-icon-only': iconOnly
      }, className);
      var chooseIconClassName = classNames('p-button-icon p-button-icon-left p-clickable', {
        'pi pi-fw pi-plus': !icon
      }, icon);
      var labelClassName = 'p-button-label p-clickable';
      var label = iconOnly ? /*#__PURE__*/React__default['default'].createElement("span", {
        className: labelClassName,
        dangerouslySetInnerHTML: {
          __html: "&nbsp;"
        }
      }) : /*#__PURE__*/React__default['default'].createElement("span", {
        className: labelClassName
      }, this.chooseButtonLabel());
      return /*#__PURE__*/React__default['default'].createElement("span", {
        className: chooseClassName,
        style: style,
        onClick: this.choose,
        onKeyDown: this.onKeyDown,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        tabIndex: 0
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: function ref(el) {
          return _this4.fileInput = el;
        },
        type: "file",
        onChange: this.onFileSelect,
        multiple: this.props.multiple,
        accept: this.props.accept,
        disabled: this.chooseDisabled()
      }), /*#__PURE__*/React__default['default'].createElement("span", {
        className: chooseIconClassName
      }), label, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
    }
  }, {
    key: "renderFile",
    value: function renderFile(file, index) {
      var _this5 = this;

      var preview = this.isImage(file) ? /*#__PURE__*/React__default['default'].createElement("div", null, /*#__PURE__*/React__default['default'].createElement("img", {
        alt: file.name,
        role: "presentation",
        src: file.objectURL,
        width: this.props.previewWidth
      })) : null;
      var fileName = /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-fileupload-filename"
      }, file.name);
      var size = /*#__PURE__*/React__default['default'].createElement("div", null, this.formatSize(file.size));
      var removeButton = /*#__PURE__*/React__default['default'].createElement("div", null, /*#__PURE__*/React__default['default'].createElement(Button, {
        type: "button",
        icon: "pi pi-times",
        onClick: function onClick(e) {
          return _this5.remove(e, index);
        }
      }));
      var content = /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, preview, fileName, size, removeButton);

      if (this.props.itemTemplate) {
        var defaultContentOptions = {
          onRemove: function onRemove(event) {
            return _this5.remove(event, index);
          },
          previewElement: preview,
          fileNameElement: fileName,
          sizeElement: size,
          removeElement: removeButton,
          formatSize: this.formatSize(file.size),
          element: content,
          props: this.props
        };
        content = ObjectUtils.getJSXElement(this.props.itemTemplate, file, defaultContentOptions);
      }

      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-fileupload-row",
        key: file.name + file.type + file.size
      }, content);
    }
  }, {
    key: "renderFiles",
    value: function renderFiles() {
      var _this6 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-fileupload-files"
      }, this.state.files.map(function (file, index) {
        return _this6.renderFile(file, index);
      }));
    }
  }, {
    key: "renderEmptyContent",
    value: function renderEmptyContent() {
      if (this.props.emptyTemplate && !this.hasFiles()) {
        return ObjectUtils.getJSXElement(this.props.emptyTemplate, this.props);
      }

      return null;
    }
  }, {
    key: "renderProgressBarContent",
    value: function renderProgressBarContent() {
      if (this.props.progressBarTemplate) {
        return ObjectUtils.getJSXElement(this.props.progressBarTemplate, this.props);
      }

      return /*#__PURE__*/React__default['default'].createElement(ProgressBar, {
        value: this.state.progress,
        showValue: false
      });
    }
  }, {
    key: "renderAdvanced",
    value: function renderAdvanced() {
      var _this7 = this;

      var className = classNames('p-fileupload p-fileupload-advanced p-component', this.props.className);
      var headerClassName = classNames('p-fileupload-buttonbar', this.props.headerClassName);
      var contentClassName = classNames('p-fileupload-content', this.props.contentClassName);
      var uploadButton, cancelButton, filesList, progressBar;
      var chooseButton = this.renderChooseButton();
      var emptyContent = this.renderEmptyContent();

      if (!this.props.auto) {
        var uploadOptions = this.props.uploadOptions;
        var cancelOptions = this.props.cancelOptions;
        var uploadLabel = !uploadOptions.iconOnly ? this.uploadButtonLabel() : '';
        var cancelLabel = !cancelOptions.iconOnly ? this.cancelButtonLabel() : '';
        uploadButton = /*#__PURE__*/React__default['default'].createElement(Button, {
          type: "button",
          label: uploadLabel,
          icon: uploadOptions.icon || 'pi pi-upload',
          onClick: this.upload,
          disabled: this.uploadDisabled(),
          style: uploadOptions.style,
          className: uploadOptions.className
        });
        cancelButton = /*#__PURE__*/React__default['default'].createElement(Button, {
          type: "button",
          label: cancelLabel,
          icon: cancelOptions.icon || 'pi pi-times',
          onClick: this.clear,
          disabled: this.cancelDisabled(),
          style: cancelOptions.style,
          className: cancelOptions.className
        });
      }

      if (this.hasFiles()) {
        filesList = this.renderFiles();
        progressBar = this.renderProgressBarContent();
      }

      var header = /*#__PURE__*/React__default['default'].createElement("div", {
        className: headerClassName,
        style: this.props.headerStyle
      }, chooseButton, uploadButton, cancelButton);

      if (this.props.headerTemplate) {
        var defaultContentOptions = {
          className: headerClassName,
          chooseButton: chooseButton,
          uploadButton: uploadButton,
          cancelButton: cancelButton,
          element: header,
          props: this.props
        };
        header = ObjectUtils.getJSXElement(this.props.headerTemplate, defaultContentOptions);
      }

      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        className: className,
        style: this.props.style
      }, header, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          _this7.content = el;
        },
        className: contentClassName,
        style: this.props.contentStyle,
        onDragEnter: this.onDragEnter,
        onDragOver: this.onDragOver,
        onDragLeave: this.onDragLeave,
        onDrop: this.onDrop
      }, progressBar, /*#__PURE__*/React__default['default'].createElement(Messages, {
        ref: function ref(el) {
          return _this7.messagesUI = el;
        }
      }), filesList, emptyContent));
    }
  }, {
    key: "renderBasic",
    value: function renderBasic() {
      var _this8 = this;

      var chooseOptions = this.props.chooseOptions;
      var className = classNames('p-fileupload p-fileupload-basic p-component', this.props.className);
      var buttonClassName = classNames('p-button p-component p-fileupload-choose', {
        'p-fileupload-choose-selected': this.hasFiles(),
        'p-disabled': this.props.disabled,
        'p-focus': this.state.focused
      }, chooseOptions.className);
      var iconClassName = classNames('p-button-icon p-button-icon-left pi', {
        'pi-plus': !chooseOptions.icon && (!this.hasFiles() || this.props.auto),
        'pi-upload': !chooseOptions.icon && this.hasFiles() && !this.props.auto
      }, chooseOptions.icon);
      var labelClassName = 'p-button-label p-clickable';
      var chooseLabel = chooseOptions.iconOnly ? /*#__PURE__*/React__default['default'].createElement("span", {
        className: labelClassName,
        dangerouslySetInnerHTML: {
          __html: "&nbsp;"
        }
      }) : /*#__PURE__*/React__default['default'].createElement("span", {
        className: labelClassName
      }, this.chooseButtonLabel());
      var label = this.props.auto ? chooseLabel : /*#__PURE__*/React__default['default'].createElement("span", {
        className: labelClassName
      }, this.hasFiles() ? this.state.files[0].name : chooseLabel);
      var icon = /*#__PURE__*/React__default['default'].createElement("span", {
        className: iconClassName
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: className,
        style: this.props.style
      }, /*#__PURE__*/React__default['default'].createElement(Messages, {
        ref: function ref(el) {
          return _this8.messagesUI = el;
        }
      }), /*#__PURE__*/React__default['default'].createElement("span", {
        className: buttonClassName,
        style: chooseOptions.style,
        onMouseUp: this.onSimpleUploaderClick,
        onKeyDown: this.onKeyDown,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        tabIndex: 0
      }, icon, label, !this.hasFiles() && /*#__PURE__*/React__default['default'].createElement("input", {
        ref: function ref(el) {
          return _this8.fileInput = el;
        },
        type: "file",
        accept: this.props.accept,
        multiple: this.props.multiple,
        disabled: this.props.disabled,
        onChange: this.onFileSelect
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null)));
    }
  }, {
    key: "render",
    value: function render() {
      if (this.props.mode === 'advanced') return this.renderAdvanced();else if (this.props.mode === 'basic') return this.renderBasic();
    }
  }]);

  return FileUpload;
}(React.Component);

_defineProperty(FileUpload, "defaultProps", {
  id: null,
  name: null,
  url: null,
  mode: 'advanced',
  multiple: false,
  accept: null,
  disabled: false,
  auto: false,
  maxFileSize: null,
  invalidFileSizeMessageSummary: '{0}: Invalid file size, ',
  invalidFileSizeMessageDetail: 'maximum upload size is {0}.',
  style: null,
  className: null,
  widthCredentials: false,
  previewWidth: 50,
  chooseLabel: null,
  uploadLabel: null,
  cancelLabel: null,
  chooseOptions: {
    label: null,
    icon: null,
    iconOnly: false,
    className: null,
    style: null
  },
  uploadOptions: {
    label: null,
    icon: null,
    iconOnly: false,
    className: null,
    style: null
  },
  cancelOptions: {
    label: null,
    icon: null,
    iconOnly: false,
    className: null,
    style: null
  },
  customUpload: false,
  headerClassName: null,
  headerStyle: null,
  contentClassName: null,
  contentStyle: null,
  headerTemplate: null,
  itemTemplate: null,
  emptyTemplate: null,
  progressBarTemplate: null,
  onBeforeUpload: null,
  onBeforeSend: null,
  onUpload: null,
  onError: null,
  onClear: null,
  onSelect: null,
  onProgress: null,
  onValidationFail: null,
  uploadHandler: null,
  onRemove: null
});

function _createSuper$1g(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1g(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1g() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var FullCalendar = /*#__PURE__*/function (_Component) {
  _inherits(FullCalendar, _Component);

  var _super = _createSuper$1g(FullCalendar);

  function FullCalendar() {
    _classCallCheck(this, FullCalendar);

    return _super.apply(this, arguments);
  }

  _createClass(FullCalendar, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      console.warn("FullCalendar component is deprecated. Use FullCalendar component of '@fullcalendar/react' package.");
      this.config = {
        theme: true
      };

      if (this.props.options) {
        for (var prop in this.props.options) {
          this.config[prop] = this.props.options[prop];
        }
      }

      this.initialize();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!this.calendar) {
        this.initialize();
      } else {
        if (!ObjectUtils.equals(prevProps.events, this.props.events)) {
          this.calendar.removeAllEventSources();
          this.calendar.addEventSource(this.props.events);
        }

        if (!ObjectUtils.equals(prevProps.options, this.props.options)) {
          for (var prop in this.props.options) {
            var optionValue = this.props.options[prop];
            this.config[prop] = optionValue;
            this.calendar.setOption(prop, optionValue);
          }
        }
      }
    }
  }, {
    key: "initialize",
    value: function initialize() {
      var _this = this;

      Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require('@fullcalendar/core')); }).then(function (module) {
        if (module && module.Calendar) {
          _this.calendar = new module.Calendar(_this.element, _this.config);

          _this.calendar.render();

          if (_this.props.events) {
            _this.calendar.removeAllEventSources();

            _this.calendar.addEventSource(_this.props.events);
          }
        }
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.calendar) {
        this.calendar.destroy();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        id: this.props.id,
        ref: function ref(el) {
          return _this2.element = el;
        },
        style: this.props.style,
        className: this.props.className
      });
    }
  }]);

  return FullCalendar;
}(React.Component);

_defineProperty(FullCalendar, "defaultProps", {
  id: null,
  events: [],
  style: null,
  className: null,
  options: null
});

function _createSuper$1f(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1f(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1f() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var GalleriaItemComponent = /*#__PURE__*/function (_Component) {
  _inherits(GalleriaItemComponent, _Component);

  var _super = _createSuper$1f(GalleriaItemComponent);

  function GalleriaItemComponent(props) {
    var _this;

    _classCallCheck(this, GalleriaItemComponent);

    _this = _super.call(this, props);
    _this.navForward = _this.navForward.bind(_assertThisInitialized(_this));
    _this.navBackward = _this.navBackward.bind(_assertThisInitialized(_this));
    _this.next = _this.next.bind(_assertThisInitialized(_this));
    _this.prev = _this.prev.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(GalleriaItemComponent, [{
    key: "step",
    value: function step(index) {
      if (this.itemsContainer) {
        this.itemsContainer.style.transform = this.isVertical() ? "translate3d(0, ".concat(index * 100, "%, 0)") : "translate3d(".concat(index * 100, "%, 0, 0)");
        this.itemsContainer.style.transition = 'transform 500ms ease 0s';
      }
    }
  }, {
    key: "next",
    value: function next() {
      var nextItemIndex = this.props.activeItemIndex + 1;
      this.props.onActiveItemChange({
        index: this.props.circular && this.props.value.length - 1 === this.props.activeItemIndex ? 0 : nextItemIndex
      });
    }
  }, {
    key: "prev",
    value: function prev() {
      var prevItemIndex = this.props.activeItemIndex !== 0 ? this.props.activeItemIndex - 1 : 0;
      this.props.onActiveItemChange({
        index: this.props.circular && this.props.activeItemIndex === 0 ? this.props.value.length - 1 : prevItemIndex
      });
    }
  }, {
    key: "stopSlideShow",
    value: function stopSlideShow() {
      if (this.props.slideShowActive && this.props.stopSlideShow) {
        this.props.stopSlideShow();
      }
    }
  }, {
    key: "navBackward",
    value: function navBackward(e) {
      this.stopSlideShow();
      this.prev();

      if (e && e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "navForward",
    value: function navForward(e) {
      this.stopSlideShow();
      this.next();

      if (e && e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "onIndicatorClick",
    value: function onIndicatorClick(index) {
      this.stopSlideShow();
      this.props.onActiveItemChange({
        index: index
      });
    }
  }, {
    key: "onIndicatorMouseEnter",
    value: function onIndicatorMouseEnter(index) {
      if (this.props.changeItemOnIndicatorHover) {
        this.stopSlideShow();
        this.props.onActiveItemChange({
          index: index
        });
      }
    }
  }, {
    key: "onIndicatorKeyDown",
    value: function onIndicatorKeyDown(event, index) {
      if (event.which === 13) {
        this.stopSlideShow();
        this.props.onActiveItemChange({
          index: index
        });
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.autoPlay) {
        this.props.startSlideShow();
      }
    }
  }, {
    key: "renderBackwardNavigator",
    value: function renderBackwardNavigator() {
      if (this.props.showItemNavigators) {
        var isDisabled = !this.props.circular && this.props.activeItemIndex === 0;
        var buttonClassName = classNames('p-galleria-item-prev p-galleria-item-nav p-link', {
          'p-disabled': isDisabled
        });
        return /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: buttonClassName,
          onClick: this.navBackward,
          disabled: isDisabled
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-galleria-item-prev-icon pi pi-chevron-left"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderForwardNavigator",
    value: function renderForwardNavigator() {
      if (this.props.showItemNavigators) {
        var isDisabled = !this.props.circular && this.props.activeItemIndex === this.props.value.length - 1;
        var buttonClassName = classNames('p-galleria-item-next p-galleria-item-nav p-link', {
          'p-disabled': isDisabled
        });
        return /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          className: buttonClassName,
          onClick: this.navForward,
          disabled: isDisabled
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "p-galleria-item-next-icon pi pi-chevron-right"
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderCaption",
    value: function renderCaption() {
      if (this.props.caption) {
        var content = this.props.caption(this.props.value[this.props.activeItemIndex]);
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-galleria-caption"
        }, content);
      }

      return null;
    }
  }, {
    key: "renderIndicator",
    value: function renderIndicator(index) {
      var _this2 = this;

      var indicator = this.props.indicator && this.props.indicator(index);
      var isActive = this.props.activeItemIndex === index;
      var indicatorItemClassName = classNames('p-galleria-indicator', {
        'p-highlight': isActive
      });

      if (!indicator) {
        indicator = /*#__PURE__*/React__default['default'].createElement("button", {
          type: "button",
          tabIndex: -1,
          className: "p-link"
        }, /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return /*#__PURE__*/React__default['default'].createElement("li", {
        className: indicatorItemClassName,
        key: 'p-galleria-indicator-' + index,
        tabIndex: 0,
        onClick: function onClick() {
          return _this2.onIndicatorClick(index);
        },
        onMouseEnter: function onMouseEnter() {
          return _this2.onIndicatorMouseEnter(index);
        },
        onKeyDown: function onKeyDown(e) {
          return _this2.onIndicatorKeyDown(e, index);
        }
      }, indicator);
    }
  }, {
    key: "renderIndicators",
    value: function renderIndicators() {
      if (this.props.showIndicators) {
        var indicatorsContentClassName = classNames('p-galleria-indicators p-reset', this.props.indicatorsContentClassName);
        var indicators = [];

        for (var i = 0; i < this.props.value.length; i++) {
          indicators.push(this.renderIndicator(i));
        }

        return /*#__PURE__*/React__default['default'].createElement("ul", {
          className: indicatorsContentClassName
        }, indicators);
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var content = this.props.itemTemplate && this.props.itemTemplate(this.props.value[this.props.activeItemIndex]);
      var backwardNavigator = this.renderBackwardNavigator();
      var forwardNavigator = this.renderForwardNavigator();
      var caption = this.renderCaption();
      var indicators = this.renderIndicators();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this3.props.forwardRef(el);
        },
        className: "p-galleria-item-wrapper"
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-item-container"
      }, backwardNavigator, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-item"
      }, content), forwardNavigator, caption), indicators);
    }
  }]);

  return GalleriaItemComponent;
}(React.Component);

var GalleriaItem = /*#__PURE__*/React__default['default'].forwardRef(function (props, ref) {
  return /*#__PURE__*/React__default['default'].createElement(GalleriaItemComponent, _extends({
    forwardRef: ref
  }, props));
});

function _createSuper$1e(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1e(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1e() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var GalleriaThumbnailItem = /*#__PURE__*/function (_Component) {
  _inherits(GalleriaThumbnailItem, _Component);

  var _super = _createSuper$1e(GalleriaThumbnailItem);

  function GalleriaThumbnailItem(props) {
    var _this;

    _classCallCheck(this, GalleriaThumbnailItem);

    _this = _super.call(this, props);
    _this.onItemClick = _this.onItemClick.bind(_assertThisInitialized(_this));
    _this.onItemKeyDown = _this.onItemKeyDown.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(GalleriaThumbnailItem, [{
    key: "onItemClick",
    value: function onItemClick(event) {
      this.props.onItemClick({
        originalEvent: event,
        index: this.props.index
      });
    }
  }, {
    key: "onItemKeyDown",
    value: function onItemKeyDown(event) {
      if (event.which === 13) {
        this.props.onItemClick({
          originalEvent: event,
          index: this.props.index
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var content = this.props.template && this.props.template(this.props.item);
      var itemClassName = classNames(this.props.className, 'p-galleria-thumbnail-item', {
        'p-galleria-thumbnail-item-current': this.props.current,
        'p-galleria-thumbnail-item-active': this.props.active,
        'p-galleria-thumbnail-item-start': this.props.start,
        'p-galleria-thumbnail-item-end': this.props.end
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: itemClassName
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-thumbnail-item-content",
        tabIndex: this.props.active ? 0 : null,
        onClick: this.onItemClick,
        onKeyDown: this.onItemKeyDown
      }, content));
    }
  }]);

  return GalleriaThumbnailItem;
}(React.Component);

_defineProperty(GalleriaThumbnailItem, "defaultProps", {
  index: null,
  template: null,
  item: null,
  current: false,
  active: false,
  start: false,
  end: false,
  className: null,
  onItemClick: null
});

var GalleriaThumbnails = /*#__PURE__*/function (_Component2) {
  _inherits(GalleriaThumbnails, _Component2);

  var _super2 = _createSuper$1e(GalleriaThumbnails);

  function GalleriaThumbnails(props) {
    var _this2;

    _classCallCheck(this, GalleriaThumbnails);

    _this2 = _super2.call(this, props);
    _this2.state = {
      numVisible: props.numVisible,
      totalShiftedItems: 0,
      page: 0
    };
    _this2.navForward = _this2.navForward.bind(_assertThisInitialized(_this2));
    _this2.navBackward = _this2.navBackward.bind(_assertThisInitialized(_this2));
    _this2.onTransitionEnd = _this2.onTransitionEnd.bind(_assertThisInitialized(_this2));
    _this2.onTouchStart = _this2.onTouchStart.bind(_assertThisInitialized(_this2));
    _this2.onTouchMove = _this2.onTouchMove.bind(_assertThisInitialized(_this2));
    _this2.onTouchEnd = _this2.onTouchEnd.bind(_assertThisInitialized(_this2));
    _this2.onItemClick = _this2.onItemClick.bind(_assertThisInitialized(_this2));
    _this2.attributeSelector = UniqueComponentId();
    return _this2;
  }

  _createClass(GalleriaThumbnails, [{
    key: "step",
    value: function step(dir) {
      var totalShiftedItems = this.state.totalShiftedItems + dir;

      if (dir < 0 && -1 * totalShiftedItems + this.state.numVisible > this.props.value.length - 1) {
        totalShiftedItems = this.state.numVisible - this.props.value.length;
      } else if (dir > 0 && totalShiftedItems > 0) {
        totalShiftedItems = 0;
      }

      if (this.props.circular) {
        if (dir < 0 && this.props.value.length - 1 === this.props.activeItemIndex) {
          totalShiftedItems = 0;
        } else if (dir > 0 && this.props.activeItemIndex === 0) {
          totalShiftedItems = this.state.numVisible - this.props.value.length;
        }
      }

      if (this.itemsContainer) {
        DomHandler.removeClass(this.itemsContainer, 'p-items-hidden');
        this.itemsContainer.style.transform = this.props.isVertical ? "translate3d(0, ".concat(totalShiftedItems * (100 / this.state.numVisible), "%, 0)") : "translate3d(".concat(totalShiftedItems * (100 / this.state.numVisible), "%, 0, 0)");
        this.itemsContainer.style.transition = 'transform 500ms ease 0s';
      }

      this.setState({
        totalShiftedItems: totalShiftedItems
      });
    }
  }, {
    key: "stopSlideShow",
    value: function stopSlideShow() {
      if (this.props.slideShowActive && this.props.stopSlideShow) {
        this.props.stopSlideShow();
      }
    }
  }, {
    key: "getMedianItemIndex",
    value: function getMedianItemIndex() {
      var index = Math.floor(this.state.numVisible / 2);
      return this.state.numVisible % 2 ? index : index - 1;
    }
  }, {
    key: "navBackward",
    value: function navBackward(e) {
      this.stopSlideShow();
      var prevItemIndex = this.props.activeItemIndex !== 0 ? this.props.activeItemIndex - 1 : 0;
      var diff = prevItemIndex + this.state.totalShiftedItems;

      if (this.state.numVisible - diff - 1 > this.getMedianItemIndex() && (-1 * this.state.totalShiftedItems !== 0 || this.props.circular)) {
        this.step(1);
      }

      this.props.onActiveItemChange({
        index: this.props.circular && this.props.activeItemIndex === 0 ? this.props.value.length - 1 : prevItemIndex
      });

      if (e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "navForward",
    value: function navForward(e) {
      this.stopSlideShow();
      var nextItemIndex = this.props.activeItemIndex + 1;

      if (nextItemIndex + this.state.totalShiftedItems > this.getMedianItemIndex() && (-1 * this.state.totalShiftedItems < this.getTotalPageNumber() - 1 || this.props.circular)) {
        this.step(-1);
      }

      this.props.onActiveItemChange({
        index: this.props.circular && this.props.value.length - 1 === this.props.activeItemIndex ? 0 : nextItemIndex
      });

      if (e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "onItemClick",
    value: function onItemClick(event) {
      this.stopSlideShow();
      var selectedItemIndex = event.index;

      if (selectedItemIndex !== this.props.activeItemIndex) {
        var diff = selectedItemIndex + this.state.totalShiftedItems;
        var dir = 0;

        if (selectedItemIndex < this.props.activeItemIndex) {
          dir = this.state.numVisible - diff - 1 - this.getMedianItemIndex();

          if (dir > 0 && -1 * this.state.totalShiftedItems !== 0) {
            this.step(dir);
          }
        } else {
          dir = this.getMedianItemIndex() - diff;

          if (dir < 0 && -1 * this.state.totalShiftedItems < this.getTotalPageNumber() - 1) {
            this.step(dir);
          }
        }

        this.props.onActiveItemChange({
          index: selectedItemIndex
        });
      }
    }
  }, {
    key: "onTransitionEnd",
    value: function onTransitionEnd(e) {
      if (this.itemsContainer && e.propertyName === 'transform') {
        DomHandler.addClass(this.itemsContainer, 'p-items-hidden');
        this.itemsContainer.style.transition = '';
      }
    }
  }, {
    key: "onTouchStart",
    value: function onTouchStart(e) {
      var touchobj = e.changedTouches[0];
      this.startPos = {
        x: touchobj.pageX,
        y: touchobj.pageY
      };
    }
  }, {
    key: "onTouchMove",
    value: function onTouchMove(e) {
      if (e.cancelable) {
        e.preventDefault();
      }
    }
  }, {
    key: "onTouchEnd",
    value: function onTouchEnd(e) {
      var touchobj = e.changedTouches[0];

      if (this.props.isVertical) {
        this.changePageOnTouch(e, touchobj.pageY - this.startPos.y);
      } else {
        this.changePageOnTouch(e, touchobj.pageX - this.startPos.x);
      }
    }
  }, {
    key: "changePageOnTouch",
    value: function changePageOnTouch(e, diff) {
      if (diff < 0) {
        // left
        this.navForward(e);
      } else {
        // right
        this.navBackward(e);
      }
    }
  }, {
    key: "getTotalPageNumber",
    value: function getTotalPageNumber() {
      return this.props.value.length > this.state.numVisible ? this.props.value.length - this.state.numVisible + 1 : 0;
    }
  }, {
    key: "createStyle",
    value: function createStyle() {
      if (!this.thumbnailsStyle) {
        this.thumbnailsStyle = document.createElement('style');
        document.body.appendChild(this.thumbnailsStyle);
      }

      var innerHTML = "\n            .p-galleria-thumbnail-items[".concat(this.attributeSelector, "] .p-galleria-thumbnail-item {\n                flex: 1 0 ").concat(100 / this.state.numVisible, "%\n            }\n        ");

      if (this.props.responsiveOptions) {
        this.responsiveOptions = _toConsumableArray(this.props.responsiveOptions);
        this.responsiveOptions.sort(function (data1, data2) {
          var value1 = data1.breakpoint;
          var value2 = data2.breakpoint;
          var result = null;
          if (value1 == null && value2 != null) result = -1;else if (value1 != null && value2 == null) result = 1;else if (value1 == null && value2 == null) result = 0;else if (typeof value1 === 'string' && typeof value2 === 'string') result = value1.localeCompare(value2, undefined, {
            numeric: true
          });else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
          return -1 * result;
        });

        for (var i = 0; i < this.responsiveOptions.length; i++) {
          var res = this.responsiveOptions[i];
          innerHTML += "\n                    @media screen and (max-width: ".concat(res.breakpoint, ") {\n                        .p-galleria-thumbnail-items[").concat(this.attributeSelector, "] .p-galleria-thumbnail-item {\n                            flex: 1 0 ").concat(100 / res.numVisible, "%\n                        }\n                    }\n                ");
        }
      }

      this.thumbnailsStyle.innerHTML = innerHTML;
    }
  }, {
    key: "calculatePosition",
    value: function calculatePosition() {
      if (this.itemsContainer && this.responsiveOptions) {
        var windowWidth = window.innerWidth;
        var matchedResponsiveData = {
          numVisible: this.props.numVisible
        };

        for (var i = 0; i < this.responsiveOptions.length; i++) {
          var res = this.responsiveOptions[i];

          if (parseInt(res.breakpoint, 10) >= windowWidth) {
            matchedResponsiveData = res;
          }
        }

        if (this.state.numVisible !== matchedResponsiveData.numVisible) {
          this.setState({
            numVisible: matchedResponsiveData.numVisible
          });
        }
      }
    }
  }, {
    key: "bindDocumentListeners",
    value: function bindDocumentListeners() {
      var _this3 = this;

      if (!this.documentResizeListener) {
        this.documentResizeListener = function () {
          _this3.calculatePosition();
        };

        window.addEventListener('resize', this.documentResizeListener);
      }
    }
  }, {
    key: "unbindDocumentListeners",
    value: function unbindDocumentListeners() {
      if (this.documentResizeListener) {
        window.removeEventListener('resize', this.documentResizeListener);
        this.documentResizeListener = null;
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.itemsContainer) {
        this.itemsContainer.setAttribute(this.attributeSelector, '');
      }

      this.createStyle();
      this.calculatePosition();

      if (this.props.responsiveOptions) {
        this.bindDocumentListeners();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var totalShiftedItems = this.state.totalShiftedItems;

      if (prevState.numVisible !== this.state.numVisible || prevProps.activeItemIndex !== this.props.activeItemIndex) {
        if (this.props.activeItemIndex <= this.getMedianItemIndex()) {
          totalShiftedItems = 0;
        } else if (this.props.value.length - this.state.numVisible + this.getMedianItemIndex() < this.props.activeItemIndex) {
          totalShiftedItems = this.state.numVisible - this.props.value.length;
        } else if (this.props.value.length - this.state.numVisible < this.props.activeItemIndex && this.state.numVisible % 2 === 0) {
          totalShiftedItems = this.props.activeItemIndex * -1 + this.getMedianItemIndex() + 1;
        } else {
          totalShiftedItems = this.props.activeItemIndex * -1 + this.getMedianItemIndex();
        }

        if (totalShiftedItems !== this.state.totalShiftedItems) {
          this.setState({
            totalShiftedItems: totalShiftedItems
          });
        }

        this.itemsContainer.style.transform = this.props.isVertical ? "translate3d(0, ".concat(totalShiftedItems * (100 / this.state.numVisible), "%, 0)") : "translate3d(".concat(totalShiftedItems * (100 / this.state.numVisible), "%, 0, 0)");

        if (prevProps.activeItemIndex !== this.props.activeItemIndex) {
          DomHandler.removeClass(this.itemsContainer, 'p-items-hidden');
          this.itemsContainer.style.transition = 'transform 500ms ease 0s';
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.props.responsiveOptions) {
        this.unbindDocumentListeners();
      }
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this4 = this;

      return this.props.value.map(function (item, index) {
        var firstIndex = _this4.state.totalShiftedItems * -1,
            lastIndex = firstIndex + _this4.state.numVisible - 1,
            isActive = firstIndex <= index && lastIndex >= index,
            start = firstIndex === index,
            end = lastIndex === index,
            current = _this4.props.activeItemIndex === index;
        return /*#__PURE__*/React__default['default'].createElement(GalleriaThumbnailItem, {
          key: index,
          index: index,
          template: _this4.props.itemTemplate,
          item: item,
          active: isActive,
          start: start,
          end: end,
          onItemClick: _this4.onItemClick,
          current: current
        });
      });
    }
  }, {
    key: "renderBackwardNavigator",
    value: function renderBackwardNavigator() {
      if (this.props.showThumbnailNavigators) {
        var isDisabled = !this.props.circular && this.props.activeItemIndex === 0 || this.props.value.length <= this.state.numVisible;
        var buttonClassName = classNames('p-galleria-thumbnail-prev p-link', {
          'p-disabled': isDisabled
        }),
            iconClassName = classNames('p-galleria-thumbnail-prev-icon pi', {
          'pi-chevron-left': !this.props.isVertical,
          'pi-chevron-up': this.props.isVertical
        });
        return /*#__PURE__*/React__default['default'].createElement("button", {
          className: buttonClassName,
          onClick: this.navBackward,
          disabled: isDisabled
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: iconClassName
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderForwardNavigator",
    value: function renderForwardNavigator() {
      if (this.props.showThumbnailNavigators) {
        var isDisabled = !this.props.circular && this.props.activeItemIndex === this.props.value.length - 1 || this.props.value.length <= this.state.numVisible;
        var buttonClassName = classNames('p-galleria-thumbnail-next p-link', {
          'p-disabled': isDisabled
        }),
            iconClassName = classNames('p-galleria-thumbnail-next-icon pi', {
          'pi-chevron-right': !this.props.isVertical,
          'pi-chevron-down': this.props.isVertical
        });
        return /*#__PURE__*/React__default['default'].createElement("button", {
          className: buttonClassName,
          onClick: this.navForward,
          disabled: isDisabled
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: iconClassName
        }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this5 = this;

      var items = this.renderItems();
      var height = this.props.isVertical ? this.props.contentHeight : '';
      var backwardNavigator = this.renderBackwardNavigator();
      var forwardNavigator = this.renderForwardNavigator();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-thumbnail-container"
      }, backwardNavigator, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-thumbnail-items-container",
        style: {
          'height': height
        }
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this5.itemsContainer = el;
        },
        className: "p-galleria-thumbnail-items",
        onTransitionEnd: this.onTransitionEnd,
        onTouchStart: this.onTouchStart,
        onTouchMove: this.onTouchMove,
        onTouchEnd: this.onTouchEnd
      }, items)), forwardNavigator);
    }
  }, {
    key: "render",
    value: function render() {
      var content = this.renderContent();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-thumbnail-wrapper"
      }, content);
    }
  }]);

  return GalleriaThumbnails;
}(React.Component);

function ownKeys$o(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$o(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$o(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$o(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1d(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1d(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1d() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var Galleria = /*#__PURE__*/function (_Component) {
  _inherits(Galleria, _Component);

  var _super = _createSuper$1d(Galleria);

  function Galleria(props) {
    var _this;

    _classCallCheck(this, Galleria);

    _this = _super.call(this, props);
    _this.state = {
      visible: false,
      numVisible: props.numVisible,
      slideShowActive: false
    };

    if (!_this.props.onItemChange) {
      _this.state = _objectSpread$o(_objectSpread$o({}, _this.state), {}, {
        activeIndex: props.activeIndex
      });
    }

    _this.onActiveItemChange = _this.onActiveItemChange.bind(_assertThisInitialized(_this));
    _this.show = _this.show.bind(_assertThisInitialized(_this));
    _this.hide = _this.hide.bind(_assertThisInitialized(_this));
    _this.startSlideShow = _this.startSlideShow.bind(_assertThisInitialized(_this));
    _this.stopSlideShow = _this.stopSlideShow.bind(_assertThisInitialized(_this));
    _this.onEnter = _this.onEnter.bind(_assertThisInitialized(_this));
    _this.onEntering = _this.onEntering.bind(_assertThisInitialized(_this));
    _this.onEntered = _this.onEntered.bind(_assertThisInitialized(_this));
    _this.onExit = _this.onExit.bind(_assertThisInitialized(_this));
    _this.onExited = _this.onExited.bind(_assertThisInitialized(_this));
    _this.galleriaRef = /*#__PURE__*/React__default['default'].createRef();
    return _this;
  }

  _createClass(Galleria, [{
    key: "activeItemIndex",
    get: function get() {
      return this.props.onItemChange ? this.props.activeIndex : this.state.activeIndex;
    }
  }, {
    key: "onActiveItemChange",
    value: function onActiveItemChange(event) {
      if (this.props.onItemChange) {
        this.props.onItemChange(event);
      } else {
        this.setState({
          activeIndex: event.index
        });
      }
    }
  }, {
    key: "show",
    value: function show() {
      this.setState({
        visible: true
      });
    }
  }, {
    key: "hide",
    value: function hide() {
      this.setState({
        visible: false
      });
    }
  }, {
    key: "onEnter",
    value: function onEnter() {
      DomHandler.addClass(document.body, 'p-overflow-hidden');
    }
  }, {
    key: "onEntering",
    value: function onEntering() {
      ZIndexUtils.set('modal', this.mask, this.props.baseZIndex);
      DomHandler.addMultipleClasses(this.mask, 'p-component-overlay p-component-overlay-enter');
    }
  }, {
    key: "onEntered",
    value: function onEntered() {
      this.props.onShow && this.props.onShow();
    }
  }, {
    key: "onExit",
    value: function onExit() {
      DomHandler.removeClass(document.body, 'p-overflow-hidden');
      DomHandler.addClass(this.mask, 'p-component-overlay-leave');
    }
  }, {
    key: "onExited",
    value: function onExited() {
      ZIndexUtils.clear(this.mask);
      this.props.onHide && this.props.onHide();
    }
  }, {
    key: "isAutoPlayActive",
    value: function isAutoPlayActive() {
      return this.state.slideShowActive;
    }
  }, {
    key: "startSlideShow",
    value: function startSlideShow() {
      var _this2 = this;

      this.interval = setInterval(function () {
        var activeIndex = _this2.props.circular && _this2.props.value.length - 1 === _this2.activeItemIndex ? 0 : _this2.activeItemIndex + 1;

        _this2.onActiveItemChange({
          index: activeIndex
        });
      }, this.props.transitionInterval);
      this.setState({
        slideShowActive: true
      });
    }
  }, {
    key: "stopSlideShow",
    value: function stopSlideShow() {
      if (this.interval) {
        clearInterval(this.interval);
      }

      this.setState({
        slideShowActive: false
      });
    }
  }, {
    key: "getPositionClassName",
    value: function getPositionClassName(preClassName, position) {
      var positions = ['top', 'left', 'bottom', 'right'];
      var pos = positions.find(function (item) {
        return item === position;
      });
      return pos ? "".concat(preClassName, "-").concat(pos) : '';
    }
  }, {
    key: "isVertical",
    value: function isVertical() {
      return this.props.thumbnailsPosition === 'left' || this.props.thumbnailsPosition === 'right';
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevProps.value !== this.props.value) {
        if (this.props.value && this.props.value.length < this.state.numVisible) {
          this.setState({
            numVisible: this.props.value.length
          });
        }
      }

      if (prevProps.numVisible !== this.props.numVisible) {
        this.setState({
          numVisible: this.props.numVisible
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.state.slideShowActive) {
        this.stopSlideShow();
      }

      ZIndexUtils.clear(this.mask);
    }
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      if (this.props.header) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-galleria-header"
        }, this.props.header);
      }

      return null;
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      if (this.props.footer) {
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "p-galleria-footer"
        }, this.props.footer);
      }

      return null;
    }
  }, {
    key: "renderElement",
    value: function renderElement() {
      var _this3 = this;

      var isVertical = this.isVertical();
      var thumbnailsPosClassName = this.props.showThumbnails && this.getPositionClassName('p-galleria-thumbnails', this.props.thumbnailsPosition);
      var indicatorPosClassName = this.props.showIndicators && this.getPositionClassName('p-galleria-indicators', this.props.indicatorsPosition);
      var galleriaClassName = classNames('p-galleria p-component', this.props.className, {
        'p-galleria-fullscreen': this.props.fullScreen,
        'p-galleria-indicator-onitem': this.props.showIndicatorsOnItem,
        'p-galleria-item-nav-onhover': this.props.showItemNavigatorsOnHover && !this.props.fullScreen
      }, thumbnailsPosClassName, indicatorPosClassName);
      var closeIcon = this.props.fullScreen && /*#__PURE__*/React__default['default'].createElement("button", {
        type: "button",
        className: "p-galleria-close p-link",
        onClick: this.hide
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-galleria-close-icon pi pi-times"
      }), /*#__PURE__*/React__default['default'].createElement(Ripple, null));
      var header = this.renderHeader();
      var footer = this.renderFooter();
      var element = /*#__PURE__*/React__default['default'].createElement("div", {
        ref: this.galleriaRef,
        id: this.props.id,
        className: galleriaClassName,
        style: this.props.style
      }, closeIcon, header, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-galleria-content"
      }, /*#__PURE__*/React__default['default'].createElement(GalleriaItem, {
        ref: function ref(el) {
          return _this3.previewContent = el;
        },
        value: this.props.value,
        activeItemIndex: this.activeItemIndex,
        onActiveItemChange: this.onActiveItemChange,
        itemTemplate: this.props.item,
        circular: this.props.circular,
        caption: this.props.caption,
        showIndicators: this.props.showIndicators,
        changeItemOnIndicatorHover: this.props.changeItemOnIndicatorHover,
        indicator: this.props.indicator,
        showItemNavigators: this.props.showItemNavigators,
        autoPlay: this.props.autoPlay,
        slideShowActive: this.state.slideShowActive,
        startSlideShow: this.startSlideShow,
        stopSlideShow: this.stopSlideShow
      }), this.props.showThumbnails && /*#__PURE__*/React__default['default'].createElement(GalleriaThumbnails, {
        value: this.props.value,
        activeItemIndex: this.activeItemIndex,
        onActiveItemChange: this.onActiveItemChange,
        itemTemplate: this.props.thumbnail,
        numVisible: this.state.numVisible,
        responsiveOptions: this.props.responsiveOptions,
        circular: this.props.circular,
        isVertical: isVertical,
        contentHeight: this.props.verticalThumbnailViewPortHeight,
        showThumbnailNavigators: this.props.showThumbnailNavigators,
        autoPlay: this.props.autoPlay,
        slideShowActive: this.state.slideShowActive,
        stopSlideShow: this.stopSlideShow
      })), footer);
      return element;
    }
  }, {
    key: "renderGalleria",
    value: function renderGalleria() {
      var _this4 = this;

      var element = this.renderElement();

      if (this.props.fullScreen) {
        var maskClassName = classNames('p-galleria-mask', {
          'p-galleria-visible': this.state.visible
        });
        var galleriaWrapper = /*#__PURE__*/React__default['default'].createElement("div", {
          ref: function ref(el) {
            return _this4.mask = el;
          },
          className: maskClassName
        }, /*#__PURE__*/React__default['default'].createElement(CSSTransition, {
          nodeRef: this.galleriaRef,
          classNames: "p-galleria",
          in: this.state.visible,
          timeout: {
            enter: 150,
            exit: 150
          },
          options: this.props.transitionOptions,
          unmountOnExit: true,
          onEnter: this.onEnter,
          onEntering: this.onEntering,
          onEntered: this.onEntered,
          onExit: this.onExit,
          onExited: this.onExited
        }, element));
        return /*#__PURE__*/React__default['default'].createElement(Portal, {
          element: galleriaWrapper
        });
      } else {
        return element;
      }
    }
  }, {
    key: "render",
    value: function render() {
      return this.props.value && this.props.value.length > 0 && this.renderGalleria();
    }
  }]);

  return Galleria;
}(React.Component);

_defineProperty(Galleria, "defaultProps", {
  id: null,
  value: null,
  activeIndex: 0,
  fullScreen: false,
  item: null,
  thumbnail: null,
  indicator: null,
  caption: null,
  className: null,
  style: null,
  header: null,
  footer: null,
  numVisible: 3,
  responsiveOptions: null,
  showItemNavigators: false,
  showThumbnailNavigators: true,
  showItemNavigatorsOnHover: false,
  changeItemOnIndicatorHover: false,
  circular: false,
  autoPlay: false,
  transitionInterval: 4000,
  showThumbnails: true,
  thumbnailsPosition: "bottom",
  verticalThumbnailViewPortHeight: "300px",
  showIndicators: false,
  showIndicatorsOnItem: false,
  indicatorsPosition: "bottom",
  baseZIndex: 0,
  transitionOptions: null,
  onItemChange: null
});

function _createForOfIteratorHelper$9(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray$9(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray$9(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray$9(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray$9(o, minLen); }

function _arrayLikeToArray$9(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper$1c(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1c(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1c() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var GMap = /*#__PURE__*/function (_Component) {
  _inherits(GMap, _Component);

  var _super = _createSuper$1c(GMap);

  function GMap() {
    _classCallCheck(this, GMap);

    return _super.apply(this, arguments);
  }

  _createClass(GMap, [{
    key: "initMap",
    value: function initMap() {
      this.map = new google.maps.Map(this.container, this.props.options);

      if (this.props.onMapReady) {
        this.props.onMapReady({
          map: this.map
        });
      }

      this.initOverlays(this.props.overlays);
      this.bindMapEvent('click', this.props.onMapClick);
      this.bindMapEvent('dragend', this.props.onMapDragEnd);
      this.bindMapEvent('zoom_changed', this.props.onZoomChanged);
    }
  }, {
    key: "initOverlays",
    value: function initOverlays(overlays) {
      if (overlays) {
        var _iterator = _createForOfIteratorHelper$9(overlays),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var overlay = _step.value;
            overlay.setMap(this.map);
            this.bindOverlayEvents(overlay);
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
  }, {
    key: "bindOverlayEvents",
    value: function bindOverlayEvents(overlay) {
      var _this = this;

      overlay.addListener('click', function (event) {
        if (_this.props.onOverlayClick) {
          _this.props.onOverlayClick({
            originalEvent: event,
            overlay: overlay,
            map: _this.map
          });
        }
      });

      if (overlay.getDraggable()) {
        this.bindDragEvents(overlay);
      }
    }
  }, {
    key: "bindDragEvents",
    value: function bindDragEvents(overlay) {
      this.bindDragEvent(overlay, 'dragstart', this.props.onOverlayDragStart);
      this.bindDragEvent(overlay, 'drag', this.props.onOverlayDrag);
      this.bindDragEvent(overlay, 'dragend', this.props.onOverlayDragEnd);
    }
  }, {
    key: "bindMapEvent",
    value: function bindMapEvent(eventName, callback) {
      this.map.addListener(eventName, function (event) {
        if (callback) {
          callback(event);
        }
      });
    }
  }, {
    key: "bindDragEvent",
    value: function bindDragEvent(overlay, eventName, callback) {
      var _this2 = this;

      overlay.addListener(eventName, function (event) {
        if (callback) {
          callback({
            originalEvent: event,
            overlay: overlay,
            map: _this2.map
          });
        }
      });
    }
  }, {
    key: "getMap",
    value: function getMap() {
      return this.map;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState, snapshot) {
      if (prevProps.overlays !== this.props.overlays) {
        if (prevProps.overlays) {
          var _iterator2 = _createForOfIteratorHelper$9(prevProps.overlays),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var overlay = _step2.value;
              google.maps.event.clearInstanceListeners(overlay);
              overlay.setMap(null);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }

        this.initOverlays(this.props.overlays);
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.initMap();
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/React__default['default'].createElement("div", {
        ref: function ref(el) {
          return _this3.container = el;
        },
        style: this.props.style,
        className: this.props.className
      });
    }
  }]);

  return GMap;
}(React.Component);

_defineProperty(GMap, "defaultProps", {
  options: null,
  overlays: null,
  style: null,
  className: null,
  onMapReady: null,
  onMapClick: null,
  onMapDragEnd: null,
  onZoomChanged: null,
  onOverlayDragStart: null,
  onOverlayDrag: null,
  onOverlayDragEnd: null,
  onOverlayClick: null
});

function _createSuper$1b(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1b(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1b() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var InplaceDisplay = /*#__PURE__*/function (_Component) {
  _inherits(InplaceDisplay, _Component);

  var _super = _createSuper$1b(InplaceDisplay);

  function InplaceDisplay() {
    _classCallCheck(this, InplaceDisplay);

    return _super.apply(this, arguments);
  }

  _createClass(InplaceDisplay, [{
    key: "render",
    value: function render() {
      return this.props.children;
    }
  }]);

  return InplaceDisplay;
}(React.Component);
var InplaceContent = /*#__PURE__*/function (_Component2) {
  _inherits(InplaceContent, _Component2);

  var _super2 = _createSuper$1b(InplaceContent);

  function InplaceContent() {
    _classCallCheck(this, InplaceContent);

    return _super2.apply(this, arguments);
  }

  _createClass(InplaceContent, [{
    key: "render",
    value: function render() {
      return this.props.children;
    }
  }]);

  return InplaceContent;
}(React.Component);
var Inplace = /*#__PURE__*/function (_Component3) {
  _inherits(Inplace, _Component3);

  var _super3 = _createSuper$1b(Inplace);

  function Inplace(props) {
    var _this;

    _classCallCheck(this, Inplace);

    _this = _super3.call(this, props);

    if (!_this.props.onToggle) {
      _this.state = {
        active: false
      };
    }

    _this.open = _this.open.bind(_assertThisInitialized(_this));
    _this.close = _this.close.bind(_assertThisInitialized(_this));
    _this.onDisplayKeyDown = _this.onDisplayKeyDown.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Inplace, [{
    key: "open",
    value: function open(event) {
      if (this.props.disabled) {
        return;
      }

      if (this.props.onOpen) {
        this.props.onOpen(event);
      }

      if (this.props.onToggle) {
        this.props.onToggle({
          originalEvent: event,
          value: true
        });
      } else {
        this.setState({
          active: true
        });
      }
    }
  }, {
    key: "close",
    value: function close(event) {
      if (this.props.onClose) {
        this.props.onClose(event);
      }

      if (this.props.onToggle) {
        this.props.onToggle({
          originalEvent: event,
          value: false
        });
      } else {
        this.setState({
          active: false
        });
      }
    }
  }, {
    key: "onDisplayKeyDown",
    value: function onDisplayKeyDown(event) {
      if (event.key === 'Enter') {
        this.open(event);
        event.preventDefault();
      }
    }
  }, {
    key: "isActive",
    value: function isActive() {
      return this.props.onToggle ? this.props.active : this.state.active;
    }
  }, {
    key: "renderDisplay",
    value: function renderDisplay(content) {
      var className = classNames('p-inplace-display', {
        'p-disabled': this.props.disabled
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: className,
        onClick: this.open,
        onKeyDown: this.onDisplayKeyDown,
        tabIndex: this.props.tabIndex,
        "aria-label": this.props.ariaLabel
      }, content);
    }
  }, {
    key: "renderCloseButton",
    value: function renderCloseButton() {
      if (this.props.closable) {
        return /*#__PURE__*/React__default['default'].createElement(Button, {
          type: "button",
          className: "p-inplace-content-close",
          icon: "pi pi-times",
          onClick: this.close
        });
      }

      return null;
    }
  }, {
    key: "renderContent",
    value: function renderContent(content) {
      var closeButton = this.renderCloseButton();
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-inplace-content"
      }, content, closeButton);
    }
  }, {
    key: "renderChildren",
    value: function renderChildren() {
      var _this2 = this;

      var active = this.isActive();
      return React__default['default'].Children.map(this.props.children, function (child, i) {
        if (active && child.type === InplaceContent) {
          return _this2.renderContent(child);
        } else if (!active && child.type === InplaceDisplay) {
          return _this2.renderDisplay(child);
        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      var className = classNames('p-inplace p-component', {
        'p-inplace-closable': this.props.closable
      }, this.props.className);
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: className
      }, this.renderChildren());
    }
  }]);

  return Inplace;
}(React.Component);

_defineProperty(Inplace, "defaultProps", {
  style: null,
  className: null,
  active: false,
  closable: false,
  disabled: false,
  tabIndex: 0,
  ariaLabel: null,
  onOpen: null,
  onClose: null,
  onToggle: null
});

function ownKeys$n(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$n(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$n(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$n(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$1a(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$1a(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$1a() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var InputMask = /*#__PURE__*/function (_Component) {
  _inherits(InputMask, _Component);

  var _super = _createSuper$1a(InputMask);

  function InputMask(props) {
    var _this;

    _classCallCheck(this, InputMask);

    _this = _super.call(this, props);
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.onKeyPress = _this.onKeyPress.bind(_assertThisInitialized(_this));
    _this.onInput = _this.onInput.bind(_assertThisInitialized(_this));
    _this.handleInputChange = _this.handleInputChange.bind(_assertThisInitialized(_this));
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(InputMask, [{
    key: "caret",
    value: function caret(first, last) {
      var range, begin, end;
      var inputEl = this.inputRef && this.inputRef.current;

      if (!inputEl || !inputEl.offsetParent || inputEl !== document.activeElement) {
        return;
      }

      if (typeof first === 'number') {
        begin = first;
        end = typeof last === 'number' ? last : begin;

        if (inputEl.setSelectionRange) {
          inputEl.setSelectionRange(begin, end);
        } else if (inputEl['createTextRange']) {
          range = inputEl['createTextRange']();
          range.collapse(true);
          range.moveEnd('character', end);
          range.moveStart('character', begin);
          range.select();
        }
      } else {
        if (inputEl.setSelectionRange) {
          begin = inputEl.selectionStart;
          end = inputEl.selectionEnd;
        } else if (document['selection'] && document['selection'].createRange) {
          range = document['selection'].createRange();
          begin = 0 - range.duplicate().moveStart('character', -100000);
          end = begin + range.text.length;
        }

        return {
          begin: begin,
          end: end
        };
      }
    }
  }, {
    key: "isCompleted",
    value: function isCompleted() {
      for (var i = this.firstNonMaskPos; i <= this.lastRequiredNonMaskPos; i++) {
        if (this.tests[i] && this.buffer[i] === this.getPlaceholder(i)) {
          return false;
        }
      }

      return true;
    }
  }, {
    key: "getPlaceholder",
    value: function getPlaceholder(i) {
      if (i < this.props.slotChar.length) {
        return this.props.slotChar.charAt(i);
      }

      return this.props.slotChar.charAt(0);
    }
  }, {
    key: "getValue",
    value: function getValue() {
      return this.props.unmask ? this.getUnmaskedValue() : this.inputRef && this.inputRef.current && this.inputRef.current.value;
    }
  }, {
    key: "seekNext",
    value: function seekNext(pos) {
      while (++pos < this.len && !this.tests[pos]) {
      }

      return pos;
    }
  }, {
    key: "seekPrev",
    value: function seekPrev(pos) {
      while (--pos >= 0 && !this.tests[pos]) {
      }

      return pos;
    }
  }, {
    key: "shiftL",
    value: function shiftL(begin, end) {
      var i, j;

      if (begin < 0) {
        return;
      }

      for (i = begin, j = this.seekNext(end); i < this.len; i++) {
        if (this.tests[i]) {
          if (j < this.len && this.tests[i].test(this.buffer[j])) {
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = this.getPlaceholder(j);
          } else {
            break;
          }

          j = this.seekNext(j);
        }
      }

      this.writeBuffer();
      this.caret(Math.max(this.firstNonMaskPos, begin));
    }
  }, {
    key: "shiftR",
    value: function shiftR(pos) {
      var i, c, j, t;

      for (i = pos, c = this.getPlaceholder(pos); i < this.len; i++) {
        if (this.tests[i]) {
          j = this.seekNext(i);
          t = this.buffer[i];
          this.buffer[i] = c;

          if (j < this.len && this.tests[j].test(t)) {
            c = t;
          } else {
            break;
          }
        }
      }
    }
  }, {
    key: "handleAndroidInput",
    value: function handleAndroidInput(e) {
      var curVal = this.inputRef.current.value;
      var pos = this.caret();

      if (this.oldVal && this.oldVal.length && this.oldVal.length > curVal.length) {
        // a deletion or backspace happened
        this.checkVal(true);

        while (pos.begin > 0 && !this.tests[pos.begin - 1]) {
          pos.begin--;
        }

        if (pos.begin === 0) {
          while (pos.begin < this.firstNonMaskPos && !this.tests[pos.begin]) {
            pos.begin++;
          }
        }

        this.caret(pos.begin, pos.begin);
      } else {
        this.checkVal(true);

        while (pos.begin < this.len && !this.tests[pos.begin]) {
          pos.begin++;
        }

        this.caret(pos.begin, pos.begin);
      }

      if (this.props.onComplete && this.isCompleted()) {
        this.props.onComplete({
          originalEvent: e,
          value: this.getValue()
        });
      }
    }
  }, {
    key: "onBlur",
    value: function onBlur(e) {
      this.focus = false;
      this.checkVal();
      this.updateModel(e);
      this.updateFilledState();

      if (this.props.onBlur) {
        this.props.onBlur(e);
      }

      if (this.inputRef.current.value !== this.focusText) {
        var event = document.createEvent('HTMLEvents');
        event.initEvent('change', true, false);
        this.inputRef.current.dispatchEvent(event);
      }
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(e) {
      if (this.props.readOnly) {
        return;
      }

      var k = e.which || e.keyCode,
          pos,
          begin,
          end;
      var iPhone = /iphone/i.test(DomHandler.getUserAgent());
      this.oldVal = this.inputRef.current.value; //backspace, delete, and escape get special treatment

      if (k === 8 || k === 46 || iPhone && k === 127) {
        pos = this.caret();
        begin = pos.begin;
        end = pos.end;

        if (end - begin === 0) {
          begin = k !== 46 ? this.seekPrev(begin) : end = this.seekNext(begin - 1);
          end = k === 46 ? this.seekNext(end) : end;
        }

        this.clearBuffer(begin, end);
        this.shiftL(begin, end - 1);
        this.updateModel(e);
        e.preventDefault();
      } else if (k === 13) {
        // enter
        this.onBlur(e);
        this.updateModel(e);
      } else if (k === 27) {
        // escape
        this.inputRef.current.value = this.focusText;
        this.caret(0, this.checkVal());
        this.updateModel(e);
        e.preventDefault();
      }
    }
  }, {
    key: "onKeyPress",
    value: function onKeyPress(e) {
      var _this2 = this;

      if (this.props.readOnly) {
        return;
      }

      var k = e.which || e.keyCode,
          pos = this.caret(),
          p,
          c,
          next,
          completed;

      if (e.ctrlKey || e.altKey || e.metaKey || k < 32) {
        //Ignore
        return;
      } else if (k && k !== 13) {
        if (pos.end - pos.begin !== 0) {
          this.clearBuffer(pos.begin, pos.end);
          this.shiftL(pos.begin, pos.end - 1);
        }

        p = this.seekNext(pos.begin - 1);

        if (p < this.len) {
          c = String.fromCharCode(k);

          if (this.tests[p].test(c)) {
            this.shiftR(p);
            this.buffer[p] = c;
            this.writeBuffer();
            next = this.seekNext(p);

            if (/android/i.test(DomHandler.getUserAgent())) {
              //Path for CSP Violation on FireFox OS 1.1
              var proxy = function proxy() {
                _this2.caret(next);
              };

              setTimeout(proxy, 0);
            } else {
              this.caret(next);
            }

            if (pos.begin <= this.lastRequiredNonMaskPos) {
              completed = this.isCompleted();
            }
          }
        }

        e.preventDefault();
      }

      this.updateModel(e);

      if (this.props.onComplete && completed) {
        this.props.onComplete({
          originalEvent: e,
          value: this.getValue()
        });
      }
    }
  }, {
    key: "clearBuffer",
    value: function clearBuffer(start, end) {
      var i;

      for (i = start; i < end && i < this.len; i++) {
        if (this.tests[i]) {
          this.buffer[i] = this.getPlaceholder(i);
        }
      }
    }
  }, {
    key: "writeBuffer",
    value: function writeBuffer() {
      this.inputRef.current.value = this.buffer.join('');
    }
  }, {
    key: "checkVal",
    value: function checkVal(allow) {
      this.isValueChecked = true; //try to place characters where they belong

      var test = this.inputRef.current.value,
          lastMatch = -1,
          i,
          c,
          pos;

      for (i = 0, pos = 0; i < this.len; i++) {
        if (this.tests[i]) {
          this.buffer[i] = this.getPlaceholder(i);

          while (pos++ < test.length) {
            c = test.charAt(pos - 1);

            if (this.tests[i].test(c)) {
              this.buffer[i] = c;
              lastMatch = i;
              break;
            }
          }

          if (pos > test.length) {
            this.clearBuffer(i + 1, this.len);
            break;
          }
        } else {
          if (this.buffer[i] === test.charAt(pos)) {
            pos++;
          }

          if (i < this.partialPosition) {
            lastMatch = i;
          }
        }
      }

      if (allow) {
        this.writeBuffer();
      } else if (lastMatch + 1 < this.partialPosition) {
        if (this.props.autoClear || this.buffer.join('') === this.defaultBuffer) {
          // Invalid value. Remove it and replace it with the
          // mask, which is the default behavior.
          if (this.inputRef.current.value) this.inputRef.current.value = '';
          this.clearBuffer(0, this.len);
        } else {
          // Invalid value, but we opt to show the value to the
          // user and allow them to correct their mistake.
          this.writeBuffer();
        }
      } else {
        this.writeBuffer();
        this.inputRef.current.value = this.inputRef.current.value.substring(0, lastMatch + 1);
      }

      return this.partialPosition ? i : this.firstNonMaskPos;
    }
  }, {
    key: "onFocus",
    value: function onFocus(e) {
      var _this3 = this;

      if (this.props.readOnly) {
        return;
      }

      this.focus = true;
      clearTimeout(this.caretTimeoutId);
      var pos;
      this.focusText = this.inputRef.current.value;
      pos = this.checkVal();
      this.caretTimeoutId = setTimeout(function () {
        if (_this3.inputRef.current !== document.activeElement) {
          return;
        }

        _this3.writeBuffer();

        if (pos === _this3.props.mask.replace("?", "").length) {
          _this3.caret(0, pos);
        } else {
          _this3.caret(pos);
        }

        _this3.updateFilledState();
      }, 10);

      if (this.props.onFocus) {
        this.props.onFocus(e);
      }
    }
  }, {
    key: "onInput",
    value: function onInput(event) {
      if (this.androidChrome) this.handleAndroidInput(event);else this.handleInputChange(event);
    }
  }, {
    key: "handleInputChange",
    value: function handleInputChange(e) {
      if (this.props.readOnly) {
        return;
      }

      var pos = this.checkVal(true);
      this.caret(pos);
      this.updateModel(e);

      if (this.props.onComplete && this.isCompleted()) {
        this.props.onComplete({
          originalEvent: e,
          value: this.getValue()
        });
      }
    }
  }, {
    key: "getUnmaskedValue",
    value: function getUnmaskedValue() {
      var unmaskedBuffer = [];

      for (var i = 0; i < this.buffer.length; i++) {
        var c = this.buffer[i];

        if (this.tests[i] && c !== this.getPlaceholder(i)) {
          unmaskedBuffer.push(c);
        }
      }

      return unmaskedBuffer.join('');
    }
  }, {
    key: "updateModel",
    value: function updateModel(e) {
      if (this.props.onChange) {
        var val = this.props.unmask ? this.getUnmaskedValue() : e && e.target.value;
        this.props.onChange({
          originalEvent: e,
          value: this.defaultBuffer !== val ? val : '',
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: this.defaultBuffer !== val ? val : ''
          }
        });
      }
    }
  }, {
    key: "updateFilledState",
    value: function updateFilledState() {
      if (this.inputRef && this.inputRef.current && this.inputRef.current.value && this.inputRef.current.value.length > 0) DomHandler.addClass(this.inputRef.current, 'p-filled');else DomHandler.removeClass(this.inputRef.current, 'p-filled');
    }
  }, {
    key: "updateValue",
    value: function updateValue(allow) {
      var _this4 = this;

      var pos;

      if (this.inputRef && this.inputRef.current) {
        if (this.props.value == null) {
          this.inputRef.current.value = '';
        } else {
          this.inputRef.current.value = this.props.value;
          pos = this.checkVal(allow);
          setTimeout(function () {
            if (_this4.inputRef && _this4.inputRef.current) {
              _this4.writeBuffer();

              return _this4.checkVal(allow);
            }
          }, 10);
        }

        this.focusText = this.inputRef.current.value;
      }

      this.updateFilledState();
      return pos;
    }
  }, {
    key: "isValueUpdated",
    value: function isValueUpdated() {
      return this.props.unmask ? this.props.value !== this.getUnmaskedValue() : this.defaultBuffer !== this.inputRef.current.value && this.inputRef.current.value !== this.props.value;
    }
  }, {
    key: "init",
    value: function init() {
      if (this.props.mask) {
        this.tests = [];
        this.partialPosition = this.props.mask.length;
        this.len = this.props.mask.length;
        this.firstNonMaskPos = null;
        this.defs = {
          '9': '[0-9]',
          'a': '[A-Za-z]',
          '*': '[A-Za-z0-9]'
        };
        var ua = DomHandler.getUserAgent();
        this.androidChrome = /chrome/i.test(ua) && /android/i.test(ua);
        var maskTokens = this.props.mask.split('');

        for (var i = 0; i < maskTokens.length; i++) {
          var c = maskTokens[i];

          if (c === '?') {
            this.len--;
            this.partialPosition = i;
          } else if (this.defs[c]) {
            this.tests.push(new RegExp(this.defs[c]));

            if (this.firstNonMaskPos === null) {
              this.firstNonMaskPos = this.tests.length - 1;
            }

            if (i < this.partialPosition) {
              this.lastRequiredNonMaskPos = this.tests.length - 1;
            }
          } else {
            this.tests.push(null);
          }
        }

        this.buffer = [];

        for (var _i = 0; _i < maskTokens.length; _i++) {
          var _c = maskTokens[_i];

          if (_c !== '?') {
            if (this.defs[_c]) this.buffer.push(this.getPlaceholder(_i));else this.buffer.push(_c);
          }
        }

        this.defaultBuffer = this.buffer.join('');
      }
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();
      this.init();
      this.updateValue();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$n({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }

      if (this.isValueUpdated()) {
        this.updateValue();
      }

      if (prevProps.mask !== this.props.mask) {
        this.init();
        this.caret(this.updateValue(true));
        this.updateModel();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.inputRef.current,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "render",
    value: function render() {
      var inputMaskClassName = classNames('p-inputmask', this.props.className);
      return /*#__PURE__*/React__default['default'].createElement(InputText, {
        id: this.props.id,
        ref: this.inputRef,
        type: this.props.type,
        name: this.props.name,
        style: this.props.style,
        className: inputMaskClassName,
        placeholder: this.props.placeholder,
        size: this.props.size,
        maxLength: this.props.maxlength,
        tabIndex: this.props.tabIndex,
        disabled: this.props.disabled,
        readOnly: this.props.readOnly,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        onKeyDown: this.onKeyDown,
        onKeyPress: this.onKeyPress,
        onInput: this.onInput,
        onPaste: this.handleInputChange,
        required: this.props.required,
        "aria-labelledby": this.props.ariaLabelledBy
      });
    }
  }]);

  return InputMask;
}(React.Component);

_defineProperty(InputMask, "defaultProps", {
  id: null,
  inputRef: null,
  value: null,
  type: 'text',
  mask: null,
  slotChar: '_',
  autoClear: true,
  unmask: false,
  style: null,
  className: null,
  placeholder: null,
  size: null,
  maxlength: null,
  tabIndex: null,
  disabled: false,
  readOnly: false,
  name: null,
  required: false,
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  onComplete: null,
  onChange: null,
  onFocus: null,
  onBlur: null
});

function ownKeys$m(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$m(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$m(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$m(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$19(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$19(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$19() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var InputSwitch = /*#__PURE__*/function (_Component) {
  _inherits(InputSwitch, _Component);

  var _super = _createSuper$19(InputSwitch);

  function InputSwitch(props) {
    var _this;

    _classCallCheck(this, InputSwitch);

    _this = _super.call(this, props);
    _this.state = {
      focused: false
    };
    _this.onClick = _this.onClick.bind(_assertThisInitialized(_this));
    _this.toggle = _this.toggle.bind(_assertThisInitialized(_this));
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyDown = _this.onKeyDown.bind(_assertThisInitialized(_this));
    _this.inputRef = /*#__PURE__*/React.createRef(_this.props.inputRef);
    return _this;
  }

  _createClass(InputSwitch, [{
    key: "onClick",
    value: function onClick(event) {
      if (this.props.disabled) {
        return;
      }

      this.toggle(event);
      this.inputRef.current.focus();
    }
  }, {
    key: "toggle",
    value: function toggle(event) {
      if (this.props.onChange) {
        var value = this.isChecked() ? this.props.falseValue : this.props.trueValue;
        this.props.onChange({
          originalEvent: event,
          value: value,
          stopPropagation: function stopPropagation() {},
          preventDefault: function preventDefault() {},
          target: {
            name: this.props.name,
            id: this.props.id,
            value: value
          }
        });
      }
    }
  }, {
    key: "onFocus",
    value: function onFocus(event) {
      var _this2 = this;

      var currentEvent = event;
      this.setState({
        focused: true
      }, function () {
        if (_this2.props.onFocus) {
          _this2.props.onFocus(currentEvent);
        }
      });
    }
  }, {
    key: "onBlur",
    value: function onBlur(event) {
      var _this3 = this;

      var currentEvent = event;
      this.setState({
        focused: false
      }, function () {
        if (_this3.props.onBlur) {
          _this3.props.onBlur(currentEvent);
        }
      });
    }
  }, {
    key: "onKeyDown",
    value: function onKeyDown(event) {
      if (event.key === 'Enter') {
        this.onClick(event);
      }
    }
  }, {
    key: "updateInputRef",
    value: function updateInputRef() {
      var ref = this.props.inputRef;

      if (ref) {
        if (typeof ref === 'function') {
          ref(this.inputRef.current);
        } else {
          ref.current = this.inputRef.current;
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateInputRef();

      if (this.props.tooltip) {
        this.renderTooltip();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.tooltip !== this.props.tooltip || prevProps.tooltipOptions !== this.props.tooltipOptions) {
        if (this.tooltip) this.tooltip.update(_objectSpread$m({
          content: this.props.tooltip
        }, this.props.tooltipOptions || {}));else this.renderTooltip();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tooltip) {
        this.tooltip.destroy();
        this.tooltip = null;
      }
    }
  }, {
    key: "renderTooltip",
    value: function renderTooltip() {
      this.tooltip = tip({
        target: this.container,
        content: this.props.tooltip,
        options: this.props.tooltipOptions
      });
    }
  }, {
    key: "isChecked",
    value: function isChecked() {
      return this.props.checked === this.props.trueValue;
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var className = classNames('p-inputswitch p-component', {
        'p-inputswitch-checked': this.isChecked(),
        'p-disabled': this.props.disabled,
        'p-inputswitch-focus': this.state.focused
      }, this.props.className);
      var inputSwitchProps = ObjectUtils.findDiffKeys(this.props, InputSwitch.defaultProps);
      return /*#__PURE__*/React__default['default'].createElement("div", _extends({
        ref: function ref(el) {
          return _this4.container = el;
        },
        id: this.props.id,
        className: className,
        style: this.props.style,
        onClick: this.onClick,
        role: "checkbox",
        "aria-checked": this.isChecked()
      }, inputSwitchProps), /*#__PURE__*/React__default['default'].createElement("div", {
        className: "p-hidden-accessible"
      }, /*#__PURE__*/React__default['default'].createElement("input", {
        ref: this.inputRef,
        type: "checkbox",
        id: this.props.inputId,
        name: this.props.name,
        checked: this.isChecked(),
        onChange: this.toggle,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        onKeyDown: this.onKeyDown,
        disabled: this.props.disabled,
        role: "switch",
        "aria-checked": this.isChecked(),
        "aria-labelledby": this.props.ariaLabelledBy
      })), /*#__PURE__*/React__default['default'].createElement("span", {
        className: "p-inputswitch-slider"
      }));
    }
  }]);

  return InputSwitch;
}(React.Component);

_defineProperty(InputSwitch, "defaultProps", {
  id: null,
  inputRef: null,
  style: null,
  className: null,
  inputId: null,
  name: null,
  checked: false,
  trueValue: true,
  falseValue: false,
  disabled: false,
  tooltip: null,
  tooltipOptions: null,
  ariaLabelledBy: null,
  onChange: null,
  onFocus: null,
  onBlur: null
});

function ownKeys$l(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread$l(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$l(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$l(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper$18(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct$18(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct$18() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var InputTextareaComponent = /*#__PURE__*/function (_Component) {
  _inherits(InputTextareaComponent, _Component);

  var _super = _createSuper$18(InputTextareaComponent);

  function InputTextareaComponent(props) {
    var _this;

    _classCallCheck(this, InputTextareaComponent);

    _this = _super.call(this, props);
    _this.onFocus = _this.onFocus.bind(_assertThisInitialized(_this));
    _this.onBlur = _this.onBlur.bind(_assertThisInitialized(_this));
    _this.onKeyUp = _this.onKeyUp.bind(_assertThisInitialized(_this));
    _this.onInput = _this.onInput.bind(_assertThisInitialized(_this));
    _this.elementRef = /*#__PURE__*/React.createRef(_this.props.forwardRef);
    return _this;
  }

  _createClass(InputTextareaComponent, [{
    key: "onFocus",
    value: function onFocus(e) {
      if (this.props.autoResize) {
        this.resize();
      }

      if (this.props.onFocus) {
        this.props.onFocus(e);
      }
    }
  }, {
    key: "onBlur",
    value: function onBlur(e) {
      if (this.props.autoResize) {
        this.re