function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

import React, { Component } from "react";
import normalizeTokens from "../utils/normalizeTokens";
import themeToDict from "../utils/themeToDict";

var Highlight =
/*#__PURE__*/
function (_Component) {
  _inheritsLoose(Highlight, _Component);

  function Highlight() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _Component.call.apply(_Component, [this].concat(args)) || this;
    _this.prevTheme = void 0;
    _this.prevLanguage = void 0;
    _this.themeDict = void 0;

    _this.getThemeDict = function (props) {
      if (_this.themeDict !== undefined && props.theme === _this.prevTheme && props.language === _this.prevLanguage) {
        return _this.themeDict;
      }

      _this.prevTheme = props.theme;
      _this.prevLanguage = props.language;
      var themeDict = props.theme ? themeToDict(props.theme, props.language) : undefined;
      return _this.themeDict = themeDict;
    };

    _this.getLineProps = function (_ref) {
      var key = _ref.key,
          className = _ref.className,
          style = _ref.style,
          line = _ref.line,
          rest = _objectWithoutPropertiesLoose(_ref, ["key", "className", "style", "line"]);

      var output = _extends({}, rest, {
        className: "token-line",
        style: undefined,
        key: undefined
      });

      var themeDict = _this.getThemeDict(_this.props);

      if (themeDict !== undefined) {
        output.style = themeDict.plain;
      }

      if (style !== undefined) {
        output.style = output.style !== undefined ? _extends({}, output.style, style) : style;
      }

      if (key !== undefined) output.key = key;
      if (className) output.className += " " + className;
      return output;
    };

    _this.getStyleForToken = function (_ref2) {
      var types = _ref2.types,
          empty = _ref2.empty;
      var typesSize = types.length;

      var themeDict = _this.getThemeDict(_this.props);

      if (themeDict === undefined) {
        return undefined;
      } else if (typesSize === 1 && types[0] === "plain") {
        return empty ? {
          display: "inline-block"
        } : undefined;
      } else if (typesSize === 1 && !empty) {
        return themeDict[types[0]];
      }

      var baseStyle = empty ? {
        display: "inline-block"
      } : {}; // $FlowFixMe

      var typeStyles = types.map(function (type) {
        return themeDict[type];
      });
      return Object.assign.apply(Object, [baseStyle].concat(typeStyles));
    };

    _this.getTokenProps = function (_ref3) {
      var key = _ref3.key,
          className = _ref3.className,
          style = _ref3.style,
          token = _ref3.token,
          rest = _objectWithoutPropertiesLoose(_ref3, ["key", "className", "style", "token"]);

      var output = _extends({}, rest, {
        className: "token " + token.types.join(" "),
        children: token.content,
        style: _this.getStyleForToken(token),
        key: undefined
      });

      if (style !== undefined) {
        output.style = output.style !== undefined ? _extends({}, output.style, style) : style;
      }

      if (key !== undefined) output.key = key;
      if (className) output.className += " " + className;
      return output;
    };

    return _this;
  }

  var _proto = Highlight.prototype;

  _proto.render = function render() {
    var _this$props = this.props,
        Prism = _this$props.Prism,
        language = _this$props.language,
        code = _this$props.code,
        children = _this$props.children;
    var themeDict = this.getThemeDict(this.props);
    var grammar = Prism.languages[language];
    var mixedTokens = grammar !== undefined ? Prism.tokenize(code, grammar, language) : [code];
    var tokens = normalizeTokens(mixedTokens);
    return children({
      tokens: tokens,
      className: "prism-code language-" + language,
      style: themeDict !== undefined ? themeDict.root : {},
      getLineProps: this.getLineProps,
      getTokenProps: this.getTokenProps
    });
  };

  return Highlight;
}(Component);

export default Highlight;