import * as React from 'react';
import { DraggableData, DraggableEvent } from 'react-draggable';
import { AXIS_DIRECTION, ElementPropsWithElementRefAndRenderer } from './types';
export declare type DragCallbackData = Pick<DraggableData, Exclude<keyof DraggableData, 'node'>>;
export declare type ScrollbarThumbProps = ElementPropsWithElementRefAndRenderer & {
    axis: AXIS_DIRECTION;
    onDrag?: (data: DragCallbackData) => void;
    onDragStart?: (data: DragCallbackData) => void;
    onDragEnd?: (data: DragCallbackData) => void;
    ref?: (ref: ScrollbarThumb | null) => void;
};
export default class ScrollbarThumb extends React.Component<ScrollbarThumbProps, unknown> {
    private static selectStartReplacer;
    element: HTMLDivElement | null;
    initialOffsetX: number;
    initialOffsetY: number;
    private prevUserSelect;
    private prevOnSelectStart;
    private elementRefHack;
    lastDragData: DragCallbackData;
    componentDidMount(): void;
    componentWillUnmount(): void;
    handleOnDragStart: (ev: DraggableEvent, data: DraggableData) => void;
    handleOnDrag: (ev: DraggableEvent, data: DraggableData) => void;
    handleOnDragStop: (ev?: DraggableEvent, data?: DraggableData) => void;
    handleOnMouseDown: (ev: MouseEvent) => void;
    private elementRef;
    render(): React.ReactElement<any> | null;
}
