"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Results;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _styledComponents = _interopRequireDefault(require("styled-components"));

var _SearchIcon = require("./SearchIcon");

var _templateObject;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

function Results(props) {
  var results = props.results,
      onClick = props.onClick,
      setSearchString = props.setSearchString,
      showIcon = props.showIcon,
      maxResults = props.maxResults,
      resultStringKeyName = props.resultStringKeyName,
      onHover = props.onHover,
      formatResult = props.formatResult;
  var formatResultWithKey = formatResult ? formatResult : function (val) {
    return val[resultStringKeyName];
  };

  var handleClick = function handleClick(result) {
    onClick(result);
    setSearchString(result[resultStringKeyName]);
  };

  if ((results === null || results === void 0 ? void 0 : results.length) <= 0) {
    return null;
  }

  return /*#__PURE__*/_react.default.createElement(StyledResults, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "line"
  }), /*#__PURE__*/_react.default.createElement("ul", null, results.slice(0, maxResults).map(function (result) {
    return /*#__PURE__*/_react.default.createElement("li", {
      onMouseEnter: function onMouseEnter() {
        return onHover(result);
      },
      "data-test": "result",
      key: "rsa-result-".concat(result.id),
      onMouseDown: function onMouseDown() {
        return handleClick(result);
      },
      onClick: function onClick() {
        return handleClick(result);
      }
    }, /*#__PURE__*/_react.default.createElement(_SearchIcon.SearchIcon, {
      showIcon: showIcon
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "ellipsis",
      title: result[resultStringKeyName]
    }, formatResultWithKey(result)));
  })));
}

Results.defaultProps = {
  results: [],
  setDisplayString: function setDisplayString() {},
  resultStringKeyName: 'name',
  formatResult: null
};
Results.propTypes = {
  results: _propTypes.default.array,
  onClick: _propTypes.default.func,
  setSearchString: _propTypes.default.func,
  showIcon: _propTypes.default.bool,
  maxResults: _propTypes.default.number,
  resultStringKeyName: _propTypes.default.string,
  formatResult: null || _propTypes.default.func
};

var StyledResults = _styledComponents.default.div(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  > div.line {\n    border-top-color: ", ";\n    border-top-style: solid;\n    border-top-width: 1px;\n\n    margin-bottom: 0px;\n    margin-left: 14px;\n    margin-right: 20px;\n    margin-top: 0px;\n\n    padding-bottom: 4px;\n  }\n\n  > ul {\n    list-style-type: none;\n    margin: 0;\n    padding: 0px 0 16px 0;\n    max-height: ", ";\n\n    > li {\n      display: flex;\n      align-items: center;\n      padding: 4px 0 4px 0;\n\n      &:hover {\n        background-color: ", ";\n        cursor: default;\n      }\n\n      > div {\n        margin-left: 13px;\n      }\n    }\n  }\n\n  .ellipsis {\n    text-align: left;\n    width: 100%;\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n  }\n"])), function (props) {
  return props.theme.lineColor;
}, function (props) {
  return props.theme.maxHeight;
}, function (props) {
  return props.theme.hoverBackgroundColor;
});