"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var starRange_1 = require("./starRange");
var DEFAULT_SIZE = 5;
var StarRatingInput = /** @class */ (function (_super) {
    __extends(StarRatingInput, _super);
    function StarRatingInput(props) {
        var _this = _super.call(this, props) || this;
        _this._promiseSetStateDone = Promise.resolve();
        _this.state = { prospectiveValue: 0 };
        return _this;
    }
    Object.defineProperty(StarRatingInput.prototype, "promiseSetStateDone", {
        get: function () {
            return this._promiseSetStateDone;
        },
        enumerable: true,
        configurable: true
    });
    StarRatingInput.prototype.render = function () {
        var _this = this;
        var range = starRange_1.default(this.props.size ? this.props.size : DEFAULT_SIZE);
        return (React.createElement("div", { className: 'star-rating-input' },
            React.createElement(Clear, { onClick: this.handleStarClick.bind(this, 0) }),
            range.map(function (i) { return (React.createElement(Star, __assign({}, _this.starProps(i), { key: i }))); })));
    };
    StarRatingInput.prototype.starProps = function (value) {
        return {
            value: value,
            mode: this.anchorMode(value),
            onClick: this.handleStarClick.bind(this, value),
            onMouseEnter: this.handleStarMouseEnter.bind(this, value),
            onMouseLeave: this.handleStarMouseLeave.bind(this, value)
        };
    };
    StarRatingInput.prototype.anchorMode = function (value) {
        if (this.state.prospectiveValue > 0) {
            return (value <= this.state.prospectiveValue ? 'suggested' : 'off');
        }
        return (value <= this.props.value ? 'on' : 'off');
    };
    StarRatingInput.prototype.handleStarMouseEnter = function (value) {
        var _this = this;
        this._promiseSetStateDone = new Promise(function (resolve) {
            _this.setState({ prospectiveValue: value }, resolve);
        });
    };
    StarRatingInput.prototype.handleStarMouseLeave = function (value) {
        var _this = this;
        this._promiseSetStateDone = new Promise(function (resolve) {
            _this.setState({ prospectiveValue: 0 }, resolve);
        });
    };
    StarRatingInput.prototype.handleStarClick = function (value) {
        var _this = this;
        this._promiseSetStateDone = new Promise(function (resolve) {
            _this.setState({ prospectiveValue: 0 }, resolve);
        });
        this.props.onChange(value);
    };
    return StarRatingInput;
}(React.Component));
exports.default = StarRatingInput;
function Clear(props) {
    return (React.createElement("div", { className: 'star-rating-clear-container' },
        React.createElement("a", { className: 'star-rating-clear', href: '', title: '0', onClick: function (e) {
                e.preventDefault();
                props.onClick();
            } }, "\u2022")));
}
function Star(props) {
    return (React.createElement("div", { className: 'star-rating-star-container' },
        React.createElement("a", { className: "star-rating-star " + props.mode, title: "" + props.value, href: '', onMouseEnter: props.onMouseEnter, onMouseLeave: props.onMouseLeave, onClick: function (e) {
                e.preventDefault();
                props.onClick();
            } })));
}
