declare type IECompatibleWindow = Window & {
    document: Document & {
        frames?: {
            devicePixelRatio: number;
            screen: {
                deviceXDPI: number;
                systemXDPI: number;
            };
        };
    };
};
/**
 * @description Return zoom multiplier of a window instance.
 *
 * @param win {Window} Window instance zoom level will be determined for. Useful
 * when needed to get zoom level of an iFrame
 */
export declare function zoomLevel(win?: IECompatibleWindow): number;
/**
 * @description Return reduced element's zoom level. Basically it multiplies
 * computed CSS zoom level of an element with  window's one
 *
 * @param elementOrStyles {Element | CSSStyleDeclaration} Can be element itself or
 * element's `getComputedStyle` call result
 * @param win {Window} parent window of an element (useful for iFrames)
 */
export declare function elementZoomLevel(elementOrStyles: Element | CSSStyleDeclaration, win?: IECompatibleWindow): number;
export {};
