import React, {useState,createContext,useEffect} from 'react'
import config from "../../helpers/config";
import axios from 'axios';


export const AllDetailsContext = createContext();

export const UserDetailProvider = (props) => {
	const [userData, setUserData] = useState(null)
	const [companyData, setCompanyData] = useState(null)
	const [userCompanyData, setUserCompanyData] = useState(null)
	const [userSkill, setUserSkill] = useState(null)
  const [userEntryskill, setUserEntryskill] = useState(null)
  const [userTopskill, setuserTopskill] = useState(null)

	const [isValueChange, setIsValueChange] = useState(false)
	
	useEffect(() => {
    axios
      .get(config.API_URL() + "profile/"+localStorage.getItem("user_profile_id")+"?"+"default_user="+localStorage.getItem('default_user'))
      .then((res) => setUserData(res?.data?.result?.data),);
      
  }, []);

	useEffect(() => {
    axios
      .get(config.API_URL() + "recruiters"+"?"+"default_user="+localStorage.getItem('default_user'))
      .then((res) => setCompanyData(res?.data?.result?.data));
  }, []);
	// http://139.59.35.110/castclass/api/v2/company/list
		useEffect(() => {
		axios
			.get(config.API_URL() + "company" + "/" + "list" + "?" + "default_user=" + localStorage.getItem('default_user'))
			.then(res => setUserCompanyData(res?.data?.result?.data))
	},[])


	useEffect(() => {
    const formBody = new FormData();
    formBody.append('user_id', localStorage.getItem('user_id'))
    axios({
      method:'post',
      url:`${process.env.REACT_APP_API_URL}/get_top_skills`,
      // url:'http://13.49.154.94/backend/api/v2/get_selected_skills',

      
      data:formBody,userTopskill,

      headers: { "Content-Type": "multipart/form-data" },
    })
    .then(res => {
      localStorage.setItem("selectedSkill", JSON.stringify(res.data.result.data.selected_skill));
      setuserTopskill(res?.data?.result?.data)
      // setUserSkill(res?.data?.result?.data)

      setIsValueChange(false)
    })
    .catch(err => console.log(err))
  },[isValueChange]);
  useEffect(() => {
    const formBody = new FormData();
    formBody.append('user_id', localStorage.getItem('user_id'))
    axios({
      method:'post',
      url:`${process.env.REACT_APP_API_URL}/get_selected_skills`,
      // url:'http://13.49.154.94/backend/api/v2/get_selected_skills',

      
      data:formBody,userTopskill,

      headers: { "Content-Type": "multipart/form-data" },
    })
    .then(res => {
      setUserSkill(res?.data?.result?.data)
      // setUserSkill(res?.data?.result?.data)

      setIsValueChange(false)
    })
    .catch(err => console.log(err))
  },[isValueChange]);
	// console.log(userCompanyData,"this is RESPONSE")
	
	// ?limit=10&offset=0&recruitement_company=0&default_user

	return(
			<AllDetailsContext.Provider value={{userData, setUserData, companyData, setCompanyData,userCompanyData, setUserCompanyData, userSkill,userTopskill, setIsValueChange}}>
				{props.children}
			</AllDetailsContext.Provider>
		)
} 
