import React, { useState,useEffect, useContext } from "react";
import { CustomInput, Nav, Card, CardBody } from "reactstrap";
import { navbarBreakPoint } from "../../config";
import NavItemWithRoundTextCount from "../navbar/NavItemWithRoundTextCount";
import FalconCardHeader from "../common/FalconCardHeader";
import { AllDetailsContext } from "../AllDetailsContext/AllDetailsContext";
import axios from 'axios';
import {Link} from 'react-router-dom'
import config from "../../helpers/config";
import { faBuilding,faQuestion } from "@fortawesome/free-solid-svg-icons";
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';



const CommonLeftPanel = ({ items }) => {
  const [allowFollow, setAllowFollow] = useState(false);
  const [allowAvail, setAllowAvail] = useState(true);
  const [joinedCompany, setJoinedCompany] = useState(null);
  const [loading, setLoading] = useState(true);
  const [joinRequest, setJoinRequest] = useState(null);
console.log(items,"new data")


  // const result = items.result
  const email = items?.user?.user_email;
  // console.log(email,"emaillllll")
  const count_connection = items?.PendingConnection?.length;
  const count_messages = items?.user?.messages?.length;
  const count_messages_notifications = items?.user?.message;
  const user_roles = items?.user_roles?.map((role) => role.user_role);
  const { companyData, setCompanyData, userData, userCompanyData } = useContext(AllDetailsContext);
  // console.log(userData?.user?.user_email != "undefined","userDatanewww")


const user_data = userCompanyData?.filter(
    (company_data) => company_data.user_id == localStorage.getItem("user_profile_id")
  );

useEffect(() => {
  axios.post(config.API_URL() + "company/joincompanylist" + "?" + "default_user=" 
    + localStorage.getItem('default_user'))
  .then(res => {
    // console.log(res,"joincompanylistjoincompanylist")
      if(res?.status === 200){
          setJoinedCompany(res?.data?.user_join_company)
          setLoading(false)
      }
})
  .catch(err => console.log(err))
},[])

// NEED TO DO THIS
  // let bodyFormData = new FormData();
  //   bodyFormData.append('default_user', localStorage.getItem('default_user'));
  //   bodyFormData.append('email', email);

 // useEffect(() => {
        // axios.post(config.API_URL() + "company/whoinvitedme" + "?email=" + items?.user?.user_email )


 //        axios({
 //              method: 'post',
 //              url: config.API_URL() + "company/whoinvitedme",
 //              data: bodyFormData,
 //              headers: {'Content-Type': 'multipart/form-data' }
 //            })
 //              .then(response => {
 //                      setJoinRequest(response?.data?.company_list)
 //                      console.log(response,"res then insise ")
 //                })
 //              .catch(err => console.log(err,"whoinvitedme_err"))
    
 // },[])
 const user_Email = localStorage.getItem('email')
// console.log(user_Email,"user_Email")


useEffect(() => {
  axios.post(config.API_URL() + "company/whoinvitedme" + "?email=" + encodeURIComponent(user_Email) )
        .then(res => setJoinRequest(res?.data?.company_list))
        .catch(err => console.log(err))
},[])

const joinRequestCountFiltering = joinRequest?.filter(item => !item.invitation_code == "")
// console.log(joinRequestCountFiltering,"res then outside ")


  return (
    <span>
      <Card className="mb-3">
        <FalconCardHeader title="Network" titleTag="h5" />
        <CardBody className="siquer">
          <NavItemWithRoundTextCount
            item={{ name: "Following", path: "/Following", type: 2, count: 0 }}
          />
          <NavItemWithRoundTextCount
            item={{ name: "Followers", path: "/Followers", type: 2, count: 0 }}
          />
          <NavItemWithRoundTextCount
            item={{
              name: "Connections",
              path: "/Connections",
              type: 2,
              count: count_connection == undefined ? 0 : count_connection,
              data: items?.connection,
            }}
          />
          <NavItemWithRoundTextCount
            item={{
              name: "Z-Connections",
              path: "/Z-Connections",
              type: 2,
              count: 0,
            }}
          />
          <NavItemWithRoundTextCount
            item={{ name: "Groups", path: "/Groups", type: 2, count: 0 }}
          />
        </CardBody>
      </Card>

      <Card className="mb-3">
        <FalconCardHeader title="Notifications" titleTag="h5" />
        <CardBody className="siquer">
          <NavItemWithRoundTextCount
            item={{
              name: "Message",
              path: "/message",
              // path: "/MessageNotification",
              type: 2,
              count: count_messages_notifications ? count_messages_notifications : 0,
              data: items,
            }}
          />
          <NavItemWithRoundTextCount
            item={{
              name: "Connection",
              path: "/ConnectionNotification",
              type: 2,
              count: count_connection ? count_connection : 0,
              data: items?.connection,
            }}
          />
          <NavItemWithRoundTextCount
            item={{
              name: "Z-connections",
              path: "/Z-ConnectionsNotification",
              type: 2,
              count: 0,
            }}
          />

          <h6 className="nav-txt-algn-left mn-tp20">Own Company</h6>
          <p className="nav-txt-algn-left nav-link-text noti-text">
            {user_data ? user_data?.map((comp) => (
              <ul key={comp.id}>
                <li>
                  <Link style={{textDecoration:'none'}} to={{
                    pathname:`/page/${comp.id}`,
                    state: {
                      data: comp
                    }
                  }}>
                    {comp.company_name}
                  </Link>
                </li>
              </ul>
            )) : "none"}
          </p>

          <h6 className="nav-txt-algn-left mn-tp20">Role</h6>
          <p className="nav-txt-algn-left nav-link-text noti-text">
            {!user_roles?.length == 0  ? user_roles : "Admin"}
          </p>
          <h6 className="nav-txt-algn-left mn-tp20">Notification</h6>
          
          <NavItemWithRoundTextCount
            item={{
              name: "Join Request",
              path: "/JoinNotification",
              type: 2,
              count: joinRequestCountFiltering?.length ? joinRequestCountFiltering?.length : 0,
              data: joinRequest
            }}
          />

          <h6 className="nav-txt-algn-left mn-tp20">Joined Company</h6>
          {
            !loading ? joinedCompany?.map(comp => (
            <div key={comp.id}>
              
                <FontAwesomeIcon icon={faBuilding} color="#6B798B" size="lg" className="mn10"></FontAwesomeIcon>
                  <Link style={{textDecoration:'none'}} to={{
                    pathname:`/page/${comp.id}`,
                    state: {
                      data: comp
                    }
                  }}>
                  <div style={{display:"inline-block", verticalAlign:" super"}}>
                    {comp.company_name}
                  </div>
                  </Link>
                  <h6 className="nav-txt-algn-left mn-tp20">Role</h6>
          <p className="nav-txt-algn-left nav-link-text noti-text">
            {comp.request_type}
          </p>

          <h6 className="nav-txt-algn-left mn-tp20">Notification</h6>
          <NavItemWithRoundTextCount
            item={{
              name: "Join Request",
              path: "/JoinNotification",
              type: 2,
              count: 0,
              color: "#334051",
            }}
          />
               
            </div>))
            : "Loading"
          }
          

          
          <NavItemWithRoundTextCount
            item={{
              name: "Job Application",
              path: "/ApplicationNotification",
              type: 2,
              count: 0,
              color: "#334051",
            }}
          />
        </CardBody>
      </Card>

      <Card className="mb-3">
        <FalconCardHeader title="Jobs" titleTag="h5" />
        <CardBody className="siquer">
          <span aria-current="page" name="Job Alert" className="noti-text">
            <div className="d-flex align-items-left">
              <span className="nav-link-text">Job Alert</span>
            </div>
          </span>
          <span className="nav-link-text dd">
            <CustomInput
              id="allow-follow"
              onChange={() => setAllowFollow(!allowFollow)}
              checked={allowFollow}
              type="switch"
            />
          </span>

          <span aria-current="page" name="Job Alert"  className="noti-text">
            <div className="d-flex align-items-left">
              <span className="nav-link-text">Job Availability</span>
            </div>
          </span>
          <span className="nav-link-text dd">
            <CustomInput
              id="allow-Avail"
              onChange={() => setAllowAvail(!allowAvail)}
              checked={allowAvail}
              type="switch"
            />
          </span>
        </CardBody>
      </Card>
    </span>
  );
};

export default CommonLeftPanel;
