import React, { useState, useEffect } from "react";
import {
  Label,
  Form,
  Button,
  FormGroup,
  Input,
  Card,
  CardBody,
  CardHeader,
  Container,
  Row,
  Col,
} from "reactstrap";
import { Link, useHistory } from "react-router-dom";
import FalconCardHeader from "../common/FalconCardHeader";
import "./CompanyTabs.css";
import axios from 'axios'
import Modal from 'react-awesome-modal';
import config from "../../helpers/config";
import spinner from "../../assets/img/media/spinner.gif";
import SkillsTest from '../AllSkillsTest/SkillsTest';

// import {options_industry} from '../common/data/industryOption';


const EditCompany = (props) => {
  // console.log(props,"edit comp props data")
  const history = useHistory()
  const [isModalOpen, setModalOpen] = useState(false)
  
  const [isLoading, setIsLoading] = useState(false)

  const [industryOption, setIndustryOption] = useState([])
  
  const [skill_cat_id, setSkill_Cat_id] = useState("")
  const [subSkills, setSubSkills] = useState([])

  // console.log(subSkills,"edit subSkillssubSkills")
  
  useEffect(() => {
    const fetchingIndustry = async () => {
        const industryReq = await axios.post(`${config.API_URL()}company/industries-list`)
        
          setIndustryOption(industryReq?.data)
        
    }
    fetchingIndustry()
    //http://13.49.154.94/backend/api/v2/company/industries-list
  },[])

  // console.log(props,"DESTRUCTURE")
const {itemData} = props?.location?.state;
console.log(itemData,"itemData.skills[0].selected_skills")
   
  let bodyFormData = new FormData();
  const [formData, setFormData] = useState({
    company_name: itemData?.company_name,
    company_username:"",
    established: itemData?.year_established,
    employees: itemData?.number_of_emp,
    sales: itemData?.total_annual_sales,
    market: itemData?.main_markets,
    certifications: itemData?.certifications,
    headquarter: itemData?.headquarter,
    logo: "",
    banner: "",
    location: itemData?.company_location,
    profilevideo: itemData?.company_video,
    business: itemData?.business_type,
    services: itemData?.products_services,
    productcertifications: itemData?.product_certifications,
    industry: itemData?.company_industry,
    skill_category_id: itemData?.skill_category_id,
    skills:itemData?.selected_skills,
    profile: itemData?.company_profile,
    verify: itemData?.company_verified_status,
    phone: itemData?.company_contactus,
    email: itemData?.company_email,
    city: itemData?.company_city,
    state: itemData?.company_state,
    country: itemData?.company_country,
    aboutus: itemData?.company_aboutus,
    recruitement_company: itemData?.recruitement_company,
  });
  const {
    company_name,
    company_username,
    established,
    employees,
    sales,
    market,
    certifications,
    headquarter,
    logo,
    banner,
    location,
    profilevideo,
    business,
    services,
    productcertifications,
    industry,
    skill_category_id,
    skills,
    profile,
    verify,
    phone,
    email,
    city,
    state,
    country,
    aboutus,
    recruitement_company,
  } = formData;
  // console.log(formData,"this is new formdata")
  const handleSubmit = (e) => {
    e.preventDefault();
    setIsLoading(true)
    // console.log(formData, "=================================");
  //   bodyFormData.append('default_user', localStorage.getItem('default_user'));
  //   bodyFormData.append('company_name', company_name);
  //   bodyFormData.append('company_email', email);
  //   bodyFormData.append('year_established', established);
  //   bodyFormData.append('number_of_emp', employees);
  //   bodyFormData.append('total_annual_sales', sales);
  //   bodyFormData.append('main_markets', market);
  //   bodyFormData.append('certifications', certifications);
  //   bodyFormData.append('headquarter', headquarter);
  //   bodyFormData.append('company_location', location);
  //   bodyFormData.append('company_username', company_username);
  //   bodyFormData.append('company_logo', logo, logo.name);
  //   bodyFormData.append('company_banner', banner, banner.name);
  //   bodyFormData.append('company_video', profilevideo);
  //   bodyFormData.append('company_industry', industry);
  //   bodyFormData.append('company_profile', profile);
  //   bodyFormData.append('company_aboutus', aboutus);
  //   bodyFormData.append('company_contactus', phone);
  //   bodyFormData.append('business_type', business);
  //   bodyFormData.append('products_services', services);
  //   bodyFormData.append('product_certifications', productcertifications);
  //   bodyFormData.append('company_city', city);
  //   bodyFormData.append('company_state', state);
  //   bodyFormData.append('company_country', country);
  //   // bodyFormData.append('skill', skills);
    
  //   axios({
  //   method: 'PUT',
  //   url: config.API_URL() + "companies/"+ itemData.id + "?" + "default_user=" + localStorage.getItem("default_user"),
  //   data: bodyFormData,
  //   headers: {'Content-Type': 'multipart/form-data' }
  //   })
  //   .then(function (response) {
  //       //handle success
  //       // console.log(response);
  //       if(response.data.msg){
  //       console.log(response);

  //       setModalOpen(true)
  //       console.log(formData,'request');

  

  // }
  //   })
  //   .catch(function (response) {
  //       //handle error
  //       console.log(response);
  //   });


// let requestUpdate = {
//             company_name: company_name,
//             company_email: email,
//             year_established: established,
//             number_of_emp: employees,
//             total_annual_sales: sales,
//             main_markets: market,
//             certifications: certifications,
//             headquarter: headquarter,
//             location: location,
//             company_username: company_username,
//             company_logo: (logo, logo.name),
//             company_banner: (banner, banner.name),
//             company_video: profilevideo,
//             company_industry: industry,
//             company_profile: profile,
//             company_aboutus: aboutus,
//             company_verified_status: verify,
//             company_contactus: phone,
//             business_type: business,
//             products_services: services,
//             product_certifications: productcertifications,
//             skill_category_id: skill_cat_id ? skill_cat_id : skill_category_id,
//             skills: subSkills.length > 0 ? subSkills : skills
//         };
        // var formBody = [];
        // for (var property in requestUpdate) {
        //     var encodeKey = encodeURIComponent(property);
        //     var encodedValue = encodeURIComponent(requestUpdate[property]);
        //     formBody.push(encodeKey + "=" + encodedValue);
        // }
        // formBody = formBody.join("&");
        // fetch("http://13.49.154.94/backend/api/v2/companies/" + itemData.id + "?default_user=" + localStorage.getItem('default_user'), {
        //     method: 'PUT',
        //     headers: {
        //         'Content-Type': 'application/x-www-form-urlencoded'
        //     },
        //     body: formBody
        // })
        const formBody = new FormData();

            // formBody.append("default_user", localStorage.getItem('default_user'));
            formBody.append("company_name", company_name);
            formBody.append("company_email", email);
            formBody.append("year_established", established);
            formBody.append("number_of_emp", employees);
            formBody.append("total_annual_sales", sales);
            formBody.append("main_markets", market);
            formBody.append("certifications", certifications);
            formBody.append("headquarter", headquarter);
            formBody.append("location", location);
            formBody.append("company_username", company_username);
            formBody.append("company_logo", logo);
            formBody.append("company_banner", banner);
            formBody.append("company_video", profilevideo);
            formBody.append("company_industry", industry);
            formBody.append("company_profile", profile);
            formBody.append("company_aboutus", aboutus);
            formBody.append("company_verified_status", verify);
            formBody.append("company_contactus", phone);
            formBody.append("business_type", business);
            formBody.append("products_services", services);
            formBody.append("product_certifications", productcertifications);
            formBody.append("skill_category_id", skill_cat_id ? skill_cat_id : skill_category_id);
            formBody.append("skills", subSkills.length > 0 ? subSkills : skills)
            
            axios.post(`${process.env.REACT_APP_API_URL}/companies/` + itemData?.id + "?default_user=" + localStorage.getItem('default_user'), formBody)
            // axios({
            //   method:'post',
            //   url:"http://13.49.154.94/backend/api/v2/companies/" + itemData.id + "?default_user=" + localStorage.getItem('default_user'),
            //   data:formBody,
            //   headers:{
            //     'Content-Type':'application/form-data'
            //   }
            // })
        .then(function (response) {
        //handle success
        console.log(response,"this is res from edit comp");
        if(response.status === 200){
          setIsLoading(false)
          setModalOpen(true)
        // console.log(formData,'request');

  

  }
    })
    .catch(function (response) {
        //handle error
        console.log(response);
    });


  };
  const onChangeHandler = (e) => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value,
    });
  };

  const onChangeHandlerFile = e => {
     // let reader = new FileReader();
     // let file = e.target.files[0];

     // reader.onloadend = e => {
     //  console.log(e.target.result,"aaaaaaaaasssssssss")
     //        setFormData({
     //            logo: e.target.result,
     //            imagePreview_Url: reader.result
     //        });
     //    }
     //    reader.readAsDataURL(file)

    setFormData({
      ...formData,
      logo:e.target.files[0]
    })
  }

  // console.log(logo)

  const onChangeHandlerFileBanner = e => {
    setFormData({
      ...formData,
      banner:e.target.files[0]
    })
  }
   const closeModal = () => {
        setModalOpen(false)
        if(recruitement_company == 1){
         history.push('/pages/recruiter') 
        }else{
          history.push('/pages/company')
        }
    }

    
  return (
    <>
    <Modal visible={isModalOpen} width="400" height="300" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src="https://webstockreview.net/images/check-clipart-gif-animation-18.gif" width="200px" style={{marginTop:'0px', textAlign:'center'}}/>

            <h1 style={{position:'absolute', top:'125px', left:'115px'}}>Updated</h1>
            <p style={{textAlign:'center', marginTop:'32px'}}>Operation processed successfully</p>
            <Button style={{marginTop:'2px'}} color="primary" size="lg" onClick={() => closeModal()}>OK</Button>
        </div>
    </Modal>
      <Card className="mb-3">
        <FalconCardHeader
          title={recruitement_company == 1 ? "Edit Recruitment Company" : "Edit Company"}
          titleTag="h5"
          className="bg-light text-left pad-cl card-header"
        />
        <CardBody className="fs--1">
      <Container>
        <Row>
          <Col md="8">
          <Form onSubmit={handleSubmit}>
            <FormGroup className="required">
              <Label >Company Name</Label>

              <Input
                type="text"
                placeholder="Company Name"
                name="company_name"
                value={company_name}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Company Username</Label>

              <Input
                type="text"
                placeholder="Company Username"
                name="company_username"
                value={company_name}
                disabled
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label>Company Url : {(company_name?company_name:"null").toLowerCase().replace(/\s/g,'')}.castclass.com</Label>
            </FormGroup>

            <FormGroup className="required">
              <Label>Year Established</Label>

              <Input
                type="text"
                placeholder="Year Established"
                name="established"
                value={established}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Number of Employees</Label>

              <Input
                type="select"
                name="employees"
                value={employees}
                required
                onChange={(e) => onChangeHandler(e)}
              >
                <option value="1_25people">1 - 25 People</option>
                <option value="2_50people">2 - 50 People</option>
                <option value="3_100people">3 - 100 People</option>
                <option value="4_150people">4 - 150 People</option>
                <option value="5_200people">5 - 200 People</option>
              </Input>
            </FormGroup>

            <FormGroup>
              <Label>Total Annual Sales Volume</Label>

              <Input
                type="text"
                placeholder="Total Annual Sales Volume"
                name="sales"
                value={sales}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Main Markets</Label>

              <Input
                type="text"
                placeholder="Main Markets"
                name="market"
                value={market}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Certifications</Label>

              <Input
                type="text"
                placeholder="Certifications"
                name="certifications"
                value={certifications}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label> Headquarter</Label>

              <Input
                type="text"
                placeholder="Headquarter"
                name="headquarter"
                value={headquarter}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label> Location</Label>

              <Input
                type="text"
                placeholder="Location"
                name="location"
                value={location}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label> Phone</Label>

              <Input
                type="number"
                placeholder="Phone"
                name="phone"
                value={phone}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label> Email</Label>

              <Input
                type="text"
                placeholder="Email"
                name="email"
                value={email}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label>Company Logo</Label>
              <Input
                type="file"
                name="logo"
                // value={logo}
                // required
                onChange={(e) => onChangeHandlerFile(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label>Company Banner</Label>
              <Input
                type="file"
                name="banner"
                // value={banner}
                // required
                onChange={(e) => onChangeHandlerFileBanner(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Profile Video (Note: Enter valid youtube url)</Label>

              <Input
                type="text"
                placeholder="Note: Enter valid youtube url"
                name="profilevideo"
                value={profilevideo}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> Business</Label>

              <Input
                type="text"
                placeholder="Business Type"
                name="business"
                value={business}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> Products Services</Label>

              <Input
                type="text"
                placeholder="Products Services"
                name="services"
                value={services}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Product Certifications</Label>

              <Input
                type="text"
                placeholder="Product Certifications"
                name="productcertifications"
                value={productcertifications}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label>Industry</Label>

              <Input
                type="select"
                name="industry"
                value={industry}
                required
                onChange={(e) => onChangeHandler(e)}
              >
             {industryOption.map((data, key) => (
                <option key={key} value={data.id}>{data.industry}</option>
                ))}
             
              </Input>
              
            </FormGroup>

            <FormGroup>
              <Label> Skills</Label>
              <SkillsTest 
                setSkill_Cat_id={setSkill_Cat_id} 
                subSkills={subSkills} 
                setSubSkills={setSubSkills}
                itemData={itemData}
              />
              {/*<Input
                type="text"
                placeholder=""
                name="skills"
                value={skills}
                onChange={(e) => onChangeHandler(e)}
              />*/}
            </FormGroup>

            <FormGroup>
              <Label> Company City</Label>

              <Input
                type="text"
                placeholder="Company City"
                name="city"
                value={city}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> Company State</Label>

              <Input
                type="text"
                placeholder="Company State"
                name="state"
                value={state}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Company Country</Label>

              <Input
                type="text"
                placeholder="Company Country"
                name="country"
                value={country}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label> Company Profile</Label>

              <Input
                type="textarea"
                name="profile"
                value={profile}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> About Us</Label>

              <Input
                type="textarea"
                name="aboutus"
                value={aboutus}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Verify the Company</Label>

              <Input
                type="select"
                name="verify"
                value={verify}
                required
                onChange={(e) => onChangeHandler(e)}
              >
                <option value="applied">Applied </option>
                <option value="not_applied">Not Applied </option>
              </Input>
            </FormGroup>
            {
              isLoading ? 
                <>
                    <img src={spinner} width="25px" style={{marginRight:'54px',marginLeft:'36px', textAlign:'center'}}/>
                </> 
                : 
                <Button color="primary" className="button_btn" type="submit">
                  Submit
                </Button>
            }
            <Link to="/pages/recruiter">
              <Button color="secondary">Cancel</Button>
            </Link>
          </Form>
        </Col>
      <Col md="4"></Col>
    </Row>
  </Container>
        </CardBody>
      </Card>

    </>
  );
};

export default EditCompany;
