import React,{useEffect, useState, useContext} from "react";
import { Card, CardBody, Button,Table, Row, Col, Alert } from "reactstrap";
import FalconCardHeader from "../common/FalconCardHeader";
import { Link } from "react-router-dom";
import axios from 'axios';
import Loader from "../common/Loader";
import config from "../../helpers/config";
import { isIterableArray } from "../../helpers/utils";
import company from "../../assets/img/myicons/work.svg";
import Pagination from '../common/Pagination.js'


// import {AllDetailsContext} from '../../components/AllDetailsContext/AllDetailsContext'

const PrivateCertifierContent = ({data, loading}) => {
	return(
		<> 
			{loading 
				? 
				<Loader/>
				: isIterableArray(data) ?
				( data.map(item => {
					return(
						
						
				<div className="media mn-tp30 pd-bt30 border-bottom-list" key={item.id} style={{fontSize: "0.8rem"}}>
                <div className="media-left">
                <Link to={{
                	pathname:`/page/privatecertifierdetails/${item.id}`
                }}>
                  <embed
                    height="70"
                    width="70"
                    src={item.profile_pic == "" ||
                    	item.profile_pic == null ? company : item.profile_pic
                }
                    className="media-object official-logo"
                  ></embed>
                </Link>
                </div>
                <div className="media-body pd-lt20">
                  <h5 className="media-heading field"  style={{fontWeight: "600",fontSize: "1rem", textTransform: "capitalize"}}>
                    <Link className="reverse" to={{
              pathname:`/page/privatecertifierdetails/${item.id}`,
              state:{
              	data: item
              }
            } } >
                      {item.certifier_name ? item.certifier_name : "No Name"}
                    </Link>
                    
                  </h5>
                  <div className="font13">{item.email}</div>
                  <div className="space20" />

                  <div className="required-skills">
                    <div className="txt_666 font13">
                      Company Info: {item.company_info}
                    </div>
                  </div>
                  <div className="space15" />
                  <div className="job-counts font13">
                    Year of Establish: {item.year_of_establish} | Pincode: {item.pincode}
                    
                  </div>
                  <div className="job-counts font13">
                    Location: {item.address}
                  </div>
                </div>
              </div>


						)
				})
					
				) : (<Row className="p-card">
          <Col>
            <Alert color="info" className="mb-0">
              Not found
            </Alert>
          </Col>
        </Row>)
			}
			</>)
			
		
		
}

const PrivateCertifierListingPage = () => {

	 const [data, setData] = useState(null);
	 const [loading, setLoading] = useState(false);
	 const [totalPage, setTotalPage] = useState(0);
	const [pages, setPage] = useState(1)


	 // const {userData, setUserData} = useContext(AllDetailsContext)
let limit = 10;
let offset = pages.length == 0 ? pages + 0 : pages - 1;

  useEffect(() => {
  	const fetchPrivateCertifier = async () => {
  		setLoading(true)
  		const res = await axios.get(config.API_URL() + `privatecertifier?limit=${limit}&offset=${offset}`)
  		setData(res.data.result);
  		setLoading(false)
  		setTotalPage(Math.ceil(res?.data?.result?.total/limit))

  	}
  	fetchPrivateCertifier()

  }, [pages]);

	let pageArray = []
  
  for( let i = 0 ; i < totalPage ; i++){
		pageArray.push(i + 1)
		// setPage(pageArray)
	}

	const buttonHandler = index => {
	setPage(index+1)
}

	return (
		<Card className="mb-3">
					<CardBody className="fs--1">
				<FalconCardHeader title="Private Certifier Listing Page" titleTag="h5" />
					
						{pageArray.map((item, index) => (
								<span
                  className={
                    ("page-but mn-tp20",
                    pages == index + 1 ? "btn-select" : "btn-unselect")
                  }
                  onClick={() => buttonHandler(index)}
                >
                  {item}
                </span>
			))}

						<PrivateCertifierContent data={data?.data} loading={loading}/>
					</CardBody>
			</Card>
		)
}
export default PrivateCertifierListingPage;