import React, { Fragment } from 'react';
import PropTypes from 'prop-types';
import { Media } from 'reactstrap';
import Avatar from '../common/Avatar';
import { Link } from 'react-router-dom';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import FeedDropDown from './FeedDropDown';
import FalconCardHeader from '../common/FalconCardHeader';
import classNames from 'classnames';


// { name, avatarSrc, time, location, privacy, status, share,user_id }
const FeedCardHeader = (props) => {
  console.log(props,"aasaasaasasa")
//const baseUrlImg = "http://139.59.35.110/"
const baseUrlImg = `${process.env.REACT_APP_API_URL}`
  return (
    <FalconCardHeader
      title={
        <Fragment>
          <Avatar src={baseUrlImg+props.avatarSrc} className={props.status} size="2xl" />

          <Media body className="align-self-center ml-2">
            <p className="mb-1 line-height-1">
              <Link className="font-weight-semi-bold" to={{
                pathname: `/pages/profile/${props.user_id}`,
                state: {
                    data:props
                }
              }}>
                {props.name ===" " ? props.user_id :  props.name }
              </Link>
              {!!props.share && (
                <span className="ml-1">
                  shared {/^[aeiou]/g.test(props.share.toLowerCase()) ? 'an' : 'a'} <a href="#!">{props.share}</a>
                </span>
              )}
            </p>
            <p className="mb-0 fs--1">
              {props.time} • {props.location} •{' '}
              <FontAwesomeIcon
                icon={classNames({
                  users: props.privacy === 'friends',
                  lock: props.privacy === 'private',
                  'globe-americas': props.privacy === 'public'
                })}
              />
            </p>
          </Media>
        </Fragment>
      }
      titleTag={Media}
    >
      <FeedDropDown />
    </FalconCardHeader>
  );
};

FeedCardHeader.propsType = {
  name: PropTypes.string.isRequired,
  avatarSrc: PropTypes.string.isRequired,
  time: PropTypes.string.isRequired,
  location: PropTypes.string.isRequired,
  privacyIcon: PropTypes.string.isRequired,
  status: PropTypes.string,
  share: PropTypes.bool
};

export default FeedCardHeader;
