import React,{useContext, useState, useRef, useEffect} from "react";
import FalconCardHeader from "../common/FalconCardHeader";
import { Link } from "react-router-dom";
import {Row, Col, Card, CardBody, Button, Form, FormGroup, Label, Badge, Input,Collapse, FormText, Container, CardHeader, CardFooter } from 'reactstrap';
// import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'
import data from './data.json'
import Modal from 'react-awesome-modal';
import './jobs.css'
import axios from 'axios';
import SkillsTest from '../AllSkillsTest/SkillsTest';
import {useHistory} from 'react-router-dom';
import {toast} from 'react-toastify';
const CreateJob = () => {
  // const {companyData} = useContext(AllDetailsContext)
  // const loginUserCompanies = companyData?.userCompanies?.filter(company => localStorage.getItem("user_profile_id") == company.user_id)
 
  const [isModalOpen, setModalOpen] = useState(false)
  
  const [skill_cat_id, setSkill_Cat_id] = useState("")
  const [subSkills, setSubSkills] = useState([])
  const [isOpen, setIsOpen] = useState(false)
  const [addSkill, setAddSkill] = useState([])
  const [industryList, setIndustryList] = useState(null)
  const [userCompany, setUserCompany] = useState(null)

  const history = useHistory()

  const getUserCompany = async () => {
    const userBody = new FormData();
    userBody.append('user_id', localStorage.getItem('user_id'))
    const res = await axios.post(`${process.env.REACT_APP_API_URL}/get_own_company_list`, userBody)
    if(res?.data?.status == true){
      setUserCompany(res?.data?.own_company)
    }
  }
    

  useEffect(() => {
    const get_Industry = async () => {
      const res = await axios.post(`${process.env.REACT_APP_API_URL}/company/industries-list`)
      
      setIndustryList(res?.data)
    }
    get_Industry();
    getUserCompany();
   
  },[])
// console.log(industryList,"industry_list")
const [formData, setFormData] = useState({
  company_id:"",
  company_name:"",
  industry_id:"",
  job_title:"",
  location:"",
  experience_level:"",
  functional_area:"",
  employment_type:"",
  job_desc:"",
  desired_skills:"",
  add_skills:"",
  application_type:"",
  notification_email:"",
  application_url:"",
  show_my_profile:"",
  setting_city:"",
  setting_state:"",
  setting_country:"",
  setting_latitude:"NA",
  setting_longitude:"NA"
})
const {
  company_id,
  company_name,
  industry_id,
  job_title,
  experience_level,
  functional_area,
  employment_type,
  job_desc,
  desired_skills,
  add_skills,
  application_type,
  notification_email,
  application_url,
  show_my_profile,
  location,
  setting_city,
  setting_state,
  setting_country,
  setting_latitude,
  setting_longitude
} = formData;
const [showBtn, setShowBtn] = useState(true)
useEffect(() => {
  if(company_id && industry_id && job_title && location && experience_level &&
  functional_area && employment_type && job_desc && setting_country){
    setShowBtn(false)
  }else{
    setShowBtn(true)
  }
},[company_id, industry_id, job_title, location, experience_level,
  functional_area, employment_type, job_desc, setting_country])

// console.log(formData,"formData")
  let bodyFormData = new FormData();

  const handleSubmit = (e) => {
    e.preventDefault();
    // console.log(formData,"formData")
    // bodyFormData.append('default_user', localStorage.getItem('default_user'));
    // bodyFormData.append('company_id', company_id);
    // bodyFormData.append('industry_id', industry_id);
    // bodyFormData.append('job_title', job_title);
    // bodyFormData.append('experience_level', experience_level);
    // bodyFormData.append('functional_area', functional_area);
    // bodyFormData.append('employment_type', employment_type);
    // bodyFormData.append('job_desc', job_desc);
    // bodyFormData.append('desired_skills', desired_skills);
    // bodyFormData.append('application_type', application_type);
    // bodyFormData.append('notification_email', notification_email);
    // bodyFormData.append('application_url', application_url);
    // bodyFormData.append('show_my_profile', show_my_profile);
    // bodyFormData.append('location', location);
    // bodyFormData.append('setting_city', setting_city);
    // bodyFormData.append('setting_state', setting_state);
    // bodyFormData.append('setting_country', setting_country);
    // bodyFormData.append('setting_longitude', setting_longitude);
    // bodyFormData.append('setting_latitude', setting_latitude);
    
    // axios({
    // method: 'post',
    // url: 'http://139.59.35.110/castclass/api/v2/job',
    // data: bodyFormData,
    // headers: {'Content-Type': 'multipart/form-data' }
    // })
    var details = {
    'default_user': localStorage.getItem('default_user'),
    'company_id': company_id,
    'industry_id': industry_id,
    'job_title': job_title,
    'experience_level': experience_level,
    'functional_area': functional_area,
    'employment_type': employment_type,
    'job_desc': job_desc,
    'desired_skills': addSkill.toString(),
    'skill_category_id': skill_cat_id,
    'skills': subSkills,
    'application_type': application_type,
    'notification_email': notification_email,
    'application_url': application_url,
    'show_my_profile': show_my_profile,
    'location': location,
    'setting_city': setting_city,
    'setting_state': setting_state,
    'setting_country': setting_country,
    'setting_longitude': setting_longitude,
    'setting_latitude': setting_latitude
};

var formBody = [];
for (var property in details) {
  var encodedKey = encodeURIComponent(property);
  var encodedValue = encodeURIComponent(details[property]);
  formBody.push(encodedKey + "=" + encodedValue);
}
formBody = formBody.join("&");

fetch(`${process.env.REACT_APP_API_URL}/job`, {
  method: 'POST',
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
  },
  body: formBody
})
    .then(function (response) {
        //handle success
        // console.log(response,"job check");
        if(response?.status === 200){
          toast.success('Job Posted!')
          history.push('/pages/jobs')
        }else{
          toast.error('Something went wrong!')
        }
        // console.log(response,"POST JOB");
        // alert(response)
        // if(response.data.msg){
        // setIsLoading(false)
        // setModalOpen(true)
}).catch(err => console.log(err))
  
  
    

  }

  const onChangeHandler = e => {
    // console.log(e.target.value,"============")
    setFormData({
      ...formData, [e.target.name]: e.target.value
    })
  }
  const closeModal = () => {
    setModalOpen(false)
  }

  const addSkillBtn = useRef(null)
  // console.log(addSkillBtn,"addSkillBtn")

  const addSkillButton = () => {
    
      setIsOpen(true)

    if(add_skills){
    
      // console.log("working")
      setAddSkill([...addSkill, add_skills])
      setFormData({...formData, add_skills:""})  
    }
    
    
  }

const deleteSkill = (index) => {
  // console.log(index,"delelte")
  const newAddSkill = addSkill.filter((el, id) => id !== index)
  setAddSkill(newAddSkill)
  // console.log(newAddSkill,"newAddSkill")
}
// console.log(add_skills,"add_skills")
// console.log(addSkill,"=============")

  return (
    <>
    <Modal visible={isModalOpen} width="40%" height="70%" effect="fadeInUp" onClickAway={() => closeModal()}>
          <CardHeader><h3>Preview</h3></CardHeader>
          <CardBody className="bg-light p-0">
            <div className="wrapper">
              <div className="job_title">
                <h5>{job_title ? job_title : "Job Title"}</h5>
                <p>{setting_city ? setting_city : "Job City"} , {setting_country ? setting_country : "Job Country"}</p>
              </div>
              <div>
                <h6>Job Description</h6>
                <p>{job_desc ? job_desc : "Empty"}</p>
              </div>
              <div>
                <h6>Additional Info</h6>
                <Row>
                  <Col md="3">Type:</Col>
                  <Col>{application_type ? application_type : "Empty"}</Col>
                </Row>
                <Row>
                  <Col md="3">Experience:</Col>
                  <Col>{experience_level ? experience_level : "Empty"}</Col>
                </Row>
                <Row>
                  <Col md="3">Funcions:</Col>
                  <Col>{functional_area ? functional_area : "Empty"}</Col>
                </Row>
                <Row>
                  <Col md="3">Industries:</Col>
                  <Col>{industry_id ? industry_id : "Empty"}</Col>
                </Row>
              </div>
            </div>
          </CardBody>
          <CardFooter style={{textAlign:'end'}}>
            <Button color="secondary" onClick={e => closeModal()}>Close</Button>
          </CardFooter>
    </Modal>
    <Card className="mb-3">
      <FalconCardHeader title="Post a Job" titleTag="h5" />
      <CardBody className="fs--1">
      <Row>
        <Col md="8">
          <Form onSubmit={handleSubmit}>
          <FormGroup>
            <Label>Company</Label>
            <Input 
              type="select" 
              name="company_id" 
              // value={company_id} 
              onChange={(e) => onChangeHandler(e)}
              // defaultValue="SELECT-COMPANY"
              className="form-control-sm"
            >
                  <option value="" disabled selected>SELECT COMPANY</option>
              {userCompany?.map((data, index) => (
                    <option value={data.id} key={index}>{data.company_name}</option>
                ))}
            </Input>
          </FormGroup>
          <FormGroup>
            <Label>Industry</Label>
            <Input 
              type="select" 
              name="industry_id" 
              // value={industry_id}
              onChange={(e) => onChangeHandler(e)}
              className="form-control-sm"
            >
                  <option value="" disabled selected>SELECT INDUSTRY</option>
              {industryList?.map(item => (
                  <option value={item.id}>{item.industry}</option>
                ))}
            </Input>
          </FormGroup>
          <br></br>
          <i class="fas fa-file-alt"></i><h5>Positiion</h5>
          <FormGroup>
            <Label>Job Title</Label>
            <Input type="text" name="job_title" value={job_title} onChange={(e) => onChangeHandler(e)}  className="form-control-sm"/>
          </FormGroup>
          <FormGroup>
            <Label>Job Location</Label>
            <Input type="text" name="location" value={location} onChange={(e) => onChangeHandler(e)}  className="form-control-sm"/>
          </FormGroup>
          
          <FormGroup>
            <Label>Experience</Label>
            <Input type="select" name="experience_level" onChange={(e) => onChangeHandler(e)}  className="form-control-sm">
              <option value="" disabled selected>SELECT EXPRIENCE</option>
              <option value="executive">Executive</option>
              <option value="director">Director</option>
              <option value="midSeniorLevel">Mid-Senior Level</option>
              <option value="associate">Associate</option>
              <option value="entryLevel">Entry Level</option>
              <option value="internship">Internship</option>
            </Input>
          </FormGroup>
          <FormGroup>
            <Label>Job Function</Label>
            <Input type="select" name="functional_area" onChange={(e) => onChangeHandler(e)} className="form-control-sm">
                  <option value="" disabled selected>SELECT JOB FUNCTION</option>
                  <option value="Accounting/Auditing">Accounting/Auditing</option>
                  <option value="Administrative">Administrative</option>
                  <option value="Advertising">Advertising</option>
                  <option value="Analyst">Analyst</option>
                  <option value="Art">Art/Creative</option>
                  <option value="Business Development">Business Development</option>
                  <option value="Consulting">Consulting</option>
                  <option value="Customer Service">Customer Service</option>
                  <option value="Distribution">Distribution</option>
                  <option value="Design">Design</option>
                  <option value="Education">Education</option>
                  <option value="Engineering">Engineering</option>
                  <option value="Finance">Finance</option>
                  <option value="General Business">General Business</option>
                  <option value="Human Resources">Human Resources</option>
                  <option value="Information Technology">Information Technology</option>
                  <option value="Legal">Legal</option>
                  <option value="Management">Management</option>
                  <option value="Manufacturing">Manufacturing</option>
                  <option value="Marketing">Marketing</option>
                  <option value="Other">Other</option>
                  <option value="Public Relations">Public Relations</option>
                  <option value="Purchasing">Purchasing</option>
                  <option value="Product Management">Product Management</option>
                  <option value="Project Management">Project Management</option>
                  <option value="Production">Production</option>
                  <option value="Quality Assurance">Quality Assurance</option>
                  <option value="Research">Research</option>
                  <option value="Sales">Sales</option>
                  <option value="Science">Science</option>
                  <option value="Strategy/Planning">Strategy/Planning</option>
                  <option value="Supply Chain">Supply Chain</option>
                  <option value="Training">Training</option>
                  <option value="Writing/Editing">Writing/Editing</option>
                  <option value="Health Care Provider">Health Care Provider</option>
            </Input>
          </FormGroup>

          <FormGroup>
            <Label>Desired Skills</Label>
            <SkillsTest setSkill_Cat_id={setSkill_Cat_id} subSkills={subSkills} setSubSkills={setSubSkills}/>
          </FormGroup>
          <FormGroup>
          <Row>
            {isOpen && (
                <Col md="9">
                  <Input type="text" name="add_skills" placeholder="Add Skills" value={add_skills} onChange={(e) => onChangeHandler(e)} className="form-control-sm"/>
                </Col>
              )}
            
            <Col md="3" className="add__skill__btn">
              <Button 
                color="primary" 
                onClick={addSkillButton}
                ref={addSkillBtn}
                className="btn-sm"
              >Add Skill</Button>
            </Col>
          </Row>
          <div className="outer_wrapper_skill">
          {addSkill.length > 0 && addSkill.map((skill,index) => (
             <div className="d-flex align-item-center justify-content-between p-2 mt-3 skillWrapper" style={{backgroundColor:'#f9fafd'}} key={index}>
               <div className="skill__section">{skill}</div>
               <div className="xbtn" onClick={e => deleteSkill(index)}>X</div>
             </div>
            ))}
          </div>

            
          </FormGroup>

          <FormGroup>
            <Label>Employement Type</Label>
            <Input type="select" name="employment_type" onChange={(e) => onChangeHandler(e)}  className="form-control-sm">
              <option value="" disabled selected>SELECT EMPLOYMENT</option>
              <option value="fullTime">Full-Time</option>
              <option value="partTime">Part-Time</option>
              <option value="contract">Contract</option>
              <option value="temporary">Temporary</option>
              <option value="volunteer">Volunteer</option>
              <option value="other">Other</option>
            </Input>
          </FormGroup>
          <FormGroup>
            <Label>Job Description</Label>
            <Input type="textarea" name="job_desc" value={job_desc} onChange={(e) => onChangeHandler(e)}  className="form-control-sm"/>
          </FormGroup>
          
          
          
          <FormGroup>
            <Label>City</Label>
            <Input type="text" name="setting_city" value={setting_city} onChange={(e) => onChangeHandler(e)}  className="form-control-sm"/>
          </FormGroup>
          <FormGroup>
            <Label>State</Label>
            <Input type="text" name="setting_state" value={setting_state} onChange={(e) => onChangeHandler(e)}  className="form-control-sm"/>
          </FormGroup>
          <FormGroup>
            <Label>Country</Label>
            <Input type="text" name="setting_country" value={setting_country} onChange={(e) => onChangeHandler(e)}  className="form-control-sm"/>
          </FormGroup>
          
          
          <br></br>
          <h5>Finishing Touches</h5>
          <br />
          <h6>How candidates apply</h6>
           <Container>
          <FormGroup>
            <Input type="radio" name="application_type" onChange={(e) => onChangeHandler(e)}/>
            <Label>Collect applications on CastClass and be notified by email :</Label>
            <Input type="email" name="notification_email" value={notification_email} placeholder="Your Enail Address" onChange={(e) => onChangeHandler(e)} />
            <p>Your email address will not be disclosed to candidates.</p>
          
          </FormGroup>
          <FormGroup>
            <Input type="radio" name="application_type"  onChange={(e) => onChangeHandler(e)}/>
            <Label>Direct applicants to an external site to apply :</Label>
            <Input type="text" name="application_url" placeholder="http://www.yourcompany.com/job123" onChange={(e) => onChangeHandler(e)} />
          </FormGroup>
          <h5>Job Poster</h5>
          <FormGroup>
            <Input type="checkbox" name="show_my_profile" checked={show_my_profile ? "true" : "false"} value={show_my_profile} onChange={(e) => onChangeHandler(e)}
              //  className="form-control-sm"
            />
            <Label>Show your profile summary on this job listing</Label>
          </FormGroup>
          </Container>
          <FormGroup>
            <Button color="primary" style={{marginRight:'5px'}} type="submit" disabled={showBtn} className="btn-sm">Continue</Button>
            <Button color="secondary" onClick={e => setModalOpen(true)}  className="btn-sm">Preview</Button>
          </FormGroup>
        </Form>
        </Col>
        <Col md="4">
        </Col>

      </Row>
         
      </CardBody>

      
    </Card>
    </>
  );
};

export default CreateJob;
