import React from "react";
import { Card, CardBody, Button } from "reactstrap";
import FalconCardHeader from "../common/FalconCardHeader";
import { Link } from "react-router-dom";

const JobCard = () => {
  return (
    <Card className="mb-3">
      <FalconCardHeader title="Create a Job page" titleTag="h5" />
      <CardBody className="fs--1">
        Are you hiring?
        Reach the right candidates with Cast Class Jobs
      </CardBody>

      <Link to="/pages/createjob">
        <Button className="mn-lt20 mn-rt20 mn-bt20 bg-primary btn-sm">Post a Job</Button>
      </Link>
    </Card>
  );
};

export default JobCard;
