import React,{useState, useEffect} from 'react';
import {Card, CardBody, Button} from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import axios from 'axios';
import config from '../../helpers/config';
import {toast} from 'react-toastify';
import spinner from "../../assets/img/media/spinner.gif";
import {useHistory} from 'react-router-dom';
import './jobs.css';

const JobDetails = (props) => {
	console.log(props,"job props")
	const jobDetail = props?.location?.state?.data;

	const [loading, setLoading] = useState(false)
	const [userName, setUserName] = useState("")
	
	const history = useHistory();

	useEffect(() => {
		getJobPostedBy();
	},[])
	
	const getJobPostedBy = async () => {
		const res = await axios.get(`${process.env.REACT_APP_API_URL}/profile?default_user=${localStorage.getItem('default_user')}`)		
		console.log(res,"userrrrrr")
		if(res?.data?.status_code === 200){
			setUserName(res?.data?.result?.data?.user?.name)
		}
	}
	
	const applyJob = id => {
		setLoading(true)	
		const jobdata = new FormData();
		
		jobdata.append('default_user', localStorage.getItem('default_user'))
		jobdata.append('candidate_id', localStorage.getItem('user_id'))
		jobdata.append('job_id', id)
		
		
		axios({
			method:'post',
			url: `${process.env.REACT_APP_API_URL}/company/apply-job`,
			data: jobdata,
			headers: { "Content-Type": "multipart/form-data" }
		})
		.then(res => {
			setLoading(false)
			console.log(res,"this is job")
			if(res?.data?.result?.data?.status === true){
				toast.success(res?.data?.result?.data?.message)
				history.goBack();
			}
			if(res?.data?.result?.data?.status === false){
				toast.error(res?.data?.result?.data?.message)
				history.goBack();

			}
		})

	}

	const isOwnJob = jobDetail.user_id == localStorage.getItem('user_id')
	console.log(isOwnJob,"isOwnJob")
	return(
		<Card className="mb-3">
	      	<FalconCardHeader title={'Job Details'}	/>
    
        	<CardBody className="text-justify">
        		<div>
        			<div className="job__title__header">
        				<h3>{jobDetail?.job_title}</h3>
        				<p className="para__title">
        					<span>{jobDetail?.company_name ? jobDetail?.company_name : "NA"}</span>
        					{jobDetail?.job_city || jobDetail?.job_state || jobDetail?.job_country ?  " • " : null }
        					<span>{jobDetail?.job_city ? jobDetail?.job_city + ", ": null}</span>
        					<span>{jobDetail?.job_state ? jobDetail?.job_state + ", ": null}</span>
        					<span>{jobDetail?.job_country ? jobDetail?.job_country : null}</span>
        				</p>
        			</div>

        			<div className="m-2">
        				<span><b>Company:</b> </span>
        				<span>{" " + jobDetail?.company_name ? jobDetail?.company_name : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Job Title: </b></span>
        				<span>{" " + jobDetail?.job_title ? jobDetail?.job_title : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Experience:</b> </span>
        				<span>{" " + jobDetail?.experience_level ? jobDetail?.experience_level : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Job Function:</b> </span>
        				<span>{" " + jobDetail?.functional_area ? jobDetail?.functional_area : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Employment type:</b> </span>
        				<span>{" " + jobDetail?.employment_type ? jobDetail?.employment_type : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Job Description:</b> </span>
        				<span>{" " + jobDetail?.job_desc ? jobDetail?.job_desc : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Desired Skills and Expertise:</b> </span>
        				<span>{" " + jobDetail?.desired_skills ? jobDetail?.desired_skills : "NA"}</span>
        			</div>
        			<div className="m-2">
        				<span><b>Job Status:</b> </span>
        				<span>{" " + jobDetail?.job_status ? jobDetail?.job_status : "NA"}</span>
        			</div>

        			<div>
        			{isOwnJob ? (
        				<>
        					<Button color="secondary" className="m-2" size="sm">Close this job</Button>
	        				<Button color="danger" className="m-2" size="sm">Remove this job</Button>
        				</>
        				):(
        				<>
        					{loading 
        						? <img src={spinner} width="25px" style={{marginRight:'54px',marginLeft:'36px', textAlign:'center'}}/> 
        						: (
        							<Button 
        								color="success" 
        								className="m-2" 
        								size="sm"
        								onClick={e => applyJob(jobDetail?.id)}
        							>Apply</Button>
        							)}		
        							<Button color="primary" className="m-2" size="sm">Share this job</Button>
        							<Button color="danger" className="m-2" size="sm">Remove this job</Button>
        				</>
        				)}
        			
        				
        				
        			</div>
        			<div className="m-2 posted__by">
        				<span>Posted By: </span>
        				<h5>{jobDetail?.user_profile?.user_f_name ? jobDetail?.user_profile?.user_f_name : null} {jobDetail?.user_profile?.user_l_name ? jobDetail?.user_profile?.user_l_name : null}</h5>
        			</div>
        		</div>
        	</CardBody>
        </Card>
		)
}
export default JobDetails;