import React,{useState} from 'react';
import {
  Alert,
  Button,
  Card,
  CardBody,
  Col,
  ModalHeader,
  Row,
  Table,
  Badge,
  Container,
  Input,
  CardFooter
} from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import Avatar from '../common/Avatar';
import send from '../../assets/img/myicons/send.svg';
import './Messages.css';
import moment from 'moment';
import config from '../../helpers/config'
import axios from 'axios';
import { toast } from 'react-toastify';
import {useHistory} from 'react-router-dom'





const MessageDetails = (props) => {
  console.log(props)

  const [message, setMessage] = useState("")
  const history = useHistory()
  const messageHandler = (data) => {
    console.log(props,"dataprops")
    const formBody = new FormData();
    formBody.append('default_user',localStorage.getItem('default_user'))
    formBody.append('message',message)
    formBody.append('subject',props.location.state.subject)
    formBody.append('to_id',props.location.state.to_id)
    formBody.append('from_id',props.location.state.from_id)
    // formBody.append('company_id',id)
// http://localhost/castclass/api/v2/message
    axios({
      method: "post",
      url: `${config.API_URL()}message`,
      data: formBody,
      headers: { "Content-Type": "multipart/form-data" },
    })
    .then(res => {
      console.log(res)
      if(res?.data?.resultType == "S"){
        toast.success(res.data.msg)
        setMessage("")
        history.push('/message')
      }
      
    })
    .catch(err => console.error(err))


  }
	return(
		<Container className="container">
			<Card>
            <FalconCardHeader 
              title={
                <div className="d-flex align-items-center justify-content-start">
                  <Avatar name={props.location.state.user_f_name} size="xl" className="avatar__img" />
                  <h5 className="mr-1">{props.location.state.user_f_name ? props.location.state.user_f_name : "No Name"}</h5>
                  <h5 className="mr-1">{props.location.state.user_l_name ? props.location.state.user_l_name : null}</h5>
                </div>
              } />
      			<CardBody className="p-0 card__body">
      				<div className="message__detail">
      					{/*<div className="message__details__left">
              		<Avatar name={props.location.state.user_f_name} size="xl" />
      						<h3>{props.location.state.user_f_name ? props.location.state.user_f_name : "No Name"}</h3>
      					</div>*/}
      					<div className="message__details__right">
      						<p>Subject: {props.location.state.subject}</p>
      						<p>
                    <Row>
                      <Col md="1" xs="2" className="avatar__container">
                        <Avatar 
                          name={props.location.state.user_f_name} 
                          size="xl" 
                        />    
                      </Col>
                      <Col md="11" xs="10">
                        <Card 
                          className="p-2" 
                          title={moment.utc(props.location.state.created_at).local().startOf('minute').fromNow()}
                        >
                          <span>{props.location.state.message}</span>
                          <span className="time__msg">{moment.utc(props.location.state.created_at).local().startOf('minute').fromNow()}</span>
                        </Card>
                      </Col>
                    </Row>
                  </p>
      					</div>
      				</div>
            <hr style={{background:"#f4f4f4"}}/>
      			</CardBody>
            <CardFooter className="d-flex justify-content-around align-items-center card__body">
              <Input 
                type="text" 
                className="textArea"
                placeholder="Write something..."
                name="message"
                onChange={e => setMessage(e.target.value)}
                value={message}
              />
              
                <img 
                  src={send} 
                  className="send__icon" 
                  title="Send" 
                  onClick={e => messageHandler(props)}
                />
            </CardFooter>
    		</Card>
    	</Container>
		)
}



export default MessageDetails;