import React,{useEffect, useState, useContext} from 'react';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext';
import {
  Alert,
  Button,
  Card,
  CardBody,
  Col,
  ModalHeader,
  Row,
  Table,
  Badge,
  Container
} from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import './Messages.css';
import Avatar from '../common/Avatar';
import moment from 'moment';
import trash from '../../assets/img/illustrations/trash.svg';
import ques from '../../assets/img/icons/ques.gif';
import config from '../../helpers/config';
import {useHistory, Link} from 'react-router-dom';
import axios from 'axios';
import Modal from 'react-awesome-modal';
import { toast } from 'react-toastify';



const Messages = (props) => {

	// const [reload, setReload] = useState(false)isModalOpen
	const [isModalOpen, setIsModalOpen] = useState(false);
	const [msgs, setMsgs] = useState(null);
	const [reload, setReload] = useState(0);
	
	useEffect(() => {
		axios.get(`${process.env.REACT_APP_API_URL}/profile?default_user=${localStorage.getItem('default_user')}`)
		.then(res => {
			if(res?.data?.status_code === 200){
				setMsgs(res?.data?.result?.data?.user?.messages)
			}
			
		})
	},[reload, isModalOpen])
console.log(msgs,"mmmmmmmmmmmmmmmmmmmmmm")
	const history = useHistory();

  	const {userData} = useContext(AllDetailsContext)
  	console.log(userData,"messss check")
  	console.log(props,"proping")

  	

	const formBody = new FormData();

	const deleteMessage = (msg_id) => {
		
		
		console.log(msg_id)
		formBody.append("default_user", localStorage.getItem('default_user'));
		formBody.append("message_id", msg_id);
		
		axios({
			method:'post',
			url:`${config.API_URL()}company/message/delete`,
			data: formBody,
			headers: { "Content-Type": "multipart/form-data" },
		})
		.then(res => {
			if(res?.data?.result?.data?.status === true){
				console.log(res)
				toast.success(res?.data?.result?.data?.message)
				setReload(0)
				setIsModalOpen(true)
			}
		
		setIsModalOpen(false)
		})

		setReload(0)
	}
	const deleteMsgHandler = () => {
		
	}

	// const closeModal = () => {
	// 	setIsModalOpen(true)
	// }

 	const openMessageDetails = (msg_details) => {
	
	}
	

	return(
		<>

		<Container className="container">
		
				<Card>
      			<FalconCardHeader title="Messages" />
      			<CardBody className="p-0">
      			{msgs?.map(msg => (
      				<Card className="messages__card" key={msg.id}>
      					<Link to={{pathname:`/message/${msg.id}`, state:msg}}>
      						<div className="messages__left" onClick={e => openMessageDetails(msg)}>
              					<Avatar name={msg.user_f_name} size="xl" />
              					<span className="messages__text">Subject: {msg.subject}</span>
      						</div>
      					</Link>
      					<div className="messages__right">
      						{moment.utc(msg.created_at).local().startOf('minute').fromNow()}
      						<img src={trash} className="del__img" onClick={e => deleteMessage(msg.id)}/>
      					</div>
      				</Card>
      			))}
			    
      			</CardBody>
    		</Card>	
			
			
    	</Container>
    	</>
		)
}



export default Messages;