import React,{useEffect, useState} from 'react';
import {
  Alert,
  Button,
  Card,
  CardBody,
  Col,
  ModalHeader,
  Row,
  Table,
  Badge
} from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import config from "../../helpers/config";
import axios from 'axios';
import Modal from 'react-awesome-modal';
import correct from '../../assets/img/icons/correct.gif';
import JoinRequestData from './JoinRequestData'
import './JoinRequest.css'
import question_mark from '../../assets/img/icons/ques.gif'
import Spinner from '../../assets/img/media/spinner.gif'




const JoinRequest = (props) => {


const [isOpenModalOne, setIsOpenModalOne] = useState(false)
const [isOpenModalTwo, setIsOpenModalTwo] = useState(false)
const [confirm, setConfirm] = useState(false)
const [confirmData, setConfirmData] = useState(null)
const [msg, setMsg] = useState("")
const [status, setStatus] = useState("Pending")
const [loading, setLoading] = useState(true)
const [data, setData] = useState(null)
const [msg_role, setMsg_role] = useState("")

useEffect(() => {
	axios.post(`${process.env.REACT_APP_API_URL}/company/whoinvitedme?email=${encodeURIComponent(localStorage.getItem('email'))}`)
	.then(res => {
		// console.log(res,"ressss in data")
			if(res?.status === 200){
				setData(res?.data?.company_list)
			}
		})
		.catch(err => console.log(err))
},[status])


	// console.log(props,"letccc_again")
	console.log(data,"confirmDataconfirmData")
	const checkForAlreadyAdmin = data?.find(admin => admin.accepted === 1)
	console.log(checkForAlreadyAdmin,"checkForAlreadyAdmin")


const acceptInviteHandler = async data => {
	console.log(data,"letcccsss")
	let role = [9,11,12,13]
	setIsOpenModalOne(true)
	setConfirmData(data)
	
	if(data.invited_for === 9){
		setMsg_role("an Admin")
	}
	if(data.invited_for === 10){
		setMsg_role("a Editor")
	}
	if(data.invited_for === 11){
		setMsg_role("a Recruiter")
	}
	if(data.invited_for === 12){
		setMsg_role("a Job Manager")
	}
	if(data.invited_for === 13){
		setMsg_role("a Private Certifier")
	}
	setLoading(false)



}
	console.log(confirmData,"msgggggggggggggggg")
const rejectInviteHandler = data => {
	const params = new URLSearchParams()
		params.append('default_user', localStorage.getItem('default_user'))
		params.append('invited_for', data?.invited_for)
		params.append('invitation_code', data?.invitation_code)
		params.append('accept', "no")

const config = {
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded'
  }
}

axios.post(`${process.env.REACT_APP_API_URL}/company/accept_invitation`, params, config)
  .then((result) => {
  	if(result?.data?.status_code === 200){
  		setIsOpenModalTwo(true)
  		setMsg(result?.data?.result?.data?.message)
  		setStatus("Rejected")
  		setLoading(false)

  	}
  })
  .catch((err) => console.log(err))
}

const closeModal = () => {
	setIsOpenModalOne(false)
	setIsOpenModalTwo(false)
}

const confirmHanlder = () => {
	setLoading(true)
	const params = new URLSearchParams()
	params.append('default_user', localStorage.getItem('default_user'))
	params.append('invited_for', confirmData?.invited_for)
	params.append('invitation_code', confirmData?.invitation_code ? confirmData?.invitation_code : "klBf3oT9bH81whT")
	params.append('accept', "yes")

const config = {
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded'
  }
}

axios.post(`${process.env.REACT_APP_API_URL}/company/accept_invitation`, params, config)
  .then((result) => {
  	console.log(result,"this is JoinRequest")
  	setIsOpenModalOne(false)
  	if(result?.data?.status_code === 200){
  		setIsOpenModalTwo(true)
  		setMsg(result?.data?.result?.data?.message)
  		setStatus("Accepted")
  		setLoading(false)
  		// console.log(result.data,"checking for invi")

  	}

  })
  .catch((err) => console.log(err))
}

// console.log(status,"status here!!")
// console.log(data,"this is new dataaaaadaa")

	return(
		<>
		<Modal visible={isOpenModalTwo} width="400" height="300" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src={correct} width="200px" style={{marginTop:'0px', textAlign:'center'}}/>

            <h5 style={{marginBottom:'40px'}}>{msg}</h5>
            <Button style={{marginTop:'2px'}} color="primary" size="lg" onClick={() => closeModal()}>OK</Button>
        </div>
    	</Modal>

    	<Modal visible={isOpenModalOne}  effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src={question_mark} width="100px" style={{marginTop:'0px', textAlign:'center'}}/>

            <p>
             If you want to become {msg_role} of this <b>{confirmData?.company_name} company</b>.{" "}
             Your permission would be removed from the{" "}
             <b>{checkForAlreadyAdmin?.company_name}</b>
            </p>
            <h5 style={{marginBottom:'40px'}}>Are you still want to become an {msg_role}?</h5>
            <div className="d-flex justify-content-around">
            {loading ? (<><img src={Spinner} width="30px" heigth="30px" style={{objectFit:"contain"}}/></>) : 
            	<Button style={{marginTop:'2px'}} color="primary" size="md" onClick={() => confirmHanlder()}>Yes</Button>
          }
            	<Button style={{marginTop:'2px'}} color="secondary" size="md" onClick={() => closeModal()}>No</Button>
            </div>
        </div>
    	</Modal>
		
		<Card>
      <FalconCardHeader title="Join Request" />
      <CardBody className="p-0">
		
				<Table>
					<thead>
						<tr>
							<th>Company Name</th>
							<th>Role</th>
							<th>Status</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody>
						{data?.map(invite => (
    			<tr>
    				<td>{invite.company_name}</td>
    				<td>
    					{
							invite?.invited_for == 9 && "Admin" ||
							invite?.invited_for == 10 && "Editor" ||
							invite?.invited_for == 11 && "Recruiter" ||
							invite?.invited_for == 12 && "Job Manager" ||
							invite?.invited_for == 13 && "Private Certifier"
						}
    				</td>
    				<td>{ invite.invitation_code ? <h6><Badge color="light" pill>Pending</Badge></h6> : invite.accepted === 1 ? <h6><Badge color="success" pill>Accepted</Badge></h6> : <h6><Badge color="danger" pill>Rejected</Badge></h6> }</td>
    				<td>
    				{invite.invitation_code ? (
    					  <>
    					  <div className="d-flex justify-content-evenly">
    					     	<Button color="success" size="sm" onClick={e => acceptInviteHandler(invite)}>Accept</Button>
    									{" "} 
    						 		<Button color="danger" size="sm" onClick={e => rejectInviteHandler(invite)}>Reject</Button>
    						 </div>
    					  </>
    					) : <h6><Badge color="info" pill>Responded</Badge></h6>}

    					
    				
    				</td>
    			</tr>
    		))}

					</tbody>
					<tfoot>
					</tfoot>
				</Table>
			    
      </CardBody>
    </Card>
    </>
		)
}

export default JoinRequest