import React,{useState, useContext} from 'react'
import Modal from 'react-awesome-modal';
import {Card, CardBody, FormGroup, Input, Label, Container, Button, CardFooter, CardHeader} from 'reactstrap'
import FalconCardHeader from '../common/FalconCardHeader';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'


const BanUser = () => {
  const {companyData} = useContext(AllDetailsContext);
  const [isModalOpen, setModalOpen] = useState(false)
  const loginUserCompanies = companyData?.userCompanies?.filter(comp => localStorage.getItem("user_profile_id") == comp.user_id )

  console.log(loginUserCompanies,"qwerty")
  console.log(companyData,"COMPANYDATA")
	const banUserHandler = () => {
		console.log("ban me")
		setModalOpen(true)
	}

	const closeModal = () => {
    setModalOpen(false)
  }
  console.log(isModalOpen,"Modal OPEN")
	return(

		<>
		<Modal visible={isModalOpen} width="40%" height="85%" effect="fadeInUp" onClickAway={() => closeModal()}>
        	<CardHeader>Select Company to Ban</CardHeader>
      		<CardBody className="bg-light p-0" style={{'max-height': 'calc(100vh - 210px)', 'overflow-y': 'auto'}}>
        		<Container>

        		{loginUserCompanies?.map(company => (
        			<>
        				<FormGroup check>
        					<Label check>
          					<Input type="checkbox" />{' '}
          						{company.company_name}
        					</Label>
      					</FormGroup>
        			</>
        		))}
        		</Container>
        	
      		</CardBody>
      		<CardFooter>
      			<div style={{textAlign:"end"}}>
      				<Button color="primary" onClick={e => closeModal()}>Save</Button>{" "}
        			<Button color="secondary" onClick={e => closeModal()}>Close</Button>
        		</div>
      		</CardFooter>
    	</Modal>
    	 
      		<div  
      			style={{
      				color:'#fff', 
      				border:'1px solid white', 
      				textAlign:'center', 
      				borderRadius:'10px', 
      				marginTop:'10px', 
      				marginBottom:'10px', 
      				cursor:'pointer'
      			}}
      			onClick={banUserHandler}
      		>
      		Ban this user
      		</div>
		</>
		)
}

export default BanUser;