import React,{useEffect, useState} from 'react';
import {Table, Container,Row, Col, Alert} from 'reactstrap';
import axios from 'axios';
import Loader from '../common/Loader';
import config from '../../helpers/config'


const CandidateAppliedJobs = () => {

const [appliedJobs, setAppliedJobs] = useState(null);
const [isLoading, setIsLoading] = useState(true);

const userBody = new FormData();
userBody.append('user_id', localStorage.getItem('user_id'));

const getAppliedJobs = async () => {
	const res = await axios.post(`${config.API_URL()}candidate_applied_jobs`, userBody)
	if(res?.data?.status_code === 200){
		setAppliedJobs(res?.data?.result?.data?.jobs)
		setIsLoading(false)
	}
}

useEffect(() => {
	getAppliedJobs();
},[])


	return(
		<Container>
		{isLoading 
			? <Loader/>
			: (
				<div className="table-responsive">
				<Table className="table table-striped table-sm" style={{tableLayout: "auto", width: "100%"}}>
					<style jsx>{`
						th {
							font-size: 12px;
						}
						tr td{
							color: black;
						}
					`}</style>
					<thead style={{fontSize: "12px", textTransform: "uppercase", color: "black"}}>
						<tr style={{textAlign: 'left'}}>
							<th style={{minWidth: "63px"}}>JOB ID</th>
							<th style={{minWidth: "66px"}}>JOB TITLE</th>
							<th>STATUS</th>
							<th>EMPLOYER</th>
							<th>RECOMMENDATAION</th>
							<th>REGRATES</th>
						</tr>
					</thead>
					<tbody>
						{appliedJobs?.length > 0 ? appliedJobs?.map((job, index) => (
							<tr key={index} >
								<td>{job.job_id}</td>
								<td>{job.job_detail.job_title}</td>
								<td>
									<p>Hired</p>
									<p>Not Hired</p>
								</td>
								<td>{job.job_detail.company_name}</td>
								<td>View</td>
								<td>View</td>
							</tr>
						)) : (
						<tr className="danger">
							<td  colspan="6" style={{padding: "2px 0", textAlign: "left"}}>
								<Alert color="danger">No Cerification Found</Alert>
							</td>
						</tr>
						)}
					</tbody>
				</Table>
				</div>
				)
		}
		
		</Container>)
}

export default CandidateAppliedJobs;