import React,{useState} from 'react';
import {Container,Table, Button, Badge, Alert, Row, Col} from 'reactstrap';
import { Rating } from 'primereact/rating';
import FalconCardHeader from '../common/FalconCardHeader';
import Interviews from '../recruiter/Interviews'
import createMarkup from '../../helpers/createMarkup';

const Certification = ({data, profileInfo, tableData, type}) => {
	console.log(data,"datadatadatadatadatadata")
	console.log(profileInfo,"profileInfo")
	console.log(tableData,"tableData")
	console.log(type,"typeeeeeeeeeee")
	// console.log(JSON.parse("{\"skill\":\"hhh\",\"rate\":\"1\",\"explanations\":\"hhj\"}"))

	const skills = JSON.parse(localStorage.getItem("selectedSkill"));
    // console.log(skills,"skillsskillsskillsskillsskillsskills")
	// function filterskill(arr,skill){
	// 	var newArr = skill.map((ski)=>{return ski.skill_name})
	// 	console.log('certifiedSkill', arr)
	// 	if(Array.isArray(arr)){
	// 		const remove = arr.filter(element=>{
	// 			const value = newArr.includes(element.message_keys_value);
	// 			if(value == false){
	// 				newArr.push(element.message_keys_value);
	// 			}else{
	// 				newArr.pop(element.message_keys_value);
	// 			}
				
	// 		})
	// 		return remove;
			
	// 	}
	// }
	function filterskill(arr, skill) {
	// Validate inputs
	if (!Array.isArray(skill)) {
		console.warn("Skill is not an array:", skill);
		return [];
	}

	if (!Array.isArray(arr)) {
		console.warn("Arr is not an array:", arr);
		return [];
	}

	// Extract skill names
	let skillNames = skill.map((ski) => ski.skill_name);

	console.log("certifiedSkill", arr);

	// Filter logic
	const result = arr.filter(element => {
		const value = element.message_keys_value;
		const exists = skillNames.includes(value);

		if (!exists) {
		// Add new skill name
		skillNames.push(value);
		return true; // keep in array
		} else {
		// Remove existing one (simulate toggling)
		skillNames = skillNames.filter(name => name !== value);
		return false; // remove from array
		}
	});

	return result;
	}
	// "data.certified_details" is certified Data and "skills" is selected skill
	var filterSkill = filterskill(data.certified_details, skills);
	// console.log('filterSkill', filterSkill)


	return(
		<Container>
		<style jsx>{`
			th {
				font-size: 12px;
				
			}
			tr td {
				color: black;
			}
			.p-rating .p-rating-icon {
				font-size: 1.0rem;
			}
		`}</style>
		<div className="table-responsive">
		<Table style={{tableLayout: "auto", width: "100%"}} className="table table-striped table-sm">
			<thead>
				<tr style={{fontSize: "12px", textTransform: "uppercase", color: "black"}}>
					<th style={{minWidth: "170px"}}>Type of Certification</th>
					<th>Skill</th>
					<th style={{minWidth: "170px"}}>Rating</th>
					<th>Certifier</th>
					<th style={{minWidth: "170px"}}>Status</th>
				</tr>
			</thead>
			<tbody>
			{data?.certified_details.length > 0 ? data?.certified_details?.map((certi, index) => {
				console.log(certi.message_keys_value ? JSON.parse(certi.message_keys_value) : "No Skill","keyyyyyyyyyyyyyy")
				return(
							<tr key={index}>
								<td>{certi.certifier_type}</td>
								<td>{certi.message_keys_value ? JSON.parse(certi.message_keys_value).skill : "No Skill"}</td>
								<td>
									<Rating 
										value={certi.rating} 
										stars={5} 
										readOnly 
										cancel={false}
									/>
								</td>
								<td>{certi.company_id}</td>
								<td>
									<button color="success" className="btn btn-sm btn-success" style={{fontSize: "0.7rem"}}>Accept</button>
									<span>&nbsp;</span>
									<button color="danger" className="btn btn-sm btn-danger"  style={{fontSize: "0.7rem"}}>Reject</button>
								</td>
							</tr>
							)}) : (
				<tr className="danger">
					<td  colspan="5" style={{padding: "2px 0"}}>
						<Alert color="danger">No Cerification Found</Alert>
					</td>
				</tr>
			)}
				
			</tbody>
		</Table>
		</div>
		<div className="mn-tp20 mn-bt20 btns-cont">
			<FalconCardHeader clas title={"Entry Skill"}></FalconCardHeader>
			<div className='row mn-tp20 mn-bt20 btns-cont'>
				<div className='row mn-tp20 mn-bt20 btns-cont'>
					<div className='col-md-4'>
						{data?.certified_details?.length > 50
						? filterSkill?.map((filSkill, index) => (
							<h6 key={index} className='mn-bt20 btns-cont'>{filSkill}</h6>
							))
						: Array.isArray(skills) && skills.map((seleSkill, index) => (
							<h6 key={index} className='mn-bt20 btns-cont'>{seleSkill?.skill_name}</h6>
							))}
					</div>
					<div className='col-md-8'>
						{data?.certified_details?.length > 50
						? filterSkill?.map((filSkill, index) => (
							<h6 key={index} className='reqAff'>
								<button className='RequestAffirmation'>Request Affirmation</button>
							</h6>
							))
						: Array.isArray(skills) && skills.map((seleSkill, index) => (
							<div key={index} className='reqAff'>
								<button className='RequestAffirmation'>Request Affirmation</button>
							</div>
							))}
					</div>
					</div>
			</div>
			
        </div>
		</Container>
		)
}
export default Certification;