import React,{useState, useContext} from 'react'
import Modal from 'react-awesome-modal';
import {Card, CardBody, FormGroup, Input, Label, Container, Button, CardFooter, CardHeader} from 'reactstrap'
import FalconCardHeader from '../common/FalconCardHeader';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'
import axios from 'axios';
import correct from "../../assets/img/icons/correct.gif";
import {useParams} from 'react-router-dom'
import spinner from "../../assets/img/media/spinner.gif";



const Message = () => {
  const {companyData} = useContext(AllDetailsContext);
  const [isModalOpen, setModalOpen] = useState(false)
  const [isModalTwoOpen, setIsModalTwoOpen] = useState(false)
  const [isLoading, setIsLoading] = useState(false)
  const [subject, setSubject] = useState('')
  const [message, setMessage] = useState('')
  const loginUserCompanies = companyData?.userCompanies?.filter(comp => localStorage.getItem("user_profile_id") == comp.user_id )

  const id = useParams()
  console.log(id.id,'useParam')


  console.log(loginUserCompanies,"qwerty.")
  console.log(companyData,"COMPANYDATA")
	const banUserHandler = () => {
		console.log("ban me")
		setModalOpen(true)
	}

	const closeModal = () => {
    setModalOpen(false)
  }
  console.log(isModalOpen,"Modal OPEN")
  console.log(subject)
  console.log(message)

  const sendMessage = () => {
    setIsLoading(true)
    axios.post('http://139.59.35.110/castclass/api/v2/message' 
      + '?' + 'default_user=' + localStorage.getItem('default_user') 
      + '&' + 'from_id=' + localStorage.getItem('user_profile_id') + '&' + 'to_id=' + id.id + '&' 
      + 'subject=' + subject + '&' + 'message=' + message)
        .then(response => {
          console.log(response,"responsee")
          if(response.data.resultType == "S"){
              setModalOpen(false)
              setIsModalTwoOpen(true)
              setTimeout(() => {
                setIsModalTwoOpen(false)
              }, 3000)
              setIsLoading(false)
              setSubject('')
              setMessage('')
          }
        })
  }
	return(

		<>
		<Modal visible={isModalOpen} width="40%" height="45%" effect="fadeInUp" onClickAway={() => closeModal()}>
        	<CardHeader>Send Message</CardHeader>
      		<CardBody className="bg-light p-0" style={{'max-height': 'calc(100vh - 210px)', 'overflow-y': 'auto'}}>
            <Container>
              <FormGroup>
                <Label>Subject</Label>
                <Input type="text" placeholder="Subject" onChange={e => setSubject(e.target.value)} value={subject} required/>
        		  </FormGroup>
              <FormGroup>
                <Label>Message</Label>
                <Input type="textarea" placeholder="Write something..." onChange={e => setMessage(e.target.value)} value={message} required/>
              </FormGroup>
        	 </Container>
      		</CardBody>
      		<CardFooter>
      			<div style={{textAlign:"end"}}>
             {
              isLoading ? 
                <>
                    <img src={spinner} width="25px" style={{marginRight:'40px',marginLeft:'36px', textAlign:'center'}}/>
                </> 
                : 
      				<Button color="primary" onClick={e => sendMessage()} disabled={!subject || !message ? true : false} style={{marginRight:'10px'}}>Send</Button>

              }
        			<Button color="secondary" onClick={e => closeModal()}>Close</Button>
        		</div>
      		</CardFooter>
    	</Modal>

      <Modal visible={isModalTwoOpen} width="600" height="350" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src={correct} width="200px" style={{marginTop:'0px',marginBottom:'20px', textAlign:'center'}}/>

            <h3 style={{textAlign:'center'}}>Message sent successfully!</h3>
        </div>
    </Modal>
    	 
      		<div  
      			style={{
      				color:'#fff', 
      				border:'1px solid white', 
      				textAlign:'center', 
      				borderRadius:'10px', 
      				marginTop:'10px', 
      				marginBottom:'10px', 
      				cursor:'pointer'
      			}}
      			onClick={banUserHandler}
      		>
      		Send Message
      		</div>
		</>
		)
}

export default Message;