import React, { useEffect, Fragment, useState, useContext } from 'react';
import ContentWithAsideLayout from '../../layouts/ContentWithAsideLayout';
import ProfileBanner from './ProfileBanner';
import ProfileAside from './ProfileAside';
import ProfileLeftPanel from './ProfileLeftPanel';
import ContentWithBothSideLayout from '../../layouts/ContentWithBothSideLayout'
import Loader from '../common/Loader';
import ActivityContent from './ActivityContent';
import useGetFetch from '../../hooks/useGetFetch';
import axios from 'axios';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'


const ProfileActivity = () => {
  
  const {userSkill,userTopskill} = useContext(AllDetailsContext)
  
  let api = 'profilenew?default_user=' + localStorage.getItem('default_user');
  // let selectskillValue = 
  const { loading, data: profileinfo } = useGetFetch(api);
  let profileCompletion = profileinfo?.result?.data?.user?.profileCompletion;
  
  return (
    <Fragment>
      {loading ? (
        <Loader />
      ) :
        (
          <ContentWithBothSideLayout 
            banner={<ProfileBanner profileInfo={profileinfo?.result?.data} />} 
            leftSide={<ProfileLeftPanel profileCompletion={profileCompletion} />}
            rightSide={<ProfileAside skill={userTopskill} entry_skill={userSkill}/>} isStickyAside={false}
          >
          {
            <ActivityContent profileInfo={profileinfo?.data?.result} />
          }
        </ContentWithBothSideLayout>
        )}
    </Fragment>
  );
};
export default ProfileActivity;