import React, { useState, Fragment,useContext } from 'react';
import { Card, CardBody, Table } from 'reactstrap';
import ProfileInfoTab from './ProfileInfoTab';
import { faLanguage, faAward, faUserCircle } from "@fortawesome/free-solid-svg-icons";
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'




const PInfoDetail = ({ pi }) => (
  <Fragment><p>Date of birth : {pi?.user?.user_dob}</p>
    <p>Marital status : {pi?.user?.user_maritial_status}</p>
    <p>Email : {pi?.user?.user_email}</p></Fragment>
);


const ProfileIntro = ({ profileInfo}) => {
  const {userData} = useContext(AllDetailsContext)
  return (
    // <Card className="mb-3" style={{ borderRadius: 5 }}>
      <CardBody>
      <h5 className="profile-intro-header">Personal Information</h5>
      <ProfileInfoTab icon="file-alt" title="Summary Interests" detail={userData?.user?.user_summary}></ProfileInfoTab>
      <ProfileInfoTab icon="heart" title="Interests" detail={profileInfo?.user_interest}></ProfileInfoTab>
      <ProfileInfoTab icon={faAward} title="Honor & Awards" detail={userData?.award?.map(item => (
        <>
          <Table bordered>
            <thead>
              <tr>
                <th>Award</th>
                <th>Description</th>
                <th>Issuer</th>
                <th>Occupation</th>
                <th>Month/Year</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>{item.user_award ? item.user_award : "NA"}</td>
                <td>{item.user_award_desc ? item.user_award_desc : "NA"}</td>
                <td>{item.user_award_issuer ? item.user_award_issuer : "NA"}</td>
                <td>{item.user_occupation ? item.user_occupation : "NA"}</td>
                <td>{item.user_award_month || item.user_award_year  ? item.user_award_month + "/" + item.user_award_year : "NA"}</td>
                
              </tr>
            </tbody>
            <tfoot/>
          </Table>
        </>))}></ProfileInfoTab>
      <ProfileInfoTab icon={faLanguage} title="Language" detail={userData?.language?.map(lang => (
        <>
        <ul>
          <li>{lang.user_language}</li>
        </ul>
        </>))}></ProfileInfoTab>
      <ProfileInfoTab icon={faUserCircle} title="Personal Information" detail={<PInfoDetail pi={userData} />}></ProfileInfoTab>
      </CardBody>
      // </Card>
  );
};

export default ProfileIntro;
