import React from 'react';
import { Card, CardBody } from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import { Rating } from 'primereact/rating';
import { text } from '@fortawesome/fontawesome-svg-core';

const FeedInterest = ({skill}) => {
//   console.log(skill,"check skill")

  return (
    <Card className="mb-3">
      <FalconCardHeader title="Entry Level Skills" titleTag="h5" />
      <CardBody className="fs--1">
      {skill?.skill_category?.map(skill => (
        <h6>{skill.skill_name}</h6>
        ))}
      {skill?.selected_skill?.map(skill => (
        <ul style={{
          padding: 0,
          listStyle: "none",
          marginBottom: "10px",
        }}>
          <li>
            <span>
              {skill.skill_name} 
            </span>
            <span >
              <div>
              {skill.rating !== null && Math.floor(skill.rating) == 5 &&
                <h6 className="RatingColorExce">Excellent</h6>
              }
              </div>
              <div>
              {skill.rating !== null && Math.floor(skill.rating) == 4 &&
                <h6 className="RatingColorVerGood">Very Good</h6>
              }
              </div>
              <div>
              {skill.rating !== null && Math.floor(skill.rating) == 3 &&
                <h6 className="RatingColorGood">Good</h6>
              }
              </div>
              <div>
              {skill.rating !== null && Math.floor(skill.rating) == 2 &&
                <h6 className="RatingColorBad">Bad</h6>
              }
              </div>
              <div>
              {skill.rating == null || Math.floor(skill.rating) == 1 &&
                <h6 className="RatingColorVerBad">Very Bad</h6>
              }
              </div>
              {/* <Rating 
                  value={skill.rating !== null ? skill.rating : "0"}  
                  stars={5} 
                  readOnly 
                  cancel={false}
                  style={{marginTop:'3px'}}
              /> */}
            </span>

          </li>
        </ul>
        // <p class="text-1000 mb-0">{skill.skill_name}</p>
        ))}
       
      </CardBody>
      
    </Card>

    
  );
};

export default FeedInterest;
