import React from 'react';
import { Card, CardBody } from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import { Rating } from 'primereact/rating';

const FeedInterest = ({skill}) => {
  console.log(skill,"check skill")

  return (
    <Card className="mb-3">
      <FalconCardHeader title="Top Skills" titleTag="h5" />
      <CardBody className="fs--1">
      <h6>{skill?.skill_category }</h6>
        
        
      {skill?.selected_skill?.map(skill => (
        <ul style={{
          padding: 0,
          listStyle: "none",
          marginBottom: "10px",
        }}>
          <li>
            <span>
              {skill.skill_name} 
            </span>
            <span >
              <Rating 
                  value={skill.rating !== null ? skill.rating : "0"} 
                  stars={5} 
                  readOnly 
                  cancel={false}
                  style={{marginTop:'3px'}}
              />
            </span>

          </li>
        </ul>
        // <p class="text-1000 mb-0">{skill.skill_name}</p>
        ))}
       
      </CardBody>
      
    </Card>

    
  );
};

export default FeedInterest;
