import React, { useEffect, useState } from "react";
import {
  Card,
  CardBody,
  CardFooter,
  Table,
  Container,
  Row,
  Col,
  Input,
  FormGroup,
  Label,
  Button,
  Alert,
} from "reactstrap";
import FalconCardHeader from "../common/FalconCardHeader";
import axios from "axios";
import config from "../../helpers/config";
import { useParams } from "react-router-dom";
import Loader from "../common/Loader";
import ScheduleMeeting from "../recruiter/ScheduleMeeting";
import Modal from "react-awesome-modal";
import { toast } from "react-toastify";
import RatingModal from "./RatingModal";

const AppliedCandidate = ({ title }) => {
  const [appliedCandidate, setAppliedCandidate] = useState(null);
  const [isLoading, setIsLoading] = useState(true);
  const [modal, setModal] = useState(false);
  const [ratingmodal, setRatingModal] = useState(false);

  const [appID, setappID] = useState("");
  const { id } = useParams();
  const [isModalOpen, setModalOpen] = useState(false);
  const [rejectId, setRejectId] = useState(0);
  const [userId, setUserId] = useState(null);
  const [applicationId, setapplicationId] = useState(null);


  const [userSkill, setUserSkill] = useState(null);
  const [cars, setCars] = useState([]);
let newCar ={};

  const getAppliedCandidate = async () => {
    const formBody = new FormData();
    formBody.append("company_id", id);
    const res = await axios.post(
      `${process.env.REACT_APP_API_URL}/company/get_applied_candidate`,
      formBody
    );
    if (res?.data?.status_code === 200) {
      console.log('applied candidate data', res?.data?.result?.data?.applied_jobs);
      setAppliedCandidate(res?.data?.result?.data?.applied_jobs);
      setIsLoading(false);
    }
  };
  const acceptHandler = (id) => {
    console.log(id);
    setModal(true);
    setappID(id);
  };
  const assignHandler = (id) => {
    console.log(id);
  };

  const rejectHandler = (id) => {
    setModalOpen(true);
    setRejectId(id);
  };


  const skillHandler = async (id) => {
    const formBody = new FormData();
    formBody.append("user_id", id);
    await axios({
      method: "post",
      url: `${process.env.REACT_APP_API_URL}/get_selected_skills`,
      // url:'http://13.49.154.94/backend/api/v2/get_selected_skills',

      data: formBody,

      headers: { "Content-Type": "multipart/form-data" },
    })
      .then((res) => {
        setUserSkill(res?.data?.result?.data);

        res.data.result.data.selected_skill.map((skill, index) =>
        
        setSkillFn(skill,index)
        
        
        );
        setCars(array)
        console.log(array);
        // setUserSkill(res?.data?.result?.data)

        // setIsValueChange(false)
      })
      .catch((err) => console.log(err));
  };
  useEffect(() => {
    getAppliedCandidate();
  }, []);
  let array =[];
  const setSkillFn = (skill,index) => {
    console.log(skill.id);
     array[index] = {
      id:skill.id,
      rating:0
     }
    

     
    
  };
  const yesDelete = () => {
    let bodyFormData = new FormData();

    bodyFormData.append("app_id", rejectId);

    axios({
      method: "post",
      url: `${process.env.REACT_APP_API_URL}/jobs/reject_candidate`,
      data: bodyFormData,
      headers: { "Content-Type": "multipart/form-data" },
    })
      .then(function(response) {
        if (response?.status == 200) {
          // window.location.reload()
          toast.success("Rejected!");
          setModalOpen(false);
          getAppliedCandidate();
        }
      })
      .catch(function(response) {
        //handle error
        console.log(response);
      });
  };

  const closeModal = () => {
    setModalOpen(false);
    setRatingModal(false);
  };

  const ratingHandler = (id,appId) => {
    // alert(id)
   
    setUserId(id);
    setRatingModal(true);
    skillHandler(id);
    setapplicationId(appId);
    // setModalOpen(false);
  };

  function Applistatus(status){
    if (status === 'Finalized'){
      console.log('shortlist')
      return 'Shortlist'
    }else{
      return status
    }
  }

  return (
    <>
      <Modal
        visible={isModalOpen}
        width="600"
        height="350"
        effect="fadeInUp"
        onClickAway={() => closeModal()}
      >
        <div style={{ textAlign: "center" }}>
          <img
            src="https://images.vexels.com/media/users/3/128917/isolated/preview/3fa111197f6aee0add60c05829d0f196-exclamation-point-icon-by-vexels.png"
            width="100px"
            style={{
              marginTop: "40px",
              marginBottom: "20px",
              textAlign: "center",
            }}
          />

          <h1 style={{ textAlign: "center" }}>Are you sure?</h1>
          <p style={{ textAlign: "center" }}>
            You won't be able to revert this!
          </p>
          <Button
            style={{ marginTop: "10px", marginRight: "10px" }}
            color="primary"
            size="lg"
            onClick={() => yesDelete()}
          >
            Yes, reject it!
          </Button>
          <Button
            style={{ marginTop: "10px" }}
            color="danger"
            size="lg"
            onClick={() => closeModal()}
          >
            Cancel
          </Button>
        </div>
      </Modal>{" "}
      {isLoading ? (
        <Loader />
      ) : (
        <Card className="mb-3">
          <FalconCardHeader title={title} />

          <CardBody className="text-justify">
            <Container>
              <style jsx>{`
                th {
                  font-size: 12px;
                }
                tr td {
                  color: black;
                }
              `}</style>
              <Row>
                <ScheduleMeeting
                  appID={appID}
                  modal={modal}
                  setModal={setModal}
                  getAppliedCandidate={getAppliedCandidate}
                  getCompanyID={id}
                  setIsLoading={setIsLoading}
                />
                <RatingModal
                  userSkill={userSkill}
                  appID={appID}
                  modal={ratingmodal}
                  setModal={setRatingModal}
                  getAppliedCandidate={getAppliedCandidate}
                  setIsLoading={setIsLoading}
                  cars={cars}
                  setCars={setCars}
                  userId = {userId}
                  applicationId = {applicationId}
                />
                <Col md="4">
                  <FormGroup>
                    <Label>Contact Certifier</Label>
                    <Input type="select" className="form-control-sm">
                      <option>Select</option>
                      <option>Contracted</option>
                      <option>Pending</option>
                      <option>Not Contracted</option>
                    </Input>
                  </FormGroup>
                </Col>
                <Col md="4">
                  <FormGroup>
                    <Label>Certification Rating</Label>
                    <Input type="select" className="form-control-sm">
                      <option>Select</option>
                      <option>1</option>
                      <option>2</option>
                      <option>3</option>
                      <option>4</option>
                      <option>5</option>
                    </Input>
                  </FormGroup>
                </Col>
                <Col md="4">
                  <FormGroup>
                    <Label>Recom. Candidate</Label>
                    <Input type="select" className="form-control-sm">
                      <option>Select</option>
                      <option>Recommended</option>
                      <option>Regret</option>
                    </Input>
                  </FormGroup>
                </Col>
              </Row>
              <Row>
                <Col md="4">
                  <FormGroup>
                    <Label>Job Title</Label>
                    <Input type="select" className="form-control-sm">
                      <option>New</option>
                      <option>Developer</option>
                    </Input>
                  </FormGroup>
                </Col>
                <Col md="4">
                  <FormGroup>
                    <Label>Status</Label>
                    <Input type="select" className="form-control-sm">
                      <option>Select</option>
                      <option>Applied</option>
                      <option>Shortlisted</option>
                      <option>Finalized</option>
                      <option>Rejected</option>
                    </Input>
                  </FormGroup>
                </Col>
              </Row>
            </Container>
            {/*<Table bordered>
                  <thead>
                    <tr>
                      <th>Data</th>
                      <th>Job Title</th>
                      <th>Certfication</th>
                      <th>Rating</th>
                      <th>Name</th>
                      <th>Phone</th>
                      <th>Status</th>
                      <th>Name of Rec. Company</th>
                      <th>Contact Certifier</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      No Data
                    </tr>
                  </tbody>
                  <tfoot/>
                </Table>*/}
            <div className="table-responsive">
              <Table
                className="table table-striped table-sm table"
                style={{ tableLayout: "auto", width: "100%" }}
              >
                <thead>
                  <tr
                    style={{
                      fontSize: "12px",
                      textTransform: "uppercase",
                      color: "black",
                    }}
                  >
                    <th style={{ minWidth: "65px" }}>Job Id</th>
                    <th style={{ minWidth: "70px" }}>Job Title</th>
                    <th>Candidate</th>
                    <th style={{ minWidth: "80px" }}>Cand. Email</th>
                    <th>Phone</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  {appliedCandidate?.length > 0 ? (
                    appliedCandidate?.map((user, index) => (
                      <tr key={index}>
                        <td>{user.job_id}</td>
                        <td>{user.job_detail.job_title}</td>
                        <td>
                          {user.candidate_details.user_f_name
                            ? user.candidate_details.user_f_name
                            : null}
                          {user.candidate_details.user_l_name
                            ? user.candidate_details.user_l_name
                            : null}
                        </td>
                        <td>
                          {user.candidate_details.user_email
                            ? user.candidate_details.user_email
                            : "NA"}
                        </td>
                        <td>
                          {user.candidate_details.user_phone
                            ? user.candidate_details.user_phone
                            : "NA"}
                        </td>
                        <td>
                          {user.application_status == "Shortlisted"
                            ? "Interview Scheduled"
                            : Applistatus(user.application_status)}
                        </td>
                        <td>
                          {user.application_status == "Applied" && (
                            <Button
                              className="buttonHire hirebtn"
                              color="info"
                              size="sm"
                              onClick={(e) => assignHandler(user.id)}
                            >
                              Assign To Private
                            </Button>
                          )}
                          {user.application_status == "Applied" && (
                            <Button
                              className="buttonHire hirebtn"
                              color="success"
                              size="sm"
                              onClick={(e) => acceptHandler(user.id)}
                            >
                              Schedule Interview
                            </Button>
                          )}
                          {user.application_status == "Shortlisted" && (
                            <div>
                              <Button
                                className="buttonHire hirebtn"
                                color="danger"
                                size="sm"
                                onClick={(e) => rejectHandler(user.id)}
                              >
                                Reject
                              </Button>
                              <Button
                                className="buttonHire hirebtn"
                                color="info"
                                size="sm"
                                onClick={(e) =>
                                  ratingHandler(user.candidate_id,user.id)
                                }
                              >
                                Give rating
                              </Button>
                            </div>
                          )}
                          {(user.application_status == "Rejected" || user.application_status == "Finalized")? Applistatus(user.application_status) : '' }
                        </td>
                      </tr>
                    ))
                  ) : (
                    <tr className="danger">
                      <td colspan="7" style={{ padding: "2px 0" }}>
                        <Alert color="danger">No Cerification Found</Alert>
                      </td>
                    </tr>
                  )}
                </tbody>
                <tfoot />
              </Table>
            </div>
          </CardBody>

          <CardFooter className="bg-light p-0 border-top" />
        </Card>
      )}
    </>
  );
};
export default AppliedCandidate;
