import React,{useEffect, useState} from 'react'
import { Card, CardBody, CardFooter, Row, Col,Table,Badge, Container,Alert, Button, Input,UncontrolledDropdown} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import axios from 'axios';
import config from '../../helpers/config';
import {useParams} from 'react-router-dom';
import Loader from '../common/Loader';
import usePostFetch from "../../hooks/usePostFetch";
import {toast} from 'react-toastify';
import CandidateRequestedList from './CandidateRequestedList'
import './Recruiter.css';

const CandidateList = ({title, data}) => {
  
  const [candidateList, setCandidateList] = useState(null)
  const [hiredPC, setHiredPC] = useState(null)
  const [selectedPC, setSelectedPC] = useState("")
  const [loading, setLoading] = useState(true)
  const [reload, setReload] = useState(false)
  const [acceptedCandidate, setAcceptedCandidate] = useState(null)

  useEffect(() => {
    getCandidate()
    getAllHiredPc()
    // getAllAssignCandidate()
    setReload(false)
  },[reload])

  const {id} = useParams();

  const getAllHiredPc = async () => {
    const formBody = new FormData();
    formBody.append('default_user', localStorage.getItem('default_user'))
    formBody.append('recruitment_company_id', id)
    
    const res = await axios.post(`http://13.49.154.94./backend/api/v2/company/private_certifier/hired_list`, formBody)
    console.log(res,"dddddddddddddddddddddd")
    if(res?.data?.status_code === 200){
      setHiredPC(res?.data?.result?.data?.private_certifier)
    }
  }
    console.log(selectedPC,"ssssssssssssssssssss")

  // const api = 'company/private_certifier/get_all_assigned_candidate'
  // const obj = {
  //   default_user: localStorage.getItem('default_user'),
  //   private_certifier_id:
  // }
  //   const { loading, data } = usePostFetch(api, obj);
  // }


  // const getAllAssignCandidate = async () => {
  //   const res = await axios.post(`http://13.49.154.94./backend/api/v2/company/private_certifier/get_all_assigned_candidate?default_user=${localStorage.getItem('default_user')}&private_certifier_id=${56}&company_id=${id}`)
  //   console.log(res)
  // }

  const getCandidate = async () => {
    
    const res = await axios.post(`${config.API_URL()}company/candidate_list?company_value=${id}`)
    // console.log(res)
    if(res?.data?.status === true){
      setCandidateList(res?.data?.data)
        setLoading(false)
    }
  }
  const assignPcHandler = (candidate_id) => {
    let assignCandidateBody = new FormData();
    assignCandidateBody.append('default_user', localStorage.getItem('default_user'))
    assignCandidateBody.append('private_certifier_id', selectedPC)
    assignCandidateBody.append('candidate_id', candidate_id)
    assignCandidateBody.append('company_id', id)
    assignCandidateBody.append('assignToPrivate',true)
    
    axios({
      method: "post",
      url: `${process.env.REACT_APP_API_URL}/company/private_certifier/assign_candidate`,
      data: assignCandidateBody,
      headers: { "Content-Type": "multipart/form-data" },
    })
    .then(res => {
      if(res?.data?.result?.data?.status == true){
        toast.success(res?.data?.result?.data?.message)
        setReload(true)
      }
      if(res?.data?.result?.data?.status == false){
       toast.error(res?.data?.result?.data?.message) 
      }
    })
    .catch(err => console.log(err))
      }
  console.log(candidateList,"candidateList")

  const onChangeSelect = e => {
    setSelectedPC(e.target.value)
  }
  const filterAcceptedCandidate = candidateList?.filter(candidate => candidate.request_status == "Accepted")
  console.log(selectedPC,"selectedPCselectedPC")
  
const headerTitle = "Accepted Candidate for Certification";
	return(
		<Card className="mb-3" style={{minWidth:'100%'}}>
      
      
      <FalconCardHeader title={title} />
          <CardBody className="text-justify">
          <Row>
            <Col md="12">
              <CandidateRequestedList 
                candidateList={candidateList} 
                setReload={setReload}
                loading={loading}
              />
            </Col>
          </Row>
          <hr/>
          <Row>
            <Col md="12">
              
            
      
      {loading ? <Loader/> : (
        <>
        {filterAcceptedCandidate?.length > 0 ? (
            <div className="table-responsive">
            <Table className="table table-striped table-sm table" style={{tableLayout: "auto", width: "100%"}} >
            <style jsx>{`
              th { font-size: 12px; color: "black" }
              tr td, tr th { color: black; }
            `}</style>
            <thead>
              <tr className="text-center">
                <th colspan="5" style={{color: "black", textTransform: "uppercase"}}>{headerTitle}</th>
              </tr>
              <tr style={{fontSize: "12px", textTransform: "uppercase", color: "black" }}>
                <th><b>S. No.</b></th>
                <th><b>Name</b></th>
                <th><b>Email</b></th>
                <th><b>Private Certifier</b></th>
                <th><b>Assign Cand.</b></th>
              </tr>
            </thead>
            {filterAcceptedCandidate?.map((candidate, index) => (
              <tbody key={index}>
              <tr>
                <td>{index+1}.</td>
                <td>{candidate.recruiter_profile.user_f_name } {candidate.recruiter_profile.user_l_name}</td>
                <td>{candidate.recruiter_profile.user_email}</td>
                <td>
                {candidate.is_assigned === true 
                  ? <h6><Badge color="secondary" pill>{candidate?.private_certifier?.certifier_name}</Badge></h6>  
                  : (
                    <Input type="select" 
                      // value={selectedPC} 
                      onChange={e => onChangeSelect(e)} 
                      defaultValue={"0"}
                    >
                    <option value="0">Select PC</option>
                      {hiredPC?.map((pc, index) => (
                        <option value={pc.private_certifier_id} key={pc.id}>
                          {pc.private_certifier.certifier_name}
                        </option>
                      ))}
                  </Input>
                    )}
                  
                </td>
                <td>
                {candidate.is_assigned === true ? 
                  <Badge color="success" pill>Assigned</Badge>
                  : (
                    <Button 
                      color="primary" 
                      size="sm"
                      onClick={e => assignPcHandler(candidate.user_id)}
                      >Assign</Button>
                    )}
                  
                
                </td>
                </tr>
            </tbody>
            ))}
          </Table>
          </div>
          ) : (
            <div className="table-responsive">
            <Table className="table table-striped table-sm table" style={{tableLayout: "auto", width: "100%"}} >
              <thead>
                <tr  style={{textAlign: "center", color: "black"}}>
                  <th>{headerTitle}</th>
                </tr>
              </thead>
              <tbody>
                    <tr className="danger">
                      <td style={{padding: "2px 0"}}>
                        <Alert color="danger">No Cerification Found</Alert>
                      </td>
                    </tr>
              </tbody>
            </Table>
            </div>
            
          )}
        
          </>
        )}
          </Col>
        </Row>
      {/*<div className="my-2">
        <Row>
          <Col>hello</Col>
        </Row>
      </div>*/}
      </CardBody>
      

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
		)
}
export default CandidateList