import React from 'react';
import { Card, CardBody, CardFooter, Row, Col, Container,Table,Badge,Alert, Button, Input,UncontrolledDropdown} from "reactstrap";
import axios from 'axios';
import {toast} from 'react-toastify';
import Loader from '../common/Loader';


const CandidateRequestedList = ({candidateList, setReload, loading}) => {
	console.log(candidateList,"candidateList==========")
	
	const acceptCandidateRequest = data => {
		console.log(data,"accept")
		const acceptBody = new FormData();
		acceptBody.append('default_user', localStorage.getItem('default_user'))
		acceptBody.append('user_id', data.user_id)
		acceptBody.append('company_id', data.company_id)
		acceptBody.append('request_type', data.request_type)
		acceptBody.append('request_status', "Accepted")

		axios({
			method:'post',
			url:`${process.env.REACT_APP_API_URL}/company/accept-candidate-invitation`,
			data:acceptBody,
			headers: { "Content-Type": "multipart/form-data" }
		})
		.then(res => {
			console.log(res)
			setReload(true)
			if(res?.data?.status_code === 200){
				toast.success(res?.data?.result?.data?.message)
			}
		})
		.catch(err => console.log(err))
	}
	
	const rejectCandidateRequest = data => {
		console.log("reject")
		const rejectBody = new FormData();
		rejectBody.append('default_user', localStorage.getItem('default_user'))
		rejectBody.append('user_id', data.user_id)
		rejectBody.append('company_id', data.company_id)
		rejectBody.append('request_type', data.request_type)
		rejectBody.append('request_status', "Rejected")

		axios({
			method:'post',
			url:`${process.env.REACT_APP_API_URL}/company/accept-candidate-invitation`,
			data:rejectBody,
			headers: { "Content-Type": "multipart/form-data" }
		})
		.then(res => {
			console.log(res)
			setReload(true)
			if(res?.data?.status_code === 200){
				toast.error(res?.data?.result?.data?.message)
			}
		})
		.catch(err => console.log(err))
	}
	
	return(
		<>
		{loading ? <Loader/> : (

			<div className="table-responsive">
			<Table className="table table-striped table-sm table" style={{tableLayout: "auto", width: "100%"}} >
				<style jsx>{`
					th { font-size: 12px; }
					tr td { color: black; }        
				`}</style>
				<thead>
				<tr style={{fontSize: "12px", textTransform: "uppercase", color: "black", textAlign: "center" }}>
					<th colspan="5">Requested Candidate</th>
				</tr>
				<tr style={{fontSize: "12px", textTransform: "uppercase", color: "black" }}>	
						<th>S.No.</th>
						<th>Candidate Name</th>
						<th>Email</th>
						<th>Status</th>
						<th>Action</th>
					</tr>
				</thead>
				<tbody>
				{candidateList?.length > 0 ? candidateList?.map((candidate, index) => (
					<tr key={index}>
						<td>{index+1}.</td>
						<td>{candidate.recruiter_profile.user_f_name} {candidate.recruiter_profile.user_l_name}</td>
						<td>{candidate.recruiter_profile.user_email}</td>
						<td>
							<Badge color={candidate.request_status == "Accepted" ? "success" : candidate.request_status == "Pending" ? "primary" : "danger"} pill>{candidate.request_status}</Badge>
						</td>
						<td>{candidate.request_status == "Pending" ? (
							<div className="d-flex flex-column">
								<Button 
									size="sm" 
									color="success" 
									onClick={e => acceptCandidateRequest(candidate)}
								>Accept</Button>		
								
								<Button 
									size="sm" 
									color="danger" 
									className="mt-1" 
									onClick={e => rejectCandidateRequest(candidate)}
								>Reject</Button>		
							</div>
						) : (
						<Badge color="primary" size="lg" pill>Responded</Badge>
						
						)}</td>
					</tr>
					)) : (
						
					<tr className="danger">
						<td  colspan="6" style={{padding: "2px 0"}}>
						  <Alert color="danger">No Cerification Found</Alert>
						</td>
					</tr>
				)}
					
				</tbody>
			</Table>
			</div>
			)}
		</>
		)
}

export default CandidateRequestedList;