import React,{useState} from 'react'
import { Card, CardBody, CardFooter,CardHeader, Input, Form , Button, Media, Dropdown, DropdownToggle, DropdownMenu, DropdownItem} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
// import { FeedContext } from '../../context/Context';
// import FeedCard from '../feed/FeedCard';
import { Link } from 'react-router-dom';
import LikeComentShareCount from '../feed/LikeComentShareCount';
import IconStatus from '../feed/IconStatus';
import Flex from '../common/Flex';
import Comments from '../feed/Comments';

import FeedCardFooter from '../feed/FeedCardFooter';
import { isIterableArray } from '../../helpers/utils';
import Avatar from '../common/Avatar'
import data from './data/data.json'
import av3 from '../../assets/img/team/3.jpg';



const Discussion = ({title,dataProps}) => {
  const [content, setContent] = useState("")
  const [newData, setNewData] = useState(data)
  const [dropdownOpen, setDropdownOpen] = useState(false);

  const toggle = () => setDropdownOpen(!dropdownOpen);
 
  // console.log(data,"DATA from json")
  // console.log(newData,"DATA from dataProps")
  const handleSubmit = e => {
    e.preventDefault()
// console.log(content)

  }
	return(
    <>
		<Card className="mb-3">
    
      <FalconCardHeader title={title} />

      <CardBody className="text-justify">
      {dataProps && dataProps[0].user_id == localStorage.getItem('user_id') 
        ? (
            <>
                <Form onSubmit={handleSubmit}>
                  <Input
                  className="border-0 rounded-0 resize-none my-3"
                  placeholder="What do you want to talk about?"
                  type="textarea"
                  rows="4"
                  spellCheck="false"
                  value={content}
                  onChange={({ target }) => {
                      setContent(target.value);
                  }}
            
                  />
                  <Button color="primary">POST</Button>
                </Form>
            </>
        ):"Only company admin can post"}
      
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    {data.map(item => (
      <Card className="mb-3" key={item.id}>
      
        <FalconCardHeader 
          title={
        <div className="d-flex">
          <Avatar src={item.user.avatarSrc} className={item.user.status} size="2xl" />
          <Media body className="align-self-center ml-2">
            <p className="mb-1 line-height-1">
              <Link className="font-weight-semi-bold" to={{
                pathname: `/pages/profile/${item.user.user_id}`,
                state: {
                    data:item
                }
              }}>
                {item.user.name ===" " ? item.user.user_id :  item.user.name }
              </Link>
              {!!item.user.share && (
                <span className="ml-1">
                  shared {/^[aeiou]/g.test(item.user.share.toLowerCase()) ? 'an' : 'a'} <a href="#!">{item.user.share}</a>
                </span>
              )}
            </p>
            <p className="mb-0 fs--1">
              {item.content.time} • {' '}
              
            </p>
          </Media>
           <Dropdown isOpen={dropdownOpen} toggle={toggle}>
              <DropdownToggle color="text-white">
                . . .
              </DropdownToggle>
              
            </Dropdown>
        </div>
      }
         />

        <CardBody>{item.content.status}</CardBody>
        <CardFooter className="bg-light pt-0">
          <LikeComentShareCount countLCS={item.footer.countLCS} comments={item.footer.comments} />
          <Flex  align="center" className="border-top border-200 pt-3" >
          <Avatar src={av3} size="xl" />
          <Input
            className="rounded-capsule ml-2 fs--1"
            placeholder="Write a comment..."
          
          />
          </Flex>
          {isIterableArray(item.footer.comments) && <Comments comments={item.footer.comments} loadComment={item.user.otherComments} />}
        </CardFooter>
    </Card>
      ))}
    
    </>
		)
}
export default Discussion