import React,{useState, useEffect} from 'react';
import { Card, CardBody, CardFooter, Table,Container,Button, Row, Col, Input, Form, FormGroup, Label} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import axios from 'axios'
import spinner from "../../assets/img/media/spinner.gif";
import { Link, useHistory } from "react-router-dom";
import Modal from 'react-awesome-modal';
import config from '../../helpers/config'

// import {options_industry} from '../common/data/industryOption';




const EditCompanyEditorRole = ({title, data, checkingUserRole}) => {
  console.log(checkingUserRole,"checkingUserRole")
  
	const history = useHistory()
  
	
	
  const [isLoading, setIsLoading] = useState(false)
  const [isModalOpen, setModalOpen] = useState(false)

const [industry, setIndustry] = useState([])
  

  useEffect(() => {
    const fetchingIndustry = async () => {
        const industryReq = await axios.post(`${process.env.REACT_APP_API_URL}/company/industries-list`)
        
          setIndustry(industryReq?.data)
        
    }
    fetchingIndustry()
    //http://13.49.154.94/backend/api/v2/company/industries-list
  },[])
        


	const [formData, setFormData] = useState({
		company_name: data[0]?.company_name,
    	company_username: data[0]?.company_username,
    	year_established: data[0]?.year_established,
    	number_of_emp: data[0]?.number_of_emp,
    	total_annual_sales: data[0]?.total_annual_sales,
    	main_markets: data[0]?.main_markets,
    	certifications: data[0]?.certifications,
    	headquarter: data[0]?.headquarter,
    	company_logo: "",
    	company_banner: "",
    	company_location: data[0]?.company_location,
    	company_video: data[0]?.company_video,
    	business_type: data[0]?.business_type,
    	products_services: data[0]?.products_services,
    	product_certifications: data[0]?.product_certifications,
    	company_industry: data[0]?.company_industry,
    	company_skills: [],
    	company_profile: data[0]?.company_profile,
    	company_verified_status: data[0]?.company_verified_status,
    	company_contactus: data[0]?.company_contactus,
    	company_email: data[0]?.company_email,
    	company_city: data[0]?.company_city,
    	company_state: data[0]?.company_state,
    	company_country: data[0]?.company_country,
    	company_aboutus: data[0]?.company_aboutus,
    	recruitement_company: data[0]?.recruitement_company,
	});

	const {
    company_name,
		company_username,
		year_established,
		number_of_emp,
		total_annual_sales,
		main_markets,
		certifications,
		headquarter,
		company_logo,
		company_banner,
		company_location,
		company_video,
		business_type,
		products_services,
		product_certifications,
		company_industry,
		company_skills,
		company_profile,
		company_verified_status,
		company_contactus,
		company_email,
		company_city,
		company_state,
		company_country,
		company_aboutus,
		recruitement_company
  	} = formData;
	
	

	const onSubmitUpdate = async (e) => {
		e.preventDefault();
    setIsLoading(true)
		
		const config = {
			headers:{
				'content-type': 'multipart/form-data'
			}
		}
		
    const bodyFormData = new FormData()

    bodyFormData.append('company_name',company_name)
    bodyFormData.append('company_username',company_username)
    bodyFormData.append('year_established',year_established)
    bodyFormData.append('number_of_emp',number_of_emp)
    bodyFormData.append('total_annual_sales',total_annual_sales)
    bodyFormData.append('main_markets',main_markets)
    bodyFormData.append('certifications',certifications)
    bodyFormData.append('headquarter',headquarter)
    bodyFormData.append('company_logo',company_logo, company_logo.name)
    bodyFormData.append('company_banner',company_banner, company_banner.name)
    bodyFormData.append('company_location',company_location)
    bodyFormData.append('company_video',company_video)
    bodyFormData.append('business_type',business_type)
    bodyFormData.append('products_services',products_services)
    bodyFormData.append('product_certifications',product_certifications)
    bodyFormData.append('company_industry',company_industry)
    bodyFormData.append('company_skills',company_skills)
    bodyFormData.append('company_profile',company_profile)
    bodyFormData.append('company_verified_status',company_verified_status)
    bodyFormData.append('company_contactus',company_contactus)
    bodyFormData.append('company_email',company_email)
    bodyFormData.append('company_city',company_city)
    bodyFormData.append('company_state',company_state)
    bodyFormData.append('company_country',company_country)
    bodyFormData.append('company_aboutus',company_aboutus)
    // bodyFormData.append('recruitement_company')

    //   bodyFormData.append('company_name', company_name);
    // bodyFormData.append('company_email', email);
    // bodyFormData.append('year_established', established);
    // bodyFormData.append('number_of_emp', employees);
    // bodyFormData.append('total_annual_sales', sales);
    // bodyFormData.append('main_markets', market);
    // bodyFormData.append('certifications', certifications);
    // bodyFormData.append('headquarter', headquarter);
    // bodyFormData.append('company_location', location);
    // bodyFormData.append('company_username', company_username);
    // bodyFormData.append('company_logo', company_logo, company_logo.name);
    // bodyFormData.append('company_banner', banner, banner.name);
    // bodyFormData.append('company_video', profilevideo);
    // bodyFormData.append('company_industry', industry);
    // bodyFormData.append('company_profile', profile);
    // bodyFormData.append('company_aboutus', aboutus);
    // bodyFormData.append('company_contactus', phone);
    // bodyFormData.append('business_type', business);
    // bodyFormData.append('products_services', services);
    // bodyFormData.append('product_certifications', productcertifications);
    // bodyFormData.append('company_city', city);
    // bodyFormData.append('company_state', state);
    // bodyFormData.append('company_country', country);
    // bodyFormData.append('skill', skills);
  

    // fd.append('company_logo', company_logo, company_logo.name)

		const updateCompany =  await axios.post(`${process.env.REACT_APP_API_URL}/company/page/edit?default_user=${localStorage.getItem('default_user')}&company_page_id=${data[0].id}`, bodyFormData, config)
    console.log(updateCompany,"updateCompanyupdateCompany")
    if(updateCompany?.data?.status_code === 200){
      setIsLoading(false)
      setModalOpen(true)
    }
	}

	const onChangeHandler = (e) => {
    console.log(e.target.value)
    setFormData({
      ...formData,
      [e.target.name]: e.target.value,
    });
  };

const convertBase64 = (file) => {
    return new Promise((resolve, reject) => {
      const fileReader = new FileReader();
      fileReader.readAsDataURL(file)
      fileReader.onload = () => {
        resolve(fileReader.result);
      }
      fileReader.onerror = (error) => {
        reject(error);
      }
    })
  }
  console.log(company_logo,"company_logo")

 const onChangeHandlerFile = async (event) => {
    const file = event.target.files
  console.log(file,"logo check")
    // const base64 = await convertBase64(file)
    // console.log(base64)
    if(file.length > 0){
      setFormData({
        ...formData,
        company_logo: file[0]
      })  
    }else{
      return 0;
    }
  }
const onChangeHandlerFileBanner = async (event) => {
    const file = event.target.files
    // const base64 = await convertBase64(file)
    // console.log(base64)
    if(file.length > 0){
      setFormData({
        ...formData,
        company_banner: file[0]
      })  
    }else{
      return 0;
    }
    
  }
  // const onChangeHandlerFile = e => {
  //   setFormData({
  //     ...formData,
  //     company_logo_image: e.target.files[0]
  //   })
  // }

  // const onChangeHandlerFileBanner = e => {
  	
  //   setFormData({
  //     ...formData,
  //     company_banner_image:e.target.files[0]
  //   })
  // }
  const closeModal = () => {
        setModalOpen(false)
        if(recruitement_company == 1){
         history.push('/pages/recruiter') 
        }else{
          history.push('/pages/company')
        }
    }
    console.log(formData)
	return(
		<>
		<Modal visible={isModalOpen} width="400" height="300" effect="fadeInUp" onClickAway={() =>closeModal()}>
        	<div style={{textAlign:"center"}}>
            	<img src="https://webstockreview.net/images/check-clipart-gif-animation-18.gif" width="200px" style={{marginTop:'0px', textAlign:'center'}}/>

            	<h1 style={{position:'absolute', top:'125px', left:'115px'}}>Updated</h1>
            	<p style={{textAlign:'center', marginTop:'32px'}}>Operation processed successfully</p>
            	<Button style={{marginTop:'2px'}} color="primary" size="lg" onClick={() => closeModal()}>OK</Button>
        	</div>
    	</Modal>
      {checkingUserRole ? 
        (<>
          

		<Card className="mb-3">
      		<FalconCardHeader title={title} />

		    <CardBody className="text-justify d-flex justify-content-between">
       			<Form onSubmit={e => onSubmitUpdate(e)}>
       				<FormGroup className="required">
              			<Label >Company Name</Label>

              			<Input
                			type="text"
                			placeholder="Company Name"
                			name="company_name"
                			value={company_name}
                			required
                			onChange={(e) => onChangeHandler(e)}
              			/>
            		</FormGroup>
            		<FormGroup className="required">
              <Label>Company Username</Label>

              <Input
                type="text"
                placeholder="Company Username"
                name="company_username"
                value={company_name}
                disabled
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label>Company Url : {(company_name?company_name:"null").toLowerCase().replace(/\s/g,'')}.castclass.com</Label>
            </FormGroup>

            <FormGroup className="required">
              <Label>Year Established</Label>

              <Input
                type="text"
                placeholder="Year Established"
                name="year_established"
                value={year_established}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Number of Employees</Label>

              <Input
                type="select"
                name="number_of_emp"
                value={number_of_emp}
                required
                onChange={(e) => onChangeHandler(e)}
              >
                <option value="1-25 people">1 - 25 People</option>
                <option value="2-50 people">2 - 50 People</option>
                <option value="3-100 people">3 - 100 People</option>
                <option value="4-150 people">4 - 150 People</option>
                <option value="5-200 people">5 - 200 People</option>
              </Input>
            </FormGroup>

            <FormGroup>
              <Label>Total Annual Sales Volume</Label>

              <Input
                type="text"
                placeholder="Total Annual Sales Volume"
                name="total_annual_sales"
                value={total_annual_sales}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Main Markets</Label>

              <Input
                type="text"
                placeholder="Main Markets"
                name="main_markets"
                value={main_markets}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Certifications</Label>

              <Input
                type="text"
                placeholder="Certifications"
                name="certifications"
                value={certifications}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label> Headquarter</Label>

              <Input
                type="text"
                placeholder="Headquarter"
                name="headquarter"
                value={headquarter}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label> Location</Label>

              <Input
                type="text"
                placeholder="Location"
                name="company_location"
                value={company_location}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label> Phone</Label>

              <Input
                type="number"
                placeholder="Phone"
                name="company_contactus"
                value={company_contactus}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label> Email</Label>

              <Input
                type="text"
                placeholder="Email"
                name="company_email"
                value={company_email}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label>Company Logo</Label>
              <Input
                type="file"
                // name="company_logo_image"
                // value={company_logo_image}
                required
                onChange={(e) => onChangeHandlerFile(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label>Company Banner</Label>
              <Input
                type="file"
                // name="company_banner_image"
                // value={company_banner_image}
                required
                onChange={(e) => onChangeHandlerFileBanner(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Profile Video (Note: Enter valid youtube url)</Label>

              <Input
                type="text"
                placeholder="Note: Enter valid youtube url"
                name="company_video"
                value={company_video}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> Business</Label>

              <Input
                type="text"
                placeholder="Business Type"
                name="business_type"
                value={business_type}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> Products Services</Label>

              <Input
                type="text"
                placeholder="Products Services"
                name="products_services"
                value={products_services}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Product Certifications</Label>

              <Input
                type="text"
                placeholder="Product Certifications"
                name="product_certifications"
                value={product_certifications}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup className="required">
              <Label>Industry</Label>

              <Input
                type="select"
                name="company_industry"
                value={company_industry}
                required
                onChange={(e) => onChangeHandler(e)}
              >
              {industry.map((data, key) => (
                <option key={key} value={data.id}>{data.industry}</option>
                ))}
             
              </Input>
              
            </FormGroup>

            <FormGroup>
              <Label> Skills/Roles hire for:</Label>

              <Input
                type="text"
                placeholder=""
                name="company_skills"
                value={company_skills}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Company City</Label>

              <Input
                type="text"
                placeholder="Company City"
                name="company_city"
                value={company_city}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> Company State</Label>

              <Input
                type="text"
                placeholder="Company State"
                name="company_state"
                value={company_state}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup>
              <Label> Company Country</Label>

              <Input
                type="text"
                placeholder="Company Country"
                name="company_country"
                value={company_country}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label> Company Profile</Label>

              <Input
                type="textarea"
                name="company_profile"
                value={company_profile}
                required
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>
            <FormGroup>
              <Label> About Us</Label>

              <Input
                type="textarea"
                name="company_aboutus"
                value={company_aboutus}
                onChange={(e) => onChangeHandler(e)}
              />
            </FormGroup>

            <FormGroup className="required">
              <Label>Verify the Company</Label>

              <Input
                type="select"
                name="company_verified_status"
                value={company_verified_status}
                required
                onChange={(e) => onChangeHandler(e)}
              >
                <option value="applied">Applied </option>
                <option value="not_applied">Not Applied </option>
              </Input>
            </FormGroup>
            {
              isLoading ? 
                <>
                    <img src={spinner} width="25px" style={{marginRight:'54px',marginLeft:'36px', textAlign:'center'}}/>
                </> 
                : 
                <Button color="primary" className="button_btn" type="submit">
                  Submit
                </Button>
            }
            <Link to="/pages/recruiter">
              <Button color="secondary">Cancel</Button>
            </Link>
       			</Form>
      		</CardBody>

		      <CardFooter className="bg-light p-0 border-top">
        
      		  </CardFooter>
    	</Card>
      </>
        ):(
        <Card>
          <CardBody>
            Unauthorized!
          </CardBody>
        </Card>
        )}
    	</>
		)
}
export default EditCompanyEditorRole