import React, { useEffect, useState } from "react";
import {
  Card,
  CardBody,
  CardFooter,
  Table,
  Container,
  Row,
  Col,
  Input,
  FormGroup,
  Label,
  Button,
  Alert,
  Collapse,
  Form,
} from "reactstrap";
import { Rating } from "primereact/rating";
import { toast } from "react-toastify";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import FalconCardHeader from "../common/FalconCardHeader";
import axios from "axios";
import config from "../../helpers/config";
import { useParams } from "react-router-dom";
import Loader from "../common/Loader";
import ScheduleMeeting from "../recruiter/ScheduleMeeting";
const InterviewDetails = ({
  title,
  intId,
  setIntId,
  candidateId,
  jobID,
  appID,
}) => {
  const [isLoading, setIsLoading] = useState(true);
  const [interviewData, setinterviewData] = useState(false);
  const [userSkill, setUserSkill] = useState(null);
  const [cars, setCars] = useState([]);
  const [comment, setComment] = useState("");
  const [recom, setRecom] = useState(0);
  const [recomStatus, setRecomStatus] = useState("");
  const [isTopSkill, setisTopSkill] = useState(0);

  //  console.log(id);
  const getInterviewDetails = async () => {
    setIsLoading(true);
    const formBody = new FormData();
    formBody.append("int_id", intId);
    formBody.append("candidateId", candidateId);
    formBody.append("jobID", jobID);
    formBody.append("appID", appID);

    const res = await axios.post(
      `${config.API_URL()}jobs/get_interview_details`,
      formBody
    );

    if (res?.data?.status === 200) {
      // console.log(res?.data?.data);
      setinterviewData(res?.data?.data);
      // setIsLoading(false);
      setRecom(res?.data?.data?.recom_data?.recommend_regret);
      setRecomStatus(res?.data?.data?.recom_data?.recommend_regret);
      setComment(res?.data?.data?.recom_data?.message);
    }
    const ff = new FormData();
    ff.append("user_id", candidateId);
    axios({
      method: "post",
      url: `${process.env.REACT_APP_API_URL}/get_selected_skills`,
      // url:'http://13.49.154.94/backend/api/v2/get_selected_skills',

      data: ff,

      headers: { "Content-Type": "multipart/form-data" },
    })
      .then((res) => {
        setIsLoading(false);
        setUserSkill(res?.data?.result?.data);
        res.data.result.data.selected_skill.map((skill, index) =>
          setSkillFn(skill, index)
        );
        setCars(array);
        // setUserSkill(res?.data?.result?.data)
      })
      .catch((err) => console.log(err));
  };
  let array = [];
  const setSkillFn = (skill, index) => {
    console.log(skill.id);
    array[index] = {
      id: skill.id,
      rating: skill.rating,
    };
  };

  const setRecomend = (e) => {
    setRecom(e.target.value);
    setRecomStatus(e.target.value);
  };
  const submitHandle = (e) => {
    e.preventDefault();
    e.preventDefault();
    const curr_url = window.location.href;
    const company_id = curr_url.split("/").pop();

    const formBody = new FormData();
    formBody.append("hire_status", "HireStatus");
    formBody.append("rating_string", JSON.stringify(cars));
    formBody.append("candidate_id", candidateId);
    formBody.append("applicationId", appID);
    formBody.append("jobID", jobID);
    formBody.append("comment", comment);
    formBody.append("recom", recom);

    axios({
      method: "post",
      url: `${process.env.REACT_APP_API_URL}/company/submit_feedback_rating`,
      data: formBody,
      headers: { "Content-Type": "multipart/form-data" },
    })
      .then((res) => {
        // console.log(res);
        toast.success("Submitted successfully!");
        getInterviewDetails();
      })
      .catch((err) => console.log(err));
  };


  const setStars = (index, val) => {
    const newItems = [...cars];
    newItems[index].rating = val;
    setCars(newItems);
    // console.log(cars);
  };
  useEffect(() => {
    // console.log(intId);
    getInterviewDetails();
  }, []);
  const backHandle = (id) => {
    setIntId(0);
  };
  return (
    <>
      {isLoading ? (
        <Loader />
      ) : (
        <Card className="mb-3">
          <Button
            className="buttonHire hirebtn"
            color="success"
            size="sm"
            onClick={() => backHandle()}
          >
            Back
          </Button>
          <FalconCardHeader title={title} />

          <CardBody className="text-justify">
            <div className="row">
              <div className="col-md-6">
                <h4>Candidate Details</h4>
                <Row>
                  <Col md="3">Name :</Col>
                  <Col>
                    {interviewData.candidate?.user_f_name +
                      " " +
                      interviewData.candidate?.user_l_name}
                  </Col>
                </Row>

                <Row>
                  <Col md="3">Email :</Col>
                  <Col>{interviewData.candidate?.user_email}</Col>
                </Row>
                <Row>
                  <Col md="3">DOB :</Col>
                  <Col>{interviewData.candidate?.user_dob}</Col>
                </Row>
                <Row>
                  <Col md="3">Gender :</Col>
                  <Col>
                    {interviewData.candidate?.user_gender ? "Male" : "Female"}
                  </Col>
                </Row>
                <Row>
                  <Col md="3">Marritial Status :</Col>
                  <Col>{interviewData.candidate?.user_maritial_status}</Col>
                </Row>
                <Row>
                  <Col md="3">City :</Col>
                  <Col>{interviewData.candidate?.user_city}</Col>
                </Row>
                <Row>
                  <Col md="3">Address :</Col>
                  <Col>{interviewData.candidate?.user_address}</Col>
                </Row>
              </div>
              <div className="col-md-6">
                <h4>Job Information</h4>
                <Row>
                  <Col md="3">Job Title :</Col>
                  <Col>{interviewData.job?.job_title}</Col>
                </Row>

                <Row>
                  <Col md="3">Company Name :</Col>
                  <Col>{interviewData.job?.company_name}</Col>
                </Row>
                <Row>
                  <Col md="3">Experience Level :</Col>
                  <Col>{interviewData.job?.experience_level}</Col>
                </Row>
                <Row>
                  <Col md="3">Type :</Col>
                  <Col>{interviewData.job?.employment_type}</Col>
                </Row>
                <Row>
                  <Col md="3">Location :</Col>
                  <Col>{interviewData.job?.job_location}</Col>
                </Row>
                {/* <Row>
                  <Col md="3">Job Description :</Col>
                  <Col>{interviewData.job?.job_desc}</Col>

                </Row> */}
              </div>
            </div>
            <br />
            <div className="row">
              <div className="col-md-6">
                <h4>Top Skills</h4>

                {interviewData?.top_skills?.map((skill, index) => (
                  <div value="333" key={index}>
                    {skill.skill_name}
                    {/* {setisTopSkill(1)} */}
                    <br />
                    <Rating
                      value={skill.rating}
                      stars={5}
                      cancel={false}
                      required
                    />
                  </div>
                ))}

                {!interviewData?.top_skills?.length ? "No record found!" : null}
                <br />

                <h4>Entry Level Skills</h4>
                {/* {userSkill?.skill_category?.map((skill) => (
                  <h6>{skill.skill_name}</h6>
                ))} */}

                {userSkill?.selected_skill?.map(
                  (skill) =>
                    skill.rating < 1 ? (
                      <ul
                        style={{
                          padding: 0,
                          listStyle: "none",
                          marginBottom: "10px",
                        }}
                      >
                        <li>
                          {setisTopSkill(1)}
                          <span>{skill.skill_name}</span>
                          <span>
                            <Rating
                              value={skill.rating !== null ? skill.rating : "0"}
                              stars={5}
                              readOnly
                              cancel={false}
                              style={{ marginTop: "3px" }}
                            />
                          </span>
                        </li>
                      </ul>
                    ) : null

                  // <p class="text-1000 mb-0">{skill.skill_name}</p>
                )}
                {isTopSkill == 0 ? "No record found!" : null}
              </div>
              <div className="col-md-6">
                <h4>Give Rating</h4>
                {userSkill?.skill_category?.map((skill) => (
                  <h6>{skill.skill_name}</h6>
                ))}
                {userSkill?.selected_skill?.map(
                  (skill, index) => (
                    <ul
                      style={{
                        padding: 0,
                        listStyle: "none",
                        marginBottom: "10px",
                      }}
                    >
                      <li>
                        <span>{skill.skill_name}</span>
                        <span>
                          <Rating
                            value={!!cars.length && cars[index].rating}
                            stars={5}
                            cancel={false}
                            onChange={(e) => setStars(index, e.value)}
                            style={{ marginTop: "3px" }}
                          />
                        </span>
                      </li>
                    </ul>
                  )

                  // <p class="text-1000 mb-0">{skill.skill_name}</p>
                )}
                {!userSkill?.top_skills?.length ? "No record found!" : null}

                <Form onSubmit={submitHandle}>
                  <Label>Recom. Candidate</Label>
                  <Input
                    type="select"
                    className="form-control-sm"
                    value={recomStatus}
                    onChange={(e) => setRecomend(e)}
                    required
                  >
                    <option value={""}>Select</option>
                    <option value={1}>Recommended</option>
                    <option value={2}>Regret</option>
                  </Input>
                  <Label>Comment</Label>
                  <Input
                    type="textarea"
                    value={comment}
                    onChange={(e) => setComment(e.target.value)}
                    className="form-control-sm"
                    required
                  />
                  <br />
                  <Button className="btn btn-primary">Submit</Button>
                </Form>
              </div>
            </div>
          </CardBody>
        </Card>
      )}
    </>
  );
};
export default InterviewDetails;
