import React, { useEffect, useState } from "react";
import {
  Card,
  CardBody,
  CardFooter,
  Table,
  Container,
  Row,
  Col,
  Input,
  FormGroup,
  Label,
  Button,
  Alert,
} from "reactstrap";
import FalconCardHeader from "../common/FalconCardHeader";
import axios from "axios";
import config from "../../helpers/config";
import { useParams } from "react-router-dom";
import Loader from "../common/Loader";
import ScheduleMeeting from "../recruiter/ScheduleMeeting";
import InterviewDetails from "./InterviewDetails";
const Interviews = ({ title }) => {
  const [appliedCandidate, setAppliedCandidate] = useState(null);
  const [isLoading, setIsLoading] = useState(true);
  const [modal, setModal] = useState(false);
  const [appID, setappID] = useState("");
  const [intId, setIntId] = useState(0);
  const [jobID, setjobID] = useState(0);
  const [candidateId, setcandidateId] = useState(0);

  const { id } = useParams();

  const getAppliedCandidate = async () => {
    const formBody = new FormData();
    formBody.append("company_id", id);
    const res = await axios.post(
      `${config.API_URL()}jobs/get_interviews`,
      formBody
    );
    if (res?.data?.status === 200) {
      //   console.log(res?.data?.data);
      setAppliedCandidate(res?.data?.data);
      setIsLoading(false);
    }
  };

  const getInterviewDetails = (id, appID, jobId, cand_id) => {
    setIntId(id);
    setappID(appID);
    setjobID(jobId);
    setcandidateId(cand_id);
  };
  const acceptHandler = (id) => {
    setModal(true);
    setappID(id);
  };
  const assignHandler = (id) => {
    // console.log(id);
  };

  const rejectHandler = (id) => {};
  useEffect(() => {
    getAppliedCandidate();
  }, []);

  return (
    <>
      {isLoading ? (
        <Loader />
      ) : intId ? (
        <InterviewDetails
          title={"Interview Details"}
          intId={intId}
          setIntId={setIntId}
          appID={appID}
          jobID={jobID}
          candidateId={candidateId}
         

        />
      ) : (
        <Card className="mb-3">
          <FalconCardHeader title={title} />

          <CardBody className="text-justify">
            <Container>
              <style jsx>{`
                th {
                  font-size: 12px;
                }
                tr td {
                  color: black;
                }
              `}</style>
              <Row>
                {/* <ScheduleMeeting
                  appID={appID}
                  modal={modal}
                  setModal={setModal}
                  getAppliedCandidate={getAppliedCandidate}
                  setIsLoading={setIsLoading}
                /> */}
              </Row>
            </Container>
            {/*<Table bordered>
                  <thead>
                    <tr>
                      <th>Data</th>
                      <th>Job Title</th>
                      <th>Certfication</th>
                      <th>Rating</th>
                      <th>Name</th>
                      <th>Phone</th>
                      <th>Status</th>
                      <th>Name of Rec. Company</th>
                      <th>Contact Certifier</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      No Data
                    </tr>
                  </tbody>
                  <tfoot/>
                </Table>*/}
            <div className="table-responsive">
              <Table
                className="table table-striped table-sm table"
                style={{ tableLayout: "auto", width: "100%" }}
              >
                <thead>
                  <tr
                    style={{
                      fontSize: "12px",
                      textTransform: "uppercase",
                      color: "black",
                    }}
                  >
                    <th>Application ID</th>
                    <th>Job Title</th>

                    <th>Candidate Name</th>
                    <th>Interview Datetime</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  {appliedCandidate?.length > 0 ? (
                    appliedCandidate?.map((user, index) => (
                      <tr key={index}>
                        <td>{user.application_id}</td>
                        <td>{user.job_title}</td>
                        <td>{user.candidate_name}</td>
                        <td>{user.datetime}</td>
                        <td>{user.description}</td>
                        <td>Scheduled</td>
                        <td>
                          <a target="_blank" href={user.link}>
                            <Button
                              className="buttonHire hirebtn"
                              color="info"
                              size="sm"
                            >
                              start
                            </Button>
                          </a>
                          <Button
                            className="buttonHire hirebtn"
                            color="success"
                            size="sm"
                            onClick={() =>
                              getInterviewDetails(
                                user.id,
                                user.application_id,
                                user.job_id,
                                user.candidate_id
                              )
                            }
                          >
                            Details
                          </Button>
                        </td>
                      </tr>
                    ))
                  ) : (
                    <tr className="danger">
                      <td colspan="7" style={{ padding: "2px 0" }}>
                        <Alert color="danger">No Interview Found</Alert>
                      </td>
                    </tr>
                  )}
                </tbody>
                <tfoot />
              </Table>
            </div>
          </CardBody>

          <CardFooter className="bg-light p-0 border-top" />
        </Card>
      )}
    </>
  );
};
export default Interviews;
