import React,{useEffect, useState} from 'react'
import { Card, CardBody, CardFooter, Table, Alert} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import config from '../../helpers/config';
import {useParams} from 'react-router-dom';
import axios from 'axios';

const CompanyProduct = ({title}) => {
  const {id} = useParams()
  useEffect(() => {
    const formBody = new FormData()
    formBody.append('company_id', id)

    const getJobList = async () => {
      const res = await axios.post(`${config.API_URL()}company/get-jobs-list`, formBody)
      console.log(res,"joblisttt")
    }
    getJobList();
  },[])
	return(
		<Card className="mb-3">
      <FalconCardHeader title={title} />

      <CardBody className="text-justify">
        <div className="table-responsive">
            <style jsx>{`
              th {
                font-size: 12px;
                
              }
              tr td {
                color: black;
              }
              
            `}</style>
        <Table className="table table-striped table-sm table" style={{tableLayout: "auto", width: "100%"}} >
          <thead>
    				<tr style={{fontSize: "12px", textTransform: "uppercase", color: "black"}}>
              <th>Job Title</th>
              <th>Job Description</th>
              <th>Job Status</th>
            </tr>
          </thead>
          <tbody>
            <tr className="danger">
              <td  colspan="6" style={{padding: "2px 0"}}>
                <Alert color="danger">No Data Found</Alert>
              </td>
            </tr>
          </tbody>
          <tfoot/>
        </Table>
        </div>
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
		)
}
export default CompanyProduct