import React,{useState, useEffect} from 'react'
import { Card, CardBody, CardFooter, Table, Button} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import Modal from 'react-awesome-modal';
import axios from 'axios'
import ques from "../../assets/img/icons/ques.gif";
import correct from "../../assets/img/icons/correct.gif";





const JoinAsCandidate = (props) => {

	const [isModalOpen, setModalOpen] = useState(false)
	const [isJoin, setIsJoin] = useState(false)
	const [confirm, setConfirm] = useState(false)
	const [msg, setMsg] = useState(null)
	const [showMsg, setShowMsg] = useState(false)

	useEffect(() => {
		setModalOpen(props.isOpen)
	},[])

	useEffect(() => {
		axios.post(`${process.env.REACT_APP_API_URL}/company/join` + '?' + 
			'default_user=' + localStorage.getItem('default_user') + '&' +'company_value=' + props.data.map(id => id.id) + '&' + 'type=Candidate')
			.then( function (response) {
        //handle success
        // console.log(response);
        if(response.data.msg){
        setMsg(response.data.result.data)

  }
    })
			.catch(err => console.log(err))
	},[])



	const closeModal = () => {
        setModalOpen(false)

    }

    const yesJoin = () => {
    	setIsJoin(true)
        setConfirm(true)
        	setTimeout(() => {
		setConfirm(false)
		setShowMsg(true)
	}, 3000)
    	closeModal()
    }

	return(
		<>
		<Modal visible={isModalOpen } width="600" height="350" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src={ques} width="150px" style={{marginTop:'40px',marginBottom:'20px', textAlign:'center'}}/>

            <h3 style={{textAlign:'center'}}>Are you sure?</h3>
            <p style={{textAlign:'center'}}>You want to join this recruitment company as candidate?</p>
            <Button style={{marginTop:'10px', marginRight:'10px'}} color="primary" size="lg" onClick={() => yesJoin()}>Yes, Join!</Button>
            <Button style={{marginTop:'10px'}} color="danger" size="lg" onClick={() => closeModal()}>Cancel</Button>
        </div>
    </Modal>
    <Modal visible={confirm } width="600" height="350" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src={correct} width="200px" style={{marginTop:'0px', textAlign:'center'}}/>

            <h3 style={{textAlign:'center'}}>Join Request as candidate sent successfully </h3>
        </div>
    </Modal>
		<Card className="mb-3">
      <FalconCardHeader title={props.title} />

      <CardBody className="text-justify">
        {
        	showMsg == true ? <><h5>{msg}</h5></>: null
        }
        
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    </>
		)
}
export default JoinAsCandidate