import React, { useEffect, useState } from 'react'
import { Card, CardBody, CardFooter, Table, Alert, FormGroup, Button } from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import config from '../../helpers/config';
import { useParams } from 'react-router-dom';
import Modal from 'react-awesome-modal';
import axios from 'axios';
import { Rating } from 'primereact/rating';

const MyAssignedCandidate = ({ title }) => {
    const { id } = useParams()
    const dataNotFound = true;
    const [isModalOpen, setModalOpen] = useState(false)
    const [MyAssignedCandidate, SetAssignedResData] = useState([
        // {
        //     title : 'Check List',
        //     name : "d",
        //     email : "d",
        //     phone: "sd",
        //     status : "D"
        // }
    ]);


    const openModal = () => {
        setModalOpen(true)
    }
    const closeModal = () => {
        setModalOpen(false)
    }

    const reqData = new FormData();
    reqData.append('companyID', '11118');

    axios.post({
        url: `${process.env.REACT_APP_API_URL}/company/MyAssignedCandidate`,
        data: reqData,
        headers: { "Content-Type": "multipart/form-data" }
    }).then(res => {
        console.log('sucessfully worked MyAssignedCandidate API');
        if (res) {
            dataNotFound = false;
            SetAssignedResData(res.data);
        }
    }).catch(err => {
        console.log('AssignedCandidate API is not sucessfuly worked', err)
    })

    return (
        <Card className="mb-3">
            <Modal visible={isModalOpen} width="70%" height="50%" effect="fadeInUp" onClickAway={() => closeModal()}>
                <div style={{ padding: '20px' }}>
                    <h3 style={{}}>{"My Assigned Candidate"}</h3>
                    <p>No Data Available</p>
                    {/* {title == 'test' && data?.map(certification => (
                    <>
                        <Table bordered>
                        <thead>
                            <tr>
                            <td>Certification</td>
                            <td>Start Month</td>
                            <td>Start Year</td>
                            <td>End Month</td>
                            <td>End Year</td>
                            <td>Certificate License</td>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                            <td>{certification.user_certification}</td>
                            <td>{certification.user_cert_start_month}</td>
                            <td>{certification.user_cert_start_year}</td>
                            <td>{certification.user_cert_end_month}</td>
                            <td>{certification.user_cert_end_year}</td>
                            <td>{certification.user_cert_license}</td>
                            </tr>
                        </tbody>
                        <tfoot />
                        </Table>
                    </>
                    ))} */}


                </div>
            </Modal>
            <FalconCardHeader title={title} />

            <CardBody className="text-justify">
                <div className="table-responsive">
                    <style jsx>{`
              th {
                font-size: 12px;
                
              }
              tr td {
                color: black;
              }
              
            `}</style>


                    <Table className="table table-striped table-sm table" style={{ tableLayout: "auto", width: "100%" }} >
                        <thead>
                            <tr style={{ fontSize: "12px", textTransform: "uppercase", color: "black" }}>
                                <th>Date</th>
                                <th>Cand. Name</th>
                                <th>Top Skills</th>
                                <th>Certification</th>
                                <th>Company Name</th>
                                <th>Status</th>
                                <th>Certify Candidate</th>
                            </tr>
                        </thead>
                        {
                            dataNotFound &&

                            <tbody>
                                <tr>
                                    <td> 02 November, 2022 </td>
                                    <td> Chinedu </td>
                                    <td>
                                        <tr>Angular</tr>
                                        <tr>Php</tr>
                                        <tr>Laravel</tr>
                                    </td>
                                    <td>
                                        <tr>
                                            <Rating
                                                value={"0"}
                                                stars={5}
                                                readOnly
                                                cancel={false}
                                                style={{ marginTop: '3px' }}
                                            />
                                        </tr>
                                        <tr>
                                            <Rating
                                                value={"0"}
                                                stars={5}
                                                readOnly
                                                cancel={false}
                                                style={{ marginTop: '3px' }}
                                            />
                                        </tr>
                                        <tr>
                                            <Rating
                                                value={"0"}
                                                stars={5}
                                                readOnly
                                                cancel={false}
                                                style={{ marginTop: '3px' }}
                                            />
                                        </tr>
                                    </td>
                                    <td> Pradeep </td>
                                    <td>
                                        <Button className="buttonHire hirebtn" color="success" size="sm"
                                        > Accept </Button>

                                        <Button className="buttonHire hirebtn" color="danger" size="sm"
                                        > Reject </Button>
                                    </td>
                                    <td>
                                        <Button className="buttonHire hirebtn" color="info" size="sm"
                                            onClick={openModal} > Certify </Button>
                                        <Button className="buttonHire hirebtn" color="info" size="sm"
                                            onClick={openModal} > Recertify </Button>
                                        <Button className="buttonHire hirebtn" color="success" size="sm"
                                            onClick={openModal} > Edit </Button>
                                    </td>
                                </tr>
                                <tr>
                                    <td> 28 October, 2022 </td>
                                    <td> Pawan </td>
                                    <td>
                                        <tr>Angular</tr>
                                        <tr>Node</tr>
                                        <tr>My SQL</tr>
                                    </td>
                                    <td>
                                        <tr>
                                            <Rating
                                                value={"0"}
                                                stars={5}
                                                readOnly
                                                cancel={false}
                                                style={{ marginTop: '3px' }}
                                            />
                                        </tr>
                                        <tr>
                                            <Rating
                                                value={"0"}
                                                stars={5}
                                                readOnly
                                                cancel={false}
                                                style={{ marginTop: '3px' }}
                                            />
                                        </tr>
                                        <tr>
                                            <Rating
                                                value={"0"}
                                                stars={5}
                                                readOnly
                                                cancel={false}
                                                style={{ marginTop: '3px' }}
                                            />
                                        </tr>
                                    </td>
                                    <td> Pradeep </td>
                                    <td>
                                        <Button className="buttonHire hirebtn" color="success" size="sm"
                                        > Accept </Button>

                                        <Button className="buttonHire hirebtn" color="danger" size="sm"
                                        > Reject </Button>
                                    </td>
                                    <td>
                                        <Button className="buttonHire hirebtn" color="info" size="sm"
                                            onClick={openModal} > Certify </Button>
                                        <Button className="buttonHire hirebtn" color="info" size="sm"
                                            onClick={openModal} > Recertify </Button>
                                        <Button className="buttonHire hirebtn" color="success" size="sm"
                                            onClick={openModal} > Edit </Button>
                                    </td>
                                </tr>
                            </tbody>
                        }
                        {
                            !dataNotFound &&

                            <tbody>
                                {
                                    MyAssignedCandidate.length > 0 ?
                                        (MyAssignedCandidate.map((candidate, index) => (
                                            <tr key={index}>
                                                <td>{candidate.date ? candidate.date : null}</td>
                                                <td>{candidate.name ? candidate.name : null}</td>
                                                <td>{candidate.skill ? candidate.skill : null}</td>
                                                <td>{candidate.rating ? candidate.rating : "NA"}</td>
                                                <td>{candidate.certifier ? candidate.certifier : null}</td>
                                                <td>{candidate.status ? candidate.status : null}</td>
                                                <td>{candidate.current ? candidate.current : null}</td>
                                            </tr>
                                        ))) : (
                                            <tr className="danger">
                                                <td colspan="7" style={{ padding: "2px 0" }}>
                                                    <Alert color="danger">No Cerification Found</Alert>
                                                </td>
                                            </tr>
                                        )
                                }
                            </tbody>
                        }

                        <tfoot />
                    </Table>

                </div>
            </CardBody>

            <CardFooter className="bg-light p-0 border-top">

            </CardFooter>
        </Card>
    )
}
export default MyAssignedCandidate;