import React,{useEffect, useState} from 'react';
import { Card, CardBody, CardFooter, Row, Col, Container,Table,Button, Badge, Alert} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import axios from 'axios';
import config from '../../helpers/config';
import {useParams, useHistory} from 'react-router-dom';
import {Link} from 'react-router-dom';
import usePostFetch from "../../hooks/usePostFetch";
import Loader from '../common/Loader'




const MyCandidateList = (props) => {
// console.log(props,"dddddddddddddddd")
	
	const {compId, pcId} = props.location.state;
	const history = useHistory()
  	const api = `company/private_certifier/get_all_assigned_candidate?default_user=${localStorage.getItem('default_user')}&private_certifier_id=${pcId}&company_id=${compId}`
  	const { loading, data } = usePostFetch(api);
  	// console.log(data,"ccccccccccccccccccccccccccccccccc")
  	

  	const candidateList = data?.data?.result?.data?.candidates;
  	console.log(candidateList,"candidateListcandidateList")
	
	const certifyHandler = (item) => {
		console.log(item,'working')
		history.push({
			pathname:'give_certification',
			state:{
				data:item
			}
		})
	}
	return(
		<>
			<Card className="mb-3">
		      <FalconCardHeader title={"Candidate List to Certified"} />
		      <CardBody>
		      {loading ? <Loader/> : (
		      	<Table bordered>
		      	<thead>
		      		<tr className="text-center font-weight-bold my-1">
		      			<th>S. No.</th>
		      			<th>Candidate</th>
		      			<th>Email</th>
		      			<th>status</th>
		      			<th>Certify Candidate</th>
		      		</tr>
		      	</thead>
		      	<tbody>
		      	{candidateList.length > 0 ? candidateList?.map((candidate, index) => (
		      		<tr key={index} className="text-center">
		      			<td>{index+1}.</td>
		      			<td>
		      				<Link to={{
		      					pathname:`/pages/profile/${candidate.candidate_id}`
		      				}}>
		      					{candidate.candidate.user_f_name} {candidate.candidate.user_l_name}
		      				</Link>
		      			</td>
		      			<td>{candidate.candidate.user_email}</td>
		      			<td>{candidate.status == 0 ? <Badge color="primary" pill>Pending</Badge> : <Badge color="success" pill>Active</Badge>}</td>
		      			<td>
		      				{
		      				candidate.status == 1 ? <Badge pill color="success">Certified</Badge> : (
		      					<Button 
		      					color="primary" 
		      					size="sm"
		      					onClick={e => certifyHandler(candidate)}
		      				>
		      				Certify
		      				</Button>
		      					)
		      				}
		      				
		      			</td>
		      		</tr>

		      		)) : (
		      		<tr className="text-center">
		      			<td>
		      				<Alert>No Data</Alert>
		      			</td>
		      		</tr>
		      	)}
		      	</tbody>
		      	</Table>
		      	)}
		      	
		      </CardBody>
		    </Card>

		</>
		)
}
export default MyCandidateList;