import React,{useState, useEffect, useContext} from 'react'
import { Card, CardBody, CardFooter, Table,Container, Row, Col, Input,Alert, Form,Button,FormGroup,Badge, Label, ButtonDropdown,UncontrolledDropdown, DropdownToggle, DropdownMenu, DropdownItem} from "reactstrap";
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import FalconCardHeader from '../common/FalconCardHeader';
import axios from 'axios';
import config from '../../helpers/config'
import capitalize from '../../helpers/capitalize'
import {useParams} from 'react-router-dom';
import Modal from 'react-awesome-modal';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext';
import likeInactive from '../../assets/img/illustrations/like-inactive.png'
import likeActive from '../../assets/img/illustrations/like-active.png'
import commentActiveImg from '../../assets/img/illustrations/comment-inactive.png'
import commentInActiveImg from '../../assets/img/illustrations/comment-active.png'
import trash from '../../assets/img/illustrations/trash.svg'
import Avatar from '../common/Avatar'
import av3 from '../../assets/img/team/3.jpg';
import {Link} from 'react-router-dom'
import moment from 'moment';
import { toast } from 'react-toastify';
import Loader from '../common/Loader';



const Post = ({title, data, isAdmin}) => {
  const {id} = useParams()
    // console.log(data[0],"ssssssssssssss")
    // console.log(isAdmin,"ssssssssssssssisAdmin")
    // console.log(id,"IDssssssssssssssisAdmin")
    

  const [postBody, setPostBody] = useState('')
  const [isModalOpen, setIsModalOpen] = useState(false)
  const [loading, setLoading] = useState(true)
  const [posts, setPosts] = useState([])
  const [like, setLike] = useState(false)
  const [hasLike, setHasLike] = useState(null)
  const [hasLikeVal, setHasLikeVal] = useState(null)
  const [likeCount, setLikeCount] = useState(0)
  const [comment, setComment] = useState("")
  const [isComment, setIsComment] = useState(false)
  const [isPostDeleted, setIsPostDeleted] = useState(false)
  const [deleteComment, setDeleteComment] = useState(false)
  const [adminCheck, setAdminCheck] = useState(null)
  const [userBan, setUserBan] = useState("Ban User")
  const [allBanUsersList, setAllBanUsersList] = useState(null)
  const [reload, setReload] = useState(false)
  const [isMsgModalOpen, setIsMsgModalOpen] = useState(false)
  const [userMsgName, setUserMsgName] = useState(null)
  const [msgToDetail, setMsgToDetail] = useState(null)
  const [checkingForRecruiter, setCheckingForRecruiter] = useState(null)
  const [formData, setFormData] = useState({
    subject:'',
    message:''
  })
  const {subject, message} = formData;

  const avatarProfile = localStorage.getItem('name').split(" ").slice(0,1)
  // console.log(avatarProfile,"avatarProfile")

  const {companyData, userCompanyData, userData} = useContext(AllDetailsContext)
  // console.log(userCompanyData,"companyDatapostUserData")
  // console.log(userCompanyData,"userCompanyDatauserCompanyData")
  console.log(posts,"get post data")

  const checkForAdmin = async () => {
    const admin = await axios.post(`${process.env.REACT_APP_API_URL}/company/checkifusertypeofcompany?default_user=${localStorage.getItem('default_user')}&company_id=${id}&id=${userData.user.user_id}`)
    setAdminCheck(admin?.data?.result?.status)
    setCheckingForRecruiter(admin?.data?.result?.data?.role_id)
  }
  
  useEffect(() => {
    const fetchPosts = async () => {
      const response = await axios.post(`${process.env.REACT_APP_API_URL}/company/getcompanypost?default_user=${localStorage.getItem('default_user')}&company_id=${id}`)
      // console.log(response,"pos ressssssss")   
      if(response?.data?.status_code === 200 ){
        setLoading(false)
      }   
      // const sortData = response.data.result.data.post.sort((a,b) => a - b)
      // console.log(sortData,"data sorted")
        setPosts(response.data.result.data.post)
        // console.log(response.data.result.data.post,"this is get post")
        // console.log(response,"get post")  
      
    }
    fetchPosts();
    
  },[isModalOpen, like, isComment, deleteComment, isPostDeleted, reload])
  
  useEffect(() => {
    checkForAdmin()
  },[reload])
  
  useEffect(() => {
    getAllBanUsers()
  },[reload])
  // console.log(reload,"reload")
  
   const getAllBanUsers = async () => {
      const getBanUsersList = await axios.post(`${process.env.REACT_APP_API_URL}/company/user/banned?company_id=${id}`)
      if(getBanUsersList?.data?.status_code === 200){
      setAllBanUsersList(getBanUsersList?.data?.result?.data?.banned_users)
      }
  }
  

  const postHandler = e => {
    e.preventDefault();
    // console.log(postBody,"ssssssssssssss")
    const companyPost = async () => {
      const res = await axios.post(`${process.env.REACT_APP_API_URL}/company/savecompanypost?default_user=${localStorage.getItem('default_user')}&company_id=${id}&post=${postBody}`)
      // console.log(res,"this is new res")
      if(res?.data?.resultType == "S"){
        setIsModalOpen(true)
        toast.success(res?.data?.result?.data?.message)
      }
      if(res?.data?.resultType == "F"){
       toast.error(res?.data?.result?.data?.message) 
      }
    }
    companyPost();
  }
  const closeModal = () => {
    setIsModalOpen(false)
    setPostBody('')
    setIsMsgModalOpen(false)
  }
  
  // console.log(postBody,"postBody")
const comp  =   companyData?.userCompanies?.filter(company => company.user_id == localStorage.getItem('user_profile_id'))
// console.log(comp,"compcheck")


// console.log(comment,"this is for comment")
const onChangeCommentHandler = event => {
      setComment(event.target.value)
  // if(isComment){
  //   setComment('')
  // }
  // console.log(event.key,"event.code")

  }
  const onEnterKeyHandler = async (event, postId) => {
    // console.log(postId,"postId.................")
    if(event.key == "Enter"){
      event.preventDefault();
      try{
        const commentRes = await axios.post(`${process.env.REACT_APP_API_URL}/company/post/comment?default_user=${localStorage.getItem('default_user')}&company_post_id=${postId}&comment=${comment}`)
        if(commentRes?.data?.status_code === 200){
          setIsComment(!isComment)
          setComment("")
        }
      }catch(err){
        console.log(err)

      }
    }
    // console.log(comment,"event.code")
  }
  
  const likeAndUnlikeHandler = async (e, post) => {
    // console.log(post,"post for like")
    
    const likePost = await axios.post(`${process.env.REACT_APP_API_URL}/company/post/togglelike?default_user=${localStorage.getItem('default_user')}&company_post_id=${post.id}`)
    setLike(!like)
    // console.log(likePost,"likePost")
    setHasLike(likePost?.data?.result?.data?.status)
    // const matchLike = likePost?.data?.result?.data?.post.map()
    const matchLike = likePost?.data?.result?.data?.post?.likes.map(li => li.user_id == localStorage.getItem('user_id'))
    // console.log(matchLike,"matchLike")
    setHasLikeVal(matchLike)
    
  }
    

  const deletePostHandler = async (postId) => {
    try{
        const deletePost = await axios.post(`${process.env.REACT_APP_API_URL}/company/post/delete?default_user=${localStorage.getItem('default_user')}&company_post_id=${postId}`)
        // console.log(deletePost,"deletePost")       
        if(deletePost?.data?.status_code === 200){
          setIsPostDeleted(!isPostDeleted)
          toast.success("Post Deleted!")
        }
        if(deletePost?.data?.status_code === 400){
          toast.error("Permission not granted!")

        }
    }catch(err){
        console.log(err)
    }

    
  }
 
const banUserHandler = async (banUserId) => {
  // console.log(banUserId,"user banned")
  setReload(!reload)
  try{
    const banUser = await axios.post(`${process.env.REACT_APP_API_URL}/company/user/toggleban?default_user=${localStorage.getItem('default_user')}&company_id=${id}&banned_user_id=${banUserId}`)
    // console.log(banUser.data.result.data.status,"res from ban user")
    if(banUser?.data?.status_code === 200){
      toast.success(banUser.data.result.data.message)
      if(banUser.data.result.data.status == "Banned"){
        setUserBan("Unban User")
        

      }else{
        setUserBan("Ban User")
        
      }
    }
  }catch(err){
    console.log(err)
  }
} 

const deletecommentHandler = async (comment_id) => {
  
  const deleteComment = await axios.post(`${process.env.REACT_APP_API_URL}/company/post/comment/delete?default_user=${localStorage.getItem('default_user')}&comment_id=${comment_id}`)
  
    if(deleteComment?.data?.status_code === 200){
      // setDeleteComment(!deleteComment)
      setIsComment(!isComment)
      toast.success("Comment Deleted!")
    }
    if(deleteComment?.data.status_code === 400){
      toast.error("Can't delete other's comment")
    }
} 
const checkingBan = allBanUsersList?.find(ban => ban.company_id == id && localStorage.getItem('user_id') == ban.banned_profile_id )
// console.log(checkingBan,"BANnNNNN")
if(checkingBan !== undefined && checkingBan.banned_profile_id == localStorage.getItem('user_id')){
  return (<>
    <Card>
      <CardBody style={{textAlign:"center"}}>You are <span style={{fontWeight:'700', color:"red"}}>BANNED!</span></CardBody>
    </Card>
  </>)
}
// const sendMessage = async () => {
//   const formBody = new FormData();
//   const msg = await axios.post(`http://13.49.154.94/backend/api/v2/company/message/send`)
// }
const messageHandler = (userDetail) => {
  // console.log(userDetail)
  setIsMsgModalOpen(true)
  setUserMsgName(userDetail?.user?.user_f_name)
  setMsgToDetail(userDetail)
  

}
const onChangeMessage = e => {
  setFormData({
    ...formData,
    [e.target.name]: e.target.value
  })
}

const onSubmitMessage = e => {
  e.preventDefault();
  // console.log(formData)
  const formBody = new FormData();
  formBody.append('default_user',localStorage.getItem('default_user'))
  formBody.append('message',message)
  formBody.append('subject',subject)
  formBody.append('to_id',msgToDetail?.user_id)
  formBody.append('company_id',id)

  axios({
    method: "post",
    url: `${process.env.REACT_APP_API_URL}/company/message/send`,
    data: formBody,
    headers: { "Content-Type": "multipart/form-data" },
  })
  .then(res => {
    // console.log(res)
    if(res?.data?.status_code === 200){
      toast.success(res?.data?.result?.data?.message)
      closeModal()
      setFormData({
        message:'',
        subject:''
      })
    }
  })
  .catch(err => console.error(err))

}

	return(
    <>
    <Modal visible={isModalOpen} width="400" height="300" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div style={{textAlign:"center"}}>
            <img src="https://webstockreview.net/images/check-clipart-gif-animation-18.gif" width="200px" style={{marginTop:'0px', textAlign:'center'}}/>

            <h1 style={{position:'absolute', top:'125px', left:'115px'}}>Success</h1>
            <p style={{textAlign:'center', marginTop:'32px'}}>Posted successfully!</p>
            <Button style={{marginTop:'2px'}} color="primary" size="lg" onClick={() => closeModal()}>Close</Button>
        </div>
    </Modal>

    <Modal visible={isMsgModalOpen} width="400" height="300" effect="fadeInUp" onClickAway={() =>closeModal()}>
        <div>
            
              
                <FalconCardHeader title={`Send Message to ${userMsgName}`} />
                  <Form onSubmit={onSubmitMessage}>
                    <CardBody>
                      <FormGroup>
                      {/*<Label>Subject</Label>*/}
                        <Input 
                          type="text" 
                          placeholder="Write Subject" 
                          name="subject" 
                          value={subject}
                          onChange={onChangeMessage}
                        />
                      </FormGroup>
                      <FormGroup>
                        {/*<Label>Message</Label>*/}
                        <Input 
                          type="textarea" 
                          placeholder="Write Message" 
                          style={{resize:"none"}}
                          name="message" 
                          value={message}
                          onChange={onChangeMessage}
                        />
                      </FormGroup>
                    </CardBody>
                    <CardFooter className="d-flex justify-content-center">
                      <Button type="submit" color="primary" className="mx-2">Send</Button>
                      <Button onClick={closeModal}>Cancel</Button>
                    </CardFooter>
                  </Form>
            
        </div>
    </Modal>


		<Card className="mb-3">
      <FalconCardHeader title={title} />
      {adminCheck && checkingForRecruiter !== 11 && (
        <CardBody className="text-justify">
          <Form onSubmit={e => postHandler(e)}>
          <FormGroup>
            <Input
              className="border-0 rounded-0 resize-none my-3"
              placeholder="What do you want to talk about?"
              type="textarea"
              name="postBody"
              rows="4"
              spellCheck="false"
              value={postBody}
              onChange={({ target }) => {
                    setPostBody(target.value);
                  }}
            
            />
          </FormGroup>
            <Button type="submit" color="primary">Post</Button>
          </Form>

        </CardBody>
      )}

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
    {loading ? <Loader/> : (<>
    {posts?.length > 0 ? posts.map((post, index) => (
       <Card key={index} style={{margin:'20px 0px'}}>
          
          <FalconCardHeader title={
            <div className="d-flex">
            {adminCheck ? (<>
              <Avatar name={post.publisher.user_f_name} size="xl" />
              <div className="align-self-center ml-2">
                {post.publisher.user_f_name ? <>{post.publisher.user_f_name.capitalize()} {post.publisher.user_l_name.capitalize()}</> : post.publisher.user_email}
              </div>
              </>) : (
              <>
              <Avatar name={"Admin"} size="xl" />
              <div className="align-self-center ml-2">
                Admin
              </div>
              </>
              )}
              
            </div>
          }
          >
          {adminCheck && (
              <UncontrolledDropdown>
                <DropdownToggle color="Secondary" size="sm" className="p-0">
                  <FontAwesomeIcon icon="ellipsis-h" />
                </DropdownToggle>
                <DropdownMenu right>
                  <DropdownItem onClick={e => deletePostHandler(post.id)} className="text-danger">Delete</DropdownItem>
                </DropdownMenu>
              </UncontrolledDropdown>
            )}
          </FalconCardHeader>
          <CardBody>{post.post}</CardBody>
          <CardFooter className="bg-light p-0">
            <Container className="p-2 my-2">
              <div style={{margin:"0px 0px -18px 0px", padding:"5px"}}>
                <span style={{marginRight:"5px", fontSize:"15px"}}>
                  {post.likes.length == 0 ? "0" : post.likes.length} {post.likes.length > 1 ? "Likes" : "Like"} 
                </span>
                <span style={{fontSize:"15px"}}>
                  {post.comments.length > 0 ? post.comments.length : "0"} {post.comments.length > 1 ? "Comments" : "Comment"} 
                </span>
              </div>
              <br/>
              <div className="border-top border-bottom" style={{padding:"5px", fontSize:"0.83333rem"}}>
                <img 
                  onClick={e => likeAndUnlikeHandler(e, post)} 
                  src={post?.likes?.find(li => li.user_id == localStorage.getItem('user_id')) ? likeActive : likeInactive} 
                  width="20px" 
                  className="mx-2"/>
                <span> <strong>Like</strong></span>
                <img 
                  src={post?.comments?.find(checkUserId => checkUserId.user_id == localStorage.getItem('user_id')) ?   commentInActiveImg : commentActiveImg  } 
                  width="20px" 
                  className="mx-2"
                />
                <span><strong>Comment</strong></span>
              </div>
              <br />
              <Row style={{marginTop:'0px', padding:"0px 15px"}}>
                <Col md="2" style={{ maxWidth: "7%"}}>

                <Avatar name={avatarProfile[0]} size="xl" />
                </Col>
                <Col>
                  <Input 
                    placeholder="Write a comment..." 
                    style={{borderRadius:'20px'}} 
                    onChange={e => onChangeCommentHandler(e)}
                    onKeyDown={e => onEnterKeyHandler(e,post.id)}
                    value={comment}
                    
                  />

                </
                Col>

              </Row>
            
            {/*==============  THIS IS COMMENT SECTION   ==========================*/}

              {post.comments.length > 0 && (
                  <>
                    {post.comments.map((comment,index) => (
                      <Container key={index} style={{fontSize:"14px", opacity:`${allBanUsersList?.find(ban => ban.banned_profile_id == comment.user_id) ? 1 : 1}`}}>
                        <Row style={{alignItems:'center', marginTop:"10px", width:"110%"}}>

                          <Col className="col-md-2 col-sm-2 col-xs-2" style={{ maxWidth: "7%", marginRight:"15px"}}>
                            <Avatar name={comment.user.user_f_name} size="xl" />
                          </Col>
                          <Col 
                            className="col-md-10 col-sm-10 col-xs-10"
                            style={{
                              backgroundColor:"#edf2f9", 
                              padding: "10px",
                              borderRadius: "8px",
                              display: "flex",
                              flexDirection: "row",
                              justifyContent: "space-between",
                              alignItems:"center"
                              
                            }}>
                            <div className="d-flex flex-wrap text-justify">
                              <div>
                                <Link to={`/pages/profile/${comment.user_id}`} style={{marginRight:"5px",fontWeight: 600, textDecoration:"none"}}>{comment.user.user_f_name ? <>{comment.user.user_f_name.capitalize()} {comment.user.user_l_name.capitalize()}</> : comment.user.user_email}</Link>
                              </div>
                              <div style={{wordBreak:"break-all", padding:"0px 5px"}} >
                                {comment.comment}
                              </div>
                            </div>
                            <div>
                            
                              <UncontrolledDropdown>
                                <DropdownToggle color="Secondary" size="sm" className="p-0">
                                  <FontAwesomeIcon icon="ellipsis-h" />
                                </DropdownToggle>
                                <DropdownMenu right>
                  
                                  <Link 
                                    to={`/pages/profile/${comment.user_id}`}
                                    style={{textDecoration:"none"}}
                                  >
                                    <DropdownItem>View Profile</DropdownItem>
                                  </Link>
                                  
                                {adminCheck ? <>
                                    {comment.user_id == localStorage.getItem('user_id') ? null : (<>
                                    <DropdownItem onClick={e => banUserHandler(comment.user_id)}>{allBanUsersList?.find(ban => ban.banned_profile_id == comment.user_id) ? "Unban User" : "Ban User"}</DropdownItem>
                                  </>)}
                                  </> : null}
                                  
                                  { comment.user_id == localStorage.getItem('user_id') ? null : checkingForRecruiter === 11 && <DropdownItem onClick={e => messageHandler(comment)}>Send Message</DropdownItem>}
                                  
                                  {adminCheck  || comment.user_id == localStorage.getItem('user_id') ? (<>
                                    <DropdownItem onClick={e => deletecommentHandler(comment.id)} className="text-danger">Delete</DropdownItem>

                                  </>): null}

                                </DropdownMenu>
                              </UncontrolledDropdown>
                            </div>

                          </Col>
                        </Row>
                        <Row style={{marginTop:"0px"}}>
                            <Col md="1"></Col>
                            <Col md="11">
                            <span style={{fontSize:"13px"}}>Like • Reply • {moment.utc(comment.created_at).local().startOf('minute').fromNow()}</span>
                            </Col>
                          </Row>
                      </Container>
                      ))}
                      </>
                )}
            </Container>
          </CardFooter>
        </Card>

      )):(
  <Row>
    <Col>
      <Alert>No post available</Alert>
    </Col>
  </Row>
)}
    </>)}
    </>
		)
}

export default Post

