import React,{useEffect, useState} from 'react'
import { Card, CardBody,Badge, CardFooter,Button, Table,Container, Row, Col, Input, FormGroup, Label} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import { useParams } from 'react-router-dom';
import axios from 'axios';
import spinner from '../../assets/img/media/spinner.gif'
import './Recruiter.css';
import PrivateCertifierDetails from './PrivateCertifierDetails';
import config from '../../helpers/config';


const PrivateCertifier = ({title, data}) => {
  // console.log(data,"DATA IS HERE")
  const [pcDetails, setPcDetails] = useState(null)
  const [totalPage, setTotalPage] = useState(0);
  const [pages, setPage] = useState(1)
   const [loading, setLoading] = useState(false);


  let limit = 10;
  let offset = pages.length == 0 ? pages + 0 : pages - 1;
  
  useEffect(() => {
    getPC()
  },[pages])

  let pageArray = []
  
  for( let i = 0 ; i < totalPage ; i++){
    pageArray.push(i + 1)
    // setPage(pageArray)
  }
  
  const getPC = async () => {
    setLoading(true)
    const pc = await axios.get(`${config.API_URL()}privatecertifier?limit=${limit}&offset=${offset}`)
    if(pc?.data?.status_code === 200){
      setLoading(false)
      setPcDetails(pc?.data?.result?.data)
      setTotalPage(Math.ceil(pc?.data?.result?.total/limit))
    }
  }
  const buttonHandler = index => {
  setPage(index+1)
}
  // console.log(pcDetails,"pcDetails")
	return(
    <Card className="mb-3">
          <CardBody className="fs--1">
        <FalconCardHeader title="Private Certifier Listing Page" titleTag="h5" />
          
            {pageArray.map((item, index) => (
                <span
                  className={
                    ("page-but mn-tp20",
                    pages == index + 1 ? "btn-select" : "btn-unselect")
                  }
                  onClick={() => buttonHandler(index)}
                >
                  {item}
                </span>
            ))}
            <PrivateCertifierDetails pc={pcDetails} loading={loading} data={data}/>
            {/*{pcDetails !== null && pcDetails?.map((pc,index) => <PrivateCertifierDetails pc={pc} key={index}/>) }*/}    
          </CardBody>
      </Card>
                                                                                                                                                                                            
		// <Card className="mb-3">
  //     <FalconCardHeader title={title} />

  //     <CardBody>
  //       <Container>
  //     {pcDetails !== null && pcDetails?.map((pc,index) => <PrivateCertifierDetails pc={pc} key={index}/>) }
  //       </Container>
  //     </CardBody>

  //     <CardFooter className="bg-light p-0 border-top">
        
  //     </CardFooter>
  //   </Card>
		)
}
export default PrivateCertifier                                                                                                                                                                                                                                                                  