import React,{useState, useEffect} from 'react';
import { Card, CardBody,Badge, CardFooter,Button,Alert, Table,Container, Row, Col, Input, FormGroup, Label} from "reactstrap";
import {Link, useParams} from 'react-router-dom';
import company from "../../assets/img/myicons/work.svg";
import Pagination from '../common/Pagination.js'
import Loader from "../common/Loader";
import { isIterableArray } from "../../helpers/utils";
import axios from 'axios';
import { toast } from 'react-toastify';
import config from '../../helpers/config';



const PrivateCertifierDetails = ({pc, loading, data}) => {
  console.log(data,"NEW CHCK DATA")
  
  const [isHired, setIsHired] = useState(false)
  const {id} = useParams();
  
  useEffect(() => {
    axios.post(`${process.env.REACT_APP_API_URL}/company/private_certifer/who_send_the_invitation?default_user=${localStorage.getItem('default_user')}&private_certifier_id=${id}`)
    .then(res => console.log(res,"checkkkkkkkkkkkkkkkkkkkk"))
  },[])

  const hirePcHandler = async (item) => {
  // console.log(item)
  const formBody = new FormData();
  
  formBody.append('default_user', localStorage.getItem('default_user'))
  formBody.append('private_certifier_id', item.id)
  formBody.append('company_id', id)
  
  
  axios({
    method: "post",
    url: `${process.env.REACT_APP_API_URL}/company/hire_private_certifier`,
    data: formBody,
    headers: { "Content-Type": "multipart/form-data" },
  })
  .then(res => {
    // console.log(res)
    setIsHired(true)
    if(res?.data?.type == "success"){
      toast.success(res?.data?.msg)
    }
    if(res?.data?.type == "error"){
      toast.error(res?.data?.msg)
    }

  })
  .catch(err => {
    // console.log(err.message,"errorrrrrrrrrrr")
    toast.error("Something went wrong!")
  })
  

  }
	// console.log(pc)
	return(
    <>
      {loading 
        ? 
        <Loader/>
        :
        isIterableArray(pc) ?
        ( pc.map((item, index) => (
          <div key={item.index}>
              <div className="media mn-tp30 pd-bt30 border-bottom-list" >
                <div className="media-left">
                  {/*<Link to={{
                                      pathname:`/page/privatecertifierdetails/${item.id}`
                                    }}>*/}
                    <embed
                      height="70"
                      width="70"
                      src={item.profile_pic == "" ||
                        item.profile_pic == null ? company : item.profile_pic
                    }
                      className="media-object official-logo"
                    ></embed>
                  {/*</Link>*/}
                </div>
                <div className="media-body pd-lt20">
                  <h5 className="media-heading field" style={{fontSize: "1rem", textTransform: "capitalize"}}>
                    {/*<Link 
                                          className="reverse"   
                                          to={{
                                            pathname:`/page/privatecertifierdetails/${item.id}`,
                                            state:{
                                              data: item
                                            }
                                          }}>*/}
                      {item.certifier_name ? item.certifier_name : "No Name"}
                    {/*</Link>*/}
                    
                  </h5>
                  <div className="font13">{item.email}</div>
                  <div className="space20" />

                  <div className="required-skills">
                    <div className="txt_666 font13">
                      Company Info: {item.company_info}
                    </div>
                  </div>
                  <div className="space15" />
                  <div className="job-counts font13">
                    Year of Establish: {item.year_of_establish} | Pincode: {item.pincode}
                  </div>
                  <div className="job-counts font13">
                    Location: {item.address}
                  </div>
                </div>
                <div>
                {data[0]?.recruitement_company == "1" ? (
                     <Button color="primary" onClick={e => hirePcHandler(item)}>
                      Hire
                     </Button>
                     ): null}
                  
                </div>
              </div>
</div>

            )
        )
          
        ) : (
        <Row className="p-card">
          <Col>
            <Alert color="info" className="mb-0">
              Not found
            </Alert>
          </Col>
        </Row>
        ) 
      }
    </>
		)
}
export default PrivateCertifierDetails;