import React, { useState } from 'react';
import { Button, Card, CardBody, CardFooter, Collapse, Row, Col } from 'reactstrap';
import FalconCardHeader from '../common/FalconCardHeader';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
// {data ? data : "No Data"}

const ProfileIntro = ({ title, data }) => {
  const [collapsed, setCollapsed] = useState(false);
  console.log(data,"about data")
  return (
    <Card className="mb-3">
      <FalconCardHeader title={title} />
      <CardBody className="text-justify" >
        <Row>
            <Col md="3">Company Name :</Col>
            <Col>{data[0].company_name ? data[0].company_name : "NA"}</Col>
        </Row>
      <Collapse isOpen={collapsed}>
        <Row>
            <Col md="3">Business Type :</Col>
            <Col>{data[0].business_type ? data[0].business_type : "NA"}</Col>
        </Row>
        <Row>
            <Col md="3">Email :</Col>
            <Col>{data[0].company_email ? data[0].company_email : "NA"}</Col>
        </Row>
        <Row>
            <Col md="3">Location :</Col>
            <Col>{data[0].company_location ? data[0].company_location : "NA"}</Col>
        </Row>
        <Row>
            <Col md="3">City :</Col>
            <Col>{data[0].company_city ? data[0].company_city : "NA"}</Col>
        </Row>
        <Row>
            <Col md="3">State :</Col>
            <Col>{data[0].company_state ? data[0].company_state : "NA"}</Col>
        </Row>
        <Row>
            <Col md="3">Country :</Col>
            <Col>{data[0].company_country ? data[0].company_country : "NA"}</Col>
        </Row>
</Collapse>
      </CardBody>
      <CardFooter className="bg-light p-0 border-top">
        <Button color="link" block to="/pages/events" onClick={() => setCollapsed(!collapsed)}>
          Show {collapsed ? 'less' : 'more'}
          <FontAwesomeIcon icon="chevron-up" className="ml-1 fs--2" transform={collapsed ? '' : 'rotate-180'} />
        </Button>
      </CardFooter>
    </Card>
  );
};

export default ProfileIntro;
