import React, { useState, useContext, useEffect } from "react";
import DatePicker from "react-datepicker";
import axios from "axios";
import PropTypes from "prop-types";
import { toast } from "react-toastify";

import "react-datepicker/dist/react-datepicker.css";

import {
  Button,
  Col,
  Media,
  Modal,
  ModalBody,
  ModalFooter,
  ModalHeader,
  Row,
  Input,
  Form,
} from "reactstrap";
import { Link } from "react-router-dom";

import { Rating } from "primereact/rating";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";

const RatingModal = ({
  modal,
  setModal,
  type = "ADD",
  appID,
  getAppliedCandidate,
  setIsLoading,
  userSkill,
  setCars,
  cars,
  userId,
  applicationId,
}) => {
  const [HireStatus, setHireStatus] = useState(true);

  const handleSubmit = (e) => {
    e.preventDefault();
    const curr_url = window.location.href;
    const company_id = curr_url.split("/").pop();

    const formBody = new FormData();
    formBody.append("hire_status", HireStatus);
    formBody.append("rating_string", JSON.stringify(cars));
    formBody.append("candidate_id", userId);
    formBody.append("applicationId", applicationId);
    formBody.append("company_id", company_id);

    axios({
      method: "post",
      url: `${process.env.REACT_APP_API_URL}/company/submit_rating`,
      data: formBody,
      headers: { "Content-Type": "multipart/form-data" },
    })
      .then((res) => {
        console.log(res);
        toast.success("Rejected!");
        setModal(false);
        getAppliedCandidate();
      })
      .catch((err) => console.log(err));
  };
  const setStars = (index, val) => {
    const newItems = [...cars];
    newItems[index].rating = val;
    setCars(newItems);
    console.log(cars);
  };
  useEffect(() => {}, []);

  return (
    <Modal isOpen={modal} toggle={() => setModal(!modal)} size="lg">
      <ModalHeader toggle={() => setModal(!modal)} className="border-200">
        <Media className="align-items-center">
          <Media body className="ml-2">
            Give a rating
          </Media>
        </Media>
      </ModalHeader>
      <ModalBody className="mb-1">
        <Form onSubmit={handleSubmit}>
          <label>Candidate Status</label>
          <Input
            type="select"
            onChange={({ target }) => setHireStatus(target.value)}
            required
          >
            <option value="">Select</option>
            <option value="Finalized">Hired</option>
            <option value="Rejected">Rejected</option>
          </Input>
          <label>Give rating to skills</label>
          {userSkill?.selected_skill?.map((skill, index) => (
            <div value={skill.id} key={index}>
              {/* {JSON.stringify(cars[index])} */}
              {skill.skill_name}
              <br />
              <Rating
                value={!!cars.length && cars[index].rating}
                stars={5}
                cancel={false}
                onChange={(e) => setStars(index, e.value)}
                required
              />
            </div>
          ))}
          <Input type="submit" value="Submit">
            Submit
          </Input>
        </Form>
      </ModalBody>

      <ModalFooter className="border-200">
        <Button
          color="secondary"
          size="sm"
          to="/e-commerce/checkout"
          onClick={() => setModal(!modal)}
        >
          Close
        </Button>
      </ModalFooter>
    </Modal>
  );
};

export default RatingModal;
