import React, { useEffect, useState } from "react";
import { Card, CardBody, CardFooter, Table, Container, Row, Col, Input, FormGroup, 
        Label, Button, Alert, Collapse, Form, } from "reactstrap";
import { Rating } from "primereact/rating";
import { toast } from "react-toastify";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import FalconCardHeader from "../common/FalconCardHeader";
import axios from "axios";
import config from "../../helpers/config";
import { useParams } from "react-router-dom";
import Loader from "../common/Loader";
import ScheduleMeeting from "../recruiter/ScheduleMeeting";
const Recommend_Regret = ({ title, intId, setIntId, candidateId, jobID, appID, }) => {
    const [isLoading, setIsLoading] = useState(true);
    const [Recommend_RegretData, setRecommend_RegretData] = useState(false);
    const [userSkill, setUserSkill] = useState(null);
    const [cars, setCars] = useState([]);
    const [comment, setComment] = useState("");
    const [recom, setRecom] = useState(0);
    const [recomStatus, setRecomStatus] = useState("");
    const [isTopSkill, setisTopSkill] = useState(0);

    //  console.log(id);
    const getInterviewDetails = async () => {
        setIsLoading(true);
        const formBody = new FormData();
        formBody.append("int_id", intId);
        formBody.append("candidateId", candidateId);
        formBody.append("jobID", jobID);
        formBody.append("appID", appID);

        const res = await axios.post(
            `${process.env.REACT_APP_API_URL}/jobs/get_interview_details`,
            formBody
        );

        if (res?.data?.status === 200) {
            // console.log(res?.data?.data);
            setRecommend_RegretData(res?.data?.data);
            // setIsLoading(false);
            setRecom(res?.data?.data?.recom_data?.recommend_regret);
            setRecomStatus(res?.data?.data?.recom_data?.recommend_regret);
            setComment(res?.data?.data?.recom_data?.message);
        }
        const ff = new FormData();
        ff.append("user_id", candidateId);
        axios({
            method: "post",
            url: `${process.env.REACT_APP_API_URL}/get_selected_skills`,
            // url:'http://13.49.154.94/backend/api/v2/get_selected_skills',

            data: ff,

            headers: { "Content-Type": "multipart/form-data" },
        })
            .then((res) => {
                setIsLoading(false);
                setUserSkill(res?.data?.result?.data);
                res.data.result.data.selected_skill.map((skill, index) =>
                    setSkillFn(skill, index)
                );
                setCars(array);
                // setUserSkill(res?.data?.result?.data)
            })
            .catch((err) => console.log(err));
    };
    let array = [];
    const setSkillFn = (skill, index) => {
        console.log(skill.id);
        array[index] = {
            id: skill.id,
            rating: skill.rating,
        };
    };

    const setRecomend = (e) => {
        setRecom(e.target.value);
        setRecomStatus(e.target.value);
    };
    const submitHandle = (e) => {
        e.preventDefault();
        e.preventDefault();
        const curr_url = window.location.href;
        const company_id = curr_url.split("/").pop();

        const formBody = new FormData();
        formBody.append("hire_status", "HireStatus");
        formBody.append("rating_string", JSON.stringify(cars));
        formBody.append("candidate_id", candidateId);
        formBody.append("applicationId", appID);
        formBody.append("jobID", jobID);
        formBody.append("comment", comment);
        formBody.append("recom", recom);

        axios({
            method: "post",
            url: `${process.env.REACT_APP_API_URL}/company/submit_feedback_rating`,
            data: formBody,
            headers: { "Content-Type": "multipart/form-data" },
        })
            .then((res) => {
                // console.log(res);
                toast.success("Submitted successfully!");
                getInterviewDetails();
            })
            .catch((err) => console.log(err));
    };

    function removeduplicatesEntryLevel(arr) {
        const uniqueIds = [];
        if (Array.isArray(arr)) {
            // console.log('1',Array.isArray(arr))
            const unique = arr.filter(element => {
                const isDuplicate = uniqueIds.includes(element.id);

                if (!isDuplicate) {
                    uniqueIds.push(element.id);
                    return true;
                }
                return false;
            });
            return unique;
        }

    }

    function removeduplicatesTopLevel(arr) {
        const uniqueNames = [];
        if (Array.isArray(arr)) {
            const unique = arr.filter(element => {
                const isDuplicate = uniqueNames.includes(element.skill_name);
                // const isDuplicate = uniqueNames.includes(element.skill_name, element.rating);

                if (!isDuplicate) {
                    // uniqueNames = uniqueNames.map(item => {
                    //   debugger;
                    //   if(element.skill_name == item.skill_name){
                    //     if(element.rating<item.rating){
                    //       uniqueNames[item].rating = item.rating;
                    //     }
                    //     else{
                    //       uniqueNames[item].rating = element.rating
                    //     }
                    //   }
                    // })
                    uniqueNames.push(element.skill_name, element.rating);
                    return true;
                }
                return false;
            });
            return unique;
        }

    }

    const setStars = (index, val) => {
        const newItems = [...cars];
        newItems[index].rating = val;
        setCars(newItems);
        // console.log(cars);
    };
    useEffect(() => {
        // console.log(intId);
        getInterviewDetails();
    }, []);
    const backHandle = (id) => {
        setIntId(0);
    };
    return (
        <>
            {isLoading ? (
                <Loader />
            ) : (
                <Card className="mb-3">
                    <FalconCardHeader title={title} />

                    <CardBody className="text-justify">
                        <div className="row">
                            <div className="col-md-4">
                                <h4>Candidate Details</h4>
                                <Row>
                                    <Col md="5">Name :</Col>
                                    <Col>
                                        {Recommend_RegretData.candidate?.user_f_name == undefined ? "Test" : "Test"+
                                            " " +
                                            Recommend_RegretData.candidate?.user_l_name}
                                    </Col>
                                </Row>

                                <Row>
                                    <Col md="5">Email :</Col>
                                    <Col>{Recommend_RegretData.candidate?.user_email ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="5">DOB :</Col>
                                    <Col>{Recommend_RegretData.candidate?.user_dob ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="5">Gender :</Col>
                                    <Col>
                                        {Recommend_RegretData.candidate?.user_gender ? "Test" : "Test"}
                                    </Col>
                                </Row>
                                <Row>
                                    <Col md="5">Marritial Status :</Col>
                                    <Col>{Recommend_RegretData.candidate?.user_maritial_status ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="5">City :</Col>
                                    <Col >{Recommend_RegretData.candidate?.user_city ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="5">Address :</Col>
                                    <Col>{Recommend_RegretData.candidate?.user_address ? "Test" : "Test"}</Col>
                                </Row>
                            </div>
                            <div className="col-md-4">
                                <h4>Job Information</h4>
                                <Row>
                                    <Col md="6">Job Title :</Col>
                                    <Col>{Recommend_RegretData.job?.job_title ? "Test" : "Test"}</Col>
                                </Row>

                                <Row>
                                    <Col md="6">Company Name :</Col>
                                    <Col>{Recommend_RegretData.job?.company_name ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="6">Experience Level :</Col>
                                    <Col>{Recommend_RegretData.job?.experience_level ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="6">Type :</Col>
                                    <Col>{Recommend_RegretData.job?.employment_type ? "Test" : "Test"}</Col>
                                </Row>
                                <Row>
                                    <Col md="6">Location :</Col>
                                    <Col>{Recommend_RegretData.job?.job_location ? "Test" : "Test"}</Col>
                                </Row>
                                {/* <Row>
                                <Col md="3">Job Description :</Col>
                                <Col>{Recommend_RegretData.job?.job_desc}</Col>

                                </Row> */}
                            </div>
                            <div className="col-md-4">
                                <Form onSubmit={submitHandle}>
                                    <h5>Candidate Status</h5>
                                    {/* <Label>Candidate Rating</Label> */}
                                    <Input
                                        type="select"
                                        className="form-control-sm"
                                        value={recomStatus}
                                        onChange={(e) => setRecomend(e)}
                                        required
                                    >
                                        <option value={""}>Select</option>
                                        <option value={1}>Recommended</option>
                                        <option value={2}>Regret</option>
                                    </Input>
                                    <Label>Comment</Label>
                                    <Input
                                        type="textarea"
                                        value={comment}
                                        onChange={(e) => setComment(e.target.value)}
                                        className="form-control-sm"
                                        required
                                    />
                                    <br />
                                    <Button className="btn btn-primary">Submit</Button>
                                </Form>
                            </div>
                        </div>
                        <br />
                        <div className="row">
                            <div className="col-md-4">
                                <h4>Top Skills</h4>

                                {removeduplicatesTopLevel(Recommend_RegretData?.top_skills)?.map((skill, index) => (
                                    <div value="333" key={index}>
                                        {skill.skill_name}
                                        {/* {setisTopSkill(1)} */}
                                        <br />
                                        <Rating
                                            value={skill.rating}
                                            stars={5}
                                            cancel={false}
                                            required
                                        />
                                    </div>
                                ))}

                                {!Recommend_RegretData?.top_skills?.length ? "No record found!" : null}
                                <br /><br />

                                <h4>Entry Level Skills</h4>
                                {/* {userSkill?.skill_category?.map((skill) => (
                                <h6>{skill.skill_name}</h6>
                                ))} */}

                                {removeduplicatesEntryLevel(userSkill)?.selected_skill?.map(
                                    (skill) =>
                                        skill.rating < 1 ? (
                                            <ul
                                                style={{
                                                    padding: 0,
                                                    listStyle: "none",
                                                    marginBottom: "10px",
                                                }}
                                            >
                                                <li>
                                                    {setisTopSkill(1)}
                                                    <span>{skill.skill_name}</span>
                                                    <span>
                                                        <Rating
                                                            value={skill.rating !== null ? skill.rating : "0"}
                                                            stars={5}
                                                            readOnly
                                                            cancel={false}
                                                            style={{ marginTop: "3px" }}
                                                        />
                                                    </span>
                                                </li>
                                            </ul>
                                        ) : null

                                    // <p class="text-1000 mb-0">{skill.skill_name}</p>
                                )}
                                {isTopSkill == 0 ? "No record found!" : null}
                            </div>
                            <div className="col-md-4">
                                <h4>Give Rating</h4>
                                {userSkill?.skill_category?.map((skill) => (
                                    <h6>{skill.skill_name}</h6>
                                ))}
                                {removeduplicatesEntryLevel(userSkill?.selected_skill)?.map(
                                    (skill, index) => (
                                        <ul
                                            style={{
                                                padding: 0,
                                                listStyle: "none",
                                                marginBottom: "10px",
                                            }}
                                        >
                                            <li>
                                                <span>{skill.skill_name}</span>
                                                <span>
                                                    <Rating
                                                        value={!!cars.length && cars[index].rating}
                                                        stars={5}
                                                        cancel={false}
                                                        onChange={(e) => setStars(index, e.value)}
                                                        style={{ marginTop: "3px" }}
                                                    />
                                                </span>
                                            </li>
                                        </ul>
                                    )

                                    // <p class="text-1000 mb-0">{skill.skill_name}</p>
                                )}
                                {!userSkill?.top_skills?.length ? "No record found!" : null}
                                <br/><br />
                                <Form onSubmit={submitHandle}>
                                    <h5>Candidate Status</h5>
                                    {/* <Label>Candidate Status</Label> */}
                                    <Input
                                        type="select"
                                        className="form-control-sm"
                                        value={recomStatus}
                                        onChange={(e) => setRecomend(e)}
                                        required
                                    >
                                        <option value={""}>Select</option>
                                        <option value={1}>Hired</option>
                                        <option value={2}>Not Hired</option>
                                    </Input>
                                    
                                </Form>
                            </div>
                        </div>
                    </CardBody>
                </Card>
            )}
        </>
    );
};
export default Recommend_Regret;
