import React, { useState, useEffect, useContext } from "react";
import ContentWithAsideLayout from "../../layouts/ContentWithAsideLayout";
import { Link } from "react-router-dom";
import RecruiterBanner from "./RecruiterBanner";
import ProfileAside from "./ProfileAside";
import ProfileContent from "./AboutUs";
import ProfileFooter from "./ProfileFooter";
import ContentWithLeftSideLayout from "../../layouts/ContentWithLeftSideLayout";
import RecruiterLefttPanel from "./RecruiterLeftPanel";
import RecruiterContent from "./RecruiterContent";
import Dropdown from "react-dropdown";
import useGetFetch from "../../hooks/useGetFetch";

import CompanyRecruiterListing from "../appcomponents/CompanyRecruiterListing";
import { useParams } from "react-router-dom/cjs/react-router-dom.min";
import { useHistory } from "react-router-dom";
import { AllDetailsContext } from "../AllDetailsContext/AllDetailsContext";
import setting_image from '../../assets/img/icons/setting_img.png';
import axios from 'axios';
import config from '../../helpers/config'


const options = ["Manage", "Dummy", "Setting"];
const defaultOption = options[0];

const Topnav = ({ selectedButton, setselectedButton, id, isAdmin, CompId, newProps, privateCert }) => {
  const { userData, companyData } = useContext(AllDetailsContext);
  const history = useHistory();
  const [isId, setIsId] = useState(false);
  const [comID, setComID] = useState(false);
  // console.log(isAdmin,"isAdminisAdmin")
  const comp_User_id = newProps?.location?.state?.data?.user_id;
  console.log(comp_User_id,"comp_User_id")

  const onClickHandler = () => {
    setIsId(true);
    history.push(`/page/recruiter/userroles/${id}`);
  };

  const promiseId = new Promise((resolve, reject) => {
    if(CompId?.length === 0){
      reject('no value')
    }else{
      resolve(CompId)
    }
  })
  promiseId.then(res => setComID(res)).catch(err => console.log(err,"dataaaaComperr"))

  return (
    <div className="rmbr">
      <div className="topbar">
        <div className="btns-cont">
          <span
            className={
              ("large", selectedButton == 0 ? "btn-select" : "btn-unselect")
            }
            onClick={() => setselectedButton(0)}
          >
            Admin View
          </span>
          <span
            className={selectedButton == 1 ? "btn-select" : "btn-unselect"}
            onClick={() => setselectedButton(1)}
          >
            Editor
          </span>
          <span
            className={selectedButton == 2 ? "btn-select" : "btn-unselect"}
            onClick={() => setselectedButton(2)}
          >
            Recruiter
          </span>
          <span
            className={selectedButton == 3 ? "btn-select" : "btn-unselect"}
            onClick={() => setselectedButton(3)}
          >
            Advertiser{" "}
          </span>
          <span
            className={selectedButton == 4 ? "btn-select" : "btn-unselect"}
            onClick={() => setselectedButton(4)}
          >
            Private Certifier
          </span>
          {/* <Link to={`/pages/userroles/${id}`}> */}

          {!isId && isAdmin || (comp_User_id == localStorage.getItem('user_id')) ? (
            <img
              src={setting_image}
              width="30px"
              alt="setting"
              style={{ marginLeft: "20px", cursor: "pointer" }}
              onClick={onClickHandler}
              className="setting__button"
            />

          ): null}
          {/* </Link> */}
          <div className="dropme">
            <Dropdown options={options} value={defaultOption} />
          </div>
        </div>
      </div>
      <RecruiterBanner id={id} privateCert={privateCert}/>
    </div>
  );
};

const Recruiter = (props) => {
  console.log(props,"fkdjfnkdfnksd")
  
  const { id } = useParams();
  
  // this companyId is temp need for find solution for comp id. 
  let changeToInt = props?.location?.pathname?.match(/(\d+)/)[0];
  let companyId = parseInt(changeToInt)
  // console.log(companyId,"a.toString().slice(-5)")
  const [selectedButton, setselectedButton] = useState(0);
  const[isAdmin, setIsAdmin] = useState(false)
  const[ownCompID, setOwnCompID] = useState('')

  const { userData, userCompanyData } = useContext(AllDetailsContext);
  const userID = userData?.user?.user_id;



  useEffect(() => {
    // console.log(selectedButton);
    axios.post(`${config.API_URL()}company/checkifusertypeofcompany?default_user=${localStorage.getItem('default_user')}&company_id=${id}&id=${userID}`)
      .then(res => {
        // console.log(res,'this is new res www')
        setIsAdmin(res?.data?.result?.status)})
      .catch(err => console.log(err))
  },[]);

  useEffect(() => {
    // const isOwnComp = userCompanyData?.filter(own => localStorage.getItem('user_id') == own.user_id)
    const newcomp = userCompanyData?.filter(own => localStorage.getItem('user_id') == own.user_id)
    .map(own => own.id)
    // console.log(newcomp,"newcomp")
    // const idObj = Object.assign({}, newcomp)
    // console.log(idObj,"idObj")

const newww = {...newcomp}
// console.log(newww[0],"newwwnewww")
    setOwnCompID(newww[0])
  },[])
    // console.log(ownCompID,"newcomp1")


  return (
    <ContentWithLeftSideLayout
      banner={
        <Topnav
          selectedButton={selectedButton}
          setselectedButton={setselectedButton}
          id={id}
          isAdmin={isAdmin}
          CompId={ownCompID}
          newProps={props}
          privateCert={props.location.state}
        />
      }
      leftSide={<RecruiterLefttPanel/>}
      isStickyAside={false}
    >
      <RecruiterContent isAdmin={isAdmin} id={id} data={props.location.state} privateCert={props}/>
    </ContentWithLeftSideLayout>
  );
};

export default Recruiter;
