import React, { Fragment, useState, useEffect, useContext } from "react";
import { Card, CardBody, Row, Col } from "reactstrap";
import FalconCardHeader from "../common/FalconCardHeader";
import EditableContent from "../profile/EditableContent";
import ProfileIntro from "./ProfileIntro";
import RecruiterListTemp from "./RecruiterListTemp";
import AboutUs from "./AboutUs";
import Feed from "./Feed";
import CompanyProfile from "./CompanyProfile";
import People from "../page/People";
import UserRole from "./item/UserRole";
import CandidateFeedback from './CandidateFeedback';
import Discussion from './Discussion';
import Contact from './Contact';
import ProfileSummary from './ProfileSummary';
import CompanyProduct from './CompanyProduct';
import JobList from './JobList';
import AppliedCandidate from './AppliedCandidate';
import HiredCandidate from './HiredCandidate'
import Post from './Post'
import Editor from './Editor'
import PrivateCertifier from './PrivateCertifier'
import CandidateList from './CandidateList'
import CertifiedCandidate from './CertifiedCandidate'
import Join from './Join'
import JoinAsCandidate from './JoinAsCandidate'
import PrivateCertifierDetailsPage from './PrivateCertifierDetailsPage'
import CertifierAddress from './privateCertifier/CertifierAddress'
import CertifierName from './privateCertifier/CertifierName'
import CompanyInfo from './privateCertifier/CompanyInfo'
import AssignedCandidate from './privateCertifier/AssignedCandidate'
import RecCompany from './privateCertifier/RecCompany';
import EditCompanyEditorRole from './EditCompanyEditorRole';
import {AllDetailsContext} from '../AllDetailsContext/AllDetailsContext'
import config from '../../helpers/config';
import axios from 'axios';
import HireRequest from './privateCertifier/HireRequest';
import {toast} from 'react-toastify';
import './Recruiter.css'
import Interviews from "./Interviews";
import Shortlist from "./Shortlist";
import AssigCandPageOnRecruiter from './AssigCandPageOnRecruiter';
import Recommend_Regret from './Recommend_Regret';
import MyAssignedCandidate from "./MyAssignedCandidate";

const GetHeader = ({ tableData }) => {
  let keys = Object.keys(tableData[0]);
  return keys.map((key, index) => {
    return <th key={key}>{key.toUpperCase()}</th>;
  });
};
const RenderRow = (props) => {
  return props.keys.map((key, index) => {
    return <td key={props.data[key]}>{props.data[key]}</td>;
  });
};

const styles = {
  cursor:"pointer"
}

const GetRowsData = ({ tableData }) => {
  var items = tableData;
  var keys = Object.keys(tableData[0]);
  return items.map((row, index) => {
    return (
      <tr key={index}>
        <RenderRow key={index} data={row} keys={keys} />
      </tr>
    );
  });
};
const GetTableData = ({ tableData }) => (
  <Card>
    <table>
      <thead>
        <tr>
          <GetHeader tableData={tableData} />
        </tr>
      </thead>
      <tbody>
        <GetRowsData tableData={tableData} />
      </tbody>
    </table>
  </Card>
);

const GetFooter = ({ profileInfo, type, data, privateCert, isAdmin, checkingUserRole }) => {
  // console.log(data,"=====================")
  console.log(type, 'type' , data, 'data',privateCert, 'privateCert' , isAdmin, 'isAdmin' , checkingUserRole,"checkingUserRole")
  let privateCertifierData = privateCert.location.state.data
  let data3 = [
    { Name: "Abc", Age: 15, Location: "Bangalore" },
    { Name: "Def", Age: 43, Location: "Mumbai" },
    { Name: "Uff", Age: 30, Location: "Chennai" },
    { Name: "Ammse", Age: 87, Location: "Delhi" },
    { Name: "Yysse", Age: 28, Location: "Hyderabad" },
  ];
  let data2 = [
    {
     status: "No Data"
    }
  ];
  let data4 = [
    { Company: "Abc", Date: "15/8/2020", Location: "Bangalore" },
    { Company: "Def", Date: "15/8/2020", Location: "Mumbai" },
    { Company: "Uff", Date: "15/8/2020", Location: "Chennai" },
    { Company: "Ammse", Date: "15/8/2020", Location: "Delhi" },
    { Company: "Yysse", Date: "15/8/2020", Location: "Hyderabad" },
  ];
  let data5 = [
    {
      Company: "Abc",
      Date: "15/8/2020",
      Location: "Bangalore",
      Status: "Applied",
    },
    {
      Company: "Def",
      Date: "15/8/2020",
      Location: "Mumbai",
      Status: "Applied",
    },
    { Company: "Uff", Date: "15/8/2020", Location: 'Chennai,Status:"Applied"' },
    {
      Company: "Ammse",
      Date: "15/8/2020",
      Location: "Delhi",
      Status: "Pending",
    },
    {
      Company: "Yysse",
      Date: "15/8/2020",
      Location: "Hyderabad",
      Status: "Applied",
    },
  ];
  if(privateCert.match.params.id === "privatecertifierdetails"){
    switch(type){
      case 0:
        return <CertifierName title="Certifier Name" data={privateCertifierData.certifier_name}/>
      case 1:
        return <CertifierAddress title="Certifier Address" data={privateCertifierData}/>
      case 2:
        return <CompanyInfo title="Company Info" data={privateCertifierData}/>
      case 3:
        return <PrivateCertifierDetailsPage title="Company Registration" data={privateCertifierData.company_registration}/>
      case 4:
        return <PrivateCertifierDetailsPage title="Skills" data={privateCertifierData.skills}/>
      case 5:
        return <CertifiedCandidate title="Certified Candidate"/>
      case 6:
        return <AssignedCandidate title="Assigned Candidates"/>
      case 7:
        return <RecCompany title="Recruitment Company" data={privateCertifierData}/>
      case 8:
        return <CertifiedCandidate title="Invite Editor"/>
      case 9:
        return <CertifiedCandidate title="Price" data={privateCertifierData.price}/>
      case 10:
        return <CertifiedCandidate title="Rate & Review by Rec. Company"/>
      
      
      
    }
  }

if(localStorage.getItem('user_id') == data.map(val => val.user_id)){
  console.log('USERIIIIIIIIIIIIID ', data.map(val => val.user_id))
  switch (type) {
    case 0:
      return <AboutUs type={type} data={data} />;
    case 1:
      return <CompanyProfile title={"Company Profile"} data={data}/>;
    case 2:
      return <RecruiterListTemp title={"Recruiter List"}/>;
    case 3:
      return (
        <CandidateList title={"Candidate List"} />
      );
    case 4:
      return <CertifiedCandidate title={"Certified Candidate"} />;
    case 5:
      return <AppliedCandidate title={"Applied Candidate"} />;
    case 6:
      return <JobList title={"Job List"} />;
    case 7:
      return <ProfileIntro title={"Contact Us"} data={data.map(val => val.company_contactus)}/>;
    case 8:
      return <People />;
    case 9:
      return <Discussion title={"Discussion"} dataProps={data}/>;
    case 10:
      return <PrivateCertifier title={"Private Certifier"} data={data}/>;
    case 11:
      return <Post title={"Whats in your mind!"} data={data} isAdmin={isAdmin}/>;
    case 12:
      return <CompanyProduct title={"Company Product"}  />;
    case 13:
      return <Editor title={"Editor"} data={data}/>;
    case 14:
      return <Interviews title={"Interviews"} data={data}/>;
    case 15:
      return <Shortlist title={"Shortlist"} data={data}/>;
    case 16:
      return <AssigCandPageOnRecruiter title={"Assigned Candidate"} data={data}/>;
    case 17:
      return <Recommend_Regret title={"Recommendation/Regret"} data = {data}/>;
    case 18:
      return <MyAssignedCandidate title={"MyAssignedCandidate"} data = {data}/>;
  }
}else{
  switch (type) {
    case 0:
      return <AboutUs type={type} data={data.map(val => val.company_aboutus)} />;
    case 1:
      return <CompanyProfile title={"Company Profile"} data={data.map(val => val.company_profile)}/>;
    case 2:
      return <CandidateFeedback title={"Candidate Feedback"}/>;
    case 3:
      return (
        <Discussion title={"Discussion"} />
      );
    case 4:
      return <Contact title={"Contact Us "} data={data.map(val => val.company_contactus)}/>;
    case 5:
      return <People />;
    case 6:
      return <ProfileSummary title={"Profile Summary"} data={data}/>;
    case 7:
      return <CompanyProduct title={"Company Product"} />;
    case 8:
      return <Post title={"Posts"} data={data} isAdmin={isAdmin}/>;
    case 9:
      return <HiredCandidate title={"Hired Candidate"}/>;
    case 10:
      return <AppliedCandidate title={"Applied Candidate"}/>;
    case 11:
      return <JobList title={"Job List"} />;
    case 12:
      return <Join title={"Join as Recruiter"} isOpen={true} data={data}/>;
    case 13:
      return <JoinAsCandidate title={"Join as Candidate"} isOpen={true} data={data}/>;
    case 14:
      return <EditCompanyEditorRole title={"Edit Company"} data={data} checkingUserRole={checkingUserRole}/>;
    case 15:
      return <PrivateCertifier title={"Private Certifier"} data={data}/>;

  }
}
  
};

const RecruiterContent = ({ profileInfo, id, data, privateCert, isAdmin }) => {
    console.log(id,"iddddddddddddddddd")
    console.log(data,"datadataaaaaaaaaaaa")
    console.log(privateCert,"privateCertprivateCert")
    console.log(isAdmin,"isAdminisAdminisAdmin")

    const {userData} = useContext(AllDetailsContext)
    


  const [selectedButton, setselectedButton] = useState(0);
  const [isUserRole, setIsUserRole] = useState("")
  const [isRecruiter, setIsRecruiter] = useState("")
  const [isPC, setIsPC] = useState(null)

  useEffect(() => {
    console.log("selectedButton=" + selectedButton);
  }, []);

  const user__id = userData?.user?.user_id
  
  const checkForPC = async () => {
    
    const pcBody = new FormData();
    
    pcBody.append('user_id', localStorage.getItem('user_id'))
    pcBody.append('private_certifier_id', privateCert?.location?.state?.data?.id)
      
      axios({
        method:'post',
        url:`${process.env.REACT_APP_API_URL}/company/invitation/is_private_certifier`,
        data:pcBody,
        headers: { "Content-Type": "multipart/form-data" }
      })
    .then(res => {
      setIsPC(res?.data)
      if(res?.data?.status === true){
        toast.success("This is your Private Certifier")
      }else{
        toast.error("This is not your Private Certifier")
      }
    })
      
  }
      console.log(isPC,"checkForPCcheckForPCcheckForPC")

  useEffect(() => {
    if(id == "privatecertifierdetails"){
      checkForPC()
    }
  },[])

  useEffect(() => {
    console.log(id, 'company_idcompany_idcompany_idcompany_idcompany_idcompany_id')
    const checkingForEditorRole =  async () => {
      const requestUserRole = await axios.post(`${config.API_URL()}company/checkifusertypeofcompany?default_user=${localStorage.getItem('default_user')}&company_id=${id}&id=${user__id}`)
      // console.log(requestUserRole,"requestUserRole")
        if(requestUserRole?.data?.status_code === 200){
          setIsUserRole(requestUserRole?.data?.result?.status)
          setIsRecruiter(requestUserRole?.data?.result?.data?.role_id)
        }
        if(requestUserRole?.data?.status_code === 400){
          setIsUserRole(requestUserRole?.data?.result?.status)
        }

      }
    checkingForEditorRole()
  },[])



    let privateCertifier = [
      "Certifier Name",
      "Address",
      "Company Info",
      "Company Reg.",
      "Skills",
      "Certified Candidate",
      "Assigned Candidates",
      "Recruitment Company",
      "Invite Editor",
      "Price",
      "Rate & Review by Rec Company",
     

      
]

  let buttonsTitleArrayOwn = [
    "About Us",
    "Company Profile",
    "Recruiters List",
    "Candidate List",
    "Certified Candidate",
    "Applied Candidate",
    "Jobs List",
    "Contact Us",
    "Follow",
    "Discussions",
    "Private Certifier",
    "Posts",
    "Company Products",
    "Editor",
    "Interviews",
    'Shortlist',
    'Assigned Candidates',
    'Recommend/Regret',
    'My Assigned Candidate'
    
  ];
  let buttonsTitleArrayOther = [
    "About Us",
    "Company Profile",
    "Candidate Feedback",
    "Discussions",
    "Contact Us",
    "Follow",
    "Profile Summary",
    "Company Products",
    "Posts",
    "Hired Candidate",
    "Applied Candidate",
    "Jobs List",
    "Join",
    "Join as Candidate",
    "Edit Company",
    "Private Certifier"

    
  ];

  
  const buttonsTitleArray =localStorage.getItem('user_id') == data?.data.user_id ? buttonsTitleArrayOwn : buttonsTitleArrayOther 

  console.log(localStorage.getItem('user_id'), 'datauser id', data?.data.user_id)
if(buttonsTitleArray.length === 14){
  // console.log("hellooooooooooooooooooooooooooo")
}else{
  // console.log("byeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee")

}
  return (
    <Fragment>
    {privateCert.match.params.id === "privatecertifierdetails" ? 
    ( 
      <>
        <div className="mn-tp20 mn-bt20 btns-cont">
          <span
              className={
                ("large", selectedButton == 0 ? "btn-select" : "btn-unselect")
              }
              style={styles}
              onClick={() => setselectedButton(0)}
            >
              {privateCertifier[0]}
            </span>
            <span
              className={selectedButton == 1 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(1)}
            >
              {privateCertifier[1]}
            </span>
            <span
              className={selectedButton == 2 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(2)}
            >
              {privateCertifier[2]}
            </span>
            <span
              className={selectedButton == 3 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(3)}
            >
              {" "}
              {privateCertifier[3]}{" "}
            </span>
            <span
              className={selectedButton == 4 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(4)}
            >
              {" "}
              {privateCertifier[4]}{" "}
            </span>
            <span
              className={selectedButton == 5 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(5)}
            >
              {" "}
              {privateCertifier[5]}{" "}
            </span>
            <span
              className={selectedButton == 6 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(6)}
            >
              {" "}
              {privateCertifier[6]}{" "}
            </span>

            {isPC?.status && (
            <span
              className={selectedButton == 7 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(7)}
            >
              {" "}
              {privateCertifier[7]}{" "}
            </span>
              )}
            
            <span
              className={selectedButton == 8 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(8)}
            >
              {" "}
              {privateCertifier[8]}{" "}
            </span>
            <span
              className={selectedButton == 9 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(9)}
            >
              {" "}
              {privateCertifier[9]}{" "}
            </span>
            
            <span
              className={selectedButton == 10 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(10)}
            >
              {" "}
              {privateCertifier[10]}{" "}
            </span>
            
             
        </div>
            <GetFooter
              type={selectedButton}
              profileInfo={profileInfo}
              data={[data?.data]}
              privateCert={privateCert}
              isAdmin={isAdmin}
            />
          </>
            )
    :
  
  
      id === "recruiter" ? (
        <UserRole />
      ) : buttonsTitleArray.length === 14 ? (
        <>
          <div className="mn-tp20 mn-bt20 btns-cont">
            <span
              className={
                ("large", selectedButton == 0 ? "btn-select" : "btn-unselect")
              }
                style={styles}
              onClick={() => setselectedButton(0)}
            >
              {buttonsTitleArray[0]}
            </span>
            <span
              className={selectedButton == 1 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(1)}
            >
              {buttonsTitleArray[1]}
            </span>
            <span
              className={selectedButton == 2 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(2)}
            >
              {buttonsTitleArray[2]}
            </span>
            <span
              className={selectedButton == 3 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(3)}
            >
              {" "}
              {buttonsTitleArray[3]}{" "}
            </span>
            <span
              className={selectedButton == 4 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(4)}
            >
              {" "}
              {buttonsTitleArray[4]}{" "}
            </span>
            <span
              className={selectedButton == 5 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(5)}
            >
              {" "}
              {buttonsTitleArray[5]}{" "}
            </span>
            <span
              className={selectedButton == 14 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(14)}
            >
              {" tt"}
              {buttonsTitleArray[14]}{" "}
            </span>
            <span
              className={selectedButton == 6 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(6)}
            >
              {" "}
              {buttonsTitleArray[6]}{" "}
            </span>
            <span
              className={selectedButton == 7 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(7)}
            >
              {" "}
              {buttonsTitleArray[7]}{" "}
            </span>
            <span
              className={selectedButton == 8 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(8)}
            >
              {" "}
              {buttonsTitleArray[8]}{" "}
            </span>
            <span
              className={selectedButton == 9 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(9)}
            >
              {" "}
              {buttonsTitleArray[9]}{" "}
            </span>
            
            <span
              className={selectedButton == 10 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(10)}
            >
              {" "}
              {buttonsTitleArray[10]}{" "}
            </span>
            <span
              className={selectedButton == 11 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(11)}
            >
              {" "}
              {buttonsTitleArray[11]}{" "}
            </span>
            <span
              className={selectedButton == 12 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(12)}
            >
              {" "}
              {buttonsTitleArray[12]}{" "}
            </span>
            <span
              className={selectedButton == 13 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(13)}
            >
              {" "}
              {buttonsTitleArray[13]}{" "}
            </span>

            
          </div>

          <GetFooter
            type={selectedButton}
            profileInfo={profileInfo}
            data={[data?.data]}
            privateCert={privateCert}
            checkingUserRole={isUserRole}
          />
        </>
      )
      : 
    (
        <>
          <div className="mn-tp20 mn-bt20 btns-cont">
            {
              console.log(buttonsTitleArray,'buttontitlearray')
            }
            <span
              className={
                ("large", selectedButton == 0 ? "btn-select" : "btn-unselect")
              }
                style={styles}
              onClick={() => setselectedButton(0)}
            >
              {buttonsTitleArray[0]}
            </span>
            <span
              className={selectedButton == 1 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(1)}
            >
              {buttonsTitleArray[1]}
            </span>
            <span
              className={selectedButton == 2 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(2)}
            >
              {buttonsTitleArray[2]}
            </span>
            <span
              className={selectedButton == 3 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(3)}
            >
              {" "}
              {buttonsTitleArray[3]}{" "}
            </span>
            <span
              className={selectedButton == 4 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(4)}
            >
              {" "}
              {buttonsTitleArray[4]}{" "}
            </span>
            <span
              className={selectedButton == 5 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(5)}
            >
              {" "}
              {buttonsTitleArray[5]}{" "}
            </span>
            <span
              className={selectedButton == 6 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(6)}
            >
              
              {" "}
              {buttonsTitleArray[6]}{" "}
            </span>
            <span
              className={selectedButton == 14 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(14)}
            >
              {" "}
              {buttonsTitleArray[14]}{" "}
            </span>
            <span
              className={selectedButton == 15 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(15)}
            >
              {" "}
              {buttonsTitleArray[15]}{" "}
            </span>
            { buttonsTitleArray.length == 19 &&
              <span
              className={selectedButton == 17 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(17)}
            >
              {" "}
              {buttonsTitleArray[17]}{" "}
            </span>
            }
            <span
              className={selectedButton == 7 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(7)}
            >
              {" "}
              {buttonsTitleArray[7]}{" "}
            </span>
            <span
              className={selectedButton == 8 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(8)}
            >
              {" "}
              {buttonsTitleArray[8]}{" "}
            </span>
            <span
              className={selectedButton == 9 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(9)}
            >
              {" "}
              {buttonsTitleArray[9]}{" "}
            </span>
            
            <span
              className={selectedButton == 10 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(10)}
            >
              {" "}
              {buttonsTitleArray[10]}{" "}
            </span>
            <span
              className={selectedButton == 11 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(11)}
            >
              {" "}
              {buttonsTitleArray[11]}{" "}
            </span>
            { buttonsTitleArray.length == 19 &&
              <span
              className={selectedButton == 16 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(16)}
            >
              {" "}
              {buttonsTitleArray[16]}{" "}
            </span>
            }
            { buttonsTitleArray.length == 19 &&
              <span
              className={selectedButton == 18 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(18)}
            >
              {" "}
              {buttonsTitleArray[18]}{" "}
            </span>
            }
            {!isUserRole && isRecruiter !== 11 && (
              <>
              <span
              className={selectedButton == 12 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(12)}
            >
              {" "}
              {buttonsTitleArray[12]}{" "}
            </span>
            <span
              className={selectedButton == 13 ? "btn-select" : "btn-unselect"}
                style={styles}
              onClick={() => setselectedButton(13)}
            >
              {" "}
              {buttonsTitleArray[13]}{" "}
            </span>
            
            </>
              )}
            
            

            {/* {isUserRole && isRecruiter !== 11 && (
              <span
                className={selectedButton == 14 ? "btn-select" : "btn-unselect"}
                style={styles}
                onClick={() => setselectedButton(14)}
              >
              {" "}
                {buttonsTitleArray[14]}{" "}
              </span>
            )} */}
            {isRecruiter === 11 && (
              <span
                className={selectedButton == 15 ? "btn-select" : "btn-unselect"}
                style={styles}
                onClick={() => setselectedButton(15)}
              >
              {" "}
                {buttonsTitleArray[15]}{" "}
              </span>
            )}
          </div>

          <GetFooter
            type={selectedButton}
            profileInfo={profileInfo}
            data={[data?.data]}
            privateCert={privateCert}
            checkingUserRole={isUserRole}
          />
        </>
      )
    
  }
    </Fragment>
  );
};

export default RecruiterContent;
