import React,{useEffect, useState} from 'react'
import { Card, CardBody, CardFooter, Row, Col,Alert, Container} from "reactstrap";
import FalconCardHeader from '../common/FalconCardHeader';
import {useParams} from 'react-router-dom';
import axios from 'axios';
import Loader from '../common/Loader'
import config from '../../helpers/config';



const RecruiterListTemp = ({title}) => {
  const [recruiters, setRecruiters] = useState(null)
  const [loading, setLoading] = useState(true)

  const {id} = useParams();

  const recruiterList = async () => {
    
    const getAllRecruiters = await axios.post(`${config.API_URL()}company/recruiters_list?company_value=${id}`)
    
    if(getAllRecruiters?.data?.status === true){
      // console.log(getAllRecruiters,"getAllRecruiters")
      setRecruiters(getAllRecruiters?.data?.data)
      setLoading(false)

    }
  }
      // console.log(recruiters,"===================")

  useEffect(() => {
    recruiterList()
  },[])
  // console.log(id)
	return(
		<Card className="mb-3">
      <FalconCardHeader title={title} />

      <CardBody className="text-justify">
      {loading ? <Loader/> : (
        <>
        { recruiters?.length > 0 ? (
              <Container>
            <Row>
              <Col xs="2"><b>S. No.</b></Col>
              <Col xs="4"><b>Name</b></Col>
              <Col xs="6"><b>Email</b></Col>
            </Row>
            {recruiters?.map((recruiter, index) => (
              <Row key={index}>
                <Col xs="2">{index+1}.</Col>
                <Col xs="4">{recruiter.name ? recruiter.name : recruiter.recruiter_profile.user_f_name } {recruiter.recruiter_profile.user_l_name ? recruiter.recruiter_profile.user_l_name : null}</Col>
                <Col xs="6">{recruiter.email ? recruiter.email : recruiter.recruiter_profile.user_email}</Col>
            </Row>
            ))}
          </Container>
          ): (
             <Row>
                  <Col>
                    <Alert color="danger">No candidate available!</Alert>
                  </Col>
                </Row>
          )}
          
          </>
        )}
        
      </CardBody>

      <CardFooter className="bg-light p-0 border-top">
        
      </CardFooter>
    </Card>
		)
}
export default RecruiterListTemp