import React, { useState, useContext,useEffect } from "react";
import DatePicker from "react-datepicker";
import axios from "axios";
import PropTypes from "prop-types";
import { toast } from 'react-toastify';

import "react-datepicker/dist/react-datepicker.css";

import {
  Button,
  Col,
  Media,
  Modal,
  ModalBody,
  ModalFooter,
  ModalHeader,
  Row,
  Input,
  Form
} from "reactstrap";
import { Link } from "react-router-dom";

import classNames from "classnames";

import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";

const ScheduleMeeting = ({ modal, setModal, type = "ADD",appID,getAppliedCandidate, getCompanyID ,setIsLoading}) => {
  const [startDate, setStartDate] = useState(new Date());
  const [link, setLink] = useState('');

  const [description, setDescription] = useState('');

  const [formData, setFormData] = useState({
    link: "",
    datetime:startDate,
    description: "",
   
  });
  const onChangeHandler = (e) => {
    setFormData({
        ...formData,
      [e.target.name]: e.target.value,
    });
    console.log(formData);
  };
  const handleSubmit = e => {
    e.preventDefault();
    setIsLoading(true)
    // setFormData({
    //     applicationId:appID
    // })
    
    formData.appID = appID;
    formData.CompanyID = getCompanyID;
    console.log('formdata', formData)
    axios({
        method:'post',
        url:`${process.env.REACT_APP_API_URL}/jobs/schedule_interview`,
        data:formData,
     
    })
    .then(res => {
        console.log(res)
        setIsLoading(false)
        if(res?.data?.status === 200){
            toast.success("Interview Scheduled!")
            setModal(false)
            getAppliedCandidate()
            // multiRef.current.resetSelectedValues()
            // setIsChange(true)
            // setSkill_id('')
            // setSubSkill_id([])
        }else{
            toast.success("Failed!")
        }
    })
    .catch(err => console.log(err))

    
}
useEffect(() => {
    setFormData({
        ...formData,
        applicationId:appID
    })
  }, []);

  return (
    <Modal isOpen={modal} toggle={() => setModal(!modal)} size="lg">
      <ModalHeader toggle={() => setModal(!modal)} className="border-200">
        <Media className="align-items-center">
          <div
            className={classNames("icon-item shadow-none", {
              "bg-soft-danger": type === "REMOVE",
              "bg-soft-success": type === "ADD",
            })}
          >
            
          </div>

          <Media body className="ml-2">
            Schedule a Meeting
          </Media>
        </Media>
      </ModalHeader>
      <ModalBody className="mb-1">
      <Form onSubmit={handleSubmit}>
        <Row noGutters className="align-items-center">
          <label>Select Datetime For Interview</label>
          <DatePicker
            className="form-control-sm"
            selected={startDate}
            onChange={(date) => setStartDate(date)}
            showTimeSelect
            timeFormat="HH:mm"
            timeIntervals={15}
            timeCaption="time"
            dateFormat="Y-M-d h:mm a"
          />
        </Row>
        <Row noGutters className="align-items-center">
          <label>Interview Link</label>
          <Input type="text" className="form-control-sm" name="link"  value={formData.link}
                onChange={(e) => onChangeHandler(e)} required/>

          {/* <Col sm="auto" className="pl-sm-3 d-none d-sm-block" /> */}
        </Row>
        <Row noGutters className="align-items-center">
          <label>Description</label>
          <Input type="textarea" className="form-control-sm" name="description"  value={formData.description}
                onChange={(e) => onChangeHandler(e)} required/>

          {/* <Col sm="auto" className="pl-sm-3 d-none d-sm-block" /> */}
        </Row>
        <br/>
        <Row style={{
          display: "flex",
          justifyContent: "center"
        }}>
        {/* <Input type="hidden" value={appID}></Input> */}
            {/* <Input type="submit" className="btn btn-primary"></Input> */}
          <button type="submit"  className="btn btn-primary" >
          Submit  
          </button>
        </Row>
        </Form>
      </ModalBody>

      <ModalFooter className="border-200">
        <Button
          color="secondary"
          size="sm"
          to="/e-commerce/checkout"
          onClick={() => setModal(!modal)}
        >
          Close
        </Button>
      </ModalFooter>
    </Modal>
  );
};

export default ScheduleMeeting;
